/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.function.BooleanSupplier;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.internal.recordstorage.IntegrityValidator;
import org.neo4j.internal.recordstorage.Loaders;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.PropertyCreator;
import org.neo4j.internal.recordstorage.PropertyDeleter;
import org.neo4j.internal.recordstorage.PropertyTraverser;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordChangeSet;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.internal.recordstorage.RelationshipModifier;
import org.neo4j.internal.recordstorage.TransactionRecordState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.cursor.StoreCursors;

class RecordStorageCommandCreationContext
implements CommandCreationContext {
    private final NeoStores neoStores;
    private final Config config;
    private final MemoryTracker memoryTracker;
    private final PropertyStore propertyStore;
    private final TokenNameLookup tokenNameLookup;
    private final LogProvider logProvider;
    private final int denseNodeThreshold;
    private final BooleanSupplier relaxedLockingForDenseNodes;
    private PropertyCreator propertyCreator;
    private PropertyDeleter propertyDeleter;
    private RelationshipGroupGetter relationshipGroupGetter;
    private Loaders loaders;
    private CursorContext cursorContext;
    private StoreCursors storeCursors;

    RecordStorageCommandCreationContext(NeoStores neoStores, TokenNameLookup tokenNameLookup, LogProvider logProvider, int denseNodeThreshold, BooleanSupplier relaxedLockingForDenseNodes, Config config, MemoryTracker memoryTracker) {
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
        this.denseNodeThreshold = denseNodeThreshold;
        this.relaxedLockingForDenseNodes = relaxedLockingForDenseNodes;
        this.neoStores = neoStores;
        this.config = config;
        this.memoryTracker = memoryTracker;
        this.propertyStore = neoStores.getPropertyStore();
    }

    public void initialize(CursorContext cursorContext, StoreCursors storeCursors) {
        this.cursorContext = cursorContext;
        this.loaders = new Loaders(this.neoStores, storeCursors);
        this.storeCursors = storeCursors;
        this.relationshipGroupGetter = new RelationshipGroupGetter(this.neoStores.getRelationshipGroupStore(), cursorContext);
        PropertyTraverser propertyTraverser = new PropertyTraverser();
        this.propertyDeleter = new PropertyDeleter(propertyTraverser, this.neoStores, this.tokenNameLookup, this.logProvider, this.config, cursorContext, this.memoryTracker, storeCursors);
        this.propertyCreator = new PropertyCreator(new StandardDynamicRecordAllocator(this.propertyStore.getStringStore(), this.propertyStore.getStringStore().getRecordDataSize()), new StandardDynamicRecordAllocator(this.propertyStore.getArrayStore(), this.propertyStore.getArrayStore().getRecordDataSize()), this.propertyStore, propertyTraverser, this.propertyStore.allowStorePointsAndTemporal(), cursorContext, this.memoryTracker);
    }

    private long nextId(StoreType storeType) {
        return this.neoStores.getRecordStore(storeType).nextId(this.cursorContext);
    }

    public long reserveNode() {
        return this.nextId(StoreType.NODE);
    }

    public long reserveRelationship(long sourceNode) {
        return this.nextId(StoreType.RELATIONSHIP);
    }

    public long reserveSchema() {
        return this.nextId(StoreType.SCHEMA);
    }

    public int reserveRelationshipTypeTokenId() {
        return Math.toIntExact(this.neoStores.getRelationshipTypeTokenStore().nextId(this.cursorContext));
    }

    public int reservePropertyKeyTokenId() {
        return Math.toIntExact(this.neoStores.getPropertyKeyTokenStore().nextId(this.cursorContext));
    }

    public int reserveLabelTokenId() {
        return Math.toIntExact(this.neoStores.getLabelTokenStore().nextId(this.cursorContext));
    }

    public void close() {
    }

    TransactionRecordState createTransactionRecordState(IntegrityValidator integrityValidator, long lastTransactionIdWhenStarted, ResourceLocker locks, LockTracer lockTracer, LogCommandSerialization commandSerialization, RecordAccess.LoadMonitor monitor) {
        RecordChangeSet recordChangeSet = new RecordChangeSet(this.loaders, this.memoryTracker, monitor, this.storeCursors);
        RelationshipModifier relationshipModifier = new RelationshipModifier(this.relationshipGroupGetter, this.propertyDeleter, this.denseNodeThreshold, this.relaxedLockingForDenseNodes.getAsBoolean(), this.cursorContext, this.memoryTracker);
        return new TransactionRecordState(this.neoStores, integrityValidator, recordChangeSet, lastTransactionIdWhenStarted, locks, lockTracer, relationshipModifier, this.propertyCreator, this.propertyDeleter, this.cursorContext, this.storeCursors, this.memoryTracker, commandSerialization);
    }
}

