/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.Serializable;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.recordstorage.SchemaRecordChangeTranslator;
import org.neo4j.internal.recordstorage.TransactionRecordState;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.values.storable.Value;

public abstract class PropertyBasedSchemaRecordChangeTranslator
implements SchemaRecordChangeTranslator {
    @Override
    public void createSchemaRule(TransactionRecordState recordState, SchemaRule rule) throws KernelException {
        IntObjectMap<Value> properties = this.asMap(rule);
        long ruleId = rule.getId();
        recordState.schemaRuleCreate(ruleId, rule instanceof ConstraintDescriptor, rule);
        properties.forEachKeyValue((IntObjectProcedure & Serializable)(propertyKeyId, value) -> recordState.schemaRuleSetProperty(ruleId, propertyKeyId, (Value)value, rule));
    }

    @Override
    public void dropSchemaRule(TransactionRecordState recordState, SchemaRule rule) {
        recordState.schemaRuleDelete(rule.getId(), rule);
    }

    @Override
    public void setConstraintIndexOwner(TransactionRecordState recordState, IndexDescriptor indexRule, long constraintId) throws KernelException {
        this.setConstraintIndexOwnerProperty(constraintId, (IntObjectProcedure<Value>)(IntObjectProcedure & Serializable)(propertyKeyId, value) -> recordState.schemaRuleSetIndexOwner(indexRule, constraintId, propertyKeyId, (Value)value));
    }

    protected abstract IntObjectMap<Value> asMap(SchemaRule var1) throws KernelException;

    protected abstract void setConstraintIndexOwnerProperty(long var1, IntObjectProcedure<Value> var3) throws KernelException;
}

