/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.IndexActivator;
import org.neo4j.internal.recordstorage.IndexUpdates;
import org.neo4j.internal.recordstorage.OnlineIndexUpdates;
import org.neo4j.internal.recordstorage.PropertyPhysicalToLogicalConverter;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.lock.LockGroup;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.storageengine.util.IndexUpdatesWorkSync;
import org.neo4j.util.VisibleForTesting;

public class BatchContextImpl
implements BatchContext {
    private final IndexUpdatesWorkSync indexUpdatesSync;
    private final CursorContext cursorContext;
    private final IdUpdateListener idUpdateListener;
    private final IndexActivator indexActivator;
    private final LockGroup lockGroup;
    private final IndexUpdates indexUpdates;

    public BatchContextImpl(IndexUpdateListener indexUpdateListener, IndexUpdatesWorkSync indexUpdatesSync, NodeStore nodeStore, PropertyStore propertyStore, StorageEngine recordStorageEngine, SchemaCache schemaCache, CursorContext cursorContext, MemoryTracker memoryTracker, IdUpdateListener idUpdateListener, StoreCursors storeCursors) {
        this.indexActivator = new IndexActivator(indexUpdateListener);
        this.indexUpdatesSync = indexUpdatesSync;
        this.cursorContext = cursorContext;
        this.idUpdateListener = idUpdateListener;
        this.lockGroup = new LockGroup();
        this.indexUpdates = new OnlineIndexUpdates(nodeStore, schemaCache, new PropertyPhysicalToLogicalConverter(propertyStore, storeCursors), recordStorageEngine.newReader(), cursorContext, memoryTracker, storeCursors);
    }

    @Override
    public LockGroup getLockGroup() {
        return this.lockGroup;
    }

    @Override
    public void close() throws Exception {
        this.applyPendingIndexUpdates();
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.indexUpdates, this.idUpdateListener, this.lockGroup, this.indexActivator});
    }

    @Override
    public IndexActivator getIndexActivator() {
        return this.indexActivator;
    }

    @Override
    public void applyPendingIndexUpdates() throws IOException {
        if (this.hasUpdates()) {
            IndexUpdatesWorkSync.Batch indexUpdatesBatch = this.indexUpdatesSync.newBatch();
            indexUpdatesBatch.add((Iterable)this.indexUpdates);
            try {
                indexUpdatesBatch.apply(this.cursorContext);
            }
            catch (ExecutionException e) {
                throw new IOException("Failed to flush index updates", e);
            }
            finally {
                this.indexUpdates.reset();
            }
        }
    }

    @VisibleForTesting
    boolean hasUpdates() {
        return this.indexUpdates.hasUpdates();
    }

    @Override
    public IndexUpdates indexUpdates() {
        return this.indexUpdates;
    }

    @Override
    public IdUpdateListener getIdUpdateListener() {
        return this.idUpdateListener;
    }
}

