/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.store.io;

import org.neo4j.internal.batchimport.IoThroughputStat;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Keys;
import org.neo4j.internal.batchimport.stats.Stat;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.io.IoTracer;

public class IoMonitor
implements StatsProvider {
    private volatile long startTime;
    private volatile long endTime;
    private final IoTracer tracer;
    private long resetPoint;

    public IoMonitor(IoTracer tracer) {
        this.tracer = tracer;
        this.reset();
    }

    public void reset() {
        this.startTime = System.nanoTime();
        this.endTime = 0L;
        this.resetPoint = this.tracer.countBytesWritten();
    }

    public void stop() {
        this.endTime = System.nanoTime();
    }

    private long totalBytesWritten() {
        return this.tracer.countBytesWritten() - this.resetPoint;
    }

    public Stat stat(Key key) {
        if (key == Keys.io_throughput) {
            return new IoThroughputStat(this.startTime, this.endTime, this.totalBytesWritten());
        }
        return null;
    }

    public Key[] keys() {
        return new Key[]{Keys.io_throughput};
    }
}

