/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.common.EntityType;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IndexImporter;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.IndexWriterStep;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class RelationshipTypeIndexWriterStep
extends IndexWriterStep<RelationshipRecord[]> {
    private static final String RELATIONSHIP_INDEX_WRITE_STEP_TAG = "relationshipIndexWriteStep";
    private final CursorContext cursorContext;
    private final IndexImporter importer;

    public RelationshipTypeIndexWriterStep(StageControl control, Configuration config, BatchingNeoStores neoStores, IndexImporterFactory indexImporterFactory, MemoryTracker memoryTracker, PageCacheTracer pageCacheTracer, Function<CursorContext, StoreCursors> storeCursorsCreator) {
        super(control, "RELATIONSHIP TYPE INDEX", config, 1, pageCacheTracer);
        this.cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(RELATIONSHIP_INDEX_WRITE_STEP_TAG));
        this.importer = this.indexImporter(config.indexConfig(), indexImporterFactory, neoStores, EntityType.RELATIONSHIP, memoryTracker, this.cursorContext, storeCursorsCreator);
    }

    protected void process(RelationshipRecord[] batch, BatchSender sender, CursorContext cursorTracer) throws Throwable {
        for (RelationshipRecord relationship : batch) {
            if (!relationship.inUse()) continue;
            this.importer.add(relationship.getId(), new long[]{relationship.getType()});
        }
        sender.send((Object)batch);
    }

    public void close() throws Exception {
        super.close();
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.importer, this.cursorContext});
    }
}

