/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IndexConfig;
import org.neo4j.internal.batchimport.IndexImporter;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.KernelVersionRepository;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;

public abstract class IndexWriterStep<T>
extends ProcessorStep<T> {
    public IndexWriterStep(StageControl control, String name, Configuration config, int maxProcessors, PageCacheTracer pageCacheTracer) {
        super(control, name, config, maxProcessors, pageCacheTracer, new StatsProvider[0]);
    }

    protected IndexImporter indexImporter(IndexConfig indexConfig, IndexImporterFactory importerFactory, BatchingNeoStores neoStores, EntityType entityType, MemoryTracker memoryTracker, CursorContext cursorContext, Function<CursorContext, StoreCursors> storeCursorsFactory) {
        SchemaStore schemaStore = neoStores.getNeoStores().getSchemaStore();
        MetaDataStore metaDataStore = neoStores.getNeoStores().getMetaDataStore();
        TokenHolders tokenHolders = neoStores.getTokenHolders();
        SchemaRuleAccess schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess(schemaStore, tokenHolders, (KernelVersionRepository)metaDataStore);
        try (StoreCursors storeCursors = storeCursorsFactory.apply(cursorContext);){
            IndexDescriptor index = IndexWriterStep.findIndex(entityType, schemaRuleAccess, storeCursors).orElseGet(() -> IndexWriterStep.createIndex(entityType, indexConfig, schemaRuleAccess, schemaStore, memoryTracker, cursorContext, storeCursors));
            IndexImporter indexImporter = importerFactory.getImporter(index, neoStores.databaseLayout(), neoStores.fileSystem(), neoStores.getPageCache(), cursorContext);
            return indexImporter;
        }
    }

    private static IndexDescriptor createIndex(EntityType entityType, IndexConfig config, SchemaRuleAccess schemaRule, SchemaStore schemaStore, MemoryTracker memoryTracker, CursorContext cursorContext, StoreCursors storeCursors) {
        try {
            IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("token-lookup", "1.0");
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)entityType)).withIndexType(IndexType.LOOKUP).withIndexProvider(providerDescriptor);
            String name = (String)StringUtils.defaultIfEmpty((CharSequence)config.indexName(entityType), (CharSequence)SchemaNameUtil.generateName((SchemaDescriptorSupplier)prototype, (String[])new String[0], (String[])new String[0]));
            IndexDescriptor descriptor = prototype.withName(name).materialise(schemaStore.nextId(cursorContext));
            schemaRule.writeSchemaRule((SchemaRule)descriptor, cursorContext, memoryTracker, storeCursors);
            return descriptor;
        }
        catch (KernelException e) {
            throw new RuntimeException("Error preparing indexes", e);
        }
    }

    private static Optional<IndexDescriptor> findIndex(EntityType entityType, SchemaRuleAccess schemaRule, StoreCursors storeCursors) {
        Iterator<IndexDescriptor> descriptors = schemaRule.indexesGetAll(storeCursors);
        return Iterators.stream(descriptors).filter(index -> index.schema().entityType() == entityType && index.isTokenIndex()).findFirst();
    }
}

