/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.CountGroupsStep;
import org.neo4j.internal.batchimport.RecordIdIterators;
import org.neo4j.internal.batchimport.RelationshipGroupCache;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class CountGroupsStage
extends Stage {
    public static final String NAME = "Count groups";

    public CountGroupsStage(Configuration config, RecordStore<RelationshipGroupRecord> store, RelationshipGroupCache groupCache, PageCacheTracer pageCacheTracer, StatsProvider ... additionalStatsProviders) {
        super(NAME, null, config, 2);
        this.add((Step)new BatchFeedStep(this.control(), config, RecordIdIterators.allIn(store, config), store.getRecordSize()));
        this.add((Step)new ReadRecordsStep<RelationshipGroupRecord>(this.control(), config, false, store, pageCacheTracer));
        this.add((Step)new CountGroupsStep(this.control(), config, groupCache, pageCacheTracer, additionalStatsProviders));
    }
}

