/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.internal.id.indexed.IdRangeKey;

class IdRange {
    static final int BITSET_COUNT = 3;
    static final int BITSET_COMMIT = 0;
    static final int BITSET_REUSE = 1;
    static final int BITSET_RESERVED = 2;
    static final int BITSET_SIZE = 64;
    private long generation;
    private boolean addition;
    private final long[][] bitSets;
    private final int numOfLongs;

    IdRange(int numOfLongs) {
        this.bitSets = new long[3][numOfLongs];
        this.numOfLongs = numOfLongs;
    }

    IdState getState(int n) {
        boolean commitBit;
        int longIndex = n / 64;
        int bitIndex = n % 64;
        boolean bl = commitBit = (this.bitSets[0][longIndex] & IdRange.bitMask(bitIndex)) != 0L;
        if (commitBit) {
            boolean reuseBit = (this.bitSets[1][longIndex] & IdRange.bitMask(bitIndex)) != 0L;
            boolean reservedBit = (this.bitSets[2][longIndex] & IdRange.bitMask(bitIndex)) != 0L;
            return reuseBit && !reservedBit ? IdState.FREE : IdState.DELETED;
        }
        return IdState.USED;
    }

    private static long bitMask(int bitIndex) {
        return 1L << bitIndex;
    }

    void setBits(int type, int n, int numIds) {
        for (int i = 0; i < numIds; ++i) {
            int bit = n + i;
            int longIndex = bit / 64;
            int bitIndex = bit % 64;
            long[] lArray = this.bitSets[type];
            int n2 = longIndex;
            lArray[n2] = lArray[n2] | IdRange.bitMask(bitIndex);
        }
    }

    void setBitsForAllTypes(int n, int numIds) {
        for (int i = 0; i < numIds; ++i) {
            int bit = n + i;
            int longIndex = bit / 64;
            int bitIndex = bit % 64;
            long mask = IdRange.bitMask(bitIndex);
            long[] lArray = this.bitSets[0];
            int n2 = longIndex;
            lArray[n2] = lArray[n2] | mask;
            long[] lArray2 = this.bitSets[1];
            int n3 = longIndex;
            lArray2[n3] = lArray2[n3] | mask;
            long[] lArray3 = this.bitSets[2];
            int n4 = longIndex;
            lArray3[n4] = lArray3[n4] | mask;
        }
    }

    void clear(long generation, boolean addition) {
        this.generation = generation;
        this.addition = addition;
        Arrays.fill(this.bitSets[0], 0L);
        Arrays.fill(this.bitSets[1], 0L);
        Arrays.fill(this.bitSets[2], 0L);
    }

    long getGeneration() {
        return this.generation;
    }

    void setGeneration(long generation) {
        this.generation = generation;
    }

    long[][] getBitSets() {
        return this.bitSets;
    }

    void normalize() {
        for (int i = 0; i < this.numOfLongs; ++i) {
            this.bitSets[1][i] = this.bitSets[0][i];
            this.bitSets[2][i] = 0L;
        }
    }

    boolean mergeFrom(IdRangeKey key, IdRange other, boolean recoveryMode) {
        if (!recoveryMode) {
            this.verifyMerge(key, other);
        }
        for (int bitSetIndex = 0; bitSetIndex < 3; ++bitSetIndex) {
            IdRange.mergeBitSet(this.bitSets[bitSetIndex], other.bitSets[bitSetIndex], other.addition);
        }
        return true;
    }

    private static void mergeBitSet(long[] into, long[] mergeFrom, boolean addition) {
        for (int i = 0; i < into.length; ++i) {
            into[i] = addition ? into[i] | mergeFrom[i] : into[i] & (mergeFrom[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    void visitFreeIds(long baseId, long generation, FreeIdVisitor visitor) {
        boolean differentGeneration = generation != this.generation;
        int firstFreeI = -1;
        int prevFreeI = -1;
        int baseI = 0;
        int i = 0;
        while (i < this.numOfLongs) {
            long bit;
            long reuseBits = this.bitSets[1][i];
            long reservedBits = this.bitSets[2][i];
            for (long commitBits = this.bitSets[0][i]; commitBits != 0L; commitBits ^= bit) {
                bit = Long.lowestOneBit(commitBits);
                if (!differentGeneration && ((reuseBits & bit) == 0L || (reservedBits & bit) != 0L)) continue;
                int localBitIndex = Long.numberOfTrailingZeros(bit);
                int bitIndex = baseI + localBitIndex;
                if (firstFreeI == -1) {
                    firstFreeI = prevFreeI = bitIndex;
                    continue;
                }
                if (prevFreeI == bitIndex - 1) {
                    prevFreeI = bitIndex;
                    continue;
                }
                long id = baseId + (long)firstFreeI;
                int numberOfIds = prevFreeI - firstFreeI + 1;
                if (!visitor.visitFreeId(id, numberOfIds)) {
                    return;
                }
                firstFreeI = prevFreeI = bitIndex;
            }
            ++i;
            baseI += 64;
        }
        if (firstFreeI != -1) {
            long id = baseId + (long)firstFreeI;
            int numberOfIds = prevFreeI - firstFreeI + 1;
            visitor.visitFreeId(id, numberOfIds);
        }
    }

    private void verifyMerge(IdRangeKey key, IdRange other) {
        boolean addition = other.addition;
        long[] intoBitSet = this.bitSets[0];
        long[] fromBitSet = other.bitSets[0];
        for (int i = 0; i < intoBitSet.length; ++i) {
            long into = intoBitSet[i];
            long from = fromBitSet[i];
            if (!addition || (into & from) == 0L) continue;
            throw new IllegalStateException(String.format("Illegal addition ID state for range: %s transition longIdx: %d%ninto: %s%nfrom: %s", key.getIdRangeIdx(), i, IdRange.toPaddedBinaryString(into), IdRange.toPaddedBinaryString(from)));
        }
    }

    private static String toPaddedBinaryString(long bits) {
        char[] padded = StringUtils.leftPad((String)Long.toBinaryString(bits), (int)64, (char)'0').toCharArray();
        int numberOfSpaces = padded.length / 8 - 1;
        char[] spaced = new char[padded.length + numberOfSpaces];
        Arrays.fill(spaced, ' ');
        for (int i = 0; i < numberOfSpaces + 1; ++i) {
            System.arraycopy(padded, i * 8, spaced, i * 8 + i, 8);
        }
        return String.valueOf(spaced);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.addition ? "+" : "-").append(" gen:").append(this.generation);
        IdRange.appendBitSet(builder, this.bitSets[0], "deleted ");
        IdRange.appendBitSet(builder, this.bitSets[1], "freed   ");
        IdRange.appendBitSet(builder, this.bitSets[2], "reserved");
        return builder.toString();
    }

    private static void appendBitSet(StringBuilder builder, long[] bitSet, String name) {
        builder.append(String.format("%n", new Object[0])).append(name).append(':');
        String delimiter = "";
        for (int i = bitSet.length - 1; i >= 0; --i) {
            builder.append(delimiter).append(IdRange.toPaddedBinaryString(bitSet[i]));
            delimiter = " , ";
        }
    }

    public boolean isEmpty() {
        for (long bits : this.bitSets[0]) {
            if (bits == 0L) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    static interface FreeIdVisitor {
        public boolean visitFreeId(long var1, int var3);
    }

    static enum IdState {
        USED,
        DELETED,
        FREE;

    }
}

