/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.neo4j.internal.id.IdSlotDistribution;
import org.neo4j.internal.id.indexed.ConcurrentLongQueue;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.internal.id.indexed.PendingIdQueue;
import org.neo4j.internal.id.indexed.SpmcLongQueue;
import org.neo4j.util.Preconditions;

class IdCache {
    private final int[] slotSizes;
    private final ConcurrentLongQueue[] queues;
    private final AtomicInteger size = new AtomicInteger();
    private final int singleIdSlotIndex;

    IdCache(IdSlotDistribution.Slot ... slots) {
        this.queues = new ConcurrentLongQueue[slots.length];
        this.slotSizes = new int[slots.length];
        for (int slotIndex = 0; slotIndex < slots.length; ++slotIndex) {
            int slotSize = this.slotSizes[slotIndex] = slots[slotIndex].slotSize();
            int capacity = slots[slotIndex].capacity();
            Preconditions.checkArgument((slotSize <= 128 ? 1 : 0) != 0, (String)"Max slot size is %d", (Object[])new Object[]{128});
            Preconditions.checkArgument((slotIndex == 0 || slotSize > this.slotSizes[slotIndex - 1] ? 1 : 0) != 0, (String)"Slot sizes should be provided ordered from smaller to bigger");
            this.queues[slotIndex] = new SpmcLongQueue(capacity);
        }
        this.singleIdSlotIndex = IdCache.findSingleSlotIndex(this.slotSizes);
    }

    private static int findSingleSlotIndex(int[] slotSizes) {
        for (int i = 0; i < slotSizes.length; ++i) {
            if (slotSizes[i] != 1) continue;
            return i;
        }
        throw new IllegalArgumentException("Must have a slot for single IDs");
    }

    void offer(PendingIdQueue pendingItemsToCache, IndexedIdGenerator.Monitor monitor) {
        int i = 0;
        while (i < this.slotSizes.length) {
            int slotIndex = i++;
            MutableLongList source = pendingItemsToCache.queues[slotIndex];
            ConcurrentLongQueue target = this.queues[slotIndex];
            source.forEach((LongProcedure & Serializable)id -> {
                if (!target.offer(id)) {
                    throw new IllegalStateException("This really should not happen, we knew the max available space there were for caching ids and now the cache claims to have less than that?");
                }
                this.size.incrementAndGet();
                monitor.cached(id, this.slotSizes[slotIndex]);
            });
        }
    }

    long takeOrDefault(long defaultValue) {
        long id = this.queues[this.singleIdSlotIndex].takeOrDefault(defaultValue);
        if (id != defaultValue) {
            this.size.decrementAndGet();
        }
        return id;
    }

    long takeOrDefault(long defaultValue, int numberOfIds, IdRangeConsumer wasteNotifier) {
        long id = defaultValue;
        for (int slotIndex = this.lowestSlotIndexCapableOf(numberOfIds); id == defaultValue && slotIndex < this.slotSizes.length; ++slotIndex) {
            id = this.queues[slotIndex].takeOrDefault(defaultValue);
            if (id == -1L || this.slotSizes[slotIndex] == numberOfIds) continue;
            int waste = this.slotSizes[slotIndex] - numberOfIds;
            wasteNotifier.accept(id + (long)numberOfIds, waste);
        }
        if (id != defaultValue) {
            this.size.decrementAndGet();
        }
        return id;
    }

    int availableSpaceById() {
        int space = 0;
        for (int i = 0; i < this.slotSizes.length; ++i) {
            space += (this.queues[i].capacity() - this.queues[i].size()) * this.slotSizes[i];
        }
        return space;
    }

    int[] slotSizes() {
        return this.slotSizes;
    }

    IdSlotDistribution.Slot[] slotsByAvailableSpace() {
        IdSlotDistribution.Slot[] slots = new IdSlotDistribution.Slot[this.slotSizes.length];
        for (int slotIndex = 0; slotIndex < this.slotSizes.length; ++slotIndex) {
            ConcurrentLongQueue queue = this.queues[slotIndex];
            slots[slotIndex] = new IdSlotDistribution.Slot(queue.capacity() - queue.size(), this.slotSizes[slotIndex]);
        }
        return slots;
    }

    void drain(IdRangeConsumer consumer) {
        for (int i = 0; i < this.queues.length; ++i) {
            long id;
            ConcurrentLongQueue queue = this.queues[i];
            int slotSize = this.slotSizes[i];
            while ((id = queue.takeOrDefault(-1L)) != -1L) {
                consumer.accept(id, slotSize);
                this.size.decrementAndGet();
            }
        }
    }

    int size() {
        return this.size.get();
    }

    boolean isFull() {
        for (ConcurrentLongQueue queue : this.queues) {
            if (queue.size() >= queue.capacity()) continue;
            return false;
        }
        return true;
    }

    private int lowestSlotIndexCapableOf(int numberOfIds) {
        for (int slotIndex = 0; slotIndex < this.slotSizes.length; ++slotIndex) {
            if (this.slotSizes[slotIndex] < numberOfIds) continue;
            return slotIndex;
        }
        throw new IllegalArgumentException("Slot size " + numberOfIds + " too large");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("IdCache{size:" + this.size + ", ");
        for (int i = 0; i < this.slotSizes.length; ++i) {
            builder.append(this.slotSizes[i]).append(":").append(this.queues[i].size()).append(", ");
        }
        return builder.append("}").toString();
    }

    static interface IdRangeConsumer {
        public void accept(long var1, int var3);
    }
}

