/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraverserIterator;
import org.neo4j.kernel.impl.traversal.TraverserIterator;

class SortingTraverserIterator
extends PrefetchingIterator<Path>
implements TraverserIterator {
    private final Comparator<? super Path> sortingStrategy;
    private final MonoDirectionalTraverserIterator source;
    private Iterator<Path> sortedResultIterator;

    SortingTraverserIterator(Comparator<? super Path> sortingStrategy, MonoDirectionalTraverserIterator source) {
        this.sortingStrategy = sortingStrategy;
        this.source = source;
    }

    public int getNumberOfPathsReturned() {
        return this.source.getNumberOfPathsReturned();
    }

    public int getNumberOfRelationshipsTraversed() {
        return this.source.getNumberOfRelationshipsTraversed();
    }

    public void relationshipTraversed() {
        this.source.relationshipTraversed();
    }

    public void unnecessaryRelationshipTraversed() {
        this.source.unnecessaryRelationshipTraversed();
    }

    public boolean isUniqueFirst(TraversalBranch branch) {
        return this.source.isUniqueFirst(branch);
    }

    public boolean isUnique(TraversalBranch branch) {
        return this.source.isUnique(branch);
    }

    public Evaluation evaluate(TraversalBranch branch, BranchState state) {
        return this.source.evaluate(branch, state);
    }

    protected Path fetchNextOrNull() {
        if (this.sortedResultIterator == null) {
            this.sortedResultIterator = this.fetchAndSortResult();
        }
        return this.sortedResultIterator.hasNext() ? this.sortedResultIterator.next() : null;
    }

    private Iterator<Path> fetchAndSortResult() {
        ArrayList<Object> result = new ArrayList<Object>();
        while (this.source.hasNext()) {
            result.add((Path)this.source.next());
        }
        result.sort(this.sortingStrategy);
        return result.iterator();
    }
}

