/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.collector.CollectorStateMachine;
import org.neo4j.internal.collector.QueryCollectorConfig;
import org.neo4j.internal.collector.RecentQueryBuffer;
import org.neo4j.internal.collector.TruncatedQuerySnapshot;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.virtual.MapValue;

class QueryCollector
extends CollectorStateMachine<Iterator<TruncatedQuerySnapshot>>
implements QueryExecutionMonitor {
    private volatile boolean isCollecting;
    private final RecentQueryBuffer recentQueryBuffer;
    private final NamedDatabaseId databaseId;
    private final JobScheduler jobScheduler;
    private final int maxQueryTextSize;

    QueryCollector(NamedDatabaseId databaseId, JobScheduler jobScheduler, RecentQueryBuffer recentQueryBuffer, int maxQueryTextSize) {
        super(true);
        this.databaseId = databaseId;
        this.jobScheduler = jobScheduler;
        this.maxQueryTextSize = maxQueryTextSize;
        this.recentQueryBuffer = recentQueryBuffer;
        this.isCollecting = false;
    }

    long numSilentQueryDrops() {
        return this.recentQueryBuffer.numSilentQueryDrops();
    }

    @Override
    protected CollectorStateMachine.Result doCollect(Map<String, Object> config, long collectionId) throws InvalidArgumentsException {
        int collectSeconds = QueryCollectorConfig.of(config).collectSeconds;
        if (collectSeconds > 0) {
            JobMonitoringParams monitoringParams = JobMonitoringParams.systemJob((String)this.databaseId.name(), (String)"Timeout of query collection");
            this.jobScheduler.schedule(Group.DATA_COLLECTOR, monitoringParams, () -> this.stop(collectionId), (long)collectSeconds, TimeUnit.SECONDS);
        }
        this.isCollecting = true;
        return QueryCollector.success("Collection started.");
    }

    @Override
    protected CollectorStateMachine.Result doStop() {
        this.isCollecting = false;
        return QueryCollector.success("Collection stopped.");
    }

    @Override
    protected CollectorStateMachine.Result doClear() {
        this.recentQueryBuffer.clear(this.databaseId);
        return QueryCollector.success("Data cleared.");
    }

    @Override
    protected Iterator<TruncatedQuerySnapshot> doGetData() {
        ArrayList querySnapshots = new ArrayList();
        this.recentQueryBuffer.foreach(this.databaseId, querySnapshots::add);
        return querySnapshots.iterator();
    }

    public void startProcessing(ExecutingQuery query) {
    }

    public void startExecution(ExecutingQuery query) {
    }

    public void endFailure(ExecutingQuery query, Throwable failure) {
    }

    public void endFailure(ExecutingQuery query, String reason) {
    }

    public void endSuccess(ExecutingQuery query) {
        if (this.isCollecting) {
            QuerySnapshot snapshot = query.snapshot();
            NamedDatabaseId databaseId = query.databaseId().orElse(null);
            String queryText = snapshot.obfuscatedQueryText().orElse(null);
            MapValue parameters = snapshot.obfuscatedQueryParameters().orElse(null);
            if (databaseId != null && queryText != null && parameters != null) {
                this.recentQueryBuffer.produce(new TruncatedQuerySnapshot(databaseId, queryText, snapshot.queryPlanSupplier(), parameters, snapshot.elapsedTimeMicros(), snapshot.compilationTimeMicros(), snapshot.startTimestampMillis(), this.maxQueryTextSize));
            }
        }
    }
}

