// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception


// Copyright 2018 Ulf Adams
// Copyright (c) Microsoft Corporation. All rights reserved.

// Boost Software License - Version 1.0 - August 17th, 2003

// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:

// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.


// This file contains test cases derived from:
// https://github.com/ulfjack/ryu
// See xcharconv_ryu.h for the exact commit.
// (Keep the cgmanifest.json commitHash in sync.)


#ifndef DOUBLE_SCIENTIFIC_PRECISION_TO_CHARS_TEST_CASES_2_HPP
#define DOUBLE_SCIENTIFIC_PRECISION_TO_CHARS_TEST_CASES_2_HPP

#include <charconv>

#include "test.hpp"
using namespace std;

inline constexpr DoublePrecisionToCharsTestCase double_scientific_precision_to_chars_test_cases_2[] = {
    // Ryu Printf d2fixed_test.cc D2expTest AllPowersOfTen
    // These values test every power of ten that's within the range of doubles.
    {1e-323, chars_format::scientific, 749,
        "9."
        "8813129168249308835313758573644274473011960522864952885117136500135101454041750373059967272327198475959312"
        "9390891435461853313420711879592797549592021563756252601426380622809055691634335697964207377437272113997461"
        "4461000127748183071299687746249467945463392302800634307707961482524771311823420533171133735363740791206212"
        "4986389054318298491065861091308880225496025941999908386397881816083312664904951429573802945356031871047722"
        "3100269607052986944038758053621421498340666445368950667144166486387218476578691673612021202301233961950615"
        "6684554636658495809965049461552751854495749312169556407468939399067294035945355435170251321102398263009782"
        "2029020757254763345019116747794671979873296198823284114052741805584855350891304581750773650128394365310668"
        "9453125e-324"},
    {1e-322, chars_format::scientific, 749,
        "9."
        "8813129168249308835313758573644274473011960522864952885117136500135101454041750373059967272327198475959312"
        "9390891435461853313420711879592797549592021563756252601426380622809055691634335697964207377437272113997461"
        "4461000127748183071299687746249467945463392302800634307707961482524771311823420533171133735363740791206212"
        "4986389054318298491065861091308880225496025941999908386397881816083312664904951429573802945356031871047722"
        "3100269607052986944038758053621421498340666445368950667144166486387218476578691673612021202301233961950615"
        "6684554636658495809965049461552751854495749312169556407468939399067294035945355435170251321102398263009782"
        "2029020757254763345019116747794671979873296198823284114052741805584855350891304581750773650128394365310668"
        "9453125e-323"},
    {1e-321, chars_format::scientific, 751,
        "9."
        "9801260459931801923666896159380717217742080128093602413968307865136452468582167876790566945050470460718906"
        "0684800349816471846554918998388725525087941779393815127440644429037146248550679054943849451211644835137436"
        "0605610129025664902012684623711962624918026225828640650785041097350019024941654738502845072717378199118274"
        "6236252944861481475976519702221969027750986201419907470261860634244145791554000943869540974809592189758199"
        "5331272303123516813479145634157635713324073109822640173815608151251090661344478590348141414324246301570121"
        "8251400183025080768064699956168279373040706805291251971543628793057966976304808989521953834313422245639880"
        "0249310964827310978469307915272618699672029160811516955193269223640703904400217627568281386629678308963775"
        "634765625e-322"},
    {1e-320, chars_format::scientific, 750,
        "9."
        "9998886718268300541337523676528005766688104049139332319738542138136722671490251377536686879595124857670824"
        "6943582132687395553181760422147911120187125822521327632643497190282764359933947726339777865966519379365430"
        "9834532129281161268155283999204461560808953010434241919400457020315068567565301579569187340188105680700687"
        "0486225722970118072958651424404586788201978253303907287034656397876312416883810846728688580700304253500294"
        "9777472842337622787367223150264878556320754442713378075149896484223865098297635973695365456728848769494023"
        "0564769292298397759684630055091384876749698303915591084358566671856101564376699700392294336955627042165899"
        "5893369006341820505159346148768208043631775753209163523421374707251873615102000236731782933929935097694396"
        "97265625e-321"},
    {1e-319, chars_format::scientific, 750,
        "9."
        "9998886718268300541337523676528005766688104049139332319738542138136722671490251377536686879595124857670824"
        "6943582132687395553181760422147911120187125822521327632643497190282764359933947726339777865966519379365430"
        "9834532129281161268155283999204461560808953010434241919400457020315068567565301579569187340188105680700687"
        "0486225722970118072958651424404586788201978253303907287034656397876312416883810846728688580700304253500294"
        "9777472842337622787367223150264878556320754442713378075149896484223865098297635973695365456728848769494023"
        "0564769292298397759684630055091384876749698303915591084358566671856101564376699700392294336955627042165899"
        "5893369006341820505159346148768208043631775753209163523421374707251873615102000236731782933929935097694396"
        "97265625e-320"},
    {1e-318, chars_format::scientific, 754,
        "9."
        "9999874849559983034425876814113742209432834168744560969267393309501724022504791795040417479267848129655584"
        "2874876041601750171714894629266707048162621742736965195169511454088992450490864069696757508040293752086570"
        "9580676739282438749985996996081924055488407644357269925743534099929893815278419813774519051525459318108599"
        "1107475586860661255943562083015499877004233213563327286118520376694473250010459896242984318729757813819005"
        "4549703845033693317236663537845414770535737849377831764656567925888728970482401760612101576940871781833642"
        "5626336137844764344642729705586000404268243261408712779922641361250092237317059153946646039468838066148529"
        "6871589296549393052792796339935685990351574486171151756262515234669929463655509149777600441666436381638050"
        "079345703125e-319"},
    {1e-317, chars_format::scientific, 757,
        "1."
        "0000002306925373540838912978475160267584454368668534526669672098520647422515697285766597706921875662045329"
        "8226457012793890336449486476033452643735894613076931082954841359365992666407440152120030445435135990799474"
        "1954259843078263037226060394561354342969032583944572412669499566187211760243538754890531880822606236371978"
        "5920066306644424273339129868180713684032457145760224028598109997351719737497945725367012867943417584786681"
        "2026553849543810389671707959598249520266798536037749981808256864213845855131011662864961199497267523368458"
        "5488557116467671933238644465316019273339602500503268103425725256465919083825811307197979879484581971974592"
        "4201832234008052893493781386861080768235954429611544999118868631378263784093853548673447306782691157422959"
        "804534912109375e-317"},
    {1e-316, chars_format::scientific, 757,
        "9."
        "9999998365971443346061920956311959264775925433695214550458499705922349191381609347228383804226938538653679"
        "2366287780216044499031536405156556539159558732763919890485263237064770961810478612616379963299515548676713"
        "4548944815532598435214836120691606867323339473597648426536418734881746971242559593050185515442628522784588"
        "1185131819846979153816675915341864013104515083595754786004003374046743354151291027432271285983439508858844"
        "2646232720370702133470343586292981797312610775210888475844901856096836954505497483976693591967374658376095"
        "0009031993538060167762492161897827345208061381095352991868150697424341071434604085640940002282989444146358"
        "4493866832825339621246977613831620733691549327791400285367657800597186444724697763908327630133499042131006"
        "717681884765625e-317"},
    {1e-315, chars_format::scientific, 758,
        "9."
        "9999999848168380869801553486018337869440042528874622393432792982679396693408131157854639400126447623561656"
        "3760184721079416030959336106467234733051521976644243346829052258460480303946313987131415432762626210235795"
        "1648564032447600351437582190186923061065358655548532968545933350501169209114129270401493513009634553240699"
        "9866063694642814968591153281329780382737718466036143916002629170014970595400981001006542729590483689199322"
        "3303391066874746239265147746874352601633933250320885156379161863259334250313774632657068696147692692894604"
        "4301624343806379717639929311373569268499339198531592674411496809458432057444014624821271529836759260682332"
        "3945334163260650980068427789118371950611629025890843267716919511388313528497528027277896356395103794056922"
        "1973419189453125e-316"},
    {1e-314, chars_format::scientific, 759,
        "9."
        "9999999996388074622175516738988975729906454238392563177730222310355101443610783338917264959716398532052454"
        "0899574415165753184152116076598302552440718301032275692463431160600051238159897524582918979708937276391703"
        "3358525954139100543059856797136454680439560573743621422746884812063111432901286238136624312766335156286311"
        "1734156882122398550068601017928572019701038804280182829002491749611793319525949998363969873951188107233370"
        "1369106901525150649844628162932489682066065497831884824432587863975583979894602347525106206565724496346455"
        "3730883578833211672627673026321143460828466980275216642665831420661841156044955678739304682592136242335929"
        "7890480896304182115950572806647047072303636995700787565951845682467426236874811053614853229021264269249513"
        "74530792236328125e-315"},
    {1e-313, chars_format::scientific, 761,
        "1."
        "0000000000132873108058798218075466365858866796204316120387346995461095826861753841161935247836939689566881"
        "4013755407163529775592520874226933814642035817851187677065124379067137026930035030916463576460714764526356"
        "6941552468486215054944726595070143906775203397101679103788691652744850950702752480372779533942489184305449"
        "8212975998837171800278451594248186507426648281555498412610248716893168741033011563160921744542987825450117"
        "1730463076268016413019727751013442758474713657274891814670103539733279230421396327135404079024632555646151"
        "7071185888666743940446059781681939593390610457300000410827430924103528812599832038053657245435064880839104"
        "9702198578740563315381331097389800290969337059469445237589300988817006332715405382115941845810880295175593"
        "3463573455810546875e-313"},
    {1e-312, chars_format::scientific, 761,
        "9."
        "9999999999846534143064242548224957279984003844947981796030495661334201221115511889808726222773497386583906"
        "0366160174694434384393280942568027468226466215267996447194900001649974559958214473790120729137684534602007"
        "8598425065645235547531043204631943751558291951834840153344907012832890084789653234050444031427324837024042"
        "1011079056496922166969741465115877157896849612172543736972488543135719183088865941635643173986271210320831"
        "2523973604333660086091482705973846213942815250273808150020501137325629806918154994205360415142145238426998"
        "5617566294317171084910720379669920191982813295182567868591765894923254035012310969997392122823095038574513"
        "7282534320075197842454489523722716158476450514996352932910660626459272200070280990896048889382541347004007"
        "5480937957763671875e-313"},
    {1e-311, chars_format::scientific, 762,
        "9."
        "9999999999994753836816616511477927917844470256657499736814793090661876925865714541989788848333087337492396"
        "8343299564388520721546473722538158536045855411592384479540534380552114130892428057327572232684630845668163"
        "7680135027566927047722665479238893283177666153753035241799107964294452027013440391018179162227081537627087"
        "7122947149684401750551218912852475949533812932510787775885488405715316005812990910633000601130631914738865"
        "3002039320168310490502062186389904351023247382521319149688554563326346056647735821920228452652563270230450"
        "4126995553552197916865708123384867766175142422964311492560020229534457444110911911051310155975850415556167"
        "3256479466808241373590371668740244833598142522966162877208895552630351312778658273922385846255167507479200"
        "13964176177978515625e-312"},
    {1e-310, chars_format::scientific, 763,
        "9."
        "9999999999999694493275028976919693605773152470381150334840936338306132782690721297062490935851740335856013"
        "1942537544044990266118246815203829571639835051469864080618722193182185449923568510112153949469529056037035"
        "6316192026297650097729052888392458267564978627150308411414247996009837425087566629583770333253740094313855"
        "8993342752790651070003934827777029242588378376522062577182588401134635899903795076266245848702110604886133"
        "1017974844029465503982414835737106288925928453596236183010823010859703264972055182844057387236243871290565"
        "4743976528860032144597541048175366018648220060557036280025628707354830891080865275753107423747608928122222"
        "4455610971699342824628234406907495789435532256565156542018836716836053949868937516689930411484255046161706"
        "559360027313232421875e-311"},
    {1e-309, chars_format::scientific, 765,
        "1."
        "0000000000000018855892087022346387017456602069175351539464355066307055836837322197256976114460360563569237"
        "4830246134201063722057542412447039667519923301545761204072654097444519258182668255539061212114801887707392"
        "2817979772617072240272969162930781476600370987449003572837576199918137596489497925344032945035640594998253"
        "2718038231310127600194920641926948457189383492092319005731229840067656788931287549282957037345925847390085"
        "9881956839641558100533045010067182648271619656070372788634304985561303898580448711893644028069461193139657"
        "6980567462639081556737072434065441584389552782431630875877218955513686823577786061222328715052478477937882"
        "7957552412218845296973202068072422088501927122992505590849983083325662421357796544096668486800716380002995"
        "72013318538665771484375e-309"},
    {1e-308, chars_format::scientific, 764,
        "9."
        "9999999999999990932662533724846199547048873403204569370722504933164788134100221702366853061102859515757830"
        "1758491822824378438792553200763769833775473829862512856683413461939989729065436937279228852476622948659167"
        "9434355446221493480729436132941672166628217375554144801591156397912760548972014203897705803515339607715061"
        "9905566488977026029171097782672502440171652303162739065260414400859795093549243326204240563556399326294969"
        "1698930975461134804791235994697938405200089317860731205010159117711704697471514344499487123311264707354172"
        "3780995387378502198261451023662795913796604718812599767273565216024053297899062477635215259813914438876185"
        "7527558861992808911690506171197530846785775640581096161907433186688396108094354271255983085398000298482656"
        "9445431232452392578125e-309"},
    {1e-307, chars_format::scientific, 764,
        "9."
        "9999999999999990932662533724846199547048873403204569370722504933164788134100221702366853061102859515757830"
        "1758491822824378438792553200763769833775473829862512856683413461939989729065436937279228852476622948659167"
        "9434355446221493480729436132941672166628217375554144801591156397912760548972014203897705803515339607715061"
        "9905566488977026029171097782672502440171652303162739065260414400859795093549243326204240563556399326294969"
        "1698930975461134804791235994697938405200089317860731205010159117711704697471514344499487123311264707354172"
        "3780995387378502198261451023662795913796604718812599767273565216024053297899062477635215259813914438876185"
        "7527558861992808911690506171197530846785775640581096161907433186688396108094354271255983085398000298482656"
        "9445431232452392578125e-308"},
    {1e-306, chars_format::scientific, 763,
        "1."
        "0000000000000000279023803391476325978469990224051750613215776767695913434815660171857902754611290428295390"
        "2855112999397555396569952545618616744426089938099821880772600111269030190023111167436591184859690670436405"
        "3235908198301844721604945146272364072259074692549029825719823273398887747392739210687026322232580358825111"
        "0234205543842448102753778430086832136807498326022836612478352744084880146129506125620176035215057087515132"
        "2612616922071840157682358884105637168985105575243131100589013256198578475477149271096570431275426554079671"
        "6654247614171924100040800742268229310960254010514282230676348267637082219417179036571049957325656665930634"
        "4285043677760454755517299704176913224907978537594173374670297704548248979442337094143862519235455010857549"
        "495995044708251953125e-306"},
    {1e-305, chars_format::scientific, 760,
        "9."
        "9999999999999999628217900530785377054659627883900722995775030945280642024408233714255781016776892345034950"
        "1406426481668573825190999521406861414798119234028697220781311072490218654586931744476129716298164369509417"
        "1579154906539259553297447374781782441000739045507324002369679044368579627272624666077581243976346526774830"
        "7025658385238493027973334562682769653967428338344198908910697296851733096562843141535755075192125128789628"
        "3612239021983130437614961415360789480610798036545823058988806310179363406158165146574713062236131985212038"
        "1806081273895043986502259049610427190720957335454762962899504686945017155165729595557090423005192733858302"
        "0097669333441417250244332809616705208468049446512230390757498683137398144735633162723253963832803492550738"
        "155841827392578125e-306"},
    {1e-304, chars_format::scientific, 757,
        "9."
        "9999999999999997098601793823603070870627408398607296486668841559937848165409539310797183793308082794699787"
        "9690663671822989712784178773583416591227895116453079951225559040330152058071587800564304010459170501625708"
        "2955213245355909423095844104428295815728732741520944598506836092672341349948810713443435661296780877593807"
        "0772540742689702628321774772134328282681384400836865136212433181654078404777068649802950853625368531700272"
        "9601094862994913526248059474804323713218591863837432701467745308734226327267503095061920061821625140744295"
        "4016965379635686375377660351152934455615691119704315487808322295404373123960880979434363102804093593499868"
        "1895455378110913006301401423894763575978660702968627706001115993261324824985442939750956981015406199730932"
        "712554931640625e-305"},
    {1e-303, chars_format::scientific, 755,
        "9."
        "9999999999999993051216023092111380976175857222137814072098938543389377991011628265263428235757987514163528"
        "4945443176070055132933265577065904873515536528332092319936355788874045503647037490305382881116780313011774"
        "1156906587462549214773278871862717215293522655142737552326287369958360106230708389228802729009475838904169"
        "2767552514611637988879279107256822088623714100825131099895210597337830897919829463030464099118557976357304"
        "3183264208613766468061016369913978485391061987504008129434047706422007001042443812641451261158414189595906"
        "9554379948820714197578302433620946079447265174503599527662430468939342674033123193637999390482334968926374"
        "0771913049582106215992711206739656963995638713298863410390903689459607513385138582995281808507570531219244"
        "0032958984375e-304"},
    {1e-302, chars_format::scientific, 751,
        "9."
        "9999999999999996289124639677304732891737098163313400003754860956628154130529957101690432681798063738592536"
        "0741619572672402796813996134279914247685423398828882424967718390038930747186677738512519784590692463902921"
        "4595551913777237381431331057915180095641690724245303189270726348129545101205190248600509074839319869855879"
        "5171543097074089700433275639158827043869850340834518328948988664790828903405620812448453502724006420631679"
        "2317528732118684114610650853826254667653085888570747787061005788271782462022491238577826301688982950514617"
        "7124448293472691939817788767646536780382005930664172295779143930111367033975329422275090360339741868585169"
        "3670746912405151648239663380463742253582056305034674846879073532500981362665382068399821946513839066028594"
        "970703125e-303"},
    {1e-301, chars_format::scientific, 751,
        "1."
        "0000000000000000665043221274992345902153306917507527498505381267899223777698860937825684690912630765676536"
        "0328938404179991532123233391736474424502906138441861076106807871376656352651352653277535787570721134675459"
        "2959921695798423951473709805328306131275582854537351322749293107827733708512353219858996938149482076890135"
        "2286431296095393517740606454124524290065748630886455746192107848064042252096015313058601959426144144230967"
        "8954717520733442058356948120234553845089156237198431469146727165019106393715864300157422643138680298545449"
        "2134866699635902071498414503652842702337317635037800515375262700586184498579038935391378146388344394749331"
        "4294701527343889703142991033638081518025859259858927144364121703023337768036216122169435038813389837741851"
        "806640625e-301"},
    {1e-300, chars_format::scientific, 749,
        "1."
        "0000000000000000250590918352087596856961468077037052499253423199004660431840514846763028121819501008949623"
        "0627027825414891031146499880413081224609160619018271942662793458427551041478278701507022263926060379361392"
        "4359775094030143866141479125513590882591017341692222921220404918621822029155619541859418525883262040928316"
        "3178720501540199698661694898041067655794243192165254180873224255430058507393834020333099315764646743363847"
        "9065531661724812599598594906293782493759617177861888792970476530542335134710418229637566637950767497147854"
        "2365897951520448920491760252897567092617670818249247201056323377556165380506436538125830502246596311593005"
        "6323650792902539887815381155401398600958797808116743280493635963114041915328344956037653901148587465286254"
        "8828125e-300"},
    {1e-299, chars_format::scientific, 746,
        "9."
        "9999999999999999190290760137637976208079970046606724998518567438890097551538379739129028665449972035680926"
        "8654993624028106303651130713543666646941642034794006359075819280682667925398195400906114450103317751101389"
        "4796578126155197978756945816618186836433649314161201999972943672570926856702325994597557960702860121588611"
        "8925518658960446433985656531743023483770388411882929286181173813228715116320889861526972008354488226701519"
        "1541829745179090325919123351411654126959859303926546520294760229609181275060613732216818338004372560297782"
        "5507229530280863996864368522933466048419533648184045496011719191321500860483546203133923869331978450679449"
        "9468102053494600355532932528120522673051486467229961893972473711866052331620480231322289910167455673217773"
        "4375e-300"},
    {1e-298, chars_format::scientific, 743,
        "9."
        "9999999999999991232806544017866794540396664309573605012880972516114481311058134790726022538861880706524197"
        "8378310511738176684897847296134517208981728061861094996950742552059845950875175526912254796125831249071305"
        "7673763372204220340378116764175654061689991467534736690618290439817422613053039377005652445191435431121688"
        "8057471403500725107670554654940656105757483988435859232058608834656227218039009041197321250053738130052815"
        "3669461252213404717758741643748844181432709364664927137710748047655173102156049178235583038396446773463958"
        "9943029566464163497536606908432174341802314765843821861088084189145133793489580175635409101810415254077994"
        "6423927952220683901242822865976210665363906593780031707659147505607571959629353841592092067003250122070312"
        "5e-299"},
    {1e-297, chars_format::scientific, 742,
        "1."
        "0000000000000000396478128980950068520868995348882659698990112439255546729582652670817083234140282683317496"
        "4282100349140206407490310076398915630971759041855375317635086531785636111011200732530243024248980965231943"
        "9707026697852578456178424324808370650127984402213708118558573561222302940289189796515270127000971493586876"
        "5744634701223627922977471765782444391057813106595117131865471280037220785529001835372476246333493828469074"
        "1426525084095850169081535237600934009427614926748351814984516753878158617880335246460555951776912803239807"
        "6684574950857088429646102549163424107238986497758817967696590019262732110067992581963303272984491636864032"
        "3129460651425895022810699832540710987766403439129992000576046943562114055481515606516040861606597900390625"
        "e-297"},
    {1e-296, chars_format::scientific, 739,
        "1."
        "0000000000000000056958802426506498103047840970769246579602908389217120436655495553018554972739190786606809"
        "3230295203015836077090169983922791921618802712343571099517749924697729040098218551239838345679274874478660"
        "3989786601684003410274260951904155918405588334090978932026108356624820092560153567498015491672484040126954"
        "5227598018324013146388027419038876716262595851194708809556241840951461301868974920371744480645995157678729"
        "4477304028395980916466692284740654118418456529339856054660932234114787602503073825490689912326974636334897"
        "8633835752400909208341451386944702327756651825445635092606514925836540448542916698123366642903571607142370"
        "2199575889771541254094321820289220342105066697862794979293345025428418892943227547220885753631591796875e-"
        "296"},
    {1e-295, chars_format::scientific, 737,
        "1."
        "0000000000000000600189724913616210771561687975750707570622434869278602505338946941496200190980937821343908"
        "6913183436814828605730394131884589856583532839562457848505488496038380353558990041304485831390804619683914"
        "1137370755553723483720922348550899489161422043087345630478052683980792648926611533925622908198063965662829"
        "8054856710963396788931138373828584995934943459835362125251008943488676475725017984372915305745993030943280"
        "9596057717515771720650441009317101944033109965193449271178667465736181227106692099042475575446875703382753"
        "5515018469930795962428893246494657174928387301146727692750635075318447106983038112267265251033043654697029"
        "56873915084185072840405266398916053751632054838903102133456680944423311530044884420931339263916015625e-"
        "295"},
    {1e-294, chars_format::scientific, 735,
        "1."
        "0000000000000000165604986923928440636750610371765538777806813685229416850392185830714084016387540193554229"
        "1966872849775634582818214813515151508611748737787348449315297638965859302790372849252767842821580823519711"
        "1419303432457947424963593231233504632556755075890252271716497222096014603833445160783536974977600025234129"
        "5793049756851889874896649609996818372197065372922839472695195261458904336640183533171978645665994732331639"
        "7501054766219939077303442029655943683541387216510574697964479280439066327423797480201047044950954849744469"
        "0010072295906886559158939758854693297190998920585853612635338955732921780230940980952146364529466016653302"
        "089713901350093446008356278420969734871669445506829802610380963923120134495547972619533538818359375e-294"},
    {1e-293, chars_format::scientific, 729,
        "1."
        "0000000000000000513272777315678656744599472454953673812059310632468765374349594719339776956062258295785972"
        "7923921319406989801147958268210702186989176019207435968667450324623876143405266602894142233676959860451073"
        "5193757290934568271969456525087420517840488649647926958725741591603837039907978259297205721553971177577089"
        "7602495320141095406124240621062231671187367842452857594739846207082722047908051094132727973729993371220952"
        "7177057127256605191981041213384870291934765415456874356535829828676758247170113175274189869347691532655096"
        "6414029235126014081774902548966664399380909625034552876727575851401342041632618686004241473732328127088284"
        "072934100943499271924913386875522376987390327812590777589729640340010519139468669891357421875e-293"},
    {1e-292, chars_format::scientific, 729,
        "1."
        "0000000000000000513272777315678656744599472454953673812059310632468765374349594719339776956062258295785972"
        "7923921319406989801147958268210702186989176019207435968667450324623876143405266602894142233676959860451073"
        "5193757290934568271969456525087420517840488649647926958725741591603837039907978259297205721553971177577089"
        "7602495320141095406124240621062231671187367842452857594739846207082722047908051094132727973729993371220952"
        "7177057127256605191981041213384870291934765415456874356535829828676758247170113175274189869347691532655096"
        "6414029235126014081774902548966664399380909625034552876727575851401342041632618686004241473732328127088284"
        "072934100943499271924913386875522376987390327812590777589729640340010519139468669891357421875e-292"},
    {1e-291, chars_format::scientific, 727,
        "9."
        "9999999999999996232432339127981035085063855219920481243729184475360331530186279644580030304949799540727091"
        "8738772371507204422238150241900924503429621787720119191259394493393530314311385935722237930871895259067858"
        "3311554132344189036344464928213958515141307008282797599820760056638116035571735271022137303184610275791116"
        "9703146781207292461816076327347736257721935204560112023055397862857487070623101380732096938861568556643115"
        "2064910830027399384063873030388181744477172261543472305931724251882669326195449958869442388920456244038898"
        "8198994707250476238780378062800183777747382216458827606514493984901861724443237610708779941730011243747301"
        "9589038998438035757852718923186761317114486910984268164259702871277113445103168487548828125e-292"},
    {1e-290, chars_format::scientific, 725,
        "1."
        "0000000000000000691278685996254767391818089841545998949596589069455311818615788070316131741175713964128625"
        "5133930135858243672932786917014824134318418787294520778575752499680780765800092204758525921794913927359931"
        "0566277666474598145636458531540625451105760239411856398474474708791842127178139205736204119801073207576685"
        "3728931448545168638112767218727723280270402706852226873226707491242116716077199285344631629698760674332280"
        "9571170336107378242695971995454080715432175053317379781724361309374456510080226811151638995438820714305337"
        "9932855188006207373354275497503993603702143905712286899942801141983573215470277670990914169644193527630994"
        "84834284313532305479419062640425332975063941955314039677915616266545839607715606689453125e-290"},
    {1e-289, chars_format::scientific, 723,
        "1."
        "0000000000000000121659778218411213320718514204450558509477298071098363196963969347191796428812655825432136"
        "8061901923214231283221335240841633902864841929415849386869185539498685974136650278792498119817460913251586"
        "9374212464746502549902052110890369664656891152167282191278528733790225847913624177131409245410346711577979"
        "4124335837652134295749482106198150131204691140774245182068751381932053777935925073466539930598705304376030"
        "5910008067784904480408193492832607360240464212163762421121060571141822068767863176343801791947207333024565"
        "6672612138789588840300282062184540149874194207543538025654080212120433459189768919033561542726224245894320"
        "367034868121486949612503459912314280908242325983381615372991291224025189876556396484375e-289"},
    {1e-288, chars_format::scientific, 721,
        "1."
        "0000000000000000577354904440686056577598174714126910861572730869783922094285424325691264678703102336389327"
        "7719524493329441194990496581780186088027703415718786500234439107644361807467403819565320361399423324538262"
        "2327864626128979026489577247410574293815986421962941557035285513791518871325236200015245144922927908376944"
        "1808012326366561769640110196221808650457260393636630534995116269380104128448944442969013289878749600341030"
        "8838937882442883490238416294929786044393832885086656309603701161727929621817754084190071554740498038049183"
        "5280806578162883666743476810440102912936553966078537125085056956010945264214175920599443644260599671283659"
        "9520812481325558337578531931058655199821600008391886404979231883771717548370361328125e-288"},
    {1e-287, chars_format::scientific, 719,
        "1."
        "0000000000000000212798803462866181972094446306385828979896384630835474976428260342891690078790745127623574"
        "9993426437237273265575167509029344339897414226676436809542236253127821140802800986947062568133853395508921"
        "9964942897022997845219557138194410590488710206126414064429880089790484452595946581708176425312862950937772"
        "3661071135395019790527607724202881835055204991346722252654024359421663848038528947367034602454714163569030"
        "6495794030716500282374238053252043097071137946748341198817588689259043579377841357913055744505865474029489"
        "2394251026664247805588921011835652702486666159250537845540275560898535820194650319346737963033099330972188"
        "28404414412370072644157340655102452872302586095454302039797767065465450286865234375e-287"},
    {1e-286, chars_format::scientific, 717,
        "1."
        "0000000000000000504443684245122081656497429032578694485237461621994232670713991529131349758720630894636177"
        "2174304882111007609107430767230017738401645577910316562095998536741053674134483253041668802746309338732394"
        "1855280280307782790235573225567341553150531178795636058514204428991311987579378276353831401000914916889109"
        "8178624088172253373817609701818023287376849313178648878526897887388416072366861343848617552393942512986630"
        "8370309112097606848665580646594237454929293897418993287446478667234152413329771538934668392693571525245244"
        "6703495467863156494512565650719212870846576404712937269176100676988463375410270800348902508015099603221365"
        "618473827330784812294597235794897321730333172862259516477934084832668304443359375e-286"},
    {1e-285, chars_format::scientific, 714,
        "1."
        "0000000000000000737759588870926801404019815213532986889510323214921238826142576478123077502664539508246258"
        "9919007638009995083933241373790556457205030658897420364139008363631639700799829065917353790436274093311171"
        "9367550186935610746248386095465686323279987956931013653781663900351974015566123632070355381551356489650179"
        "7792666450394040240449611283910136449234164770644190179225196709761817851829527261033883912345325192520710"
        "9869921177202492101698654721267992941215818657955514958349590649614239480491315683751958511243736366217849"
        "0150891020822283445651481361826061005534504601082856808084760769860405419582767185150634144000699821020707"
        "486017573896452080977016299189995556136179022388432713341899216175079345703125e-285"},
    {1e-284, chars_format::scientific, 712,
        "1."
        "0000000000000000364454141469639249807983997324006119042673744666238028977456840559736313112354285726470128"
        "1527483228571615124211944403293694507119614529318054280870192640606702058135275765316257810132330485985127"
        "5347918336331086016627885503628334691072857111914409501353728746174914770787331062923917012670649973232467"
        "8410198670839181253838408752562755390262460038699324098107918593964375004689261793537457736423112905266182"
        "7470541873034675696845736201789984163157379041097080284904611477806100173032845052044294321563472620661682"
        "0635058136087680323829216224055103990033819486890985545830904621265298148906772969467863526423739472541760"
        "4979475793913844510851457977578383810868256631465555983595550060272216796875e-284"},
    {1e-283, chars_format::scientific, 709,
        "9."
        "9999999999999994685210677065491259774980343891416362102659561493983253406110743556080785756096766502074141"
        "3878246459195032208808316741012258269146158183275756810250349053468517157403478438736274574028658284026209"
        "7008018948802266655386840832186907737757430838745595355266843761499725833182288969724649273569543338299591"
        "8922759999075196859715226773290408487303686820316455034264511160505121715526246715460349142098034158553149"
        "7120315430319163251987317550427630958171239606368370686366614654665658351325155359459002663308396313268813"
        "7970592127246328314557798934048071528321752128304945164216498646370406992843868518292140442390346361922877"
        "2657959257922213934465659432066116096837760096605052240192890167236328125e-284"},
    {1e-282, chars_format::scientific, 704,
        "1."
        "0000000000000000185267526717021225041886804737033222476192186962870088250087687318910666205005363911217585"
        "3499551512041192743545721857455200771078614787119958560901161093554731989656290181027731739586437554468626"
        "2218495048040914146410045219546405907613434306306439508188319872169926333293510629733626595607910845351966"
        "1106614136652848940265031537516012481956041767365788379171625098381602438061934369139173171980451007384009"
        "1918839807034123822516335312440539949689328025005031641651021475338193305452779148824615510516946022794721"
        "9267458351415070825354528957925044622593490632078887339949053669939646658982295745940133629986798505271865"
        "94367398202895198873704795707040293706313605071045458316802978515625e-282"},
    {1e-281, chars_format::scientific, 704,
        "1."
        "0000000000000000185267526717021225041886804737033222476192186962870088250087687318910666205005363911217585"
        "3499551512041192743545721857455200771078614787119958560901161093554731989656290181027731739586437554468626"
        "2218495048040914146410045219546405907613434306306439508188319872169926333293510629733626595607910845351966"
        "1106614136652848940265031537516012481956041767365788379171625098381602438061934369139173171980451007384009"
        "1918839807034123822516335312440539949689328025005031641651021475338193305452779148824615510516946022794721"
        "9267458351415070825354528957925044622593490632078887339949053669939646658982295745940133629986798505271865"
        "94367398202895198873704795707040293706313605071045458316802978515625e-281"},
    {1e-280, chars_format::scientific, 700,
        "9."
        "9999999999999995736438816947517005069417207068324021959351366687075172340009775902257914279210441151555725"
        "8308779196173510175383489009931421520586690004171251700735334129506741559146860533228960854564563482256350"
        "7367302240104608293998170498800889934052711298312352648503909155662324666479368844441019720337612888531868"
        "7103789266301679766012373101564633549368007345473197918690766334590720773073234271930285253494983959461901"
        "2356967550855734248053136101277703677183805567441722726787676002477378641128208658347785021448019020754979"
        "9327177530658970705609297562011086483971681409869254638723357560814229067067468229654822501487066703239591"
        "9842010303184918392220732752395662146227550692856311798095703125e-281"},
    {1e-279, chars_format::scientific, 700,
        "1."
        "0000000000000000552241713730382939762853855155153714644346417139367630859739713156121591071255955788854793"
        "0100755667495497779150145631332435942490582259141658595397737701917166689901252657650633132064426278214420"
        "9107553942459186136616182121346196056138332212191562054191077246132142653280854876907341369752400579251233"
        "6544355262666457518463308073931741958167586387056869531553154177335120654514700934306859959959022574246700"
        "6328725638203254061142948333828201698871896505961547263034373800392466570256754118618517715540232495226256"
        "2868302710424575078230688478959406207111284126734064465595084418254580910347625099724924457889653606240609"
        "9908263094272136716259523347982707264236523769795894622802734375e-279"},
    {1e-278, chars_format::scientific, 697,
        "9."
        "9999999999999993779243152876254526557592938171681397062528805745754945088532304770466314992540617804157284"
        "9769023700417216652159895549252833939722863486722184850086925551573756491173727324573486761348623622278779"
        "0625654803207157679565440355868675808586589133591699069822536494530504293213532859514540924900334307735775"
        "1435836594229100682288231574014076342906436040454098439322611246838623618658479257702622384275935602860880"
        "2170909784620372975377866653876841014876773669006972746076463602187921228840342152780306594657157834453463"
        "3456007615941614690269780116494491366543449438374976635277860236467913059785711676135938086005172831406290"
        "3993886175277628638145832606909380047000013291835784912109375e-279"},
    {1e-277, chars_format::scientific, 695,
        "9."
        "9999999999999996910756215390274492176511768406309596897444903251867308690896258581332873851212335159994790"
        "3432632493627286289317645086338574069104985914640691811124379276266532599930740458422245310494127398242893"
        "7412290702243078662657808584560218409332384597144744795712732752341416890438870435396906997599980037009524"
        "8504560869545227216246858018094967873244950128484657606311659387241979065722087280466882975026412973422513"
        "8468602210596951011658297769718221274568024706502572715214403442651053088500928561688272077522535732535889"
        "8849879479489384314813008029321043554428620592765821440790655955422018671436522161766153150776203026339572"
        "93508847799292922446656728396874314057640731334686279296875e-278"},
    {1e-276, chars_format::scientific, 681,
        "1."
        "0000000000000000943680846544635435465218708934482239623710929327631676310035207382479910928589920458334481"
        "1808706766646756483794864323468153458663347562631471965527419417503763703495879299381727950707614250209935"
        "2455883429838676259502728149932638881231556645135692769927351778358506727934022073892637128839856295410452"
        "3677945797080973335208136379441853399459900648060689427426785194885540085397651937152392533802832245566904"
        "8365937191450326315678002223308374231333302885648497259176616280450358052714327419732013400898404732486559"
        "6042536693368046281298591968062725230596930521032920066284183883123844111803976410428701340986032380607270"
        "307788791985359466707450337707996368408203125e-276"},
    {1e-275, chars_format::scientific, 690,
        "9."
        "9999999999999993403461585374572130683322678543526013082338874045021461456248630313162327929500011721456784"
        "3329390645232008295700965604802545124197008795371964014762431104610623358122885748511635735451163169163085"
        "3011258495322847161594356168425690696497093677965333582715712943593194781546492350408656996176376820222925"
        "1787589681191165498213196400724369359265814349890431339283925469990220965010846294970911113385878318393484"
        "1815186693503183611024214919975875383713823544507500749779910821332345405681071783711350736713312486683572"
        "1608742992315882335324592766955305103997228899848075258616324750193420386387614417860312278232649208014296"
        "495104634271942900536345177897601388394832611083984375e-276"},
    {1e-274, chars_format::scientific, 688,
        "9."
        "9999999999999996610130961388928575477095560703785289713292957891280521785069319015489684200779850293834389"
        "8280926049479119604150501130778343016684302161560515142864783718696026093490067197572764489776159035750338"
        "7320773655935630248280941234605830319660788232643652406027273911591569281105238028112199854620814046999244"
        "8785963339114879068986829879463202286332452776033723926280710765763256942803980910281513958314367145848597"
        "0184023737703199520175376382597448769637664606902995118177161217966592429973512266433107391167459454319976"
        "9372067780588798430856858149689694544391644161944300339461427566402424532718044355145652504558184127625977"
        "8116612913882732538439768177340738475322723388671875e-275"},
    {1e-273, chars_format::scientific, 681,
        "1."
        "0000000000000000943680846544635435465218708934482239623710929327631676310035207382479910928589920458334481"
        "1808706766646756483794864323468153458663347562631471965527419417503763703495879299381727950707614250209935"
        "2455883429838676259502728149932638881231556645135692769927351778358506727934022073892637128839856295410452"
        "3677945797080973335208136379441853399459900648060689427426785194885540085397651937152392533802832245566904"
        "8365937191450326315678002223308374231333302885648497259176616280450358052714327419732013400898404732486559"
        "6042536693368046281298591968062725230596930521032920066284183883123844111803976410428701340986032380607270"
        "307788791985359466707450337707996368408203125e-273"},
    {1e-272, chars_format::scientific, 683,
        "9."
        "9999999999999993018661260252849357308069932684294899886624383983470374216790147668883045176946431092771471"
        "6735206396722354938687021341685449377098533591429337879390148790920375029878823974624300284932163665172614"
        "8894116676049313191191965960484073941717450331403935323918325627433389841599442869084231853163044353009766"
        "8147784842240319869720360383275709408017817738753236228844311234497456647675670141133638771994459659098870"
        "6410926248199181701926075544461286577402962617020041425572240773736235762765978925784739938178814850567203"
        "5877144017723132403860720921027178371149899068396528248914912412248339888827962825386071451073585017660894"
        "73711783541798325813942938111722469329833984375e-273"},
    {1e-271, chars_format::scientific, 681,
        "9."
        "9999999999999996302290701291550356776893364016400399156721365842039651993502532900066257998736985790886139"
        "7005578650671396918539345720284666419005521998406414234566957867743827430894817778462896129360959432557962"
        "4027060200516803071959029068252536915837073555394533798989364058663725329147598443052659740210148073228718"
        "1874119467954202566192561065504274325334055487123967837929019377369045488935839987211696085201232218412906"
        "1860615381459997992896864882185777724588975864913027658811025179889704715641437980091818752339861345426882"
        "0786788600914598485685760672947193158113780296783062731700297696046360134670323081166259842830932775343256"
        "405271852305105539926444180309772491455078125e-272"},
    {1e-270, chars_format::scientific, 678,
        "1."
        "0000000000000000418300135978443275550206959921345359740495412230260591865761225745490596877103431706636134"
        "2965447206014909767018492422892278731958229417515139748699129965212011319333320290767552615599006927428279"
        "6434612465923877878579998052689684805372416929297197013915985629361653049926317182057688666912319700175420"
        "1481732256966752103772584270285283012689302608321372369973231892026085870796024761779903363689748636076659"
        "1493986930128595709122675929272455647783540765985619461858410775465803020254253971042880790632637293309011"
        "0456993560057411708206585607755522864682709524491074549038522237716160872469198769503871198304856739378092"
        "440884149283419901621527969837188720703125e-270"},
    {1e-269, chars_format::scientific, 674,
        "9."
        "9999999999999995776909990725358196861881615003263519273505848744668567549228551263076943947250497039187792"
        "8162319090039550201762973819708791692300403853290082017738668415452075046732258769848720794252352109776306"
        "8005789236602004691036298971009582839977933839556038042977997909666871651139893551217711278282611477993685"
        "9677905927839981334757008956347703938563457447384650780475466074509591274334212811839206915088148608922660"
        "4988665120138267386341538588149859141039213745250149861492819674905149683181364531402686142074093906249333"
        "5201245467603963912593754312639990792199559300241217214454636050638676895335545440241429700149757134114078"
        "53836720960316597484052181243896484375e-270"},
    {1e-268, chars_format::scientific, 674,
        "9."
        "9999999999999995776909990725358196861881615003263519273505848744668567549228551263076943947250497039187792"
        "8162319090039550201762973819708791692300403853290082017738668415452075046732258769848720794252352109776306"
        "8005789236602004691036298971009582839977933839556038042977997909666871651139893551217711278282611477993685"
        "9677905927839981334757008956347703938563457447384650780475466074509591274334212811839206915088148608922660"
        "4988665120138267386341538588149859141039213745250149861492819674905149683181364531402686142074093906249333"
        "5201245467603963912593754312639990792199559300241217214454636050638676895335545440241429700149757134114078"
        "53836720960316597484052181243896484375e-269"},
    {1e-267, chars_format::scientific, 667,
        "9."
        "9999999999999998466859228824262055626741769950524344275569296283208519903911337244462231890861319447883328"
        "8639808040474605391657997950657270293030608756285702967899510411185847253644560893953298510008421602418383"
        "4834696571845772401360677068893507708376729184649136313756192592530762482539342597412647403351598845597050"
        "9322519253224794039707035755229344318828919410849954114637658985149996853094543949746351466067136689512718"
        "4173050458105528091904809213613762288813995797924084183762031860426071449376940588691045106634823194838382"
        "1399226310154412926824826877412866905680370802535466262752423675126015080729606961776560030677376417207469"
        "2169189802370965480804443359375e-268"},
    {1e-266, chars_format::scientific, 667,
        "9."
        "9999999999999998466859228824262055626741769950524344275569296283208519903911337244462231890861319447883328"
        "8639808040474605391657997950657270293030608756285702967899510411185847253644560893953298510008421602418383"
        "4834696571845772401360677068893507708376729184649136313756192592530762482539342597412647403351598845597050"
        "9322519253224794039707035755229344318828919410849954114637658985149996853094543949746351466067136689512718"
        "4173050458105528091904809213613762288813995797924084183762031860426071449376940588691045106634823194838382"
        "1399226310154412926824826877412866905680370802535466262752423675126015080729606961776560030677376417207469"
        "2169189802370965480804443359375e-267"},
    {1e-265, chars_format::scientific, 667,
        "9."
        "9999999999999998466859228824262055626741769950524344275569296283208519903911337244462231890861319447883328"
        "8639808040474605391657997950657270293030608756285702967899510411185847253644560893953298510008421602418383"
        "4834696571845772401360677068893507708376729184649136313756192592530762482539342597412647403351598845597050"
        "9322519253224794039707035755229344318828919410849954114637658985149996853094543949746351466067136689512718"
        "4173050458105528091904809213613762288813995797924084183762031860426071449376940588691045106634823194838382"
        "1399226310154412926824826877412866905680370802535466262752423675126015080729606961776560030677376417207469"
        "2169189802370965480804443359375e-266"},
    {1e-264, chars_format::scientific, 661,
        "1."
        "0000000000000000122136724863753960700195856861651942907768226656267343111510651008940076674511880159438755"
        "7776875672572010190611050266074851238017833857695321882086421261481722999352275826903638609094263676288387"
        "0006749768313539053673284024112664677361709561802446894303306394778338669389237842071626199542224191002289"
        "6655860329841884224957586319728414406822075246143842472881974452564577216574512303496326748626962048403693"
        "7725786104418400305440159833408879911213537261986219292976570513839949533796121047135432468634500998635356"
        "7926595869292607271739744518374029204588472178088477728820935820260104938257312595982853348913765856309510"
        "1271755993366241455078125e-264"},
    {1e-263, chars_format::scientific, 661,
        "1."
        "0000000000000000122136724863753960700195856861651942907768226656267343111510651008940076674511880159438755"
        "7776875672572010190611050266074851238017833857695321882086421261481722999352275826903638609094263676288387"
        "0006749768313539053673284024112664677361709561802446894303306394778338669389237842071626199542224191002289"
        "6655860329841884224957586319728414406822075246143842472881974452564577216574512303496326748626962048403693"
        "7725786104418400305440159833408879911213537261986219292976570513839949533796121047135432468634500998635356"
        "7926595869292607271739744518374029204588472178088477728820935820260104938257312595982853348913765856309510"
        "1271755993366241455078125e-263"},
    {1e-262, chars_format::scientific, 661,
        "1."
        "0000000000000000122136724863753960700195856861651942907768226656267343111510651008940076674511880159438755"
        "7776875672572010190611050266074851238017833857695321882086421261481722999352275826903638609094263676288387"
        "0006749768313539053673284024112664677361709561802446894303306394778338669389237842071626199542224191002289"
        "6655860329841884224957586319728414406822075246143842472881974452564577216574512303496326748626962048403693"
        "7725786104418400305440159833408879911213537261986219292976570513839949533796121047135432468634500998635356"
        "7926595869292607271739744518374029204588472178088477728820935820260104938257312595982853348913765856309510"
        "1271755993366241455078125e-262"},
    {1e-261, chars_format::scientific, 658,
        "9."
        "9999999999999998400751036348743394393736566782540462240318584996501362034842653096183707054359139876367227"
        "3700713272028713475311137837615080482939063240589682587428357558298694067887484156951304408066000438567211"
        "8069109345174821566111745152759912370810960390248128330653547680004699501466869737653360653141903412050830"
        "6348853236140136882670183896620029124843515417635830819897288932178098245590930051701145481582277078444137"
        "1539015004039644692804886274722361405054282754197569573857943701754709276050918111507126396721778711842017"
        "6810424732967893091851084038061008702315466379055082798141457246466614257485362505823312667674329645706166"
        "0476028919219970703125e-262"},
    {1e-260, chars_format::scientific, 655,
        "9."
        "9999999999999996144258066517706424307158965315357288770427639743563706770631567501610059301751410501950963"
        "0446278509075602730671645979108334965147642971498853600679673513083865327379264867283239061764691379113885"
        "2470398674806366389614869082066524848566052208027055840749934665781749747526462791203039579317632613673177"
        "8181053186317172589145640456088737170141725782593755692759324457403959109467575665091447877832402353969896"
        "6963938171924158003527516627229211239389410861665870889131734552438880426522684223629367765023193692232777"
        "4845997565001349391413995121517582027460062057591327206087136481559066157415151742619136010503666511795017"
        "8682804107666015625e-261"},
    {1e-259, chars_format::scientific, 650,
        "1."
        "0000000000000000697542432170668388072273145235783652142590417695766445203884477835556356851426851149914903"
        "1806756537125053430494120689994071345054646026313483273707335693011504328181871745768995272401097486448985"
        "2734420989257495123679987422139478495534161148268820379228727713405190856644041613416458073367413244588591"
        "1338649342546740119806344897063893855271031603079571630302155393631982696285967672081799637583180103144625"
        "0892430696607849411205889093519633203458079594581802457581753846915485890425820688544260919717640178635713"
        "0427524797124075915351202192092603006676600280061735404794787615311529703775216340599918396492284955456852"
        "91290283203125e-259"},
    {1e-258, chars_format::scientific, 651,
        "9."
        "9999999999999995422180316171774593879454132845858673260062537262623657086084020111346492020916937102137758"
        "4604859384930607292387008584386176399454388485389788324920094618615120130416634694589458150948272480088820"
        "7478811260288460733135868739444640841447681589716312643980778501230405826265532568338936835693865958192328"
        "9167357170373824015217786555118723744637153099380291652075175825476234585908102261376344644632442442138139"
        "7499913585647202262958758340031403186376651856055727310019347624657815194673649379508485002879646485957820"
        "6217380871252055407274126668223685491506332674722925416629753836788650765392684298393799480209054308943450"
        "450897216796875e-259"},
    {1e-257, chars_format::scientific, 646,
        "9."
        "9999999999999997732829117278756451248109596748254242893230865201631816076636171760189907319587251981540013"
        "1297400582194592694897848247497083809672802840938797207350747080915104760697051247209557065560812956969027"
        "1451890986745758833868669835834669664226467568310690873642078227794706374300509281504065615289919255731045"
        "4011184421392539451786919038222766706251785685663376582264451447644953061298417153264674990872314159999761"
        "9784792261733460632778784859064388956017480674008186763178985793557223936590560880695309841738997546037682"
        "5828954291249796156521705718764154406558266699901811142893378300053980019864580119914876377151813358068466"
        "1865234375e-258"},
    {1e-256, chars_format::scientific, 646,
        "9."
        "9999999999999997732829117278756451248109596748254242893230865201631816076636171760189907319587251981540013"
        "1297400582194592694897848247497083809672802840938797207350747080915104760697051247209557065560812956969027"
        "1451890986745758833868669835834669664226467568310690873642078227794706374300509281504065615289919255731045"
        "4011184421392539451786919038222766706251785685663376582264451447644953061298417153264674990872314159999761"
        "9784792261733460632778784859064388956017480674008186763178985793557223936590560880695309841738997546037682"
        "5828954291249796156521705718764154406558266699901811142893378300053980019864580119914876377151813358068466"
        "1865234375e-257"},
    {1e-255, chars_format::scientific, 643,
        "1."
        "0000000000000000069045958269569322867998859054332057202368632496356225958454292587070947890188525502717489"
        "9106385331469249401011172301627904529475237321604152857686198223265908508745598443456328367626486476737569"
        "1333743303661110040280665523921390655738331362091149500760854187779701107578527947435543045317286747658060"
        "2501128330269649521059540861659594169711851539610572529290672424402091270979802021488173783405934995886263"
        "8430943696712387134614841880342661074115774156098733486322332264974846712624420760221444563547896690293990"
        "5893176826884690431555860690345595461782474225213078487251081761303360146558860677146185480523854494094848"
        "6328125e-255"},
    {1e-254, chars_format::scientific, 639,
        "9."
        "9999999999999991226042093361495540897975810399108318806228853725384840359241312717046849838531645281143263"
        "9811204570699209801427323756176768542497748015712788194426029747078348041827398235031358522011898974074365"
        "9303698477042007382205101948400348499281406252588921778915858197789636031034014857231062971947433169862019"
        "7810966882523836782408241965801781726344980322690209418851451295617841834599290417707136735860835402501433"
        "7830573909874557063365590181467501028708906722654060943081444709936488919352538093353211095511064960852791"
        "3002763540536158206640523112442193941772020484998068937735011811498812839271721486511523835361003875732421"
        "875e-255"},
    {1e-253, chars_format::scientific, 637,
        "1."
        "0000000000000000636911007629621184134919625862984792395416080770646871111972389376290705633989742087479388"
        "0181544256108846453532236257234041134610514833623877280632355372400752731483313615428243876881664424335648"
        "6575767377235255621516758721370204139224445804190503894482415208580143610263603824463005094190812806061175"
        "2133147315480009026750770860707243767958263644015503481733988801306275523491725809318649849297845869267936"
        "1219675480147345991581811597660207656862704246398729921530844941363565405037920930753118635945970806819217"
        "4648917110583335198090945717806421102345637531241041443337630109395447464137873794243205338716506958007812"
        "5e-253"},
    {1e-252, chars_format::scientific, 637,
        "9."
        "9999999999999994254655689948438800988219900045256239835815244521601614511337828926218891138804800399873387"
        "2212052168777060748206331519409497103219228079817985116805534542464183896428545818881574571372848027930790"
        "0594493536104117148797599001460687077874016610452145212097516975391996045354419534710860565939572148011966"
        "2515068136979087479428135294055912916992511546183174498549138639106824514662883952803009087284360060537019"
        "2703810088194337633856095340494416136692533870920708597526845650676321945557872336188806148300793582320667"
        "9700045053595596961494309925566597358108891450480538036863269667989945199693124777695629745721817016601562"
        "5e-253"},
    {1e-251, chars_format::scientific, 635,
        "1."
        "0000000000000000152332832175710262520480571519601125030682258243252187247636946782823179025946037268482568"
        "2997408640416390302047595015116804564895078023367045773051634605139018994747130002012209308983912575718620"
        "7969240167785318058861959192880549966649628146932388145173349804163766007972339076066237479152070569557183"
        "7780491114767168915227587928186582777454658648256629068982358826348038294681550843703310273070081923982242"
        "4439957691616181100303330772215901239585323902676066296819580790845192120845067451899423427499614227384357"
        "197735206849382499731433982770651655573173817676384638747710885235686628647044926765374839305877685546875e"
        "-251"},
    {1e-250, chars_format::scientific, 631,
        "1."
        "0000000000000000539995372538838999812031814994308058922469316265167934339105300857597200312381001123680024"
        "0744717132970355223235308008810593820667427471572510979116211218948405984136076892745036963302114054612243"
        "0854461935345268108985798815672273304709482272738880744620602127696868089805350874783651571183064358760376"
        "9262616075337441004446134274203111569857542644863728599183662806314628077729690816195581934052293080210797"
        "3863731922441113013326115432571346373407228177654197196588592111259890748199350234982379594256699490932245"
        "41146041021654331579356245397864401930228576603456024321655258579877312286043888889253139495849609375e-"
        "250"},
    {1e-249, chars_format::scientific, 631,
        "1."
        "0000000000000000539995372538838999812031814994308058922469316265167934339105300857597200312381001123680024"
        "0744717132970355223235308008810593820667427471572510979116211218948405984136076892745036963302114054612243"
        "0854461935345268108985798815672273304709482272738880744620602127696868089805350874783651571183064358760376"
        "9262616075337441004446134274203111569857542644863728599183662806314628077729690816195581934052293080210797"
        "3863731922441113013326115432571346373407228177654197196588592111259890748199350234982379594256699490932245"
        "41146041021654331579356245397864401930228576603456024321655258579877312286043888889253139495849609375e-"
        "249"},
    {1e-248, chars_format::scientific, 627,
        "9."
        "9999999999999997956832950416318242122534275228707458502381648630896999234860610340310794424258705217009089"
        "8698848272667425745548990609185184495845165310180177834722241204343829645092988625380078670111672151364882"
        "9148361416301640127480267399121644956345623511904149536818776665133120926859682212462165144835562834902460"
        "8169361510425185931465252898513762884440053713780975011971591647787756942772620690104203449664476602519718"
        "9700853992572437403223688846888917164691719696961858690320903760636693836791272914631037540830957849203000"
        "4110801975159454895427578925929868094239082518686308263637652071764705397072248160839080810546875e-249"},
    {1e-247, chars_format::scientific, 625,
        "1."
        "0000000000000000192649736373475651198801900840970646155428112277531424945149655606599677239735273509423103"
        "7003128723642002653851117166460958647495402365980414154482350572975195241643580478648423385033005529523557"
        "5149303231611552864074838513650889193807852976016263375515864045811208624482972303132848544723293923634315"
        "8654632110666477212506316748172301771864558583903767420123294440264563632118557400842506525812231884230012"
        "1580030211621974019257700376892867533502801947273791910395557968168320778089912861340050868842351094793337"
        "57196262799956722460189534377628286140100146030563490161247042209424762404523789882659912109375e-247"},
    {1e-246, chars_format::scientific, 623,
        "9."
        "9999999999999995575034302425255280203243435320108056671241964144246649104879042904899207640402287290675921"
        "5899384894415865269771681975930543308379850300405799608661482489098955982287298928717585561980642265042467"
        "5741558876413307019519396756689296767305879762949059005814858389345741736077657721142372963397136994038042"
        "1143185752681434215306504148588209983916734438626955498414779994873029315724848699111686364589771258651477"
        "4041185118384055729611699893665062262489939831496222442140098208008785470326559495369354852275425989964775"
        "225952548028109435657040565491081726672244441155999912507201798916867119260132312774658203125e-247"},
    {1e-245, chars_format::scientific, 617,
        "9."
        "9999999999999993034449077901454787489333206084268694718026300691819608966232037640460181737622108169253875"
        "4246623957614200762275886100458926041750180956646462834196673192837757408627896585610926246640877052965224"
        "5440969500532418371027801404761458698996819764063629106077345561839203932576831597067927969862816097115995"
        "4981931611088099051403838815334286890025193878462668017287514231763986513540558575386334807176752225192019"
        "7337538319249781944425578343559617033474707974999543777413905618539016546097531848156893317816192006777335"
        "028483055241084311512275416582382971737136376395860271060200830106623470783233642578125e-246"},
    {1e-244, chars_format::scientific, 617,
        "9."
        "9999999999999993034449077901454787489333206084268694718026300691819608966232037640460181737622108169253875"
        "4246623957614200762275886100458926041750180956646462834196673192837757408627896585610926246640877052965224"
        "5440969500532418371027801404761458698996819764063629106077345561839203932576831597067927969862816097115995"
        "4981931611088099051403838815334286890025193878462668017287514231763986513540558575386334807176752225192019"
        "7337538319249781944425578343559617033474707974999543777413905618539016546097531848156893317816192006777335"
        "028483055241084311512275416582382971737136376395860271060200830106623470783233642578125e-245"},
    {1e-243, chars_format::scientific, 616,
        "9."
        "9999999999999999538347252682384048836943392928017461318258399130032831721168371117424088048739366720094313"
        "6077691955826461901465123541666266244322134476670364976826584991266425757195966583963974093910675995882966"
        "7010478302787493311166285505696724153868013361210329649405378400255940709538946474698507153310677593236434"
        "8354742213567037070994662068464330010387537712483243968973314585323136087132341292123234794154080950848231"
        "3698874125033522834502049511829556819753701527631041159112958647581624992123842625020794846031831003737181"
        "93400495677586862932287419778865178437101302218181775316452331026084721088409423828125e-244"},
    {1e-242, chars_format::scientific, 607,
        "9."
        "9999999999999996936787982770012344297899318190517954678165559754747542619193837726638525524292463299758138"
        "3345264756541557445789428565183330163293353068660804119774620271894958417768738584622754955002756418715869"
        "8382674781885463335110891865322617971919535922351649432074165264889245998754100523646275479931532994788259"
        "1005617972575461863158332767212312762242600178875013588298994443899476257695628205428474799363149460585746"
        "7154339802720026478471461044521580905242104106578442206433337435964581613713318314275234234745575404953243"
        "17179619616195490219863468530614425931746236386743476032279431819915771484375e-243"},
    {1e-241, chars_format::scientific, 607,
        "9."
        "9999999999999996936787982770012344297899318190517954678165559754747542619193837726638525524292463299758138"
        "3345264756541557445789428565183330163293353068660804119774620271894958417768738584622754955002756418715869"
        "8382674781885463335110891865322617971919535922351649432074165264889245998754100523646275479931532994788259"
        "1005617972575461863158332767212312762242600178875013588298994443899476257695628205428474799363149460585746"
        "7154339802720026478471461044521580905242104106578442206433337435964581613713318314275234234745575404953243"
        "17179619616195490219863468530614425931746236386743476032279431819915771484375e-242"},
    {1e-240, chars_format::scientific, 607,
        "9."
        "9999999999999996936787982770012344297899318190517954678165559754747542619193837726638525524292463299758138"
        "3345264756541557445789428565183330163293353068660804119774620271894958417768738584622754955002756418715869"
        "8382674781885463335110891865322617971919535922351649432074165264889245998754100523646275479931532994788259"
        "1005617972575461863158332767212312762242600178875013588298994443899476257695628205428474799363149460585746"
        "7154339802720026478471461044521580905242104106578442206433337435964581613713318314275234234745575404953243"
        "17179619616195490219863468530614425931746236386743476032279431819915771484375e-241"},
    {1e-239, chars_format::scientific, 606,
        "1."
        "0000000000000000759277475233108684608982384831531593387598582983591608678088152649529618962442697970945511"
        "2253728656481252609623707518885743635118724171586796539025946776244048864006266446992438854796959500679229"
        "8588215800350017811703378421629495689318049951191680360226281426735122753412882953915621641409250927003198"
        "6910763086367695391445593758514057541064426431653432522754100974317078691906840500853021173802680484470088"
        "3860075238691610755277275140661505025108160714320988751660906591874799129168282589108905049857407833757225"
        "6341803279636545528499519728434495081936805860323147499002516269683837890625e-239"},
    {1e-238, chars_format::scientific, 601,
        "9."
        "9999999999999999067985336682227244656284224215477550517729613770981251451531375480370058344319366581697533"
        "1183669118195751175878957889918151400872130798102236373871589770004064462227523761683081673596124136331155"
        "5882571426208406291495470335517085756171728640264680266111895065381642305829046326748263666763728249837004"
        "6626020550795760273417853730797965291922933006406875916147397503753738389970183566048822187095880537408774"
        "1443622319559242693331719116940274774410004713904731268468483132521263549307219829637997487511275991477045"
        "80579761285687302745881169393181442384133106315857730805873870849609375e-239"},
    {1e-237, chars_format::scientific, 601,
        "9."
        "9999999999999999067985336682227244656284224215477550517729613770981251451531375480370058344319366581697533"
        "1183669118195751175878957889918151400872130798102236373871589770004064462227523761683081673596124136331155"
        "5882571426208406291495470335517085756171728640264680266111895065381642305829046326748263666763728249837004"
        "6626020550795760273417853730797965291922933006406875916147397503753738389970183566048822187095880537408774"
        "1443622319559242693331719116940274774410004713904731268468483132521263549307219829637997487511275991477045"
        "80579761285687302745881169393181442384133106315857730805873870849609375e-238"},
    {1e-236, chars_format::scientific, 599,
        "1."
        "0000000000000000452385056269749738957374958363937411586701359205253954606231547212992278236358823898346238"
        "3764998428403048712490815296123929376907380178547230294435983168516337593604201381495751807319514549342628"
        "7108230683567514025983999121921492328385734199812203920124848335464217685194090758268935342505414810276179"
        "3301425115103972420368222739757723576790458504488844347543930933698064944859304528923691149969167209407572"
        "4362418556266763620337397978233213107947983026866003126727845611570636930442760770896667141459146949297798"
        "054884123959586342812486483601353004502243493334390223026275634765625e-236"},
    {1e-235, chars_format::scientific, 593,
        "9."
        "9999999999999995794466201073065157705805008561139611308159226802046274685060917490638423932758043140638622"
        "7303880018694909606461440847125465979951128205680196431578644620908477577938829729718419833836711322074076"
        "6762730180528365910488757805298383239560360625550264905029942091825321578161929573183609811789476338082131"
        "4793082190649381915259229530730403006333941783317935380572250403817591754796466532135968599538405603408604"
        "0135284373694206587306362717705160991368109381051551269182499342610200096234987102040793131263159890576484"
        "959971436813478787059179808682785051132668741047382354736328125e-236"},
    {1e-234, chars_format::scientific, 593,
        "9."
        "9999999999999995794466201073065157705805008561139611308159226802046274685060917490638423932758043140638622"
        "7303880018694909606461440847125465979951128205680196431578644620908477577938829729718419833836711322074076"
        "6762730180528365910488757805298383239560360625550264905029942091825321578161929573183609811789476338082131"
        "4793082190649381915259229530730403006333941783317935380572250403817591754796466532135968599538405603408604"
        "0135284373694206587306362717705160991368109381051551269182499342610200096234987102040793131263159890576484"
        "959971436813478787059179808682785051132668741047382354736328125e-235"},
    {1e-233, chars_format::scientific, 593,
        "9."
        "9999999999999995794466201073065157705805008561139611308159226802046274685060917490638423932758043140638622"
        "7303880018694909606461440847125465979951128205680196431578644620908477577938829729718419833836711322074076"
        "6762730180528365910488757805298383239560360625550264905029942091825321578161929573183609811789476338082131"
        "4793082190649381915259229530730403006333941783317935380572250403817591754796466532135968599538405603408604"
        "0135284373694206587306362717705160991368109381051551269182499342610200096234987102040793131263159890576484"
        "959971436813478787059179808682785051132668741047382354736328125e-234"},
    {1e-232, chars_format::scientific, 591,
        "1."
        "0000000000000000249863339080062911178038644222122371080935937931442510710279241545360881120763563354792727"
        "1204968809447263314062851575076488572199734151496053423339459628625623951696207510718204728166398876567257"
        "4288016505168108861079050506718628599358044231968538756452578178166866642842418468448402090677674425335611"
        "1758693995222916479276809189246877056722019580820408559743015166448682006363223901758949274685611426824095"
        "2441476048682580053244629262333867401903791102273486390772019414434805804812691972815986765285930166522083"
        "3572223445350350191397625909672797206440009176731109619140625e-232"},
    {1e-231, chars_format::scientific, 587,
        "9."
        "9999999999999998923077556279261669607276344269178857742052631307823063146668949873357937994367585330706658"
        "6851923787391180589072742468823861859572694416677687405759422064737433149483010905868112642822774129086708"
        "8950866453732969837296239860846071191436398749479988812794667280418882508284315291790468322783534698543322"
        "2763549146053280591430031966208307868080860328264805481772604325463231632253160358680946534953336313663699"
        "9465706559822283761704996673667467070947350147170430500500090250087867140451222327563027908008026052077180"
        "979022374130685442417121322478124056942760944366455078125e-232"},
    {1e-230, chars_format::scientific, 587,
        "1."
        "0000000000000000464396689151344957708425250099245062264974342811838633347646649480175933513559646247825963"
        "8716834667872150467156197971992950003945212977393024232997570081916752333744951362797040806496871754762409"
        "3523774421044995987488706419099041487486686846180862681556445048241853678050810632010015245717266998624378"
        "5448097443593469531357092784822504818670379709616765366682468006790097312245968621293462047399778104098730"
        "3938419284302791059489107019314139818789224754807352395205225648090417259273233816851797149977006703310702"
        "512814408808214904078592866198960109613835811614990234375e-230"},
    {1e-229, chars_format::scientific, 584,
        "1."
        "0000000000000000693232262560712474007504296368175932861281974684261164160838551277311989399208801333728083"
        "0729491583525363430455767462037175531140390391683126429966221232093955941263611471681132623382709491503904"
        "7375249531313675588992339392304815234823905634674008201667236376321839848939762273142402611092832410132397"
        "0716794455188726120242728620103174431415297180332879294084551036487606971854229655463609004961555893191674"
        "5535158735631016132816549960093097063467020650843476133267312297323069477364478450489994893647488342551896"
        "278779277366273448013345159779419191181659698486328125e-229"},
    {1e-228, chars_format::scientific, 582,
        "1."
        "0000000000000000327095345105724447928977822337886539907189763688385114859731508401894299982170153196284692"
        "3509240518480222689176456277966414687628106528818962914816379391810430169233755297466585716365369112717512"
        "1212889354883788226586526635175577239084355573084975369489970251393861975517439647330582826491927751719567"
        "4286879236636315578025711283654103051023429227187097010241218188971591516481012000791373872862711430642963"
        "8980375613505856015492641254846765471982547217185678152367973658550825928418487036668878503774717719765986"
        "2532354876733797777177414900506846606731414794921875e-228"},
    {1e-227, chars_format::scientific, 579,
        "9."
        "9999999999999994483667432137531853405142846651919968173684572982825965370746055008918453812773976664205546"
        "1806379623718849101061094361965886631986252579449704784567589751299683163621004793516731395237522036301698"
        "4232249314520585568125760180654060493094354252712965722645315515667150793038653453822153434497565715287762"
        "8550827121105302767048696761763317380829461396372195290172193549331544235852896295780095558254847205260583"
        "2488961204054717339152603622555696524198109764069629982095609254974414109481076434981991680800682250798021"
        "9193039241043496900829268270172178745269775390625e-228"},
    {1e-226, chars_format::scientific, 576,
        "9."
        "9999999999999992140391160425608486502573412858067853267494422609219249843660980606245241543726628584567845"
        "5596772807429948356873502783913017233507635857119058287608601973485118222629925278543631190326543612068785"
        "6793144185369306448728558535026937320361233858543155596710812316128092403135788648626506813051775901445653"
        "1399369722369875296859785808489260546321506496239188673574863325229045321464303305877790712822242644948835"
        "0538349222453692588279587908979174338697479788659722904339841966832055396226731386526846785614950264968197"
        "7558236700698302001910633407533168792724609375e-227"},
    {1e-225, chars_format::scientific, 573,
        "9."
        "9999999999999995889633195164685873546684506928231237117398663206989994686997099650522381174202385511988166"
        "5532143713492189547573649308797608271073422612848092682742982417988422128215652502500591518184109090841446"
        "0695712392011353039764081168030334396734226489214851798206017435390585826980372336939541407365039603593028"
        "6841701560346559249162043333727751481534234336451999260130591683793043584486052089721478465514409941447632"
        "1659328393015332189676413050701609835498487749315574228749069627859829337433683464055078617912121442295916"
        "4173920765250613840180449187755584716796875e-226"},
    {1e-224, chars_format::scientific, 572,
        "1."
        "0000000000000000188842045074720969281726225744049265127724544816342318643633489012136580458296359659586068"
        "0142873716319177545269388374861295393117868142201454771495799112919370837715281606083172804275621385687770"
        "2693982152263862758542091738083576971893101469828956572059834562621057530513170623824039675826626152702882"
        "9554943250110925357284565537410933697787459888079249619861975705749544080532085014387137886982187761584570"
        "7545289506591395555191133327745750663038010048636493634780383388550426764336480678810024954958759532602026"
        "627590152685343127814121544361114501953125e-224"},
    {1e-223, chars_format::scientific, 568,
        "9."
        "9999999999999997089390646281190637400800057030683519949368020198276633036864657744691065855954627728762669"
        "2711462403432106728597696196760677403094474374681383689185984160229479378003085214166818823098530044048697"
        "3944534218136807948895448410591421461173584131029794582684483073554583722610639117199712477545283988280188"
        "8583247748499098113898765741804068580802307245320098647828424758533523028653011700551458546375903476327247"
        "2418041727595056862123397096052789194474810296725446652560022479388716998619908128864112804247216219040786"
        "38909396659073536284267902374267578125e-224"},
    {1e-222, chars_format::scientific, 568,
        "1."
        "0000000000000000476783833342682112606713957768637813007397190494251111847601702954737064781916897791611948"
        "6665910201904757668715159627972431984802920565041444613042119531057224577664265456883067357455082414457510"
        "5873699390533971936733619876298237867358547303864542840334666315780417025464434651086480732669884805027801"
        "3972914335267534684821378915349249801611797386207593472909455643687259147132155320986333106388946209955678"
        "3727380706890529476578409498630033709192327460014863016495012072917359803021174598364193159679182279020795"
        "42079860630110488273203372955322265625e-222"},
    {1e-221, chars_format::scientific, 566,
        "1."
        "0000000000000000169645925856856893060060376942410028602413035104481732430035608082629881503388323784117675"
        "9708004617280138870373003624653886287005531314012122115392711085043513921718682682696513167396990650436454"
        "2482001003045855479995989862202599578862071747559917487508179112410433564183086355339876938703742242547888"
        "3927078511100484735448777978881712624199170721537360029658810376553696409425413660613858205688403865026496"
        "9133150093238119960431981583020131793294388887877935675999408142925964561757501084173080407977398016174108"
        "708042922444292344152927398681640625e-221"},
    {1e-220, chars_format::scientific, 562,
        "9."
        "9999999999999999239355998681967174227375122814278010784257107926662288959827321849441348805654645781222578"
        "1416801495804438316992788219990497287676199131886641172731843282325453969622164633472698153505172392196091"
        "7686422930553623146058858509260889480648913025162172052469893497144467951580077187425939035308281925639579"
        "8904098517668447759506972297076828822690693898011732750582941628468462192600203323158782851279699890831517"
        "4577656023161923475148392505322102605760380301683938036029249989328483687465622728201902066159706058967593"
        "37838375358842313289642333984375e-221"},
    {1e-219, chars_format::scientific, 558,
        "1."
        "0000000000000000317072121450052998442454095738999365116805429691571034550467333621241329477082039307714926"
        "8647799297899955893577238506246788221948278154506196914264427139130095036572562414306059178624874697166561"
        "2910016229040151379230052268968505957340380014586137656864892970028025625598133537298246759807490672538246"
        "6349079706700668711147626428386130469357231520579072082419120104777806523524649657592646158024664190592504"
        "0138380787791276528182266982512884712925399402503660799437298029321834277564064370984814528794254462340518"
        "3301656506955623626708984375e-219"},
    {1e-218, chars_format::scientific, 558,
        "1."
        "0000000000000000317072121450052998442454095738999365116805429691571034550467333621241329477082039307714926"
        "8647799297899955893577238506246788221948278154506196914264427139130095036572562414306059178624874697166561"
        "2910016229040151379230052268968505957340380014586137656864892970028025625598133537298246759807490672538246"
        "6349079706700668711147626428386130469357231520579072082419120104777806523524649657592646158024664190592504"
        "0138380787791276528182266982512884712925399402503660799437298029321834277564064370984814528794254462340518"
        "3301656506955623626708984375e-218"},
    {1e-217, chars_format::scientific, 556,
        "1."
        "0000000000000000820286869074829038147691322564690967085931469882169185788207623459701738560623254961593543"
        "2495631807748931332781026902083893493219520703392638894413217937078958575273805231533309563616052243338659"
        "9970974867100681381948985284062799729213005566035635834935809604029406528561494585049482415841618646905336"
        "1016177121015963348199695802694543380830079047974782555840977310449435712983375193946909035332432768524474"
        "9169568225199384279436574479448148011932581959092802554105295508219736240850467056635533661182457798588529"
        "84034456312656402587890625e-217"},
    {1e-216, chars_format::scientific, 552,
        "1."
        "0000000000000000417715070975008206383501541104137685510630637729690664798015391588933411293790282438490650"
        "1417365799869750981417996185414209276202526664283485310294185298719867744312810977751509255623110206400981"
        "0322207956652257379773838871987364711714905124876037292479076296828301806190805746848493891014316267411664"
        "5282499189563727638558040303247813051651801026058214177103491545912132361416394764863498733486217906178898"
        "1944618275272898078433128481899937372726835913821489150370897525101414670221344908114958355271895129590120"
        "6322014331817626953125e-216"},
    {1e-215, chars_format::scientific, 552,
        "1."
        "0000000000000000417715070975008206383501541104137685510630637729690664798015391588933411293790282438490650"
        "1417365799869750981417996185414209276202526664283485310294185298719867744312810977751509255623110206400981"
        "0322207956652257379773838871987364711714905124876037292479076296828301806190805746848493891014316267411664"
        "5282499189563727638558040303247813051651801026058214177103491545912132361416394764863498733486217906178898"
        "1944618275272898078433128481899937372726835913821489150370897525101414670221344908114958355271895129590120"
        "6322014331817626953125e-215"},
    {1e-214, chars_format::scientific, 548,
        "9."
        "9999999999999991294853170555815447380942404303671844696679748417593976294002496024747640399247703645613921"
        "9669145746563738570562978920712197817481457391341938411132808559707770852376293656497482700456956882004083"
        "4461538432173005728133703533459726557209837131653219566175297137847666946046014646053306115669486530319154"
        "9347298089165733677047427050182759982813113559251953651435370993927616364020573917965857675783303466730526"
        "8247784355081422352221012897456633272684485689532862584208239791227856442081540328491173763580945887952111"
        "661434173583984375e-215"},
    {1e-213, chars_format::scientific, 544,
        "9."
        "9999999999999995417188383097980764646245766459737448027760269658974031233570950381415311611617342282187547"
        "3910589667246545368520413459409764199735476351819671112511702776504860961416874815223117854304683340245916"
        "0464911595164867510407202793112181136390385649127508640932246203586979303121868349231428609901062896334351"
        "8460160107236627343777979364517278553598680503677613849707225222789602684066453511779979166688543657149232"
        "4631271842328641050496299912350310218151325193111111838448475138359469325323751129341864896105107618495821"
        "95281982421875e-214"},
    {1e-212, chars_format::scientific, 544,
        "9."
        "9999999999999995417188383097980764646245766459737448027760269658974031233570950381415311611617342282187547"
        "3910589667246545368520413459409764199735476351819671112511702776504860961416874815223117854304683340245916"
        "0464911595164867510407202793112181136390385649127508640932246203586979303121868349231428609901062896334351"
        "8460160107236627343777979364517278553598680503677613849707225222789602684066453511779979166688543657149232"
        "4631271842328641050496299912350310218151325193111111838448475138359469325323751129341864896105107618495821"
        "95281982421875e-213"},
    {1e-211, chars_format::scientific, 542,
        "1."
        "0000000000000000860866106323290977989521652535914737868721793763139020704019000432275185949120018591922314"
        "8748321021343152712198420398324197662294833702534841575692416427025554931034673452314515034661740800661978"
        "0367570571673882521368240042400003578976814090504523368015448321395277884576460019940142059144210726758298"
        "1962131856506348707731574677038773798011249472583972648417715875514795890821326821198516793758531226648909"
        "0505843180151974088497721836001007644364521160456150945201722824918063055169882569206407652018242515623569"
        "488525390625e-211"},
    {1e-210, chars_format::scientific, 537,
        "1."
        "0000000000000000438738980558973249501554588251133620087619148388021703078207190706152416416973367595537175"
        "6313997163865233296087579101561566864752022160981921747071217659225532903868917941661009994907733611338014"
        "3784825159783515874863433718211592230068725922315156166760336737063572299211892600734702315734897306878342"
        "0324974785855889196258366120050919096362807417474785044114678002479328491648628750791950753089834631150033"
        "5932174061457858893794332445675895125148716795289738221567522725371785895925880183199296880047768354415893"
        "5546875e-210"},
    {1e-209, chars_format::scientific, 537,
        "1."
        "0000000000000000438738980558973249501554588251133620087619148388021703078207190706152416416973367595537175"
        "6313997163865233296087579101561566864752022160981921747071217659225532903868917941661009994907733611338014"
        "3784825159783515874863433718211592230068725922315156166760336737063572299211892600734702315734897306878342"
        "0324974785855889196258366120050919096362807417474785044114678002479328491648628750791950753089834631150033"
        "5932174061457858893794332445675895125148716795289738221567522725371785895925880183199296880047768354415893"
        "5546875e-209"},
    {1e-208, chars_format::scientific, 532,
        "1."
        "0000000000000000979061701537299941966152430535653450847430534468171869639246307155589561418121080870910153"
        "8629931701436970148709455961417734285606820934169659127706352082009561098641084995297496445792862813672687"
        "8610739287003185182389585813172758756671078777597546184366879565008155448478538897317665187298818484324685"
        "9220535836288477370944073072995373114472813248014545177622566479964726762589682280912355285145766273388594"
        "1786470533386326343014670865292039149744946382702746507819298852791020659758203237288398668169975280761718"
        "75e-208"},
    {1e-207, chars_format::scientific, 532,
        "9."
        "9999999999999992500289944066545260794393352251899924160340990116913366439211345173906974144483983897166235"
        "2189411812074122203194500098779985388714648599688995096739219291006708753701504236607398029604493662017327"
        "1678140799002433983058991092970258715435496406938981280259425155854893708252707482521839982942707164963854"
        "7547404749041952119498108235731202565207945902873127503973233520114522955783109845270607825667850182252003"
        "0527218232152305055095879225203782710370117029811199918136152450494694154947694642032729461789131164550781"
        "25e-208"},
    {1e-206, chars_format::scientific, 531,
        "1."
        "0000000000000000287448618685041775611467192411468067474871960285579656441116238100310015816652007878432741"
        "7265535493345146977353453580801839986912678504489355280493380020846005009332711166642793788659897434684305"
        "8033569204162008468756111131622465602620067122836086961830504745239089017417231637691472711696999377193365"
        "7434217691734764507346368173226471971292005784923652206732469228783416975785133762358237484114173771323236"
        "6292971049317888008012637688183374798261772510814095901417025409694400162052829728054348379373550415039062"
        "5e-206"},
    {1e-205, chars_format::scientific, 526,
        "1."
        "0000000000000000010803385544138509069593097161793914125848530612542771161864210478198197576064378681441776"
        "8719777010108417708811052628555482267435021532617233741608191196380582573609361635180912725806711283088952"
        "9802701171025537783302721259002348340999662460931503272815954817331462444992708733840995721456271734340837"
        "6719690433913279361907286213318911514019682799687295018376430328310893061063314354936590363701536770497093"
        "609557125569051267401182441733990905766850296205863565885611603245575196297068032436072826385498046875e-"
        "205"},
    {1e-204, chars_format::scientific, 526,
        "1."
        "0000000000000000010803385544138509069593097161793914125848530612542771161864210478198197576064378681441776"
        "8719777010108417708811052628555482267435021532617233741608191196380582573609361635180912725806711283088952"
        "9802701171025537783302721259002348340999662460931503272815954817331462444992708733840995721456271734340837"
        "6719690433913279361907286213318911514019682799687295018376430328310893061063314354936590363701536770497093"
        "609557125569051267401182441733990905766850296205863565885611603245575196297068032436072826385498046875e-"
        "204"},
    {1e-203, chars_format::scientific, 520,
        "1."
        "0000000000000000364909283964494690243191939081376830412598520594029984319306805834501324924016544053590211"
        "8858347868651431172545325847430820148366422456613549311381232891696323291335249035452120486258789557131004"
        "5938212253440220260683060295956098435873780428169370394754578725053224457696098050769606268964403117192073"
        "6034285323924780348069311122000588899328256220789832219472160120915723671907243196436298677829712131554556"
        "674824299153355310153286540401954520562788798446562476933408003532122165779583156108856201171875e-203"},
    {1e-202, chars_format::scientific, 520,
        "1."
        "0000000000000000364909283964494690243191939081376830412598520594029984319306805834501324924016544053590211"
        "8858347868651431172545325847430820148366422456613549311381232891696323291335249035452120486258789557131004"
        "5938212253440220260683060295956098435873780428169370394754578725053224457696098050769606268964403117192073"
        "6034285323924780348069311122000588899328256220789832219472160120915723671907243196436298677829712131554556"
        "674824299153355310153286540401954520562788798446562476933408003532122165779583156108856201171875e-202"},
    {1e-201, chars_format::scientific, 518,
        "9."
        "9999999999999994583981840083828664387789037672445647185185462414227186362537617223653189132590007008902182"
        "5036064707813167053855864071099551731820360911829814527622461516880270539569772907578286195014691755833524"
        "6313038824586331185893923613544981929960384320404305625917015212855137051754213994323632673435867770929096"
        "1889224054953378234945273557754947929383082627673369846670918518473573081467853621970453936615832072474512"
        "2774033477753696070790004781196766668518623271037326465104921879856192390434443950653076171875e-202"},
    {1e-200, chars_format::scientific, 514,
        "9."
        "9999999999999998210026239908275959605441178928974709961505359824656249094749793672197213175620180419702157"
        "0455030299293624922494821832383011632557906373552085962098408476913455489082859886355453662043973282024133"
        "1540672308512679754268595351951382901471352304920064954568524027925980061836920599672604679919133131325752"
        "1270675728671148333244408622655324354942874459763350785891191594747038536509684958927467073288347769702934"
        "065739205278643004860546448479624082362272590048489495639927326919860206544399261474609375e-201"},
    {1e-199, chars_format::scientific, 514,
        "9."
        "9999999999999998210026239908275959605441178928974709961505359824656249094749793672197213175620180419702157"
        "0455030299293624922494821832383011632557906373552085962098408476913455489082859886355453662043973282024133"
        "1540672308512679754268595351951382901471352304920064954568524027925980061836920599672604679919133131325752"
        "1270675728671148333244408622655324354942874459763350785891191594747038536509684958927467073288347769702934"
        "065739205278643004860546448479624082362272590048489495639927326919860206544399261474609375e-200"},
    {1e-198, chars_format::scientific, 510,
        "9."
        "9999999999999991248020992245337152787549067716438909430971156796632448648902414890992687013002247470966205"
        "9250616363651145814708022930718768623141819087045324807904590313649740386017732887103292125347752751738164"
        "7903616019374090502989225614211093036170293774649807043557627102989961482478123917402578427471263639364172"
        "7258288515133029744510069298046601617868074142150587382588267288301984862829368791970001850877117631024364"
        "23213435887235808111997818538852504458228488519455634531141186016611754894256591796875e-199"},
    {1e-197, chars_format::scientific, 508,
        "9."
        "9999999999999998674159923085805213393300653009810429996874306693191169124472952257610848253128042616284553"
        "7868657895003123529680608425827294499852312192652536705711329687797703162620535019638931097823721317376531"
        "0449809394455252371020553334467402225824756206938082148635917156255047967127507045157273096748991097456524"
        "0871501542907022905826697910962572537414527814270868346111386548510042114755039370057964754782429778948172"
        "054646195039061999776584332685697351547605103705418372328495024703443050384521484375e-198"},
    {1e-196, chars_format::scientific, 507,
        "1."
        "0000000000000000461507106775817966187790192124450764644959682661043814550492938215090537724522867873253923"
        "2076309112008470570165867682191411520122070667713830622395672118711607338390277672566744227580449616988722"
        "4048676409452018186544561551067244957754832615276870223269854919886711715484701354736102883217117306393040"
        "5176207196512621743488000080129534927305169075196709311692988195667648791629557583252833507790667949728721"
        "83126556639724251347018692505234351971198612785141079939421615563333034515380859375e-196"},
    {1e-195, chars_format::scientific, 504,
        "1."
        "0000000000000000936779998349607922066558293583226541961177484254423572660929452606554100043890918762554297"
        "4707863770014997143924113153878357176231542226472692183855303438657076956092857009049025121818911605189577"
        "8451632785457212546098566525163648745892718210943319829994865483295677250502261874912403342050891863710951"
        "0047452830290157305812264311356157066156142110212407293358467828320964455752800500250463133640607927195845"
        "53190632391191156426420971847936254735776662183610596912330947816371917724609375e-195"},
    {1e-194, chars_format::scientific, 503,
        "1."
        "0000000000000000176343371831543992660529331249185298255229001705015959684231029580212400332902037339673698"
        "6497376317204554625910920399179244126456387732458513685519893326744325567768730070677375691037372424068209"
        "1406902583848901570812158566609402684872101257877000459234848581841332394474165042630322607916852572002294"
        "2253459816246100406093441541393561643994585254187290522693700416075659393155611833054255732280703963248447"
        "6108811118884410829937732489961321031245178314605936975567601621150970458984375e-194"},
    {1e-193, chars_format::scientific, 500,
        "1."
        "0000000000000000480518022438769564422940916182801795737608394724779004874910398790749080217297589908825938"
        "1781571298328731633116197501058889346366449530064185084854057371509426123098380846026035463349988096516756"
        "6224794664492225960926721750031101109280348039103528207538855342423070336885403775543154901570468288685756"
        "9371057021863723165980970649378599812859207996597337230959607380973781418194487299932738692824665548827406"
        "7792911966978292755019478367894242808178173476107986061833798885345458984375e-193"},
    {1e-192, chars_format::scientific, 497,
        "1."
        "0000000000000000967197463410330479242799452076588191709415423556399877179997389527607768032330474019469521"
        "4236283268127414844644640864066321698222548406233259323788719843133587011625822086583891099050173172434432"
        "5933421993521544985110022843505818588333542889065972604825266159353851044743385748203686571416253435379297"
        "2759212550851919581801017222154660883042604384453411964185058524810776658256688046938311429695004085753741"
        "4487473323928503835150271772586917651270965734511264599859714508056640625e-192"},
    {1e-191, chars_format::scientific, 493,
        "1."
        "0000000000000000188510357855833015531025794646529958154524177425806481491858204348633867528277859442439788"
        "2308744116449521706199131483254429935252790204362740541493259888534929589981916101691322081929877050966151"
        "0399618267074634546416741093946270621848431129126061569167008852264601912170614591946835899662997200669632"
        "7338163704470805316488942705712963170749170163883692391024336694671584274157166851729395050702462426671605"
        "977617515280816610694100232507863790232249812106601893901824951171875e-191"},
    {1e-190, chars_format::scientific, 493,
        "1."
        "0000000000000000188510357855833015531025794646529958154524177425806481491858204348633867528277859442439788"
        "2308744116449521706199131483254429935252790204362740541493259888534929589981916101691322081929877050966151"
        "0399618267074634546416741093946270621848431129126061569167008852264601912170614591946835899662997200669632"
        "7338163704470805316488942705712963170749170163883692391024336694671584274157166851729395050702462426671605"
        "977617515280816610694100232507863790232249812106601893901824951171875e-190"},
    {1e-189, chars_format::scientific, 491,
        "1."
        "0000000000000000686870105410711392306560935401767227629654574949386254732267282863177163850871532771738817"
        "4742369173523373314804257486974040663553435453559872562162354259478070339834015932022566252886866568705851"
        "2341252652000657227180441413664381320398902655487604631988293528801721357017188131951220329585081190883818"
        "0407634966154718446288670396235649706616968065048312917847198665960667399980860416663101533257689088484172"
        "6791405982325182252994934771483936941649517393670976161956787109375e-189"},
    {1e-188, chars_format::scientific, 487,
        "9."
        "9999999999999994908067112790032880452765975891977808893416208927947989552854944282732526766467167814211472"
        "9016690365461294541519550780469749156318868554867557125565277692145325401889763392275802425900917261305707"
        "6813301281782027933475606463409156438777709922199012812172103051126346893854116359406976977720796143697733"
        "0409039381133269347693239389812020205342531022532236534723299348668678980039958608222059751251451001340125"
        "954851991484343502465496900111219247264671139419078826904296875e-189"},
    {1e-187, chars_format::scientific, 485,
        "1."
        "0000000000000000128707188149247610317961577755901485817508529722976908703009114926888671969566618642923904"
        "7216709109600659513166516362808076647856712774459084699012968564021752699999664122051572781415038308837387"
        "0166622140883511824725097055580097338022374545962676401628454691080147578789025767146309768072347121843930"
        "4969827153068735740912975382850240786445034415743937927805593258116894299058323623937350272795835227254097"
        "9734347453266124169414530431510002017603255808353424072265625e-187"},
    {1e-186, chars_format::scientific, 482,
        "9."
        "9999999999999991080664251568566946816656094891755579324414755946855331066513221291040011008947756645194928"
        "3126449927134114187432183071903138762969913041033583206826632923302004443025636695331847192951237765064810"
        "1901549205550173745210388007974066273910088599742362089704636735321269557432431572173304555919191098852789"
        "8835500091400816510831330726597787609877843141587950888723719409168520573713992029531193965227310238619613"
        "6871547144152751022960767812719495850615203380584716796875e-187"},
    {1e-185, chars_format::scientific, 480,
        "9."
        "9999999999999999245790355507694271907023841025563002404951188973186335837375563673317377958322500472430223"
        "4358962862232098942818567516845240935447684803879394233469075096834422488602440315478951689910554023712058"
        "1713286968178129346842854046235591958961014087649883630968564875705434541798692451605139055762615194522001"
        "9525717242830049229470069208121483813535843954269093600189489946768858507209387397405040975412143865756706"
        "52490890549595435599083970146239153109490871429443359375e-186"},
    {1e-184, chars_format::scientific, 479,
        "1."
        "0000000000000000577789123865899613197931803793260894086938033539425113965406543757913927151782229553421845"
        "9534497321031048674712767507279892267342990221415604305478302883566035692506388321159663528747800703062985"
        "6556267717828049382814882687684481250700175447797590086397970738801276652929170115515060665563735447105737"
        "1607789096397343540438105999334044077646224460441400776936210637684912885400570369170411858356001076746638"
        "0795112258360497758946650037614745087921619415283203125e-184"},
    {1e-183, chars_format::scientific, 477,
        "1."
        "0000000000000000055221053213795464392148268040697219009783701825739929660071353845448175667022245948478787"
        "0655616493184777650368038902803597728304412828593472399773186584459960937589472889470248840942404462509561"
        "7848316501019860224310404861235743606856916216571508707757079337816690093929729419231423257573756304982907"
        "5883615198705872646445226736516527520612112408429807643402401323278491257656865065626485649704171724609864"
        "13789495760688630365820017686928622424602508544921875e-183"},
    {1e-182, chars_format::scientific, 473,
        "1."
        "0000000000000000473275509735478783436775096642748159071507167196688077104339505775420776854830232832433234"
        "1758721155461794469843821786384633359535274742851177924337279623744820741523005234821780591186721454952300"
        "8814677474466411551113987122394733721931523601552373810669792458604359341129281976258333183965739618681171"
        "2462954316859049361639530146770540766239402050039082150229448774803628559851829308461626616625635206319283"
        "2911879721902170814473720383830368518829345703125e-182"},
    {1e-181, chars_format::scientific, 473,
        "1."
        "0000000000000000473275509735478783436775096642748159071507167196688077104339505775420776854830232832433234"
        "1758721155461794469843821786384633359535274742851177924337279623744820741523005234821780591186721454952300"
        "8814677474466411551113987122394733721931523601552373810669792458604359341129281976258333183965739618681171"
        "2462954316859049361639530146770540766239402050039082150229448774803628559851829308461626616625635206319283"
        "2911879721902170814473720383830368518829345703125e-181"},
    {1e-180, chars_format::scientific, 467,
        "1."
        "0000000000000000205720657561601459248213926337435557432004149359281262740007888540238312094633121226702388"
        "0252734171604503705379320740892770555547523117726246388616260078602510467005544533796800271030358579788947"
        "8596206451460618701959694475252980048283774875164620144805656061300251022921568339761110831074870297914282"
        "5052177281241016263915175964207972289037936679409146465860138405827540686447052193047136397795898578025255"
        "0330804428568853836623020470142364501953125e-180"},
    {1e-179, chars_format::scientific, 467,
        "1."
        "0000000000000000205720657561601459248213926337435557432004149359281262740007888540238312094633121226702388"
        "0252734171604503705379320740892770555547523117726246388616260078602510467005544533796800271030358579788947"
        "8596206451460618701959694475252980048283774875164620144805656061300251022921568339761110831074870297914282"
        "5052177281241016263915175964207972289037936679409146465860138405827540686447052193047136397795898578025255"
        "0330804428568853836623020470142364501953125e-179"},
    {1e-178, chars_format::scientific, 462,
        "9."
        "9999999999999995207802359964755093254973303558352972348764236955198179673189484181712023085285155160314218"
        "7974074929298393483501980644336017773388789574064216571704500430381961642408451391728506514300696193707641"
        "2369206325657890081247052985700906437455381356119707601934668842017337283098214303282216076742448367510473"
        "2805880700588515337408292568477969874021853305965111138747038612487557305308227775860414375917728095925426"
        "92325167763556237332522869110107421875e-179"},
    {1e-177, chars_format::scientific, 462,
        "9."
        "9999999999999995207802359964755093254973303558352972348764236955198179673189484181712023085285155160314218"
        "7974074929298393483501980644336017773388789574064216571704500430381961642408451391728506514300696193707641"
        "2369206325657890081247052985700906437455381356119707601934668842017337283098214303282216076742448367510473"
        "2805880700588515337408292568477969874021853305965111138747038612487557305308227775860414375917728095925426"
        "92325167763556237332522869110107421875e-178"},
    {1e-176, chars_format::scientific, 455,
        "9."
        "9999999999999999591421057981561172760359517840594637610381681203271426218398700962941525716354631708608402"
        "1288165672816245368488365773674697953924112200111094852957684657993573180102527517321784079742545540384017"
        "1468635566584800121790983716471398626500096489256663663452679575447847968613394523652707106506451318955178"
        "4144051652154369610524111495583091804490661938365977391453819697791781023172096034811422121224133013894785"
        "9040854382328689098358154296875e-177"},
    {1e-175, chars_format::scientific, 455,
        "9."
        "9999999999999999591421057981561172760359517840594637610381681203271426218398700962941525716354631708608402"
        "1288165672816245368488365773674697953924112200111094852957684657993573180102527517321784079742545540384017"
        "1468635566584800121790983716471398626500096489256663663452679575447847968613394523652707106506451318955178"
        "4144051652154369610524111495583091804490661938365977391453819697791781023172096034811422121224133013894785"
        "9040854382328689098358154296875e-176"},
    {1e-174, chars_format::scientific, 455,
        "9."
        "9999999999999999591421057981561172760359517840594637610381681203271426218398700962941525716354631708608402"
        "1288165672816245368488365773674697953924112200111094852957684657993573180102527517321784079742545540384017"
        "1468635566584800121790983716471398626500096489256663663452679575447847968613394523652707106506451318955178"
        "4144051652154369610524111495583091804490661938365977391453819697791781023172096034811422121224133013894785"
        "9040854382328689098358154296875e-175"},
    {1e-173, chars_format::scientific, 451,
        "1."
        "0000000000000000408024660475077059817387500126561010283827794411329843068069293894692053641056977569406164"
        "5860179459417852569871442414611750645879228256918309821296094530706786339470126146992930030675499927138062"
        "6078645110929395600330796878478038262808188478558890667044712256648069091058093906931208992098479034123455"
        "6471433870655780438619471007693873666129072197794446443422556352914330611026469713197725405241789164989540"
        "950045920908451080322265625e-173"},
    {1e-172, chars_format::scientific, 451,
        "1."
        "0000000000000000408024660475077059817387500126561010283827794411329843068069293894692053641056977569406164"
        "5860179459417852569871442414611750645879228256918309821296094530706786339470126146992930030675499927138062"
        "6078645110929395600330796878478038262808188478558890667044712256648069091058093906931208992098479034123455"
        "6471433870655780438619471007693873666129072197794446443422556352914330611026469713197725405241789164989540"
        "950045920908451080322265625e-172"},
    {1e-171, chars_format::scientific, 446,
        "9."
        "9999999999999998334549904886182533644575182481590307346570727588463864968956314327427402721974391392681493"
        "8840349574834806876025069429390711572561024496770933912156771676252771920014882010591679536179058495704966"
        "6459647214626236474966227897344883106057195766283635621494235537958651944862482050868079918452516392716952"
        "5584371276921407873336343892803511244586645127284001019477731425013353998786167727604989180489880595814611"
        "2971007823944091796875e-172"},
    {1e-170, chars_format::scientific, 446,
        "9."
        "9999999999999998334549904886182533644575182481590307346570727588463864968956314327427402721974391392681493"
        "8840349574834806876025069429390711572561024496770933912156771676252771920014882010591679536179058495704966"
        "6459647214626236474966227897344883106057195766283635621494235537958651944862482050868079918452516392716952"
        "5584371276921407873336343892803511244586645127284001019477731425013353998786167727604989180489880595814611"
        "2971007823944091796875e-171"},
    {1e-169, chars_format::scientific, 445,
        "1."
        "0000000000000000201179579279951889494332706650336297646126334616435798702446775408390300828267543734556479"
        "1148767438721478692254625644809586029974902966311471906467144279997443046381416486456775682934766059213738"
        "8682880170721357697310494206530360280015299673863900909282408323621275688292229454267224632007317171976821"
        "9062755043188870164156569825065005551127725431170669760491634397165652335013242654640323869852380767042632"
        "214725017547607421875e-169"},
    {1e-168, chars_format::scientific, 442,
        "1."
        "0000000000000000495359250313018798398232857372078111175301744102507328466887690588908349273123627410787142"
        "8960553423711877095976320606305997928149943379618974718668317969895175729885359114774861866388254226928332"
        "6312412530128344937161591339967057855542963751652330786988796139481604083337014453611557944136969598140923"
        "2266209375586253665614918173692729092462974165924485487326723400897105883120943360144183831295094933011569"
        "082736968994140625e-168"},
    {1e-167, chars_format::scientific, 440,
        "1."
        "0000000000000000024671776660111744151992616217291209528621088924792880843782226300079471761353893528818080"
        "8461695847727239650021608667911738891069878718326970219146440066058803436279050909465923972862673158584982"
        "6105160755077165353399835926468341734698701227190842982658575634105078651265358454660624644729525716278361"
        "1140682443750440063281560815888371426326576190318380324390580994926780206148622231338007892986752267461270"
        "0939178466796875e-167"},
    {1e-166, chars_format::scientific, 438,
        "1."
        "0000000000000000401221755582437387548984809141120730845965613066964438942266597731142573770769680634393330"
        "4860781908514949606785378218627146120733930447360573818763942389127901271164097473713074287683138013259662"
        "6270962175118109020409240257267314631374111246760033226122752038406298996922683253821371284255480821768410"
        "8041103989219090945148246702131857559235694570803264454739494919703040747726479134382948643633426399901509"
        "28497314453125e-166"},
    {1e-165, chars_format::scientific, 435,
        "1."
        "0000000000000000099981772444576872831391054802057113792089993753227192463479100586292092163237050949933130"
        "7741513059884781641374362578054820337002689064133690939069940530672623003256060222315354035826766129519918"
        "6138321039085354086801716792628136314033783231104681031351410914965322720396823414492773972634716737376371"
        "0520766752844170239654897993137068652908399866415357150460363779882032314464193611946996043116087093949317"
        "93212890625e-165"},
    {1e-164, chars_format::scientific, 432,
        "9."
        "9999999999999996179977994240000492832410478595553265058890028512475980974191051545313215911848434547968112"
        "3506829020765128967167375531390990830327028509706783315595375571441777746032006200790016328565711155363281"
        "9260952214329461930296792492054510062892584060561175197172651174597606779554476715670182740414942023491074"
        "4882271746442971108655400587454064027847283393947054636137539561684188212445367760494718822883442044258117"
        "67578125e-165"},
    {1e-163, chars_format::scientific, 430,
        "9."
        "9999999999999992324106210075385904447210423055538966769282101296639226045711088091227051335430774586877556"
        "0380187758298979009906375332065220798567138804402682455512151783214215916809129382899197104804151043494558"
        "5563145673110198780120492144673027600936385460172667104099484794553110440023470772264137151669161743272965"
        "6621955120843986078340537112320766026857911177781841141364660971975280266688113073314525536261498928070068"
        "359375e-164"},
    {1e-162, chars_format::scientific, 428,
        "9."
        "9999999999999995408803637407077575155370467487550405400968443069308629988495058854495982996564902555750001"
        "0881500768271898975715175491525836823975050568645963143578730813796265380187430837211852483813399132989537"
        "2521390906085609300261532422578213570501344340483473578558017898588707511648275526988973622665785967447452"
        "7230208421323174102592427892427404427649408950714011937182963843742406623293916823058680165559053421020507"
        "8125e-163"},
    {1e-161, chars_format::scientific, 426,
        "1."
        "0000000000000000281207746300313758485495457412437785811701566332371519945117658868634141898328680968104386"
        "9208465199220690689365629587423131528495403880282983679493852048719318409229535432756222539343559454777748"
        "6122117946522659454860002908955065989745724565322940911725849734827414048354780693832858115305768410546622"
        "1669001634247322536079696576468333658954900360575122184714689073598350987914784582244465127587318420410156"
        "25e-161"},
    {1e-160, chars_format::scientific, 421,
        "9."
        "9999999999999998863664756018572246348509717251403216668457145854698362404413106109357186457035125880887139"
        "5442971339441569337421031670121726772431911744598437514213299328048160779171128466042026508303756993223913"
        "3914625567018069082819497533832021856414098286431576829951574975108576231868056852280790470182005098522878"
        "2311452117859864689754545566146839436535886456398043228499463060121588142692417022772133350372314453125e-"
        "161"},
    {1e-159, chars_format::scientific, 421,
        "9."
        "9999999999999998863664756018572246348509717251403216668457145854698362404413106109357186457035125880887139"
        "5442971339441569337421031670121726772431911744598437514213299328048160779171128466042026508303756993223913"
        "3914625567018069082819497533832021856414098286431576829951574975108576231868056852280790470182005098522878"
        "2311452117859864689754545566146839436535886456398043228499463060121588142692417022772133350372314453125e-"
        "160"},
    {1e-158, chars_format::scientific, 419,
        "1."
        "0000000000000000644461715342893769628088384244751452824968949939521068953419899265716691290743835877718806"
        "0499499819275101744539273894201213671647439569640272413320572395360660554036964212016080836775688509796677"
        "3034320905157843797711811812081180689521694123068341482158086593158645959509317701749254858130330879185409"
        "76318295429117517178155992347336913970321071383156146176302524197776477876686840318143367767333984375e-"
        "158"},
    {1e-157, chars_format::scientific, 416,
        "9."
        "9999999999999994315093317572352976389085242133736429719717733730390966126541574180671350586793186143106586"
        "9711755227455900472638007306987480806006421373515865542817844552713093922452020273570757392631880130378197"
        "6057475476281847746240325181644150833132392519880474034974000401221846213932984753153735603509222882524146"
        "59073461311052731967136774974327947162647755003431814598176263775286543022957630455493927001953125e-158"},
    {1e-156, chars_format::scientific, 415,
        "1."
        "0000000000000000401871238625762075230252412238475890854369514626224674485266750896186780044330932425037176"
        "5793834959969199405084179261500720553438080083182535241512814807342790321678611775084279817273188410444905"
        "7948606233651911993094255953297827568280003148852282666425949282551353691886113856462478598574449160998810"
        "7423610556951506838186752937735609011950981220659355323300554463372691316180862486362457275390625e-156"},
    {1e-155, chars_format::scientific, 412,
        "1."
        "0000000000000000143108063460821601205894042098448624752396783625375187052570059302021541381490502075510105"
        "1441125776709570242998744986620194560681429964294282258251206713457062073829702509023692063137188304469682"
        "8523843917378918068168863037262250905622199443021819929645002817903575273088029754823250588381508661599771"
        "7868176971927245633249316887604321134531113575159345409348876643207404413260519504547119140625e-155"},
    {1e-154, chars_format::scientific, 408,
        "9."
        "9999999999999997290869831969168427669206498744049989892404140240160071602553527513571595209458135162667908"
        "4767910834941635836620501468113529722707897740730774850326337632398968772714476833267516565195881349093261"
        "4442242113421277882882343716053282453697135136930795507954884744671298030110951922004857720728038625613094"
        "579483235888427705349419207394260530659325342359329547026192130942945368587970733642578125e-155"},
    {1e-153, chars_format::scientific, 408,
        "1."
        "0000000000000000391520711619164456269278077432874800210290605386190694987958883232420170497817315211056093"
        "7219726592638814238600761890505499513727814078427005122182350483587361191764655404441856307107748406205896"
        "8771615741000992236097240236656404501773691000619064156954711423965442555134190492396909478166731541022849"
        "184139321355053638998925549573035749685418651483935492674248735056607984006404876708984375e-153"},
    {1e-152, chars_format::scientific, 405,
        "1."
        "0000000000000000656494202988063501670221048456262720698710681931060570119040295424845374888565915888971814"
        "8716900796296674500576246587983158130310623800168576177042237171726346917561938492887898167343012514724525"
        "1702572352864538015220842582676835004335281995389457999418400603764767655983428612475478960604302612407465"
        "074615720461537986384519001106479628333213098383136507862900543841533362865447998046875e-152"},
    {1e-151, chars_format::scientific, 401,
        "9."
        "9999999999999993846214444173480837456947875440007023542943145156851694898495169012043938129726326349763533"
        "5304646187389452430939200400903967707131371358090351137147810686592154337349796683468972382137447938351093"
        "6339806159195182754275513217787685920396452204915675555926925407280071719070856360983454449039614697613088"
        "00329004750413118933670433745949010823799753266971634957371861673891544342041015625e-152"},
    {1e-150, chars_format::scientific, 401,
        "1."
        "0000000000000000062953582321729639972108793363873778804649710470552049825417932113812917053289050370440599"
        "4963230580103067513751160865633202829165130023467457014156090990295018891776024374768764400416020911642797"
        "7937229542290195469983973327591070678597318167103775792299736841014279430081135223499483319944143412505925"
        "47994858646301304824078966967156534016215353732892623384032049216330051422119140625e-150"},
    {1e-149, chars_format::scientific, 397,
        "9."
        "9999999999999997916207271599770174815431910359245482245075520886052976911905660287695077571624832762549010"
        "3901241955574186054882645354160804057843328684040882539795670216406975085596064922000175355351104645197224"
        "2159299717419245921614045252661498439742489884588924976169191208997705268115153885390281699280706354080788"
        "0810075377797307651794197530131880842681202370414439428714103996753692626953125e-150"},
    {1e-148, chars_format::scientific, 395,
        "9."
        "9999999999999993574881589011728214966382273112057792962800986774904942764267802927000528833599759255577835"
        "0731539802843803522676304070686845283750574203026982376971286717937832954133378800900225517256537491228018"
        "2618506588646911876452944415462765085773383026270792261244107687165562815801236526022999299023541920515241"
        "33144221481909121761385664308924357650265601904493451002053916454315185546875e-149"},
    {1e-147, chars_format::scientific, 392,
        "9."
        "9999999999999997047942135082161782845621982909807944388620614063823370082378088815556167824019818061154775"
        "3267301525028109548441377097466012303024777787838102507230793516713146659303527697780185387732191214403383"
        "0251141091664779112581825085221751768948668512925298433184174504631276777652370413516825219229273467367678"
        "73109447318760285566630713102839918271502739344214205630123615264892578125e-148"},
    {1e-146, chars_format::scientific, 392,
        "1."
        "0000000000000000260483900879485549145240551858620818666993201772609285379135454623724519020869191215007787"
        "9732452028052299918966549394031267953386350352353589471564600439475364858757576593278812118049323717148396"
        "6646335629649336669038803415683613046202912529157250830828828141257641911661418463350694669155844394233157"
        "85705380865772214765502279117310481526548215924776741303503513336181640625e-146"},
    {1e-145, chars_format::scientific, 388,
        "9."
        "9999999999999991491045261369468074238838447233407702107309210401553886373401631393867145439347723972231670"
        "9210082769533219907217260254619345072186052052140310298815582638672644731031289462772249594971145257322799"
        "4038925886836191534775616013607373075868211734278088558080067596686134438690556193526703746900102992403778"
        "8916508597979842347823863503257502127752331944066099822521209716796875e-146"},
    {1e-144, chars_format::scientific, 382,
        "9."
        "9999999999999995047459260545592047747179910066303857167348508745406355947146564143748119765537864189142457"
        "7406702773049949277600695034041212099922836522986897312201317600618565965125521933177328502338214669854372"
        "9214743617926487584571589819440575439439704072612302878146696017771025535626117294320381489190772096380674"
        "7888947723673401521480956499754455535367014817893505096435546875e-145"},
    {1e-143, chars_format::scientific, 382,
        "9."
        "9999999999999995047459260545592047747179910066303857167348508745406355947146564143748119765537864189142457"
        "7406702773049949277600695034041212099922836522986897312201317600618565965125521933177328502338214669854372"
        "9214743617926487584571589819440575439439704072612302878146696017771025535626117294320381489190772096380674"
        "7888947723673401521480956499754455535367014817893505096435546875e-144"},
    {1e-142, chars_format::scientific, 379,
        "1."
        "0000000000000000415187909843646941992853405491851801412104911250566867805593359198344341404058462314443407"
        "1999004998205277646578228806936119169092900476835416006646879910320012432440675705741433050519791236593520"
        "1126483700951764547204928276237357349018272445874789153751726477574834674378115371235219650945488500256152"
        "8285839188544891300604311457078665625886060297489166259765625e-142"},
    {1e-141, chars_format::scientific, 379,
        "1."
        "0000000000000000415187909843646941992853405491851801412104911250566867805593359198344341404058462314443407"
        "1999004998205277646578228806936119169092900476835416006646879910320012432440675705741433050519791236593520"
        "1126483700951764547204928276237357349018272445874789153751726477574834674378115371235219650945488500256152"
        "8285839188544891300604311457078665625886060297489166259765625e-141"},
    {1e-140, chars_format::scientific, 376,
        "9."
        "9999999999999998325050402186307901732467402213100953670680726099100791906309894166038425704554697413047438"
        "8736707768290967065346068526756404752685057091319111903737610941547926974466766577902649223367705840443471"
        "0752777238899304424063559278896454737707191411621114795520100770642861170561930404811834896485852742605782"
        "0477947621912585655923333405326047795824706554412841796875e-141"},
    {1e-139, chars_format::scientific, 375,
        "1."
        "0000000000000000298651335918643711628932072437743460203097543522435510082600885241996241637337863799815674"
        "5373938153930041458569504416084023430328021523294715043392256147086968485441875896151199424883187106083685"
        "5116242505539397726245213806567814973968761784932253618911783197472724962913730905084412418686107855057037"
        "903823030327416475360191583376945345662534236907958984375e-139"},
    {1e-138, chars_format::scientific, 373,
        "1."
        "0000000000000000671568372478654048793480338210890152071921120252455854796176801902310160890843779046624419"
        "0574152055610797260197422466810729794375634174624958125807052189432709115838035286839947026920320323715156"
        "2349014330858971553316300109510350574127195899948367330399601693799476039599761196766995561916125919694205"
        "6630578736140489704009581828358932398259639739990234375e-138"},
    {1e-137, chars_format::scientific, 370,
        "9."
        "9999999999999997765674847346292395985645003553380915867445361004070274835946019175567546824295824542834322"
        "0936386915769833362904191450666345206613638114323747280115416878029316028872527491869527820312006013996264"
        "9903619500919943683456929824482651337469540239096944228288373026152734555532884967287960181640825645650030"
        "4089424972613098230311834413441829383373260498046875e-138"},
    {1e-136, chars_format::scientific, 368,
        "1."
        "0000000000000000015234388133035855383875390450151974382791625207620048100283188580157663004673368212241028"
        "7021775588652667049332286697531726593651835908283730300757011154904205606340794759227751247334965860683767"
        "7619335918296521617671188216331487917848351857520007198181041140264394144632347883405649229831294125932790"
        "40680454942957577912920896778814494609832763671875e-136"},
    {1e-135, chars_format::scientific, 364,
        "1."
        "0000000000000000397101433570486440640372814601854186856466967779160881086984927240319116320263425424973183"
        "0906794623973760990199274781475873910436591263245899217149762302266244011866461975293028791820990275538393"
        "7825694267423765216591980590544644372410588391296507638744567280502987247158842902088614368498832624121250"
        "1922610289550874540509539656341075897216796875e-135"},
    {1e-134, chars_format::scientific, 364,
        "1."
        "0000000000000000397101433570486440640372814601854186856466967779160881086984927240319116320263425424973183"
        "0906794623973760990199274781475873910436591263245899217149762302266244011866461975293028791820990275538393"
        "7825694267423765216591980590544644372410588391296507638744567280502987247158842902088614368498832624121250"
        "1922610289550874540509539656341075897216796875e-134"},
    {1e-133, chars_format::scientific, 360,
        "1."
        "0000000000000000641496342650454815204531166058943602839619187024947014198474039982822446442241062041121761"
        "8993206806579261112354147155200128193178834690421687323641123036577948591402888993574806420292045901045354"
        "4357763610865201119901287710041064503330419772913467920705224010255686832775799714045712057246057262961864"
        "454953175851414926000870764255523681640625e-133"},
    {1e-132, chars_format::scientific, 354,
        "9."
        "9999999999999998594326335945560165992244413962574716935320854384313882417088792068117900519126248694463097"
        "1166878222416607214585555592825144884036557234591653828687686867804939368863225350731180091846678994230803"
        "4551417118526062293115049276525200843869593517391950184311224750470481588015379157829994532549384186718988"
        "143383057831670157611370086669921875e-133"},
    {1e-131, chars_format::scientific, 354,
        "9."
        "9999999999999998594326335945560165992244413962574716935320854384313882417088792068117900519126248694463097"
        "1166878222416607214585555592825144884036557234591653828687686867804939368863225350731180091846678994230803"
        "4551417118526062293115049276525200843869593517391950184311224750470481588015379157829994532549384186718988"
        "143383057831670157611370086669921875e-132"},
    {1e-130, chars_format::scientific, 352,
        "1."
        "0000000000000000860474181186106478814017048964495719560523575469171389466368285000105430231533024449190888"
        "5118632122193789221804912802057060030515884801171193467057382254521235894667527601955279175402111741499591"
        "1810497742588727689266426889109856940634588690842264333341972440114105661488593017559271586363570539363054"
        "8343253394705243408679962158203125e-130"},
    {1e-129, chars_format::scientific, 347,
        "9."
        "9999999999999992588077050396257392703488768553145229733371914199873875069132357308356059441403851215995624"
        "3155212422703836212507412136177871631363182768319485323556005461360487622175994949438213094542015941771738"
        "4419280934109333533385517507781179706383817482773534294846124960068136571893048547172361733897591462572052"
        "02346085570752620697021484375e-130"},
    {1e-128, chars_format::scientific, 350,
        "1."
        "0000000000000000540140885956810330905283414542659480243086298659334589074477275146251465374054496583672623"
        "2958009946209108101694078484369205457039971496303344480117025912844198468177541980552987602212529712035107"
        "7136783812753168822080851861443509146635347302329282152570500451292647260628735384990864503768808260741884"
        "90792948869056999683380126953125e-128"},
    {1e-127, chars_format::scientific, 346,
        "1."
        "0000000000000000283874249773373412578296507005190488789136477211465148760964467263168293488071674291258011"
        "1229512205421363205605411030218921798259240852409065290564740839502568526985553483431154343660864088463520"
        "9397812668884721728332391839310430911435954191518896407953322860235480539940849278936138837692998437844948"
        "9668128080666065216064453125e-127"},
    {1e-126, chars_format::scientific, 343,
        "9."
        "9999999999999994638210139863752739319384028852897161364970485782829397577234820373021434529266429555312521"
        "6983194349005795381216751769380140901609027919473718839974286048093527151711902926412879162955340930344432"
        "6331050085056910283373197684845805587978962369256620251783545688525470337396137395610167062504070045747539"
        "5523943006992340087890625e-127"},
    {1e-125, chars_format::scientific, 343,
        "1."
        "0000000000000000119863602615973784849024886181210334258608591484828706960316270217995063481042668024112659"
        "3323273651317206472108663859562740256639573240316726609251278392563925364622680845273181058187798089377705"
        "4044871136808915588333377425145260840908342600600249531398329201958893838700602171061114411404480151190909"
        "9644981324672698974609375e-125"},
    {1e-124, chars_format::scientific, 339,
        "9."
        "9999999999999993326124962604555717485211062261055925120747399969737863172049244011635594473034379418149707"
        "3733285916172541513242774404130688568651687022735009389466586472584381852808921821149092879170812937657908"
        "3507517828450461163381082371524445023758069641907445239343596422312776727474160532609971652195923752515227"
        "533876895904541015625e-125"},
    {1e-123, chars_format::scientific, 336,
        "1."
        "0000000000000000592214266429284712709327154154273179306528902377541659346183077708093965901286206073491272"
        "4893240687137177864579295711052543096504215963142662011434050239747217672227754043168144120350228166744854"
        "1461342749187237271530538937940950644027863982445952535876710937795463538272513841741184759115412816754542"
        "291164398193359375e-123"},
    {1e-122, chars_format::scientific, 336,
        "1."
        "0000000000000000592214266429284712709327154154273179306528902377541659346183077708093965901286206073491272"
        "4893240687137177864579295711052543096504215963142662011434050239747217672227754043168144120350228166744854"
        "1461342749187237271530538937940950644027863982445952535876710937795463538272513841741184759115412816754542"
        "291164398193359375e-122"},
    {1e-121, chars_format::scientific, 330,
        "9."
        "9999999999999997860691335212340624944112834802459237580782384539782206076370595916585057707372344692184393"
        "6804969460044266880960840178432795831352257161863989250421196205543988005817624520940738275930141680382536"
        "2705645307282349322073832894363067133705474907626194082336061086343845843364512571138646990220877341926097"
        "869873046875e-122"},
    {1e-120, chars_format::scientific, 330,
        "9."
        "9999999999999997860691335212340624944112834802459237580782384539782206076370595916585057707372344692184393"
        "6804969460044266880960840178432795831352257161863989250421196205543988005817624520940738275930141680382536"
        "2705645307282349322073832894363067133705474907626194082336061086343845843364512571138646990220877341926097"
        "869873046875e-121"},
    {1e-119, chars_format::scientific, 329,
        "1."
        "0000000000000000130024390228669006586108721634497552792083855061365287802750027321337635426438129020374848"
        "1664600942221067190062254340279232015505994888221071175236010018076668185817385530952343819169425474153069"
        "8485296570604075930318596366131621457117669193880841542694664169076444938015837959888187924661906436085700"
        "98876953125e-119"},
    {1e-118, chars_format::scientific, 325,
        "9."
        "9999999999999998548601848627210513127507711110962495648793617754556340466596531375943317018774133794497211"
        "2773177452477547884893180823304700696093795505933333750808977000588526776288870678657278259082964292612168"
        "7135109387034031318296259047753696621199718313862638351258177207227966550723285976687293441500514745712280"
        "2734375e-119"},
    {1e-117, chars_format::scientific, 324,
        "1."
        "0000000000000000295122913448237779750123491948538334728406551032911080056404251831583617661174558404929924"
        "3896970860405054631006016095048489183043964090797713855329077408887357490730484608804313415126102901088181"
        "6348367949744479609411978642945372534116287611377588167235972038088633907781943577219863072969019412994384"
        "765625e-117"},
    {1e-116, chars_format::scientific, 320,
        "9."
        "9999999999999999429127305798243970002253152785846665975847996269467232486085728763921888937368423845457617"
        "8012483682792147569926576848740738922962964586342094711305336418245536402492065760534449437518577236266098"
        "2404823409116184273460964524093702365192349873845287015478485841959641056142515935789560899138450622558593"
        "75e-117"},
    {1e-115, chars_format::scientific, 316,
        "1."
        "0000000000000000506449023169285809400062397950510535606899601876489694141081659204698474921637188017160421"
        "9554404355680558555414031141153138357492564670095816485848203669125039801019251428454834497950650007565124"
        "72130993150441963186515079572669739126745191857734238466488461104242357890825587674044072628021240234375e-"
        "115"},
    {1e-114, chars_format::scientific, 316,
        "1."
        "0000000000000000506449023169285809400062397950510535606899601876489694141081659204698474921637188017160421"
        "9554404355680558555414031141153138357492564670095816485848203669125039801019251428454834497950650007565124"
        "72130993150441963186515079572669739126745191857734238466488461104242357890825587674044072628021240234375e-"
        "114"},
    {1e-113, chars_format::scientific, 314,
        "9."
        "9999999999999997851225686547752015282709321304454232749766549970746913987161087044664288059247456074136569"
        "3103646918068384934346731171159358420413413594249595070095860341804175152335940173810558685761958841238256"
        "528149588154496617780581231049241207195755411835638060919569276852048034243125584907829761505126953125e-"
        "114"},
    {1e-112, chars_format::scientific, 311,
        "9."
        "9999999999999994965919868489709583795543458024193783422074762453086903017698885043736103596397686435149509"
        "2127488262573504686429299075010548358608520351566167154741389802025686009193310529515444168264142347473060"
        "254169697398616737432210540562148125004249902260523746627858543423172932307352311909198760986328125e-113"},
    {1e-111, chars_format::scientific, 310,
        "1."
        "0000000000000000881538779516831325493393960176944394019499534253785495567111745464819138901807658070228739"
        "7681304980894892987643297313652483665527200791644662114844284839296243389627793282213199385225366151754600"
        "23692731730268401631043898549001949195234763482210724552280700638817734215990640223026275634765625e-111"},
    {1e-110, chars_format::scientific, 307,
        "1."
        "0000000000000000512219634805401894263036729677071056505554985451525014163020583608700331290562887556438396"
        "0756356672991548315909866005345435977616174456581183341678912610204596779305536687743424726985645640552655"
        "11385789128593139162584753710767157743183492959649261329346803250928132911212742328643798828125e-110"},
    {1e-109, chars_format::scientific, 304,
        "9."
        "9999999999999999213090032671148042944651608772737164832437073679082439164747246389102391125712547343738461"
        "6764393803461968411363759120541596769585323204796173046143170436579622027899261365917852738020928226295429"
        "16946809659127192130501219695914914199014601235509201726525674303047708235681056976318359375e-110"},
    {1e-108, chars_format::scientific, 303,
        "1."
        "0000000000000000394037508497744476269322415917111588501092729834801660113711411814742312854964560992025486"
        "0940373214462478020955167986687180717484646029360870134265993496895269864002414577513096836348935076968032"
        "6744756749605705517267782736253202447852708639242959309800795608680346049368381500244140625e-108"},
    {1e-107, chars_format::scientific, 300,
        "1."
        "0000000000000000015854704313240738689436611885241290886813511861286927155922062074076653861049915985904174"
        "1529226147169453077100134326980763885063755062255867870544652334305423735032423824776047586311461273497240"
        "8684525827194158640497566304817959803162658537732665475772364516160450875759124755859375e-107"},
    {1e-106, chars_format::scientific, 298,
        "9."
        "9999999999999994107622176180347585616193254342488147039667631036633544234591024890115994707864839761100750"
        "4713908395006131669320804714504969531903295148878642485905064741616699286804386203967687862515031879439739"
        "78815635133568363766522001452157157165857837531619534132687476812861859798431396484375e-107"},
    {1e-105, chars_format::scientific, 295,
        "9."
        "9999999999999996527992122961171506127462400146458051771054626067127835164442863230376212268918567800277146"
        "8945249625681491309993020136626037259396997338350656973721648182191714512212327021484803062754864221652807"
        "34670414167907363879815853064012686426021044028278339510507066734135150909423828125e-106"},
    {1e-104, chars_format::scientific, 293,
        "9."
        "9999999999999992655400208111853233309431766860106204200835434018336969676679921885959864171232602937594912"
        "6175103656600915884917475461232328895407073835195433793215114677271690151559621713457418742371132474111899"
        "253027677129649636985456904850438396097599136336242509059957228600978851318359375e-105"},
    {1e-103, chars_format::scientific, 291,
        "9."
        "9999999999999995753473739991307851563856273489187682257010787657369662066890274961492942649381374827740700"
        "0391220431865376224977911201547295586599012637719612337620341481207709640081785959879326198678117872144625"
        "7279688487691888384356182054821891706276881794934752178960479795932769775390625e-104"},
    {1e-102, chars_format::scientific, 288,
        "9."
        "9999999999999993275014914487744156960316668185922499812070504746143508154721992501066479866862357315624070"
        "1018327011653807952929562609295322233645461595700269502096160038058894049264054562741800233632529553718444"
        "5480159114575574772754891649767885510036169449676890508271753787994384765625e-103"},
    {1e-101, chars_format::scientific, 287,
        "1."
        "0000000000000000517161727690484989105730677364159537554778386272002904693312974831111350122295364137378389"
        "3800821542866933565876163585210479432782250659739311511261223096517320888518916526900192486585135348216411"
        "421179001055338801084410855940271152519915887069146265275776386260986328125e-101"},
    {1e-100, chars_format::scientific, 281,
        "1."
        "0000000000000000199918998026028836196477607885341594201826030059365956992555434676176762886132929895827460"
        "7481091185079852827053974965402226843604196126360835628314127871794272492894246908066589163059300043457860"
        "230145025079449986855914338755579873208034769049845635890960693359375e-100"},
    {1e-99, chars_format::scientific, 281,
        "1."
        "0000000000000000199918998026028836196477607885341594201826030059365956992555434676176762886132929895827460"
        "7481091185079852827053974965402226843604196126360835628314127871794272492894246908066589163059300043457860"
        "230145025079449986855914338755579873208034769049845635890960693359375e-99"},
    {1e-98, chars_format::scientific, 279,
        "9."
        "9999999999999993877776100850210847487897500195676592182679981550153708786161318795442195615570982374570834"
        "5025814691449261356691720986931002153083765209119373679695640965032686000950926838525646548331616632759691"
        "8109804658117462243096325476277019816961910692043602466583251953125e-99"},
    {1e-97, chars_format::scientific, 278,
        "1."
        "0000000000000000362347275614230386486015179458496381198537636440236074215343295235503271551048096227501536"
        "2076793128266838165330935538744052169263360047450615280383040626852473271454077752909394064704527719494238"
        "439954420779105059740904555554141808215717901475727558135986328125e-97"},
    {1e-96, chars_format::scientific, 273,
        "9."
        "9999999999999990629210549086179841697146068732580852248447853932751364330404107608912022317267655741089325"
        "3111775827709554591152509520094495639900486787323780638317385863868670429754309941669548515427063112032127"
        "6147925518186447666098282116564632815425284206867218017578125e-97"},
    {1e-95, chars_format::scientific, 272,
        "9."
        "9999999999999998945538361602099216521469733278105946480082100633301366137142568246429265960924171922801988"
        "8411715318883203910932890875195952313649679547120498824245718922848550292017649197621159479662720125094691"
        "957033611640984498321327311742834353935904800891876220703125e-96"},
    {1e-94, chars_format::scientific, 269,
        "9."
        "9999999999999995619007236595731466591740267459895908787428401953081365414447183991422368503461565450116923"
        "4291739522413744183020738333155369644150002443201811549874385699256598347112313495240515093968457319869666"
        "220137187712048605636727671708285924978554248809814453125e-95"},
    {1e-93, chars_format::scientific, 266,
        "9."
        "9999999999999990296557436585543066704173122150759848479182484064729364258134569183411332571521395093820818"
        "7699778248062608618361294265890437372950519076931911910880252541509475235263776371431484076857636831509625"
        "041102909425751177341368247653008438646793365478515625e-94"},
    {1e-92, chars_format::scientific, 265,
        "9."
        "9999999999999998812477116601844506524280554645377544972375952686092566108234752876228990062625667663894586"
        "2246916287024425521816404773514329006869692462963751333270865593904872214221435769525933704234949612885690"
        "92755775468382706261394332614145241677761077880859375e-93"},
    {1e-91, chars_format::scientific, 264,
        "1."
        "0000000000000000221884498860836508245232352764322462356965334013463784684827482635335605305906737669192409"
        "3206577150260915228319844897656388566043736181737648710222711081486303100580449952876371355518587472543611"
        "7282139692787057416722973357536830008029937744140625e-91"},
    {1e-90, chars_format::scientific, 260,
        "9."
        "9999999999999999493750691003148621709889149244946960691831430175801622256242767571654402661914009469500487"
        "6210687330141370874092813614124240337583226333846298487062114638096503972538048521373489674425134635395776"
        "198474142304473133435749332420527935028076171875e-91"},
    {1e-89, chars_format::scientific, 259,
        "1."
        "0000000000000000385390156717149495889778415468219122129634648610993958160349406162237704329735939702537825"
        "6557882200608982112866183019402767285414984310749460027132610852092294722576437013319784788364231877946032"
        "19323390230766079866953077726066112518310546875e-89"},
    {1e-88, chars_format::scientific, 256,
        "9."
        "9999999999999993389539464367463749646836141632804995845510351868008479170090955900642705772290466891271611"
        "1095298783813540517696190402259434814389962850738675989092523202139483418021198264819388181521076833705412"
        "17106330922348433887236751616001129150390625e-89"},
    {1e-87, chars_format::scientific, 255,
        "1."
        "0000000000000000176102914661068871704759455207231397620617925926155336111681344047803017579234561099855692"
        "7468211736163456500646870223567402524619786705614341541487939145716625446421573575952215594321807039030933"
        "9980083880305983257130719721317291259765625e-87"},
    {1e-86, chars_format::scientific, 252,
        "1."
        "0000000000000000845822089240526869096820128042392116049471438517638926667419142813994015180838972628438518"
        "0555157222389138459748671170240569759164419042046720695550888606118767130117136575528437015257566523559248"
        "2227300337171982391737401485443115234375e-86"},
    {1e-85, chars_format::scientific, 248,
        "9."
        "9999999999999997742714099133940732695230515061349665633058183712651817782386647880884190182719141827059975"
        "6160444444280473251857896555635021838930073037549140490501694694753404362042357762064827417603513483139454"
        "631754006186383776366710662841796875e-86"},
    {1e-84, chars_format::scientific, 244,
        "1."
        "0000000000000000345765105554531564377414825658805446289260815782664512385801586401904736971641012020430008"
        "4916904592673962596952659796724604890704426897510544260517219675685168006291116202511525020958866108444773"
        "60160453827120363712310791015625e-84"},
    {1e-83, chars_format::scientific, 244,
        "1."
        "0000000000000000345765105554531564377414825658805446289260815782664512385801586401904736971641012020430008"
        "4916904592673962596952659796724604890704426897510544260517219675685168006291116202511525020958866108444773"
        "60160453827120363712310791015625e-83"},
    {1e-82, chars_format::scientific, 237,
        "9."
        "9999999999999996142531751338755757593133547433872322400384190960733692081210467362198499913285667881432745"
        "0118036029191910490910660160383934259858098175033375898393954117365887165799092568410709035847672154773135"
        "8441524207592010498046875e-83"},
    {1e-81, chars_format::scientific, 237,
        "9."
        "9999999999999996142531751338755757593133547433872322400384190960733692081210467362198499913285667881432745"
        "0118036029191910490910660160383934259858098175033375898393954117365887165799092568410709035847672154773135"
        "8441524207592010498046875e-82"},
    {1e-80, chars_format::scientific, 237,
        "9."
        "9999999999999996142531751338755757593133547433872322400384190960733692081210467362198499913285667881432745"
        "0118036029191910490910660160383934259858098175033375898393954117365887165799092568410709035847672154773135"
        "8441524207592010498046875e-81"},
    {1e-79, chars_format::scientific, 233,
        "9."
        "9999999999999999887872835092514419317813078520813578332402861996080345150934830450505121252485387470740823"
        "0432153096736340815962020317497336959217417624670274052264414348782613129120472130243434116803058486766531"
        "132161617279052734375e-80"},
    {1e-78, chars_format::scientific, 233,
        "9."
        "9999999999999999887872835092514419317813078520813578332402861996080345150934830450505121252485387470740823"
        "0432153096736340815962020317497336959217417624670274052264414348782613129120472130243434116803058486766531"
        "132161617279052734375e-79"},
    {1e-77, chars_format::scientific, 228,
        "9."
        "9999999999999992696817954285297788806428378833886366942927013608214771257064053320956408281221925859269313"
        "2229048327051034591863408815839603776447524281367429596833130704462499279543423371524601961368716729339212"
        "1791839599609375e-78"},
    {1e-76, chars_format::scientific, 228,
        "9."
        "9999999999999992696817954285297788806428378833886366942927013608214771257064053320956408281221925859269313"
        "2229048327051034591863408815839603776447524281367429596833130704462499279543423371524601961368716729339212"
        "1791839599609375e-77"},
    {1e-75, chars_format::scientific, 223,
        "9."
        "9999999999999995765001370096376884491285850700308643802436708920370749451782251562897192482294336146830490"
        "7462373028783431914145483056546903267762678774509976564483811726039081188696297508577970347687369212508201"
        "59912109375e-76"},
    {1e-74, chars_format::scientific, 223,
        "9."
        "9999999999999995765001370096376884491285850700308643802436708920370749451782251562897192482294336146830490"
        "7462373028783431914145483056546903267762678774509976564483811726039081188696297508577970347687369212508201"
        "59912109375e-75"},
    {1e-73, chars_format::scientific, 221,
        "9."
        "9999999999999999692276142334558126967903414689329158182609118919930401541021545312581396259667021314908797"
        "9761028647000900486666538084652246616646076525732436683076683433657106032411976404006281882175244390964508"
        "056640625e-74"},
    {1e-72, chars_format::scientific, 218,
        "9."
        "9999999999999996550456324544013132986609363498112746678471190920282679869630110312834033237768873180446152"
        "1922104152426925628649694062167971937539358324754468588202386067562686157439433287663632654584944248199462"
        "890625e-73"},
    {1e-71, chars_format::scientific, 215,
        "9."
        "9999999999999991523544616079141142616538881592166488271850506120846325195403814313238252402731836165305918"
        "9379824961108565855822743626193132450968609203189719636403510281811614357483364301515393890440464019775390"
        "625e-72"},
    {1e-70, chars_format::scientific, 214,
        "9."
        "9999999999999999566603349622936327208651652641680501722443601799944492674165887912591501738791095389530292"
        "1447471667217941492345864323752875629481807797693317959281711539013329237413074679352575913071632385253906"
        "25e-71"},
    {1e-69, chars_format::scientific, 210,
        "9."
        "9999999999999996349379856205418253371806544221874896342206363528305225682661058472850202004367391699840542"
        "86204129847741912377366160447289783580765283598918786301304310361326432854411905282177031040191650390625e-"
        "70"},
    {1e-68, chars_format::scientific, 210,
        "1."
        "0000000000000000664449503514147608964971089116525283355896552599755088005547651268002236115452324350684774"
        "05667000768594192052486210537605449626573422560856484483414528645350838331751219811849296092987060546875e-"
        "68"},
    {1e-67, chars_format::scientific, 207,
        "9."
        "9999999999999994290356820418206686116225674833199308898854531034456094808097967631415770174336221338439103"
        "32110954280101910747866971461536841043771495196989574594736115142890042761791846714913845062255859375e-"
        "68"},
    {1e-66, chars_format::scientific, 204,
        "9."
        "9999999999999997584793677677745193725155065855080248808217463024614704207398912977710861102386093916681406"
        "58660035188325913355065673838741549102961556640076313325245227492388266909983940422534942626953125e-67"},
    {1e-65, chars_format::scientific, 202,
        "9."
        "9999999999999992313694706062483581550868040220070744953236771840360929168517400423638715617506297791493721"
        "361815057351675091835477500352140162082574583311375313564306477331911082728765904903411865234375e-66"},
    {1e-64, chars_format::scientific, 200,
        "9."
        "9999999999999996530573883354692871290297660728078348037221324787763949199622610466896432005410134691643869"
        "5416432929769423252076208907803604252402073697828855693148231154054883518256247043609619140625e-65"},
    {1e-63, chars_format::scientific, 199,
        "1."
        "0000000000000000665108390885599516666492874994729659543878425186153119727427511457071495133637934325200422"
        "517323105847758368530076502780808905681852605731451018311606304678207379765808582305908203125e-63"},
    {1e-62, chars_format::scientific, 193,
        "1."
        "0000000000000000395228123538898122123169379282217172946503413797519326445436778014303001284812088763590813"
        "033814098767741265594259325793402808839764107397274361943573239841498434543609619140625e-62"},
    {1e-61, chars_format::scientific, 193,
        "1."
        "0000000000000000395228123538898122123169379282217172946503413797519326445436778014303001284812088763590813"
        "033814098767741265594259325793402808839764107397274361943573239841498434543609619140625e-61"},
    {1e-60, chars_format::scientific, 190,
        "9."
        "9999999999999997043346391313425520922612302581852072572233846426168156435405004008156570318179241258702127"
        "560310406428974820785673527056432009240175516617821216414085938595235347747802734375e-61"},
    {1e-59, chars_format::scientific, 186,
        "1."
        "0000000000000000257049426657387008116987749477410779808647407966538824285057522491605532434213255836046692"
        "97825748714277250889112093117585088725661479625017591388314031064510345458984375e-59"},
    {1e-58, chars_format::scientific, 186,
        "1."
        "0000000000000000257049426657387008116987749477410779808647407966538824285057522491605532434213255836046692"
        "97825748714277250889112093117585088725661479625017591388314031064510345458984375e-58"},
    {1e-57, chars_format::scientific, 184,
        "9."
        "9999999999999995495744986240501044053378048768020469428246581119186532239157342153944919191472312470207982"
        "938076356229324745710523507339850487508903231770318598137237131595611572265625e-58"},
    {1e-56, chars_format::scientific, 182,
        "1."
        "0000000000000000398544412264054388859317738397532526381811957937462858497285880146847740537226460753851871"
        "9151474574467405157551346472642240549577596908648047246970236301422119140625e-56"},
    {1e-55, chars_format::scientific, 179,
        "9."
        "9999999999999999457604583227187704838617738531429373476853980305059490181551356500726746075842050168752993"
        "1709955247404289379029075578142991831409602809799253009259700775146484375e-56"},
    {1e-54, chars_format::scientific, 176,
        "1."
        "0000000000000000307987621475787265184226545488654608574986645956071476601459731247492727351298009606456557"
        "3955378764522009913621658689676652276290269583114422857761383056640625e-54"},
    {1e-53, chars_format::scientific, 176,
        "1."
        "0000000000000000307987621475787265184226545488654608574986645956071476601459731247492727351298009606456557"
        "3955378764522009913621658689676652276290269583114422857761383056640625e-53"},
    {1e-52, chars_format::scientific, 169,
        "1."
        "0000000000000000076162237057823428575993091641927138989513847283709538948144790065143893595321174669124552"
        "225337349106179808916165796528474629667471162974834442138671875e-52"},
    {1e-51, chars_format::scientific, 169,
        "1."
        "0000000000000000076162237057823428575993091641927138989513847283709538948144790065143893595321174669124552"
        "225337349106179808916165796528474629667471162974834442138671875e-51"},
    {1e-50, chars_format::scientific, 169,
        "1."
        "0000000000000000076162237057823428575993091641927138989513847283709538948144790065143893595321174669124552"
        "225337349106179808916165796528474629667471162974834442138671875e-50"},
    {1e-49, chars_format::scientific, 165,
        "9."
        "9999999999999993639946561258385225154999214247803524229414097622136664771612907529682762969603377416406323"
        "42481329099202736442053573995281112729571759700775146484375e-50"},
    {1e-48, chars_format::scientific, 160,
        "9."
        "9999999999999997438173659562304724144296122072586385917800431070114651283524903861286055227527841029653896"
        "133378731029238417615800926796509884297847747802734375e-49"},
    {1e-47, chars_format::scientific, 160,
        "9."
        "9999999999999997438173659562304724144296122072586385917800431070114651283524903861286055227527841029653896"
        "133378731029238417615800926796509884297847747802734375e-48"},
    {1e-46, chars_format::scientific, 159,
        "1."
        "0000000000000000229990434539132168285059616408830844887893493788352647401877225916573826931767115445461078"
        "92003424942768685657057403659564442932605743408203125e-46"},
    {1e-45, chars_format::scientific, 156,
        "9."
        "9999999999999998410519796728108115885556130475730798510027332432797015830574374922176498045556503714645274"
        "74677148367876444723378881462849676609039306640625e-46"},
    {1e-44, chars_format::scientific, 154,
        "9."
        "9999999999999995299012157797537262313524103585668678214901248072213449280016067527327081027864783122672863"
        "183914675200281152456227573566138744354248046875e-45"},
    {1e-43, chars_format::scientific, 152,
        "1."
        "0000000000000000774504271351982067660165221114591715939540558551454771548224929710672474909863166549056250"
        "9435341909114214331566472537815570831298828125e-43"},
    {1e-42, chars_format::scientific, 150,
        "1."
        "0000000000000000376231293568868998402945121672663764541764419753300075029753466364131749531598626313283782"
        "26348851942617557142511941492557525634765625e-42"},
    {1e-41, chars_format::scientific, 148,
        "1."
        "0000000000000000057612911342378542997169042119121403423543508714776317814976295686899169228986994124665807"
        "319451982237978882039897143840789794921875e-41"},
    {1e-40, chars_format::scientific, 142,
        "9."
        "9999999999999992929287939988014500233064511906197367398133222223193004995110860615409765027190768719826674"
        "537642929863068275153636932373046875e-41"},
    {1e-39, chars_format::scientific, 142,
        "9."
        "9999999999999992929287939988014500233064511906197367398133222223193004995110860615409765027190768719826674"
        "537642929863068275153636932373046875e-40"},
    {1e-38, chars_format::scientific, 138,
        "9."
        "9999999999999996191940173987276763588211566534471145248715351257676278874429088350271387325933882331274737"
        "96457707067020237445831298828125e-39"},
    {1e-37, chars_format::scientific, 138,
        "1."
        "0000000000000000663242732278491600632468214134494723437057816416802275528824741710182857868191184588790854"
        "09307663212530314922332763671875e-37"},
    {1e-36, chars_format::scientific, 134,
        "9."
        "9999999999999994103842744227748915040917451572375927424342788675606983591665422599959949054738289619947977"
        "3713392205536365509033203125e-37"},
    {1e-35, chars_format::scientific, 134,
        "1."
        "0000000000000000078575451945823803039225861945108062446233498893822872849650915300095655152256418629619361"
        "1269700340926647186279296875e-35"},
    {1e-34, chars_format::scientific, 130,
        "9."
        "9999999999999992767460389181651091970649217996634988016744348623082634610696676519760628561173110284698850"
        "591666996479034423828125e-35"},
    {1e-33, chars_format::scientific, 127,
        "1."
        "0000000000000000559673099762419019344522426032374800632968937312731638482799663888967410529939883190309046"
        "767652034759521484375e-33"},
    {1e-32, chars_format::scientific, 127,
        "1."
        "0000000000000000559673099762419019344522426032374800632968937312731638482799663888967410529939883190309046"
        "767652034759521484375e-32"},
    {1e-31, chars_format::scientific, 117,
        "1."
        "0000000000000000833364206075859853509313360268686545023645097835488625154102063086192231367022031918168067"
        "93212890625e-31"},
    {1e-30, chars_format::scientific, 117,
        "1."
        "0000000000000000833364206075859853509313360268686545023645097835488625154102063086192231367022031918168067"
        "93212890625e-30"},
    {1e-29, chars_format::scientific, 119,
        "9."
        "9999999999999994320657417510427825855837769787704137433831559589728533970337791964011486811614304315298795"
        "7000732421875e-30"},
    {1e-28, chars_format::scientific, 117,
        "9."
        "9999999999999997123254346160061967703296936367536399994355443342760077484474359743593652183335507288575172"
        "42431640625e-29"},
    {1e-27, chars_format::scientific, 111,
        "1."
        "0000000000000000384948697491918390813719893615913383013961276435003578191840212241459084907546639442443847"
        "65625e-27"},
    {1e-26, chars_format::scientific, 111,
        "1."
        "0000000000000000384948697491918390813719893615913383013961276435003578191840212241459084907546639442443847"
        "65625e-26"},
    {1e-25, chars_format::scientific, 111,
        "1."
        "0000000000000000384948697491918390813719893615913383013961276435003578191840212241459084907546639442443847"
        "65625e-25"},
    {1e-24, chars_format::scientific, 107,
        "9."
        "9999999999999992370049955170282463130006189848140882691706936497618579684498740789422299712896347045898437"
        "5e-25"},
    {1e-23, chars_format::scientific, 105,
        "9."
        "999999999999999604346980148993092553230786866765862587503680141039208439934782290947623550891876220703125e"
        "-24"},
    {1e-22, chars_format::scientific, 103,
        "1."
        "0000000000000000485967743265708723529783189783450120951502847720104849571498561999760568141937255859375e-"
        "22"},
    {1e-21, chars_format::scientific, 100,
        "9.9999999999999990753745222789637139672993451167553075691041795935998237609965144656598567962646484375e-"
        "22"},
    {1e-20, chars_format::scientific, 98,
        "9.99999999999999945153271454209571651729503702787392447107715776066783064379706047475337982177734375e-21"},
    {1e-19, chars_format::scientific, 94,
        "9.9999999999999997524592683526013185572915905567688179926555402943222361500374972820281982421875e-20"},
    {1e-18, chars_format::scientific, 92,
        "1.00000000000000007154242405462192450852805618492324772617063644020163337700068950653076171875e-18"},
    {1e-17, chars_format::scientific, 92,
        "1.00000000000000007154242405462192450852805618492324772617063644020163337700068950653076171875e-17"},
    {1e-16, chars_format::scientific, 87,
        "9.999999999999999790977867240346035618411149408467364363417573258630000054836273193359375e-17"},
    {1e-15, chars_format::scientific, 86,
        "1.00000000000000007770539987666107923830718560119501514549256171449087560176849365234375e-15"},
    {1e-14, chars_format::scientific, 84,
        "9.999999999999999988193093545598986971343290729163921781719182035885751247406005859375e-15"},
    {1e-13, chars_format::scientific, 82,
        "1.0000000000000000303737455634003709136034716842278413651001756079494953155517578125e-13"},
    {1e-12, chars_format::scientific, 79,
        "9.9999999999999997988664762925561536725284350612952266601496376097202301025390625e-13"},
    {1e-11, chars_format::scientific, 77,
        "9.99999999999999939496969281939810930172340963650867706746794283390045166015625e-12"},
    {1e-10, chars_format::scientific, 76,
        "1.0000000000000000364321973154977415791655470655996396089904010295867919921875e-10"},
    {1e-09, chars_format::scientific, 73,
        "1.0000000000000000622815914577798564188970686927859787829220294952392578125e-09"},
    {1e-08, chars_format::scientific, 70,
        "1.0000000000000000209225608301284726753266340892878361046314239501953125e-08"},
    {1e-07, chars_format::scientific, 65, "9.99999999999999954748111825886258685613938723690807819366455078125e-08"},
    {1e-06, chars_format::scientific, 65, "9.99999999999999954748111825886258685613938723690807819366455078125e-07"},
    {1e-05, chars_format::scientific, 64, "1.0000000000000000818030539140313095458623138256371021270751953125e-05"},
    {1e-04, chars_format::scientific, 62, "1.00000000000000004792173602385929598312941379845142364501953125e-04"},
    {1e-03, chars_format::scientific, 57, "1.000000000000000020816681711721685132943093776702880859375e-03"},
    {1e-02, chars_format::scientific, 57, "1.000000000000000020816681711721685132943093776702880859375e-02"},
    {1e-01, chars_format::scientific, 54, "1.000000000000000055511151231257827021181583404541015625e-01"},
    {1e+00, chars_format::scientific, 0, "1e+00"},
    {1e+01, chars_format::scientific, 0, "1e+01"},
    {1e+02, chars_format::scientific, 0, "1e+02"},
    {1e+03, chars_format::scientific, 0, "1e+03"},
    {1e+04, chars_format::scientific, 0, "1e+04"},
    {1e+05, chars_format::scientific, 0, "1e+05"},
    {1e+06, chars_format::scientific, 0, "1e+06"},
    {1e+07, chars_format::scientific, 0, "1e+07"},
    {1e+08, chars_format::scientific, 0, "1e+08"},
    {1e+09, chars_format::scientific, 0, "1e+09"},
    {1e+10, chars_format::scientific, 0, "1e+10"},
    {1e+11, chars_format::scientific, 0, "1e+11"},
    {1e+12, chars_format::scientific, 0, "1e+12"},
    {1e+13, chars_format::scientific, 0, "1e+13"},
    {1e+14, chars_format::scientific, 0, "1e+14"},
    {1e+15, chars_format::scientific, 0, "1e+15"},
    {1e+16, chars_format::scientific, 0, "1e+16"},
    {1e+17, chars_format::scientific, 0, "1e+17"},
    {1e+18, chars_format::scientific, 0, "1e+18"},
    {1e+19, chars_format::scientific, 0, "1e+19"},
    {1e+20, chars_format::scientific, 0, "1e+20"},
    {1e+21, chars_format::scientific, 0, "1e+21"},
    {1e+22, chars_format::scientific, 0, "1e+22"},
    {1e+23, chars_format::scientific, 22, "9.9999999999999991611392e+22"},
    {1e+24, chars_format::scientific, 23, "9.99999999999999983222784e+23"},
    {1e+25, chars_format::scientific, 25, "1.0000000000000000905969664e+25"},
    {1e+26, chars_format::scientific, 26, "1.00000000000000004764729344e+26"},
    {1e+27, chars_format::scientific, 27, "1.000000000000000013287555072e+27"},
    {1e+28, chars_format::scientific, 27, "9.999999999999999583119736832e+27"},
    {1e+29, chars_format::scientific, 28, "9.9999999999999991433150857216e+28"},
    {1e+30, chars_format::scientific, 30, "1.000000000000000019884624838656e+30"},
    {1e+31, chars_format::scientific, 30, "9.999999999999999635896294965248e+30"},
    {1e+32, chars_format::scientific, 32, "1.00000000000000005366162204393472e+32"},
    {1e+33, chars_format::scientific, 32, "9.99999999999999945575230987042816e+32"},
    {1e+34, chars_format::scientific, 32, "9.99999999999999945575230987042816e+33"},
    {1e+35, chars_format::scientific, 34, "9.9999999999999996863366107917975552e+34"},
    {1e+36, chars_format::scientific, 36, "1.000000000000000042420637374017961984e+36"},
    {1e+37, chars_format::scientific, 36, "9.999999999999999538762658202121142272e+36"},
    {1e+38, chars_format::scientific, 37, "9.9999999999999997748809823456034029568e+37"},
    {1e+39, chars_format::scientific, 38, "9.99999999999999939709166371603178586112e+38"},
    {1e+40, chars_format::scientific, 40, "1.0000000000000000303786028427003666890752e+40"},
    {1e+41, chars_format::scientific, 41, "1.00000000000000000620008645040778319495168e+41"},
    {1e+42, chars_format::scientific, 42, "1.000000000000000044885712678075916785549312e+42"},
    {1e+43, chars_format::scientific, 43, "1.0000000000000000139372116959414099130712064e+43"},
    {1e+44, chars_format::scientific, 44, "1.00000000000000008821361405306422640701865984e+44"},
    {1e+45, chars_format::scientific, 44, "9.99999999999999929757289024535551219930759168e+44"},
    {1e+46, chars_format::scientific, 45, "9.999999999999999931398190359470212947659194368e+45"},
    {1e+47, chars_format::scientific, 47, "1.00000000000000004384584304507619735463404765184e+47"},
    {1e+48, chars_format::scientific, 47, "1.00000000000000004384584304507619735463404765184e+48"},
    {1e+49, chars_format::scientific, 48, "9.999999999999999464902769475481793196872414789632e+48"},
    {1e+50, chars_format::scientific, 49, "1.0000000000000000762976984109188700329496497094656e+50"},
    {1e+51, chars_format::scientific, 50, "9.99999999999999993220948674361627976461708441944064e+50"},
    {1e+52, chars_format::scientific, 50, "9.99999999999999993220948674361627976461708441944064e+51"},
    {1e+53, chars_format::scientific, 50, "9.99999999999999993220948674361627976461708441944064e+52"},
    {1e+54, chars_format::scientific, 54, "1.000000000000000078291540404596243842305360299886116864e+54"},
    {1e+55, chars_format::scientific, 55, "1.0000000000000000102350670204085511496304388135324745728e+55"},
    {1e+56, chars_format::scientific, 56, "1.00000000000000009190283508143378238084034459715684532224e+56"},
    {1e+57, chars_format::scientific, 57, "1.000000000000000048346692115553659057528394845890514255872e+57"},
    {1e+58, chars_format::scientific, 57, "9.999999999999999438119489974413630815797154428513196965888e+57"},
    {1e+59, chars_format::scientific, 58, "9.9999999999999997168788049560464200849936328366177157906432e+58"},
    {1e+60, chars_format::scientific, 59, "9.99999999999999949387135297074018866963645011013410073083904e+59"},
    {1e+61, chars_format::scientific, 59, "9.99999999999999949387135297074018866963645011013410073083904e+60"},
    {1e+62, chars_format::scientific, 62, "1.00000000000000003502199685943161173046080317798311825604870144e+62"},
    {1e+63, chars_format::scientific, 63, "1.000000000000000057857959942726969827393378689175040438172647424e+63"},
    {1e+64, chars_format::scientific, 64, "1.0000000000000000213204190094543968723012578712679649467743338496e+64"},
    {1e+65, chars_format::scientific, 64, "9.9999999999999999209038626283633850822756121694230455365568299008e+64"},
    {1e+66, chars_format::scientific, 65, "9.99999999999999945322333868247445125709646570021247924665841614848e+65"},
    {1e+67, chars_format::scientific, 66, "9.999999999999999827367757839185598317239782875580932278577147150336e+66"},
    {1e+68, chars_format::scientific, 67, "9.9999999999999995280522225138166806691251291352861698530421623488512e+67"},
    {1e+69, chars_format::scientific, 68, "1.00000000000000007253143638152923512615837440964652195551821015547904e+69"},
    {1e+70, chars_format::scientific, 68, "1.00000000000000007253143638152923512615837440964652195551821015547904e+70"},
    {1e+71, chars_format::scientific, 71,
        "1.00000000000000004188152556421145795899143386664033828314342771180699648e+71"},
    {1e+72, chars_format::scientific, 71,
        "9.99999999999999943801810948794571024057224129020550531544123892056457216e+71"},
    {1e+73, chars_format::scientific, 72,
        "9.999999999999999830336967949613257980309080240684656321838454199566729216e+72"},
    {1e+74, chars_format::scientific, 73,
        "9.9999999999999995164818811802792197885196090803013355167206819763650035712e+73"},
    {1e+75, chars_format::scientific, 74,
        "9.99999999999999926539781176481198923508803215199467887262646419780362305536e+74"},
    {1e+76, chars_format::scientific, 76,
        "1.0000000000000000470601344959054695891559601407866630764278709534898249531392e+76"},
    {1e+77, chars_format::scientific, 76,
        "9.9999999999999998278261272554585856747747644714015897553975120217811154108416e+76"},
    {1e+78, chars_format::scientific, 78,
        "1.000000000000000008493621433689702976148869924598760615894999102702796905906176e+78"},
    {1e+79, chars_format::scientific, 78,
        "9.999999999999999673560075006595519222746403606649979913266024618633003221909504e+78"},
    {1e+80, chars_format::scientific, 80,
        "1.00000000000000000026609864708367276537402401181200809098131977453489758916313088e+80"},
    {1e+81, chars_format::scientific, 80,
        "9.99999999999999921281879895665782741935503249059183851809998224123064148429897728e+80"},
    {1e+82, chars_format::scientific, 81,
        "9.999999999999999634067965630886574211027143225273567793680363843427086501542887424e+81"},
    {1e+83, chars_format::scientific, 83,
        "1.00000000000000003080666323096525690777025204007643346346089744069413985291331436544e+83"},
    {1e+84, chars_format::scientific, 84,
        "1.000000000000000057766609898115896702437267127096064137098041863234712334016924614656e+84"},
    {1e+85, chars_format::scientific, 85,
        "1.0000000000000000146306952306748730309700429878646550592786107871697963642511482159104e+85"},
    {1e+86, chars_format::scientific, 85,
        "1.0000000000000000146306952306748730309700429878646550592786107871697963642511482159104e+86"},
    {1e+87, chars_format::scientific, 86,
        "9.99999999999999959416724456350362731491996089648451439669739009806703922950954425516032e+86"},
    {1e+88, chars_format::scientific, 86,
        "9.99999999999999959416724456350362731491996089648451439669739009806703922950954425516032e+87"},
    {1e+89, chars_format::scientific, 88,
        "9.9999999999999999475366575191804932315794610450682175621941694731908308538307845136842752e+88"},
    {1e+90, chars_format::scientific, 89,
        "9.99999999999999966484112715463900049825186092620125502979674597309179755437379230686511104e+89"},
    {1e+91, chars_format::scientific, 90,
        "1.000000000000000079562324861280497143156226140166910515938643997348793075220176113414176768e+91"},
    {1e+92, chars_format::scientific, 92,
        "1.00000000000000004337729697461918607329029332495193931179177378933611681288968111094132375552e+92"},
    {1e+93, chars_format::scientific, 92,
        "1.00000000000000004337729697461918607329029332495193931179177378933611681288968111094132375552e+93"},
    {1e+94, chars_format::scientific, 94,
        "1.0000000000000000202188791271559469885760963232143577411377768562080040049981643093586978275328e+94"},
    {1e+95, chars_format::scientific, 94,
        "1.0000000000000000202188791271559469885760963232143577411377768562080040049981643093586978275328e+95"},
    {1e+96, chars_format::scientific, 96,
        "1.000000000000000049861653971908893017010268485438462151574892930611988399099305815384459015356416e+96"},
    {1e+97, chars_format::scientific, 97,
        "1.0000000000000000735758738477112498397576062152177456799245857901351759143802190202050679656153088e+97"},
    {1e+98, chars_format::scientific, 97,
        "9.9999999999999999769037024514370800696612547992403838920556863966097586548129676477911932478685184e+97"},
    {1e+99, chars_format::scientific, 98,
        "9.99999999999999967336168804116691273849533185806555472917961779471295845921727862608739868455469056e+98"},
    {1e+100, chars_format::scientific, 100,
        "1.0000000000000000159028911097599180468360808563945281389781327557747838772170381060813469985856815104e+"
        "100"},
    {1e+101, chars_format::scientific, 100,
        "9.9999999999999997704951326524533662844684271992415000612999597473199345218078991130326129448151154688e+"
        "100"},
    {1e+102, chars_format::scientific, 100,
        "9.9999999999999997704951326524533662844684271992415000612999597473199345218078991130326129448151154688e+"
        "101"},
    {1e+103, chars_format::scientific, 103,
        "1."
        "0000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328e+"
        "103"},
    {1e+104, chars_format::scientific, 103,
        "1."
        "0000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328e+"
        "104"},
    {1e+105, chars_format::scientific, 104,
        "9."
        "99999999999999938258300825281978540327027364472124478294416212538871491824599713636820527503908255301632e+"
        "104"},
    {1e+106, chars_format::scientific, 106,
        "1."
        "0000000000000000910359990503684350104604539951754865571545457374840902895351334152154180097541612190564352"
        "e+106"},
    {1e+107, chars_format::scientific, 106,
        "9."
        "9999999999999996881384047029926983435371269061279689406644211752791525136670645395254002395395884805259264"
        "e+106"},
    {1e+108, chars_format::scientific, 108,
        "1."
        "0000000000000000339989917130028245949439747197128980477134307148378752717232008332927416163807334459213086"
        "72e+108"},
    {1e+109, chars_format::scientific, 108,
        "9."
        "9999999999999998185087071883998078647176509643281712479583983698990725543800532982058034243931376762633584"
        "64e+108"},
    {1e+110, chars_format::scientific, 110,
        "1."
        "0000000000000000235693675141702558332495327950568818631299125392682816684661617325983093615924495102623141"
        "0688e+110"},
    {1e+111, chars_format::scientific, 110,
        "9."
        "9999999999999995681977264164181575840510447725837828179539621562288260762111148815394293094743232204474889"
        "0112e+110"},
    {1e+112, chars_format::scientific, 111,
        "9."
        "9999999999999993011993469263043972846733315013897684926158968616472298328309139037619635868942544675772280"
        "34048e+111"},
    {1e+113, chars_format::scientific, 113,
        "1."
        "0000000000000000155594161294668430242682013969210614333697705804308337811647557032649853899150474476762062"
        "8086784e+113"},
    {1e+114, chars_format::scientific, 113,
        "1."
        "0000000000000000155594161294668430242682013969210614333697705804308337811647557032649853899150474476762062"
        "8086784e+114"},
    {1e+115, chars_format::scientific, 113,
        "1."
        "0000000000000000155594161294668430242682013969210614333697705804308337811647557032649853899150474476762062"
        "8086784e+115"},
    {1e+116, chars_format::scientific, 113,
        "1."
        "0000000000000000155594161294668430242682013969210614333697705804308337811647557032649853899150474476762062"
        "8086784e+116"},
    {1e+117, chars_format::scientific, 117,
        "1."
        "0000000000000000505554277259950338142282370308030032790204814747222327639770854058242333771050622192524171"
        "13236701184e+117"},
    {1e+118, chars_format::scientific, 117,
        "9."
        "9999999999999996656499989432737591832415150948634284945877532842287520522749411968203820784902676746951111"
        "55514343424e+117"},
    {1e+119, chars_format::scientific, 118,
        "9."
        "9999999999999994416755247254933381274972870380190006824232035607637985622760311004411949604741731366073618"
        "283536318464e+118"},
    {1e+120, chars_format::scientific, 119,
        "9."
        "9999999999999998000346834739420118166880519289700851818864831183077241462742872546478943492999243975477607"
        "5181077037056e+119"},
    {1e+121, chars_format::scientific, 121,
        "1."
        "0000000000000000373409337471459889719393275754491820381027730410378005080671497101378613371421126415052399"
        "029342192009216e+121"},
    {1e+122, chars_format::scientific, 122,
        "1."
        "0000000000000000144059475872452738558311186224283126301371231493549892706912613162686325762572645608050543"
        "7183296233537536e+122"},
    {1e+123, chars_format::scientific, 122,
        "9."
        "9999999999999997770996973140412967005798429759492157739208332266249129088983988607786655884150763168475752"
        "2070951350501376e+122"},
    {1e+124, chars_format::scientific, 123,
        "9."
        "9999999999999994835318744673121432143947683772820873519605146130849290704870274192525374490890208838852004"
        "22613425626021888e+123"},
    {1e+125, chars_format::scientific, 124,
        "9."
        "9999999999999992486776161899288204254467086983483846143922597222529419997579302660316349376281765375153005"
        "841365553228283904e+124"},
    {1e+126, chars_format::scientific, 124,
        "9."
        "9999999999999992486776161899288204254467086983483846143922597222529419997579302660316349376281765375153005"
        "841365553228283904e+125"},
    {1e+127, chars_format::scientific, 126,
        "9."
        "9999999999999995492910667849794735953002250873835241184796259825178854502911746221543901522980573008687723"
        "77386949310916067328e+126"},
    {1e+128, chars_format::scientific, 126,
        "1."
        "0000000000000000751744869165182086274714290643524082134829091023577659252424152046645411010977580354282659"
        "55038852526326677504e+128"},
    {1e+129, chars_format::scientific, 128,
        "9."
        "9999999999999999821744356418524141598892886875941250043654333972994040190590464949711576614226856000977717"
        "5966751665376232210432e+128"},
    {1e+130, chars_format::scientific, 130,
        "1."
        "0000000000000000597830782460516151851749290252338090708736359498322008205751130936310560341066601403445681"
        "992244323541365884452864e+130"},
    {1e+131, chars_format::scientific, 130,
        "9."
        "9999999999999991202555500957231813912852864969525730182461368558677581576901282770959939099212034754106974"
        "340599870111173348163584e+130"},
    {1e+132, chars_format::scientific, 131,
        "9."
        "9999999999999999082956740236127656368660884998248491198409222651766915166559963620104293398654157036960225"
        "3175829982724989462249472e+131"},
    {1e+133, chars_format::scientific, 133,
        "1."
        "0000000000000000223511723594768599335098409300973759560478836428900264860242343595976203511843100595010152"
        "570837624953702918544949248e+133"},
    {1e+134, chars_format::scientific, 133,
        "9."
        "9999999999999992148203649670699315007549827372972461504375111049848301607660324472857261615145089428049364"
        "457837845490532419930947584e+133"},
    {1e+135, chars_format::scientific, 134,
        "9."
        "9999999999999996182969084181493986344923533627678515144540412345510040405565569067619171016459456036870228"
        "9580532071091311261383655424e+134"},
    {1e+136, chars_format::scientific, 136,
        "1."
        "0000000000000000586640612700740119755462042863897304388093713545509821352053815609504775357961393589804030"
        "375857007499376802103616864256e+136"},
    {1e+137, chars_format::scientific, 137,
        "1."
        "0000000000000000328415624892049260789870125663596116955123134262587470068987879955440013156277274126839495"
        "0478432243557864849063421149184e+137"},
    {1e+138, chars_format::scientific, 137,
        "1."
        "0000000000000000328415624892049260789870125663596116955123134262587470068987879955440013156277274126839495"
        "0478432243557864849063421149184e+138"},
    {1e+139, chars_format::scientific, 137,
        "1."
        "0000000000000000328415624892049260789870125663596116955123134262587470068987879955440013156277274126839495"
        "0478432243557864849063421149184e+139"},
    {1e+140, chars_format::scientific, 140,
        "1."
        "0000000000000000592838012408148700370636248876704532886485007448299957782847398065202329650801812456915179"
        "2237293382948229697163514582401024e+140"},
    {1e+141, chars_format::scientific, 141,
        "1."
        "0000000000000000169762192382389597041410451735731067396306010351159977440672169089582623259562551128794084"
        "54231155599236459402033650892537856e+141"},
    {1e+142, chars_format::scientific, 142,
        "1."
        "0000000000000000508222848402996879704791089448509839788449208028871961714412352270078388372553960191290960"
        "287445781834331294577148468377157632e+142"},
    {1e+143, chars_format::scientific, 143,
        "1."
        "0000000000000000237454323586511053574086579278286821874734649886702374295420205725681776282160832941293459"
        "6913384011607579341316989008157343744e+143"},
    {1e+144, chars_format::scientific, 143,
        "1."
        "0000000000000000237454323586511053574086579278286821874734649886702374295420205725681776282160832941293459"
        "6913384011607579341316989008157343744e+144"},
    {1e+145, chars_format::scientific, 144,
        "9."
        "9999999999999998908706118214091961267848062604013589451800154647253023991102581488541128064576300612966589"
        "28320953898584032761523454337112604672e+144"},
    {1e+146, chars_format::scientific, 145,
        "9."
        "9999999999999993363366729972462242111019694317846182578926003895619873650143420259298512453325054533017777"
        "074930382791057905692427399713177731072e+145"},
    {1e+147, chars_format::scientific, 146,
        "9."
        "9999999999999997799638240565766017436482388946780108077225324496926393922910749242692604942326051396976826"
        "8415537077468838432306731146395363835904e+146"},
    {1e+148, chars_format::scientific, 148,
        "1."
        "0000000000000000489767265751505205795722270035307438887450423745901682635933847561612315292472764637931130"
        "646815102767620534329186625852171022761984e+148"},
    {1e+149, chars_format::scientific, 148,
        "1."
        "0000000000000000489767265751505205795722270035307438887450423745901682635933847561612315292472764637931130"
        "646815102767620534329186625852171022761984e+149"},
    {1e+150, chars_format::scientific, 149,
        "9."
        "9999999999999998083559617243737459057312001403031879309116481015410011220367858297629826861622115196270206"
        "0266176005440567032331208403948233373515776e+149"},
    {1e+151, chars_format::scientific, 151,
        "1."
        "0000000000000000171775323872177191180393104084305455107732328445200031262781885420082626742861173182722545"
        "959543542834786931126445173006249634549465088e+151"},
    {1e+152, chars_format::scientific, 152,
        "1."
        "0000000000000000462510813590419947400122627239507268849188872720127255375377965092338341988220342513198966"
        "2450489690590919397689516441796634752009109504e+152"},
    {1e+153, chars_format::scientific, 152,
        "9."
        "9999999999999999973340300412315374485553901911843668628584018802436967952242376167291975956456715844366937"
        "8824028710020392594094129030220133015859757056e+152"},
    {1e+154, chars_format::scientific, 154,
        "1."
        "0000000000000000369475456880582265409809179829842688451922778552150543659347219597216513109705408327446511"
        "753687232667314337003349573404171046192448274432e+154"},
    {1e+155, chars_format::scientific, 155,
        "1."
        "0000000000000000071762315409101683040806148118916031180671277214625066168048834012826660698457618933038657"
        "3813296762136260081534229469225952733653677113344e+155"},
    {1e+156, chars_format::scientific, 155,
        "9."
        "9999999999999998335918022319172171456037227501747053636700761446046841750101255453147787694593874175123738"
        "8344363105067534507348164573733465510370326085632e+155"},
    {1e+157, chars_format::scientific, 155,
        "9."
        "9999999999999998335918022319172171456037227501747053636700761446046841750101255453147787694593874175123738"
        "8344363105067534507348164573733465510370326085632e+156"},
    {1e+158, chars_format::scientific, 157,
        "9."
        "9999999999999995287335453651211007997446182781858083179085387749785952239205787068995699003416510776387310"
        "061494932420984963311567802202010637287727642443776e+157"},
    {1e+159, chars_format::scientific, 158,
        "9."
        "9999999999999992848469398716842077230573347005946906812993088792777240630489412361674028050474620057398167"
        "0431418299523701733729688780649419062882836695482368e+158"},
    {1e+160, chars_format::scientific, 160,
        "1."
        "0000000000000000065284077450682265568456642148886267118448844545520511777838181142510337509988867035816342"
        "470187175785193750117648543530356184548650438281396224e+160"},
    {1e+161, chars_format::scientific, 161,
        "1."
        "0000000000000000377458932482281488706616365128202897693308658812017626863753877105047511391965429047846952"
        "7765363729011764432297892058199009821165792668120252416e+161"},
    {1e+162, chars_format::scientific, 161,
        "9."
        "9999999999999993784993963811639746645052515943896798537572531592268585888236500249285549696404306093489997"
        "9621894213003182527093908649335762989920701551401238528e+161"},
    {1e+163, chars_format::scientific, 161,
        "9."
        "9999999999999993784993963811639746645052515943896798537572531592268585888236500249285549696404306093489997"
        "9621894213003182527093908649335762989920701551401238528e+162"},
    {1e+164, chars_format::scientific, 164,
        "1."
        "0000000000000000017833499485879183651456364256030139271070152777012950284778995356204687079928429609987689"
        "7036220978235643807646031628623453753183252563447406133248e+164"},
    {1e+165, chars_format::scientific, 164,
        "9."
        "9999999999999989948989345183348492723345839974054042033695133885552035712504428261628757034676312089657858"
        "5177704871391229197474064067196498264773607101557544845312e+164"},
    {1e+166, chars_format::scientific, 165,
        "9."
        "9999999999999994040727605053525830239832961008552982304497691439383022566618638381796002540519505693745473"
        "92515068357773127490685649548117139715971745147241514401792e+165"},
    {1e+167, chars_format::scientific, 167,
        "1."
        "0000000000000000386089942874195144027940205149135043895442382956857739101649274267019739175454317034355575"
        "0902863155030391327289536708508823166797373630632400726786048e+167"},
    {1e+168, chars_format::scientific, 167,
        "9."
        "9999999999999993386049483474297456237195021643033151861169282230770064669960364762569243259584594717091455"
        "4599698521475539380813444812793279458505403728617494385000448e+167"},
    {1e+169, chars_format::scientific, 167,
        "9."
        "9999999999999993386049483474297456237195021643033151861169282230770064669960364762569243259584594717091455"
        "4599698521475539380813444812793279458505403728617494385000448e+168"},
    {1e+170, chars_format::scientific, 170,
        "1."
        "0000000000000000344190543093124528091771377029741774747069364767506509796263144755389226581474482731849717"
        "9085147422915077831721209019419643357959500300321574675254607872e+170"},
    {1e+171, chars_format::scientific, 170,
        "9."
        "9999999999999995397220672965687021173298771373910070983074155319629071328494581320833847770616641237372600"
        "1850053663010587168093173889073910282723323583537144858509574144e+170"},
    {1e+172, chars_format::scientific, 172,
        "1."
        "0000000000000000826871628571058023676436276965152235336326534308832671394311356729372731664122173896717192"
        "642523265688348930066834399772699475577180106550229078889679814656e+172"},
    {1e+173, chars_format::scientific, 173,
        "1."
        "0000000000000000140391862557997052178246197057012913609383004294502130454865010810818413324356568684461228"
        "5763778101906192989276863139689872767772084421689716760605683089408e+173"},
    {1e+174, chars_format::scientific, 174,
        "1."
        "0000000000000000689575675368445829376798260983524370990937828305966563206422087545661867996169052854265999"
        "82929417458880300383900478261195703581718577367397759832385751351296e+174"},
    {1e+175, chars_format::scientific, 174,
        "9."
        "9999999999999993715345246233687641002733075598968732752062506784519246026851033820375767838190908467345488"
        "22294900033162112051840457868829614121240178061963384891963422539776e+174"},
    {1e+176, chars_format::scientific, 176,
        "1."
        "0000000000000000074489805020743198914419949385831538723596425413126398524678161602637198763739070584084656"
        "0260278464628372543383280977318309056924111623883709653889736043921408e+176"},
    {1e+177, chars_format::scientific, 176,
        "1."
        "0000000000000000074489805020743198914419949385831538723596425413126398524678161602637198763739070584084656"
        "0260278464628372543383280977318309056924111623883709653889736043921408e+177"},
    {1e+178, chars_format::scientific, 178,
        "1."
        "0000000000000000524381184475062837195473800154429724610566137243318061834753718863820956830887857615988724"
        "636416932177829345401680187244151732297960592357271816907060120777654272e+178"},
    {1e+179, chars_format::scientific, 178,
        "9."
        "9999999999999998045549773481514159457876389246726271914145983150114005386328272459269439234497983649422148"
        "597943950338419997003168440244384097290815044070304544781216945608327168e+178"},
    {1e+180, chars_format::scientific, 180,
        "1."
        "0000000000000000092485460198915984445662103416575466159075213886334065057081183893084549086425022065360818"
        "77044340989143693798086218131232373875663313958712699944969706504756133888e+180"},
    {1e+181, chars_format::scientific, 180,
        "9."
        "9999999999999991711079150764693652460638170424863814625612440581015385980464426221802125649043062240212862"
        "56366562347133135483117101991090685868467907010818055540655879490029748224e+180"},
    {1e+182, chars_format::scientific, 182,
        "1."
        "0000000000000000645311987272383955965421075241028916976983595783273580932502028655627150999337451570164538"
        "2788895184180192194795092289050635704895322791329123657951217763820802932736e+182"},
    {1e+183, chars_format::scientific, 182,
        "9."
        "9999999999999994659487295156522833899352686821948885654457144031359470649375598288696002517909352932499366"
        "6087115356131035228239552737388526279268078143523691759154905886843985723392e+182"},
    {1e+184, chars_format::scientific, 184,
        "1."
        "0000000000000000173566684169691286935226752617495305612368443231218527385476241124924130700318845059398697"
        "631682172475335672600663748292592247410791680053842186513692689376624118857728e+184"},
    {1e+185, chars_format::scientific, 184,
        "9."
        "9999999999999997961704416875371517110712945186684165206763211895744845478556111003617144611039598507860251"
        "139162957211888350975873638026151889477992007905860430885494197722591793250304e+184"},
    {1e+186, chars_format::scientific, 184,
        "9."
        "9999999999999997961704416875371517110712945186684165206763211895744845478556111003617144611039598507860251"
        "139162957211888350975873638026151889477992007905860430885494197722591793250304e+185"},
    {1e+187, chars_format::scientific, 186,
        "9."
        "9999999999999990715696561218012120806928149689207894646274468696179222996240014532018752818113802502496938"
        "79805812353226907091680705581859236698853640605134247712274342131878495422251008e+186"},
    {1e+188, chars_format::scientific, 188,
        "1."
        "0000000000000000230930913026978715489298382248516992754305645781548421896794576888657617968679507611107823"
        "8543825857419659919011313587350687602971665369018571203143144663564875896666980352e+188"},
    {1e+189, chars_format::scientific, 188,
        "1."
        "0000000000000000230930913026978715489298382248516992754305645781548421896794576888657617968679507611107823"
        "8543825857419659919011313587350687602971665369018571203143144663564875896666980352e+189"},
    {1e+190, chars_format::scientific, 190,
        "1."
        "0000000000000000725591715973187783610303424287811372824568343983972101724920689074452068181743241951740625"
        "976868675721161334753163637413771490365780039321792212624518252692320803210995433472e+190"},
    {1e+191, chars_format::scientific, 190,
        "1."
        "0000000000000000725591715973187783610303424287811372824568343983972101724920689074452068181743241951740625"
        "976868675721161334753163637413771490365780039321792212624518252692320803210995433472e+191"},
    {1e+192, chars_format::scientific, 192,
        "1."
        "0000000000000000409008802087613980012860197382662969579600217134420946634919977275543620045382451973735632"
        "61847757813447631532786297905940174312186739777303375354598782943738754654264509857792e+192"},
    {1e+193, chars_format::scientific, 193,
        "1."
        "0000000000000000662275133196073022890814778906781692175574718614061870706920546714670378554471083956139627"
        "305190456203824330868103505742897540916997511012040520808812168041334151877325366493184e+193"},
    {1e+194, chars_format::scientific, 193,
        "9."
        "9999999999999994465967438754696170766327875910118237148971115117854351613178134068619377108456504406004528"
        "089686414709538562749489776621177115003729674648080379472553427423904462708600804999168e+193"},
    {1e+195, chars_format::scientific, 194,
        "9."
        "9999999999999997707776476942971919604146519418837886377444734057258179734785422889441886024790993780775660"
        "0796112539971931616645685181699233267813951241073670004367049615544210109925082343145472e+194"},
    {1e+196, chars_format::scientific, 195,
        "9."
        "9999999999999995114329246392351320533891604611862166994665838905735117237499591832783878891723402280958754"
        "48767138256706948253250552493092635735926276453993770366538373425000777236538229086224384e+195"},
    {1e+197, chars_format::scientific, 195,
        "9."
        "9999999999999995114329246392351320533891604611862166994665838905735117237499591832783878891723402280958754"
        "48767138256706948253250552493092635735926276453993770366538373425000777236538229086224384e+196"},
    {1e+198, chars_format::scientific, 198,
        "1."
        "0000000000000000175355415660194005415374418651772000861457981049363415723055131933782837715237643652049003"
        "28030374534281861011105867876227585990799216050325567033999660761493056632508247061001404416e+198"},
    {1e+199, chars_format::scientific, 199,
        "1."
        "0000000000000000972062404885344653449756728480474941855847657639911300522221339234388177506516007760792756"
        "678147673846152604340428430285295728914471221362369950308146488642846313231335560438561636352e+199"},
    {1e+200, chars_format::scientific, 199,
        "9."
        "9999999999999996973312221251036165947450327545502362648241750950346848435554075534196338404706251868027512"
        "415973882408182135734368278484639385041047239877871023591066789981811181813306167128854888448e+199"},
    {1e+201, chars_format::scientific, 201,
        "1."
        "0000000000000000377187852930565502917417937141710079246703365785635546538843904449936190462361495892930754"
        "14109087389699655531583234914810756005630018925423128793192791080866922220799992003324610084864e+201"},
    {1e+202, chars_format::scientific, 200,
        "9."
        "9999999999999990174745913196417302720721283673903932829449844044338231482669106569030772185797544806747483"
        "4210390258463987183104130654882031695190925872134291678628544718769301415466131339252487684096e+201"},
    {1e+203, chars_format::scientific, 202,
        "9."
        "9999999999999998876910787506329447650934459829549922997503484884029261182361866844442696946000689845185920"
        "534555642245481492613075738123641525387194542623914743194966239051177873087980216425864602058752e+202"},
    {1e+204, chars_format::scientific, 202,
        "9."
        "9999999999999998876910787506329447650934459829549922997503484884029261182361866844442696946000689845185920"
        "534555642245481492613075738123641525387194542623914743194966239051177873087980216425864602058752e+203"},
    {1e+205, chars_format::scientific, 205,
        "1."
        "0000000000000000166160354728550133402860267619935663985128064995273039068626355013257451286926569625748622"
        "041088095949318798038992779336698179926498716835527012730124200454693714718121768282606166882648064e+205"},
    {1e+206, chars_format::scientific, 206,
        "1."
        "0000000000000000388935775510883884313073724929520201333430238200769129428938489676307996560787770138732646"
        "0311941213291353170611409437561654018367221268940354434586262616943544566455807655946219322240663552e+"
        "206"},
    {1e+207, chars_format::scientific, 206,
        "1."
        "0000000000000000388935775510883884313073724929520201333430238200769129428938489676307996560787770138732646"
        "0311941213291353170611409437561654018367221268940354434586262616943544566455807655946219322240663552e+"
        "207"},
    {1e+208, chars_format::scientific, 207,
        "9."
        "9999999999999998186306983081094819829272742169837857217766747946991381065394249388986006597030968254935446"
        "16522696356805028364441642842329313746550197144253860793660984920822957311285732475861572950035529728e+"
        "207"},
    {1e+209, chars_format::scientific, 209,
        "1."
        "0000000000000000731118821832548525711161595357042050700422376244411124222377928518753634101438574126676106"
        "8799969763125334902791605243044670546908252847439043930576054277584733562461577854658781477884848504832e+"
        "209"},
    {1e+210, chars_format::scientific, 209,
        "9."
        "9999999999999992711378241934460557459866815329488267345892539248719464370363227909855805946618104447840072"
        "5843812838336795121561031396504666917998514458446354143529431921823271795036250068185162804696593727488e+"
        "209"},
    {1e+211, chars_format::scientific, 210,
        "9."
        "9999999999999995631340237212665497390216642977674715277558783887797819941046439365391912960171631811624271"
        "82749897969201059028320356032930746282153172616351711759756540926280845609521557638656931995269719916544e+"
        "210"},
    {1e+212, chars_format::scientific, 211,
        "9."
        "9999999999999990959401044767537593501656918740576398586892792465272451027953301036534141738485988029569553"
        "038510666318680865279842887243162229186843277653306392406169861934038413548670665077684456779836676898816e"
        "+211"},
    {1e+213, chars_format::scientific, 212,
        "9."
        "9999999999999998434503752679742239723352477519933705291958378741313041288902322362706575693183018080857103"
        "1008919677160084252852199641809946030023447952696435527124027376600704816231425231719002378564135125254144"
        "e+212"},
    {1e+214, chars_format::scientific, 213,
        "9."
        "9999999999999995444462669514860381234674254008190782609932144230896805184522713832237602111304206060342083"
        "0759394471570774012830691334058616534761441882231086885899095873696576543933537799342139254257827782747750"
        "4e+213"},
    {1e+215, chars_format::scientific, 214,
        "9."
        "9999999999999990660396936451049407652789096389402106318690169014230827417515340183487244380298106827518051"
        "0360154142627877628796278041656489342342232169486529059939205469049971308256917907539158255367736034737520"
        "64e+214"},
    {1e+216, chars_format::scientific, 216,
        "1."
        "0000000000000000214215469580419574424931347467449492941767090953422917405833303694048810293471274498629572"
        "7931833093209082895047886994342159460414833548007346784224294244020182387388080564786631265270395622996207"
        "2064e+216"},
    {1e+217, chars_format::scientific, 216,
        "9."
        "9999999999999996018550557482517698064500472922445423764881181256896722516563598670087645039024937968280966"
        "9207303311043921578914820929146871797851747047760433825014282722254169172214732186358496974124638792508977"
        "9712e+216"},
    {1e+218, chars_format::scientific, 217,
        "1."
        "0000000000000000826575883412587379043412647642654443507046063781156162560010247521088856083040055200431048"
        "8942935855313773632204291895769631741044492391238650185947160215814947857554687910937412833128327366741516"
        "61568e+218"},
    {1e+219, chars_format::scientific, 218,
        "9."
        "9999999999999996508438888548251941759285513062609384217104359519083318639905153731719681670679962529722147"
        "8016185520727674168639944850288849622355474122345476546392575499689981548348018063279122228410984187505225"
        "498624e+218"},
    {1e+220, chars_format::scientific, 219,
        "9."
        "9999999999999999643724207368951101405909769959658731111332700397077533829291106126164716113272119722945705"
        "4393031662703690742880737945597507699179327399689749963213649275279180755601047675571123855843594715481209"
        "6741376e+219"},
    {1e+221, chars_format::scientific, 221,
        "1."
        "0000000000000000466018071748206975684050858099493768614209804580186827813230862995727677122141957123210339"
        "7659598548986531726166600689809136062209749264344058743012736731622189948720589505523832645973577156024278"
        "435495936e+221"},
    {1e+222, chars_format::scientific, 221,
        "1."
        "0000000000000000466018071748206975684050858099493768614209804580186827813230862995727677122141957123210339"
        "7659598548986531726166600689809136062209749264344058743012736731622189948720589505523832645973577156024278"
        "435495936e+222"},
    {1e+223, chars_format::scientific, 221,
        "1."
        "0000000000000000466018071748206975684050858099493768614209804580186827813230862995727677122141957123210339"
        "7659598548986531726166600689809136062209749264344058743012736731622189948720589505523832645973577156024278"
        "435495936e+223"},
    {1e+224, chars_format::scientific, 223,
        "9."
        "9999999999999996954903517948319502092964807244749211214842475260109694882873713352688654575305085714037182"
        "4092248411345058928811833787060802532495190829039301080947896405333883515460849480069503260157387926689005"
        "64521713664e+223"},
    {1e+225, chars_format::scientific, 224,
        "9."
        "9999999999999992845422344863652699560941461244648691253639504304505117149841757830241659030710693437735200"
        "9423588636134254484622941461177838218040629861358615028052178586193608330530158506646130887048916655460323"
        "666687950848e+224"},
    {1e+226, chars_format::scientific, 225,
        "9."
        "9999999999999996133007283331386141586560138044729107222601881068988779336267322248199255466386207258776786"
        "1158516456302898039974055321884209669604278635503163870368752841505828478474711285384828785535693672443269"
        "2495112994816e+225"},
    {1e+227, chars_format::scientific, 225,
        "1."
        "0000000000000000928334703720231990968903484524505077109845138812692342808196957992002964120908826254294312"
        "6809822773697747226137851076470969547585887373208135923963504986275470907025292240033962037948280174037505"
        "1580804694016e+227"},
    {1e+228, chars_format::scientific, 227,
        "9."
        "9999999999999992450912152247524686517867220028639041337364019092767077687470690100086747458429631779210210"
        "7215397297714017257980807797893073643852992008461269166974189675556141912776812173197487139230503413422370"
        "196749149011968e+227"},
    {1e+229, chars_format::scientific, 228,
        "9."
        "9999999999999999183886106229442775786334270115203733241798966706429617845270246028063904958693084084703377"
        "1568529473419399259339888984619722376655344697909305196038533750435568775767256264054340435331422744203442"
        "7503713670135808e+228"},
    {1e+230, chars_format::scientific, 230,
        "1."
        "0000000000000000995664443260051171861588155025370724028889488288828968209774953551282735695911460777349244"
        "3453354095454801046151441888338236034913910900102616284254148427024265175655196680942530570909289367345315"
        "883616691581616128e+230"},
    {1e+231, chars_format::scientific, 231,
        "1."
        "0000000000000000564754110205208414148406263819830583747005651641554565639675781971892197615894599829797681"
        "6934753636209656598064460692387730516014560327977941978394030406231981856423808259127691959958830530175327"
        "2401848696295129088e+231"},
    {1e+232, chars_format::scientific, 231,
        "1."
        "0000000000000000564754110205208414148406263819830583747005651641554565639675781971892197615894599829797681"
        "6934753636209656598064460692387730516014560327977941978394030406231981856423808259127691959958830530175327"
        "2401848696295129088e+232"},
    {1e+233, chars_format::scientific, 232,
        "9."
        "9999999999999997374062707399103193390970327051935144057886852787877127050853725394623645022622268104986814"
        "0190407544589792577374567961627599197278072294985673111426038063107978834995424892432018269339495628089490"
        "44795771481474727936e+232"},
    {1e+234, chars_format::scientific, 234,
        "1."
        "0000000000000000178658451788069303237395289299666618054437734005596700936866924236758275496199492420791481"
        "5574087624726007172578525540816077571080742215354233800343364659602096002392484233181596564547219412071017"
        "4156699571604284243968e+234"},
    {1e+235, chars_format::scientific, 235,
        "1."
        "0000000000000000531660196626596490356033894575245100973356972987043891522292165594595004291349304909025721"
        "6818125120939629504451380536538731692163090204038766991703973342235134497506837628332312354637835291480672"
        "11236930570359138156544e+235"},
    {1e+236, chars_format::scientific, 235,
        "1."
        "0000000000000000531660196626596490356033894575245100973356972987043891522292165594595004291349304909025721"
        "6818125120939629504451380536538731692163090204038766991703973342235134497506837628332312354637835291480672"
        "11236930570359138156544e+236"},
    {1e+237, chars_format::scientific, 235,
        "9."
        "9999999999999994020546131433094915763903576933939556328154082464128816489313932495174721468699049466761532"
        "8372051330560380424582445502262385046995766402482607793500255578094113131409067638500218263478644773697770"
        "82931390365469918625792e+236"},
    {1e+238, chars_format::scientific, 238,
        "1."
        "0000000000000000486475973287265010404848153099971055159735310397418651127357734700791903005570128910531738"
        "9458888321424285845971655097086231964664549661487146743209815430858105570132200393753020733506236458916236"
        "31119178909006652304785408e+238"},
    {1e+239, chars_format::scientific, 238,
        "9."
        "9999999999999999081179145438220670296706622164632687453780292502155740721970192601122065475966761298087599"
        "2606572876278870174311694720942354526832307168264075624845941652321352997368437911380879830217714020914580"
        "56119576436948334022754304e+238"},
    {1e+240, chars_format::scientific, 240,
        "1."
        "0000000000000000139461138041199244379741658569866383311120941709096804894261305436384085130786057242097951"
        "5339949701146446548847363722091034057475758294690703234774682671482523407894986432184061083215557424821369"
        "3581484614981956096327942144e+240"},
    {1e+241, chars_format::scientific, 241,
        "1."
        "0000000000000000509610295637002728139855252735311366616309601643306774209564163318419090863889067021760658"
        "1066817562776141799113274522085911825143802419273576310438824281483144380948014657857618043525615061189227"
        "44139467759619125060885807104e+241"},
    {1e+242, chars_format::scientific, 241,
        "1."
        "0000000000000000509610295637002728139855252735311366616309601643306774209564163318419090863889067021760658"
        "1066817562776141799113274522085911825143802419273576310438824281483144380948014657857618043525615061189227"
        "44139467759619125060885807104e+242"},
    {1e+243, chars_format::scientific, 243,
        "1."
        "0000000000000000746505756498316957746327953001196155931630344001201154571357992362921494533074993280744790"
        "3132012994219146759283457434082633596451350659006615078863874911883541803701952722288694498124051948464656"
        "6146722558989084608335389392896e+243"},
    {1e+244, chars_format::scientific, 243,
        "1."
        "0000000000000000746505756498316957746327953001196155931630344001201154571357992362921494533074993280744790"
        "3132012994219146759283457434082633596451350659006615078863874911883541803701952722288694498124051948464656"
        "6146722558989084608335389392896e+244"},
    {1e+245, chars_format::scientific, 245,
        "1."
        "0000000000000000443279566595834743850042896660863625608019793783096347708261891185958417836517007669245101"
        "0888562841972100410265623306726829729177688912148325455279810104971033102576911999816916636238052732752107"
        "272876955671430431745947427930112e+245"},
    {1e+246, chars_format::scientific, 246,
        "1."
        "0000000000000000685860518517820514967070941733129649866908233957580193198738772127528879193763396158444852"
        "4683322963769737489479890608611472822996618309634957154147061950501040063476944577794338925746852105322146"
        "7463131958534128550160206370177024e+246"},
    {1e+247, chars_format::scientific, 246,
        "9."
        "9999999999999995214719492922888136053363253862527334242437211200577348444497436079906646789807314102860458"
        "4684743791410795092514075595651859726657572016991249995842530919570066511567882035027119361046151169859572"
        "7381924297989722331966923339726848e+246"},
    {1e+248, chars_format::scientific, 248,
        "1."
        "0000000000000000452982804672714174694724018463754266578375331390075701527880966423621236290806863208813091"
        "1440353246844005893434193998802215452930446088047790723234500178792233381012913302936013527818404707654908"
        "851814405278709728676750356293615616e+248"},
    {1e+249, chars_format::scientific, 247,
        "9."
        "9999999999999992109683308321470265755404276937522223728665176967184126166393360027804741417053541441103640"
        "8111814232401040478571454131528428125775275729162364250341707296785977412047465036916114055333519200963067"
        "47820855546959721533975525765152768e+248"},
    {1e+250, chars_format::scientific, 247,
        "9."
        "9999999999999992109683308321470265755404276937522223728665176967184126166393360027804741417053541441103640"
        "8111814232401040478571454131528428125775275729162364250341707296785977412047465036916114055333519200963067"
        "47820855546959721533975525765152768e+249"},
    {1e+251, chars_format::scientific, 251,
        "1."
        "0000000000000000482791152044887786249584424642234315639307542918716276461750765553721414582385299426365956"
        "5935453370610499537728043164857800396298916132410948026391308085570960636368309306117879178753245974556315"
        "302310250472271728848176952226298724352e+251"},
    {1e+252, chars_format::scientific, 252,
        "1."
        "0000000000000000991520280529984090119202023421627152945883953007515421999795337374097790758657277539268193"
        "5985162149558657733676402265539783429787471556208832666934163027927905794433734427088386288041203596340318"
        "7241060084423965317738575228107571068928e+252"},
    {1e+253, chars_format::scientific, 252,
        "9."
        "9999999999999993635870693776759177364257073275700735648394407233581562780527075488933869945869475779810351"
        "8260940569245515066416531433574377226240942000556018171970272123856812886243740399827635383197392066315077"
        "7435958293799716241167969694049028276224e+252"},
    {1e+254, chars_format::scientific, 252,
        "9."
        "9999999999999993635870693776759177364257073275700735648394407233581562780527075488933869945869475779810351"
        "8260940569245515066416531433574377226240942000556018171970272123856812886243740399827635383197392066315077"
        "7435958293799716241167969694049028276224e+253"},
    {1e+255, chars_format::scientific, 254,
        "9."
        "9999999999999998845256969464145328989141284776683389667736846542884813090103490929587961990894531655929258"
        "7569958465674654992927728624557883489163749540246356891129106733591931304833693638565628182306078113383272"
        "782784390994049606075766012189756664840192e+254"},
    {1e+256, chars_format::scientific, 256,
        "1."
        "0000000000000000301276599001405425028904865397746951288321079799032741333776462328211123562691457635682438"
        "4301717278281796693413668637734468849950199557199862786645617442138002603970565622955602242159302695103782"
        "88141352402853119916429412464176397346144256e+256"},
    {1e+257, chars_format::scientific, 256,
        "1."
        "0000000000000000301276599001405425028904865397746951288321079799032741333776462328211123562691457635682438"
        "4301717278281796693413668637734468849950199557199862786645617442138002603970565622955602242159302695103782"
        "88141352402853119916429412464176397346144256e+257"},
    {1e+258, chars_format::scientific, 258,
        "1."
        "0000000000000000567997176316599595992098937026597263174111412691669067749626774798772613075396740496539726"
        "4650338994578968657651041933912824370611847303232008129066549774156440667002371228778987473473667420713674"
        "4674199783831719918405933396323484899269935104e+258"},
    {1e+259, chars_format::scientific, 258,
        "9."
        "9999999999999992877384052036675753687673932081157661223178148070147009535452749400774634144113827644247438"
        "9769547563525432293116501122567178714359381222777104854460745804679379644497043208267383631647167377861948"
        "5458899748089618699435710767754281089234894848e+258"},
    {1e+260, chars_format::scientific, 260,
        "1."
        "0000000000000000653347761057461730700321039947829362977564319217312692202698874789352289719462431012014058"
        "6361897943794063686207001388689898137223574581962294638641248120402340847172549022642470747494264132908839"
        "774942043776657045497009088429335535195969814528e+260"},
    {1e+261, chars_format::scientific, 258,
        "9."
        "9999999999999992877384052036675753687673932081157661223178148070147009535452749400774634144113827644247438"
        "9769547563525432293116501122567178714359381222777104854460745804679379644497043208267383631647167377861948"
        "5458899748089618699435710767754281089234894848e+260"},
    {1e+262, chars_format::scientific, 262,
        "1."
        "0000000000000000161728392950095834780961727121532468109675577629605415353003578843613352249644053642881905"
        "3303318396315116321724674929173953241540025456475844343490985646025955809392324929988807089135627070664687"
        "60361494711018313643605437535869015444666630275072e+262"},
    {1e+263, chars_format::scientific, 262,
        "1."
        "0000000000000000161728392950095834780961727121532468109675577629605415353003578843613352249644053642881905"
        "3303318396315116321724674929173953241540025456475844343490985646025955809392324929988807089135627070664687"
        "60361494711018313643605437535869015444666630275072e+263"},
    {1e+264, chars_format::scientific, 264,
        "1."
        "0000000000000000441405189028952877792863913973825812745630061732834443960830236092744836676918508323988196"
        "9887754761103139711296842870587468559973333403419247178065357187004521519773963524920669081446318377185805"
        "2833032509915549602573975010166573043840478561173504e+264"},
    {1e+265, chars_format::scientific, 265,
        "1."
        "0000000000000000665146625892038512202385663455660488454393649015417666847091561892050024218738072068873230"
        "3155303852933558422954577223718280814719979760973969445724854419787374088079274400866158675294871422402699"
        "42705389409665241931447200154303102433395309881065472e+265"},
    {1e+266, chars_format::scientific, 266,
        "1."
        "0000000000000000307160326911101497147150864284725007320371909363284510229073440613161724151826770077057176"
        "9927225306004888484302202258708981207125345588886413817469658847334809978790776999353375325137186550055668"
        "797052865128496484823152800700833072414104710501367808e+266"},
    {1e+267, chars_format::scientific, 266,
        "9."
        "9999999999999997343822485416022730587751856112282375059371259198714596402444465669404440447686868901514916"
        "7622996309190165824584023146941018349739309135463248122613459314107074039291811569329219648848907543004197"
        "890512187794469896370420793533163493423472892065087488e+266"},
    {1e+268, chars_format::scientific, 266,
        "9."
        "9999999999999997343822485416022730587751856112282375059371259198714596402444465669404440447686868901514916"
        "7622996309190165824584023146941018349739309135463248122613459314107074039291811569329219648848907543004197"
        "890512187794469896370420793533163493423472892065087488e+267"},
    {1e+269, chars_format::scientific, 269,
        "1."
        "0000000000000000467538188854561279891896054313304102868413648727440164393945558946103682581803033369390768"
        "8813404495028932616818466243033147431327741697981638738927986463793558699752023835231102266007829372867138"
        "519293326106230343475263802678137754874196788463928344576e+269"},
    {1e+270, chars_format::scientific, 269,
        "1."
        "0000000000000000467538188854561279891896054313304102868413648727440164393945558946103682581803033369390768"
        "8813404495028932616818466243033147431327741697981638738927986463793558699752023835231102266007829372867138"
        "519293326106230343475263802678137754874196788463928344576e+270"},
    {1e+271, chars_format::scientific, 270,
        "9."
        "9999999999999995290985852539737511455013423746469952044436995337522223092081351007747372543990698759644940"
        "5879902689682400928375844147591690679948638939044369127946865823435090410987852070094314805704679411017385"
        "4458342872794765056233999682236635579342942941443126198272e+270"},
    {1e+272, chars_format::scientific, 272,
        "1."
        "0000000000000000655226109574678785641174996701035524401207638566177752810893043715169471647283826068076023"
        "8458487340241071121614642608687943103994317258797079104154646440083568631482671560875436423095301659220218"
        "514235305581886882057848563849292034690350260273827761094656e+272"},
    {1e+273, chars_format::scientific, 272,
        "9."
        "9999999999999994540234169659267488457897654195544265913261035982571869424291411931484216282067527964903920"
        "7299571308833846909191138684972507989282336695782607667040225918275050684065261167516978177354790265605065"
        "466066369376850351293060923539046438669680406904714953752576e+272"},
    {1e+274, chars_format::scientific, 273,
        "9."
        "9999999999999992137828784441763414867127191632582070293497966046730737687363606887442116243913381421732657"
        "1842510890118474047800081204591123379150169517344970992138978221762923557912970279269500966635145000285641"
        "5308090320884466574359759805482716570229159677380024223137792e+273"},
    {1e+275, chars_format::scientific, 274,
        "9."
        "9999999999999995981677400789769932612359931733321583285118877944076548466448094957909476304960015890806678"
        "8573807560063070626025773173201338755361637002845189671980974536182326959756635700465464503786577424796719"
        "82722077174989256760731188933351130765773907040474247261585408e+274"},
    {1e+276, chars_format::scientific, 276,
        "1."
        "0000000000000000520691408002498557520091850797509641446500906649770649433625086632703114045147193861658433"
        "0872891956793010241376743389786585565826915896804571450360176569078889512418143271133577699295001524362330"
        "7738608946937362752018518070418086469181314516804918593340833792e+276"},
    {1e+277, chars_format::scientific, 277,
        "1."
        "0000000000000000028678785109953723248702060064614983783573429926910385653902272159683291957333224649616958"
        "3131285983040101879363854817804477997671848058660543459340401040833205876982154097220494366539618174024912"
        "75192019201707119869992081071729797163687409453914913289541779456e+277"},
    {1e+278, chars_format::scientific, 277,
        "9."
        "9999999999999996350686867959178558315902274782992576532314485486221746301240205812674342870820492799837784"
        "9380012040377751897535439602187919431477937881453210665245806182366589686333627580900277003353114937549783"
        "34367629875739137498376013657689431411868208826074951744485326848e+277"},
    {1e+279, chars_format::scientific, 279,
        "1."
        "0000000000000000579732922749603937632658625685457000366052203856513881087191824369465492695684870167103410"
        "0601884673643359244818290018424438474005524037381854809282549632468371548670461972003147699225647526402820"
        "9364937790149360843820835266007499279518823345374529865067232493568e+279"},
    {1e+280, chars_format::scientific, 280,
        "1."
        "0000000000000000327822459828620982485707052830214935642633335774409426031973743359279343786724117930538174"
        "9758182415081870163467691069569599399110129304252112477880424562006581527327235514959649032854891251030062"
        "90926013924448356521309485648260046220787856768108551057012647002112e+280"},
    {1e+281, chars_format::scientific, 280,
        "1."
        "0000000000000000327822459828620982485707052830214935642633335774409426031973743359279343786724117930538174"
        "9758182415081870163467691069569599399110129304252112477880424562006581527327235514959649032854891251030062"
        "90926013924448356521309485648260046220787856768108551057012647002112e+281"},
    {1e+282, chars_format::scientific, 280,
        "1."
        "0000000000000000327822459828620982485707052830214935642633335774409426031973743359279343786724117930538174"
        "9758182415081870163467691069569599399110129304252112477880424562006581527327235514959649032854891251030062"
        "90926013924448356521309485648260046220787856768108551057012647002112e+282"},
    {1e+283, chars_format::scientific, 282,
        "9."
        "9999999999999995539535177353613442742718210189113128122905730261845401023437984959874943383966870598097727"
        "9663290767809757055586510986875337610314766840775440358130963455479625817608438389220211297639279730849502"
        "4959839786965342632596166187964530344229899589832462449290116390191104e+282"},
    {1e+284, chars_format::scientific, 284,
        "1."
        "0000000000000000792143825084576765412568191916997109340838993423344357589751710277254453455720576452975216"
        "2833294418062406838213115052098838781957320876356853543120821491881752894667070520582225774709469217797130"
        "505057184069381648545374773244373557467226310750742042216461653692645376e+284"},
    {1e+285, chars_format::scientific, 284,
        "9."
        "9999999999999998015915792052044285019310951985284721180002571056165035998253808522408861618614649384428614"
        "9397221450372619320895438893697947652166455225334059372746413748147206443420891752540620587530362220273863"
        "006901551095990707698442841525909542472844588688081080376132618600579072e+284"},
    {1e+286, chars_format::scientific, 286,
        "1."
        "0000000000000000329886110340869674854270880115045078636847583141738025727786089878914788718586324412860117"
        "3816294023984005882022115176158618240811672377905911327059270770583804511182079226095749373929800486437916"
        "54301923722148311225012721166820834263125344653917287293299907083743789056e+286"},
    {1e+287, chars_format::scientific, 287,
        "1."
        "0000000000000000752521735249401871936142708048258363851925443970635243430154657100253910763966211992393922"
        "0917551527141401041968172205589677021287693862203915638886974287199071604654071266769099226071211897966340"
        "736882502910990345434353553680702253338428636675464684849307718019341877248e+287"},
    {1e+288, chars_format::scientific, 288,
        "1."
        "0000000000000000076304735395750356605147783355117107507800866644399695106364949546111315491358391865139834"
        "5555539522089568786054480958499982972526059487327108739962648660614644255098884001691739462644953639520862"
        "0267012778077787723395914064607119962069483324573977857832138825282954985472e+288"},
    {1e+289, chars_format::scientific, 289,
        "1."
        "0000000000000000617278335278671568869943723109630112583100528505388133765396715589425391709444647966943104"
        "5845149126131034590785433956171738211535366987228554259102109161882186134743033813753627273385960246277244"
        "99484625789034803081540112423670420191213257583185130503608895092113260150784e+289"},
    {1e+290, chars_format::scientific, 289,
        "1."
        "0000000000000000617278335278671568869943723109630112583100528505388133765396715589425391709444647966943104"
        "5845149126131034590785433956171738211535366987228554259102109161882186134743033813753627273385960246277244"
        "99484625789034803081540112423670420191213257583185130503608895092113260150784e+290"},
    {1e+291, chars_format::scientific, 290,
        "9."
        "9999999999999995786090235034628413215355187809651428385251777322903315400557247862623653707190362514808261"
        "2890986863714202457020042006419681526374965874177788623543449994485057258262661745948026767632275613049896"
        "960078961318150545418464661067991669581788285529005480705688196068853638234112e+290"},
    {1e+292, chars_format::scientific, 292,
        "1."
        "0000000000000000132565989783574162680686561089586460035632031477942492726904253214615979418039362499727374"
        "6385658920909881229746500070257845517383027467316859073953152552746468610581875582146175794962018326623525"
        "85538835573636597522107561710941518560028749376834095178551288964115055725510656e+292"},
    {1e+293, chars_format::scientific, 292,
        "9."
        "9999999999999992462348437353960485060448933957923525202610654848990348279466077292501969423268405025328970"
        "2311625456483436552753066788724417337901780594783307353950604674697279949729005300639788058439531021138680"
        "00379620369084502134308975505229555772913629423636305841602377586326247764393984e+292"},
    {1e+294, chars_format::scientific, 294,
        "1."
        "0000000000000000664364677412481031185471561705862924544854611073768567466278840505835448903466875698044061"
        "2078356746066803774429216105089087787538737112019976077088007803912512979947260613395493988432857461329320"
        "5683935969567348590731356020719265634967118123751637393518591968740451429495341056e+294"},
    {1e+295, chars_format::scientific, 294,
        "9."
        "9999999999999998134867772062300415778155607198205813300984837204468478832795008398842977267828545807373626"
        "9700402258157277029368704493591001552896016804949888720722394020468419889626445633965848788795148458000490"
        "2758521100414464490983962613190835886243290260424727924570510530141380583845003264e+294"},
    {1e+296, chars_format::scientific, 294,
        "9."
        "9999999999999998134867772062300415778155607198205813300984837204468478832795008398842977267828545807373626"
        "9700402258157277029368704493591001552896016804949888720722394020468419889626445633965848788795148458000490"
        "2758521100414464490983962613190835886243290260424727924570510530141380583845003264e+295"},
    {1e+297, chars_format::scientific, 297,
        "1."
        "0000000000000000176528014627563797143748787807198647768394431391197448238692552430690122228834703590788220"
        "7282921941122853493440271262470561545049232797945650079545633920176194945116080744729452765622274361759204"
        "8849967890105831362861792425329827928397252374398383022243308510390698430058459037696e+297"},
    {1e+298, chars_format::scientific, 297,
        "9."
        "9999999999999995956620347534297882382556244673937414671209151179964876700316698854008030255517451747068478"
        "7823111966314522286348299614922233214338230100245921475882026911692302152705828545968641468338591362245555"
        "1313826420028155008403585629126369847605750170289266545852965785882018353801250996224e+297"},
    {1e+299, chars_format::scientific, 299,
        "1."
        "0000000000000000525047602552044202487044685811081591549158541155118024579889081957863713750804478640437044"
        "4383288387817694252323536043057564479218478670698284838720092657580373783023379478809005936895323497079994"
        "508111903896764088007465274278014249457925878882005684283811566947219638686545940054016e+299"},
    {1e+300, chars_format::scientific, 299,
        "1."
        "0000000000000000525047602552044202487044685811081591549158541155118024579889081957863713750804478640437044"
        "4383288387817694252323536043057564479218478670698284838720092657580373783023379478809005936895323497079994"
        "508111903896764088007465274278014249457925878882005684283811566947219638686545940054016e+300"},
    {1e+301, chars_format::scientific, 299,
        "1."
        "0000000000000000525047602552044202487044685811081591549158541155118024579889081957863713750804478640437044"
        "4383288387817694252323536043057564479218478670698284838720092657580373783023379478809005936895323497079994"
        "508111903896764088007465274278014249457925878882005684283811566947219638686545940054016e+301"},
    {1e+302, chars_format::scientific, 302,
        "1."
        "0000000000000000762970307908489492534734685515065681170160173420621138028812579448414218896469178407663974"
        "7577138548761372210387844799938291815611350519830750167649856488981626536368095414607314235151058373458986"
        "890825155659063617715863205282622390509284183439858617103083735673849899204570498157510656e+302"},
    {1e+303, chars_format::scientific, 303,
        "1."
        "0000000000000000001617650767864564382126686462316594382954950171011174992257387478652602430342139152537797"
        "7356818033741602744582056777919964339154160602606861115074612228497617725665004420052727680732706769046211"
        "2661427500197051226489898260678763391449376088547292320814127957486330655468919122263277568e+303"},
    {1e+304, chars_format::scientific, 303,
        "9."
        "9999999999999993925355250553646218600402872201173249531907715713232045630132339028433092574405077484368561"
        "1805616217257871719374263603053023579884086688277498730144168201104106771025316244090584371980254855159907"
        "6639682550821832659549112269607949805346034918662572406407604380845959862074904348138143744e+303"},
    {1e+305, chars_format::scientific, 303,
        "9."
        "9999999999999993925355250553646218600402872201173249531907715713232045630132339028433092574405077484368561"
        "1805616217257871719374263603053023579884086688277498730144168201104106771025316244090584371980254855159907"
        "6639682550821832659549112269607949805346034918662572406407604380845959862074904348138143744e+304"},
    {1e+306, chars_format::scientific, 306,
        "1."
        "0000000000000000172160645967364548288310878250132389823288920178923806712445750479879204518754595945686061"
        "3886169829106031104922553294852069693880571144065012262851466942846035699262496802832955068922417528434673"
        "0060716088829214255439694630119794546505512415617982143262670862918816362862119154749127262208e+306"},
    {1e+307, chars_format::scientific, 306,
        "9."
        "9999999999999998603105976025645777170026418381263638752496607358835658526727438490648464142289606667863792"
        "8039265461539335317285025210333627595237061539701073069166468937517856903985107314633964162326607112672001"
        "1020169553304018596457812688561947201171488461172921822139066929851282122002676667750021070848e+306"},
    {1e+308, chars_format::scientific, 308,
        "1."
        "0000000000000000109790636294404554174049230967731184633681068290315758540491149153716332897849468889906124"
        "9669721172515611590283743140088328307009198146046031271664502933027185697489699588559043338384466165001178"
        "426897626212945177628091195786707458122783970171784415105291802893207873272974885715430223118336e+308"},
};

#endif // DOUBLE_SCIENTIFIC_PRECISION_TO_CHARS_TEST_CASES_2_HPP
