// Code generated by smithy-go-codegen DO NOT EDIT.

package iotwireless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotwireless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sets the log-level override for a resource-ID and resource-type. This option
// can be specified for a wireless gateway or a wireless device. A limit of 200 log
// level override can be set per account.
func (c *Client) PutResourceLogLevel(ctx context.Context, params *PutResourceLogLevelInput, optFns ...func(*Options)) (*PutResourceLogLevelOutput, error) {
	if params == nil {
		params = &PutResourceLogLevelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutResourceLogLevel", params, optFns, c.addOperationPutResourceLogLevelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutResourceLogLevelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutResourceLogLevelInput struct {

	// The log level for a log message. The log levels can be disabled, or set to ERROR
	// to display less verbose logs containing only error information, or to INFO for
	// more detailed logs.
	//
	// This member is required.
	LogLevel types.LogLevel

	// The identifier of the resource. For a Wireless Device, it is the wireless
	// device ID. For a wireless gateway, it is the wireless gateway ID.
	//
	// This member is required.
	ResourceIdentifier *string

	// The type of the resource, which can be WirelessDevice or WirelessGateway .
	//
	// This member is required.
	ResourceType *string

	noSmithyDocumentSerde
}

type PutResourceLogLevelOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutResourceLogLevelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutResourceLogLevel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutResourceLogLevel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutResourceLogLevel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutResourceLogLevelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutResourceLogLevel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutResourceLogLevel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutResourceLogLevel",
	}
}
