//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorage

import "time"

type AccessPolicy struct {
	// Expiry time of the access policy
	ExpiryTime *time.Time `json:"expiryTime,omitempty"`

	// List of abbreviated permissions.
	Permission *string `json:"permission,omitempty"`

	// Start time of the access policy
	StartTime *time.Time `json:"startTime,omitempty"`
}

// Account - The storage account.
type Account struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Properties of the storage account.
	Properties *AccountProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the Kind.
	Kind *Kind `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the SKU.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountCheckNameAvailabilityParameters - The parameters used to check the availability of the storage account name.
type AccountCheckNameAvailabilityParameters struct {
	// REQUIRED; The storage account name.
	Name *string `json:"name,omitempty"`

	// CONSTANT; The type of resource, Microsoft.Storage/storageAccounts
	// Field has constant value "Microsoft.Storage/storageAccounts", any specified value is ignored.
	Type *string `json:"type,omitempty"`
}

// AccountCreateParameters - The parameters used when creating a storage account.
type AccountCreateParameters struct {
	// REQUIRED; Required. Indicates the type of storage account.
	Kind *Kind `json:"kind,omitempty"`

	// REQUIRED; Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo
	// Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource
	// cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Required. Gets or sets the SKU name.
	SKU *SKU `json:"sku,omitempty"`

	// Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region.
	// Otherwise it will be created in the specified extended location
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The parameters used to create the storage account.
	Properties *AccountPropertiesCreateParameters `json:"properties,omitempty"`

	// Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this
	// resource (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than
	// 256 characters.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountImmutabilityPolicyProperties - This defines account-level immutability policy properties.
type AccountImmutabilityPolicyProperties struct {
	// This property can only be changed for disabled and unlocked time-based retention policies. When enabled, new blocks can
	// be written to an append blob while maintaining immutability protection and
	// compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
	AllowProtectedAppendWrites *bool `json:"allowProtectedAppendWrites,omitempty"`

	// The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32 `json:"immutabilityPeriodSinceCreationInDays,omitempty"`

	// The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state allows
	// increase and decrease of immutability retention time and also allows toggling
	// allowProtectedAppendWrites property, Locked state only allows the increase of the immutability retention time. A policy
	// can only be created in a Disabled or Unlocked state and can be toggled between
	// the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted.
	State *AccountImmutabilityPolicyState `json:"state,omitempty"`
}

// AccountInternetEndpoints - The URIs that are used to perform a retrieval of a public blob, file, web or dfs object via
// a internet routing endpoint.
type AccountInternetEndpoints struct {
	// READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty" azure:"ro"`

	// READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty" azure:"ro"`

	// READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty" azure:"ro"`
}

// AccountKey - An access key for the storage account.
type AccountKey struct {
	// READ-ONLY; Creation time of the key, in round trip date format.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key.
	KeyName *string `json:"keyName,omitempty" azure:"ro"`

	// READ-ONLY; Permissions for the key -- read-only or full permissions.
	Permissions *KeyPermission `json:"permissions,omitempty" azure:"ro"`

	// READ-ONLY; Base 64-encoded value of the key.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// AccountListKeysResult - The response from the ListKeys operation.
type AccountListKeysResult struct {
	// READ-ONLY; Gets the list of storage account keys and their properties for the specified storage account.
	Keys []*AccountKey `json:"keys,omitempty" azure:"ro"`
}

// AccountListResult - The response from the List Storage Accounts operation.
type AccountListResult struct {
	// READ-ONLY; Request URL that can be used to query next page of storage accounts. Returned when total number of requested
	// storage accounts exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the list of storage accounts and their properties.
	Value []*Account `json:"value,omitempty" azure:"ro"`
}

// AccountMicrosoftEndpoints - The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object
// via a microsoft routing endpoint.
type AccountMicrosoftEndpoints struct {
	// READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty" azure:"ro"`

	// READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty" azure:"ro"`

	// READ-ONLY; Gets the queue endpoint.
	Queue *string `json:"queue,omitempty" azure:"ro"`

	// READ-ONLY; Gets the table endpoint.
	Table *string `json:"table,omitempty" azure:"ro"`

	// READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty" azure:"ro"`
}

// AccountProperties - Properties of the storage account.
type AccountProperties struct {
	// Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for
	// this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`

	// Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
	AllowCrossTenantReplication *bool `json:"allowCrossTenantReplication,omitempty"`

	// Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If
	// false, then all requests, including shared access signatures, must be authorized
	// with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool `json:"allowSharedKeyAccess,omitempty"`

	// Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
	AllowedCopyScope *AllowedCopyScope `json:"allowedCopyScope,omitempty"`

	// Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`

	// Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription,
	// which creates accounts in an Azure DNS Zone and the endpoint URL
	// will have an alphanumeric DNS Zone identifier.
	DNSEndpointType *DNSEndpointType `json:"dnsEndpointType,omitempty"`

	// A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false
	// for this property.
	DefaultToOAuthAuthentication *bool `json:"defaultToOAuthAuthentication,omitempty"`

	// Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`

	// NFS 3.0 protocol support enabled if set to true.
	EnableNfsV3 *bool `json:"isNfsV3Enabled,omitempty"`

	// The property is immutable and can only be set to true at the account creation time. When set to true, it enables object
	// level immutability for all the containers in the account by default.
	ImmutableStorageWithVersioning *ImmutableStorageAccount `json:"immutableStorageWithVersioning,omitempty"`

	// Account HierarchicalNamespace enabled if sets to true.
	IsHnsEnabled *bool `json:"isHnsEnabled,omitempty"`

	// Enables local users feature, if set to true
	IsLocalUserEnabled *bool `json:"isLocalUserEnabled,omitempty"`

	// Enables Secure File Transfer Protocol, if set to true
	IsSftpEnabled *bool `json:"isSftpEnabled,omitempty"`

	// Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
	LargeFileSharesState *LargeFileSharesState `json:"largeFileSharesState,omitempty"`

	// Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
	MinimumTLSVersion *MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`

	// Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`

	// This property is readOnly and is set by server during asynchronous storage account sku conversion operations.
	StorageAccountSKUConversionStatus *AccountSKUConversionStatus `json:"storageAccountSkuConversionStatus,omitempty"`

	// READ-ONLY; Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access
	// tier is the default value for premium block blobs storage account type and it cannot
	// be changed for the premium block blobs storage account type.
	AccessTier *AccessTier `json:"accessTier,omitempty" azure:"ro"`

	// READ-ONLY; Blob restore status
	BlobRestoreStatus *BlobRestoreStatus `json:"blobRestoreStatus,omitempty" azure:"ro"`

	// READ-ONLY; Gets the creation date and time of the storage account in UTC.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the custom domain the user assigned to this storage account.
	CustomDomain *CustomDomain `json:"customDomain,omitempty" azure:"ro"`

	// READ-ONLY; Encryption settings to be used for server-side encryption for the storage account.
	Encryption *Encryption `json:"encryption,omitempty" azure:"ro"`

	// READ-ONLY; If the failover is in progress, the value will be true, otherwise, it will be null.
	FailoverInProgress *bool `json:"failoverInProgress,omitempty" azure:"ro"`

	// READ-ONLY; Geo Replication Stats
	GeoReplicationStats *GeoReplicationStats `json:"geoReplicationStats,omitempty" azure:"ro"`

	// READ-ONLY; Storage account keys creation time.
	KeyCreationTime *KeyCreationTime `json:"keyCreationTime,omitempty" azure:"ro"`

	// READ-ONLY; KeyPolicy assigned to the storage account.
	KeyPolicy *KeyPolicy `json:"keyPolicy,omitempty" azure:"ro"`

	// READ-ONLY; Gets the timestamp of the most recent instance of a failover to the secondary location. Only the most recent
	// timestamp is retained. This element is not returned if there has never been a failover
	// instance. Only available if the accountType is StandardGRS or StandardRAGRS.
	LastGeoFailoverTime *time.Time `json:"lastGeoFailoverTime,omitempty" azure:"ro"`

	// READ-ONLY; Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty" azure:"ro"`

	// READ-ONLY; Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object. Note that StandardZRS
	// and PremiumLRS accounts only return the blob endpoint.
	PrimaryEndpoints *Endpoints `json:"primaryEndpoints,omitempty" azure:"ro"`

	// READ-ONLY; Gets the location of the primary data center for the storage account.
	PrimaryLocation *string `json:"primaryLocation,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connection associated with the specified storage account
	PrivateEndpointConnections []*PrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status of the storage account at the time the operation was called.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; SasPolicy assigned to the storage account.
	SasPolicy *SasPolicy `json:"sasPolicy,omitempty" azure:"ro"`

	// READ-ONLY; Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object from the secondary
	// location of the storage account. Only available if the SKU name is Standard_RAGRS.
	SecondaryEndpoints *Endpoints `json:"secondaryEndpoints,omitempty" azure:"ro"`

	// READ-ONLY; Gets the location of the geo-replicated secondary for the storage account. Only available if the accountType
	// is StandardGRS or StandardRAGRS.
	SecondaryLocation *string `json:"secondaryLocation,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status indicating whether the primary location of the storage account is available or unavailable.
	StatusOfPrimary *AccountStatus `json:"statusOfPrimary,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status indicating whether the secondary location of the storage account is available or unavailable.
	// Only available if the SKU name is StandardGRS or StandardRAGRS.
	StatusOfSecondary *AccountStatus `json:"statusOfSecondary,omitempty" azure:"ro"`
}

// AccountPropertiesCreateParameters - The parameters used to create the storage account.
type AccountPropertiesCreateParameters struct {
	// Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier
	// is the default value for premium block blobs storage account type and it cannot
	// be changed for the premium block blobs storage account type.
	AccessTier *AccessTier `json:"accessTier,omitempty"`

	// Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for
	// this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`

	// Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
	AllowCrossTenantReplication *bool `json:"allowCrossTenantReplication,omitempty"`

	// Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If
	// false, then all requests, including shared access signatures, must be authorized
	// with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool `json:"allowSharedKeyAccess,omitempty"`

	// Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
	AllowedCopyScope *AllowedCopyScope `json:"allowedCopyScope,omitempty"`

	// Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`

	// User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage
	// account at this time. To clear the existing custom domain, use an empty string
	// for the custom domain name property.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`

	// Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription,
	// which creates accounts in an Azure DNS Zone and the endpoint URL
	// will have an alphanumeric DNS Zone identifier.
	DNSEndpointType *DNSEndpointType `json:"dnsEndpointType,omitempty"`

	// A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false
	// for this property.
	DefaultToOAuthAuthentication *bool `json:"defaultToOAuthAuthentication,omitempty"`

	// Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`

	// NFS 3.0 protocol support enabled if set to true.
	EnableNfsV3 *bool `json:"isNfsV3Enabled,omitempty"`

	// Encryption settings to be used for server-side encryption for the storage account.
	Encryption *Encryption `json:"encryption,omitempty"`

	// The property is immutable and can only be set to true at the account creation time. When set to true, it enables object
	// level immutability for all the new containers in the account by default.
	ImmutableStorageWithVersioning *ImmutableStorageAccount `json:"immutableStorageWithVersioning,omitempty"`

	// Account HierarchicalNamespace enabled if sets to true.
	IsHnsEnabled *bool `json:"isHnsEnabled,omitempty"`

	// Enables local users feature, if set to true
	IsLocalUserEnabled *bool `json:"isLocalUserEnabled,omitempty"`

	// Enables Secure File Transfer Protocol, if set to true
	IsSftpEnabled *bool `json:"isSftpEnabled,omitempty"`

	// KeyPolicy assigned to the storage account.
	KeyPolicy *KeyPolicy `json:"keyPolicy,omitempty"`

	// Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
	LargeFileSharesState *LargeFileSharesState `json:"largeFileSharesState,omitempty"`

	// Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
	MinimumTLSVersion *MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`

	// Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`

	// Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`

	// SasPolicy assigned to the storage account.
	SasPolicy *SasPolicy `json:"sasPolicy,omitempty"`
}

// AccountPropertiesUpdateParameters - The parameters used when updating a storage account.
type AccountPropertiesUpdateParameters struct {
	// Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier
	// is the default value for premium block blobs storage account type and it cannot
	// be changed for the premium block blobs storage account type.
	AccessTier *AccessTier `json:"accessTier,omitempty"`

	// Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for
	// this property.
	AllowBlobPublicAccess *bool `json:"allowBlobPublicAccess,omitempty"`

	// Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
	AllowCrossTenantReplication *bool `json:"allowCrossTenantReplication,omitempty"`

	// Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If
	// false, then all requests, including shared access signatures, must be authorized
	// with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool `json:"allowSharedKeyAccess,omitempty"`

	// Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
	AllowedCopyScope *AllowedCopyScope `json:"allowedCopyScope,omitempty"`

	// Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication `json:"azureFilesIdentityBasedAuthentication,omitempty"`

	// Custom domain assigned to the storage account by the user. Name is the CNAME source. Only one custom domain is supported
	// per storage account at this time. To clear the existing custom domain, use an
	// empty string for the custom domain name property.
	CustomDomain *CustomDomain `json:"customDomain,omitempty"`

	// Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription,
	// which creates accounts in an Azure DNS Zone and the endpoint URL
	// will have an alphanumeric DNS Zone identifier.
	DNSEndpointType *DNSEndpointType `json:"dnsEndpointType,omitempty"`

	// A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false
	// for this property.
	DefaultToOAuthAuthentication *bool `json:"defaultToOAuthAuthentication,omitempty"`

	// Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool `json:"supportsHttpsTrafficOnly,omitempty"`

	// Not applicable. Azure Storage encryption at rest is enabled by default for all storage accounts and cannot be disabled.
	Encryption *Encryption `json:"encryption,omitempty"`

	// The property is immutable and can only be set to true at the account creation time. When set to true, it enables object
	// level immutability for all the containers in the account by default.
	ImmutableStorageWithVersioning *ImmutableStorageAccount `json:"immutableStorageWithVersioning,omitempty"`

	// Enables local users feature, if set to true
	IsLocalUserEnabled *bool `json:"isLocalUserEnabled,omitempty"`

	// Enables Secure File Transfer Protocol, if set to true
	IsSftpEnabled *bool `json:"isSftpEnabled,omitempty"`

	// KeyPolicy assigned to the storage account.
	KeyPolicy *KeyPolicy `json:"keyPolicy,omitempty"`

	// Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
	LargeFileSharesState *LargeFileSharesState `json:"largeFileSharesState,omitempty"`

	// Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
	MinimumTLSVersion *MinimumTLSVersion `json:"minimumTlsVersion,omitempty"`

	// Network rule set
	NetworkRuleSet *NetworkRuleSet `json:"networkAcls,omitempty"`

	// Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference `json:"routingPreference,omitempty"`

	// SasPolicy assigned to the storage account.
	SasPolicy *SasPolicy `json:"sasPolicy,omitempty"`
}

// AccountRegenerateKeyParameters - The parameters used to regenerate the storage account key.
type AccountRegenerateKeyParameters struct {
	// REQUIRED; The name of storage keys that want to be regenerated, possible values are key1, key2, kerb1, kerb2.
	KeyName *string `json:"keyName,omitempty"`
}

// AccountSKUConversionStatus - This defines the sku conversion status object for asynchronous sku conversions.
type AccountSKUConversionStatus struct {
	// This property represents the target sku name to which the account sku is being converted asynchronously.
	TargetSKUName *SKUName `json:"targetSkuName,omitempty"`

	// READ-ONLY; This property represents the sku conversion end time.
	EndTime *string `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; This property indicates the current sku conversion status.
	SKUConversionStatus *SKUConversionStatus `json:"skuConversionStatus,omitempty" azure:"ro"`

	// READ-ONLY; This property represents the sku conversion start time.
	StartTime *string `json:"startTime,omitempty" azure:"ro"`
}

// AccountSasParameters - The parameters to list SAS credentials of a storage account.
type AccountSasParameters struct {
	// REQUIRED; The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l),
	// Add (a), Create (c), Update (u) and Process (p).
	Permissions *Permissions `json:"signedPermission,omitempty"`

	// REQUIRED; The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs;
	// Container (c): Access to container-level APIs; Object (o): Access to object-level APIs
	// for blobs, queue messages, table entities, and files.
	ResourceTypes *SignedResourceTypes `json:"signedResourceTypes,omitempty"`

	// REQUIRED; The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t),
	// File (f).
	Services *Services `json:"signedServices,omitempty"`

	// REQUIRED; The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *time.Time `json:"signedExpiry,omitempty"`

	// An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string `json:"signedIp,omitempty"`

	// The key to sign the account SAS token with.
	KeyToSign *string `json:"keyToSign,omitempty"`

	// The protocol permitted for a request made with the account SAS.
	Protocols *HTTPProtocol `json:"signedProtocol,omitempty"`

	// The time at which the SAS becomes valid.
	SharedAccessStartTime *time.Time `json:"signedStart,omitempty"`
}

// AccountUpdateParameters - The parameters that can be provided when updating the storage account properties.
type AccountUpdateParameters struct {
	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Optional. Indicates the type of storage account. Currently only StorageV2 value supported by server.
	Kind *Kind `json:"kind,omitempty"`

	// The parameters used when updating a storage account.
	Properties *AccountPropertiesUpdateParameters `json:"properties,omitempty"`

	// Gets or sets the SKU name. Note that the SKU name cannot be updated to StandardZRS, PremiumLRS or Premium_ZRS, nor can
	// accounts of those SKU names be updated to any other value.
	SKU *SKU `json:"sku,omitempty"`

	// Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this
	// resource (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountsClientBeginAbortHierarchicalNamespaceMigrationOptions contains the optional parameters for the AccountsClient.BeginAbortHierarchicalNamespaceMigration
// method.
type AccountsClientBeginAbortHierarchicalNamespaceMigrationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginCreateOptions contains the optional parameters for the AccountsClient.BeginCreate method.
type AccountsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginFailoverOptions contains the optional parameters for the AccountsClient.BeginFailover method.
type AccountsClientBeginFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginHierarchicalNamespaceMigrationOptions contains the optional parameters for the AccountsClient.BeginHierarchicalNamespaceMigration
// method.
type AccountsClientBeginHierarchicalNamespaceMigrationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginRestoreBlobRangesOptions contains the optional parameters for the AccountsClient.BeginRestoreBlobRanges
// method.
type AccountsClientBeginRestoreBlobRangesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientCheckNameAvailabilityOptions contains the optional parameters for the AccountsClient.CheckNameAvailability
// method.
type AccountsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientDeleteOptions contains the optional parameters for the AccountsClient.Delete method.
type AccountsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientGetPropertiesOptions contains the optional parameters for the AccountsClient.GetProperties method.
type AccountsClientGetPropertiesOptions struct {
	// May be used to expand the properties within account's properties. By default, data is not included when fetching properties.
	// Currently we only support geoReplicationStats and blobRestoreStatus.
	Expand *StorageAccountExpand
}

// AccountsClientListAccountSASOptions contains the optional parameters for the AccountsClient.ListAccountSAS method.
type AccountsClientListAccountSASOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListByResourceGroupOptions contains the optional parameters for the AccountsClient.ListByResourceGroup method.
type AccountsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListKeysOptions contains the optional parameters for the AccountsClient.ListKeys method.
type AccountsClientListKeysOptions struct {
	// Specifies type of the key to be listed. Possible value is kerb.. Specifying any value will set the value to kerb.
	Expand *string
}

// AccountsClientListOptions contains the optional parameters for the AccountsClient.List method.
type AccountsClientListOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListServiceSASOptions contains the optional parameters for the AccountsClient.ListServiceSAS method.
type AccountsClientListServiceSASOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientRegenerateKeyOptions contains the optional parameters for the AccountsClient.RegenerateKey method.
type AccountsClientRegenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientRevokeUserDelegationKeysOptions contains the optional parameters for the AccountsClient.RevokeUserDelegationKeys
// method.
type AccountsClientRevokeUserDelegationKeysOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientUpdateOptions contains the optional parameters for the AccountsClient.Update method.
type AccountsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ActiveDirectoryProperties - Settings properties for Active Directory (AD).
type ActiveDirectoryProperties struct {
	// REQUIRED; Specifies the domain GUID.
	DomainGUID *string `json:"domainGuid,omitempty"`

	// REQUIRED; Specifies the primary domain that the AD DNS server is authoritative for.
	DomainName *string `json:"domainName,omitempty"`

	// Specifies the Active Directory account type for Azure Storage.
	AccountType *ActiveDirectoryPropertiesAccountType `json:"accountType,omitempty"`

	// Specifies the security identifier (SID) for Azure Storage.
	AzureStorageSid *string `json:"azureStorageSid,omitempty"`

	// Specifies the security identifier (SID).
	DomainSid *string `json:"domainSid,omitempty"`

	// Specifies the Active Directory forest to get.
	ForestName *string `json:"forestName,omitempty"`

	// Specifies the NetBIOS domain name.
	NetBiosDomainName *string `json:"netBiosDomainName,omitempty"`

	// Specifies the Active Directory SAMAccountName for Azure Storage.
	SamAccountName *string `json:"samAccountName,omitempty"`
}

// AzureEntityResource - The resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureFilesIdentityBasedAuthentication - Settings for Azure Files identity based authentication.
type AzureFilesIdentityBasedAuthentication struct {
	// REQUIRED; Indicates the directory service used. Note that this enum may be extended in the future.
	DirectoryServiceOptions *DirectoryServiceOptions `json:"directoryServiceOptions,omitempty"`

	// Required if directoryServiceOptions are AD, optional if they are AADKERB.
	ActiveDirectoryProperties *ActiveDirectoryProperties `json:"activeDirectoryProperties,omitempty"`

	// Default share permission for users using Kerberos authentication if RBAC role is not assigned.
	DefaultSharePermission *DefaultSharePermission `json:"defaultSharePermission,omitempty"`
}

// BlobContainer - Properties of the blob container, including Id, resource name, resource type, Etag.
type BlobContainer struct {
	// Properties of the blob container.
	ContainerProperties *ContainerProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BlobContainersClientBeginObjectLevelWormOptions contains the optional parameters for the BlobContainersClient.BeginObjectLevelWorm
// method.
type BlobContainersClientBeginObjectLevelWormOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BlobContainersClientClearLegalHoldOptions contains the optional parameters for the BlobContainersClient.ClearLegalHold
// method.
type BlobContainersClientClearLegalHoldOptions struct {
	// placeholder for future optional parameters
}

// BlobContainersClientCreateOptions contains the optional parameters for the BlobContainersClient.Create method.
type BlobContainersClientCreateOptions struct {
	// placeholder for future optional parameters
}

// BlobContainersClientCreateOrUpdateImmutabilityPolicyOptions contains the optional parameters for the BlobContainersClient.CreateOrUpdateImmutabilityPolicy
// method.
type BlobContainersClientCreateOrUpdateImmutabilityPolicyOptions struct {
	// The entity state (ETag) version of the immutability policy to update. A value of "*" can be used to apply the operation
	// only if the immutability policy already exists. If omitted, this operation will
	// always be applied.
	IfMatch *string
	// The ImmutabilityPolicy Properties that will be created or updated to a blob container.
	Parameters *ImmutabilityPolicy
}

// BlobContainersClientDeleteImmutabilityPolicyOptions contains the optional parameters for the BlobContainersClient.DeleteImmutabilityPolicy
// method.
type BlobContainersClientDeleteImmutabilityPolicyOptions struct {
	// placeholder for future optional parameters
}

// BlobContainersClientDeleteOptions contains the optional parameters for the BlobContainersClient.Delete method.
type BlobContainersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// BlobContainersClientExtendImmutabilityPolicyOptions contains the optional parameters for the BlobContainersClient.ExtendImmutabilityPolicy
// method.
type BlobContainersClientExtendImmutabilityPolicyOptions struct {
	// The ImmutabilityPolicy Properties that will be extended for a blob container.
	Parameters *ImmutabilityPolicy
}

// BlobContainersClientGetImmutabilityPolicyOptions contains the optional parameters for the BlobContainersClient.GetImmutabilityPolicy
// method.
type BlobContainersClientGetImmutabilityPolicyOptions struct {
	// The entity state (ETag) version of the immutability policy to update. A value of "*" can be used to apply the operation
	// only if the immutability policy already exists. If omitted, this operation will
	// always be applied.
	IfMatch *string
}

// BlobContainersClientGetOptions contains the optional parameters for the BlobContainersClient.Get method.
type BlobContainersClientGetOptions struct {
	// placeholder for future optional parameters
}

// BlobContainersClientLeaseOptions contains the optional parameters for the BlobContainersClient.Lease method.
type BlobContainersClientLeaseOptions struct {
	// Lease Container request body.
	Parameters *LeaseContainerRequest
}

// BlobContainersClientListOptions contains the optional parameters for the BlobContainersClient.List method.
type BlobContainersClientListOptions struct {
	// Optional. When specified, only container names starting with the filter will be listed.
	Filter *string
	// Optional, used to include the properties for soft deleted blob containers.
	Include *ListContainersInclude
	// Optional. Specified maximum number of containers that can be included in the list.
	Maxpagesize *string
}

// BlobContainersClientLockImmutabilityPolicyOptions contains the optional parameters for the BlobContainersClient.LockImmutabilityPolicy
// method.
type BlobContainersClientLockImmutabilityPolicyOptions struct {
	// placeholder for future optional parameters
}

// BlobContainersClientSetLegalHoldOptions contains the optional parameters for the BlobContainersClient.SetLegalHold method.
type BlobContainersClientSetLegalHoldOptions struct {
	// placeholder for future optional parameters
}

// BlobContainersClientUpdateOptions contains the optional parameters for the BlobContainersClient.Update method.
type BlobContainersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// BlobInventoryPoliciesClientCreateOrUpdateOptions contains the optional parameters for the BlobInventoryPoliciesClient.CreateOrUpdate
// method.
type BlobInventoryPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// BlobInventoryPoliciesClientDeleteOptions contains the optional parameters for the BlobInventoryPoliciesClient.Delete method.
type BlobInventoryPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// BlobInventoryPoliciesClientGetOptions contains the optional parameters for the BlobInventoryPoliciesClient.Get method.
type BlobInventoryPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BlobInventoryPoliciesClientListOptions contains the optional parameters for the BlobInventoryPoliciesClient.List method.
type BlobInventoryPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// BlobInventoryPolicy - The storage account blob inventory policy.
type BlobInventoryPolicy struct {
	// Returns the storage account blob inventory policy rules.
	Properties *BlobInventoryPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BlobInventoryPolicyDefinition - An object that defines the blob inventory rule.
type BlobInventoryPolicyDefinition struct {
	// REQUIRED; This is a required field, it specifies the format for the inventory files.
	Format *Format `json:"format,omitempty"`

	// REQUIRED; This is a required field. This field specifies the scope of the inventory created either at the blob or container
	// level.
	ObjectType *ObjectType `json:"objectType,omitempty"`

	// REQUIRED; This is a required field. This field is used to schedule an inventory formation.
	Schedule *Schedule `json:"schedule,omitempty"`

	// REQUIRED; This is a required field. This field specifies the fields and properties of the object to be included in the
	// inventory. The Schema field value 'Name' is always required. The valid values for this
	// field for the 'Blob' definition.objectType include 'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType,
	// AccessTier, AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time,
	// hdiisfolder, Owner, Group, Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag,
	// ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl,
	// ContentDisposition, LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime, RemainingRetentionDays,
	// ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold,
	// CopyId, CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription, CustomerProvidedKeySha256, RehydratePriority,
	// ArchiveStatus, XmsBlobSequenceNumber, EncryptionScope,
	// IncrementalCopy, TagCount'. For Blob object type schema field value 'DeletedTime' is applicable only for Hns enabled accounts.
	// The valid values for 'Container' definition.objectType include 'Name,
	// Last-Modified, Metadata, LeaseStatus, LeaseState, LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag,
	// DefaultEncryptionScope, DenyEncryptionScopeOverride,
	// ImmutableStorageWithVersioningEnabled, Deleted, Version, DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time,
	// hdiisfolder, Owner, Group, Permissions, Acl, DeletionId' are valid only
	// for Hns enabled accounts.Schema field values 'Tags, TagCount' are only valid for Non-Hns accounts.
	SchemaFields []*string `json:"schemaFields,omitempty"`

	// An object that defines the filter set.
	Filters *BlobInventoryPolicyFilter `json:"filters,omitempty"`
}

// BlobInventoryPolicyFilter - An object that defines the blob inventory rule filter conditions. For 'Blob' definition.objectType
// all filter properties are applicable, 'blobTypes' is required and others are optional. For
// 'Container' definition.objectType only prefixMatch is applicable and is optional.
type BlobInventoryPolicyFilter struct {
	// An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support
	// pageBlobs. This field is required when definition.objectType property is set to
	// 'Blob'.
	BlobTypes []*string `json:"blobTypes,omitempty"`

	// An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
	ExcludePrefix []*string `json:"excludePrefix,omitempty"`

	// Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values 'VersionId and IsCurrentVersion'
	// are required if this property is set to true, else they must be
	// excluded.
	IncludeBlobVersions *bool `json:"includeBlobVersions,omitempty"`

	// For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime and RemainingRetentionDays'.
	// For 'Blob' definition.objectType and HNS enabled storage
	// accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for
	// Hns disabled accounts the definition.schemaFields must include 'Deleted and
	// RemainingRetentionDays', else it must be excluded.
	IncludeDeleted *bool `json:"includeDeleted,omitempty"`

	// Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value 'Snapshot' is required
	// if this property is set to true, else it must be excluded.
	IncludeSnapshots *bool `json:"includeSnapshots,omitempty"`

	// An array of strings with maximum 10 blob prefixes to be included in the inventory.
	PrefixMatch []*string `json:"prefixMatch,omitempty"`
}

// BlobInventoryPolicyProperties - The storage account blob inventory policy properties.
type BlobInventoryPolicyProperties struct {
	// REQUIRED; The storage account blob inventory policy object. It is composed of policy rules.
	Policy *BlobInventoryPolicySchema `json:"policy,omitempty"`

	// READ-ONLY; Returns the last modified date and time of the blob inventory policy.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`
}

// BlobInventoryPolicyRule - An object that wraps the blob inventory rule. Each rule is uniquely defined by name.
type BlobInventoryPolicyRule struct {
	// REQUIRED; An object that defines the blob inventory policy rule.
	Definition *BlobInventoryPolicyDefinition `json:"definition,omitempty"`

	// REQUIRED; Container name where blob inventory files are stored. Must be pre-created.
	Destination *string `json:"destination,omitempty"`

	// REQUIRED; Rule is enabled when set to true.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be
	// unique within a policy.
	Name *string `json:"name,omitempty"`
}

// BlobInventoryPolicySchema - The storage account blob inventory policy rules.
type BlobInventoryPolicySchema struct {
	// REQUIRED; Policy is enabled if set to true.
	Enabled *bool `json:"enabled,omitempty"`

	// REQUIRED; The storage account blob inventory policy rules. The rule is applied when it is enabled.
	Rules []*BlobInventoryPolicyRule `json:"rules,omitempty"`

	// REQUIRED; The valid value is Inventory
	Type *InventoryRuleType `json:"type,omitempty"`

	// READ-ONLY; Deprecated Property from API version 2021-04-01 onwards, the required destination container name must be specified
	// at the rule level 'policy.rule.destination'
	Destination *string `json:"destination,omitempty" azure:"ro"`
}

// BlobRestoreParameters - Blob restore parameters
type BlobRestoreParameters struct {
	// REQUIRED; Blob ranges to restore.
	BlobRanges []*BlobRestoreRange `json:"blobRanges,omitempty"`

	// REQUIRED; Restore blob to the specified time.
	TimeToRestore *time.Time `json:"timeToRestore,omitempty"`
}

// BlobRestoreRange - Blob range
type BlobRestoreRange struct {
	// REQUIRED; Blob end range. This is exclusive. Empty means account end.
	EndRange *string `json:"endRange,omitempty"`

	// REQUIRED; Blob start range. This is inclusive. Empty means account start.
	StartRange *string `json:"startRange,omitempty"`
}

// BlobRestoreStatus - Blob restore status.
type BlobRestoreStatus struct {
	// READ-ONLY; Failure reason when blob restore is failed.
	FailureReason *string `json:"failureReason,omitempty" azure:"ro"`

	// READ-ONLY; Blob restore request parameters.
	Parameters *BlobRestoreParameters `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; Id for tracking blob restore request.
	RestoreID *string `json:"restoreId,omitempty" azure:"ro"`

	// READ-ONLY; The status of blob restore progress. Possible values are: - InProgress: Indicates that blob restore is ongoing.
	// - Complete: Indicates that blob restore has been completed successfully. - Failed:
	// Indicates that blob restore is failed.
	Status *BlobRestoreProgressStatus `json:"status,omitempty" azure:"ro"`
}

type BlobServiceItems struct {
	// READ-ONLY; List of blob services returned.
	Value []*BlobServiceProperties `json:"value,omitempty" azure:"ro"`
}

// BlobServiceProperties - The properties of a storage account’s Blob service.
type BlobServiceProperties struct {
	// The properties of a storage account’s Blob service.
	BlobServiceProperties *BlobServicePropertiesProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Sku name and tier.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BlobServicePropertiesProperties - The properties of a storage account’s Blob service.
type BlobServicePropertiesProperties struct {
	// Deprecated in favor of isVersioningEnabled property.
	AutomaticSnapshotPolicyEnabled *bool `json:"automaticSnapshotPolicyEnabled,omitempty"`

	// The blob service properties for change feed events.
	ChangeFeed *ChangeFeed `json:"changeFeed,omitempty"`

	// The blob service properties for container soft delete.
	ContainerDeleteRetentionPolicy *DeleteRetentionPolicy `json:"containerDeleteRetentionPolicy,omitempty"`

	// Specifies CORS rules for the Blob service. You can include up to five CorsRule elements in the request. If no CorsRule
	// elements are included in the request body, all CORS rules will be deleted, and
	// CORS will be disabled for the Blob service.
	Cors *CorsRules `json:"cors,omitempty"`

	// DefaultServiceVersion indicates the default version to use for requests to the Blob service if an incoming request’s version
	// is not specified. Possible values include version 2008-10-27 and all more
	// recent versions.
	DefaultServiceVersion *string `json:"defaultServiceVersion,omitempty"`

	// The blob service properties for blob soft delete.
	DeleteRetentionPolicy *DeleteRetentionPolicy `json:"deleteRetentionPolicy,omitempty"`

	// Versioning is enabled if set to true.
	IsVersioningEnabled *bool `json:"isVersioningEnabled,omitempty"`

	// The blob service property to configure last access time based tracking policy.
	LastAccessTimeTrackingPolicy *LastAccessTimeTrackingPolicy `json:"lastAccessTimeTrackingPolicy,omitempty"`

	// The blob service properties for blob restore policy.
	RestorePolicy *RestorePolicyProperties `json:"restorePolicy,omitempty"`
}

// BlobServicesClientGetServicePropertiesOptions contains the optional parameters for the BlobServicesClient.GetServiceProperties
// method.
type BlobServicesClientGetServicePropertiesOptions struct {
	// placeholder for future optional parameters
}

// BlobServicesClientListOptions contains the optional parameters for the BlobServicesClient.List method.
type BlobServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// BlobServicesClientSetServicePropertiesOptions contains the optional parameters for the BlobServicesClient.SetServiceProperties
// method.
type BlobServicesClientSetServicePropertiesOptions struct {
	// placeholder for future optional parameters
}

// ChangeFeed - The blob service properties for change feed events.
type ChangeFeed struct {
	// Indicates whether change feed event logging is enabled for the Blob service.
	Enabled *bool `json:"enabled,omitempty"`

	// Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years).
	// A null value indicates an infinite retention of the change feed.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
}

// CheckNameAvailabilityResult - The CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	// READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available.
	// If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; Gets the reason that a storage account name could not be used. The Reason element is only returned if NameAvailable
	// is false.
	Reason *Reason `json:"reason,omitempty" azure:"ro"`
}

// CloudError - An error response from the Storage service.
type CloudError struct {
	// An error response from the Storage service.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the Storage service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// ContainerProperties - The properties of a container.
type ContainerProperties struct {
	// Default the container to use specified encryption scope for all writes.
	DefaultEncryptionScope *string `json:"defaultEncryptionScope,omitempty"`

	// Block override of encryption scope from the container default.
	DenyEncryptionScopeOverride *bool `json:"denyEncryptionScopeOverride,omitempty"`

	// Enable NFSv3 all squash on blob container.
	EnableNfsV3AllSquash *bool `json:"enableNfsV3AllSquash,omitempty"`

	// Enable NFSv3 root squash on blob container.
	EnableNfsV3RootSquash *bool `json:"enableNfsV3RootSquash,omitempty"`

	// The object level immutability property of the container. The property is immutable and can only be set to true at the container
	// creation time. Existing containers must undergo a migration process.
	ImmutableStorageWithVersioning *ImmutableStorageWithVersioning `json:"immutableStorageWithVersioning,omitempty"`

	// A name-value pair to associate with the container as metadata.
	Metadata map[string]*string `json:"metadata,omitempty"`

	// Specifies whether data in the container may be accessed publicly and the level of access.
	PublicAccess *PublicAccess `json:"publicAccess,omitempty"`

	// READ-ONLY; Indicates whether the blob container was deleted.
	Deleted *bool `json:"deleted,omitempty" azure:"ro"`

	// READ-ONLY; Blob container deletion time.
	DeletedTime *time.Time `json:"deletedTime,omitempty" azure:"ro"`

	// READ-ONLY; The hasImmutabilityPolicy public property is set to true by SRP if ImmutabilityPolicy has been created for this
	// container. The hasImmutabilityPolicy public property is set to false by SRP if
	// ImmutabilityPolicy has not been created for this container.
	HasImmutabilityPolicy *bool `json:"hasImmutabilityPolicy,omitempty" azure:"ro"`

	// READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold
	// public property is set to false by SRP if all existing legal hold tags are cleared out.
	// There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty" azure:"ro"`

	// READ-ONLY; The ImmutabilityPolicy property of the container.
	ImmutabilityPolicy *ImmutabilityPolicyProperties `json:"immutabilityPolicy,omitempty" azure:"ro"`

	// READ-ONLY; Returns the date and time the container was last modified.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Specifies whether the lease on a container is of infinite or fixed duration, only when the container is leased.
	LeaseDuration *LeaseDuration `json:"leaseDuration,omitempty" azure:"ro"`

	// READ-ONLY; Lease state of the container.
	LeaseState *LeaseState `json:"leaseState,omitempty" azure:"ro"`

	// READ-ONLY; The lease status of the container.
	LeaseStatus *LeaseStatus `json:"leaseStatus,omitempty" azure:"ro"`

	// READ-ONLY; The LegalHold property of the container.
	LegalHold *LegalHoldProperties `json:"legalHold,omitempty" azure:"ro"`

	// READ-ONLY; Remaining retention days for soft deleted blob container.
	RemainingRetentionDays *int32 `json:"remainingRetentionDays,omitempty" azure:"ro"`

	// READ-ONLY; The version of the deleted blob container.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// CorsRule - Specifies a CORS rule for the Blob service.
type CorsRule struct {
	// REQUIRED; Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
	AllowedHeaders []*string `json:"allowedHeaders,omitempty"`

	// REQUIRED; Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
	AllowedMethods []*CorsRuleAllowedMethodsItem `json:"allowedMethods,omitempty"`

	// REQUIRED; Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow
	// all domains
	AllowedOrigins []*string `json:"allowedOrigins,omitempty"`

	// REQUIRED; Required if CorsRule element is present. A list of response headers to expose to CORS clients.
	ExposedHeaders []*string `json:"exposedHeaders,omitempty"`

	// REQUIRED; Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight
	// response.
	MaxAgeInSeconds *int32 `json:"maxAgeInSeconds,omitempty"`
}

// CorsRules - Sets the CORS rules. You can include up to five CorsRule elements in the request.
type CorsRules struct {
	// The List of CORS rules. You can include up to five CorsRule elements in the request.
	CorsRules []*CorsRule `json:"corsRules,omitempty"`
}

// CustomDomain - The custom domain assigned to this storage account. This can be set via Update.
type CustomDomain struct {
	// REQUIRED; Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
	Name *string `json:"name,omitempty"`

	// Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
	UseSubDomainName *bool `json:"useSubDomainName,omitempty"`
}

// DateAfterCreation - Object to define snapshot and version action conditions.
type DateAfterCreation struct {
	// REQUIRED; Value indicating the age in days after creation
	DaysAfterCreationGreaterThan *float32 `json:"daysAfterCreationGreaterThan,omitempty"`

	// Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions
	// and requires daysAfterCreationGreaterThan to be set for snapshots and blob
	// version based actions. The blob will be archived if both the conditions are satisfied.
	DaysAfterLastTierChangeGreaterThan *float32 `json:"daysAfterLastTierChangeGreaterThan,omitempty"`
}

// DateAfterModification - Object to define the base blob action conditions. Properties daysAfterModificationGreaterThan,
// daysAfterLastAccessTimeGreaterThan and daysAfterCreationGreaterThan are mutually exclusive. The
// daysAfterLastTierChangeGreaterThan property is only applicable for tierToArchive actions which requires daysAfterModificationGreaterThan
// to be set, also it cannot be used in conjunction with
// daysAfterLastAccessTimeGreaterThan or daysAfterCreationGreaterThan.
type DateAfterModification struct {
	// Value indicating the age in days after blob creation.
	DaysAfterCreationGreaterThan *float32 `json:"daysAfterCreationGreaterThan,omitempty"`

	// Value indicating the age in days after last blob access. This property can only be used in conjunction with last access
	// time tracking policy
	DaysAfterLastAccessTimeGreaterThan *float32 `json:"daysAfterLastAccessTimeGreaterThan,omitempty"`

	// Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions
	// and requires daysAfterModificationGreaterThan to be set for baseBlobs
	// based actions. The blob will be archived if both the conditions are satisfied.
	DaysAfterLastTierChangeGreaterThan *float32 `json:"daysAfterLastTierChangeGreaterThan,omitempty"`

	// Value indicating the age in days after last modification
	DaysAfterModificationGreaterThan *float32 `json:"daysAfterModificationGreaterThan,omitempty"`
}

// DeleteRetentionPolicy - The service properties for soft delete.
type DeleteRetentionPolicy struct {
	// This property when set to true allows deletion of the soft deleted blob versions and snapshots. This property cannot be
	// used blob restore policy. This property only applies to blob service and does
	// not apply to containers or file share.
	AllowPermanentDelete *bool `json:"allowPermanentDelete,omitempty"`

	// Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum
	// value can be 365.
	Days *int32 `json:"days,omitempty"`

	// Indicates whether DeleteRetentionPolicy is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// DeletedAccount - Deleted storage account
type DeletedAccount struct {
	// Properties of the deleted account.
	Properties *DeletedAccountProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeletedAccountListResult - The response from the List Deleted Accounts operation.
type DeletedAccountListResult struct {
	// READ-ONLY; Request URL that can be used to query next page of deleted accounts. Returned when total number of requested
	// deleted accounts exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the list of deleted accounts and their properties.
	Value []*DeletedAccount `json:"value,omitempty" azure:"ro"`
}

// DeletedAccountProperties - Attributes of a deleted storage account.
type DeletedAccountProperties struct {
	// READ-ONLY; Creation time of the deleted account.
	CreationTime *string `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Deletion time of the deleted account.
	DeletionTime *string `json:"deletionTime,omitempty" azure:"ro"`

	// READ-ONLY; Location of the deleted account.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Can be used to attempt recovering this deleted account via PutStorageAccount API.
	RestoreReference *string `json:"restoreReference,omitempty" azure:"ro"`

	// READ-ONLY; Full resource id of the original storage account.
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty" azure:"ro"`
}

// DeletedAccountsClientGetOptions contains the optional parameters for the DeletedAccountsClient.Get method.
type DeletedAccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeletedAccountsClientListOptions contains the optional parameters for the DeletedAccountsClient.List method.
type DeletedAccountsClientListOptions struct {
	// placeholder for future optional parameters
}

// DeletedShare - The deleted share to be restored.
type DeletedShare struct {
	// REQUIRED; Required. Identify the name of the deleted share that will be restored.
	DeletedShareName *string `json:"deletedShareName,omitempty"`

	// REQUIRED; Required. Identify the version of the deleted share that will be restored.
	DeletedShareVersion *string `json:"deletedShareVersion,omitempty"`
}

// Dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// Display name of dimension.
	Name *string `json:"name,omitempty"`
}

// Encryption - The encryption settings on the storage account.
type Encryption struct {
	// The identity to be used with service-side encryption at rest.
	EncryptionIdentity *EncryptionIdentity `json:"identity,omitempty"`

	// The encryption keySource (provider). Possible values (case-insensitive): Microsoft.Storage, Microsoft.Keyvault
	KeySource *KeySource `json:"keySource,omitempty"`

	// Properties provided by key vault.
	KeyVaultProperties *KeyVaultProperties `json:"keyvaultproperties,omitempty"`

	// A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for
	// data at rest.
	RequireInfrastructureEncryption *bool `json:"requireInfrastructureEncryption,omitempty"`

	// List of services which support encryption.
	Services *EncryptionServices `json:"services,omitempty"`
}

// EncryptionIdentity - Encryption identity for the storage account.
type EncryptionIdentity struct {
	// ClientId of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys
	// server-side encryption on the storage account.
	EncryptionFederatedIdentityClientID *string `json:"federatedIdentityClientId,omitempty"`

	// Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
	EncryptionUserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// EncryptionScope - The Encryption Scope resource.
type EncryptionScope struct {
	// Properties of the encryption scope.
	EncryptionScopeProperties *EncryptionScopeProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EncryptionScopeKeyVaultProperties - The key vault properties for the encryption scope. This is a required field if encryption
// scope 'source' attribute is set to 'Microsoft.KeyVault'.
type EncryptionScopeKeyVaultProperties struct {
	// The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the
	// identifier to enable customer-managed key support on this encryption scope.
	KeyURI *string `json:"keyUri,omitempty"`

	// READ-ONLY; The object identifier of the current versioned Key Vault Key in use.
	CurrentVersionedKeyIdentifier *string `json:"currentVersionedKeyIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of last rotation of the Key Vault Key.
	LastKeyRotationTimestamp *time.Time `json:"lastKeyRotationTimestamp,omitempty" azure:"ro"`
}

// EncryptionScopeListResult - List of encryption scopes requested, and if paging is required, a URL to the next page of encryption
// scopes.
type EncryptionScopeListResult struct {
	// READ-ONLY; Request URL that can be used to query next page of encryption scopes. Returned when total number of requested
	// encryption scopes exceeds the maximum page size.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of encryption scopes requested.
	Value []*EncryptionScope `json:"value,omitempty" azure:"ro"`
}

// EncryptionScopeProperties - Properties of the encryption scope.
type EncryptionScopeProperties struct {
	// The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set
	// to 'Microsoft.KeyVault'.
	KeyVaultProperties *EncryptionScopeKeyVaultProperties `json:"keyVaultProperties,omitempty"`

	// A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for
	// data at rest.
	RequireInfrastructureEncryption *bool `json:"requireInfrastructureEncryption,omitempty"`

	// The provider for the encryption scope. Possible values (case-insensitive): Microsoft.Storage, Microsoft.KeyVault.
	Source *EncryptionScopeSource `json:"source,omitempty"`

	// The state of the encryption scope. Possible values (case-insensitive): Enabled, Disabled.
	State *EncryptionScopeState `json:"state,omitempty"`

	// READ-ONLY; Gets the creation date and time of the encryption scope in UTC.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the last modification date and time of the encryption scope in UTC.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`
}

// EncryptionScopesClientGetOptions contains the optional parameters for the EncryptionScopesClient.Get method.
type EncryptionScopesClientGetOptions struct {
	// placeholder for future optional parameters
}

// EncryptionScopesClientListOptions contains the optional parameters for the EncryptionScopesClient.List method.
type EncryptionScopesClientListOptions struct {
	// placeholder for future optional parameters
}

// EncryptionScopesClientPatchOptions contains the optional parameters for the EncryptionScopesClient.Patch method.
type EncryptionScopesClientPatchOptions struct {
	// placeholder for future optional parameters
}

// EncryptionScopesClientPutOptions contains the optional parameters for the EncryptionScopesClient.Put method.
type EncryptionScopesClientPutOptions struct {
	// placeholder for future optional parameters
}

// EncryptionService - A service that allows server-side encryption to be used.
type EncryptionService struct {
	// A boolean indicating whether or not the service encrypts the data as it is stored. Encryption at rest is enabled by default
	// today and cannot be disabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption
	// key will be used. 'Service' key type implies that a default service key is used.
	KeyType *KeyType `json:"keyType,omitempty"`

	// READ-ONLY; Gets a rough estimate of the date/time when the encryption was last enabled by the user. Data is encrypted at
	// rest by default today and cannot be disabled.
	LastEnabledTime *time.Time `json:"lastEnabledTime,omitempty" azure:"ro"`
}

// EncryptionServices - A list of services that support encryption.
type EncryptionServices struct {
	// The encryption function of the blob storage service.
	Blob *EncryptionService `json:"blob,omitempty"`

	// The encryption function of the file storage service.
	File *EncryptionService `json:"file,omitempty"`

	// The encryption function of the queue storage service.
	Queue *EncryptionService `json:"queue,omitempty"`

	// The encryption function of the table storage service.
	Table *EncryptionService `json:"table,omitempty"`
}

// Endpoints - The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.
type Endpoints struct {
	// Gets the internet routing storage endpoints
	InternetEndpoints *AccountInternetEndpoints `json:"internetEndpoints,omitempty"`

	// Gets the microsoft routing storage endpoints.
	MicrosoftEndpoints *AccountMicrosoftEndpoints `json:"microsoftEndpoints,omitempty"`

	// READ-ONLY; Gets the blob endpoint.
	Blob *string `json:"blob,omitempty" azure:"ro"`

	// READ-ONLY; Gets the dfs endpoint.
	Dfs *string `json:"dfs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the file endpoint.
	File *string `json:"file,omitempty" azure:"ro"`

	// READ-ONLY; Gets the queue endpoint.
	Queue *string `json:"queue,omitempty" azure:"ro"`

	// READ-ONLY; Gets the table endpoint.
	Table *string `json:"table,omitempty" azure:"ro"`

	// READ-ONLY; Gets the web endpoint.
	Web *string `json:"web,omitempty" azure:"ro"`
}

// ErrorResponse - An error response from the storage resource provider.
type ErrorResponse struct {
	// Azure Storage Resource Provider error response body.
	Error *ErrorResponseBody `json:"error,omitempty"`
}

// ErrorResponseBody - Error response body contract.
type ErrorResponseBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string `json:"name,omitempty"`

	// The type of the extended location.
	Type *ExtendedLocationTypes `json:"type,omitempty"`
}

type FileServiceItems struct {
	// READ-ONLY; List of file services returned.
	Value []*FileServiceProperties `json:"value,omitempty" azure:"ro"`
}

// FileServiceProperties - The properties of File services in storage account.
type FileServiceProperties struct {
	// The properties of File services in storage account.
	FileServiceProperties *FileServicePropertiesProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Sku name and tier.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FileServicePropertiesProperties - The properties of File services in storage account.
type FileServicePropertiesProperties struct {
	// Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule
	// elements are included in the request body, all CORS rules will be deleted, and
	// CORS will be disabled for the File service.
	Cors *CorsRules `json:"cors,omitempty"`

	// Protocol settings for file service
	ProtocolSettings *ProtocolSettings `json:"protocolSettings,omitempty"`

	// The file service properties for share soft delete.
	ShareDeleteRetentionPolicy *DeleteRetentionPolicy `json:"shareDeleteRetentionPolicy,omitempty"`
}

// FileServicesClientGetServicePropertiesOptions contains the optional parameters for the FileServicesClient.GetServiceProperties
// method.
type FileServicesClientGetServicePropertiesOptions struct {
	// placeholder for future optional parameters
}

// FileServicesClientListOptions contains the optional parameters for the FileServicesClient.List method.
type FileServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// FileServicesClientSetServicePropertiesOptions contains the optional parameters for the FileServicesClient.SetServiceProperties
// method.
type FileServicesClientSetServicePropertiesOptions struct {
	// placeholder for future optional parameters
}

// FileShare - Properties of the file share, including Id, resource name, resource type, Etag.
type FileShare struct {
	// Properties of the file share.
	FileShareProperties *FileShareProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FileShareItem - The file share properties be listed out.
type FileShareItem struct {
	// The file share properties be listed out.
	Properties *FileShareProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FileShareItems - Response schema. Contains list of shares returned, and if paging is requested or required, a URL to next
// page of shares.
type FileShareItems struct {
	// READ-ONLY; Request URL that can be used to query next page of shares. Returned when total number of requested shares exceed
	// maximum page size.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of file shares returned.
	Value []*FileShareItem `json:"value,omitempty" azure:"ro"`
}

// FileShareProperties - The properties of the file share.
type FileShareProperties struct {
	// Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage
	// account can choose Premium.
	AccessTier *ShareAccessTier `json:"accessTier,omitempty"`

	// The authentication protocol that is used for the file share. Can only be specified when creating a share.
	EnabledProtocols *EnabledProtocols `json:"enabledProtocols,omitempty"`

	// A name-value pair to associate with the share as metadata.
	Metadata map[string]*string `json:"metadata,omitempty"`

	// The property is for NFS share only. The default is NoRootSquash.
	RootSquash *RootSquashType `json:"rootSquash,omitempty"`

	// The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File
	// Shares, the maximum size is 102400.
	ShareQuota *int32 `json:"shareQuota,omitempty"`

	// List of stored access policies specified on the share.
	SignedIdentifiers []*SignedIdentifier `json:"signedIdentifiers,omitempty"`

	// READ-ONLY; Indicates the last modification time for share access tier.
	AccessTierChangeTime *time.Time `json:"accessTierChangeTime,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if there is a pending transition for access tier.
	AccessTierStatus *string `json:"accessTierStatus,omitempty" azure:"ro"`

	// READ-ONLY; Indicates whether the share was deleted.
	Deleted *bool `json:"deleted,omitempty" azure:"ro"`

	// READ-ONLY; The deleted time if the share was deleted.
	DeletedTime *time.Time `json:"deletedTime,omitempty" azure:"ro"`

	// READ-ONLY; Returns the date and time the share was last modified.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Specifies whether the lease on a share is of infinite or fixed duration, only when the share is leased.
	LeaseDuration *LeaseDuration `json:"leaseDuration,omitempty" azure:"ro"`

	// READ-ONLY; Lease state of the share.
	LeaseState *LeaseState `json:"leaseState,omitempty" azure:"ro"`

	// READ-ONLY; The lease status of the share.
	LeaseStatus *LeaseStatus `json:"leaseStatus,omitempty" azure:"ro"`

	// READ-ONLY; Remaining retention days for share that was soft deleted.
	RemainingRetentionDays *int32 `json:"remainingRetentionDays,omitempty" azure:"ro"`

	// READ-ONLY; The approximate size of the data stored on the share. Note that this value may not include all recently created
	// or recently resized files.
	ShareUsageBytes *int64 `json:"shareUsageBytes,omitempty" azure:"ro"`

	// READ-ONLY; Creation time of share snapshot returned in the response of list shares with expand param "snapshots".
	SnapshotTime *time.Time `json:"snapshotTime,omitempty" azure:"ro"`

	// READ-ONLY; The version of the share.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// FileSharesClientCreateOptions contains the optional parameters for the FileSharesClient.Create method.
type FileSharesClientCreateOptions struct {
	// Optional, used to expand the properties within share's properties. Valid values are: snapshots. Should be passed as a string
	// with delimiter ','
	Expand *string
}

// FileSharesClientDeleteOptions contains the optional parameters for the FileSharesClient.Delete method.
type FileSharesClientDeleteOptions struct {
	// Optional. Valid values are: snapshots, leased-snapshots, none. The default value is snapshots. For 'snapshots', the file
	// share is deleted including all of its file share snapshots. If the file share
	// contains leased-snapshots, the deletion fails. For 'leased-snapshots', the file share is deleted included all of its file
	// share snapshots (leased/unleased). For 'none', the file share is deleted if it
	// has no share snapshots. If the file share contains any snapshots (leased or unleased), the deletion fails.
	Include *string
	// Optional, used to delete a snapshot.
	XMSSnapshot *string
}

// FileSharesClientGetOptions contains the optional parameters for the FileSharesClient.Get method.
type FileSharesClientGetOptions struct {
	// Optional, used to expand the properties within share's properties. Valid values are: stats. Should be passed as a string
	// with delimiter ','.
	Expand *string
	// Optional, used to retrieve properties of a snapshot.
	XMSSnapshot *string
}

// FileSharesClientLeaseOptions contains the optional parameters for the FileSharesClient.Lease method.
type FileSharesClientLeaseOptions struct {
	// Lease Share request body.
	Parameters *LeaseShareRequest
	// Optional. Specify the snapshot time to lease a snapshot.
	XMSSnapshot *string
}

// FileSharesClientListOptions contains the optional parameters for the FileSharesClient.List method.
type FileSharesClientListOptions struct {
	// Optional, used to expand the properties within share's properties. Valid values are: deleted, snapshots. Should be passed
	// as a string with delimiter ','
	Expand *string
	// Optional. When specified, only share names starting with the filter will be listed.
	Filter *string
	// Optional. Specified maximum number of shares that can be included in the list.
	Maxpagesize *string
}

// FileSharesClientRestoreOptions contains the optional parameters for the FileSharesClient.Restore method.
type FileSharesClientRestoreOptions struct {
	// placeholder for future optional parameters
}

// FileSharesClientUpdateOptions contains the optional parameters for the FileSharesClient.Update method.
type FileSharesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// GeoReplicationStats - Statistics related to replication for storage account's Blob, Table, Queue and File services. It
// is only available when geo-redundant replication is enabled for the storage account.
type GeoReplicationStats struct {
	// READ-ONLY; A boolean flag which indicates whether or not account failover is supported for the account.
	CanFailover *bool `json:"canFailover,omitempty" azure:"ro"`

	// READ-ONLY; All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary
	// writes following this point in time may or may not be available for reads. Element may
	// be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap.
	LastSyncTime *time.Time `json:"lastSyncTime,omitempty" azure:"ro"`

	// READ-ONLY; The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is
	// active and operational. - Bootstrap: Indicates initial synchronization from the primary
	// location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable:
	// Indicates that the secondary location is temporarily unavailable.
	Status *GeoReplicationStatus `json:"status,omitempty" azure:"ro"`
}

// IPRule - IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// REQUIRED; Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string `json:"value,omitempty"`

	// The action of IP ACL rule.
	Action *string `json:"action,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// REQUIRED; The identity type.
	Type *IdentityType `json:"type,omitempty"`

	// Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage
	// account. The key is the ARM resource identifier of the identity. Only 1
	// User Assigned identity is permitted here.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ImmutabilityPolicy - The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.
type ImmutabilityPolicy struct {
	// REQUIRED; The properties of an ImmutabilityPolicy of a blob container.
	Properties *ImmutabilityPolicyProperty `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ImmutabilityPolicyProperties - The properties of an ImmutabilityPolicy of a blob container.
type ImmutabilityPolicyProperties struct {
	// The properties of an ImmutabilityPolicy of a blob container.
	Properties *ImmutabilityPolicyProperty `json:"properties,omitempty"`

	// READ-ONLY; ImmutabilityPolicy Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The ImmutabilityPolicy update history of the blob container.
	UpdateHistory []*UpdateHistoryProperty `json:"updateHistory,omitempty" azure:"ro"`
}

// ImmutabilityPolicyProperty - The properties of an ImmutabilityPolicy of a blob container.
type ImmutabilityPolicyProperty struct {
	// This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to
	// an append blob while maintaining immutability protection and compliance. Only
	// new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy
	// API.
	AllowProtectedAppendWrites *bool `json:"allowProtectedAppendWrites,omitempty"`

	// This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to
	// both 'Append and Bock Blobs' while maintaining immutability protection and
	// compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be
	// changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and
	// 'allowProtectedAppendWritesAll' properties are mutually exclusive.
	AllowProtectedAppendWritesAll *bool `json:"allowProtectedAppendWritesAll,omitempty"`

	// The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32 `json:"immutabilityPeriodSinceCreationInDays,omitempty"`

	// READ-ONLY; The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked.
	State *ImmutabilityPolicyState `json:"state,omitempty" azure:"ro"`
}

// ImmutableStorageAccount - This property enables and defines account-level immutability. Enabling the feature auto-enables
// Blob Versioning.
type ImmutableStorageAccount struct {
	// A boolean flag which enables account-level immutability. All the containers under such an account have object-level immutability
	// enabled by default.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the default account-level immutability policy which is inherited and applied to objects that do not possess an
	// explicit immutability policy at the object level. The object-level immutability
	// policy has higher precedence than the container-level immutability policy, which has a higher precedence than the account-level
	// immutability policy.
	ImmutabilityPolicy *AccountImmutabilityPolicyProperties `json:"immutabilityPolicy,omitempty"`
}

// ImmutableStorageWithVersioning - Object level immutability properties of the container.
type ImmutableStorageWithVersioning struct {
	// This is an immutable property, when set to true it enables object level immutability at the container level.
	Enabled *bool `json:"enabled,omitempty"`

	// READ-ONLY; This property denotes the container level immutability to object level immutability migration state.
	MigrationState *MigrationState `json:"migrationState,omitempty" azure:"ro"`

	// READ-ONLY; Returns the date and time the object level immutability was enabled.
	TimeStamp *time.Time `json:"timeStamp,omitempty" azure:"ro"`
}

// KeyCreationTime - Storage account keys creation time.
type KeyCreationTime struct {
	Key1 *time.Time `json:"key1,omitempty"`
	Key2 *time.Time `json:"key2,omitempty"`
}

// KeyPolicy assigned to the storage account.
type KeyPolicy struct {
	// REQUIRED; The key expiration period in days.
	KeyExpirationPeriodInDays *int32 `json:"keyExpirationPeriodInDays,omitempty"`
}

// KeyVaultProperties - Properties of key vault.
type KeyVaultProperties struct {
	// The name of KeyVault key.
	KeyName *string `json:"keyname,omitempty"`

	// The Uri of KeyVault.
	KeyVaultURI *string `json:"keyvaulturi,omitempty"`

	// The version of KeyVault key.
	KeyVersion *string `json:"keyversion,omitempty"`

	// READ-ONLY; This is a read only property that represents the expiration time of the current version of the customer managed
	// key used for encryption.
	CurrentVersionedKeyExpirationTimestamp *time.Time `json:"currentVersionedKeyExpirationTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; The object identifier of the current versioned Key Vault Key in use.
	CurrentVersionedKeyIdentifier *string `json:"currentVersionedKeyIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of last rotation of the Key Vault Key.
	LastKeyRotationTimestamp *time.Time `json:"lastKeyRotationTimestamp,omitempty" azure:"ro"`
}

// LastAccessTimeTrackingPolicy - The blob service properties for Last access time based tracking policy.
type LastAccessTimeTrackingPolicy struct {
	// REQUIRED; When set to true last access time based tracking is enabled.
	Enable *bool `json:"enable,omitempty"`

	// An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
	BlobType []*string `json:"blobType,omitempty"`

	// Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
	Name *Name `json:"name,omitempty"`

	// The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This
	// field is currently read only with value as 1
	TrackingGranularityInDays *int32 `json:"trackingGranularityInDays,omitempty"`
}

// LeaseContainerRequest - Lease Container request schema.
type LeaseContainerRequest struct {
	// REQUIRED; Specifies the lease action. Can be one of the available actions.
	Action *LeaseContainerRequestAction `json:"action,omitempty"`

	// Optional. For a break action, proposed duration the lease should continue before it is broken, in seconds, between 0 and
	// 60.
	BreakPeriod *int32 `json:"breakPeriod,omitempty"`

	// Required for acquire. Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires.
	LeaseDuration *int32 `json:"leaseDuration,omitempty"`

	// Identifies the lease. Can be specified in any valid GUID string format.
	LeaseID *string `json:"leaseId,omitempty"`

	// Optional for acquire, required for change. Proposed lease ID, in a GUID string format.
	ProposedLeaseID *string `json:"proposedLeaseId,omitempty"`
}

// LeaseContainerResponse - Lease Container response schema.
type LeaseContainerResponse struct {
	// Returned unique lease ID that must be included with any request to delete the container, or to renew, change, or release
	// the lease.
	LeaseID *string `json:"leaseId,omitempty"`

	// Approximate time remaining in the lease period, in seconds.
	LeaseTimeSeconds *string `json:"leaseTimeSeconds,omitempty"`
}

// LeaseShareRequest - Lease Share request schema.
type LeaseShareRequest struct {
	// REQUIRED; Specifies the lease action. Can be one of the available actions.
	Action *LeaseShareAction `json:"action,omitempty"`

	// Optional. For a break action, proposed duration the lease should continue before it is broken, in seconds, between 0 and
	// 60.
	BreakPeriod *int32 `json:"breakPeriod,omitempty"`

	// Required for acquire. Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires.
	LeaseDuration *int32 `json:"leaseDuration,omitempty"`

	// Identifies the lease. Can be specified in any valid GUID string format.
	LeaseID *string `json:"leaseId,omitempty"`

	// Optional for acquire, required for change. Proposed lease ID, in a GUID string format.
	ProposedLeaseID *string `json:"proposedLeaseId,omitempty"`
}

// LeaseShareResponse - Lease Share response schema.
type LeaseShareResponse struct {
	// Returned unique lease ID that must be included with any request to delete the share, or to renew, change, or release the
	// lease.
	LeaseID *string `json:"leaseId,omitempty"`

	// Approximate time remaining in the lease period, in seconds.
	LeaseTimeSeconds *string `json:"leaseTimeSeconds,omitempty"`
}

// LegalHold - The LegalHold property of a blob container.
type LegalHold struct {
	// REQUIRED; Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
	Tags []*string `json:"tags,omitempty"`

	// When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance.
	// Only new blocks can be added and any existing blocks cannot be modified
	// or deleted.
	AllowProtectedAppendWritesAll *bool `json:"allowProtectedAppendWritesAll,omitempty"`

	// READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold
	// public property is set to false by SRP if all existing legal hold tags are cleared out.
	// There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty" azure:"ro"`
}

// LegalHoldProperties - The LegalHold property of a blob container.
type LegalHoldProperties struct {
	// Protected append blob writes history.
	ProtectedAppendWritesHistory *ProtectedAppendWritesHistory `json:"protectedAppendWritesHistory,omitempty"`

	// The list of LegalHold tags of a blob container.
	Tags []*TagProperty `json:"tags,omitempty"`

	// READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold
	// public property is set to false by SRP if all existing legal hold tags are cleared out.
	// There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool `json:"hasLegalHold,omitempty" azure:"ro"`
}

// ListAccountSasResponse - The List SAS credentials operation response.
type ListAccountSasResponse struct {
	// READ-ONLY; List SAS credentials of storage account.
	AccountSasToken *string `json:"accountSasToken,omitempty" azure:"ro"`
}

// ListBlobInventoryPolicy - List of blob inventory policies returned.
type ListBlobInventoryPolicy struct {
	// READ-ONLY; List of blob inventory policies.
	Value []*BlobInventoryPolicy `json:"value,omitempty" azure:"ro"`
}

// ListContainerItem - The blob container properties be listed out.
type ListContainerItem struct {
	// The blob container properties be listed out.
	Properties *ContainerProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ListContainerItems - Response schema. Contains list of blobs returned, and if paging is requested or required, a URL to
// next page of containers.
type ListContainerItems struct {
	// READ-ONLY; Request URL that can be used to query next page of containers. Returned when total number of requested containers
	// exceed maximum page size.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of blobs containers returned.
	Value []*ListContainerItem `json:"value,omitempty" azure:"ro"`
}

type ListQueue struct {
	// List Queue resource properties.
	QueueProperties *ListQueueProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ListQueueProperties struct {
	// A name-value pair that represents queue metadata.
	Metadata map[string]*string `json:"metadata,omitempty"`
}

// ListQueueResource - Response schema. Contains list of queues returned
type ListQueueResource struct {
	// READ-ONLY; Request URL that can be used to list next page of queues
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of queues returned.
	Value []*ListQueue `json:"value,omitempty" azure:"ro"`
}

type ListQueueServices struct {
	// READ-ONLY; List of queue services returned.
	Value []*QueueServiceProperties `json:"value,omitempty" azure:"ro"`
}

// ListServiceSasResponse - The List service SAS credentials operation response.
type ListServiceSasResponse struct {
	// READ-ONLY; List service SAS credentials of specific resource.
	ServiceSasToken *string `json:"serviceSasToken,omitempty" azure:"ro"`
}

// ListTableResource - Response schema. Contains list of tables returned
type ListTableResource struct {
	// READ-ONLY; Request URL that can be used to query next page of tables
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of tables returned.
	Value []*Table `json:"value,omitempty" azure:"ro"`
}

type ListTableServices struct {
	// READ-ONLY; List of table services returned.
	Value []*TableServiceProperties `json:"value,omitempty" azure:"ro"`
}

// LocalUser - The local user associated with the storage accounts.
type LocalUser struct {
	// Storage account local user properties.
	Properties *LocalUserProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LocalUserKeys - The Storage Account Local User keys.
type LocalUserKeys struct {
	// Optional, local user ssh authorized keys for SFTP.
	SSHAuthorizedKeys []*SSHPublicKey `json:"sshAuthorizedKeys,omitempty"`

	// READ-ONLY; Auto generated by the server for SMB authentication.
	SharedKey *string `json:"sharedKey,omitempty" azure:"ro"`
}

// LocalUserProperties - The Storage Account Local User properties.
type LocalUserProperties struct {
	// Indicates whether ssh key exists. Set it to false to remove existing SSH key.
	HasSSHKey *bool `json:"hasSshKey,omitempty"`

	// Indicates whether ssh password exists. Set it to false to remove existing SSH password.
	HasSSHPassword *bool `json:"hasSshPassword,omitempty"`

	// Indicates whether shared key exists. Set it to false to remove existing shared key.
	HasSharedKey *bool `json:"hasSharedKey,omitempty"`

	// Optional, local user home directory.
	HomeDirectory *string `json:"homeDirectory,omitempty"`

	// The permission scopes of the local user.
	PermissionScopes []*PermissionScope `json:"permissionScopes,omitempty"`

	// Optional, local user ssh authorized keys for SFTP.
	SSHAuthorizedKeys []*SSHPublicKey `json:"sshAuthorizedKeys,omitempty"`

	// READ-ONLY; A unique Security Identifier that is generated by the server.
	Sid *string `json:"sid,omitempty" azure:"ro"`
}

// LocalUserRegeneratePasswordResult - The secrets of Storage Account Local User.
type LocalUserRegeneratePasswordResult struct {
	// READ-ONLY; Auto generated password by the server for SSH authentication if hasSshPassword is set to true on the creation
	// of local user.
	SSHPassword *string `json:"sshPassword,omitempty" azure:"ro"`
}

// LocalUsers - List storage account local users.
type LocalUsers struct {
	// The local users associated with the storage account.
	Value []*LocalUser `json:"value,omitempty"`
}

// LocalUsersClientCreateOrUpdateOptions contains the optional parameters for the LocalUsersClient.CreateOrUpdate method.
type LocalUsersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// LocalUsersClientDeleteOptions contains the optional parameters for the LocalUsersClient.Delete method.
type LocalUsersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// LocalUsersClientGetOptions contains the optional parameters for the LocalUsersClient.Get method.
type LocalUsersClientGetOptions struct {
	// placeholder for future optional parameters
}

// LocalUsersClientListKeysOptions contains the optional parameters for the LocalUsersClient.ListKeys method.
type LocalUsersClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// LocalUsersClientListOptions contains the optional parameters for the LocalUsersClient.List method.
type LocalUsersClientListOptions struct {
	// placeholder for future optional parameters
}

// LocalUsersClientRegeneratePasswordOptions contains the optional parameters for the LocalUsersClient.RegeneratePassword
// method.
type LocalUsersClientRegeneratePasswordOptions struct {
	// placeholder for future optional parameters
}

// ManagementPoliciesClientCreateOrUpdateOptions contains the optional parameters for the ManagementPoliciesClient.CreateOrUpdate
// method.
type ManagementPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagementPoliciesClientDeleteOptions contains the optional parameters for the ManagementPoliciesClient.Delete method.
type ManagementPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagementPoliciesClientGetOptions contains the optional parameters for the ManagementPoliciesClient.Get method.
type ManagementPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagementPolicy - The Get Storage Account ManagementPolicies operation response.
type ManagementPolicy struct {
	// Returns the Storage Account Data Policies Rules.
	Properties *ManagementPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagementPolicyAction - Actions are applied to the filtered blobs when the execution condition is met.
type ManagementPolicyAction struct {
	// The management policy action for base blob
	BaseBlob *ManagementPolicyBaseBlob `json:"baseBlob,omitempty"`

	// The management policy action for snapshot
	Snapshot *ManagementPolicySnapShot `json:"snapshot,omitempty"`

	// The management policy action for version
	Version *ManagementPolicyVersion `json:"version,omitempty"`
}

// ManagementPolicyBaseBlob - Management policy action for base blob.
type ManagementPolicyBaseBlob struct {
	// The function to delete the blob
	Delete *DateAfterModification `json:"delete,omitempty"`

	// This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
	EnableAutoTierToHotFromCool *bool `json:"enableAutoTierToHotFromCool,omitempty"`

	// The function to tier blobs to archive storage. Support blobs currently at Hot or Cool tier
	TierToArchive *DateAfterModification `json:"tierToArchive,omitempty"`

	// The function to tier blobs to cool storage. Support blobs currently at Hot tier
	TierToCool *DateAfterModification `json:"tierToCool,omitempty"`
}

// ManagementPolicyDefinition - An object that defines the Lifecycle rule. Each definition is made up with a filters set and
// an actions set.
type ManagementPolicyDefinition struct {
	// REQUIRED; An object that defines the action set.
	Actions *ManagementPolicyAction `json:"actions,omitempty"`

	// An object that defines the filter set.
	Filters *ManagementPolicyFilter `json:"filters,omitempty"`
}

// ManagementPolicyFilter - Filters limit rule actions to a subset of blobs within the storage account. If multiple filters
// are defined, a logical AND is performed on all filters.
type ManagementPolicyFilter struct {
	// REQUIRED; An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete
	// actions are supported for appendBlob.
	BlobTypes []*string `json:"blobTypes,omitempty"`

	// An array of blob index tag based filters, there can be at most 10 tag filters
	BlobIndexMatch []*TagFilter `json:"blobIndexMatch,omitempty"`

	// An array of strings for prefixes to be match.
	PrefixMatch []*string `json:"prefixMatch,omitempty"`
}

// ManagementPolicyProperties - The Storage Account ManagementPolicy properties.
type ManagementPolicyProperties struct {
	// REQUIRED; The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
	Policy *ManagementPolicySchema `json:"policy,omitempty"`

	// READ-ONLY; Returns the date and time the ManagementPolicies was last modified.
	LastModifiedTime *time.Time `json:"lastModifiedTime,omitempty" azure:"ro"`
}

// ManagementPolicyRule - An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
type ManagementPolicyRule struct {
	// REQUIRED; An object that defines the Lifecycle rule.
	Definition *ManagementPolicyDefinition `json:"definition,omitempty"`

	// REQUIRED; A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be
	// unique within a policy.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The valid value is Lifecycle
	Type *RuleType `json:"type,omitempty"`

	// Rule is enabled if set to true.
	Enabled *bool `json:"enabled,omitempty"`
}

// ManagementPolicySchema - The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
type ManagementPolicySchema struct {
	// REQUIRED; The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
	Rules []*ManagementPolicyRule `json:"rules,omitempty"`
}

// ManagementPolicySnapShot - Management policy action for snapshot.
type ManagementPolicySnapShot struct {
	// The function to delete the blob snapshot
	Delete *DateAfterCreation `json:"delete,omitempty"`

	// The function to tier blob snapshot to archive storage. Support blob snapshot currently at Hot or Cool tier
	TierToArchive *DateAfterCreation `json:"tierToArchive,omitempty"`

	// The function to tier blob snapshot to cool storage. Support blob snapshot currently at Hot tier
	TierToCool *DateAfterCreation `json:"tierToCool,omitempty"`
}

// ManagementPolicyVersion - Management policy action for blob version.
type ManagementPolicyVersion struct {
	// The function to delete the blob version
	Delete *DateAfterCreation `json:"delete,omitempty"`

	// The function to tier blob version to archive storage. Support blob version currently at Hot or Cool tier
	TierToArchive *DateAfterCreation `json:"tierToArchive,omitempty"`

	// The function to tier blob version to cool storage. Support blob version currently at Hot tier
	TierToCool *DateAfterCreation `json:"tierToCool,omitempty"`
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// Aggregation type could be Average.
	AggregationType *string `json:"aggregationType,omitempty"`

	// The category this metric specification belong to, could be Capacity.
	Category *string `json:"category,omitempty"`

	// Dimensions of blobs, including blob type and access tier.
	Dimensions []*Dimension `json:"dimensions,omitempty"`

	// Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`

	// The property to decide fill gap with zero or not.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Name of metric specification.
	Name *string `json:"name,omitempty"`

	// Account Resource Id.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// Unit could be Bytes or Count.
	Unit *string `json:"unit,omitempty"`
}

// Multichannel setting. Applies to Premium FileStorage only.
type Multichannel struct {
	// Indicates whether multichannel is enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// NetworkRuleSet - Network rule set
type NetworkRuleSet struct {
	// REQUIRED; Specifies the default action of allow or deny when no other rules match.
	DefaultAction *DefaultAction `json:"defaultAction,omitempty"`

	// Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices
	// (For example, "Logging, Metrics"), or None to bypass none
	// of those traffics.
	Bypass *Bypass `json:"bypass,omitempty"`

	// Sets the IP ACL rules
	IPRules []*IPRule `json:"ipRules,omitempty"`

	// Sets the resource access rules
	ResourceAccessRules []*ResourceAccessRule `json:"resourceAccessRules,omitempty"`

	// Sets the virtual network rules
	VirtualNetworkRules []*VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// ObjectReplicationPolicies - List storage account object replication policies.
type ObjectReplicationPolicies struct {
	// The replication policy between two storage accounts.
	Value []*ObjectReplicationPolicy `json:"value,omitempty"`
}

// ObjectReplicationPoliciesClientCreateOrUpdateOptions contains the optional parameters for the ObjectReplicationPoliciesClient.CreateOrUpdate
// method.
type ObjectReplicationPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ObjectReplicationPoliciesClientDeleteOptions contains the optional parameters for the ObjectReplicationPoliciesClient.Delete
// method.
type ObjectReplicationPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ObjectReplicationPoliciesClientGetOptions contains the optional parameters for the ObjectReplicationPoliciesClient.Get
// method.
type ObjectReplicationPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ObjectReplicationPoliciesClientListOptions contains the optional parameters for the ObjectReplicationPoliciesClient.List
// method.
type ObjectReplicationPoliciesClientListOptions struct {
	// placeholder for future optional parameters
}

// ObjectReplicationPolicy - The replication policy between two storage accounts. Multiple rules can be defined in one policy.
type ObjectReplicationPolicy struct {
	// Returns the Storage Account Object Replication Policy.
	Properties *ObjectReplicationPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ObjectReplicationPolicyFilter - Filters limit replication to a subset of blobs within the storage account. A logical OR
// is performed on values in the filter. If multiple filters are defined, a logical AND is performed on all
// filters.
type ObjectReplicationPolicyFilter struct {
	// Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'.
	// Example: 2020-02-19T16:05:00Z
	MinCreationTime *string `json:"minCreationTime,omitempty"`

	// Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
	PrefixMatch []*string `json:"prefixMatch,omitempty"`
}

// ObjectReplicationPolicyProperties - The Storage Account ObjectReplicationPolicy properties.
type ObjectReplicationPolicyProperties struct {
	// REQUIRED; Required. Destination account name. It should be full resource id if allowCrossTenantReplication set to false.
	DestinationAccount *string `json:"destinationAccount,omitempty"`

	// REQUIRED; Required. Source account name. It should be full resource id if allowCrossTenantReplication set to false.
	SourceAccount *string `json:"sourceAccount,omitempty"`

	// The storage account object replication rules.
	Rules []*ObjectReplicationPolicyRule `json:"rules,omitempty"`

	// READ-ONLY; Indicates when the policy is enabled on the source account.
	EnabledTime *time.Time `json:"enabledTime,omitempty" azure:"ro"`

	// READ-ONLY; A unique id for object replication policy.
	PolicyID *string `json:"policyId,omitempty" azure:"ro"`
}

// ObjectReplicationPolicyRule - The replication policy rule between two containers.
type ObjectReplicationPolicyRule struct {
	// REQUIRED; Required. Destination container name.
	DestinationContainer *string `json:"destinationContainer,omitempty"`

	// REQUIRED; Required. Source container name.
	SourceContainer *string `json:"sourceContainer,omitempty"`

	// Optional. An object that defines the filter set.
	Filters *ObjectReplicationPolicyFilter `json:"filters,omitempty"`

	// Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
	RuleID *string `json:"ruleId,omitempty"`
}

// Operation - Storage REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// Properties of operation, include metric specifications.
	OperationProperties *OperationProperties `json:"properties,omitempty"`

	// The origin of operations.
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string `json:"description,omitempty"`

	// Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft Storage.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Storage operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// List of Storage operations supported by the Storage resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

type PermissionScope struct {
	// REQUIRED; The permissions for the local user. Possible values include: Read (r), Write (w), Delete (d), List (l), and Create
	// (c).
	Permissions *string `json:"permissions,omitempty"`

	// REQUIRED; The name of resource, normally the container name or the file share name, used by the local user.
	ResourceName *string `json:"resourceName,omitempty"`

	// REQUIRED; The service used by the local user, e.g. blob, file.
	Service *string `json:"service,omitempty"`
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Delete
// method.
type PrivateEndpointConnectionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.List
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientPutOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Put
// method.
type PrivateEndpointConnectionsClientPutOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListByStorageAccountOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByStorageAccount
// method.
type PrivateLinkResourcesClientListByStorageAccountOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionRequired *string `json:"actionRequired,omitempty"`

	// The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// ProtectedAppendWritesHistory - Protected append writes history setting for the blob container with Legal holds.
type ProtectedAppendWritesHistory struct {
	// When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance.
	// Only new blocks can be added and any existing blocks cannot be modified
	// or deleted.
	AllowProtectedAppendWritesAll *bool `json:"allowProtectedAppendWritesAll,omitempty"`

	// READ-ONLY; Returns the date and time the tag was added.
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`
}

// ProtocolSettings - Protocol settings for file service
type ProtocolSettings struct {
	// Setting for SMB protocol
	Smb *SmbSetting `json:"smb,omitempty"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type Queue struct {
	// Queue resource properties.
	QueueProperties *QueueProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QueueClientCreateOptions contains the optional parameters for the QueueClient.Create method.
type QueueClientCreateOptions struct {
	// placeholder for future optional parameters
}

// QueueClientDeleteOptions contains the optional parameters for the QueueClient.Delete method.
type QueueClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// QueueClientGetOptions contains the optional parameters for the QueueClient.Get method.
type QueueClientGetOptions struct {
	// placeholder for future optional parameters
}

// QueueClientListOptions contains the optional parameters for the QueueClient.List method.
type QueueClientListOptions struct {
	// Optional, When specified, only the queues with a name starting with the given filter will be listed.
	Filter *string
	// Optional, a maximum number of queues that should be included in a list queue response
	Maxpagesize *string
}

// QueueClientUpdateOptions contains the optional parameters for the QueueClient.Update method.
type QueueClientUpdateOptions struct {
	// placeholder for future optional parameters
}

type QueueProperties struct {
	// A name-value pair that represents queue metadata.
	Metadata map[string]*string `json:"metadata,omitempty"`

	// READ-ONLY; Integer indicating an approximate number of messages in the queue. This number is not lower than the actual
	// number of messages in the queue, but could be higher.
	ApproximateMessageCount *int32 `json:"approximateMessageCount,omitempty" azure:"ro"`
}

// QueueServiceProperties - The properties of a storage account’s Queue service.
type QueueServiceProperties struct {
	// The properties of a storage account’s Queue service.
	QueueServiceProperties *QueueServicePropertiesProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QueueServicePropertiesProperties - The properties of a storage account’s Queue service.
type QueueServicePropertiesProperties struct {
	// Specifies CORS rules for the Queue service. You can include up to five CorsRule elements in the request. If no CorsRule
	// elements are included in the request body, all CORS rules will be deleted, and
	// CORS will be disabled for the Queue service.
	Cors *CorsRules `json:"cors,omitempty"`
}

// QueueServicesClientGetServicePropertiesOptions contains the optional parameters for the QueueServicesClient.GetServiceProperties
// method.
type QueueServicesClientGetServicePropertiesOptions struct {
	// placeholder for future optional parameters
}

// QueueServicesClientListOptions contains the optional parameters for the QueueServicesClient.List method.
type QueueServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// QueueServicesClientSetServicePropertiesOptions contains the optional parameters for the QueueServicesClient.SetServiceProperties
// method.
type QueueServicesClientSetServicePropertiesOptions struct {
	// placeholder for future optional parameters
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceAccessRule - Resource Access Rule.
type ResourceAccessRule struct {
	// Resource Id
	ResourceID *string `json:"resourceId,omitempty"`

	// Tenant Id
	TenantID *string `json:"tenantId,omitempty"`
}

// RestorePolicyProperties - The blob service properties for blob restore policy
type RestorePolicyProperties struct {
	// REQUIRED; Blob restore is enabled if set to true.
	Enabled *bool `json:"enabled,omitempty"`

	// how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
	Days *int32 `json:"days,omitempty"`

	// READ-ONLY; Deprecated in favor of minRestoreTime property.
	LastEnabledTime *time.Time `json:"lastEnabledTime,omitempty" azure:"ro"`

	// READ-ONLY; Returns the minimum date and time that the restore can be started.
	MinRestoreTime *time.Time `json:"minRestoreTime,omitempty" azure:"ro"`
}

// Restriction - The restriction because of which SKU cannot be used.
type Restriction struct {
	// The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when
	// the SKU has requiredQuotas parameter as the subscription does not belong to that
	// quota. The "NotAvailableForSubscription" is related to capacity at DC.
	ReasonCode *ReasonCode `json:"reasonCode,omitempty"`

	// READ-ONLY; The type of restrictions. As of now only possible value for this is location.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where
	// the SKU is restricted.
	Values []*string `json:"values,omitempty" azure:"ro"`
}

// RoutingPreference - Routing preference defines the type of network, either microsoft or internet routing to be used to
// deliver the user data, the default option is microsoft routing
type RoutingPreference struct {
	// A boolean flag which indicates whether internet routing storage endpoints are to be published
	PublishInternetEndpoints *bool `json:"publishInternetEndpoints,omitempty"`

	// A boolean flag which indicates whether microsoft routing storage endpoints are to be published
	PublishMicrosoftEndpoints *bool `json:"publishMicrosoftEndpoints,omitempty"`

	// Routing Choice defines the kind of network routing opted by the user.
	RoutingChoice *RoutingChoice `json:"routingChoice,omitempty"`
}

// SKU - The SKU of the storage account.
type SKU struct {
	// REQUIRED; The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called
	// accountType.
	Name *SKUName `json:"name,omitempty"`

	// READ-ONLY; The SKU tier. This is based on the SKU name.
	Tier *SKUTier `json:"tier,omitempty" azure:"ro"`
}

// SKUCapability - The capability information in the specified SKU, including file encryption, network ACLs, change notification,
// etc.
type SKUCapability struct {
	// READ-ONLY; The name of capability, The capability information in the specified SKU, including file encryption, network
	// ACLs, change notification, etc.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; A string value to indicate states of given capability. Possibly 'true' or 'false'.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// SKUInformation - Storage SKU and its properties
type SKUInformation struct {
	// REQUIRED; The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called
	// accountType.
	Name *SKUName `json:"name,omitempty"`

	// The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*Restriction `json:"restrictions,omitempty"`

	// READ-ONLY; The capability information in the specified SKU, including file encryption, network ACLs, change notification,
	// etc.
	Capabilities []*SKUCapability `json:"capabilities,omitempty" azure:"ro"`

	// READ-ONLY; Indicates the type of storage account.
	Kind *Kind `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g.
	// West US, East US, Southeast Asia, etc.).
	Locations []*string `json:"locations,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource, usually it is 'storageAccounts'.
	ResourceType *string `json:"resourceType,omitempty" azure:"ro"`

	// READ-ONLY; The SKU tier. This is based on the SKU name.
	Tier *SKUTier `json:"tier,omitempty" azure:"ro"`
}

// SKUListResult - The response from the List Storage SKUs operation.
type SKUListResult struct {
	// READ-ONLY; Get the list result of storage SKUs and their properties.
	Value []*SKUInformation `json:"value,omitempty" azure:"ro"`
}

// SKUsClientListOptions contains the optional parameters for the SKUsClient.List method.
type SKUsClientListOptions struct {
	// placeholder for future optional parameters
}

type SSHPublicKey struct {
	// Optional. It is used to store the function/usage of the key
	Description *string `json:"description,omitempty"`

	// Ssh public key base64 encoded. The format should be: ' ', e.g. ssh-rsa AAAABBBB
	Key *string `json:"key,omitempty"`
}

// SasPolicy assigned to the storage account.
type SasPolicy struct {
	// REQUIRED; The SAS expiration action. Can only be Log.
	ExpirationAction *ExpirationAction `json:"expirationAction,omitempty"`

	// REQUIRED; The SAS expiration period, DD.HH:MM:SS.
	SasExpirationPeriod *string `json:"sasExpirationPeriod,omitempty"`
}

// ServiceSasParameters - The parameters to list service SAS credentials of a specific resource.
type ServiceSasParameters struct {
	// REQUIRED; The canonical path to the signed resource.
	CanonicalizedResource *string `json:"canonicalizedResource,omitempty"`

	// The response header override for cache control.
	CacheControl *string `json:"rscc,omitempty"`

	// The response header override for content disposition.
	ContentDisposition *string `json:"rscd,omitempty"`

	// The response header override for content encoding.
	ContentEncoding *string `json:"rsce,omitempty"`

	// The response header override for content language.
	ContentLanguage *string `json:"rscl,omitempty"`

	// The response header override for content type.
	ContentType *string `json:"rsct,omitempty"`

	// An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string `json:"signedIp,omitempty"`

	// A unique value up to 64 characters in length that correlates to an access policy specified for the container, queue, or
	// table.
	Identifier *string `json:"signedIdentifier,omitempty"`

	// The key to sign the account SAS token with.
	KeyToSign *string `json:"keyToSign,omitempty"`

	// The end of partition key.
	PartitionKeyEnd *string `json:"endPk,omitempty"`

	// The start of partition key.
	PartitionKeyStart *string `json:"startPk,omitempty"`

	// The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a),
	// Create (c), Update (u) and Process (p).
	Permissions *Permissions `json:"signedPermission,omitempty"`

	// The protocol permitted for a request made with the account SAS.
	Protocols *HTTPProtocol `json:"signedProtocol,omitempty"`

	// The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share
	// (s).
	Resource *SignedResource `json:"signedResource,omitempty"`

	// The end of row key.
	RowKeyEnd *string `json:"endRk,omitempty"`

	// The start of row key.
	RowKeyStart *string `json:"startRk,omitempty"`

	// The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *time.Time `json:"signedExpiry,omitempty"`

	// The time at which the SAS becomes valid.
	SharedAccessStartTime *time.Time `json:"signedStart,omitempty"`
}

// ServiceSpecification - One property of operation, include metric specifications.
type ServiceSpecification struct {
	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

type SignedIdentifier struct {
	// Access policy
	AccessPolicy *AccessPolicy `json:"accessPolicy,omitempty"`

	// An unique identifier of the stored access policy.
	ID *string `json:"id,omitempty"`
}

// SmbSetting - Setting for SMB protocol
type SmbSetting struct {
	// SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter
	// ';'.
	AuthenticationMethods *string `json:"authenticationMethods,omitempty"`

	// SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as
	// a string with delimiter ';'.
	ChannelEncryption *string `json:"channelEncryption,omitempty"`

	// Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter
	// ';'
	KerberosTicketEncryption *string `json:"kerberosTicketEncryption,omitempty"`

	// Multichannel setting. Applies to Premium FileStorage only.
	Multichannel *Multichannel `json:"multichannel,omitempty"`

	// SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with
	// delimiter ';'.
	Versions *string `json:"versions,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// Table - Properties of the table, including Id, resource name, resource type.
type Table struct {
	// Table resource properties.
	TableProperties *TableProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TableAccessPolicy - Table Access Policy Properties Object.
type TableAccessPolicy struct {
	// REQUIRED; Required. List of abbreviated permissions. Supported permission values include 'r','a','u','d'
	Permission *string `json:"permission,omitempty"`

	// Expiry time of the access policy
	ExpiryTime *time.Time `json:"expiryTime,omitempty"`

	// Start time of the access policy
	StartTime *time.Time `json:"startTime,omitempty"`
}

// TableClientCreateOptions contains the optional parameters for the TableClient.Create method.
type TableClientCreateOptions struct {
	// The parameters to provide to create a table.
	Parameters *Table
}

// TableClientDeleteOptions contains the optional parameters for the TableClient.Delete method.
type TableClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// TableClientGetOptions contains the optional parameters for the TableClient.Get method.
type TableClientGetOptions struct {
	// placeholder for future optional parameters
}

// TableClientListOptions contains the optional parameters for the TableClient.List method.
type TableClientListOptions struct {
	// placeholder for future optional parameters
}

// TableClientUpdateOptions contains the optional parameters for the TableClient.Update method.
type TableClientUpdateOptions struct {
	// The parameters to provide to create a table.
	Parameters *Table
}

type TableProperties struct {
	// List of stored access policies specified on the table.
	SignedIdentifiers []*TableSignedIdentifier `json:"signedIdentifiers,omitempty"`

	// READ-ONLY; Table name under the specified account
	TableName *string `json:"tableName,omitempty" azure:"ro"`
}

// TableServiceProperties - The properties of a storage account’s Table service.
type TableServiceProperties struct {
	// The properties of a storage account’s Table service.
	TableServiceProperties *TableServicePropertiesProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TableServicePropertiesProperties - The properties of a storage account’s Table service.
type TableServicePropertiesProperties struct {
	// Specifies CORS rules for the Table service. You can include up to five CorsRule elements in the request. If no CorsRule
	// elements are included in the request body, all CORS rules will be deleted, and
	// CORS will be disabled for the Table service.
	Cors *CorsRules `json:"cors,omitempty"`
}

// TableServicesClientGetServicePropertiesOptions contains the optional parameters for the TableServicesClient.GetServiceProperties
// method.
type TableServicesClientGetServicePropertiesOptions struct {
	// placeholder for future optional parameters
}

// TableServicesClientListOptions contains the optional parameters for the TableServicesClient.List method.
type TableServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// TableServicesClientSetServicePropertiesOptions contains the optional parameters for the TableServicesClient.SetServiceProperties
// method.
type TableServicesClientSetServicePropertiesOptions struct {
	// placeholder for future optional parameters
}

// TableSignedIdentifier - Object to set Table Access Policy.
type TableSignedIdentifier struct {
	// REQUIRED; unique-64-character-value of the stored access policy.
	ID *string `json:"id,omitempty"`

	// Access policy
	AccessPolicy *TableAccessPolicy `json:"accessPolicy,omitempty"`
}

// TagFilter - Blob index tag based filtering for blob objects
type TagFilter struct {
	// REQUIRED; This is the filter tag name, it can have 1 - 128 characters
	Name *string `json:"name,omitempty"`

	// REQUIRED; This is the comparison operator which is used for object comparison and filtering. Only == (equality operator)
	// is currently supported
	Op *string `json:"op,omitempty"`

	// REQUIRED; This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
	Value *string `json:"value,omitempty"`
}

// TagProperty - A tag of the LegalHold of a blob container.
type TagProperty struct {
	// READ-ONLY; Returns the Object ID of the user who added the tag.
	ObjectIdentifier *string `json:"objectIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; The tag value.
	Tag *string `json:"tag,omitempty" azure:"ro"`

	// READ-ONLY; Returns the Tenant ID that issued the token for the user who added the tag.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`

	// READ-ONLY; Returns the date and time the tag was added.
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; Returns the User Principal Name of the user who added the tag.
	Upn *string `json:"upn,omitempty" azure:"ro"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdateHistoryProperty - An update history of the ImmutabilityPolicy of a blob container.
type UpdateHistoryProperty struct {
	// This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to
	// an append blob while maintaining immutability protection and compliance. Only
	// new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy
	// API.
	AllowProtectedAppendWrites *bool `json:"allowProtectedAppendWrites,omitempty"`

	// This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to
	// both 'Append and Bock Blobs' while maintaining immutability protection and
	// compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be
	// changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and
	// 'allowProtectedAppendWritesAll' properties are mutually exclusive.
	AllowProtectedAppendWritesAll *bool `json:"allowProtectedAppendWritesAll,omitempty"`

	// READ-ONLY; The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32 `json:"immutabilityPeriodSinceCreationInDays,omitempty" azure:"ro"`

	// READ-ONLY; Returns the Object ID of the user who updated the ImmutabilityPolicy.
	ObjectIdentifier *string `json:"objectIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; Returns the Tenant ID that issued the token for the user who updated the ImmutabilityPolicy.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`

	// READ-ONLY; Returns the date and time the ImmutabilityPolicy was updated.
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; The ImmutabilityPolicy update type of a blob container, possible values include: put, lock and extend.
	Update *ImmutabilityPolicyUpdateType `json:"update,omitempty" azure:"ro"`

	// READ-ONLY; Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
	Upn *string `json:"upn,omitempty" azure:"ro"`
}

// Usage - Describes Storage Resource Usage.
type Usage struct {
	// READ-ONLY; Gets the current count of the allocated resources in the subscription.
	CurrentValue *int32 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Gets the maximum count of the resources that can be allocated in the subscription.
	Limit *int32 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name of the type of usage.
	Name *UsageName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the unit of measurement.
	Unit *UsageUnit `json:"unit,omitempty" azure:"ro"`
}

// UsageListResult - The response from the List Usages operation.
type UsageListResult struct {
	// Gets or sets the list of Storage Resource Usages.
	Value []*Usage `json:"value,omitempty"`
}

// UsageName - The usage names that can be used; currently limited to StorageAccount.
type UsageName struct {
	// READ-ONLY; Gets a localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`

	// READ-ONLY; Gets a string describing the resource name.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// UsagesClientListByLocationOptions contains the optional parameters for the UsagesClient.ListByLocation method.
type UsagesClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// UserAssignedIdentity for the resource.
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID of the identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// VirtualNetworkRule - Virtual Network rule.
type VirtualNetworkRule struct {
	// REQUIRED; Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
	VirtualNetworkResourceID *string `json:"id,omitempty"`

	// The action of virtual network rule.
	Action *string `json:"action,omitempty"`

	// Gets the state of virtual network rule.
	State *State `json:"state,omitempty"`
}
