//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armorbital

const (
	moduleName    = "armorbital"
	moduleVersion = "v1.0.0"
)

type APIVersionParameter string

const (
	APIVersionParameterTwoThousandTwenty0901Preview    APIVersionParameter = "2020-09-01-preview"
	APIVersionParameterTwoThousandTwentyOne0404Preview APIVersionParameter = "2021-04-04-preview"
	APIVersionParameterTwoThousandTwentyTwo0301        APIVersionParameter = "2022-03-01"
)

// PossibleAPIVersionParameterValues returns the possible values for the APIVersionParameter const type.
func PossibleAPIVersionParameterValues() []APIVersionParameter {
	return []APIVersionParameter{
		APIVersionParameterTwoThousandTwenty0901Preview,
		APIVersionParameterTwoThousandTwentyOne0404Preview,
		APIVersionParameterTwoThousandTwentyTwo0301,
	}
}

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// AutoTrackingConfiguration - Auto track configuration.
type AutoTrackingConfiguration string

const (
	AutoTrackingConfigurationDisabled AutoTrackingConfiguration = "disabled"
	AutoTrackingConfigurationXBand    AutoTrackingConfiguration = "xBand"
	AutoTrackingConfigurationSBand    AutoTrackingConfiguration = "sBand"
)

// PossibleAutoTrackingConfigurationValues returns the possible values for the AutoTrackingConfiguration const type.
func PossibleAutoTrackingConfigurationValues() []AutoTrackingConfiguration {
	return []AutoTrackingConfiguration{
		AutoTrackingConfigurationDisabled,
		AutoTrackingConfigurationXBand,
		AutoTrackingConfigurationSBand,
	}
}

// Capability - Capability of the Ground Station.
type Capability string

const (
	CapabilityCommunication    Capability = "Communication"
	CapabilityEarthObservation Capability = "EarthObservation"
)

// PossibleCapabilityValues returns the possible values for the Capability const type.
func PossibleCapabilityValues() []Capability {
	return []Capability{
		CapabilityCommunication,
		CapabilityEarthObservation,
	}
}

type CapabilityParameter string

const (
	CapabilityParameterCommunication    CapabilityParameter = "Communication"
	CapabilityParameterEarthObservation CapabilityParameter = "EarthObservation"
)

// PossibleCapabilityParameterValues returns the possible values for the CapabilityParameter const type.
func PossibleCapabilityParameterValues() []CapabilityParameter {
	return []CapabilityParameter{
		CapabilityParameterCommunication,
		CapabilityParameterEarthObservation,
	}
}

// ContactProfilesPropertiesProvisioningState - The current state of the resource's creation, deletion, or modification
type ContactProfilesPropertiesProvisioningState string

const (
	ContactProfilesPropertiesProvisioningStateCanceled  ContactProfilesPropertiesProvisioningState = "Canceled"
	ContactProfilesPropertiesProvisioningStateCreating  ContactProfilesPropertiesProvisioningState = "Creating"
	ContactProfilesPropertiesProvisioningStateDeleting  ContactProfilesPropertiesProvisioningState = "Deleting"
	ContactProfilesPropertiesProvisioningStateFailed    ContactProfilesPropertiesProvisioningState = "Failed"
	ContactProfilesPropertiesProvisioningStateSucceeded ContactProfilesPropertiesProvisioningState = "Succeeded"
	ContactProfilesPropertiesProvisioningStateUpdating  ContactProfilesPropertiesProvisioningState = "Updating"
)

// PossibleContactProfilesPropertiesProvisioningStateValues returns the possible values for the ContactProfilesPropertiesProvisioningState const type.
func PossibleContactProfilesPropertiesProvisioningStateValues() []ContactProfilesPropertiesProvisioningState {
	return []ContactProfilesPropertiesProvisioningState{
		ContactProfilesPropertiesProvisioningStateCanceled,
		ContactProfilesPropertiesProvisioningStateCreating,
		ContactProfilesPropertiesProvisioningStateDeleting,
		ContactProfilesPropertiesProvisioningStateFailed,
		ContactProfilesPropertiesProvisioningStateSucceeded,
		ContactProfilesPropertiesProvisioningStateUpdating,
	}
}

// ContactsPropertiesProvisioningState - The current state of the resource's creation, deletion, or modification
type ContactsPropertiesProvisioningState string

const (
	ContactsPropertiesProvisioningStateCanceled  ContactsPropertiesProvisioningState = "Canceled"
	ContactsPropertiesProvisioningStateCreating  ContactsPropertiesProvisioningState = "Creating"
	ContactsPropertiesProvisioningStateDeleting  ContactsPropertiesProvisioningState = "Deleting"
	ContactsPropertiesProvisioningStateFailed    ContactsPropertiesProvisioningState = "Failed"
	ContactsPropertiesProvisioningStateSucceeded ContactsPropertiesProvisioningState = "Succeeded"
	ContactsPropertiesProvisioningStateUpdating  ContactsPropertiesProvisioningState = "Updating"
)

// PossibleContactsPropertiesProvisioningStateValues returns the possible values for the ContactsPropertiesProvisioningState const type.
func PossibleContactsPropertiesProvisioningStateValues() []ContactsPropertiesProvisioningState {
	return []ContactsPropertiesProvisioningState{
		ContactsPropertiesProvisioningStateCanceled,
		ContactsPropertiesProvisioningStateCreating,
		ContactsPropertiesProvisioningStateDeleting,
		ContactsPropertiesProvisioningStateFailed,
		ContactsPropertiesProvisioningStateSucceeded,
		ContactsPropertiesProvisioningStateUpdating,
	}
}

// ContactsStatus - Status of a contact.
type ContactsStatus string

const (
	ContactsStatusScheduled         ContactsStatus = "scheduled"
	ContactsStatusCancelled         ContactsStatus = "cancelled"
	ContactsStatusSucceeded         ContactsStatus = "succeeded"
	ContactsStatusFailed            ContactsStatus = "failed"
	ContactsStatusProviderCancelled ContactsStatus = "providerCancelled"
)

// PossibleContactsStatusValues returns the possible values for the ContactsStatus const type.
func PossibleContactsStatusValues() []ContactsStatus {
	return []ContactsStatus{
		ContactsStatusScheduled,
		ContactsStatusCancelled,
		ContactsStatusSucceeded,
		ContactsStatusFailed,
		ContactsStatusProviderCancelled,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// Direction - Direction (uplink or downlink)
type Direction string

const (
	DirectionDownlink Direction = "downlink"
	DirectionUplink   Direction = "uplink"
)

// PossibleDirectionValues returns the possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{
		DirectionDownlink,
		DirectionUplink,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// Polarization - polarization. eg (RHCP, LHCP)
type Polarization string

const (
	PolarizationLHCP             Polarization = "LHCP"
	PolarizationLinearHorizontal Polarization = "linearHorizontal"
	PolarizationLinearVertical   Polarization = "linearVertical"
	PolarizationRHCP             Polarization = "RHCP"
)

// PossiblePolarizationValues returns the possible values for the Polarization const type.
func PossiblePolarizationValues() []Polarization {
	return []Polarization{
		PolarizationLHCP,
		PolarizationLinearHorizontal,
		PolarizationLinearVertical,
		PolarizationRHCP,
	}
}

// Protocol - Protocol either UDP or TCP.
type Protocol string

const (
	ProtocolTCP Protocol = "TCP"
	ProtocolUDP Protocol = "UDP"
)

// PossibleProtocolValues returns the possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{
		ProtocolTCP,
		ProtocolUDP,
	}
}

// ProvisioningState - The current state of the resource's creation, deletion, or modification
type ProvisioningState string

const (
	ProvisioningStateCanceled  ProvisioningState = "Canceled"
	ProvisioningStateCreating  ProvisioningState = "Creating"
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	ProvisioningStateUpdating  ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateCanceled,
		ProvisioningStateCreating,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
		ProvisioningStateUpdating,
	}
}

// ReleaseMode - Release Status of a ground station
type ReleaseMode string

const (
	ReleaseModeGA      ReleaseMode = "GA"
	ReleaseModePreview ReleaseMode = "Preview"
)

// PossibleReleaseModeValues returns the possible values for the ReleaseMode const type.
func PossibleReleaseModeValues() []ReleaseMode {
	return []ReleaseMode{
		ReleaseModeGA,
		ReleaseModePreview,
	}
}

// SpacecraftsPropertiesProvisioningState - The current state of the resource's creation, deletion, or modification
type SpacecraftsPropertiesProvisioningState string

const (
	SpacecraftsPropertiesProvisioningStateCanceled  SpacecraftsPropertiesProvisioningState = "Canceled"
	SpacecraftsPropertiesProvisioningStateCreating  SpacecraftsPropertiesProvisioningState = "Creating"
	SpacecraftsPropertiesProvisioningStateDeleting  SpacecraftsPropertiesProvisioningState = "Deleting"
	SpacecraftsPropertiesProvisioningStateFailed    SpacecraftsPropertiesProvisioningState = "Failed"
	SpacecraftsPropertiesProvisioningStateSucceeded SpacecraftsPropertiesProvisioningState = "Succeeded"
	SpacecraftsPropertiesProvisioningStateUpdating  SpacecraftsPropertiesProvisioningState = "Updating"
)

// PossibleSpacecraftsPropertiesProvisioningStateValues returns the possible values for the SpacecraftsPropertiesProvisioningState const type.
func PossibleSpacecraftsPropertiesProvisioningStateValues() []SpacecraftsPropertiesProvisioningState {
	return []SpacecraftsPropertiesProvisioningState{
		SpacecraftsPropertiesProvisioningStateCanceled,
		SpacecraftsPropertiesProvisioningStateCreating,
		SpacecraftsPropertiesProvisioningStateDeleting,
		SpacecraftsPropertiesProvisioningStateFailed,
		SpacecraftsPropertiesProvisioningStateSucceeded,
		SpacecraftsPropertiesProvisioningStateUpdating,
	}
}

// Status - The status of operation.
type Status string

const (
	StatusCanceled  Status = "Canceled"
	StatusFailed    Status = "Failed"
	StatusRunning   Status = "Running"
	StatusSucceeded Status = "Succeeded"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusCanceled,
		StatusFailed,
		StatusRunning,
		StatusSucceeded,
	}
}
