/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.jkiss.dbeaver.model.sql.parser.tokens.SQLBlockToggleToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;

public class SQLDollarQuoteRule
implements TPPredicateRule {
    private final boolean partitionRule;
    private final boolean allowNamedQuotes;
    private final boolean fullyConsumeNamed;
    private final boolean fullyConsumeUnnamed;
    private final TPToken stringToken;
    private final TPToken delimiterToken;

    public SQLDollarQuoteRule(boolean partitionRule, boolean allowNamedQuotes, boolean fullyConsumeNamed, boolean fullyConsumeUnnamed) {
        this.partitionRule = partitionRule;
        this.allowNamedQuotes = allowNamedQuotes;
        this.fullyConsumeNamed = fullyConsumeNamed || partitionRule;
        this.fullyConsumeUnnamed = fullyConsumeUnnamed || partitionRule;
        this.stringToken = new TPTokenDefault(SQLTokenType.T_STRING);
        this.delimiterToken = new SQLBlockToggleToken();
    }

    @Override
    public TPToken getSuccessToken() {
        return this.stringToken;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner, boolean resume) {
        String start = this.tryReadDollarQuote(scanner);
        if (start != null) {
            if (start.length() == 2 && this.fullyConsumeUnnamed || start.length() > 2 && this.fullyConsumeNamed) {
                int c = scanner.read();
                int captured = 1;
                while (c != -1) {
                    if (c == 36) {
                        scanner.unread();
                        --captured;
                        String end = this.tryReadDollarQuote(scanner);
                        if (end != null) {
                            if (end.equals(start)) {
                                return this.stringToken;
                            }
                            scanner.unread();
                            captured += end.length() - 1;
                        } else {
                            scanner.read();
                            ++captured;
                        }
                    }
                    c = scanner.read();
                    ++captured;
                }
                SQLDollarQuoteRule.unread(scanner, captured + start.length());
            } else if (!this.partitionRule) {
                return this.delimiterToken;
            }
        }
        return TPTokenAbstract.UNDEFINED;
    }

    private String tryReadDollarQuote(TPCharacterScanner scanner) {
        int totalRead = 0;
        int c = scanner.read();
        ++totalRead;
        if (c == 36) {
            if (this.allowNamedQuotes) {
                StringBuilder qname = new StringBuilder();
                do {
                    qname.append((char)c);
                    c = scanner.read();
                    ++totalRead;
                    if (c != 36) continue;
                    qname.append((char)c);
                    return qname.toString();
                } while (c != -1 && (Character.isLetterOrDigit(c) || c == 95));
            } else {
                c = scanner.read();
                ++totalRead;
                if (c == 36) {
                    return "$$";
                }
            }
        }
        SQLDollarQuoteRule.unread(scanner, totalRead);
        return null;
    }

    private static void unread(TPCharacterScanner scanner, int totalRead) {
        while (totalRead-- > 0) {
            scanner.unread();
        }
    }
}

