// Code generated by smithy-go-codegen DO NOT EDIT.

package ecr

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ecr/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing repository creation template.
func (c *Client) UpdateRepositoryCreationTemplate(ctx context.Context, params *UpdateRepositoryCreationTemplateInput, optFns ...func(*Options)) (*UpdateRepositoryCreationTemplateOutput, error) {
	if params == nil {
		params = &UpdateRepositoryCreationTemplateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateRepositoryCreationTemplate", params, optFns, c.addOperationUpdateRepositoryCreationTemplateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateRepositoryCreationTemplateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateRepositoryCreationTemplateInput struct {

	// The repository namespace prefix that matches an existing repository creation
	// template in the registry. All repositories created using this namespace prefix
	// will have the settings defined in this template applied. For example, a prefix
	// of prod would apply to all repositories beginning with prod/ . This includes a
	// repository named prod/team1 as well as a repository named prod/repository1 .
	//
	// To apply a template to all repositories in your registry that don't have an
	// associated creation template, you can use ROOT as the prefix.
	//
	// This member is required.
	Prefix *string

	// Updates the list of enumerable strings representing the Amazon ECR repository
	// creation scenarios that this template will apply towards. The two supported
	// scenarios are PULL_THROUGH_CACHE and REPLICATION
	AppliedFor []types.RCTAppliedFor

	// The ARN of the role to be assumed by Amazon ECR. This role must be in the same
	// account as the registry that you are configuring. Amazon ECR will assume your
	// supplied role when the customRoleArn is specified. When this field isn't
	// specified, Amazon ECR will use the service-linked role for the repository
	// creation template.
	CustomRoleArn *string

	// A description for the repository creation template.
	Description *string

	// The encryption configuration to associate with the repository creation template.
	EncryptionConfiguration *types.EncryptionConfigurationForRepositoryCreationTemplate

	// Updates the tag mutability setting for the repository. If this parameter is
	// omitted, the default setting of MUTABLE will be used which will allow image
	// tags to be overwritten. If IMMUTABLE is specified, all image tags within the
	// repository will be immutable which will prevent them from being overwritten.
	ImageTagMutability types.ImageTagMutability

	// Updates the lifecycle policy associated with the specified repository creation
	// template.
	LifecyclePolicy *string

	// Updates the repository policy created using the template. A repository policy
	// is a permissions policy associated with a repository to control access
	// permissions.
	RepositoryPolicy *string

	// The metadata to apply to the repository to help you categorize and organize.
	// Each tag consists of a key and an optional value, both of which you define. Tag
	// keys can have a maximum character length of 128 characters, and tag values can
	// have a maximum length of 256 characters.
	ResourceTags []types.Tag

	noSmithyDocumentSerde
}

type UpdateRepositoryCreationTemplateOutput struct {

	// The registry ID associated with the request.
	RegistryId *string

	// The details of the repository creation template associated with the request.
	RepositoryCreationTemplate *types.RepositoryCreationTemplate

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateRepositoryCreationTemplateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateRepositoryCreationTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateRepositoryCreationTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateRepositoryCreationTemplate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateRepositoryCreationTemplateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateRepositoryCreationTemplate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateRepositoryCreationTemplate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateRepositoryCreationTemplate",
	}
}
