/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Mode;
import com.icl.saxon.NodeHandler;
import com.icl.saxon.expr.StandaloneContext;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.pattern.UnionPattern;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;

public class RuleManager {
    private Mode defaultMode;
    private Hashtable modes;
    private NamePool namePool;
    private StandaloneContext standaloneContext;

    public RuleManager(NamePool namePool) {
        this.namePool = namePool;
        this.resetHandlers();
    }

    public void setStandaloneContext(StandaloneContext standaloneContext) {
        this.standaloneContext = standaloneContext;
    }

    public StandaloneContext getStandaloneContext() {
        if (this.standaloneContext == null) {
            this.standaloneContext = new StandaloneContext(this.namePool);
        }
        return this.standaloneContext;
    }

    public void resetHandlers() {
        this.defaultMode = new Mode();
        this.modes = new Hashtable();
    }

    public Mode getMode(int n) {
        if (n == -1) {
            return this.defaultMode;
        }
        Integer n2 = new Integer(n & 0xFFFFF);
        Mode mode = (Mode)this.modes.get(n2);
        if (mode == null) {
            mode = new Mode();
            mode.setNameCode(n);
            this.modes.put(n2, mode);
        }
        return mode;
    }

    public void setHandler(String string, NodeHandler nodeHandler) throws XPathException {
        Pattern pattern = Pattern.make(string, this.getStandaloneContext());
        this.setHandler(pattern, nodeHandler, this.defaultMode, 0);
    }

    public void setHandler(Pattern pattern, NodeHandler nodeHandler, Mode mode, int n) {
        if (pattern instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pattern;
            Pattern pattern2 = unionPattern.getLHS();
            Pattern pattern3 = unionPattern.getRHS();
            this.setHandler(pattern2, nodeHandler, mode, n);
            this.setHandler(pattern3, nodeHandler, mode, n);
            return;
        }
        double d = pattern.getDefaultPriority();
        this.setHandler(pattern, nodeHandler, mode, n, d);
    }

    public void setHandler(Pattern pattern, NodeHandler nodeHandler, Mode mode, int n, double d) {
        if (pattern instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pattern;
            Pattern pattern2 = unionPattern.getLHS();
            Pattern pattern3 = unionPattern.getRHS();
            this.setHandler(pattern2, nodeHandler, mode, n, d);
            this.setHandler(pattern3, nodeHandler, mode, n, d);
            return;
        }
        mode.addRule(pattern, nodeHandler, n, d);
    }

    public NodeHandler getHandler(NodeInfo nodeInfo, Context context) throws TransformerException {
        return this.getHandler(nodeInfo, this.defaultMode, context);
    }

    public NodeHandler getHandler(NodeInfo nodeInfo, Mode mode, Context context) throws TransformerException {
        NodeHandler nodeHandler;
        if (mode == null) {
            mode = this.defaultMode;
        }
        if ((nodeHandler = (NodeHandler)mode.getRule(nodeInfo, context)) != null) {
            return nodeHandler;
        }
        return null;
    }

    public NodeHandler getHandler(NodeInfo nodeInfo, Mode mode, int n, int n2, Context context) throws XPathException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return (NodeHandler)mode.getRule(nodeInfo, n, n2, context);
    }

    public Enumeration getAllModes() {
        return this.modes.keys();
    }
}

