/** \file
 *  This C source file was generated by $ANTLR version 3.3 Nov 30, 2010 12:50:56
 *
 *     -  From the grammar source file : OracleSQL.g
 *     -                            On : 2011-09-20 08:47:36
 *     -                for the parser : OracleSQLParserParser *
 * Editing it, at least manually, is not wise. 
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD licence"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "OracleSQLParser.h"
/* ----------------------------------------- */

/*******************************************************************************

DESCRIPTION:
		Grammar for Oracle's SELECT statement for ANTLR v3, target C language		
AUTHOR:
		Ivan.Brezina (ibre5041@ibrezina.net)
DATE:
		MAY 2011
BASED ON:
		PLSQL3.g Andrey Kharitonkin (thikone@gmail.com)
		PLSQLGrammar.g for ANTLR v2
		Qazi Firdous Ahmed (qazif_ahmed@infosys.com) 
		Krupa Benhur (krupa_bg@infosys.com)
		Manojaba Banerjee (manojaba_banerjee@infosys.com)
		Infosys Technologies Ltd., Bangalore, India
		Sept 18, 2002
		This grammar is for PL/SQL.
COMMENT:
		This grammar file is based on freely downloadable
		file PLSQL3.g. I extracted only those rules that
		are mandatory for DML statements. PL/SQL support was removed
		and should be handled by a separate grammar.
		This grammar was tested on a quite large set of SQL statements
		and handles many "undocumented" Oracle's behaviours.
ORIGINAL COMMENT:
		The grammar has been mostly re-written for ANTLR v3,
		using Oracle 10g Release 2 documentation and ANTLR book.
		New SQL and PL/SQL expression rules, SQL statments
		SELECT, INSERT, UPDATE, DELETE are fully supported.
		Generated parser can parse most of valid PL/SQL and 
		it was tested with over 10 Mb of test source code.
		Let me know if something cannot be parsed by this grammar.
KNOWN ISSUES:
		XQUERIES are unsupported.
		Some keywords are treated as reserved ones. If you really insist on identifiers
			like: MODEL, JOIN, OUTER or PARTITION put them into double quotes. 
		"AS OF SNAPSHOT(:X)" construct is not supported yet.
		Some build-in functions having non-standart calling convention
			are unsupported too.
*******************************************************************************/




/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */
 
#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pOracleSQLParser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pOracleSQLParser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pOracleSQLParser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pOracleSQLParser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */
 
#undef	    PARSER		    
#undef	    RECOGNIZER		    
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO		    
#undef		DBG

#define	    PARSER				ctx->pParser  
#define	    RECOGNIZER				PARSER->rec
#define	    PSRSTATE				RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)			RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT				PARSER->tstream
#define	    STRSTREAM				INPUT
#define	    ISTREAM				INPUT->istream
#define	    INDEX()				ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()			(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				PSRSTATE->exception
#define	    MATCHT(t, fs)			RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()				RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK				PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define	    FOLLOWPUSH(x)
#define	    FOLLOWPOP()
#else
#define	    FOLLOWPUSH(x)			FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()				FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define	    PRECOVER()				RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()			RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)				INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)				INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()				ISTREAM->consume(ISTREAM)
#define	    MARK()				ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define	    SEEK(n)				ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY			PSRSTATE->errorRecovery
#define	    FAILEDFLAG				PSRSTATE->failed
#define	    HASFAILED()				(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING			PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger

#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */



/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   OracleSQLParserTokenNames[282+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>", 
        (pANTLR3_UINT8) "<UP>", 
        (pANTLR3_UINT8) "T_UNKNOWN",
        (pANTLR3_UINT8) "T_RESERVED",
        (pANTLR3_UINT8) "T_TABLE_ALIAS",
        (pANTLR3_UINT8) "T_COLUMN_ALIAS",
        (pANTLR3_UINT8) "T_COLUMN_NAME",
        (pANTLR3_UINT8) "T_TABLE_NAME",
        (pANTLR3_UINT8) "T_SCHEMA_NAME",
        (pANTLR3_UINT8) "T_FUNCTION_NAME",
        (pANTLR3_UINT8) "T_PACKAGE_NAME",
        (pANTLR3_UINT8) "T_DBLINK_NAME",
        (pANTLR3_UINT8) "T_BINDVAR_NAME",
        (pANTLR3_UINT8) "T_DECL",
        (pANTLR3_UINT8) "T_USE",
        (pANTLR3_UINT8) "T_IDENTIFIER",
        (pANTLR3_UINT8) "T_TABLE_REF",
        (pANTLR3_UINT8) "T_WITH",
        (pANTLR3_UINT8) "T_SELECT",
        (pANTLR3_UINT8) "T_SUBQUERY",
        (pANTLR3_UINT8) "T_TABLE_CAST",
        (pANTLR3_UINT8) "T_COLUMN_LIST",
        (pANTLR3_UINT8) "T_SELECT_COLUMN",
        (pANTLR3_UINT8) "T_FROM",
        (pANTLR3_UINT8) "T_WHERE",
        (pANTLR3_UINT8) "T_HIERARCHICAL",
        (pANTLR3_UINT8) "T_GROUP_BY",
        (pANTLR3_UINT8) "T_MODEL",
        (pANTLR3_UINT8) "T_UNION",
        (pANTLR3_UINT8) "T_ORDER_BY_CLAUSE",
        (pANTLR3_UINT8) "T_FOR_UPDATE_CLAUSE",
        (pANTLR3_UINT8) "T_JOINING_CLAUSE",
        (pANTLR3_UINT8) "T_OPERATOR_UNARY",
        (pANTLR3_UINT8) "T_OPERATOR_BINARY",
        (pANTLR3_UINT8) "T_OPERATOR_PART",
        (pANTLR3_UINT8) "T_COND_OR",
        (pANTLR3_UINT8) "T_COND_OR_SEQ",
        (pANTLR3_UINT8) "T_COND_AND",
        (pANTLR3_UINT8) "T_COND_AND_SEQ",
        (pANTLR3_UINT8) "T_COND_NOT",
        (pANTLR3_UINT8) "T_COND_EXISTS",
        (pANTLR3_UINT8) "T_COND_IS",
        (pANTLR3_UINT8) "T_COND_COMPARISON",
        (pANTLR3_UINT8) "T_COND_GROUP_COMPARISON",
        (pANTLR3_UINT8) "T_COND_IN",
        (pANTLR3_UINT8) "T_COND_IS_A_SET",
        (pANTLR3_UINT8) "T_COND_IS_ANY",
        (pANTLR3_UINT8) "T_COND_IS_EMPTY",
        (pANTLR3_UINT8) "T_COND_IS_OF_TYPE",
        (pANTLR3_UINT8) "T_COND_IS_PRESENT",
        (pANTLR3_UINT8) "T_COND_LIKE",
        (pANTLR3_UINT8) "T_COND_MEMEBER",
        (pANTLR3_UINT8) "T_COND_BETWEEN",
        (pANTLR3_UINT8) "T_COND_REGEXP_LIKE",
        (pANTLR3_UINT8) "T_COND_SUBMULTISET",
        (pANTLR3_UINT8) "T_COND_EQUALS_PATH",
        (pANTLR3_UINT8) "T_COND_UNDER_PATH",
        (pANTLR3_UINT8) "T_COND_PAREN",
        (pANTLR3_UINT8) "SEMI",
        (pANTLR3_UINT8) "LPAREN",
        (pANTLR3_UINT8) "RPAREN",
        (pANTLR3_UINT8) "EQ",
        (pANTLR3_UINT8) "COMMA",
        (pANTLR3_UINT8) "AT_SIGN",
        (pANTLR3_UINT8) "NUMBER",
        (pANTLR3_UINT8) "ASTERISK",
        (pANTLR3_UINT8) "DOT",
        (pANTLR3_UINT8) "PLUS",
        (pANTLR3_UINT8) "MINUS",
        (pANTLR3_UINT8) "DIVIDE",
        (pANTLR3_UINT8) "ARROW",
        (pANTLR3_UINT8) "QUOTED_STRING",
        (pANTLR3_UINT8) "FOUND_ATTR",
        (pANTLR3_UINT8) "NOTFOUND_ATTR",
        (pANTLR3_UINT8) "ISOPEN_ATTR",
        (pANTLR3_UINT8) "ROWCOUNT_ATTR",
        (pANTLR3_UINT8) "BULK_ROWCOUNT_ATTR",
        (pANTLR3_UINT8) "CHARSET_ATTR",
        (pANTLR3_UINT8) "ID",
        (pANTLR3_UINT8) "BINDVAR",
        (pANTLR3_UINT8) "COLON",
        (pANTLR3_UINT8) "GTH",
        (pANTLR3_UINT8) "LTH",
        (pANTLR3_UINT8) "LBRACK",
        (pANTLR3_UINT8) "RBRACK",
        (pANTLR3_UINT8) "QSTRING",
        (pANTLR3_UINT8) "QS_ANGLE",
        (pANTLR3_UINT8) "QS_BRACE",
        (pANTLR3_UINT8) "QS_BRACK",
        (pANTLR3_UINT8) "QS_PAREN",
        (pANTLR3_UINT8) "QS_OTHER",
        (pANTLR3_UINT8) "QUOTE",
        (pANTLR3_UINT8) "QS_OTHER_CH",
        (pANTLR3_UINT8) "DOUBLEQUOTED_STRING",
        (pANTLR3_UINT8) "NUM",
        (pANTLR3_UINT8) "POINT",
        (pANTLR3_UINT8) "DOUBLEDOT",
        (pANTLR3_UINT8) "PERCENTAGE",
        (pANTLR3_UINT8) "LLABEL",
        (pANTLR3_UINT8) "RLABEL",
        (pANTLR3_UINT8) "ASSIGN",
        (pANTLR3_UINT8) "VERTBAR",
        (pANTLR3_UINT8) "DOUBLEVERTBAR",
        (pANTLR3_UINT8) "NOT_EQ",
        (pANTLR3_UINT8) "LEQ",
        (pANTLR3_UINT8) "GEQ",
        (pANTLR3_UINT8) "WS",
        (pANTLR3_UINT8) "SL_COMMENT",
        (pANTLR3_UINT8) "ML_COMMENT",
        (pANTLR3_UINT8) "TYPE_ATTR",
        (pANTLR3_UINT8) "ROWTYPE_ATTR",
        (pANTLR3_UINT8) "ZV",
        (pANTLR3_UINT8) "'ACCESS'",
        (pANTLR3_UINT8) "'ADD'",
        (pANTLR3_UINT8) "'ALL'",
        (pANTLR3_UINT8) "'ALTER'",
        (pANTLR3_UINT8) "'AND'",
        (pANTLR3_UINT8) "'ANY'",
        (pANTLR3_UINT8) "'ARRAYLEN'",
        (pANTLR3_UINT8) "'AS'",
        (pANTLR3_UINT8) "'ASC'",
        (pANTLR3_UINT8) "'AUDIT'",
        (pANTLR3_UINT8) "'BETWEEN'",
        (pANTLR3_UINT8) "'BY'",
        (pANTLR3_UINT8) "'CASE'",
        (pANTLR3_UINT8) "'CHAR'",
        (pANTLR3_UINT8) "'CHECK'",
        (pANTLR3_UINT8) "'CLUSTER'",
        (pANTLR3_UINT8) "'COLUMN'",
        (pANTLR3_UINT8) "'COMMENT'",
        (pANTLR3_UINT8) "'COMPRESS'",
        (pANTLR3_UINT8) "'CONNECT'",
        (pANTLR3_UINT8) "'CREATE'",
        (pANTLR3_UINT8) "'CURRENT'",
        (pANTLR3_UINT8) "'DATE'",
        (pANTLR3_UINT8) "'DECIMAL'",
        (pANTLR3_UINT8) "'DEFAULT'",
        (pANTLR3_UINT8) "'DELETE'",
        (pANTLR3_UINT8) "'DESC'",
        (pANTLR3_UINT8) "'DISTINCT'",
        (pANTLR3_UINT8) "'DROP'",
        (pANTLR3_UINT8) "'ELSE'",
        (pANTLR3_UINT8) "'EXCLUSIVE'",
        (pANTLR3_UINT8) "'EXISTS'",
        (pANTLR3_UINT8) "'FALSE'",
        (pANTLR3_UINT8) "'FILE'",
        (pANTLR3_UINT8) "'FLOAT'",
        (pANTLR3_UINT8) "'FOR'",
        (pANTLR3_UINT8) "'FROM'",
        (pANTLR3_UINT8) "'GRANT'",
        (pANTLR3_UINT8) "'GROUP'",
        (pANTLR3_UINT8) "'HAVING'",
        (pANTLR3_UINT8) "'IDENTIFIED'",
        (pANTLR3_UINT8) "'IMMEDIATE'",
        (pANTLR3_UINT8) "'IN'",
        (pANTLR3_UINT8) "'INCREMENT'",
        (pANTLR3_UINT8) "'INDEX'",
        (pANTLR3_UINT8) "'INITIAL'",
        (pANTLR3_UINT8) "'INSERT'",
        (pANTLR3_UINT8) "'INTEGER'",
        (pANTLR3_UINT8) "'INTERSECT'",
        (pANTLR3_UINT8) "'INTO'",
        (pANTLR3_UINT8) "'IS'",
        (pANTLR3_UINT8) "'LEVEL'",
        (pANTLR3_UINT8) "'LIKE'",
        (pANTLR3_UINT8) "'LOCK'",
        (pANTLR3_UINT8) "'LONG'",
        (pANTLR3_UINT8) "'MAXEXTENTS'",
        (pANTLR3_UINT8) "'MINUS'",
        (pANTLR3_UINT8) "'MODE'",
        (pANTLR3_UINT8) "'MODIFY'",
        (pANTLR3_UINT8) "'NOAUDIT'",
        (pANTLR3_UINT8) "'NOCOMPRESS'",
        (pANTLR3_UINT8) "'NOT'",
        (pANTLR3_UINT8) "'NOTFOUND'",
        (pANTLR3_UINT8) "'NOWAIT'",
        (pANTLR3_UINT8) "'NULL'",
        (pANTLR3_UINT8) "'NUMBER'",
        (pANTLR3_UINT8) "'OF'",
        (pANTLR3_UINT8) "'OFFLINE'",
        (pANTLR3_UINT8) "'ON'",
        (pANTLR3_UINT8) "'ONLINE'",
        (pANTLR3_UINT8) "'OPTION'",
        (pANTLR3_UINT8) "'OR'",
        (pANTLR3_UINT8) "'ORDER'",
        (pANTLR3_UINT8) "'PCTFREE'",
        (pANTLR3_UINT8) "'PRIOR'",
        (pANTLR3_UINT8) "'PRIVILEGES'",
        (pANTLR3_UINT8) "'PUBLIC'",
        (pANTLR3_UINT8) "'RAW'",
        (pANTLR3_UINT8) "'RENAME'",
        (pANTLR3_UINT8) "'RESOURCE'",
        (pANTLR3_UINT8) "'REVOKE'",
        (pANTLR3_UINT8) "'ROW'",
        (pANTLR3_UINT8) "'ROWID'",
        (pANTLR3_UINT8) "'ROWLABEL'",
        (pANTLR3_UINT8) "'ROWNUM'",
        (pANTLR3_UINT8) "'ROWS'",
        (pANTLR3_UINT8) "'SELECT'",
        (pANTLR3_UINT8) "'SESSION'",
        (pANTLR3_UINT8) "'SET'",
        (pANTLR3_UINT8) "'SHARE'",
        (pANTLR3_UINT8) "'SIZE'",
        (pANTLR3_UINT8) "'SMALLINT'",
        (pANTLR3_UINT8) "'SQLBUF'",
        (pANTLR3_UINT8) "'START'",
        (pANTLR3_UINT8) "'SUCCESSFUL'",
        (pANTLR3_UINT8) "'SYNONYM'",
        (pANTLR3_UINT8) "'SYSDATE'",
        (pANTLR3_UINT8) "'TABLE'",
        (pANTLR3_UINT8) "'THEN'",
        (pANTLR3_UINT8) "'TO'",
        (pANTLR3_UINT8) "'TRIGGER'",
        (pANTLR3_UINT8) "'TRUE'",
        (pANTLR3_UINT8) "'UID'",
        (pANTLR3_UINT8) "'UNION'",
        (pANTLR3_UINT8) "'UNIQUE'",
        (pANTLR3_UINT8) "'UPDATE'",
        (pANTLR3_UINT8) "'USER'",
        (pANTLR3_UINT8) "'VALIDATE'",
        (pANTLR3_UINT8) "'VALUES'",
        (pANTLR3_UINT8) "'VARCHAR'",
        (pANTLR3_UINT8) "'VARCHAR2'",
        (pANTLR3_UINT8) "'VIEW'",
        (pANTLR3_UINT8) "'WHENEVER'",
        (pANTLR3_UINT8) "'WHERE'",
        (pANTLR3_UINT8) "'WITH'",
        (pANTLR3_UINT8) "'AT'",
        (pANTLR3_UINT8) "'CAST'",
        (pANTLR3_UINT8) "'CLUSTER_SET'",
        (pANTLR3_UINT8) "'CONNECT_BY_ROOT'",
        (pANTLR3_UINT8) "'COUNT'",
        (pANTLR3_UINT8) "'CUBE'",
        (pANTLR3_UINT8) "'CURSOR'",
        (pANTLR3_UINT8) "'CYCLE'",
        (pANTLR3_UINT8) "'DIMENSION'",
        (pANTLR3_UINT8) "'END'",
        (pANTLR3_UINT8) "'ESCAPE'",
        (pANTLR3_UINT8) "'EXTRACT'",
        (pANTLR3_UINT8) "'FIRST'",
        (pANTLR3_UINT8) "'FOLLOWING'",
        (pANTLR3_UINT8) "'FULL'",
        (pANTLR3_UINT8) "'GROUPING'",
        (pANTLR3_UINT8) "'IGNORE'",
        (pANTLR3_UINT8) "'INFINITE'",
        (pANTLR3_UINT8) "'INTERVAL'",
        (pANTLR3_UINT8) "'JOIN'",
        (pANTLR3_UINT8) "'LAST'",
        (pANTLR3_UINT8) "'LEFT'",
        (pANTLR3_UINT8) "'LIKE2'",
        (pANTLR3_UINT8) "'LIKE4'",
        (pANTLR3_UINT8) "'LIKEC'",
        (pANTLR3_UINT8) "'MAIN'",
        (pANTLR3_UINT8) "'MEMBER'",
        (pANTLR3_UINT8) "'MODEL'",
        (pANTLR3_UINT8) "'MULTISET'",
        (pANTLR3_UINT8) "'NAN'",
        (pANTLR3_UINT8) "'NAV'",
        (pANTLR3_UINT8) "'NULLS'",
        (pANTLR3_UINT8) "'OUTER'",
        (pANTLR3_UINT8) "'PARTITION'",
        (pANTLR3_UINT8) "'PIVOT'",
        (pANTLR3_UINT8) "'PRECEDING'",
        (pANTLR3_UINT8) "'RANGE'",
        (pANTLR3_UINT8) "'REFERENCE'",
        (pANTLR3_UINT8) "'RESPECT'",
        (pANTLR3_UINT8) "'RETURN'",
        (pANTLR3_UINT8) "'RETURNING'",
        (pANTLR3_UINT8) "'RIGHT'",
        (pANTLR3_UINT8) "'ROLLUP'",
        (pANTLR3_UINT8) "'SEARCH'",
        (pANTLR3_UINT8) "'SETS'",
        (pANTLR3_UINT8) "'SOME'",
        (pANTLR3_UINT8) "'SQL'",
        (pANTLR3_UINT8) "'SUBMULTISET'",
        (pANTLR3_UINT8) "'THE'",
        (pANTLR3_UINT8) "'TIMESTAMP'",
        (pANTLR3_UINT8) "'UNBOUNDED'",
        (pANTLR3_UINT8) "'UNPIVOT'",
        (pANTLR3_UINT8) "'USING'",
        (pANTLR3_UINT8) "'VERSIONS'",
        (pANTLR3_UINT8) "'WHEN'",
        (pANTLR3_UINT8) "'!'",
        (pANTLR3_UINT8) "'^'"
       };

        

// Forward declare the locally static matching functions we have generated.
//
static OracleSQLParser_start_rule_return	start_rule    (pOracleSQLParser ctx);
static OracleSQLParser_delete_statement_return	delete_statement    (pOracleSQLParser ctx);
static OracleSQLParser_merge_statement_return	merge_statement    (pOracleSQLParser ctx);
static OracleSQLParser_merge_update_clause_return	merge_update_clause    (pOracleSQLParser ctx);
static OracleSQLParser_merge_insert_clause_return	merge_insert_clause    (pOracleSQLParser ctx);
static OracleSQLParser_insert_statement_return	insert_statement    (pOracleSQLParser ctx);
static OracleSQLParser_single_table_insert_return	single_table_insert    (pOracleSQLParser ctx);
static OracleSQLParser_insert_into_clause_return	insert_into_clause    (pOracleSQLParser ctx);
static OracleSQLParser_values_clause_return	values_clause    (pOracleSQLParser ctx);
static OracleSQLParser_returning_clause_return	returning_clause    (pOracleSQLParser ctx);
static OracleSQLParser_multi_table_insert_return	multi_table_insert    (pOracleSQLParser ctx);
static OracleSQLParser_conditional_insert_clause_return	conditional_insert_clause    (pOracleSQLParser ctx);
static OracleSQLParser_dml_table_expression_clause_return	dml_table_expression_clause    (pOracleSQLParser ctx);
static OracleSQLParser_error_logging_clause_return	error_logging_clause    (pOracleSQLParser ctx);
static OracleSQLParser_data_item_return	data_item    (pOracleSQLParser ctx);
static OracleSQLParser_update_statement_return	update_statement    (pOracleSQLParser ctx);
static OracleSQLParser_update_set_clause_return	update_set_clause    (pOracleSQLParser ctx);
static OracleSQLParser_update_set_clause_part1_return	update_set_clause_part1    (pOracleSQLParser ctx);
static OracleSQLParser_update_set_clause_part2_return	update_set_clause_part2    (pOracleSQLParser ctx);
static OracleSQLParser_select_statement_return	select_statement    (pOracleSQLParser ctx);
static OracleSQLParser_subquery_factoring_clause_return	subquery_factoring_clause    (pOracleSQLParser ctx);
static OracleSQLParser_subquery_factoring_clause_part_first_return	subquery_factoring_clause_part_first    (pOracleSQLParser ctx);
static OracleSQLParser_subquery_factoring_clause_part_next_return	subquery_factoring_clause_part_next    (pOracleSQLParser ctx);
static OracleSQLParser_search_clause_return	search_clause    (pOracleSQLParser ctx);
static OracleSQLParser_cycle_clause_return	cycle_clause    (pOracleSQLParser ctx);
static OracleSQLParser_select_list_return	select_list    (pOracleSQLParser ctx);
static OracleSQLParser_displayed_column_part_first_return	displayed_column_part_first    (pOracleSQLParser ctx);
static OracleSQLParser_displayed_column_part_next_return	displayed_column_part_next    (pOracleSQLParser ctx);
static OracleSQLParser_displayed_column_return	displayed_column    (pOracleSQLParser ctx);
static OracleSQLParser_sql_expression_return	sql_expression    (pOracleSQLParser ctx);
static OracleSQLParser_expr_add_return	expr_add    (pOracleSQLParser ctx);
static OracleSQLParser_expr_mul_return	expr_mul    (pOracleSQLParser ctx);
static OracleSQLParser_expr_sign_return	expr_sign    (pOracleSQLParser ctx);
static OracleSQLParser_expr_expr_return	expr_expr    (pOracleSQLParser ctx);
static OracleSQLParser_expr_paren_return	expr_paren    (pOracleSQLParser ctx);
static OracleSQLParser_nested_expression_return	nested_expression    (pOracleSQLParser ctx);
static OracleSQLParser_function_expression_return	function_expression    (pOracleSQLParser ctx);
static OracleSQLParser_call_parameters_return	call_parameters    (pOracleSQLParser ctx);
static OracleSQLParser_call_parameter_return	call_parameter    (pOracleSQLParser ctx);
static OracleSQLParser_parameter_name_return	parameter_name    (pOracleSQLParser ctx);
static OracleSQLParser_special_function_return	special_function    (pOracleSQLParser ctx);
static OracleSQLParser_case_expression_return	case_expression    (pOracleSQLParser ctx);
static OracleSQLParser_cursor_expression_return	cursor_expression    (pOracleSQLParser ctx);
static OracleSQLParser_simple_case_expression_return	simple_case_expression    (pOracleSQLParser ctx);
static OracleSQLParser_searched_case_expression_return	searched_case_expression    (pOracleSQLParser ctx);
static OracleSQLParser_else_case_expression_return	else_case_expression    (pOracleSQLParser ctx);
static OracleSQLParser_object_access_expression_return	object_access_expression    (pOracleSQLParser ctx);
static OracleSQLParser_simple_expression_return	simple_expression    (pOracleSQLParser ctx);
static OracleSQLParser_query_block_return	query_block    (pOracleSQLParser ctx);
static OracleSQLParser_subquery_return	subquery    (pOracleSQLParser ctx);
static OracleSQLParser_timestamp_expression_return	timestamp_expression    (pOracleSQLParser ctx);
static OracleSQLParser_interval_x_to_y_return	interval_x_to_y    (pOracleSQLParser ctx);
static OracleSQLParser_precision_return	precision    (pOracleSQLParser ctx);
static OracleSQLParser_extract_datetime_expression_return	extract_datetime_expression    (pOracleSQLParser ctx);
static OracleSQLParser_datetime_expression_return	datetime_expression    (pOracleSQLParser ctx);
static OracleSQLParser_interval_expression_return	interval_expression    (pOracleSQLParser ctx);
static OracleSQLParser_special_expression_return	special_expression    (pOracleSQLParser ctx);
static OracleSQLParser_cluster_set_clause_return	cluster_set_clause    (pOracleSQLParser ctx);
static OracleSQLParser_cast_expression_return	cast_expression    (pOracleSQLParser ctx);
static OracleSQLParser_datatype_name_return	datatype_name    (pOracleSQLParser ctx);
static OracleSQLParser_boolean_literal_return	boolean_literal    (pOracleSQLParser ctx);
static OracleSQLParser_t_alias_return	t_alias    (pOracleSQLParser ctx, int aliasUsage);
static OracleSQLParser_c_alias_return	c_alias    (pOracleSQLParser ctx);
static OracleSQLParser_column_spec_return	column_spec    (pOracleSQLParser ctx);
static OracleSQLParser_pseudo_column_return	pseudo_column    (pOracleSQLParser ctx);
static OracleSQLParser_function_name_return	function_name    (pOracleSQLParser ctx);
static OracleSQLParser_function_spec_return	function_spec    (pOracleSQLParser ctx);
static OracleSQLParser_identifier_return	identifier    (pOracleSQLParser ctx, int identifierClass, int usageType);
static OracleSQLParser_bind_variable_return	bind_variable    (pOracleSQLParser ctx);
static OracleSQLParser_sql_identifier_return	sql_identifier    (pOracleSQLParser ctx, int identifierClass, int usageType);
static OracleSQLParser_table_reference_list_return	table_reference_list    (pOracleSQLParser ctx);
static OracleSQLParser_table_reference_return	table_reference    (pOracleSQLParser ctx);
static OracleSQLParser_query_table_expression_return	query_table_expression    (pOracleSQLParser ctx);
static OracleSQLParser_flashback_query_clause_return	flashback_query_clause    (pOracleSQLParser ctx);
static OracleSQLParser_sample_clause_return	sample_clause    (pOracleSQLParser ctx);
static OracleSQLParser_partition_extension_clause_return	partition_extension_clause    (pOracleSQLParser ctx);
static OracleSQLParser_subquery_restricrion_clause_return	subquery_restricrion_clause    (pOracleSQLParser ctx);
static OracleSQLParser_table_collection_clause_return	table_collection_clause    (pOracleSQLParser ctx);
static OracleSQLParser_join_clause_return	join_clause    (pOracleSQLParser ctx);
static OracleSQLParser_inner_cross_join_clause_return	inner_cross_join_clause    (pOracleSQLParser ctx);
static OracleSQLParser_outer_join_clause_return	outer_join_clause    (pOracleSQLParser ctx);
static OracleSQLParser_query_partition_clause_return	query_partition_clause    (pOracleSQLParser ctx);
static OracleSQLParser_outer_join_type_return	outer_join_type    (pOracleSQLParser ctx);
static OracleSQLParser_joining_clause_return	joining_clause    (pOracleSQLParser ctx);
static OracleSQLParser_sample_percent_return	sample_percent    (pOracleSQLParser ctx);
static OracleSQLParser_seed_value_return	seed_value    (pOracleSQLParser ctx);
static OracleSQLParser_outer_join_sign_return	outer_join_sign    (pOracleSQLParser ctx);
static OracleSQLParser_table_name_long_return	table_name_long    (pOracleSQLParser ctx);
static OracleSQLParser_table_name_return	table_name    (pOracleSQLParser ctx);
static OracleSQLParser_schema_name_return	schema_name    (pOracleSQLParser ctx);
static OracleSQLParser_package_name_return	package_name    (pOracleSQLParser ctx);
static OracleSQLParser_dblink_name_return	dblink_name    (pOracleSQLParser ctx);
static OracleSQLParser_column_specs_return	column_specs    (pOracleSQLParser ctx);
static OracleSQLParser_partition_return	partition    (pOracleSQLParser ctx);
static OracleSQLParser_partition_key_value_return	partition_key_value    (pOracleSQLParser ctx);
static OracleSQLParser_subpartition_key_value_return	subpartition_key_value    (pOracleSQLParser ctx);
static OracleSQLParser_constraint_return	constraint    (pOracleSQLParser ctx);
static OracleSQLParser_collection_expression_return	collection_expression    (pOracleSQLParser ctx);
static OracleSQLParser_where_clause_return	where_clause    (pOracleSQLParser ctx);
static OracleSQLParser_hierarchical_query_clause_return	hierarchical_query_clause    (pOracleSQLParser ctx);
static OracleSQLParser_group_by_clause_return	group_by_clause    (pOracleSQLParser ctx);
static OracleSQLParser_group_by_exprs_return	group_by_exprs    (pOracleSQLParser ctx);
static OracleSQLParser_group_by_expr_return	group_by_expr    (pOracleSQLParser ctx);
static OracleSQLParser_rollup_cube_clause_return	rollup_cube_clause    (pOracleSQLParser ctx);
static OracleSQLParser_grouping_sets_clause_return	grouping_sets_clause    (pOracleSQLParser ctx);
static OracleSQLParser_grouping_sets_exprs_return	grouping_sets_exprs    (pOracleSQLParser ctx);
static OracleSQLParser_grouping_sets_expr_return	grouping_sets_expr    (pOracleSQLParser ctx);
static OracleSQLParser_sql_condition_return	sql_condition    (pOracleSQLParser ctx);
static OracleSQLParser_condition_or_return	condition_or    (pOracleSQLParser ctx);
static OracleSQLParser_condition_and_return	condition_and    (pOracleSQLParser ctx);
static OracleSQLParser_condition_not_return	condition_not    (pOracleSQLParser ctx);
static OracleSQLParser_condition_expr_return	condition_expr    (pOracleSQLParser ctx);
static OracleSQLParser_condition_exists_return	condition_exists    (pOracleSQLParser ctx);
static OracleSQLParser_condition_is_return	condition_is    (pOracleSQLParser ctx);
static OracleSQLParser_condition_comparison_return	condition_comparison    (pOracleSQLParser ctx);
static OracleSQLParser_condition_group_comparison_return	condition_group_comparison    (pOracleSQLParser ctx);
static OracleSQLParser_condition_in_return	condition_in    (pOracleSQLParser ctx);
static OracleSQLParser_condition_is_a_set_return	condition_is_a_set    (pOracleSQLParser ctx);
static OracleSQLParser_condition_is_any_return	condition_is_any    (pOracleSQLParser ctx);
static OracleSQLParser_condition_is_empty_return	condition_is_empty    (pOracleSQLParser ctx);
static OracleSQLParser_condition_is_of_type_return	condition_is_of_type    (pOracleSQLParser ctx);
static OracleSQLParser_condition_is_present_return	condition_is_present    (pOracleSQLParser ctx);
static OracleSQLParser_condition_like_return	condition_like    (pOracleSQLParser ctx);
static OracleSQLParser_condition_memeber_return	condition_memeber    (pOracleSQLParser ctx);
static OracleSQLParser_condition_between_return	condition_between    (pOracleSQLParser ctx);
static OracleSQLParser_condition_regexp_like_return	condition_regexp_like    (pOracleSQLParser ctx);
static OracleSQLParser_condition_submultiset_return	condition_submultiset    (pOracleSQLParser ctx);
static OracleSQLParser_condition_equals_path_return	condition_equals_path    (pOracleSQLParser ctx);
static OracleSQLParser_condition_under_path_return	condition_under_path    (pOracleSQLParser ctx);
static OracleSQLParser_levels_return	levels    (pOracleSQLParser ctx);
static OracleSQLParser_correlation_integer_return	correlation_integer    (pOracleSQLParser ctx);
static OracleSQLParser_path_string_return	path_string    (pOracleSQLParser ctx);
static OracleSQLParser_type_names_return	type_names    (pOracleSQLParser ctx);
static OracleSQLParser_integer_return	integer    (pOracleSQLParser ctx);
static OracleSQLParser_column_name_return	column_name    (pOracleSQLParser ctx);
static OracleSQLParser_nested_table_return	nested_table    (pOracleSQLParser ctx);
static OracleSQLParser_nested_table_column_name_return	nested_table_column_name    (pOracleSQLParser ctx);
static OracleSQLParser_sql_expressions_return	sql_expressions    (pOracleSQLParser ctx);
static OracleSQLParser_grouping_sets_expression_list_return	grouping_sets_expression_list    (pOracleSQLParser ctx);
static OracleSQLParser_grouping_expression_list_return	grouping_expression_list    (pOracleSQLParser ctx);
static OracleSQLParser_expression_list_return	expression_list    (pOracleSQLParser ctx);
static OracleSQLParser_cell_reference_return	cell_reference    (pOracleSQLParser ctx);
static OracleSQLParser_condition_paren_return	condition_paren    (pOracleSQLParser ctx);
static OracleSQLParser_model_clause_return	model_clause    (pOracleSQLParser ctx);
static OracleSQLParser_cell_reference_options_return	cell_reference_options    (pOracleSQLParser ctx);
static OracleSQLParser_return_rows_clause_return	return_rows_clause    (pOracleSQLParser ctx);
static OracleSQLParser_reference_model_return	reference_model    (pOracleSQLParser ctx);
static OracleSQLParser_reference_model_name_return	reference_model_name    (pOracleSQLParser ctx);
static OracleSQLParser_main_model_return	main_model    (pOracleSQLParser ctx);
static OracleSQLParser_main_model_name_return	main_model_name    (pOracleSQLParser ctx);
static OracleSQLParser_model_column_clauses_return	model_column_clauses    (pOracleSQLParser ctx);
static OracleSQLParser_model_columns_return	model_columns    (pOracleSQLParser ctx);
static OracleSQLParser_model_column_return	model_column    (pOracleSQLParser ctx);
static OracleSQLParser_model_rules_clause_return	model_rules_clause    (pOracleSQLParser ctx);
static OracleSQLParser_model_rules_exprs_return	model_rules_exprs    (pOracleSQLParser ctx);
static OracleSQLParser_model_rules_expr_return	model_rules_expr    (pOracleSQLParser ctx);
static OracleSQLParser_cell_assignment_return	cell_assignment    (pOracleSQLParser ctx);
static OracleSQLParser_cell_assignment_exprs_return	cell_assignment_exprs    (pOracleSQLParser ctx);
static OracleSQLParser_cell_assignment_expr_return	cell_assignment_expr    (pOracleSQLParser ctx);
static OracleSQLParser_measure_column_return	measure_column    (pOracleSQLParser ctx);
static OracleSQLParser_single_column_for_loop_return	single_column_for_loop    (pOracleSQLParser ctx);
static OracleSQLParser_pattern_return	pattern    (pOracleSQLParser ctx);
static OracleSQLParser_literal_return	literal    (pOracleSQLParser ctx);
static OracleSQLParser_literals_return	literals    (pOracleSQLParser ctx);
static OracleSQLParser_multi_column_for_loop_return	multi_column_for_loop    (pOracleSQLParser ctx);
static OracleSQLParser_bracket_literals_return	bracket_literals    (pOracleSQLParser ctx);
static OracleSQLParser_bracket_literals_list_return	bracket_literals_list    (pOracleSQLParser ctx);
static OracleSQLParser_union_clause_return	union_clause    (pOracleSQLParser ctx);
static OracleSQLParser_order_by_clause_return	order_by_clause    (pOracleSQLParser ctx);
static OracleSQLParser_order_by_clause_part_first_return	order_by_clause_part_first    (pOracleSQLParser ctx);
static OracleSQLParser_order_by_clause_part_next_return	order_by_clause_part_next    (pOracleSQLParser ctx);
static OracleSQLParser_analytic_function_name_return	analytic_function_name    (pOracleSQLParser ctx);
static OracleSQLParser_analytic_function_call_return	analytic_function_call    (pOracleSQLParser ctx);
static OracleSQLParser_analytic_function_return	analytic_function    (pOracleSQLParser ctx);
static OracleSQLParser_count_function_return	count_function    (pOracleSQLParser ctx);
static OracleSQLParser_analytic_clause_return	analytic_clause    (pOracleSQLParser ctx);
static OracleSQLParser_windowing_clause_part_return	windowing_clause_part    (pOracleSQLParser ctx);
static OracleSQLParser_windowing_clause_return	windowing_clause    (pOracleSQLParser ctx);
static OracleSQLParser_aggregate_function_name_return	aggregate_function_name    (pOracleSQLParser ctx);
static OracleSQLParser_aggregate_function_return	aggregate_function    (pOracleSQLParser ctx);
static OracleSQLParser_percent_rank_aggregate_return	percent_rank_aggregate    (pOracleSQLParser ctx);
static OracleSQLParser_dense_rank_aggregate_return	dense_rank_aggregate    (pOracleSQLParser ctx);
static OracleSQLParser_percent_rank_analytic_return	percent_rank_analytic    (pOracleSQLParser ctx);
static OracleSQLParser_percent_cont_disc_analytic_return	percent_cont_disc_analytic    (pOracleSQLParser ctx);
static OracleSQLParser_dense_rank_analytic_return	dense_rank_analytic    (pOracleSQLParser ctx);
static OracleSQLParser_first_last_return	first_last    (pOracleSQLParser ctx);
static OracleSQLParser_listagg_return	listagg    (pOracleSQLParser ctx);
static OracleSQLParser_for_update_clause_return	for_update_clause    (pOracleSQLParser ctx);
static OracleSQLParser_for_update_clause_part_first_return	for_update_clause_part_first    (pOracleSQLParser ctx);
static OracleSQLParser_for_update_clause_part_next_return	for_update_clause_part_next    (pOracleSQLParser ctx);
static OracleSQLParser_pivot_clause_return	pivot_clause    (pOracleSQLParser ctx);
static OracleSQLParser_pivot_for_clause_return	pivot_for_clause    (pOracleSQLParser ctx);
static OracleSQLParser_pivot_in_clause_return	pivot_in_clause    (pOracleSQLParser ctx);
static OracleSQLParser_unpivot_clause_return	unpivot_clause    (pOracleSQLParser ctx);
static OracleSQLParser_unpivot_in_clause_return	unpivot_in_clause    (pOracleSQLParser ctx);
static OracleSQLParser_constant_return	constant    (pOracleSQLParser ctx);
static OracleSQLParser_r_access_return	r_access    (pOracleSQLParser ctx);
static OracleSQLParser_r_add_return	r_add    (pOracleSQLParser ctx);
static OracleSQLParser_r_all_return	r_all    (pOracleSQLParser ctx);
static OracleSQLParser_r_alter_return	r_alter    (pOracleSQLParser ctx);
static OracleSQLParser_r_and_return	r_and    (pOracleSQLParser ctx);
static OracleSQLParser_r_any_return	r_any    (pOracleSQLParser ctx);
static OracleSQLParser_r_arraylen_return	r_arraylen    (pOracleSQLParser ctx);
static OracleSQLParser_r_as_return	r_as    (pOracleSQLParser ctx);
static OracleSQLParser_r_asc_return	r_asc    (pOracleSQLParser ctx);
static OracleSQLParser_r_audit_return	r_audit    (pOracleSQLParser ctx);
static OracleSQLParser_r_between_return	r_between    (pOracleSQLParser ctx);
static OracleSQLParser_r_by_return	r_by    (pOracleSQLParser ctx);
static OracleSQLParser_r_case_return	r_case    (pOracleSQLParser ctx);
static OracleSQLParser_r_char_return	r_char    (pOracleSQLParser ctx);
static OracleSQLParser_r_check_return	r_check    (pOracleSQLParser ctx);
static OracleSQLParser_r_cluster_return	r_cluster    (pOracleSQLParser ctx);
static OracleSQLParser_r_column_return	r_column    (pOracleSQLParser ctx);
static OracleSQLParser_r_comment_return	r_comment    (pOracleSQLParser ctx);
static OracleSQLParser_r_compress_return	r_compress    (pOracleSQLParser ctx);
static OracleSQLParser_r_connect_return	r_connect    (pOracleSQLParser ctx);
static OracleSQLParser_r_create_return	r_create    (pOracleSQLParser ctx);
static OracleSQLParser_r_current_return	r_current    (pOracleSQLParser ctx);
static OracleSQLParser_r_date_return	r_date    (pOracleSQLParser ctx);
static OracleSQLParser_r_decimal_return	r_decimal    (pOracleSQLParser ctx);
static OracleSQLParser_r_default_return	r_default    (pOracleSQLParser ctx);
static OracleSQLParser_r_delete_return	r_delete    (pOracleSQLParser ctx);
static OracleSQLParser_r_desc_return	r_desc    (pOracleSQLParser ctx);
static OracleSQLParser_r_distinct_return	r_distinct    (pOracleSQLParser ctx);
static OracleSQLParser_r_drop_return	r_drop    (pOracleSQLParser ctx);
static OracleSQLParser_r_else_return	r_else    (pOracleSQLParser ctx);
static OracleSQLParser_r_exclusive_return	r_exclusive    (pOracleSQLParser ctx);
static OracleSQLParser_r_exists_return	r_exists    (pOracleSQLParser ctx);
static OracleSQLParser_r_false_return	r_false    (pOracleSQLParser ctx);
static OracleSQLParser_r_file_return	r_file    (pOracleSQLParser ctx);
static OracleSQLParser_r_float_return	r_float    (pOracleSQLParser ctx);
static OracleSQLParser_r_for_return	r_for    (pOracleSQLParser ctx);
static OracleSQLParser_r_from_return	r_from    (pOracleSQLParser ctx);
static OracleSQLParser_r_grant_return	r_grant    (pOracleSQLParser ctx);
static OracleSQLParser_r_group_return	r_group    (pOracleSQLParser ctx);
static OracleSQLParser_r_having_return	r_having    (pOracleSQLParser ctx);
static OracleSQLParser_r_identified_return	r_identified    (pOracleSQLParser ctx);
static OracleSQLParser_r_immediate_return	r_immediate    (pOracleSQLParser ctx);
static OracleSQLParser_r_in_return	r_in    (pOracleSQLParser ctx);
static OracleSQLParser_r_increment_return	r_increment    (pOracleSQLParser ctx);
static OracleSQLParser_r_index_return	r_index    (pOracleSQLParser ctx);
static OracleSQLParser_r_initial_return	r_initial    (pOracleSQLParser ctx);
static OracleSQLParser_r_insert_return	r_insert    (pOracleSQLParser ctx);
static OracleSQLParser_r_integer_return	r_integer    (pOracleSQLParser ctx);
static OracleSQLParser_r_intersect_return	r_intersect    (pOracleSQLParser ctx);
static OracleSQLParser_r_into_return	r_into    (pOracleSQLParser ctx);
static OracleSQLParser_r_is_return	r_is    (pOracleSQLParser ctx);
static OracleSQLParser_r_level_return	r_level    (pOracleSQLParser ctx);
static OracleSQLParser_r_like_return	r_like    (pOracleSQLParser ctx);
static OracleSQLParser_r_lock_return	r_lock    (pOracleSQLParser ctx);
static OracleSQLParser_r_long_return	r_long    (pOracleSQLParser ctx);
static OracleSQLParser_r_maxextents_return	r_maxextents    (pOracleSQLParser ctx);
static OracleSQLParser_r_minus_return	r_minus    (pOracleSQLParser ctx);
static OracleSQLParser_r_mode_return	r_mode    (pOracleSQLParser ctx);
static OracleSQLParser_r_modify_return	r_modify    (pOracleSQLParser ctx);
static OracleSQLParser_r_noaudit_return	r_noaudit    (pOracleSQLParser ctx);
static OracleSQLParser_r_nocompress_return	r_nocompress    (pOracleSQLParser ctx);
static OracleSQLParser_r_not_return	r_not    (pOracleSQLParser ctx);
static OracleSQLParser_r_notfound_return	r_notfound    (pOracleSQLParser ctx);
static OracleSQLParser_r_nowait_return	r_nowait    (pOracleSQLParser ctx);
static OracleSQLParser_r_null_return	r_null    (pOracleSQLParser ctx);
static OracleSQLParser_r_number_return	r_number    (pOracleSQLParser ctx);
static OracleSQLParser_r_of_return	r_of    (pOracleSQLParser ctx);
static OracleSQLParser_r_offline_return	r_offline    (pOracleSQLParser ctx);
static OracleSQLParser_r_on_return	r_on    (pOracleSQLParser ctx);
static OracleSQLParser_r_online_return	r_online    (pOracleSQLParser ctx);
static OracleSQLParser_r_option_return	r_option    (pOracleSQLParser ctx);
static OracleSQLParser_r_or_return	r_or    (pOracleSQLParser ctx);
static OracleSQLParser_r_order_return	r_order    (pOracleSQLParser ctx);
static OracleSQLParser_r_pctfree_return	r_pctfree    (pOracleSQLParser ctx);
static OracleSQLParser_r_prior_return	r_prior    (pOracleSQLParser ctx);
static OracleSQLParser_r_privileges_return	r_privileges    (pOracleSQLParser ctx);
static OracleSQLParser_r_public_return	r_public    (pOracleSQLParser ctx);
static OracleSQLParser_r_raw_return	r_raw    (pOracleSQLParser ctx);
static OracleSQLParser_r_rename_return	r_rename    (pOracleSQLParser ctx);
static OracleSQLParser_r_resource_return	r_resource    (pOracleSQLParser ctx);
static OracleSQLParser_r_revoke_return	r_revoke    (pOracleSQLParser ctx);
static OracleSQLParser_r_row_return	r_row    (pOracleSQLParser ctx);
static OracleSQLParser_r_rowid_return	r_rowid    (pOracleSQLParser ctx);
static OracleSQLParser_r_rowlabel_return	r_rowlabel    (pOracleSQLParser ctx);
static OracleSQLParser_r_rownum_return	r_rownum    (pOracleSQLParser ctx);
static OracleSQLParser_r_rows_return	r_rows    (pOracleSQLParser ctx);
static OracleSQLParser_r_select_return	r_select    (pOracleSQLParser ctx);
static OracleSQLParser_r_session_return	r_session    (pOracleSQLParser ctx);
static OracleSQLParser_r_set_return	r_set    (pOracleSQLParser ctx);
static OracleSQLParser_r_share_return	r_share    (pOracleSQLParser ctx);
static OracleSQLParser_r_size_return	r_size    (pOracleSQLParser ctx);
static OracleSQLParser_r_smallint_return	r_smallint    (pOracleSQLParser ctx);
static OracleSQLParser_r_sqlbuf_return	r_sqlbuf    (pOracleSQLParser ctx);
static OracleSQLParser_r_start_return	r_start    (pOracleSQLParser ctx);
static OracleSQLParser_r_successful_return	r_successful    (pOracleSQLParser ctx);
static OracleSQLParser_r_synonym_return	r_synonym    (pOracleSQLParser ctx);
static OracleSQLParser_r_sysdate_return	r_sysdate    (pOracleSQLParser ctx);
static OracleSQLParser_r_table_return	r_table    (pOracleSQLParser ctx);
static OracleSQLParser_r_then_return	r_then    (pOracleSQLParser ctx);
static OracleSQLParser_r_to_return	r_to    (pOracleSQLParser ctx);
static OracleSQLParser_r_trigger_return	r_trigger    (pOracleSQLParser ctx);
static OracleSQLParser_r_true_return	r_true    (pOracleSQLParser ctx);
static OracleSQLParser_r_uid_return	r_uid    (pOracleSQLParser ctx);
static OracleSQLParser_r_union_return	r_union    (pOracleSQLParser ctx);
static OracleSQLParser_r_unique_return	r_unique    (pOracleSQLParser ctx);
static OracleSQLParser_r_update_return	r_update    (pOracleSQLParser ctx);
static OracleSQLParser_r_user_return	r_user    (pOracleSQLParser ctx);
static OracleSQLParser_r_validate_return	r_validate    (pOracleSQLParser ctx);
static OracleSQLParser_r_values_return	r_values    (pOracleSQLParser ctx);
static OracleSQLParser_r_varchar_return	r_varchar    (pOracleSQLParser ctx);
static OracleSQLParser_r_varchar2_return	r_varchar2    (pOracleSQLParser ctx);
static OracleSQLParser_r_view_return	r_view    (pOracleSQLParser ctx);
static OracleSQLParser_r_whenever_return	r_whenever    (pOracleSQLParser ctx);
static OracleSQLParser_r_where_return	r_where    (pOracleSQLParser ctx);
static OracleSQLParser_r_with_return	r_with    (pOracleSQLParser ctx);
static OracleSQLParser_k_a_return	k_a    (pOracleSQLParser ctx);
static OracleSQLParser_k_at_return	k_at    (pOracleSQLParser ctx);
static OracleSQLParser_k_automatic_return	k_automatic    (pOracleSQLParser ctx);
static OracleSQLParser_k_bfile_return	k_bfile    (pOracleSQLParser ctx);
static OracleSQLParser_k_binary_double_return	k_binary_double    (pOracleSQLParser ctx);
static OracleSQLParser_k_binary_float_return	k_binary_float    (pOracleSQLParser ctx);
static OracleSQLParser_k_binary_integer_return	k_binary_integer    (pOracleSQLParser ctx);
static OracleSQLParser_k_blob_return	k_blob    (pOracleSQLParser ctx);
static OracleSQLParser_k_block_return	k_block    (pOracleSQLParser ctx);
static OracleSQLParser_k_boolean_return	k_boolean    (pOracleSQLParser ctx);
static OracleSQLParser_k_both_return	k_both    (pOracleSQLParser ctx);
static OracleSQLParser_k_breadth_return	k_breadth    (pOracleSQLParser ctx);
static OracleSQLParser_k_byte_return	k_byte    (pOracleSQLParser ctx);
static OracleSQLParser_k_cast_return	k_cast    (pOracleSQLParser ctx);
static OracleSQLParser_k_character_return	k_character    (pOracleSQLParser ctx);
static OracleSQLParser_k_clob_return	k_clob    (pOracleSQLParser ctx);
static OracleSQLParser_k_cluster_set_return	k_cluster_set    (pOracleSQLParser ctx);
static OracleSQLParser_k_connect_by_root_return	k_connect_by_root    (pOracleSQLParser ctx);
static OracleSQLParser_k_constraint_return	k_constraint    (pOracleSQLParser ctx);
static OracleSQLParser_k_count_return	k_count    (pOracleSQLParser ctx);
static OracleSQLParser_k_cross_return	k_cross    (pOracleSQLParser ctx);
static OracleSQLParser_k_cube_return	k_cube    (pOracleSQLParser ctx);
static OracleSQLParser_k_cursor_return	k_cursor    (pOracleSQLParser ctx);
static OracleSQLParser_k_cycle_return	k_cycle    (pOracleSQLParser ctx);
static OracleSQLParser_k_day_return	k_day    (pOracleSQLParser ctx);
static OracleSQLParser_k_dbtimezone_return	k_dbtimezone    (pOracleSQLParser ctx);
static OracleSQLParser_k_dec_return	k_dec    (pOracleSQLParser ctx);
static OracleSQLParser_k_decrement_return	k_decrement    (pOracleSQLParser ctx);
static OracleSQLParser_k_dense_rank_return	k_dense_rank    (pOracleSQLParser ctx);
static OracleSQLParser_k_depth_return	k_depth    (pOracleSQLParser ctx);
static OracleSQLParser_k_dimension_return	k_dimension    (pOracleSQLParser ctx);
static OracleSQLParser_k_double_return	k_double    (pOracleSQLParser ctx);
static OracleSQLParser_k_empty_return	k_empty    (pOracleSQLParser ctx);
static OracleSQLParser_k_end_return	k_end    (pOracleSQLParser ctx);
static OracleSQLParser_k_equals_path_return	k_equals_path    (pOracleSQLParser ctx);
static OracleSQLParser_k_errors_return	k_errors    (pOracleSQLParser ctx);
static OracleSQLParser_k_escape_return	k_escape    (pOracleSQLParser ctx);
static OracleSQLParser_k_exclude_return	k_exclude    (pOracleSQLParser ctx);
static OracleSQLParser_k_extract_return	k_extract    (pOracleSQLParser ctx);
static OracleSQLParser_k_first_return	k_first    (pOracleSQLParser ctx);
static OracleSQLParser_k_following_return	k_following    (pOracleSQLParser ctx);
static OracleSQLParser_k_full_return	k_full    (pOracleSQLParser ctx);
static OracleSQLParser_k_grouping_return	k_grouping    (pOracleSQLParser ctx);
static OracleSQLParser_k_hour_return	k_hour    (pOracleSQLParser ctx);
static OracleSQLParser_k_ignore_return	k_ignore    (pOracleSQLParser ctx);
static OracleSQLParser_k_include_return	k_include    (pOracleSQLParser ctx);
static OracleSQLParser_k_infinite_return	k_infinite    (pOracleSQLParser ctx);
static OracleSQLParser_k_inner_return	k_inner    (pOracleSQLParser ctx);
static OracleSQLParser_k_int_return	k_int    (pOracleSQLParser ctx);
static OracleSQLParser_k_interval_return	k_interval    (pOracleSQLParser ctx);
static OracleSQLParser_k_iterate_return	k_iterate    (pOracleSQLParser ctx);
static OracleSQLParser_k_join_return	k_join    (pOracleSQLParser ctx);
static OracleSQLParser_k_keep_return	k_keep    (pOracleSQLParser ctx);
static OracleSQLParser_k_last_return	k_last    (pOracleSQLParser ctx);
static OracleSQLParser_k_leading_return	k_leading    (pOracleSQLParser ctx);
static OracleSQLParser_k_left_return	k_left    (pOracleSQLParser ctx);
static OracleSQLParser_k_like2_return	k_like2    (pOracleSQLParser ctx);
static OracleSQLParser_k_like4_return	k_like4    (pOracleSQLParser ctx);
static OracleSQLParser_k_likec_return	k_likec    (pOracleSQLParser ctx);
static OracleSQLParser_k_limit_return	k_limit    (pOracleSQLParser ctx);
static OracleSQLParser_k_listagg_return	k_listagg    (pOracleSQLParser ctx);
static OracleSQLParser_k_lnnvl_return	k_lnnvl    (pOracleSQLParser ctx);
static OracleSQLParser_k_local_return	k_local    (pOracleSQLParser ctx);
static OracleSQLParser_k_locked_return	k_locked    (pOracleSQLParser ctx);
static OracleSQLParser_k_log_return	k_log    (pOracleSQLParser ctx);
static OracleSQLParser_k_main_return	k_main    (pOracleSQLParser ctx);
static OracleSQLParser_k_matched_return	k_matched    (pOracleSQLParser ctx);
static OracleSQLParser_k_maxvalue_return	k_maxvalue    (pOracleSQLParser ctx);
static OracleSQLParser_k_measures_return	k_measures    (pOracleSQLParser ctx);
static OracleSQLParser_k_member_return	k_member    (pOracleSQLParser ctx);
static OracleSQLParser_k_merge_return	k_merge    (pOracleSQLParser ctx);
static OracleSQLParser_k_minute_return	k_minute    (pOracleSQLParser ctx);
static OracleSQLParser_k_mivalue_return	k_mivalue    (pOracleSQLParser ctx);
static OracleSQLParser_k_mlslabel_return	k_mlslabel    (pOracleSQLParser ctx);
static OracleSQLParser_k_model_return	k_model    (pOracleSQLParser ctx);
static OracleSQLParser_k_month_return	k_month    (pOracleSQLParser ctx);
static OracleSQLParser_k_multiset_return	k_multiset    (pOracleSQLParser ctx);
static OracleSQLParser_k_nan_return	k_nan    (pOracleSQLParser ctx);
static OracleSQLParser_k_national_return	k_national    (pOracleSQLParser ctx);
static OracleSQLParser_k_natural_return	k_natural    (pOracleSQLParser ctx);
static OracleSQLParser_k_nav_return	k_nav    (pOracleSQLParser ctx);
static OracleSQLParser_k_nchar_return	k_nchar    (pOracleSQLParser ctx);
static OracleSQLParser_k_nclob_return	k_nclob    (pOracleSQLParser ctx);
static OracleSQLParser_k_nocycle_return	k_nocycle    (pOracleSQLParser ctx);
static OracleSQLParser_k_nulls_return	k_nulls    (pOracleSQLParser ctx);
static OracleSQLParser_k_numeric_return	k_numeric    (pOracleSQLParser ctx);
static OracleSQLParser_k_nvarchar_return	k_nvarchar    (pOracleSQLParser ctx);
static OracleSQLParser_k_nvarchar2_return	k_nvarchar2    (pOracleSQLParser ctx);
static OracleSQLParser_k_only_return	k_only    (pOracleSQLParser ctx);
static OracleSQLParser_k_outer_return	k_outer    (pOracleSQLParser ctx);
static OracleSQLParser_k_over_return	k_over    (pOracleSQLParser ctx);
static OracleSQLParser_k_partition_return	k_partition    (pOracleSQLParser ctx);
static OracleSQLParser_k_percent_rank_return	k_percent_rank    (pOracleSQLParser ctx);
static OracleSQLParser_k_percentile_cont_return	k_percentile_cont    (pOracleSQLParser ctx);
static OracleSQLParser_k_percentile_disc_return	k_percentile_disc    (pOracleSQLParser ctx);
static OracleSQLParser_k_pivot_return	k_pivot    (pOracleSQLParser ctx);
static OracleSQLParser_k_pls_integer_return	k_pls_integer    (pOracleSQLParser ctx);
static OracleSQLParser_k_positive_return	k_positive    (pOracleSQLParser ctx);
static OracleSQLParser_k_preceding_return	k_preceding    (pOracleSQLParser ctx);
static OracleSQLParser_k_precision_return	k_precision    (pOracleSQLParser ctx);
static OracleSQLParser_k_present_return	k_present    (pOracleSQLParser ctx);
static OracleSQLParser_k_range_return	k_range    (pOracleSQLParser ctx);
static OracleSQLParser_k_read_return	k_read    (pOracleSQLParser ctx);
static OracleSQLParser_k_real_return	k_real    (pOracleSQLParser ctx);
static OracleSQLParser_k_reference_return	k_reference    (pOracleSQLParser ctx);
static OracleSQLParser_k_regexp_like_return	k_regexp_like    (pOracleSQLParser ctx);
static OracleSQLParser_k_reject_return	k_reject    (pOracleSQLParser ctx);
static OracleSQLParser_k_respect_return	k_respect    (pOracleSQLParser ctx);
static OracleSQLParser_k_return_return	k_return    (pOracleSQLParser ctx);
static OracleSQLParser_k_returning_return	k_returning    (pOracleSQLParser ctx);
static OracleSQLParser_k_right_return	k_right    (pOracleSQLParser ctx);
static OracleSQLParser_k_rollup_return	k_rollup    (pOracleSQLParser ctx);
static OracleSQLParser_k_rules_return	k_rules    (pOracleSQLParser ctx);
static OracleSQLParser_k_sample_return	k_sample    (pOracleSQLParser ctx);
static OracleSQLParser_k_scn_return	k_scn    (pOracleSQLParser ctx);
static OracleSQLParser_k_search_return	k_search    (pOracleSQLParser ctx);
static OracleSQLParser_k_second_return	k_second    (pOracleSQLParser ctx);
static OracleSQLParser_k_seed_return	k_seed    (pOracleSQLParser ctx);
static OracleSQLParser_k_sequential_return	k_sequential    (pOracleSQLParser ctx);
static OracleSQLParser_k_sessiontimezone_return	k_sessiontimezone    (pOracleSQLParser ctx);
static OracleSQLParser_k_sets_return	k_sets    (pOracleSQLParser ctx);
static OracleSQLParser_k_siblings_return	k_siblings    (pOracleSQLParser ctx);
static OracleSQLParser_k_single_return	k_single    (pOracleSQLParser ctx);
static OracleSQLParser_k_skip_return	k_skip    (pOracleSQLParser ctx);
static OracleSQLParser_k_some_return	k_some    (pOracleSQLParser ctx);
static OracleSQLParser_k_sql_return	k_sql    (pOracleSQLParser ctx);
static OracleSQLParser_k_submultiset_return	k_submultiset    (pOracleSQLParser ctx);
static OracleSQLParser_k_subpartition_return	k_subpartition    (pOracleSQLParser ctx);
static OracleSQLParser_k_the_return	k_the    (pOracleSQLParser ctx);
static OracleSQLParser_k_time_return	k_time    (pOracleSQLParser ctx);
static OracleSQLParser_k_timestamp_return	k_timestamp    (pOracleSQLParser ctx);
static OracleSQLParser_k_timezone_hour_return	k_timezone_hour    (pOracleSQLParser ctx);
static OracleSQLParser_k_timezone_minute_return	k_timezone_minute    (pOracleSQLParser ctx);
static OracleSQLParser_k_timezone_region_return	k_timezone_region    (pOracleSQLParser ctx);
static OracleSQLParser_k_timezone_abbr_return	k_timezone_abbr    (pOracleSQLParser ctx);
static OracleSQLParser_k_to_return	k_to    (pOracleSQLParser ctx);
static OracleSQLParser_k_trailing_return	k_trailing    (pOracleSQLParser ctx);
static OracleSQLParser_k_trim_return	k_trim    (pOracleSQLParser ctx);
static OracleSQLParser_k_type_return	k_type    (pOracleSQLParser ctx);
static OracleSQLParser_k_unbounded_return	k_unbounded    (pOracleSQLParser ctx);
static OracleSQLParser_k_under_path_return	k_under_path    (pOracleSQLParser ctx);
static OracleSQLParser_k_unlimited_return	k_unlimited    (pOracleSQLParser ctx);
static OracleSQLParser_k_unpivot_return	k_unpivot    (pOracleSQLParser ctx);
static OracleSQLParser_k_until_return	k_until    (pOracleSQLParser ctx);
static OracleSQLParser_k_updated_return	k_updated    (pOracleSQLParser ctx);
static OracleSQLParser_k_upsert_return	k_upsert    (pOracleSQLParser ctx);
static OracleSQLParser_k_urowid_return	k_urowid    (pOracleSQLParser ctx);
static OracleSQLParser_k_using_return	k_using    (pOracleSQLParser ctx);
static OracleSQLParser_k_value_return	k_value    (pOracleSQLParser ctx);
static OracleSQLParser_k_varying_return	k_varying    (pOracleSQLParser ctx);
static OracleSQLParser_k_versions_return	k_versions    (pOracleSQLParser ctx);
static OracleSQLParser_k_wait_return	k_wait    (pOracleSQLParser ctx);
static OracleSQLParser_k_when_return	k_when    (pOracleSQLParser ctx);
static OracleSQLParser_k_within_return	k_within    (pOracleSQLParser ctx);
static OracleSQLParser_k_xml_return	k_xml    (pOracleSQLParser ctx);
static OracleSQLParser_k_year_return	k_year    (pOracleSQLParser ctx);
static OracleSQLParser_k_zone_return	k_zone    (pOracleSQLParser ctx);
static OracleSQLParser_keyword_return	keyword    (pOracleSQLParser ctx, int identifierClass, int usageType);
static OracleSQLParser_quoted_string_return	quoted_string    (pOracleSQLParser ctx);
static OracleSQLParser_doublevertbar_return	doublevertbar    (pOracleSQLParser ctx);
static OracleSQLParser_not_equal_return	not_equal    (pOracleSQLParser ctx);
static OracleSQLParser_leq_return	leq    (pOracleSQLParser ctx);
static OracleSQLParser_geq_return	geq    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred8_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred15_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred17_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred33_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred35_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred54_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred58_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred59_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred60_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred62_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred63_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred73_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred79_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred87_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred88_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred89_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred92_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred93_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred94_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred95_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred96_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred103_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred121_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred123_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred128_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred129_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred130_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred131_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred132_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred133_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred134_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred135_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred136_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred137_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred138_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred139_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred140_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred141_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred142_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred144_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred145_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred150_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred151_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred152_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred155_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred157_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred162_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred163_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred170_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred171_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred182_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred183_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred186_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred187_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred188_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred189_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred190_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred191_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred192_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred195_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred196_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred197_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred198_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred199_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred202_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred203_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred204_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred206_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred208_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred209_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred210_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred212_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred213_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred214_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred215_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred216_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred219_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred220_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred221_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred222_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred223_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred224_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred225_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred226_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred227_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred230_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred231_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred232_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred233_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred240_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred247_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred248_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred249_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred250_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred251_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred252_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred254_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred258_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred264_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred268_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred270_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred275_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred277_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred281_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred282_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred304_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred307_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred309_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred311_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred315_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred316_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred317_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred318_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred321_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred322_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred323_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred331_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred344_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred345_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred346_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred347_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred348_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred349_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred350_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred352_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred353_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred354_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred356_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred357_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred358_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred359_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred363_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred364_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred365_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred367_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred368_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred373_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred380_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred382_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred383_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred384_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred385_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred386_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred388_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred389_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred390_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred395_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred396_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred410_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred411_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred413_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred414_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred415_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred416_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred417_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred418_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred419_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred420_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred423_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred424_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred425_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred427_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred428_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred429_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred430_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred431_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred432_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred433_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred434_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred435_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred436_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred437_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred438_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred439_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred440_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred441_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred442_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred443_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred444_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred449_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred455_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred456_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred457_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred464_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred465_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred466_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred470_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred471_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred479_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred481_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred482_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred484_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred485_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred496_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred499_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred506_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred508_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred511_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred512_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred514_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred515_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred516_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred517_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred518_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred520_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred521_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred522_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred523_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred524_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred539_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred551_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred552_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred566_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred568_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred569_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred570_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred571_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred572_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred573_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred574_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred575_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred576_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred584_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred585_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred586_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred587_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred588_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred605_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred606_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred607_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred608_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred609_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred615_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred616_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred618_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred619_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred620_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred622_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred623_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred624_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred625_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred627_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred628_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred629_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred631_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred632_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred633_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred643_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred647_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred648_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred650_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred657_OracleSQL    (pOracleSQLParser ctx);
static ANTLR3_BOOLEAN	synpred662_OracleSQL    (pOracleSQLParser ctx);
static void	OracleSQLParserFree(pOracleSQLParser ctx);
static void     OracleSQLParserReset (pOracleSQLParser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed. 
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "OracleSQL.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new OracleSQLParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pOracleSQLParser
OracleSQLParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return OracleSQLParserNewSSD(instream, NULL);
}

/** \brief Create a new OracleSQLParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pOracleSQLParser
OracleSQLParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pOracleSQLParser ctx;	    /* Context structure we will build and return   */
    
    ctx	= (pOracleSQLParser) ANTLR3_CALLOC(1, sizeof(OracleSQLParser));
    
    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }
    
    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function. 
     *
     * We don't use the macros defined in OracleSQLParser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our OracleSQLParser interface
     */
    ctx->start_rule	= start_rule;
    ctx->delete_statement	= delete_statement;
    ctx->merge_statement	= merge_statement;
    ctx->merge_update_clause	= merge_update_clause;
    ctx->merge_insert_clause	= merge_insert_clause;
    ctx->insert_statement	= insert_statement;
    ctx->single_table_insert	= single_table_insert;
    ctx->insert_into_clause	= insert_into_clause;
    ctx->values_clause	= values_clause;
    ctx->returning_clause	= returning_clause;
    ctx->multi_table_insert	= multi_table_insert;
    ctx->conditional_insert_clause	= conditional_insert_clause;
    ctx->dml_table_expression_clause	= dml_table_expression_clause;
    ctx->error_logging_clause	= error_logging_clause;
    ctx->data_item	= data_item;
    ctx->update_statement	= update_statement;
    ctx->update_set_clause	= update_set_clause;
    ctx->update_set_clause_part1	= update_set_clause_part1;
    ctx->update_set_clause_part2	= update_set_clause_part2;
    ctx->select_statement	= select_statement;
    ctx->subquery_factoring_clause	= subquery_factoring_clause;
    ctx->subquery_factoring_clause_part_first	= subquery_factoring_clause_part_first;
    ctx->subquery_factoring_clause_part_next	= subquery_factoring_clause_part_next;
    ctx->search_clause	= search_clause;
    ctx->cycle_clause	= cycle_clause;
    ctx->select_list	= select_list;
    ctx->displayed_column_part_first	= displayed_column_part_first;
    ctx->displayed_column_part_next	= displayed_column_part_next;
    ctx->displayed_column	= displayed_column;
    ctx->sql_expression	= sql_expression;
    ctx->expr_add	= expr_add;
    ctx->expr_mul	= expr_mul;
    ctx->expr_sign	= expr_sign;
    ctx->expr_expr	= expr_expr;
    ctx->expr_paren	= expr_paren;
    ctx->nested_expression	= nested_expression;
    ctx->function_expression	= function_expression;
    ctx->call_parameters	= call_parameters;
    ctx->call_parameter	= call_parameter;
    ctx->parameter_name	= parameter_name;
    ctx->special_function	= special_function;
    ctx->case_expression	= case_expression;
    ctx->cursor_expression	= cursor_expression;
    ctx->simple_case_expression	= simple_case_expression;
    ctx->searched_case_expression	= searched_case_expression;
    ctx->else_case_expression	= else_case_expression;
    ctx->object_access_expression	= object_access_expression;
    ctx->simple_expression	= simple_expression;
    ctx->query_block	= query_block;
    ctx->subquery	= subquery;
    ctx->timestamp_expression	= timestamp_expression;
    ctx->interval_x_to_y	= interval_x_to_y;
    ctx->precision	= precision;
    ctx->extract_datetime_expression	= extract_datetime_expression;
    ctx->datetime_expression	= datetime_expression;
    ctx->interval_expression	= interval_expression;
    ctx->special_expression	= special_expression;
    ctx->cluster_set_clause	= cluster_set_clause;
    ctx->cast_expression	= cast_expression;
    ctx->datatype_name	= datatype_name;
    ctx->boolean_literal	= boolean_literal;
    ctx->t_alias	= t_alias;
    ctx->c_alias	= c_alias;
    ctx->column_spec	= column_spec;
    ctx->pseudo_column	= pseudo_column;
    ctx->function_name	= function_name;
    ctx->function_spec	= function_spec;
    ctx->identifier	= identifier;
    ctx->bind_variable	= bind_variable;
    ctx->sql_identifier	= sql_identifier;
    ctx->table_reference_list	= table_reference_list;
    ctx->table_reference	= table_reference;
    ctx->query_table_expression	= query_table_expression;
    ctx->flashback_query_clause	= flashback_query_clause;
    ctx->sample_clause	= sample_clause;
    ctx->partition_extension_clause	= partition_extension_clause;
    ctx->subquery_restricrion_clause	= subquery_restricrion_clause;
    ctx->table_collection_clause	= table_collection_clause;
    ctx->join_clause	= join_clause;
    ctx->inner_cross_join_clause	= inner_cross_join_clause;
    ctx->outer_join_clause	= outer_join_clause;
    ctx->query_partition_clause	= query_partition_clause;
    ctx->outer_join_type	= outer_join_type;
    ctx->joining_clause	= joining_clause;
    ctx->sample_percent	= sample_percent;
    ctx->seed_value	= seed_value;
    ctx->outer_join_sign	= outer_join_sign;
    ctx->table_name_long	= table_name_long;
    ctx->table_name	= table_name;
    ctx->schema_name	= schema_name;
    ctx->package_name	= package_name;
    ctx->dblink_name	= dblink_name;
    ctx->column_specs	= column_specs;
    ctx->partition	= partition;
    ctx->partition_key_value	= partition_key_value;
    ctx->subpartition_key_value	= subpartition_key_value;
    ctx->constraint	= constraint;
    ctx->collection_expression	= collection_expression;
    ctx->where_clause	= where_clause;
    ctx->hierarchical_query_clause	= hierarchical_query_clause;
    ctx->group_by_clause	= group_by_clause;
    ctx->group_by_exprs	= group_by_exprs;
    ctx->group_by_expr	= group_by_expr;
    ctx->rollup_cube_clause	= rollup_cube_clause;
    ctx->grouping_sets_clause	= grouping_sets_clause;
    ctx->grouping_sets_exprs	= grouping_sets_exprs;
    ctx->grouping_sets_expr	= grouping_sets_expr;
    ctx->sql_condition	= sql_condition;
    ctx->condition_or	= condition_or;
    ctx->condition_and	= condition_and;
    ctx->condition_not	= condition_not;
    ctx->condition_expr	= condition_expr;
    ctx->condition_exists	= condition_exists;
    ctx->condition_is	= condition_is;
    ctx->condition_comparison	= condition_comparison;
    ctx->condition_group_comparison	= condition_group_comparison;
    ctx->condition_in	= condition_in;
    ctx->condition_is_a_set	= condition_is_a_set;
    ctx->condition_is_any	= condition_is_any;
    ctx->condition_is_empty	= condition_is_empty;
    ctx->condition_is_of_type	= condition_is_of_type;
    ctx->condition_is_present	= condition_is_present;
    ctx->condition_like	= condition_like;
    ctx->condition_memeber	= condition_memeber;
    ctx->condition_between	= condition_between;
    ctx->condition_regexp_like	= condition_regexp_like;
    ctx->condition_submultiset	= condition_submultiset;
    ctx->condition_equals_path	= condition_equals_path;
    ctx->condition_under_path	= condition_under_path;
    ctx->levels	= levels;
    ctx->correlation_integer	= correlation_integer;
    ctx->path_string	= path_string;
    ctx->type_names	= type_names;
    ctx->integer	= integer;
    ctx->column_name	= column_name;
    ctx->nested_table	= nested_table;
    ctx->nested_table_column_name	= nested_table_column_name;
    ctx->sql_expressions	= sql_expressions;
    ctx->grouping_sets_expression_list	= grouping_sets_expression_list;
    ctx->grouping_expression_list	= grouping_expression_list;
    ctx->expression_list	= expression_list;
    ctx->cell_reference	= cell_reference;
    ctx->condition_paren	= condition_paren;
    ctx->model_clause	= model_clause;
    ctx->cell_reference_options	= cell_reference_options;
    ctx->return_rows_clause	= return_rows_clause;
    ctx->reference_model	= reference_model;
    ctx->reference_model_name	= reference_model_name;
    ctx->main_model	= main_model;
    ctx->main_model_name	= main_model_name;
    ctx->model_column_clauses	= model_column_clauses;
    ctx->model_columns	= model_columns;
    ctx->model_column	= model_column;
    ctx->model_rules_clause	= model_rules_clause;
    ctx->model_rules_exprs	= model_rules_exprs;
    ctx->model_rules_expr	= model_rules_expr;
    ctx->cell_assignment	= cell_assignment;
    ctx->cell_assignment_exprs	= cell_assignment_exprs;
    ctx->cell_assignment_expr	= cell_assignment_expr;
    ctx->measure_column	= measure_column;
    ctx->single_column_for_loop	= single_column_for_loop;
    ctx->pattern	= pattern;
    ctx->literal	= literal;
    ctx->literals	= literals;
    ctx->multi_column_for_loop	= multi_column_for_loop;
    ctx->bracket_literals	= bracket_literals;
    ctx->bracket_literals_list	= bracket_literals_list;
    ctx->union_clause	= union_clause;
    ctx->order_by_clause	= order_by_clause;
    ctx->order_by_clause_part_first	= order_by_clause_part_first;
    ctx->order_by_clause_part_next	= order_by_clause_part_next;
    ctx->analytic_function_name	= analytic_function_name;
    ctx->analytic_function_call	= analytic_function_call;
    ctx->analytic_function	= analytic_function;
    ctx->count_function	= count_function;
    ctx->analytic_clause	= analytic_clause;
    ctx->windowing_clause_part	= windowing_clause_part;
    ctx->windowing_clause	= windowing_clause;
    ctx->aggregate_function_name	= aggregate_function_name;
    ctx->aggregate_function	= aggregate_function;
    ctx->percent_rank_aggregate	= percent_rank_aggregate;
    ctx->dense_rank_aggregate	= dense_rank_aggregate;
    ctx->percent_rank_analytic	= percent_rank_analytic;
    ctx->percent_cont_disc_analytic	= percent_cont_disc_analytic;
    ctx->dense_rank_analytic	= dense_rank_analytic;
    ctx->first_last	= first_last;
    ctx->listagg	= listagg;
    ctx->for_update_clause	= for_update_clause;
    ctx->for_update_clause_part_first	= for_update_clause_part_first;
    ctx->for_update_clause_part_next	= for_update_clause_part_next;
    ctx->pivot_clause	= pivot_clause;
    ctx->pivot_for_clause	= pivot_for_clause;
    ctx->pivot_in_clause	= pivot_in_clause;
    ctx->unpivot_clause	= unpivot_clause;
    ctx->unpivot_in_clause	= unpivot_in_clause;
    ctx->constant	= constant;
    ctx->r_access	= r_access;
    ctx->r_add	= r_add;
    ctx->r_all	= r_all;
    ctx->r_alter	= r_alter;
    ctx->r_and	= r_and;
    ctx->r_any	= r_any;
    ctx->r_arraylen	= r_arraylen;
    ctx->r_as	= r_as;
    ctx->r_asc	= r_asc;
    ctx->r_audit	= r_audit;
    ctx->r_between	= r_between;
    ctx->r_by	= r_by;
    ctx->r_case	= r_case;
    ctx->r_char	= r_char;
    ctx->r_check	= r_check;
    ctx->r_cluster	= r_cluster;
    ctx->r_column	= r_column;
    ctx->r_comment	= r_comment;
    ctx->r_compress	= r_compress;
    ctx->r_connect	= r_connect;
    ctx->r_create	= r_create;
    ctx->r_current	= r_current;
    ctx->r_date	= r_date;
    ctx->r_decimal	= r_decimal;
    ctx->r_default	= r_default;
    ctx->r_delete	= r_delete;
    ctx->r_desc	= r_desc;
    ctx->r_distinct	= r_distinct;
    ctx->r_drop	= r_drop;
    ctx->r_else	= r_else;
    ctx->r_exclusive	= r_exclusive;
    ctx->r_exists	= r_exists;
    ctx->r_false	= r_false;
    ctx->r_file	= r_file;
    ctx->r_float	= r_float;
    ctx->r_for	= r_for;
    ctx->r_from	= r_from;
    ctx->r_grant	= r_grant;
    ctx->r_group	= r_group;
    ctx->r_having	= r_having;
    ctx->r_identified	= r_identified;
    ctx->r_immediate	= r_immediate;
    ctx->r_in	= r_in;
    ctx->r_increment	= r_increment;
    ctx->r_index	= r_index;
    ctx->r_initial	= r_initial;
    ctx->r_insert	= r_insert;
    ctx->r_integer	= r_integer;
    ctx->r_intersect	= r_intersect;
    ctx->r_into	= r_into;
    ctx->r_is	= r_is;
    ctx->r_level	= r_level;
    ctx->r_like	= r_like;
    ctx->r_lock	= r_lock;
    ctx->r_long	= r_long;
    ctx->r_maxextents	= r_maxextents;
    ctx->r_minus	= r_minus;
    ctx->r_mode	= r_mode;
    ctx->r_modify	= r_modify;
    ctx->r_noaudit	= r_noaudit;
    ctx->r_nocompress	= r_nocompress;
    ctx->r_not	= r_not;
    ctx->r_notfound	= r_notfound;
    ctx->r_nowait	= r_nowait;
    ctx->r_null	= r_null;
    ctx->r_number	= r_number;
    ctx->r_of	= r_of;
    ctx->r_offline	= r_offline;
    ctx->r_on	= r_on;
    ctx->r_online	= r_online;
    ctx->r_option	= r_option;
    ctx->r_or	= r_or;
    ctx->r_order	= r_order;
    ctx->r_pctfree	= r_pctfree;
    ctx->r_prior	= r_prior;
    ctx->r_privileges	= r_privileges;
    ctx->r_public	= r_public;
    ctx->r_raw	= r_raw;
    ctx->r_rename	= r_rename;
    ctx->r_resource	= r_resource;
    ctx->r_revoke	= r_revoke;
    ctx->r_row	= r_row;
    ctx->r_rowid	= r_rowid;
    ctx->r_rowlabel	= r_rowlabel;
    ctx->r_rownum	= r_rownum;
    ctx->r_rows	= r_rows;
    ctx->r_select	= r_select;
    ctx->r_session	= r_session;
    ctx->r_set	= r_set;
    ctx->r_share	= r_share;
    ctx->r_size	= r_size;
    ctx->r_smallint	= r_smallint;
    ctx->r_sqlbuf	= r_sqlbuf;
    ctx->r_start	= r_start;
    ctx->r_successful	= r_successful;
    ctx->r_synonym	= r_synonym;
    ctx->r_sysdate	= r_sysdate;
    ctx->r_table	= r_table;
    ctx->r_then	= r_then;
    ctx->r_to	= r_to;
    ctx->r_trigger	= r_trigger;
    ctx->r_true	= r_true;
    ctx->r_uid	= r_uid;
    ctx->r_union	= r_union;
    ctx->r_unique	= r_unique;
    ctx->r_update	= r_update;
    ctx->r_user	= r_user;
    ctx->r_validate	= r_validate;
    ctx->r_values	= r_values;
    ctx->r_varchar	= r_varchar;
    ctx->r_varchar2	= r_varchar2;
    ctx->r_view	= r_view;
    ctx->r_whenever	= r_whenever;
    ctx->r_where	= r_where;
    ctx->r_with	= r_with;
    ctx->k_a	= k_a;
    ctx->k_at	= k_at;
    ctx->k_automatic	= k_automatic;
    ctx->k_bfile	= k_bfile;
    ctx->k_binary_double	= k_binary_double;
    ctx->k_binary_float	= k_binary_float;
    ctx->k_binary_integer	= k_binary_integer;
    ctx->k_blob	= k_blob;
    ctx->k_block	= k_block;
    ctx->k_boolean	= k_boolean;
    ctx->k_both	= k_both;
    ctx->k_breadth	= k_breadth;
    ctx->k_byte	= k_byte;
    ctx->k_cast	= k_cast;
    ctx->k_character	= k_character;
    ctx->k_clob	= k_clob;
    ctx->k_cluster_set	= k_cluster_set;
    ctx->k_connect_by_root	= k_connect_by_root;
    ctx->k_constraint	= k_constraint;
    ctx->k_count	= k_count;
    ctx->k_cross	= k_cross;
    ctx->k_cube	= k_cube;
    ctx->k_cursor	= k_cursor;
    ctx->k_cycle	= k_cycle;
    ctx->k_day	= k_day;
    ctx->k_dbtimezone	= k_dbtimezone;
    ctx->k_dec	= k_dec;
    ctx->k_decrement	= k_decrement;
    ctx->k_dense_rank	= k_dense_rank;
    ctx->k_depth	= k_depth;
    ctx->k_dimension	= k_dimension;
    ctx->k_double	= k_double;
    ctx->k_empty	= k_empty;
    ctx->k_end	= k_end;
    ctx->k_equals_path	= k_equals_path;
    ctx->k_errors	= k_errors;
    ctx->k_escape	= k_escape;
    ctx->k_exclude	= k_exclude;
    ctx->k_extract	= k_extract;
    ctx->k_first	= k_first;
    ctx->k_following	= k_following;
    ctx->k_full	= k_full;
    ctx->k_grouping	= k_grouping;
    ctx->k_hour	= k_hour;
    ctx->k_ignore	= k_ignore;
    ctx->k_include	= k_include;
    ctx->k_infinite	= k_infinite;
    ctx->k_inner	= k_inner;
    ctx->k_int	= k_int;
    ctx->k_interval	= k_interval;
    ctx->k_iterate	= k_iterate;
    ctx->k_join	= k_join;
    ctx->k_keep	= k_keep;
    ctx->k_last	= k_last;
    ctx->k_leading	= k_leading;
    ctx->k_left	= k_left;
    ctx->k_like2	= k_like2;
    ctx->k_like4	= k_like4;
    ctx->k_likec	= k_likec;
    ctx->k_limit	= k_limit;
    ctx->k_listagg	= k_listagg;
    ctx->k_lnnvl	= k_lnnvl;
    ctx->k_local	= k_local;
    ctx->k_locked	= k_locked;
    ctx->k_log	= k_log;
    ctx->k_main	= k_main;
    ctx->k_matched	= k_matched;
    ctx->k_maxvalue	= k_maxvalue;
    ctx->k_measures	= k_measures;
    ctx->k_member	= k_member;
    ctx->k_merge	= k_merge;
    ctx->k_minute	= k_minute;
    ctx->k_mivalue	= k_mivalue;
    ctx->k_mlslabel	= k_mlslabel;
    ctx->k_model	= k_model;
    ctx->k_month	= k_month;
    ctx->k_multiset	= k_multiset;
    ctx->k_nan	= k_nan;
    ctx->k_national	= k_national;
    ctx->k_natural	= k_natural;
    ctx->k_nav	= k_nav;
    ctx->k_nchar	= k_nchar;
    ctx->k_nclob	= k_nclob;
    ctx->k_nocycle	= k_nocycle;
    ctx->k_nulls	= k_nulls;
    ctx->k_numeric	= k_numeric;
    ctx->k_nvarchar	= k_nvarchar;
    ctx->k_nvarchar2	= k_nvarchar2;
    ctx->k_only	= k_only;
    ctx->k_outer	= k_outer;
    ctx->k_over	= k_over;
    ctx->k_partition	= k_partition;
    ctx->k_percent_rank	= k_percent_rank;
    ctx->k_percentile_cont	= k_percentile_cont;
    ctx->k_percentile_disc	= k_percentile_disc;
    ctx->k_pivot	= k_pivot;
    ctx->k_pls_integer	= k_pls_integer;
    ctx->k_positive	= k_positive;
    ctx->k_preceding	= k_preceding;
    ctx->k_precision	= k_precision;
    ctx->k_present	= k_present;
    ctx->k_range	= k_range;
    ctx->k_read	= k_read;
    ctx->k_real	= k_real;
    ctx->k_reference	= k_reference;
    ctx->k_regexp_like	= k_regexp_like;
    ctx->k_reject	= k_reject;
    ctx->k_respect	= k_respect;
    ctx->k_return	= k_return;
    ctx->k_returning	= k_returning;
    ctx->k_right	= k_right;
    ctx->k_rollup	= k_rollup;
    ctx->k_rules	= k_rules;
    ctx->k_sample	= k_sample;
    ctx->k_scn	= k_scn;
    ctx->k_search	= k_search;
    ctx->k_second	= k_second;
    ctx->k_seed	= k_seed;
    ctx->k_sequential	= k_sequential;
    ctx->k_sessiontimezone	= k_sessiontimezone;
    ctx->k_sets	= k_sets;
    ctx->k_siblings	= k_siblings;
    ctx->k_single	= k_single;
    ctx->k_skip	= k_skip;
    ctx->k_some	= k_some;
    ctx->k_sql	= k_sql;
    ctx->k_submultiset	= k_submultiset;
    ctx->k_subpartition	= k_subpartition;
    ctx->k_the	= k_the;
    ctx->k_time	= k_time;
    ctx->k_timestamp	= k_timestamp;
    ctx->k_timezone_hour	= k_timezone_hour;
    ctx->k_timezone_minute	= k_timezone_minute;
    ctx->k_timezone_region	= k_timezone_region;
    ctx->k_timezone_abbr	= k_timezone_abbr;
    ctx->k_to	= k_to;
    ctx->k_trailing	= k_trailing;
    ctx->k_trim	= k_trim;
    ctx->k_type	= k_type;
    ctx->k_unbounded	= k_unbounded;
    ctx->k_under_path	= k_under_path;
    ctx->k_unlimited	= k_unlimited;
    ctx->k_unpivot	= k_unpivot;
    ctx->k_until	= k_until;
    ctx->k_updated	= k_updated;
    ctx->k_upsert	= k_upsert;
    ctx->k_urowid	= k_urowid;
    ctx->k_using	= k_using;
    ctx->k_value	= k_value;
    ctx->k_varying	= k_varying;
    ctx->k_versions	= k_versions;
    ctx->k_wait	= k_wait;
    ctx->k_when	= k_when;
    ctx->k_within	= k_within;
    ctx->k_xml	= k_xml;
    ctx->k_year	= k_year;
    ctx->k_zone	= k_zone;
    ctx->keyword	= keyword;
    ctx->quoted_string	= quoted_string;
    ctx->doublevertbar	= doublevertbar;
    ctx->not_equal	= not_equal;
    ctx->leq	= leq;
    ctx->geq	= geq;
    ctx->synpred8_OracleSQL	= synpred8_OracleSQL;
    ctx->synpred15_OracleSQL	= synpred15_OracleSQL;
    ctx->synpred17_OracleSQL	= synpred17_OracleSQL;
    ctx->synpred33_OracleSQL	= synpred33_OracleSQL;
    ctx->synpred35_OracleSQL	= synpred35_OracleSQL;
    ctx->synpred54_OracleSQL	= synpred54_OracleSQL;
    ctx->synpred58_OracleSQL	= synpred58_OracleSQL;
    ctx->synpred59_OracleSQL	= synpred59_OracleSQL;
    ctx->synpred60_OracleSQL	= synpred60_OracleSQL;
    ctx->synpred62_OracleSQL	= synpred62_OracleSQL;
    ctx->synpred63_OracleSQL	= synpred63_OracleSQL;
    ctx->synpred73_OracleSQL	= synpred73_OracleSQL;
    ctx->synpred79_OracleSQL	= synpred79_OracleSQL;
    ctx->synpred87_OracleSQL	= synpred87_OracleSQL;
    ctx->synpred88_OracleSQL	= synpred88_OracleSQL;
    ctx->synpred89_OracleSQL	= synpred89_OracleSQL;
    ctx->synpred92_OracleSQL	= synpred92_OracleSQL;
    ctx->synpred93_OracleSQL	= synpred93_OracleSQL;
    ctx->synpred94_OracleSQL	= synpred94_OracleSQL;
    ctx->synpred95_OracleSQL	= synpred95_OracleSQL;
    ctx->synpred96_OracleSQL	= synpred96_OracleSQL;
    ctx->synpred103_OracleSQL	= synpred103_OracleSQL;
    ctx->synpred121_OracleSQL	= synpred121_OracleSQL;
    ctx->synpred123_OracleSQL	= synpred123_OracleSQL;
    ctx->synpred128_OracleSQL	= synpred128_OracleSQL;
    ctx->synpred129_OracleSQL	= synpred129_OracleSQL;
    ctx->synpred130_OracleSQL	= synpred130_OracleSQL;
    ctx->synpred131_OracleSQL	= synpred131_OracleSQL;
    ctx->synpred132_OracleSQL	= synpred132_OracleSQL;
    ctx->synpred133_OracleSQL	= synpred133_OracleSQL;
    ctx->synpred134_OracleSQL	= synpred134_OracleSQL;
    ctx->synpred135_OracleSQL	= synpred135_OracleSQL;
    ctx->synpred136_OracleSQL	= synpred136_OracleSQL;
    ctx->synpred137_OracleSQL	= synpred137_OracleSQL;
    ctx->synpred138_OracleSQL	= synpred138_OracleSQL;
    ctx->synpred139_OracleSQL	= synpred139_OracleSQL;
    ctx->synpred140_OracleSQL	= synpred140_OracleSQL;
    ctx->synpred141_OracleSQL	= synpred141_OracleSQL;
    ctx->synpred142_OracleSQL	= synpred142_OracleSQL;
    ctx->synpred144_OracleSQL	= synpred144_OracleSQL;
    ctx->synpred145_OracleSQL	= synpred145_OracleSQL;
    ctx->synpred150_OracleSQL	= synpred150_OracleSQL;
    ctx->synpred151_OracleSQL	= synpred151_OracleSQL;
    ctx->synpred152_OracleSQL	= synpred152_OracleSQL;
    ctx->synpred155_OracleSQL	= synpred155_OracleSQL;
    ctx->synpred157_OracleSQL	= synpred157_OracleSQL;
    ctx->synpred162_OracleSQL	= synpred162_OracleSQL;
    ctx->synpred163_OracleSQL	= synpred163_OracleSQL;
    ctx->synpred170_OracleSQL	= synpred170_OracleSQL;
    ctx->synpred171_OracleSQL	= synpred171_OracleSQL;
    ctx->synpred182_OracleSQL	= synpred182_OracleSQL;
    ctx->synpred183_OracleSQL	= synpred183_OracleSQL;
    ctx->synpred186_OracleSQL	= synpred186_OracleSQL;
    ctx->synpred187_OracleSQL	= synpred187_OracleSQL;
    ctx->synpred188_OracleSQL	= synpred188_OracleSQL;
    ctx->synpred189_OracleSQL	= synpred189_OracleSQL;
    ctx->synpred190_OracleSQL	= synpred190_OracleSQL;
    ctx->synpred191_OracleSQL	= synpred191_OracleSQL;
    ctx->synpred192_OracleSQL	= synpred192_OracleSQL;
    ctx->synpred195_OracleSQL	= synpred195_OracleSQL;
    ctx->synpred196_OracleSQL	= synpred196_OracleSQL;
    ctx->synpred197_OracleSQL	= synpred197_OracleSQL;
    ctx->synpred198_OracleSQL	= synpred198_OracleSQL;
    ctx->synpred199_OracleSQL	= synpred199_OracleSQL;
    ctx->synpred202_OracleSQL	= synpred202_OracleSQL;
    ctx->synpred203_OracleSQL	= synpred203_OracleSQL;
    ctx->synpred204_OracleSQL	= synpred204_OracleSQL;
    ctx->synpred206_OracleSQL	= synpred206_OracleSQL;
    ctx->synpred208_OracleSQL	= synpred208_OracleSQL;
    ctx->synpred209_OracleSQL	= synpred209_OracleSQL;
    ctx->synpred210_OracleSQL	= synpred210_OracleSQL;
    ctx->synpred212_OracleSQL	= synpred212_OracleSQL;
    ctx->synpred213_OracleSQL	= synpred213_OracleSQL;
    ctx->synpred214_OracleSQL	= synpred214_OracleSQL;
    ctx->synpred215_OracleSQL	= synpred215_OracleSQL;
    ctx->synpred216_OracleSQL	= synpred216_OracleSQL;
    ctx->synpred219_OracleSQL	= synpred219_OracleSQL;
    ctx->synpred220_OracleSQL	= synpred220_OracleSQL;
    ctx->synpred221_OracleSQL	= synpred221_OracleSQL;
    ctx->synpred222_OracleSQL	= synpred222_OracleSQL;
    ctx->synpred223_OracleSQL	= synpred223_OracleSQL;
    ctx->synpred224_OracleSQL	= synpred224_OracleSQL;
    ctx->synpred225_OracleSQL	= synpred225_OracleSQL;
    ctx->synpred226_OracleSQL	= synpred226_OracleSQL;
    ctx->synpred227_OracleSQL	= synpred227_OracleSQL;
    ctx->synpred230_OracleSQL	= synpred230_OracleSQL;
    ctx->synpred231_OracleSQL	= synpred231_OracleSQL;
    ctx->synpred232_OracleSQL	= synpred232_OracleSQL;
    ctx->synpred233_OracleSQL	= synpred233_OracleSQL;
    ctx->synpred240_OracleSQL	= synpred240_OracleSQL;
    ctx->synpred247_OracleSQL	= synpred247_OracleSQL;
    ctx->synpred248_OracleSQL	= synpred248_OracleSQL;
    ctx->synpred249_OracleSQL	= synpred249_OracleSQL;
    ctx->synpred250_OracleSQL	= synpred250_OracleSQL;
    ctx->synpred251_OracleSQL	= synpred251_OracleSQL;
    ctx->synpred252_OracleSQL	= synpred252_OracleSQL;
    ctx->synpred254_OracleSQL	= synpred254_OracleSQL;
    ctx->synpred258_OracleSQL	= synpred258_OracleSQL;
    ctx->synpred264_OracleSQL	= synpred264_OracleSQL;
    ctx->synpred268_OracleSQL	= synpred268_OracleSQL;
    ctx->synpred270_OracleSQL	= synpred270_OracleSQL;
    ctx->synpred275_OracleSQL	= synpred275_OracleSQL;
    ctx->synpred277_OracleSQL	= synpred277_OracleSQL;
    ctx->synpred281_OracleSQL	= synpred281_OracleSQL;
    ctx->synpred282_OracleSQL	= synpred282_OracleSQL;
    ctx->synpred304_OracleSQL	= synpred304_OracleSQL;
    ctx->synpred307_OracleSQL	= synpred307_OracleSQL;
    ctx->synpred309_OracleSQL	= synpred309_OracleSQL;
    ctx->synpred311_OracleSQL	= synpred311_OracleSQL;
    ctx->synpred315_OracleSQL	= synpred315_OracleSQL;
    ctx->synpred316_OracleSQL	= synpred316_OracleSQL;
    ctx->synpred317_OracleSQL	= synpred317_OracleSQL;
    ctx->synpred318_OracleSQL	= synpred318_OracleSQL;
    ctx->synpred321_OracleSQL	= synpred321_OracleSQL;
    ctx->synpred322_OracleSQL	= synpred322_OracleSQL;
    ctx->synpred323_OracleSQL	= synpred323_OracleSQL;
    ctx->synpred331_OracleSQL	= synpred331_OracleSQL;
    ctx->synpred344_OracleSQL	= synpred344_OracleSQL;
    ctx->synpred345_OracleSQL	= synpred345_OracleSQL;
    ctx->synpred346_OracleSQL	= synpred346_OracleSQL;
    ctx->synpred347_OracleSQL	= synpred347_OracleSQL;
    ctx->synpred348_OracleSQL	= synpred348_OracleSQL;
    ctx->synpred349_OracleSQL	= synpred349_OracleSQL;
    ctx->synpred350_OracleSQL	= synpred350_OracleSQL;
    ctx->synpred352_OracleSQL	= synpred352_OracleSQL;
    ctx->synpred353_OracleSQL	= synpred353_OracleSQL;
    ctx->synpred354_OracleSQL	= synpred354_OracleSQL;
    ctx->synpred356_OracleSQL	= synpred356_OracleSQL;
    ctx->synpred357_OracleSQL	= synpred357_OracleSQL;
    ctx->synpred358_OracleSQL	= synpred358_OracleSQL;
    ctx->synpred359_OracleSQL	= synpred359_OracleSQL;
    ctx->synpred363_OracleSQL	= synpred363_OracleSQL;
    ctx->synpred364_OracleSQL	= synpred364_OracleSQL;
    ctx->synpred365_OracleSQL	= synpred365_OracleSQL;
    ctx->synpred367_OracleSQL	= synpred367_OracleSQL;
    ctx->synpred368_OracleSQL	= synpred368_OracleSQL;
    ctx->synpred373_OracleSQL	= synpred373_OracleSQL;
    ctx->synpred380_OracleSQL	= synpred380_OracleSQL;
    ctx->synpred382_OracleSQL	= synpred382_OracleSQL;
    ctx->synpred383_OracleSQL	= synpred383_OracleSQL;
    ctx->synpred384_OracleSQL	= synpred384_OracleSQL;
    ctx->synpred385_OracleSQL	= synpred385_OracleSQL;
    ctx->synpred386_OracleSQL	= synpred386_OracleSQL;
    ctx->synpred388_OracleSQL	= synpred388_OracleSQL;
    ctx->synpred389_OracleSQL	= synpred389_OracleSQL;
    ctx->synpred390_OracleSQL	= synpred390_OracleSQL;
    ctx->synpred395_OracleSQL	= synpred395_OracleSQL;
    ctx->synpred396_OracleSQL	= synpred396_OracleSQL;
    ctx->synpred410_OracleSQL	= synpred410_OracleSQL;
    ctx->synpred411_OracleSQL	= synpred411_OracleSQL;
    ctx->synpred413_OracleSQL	= synpred413_OracleSQL;
    ctx->synpred414_OracleSQL	= synpred414_OracleSQL;
    ctx->synpred415_OracleSQL	= synpred415_OracleSQL;
    ctx->synpred416_OracleSQL	= synpred416_OracleSQL;
    ctx->synpred417_OracleSQL	= synpred417_OracleSQL;
    ctx->synpred418_OracleSQL	= synpred418_OracleSQL;
    ctx->synpred419_OracleSQL	= synpred419_OracleSQL;
    ctx->synpred420_OracleSQL	= synpred420_OracleSQL;
    ctx->synpred423_OracleSQL	= synpred423_OracleSQL;
    ctx->synpred424_OracleSQL	= synpred424_OracleSQL;
    ctx->synpred425_OracleSQL	= synpred425_OracleSQL;
    ctx->synpred427_OracleSQL	= synpred427_OracleSQL;
    ctx->synpred428_OracleSQL	= synpred428_OracleSQL;
    ctx->synpred429_OracleSQL	= synpred429_OracleSQL;
    ctx->synpred430_OracleSQL	= synpred430_OracleSQL;
    ctx->synpred431_OracleSQL	= synpred431_OracleSQL;
    ctx->synpred432_OracleSQL	= synpred432_OracleSQL;
    ctx->synpred433_OracleSQL	= synpred433_OracleSQL;
    ctx->synpred434_OracleSQL	= synpred434_OracleSQL;
    ctx->synpred435_OracleSQL	= synpred435_OracleSQL;
    ctx->synpred436_OracleSQL	= synpred436_OracleSQL;
    ctx->synpred437_OracleSQL	= synpred437_OracleSQL;
    ctx->synpred438_OracleSQL	= synpred438_OracleSQL;
    ctx->synpred439_OracleSQL	= synpred439_OracleSQL;
    ctx->synpred440_OracleSQL	= synpred440_OracleSQL;
    ctx->synpred441_OracleSQL	= synpred441_OracleSQL;
    ctx->synpred442_OracleSQL	= synpred442_OracleSQL;
    ctx->synpred443_OracleSQL	= synpred443_OracleSQL;
    ctx->synpred444_OracleSQL	= synpred444_OracleSQL;
    ctx->synpred449_OracleSQL	= synpred449_OracleSQL;
    ctx->synpred455_OracleSQL	= synpred455_OracleSQL;
    ctx->synpred456_OracleSQL	= synpred456_OracleSQL;
    ctx->synpred457_OracleSQL	= synpred457_OracleSQL;
    ctx->synpred464_OracleSQL	= synpred464_OracleSQL;
    ctx->synpred465_OracleSQL	= synpred465_OracleSQL;
    ctx->synpred466_OracleSQL	= synpred466_OracleSQL;
    ctx->synpred470_OracleSQL	= synpred470_OracleSQL;
    ctx->synpred471_OracleSQL	= synpred471_OracleSQL;
    ctx->synpred479_OracleSQL	= synpred479_OracleSQL;
    ctx->synpred481_OracleSQL	= synpred481_OracleSQL;
    ctx->synpred482_OracleSQL	= synpred482_OracleSQL;
    ctx->synpred484_OracleSQL	= synpred484_OracleSQL;
    ctx->synpred485_OracleSQL	= synpred485_OracleSQL;
    ctx->synpred496_OracleSQL	= synpred496_OracleSQL;
    ctx->synpred499_OracleSQL	= synpred499_OracleSQL;
    ctx->synpred506_OracleSQL	= synpred506_OracleSQL;
    ctx->synpred508_OracleSQL	= synpred508_OracleSQL;
    ctx->synpred511_OracleSQL	= synpred511_OracleSQL;
    ctx->synpred512_OracleSQL	= synpred512_OracleSQL;
    ctx->synpred514_OracleSQL	= synpred514_OracleSQL;
    ctx->synpred515_OracleSQL	= synpred515_OracleSQL;
    ctx->synpred516_OracleSQL	= synpred516_OracleSQL;
    ctx->synpred517_OracleSQL	= synpred517_OracleSQL;
    ctx->synpred518_OracleSQL	= synpred518_OracleSQL;
    ctx->synpred520_OracleSQL	= synpred520_OracleSQL;
    ctx->synpred521_OracleSQL	= synpred521_OracleSQL;
    ctx->synpred522_OracleSQL	= synpred522_OracleSQL;
    ctx->synpred523_OracleSQL	= synpred523_OracleSQL;
    ctx->synpred524_OracleSQL	= synpred524_OracleSQL;
    ctx->synpred539_OracleSQL	= synpred539_OracleSQL;
    ctx->synpred551_OracleSQL	= synpred551_OracleSQL;
    ctx->synpred552_OracleSQL	= synpred552_OracleSQL;
    ctx->synpred566_OracleSQL	= synpred566_OracleSQL;
    ctx->synpred568_OracleSQL	= synpred568_OracleSQL;
    ctx->synpred569_OracleSQL	= synpred569_OracleSQL;
    ctx->synpred570_OracleSQL	= synpred570_OracleSQL;
    ctx->synpred571_OracleSQL	= synpred571_OracleSQL;
    ctx->synpred572_OracleSQL	= synpred572_OracleSQL;
    ctx->synpred573_OracleSQL	= synpred573_OracleSQL;
    ctx->synpred574_OracleSQL	= synpred574_OracleSQL;
    ctx->synpred575_OracleSQL	= synpred575_OracleSQL;
    ctx->synpred576_OracleSQL	= synpred576_OracleSQL;
    ctx->synpred584_OracleSQL	= synpred584_OracleSQL;
    ctx->synpred585_OracleSQL	= synpred585_OracleSQL;
    ctx->synpred586_OracleSQL	= synpred586_OracleSQL;
    ctx->synpred587_OracleSQL	= synpred587_OracleSQL;
    ctx->synpred588_OracleSQL	= synpred588_OracleSQL;
    ctx->synpred605_OracleSQL	= synpred605_OracleSQL;
    ctx->synpred606_OracleSQL	= synpred606_OracleSQL;
    ctx->synpred607_OracleSQL	= synpred607_OracleSQL;
    ctx->synpred608_OracleSQL	= synpred608_OracleSQL;
    ctx->synpred609_OracleSQL	= synpred609_OracleSQL;
    ctx->synpred615_OracleSQL	= synpred615_OracleSQL;
    ctx->synpred616_OracleSQL	= synpred616_OracleSQL;
    ctx->synpred618_OracleSQL	= synpred618_OracleSQL;
    ctx->synpred619_OracleSQL	= synpred619_OracleSQL;
    ctx->synpred620_OracleSQL	= synpred620_OracleSQL;
    ctx->synpred622_OracleSQL	= synpred622_OracleSQL;
    ctx->synpred623_OracleSQL	= synpred623_OracleSQL;
    ctx->synpred624_OracleSQL	= synpred624_OracleSQL;
    ctx->synpred625_OracleSQL	= synpred625_OracleSQL;
    ctx->synpred627_OracleSQL	= synpred627_OracleSQL;
    ctx->synpred628_OracleSQL	= synpred628_OracleSQL;
    ctx->synpred629_OracleSQL	= synpred629_OracleSQL;
    ctx->synpred631_OracleSQL	= synpred631_OracleSQL;
    ctx->synpred632_OracleSQL	= synpred632_OracleSQL;
    ctx->synpred633_OracleSQL	= synpred633_OracleSQL;
    ctx->synpred643_OracleSQL	= synpred643_OracleSQL;
    ctx->synpred647_OracleSQL	= synpred647_OracleSQL;
    ctx->synpred648_OracleSQL	= synpred648_OracleSQL;
    ctx->synpred650_OracleSQL	= synpred650_OracleSQL;
    ctx->synpred657_OracleSQL	= synpred657_OracleSQL;
    ctx->synpred662_OracleSQL	= synpred662_OracleSQL;
    ctx->free			= OracleSQLParserFree;
    ctx->reset			= OracleSQLParserReset;
    ctx->getGrammarFileName	= getGrammarFileName;
    
    /* Install the scope pushing methods.
     */
    ADAPTOR	= ANTLR3_TREE_ADAPTORNew(instream->tstream->tokenSource->strFactory);
    ctx->vectors	= antlr3VectorFactoryNew(0);
    

    //            RECOGNIZER->displayRecognitionError = myDisplayRecognitionParserError;

    /* Create a LIST for recording rule memos.
     */
     RULEMEMO    = antlr3IntTrieNew(15);	/* 16 bit depth is enough for 32768 rules! */
	
    /* Install the token table
     */
    PSRSTATE->tokenNames   = OracleSQLParserTokenNames;
    
    
    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
OracleSQLParserReset (pOracleSQLParser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 OracleSQLParserFree(pOracleSQLParser ctx)
 {
    /* Free any scope memory
     */
    
    ctx->vectors->close(ctx->vectors);
    /* We created the adaptor so we must free it
     */
    ADAPTOR->free(ADAPTOR);
	if	(RULEMEMO != NULL)
	{
		RULEMEMO->free(RULEMEMO);
		RULEMEMO = NULL;
	}	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);
    
    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }
 
/** Return token names used by this parser
 *
 * The returned pointer is used as an index into the token names table (using the token 
 * number as the index).
 * 
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames() 
{
        return OracleSQLParserTokenNames; 
}

    
/* Declare the bitsets
 */

/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_start_rule708  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_start_rule708_bits[]	= { ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_start_rule708	= { FOLLOW_select_statement_in_start_rule708_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_update_statement_in_start_rule720  */
static	ANTLR3_BITWORD FOLLOW_update_statement_in_start_rule720_bits[]	= { ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_update_statement_in_start_rule720	= { FOLLOW_update_statement_in_start_rule720_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_insert_statement_in_start_rule732  */
static	ANTLR3_BITWORD FOLLOW_insert_statement_in_start_rule732_bits[]	= { ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_insert_statement_in_start_rule732	= { FOLLOW_insert_statement_in_start_rule732_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_merge_statement_in_start_rule744  */
static	ANTLR3_BITWORD FOLLOW_merge_statement_in_start_rule744_bits[]	= { ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_merge_statement_in_start_rule744	= { FOLLOW_merge_statement_in_start_rule744_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_delete_statement_in_start_rule756  */
static	ANTLR3_BITWORD FOLLOW_delete_statement_in_start_rule756_bits[]	= { ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_delete_statement_in_start_rule756	= { FOLLOW_delete_statement_in_start_rule756_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_start_rule800  */
static	ANTLR3_BITWORD FOLLOW_set_in_start_rule800_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_start_rule800	= { FOLLOW_set_in_start_rule800_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_delete_in_delete_statement832  */
static	ANTLR3_BITWORD FOLLOW_r_delete_in_delete_statement832_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_delete_in_delete_statement832	= { FOLLOW_r_delete_in_delete_statement832_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_from_in_delete_statement834  */
static	ANTLR3_BITWORD FOLLOW_r_from_in_delete_statement834_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_from_in_delete_statement834	= { FOLLOW_r_from_in_delete_statement834_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dml_table_expression_clause_in_delete_statement859  */
static	ANTLR3_BITWORD FOLLOW_dml_table_expression_clause_in_delete_statement859_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962800000050), ANTLR3_UINT64_LIT(0x000000000949B4B4) };
static  ANTLR3_BITSET_LIST FOLLOW_dml_table_expression_clause_in_delete_statement859	= { FOLLOW_dml_table_expression_clause_in_delete_statement859_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_only_in_delete_statement876  */
static	ANTLR3_BITWORD FOLLOW_k_only_in_delete_statement876_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_only_in_delete_statement876	= { FOLLOW_k_only_in_delete_statement876_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_delete_statement878  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_delete_statement878_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_delete_statement878	= { FOLLOW_LPAREN_in_delete_statement878_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dml_table_expression_clause_in_delete_statement880  */
static	ANTLR3_BITWORD FOLLOW_dml_table_expression_clause_in_delete_statement880_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_dml_table_expression_clause_in_delete_statement880	= { FOLLOW_dml_table_expression_clause_in_delete_statement880_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_delete_statement882  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_delete_statement882_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962800000050), ANTLR3_UINT64_LIT(0x000000000949B4B4) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_delete_statement882	= { FOLLOW_RPAREN_in_delete_statement882_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_delete_statement902  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_delete_statement902_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000), ANTLR3_UINT64_LIT(0x0000000000003000) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_delete_statement902	= { FOLLOW_t_alias_in_delete_statement902_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_where_clause_in_delete_statement906  */
static	ANTLR3_BITWORD FOLLOW_where_clause_in_delete_statement906_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000003000) };
static  ANTLR3_BITSET_LIST FOLLOW_where_clause_in_delete_statement906	= { FOLLOW_where_clause_in_delete_statement906_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_returning_clause_in_delete_statement909  */
static	ANTLR3_BITWORD FOLLOW_returning_clause_in_delete_statement909_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_returning_clause_in_delete_statement909	= { FOLLOW_returning_clause_in_delete_statement909_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_error_logging_clause_in_delete_statement912  */
static	ANTLR3_BITWORD FOLLOW_error_logging_clause_in_delete_statement912_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_error_logging_clause_in_delete_statement912	= { FOLLOW_error_logging_clause_in_delete_statement912_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_merge_in_merge_statement929  */
static	ANTLR3_BITWORD FOLLOW_k_merge_in_merge_statement929_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_merge_in_merge_statement929	= { FOLLOW_k_merge_in_merge_statement929_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_into_in_merge_statement931  */
static	ANTLR3_BITWORD FOLLOW_r_into_in_merge_statement931_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_into_in_merge_statement931	= { FOLLOW_r_into_in_merge_statement931_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_name_long_in_merge_statement933  */
static	ANTLR3_BITWORD FOLLOW_table_name_long_in_merge_statement933_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_table_name_long_in_merge_statement933	= { FOLLOW_table_name_long_in_merge_statement933_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_merge_statement935  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_merge_statement935_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_merge_statement935	= { FOLLOW_t_alias_in_merge_statement935_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_using_in_merge_statement947  */
static	ANTLR3_BITWORD FOLLOW_k_using_in_merge_statement947_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_using_in_merge_statement947	= { FOLLOW_k_using_in_merge_statement947_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_merge_statement971  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_merge_statement971_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_merge_statement971	= { FOLLOW_subquery_in_merge_statement971_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_name_long_in_merge_statement983  */
static	ANTLR3_BITWORD FOLLOW_table_name_long_in_merge_statement983_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_table_name_long_in_merge_statement983	= { FOLLOW_table_name_long_in_merge_statement983_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_merge_statement1003  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_merge_statement1003_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_merge_statement1003	= { FOLLOW_t_alias_in_merge_statement1003_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_on_in_merge_statement1007  */
static	ANTLR3_BITWORD FOLLOW_r_on_in_merge_statement1007_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_on_in_merge_statement1007	= { FOLLOW_r_on_in_merge_statement1007_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_merge_statement1009  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_merge_statement1009_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_merge_statement1009	= { FOLLOW_LPAREN_in_merge_statement1009_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_merge_statement1011  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_merge_statement1011_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_merge_statement1011	= { FOLLOW_sql_condition_in_merge_statement1011_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_merge_statement1013  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_merge_statement1013_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_merge_statement1013	= { FOLLOW_RPAREN_in_merge_statement1013_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_merge_update_clause_in_merge_statement1045  */
static	ANTLR3_BITWORD FOLLOW_merge_update_clause_in_merge_statement1045_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_merge_update_clause_in_merge_statement1045	= { FOLLOW_merge_update_clause_in_merge_statement1045_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_merge_insert_clause_in_merge_statement1047  */
static	ANTLR3_BITWORD FOLLOW_merge_insert_clause_in_merge_statement1047_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_merge_insert_clause_in_merge_statement1047	= { FOLLOW_merge_insert_clause_in_merge_statement1047_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_merge_insert_clause_in_merge_statement1082  */
static	ANTLR3_BITWORD FOLLOW_merge_insert_clause_in_merge_statement1082_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_merge_insert_clause_in_merge_statement1082	= { FOLLOW_merge_insert_clause_in_merge_statement1082_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_merge_update_clause_in_merge_statement1084  */
static	ANTLR3_BITWORD FOLLOW_merge_update_clause_in_merge_statement1084_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_merge_update_clause_in_merge_statement1084	= { FOLLOW_merge_update_clause_in_merge_statement1084_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_error_logging_clause_in_merge_statement1106  */
static	ANTLR3_BITWORD FOLLOW_error_logging_clause_in_merge_statement1106_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_error_logging_clause_in_merge_statement1106	= { FOLLOW_error_logging_clause_in_merge_statement1106_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_when_in_merge_update_clause1121  */
static	ANTLR3_BITWORD FOLLOW_k_when_in_merge_update_clause1121_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_when_in_merge_update_clause1121	= { FOLLOW_k_when_in_merge_update_clause1121_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_matched_in_merge_update_clause1123  */
static	ANTLR3_BITWORD FOLLOW_k_matched_in_merge_update_clause1123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_matched_in_merge_update_clause1123	= { FOLLOW_k_matched_in_merge_update_clause1123_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_then_in_merge_update_clause1125  */
static	ANTLR3_BITWORD FOLLOW_r_then_in_merge_update_clause1125_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_then_in_merge_update_clause1125	= { FOLLOW_r_then_in_merge_update_clause1125_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_update_in_merge_update_clause1127  */
static	ANTLR3_BITWORD FOLLOW_r_update_in_merge_update_clause1127_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_r_update_in_merge_update_clause1127	= { FOLLOW_r_update_in_merge_update_clause1127_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_merge_update_clause1129  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_merge_update_clause1129_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_merge_update_clause1129	= { FOLLOW_r_set_in_merge_update_clause1129_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_merge_update_clause1131  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_merge_update_clause1131_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_merge_update_clause1131	= { FOLLOW_column_spec_in_merge_update_clause1131_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_merge_update_clause1133  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_merge_update_clause1133_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040500), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_merge_update_clause1133	= { FOLLOW_EQ_in_merge_update_clause1133_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_default_in_merge_update_clause1136  */
static	ANTLR3_BITWORD FOLLOW_r_default_in_merge_update_clause1136_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000800), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_default_in_merge_update_clause1136	= { FOLLOW_r_default_in_merge_update_clause1136_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_merge_update_clause1140  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_merge_update_clause1140_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000800), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_merge_update_clause1140	= { FOLLOW_sql_expression_in_merge_update_clause1140_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_merge_update_clause1152  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_merge_update_clause1152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_merge_update_clause1152	= { FOLLOW_COMMA_in_merge_update_clause1152_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_merge_update_clause1154  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_merge_update_clause1154_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_merge_update_clause1154	= { FOLLOW_column_spec_in_merge_update_clause1154_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_merge_update_clause1156  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_merge_update_clause1156_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040500), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_merge_update_clause1156	= { FOLLOW_EQ_in_merge_update_clause1156_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_default_in_merge_update_clause1159  */
static	ANTLR3_BITWORD FOLLOW_r_default_in_merge_update_clause1159_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000800), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_default_in_merge_update_clause1159	= { FOLLOW_r_default_in_merge_update_clause1159_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_merge_update_clause1163  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_merge_update_clause1163_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000800), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_merge_update_clause1163	= { FOLLOW_sql_expression_in_merge_update_clause1163_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_where_clause_in_merge_update_clause1176  */
static	ANTLR3_BITWORD FOLLOW_where_clause_in_merge_update_clause1176_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_where_clause_in_merge_update_clause1176	= { FOLLOW_where_clause_in_merge_update_clause1176_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_delete_in_merge_update_clause1180  */
static	ANTLR3_BITWORD FOLLOW_r_delete_in_merge_update_clause1180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_delete_in_merge_update_clause1180	= { FOLLOW_r_delete_in_merge_update_clause1180_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_where_clause_in_merge_update_clause1182  */
static	ANTLR3_BITWORD FOLLOW_where_clause_in_merge_update_clause1182_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_where_clause_in_merge_update_clause1182	= { FOLLOW_where_clause_in_merge_update_clause1182_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_when_in_merge_insert_clause1198  */
static	ANTLR3_BITWORD FOLLOW_k_when_in_merge_insert_clause1198_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_when_in_merge_insert_clause1198	= { FOLLOW_k_when_in_merge_insert_clause1198_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_merge_insert_clause1200  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_merge_insert_clause1200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_merge_insert_clause1200	= { FOLLOW_r_not_in_merge_insert_clause1200_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_matched_in_merge_insert_clause1202  */
static	ANTLR3_BITWORD FOLLOW_k_matched_in_merge_insert_clause1202_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_matched_in_merge_insert_clause1202	= { FOLLOW_k_matched_in_merge_insert_clause1202_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_then_in_merge_insert_clause1204  */
static	ANTLR3_BITWORD FOLLOW_r_then_in_merge_insert_clause1204_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_then_in_merge_insert_clause1204	= { FOLLOW_r_then_in_merge_insert_clause1204_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_insert_in_merge_insert_clause1206  */
static	ANTLR3_BITWORD FOLLOW_r_insert_in_merge_insert_clause1206_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000040000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_insert_in_merge_insert_clause1206	= { FOLLOW_r_insert_in_merge_insert_clause1206_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_merge_insert_clause1209  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_merge_insert_clause1209_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_merge_insert_clause1209	= { FOLLOW_LPAREN_in_merge_insert_clause1209_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_specs_in_merge_insert_clause1211  */
static	ANTLR3_BITWORD FOLLOW_column_specs_in_merge_insert_clause1211_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_specs_in_merge_insert_clause1211	= { FOLLOW_column_specs_in_merge_insert_clause1211_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_merge_insert_clause1213  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_merge_insert_clause1213_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000040000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_merge_insert_clause1213	= { FOLLOW_RPAREN_in_merge_insert_clause1213_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_values_in_merge_insert_clause1225  */
static	ANTLR3_BITWORD FOLLOW_r_values_in_merge_insert_clause1225_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_values_in_merge_insert_clause1225	= { FOLLOW_r_values_in_merge_insert_clause1225_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_merge_insert_clause1227  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_merge_insert_clause1227_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040500), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_merge_insert_clause1227	= { FOLLOW_LPAREN_in_merge_insert_clause1227_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_default_in_merge_insert_clause1230  */
static	ANTLR3_BITWORD FOLLOW_r_default_in_merge_insert_clause1230_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_r_default_in_merge_insert_clause1230	= { FOLLOW_r_default_in_merge_insert_clause1230_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_merge_insert_clause1234  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_merge_insert_clause1234_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_merge_insert_clause1234	= { FOLLOW_sql_expression_in_merge_insert_clause1234_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_merge_insert_clause1238  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_merge_insert_clause1238_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040500), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_merge_insert_clause1238	= { FOLLOW_COMMA_in_merge_insert_clause1238_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_default_in_merge_insert_clause1241  */
static	ANTLR3_BITWORD FOLLOW_r_default_in_merge_insert_clause1241_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_r_default_in_merge_insert_clause1241	= { FOLLOW_r_default_in_merge_insert_clause1241_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_merge_insert_clause1245  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_merge_insert_clause1245_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_merge_insert_clause1245	= { FOLLOW_sql_expression_in_merge_insert_clause1245_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_merge_insert_clause1250  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_merge_insert_clause1250_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_merge_insert_clause1250	= { FOLLOW_RPAREN_in_merge_insert_clause1250_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_where_clause_in_merge_insert_clause1260  */
static	ANTLR3_BITWORD FOLLOW_where_clause_in_merge_insert_clause1260_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_where_clause_in_merge_insert_clause1260	= { FOLLOW_where_clause_in_merge_insert_clause1260_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_insert_in_insert_statement1278  */
static	ANTLR3_BITWORD FOLLOW_r_insert_in_insert_statement1278_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0010000000000000), ANTLR3_UINT64_LIT(0x0000000800000000), ANTLR3_UINT64_LIT(0x0002000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_insert_in_insert_statement1278	= { FOLLOW_r_insert_in_insert_statement1278_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_single_table_insert_in_insert_statement1281  */
static	ANTLR3_BITWORD FOLLOW_single_table_insert_in_insert_statement1281_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_single_table_insert_in_insert_statement1281	= { FOLLOW_single_table_insert_in_insert_statement1281_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_multi_table_insert_in_insert_statement1285  */
static	ANTLR3_BITWORD FOLLOW_multi_table_insert_in_insert_statement1285_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_multi_table_insert_in_insert_statement1285	= { FOLLOW_multi_table_insert_in_insert_statement1285_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_insert_into_clause_in_single_table_insert1299  */
static	ANTLR3_BITWORD FOLLOW_insert_into_clause_in_single_table_insert1299_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001040000100) };
static  ANTLR3_BITSET_LIST FOLLOW_insert_into_clause_in_single_table_insert1299	= { FOLLOW_insert_into_clause_in_single_table_insert1299_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_values_clause_in_single_table_insert1303  */
static	ANTLR3_BITWORD FOLLOW_values_clause_in_single_table_insert1303_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000003000) };
static  ANTLR3_BITSET_LIST FOLLOW_values_clause_in_single_table_insert1303	= { FOLLOW_values_clause_in_single_table_insert1303_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_returning_clause_in_single_table_insert1305  */
static	ANTLR3_BITWORD FOLLOW_returning_clause_in_single_table_insert1305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_returning_clause_in_single_table_insert1305	= { FOLLOW_returning_clause_in_single_table_insert1305_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_single_table_insert1310  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_single_table_insert1310_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_single_table_insert1310	= { FOLLOW_select_statement_in_single_table_insert1310_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_single_table_insert1314  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_single_table_insert1314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_single_table_insert1314	= { FOLLOW_subquery_in_single_table_insert1314_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_error_logging_clause_in_single_table_insert1318  */
static	ANTLR3_BITWORD FOLLOW_error_logging_clause_in_single_table_insert1318_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_error_logging_clause_in_single_table_insert1318	= { FOLLOW_error_logging_clause_in_single_table_insert1318_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_into_in_insert_into_clause1332  */
static	ANTLR3_BITWORD FOLLOW_r_into_in_insert_into_clause1332_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_into_in_insert_into_clause1332	= { FOLLOW_r_into_in_insert_into_clause1332_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dml_table_expression_clause_in_insert_into_clause1334  */
static	ANTLR3_BITWORD FOLLOW_dml_table_expression_clause_in_insert_into_clause1334_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_dml_table_expression_clause_in_insert_into_clause1334	= { FOLLOW_dml_table_expression_clause_in_insert_into_clause1334_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_insert_into_clause1336  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_insert_into_clause1336_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_insert_into_clause1336	= { FOLLOW_t_alias_in_insert_into_clause1336_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_insert_into_clause1342  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_insert_into_clause1342_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_insert_into_clause1342	= { FOLLOW_LPAREN_in_insert_into_clause1342_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_specs_in_insert_into_clause1344  */
static	ANTLR3_BITWORD FOLLOW_column_specs_in_insert_into_clause1344_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_specs_in_insert_into_clause1344	= { FOLLOW_column_specs_in_insert_into_clause1344_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_insert_into_clause1346  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_insert_into_clause1346_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_insert_into_clause1346	= { FOLLOW_RPAREN_in_insert_into_clause1346_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_values_in_values_clause1359  */
static	ANTLR3_BITWORD FOLLOW_r_values_in_values_clause1359_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_values_in_values_clause1359	= { FOLLOW_r_values_in_values_clause1359_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_values_clause1361  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_values_clause1361_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040500), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_values_clause1361	= { FOLLOW_LPAREN_in_values_clause1361_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_default_in_values_clause1365  */
static	ANTLR3_BITWORD FOLLOW_r_default_in_values_clause1365_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_r_default_in_values_clause1365	= { FOLLOW_r_default_in_values_clause1365_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_values_clause1369  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_values_clause1369_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_values_clause1369	= { FOLLOW_sql_expression_in_values_clause1369_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_values_clause1374  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_values_clause1374_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040500), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_values_clause1374	= { FOLLOW_COMMA_in_values_clause1374_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_default_in_values_clause1377  */
static	ANTLR3_BITWORD FOLLOW_r_default_in_values_clause1377_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_r_default_in_values_clause1377	= { FOLLOW_r_default_in_values_clause1377_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_values_clause1381  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_values_clause1381_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_values_clause1381	= { FOLLOW_sql_expression_in_values_clause1381_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_values_clause1386  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_values_clause1386_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_values_clause1386	= { FOLLOW_RPAREN_in_values_clause1386_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_return_in_returning_clause1404  */
static	ANTLR3_BITWORD FOLLOW_k_return_in_returning_clause1404_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_return_in_returning_clause1404	= { FOLLOW_k_return_in_returning_clause1404_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_returning_in_returning_clause1408  */
static	ANTLR3_BITWORD FOLLOW_k_returning_in_returning_clause1408_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_returning_in_returning_clause1408	= { FOLLOW_k_returning_in_returning_clause1408_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_returning_clause1412  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_returning_clause1412_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_returning_clause1412	= { FOLLOW_sql_expression_in_returning_clause1412_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_returning_clause1415  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_returning_clause1415_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_returning_clause1415	= { FOLLOW_COMMA_in_returning_clause1415_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_returning_clause1417  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_returning_clause1417_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_returning_clause1417	= { FOLLOW_sql_expression_in_returning_clause1417_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_into_in_returning_clause1421  */
static	ANTLR3_BITWORD FOLLOW_r_into_in_returning_clause1421_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_into_in_returning_clause1421	= { FOLLOW_r_into_in_returning_clause1421_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_data_item_in_returning_clause1423  */
static	ANTLR3_BITWORD FOLLOW_data_item_in_returning_clause1423_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_data_item_in_returning_clause1423	= { FOLLOW_data_item_in_returning_clause1423_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_returning_clause1426  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_returning_clause1426_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_returning_clause1426	= { FOLLOW_COMMA_in_returning_clause1426_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_data_item_in_returning_clause1428  */
static	ANTLR3_BITWORD FOLLOW_data_item_in_returning_clause1428_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_data_item_in_returning_clause1428	= { FOLLOW_data_item_in_returning_clause1428_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_multi_table_insert1457  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_multi_table_insert1457_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_multi_table_insert1457	= { FOLLOW_r_all_in_multi_table_insert1457_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_insert_into_clause_in_multi_table_insert1461  */
static	ANTLR3_BITWORD FOLLOW_insert_into_clause_in_multi_table_insert1461_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000800000000), ANTLR3_UINT64_LIT(0x0000000040000000) };
static  ANTLR3_BITSET_LIST FOLLOW_insert_into_clause_in_multi_table_insert1461	= { FOLLOW_insert_into_clause_in_multi_table_insert1461_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_values_clause_in_multi_table_insert1463  */
static	ANTLR3_BITWORD FOLLOW_values_clause_in_multi_table_insert1463_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_values_clause_in_multi_table_insert1463	= { FOLLOW_values_clause_in_multi_table_insert1463_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_error_logging_clause_in_multi_table_insert1466  */
static	ANTLR3_BITWORD FOLLOW_error_logging_clause_in_multi_table_insert1466_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_error_logging_clause_in_multi_table_insert1466	= { FOLLOW_error_logging_clause_in_multi_table_insert1466_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_conditional_insert_clause_in_multi_table_insert1484  */
static	ANTLR3_BITWORD FOLLOW_conditional_insert_clause_in_multi_table_insert1484_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_conditional_insert_clause_in_multi_table_insert1484	= { FOLLOW_conditional_insert_clause_in_multi_table_insert1484_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_multi_table_insert1504  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_multi_table_insert1504_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_multi_table_insert1504	= { FOLLOW_subquery_in_multi_table_insert1504_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_conditional_insert_clause1519  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_conditional_insert_clause1519_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_conditional_insert_clause1519	= { FOLLOW_r_all_in_conditional_insert_clause1519_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_conditional_insert_clause1523  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_conditional_insert_clause1523_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_conditional_insert_clause1523	= { FOLLOW_k_first_in_conditional_insert_clause1523_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_when_in_conditional_insert_clause1538  */
static	ANTLR3_BITWORD FOLLOW_k_when_in_conditional_insert_clause1538_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_when_in_conditional_insert_clause1538	= { FOLLOW_k_when_in_conditional_insert_clause1538_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_conditional_insert_clause1540  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_conditional_insert_clause1540_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_conditional_insert_clause1540	= { FOLLOW_sql_condition_in_conditional_insert_clause1540_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_then_in_conditional_insert_clause1542  */
static	ANTLR3_BITWORD FOLLOW_r_then_in_conditional_insert_clause1542_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_then_in_conditional_insert_clause1542	= { FOLLOW_r_then_in_conditional_insert_clause1542_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_insert_into_clause_in_conditional_insert_clause1546  */
static	ANTLR3_BITWORD FOLLOW_insert_into_clause_in_conditional_insert_clause1546_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800008000), ANTLR3_UINT64_LIT(0x0000000040000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_insert_into_clause_in_conditional_insert_clause1546	= { FOLLOW_insert_into_clause_in_conditional_insert_clause1546_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_values_clause_in_conditional_insert_clause1548  */
static	ANTLR3_BITWORD FOLLOW_values_clause_in_conditional_insert_clause1548_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800008000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_values_clause_in_conditional_insert_clause1548	= { FOLLOW_values_clause_in_conditional_insert_clause1548_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_else_in_conditional_insert_clause1565  */
static	ANTLR3_BITWORD FOLLOW_r_else_in_conditional_insert_clause1565_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_else_in_conditional_insert_clause1565	= { FOLLOW_r_else_in_conditional_insert_clause1565_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_insert_into_clause_in_conditional_insert_clause1569  */
static	ANTLR3_BITWORD FOLLOW_insert_into_clause_in_conditional_insert_clause1569_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000), ANTLR3_UINT64_LIT(0x0000000040000000) };
static  ANTLR3_BITSET_LIST FOLLOW_insert_into_clause_in_conditional_insert_clause1569	= { FOLLOW_insert_into_clause_in_conditional_insert_clause1569_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_values_clause_in_conditional_insert_clause1571  */
static	ANTLR3_BITWORD FOLLOW_values_clause_in_conditional_insert_clause1571_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_values_clause_in_conditional_insert_clause1571	= { FOLLOW_values_clause_in_conditional_insert_clause1571_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_name_long_in_dml_table_expression_clause1591  */
static	ANTLR3_BITWORD FOLLOW_table_name_long_in_dml_table_expression_clause1591_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_table_name_long_in_dml_table_expression_clause1591	= { FOLLOW_table_name_long_in_dml_table_expression_clause1591_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_partition_extension_clause_in_dml_table_expression_clause1595  */
static	ANTLR3_BITWORD FOLLOW_partition_extension_clause_in_dml_table_expression_clause1595_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_partition_extension_clause_in_dml_table_expression_clause1595	= { FOLLOW_partition_extension_clause_in_dml_table_expression_clause1595_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AT_SIGN_in_dml_table_expression_clause1599  */
static	ANTLR3_BITWORD FOLLOW_AT_SIGN_in_dml_table_expression_clause1599_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_AT_SIGN_in_dml_table_expression_clause1599	= { FOLLOW_AT_SIGN_in_dml_table_expression_clause1599_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dblink_name_in_dml_table_expression_clause1601  */
static	ANTLR3_BITWORD FOLLOW_dblink_name_in_dml_table_expression_clause1601_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_dblink_name_in_dml_table_expression_clause1601	= { FOLLOW_dblink_name_in_dml_table_expression_clause1601_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_dml_table_expression_clause1608  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_dml_table_expression_clause1608_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_dml_table_expression_clause1608	= { FOLLOW_subquery_in_dml_table_expression_clause1608_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_restricrion_clause_in_dml_table_expression_clause1610  */
static	ANTLR3_BITWORD FOLLOW_subquery_restricrion_clause_in_dml_table_expression_clause1610_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_restricrion_clause_in_dml_table_expression_clause1610	= { FOLLOW_subquery_restricrion_clause_in_dml_table_expression_clause1610_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_dml_table_expression_clause1614  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_dml_table_expression_clause1614_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_dml_table_expression_clause1614	= { FOLLOW_pivot_clause_in_dml_table_expression_clause1614_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_dml_table_expression_clause1616  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_dml_table_expression_clause1616_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_dml_table_expression_clause1616	= { FOLLOW_unpivot_clause_in_dml_table_expression_clause1616_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_dml_table_expression_clause1623  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_dml_table_expression_clause1623_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_dml_table_expression_clause1623	= { FOLLOW_LPAREN_in_dml_table_expression_clause1623_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_dml_table_expression_clause1625  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_dml_table_expression_clause1625_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_dml_table_expression_clause1625	= { FOLLOW_subquery_in_dml_table_expression_clause1625_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_restricrion_clause_in_dml_table_expression_clause1627  */
static	ANTLR3_BITWORD FOLLOW_subquery_restricrion_clause_in_dml_table_expression_clause1627_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_restricrion_clause_in_dml_table_expression_clause1627	= { FOLLOW_subquery_restricrion_clause_in_dml_table_expression_clause1627_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_dml_table_expression_clause1630  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_dml_table_expression_clause1630_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_dml_table_expression_clause1630	= { FOLLOW_RPAREN_in_dml_table_expression_clause1630_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_collection_clause_in_dml_table_expression_clause1635  */
static	ANTLR3_BITWORD FOLLOW_table_collection_clause_in_dml_table_expression_clause1635_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_table_collection_clause_in_dml_table_expression_clause1635	= { FOLLOW_table_collection_clause_in_dml_table_expression_clause1635_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_log_in_error_logging_clause1645  */
static	ANTLR3_BITWORD FOLLOW_k_log_in_error_logging_clause1645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_log_in_error_logging_clause1645	= { FOLLOW_k_log_in_error_logging_clause1645_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_errors_in_error_logging_clause1647  */
static	ANTLR3_BITWORD FOLLOW_k_errors_in_error_logging_clause1647_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_errors_in_error_logging_clause1647	= { FOLLOW_k_errors_in_error_logging_clause1647_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_into_in_error_logging_clause1651  */
static	ANTLR3_BITWORD FOLLOW_r_into_in_error_logging_clause1651_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_into_in_error_logging_clause1651	= { FOLLOW_r_into_in_error_logging_clause1651_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_name_long_in_error_logging_clause1653  */
static	ANTLR3_BITWORD FOLLOW_table_name_long_in_error_logging_clause1653_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_table_name_long_in_error_logging_clause1653	= { FOLLOW_table_name_long_in_error_logging_clause1653_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_error_logging_clause1658  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_error_logging_clause1658_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000870204), ANTLR3_UINT64_LIT(0x0004002000040100), ANTLR3_UINT64_LIT(0xBAD3966010840050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_error_logging_clause1658	= { FOLLOW_LPAREN_in_error_logging_clause1658_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simple_expression_in_error_logging_clause1660  */
static	ANTLR3_BITWORD FOLLOW_simple_expression_in_error_logging_clause1660_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_simple_expression_in_error_logging_clause1660	= { FOLLOW_simple_expression_in_error_logging_clause1660_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_error_logging_clause1662  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_error_logging_clause1662_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_error_logging_clause1662	= { FOLLOW_RPAREN_in_error_logging_clause1662_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_reject_in_error_logging_clause1667  */
static	ANTLR3_BITWORD FOLLOW_k_reject_in_error_logging_clause1667_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_reject_in_error_logging_clause1667	= { FOLLOW_k_reject_in_error_logging_clause1667_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_limit_in_error_logging_clause1669  */
static	ANTLR3_BITWORD FOLLOW_k_limit_in_error_logging_clause1669_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010004) };
static  ANTLR3_BITSET_LIST FOLLOW_k_limit_in_error_logging_clause1669	= { FOLLOW_k_limit_in_error_logging_clause1669_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_error_logging_clause1672  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_error_logging_clause1672_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_error_logging_clause1672	= { FOLLOW_NUMBER_in_error_logging_clause1672_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_unlimited_in_error_logging_clause1676  */
static	ANTLR3_BITWORD FOLLOW_k_unlimited_in_error_logging_clause1676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_unlimited_in_error_logging_clause1676	= { FOLLOW_k_unlimited_in_error_logging_clause1676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_data_item1692  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_data_item1692_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_data_item1692	= { FOLLOW_sql_identifier_in_data_item1692_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bind_variable_in_data_item1701  */
static	ANTLR3_BITWORD FOLLOW_bind_variable_in_data_item1701_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bind_variable_in_data_item1701	= { FOLLOW_bind_variable_in_data_item1701_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_update_in_update_statement1717  */
static	ANTLR3_BITWORD FOLLOW_r_update_in_update_statement1717_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_update_in_update_statement1717	= { FOLLOW_r_update_in_update_statement1717_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_only_in_update_statement1721  */
static	ANTLR3_BITWORD FOLLOW_k_only_in_update_statement1721_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_only_in_update_statement1721	= { FOLLOW_k_only_in_update_statement1721_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_update_statement1723  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_update_statement1723_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_update_statement1723	= { FOLLOW_LPAREN_in_update_statement1723_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dml_table_expression_clause_in_update_statement1725  */
static	ANTLR3_BITWORD FOLLOW_dml_table_expression_clause_in_update_statement1725_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_dml_table_expression_clause_in_update_statement1725	= { FOLLOW_dml_table_expression_clause_in_update_statement1725_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_update_statement1727  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_update_statement1727_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_update_statement1727	= { FOLLOW_RPAREN_in_update_statement1727_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dml_table_expression_clause_in_update_statement1731  */
static	ANTLR3_BITWORD FOLLOW_dml_table_expression_clause_in_update_statement1731_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_dml_table_expression_clause_in_update_statement1731	= { FOLLOW_dml_table_expression_clause_in_update_statement1731_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_update_statement1734  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_update_statement1734_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_update_statement1734	= { FOLLOW_t_alias_in_update_statement1734_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_update_set_clause_in_update_statement1740  */
static	ANTLR3_BITWORD FOLLOW_update_set_clause_in_update_statement1740_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000), ANTLR3_UINT64_LIT(0x0000000000003000) };
static  ANTLR3_BITSET_LIST FOLLOW_update_set_clause_in_update_statement1740	= { FOLLOW_update_set_clause_in_update_statement1740_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_where_clause_in_update_statement1742  */
static	ANTLR3_BITWORD FOLLOW_where_clause_in_update_statement1742_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000003000) };
static  ANTLR3_BITSET_LIST FOLLOW_where_clause_in_update_statement1742	= { FOLLOW_where_clause_in_update_statement1742_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_returning_clause_in_update_statement1745  */
static	ANTLR3_BITWORD FOLLOW_returning_clause_in_update_statement1745_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_returning_clause_in_update_statement1745	= { FOLLOW_returning_clause_in_update_statement1745_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_error_logging_clause_in_update_statement1748  */
static	ANTLR3_BITWORD FOLLOW_error_logging_clause_in_update_statement1748_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_error_logging_clause_in_update_statement1748	= { FOLLOW_error_logging_clause_in_update_statement1748_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_update_set_clause1758  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_update_set_clause1758_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_update_set_clause1758	= { FOLLOW_r_set_in_update_set_clause1758_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_value_in_update_set_clause1782  */
static	ANTLR3_BITWORD FOLLOW_k_value_in_update_set_clause1782_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_value_in_update_set_clause1782	= { FOLLOW_k_value_in_update_set_clause1782_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_update_set_clause1784  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_update_set_clause1784_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_update_set_clause1784	= { FOLLOW_LPAREN_in_update_set_clause1784_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_update_set_clause1786  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_update_set_clause1786_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_update_set_clause1786	= { FOLLOW_t_alias_in_update_set_clause1786_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_update_set_clause1789  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_update_set_clause1789_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_update_set_clause1789	= { FOLLOW_RPAREN_in_update_set_clause1789_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_update_set_clause1791  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_update_set_clause1791_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_update_set_clause1791	= { FOLLOW_EQ_in_update_set_clause1791_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_update_set_clause1795  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_update_set_clause1795_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_update_set_clause1795	= { FOLLOW_sql_expression_in_update_set_clause1795_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_update_set_clause1799  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_update_set_clause1799_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_update_set_clause1799	= { FOLLOW_subquery_in_update_set_clause1799_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_update_set_clause_part1_in_update_set_clause1831  */
static	ANTLR3_BITWORD FOLLOW_update_set_clause_part1_in_update_set_clause1831_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_update_set_clause_part1_in_update_set_clause1831	= { FOLLOW_update_set_clause_part1_in_update_set_clause1831_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_update_set_clause_part2_in_update_set_clause1835  */
static	ANTLR3_BITWORD FOLLOW_update_set_clause_part2_in_update_set_clause1835_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_update_set_clause_part2_in_update_set_clause1835	= { FOLLOW_update_set_clause_part2_in_update_set_clause1835_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_update_set_clause1853  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_update_set_clause1853_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_update_set_clause1853	= { FOLLOW_COMMA_in_update_set_clause1853_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_update_set_clause_part1_in_update_set_clause1856  */
static	ANTLR3_BITWORD FOLLOW_update_set_clause_part1_in_update_set_clause1856_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_update_set_clause_part1_in_update_set_clause1856	= { FOLLOW_update_set_clause_part1_in_update_set_clause1856_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_update_set_clause_part2_in_update_set_clause1860  */
static	ANTLR3_BITWORD FOLLOW_update_set_clause_part2_in_update_set_clause1860_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_update_set_clause_part2_in_update_set_clause1860	= { FOLLOW_update_set_clause_part2_in_update_set_clause1860_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_update_set_clause_part11900  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_update_set_clause_part11900_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_update_set_clause_part11900	= { FOLLOW_LPAREN_in_update_set_clause_part11900_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_specs_in_update_set_clause_part11902  */
static	ANTLR3_BITWORD FOLLOW_column_specs_in_update_set_clause_part11902_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_specs_in_update_set_clause_part11902	= { FOLLOW_column_specs_in_update_set_clause_part11902_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_update_set_clause_part11904  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_update_set_clause_part11904_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_update_set_clause_part11904	= { FOLLOW_RPAREN_in_update_set_clause_part11904_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_update_set_clause_part11906  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_update_set_clause_part11906_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_update_set_clause_part11906	= { FOLLOW_EQ_in_update_set_clause_part11906_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_update_set_clause_part11908  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_update_set_clause_part11908_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_update_set_clause_part11908	= { FOLLOW_subquery_in_update_set_clause_part11908_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_update_set_clause_part21921  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_update_set_clause_part21921_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_update_set_clause_part21921	= { FOLLOW_column_spec_in_update_set_clause_part21921_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_update_set_clause_part21923  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_update_set_clause_part21923_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040500), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_update_set_clause_part21923	= { FOLLOW_EQ_in_update_set_clause_part21923_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_default_in_update_set_clause_part21927  */
static	ANTLR3_BITWORD FOLLOW_r_default_in_update_set_clause_part21927_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_default_in_update_set_clause_part21927	= { FOLLOW_r_default_in_update_set_clause_part21927_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_update_set_clause_part21931  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_update_set_clause_part21931_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_update_set_clause_part21931	= { FOLLOW_subquery_in_update_set_clause_part21931_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_update_set_clause_part21935  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_update_set_clause_part21935_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_update_set_clause_part21935	= { FOLLOW_sql_expression_in_update_set_clause_part21935_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_factoring_clause_in_select_statement1950  */
static	ANTLR3_BITWORD FOLLOW_subquery_factoring_clause_in_select_statement1950_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_factoring_clause_in_select_statement1950	= { FOLLOW_subquery_factoring_clause_in_select_statement1950_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_select_in_select_statement1966  */
static	ANTLR3_BITWORD FOLLOW_r_select_in_select_statement1966_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_select_in_select_statement1966	= { FOLLOW_r_select_in_select_statement1966_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_distinct_in_select_statement1972  */
static	ANTLR3_BITWORD FOLLOW_r_distinct_in_select_statement1972_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_distinct_in_select_statement1972	= { FOLLOW_r_distinct_in_select_statement1972_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_unique_in_select_statement1976  */
static	ANTLR3_BITWORD FOLLOW_r_unique_in_select_statement1976_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_unique_in_select_statement1976	= { FOLLOW_r_unique_in_select_statement1976_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_union_in_select_statement1979  */
static	ANTLR3_BITWORD FOLLOW_r_union_in_select_statement1979_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_union_in_select_statement1979	= { FOLLOW_r_union_in_select_statement1979_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_select_statement1983  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_select_statement1983_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_select_statement1983	= { FOLLOW_r_all_in_select_statement1983_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_list_in_select_statement1988  */
static	ANTLR3_BITWORD FOLLOW_select_list_in_select_statement1988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800400000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_list_in_select_statement1988	= { FOLLOW_select_list_in_select_statement1988_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_into_in_select_statement1993  */
static	ANTLR3_BITWORD FOLLOW_r_into_in_select_statement1993_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_into_in_select_statement1993	= { FOLLOW_r_into_in_select_statement1993_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_data_item_in_select_statement1995  */
static	ANTLR3_BITWORD FOLLOW_data_item_in_select_statement1995_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_data_item_in_select_statement1995	= { FOLLOW_data_item_in_select_statement1995_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_select_statement1998  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_select_statement1998_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_select_statement1998	= { FOLLOW_COMMA_in_select_statement1998_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_data_item_in_select_statement2000  */
static	ANTLR3_BITWORD FOLLOW_data_item_in_select_statement2000_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_data_item_in_select_statement2000	= { FOLLOW_data_item_in_select_statement2000_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_from_in_select_statement2007  */
static	ANTLR3_BITWORD FOLLOW_r_from_in_select_statement2007_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_from_in_select_statement2007	= { FOLLOW_r_from_in_select_statement2007_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_list_in_select_statement2011  */
static	ANTLR3_BITWORD FOLLOW_table_reference_list_in_select_statement2011_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040403200020), ANTLR3_UINT64_LIT(0x0000000802008000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_list_in_select_statement2011	= { FOLLOW_table_reference_list_in_select_statement2011_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_where_clause_in_select_statement2024  */
static	ANTLR3_BITWORD FOLLOW_where_clause_in_select_statement2024_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040403200020), ANTLR3_UINT64_LIT(0x0000000002008000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_where_clause_in_select_statement2024	= { FOLLOW_where_clause_in_select_statement2024_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_hierarchical_query_clause_in_select_statement2032  */
static	ANTLR3_BITWORD FOLLOW_hierarchical_query_clause_in_select_statement2032_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040403200000), ANTLR3_UINT64_LIT(0x0000000002000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_hierarchical_query_clause_in_select_statement2032	= { FOLLOW_hierarchical_query_clause_in_select_statement2032_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_clause_in_select_statement2040  */
static	ANTLR3_BITWORD FOLLOW_group_by_clause_in_select_statement2040_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_clause_in_select_statement2040	= { FOLLOW_group_by_clause_in_select_statement2040_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_clause_in_select_statement2063  */
static	ANTLR3_BITWORD FOLLOW_model_clause_in_select_statement2063_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_model_clause_in_select_statement2063	= { FOLLOW_model_clause_in_select_statement2063_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_union_clause_in_select_statement2071  */
static	ANTLR3_BITWORD FOLLOW_union_clause_in_select_statement2071_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_union_clause_in_select_statement2071	= { FOLLOW_union_clause_in_select_statement2071_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_select_statement2081  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_select_statement2081_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_select_statement2081	= { FOLLOW_for_update_clause_in_select_statement2081_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_select_statement2097  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_select_statement2097_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_select_statement2097	= { FOLLOW_order_by_clause_in_select_statement2097_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_select_statement2107  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_select_statement2107_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_select_statement2107	= { FOLLOW_for_update_clause_in_select_statement2107_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_select_statement2230  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_select_statement2230_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_select_statement2230	= { FOLLOW_subquery_in_select_statement2230_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_with_in_subquery_factoring_clause2256  */
static	ANTLR3_BITWORD FOLLOW_r_with_in_subquery_factoring_clause2256_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_with_in_subquery_factoring_clause2256	= { FOLLOW_r_with_in_subquery_factoring_clause2256_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_factoring_clause_part_first_in_subquery_factoring_clause2262  */
static	ANTLR3_BITWORD FOLLOW_subquery_factoring_clause_part_first_in_subquery_factoring_clause2262_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_factoring_clause_part_first_in_subquery_factoring_clause2262	= { FOLLOW_subquery_factoring_clause_part_first_in_subquery_factoring_clause2262_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_factoring_clause_part_next_in_subquery_factoring_clause2264  */
static	ANTLR3_BITWORD FOLLOW_subquery_factoring_clause_part_next_in_subquery_factoring_clause2264_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_factoring_clause_part_next_in_subquery_factoring_clause2264	= { FOLLOW_subquery_factoring_clause_part_next_in_subquery_factoring_clause2264_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_search_clause_in_subquery_factoring_clause2268  */
static	ANTLR3_BITWORD FOLLOW_search_clause_in_subquery_factoring_clause2268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_search_clause_in_subquery_factoring_clause2268	= { FOLLOW_search_clause_in_subquery_factoring_clause2268_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cycle_clause_in_subquery_factoring_clause2272  */
static	ANTLR3_BITWORD FOLLOW_cycle_clause_in_subquery_factoring_clause2272_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cycle_clause_in_subquery_factoring_clause2272	= { FOLLOW_cycle_clause_in_subquery_factoring_clause2272_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_subquery_factoring_clause_part_first2307  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_subquery_factoring_clause_part_first2307_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_subquery_factoring_clause_part_first2307	= { FOLLOW_t_alias_in_subquery_factoring_clause_part_first2307_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_subquery_factoring_clause_part_first2311  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_subquery_factoring_clause_part_first2311_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_subquery_factoring_clause_part_first2311	= { FOLLOW_LPAREN_in_subquery_factoring_clause_part_first2311_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_list_in_subquery_factoring_clause_part_first2313  */
static	ANTLR3_BITWORD FOLLOW_select_list_in_subquery_factoring_clause_part_first2313_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_list_in_subquery_factoring_clause_part_first2313	= { FOLLOW_select_list_in_subquery_factoring_clause_part_first2313_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_subquery_factoring_clause_part_first2315  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_subquery_factoring_clause_part_first2315_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_subquery_factoring_clause_part_first2315	= { FOLLOW_RPAREN_in_subquery_factoring_clause_part_first2315_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_as_in_subquery_factoring_clause_part_first2319  */
static	ANTLR3_BITWORD FOLLOW_r_as_in_subquery_factoring_clause_part_first2319_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_as_in_subquery_factoring_clause_part_first2319	= { FOLLOW_r_as_in_subquery_factoring_clause_part_first2319_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_subquery_factoring_clause_part_first2321  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_subquery_factoring_clause_part_first2321_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_subquery_factoring_clause_part_first2321	= { FOLLOW_subquery_in_subquery_factoring_clause_part_first2321_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_subquery_factoring_clause_part_next2334  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_subquery_factoring_clause_part_next2334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_subquery_factoring_clause_part_next2334	= { FOLLOW_COMMA_in_subquery_factoring_clause_part_next2334_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_subquery_factoring_clause_part_next2336  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_subquery_factoring_clause_part_next2336_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_subquery_factoring_clause_part_next2336	= { FOLLOW_t_alias_in_subquery_factoring_clause_part_next2336_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_subquery_factoring_clause_part_next2340  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_subquery_factoring_clause_part_next2340_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_subquery_factoring_clause_part_next2340	= { FOLLOW_LPAREN_in_subquery_factoring_clause_part_next2340_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_list_in_subquery_factoring_clause_part_next2342  */
static	ANTLR3_BITWORD FOLLOW_select_list_in_subquery_factoring_clause_part_next2342_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_list_in_subquery_factoring_clause_part_next2342	= { FOLLOW_select_list_in_subquery_factoring_clause_part_next2342_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_subquery_factoring_clause_part_next2344  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_subquery_factoring_clause_part_next2344_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_subquery_factoring_clause_part_next2344	= { FOLLOW_RPAREN_in_subquery_factoring_clause_part_next2344_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_as_in_subquery_factoring_clause_part_next2348  */
static	ANTLR3_BITWORD FOLLOW_r_as_in_subquery_factoring_clause_part_next2348_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_as_in_subquery_factoring_clause_part_next2348	= { FOLLOW_r_as_in_subquery_factoring_clause_part_next2348_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_subquery_factoring_clause_part_next2350  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_subquery_factoring_clause_part_next2350_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_subquery_factoring_clause_part_next2350	= { FOLLOW_subquery_in_subquery_factoring_clause_part_next2350_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_search_in_search_clause2364  */
static	ANTLR3_BITWORD FOLLOW_k_search_in_search_clause2364_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_search_in_search_clause2364	= { FOLLOW_k_search_in_search_clause2364_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_depth_in_search_clause2368  */
static	ANTLR3_BITWORD FOLLOW_k_depth_in_search_clause2368_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_depth_in_search_clause2368	= { FOLLOW_k_depth_in_search_clause2368_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_breadth_in_search_clause2372  */
static	ANTLR3_BITWORD FOLLOW_k_breadth_in_search_clause2372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_breadth_in_search_clause2372	= { FOLLOW_k_breadth_in_search_clause2372_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_search_clause2376  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_search_clause2376_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_search_clause2376	= { FOLLOW_k_first_in_search_clause2376_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_search_clause2378  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_search_clause2378_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_search_clause2378	= { FOLLOW_r_by_in_search_clause2378_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_c_alias_in_search_clause2384  */
static	ANTLR3_BITWORD FOLLOW_c_alias_in_search_clause2384_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000001), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000400), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_c_alias_in_search_clause2384	= { FOLLOW_c_alias_in_search_clause2384_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_asc_in_search_clause2386  */
static	ANTLR3_BITWORD FOLLOW_r_asc_in_search_clause2386_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000400), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_asc_in_search_clause2386	= { FOLLOW_r_asc_in_search_clause2386_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_desc_in_search_clause2390  */
static	ANTLR3_BITWORD FOLLOW_r_desc_in_search_clause2390_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_desc_in_search_clause2390	= { FOLLOW_r_desc_in_search_clause2390_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_search_clause2395  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_search_clause2395_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_search_clause2395	= { FOLLOW_k_nulls_in_search_clause2395_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_search_clause2397  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_search_clause2397_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_search_clause2397	= { FOLLOW_k_first_in_search_clause2397_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_search_clause2402  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_search_clause2402_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_search_clause2402	= { FOLLOW_k_nulls_in_search_clause2402_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_last_in_search_clause2404  */
static	ANTLR3_BITWORD FOLLOW_k_last_in_search_clause2404_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_k_last_in_search_clause2404	= { FOLLOW_k_last_in_search_clause2404_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_search_clause2414  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_search_clause2414_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_search_clause2414	= { FOLLOW_COMMA_in_search_clause2414_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_c_alias_in_search_clause2416  */
static	ANTLR3_BITWORD FOLLOW_c_alias_in_search_clause2416_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000001), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000400), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_c_alias_in_search_clause2416	= { FOLLOW_c_alias_in_search_clause2416_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_asc_in_search_clause2418  */
static	ANTLR3_BITWORD FOLLOW_r_asc_in_search_clause2418_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000400), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_asc_in_search_clause2418	= { FOLLOW_r_asc_in_search_clause2418_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_desc_in_search_clause2422  */
static	ANTLR3_BITWORD FOLLOW_r_desc_in_search_clause2422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_desc_in_search_clause2422	= { FOLLOW_r_desc_in_search_clause2422_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_search_clause2427  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_search_clause2427_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_search_clause2427	= { FOLLOW_k_nulls_in_search_clause2427_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_search_clause2429  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_search_clause2429_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_search_clause2429	= { FOLLOW_k_first_in_search_clause2429_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_search_clause2434  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_search_clause2434_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_search_clause2434	= { FOLLOW_k_nulls_in_search_clause2434_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_last_in_search_clause2436  */
static	ANTLR3_BITWORD FOLLOW_k_last_in_search_clause2436_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_k_last_in_search_clause2436	= { FOLLOW_k_last_in_search_clause2436_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_search_clause2444  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_search_clause2444_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_search_clause2444	= { FOLLOW_r_set_in_search_clause2444_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_search_clause2446  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_search_clause2446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_search_clause2446	= { FOLLOW_sql_identifier_in_search_clause2446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_cycle_in_cycle_clause2458  */
static	ANTLR3_BITWORD FOLLOW_k_cycle_in_cycle_clause2458_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_cycle_in_cycle_clause2458	= { FOLLOW_k_cycle_in_cycle_clause2458_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_c_alias_in_cycle_clause2460  */
static	ANTLR3_BITWORD FOLLOW_c_alias_in_cycle_clause2460_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_c_alias_in_cycle_clause2460	= { FOLLOW_c_alias_in_cycle_clause2460_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_cycle_clause2464  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_cycle_clause2464_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_cycle_clause2464	= { FOLLOW_COMMA_in_cycle_clause2464_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_c_alias_in_cycle_clause2466  */
static	ANTLR3_BITWORD FOLLOW_c_alias_in_cycle_clause2466_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_c_alias_in_cycle_clause2466	= { FOLLOW_c_alias_in_cycle_clause2466_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_cycle_clause2470  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_cycle_clause2470_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_cycle_clause2470	= { FOLLOW_r_set_in_cycle_clause2470_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_cycle_clause2472  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_cycle_clause2472_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_cycle_clause2472	= { FOLLOW_sql_identifier_in_cycle_clause2472_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_to_in_cycle_clause2475  */
static	ANTLR3_BITWORD FOLLOW_r_to_in_cycle_clause2475_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800264) };
static  ANTLR3_BITSET_LIST FOLLOW_r_to_in_cycle_clause2475	= { FOLLOW_r_to_in_cycle_clause2475_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_literal_in_cycle_clause2477  */
static	ANTLR3_BITWORD FOLLOW_literal_in_cycle_clause2477_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_literal_in_cycle_clause2477	= { FOLLOW_literal_in_cycle_clause2477_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_default_in_cycle_clause2479  */
static	ANTLR3_BITWORD FOLLOW_r_default_in_cycle_clause2479_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800264) };
static  ANTLR3_BITSET_LIST FOLLOW_r_default_in_cycle_clause2479	= { FOLLOW_r_default_in_cycle_clause2479_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_literal_in_cycle_clause2481  */
static	ANTLR3_BITWORD FOLLOW_literal_in_cycle_clause2481_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_literal_in_cycle_clause2481	= { FOLLOW_literal_in_cycle_clause2481_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_displayed_column_part_first_in_select_list2495  */
static	ANTLR3_BITWORD FOLLOW_displayed_column_part_first_in_select_list2495_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_displayed_column_part_first_in_select_list2495	= { FOLLOW_displayed_column_part_first_in_select_list2495_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_displayed_column_part_next_in_select_list2497  */
static	ANTLR3_BITWORD FOLLOW_displayed_column_part_next_in_select_list2497_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_displayed_column_part_next_in_select_list2497	= { FOLLOW_displayed_column_part_next_in_select_list2497_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_displayed_column_in_displayed_column_part_first2521  */
static	ANTLR3_BITWORD FOLLOW_displayed_column_in_displayed_column_part_first2521_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_displayed_column_in_displayed_column_part_first2521	= { FOLLOW_displayed_column_in_displayed_column_part_first2521_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_displayed_column_part_next2536  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_displayed_column_part_next2536_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_displayed_column_part_next2536	= { FOLLOW_COMMA_in_displayed_column_part_next2536_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_displayed_column_in_displayed_column_part_next2538  */
static	ANTLR3_BITWORD FOLLOW_displayed_column_in_displayed_column_part_next2538_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_displayed_column_in_displayed_column_part_next2538	= { FOLLOW_displayed_column_in_displayed_column_part_next2538_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASTERISK_in_displayed_column2571  */
static	ANTLR3_BITWORD FOLLOW_ASTERISK_in_displayed_column2571_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x4200000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_ASTERISK_in_displayed_column2571	= { FOLLOW_ASTERISK_in_displayed_column2571_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_displayed_column2578  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_displayed_column2578_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_displayed_column2578	= { FOLLOW_schema_name_in_displayed_column2578_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_displayed_column2582  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_displayed_column2582_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_displayed_column2582	= { FOLLOW_DOT_in_displayed_column2582_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_displayed_column2588  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_displayed_column2588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_displayed_column2588	= { FOLLOW_t_alias_in_displayed_column2588_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_displayed_column2593  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_displayed_column2593_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_displayed_column2593	= { FOLLOW_DOT_in_displayed_column2593_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASTERISK_in_displayed_column2597  */
static	ANTLR3_BITWORD FOLLOW_ASTERISK_in_displayed_column2597_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x4200000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_ASTERISK_in_displayed_column2597	= { FOLLOW_ASTERISK_in_displayed_column2597_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_displayed_column2603  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_displayed_column2603_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x4200000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_displayed_column2603	= { FOLLOW_sql_expression_in_displayed_column2603_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_c_alias_in_displayed_column2614  */
static	ANTLR3_BITWORD FOLLOW_c_alias_in_displayed_column2614_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_c_alias_in_displayed_column2614	= { FOLLOW_c_alias_in_displayed_column2614_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_add_in_sql_expression2672  */
static	ANTLR3_BITWORD FOLLOW_expr_add_in_sql_expression2672_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_add_in_sql_expression2672	= { FOLLOW_expr_add_in_sql_expression2672_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_mul_in_expr_add2682  */
static	ANTLR3_BITWORD FOLLOW_expr_mul_in_expr_add2682_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000018000000060) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_mul_in_expr_add2682	= { FOLLOW_expr_mul_in_expr_add2682_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PLUS_in_expr_add2688  */
static	ANTLR3_BITWORD FOLLOW_PLUS_in_expr_add2688_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_PLUS_in_expr_add2688	= { FOLLOW_PLUS_in_expr_add2688_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_in_expr_add2692  */
static	ANTLR3_BITWORD FOLLOW_MINUS_in_expr_add2692_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_in_expr_add2692	= { FOLLOW_MINUS_in_expr_add2692_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_doublevertbar_in_expr_add2696  */
static	ANTLR3_BITWORD FOLLOW_doublevertbar_in_expr_add2696_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_doublevertbar_in_expr_add2696	= { FOLLOW_doublevertbar_in_expr_add2696_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_mul_in_expr_add2700  */
static	ANTLR3_BITWORD FOLLOW_expr_mul_in_expr_add2700_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000018000000060) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_mul_in_expr_add2700	= { FOLLOW_expr_mul_in_expr_add2700_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_sign_in_expr_mul2713  */
static	ANTLR3_BITWORD FOLLOW_expr_sign_in_expr_mul2713_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000088) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_sign_in_expr_mul2713	= { FOLLOW_expr_sign_in_expr_mul2713_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_expr_mul2717  */
static	ANTLR3_BITWORD FOLLOW_set_in_expr_mul2717_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_expr_mul2717	= { FOLLOW_set_in_expr_mul2717_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_sign_in_expr_mul2727  */
static	ANTLR3_BITWORD FOLLOW_expr_sign_in_expr_mul2727_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000088) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_sign_in_expr_mul2727	= { FOLLOW_expr_sign_in_expr_mul2727_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PLUS_in_expr_sign2743  */
static	ANTLR3_BITWORD FOLLOW_PLUS_in_expr_sign2743_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_PLUS_in_expr_sign2743	= { FOLLOW_PLUS_in_expr_sign2743_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_in_expr_sign2747  */
static	ANTLR3_BITWORD FOLLOW_MINUS_in_expr_sign2747_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_in_expr_sign2747	= { FOLLOW_MINUS_in_expr_sign2747_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_prior_in_expr_sign2751  */
static	ANTLR3_BITWORD FOLLOW_r_prior_in_expr_sign2751_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_prior_in_expr_sign2751	= { FOLLOW_r_prior_in_expr_sign2751_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_connect_by_root_in_expr_sign2755  */
static	ANTLR3_BITWORD FOLLOW_k_connect_by_root_in_expr_sign2755_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_connect_by_root_in_expr_sign2755	= { FOLLOW_k_connect_by_root_in_expr_sign2755_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_expr_in_expr_sign2760  */
static	ANTLR3_BITWORD FOLLOW_expr_expr_in_expr_sign2760_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_expr_in_expr_sign2760	= { FOLLOW_expr_expr_in_expr_sign2760_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_extract_datetime_expression_in_expr_expr2776  */
static	ANTLR3_BITWORD FOLLOW_extract_datetime_expression_in_expr_expr2776_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_extract_datetime_expression_in_expr_expr2776	= { FOLLOW_extract_datetime_expression_in_expr_expr2776_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_interval_x_to_y_in_expr_expr2781  */
static	ANTLR3_BITWORD FOLLOW_interval_x_to_y_in_expr_expr2781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_interval_x_to_y_in_expr_expr2781	= { FOLLOW_interval_x_to_y_in_expr_expr2781_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datetime_expression_in_expr_expr2786  */
static	ANTLR3_BITWORD FOLLOW_datetime_expression_in_expr_expr2786_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datetime_expression_in_expr_expr2786	= { FOLLOW_datetime_expression_in_expr_expr2786_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_interval_expression_in_expr_expr2791  */
static	ANTLR3_BITWORD FOLLOW_interval_expression_in_expr_expr2791_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_interval_expression_in_expr_expr2791	= { FOLLOW_interval_expression_in_expr_expr2791_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_paren_in_expr_expr2804  */
static	ANTLR3_BITWORD FOLLOW_expr_paren_in_expr_expr2804_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_paren_in_expr_expr2804	= { FOLLOW_expr_paren_in_expr_expr2804_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cursor_expression_in_expr_expr2819  */
static	ANTLR3_BITWORD FOLLOW_cursor_expression_in_expr_expr2819_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cursor_expression_in_expr_expr2819	= { FOLLOW_cursor_expression_in_expr_expr2819_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cast_expression_in_expr_expr2834  */
static	ANTLR3_BITWORD FOLLOW_cast_expression_in_expr_expr2834_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cast_expression_in_expr_expr2834	= { FOLLOW_cast_expression_in_expr_expr2834_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_special_expression_in_expr_expr2849  */
static	ANTLR3_BITWORD FOLLOW_special_expression_in_expr_expr2849_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_special_expression_in_expr_expr2849	= { FOLLOW_special_expression_in_expr_expr2849_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_object_access_expression_in_expr_expr2854  */
static	ANTLR3_BITWORD FOLLOW_object_access_expression_in_expr_expr2854_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_object_access_expression_in_expr_expr2854	= { FOLLOW_object_access_expression_in_expr_expr2854_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_case_expression_in_expr_expr2867  */
static	ANTLR3_BITWORD FOLLOW_case_expression_in_expr_expr2867_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_case_expression_in_expr_expr2867	= { FOLLOW_case_expression_in_expr_expr2867_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_special_function_in_expr_expr2880  */
static	ANTLR3_BITWORD FOLLOW_special_function_in_expr_expr2880_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_special_function_in_expr_expr2880	= { FOLLOW_special_function_in_expr_expr2880_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_analytic_function_in_expr_expr2893  */
static	ANTLR3_BITWORD FOLLOW_analytic_function_in_expr_expr2893_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_analytic_function_in_expr_expr2893	= { FOLLOW_analytic_function_in_expr_expr2893_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_aggregate_function_in_expr_expr2906  */
static	ANTLR3_BITWORD FOLLOW_aggregate_function_in_expr_expr2906_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_aggregate_function_in_expr_expr2906	= { FOLLOW_aggregate_function_in_expr_expr2906_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_expression_in_expr_expr2919  */
static	ANTLR3_BITWORD FOLLOW_function_expression_in_expr_expr2919_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_function_expression_in_expr_expr2919	= { FOLLOW_function_expression_in_expr_expr2919_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simple_expression_in_expr_expr2933  */
static	ANTLR3_BITWORD FOLLOW_simple_expression_in_expr_expr2933_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simple_expression_in_expr_expr2933	= { FOLLOW_simple_expression_in_expr_expr2933_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_expr_expr2961  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_expr_expr2961_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_expr_expr2961	= { FOLLOW_subquery_in_expr_expr2961_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_expr_paren2971  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_expr_paren2971_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_expr_paren2971	= { FOLLOW_LPAREN_in_expr_paren2971_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_expression_in_expr_paren2973  */
static	ANTLR3_BITWORD FOLLOW_nested_expression_in_expr_paren2973_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_expression_in_expr_paren2973	= { FOLLOW_nested_expression_in_expr_paren2973_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_expr_paren2975  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_expr_paren2975_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_expr_paren2975	= { FOLLOW_RPAREN_in_expr_paren2975_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_nested_expression2985  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_nested_expression2985_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_nested_expression2985	= { FOLLOW_sql_expression_in_nested_expression2985_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_spec_in_function_expression2997  */
static	ANTLR3_BITWORD FOLLOW_function_spec_in_function_expression2997_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_function_spec_in_function_expression2997	= { FOLLOW_function_spec_in_function_expression2997_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_analytic_function_name_in_function_expression2999  */
static	ANTLR3_BITWORD FOLLOW_analytic_function_name_in_function_expression2999_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_analytic_function_name_in_function_expression2999	= { FOLLOW_analytic_function_name_in_function_expression2999_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_function_expression3002  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_function_expression3002_bits[]	= { ANTLR3_UINT64_LIT(0x6000000000000000), ANTLR3_UINT64_LIT(0x400000000087026C), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_function_expression3002	= { FOLLOW_LPAREN_in_function_expression3002_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_call_parameters_in_function_expression3004  */
static	ANTLR3_BITWORD FOLLOW_call_parameters_in_function_expression3004_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_call_parameters_in_function_expression3004	= { FOLLOW_call_parameters_in_function_expression3004_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_function_expression3007  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_function_expression3007_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_function_expression3007	= { FOLLOW_RPAREN_in_function_expression3007_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASTERISK_in_call_parameters3018  */
static	ANTLR3_BITWORD FOLLOW_ASTERISK_in_call_parameters3018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ASTERISK_in_call_parameters3018	= { FOLLOW_ASTERISK_in_call_parameters3018_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_call_parameter_in_call_parameters3023  */
static	ANTLR3_BITWORD FOLLOW_call_parameter_in_call_parameters3023_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_call_parameter_in_call_parameters3023	= { FOLLOW_call_parameter_in_call_parameters3023_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_call_parameters3027  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_call_parameters3027_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x400000000087026C), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_call_parameters3027	= { FOLLOW_COMMA_in_call_parameters3027_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_call_parameter_in_call_parameters3029  */
static	ANTLR3_BITWORD FOLLOW_call_parameter_in_call_parameters3029_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_call_parameter_in_call_parameters3029	= { FOLLOW_call_parameter_in_call_parameters3029_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parameter_name_in_call_parameter3045  */
static	ANTLR3_BITWORD FOLLOW_parameter_name_in_call_parameter3045_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_parameter_name_in_call_parameter3045	= { FOLLOW_parameter_name_in_call_parameter3045_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARROW_in_call_parameter3047  */
static	ANTLR3_BITWORD FOLLOW_ARROW_in_call_parameter3047_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_ARROW_in_call_parameter3047	= { FOLLOW_ARROW_in_call_parameter3047_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_expression_in_call_parameter3052  */
static	ANTLR3_BITWORD FOLLOW_nested_expression_in_call_parameter3052_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_expression_in_call_parameter3052	= { FOLLOW_nested_expression_in_call_parameter3052_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_parameter_name3062  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_parameter_name3062_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_parameter_name3062	= { FOLLOW_identifier_in_parameter_name3062_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_trim_in_special_function3094  */
static	ANTLR3_BITWORD FOLLOW_k_trim_in_special_function3094_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_trim_in_special_function3094	= { FOLLOW_k_trim_in_special_function3094_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_special_function3104  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_special_function3104_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000440100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_special_function3104	= { FOLLOW_LPAREN_in_special_function3104_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_leading_in_special_function3113  */
static	ANTLR3_BITWORD FOLLOW_k_leading_in_special_function3113_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_leading_in_special_function3113	= { FOLLOW_k_leading_in_special_function3113_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_trailing_in_special_function3117  */
static	ANTLR3_BITWORD FOLLOW_k_trailing_in_special_function3117_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_trailing_in_special_function3117	= { FOLLOW_k_trailing_in_special_function3117_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_both_in_special_function3121  */
static	ANTLR3_BITWORD FOLLOW_k_both_in_special_function3121_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_both_in_special_function3121	= { FOLLOW_k_both_in_special_function3121_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_QUOTED_STRING_in_special_function3125  */
static	ANTLR3_BITWORD FOLLOW_QUOTED_STRING_in_special_function3125_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_QUOTED_STRING_in_special_function3125	= { FOLLOW_QUOTED_STRING_in_special_function3125_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_from_in_special_function3128  */
static	ANTLR3_BITWORD FOLLOW_r_from_in_special_function3128_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_from_in_special_function3128	= { FOLLOW_r_from_in_special_function3128_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_special_function3136  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_special_function3136_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_special_function3136	= { FOLLOW_sql_expression_in_special_function3136_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_special_function3146  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_special_function3146_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_special_function3146	= { FOLLOW_RPAREN_in_special_function3146_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_special_function3155  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_special_function3155_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_special_function3155	= { FOLLOW_r_set_in_special_function3155_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_special_function3157  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_special_function3157_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_special_function3157	= { FOLLOW_LPAREN_in_special_function3157_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_special_function3159  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_special_function3159_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_special_function3159	= { FOLLOW_sql_expression_in_special_function3159_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_special_function3161  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_special_function3161_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_special_function3161	= { FOLLOW_RPAREN_in_special_function3161_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_lnnvl_in_special_function3168  */
static	ANTLR3_BITWORD FOLLOW_k_lnnvl_in_special_function3168_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_lnnvl_in_special_function3168	= { FOLLOW_k_lnnvl_in_special_function3168_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_special_function3170  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_special_function3170_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_special_function3170	= { FOLLOW_LPAREN_in_special_function3170_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_special_function3172  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_special_function3172_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_special_function3172	= { FOLLOW_sql_condition_in_special_function3172_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_special_function3174  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_special_function3174_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_special_function3174	= { FOLLOW_RPAREN_in_special_function3174_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_case_in_case_expression3190  */
static	ANTLR3_BITWORD FOLLOW_r_case_in_case_expression3190_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_case_in_case_expression3190	= { FOLLOW_r_case_in_case_expression3190_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simple_case_expression_in_case_expression3194  */
static	ANTLR3_BITWORD FOLLOW_simple_case_expression_in_case_expression3194_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000008000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_simple_case_expression_in_case_expression3194	= { FOLLOW_simple_case_expression_in_case_expression3194_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_searched_case_expression_in_case_expression3198  */
static	ANTLR3_BITWORD FOLLOW_searched_case_expression_in_case_expression3198_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000008000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_searched_case_expression_in_case_expression3198	= { FOLLOW_searched_case_expression_in_case_expression3198_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_else_case_expression_in_case_expression3204  */
static	ANTLR3_BITWORD FOLLOW_else_case_expression_in_case_expression3204_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000008000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_else_case_expression_in_case_expression3204	= { FOLLOW_else_case_expression_in_case_expression3204_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_end_in_case_expression3209  */
static	ANTLR3_BITWORD FOLLOW_k_end_in_case_expression3209_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_end_in_case_expression3209	= { FOLLOW_k_end_in_case_expression3209_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_cursor_in_cursor_expression3219  */
static	ANTLR3_BITWORD FOLLOW_k_cursor_in_cursor_expression3219_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_cursor_in_cursor_expression3219	= { FOLLOW_k_cursor_in_cursor_expression3219_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_cursor_expression3221  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_cursor_expression3221_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_cursor_expression3221	= { FOLLOW_subquery_in_cursor_expression3221_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_expression_in_simple_case_expression3231  */
static	ANTLR3_BITWORD FOLLOW_nested_expression_in_simple_case_expression3231_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_expression_in_simple_case_expression3231	= { FOLLOW_nested_expression_in_simple_case_expression3231_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_when_in_simple_case_expression3235  */
static	ANTLR3_BITWORD FOLLOW_k_when_in_simple_case_expression3235_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_when_in_simple_case_expression3235	= { FOLLOW_k_when_in_simple_case_expression3235_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_expression_in_simple_case_expression3237  */
static	ANTLR3_BITWORD FOLLOW_nested_expression_in_simple_case_expression3237_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_expression_in_simple_case_expression3237	= { FOLLOW_nested_expression_in_simple_case_expression3237_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_then_in_simple_case_expression3239  */
static	ANTLR3_BITWORD FOLLOW_r_then_in_simple_case_expression3239_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_then_in_simple_case_expression3239	= { FOLLOW_r_then_in_simple_case_expression3239_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_expression_in_simple_case_expression3241  */
static	ANTLR3_BITWORD FOLLOW_nested_expression_in_simple_case_expression3241_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_expression_in_simple_case_expression3241	= { FOLLOW_nested_expression_in_simple_case_expression3241_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_when_in_searched_case_expression3256  */
static	ANTLR3_BITWORD FOLLOW_k_when_in_searched_case_expression3256_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_when_in_searched_case_expression3256	= { FOLLOW_k_when_in_searched_case_expression3256_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_searched_case_expression3258  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_searched_case_expression3258_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_searched_case_expression3258	= { FOLLOW_sql_condition_in_searched_case_expression3258_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_then_in_searched_case_expression3260  */
static	ANTLR3_BITWORD FOLLOW_r_then_in_searched_case_expression3260_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_then_in_searched_case_expression3260	= { FOLLOW_r_then_in_searched_case_expression3260_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_expression_in_searched_case_expression3262  */
static	ANTLR3_BITWORD FOLLOW_nested_expression_in_searched_case_expression3262_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_expression_in_searched_case_expression3262	= { FOLLOW_nested_expression_in_searched_case_expression3262_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_else_in_else_case_expression3275  */
static	ANTLR3_BITWORD FOLLOW_r_else_in_else_case_expression3275_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_else_in_else_case_expression3275	= { FOLLOW_r_else_in_else_case_expression3275_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_expression_in_else_case_expression3277  */
static	ANTLR3_BITWORD FOLLOW_nested_expression_in_else_case_expression3277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_expression_in_else_case_expression3277	= { FOLLOW_nested_expression_in_else_case_expression3277_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_object_access_expression3293  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_object_access_expression3293_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_object_access_expression3293	= { FOLLOW_LPAREN_in_object_access_expression3293_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_object_access_expression3295  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_object_access_expression3295_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_object_access_expression3295	= { FOLLOW_sql_expression_in_object_access_expression3295_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_object_access_expression3297  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_object_access_expression3297_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_object_access_expression3297	= { FOLLOW_RPAREN_in_object_access_expression3297_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_object_access_expression3299  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_object_access_expression3299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_object_access_expression3299	= { FOLLOW_DOT_in_object_access_expression3299_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_object_access_expression3304  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_object_access_expression3304_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_object_access_expression3304	= { FOLLOW_sql_identifier_in_object_access_expression3304_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_object_access_expression3307  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_object_access_expression3307_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_object_access_expression3307	= { FOLLOW_DOT_in_object_access_expression3307_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_expression_in_object_access_expression3312  */
static	ANTLR3_BITWORD FOLLOW_function_expression_in_object_access_expression3312_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_function_expression_in_object_access_expression3312	= { FOLLOW_function_expression_in_object_access_expression3312_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_object_access_expression3314  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_object_access_expression3314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_object_access_expression3314	= { FOLLOW_DOT_in_object_access_expression3314_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_object_access_expression3321  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_object_access_expression3321_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_object_access_expression3321	= { FOLLOW_identifier_in_object_access_expression3321_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_object_access_expression3324  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_object_access_expression3324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_object_access_expression3324	= { FOLLOW_DOT_in_object_access_expression3324_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_expression_in_object_access_expression3329  */
static	ANTLR3_BITWORD FOLLOW_function_expression_in_object_access_expression3329_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_function_expression_in_object_access_expression3329	= { FOLLOW_function_expression_in_object_access_expression3329_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boolean_literal_in_simple_expression3339  */
static	ANTLR3_BITWORD FOLLOW_boolean_literal_in_simple_expression3339_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boolean_literal_in_simple_expression3339	= { FOLLOW_boolean_literal_in_simple_expression3339_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_sql_in_simple_expression3344  */
static	ANTLR3_BITWORD FOLLOW_k_sql_in_simple_expression3344_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000007C00) };
static  ANTLR3_BITSET_LIST FOLLOW_k_sql_in_simple_expression3344	= { FOLLOW_k_sql_in_simple_expression3344_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_simple_expression3346  */
static	ANTLR3_BITWORD FOLLOW_set_in_simple_expression3346_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_simple_expression3346	= { FOLLOW_set_in_simple_expression3346_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cell_assignment_in_simple_expression3379  */
static	ANTLR3_BITWORD FOLLOW_cell_assignment_in_simple_expression3379_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cell_assignment_in_simple_expression3379	= { FOLLOW_cell_assignment_in_simple_expression3379_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_simple_expression3393  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_simple_expression3393_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_simple_expression3393	= { FOLLOW_column_spec_in_simple_expression3393_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_timestamp_expression_in_simple_expression3398  */
static	ANTLR3_BITWORD FOLLOW_timestamp_expression_in_simple_expression3398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_timestamp_expression_in_simple_expression3398	= { FOLLOW_timestamp_expression_in_simple_expression3398_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_simple_expression3411  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_simple_expression3411_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_simple_expression3411	= { FOLLOW_quoted_string_in_simple_expression3411_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_simple_expression3416  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_simple_expression3416_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_simple_expression3416	= { FOLLOW_NUMBER_in_simple_expression3416_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_select_in_query_block3434  */
static	ANTLR3_BITWORD FOLLOW_r_select_in_query_block3434_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_select_in_query_block3434	= { FOLLOW_r_select_in_query_block3434_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_distinct_in_query_block3440  */
static	ANTLR3_BITWORD FOLLOW_r_distinct_in_query_block3440_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_distinct_in_query_block3440	= { FOLLOW_r_distinct_in_query_block3440_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_unique_in_query_block3444  */
static	ANTLR3_BITWORD FOLLOW_r_unique_in_query_block3444_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_unique_in_query_block3444	= { FOLLOW_r_unique_in_query_block3444_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_query_block3448  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_query_block3448_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE016840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_query_block3448	= { FOLLOW_r_all_in_query_block3448_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_list_in_query_block3453  */
static	ANTLR3_BITWORD FOLLOW_select_list_in_query_block3453_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_list_in_query_block3453	= { FOLLOW_select_list_in_query_block3453_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_from_in_query_block3457  */
static	ANTLR3_BITWORD FOLLOW_r_from_in_query_block3457_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_from_in_query_block3457	= { FOLLOW_r_from_in_query_block3457_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_list_in_query_block3459  */
static	ANTLR3_BITWORD FOLLOW_table_reference_list_in_query_block3459_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000003000020), ANTLR3_UINT64_LIT(0x0000000800008000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_list_in_query_block3459	= { FOLLOW_table_reference_list_in_query_block3459_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_where_clause_in_query_block3465  */
static	ANTLR3_BITWORD FOLLOW_where_clause_in_query_block3465_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000003000020), ANTLR3_UINT64_LIT(0x0000000000008000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_where_clause_in_query_block3465	= { FOLLOW_where_clause_in_query_block3465_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_hierarchical_query_clause_in_query_block3474  */
static	ANTLR3_BITWORD FOLLOW_hierarchical_query_clause_in_query_block3474_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000003000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_hierarchical_query_clause_in_query_block3474	= { FOLLOW_hierarchical_query_clause_in_query_block3474_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_clause_in_query_block3483  */
static	ANTLR3_BITWORD FOLLOW_group_by_clause_in_query_block3483_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_clause_in_query_block3483	= { FOLLOW_group_by_clause_in_query_block3483_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_clause_in_query_block3513  */
static	ANTLR3_BITWORD FOLLOW_model_clause_in_query_block3513_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_model_clause_in_query_block3513	= { FOLLOW_model_clause_in_query_block3513_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_subquery3527  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_subquery3527_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_subquery3527	= { FOLLOW_LPAREN_in_subquery3527_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_subquery3529  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_subquery3529_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_subquery3529	= { FOLLOW_select_statement_in_subquery3529_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_subquery3531  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_subquery3531_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040403200000), ANTLR3_UINT64_LIT(0x0000000002000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_subquery3531	= { FOLLOW_RPAREN_in_subquery3531_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_clause_in_subquery3543  */
static	ANTLR3_BITWORD FOLLOW_group_by_clause_in_subquery3543_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_clause_in_subquery3543	= { FOLLOW_group_by_clause_in_subquery3543_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_clause_in_subquery3573  */
static	ANTLR3_BITWORD FOLLOW_model_clause_in_subquery3573_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_model_clause_in_subquery3573	= { FOLLOW_model_clause_in_subquery3573_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_union_clause_in_subquery3588  */
static	ANTLR3_BITWORD FOLLOW_union_clause_in_subquery3588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_union_clause_in_subquery3588	= { FOLLOW_union_clause_in_subquery3588_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_subquery3605  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_subquery3605_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_subquery3605	= { FOLLOW_for_update_clause_in_subquery3605_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_subquery3628  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_subquery3628_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_subquery3628	= { FOLLOW_order_by_clause_in_subquery3628_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_subquery3645  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_subquery3645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_subquery3645	= { FOLLOW_for_update_clause_in_subquery3645_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_subquery3653  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_subquery3653_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_subquery3653	= { FOLLOW_LPAREN_in_subquery3653_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_subquery3655  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_subquery3655_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_subquery3655	= { FOLLOW_subquery_in_subquery3655_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_subquery3657  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_subquery3657_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040403200000), ANTLR3_UINT64_LIT(0x0000000002000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_subquery3657	= { FOLLOW_RPAREN_in_subquery3657_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_clause_in_subquery3669  */
static	ANTLR3_BITWORD FOLLOW_group_by_clause_in_subquery3669_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_clause_in_subquery3669	= { FOLLOW_group_by_clause_in_subquery3669_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_clause_in_subquery3699  */
static	ANTLR3_BITWORD FOLLOW_model_clause_in_subquery3699_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_model_clause_in_subquery3699	= { FOLLOW_model_clause_in_subquery3699_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_union_clause_in_subquery3714  */
static	ANTLR3_BITWORD FOLLOW_union_clause_in_subquery3714_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_union_clause_in_subquery3714	= { FOLLOW_union_clause_in_subquery3714_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_subquery3731  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_subquery3731_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_subquery3731	= { FOLLOW_for_update_clause_in_subquery3731_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_subquery3754  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_subquery3754_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_subquery3754	= { FOLLOW_order_by_clause_in_subquery3754_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_subquery3771  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_subquery3771_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_subquery3771	= { FOLLOW_for_update_clause_in_subquery3771_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_date_in_timestamp_expression3794  */
static	ANTLR3_BITWORD FOLLOW_r_date_in_timestamp_expression3794_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800200) };
static  ANTLR3_BITSET_LIST FOLLOW_r_date_in_timestamp_expression3794	= { FOLLOW_r_date_in_timestamp_expression3794_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timestamp_in_timestamp_expression3798  */
static	ANTLR3_BITWORD FOLLOW_k_timestamp_in_timestamp_expression3798_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800200) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timestamp_in_timestamp_expression3798	= { FOLLOW_k_timestamp_in_timestamp_expression3798_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_timestamp_expression3801  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_timestamp_expression3801_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_timestamp_expression3801	= { FOLLOW_quoted_string_in_timestamp_expression3801_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_interval_in_interval_x_to_y3814  */
static	ANTLR3_BITWORD FOLLOW_k_interval_in_interval_x_to_y3814_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000870200), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_interval_in_interval_x_to_y3814	= { FOLLOW_k_interval_in_interval_x_to_y3814_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_interval_x_to_y3858  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_interval_x_to_y3858_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_interval_x_to_y3858	= { FOLLOW_quoted_string_in_interval_x_to_y3858_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bind_variable_in_interval_x_to_y3862  */
static	ANTLR3_BITWORD FOLLOW_bind_variable_in_interval_x_to_y3862_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_bind_variable_in_interval_x_to_y3862	= { FOLLOW_bind_variable_in_interval_x_to_y3862_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_interval_x_to_y3883  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_interval_x_to_y3883_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_interval_x_to_y3883	= { FOLLOW_k_year_in_interval_x_to_y3883_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_month_in_interval_x_to_y3887  */
static	ANTLR3_BITWORD FOLLOW_k_month_in_interval_x_to_y3887_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_month_in_interval_x_to_y3887	= { FOLLOW_k_month_in_interval_x_to_y3887_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_interval_x_to_y3909  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_interval_x_to_y3909_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_interval_x_to_y3909	= { FOLLOW_LPAREN_in_interval_x_to_y3909_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_precision_in_interval_x_to_y3911  */
static	ANTLR3_BITWORD FOLLOW_precision_in_interval_x_to_y3911_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_precision_in_interval_x_to_y3911	= { FOLLOW_precision_in_interval_x_to_y3911_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_interval_x_to_y3913  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_interval_x_to_y3913_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_interval_x_to_y3913	= { FOLLOW_RPAREN_in_interval_x_to_y3913_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_to_in_interval_x_to_y3936  */
static	ANTLR3_BITWORD FOLLOW_k_to_in_interval_x_to_y3936_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_to_in_interval_x_to_y3936	= { FOLLOW_k_to_in_interval_x_to_y3936_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_interval_x_to_y3939  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_interval_x_to_y3939_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_interval_x_to_y3939	= { FOLLOW_k_year_in_interval_x_to_y3939_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_month_in_interval_x_to_y3943  */
static	ANTLR3_BITWORD FOLLOW_k_month_in_interval_x_to_y3943_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_month_in_interval_x_to_y3943	= { FOLLOW_k_month_in_interval_x_to_y3943_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_interval_x_to_y4008  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_interval_x_to_y4008_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_interval_x_to_y4008	= { FOLLOW_quoted_string_in_interval_x_to_y4008_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bind_variable_in_interval_x_to_y4012  */
static	ANTLR3_BITWORD FOLLOW_bind_variable_in_interval_x_to_y4012_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_bind_variable_in_interval_x_to_y4012	= { FOLLOW_bind_variable_in_interval_x_to_y4012_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_day_in_interval_x_to_y4033  */
static	ANTLR3_BITWORD FOLLOW_k_day_in_interval_x_to_y4033_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_day_in_interval_x_to_y4033	= { FOLLOW_k_day_in_interval_x_to_y4033_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_hour_in_interval_x_to_y4037  */
static	ANTLR3_BITWORD FOLLOW_k_hour_in_interval_x_to_y4037_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_hour_in_interval_x_to_y4037	= { FOLLOW_k_hour_in_interval_x_to_y4037_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_minute_in_interval_x_to_y4041  */
static	ANTLR3_BITWORD FOLLOW_k_minute_in_interval_x_to_y4041_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_minute_in_interval_x_to_y4041	= { FOLLOW_k_minute_in_interval_x_to_y4041_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_second_in_interval_x_to_y4045  */
static	ANTLR3_BITWORD FOLLOW_k_second_in_interval_x_to_y4045_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_second_in_interval_x_to_y4045	= { FOLLOW_k_second_in_interval_x_to_y4045_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_interval_x_to_y4066  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_interval_x_to_y4066_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_interval_x_to_y4066	= { FOLLOW_LPAREN_in_interval_x_to_y4066_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_precision_in_interval_x_to_y4068  */
static	ANTLR3_BITWORD FOLLOW_precision_in_interval_x_to_y4068_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_precision_in_interval_x_to_y4068	= { FOLLOW_precision_in_interval_x_to_y4068_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_interval_x_to_y4071  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_interval_x_to_y4071_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_interval_x_to_y4071	= { FOLLOW_COMMA_in_interval_x_to_y4071_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_precision_in_interval_x_to_y4073  */
static	ANTLR3_BITWORD FOLLOW_precision_in_interval_x_to_y4073_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_precision_in_interval_x_to_y4073	= { FOLLOW_precision_in_interval_x_to_y4073_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_interval_x_to_y4077  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_interval_x_to_y4077_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_interval_x_to_y4077	= { FOLLOW_RPAREN_in_interval_x_to_y4077_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_to_in_interval_x_to_y4098  */
static	ANTLR3_BITWORD FOLLOW_k_to_in_interval_x_to_y4098_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_to_in_interval_x_to_y4098	= { FOLLOW_k_to_in_interval_x_to_y4098_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_day_in_interval_x_to_y4102  */
static	ANTLR3_BITWORD FOLLOW_k_day_in_interval_x_to_y4102_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_day_in_interval_x_to_y4102	= { FOLLOW_k_day_in_interval_x_to_y4102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_hour_in_interval_x_to_y4106  */
static	ANTLR3_BITWORD FOLLOW_k_hour_in_interval_x_to_y4106_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_hour_in_interval_x_to_y4106	= { FOLLOW_k_hour_in_interval_x_to_y4106_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_minute_in_interval_x_to_y4110  */
static	ANTLR3_BITWORD FOLLOW_k_minute_in_interval_x_to_y4110_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_minute_in_interval_x_to_y4110	= { FOLLOW_k_minute_in_interval_x_to_y4110_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_second_in_interval_x_to_y4114  */
static	ANTLR3_BITWORD FOLLOW_k_second_in_interval_x_to_y4114_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_second_in_interval_x_to_y4114	= { FOLLOW_k_second_in_interval_x_to_y4114_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_interval_x_to_y4119  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_interval_x_to_y4119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_interval_x_to_y4119	= { FOLLOW_LPAREN_in_interval_x_to_y4119_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_precision_in_interval_x_to_y4121  */
static	ANTLR3_BITWORD FOLLOW_precision_in_interval_x_to_y4121_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_precision_in_interval_x_to_y4121	= { FOLLOW_precision_in_interval_x_to_y4121_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_interval_x_to_y4123  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_interval_x_to_y4123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_interval_x_to_y4123	= { FOLLOW_RPAREN_in_interval_x_to_y4123_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_precision4162  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_precision4162_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_precision4162	= { FOLLOW_NUMBER_in_precision4162_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bind_variable_in_precision4170  */
static	ANTLR3_BITWORD FOLLOW_bind_variable_in_precision4170_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bind_variable_in_precision4170	= { FOLLOW_bind_variable_in_precision4170_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_extract_in_extract_datetime_expression4181  */
static	ANTLR3_BITWORD FOLLOW_k_extract_in_extract_datetime_expression4181_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_extract_in_extract_datetime_expression4181	= { FOLLOW_k_extract_in_extract_datetime_expression4181_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_extract_datetime_expression4191  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_extract_datetime_expression4191_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_extract_datetime_expression4191	= { FOLLOW_LPAREN_in_extract_datetime_expression4191_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_extract_datetime_expression4203  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_extract_datetime_expression4203_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_extract_datetime_expression4203	= { FOLLOW_k_year_in_extract_datetime_expression4203_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_month_in_extract_datetime_expression4215  */
static	ANTLR3_BITWORD FOLLOW_k_month_in_extract_datetime_expression4215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_month_in_extract_datetime_expression4215	= { FOLLOW_k_month_in_extract_datetime_expression4215_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_day_in_extract_datetime_expression4227  */
static	ANTLR3_BITWORD FOLLOW_k_day_in_extract_datetime_expression4227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_day_in_extract_datetime_expression4227	= { FOLLOW_k_day_in_extract_datetime_expression4227_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_hour_in_extract_datetime_expression4239  */
static	ANTLR3_BITWORD FOLLOW_k_hour_in_extract_datetime_expression4239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_hour_in_extract_datetime_expression4239	= { FOLLOW_k_hour_in_extract_datetime_expression4239_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_minute_in_extract_datetime_expression4251  */
static	ANTLR3_BITWORD FOLLOW_k_minute_in_extract_datetime_expression4251_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_minute_in_extract_datetime_expression4251	= { FOLLOW_k_minute_in_extract_datetime_expression4251_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_second_in_extract_datetime_expression4263  */
static	ANTLR3_BITWORD FOLLOW_k_second_in_extract_datetime_expression4263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_second_in_extract_datetime_expression4263	= { FOLLOW_k_second_in_extract_datetime_expression4263_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timezone_hour_in_extract_datetime_expression4275  */
static	ANTLR3_BITWORD FOLLOW_k_timezone_hour_in_extract_datetime_expression4275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timezone_hour_in_extract_datetime_expression4275	= { FOLLOW_k_timezone_hour_in_extract_datetime_expression4275_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timezone_minute_in_extract_datetime_expression4287  */
static	ANTLR3_BITWORD FOLLOW_k_timezone_minute_in_extract_datetime_expression4287_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timezone_minute_in_extract_datetime_expression4287	= { FOLLOW_k_timezone_minute_in_extract_datetime_expression4287_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timezone_region_in_extract_datetime_expression4299  */
static	ANTLR3_BITWORD FOLLOW_k_timezone_region_in_extract_datetime_expression4299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timezone_region_in_extract_datetime_expression4299	= { FOLLOW_k_timezone_region_in_extract_datetime_expression4299_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timezone_abbr_in_extract_datetime_expression4311  */
static	ANTLR3_BITWORD FOLLOW_k_timezone_abbr_in_extract_datetime_expression4311_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timezone_abbr_in_extract_datetime_expression4311	= { FOLLOW_k_timezone_abbr_in_extract_datetime_expression4311_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_from_in_extract_datetime_expression4331  */
static	ANTLR3_BITWORD FOLLOW_r_from_in_extract_datetime_expression4331_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_from_in_extract_datetime_expression4331	= { FOLLOW_r_from_in_extract_datetime_expression4331_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_extract_datetime_expression4341  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_extract_datetime_expression4341_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_extract_datetime_expression4341	= { FOLLOW_sql_expression_in_extract_datetime_expression4341_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_extract_datetime_expression4351  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_extract_datetime_expression4351_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_extract_datetime_expression4351	= { FOLLOW_RPAREN_in_extract_datetime_expression4351_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_expression_in_datetime_expression4374  */
static	ANTLR3_BITWORD FOLLOW_function_expression_in_datetime_expression4374_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_function_expression_in_datetime_expression4374	= { FOLLOW_function_expression_in_datetime_expression4374_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cast_expression_in_datetime_expression4378  */
static	ANTLR3_BITWORD FOLLOW_cast_expression_in_datetime_expression4378_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_cast_expression_in_datetime_expression4378	= { FOLLOW_cast_expression_in_datetime_expression4378_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simple_expression_in_datetime_expression4382  */
static	ANTLR3_BITWORD FOLLOW_simple_expression_in_datetime_expression4382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_simple_expression_in_datetime_expression4382	= { FOLLOW_simple_expression_in_datetime_expression4382_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_at_in_datetime_expression4394  */
static	ANTLR3_BITWORD FOLLOW_k_at_in_datetime_expression4394_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_at_in_datetime_expression4394	= { FOLLOW_k_at_in_datetime_expression4394_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_local_in_datetime_expression4397  */
static	ANTLR3_BITWORD FOLLOW_k_local_in_datetime_expression4397_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_local_in_datetime_expression4397	= { FOLLOW_k_local_in_datetime_expression4397_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_time_in_datetime_expression4401  */
static	ANTLR3_BITWORD FOLLOW_k_time_in_datetime_expression4401_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_time_in_datetime_expression4401	= { FOLLOW_k_time_in_datetime_expression4401_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_zone_in_datetime_expression4403  */
static	ANTLR3_BITWORD FOLLOW_k_zone_in_datetime_expression4403_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_zone_in_datetime_expression4403	= { FOLLOW_k_zone_in_datetime_expression4403_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_datetime_expression4407  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_datetime_expression4407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_datetime_expression4407	= { FOLLOW_quoted_string_in_datetime_expression4407_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dbtimezone_in_datetime_expression4411  */
static	ANTLR3_BITWORD FOLLOW_k_dbtimezone_in_datetime_expression4411_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dbtimezone_in_datetime_expression4411	= { FOLLOW_k_dbtimezone_in_datetime_expression4411_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_sessiontimezone_in_datetime_expression4415  */
static	ANTLR3_BITWORD FOLLOW_k_sessiontimezone_in_datetime_expression4415_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_sessiontimezone_in_datetime_expression4415	= { FOLLOW_k_sessiontimezone_in_datetime_expression4415_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_datetime_expression4419  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_datetime_expression4419_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_datetime_expression4419	= { FOLLOW_sql_expression_in_datetime_expression4419_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_interval_expression4433  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_interval_expression4433_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000870204), ANTLR3_UINT64_LIT(0x0004002000040100), ANTLR3_UINT64_LIT(0xBAD3966010840050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_interval_expression4433	= { FOLLOW_LPAREN_in_interval_expression4433_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_expression_in_interval_expression4437  */
static	ANTLR3_BITWORD FOLLOW_function_expression_in_interval_expression4437_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_function_expression_in_interval_expression4437	= { FOLLOW_function_expression_in_interval_expression4437_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cast_expression_in_interval_expression4441  */
static	ANTLR3_BITWORD FOLLOW_cast_expression_in_interval_expression4441_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_cast_expression_in_interval_expression4441	= { FOLLOW_cast_expression_in_interval_expression4441_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simple_expression_in_interval_expression4445  */
static	ANTLR3_BITWORD FOLLOW_simple_expression_in_interval_expression4445_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_simple_expression_in_interval_expression4445	= { FOLLOW_simple_expression_in_interval_expression4445_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_in_interval_expression4449  */
static	ANTLR3_BITWORD FOLLOW_MINUS_in_interval_expression4449_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000870204), ANTLR3_UINT64_LIT(0x0004002000040100), ANTLR3_UINT64_LIT(0xBAD3966010840050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_in_interval_expression4449	= { FOLLOW_MINUS_in_interval_expression4449_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_expression_in_interval_expression4453  */
static	ANTLR3_BITWORD FOLLOW_function_expression_in_interval_expression4453_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_function_expression_in_interval_expression4453	= { FOLLOW_function_expression_in_interval_expression4453_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cast_expression_in_interval_expression4457  */
static	ANTLR3_BITWORD FOLLOW_cast_expression_in_interval_expression4457_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_cast_expression_in_interval_expression4457	= { FOLLOW_cast_expression_in_interval_expression4457_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simple_expression_in_interval_expression4461  */
static	ANTLR3_BITWORD FOLLOW_simple_expression_in_interval_expression4461_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_simple_expression_in_interval_expression4461	= { FOLLOW_simple_expression_in_interval_expression4461_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_interval_expression4465  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_interval_expression4465_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_interval_expression4465	= { FOLLOW_RPAREN_in_interval_expression4465_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_day_in_interval_expression4471  */
static	ANTLR3_BITWORD FOLLOW_k_day_in_interval_expression4471_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_day_in_interval_expression4471	= { FOLLOW_k_day_in_interval_expression4471_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_interval_expression4474  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_interval_expression4474_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_interval_expression4474	= { FOLLOW_LPAREN_in_interval_expression4474_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_interval_expression4476  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_interval_expression4476_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_interval_expression4476	= { FOLLOW_NUMBER_in_interval_expression4476_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_interval_expression4478  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_interval_expression4478_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_interval_expression4478	= { FOLLOW_RPAREN_in_interval_expression4478_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_to_in_interval_expression4482  */
static	ANTLR3_BITWORD FOLLOW_r_to_in_interval_expression4482_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_to_in_interval_expression4482	= { FOLLOW_r_to_in_interval_expression4482_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_second_in_interval_expression4484  */
static	ANTLR3_BITWORD FOLLOW_k_second_in_interval_expression4484_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_second_in_interval_expression4484	= { FOLLOW_k_second_in_interval_expression4484_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_interval_expression4487  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_interval_expression4487_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_interval_expression4487	= { FOLLOW_LPAREN_in_interval_expression4487_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_interval_expression4489  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_interval_expression4489_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_interval_expression4489	= { FOLLOW_NUMBER_in_interval_expression4489_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_interval_expression4491  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_interval_expression4491_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_interval_expression4491	= { FOLLOW_RPAREN_in_interval_expression4491_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_interval_expression4499  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_interval_expression4499_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_interval_expression4499	= { FOLLOW_k_year_in_interval_expression4499_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_interval_expression4502  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_interval_expression4502_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_interval_expression4502	= { FOLLOW_LPAREN_in_interval_expression4502_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_interval_expression4504  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_interval_expression4504_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_interval_expression4504	= { FOLLOW_NUMBER_in_interval_expression4504_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_interval_expression4506  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_interval_expression4506_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_interval_expression4506	= { FOLLOW_RPAREN_in_interval_expression4506_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_to_in_interval_expression4510  */
static	ANTLR3_BITWORD FOLLOW_r_to_in_interval_expression4510_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_to_in_interval_expression4510	= { FOLLOW_r_to_in_interval_expression4510_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_month_in_interval_expression4512  */
static	ANTLR3_BITWORD FOLLOW_k_month_in_interval_expression4512_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_month_in_interval_expression4512	= { FOLLOW_k_month_in_interval_expression4512_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_interval_expression4515  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_interval_expression4515_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_interval_expression4515	= { FOLLOW_LPAREN_in_interval_expression4515_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_interval_expression4517  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_interval_expression4517_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_interval_expression4517	= { FOLLOW_NUMBER_in_interval_expression4517_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_interval_expression4519  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_interval_expression4519_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_interval_expression4519	= { FOLLOW_RPAREN_in_interval_expression4519_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cluster_set_clause_in_special_expression4537  */
static	ANTLR3_BITWORD FOLLOW_cluster_set_clause_in_special_expression4537_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cluster_set_clause_in_special_expression4537	= { FOLLOW_cluster_set_clause_in_special_expression4537_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_cluster_set_in_cluster_set_clause4555  */
static	ANTLR3_BITWORD FOLLOW_k_cluster_set_in_cluster_set_clause4555_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_cluster_set_in_cluster_set_clause4555	= { FOLLOW_k_cluster_set_in_cluster_set_clause4555_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_cluster_set_clause4557  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_cluster_set_clause4557_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_cluster_set_clause4557	= { FOLLOW_LPAREN_in_cluster_set_clause4557_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_cluster_set_clause4559  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_cluster_set_clause4559_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_cluster_set_clause4559	= { FOLLOW_column_spec_in_cluster_set_clause4559_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_cluster_set_clause4562  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_cluster_set_clause4562_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_cluster_set_clause4562	= { FOLLOW_COMMA_in_cluster_set_clause4562_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_cluster_set_clause4564  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_cluster_set_clause4564_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_cluster_set_clause4564	= { FOLLOW_column_spec_in_cluster_set_clause4564_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_cluster_set_clause4569  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_cluster_set_clause4569_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_cluster_set_clause4569	= { FOLLOW_COMMA_in_cluster_set_clause4569_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_cluster_set_clause4571  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_cluster_set_clause4571_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_cluster_set_clause4571	= { FOLLOW_NUMBER_in_cluster_set_clause4571_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_using_in_cluster_set_clause4575  */
static	ANTLR3_BITWORD FOLLOW_k_using_in_cluster_set_clause4575_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070008), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_using_in_cluster_set_clause4575	= { FOLLOW_k_using_in_cluster_set_clause4575_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_specs_in_cluster_set_clause4578  */
static	ANTLR3_BITWORD FOLLOW_column_specs_in_cluster_set_clause4578_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_specs_in_cluster_set_clause4578	= { FOLLOW_column_specs_in_cluster_set_clause4578_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASTERISK_in_cluster_set_clause4580  */
static	ANTLR3_BITWORD FOLLOW_ASTERISK_in_cluster_set_clause4580_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ASTERISK_in_cluster_set_clause4580	= { FOLLOW_ASTERISK_in_cluster_set_clause4580_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_cluster_set_clause4583  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_cluster_set_clause4583_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_cluster_set_clause4583	= { FOLLOW_RPAREN_in_cluster_set_clause4583_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_cast_in_cast_expression4594  */
static	ANTLR3_BITWORD FOLLOW_k_cast_in_cast_expression4594_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_cast_in_cast_expression4594	= { FOLLOW_k_cast_in_cast_expression4594_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_cast_expression4596  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_cast_expression4596_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B6) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_cast_expression4596	= { FOLLOW_LPAREN_in_cast_expression4596_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_cast_expression4599  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_cast_expression4599_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_cast_expression4599	= { FOLLOW_sql_expression_in_cast_expression4599_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_multiset_in_cast_expression4603  */
static	ANTLR3_BITWORD FOLLOW_k_multiset_in_cast_expression4603_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_multiset_in_cast_expression4603	= { FOLLOW_k_multiset_in_cast_expression4603_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_cast_expression4605  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_cast_expression4605_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_cast_expression4605	= { FOLLOW_subquery_in_cast_expression4605_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_as_in_cast_expression4608  */
static	ANTLR3_BITWORD FOLLOW_r_as_in_cast_expression4608_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xC000000000070000), ANTLR3_UINT64_LIT(0x800C012200100300), ANTLR3_UINT64_LIT(0xBAD3962190042050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_as_in_cast_expression4608	= { FOLLOW_r_as_in_cast_expression4608_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatype_name_in_cast_expression4611  */
static	ANTLR3_BITWORD FOLLOW_datatype_name_in_cast_expression4611_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatype_name_in_cast_expression4611	= { FOLLOW_datatype_name_in_cast_expression4611_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_cast_expression4613  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_cast_expression4613_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_cast_expression4613	= { FOLLOW_column_spec_in_cast_expression4613_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_cast_expression4616  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_cast_expression4616_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_cast_expression4616	= { FOLLOW_RPAREN_in_cast_expression4616_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_binary_integer_in_datatype_name4627  */
static	ANTLR3_BITWORD FOLLOW_k_binary_integer_in_datatype_name4627_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_binary_integer_in_datatype_name4627	= { FOLLOW_k_binary_integer_in_datatype_name4627_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_binary_float_in_datatype_name4633  */
static	ANTLR3_BITWORD FOLLOW_k_binary_float_in_datatype_name4633_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_binary_float_in_datatype_name4633	= { FOLLOW_k_binary_float_in_datatype_name4633_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_binary_double_in_datatype_name4638  */
static	ANTLR3_BITWORD FOLLOW_k_binary_double_in_datatype_name4638_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_binary_double_in_datatype_name4638	= { FOLLOW_k_binary_double_in_datatype_name4638_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_natural_in_datatype_name4643  */
static	ANTLR3_BITWORD FOLLOW_k_natural_in_datatype_name4643_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_natural_in_datatype_name4643	= { FOLLOW_k_natural_in_datatype_name4643_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_positive_in_datatype_name4648  */
static	ANTLR3_BITWORD FOLLOW_k_positive_in_datatype_name4648_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_positive_in_datatype_name4648	= { FOLLOW_k_positive_in_datatype_name4648_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_number_in_datatype_name4655  */
static	ANTLR3_BITWORD FOLLOW_r_number_in_datatype_name4655_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_number_in_datatype_name4655	= { FOLLOW_r_number_in_datatype_name4655_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_numeric_in_datatype_name4659  */
static	ANTLR3_BITWORD FOLLOW_k_numeric_in_datatype_name4659_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_numeric_in_datatype_name4659	= { FOLLOW_k_numeric_in_datatype_name4659_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_decimal_in_datatype_name4663  */
static	ANTLR3_BITWORD FOLLOW_r_decimal_in_datatype_name4663_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_decimal_in_datatype_name4663	= { FOLLOW_r_decimal_in_datatype_name4663_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dec_in_datatype_name4667  */
static	ANTLR3_BITWORD FOLLOW_k_dec_in_datatype_name4667_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dec_in_datatype_name4667	= { FOLLOW_k_dec_in_datatype_name4667_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name4673  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name4673_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name4673	= { FOLLOW_LPAREN_in_datatype_name4673_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4675  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4675_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4675	= { FOLLOW_NUMBER_in_datatype_name4675_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_datatype_name4679  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_datatype_name4679_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_datatype_name4679	= { FOLLOW_COMMA_in_datatype_name4679_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4681  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4681_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4681	= { FOLLOW_NUMBER_in_datatype_name4681_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name4686  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name4686_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name4686	= { FOLLOW_RPAREN_in_datatype_name4686_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_long_in_datatype_name4694  */
static	ANTLR3_BITWORD FOLLOW_r_long_in_datatype_name4694_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_long_in_datatype_name4694	= { FOLLOW_r_long_in_datatype_name4694_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_raw_in_datatype_name4698  */
static	ANTLR3_BITWORD FOLLOW_r_raw_in_datatype_name4698_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_raw_in_datatype_name4698	= { FOLLOW_r_raw_in_datatype_name4698_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name4704  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name4704_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name4704	= { FOLLOW_LPAREN_in_datatype_name4704_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4706  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4706_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4706	= { FOLLOW_NUMBER_in_datatype_name4706_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name4708  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name4708_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name4708	= { FOLLOW_RPAREN_in_datatype_name4708_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_raw_in_datatype_name4716  */
static	ANTLR3_BITWORD FOLLOW_r_raw_in_datatype_name4716_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_raw_in_datatype_name4716	= { FOLLOW_r_raw_in_datatype_name4716_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name4720  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name4720_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name4720	= { FOLLOW_LPAREN_in_datatype_name4720_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4722  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4722_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4722	= { FOLLOW_NUMBER_in_datatype_name4722_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name4724  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name4724_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name4724	= { FOLLOW_RPAREN_in_datatype_name4724_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_boolean_in_datatype_name4732  */
static	ANTLR3_BITWORD FOLLOW_k_boolean_in_datatype_name4732_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_boolean_in_datatype_name4732	= { FOLLOW_k_boolean_in_datatype_name4732_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_date_in_datatype_name4737  */
static	ANTLR3_BITWORD FOLLOW_r_date_in_datatype_name4737_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_date_in_datatype_name4737	= { FOLLOW_r_date_in_datatype_name4737_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_interval_in_datatype_name4742  */
static	ANTLR3_BITWORD FOLLOW_k_interval_in_datatype_name4742_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_interval_in_datatype_name4742	= { FOLLOW_k_interval_in_datatype_name4742_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_day_in_datatype_name4744  */
static	ANTLR3_BITWORD FOLLOW_k_day_in_datatype_name4744_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_day_in_datatype_name4744	= { FOLLOW_k_day_in_datatype_name4744_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name4748  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name4748_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name4748	= { FOLLOW_LPAREN_in_datatype_name4748_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4750  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4750_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4750	= { FOLLOW_NUMBER_in_datatype_name4750_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name4752  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name4752_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name4752	= { FOLLOW_RPAREN_in_datatype_name4752_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_to_in_datatype_name4757  */
static	ANTLR3_BITWORD FOLLOW_r_to_in_datatype_name4757_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_to_in_datatype_name4757	= { FOLLOW_r_to_in_datatype_name4757_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_second_in_datatype_name4759  */
static	ANTLR3_BITWORD FOLLOW_k_second_in_datatype_name4759_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_second_in_datatype_name4759	= { FOLLOW_k_second_in_datatype_name4759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name4763  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name4763_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name4763	= { FOLLOW_LPAREN_in_datatype_name4763_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4765  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4765_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4765	= { FOLLOW_NUMBER_in_datatype_name4765_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name4767  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name4767_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name4767	= { FOLLOW_RPAREN_in_datatype_name4767_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_interval_in_datatype_name4775  */
static	ANTLR3_BITWORD FOLLOW_k_interval_in_datatype_name4775_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_interval_in_datatype_name4775	= { FOLLOW_k_interval_in_datatype_name4775_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_datatype_name4777  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_datatype_name4777_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_datatype_name4777	= { FOLLOW_k_year_in_datatype_name4777_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name4781  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name4781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name4781	= { FOLLOW_LPAREN_in_datatype_name4781_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4783  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4783_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4783	= { FOLLOW_NUMBER_in_datatype_name4783_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name4785  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name4785_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name4785	= { FOLLOW_RPAREN_in_datatype_name4785_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_to_in_datatype_name4790  */
static	ANTLR3_BITWORD FOLLOW_r_to_in_datatype_name4790_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_to_in_datatype_name4790	= { FOLLOW_r_to_in_datatype_name4790_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_month_in_datatype_name4792  */
static	ANTLR3_BITWORD FOLLOW_k_month_in_datatype_name4792_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_month_in_datatype_name4792	= { FOLLOW_k_month_in_datatype_name4792_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_time_in_datatype_name4799  */
static	ANTLR3_BITWORD FOLLOW_k_time_in_datatype_name4799_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_time_in_datatype_name4799	= { FOLLOW_k_time_in_datatype_name4799_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timestamp_in_datatype_name4803  */
static	ANTLR3_BITWORD FOLLOW_k_timestamp_in_datatype_name4803_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timestamp_in_datatype_name4803	= { FOLLOW_k_timestamp_in_datatype_name4803_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name4809  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name4809_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name4809	= { FOLLOW_LPAREN_in_datatype_name4809_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4811  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4811_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4811	= { FOLLOW_NUMBER_in_datatype_name4811_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name4813  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name4813_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name4813	= { FOLLOW_RPAREN_in_datatype_name4813_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_with_in_datatype_name4820  */
static	ANTLR3_BITWORD FOLLOW_r_with_in_datatype_name4820_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_with_in_datatype_name4820	= { FOLLOW_r_with_in_datatype_name4820_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_local_in_datatype_name4824  */
static	ANTLR3_BITWORD FOLLOW_k_local_in_datatype_name4824_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_local_in_datatype_name4824	= { FOLLOW_k_local_in_datatype_name4824_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_time_in_datatype_name4829  */
static	ANTLR3_BITWORD FOLLOW_k_time_in_datatype_name4829_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_time_in_datatype_name4829	= { FOLLOW_k_time_in_datatype_name4829_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_zone_in_datatype_name4831  */
static	ANTLR3_BITWORD FOLLOW_k_zone_in_datatype_name4831_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_zone_in_datatype_name4831	= { FOLLOW_k_zone_in_datatype_name4831_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_integer_in_datatype_name4839  */
static	ANTLR3_BITWORD FOLLOW_r_integer_in_datatype_name4839_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_integer_in_datatype_name4839	= { FOLLOW_r_integer_in_datatype_name4839_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_int_in_datatype_name4844  */
static	ANTLR3_BITWORD FOLLOW_k_int_in_datatype_name4844_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_int_in_datatype_name4844	= { FOLLOW_k_int_in_datatype_name4844_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_smallint_in_datatype_name4849  */
static	ANTLR3_BITWORD FOLLOW_r_smallint_in_datatype_name4849_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_smallint_in_datatype_name4849	= { FOLLOW_r_smallint_in_datatype_name4849_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_float_in_datatype_name4854  */
static	ANTLR3_BITWORD FOLLOW_r_float_in_datatype_name4854_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_float_in_datatype_name4854	= { FOLLOW_r_float_in_datatype_name4854_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name4858  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name4858_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name4858	= { FOLLOW_LPAREN_in_datatype_name4858_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4860  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4860_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4860	= { FOLLOW_NUMBER_in_datatype_name4860_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name4862  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name4862_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name4862	= { FOLLOW_RPAREN_in_datatype_name4862_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_real_in_datatype_name4870  */
static	ANTLR3_BITWORD FOLLOW_k_real_in_datatype_name4870_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_real_in_datatype_name4870	= { FOLLOW_k_real_in_datatype_name4870_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_double_in_datatype_name4875  */
static	ANTLR3_BITWORD FOLLOW_k_double_in_datatype_name4875_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_double_in_datatype_name4875	= { FOLLOW_k_double_in_datatype_name4875_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_precision_in_datatype_name4877  */
static	ANTLR3_BITWORD FOLLOW_k_precision_in_datatype_name4877_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_precision_in_datatype_name4877	= { FOLLOW_k_precision_in_datatype_name4877_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_char_in_datatype_name4882  */
static	ANTLR3_BITWORD FOLLOW_r_char_in_datatype_name4882_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_char_in_datatype_name4882	= { FOLLOW_r_char_in_datatype_name4882_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_varying_in_datatype_name4891  */
static	ANTLR3_BITWORD FOLLOW_k_varying_in_datatype_name4891_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_varying_in_datatype_name4891	= { FOLLOW_k_varying_in_datatype_name4891_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name4898  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name4898_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name4898	= { FOLLOW_LPAREN_in_datatype_name4898_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4900  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4900_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x8000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4900	= { FOLLOW_NUMBER_in_datatype_name4900_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_byte_in_datatype_name4904  */
static	ANTLR3_BITWORD FOLLOW_k_byte_in_datatype_name4904_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_byte_in_datatype_name4904	= { FOLLOW_k_byte_in_datatype_name4904_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_char_in_datatype_name4908  */
static	ANTLR3_BITWORD FOLLOW_r_char_in_datatype_name4908_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_char_in_datatype_name4908	= { FOLLOW_r_char_in_datatype_name4908_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name4913  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name4913_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name4913	= { FOLLOW_RPAREN_in_datatype_name4913_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_character_in_datatype_name4920  */
static	ANTLR3_BITWORD FOLLOW_k_character_in_datatype_name4920_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_k_character_in_datatype_name4920	= { FOLLOW_k_character_in_datatype_name4920_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_datatype_name4922  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_datatype_name4922_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_datatype_name4922	= { FOLLOW_r_set_in_datatype_name4922_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatype_name4926  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatype_name4926_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatype_name4926	= { FOLLOW_identifier_in_datatype_name4926_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_datatype_name4931  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_datatype_name4931_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000008000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_datatype_name4931	= { FOLLOW_column_spec_in_datatype_name4931_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHARSET_ATTR_in_datatype_name4933  */
static	ANTLR3_BITWORD FOLLOW_CHARSET_ATTR_in_datatype_name4933_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHARSET_ATTR_in_datatype_name4933	= { FOLLOW_CHARSET_ATTR_in_datatype_name4933_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_varchar_in_datatype_name4943  */
static	ANTLR3_BITWORD FOLLOW_r_varchar_in_datatype_name4943_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_varchar_in_datatype_name4943	= { FOLLOW_r_varchar_in_datatype_name4943_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name4964  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name4964_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name4964	= { FOLLOW_LPAREN_in_datatype_name4964_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name4966  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name4966_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x8000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name4966	= { FOLLOW_NUMBER_in_datatype_name4966_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_byte_in_datatype_name4970  */
static	ANTLR3_BITWORD FOLLOW_k_byte_in_datatype_name4970_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_byte_in_datatype_name4970	= { FOLLOW_k_byte_in_datatype_name4970_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_char_in_datatype_name4974  */
static	ANTLR3_BITWORD FOLLOW_r_char_in_datatype_name4974_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_char_in_datatype_name4974	= { FOLLOW_r_char_in_datatype_name4974_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name4979  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name4979_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name4979	= { FOLLOW_RPAREN_in_datatype_name4979_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_character_in_datatype_name4986  */
static	ANTLR3_BITWORD FOLLOW_k_character_in_datatype_name4986_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_k_character_in_datatype_name4986	= { FOLLOW_k_character_in_datatype_name4986_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_datatype_name4988  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_datatype_name4988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_datatype_name4988	= { FOLLOW_r_set_in_datatype_name4988_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatype_name4992  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatype_name4992_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatype_name4992	= { FOLLOW_identifier_in_datatype_name4992_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_datatype_name4997  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_datatype_name4997_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000008000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_datatype_name4997	= { FOLLOW_column_spec_in_datatype_name4997_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHARSET_ATTR_in_datatype_name4999  */
static	ANTLR3_BITWORD FOLLOW_CHARSET_ATTR_in_datatype_name4999_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHARSET_ATTR_in_datatype_name4999	= { FOLLOW_CHARSET_ATTR_in_datatype_name4999_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_varchar2_in_datatype_name5009  */
static	ANTLR3_BITWORD FOLLOW_r_varchar2_in_datatype_name5009_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_varchar2_in_datatype_name5009	= { FOLLOW_r_varchar2_in_datatype_name5009_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name5029  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name5029_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name5029	= { FOLLOW_LPAREN_in_datatype_name5029_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name5031  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name5031_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x8000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name5031	= { FOLLOW_NUMBER_in_datatype_name5031_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_byte_in_datatype_name5035  */
static	ANTLR3_BITWORD FOLLOW_k_byte_in_datatype_name5035_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_byte_in_datatype_name5035	= { FOLLOW_k_byte_in_datatype_name5035_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_char_in_datatype_name5039  */
static	ANTLR3_BITWORD FOLLOW_r_char_in_datatype_name5039_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_char_in_datatype_name5039	= { FOLLOW_r_char_in_datatype_name5039_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name5044  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name5044_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name5044	= { FOLLOW_RPAREN_in_datatype_name5044_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_character_in_datatype_name5051  */
static	ANTLR3_BITWORD FOLLOW_k_character_in_datatype_name5051_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_k_character_in_datatype_name5051	= { FOLLOW_k_character_in_datatype_name5051_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_datatype_name5053  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_datatype_name5053_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_datatype_name5053	= { FOLLOW_r_set_in_datatype_name5053_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatype_name5057  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatype_name5057_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatype_name5057	= { FOLLOW_identifier_in_datatype_name5057_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_datatype_name5062  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_datatype_name5062_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000008000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_datatype_name5062	= { FOLLOW_column_spec_in_datatype_name5062_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHARSET_ATTR_in_datatype_name5064  */
static	ANTLR3_BITWORD FOLLOW_CHARSET_ATTR_in_datatype_name5064_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHARSET_ATTR_in_datatype_name5064	= { FOLLOW_CHARSET_ATTR_in_datatype_name5064_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_character_in_datatype_name5074  */
static	ANTLR3_BITWORD FOLLOW_k_character_in_datatype_name5074_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_character_in_datatype_name5074	= { FOLLOW_k_character_in_datatype_name5074_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_varying_in_datatype_name5078  */
static	ANTLR3_BITWORD FOLLOW_k_varying_in_datatype_name5078_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_varying_in_datatype_name5078	= { FOLLOW_k_varying_in_datatype_name5078_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name5085  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name5085_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name5085	= { FOLLOW_LPAREN_in_datatype_name5085_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name5087  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name5087_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name5087	= { FOLLOW_NUMBER_in_datatype_name5087_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name5089  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name5089_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name5089	= { FOLLOW_RPAREN_in_datatype_name5089_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nchar_in_datatype_name5097  */
static	ANTLR3_BITWORD FOLLOW_k_nchar_in_datatype_name5097_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nchar_in_datatype_name5097	= { FOLLOW_k_nchar_in_datatype_name5097_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_varying_in_datatype_name5105  */
static	ANTLR3_BITWORD FOLLOW_k_varying_in_datatype_name5105_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_varying_in_datatype_name5105	= { FOLLOW_k_varying_in_datatype_name5105_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name5112  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name5112_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name5112	= { FOLLOW_LPAREN_in_datatype_name5112_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name5114  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name5114_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name5114	= { FOLLOW_NUMBER_in_datatype_name5114_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name5116  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name5116_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name5116	= { FOLLOW_RPAREN_in_datatype_name5116_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nvarchar_in_datatype_name5124  */
static	ANTLR3_BITWORD FOLLOW_k_nvarchar_in_datatype_name5124_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nvarchar_in_datatype_name5124	= { FOLLOW_k_nvarchar_in_datatype_name5124_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name5129  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name5129_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name5129	= { FOLLOW_LPAREN_in_datatype_name5129_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name5131  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name5131_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name5131	= { FOLLOW_NUMBER_in_datatype_name5131_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name5133  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name5133_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name5133	= { FOLLOW_RPAREN_in_datatype_name5133_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nvarchar2_in_datatype_name5141  */
static	ANTLR3_BITWORD FOLLOW_k_nvarchar2_in_datatype_name5141_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nvarchar2_in_datatype_name5141	= { FOLLOW_k_nvarchar2_in_datatype_name5141_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name5145  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name5145_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name5145	= { FOLLOW_LPAREN_in_datatype_name5145_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name5147  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name5147_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name5147	= { FOLLOW_NUMBER_in_datatype_name5147_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name5149  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name5149_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name5149	= { FOLLOW_RPAREN_in_datatype_name5149_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_national_in_datatype_name5157  */
static	ANTLR3_BITWORD FOLLOW_k_national_in_datatype_name5157_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x8000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_national_in_datatype_name5157	= { FOLLOW_k_national_in_datatype_name5157_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_character_in_datatype_name5162  */
static	ANTLR3_BITWORD FOLLOW_k_character_in_datatype_name5162_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_character_in_datatype_name5162	= { FOLLOW_k_character_in_datatype_name5162_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_char_in_datatype_name5166  */
static	ANTLR3_BITWORD FOLLOW_r_char_in_datatype_name5166_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_char_in_datatype_name5166	= { FOLLOW_r_char_in_datatype_name5166_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_varying_in_datatype_name5172  */
static	ANTLR3_BITWORD FOLLOW_k_varying_in_datatype_name5172_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_varying_in_datatype_name5172	= { FOLLOW_k_varying_in_datatype_name5172_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name5179  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name5179_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name5179	= { FOLLOW_LPAREN_in_datatype_name5179_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name5181  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name5181_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name5181	= { FOLLOW_NUMBER_in_datatype_name5181_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name5183  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name5183_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name5183	= { FOLLOW_RPAREN_in_datatype_name5183_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_mlslabel_in_datatype_name5191  */
static	ANTLR3_BITWORD FOLLOW_k_mlslabel_in_datatype_name5191_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_mlslabel_in_datatype_name5191	= { FOLLOW_k_mlslabel_in_datatype_name5191_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_pls_integer_in_datatype_name5196  */
static	ANTLR3_BITWORD FOLLOW_k_pls_integer_in_datatype_name5196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_pls_integer_in_datatype_name5196	= { FOLLOW_k_pls_integer_in_datatype_name5196_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_blob_in_datatype_name5201  */
static	ANTLR3_BITWORD FOLLOW_k_blob_in_datatype_name5201_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_blob_in_datatype_name5201	= { FOLLOW_k_blob_in_datatype_name5201_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_clob_in_datatype_name5206  */
static	ANTLR3_BITWORD FOLLOW_k_clob_in_datatype_name5206_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_clob_in_datatype_name5206	= { FOLLOW_k_clob_in_datatype_name5206_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_character_in_datatype_name5210  */
static	ANTLR3_BITWORD FOLLOW_k_character_in_datatype_name5210_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_k_character_in_datatype_name5210	= { FOLLOW_k_character_in_datatype_name5210_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_datatype_name5212  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_datatype_name5212_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_datatype_name5212	= { FOLLOW_r_set_in_datatype_name5212_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatype_name5216  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatype_name5216_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatype_name5216	= { FOLLOW_identifier_in_datatype_name5216_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_datatype_name5221  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_datatype_name5221_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000008000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_datatype_name5221	= { FOLLOW_column_spec_in_datatype_name5221_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHARSET_ATTR_in_datatype_name5223  */
static	ANTLR3_BITWORD FOLLOW_CHARSET_ATTR_in_datatype_name5223_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHARSET_ATTR_in_datatype_name5223	= { FOLLOW_CHARSET_ATTR_in_datatype_name5223_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nclob_in_datatype_name5233  */
static	ANTLR3_BITWORD FOLLOW_k_nclob_in_datatype_name5233_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nclob_in_datatype_name5233	= { FOLLOW_k_nclob_in_datatype_name5233_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_bfile_in_datatype_name5238  */
static	ANTLR3_BITWORD FOLLOW_k_bfile_in_datatype_name5238_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_bfile_in_datatype_name5238	= { FOLLOW_k_bfile_in_datatype_name5238_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_rowid_in_datatype_name5243  */
static	ANTLR3_BITWORD FOLLOW_r_rowid_in_datatype_name5243_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_rowid_in_datatype_name5243	= { FOLLOW_r_rowid_in_datatype_name5243_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_urowid_in_datatype_name5249  */
static	ANTLR3_BITWORD FOLLOW_k_urowid_in_datatype_name5249_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_urowid_in_datatype_name5249	= { FOLLOW_k_urowid_in_datatype_name5249_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_datatype_name5253  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_datatype_name5253_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_datatype_name5253	= { FOLLOW_LPAREN_in_datatype_name5253_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_datatype_name5255  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_datatype_name5255_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_datatype_name5255	= { FOLLOW_NUMBER_in_datatype_name5255_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_datatype_name5257  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_datatype_name5257_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_datatype_name5257	= { FOLLOW_RPAREN_in_datatype_name5257_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_true_in_boolean_literal5271  */
static	ANTLR3_BITWORD FOLLOW_r_true_in_boolean_literal5271_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_true_in_boolean_literal5271	= { FOLLOW_r_true_in_boolean_literal5271_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_false_in_boolean_literal5275  */
static	ANTLR3_BITWORD FOLLOW_r_false_in_boolean_literal5275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_false_in_boolean_literal5275	= { FOLLOW_r_false_in_boolean_literal5275_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_t_alias5287  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_t_alias5287_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_t_alias5287	= { FOLLOW_sql_identifier_in_t_alias5287_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_as_in_c_alias5299  */
static	ANTLR3_BITWORD FOLLOW_r_as_in_c_alias5299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_as_in_c_alias5299	= { FOLLOW_r_as_in_c_alias5299_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_c_alias5302  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_c_alias5302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_c_alias5302	= { FOLLOW_sql_identifier_in_c_alias5302_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_as_in_c_alias5308  */
static	ANTLR3_BITWORD FOLLOW_r_as_in_c_alias5308_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_as_in_c_alias5308	= { FOLLOW_r_as_in_c_alias5308_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_column_spec5321  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_column_spec5321_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_column_spec5321	= { FOLLOW_schema_name_in_column_spec5321_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_column_spec5325  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_column_spec5325_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_column_spec5325	= { FOLLOW_DOT_in_column_spec5325_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_column_spec5329  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_column_spec5329_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_column_spec5329	= { FOLLOW_t_alias_in_column_spec5329_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_column_spec5334  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_column_spec5334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_column_spec5334	= { FOLLOW_DOT_in_column_spec5334_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_name_in_column_spec5338  */
static	ANTLR3_BITWORD FOLLOW_column_name_in_column_spec5338_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_column_name_in_column_spec5338	= { FOLLOW_column_name_in_column_spec5338_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_column_spec5340  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_column_spec5340_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_column_spec5340	= { FOLLOW_outer_join_sign_in_column_spec5340_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_column_spec5374  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_column_spec5374_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_column_spec5374	= { FOLLOW_schema_name_in_column_spec5374_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_column_spec5378  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_column_spec5378_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_column_spec5378	= { FOLLOW_DOT_in_column_spec5378_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_package_name_in_column_spec5380  */
static	ANTLR3_BITWORD FOLLOW_package_name_in_column_spec5380_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_package_name_in_column_spec5380	= { FOLLOW_package_name_in_column_spec5380_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_column_spec5384  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_column_spec5384_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_column_spec5384	= { FOLLOW_DOT_in_column_spec5384_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_column_spec5388  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_column_spec5388_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_column_spec5388	= { FOLLOW_identifier_in_column_spec5388_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_column_spec5393  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_column_spec5393_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_column_spec5393	= { FOLLOW_DOT_in_column_spec5393_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_column_spec5397  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_column_spec5397_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_column_spec5397	= { FOLLOW_identifier_in_column_spec5397_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pseudo_column_in_column_spec5433  */
static	ANTLR3_BITWORD FOLLOW_pseudo_column_in_column_spec5433_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pseudo_column_in_column_spec5433	= { FOLLOW_pseudo_column_in_column_spec5433_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bind_variable_in_column_spec5438  */
static	ANTLR3_BITWORD FOLLOW_bind_variable_in_column_spec5438_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bind_variable_in_column_spec5438	= { FOLLOW_bind_variable_in_column_spec5438_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_null_in_pseudo_column5450  */
static	ANTLR3_BITWORD FOLLOW_r_null_in_pseudo_column5450_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_null_in_pseudo_column5450	= { FOLLOW_r_null_in_pseudo_column5450_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_sysdate_in_pseudo_column5458  */
static	ANTLR3_BITWORD FOLLOW_r_sysdate_in_pseudo_column5458_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_sysdate_in_pseudo_column5458	= { FOLLOW_r_sysdate_in_pseudo_column5458_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_user_in_pseudo_column5466  */
static	ANTLR3_BITWORD FOLLOW_r_user_in_pseudo_column5466_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_user_in_pseudo_column5466	= { FOLLOW_r_user_in_pseudo_column5466_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_level_in_pseudo_column5473  */
static	ANTLR3_BITWORD FOLLOW_r_level_in_pseudo_column5473_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_level_in_pseudo_column5473	= { FOLLOW_r_level_in_pseudo_column5473_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_function_name5514  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_function_name5514_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_function_name5514	= { FOLLOW_sql_identifier_in_function_name5514_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_function_spec5530  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_function_spec5530_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_function_spec5530	= { FOLLOW_schema_name_in_function_spec5530_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_function_spec5532  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_function_spec5532_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_function_spec5532	= { FOLLOW_DOT_in_function_spec5532_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_package_name_in_function_spec5534  */
static	ANTLR3_BITWORD FOLLOW_package_name_in_function_spec5534_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_package_name_in_function_spec5534	= { FOLLOW_package_name_in_function_spec5534_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_function_spec5536  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_function_spec5536_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_function_spec5536	= { FOLLOW_DOT_in_function_spec5536_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_name_in_function_spec5538  */
static	ANTLR3_BITWORD FOLLOW_function_name_in_function_spec5538_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_function_name_in_function_spec5538	= { FOLLOW_function_name_in_function_spec5538_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_function_spec5543  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_function_spec5543_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_function_spec5543	= { FOLLOW_schema_name_in_function_spec5543_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_function_spec5545  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_function_spec5545_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_function_spec5545	= { FOLLOW_DOT_in_function_spec5545_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_name_in_function_spec5547  */
static	ANTLR3_BITWORD FOLLOW_function_name_in_function_spec5547_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_function_name_in_function_spec5547	= { FOLLOW_function_name_in_function_spec5547_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_name_in_function_spec5552  */
static	ANTLR3_BITWORD FOLLOW_function_name_in_function_spec5552_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_function_name_in_function_spec5552	= { FOLLOW_function_name_in_function_spec5552_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_identifier5566  */
static	ANTLR3_BITWORD FOLLOW_ID_in_identifier5566_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_identifier5566	= { FOLLOW_ID_in_identifier5566_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINDVAR_in_bind_variable5599  */
static	ANTLR3_BITWORD FOLLOW_BINDVAR_in_bind_variable5599_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINDVAR_in_bind_variable5599	= { FOLLOW_BINDVAR_in_bind_variable5599_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_bind_variable5620  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_bind_variable5620_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_bind_variable5620	= { FOLLOW_COLON_in_bind_variable5620_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_bind_variable5642  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_bind_variable5642_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_bind_variable5642	= { FOLLOW_NUMBER_in_bind_variable5642_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_sql_identifier5671  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_sql_identifier5671_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_sql_identifier5671	= { FOLLOW_identifier_in_sql_identifier5671_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_keyword_in_sql_identifier5679  */
static	ANTLR3_BITWORD FOLLOW_keyword_in_sql_identifier5679_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_keyword_in_sql_identifier5679	= { FOLLOW_keyword_in_sql_identifier5679_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_rowid_in_sql_identifier5687  */
static	ANTLR3_BITWORD FOLLOW_r_rowid_in_sql_identifier5687_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_rowid_in_sql_identifier5687	= { FOLLOW_r_rowid_in_sql_identifier5687_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_rownum_in_sql_identifier5695  */
static	ANTLR3_BITWORD FOLLOW_r_rownum_in_sql_identifier5695_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_rownum_in_sql_identifier5695	= { FOLLOW_r_rownum_in_sql_identifier5695_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_join_clause_in_table_reference_list5714  */
static	ANTLR3_BITWORD FOLLOW_join_clause_in_table_reference_list5714_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_join_clause_in_table_reference_list5714	= { FOLLOW_join_clause_in_table_reference_list5714_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_in_table_reference_list5716  */
static	ANTLR3_BITWORD FOLLOW_table_reference_in_table_reference_list5716_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_in_table_reference_list5716	= { FOLLOW_table_reference_in_table_reference_list5716_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_table_reference_list5720  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_table_reference_list5720_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_table_reference_list5720	= { FOLLOW_COMMA_in_table_reference_list5720_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_join_clause_in_table_reference_list5723  */
static	ANTLR3_BITWORD FOLLOW_join_clause_in_table_reference_list5723_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_join_clause_in_table_reference_list5723	= { FOLLOW_join_clause_in_table_reference_list5723_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_in_table_reference_list5725  */
static	ANTLR3_BITWORD FOLLOW_table_reference_in_table_reference_list5725_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_in_table_reference_list5725	= { FOLLOW_table_reference_in_table_reference_list5725_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_only_in_table_reference5759  */
static	ANTLR3_BITWORD FOLLOW_k_only_in_table_reference5759_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_only_in_table_reference5759	= { FOLLOW_k_only_in_table_reference5759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_table_reference5761  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_table_reference5761_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_table_reference5761	= { FOLLOW_LPAREN_in_table_reference5761_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_table_expression_in_table_reference5763  */
static	ANTLR3_BITWORD FOLLOW_query_table_expression_in_table_reference5763_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_query_table_expression_in_table_reference5763	= { FOLLOW_query_table_expression_in_table_reference5763_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_table_reference5765  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_table_reference5765_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x4200000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000D4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_table_reference5765	= { FOLLOW_RPAREN_in_table_reference5765_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_table_expression_in_table_reference5771  */
static	ANTLR3_BITWORD FOLLOW_query_table_expression_in_table_reference5771_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x4200000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000D4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_query_table_expression_in_table_reference5771	= { FOLLOW_query_table_expression_in_table_reference5771_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_flashback_query_clause_in_table_reference5776  */
static	ANTLR3_BITWORD FOLLOW_flashback_query_clause_in_table_reference5776_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_flashback_query_clause_in_table_reference5776	= { FOLLOW_flashback_query_clause_in_table_reference5776_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_table_reference5779  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_table_reference5779_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_table_reference5779	= { FOLLOW_t_alias_in_table_reference5779_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_name_long_in_query_table_expression5794  */
static	ANTLR3_BITWORD FOLLOW_table_name_long_in_query_table_expression5794_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x00000000010000C0) };
static  ANTLR3_BITSET_LIST FOLLOW_table_name_long_in_query_table_expression5794	= { FOLLOW_table_name_long_in_query_table_expression5794_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_partition_extension_clause_in_query_table_expression5798  */
static	ANTLR3_BITWORD FOLLOW_partition_extension_clause_in_query_table_expression5798_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_partition_extension_clause_in_query_table_expression5798	= { FOLLOW_partition_extension_clause_in_query_table_expression5798_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AT_SIGN_in_query_table_expression5802  */
static	ANTLR3_BITWORD FOLLOW_AT_SIGN_in_query_table_expression5802_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_AT_SIGN_in_query_table_expression5802	= { FOLLOW_AT_SIGN_in_query_table_expression5802_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dblink_name_in_query_table_expression5804  */
static	ANTLR3_BITWORD FOLLOW_dblink_name_in_query_table_expression5804_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_dblink_name_in_query_table_expression5804	= { FOLLOW_dblink_name_in_query_table_expression5804_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sample_clause_in_query_table_expression5808  */
static	ANTLR3_BITWORD FOLLOW_sample_clause_in_query_table_expression5808_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_sample_clause_in_query_table_expression5808	= { FOLLOW_sample_clause_in_query_table_expression5808_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_query_table_expression5812  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_query_table_expression5812_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_query_table_expression5812	= { FOLLOW_pivot_clause_in_query_table_expression5812_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_query_table_expression5814  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_query_table_expression5814_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_query_table_expression5814	= { FOLLOW_unpivot_clause_in_query_table_expression5814_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_query_table_expression5821  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_query_table_expression5821_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_query_table_expression5821	= { FOLLOW_subquery_in_query_table_expression5821_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_restricrion_clause_in_query_table_expression5823  */
static	ANTLR3_BITWORD FOLLOW_subquery_restricrion_clause_in_query_table_expression5823_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_restricrion_clause_in_query_table_expression5823	= { FOLLOW_subquery_restricrion_clause_in_query_table_expression5823_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_query_table_expression5827  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_query_table_expression5827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_query_table_expression5827	= { FOLLOW_pivot_clause_in_query_table_expression5827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_query_table_expression5829  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_query_table_expression5829_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_query_table_expression5829	= { FOLLOW_unpivot_clause_in_query_table_expression5829_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_query_table_expression5836  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_query_table_expression5836_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_query_table_expression5836	= { FOLLOW_LPAREN_in_query_table_expression5836_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_query_table_expression5838  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_query_table_expression5838_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_query_table_expression5838	= { FOLLOW_subquery_in_query_table_expression5838_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_restricrion_clause_in_query_table_expression5840  */
static	ANTLR3_BITWORD FOLLOW_subquery_restricrion_clause_in_query_table_expression5840_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_restricrion_clause_in_query_table_expression5840	= { FOLLOW_subquery_restricrion_clause_in_query_table_expression5840_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_query_table_expression5844  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_query_table_expression5844_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_query_table_expression5844	= { FOLLOW_pivot_clause_in_query_table_expression5844_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_query_table_expression5846  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_query_table_expression5846_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_query_table_expression5846	= { FOLLOW_unpivot_clause_in_query_table_expression5846_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_query_table_expression5850  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_query_table_expression5850_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_query_table_expression5850	= { FOLLOW_RPAREN_in_query_table_expression5850_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_collection_clause_in_query_table_expression5856  */
static	ANTLR3_BITWORD FOLLOW_table_collection_clause_in_query_table_expression5856_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_table_collection_clause_in_query_table_expression5856	= { FOLLOW_table_collection_clause_in_query_table_expression5856_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_query_table_expression5859  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_query_table_expression5859_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_query_table_expression5859	= { FOLLOW_pivot_clause_in_query_table_expression5859_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_query_table_expression5861  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_query_table_expression5861_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_query_table_expression5861	= { FOLLOW_unpivot_clause_in_query_table_expression5861_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_versions_in_flashback_query_clause5875  */
static	ANTLR3_BITWORD FOLLOW_k_versions_in_flashback_query_clause5875_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_versions_in_flashback_query_clause5875	= { FOLLOW_k_versions_in_flashback_query_clause5875_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_between_in_flashback_query_clause5877  */
static	ANTLR3_BITWORD FOLLOW_r_between_in_flashback_query_clause5877_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000100), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_between_in_flashback_query_clause5877	= { FOLLOW_r_between_in_flashback_query_clause5877_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_scn_in_flashback_query_clause5881  */
static	ANTLR3_BITWORD FOLLOW_k_scn_in_flashback_query_clause5881_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_scn_in_flashback_query_clause5881	= { FOLLOW_k_scn_in_flashback_query_clause5881_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timestamp_in_flashback_query_clause5884  */
static	ANTLR3_BITWORD FOLLOW_k_timestamp_in_flashback_query_clause5884_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timestamp_in_flashback_query_clause5884	= { FOLLOW_k_timestamp_in_flashback_query_clause5884_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_flashback_query_clause5888  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_flashback_query_clause5888_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_flashback_query_clause5888	= { FOLLOW_sql_expression_in_flashback_query_clause5888_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_mivalue_in_flashback_query_clause5891  */
static	ANTLR3_BITWORD FOLLOW_k_mivalue_in_flashback_query_clause5891_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_mivalue_in_flashback_query_clause5891	= { FOLLOW_k_mivalue_in_flashback_query_clause5891_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_and_in_flashback_query_clause5895  */
static	ANTLR3_BITWORD FOLLOW_r_and_in_flashback_query_clause5895_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_and_in_flashback_query_clause5895	= { FOLLOW_r_and_in_flashback_query_clause5895_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_flashback_query_clause5898  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_flashback_query_clause5898_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_flashback_query_clause5898	= { FOLLOW_sql_expression_in_flashback_query_clause5898_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_maxvalue_in_flashback_query_clause5901  */
static	ANTLR3_BITWORD FOLLOW_k_maxvalue_in_flashback_query_clause5901_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_maxvalue_in_flashback_query_clause5901	= { FOLLOW_k_maxvalue_in_flashback_query_clause5901_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_as_in_flashback_query_clause5909  */
static	ANTLR3_BITWORD FOLLOW_r_as_in_flashback_query_clause5909_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_as_in_flashback_query_clause5909	= { FOLLOW_r_as_in_flashback_query_clause5909_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_of_in_flashback_query_clause5911  */
static	ANTLR3_BITWORD FOLLOW_r_of_in_flashback_query_clause5911_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000100), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_of_in_flashback_query_clause5911	= { FOLLOW_r_of_in_flashback_query_clause5911_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_scn_in_flashback_query_clause5915  */
static	ANTLR3_BITWORD FOLLOW_k_scn_in_flashback_query_clause5915_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_scn_in_flashback_query_clause5915	= { FOLLOW_k_scn_in_flashback_query_clause5915_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timestamp_in_flashback_query_clause5918  */
static	ANTLR3_BITWORD FOLLOW_k_timestamp_in_flashback_query_clause5918_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timestamp_in_flashback_query_clause5918	= { FOLLOW_k_timestamp_in_flashback_query_clause5918_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_flashback_query_clause5921  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_flashback_query_clause5921_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_flashback_query_clause5921	= { FOLLOW_sql_expression_in_flashback_query_clause5921_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_sample_in_sample_clause5931  */
static	ANTLR3_BITWORD FOLLOW_k_sample_in_sample_clause5931_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_sample_in_sample_clause5931	= { FOLLOW_k_sample_in_sample_clause5931_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_block_in_sample_clause5933  */
static	ANTLR3_BITWORD FOLLOW_k_block_in_sample_clause5933_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_block_in_sample_clause5933	= { FOLLOW_k_block_in_sample_clause5933_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_sample_clause5937  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_sample_clause5937_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_sample_clause5937	= { FOLLOW_LPAREN_in_sample_clause5937_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sample_percent_in_sample_clause5939  */
static	ANTLR3_BITWORD FOLLOW_sample_percent_in_sample_clause5939_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_sample_percent_in_sample_clause5939	= { FOLLOW_sample_percent_in_sample_clause5939_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_sample_clause5942  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_sample_clause5942_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_sample_clause5942	= { FOLLOW_COMMA_in_sample_clause5942_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sample_percent_in_sample_clause5944  */
static	ANTLR3_BITWORD FOLLOW_sample_percent_in_sample_clause5944_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sample_percent_in_sample_clause5944	= { FOLLOW_sample_percent_in_sample_clause5944_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_sample_clause5948  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_sample_clause5948_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_sample_clause5948	= { FOLLOW_RPAREN_in_sample_clause5948_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_seed_in_sample_clause5952  */
static	ANTLR3_BITWORD FOLLOW_k_seed_in_sample_clause5952_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_seed_in_sample_clause5952	= { FOLLOW_k_seed_in_sample_clause5952_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_sample_clause5954  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_sample_clause5954_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_sample_clause5954	= { FOLLOW_LPAREN_in_sample_clause5954_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_seed_value_in_sample_clause5956  */
static	ANTLR3_BITWORD FOLLOW_seed_value_in_sample_clause5956_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_seed_value_in_sample_clause5956	= { FOLLOW_seed_value_in_sample_clause5956_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_sample_clause5958  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_sample_clause5958_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_sample_clause5958	= { FOLLOW_RPAREN_in_sample_clause5958_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_partition_in_partition_extension_clause5970  */
static	ANTLR3_BITWORD FOLLOW_k_partition_in_partition_extension_clause5970_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_partition_in_partition_extension_clause5970	= { FOLLOW_k_partition_in_partition_extension_clause5970_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_partition_extension_clause5975  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_partition_extension_clause5975_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_partition_extension_clause5975	= { FOLLOW_LPAREN_in_partition_extension_clause5975_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_partition_in_partition_extension_clause5977  */
static	ANTLR3_BITWORD FOLLOW_partition_in_partition_extension_clause5977_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_partition_in_partition_extension_clause5977	= { FOLLOW_partition_in_partition_extension_clause5977_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_partition_extension_clause5979  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_partition_extension_clause5979_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_partition_extension_clause5979	= { FOLLOW_RPAREN_in_partition_extension_clause5979_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_for_in_partition_extension_clause5987  */
static	ANTLR3_BITWORD FOLLOW_r_for_in_partition_extension_clause5987_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_for_in_partition_extension_clause5987	= { FOLLOW_r_for_in_partition_extension_clause5987_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_partition_extension_clause5989  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_partition_extension_clause5989_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_partition_extension_clause5989	= { FOLLOW_LPAREN_in_partition_extension_clause5989_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_partition_key_value_in_partition_extension_clause5991  */
static	ANTLR3_BITWORD FOLLOW_partition_key_value_in_partition_extension_clause5991_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_partition_key_value_in_partition_extension_clause5991	= { FOLLOW_partition_key_value_in_partition_extension_clause5991_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_partition_extension_clause5994  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_partition_extension_clause5994_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010004) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_partition_extension_clause5994	= { FOLLOW_COMMA_in_partition_extension_clause5994_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_partition_key_value_in_partition_extension_clause5996  */
static	ANTLR3_BITWORD FOLLOW_partition_key_value_in_partition_extension_clause5996_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_partition_key_value_in_partition_extension_clause5996	= { FOLLOW_partition_key_value_in_partition_extension_clause5996_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_partition_extension_clause6000  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_partition_extension_clause6000_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_partition_extension_clause6000	= { FOLLOW_RPAREN_in_partition_extension_clause6000_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_subpartition_in_partition_extension_clause6010  */
static	ANTLR3_BITWORD FOLLOW_k_subpartition_in_partition_extension_clause6010_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_subpartition_in_partition_extension_clause6010	= { FOLLOW_k_subpartition_in_partition_extension_clause6010_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_partition_extension_clause6015  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_partition_extension_clause6015_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_partition_extension_clause6015	= { FOLLOW_LPAREN_in_partition_extension_clause6015_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_partition_in_partition_extension_clause6017  */
static	ANTLR3_BITWORD FOLLOW_partition_in_partition_extension_clause6017_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_partition_in_partition_extension_clause6017	= { FOLLOW_partition_in_partition_extension_clause6017_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_partition_extension_clause6019  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_partition_extension_clause6019_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_partition_extension_clause6019	= { FOLLOW_RPAREN_in_partition_extension_clause6019_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_for_in_partition_extension_clause6027  */
static	ANTLR3_BITWORD FOLLOW_r_for_in_partition_extension_clause6027_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_for_in_partition_extension_clause6027	= { FOLLOW_r_for_in_partition_extension_clause6027_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_partition_extension_clause6029  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_partition_extension_clause6029_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_partition_extension_clause6029	= { FOLLOW_LPAREN_in_partition_extension_clause6029_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subpartition_key_value_in_partition_extension_clause6031  */
static	ANTLR3_BITWORD FOLLOW_subpartition_key_value_in_partition_extension_clause6031_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_subpartition_key_value_in_partition_extension_clause6031	= { FOLLOW_subpartition_key_value_in_partition_extension_clause6031_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_partition_extension_clause6034  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_partition_extension_clause6034_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010004) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_partition_extension_clause6034	= { FOLLOW_COMMA_in_partition_extension_clause6034_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subpartition_key_value_in_partition_extension_clause6036  */
static	ANTLR3_BITWORD FOLLOW_subpartition_key_value_in_partition_extension_clause6036_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_subpartition_key_value_in_partition_extension_clause6036	= { FOLLOW_subpartition_key_value_in_partition_extension_clause6036_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_partition_extension_clause6040  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_partition_extension_clause6040_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_partition_extension_clause6040	= { FOLLOW_RPAREN_in_partition_extension_clause6040_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_with_in_subquery_restricrion_clause6052  */
static	ANTLR3_BITWORD FOLLOW_r_with_in_subquery_restricrion_clause6052_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_r_with_in_subquery_restricrion_clause6052	= { FOLLOW_r_with_in_subquery_restricrion_clause6052_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_read_in_subquery_restricrion_clause6056  */
static	ANTLR3_BITWORD FOLLOW_k_read_in_subquery_restricrion_clause6056_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_read_in_subquery_restricrion_clause6056	= { FOLLOW_k_read_in_subquery_restricrion_clause6056_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_only_in_subquery_restricrion_clause6058  */
static	ANTLR3_BITWORD FOLLOW_k_only_in_subquery_restricrion_clause6058_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_only_in_subquery_restricrion_clause6058	= { FOLLOW_k_only_in_subquery_restricrion_clause6058_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_check_in_subquery_restricrion_clause6064  */
static	ANTLR3_BITWORD FOLLOW_r_check_in_subquery_restricrion_clause6064_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_check_in_subquery_restricrion_clause6064	= { FOLLOW_r_check_in_subquery_restricrion_clause6064_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_option_in_subquery_restricrion_clause6066  */
static	ANTLR3_BITWORD FOLLOW_r_option_in_subquery_restricrion_clause6066_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_option_in_subquery_restricrion_clause6066	= { FOLLOW_r_option_in_subquery_restricrion_clause6066_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_constraint_in_subquery_restricrion_clause6070  */
static	ANTLR3_BITWORD FOLLOW_k_constraint_in_subquery_restricrion_clause6070_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_constraint_in_subquery_restricrion_clause6070	= { FOLLOW_k_constraint_in_subquery_restricrion_clause6070_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constraint_in_subquery_restricrion_clause6072  */
static	ANTLR3_BITWORD FOLLOW_constraint_in_subquery_restricrion_clause6072_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_constraint_in_subquery_restricrion_clause6072	= { FOLLOW_constraint_in_subquery_restricrion_clause6072_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_table_in_table_collection_clause6088  */
static	ANTLR3_BITWORD FOLLOW_r_table_in_table_collection_clause6088_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_table_in_table_collection_clause6088	= { FOLLOW_r_table_in_table_collection_clause6088_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_the_in_table_collection_clause6092  */
static	ANTLR3_BITWORD FOLLOW_k_the_in_table_collection_clause6092_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_the_in_table_collection_clause6092	= { FOLLOW_k_the_in_table_collection_clause6092_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_collection_expression_in_table_collection_clause6098  */
static	ANTLR3_BITWORD FOLLOW_collection_expression_in_table_collection_clause6098_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_collection_expression_in_table_collection_clause6098	= { FOLLOW_collection_expression_in_table_collection_clause6098_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_table_collection_clause6102  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_table_collection_clause6102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_table_collection_clause6102	= { FOLLOW_outer_join_sign_in_table_collection_clause6102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_join_clause6142  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_join_clause6142_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_join_clause6142	= { FOLLOW_LPAREN_in_join_clause6142_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_join_clause_in_join_clause6144  */
static	ANTLR3_BITWORD FOLLOW_join_clause_in_join_clause6144_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_join_clause_in_join_clause6144	= { FOLLOW_join_clause_in_join_clause6144_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_join_clause6146  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_join_clause6146_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0508000000000000), ANTLR3_UINT64_LIT(0x0000000000004040) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_join_clause6146	= { FOLLOW_RPAREN_in_join_clause6146_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_in_join_clause6148  */
static	ANTLR3_BITWORD FOLLOW_table_reference_in_join_clause6148_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0508000000000000), ANTLR3_UINT64_LIT(0x0000000000004040) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_in_join_clause6148	= { FOLLOW_table_reference_in_join_clause6148_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_inner_cross_join_clause_in_join_clause6152  */
static	ANTLR3_BITWORD FOLLOW_inner_cross_join_clause_in_join_clause6152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0508000000000000), ANTLR3_UINT64_LIT(0x0000000000004040) };
static  ANTLR3_BITSET_LIST FOLLOW_inner_cross_join_clause_in_join_clause6152	= { FOLLOW_inner_cross_join_clause_in_join_clause6152_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_clause_in_join_clause6154  */
static	ANTLR3_BITWORD FOLLOW_outer_join_clause_in_join_clause6154_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0508000000000000), ANTLR3_UINT64_LIT(0x0000000000004040) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_clause_in_join_clause6154	= { FOLLOW_outer_join_clause_in_join_clause6154_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_join_clause6166  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_join_clause6166_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_join_clause6166	= { FOLLOW_LPAREN_in_join_clause6166_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_join_clause_in_join_clause6168  */
static	ANTLR3_BITWORD FOLLOW_join_clause_in_join_clause6168_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_join_clause_in_join_clause6168	= { FOLLOW_join_clause_in_join_clause6168_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_join_clause6170  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_join_clause6170_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_join_clause6170	= { FOLLOW_RPAREN_in_join_clause6170_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_inner_in_inner_cross_join_clause6180  */
static	ANTLR3_BITWORD FOLLOW_k_inner_in_inner_cross_join_clause6180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_inner_in_inner_cross_join_clause6180	= { FOLLOW_k_inner_in_inner_cross_join_clause6180_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_join_in_inner_cross_join_clause6183  */
static	ANTLR3_BITWORD FOLLOW_k_join_in_inner_cross_join_clause6183_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_join_in_inner_cross_join_clause6183	= { FOLLOW_k_join_in_inner_cross_join_clause6183_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_in_inner_cross_join_clause6185  */
static	ANTLR3_BITWORD FOLLOW_table_reference_in_inner_cross_join_clause6185_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_in_inner_cross_join_clause6185	= { FOLLOW_table_reference_in_inner_cross_join_clause6185_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_joining_clause_in_inner_cross_join_clause6187  */
static	ANTLR3_BITWORD FOLLOW_joining_clause_in_inner_cross_join_clause6187_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_joining_clause_in_inner_cross_join_clause6187	= { FOLLOW_joining_clause_in_inner_cross_join_clause6187_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_cross_in_inner_cross_join_clause6197  */
static	ANTLR3_BITWORD FOLLOW_k_cross_in_inner_cross_join_clause6197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_cross_in_inner_cross_join_clause6197	= { FOLLOW_k_cross_in_inner_cross_join_clause6197_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_natural_in_inner_cross_join_clause6201  */
static	ANTLR3_BITWORD FOLLOW_k_natural_in_inner_cross_join_clause6201_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_natural_in_inner_cross_join_clause6201	= { FOLLOW_k_natural_in_inner_cross_join_clause6201_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_inner_in_inner_cross_join_clause6203  */
static	ANTLR3_BITWORD FOLLOW_k_inner_in_inner_cross_join_clause6203_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_inner_in_inner_cross_join_clause6203	= { FOLLOW_k_inner_in_inner_cross_join_clause6203_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_join_in_inner_cross_join_clause6208  */
static	ANTLR3_BITWORD FOLLOW_k_join_in_inner_cross_join_clause6208_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_join_in_inner_cross_join_clause6208	= { FOLLOW_k_join_in_inner_cross_join_clause6208_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_in_inner_cross_join_clause6210  */
static	ANTLR3_BITWORD FOLLOW_table_reference_in_inner_cross_join_clause6210_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_in_inner_cross_join_clause6210	= { FOLLOW_table_reference_in_inner_cross_join_clause6210_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_partition_clause_in_outer_join_clause6231  */
static	ANTLR3_BITWORD FOLLOW_query_partition_clause_in_outer_join_clause6231_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0408000000000000), ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_query_partition_clause_in_outer_join_clause6231	= { FOLLOW_query_partition_clause_in_outer_join_clause6231_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_type_in_outer_join_clause6240  */
static	ANTLR3_BITWORD FOLLOW_outer_join_type_in_outer_join_clause6240_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_type_in_outer_join_clause6240	= { FOLLOW_outer_join_type_in_outer_join_clause6240_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_join_in_outer_join_clause6242  */
static	ANTLR3_BITWORD FOLLOW_k_join_in_outer_join_clause6242_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_join_in_outer_join_clause6242	= { FOLLOW_k_join_in_outer_join_clause6242_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_natural_in_outer_join_clause6248  */
static	ANTLR3_BITWORD FOLLOW_k_natural_in_outer_join_clause6248_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0508000000000000), ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_natural_in_outer_join_clause6248	= { FOLLOW_k_natural_in_outer_join_clause6248_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_type_in_outer_join_clause6252  */
static	ANTLR3_BITWORD FOLLOW_outer_join_type_in_outer_join_clause6252_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_type_in_outer_join_clause6252	= { FOLLOW_outer_join_type_in_outer_join_clause6252_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_join_in_outer_join_clause6257  */
static	ANTLR3_BITWORD FOLLOW_k_join_in_outer_join_clause6257_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_join_in_outer_join_clause6257	= { FOLLOW_k_join_in_outer_join_clause6257_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_in_outer_join_clause6265  */
static	ANTLR3_BITWORD FOLLOW_table_reference_in_outer_join_clause6265_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994F4) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_in_outer_join_clause6265	= { FOLLOW_table_reference_in_outer_join_clause6265_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_partition_clause_in_outer_join_clause6269  */
static	ANTLR3_BITWORD FOLLOW_query_partition_clause_in_outer_join_clause6269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_query_partition_clause_in_outer_join_clause6269	= { FOLLOW_query_partition_clause_in_outer_join_clause6269_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_joining_clause_in_outer_join_clause6274  */
static	ANTLR3_BITWORD FOLLOW_joining_clause_in_outer_join_clause6274_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_joining_clause_in_outer_join_clause6274	= { FOLLOW_joining_clause_in_outer_join_clause6274_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_partition_in_query_partition_clause6285  */
static	ANTLR3_BITWORD FOLLOW_k_partition_in_query_partition_clause6285_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_partition_in_query_partition_clause6285	= { FOLLOW_k_partition_in_query_partition_clause6285_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_query_partition_clause6287  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_query_partition_clause6287_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_query_partition_clause6287	= { FOLLOW_r_by_in_query_partition_clause6287_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_list_in_query_partition_clause6289  */
static	ANTLR3_BITWORD FOLLOW_expression_list_in_query_partition_clause6289_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_list_in_query_partition_clause6289	= { FOLLOW_expression_list_in_query_partition_clause6289_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_full_in_outer_join_type6302  */
static	ANTLR3_BITWORD FOLLOW_k_full_in_outer_join_type6302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_k_full_in_outer_join_type6302	= { FOLLOW_k_full_in_outer_join_type6302_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_left_in_outer_join_type6306  */
static	ANTLR3_BITWORD FOLLOW_k_left_in_outer_join_type6306_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_k_left_in_outer_join_type6306	= { FOLLOW_k_left_in_outer_join_type6306_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_right_in_outer_join_type6310  */
static	ANTLR3_BITWORD FOLLOW_k_right_in_outer_join_type6310_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_k_right_in_outer_join_type6310	= { FOLLOW_k_right_in_outer_join_type6310_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_outer_in_outer_join_type6316  */
static	ANTLR3_BITWORD FOLLOW_k_outer_in_outer_join_type6316_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_outer_in_outer_join_type6316	= { FOLLOW_k_outer_in_outer_join_type6316_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_on_in_joining_clause6337  */
static	ANTLR3_BITWORD FOLLOW_r_on_in_joining_clause6337_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_on_in_joining_clause6337	= { FOLLOW_r_on_in_joining_clause6337_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_joining_clause6339  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_joining_clause6339_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_joining_clause6339	= { FOLLOW_sql_condition_in_joining_clause6339_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_using_in_joining_clause6354  */
static	ANTLR3_BITWORD FOLLOW_k_using_in_joining_clause6354_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_using_in_joining_clause6354	= { FOLLOW_k_using_in_joining_clause6354_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_joining_clause6356  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_joining_clause6356_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_joining_clause6356	= { FOLLOW_LPAREN_in_joining_clause6356_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_specs_in_joining_clause6358  */
static	ANTLR3_BITWORD FOLLOW_column_specs_in_joining_clause6358_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_specs_in_joining_clause6358	= { FOLLOW_column_specs_in_joining_clause6358_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_joining_clause6360  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_joining_clause6360_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_joining_clause6360	= { FOLLOW_RPAREN_in_joining_clause6360_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_sample_percent6383  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_sample_percent6383_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_sample_percent6383	= { FOLLOW_NUMBER_in_sample_percent6383_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bind_variable_in_sample_percent6388  */
static	ANTLR3_BITWORD FOLLOW_bind_variable_in_sample_percent6388_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bind_variable_in_sample_percent6388	= { FOLLOW_bind_variable_in_sample_percent6388_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_seed_value6398  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_seed_value6398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_seed_value6398	= { FOLLOW_NUMBER_in_seed_value6398_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bind_variable_in_seed_value6403  */
static	ANTLR3_BITWORD FOLLOW_bind_variable_in_seed_value6403_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bind_variable_in_seed_value6403	= { FOLLOW_bind_variable_in_seed_value6403_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_outer_join_sign6421  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_outer_join_sign6421_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_outer_join_sign6421	= { FOLLOW_LPAREN_in_outer_join_sign6421_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PLUS_in_outer_join_sign6423  */
static	ANTLR3_BITWORD FOLLOW_PLUS_in_outer_join_sign6423_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PLUS_in_outer_join_sign6423	= { FOLLOW_PLUS_in_outer_join_sign6423_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_outer_join_sign6425  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_outer_join_sign6425_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_outer_join_sign6425	= { FOLLOW_RPAREN_in_outer_join_sign6425_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_table_name_long6437  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_table_name_long6437_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_table_name_long6437	= { FOLLOW_schema_name_in_table_name_long6437_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_table_name_long6439  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_table_name_long6439_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_table_name_long6439	= { FOLLOW_DOT_in_table_name_long6439_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_name_in_table_name_long6444  */
static	ANTLR3_BITWORD FOLLOW_table_name_in_table_name_long6444_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_table_name_in_table_name_long6444	= { FOLLOW_table_name_in_table_name_long6444_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_table_name6469  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_table_name6469_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_table_name6469	= { FOLLOW_sql_identifier_in_table_name6469_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_schema_name6480  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_schema_name6480_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_schema_name6480	= { FOLLOW_sql_identifier_in_schema_name6480_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_package_name6491  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_package_name6491_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_package_name6491	= { FOLLOW_sql_identifier_in_package_name6491_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_dblink_name6503  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_dblink_name6503_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_dblink_name6503	= { FOLLOW_sql_identifier_in_dblink_name6503_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_column_specs6515  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_column_specs6515_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_column_specs6515	= { FOLLOW_column_spec_in_column_specs6515_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_column_specs6519  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_column_specs6519_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_column_specs6519	= { FOLLOW_COMMA_in_column_specs6519_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_column_specs6521  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_column_specs6521_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_column_specs6521	= { FOLLOW_column_spec_in_column_specs6521_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_partition6534  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_partition6534_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_partition6534	= { FOLLOW_identifier_in_partition6534_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_partition_key_value6553  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_partition_key_value6553_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_partition_key_value6553	= { FOLLOW_identifier_in_partition_key_value6553_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_partition_key_value6558  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_partition_key_value6558_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_partition_key_value6558	= { FOLLOW_NUMBER_in_partition_key_value6558_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_subpartition_key_value6568  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_subpartition_key_value6568_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_subpartition_key_value6568	= { FOLLOW_identifier_in_subpartition_key_value6568_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_subpartition_key_value6573  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_subpartition_key_value6573_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_subpartition_key_value6573	= { FOLLOW_NUMBER_in_subpartition_key_value6573_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_constraint6583  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_constraint6583_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_constraint6583	= { FOLLOW_sql_identifier_in_constraint6583_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_collection_expression6594  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_collection_expression6594_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_collection_expression6594	= { FOLLOW_subquery_in_collection_expression6594_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_collection_expression6602  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_collection_expression6602_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3966000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_collection_expression6602	= { FOLLOW_LPAREN_in_collection_expression6602_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cast_expression_in_collection_expression6605  */
static	ANTLR3_BITWORD FOLLOW_cast_expression_in_collection_expression6605_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_cast_expression_in_collection_expression6605	= { FOLLOW_cast_expression_in_collection_expression6605_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_expression_in_collection_expression6607  */
static	ANTLR3_BITWORD FOLLOW_function_expression_in_collection_expression6607_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_function_expression_in_collection_expression6607	= { FOLLOW_function_expression_in_collection_expression6607_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_collection_expression6610  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_collection_expression6610_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_collection_expression6610	= { FOLLOW_RPAREN_in_collection_expression6610_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_collection_expression6618  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_collection_expression6618_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_collection_expression6618	= { FOLLOW_LPAREN_in_collection_expression6618_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_collection_expression6620  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_collection_expression6620_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_collection_expression6620	= { FOLLOW_column_spec_in_collection_expression6620_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_collection_expression6622  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_collection_expression6622_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_collection_expression6622	= { FOLLOW_RPAREN_in_collection_expression6622_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_where_in_where_clause6698  */
static	ANTLR3_BITWORD FOLLOW_r_where_in_where_clause6698_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_where_in_where_clause6698	= { FOLLOW_r_where_in_where_clause6698_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_where_clause6700  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_where_clause6700_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_where_clause6700	= { FOLLOW_sql_condition_in_where_clause6700_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_connect_in_hierarchical_query_clause6731  */
static	ANTLR3_BITWORD FOLLOW_r_connect_in_hierarchical_query_clause6731_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_connect_in_hierarchical_query_clause6731	= { FOLLOW_r_connect_in_hierarchical_query_clause6731_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_hierarchical_query_clause6733  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_hierarchical_query_clause6733_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_hierarchical_query_clause6733	= { FOLLOW_r_by_in_hierarchical_query_clause6733_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nocycle_in_hierarchical_query_clause6737  */
static	ANTLR3_BITWORD FOLLOW_k_nocycle_in_hierarchical_query_clause6737_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nocycle_in_hierarchical_query_clause6737	= { FOLLOW_k_nocycle_in_hierarchical_query_clause6737_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_hierarchical_query_clause6744  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_hierarchical_query_clause6744_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020), ANTLR3_UINT64_LIT(0x0000000000008000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_hierarchical_query_clause6744	= { FOLLOW_sql_condition_in_hierarchical_query_clause6744_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_start_in_hierarchical_query_clause6748  */
static	ANTLR3_BITWORD FOLLOW_r_start_in_hierarchical_query_clause6748_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_start_in_hierarchical_query_clause6748	= { FOLLOW_r_start_in_hierarchical_query_clause6748_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_with_in_hierarchical_query_clause6750  */
static	ANTLR3_BITWORD FOLLOW_r_with_in_hierarchical_query_clause6750_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_with_in_hierarchical_query_clause6750	= { FOLLOW_r_with_in_hierarchical_query_clause6750_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_hierarchical_query_clause6754  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_hierarchical_query_clause6754_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_hierarchical_query_clause6754	= { FOLLOW_sql_condition_in_hierarchical_query_clause6754_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_start_in_hierarchical_query_clause6791  */
static	ANTLR3_BITWORD FOLLOW_r_start_in_hierarchical_query_clause6791_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_start_in_hierarchical_query_clause6791	= { FOLLOW_r_start_in_hierarchical_query_clause6791_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_with_in_hierarchical_query_clause6793  */
static	ANTLR3_BITWORD FOLLOW_r_with_in_hierarchical_query_clause6793_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_with_in_hierarchical_query_clause6793	= { FOLLOW_r_with_in_hierarchical_query_clause6793_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_hierarchical_query_clause6797  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_hierarchical_query_clause6797_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_hierarchical_query_clause6797	= { FOLLOW_sql_condition_in_hierarchical_query_clause6797_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_connect_in_hierarchical_query_clause6801  */
static	ANTLR3_BITWORD FOLLOW_r_connect_in_hierarchical_query_clause6801_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_connect_in_hierarchical_query_clause6801	= { FOLLOW_r_connect_in_hierarchical_query_clause6801_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_hierarchical_query_clause6803  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_hierarchical_query_clause6803_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_hierarchical_query_clause6803	= { FOLLOW_r_by_in_hierarchical_query_clause6803_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nocycle_in_hierarchical_query_clause6807  */
static	ANTLR3_BITWORD FOLLOW_k_nocycle_in_hierarchical_query_clause6807_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nocycle_in_hierarchical_query_clause6807	= { FOLLOW_k_nocycle_in_hierarchical_query_clause6807_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_hierarchical_query_clause6814  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_hierarchical_query_clause6814_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_hierarchical_query_clause6814	= { FOLLOW_sql_condition_in_hierarchical_query_clause6814_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_having_in_group_by_clause6864  */
static	ANTLR3_BITWORD FOLLOW_r_having_in_group_by_clause6864_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_having_in_group_by_clause6864	= { FOLLOW_r_having_in_group_by_clause6864_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_group_by_clause6868  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_group_by_clause6868_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000003000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_group_by_clause6868	= { FOLLOW_sql_condition_in_group_by_clause6868_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_group_in_group_by_clause6873  */
static	ANTLR3_BITWORD FOLLOW_r_group_in_group_by_clause6873_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_group_in_group_by_clause6873	= { FOLLOW_r_group_in_group_by_clause6873_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_group_by_clause6877  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_group_by_clause6877_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_group_by_clause6877	= { FOLLOW_r_by_in_group_by_clause6877_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_exprs_in_group_by_clause6881  */
static	ANTLR3_BITWORD FOLLOW_group_by_exprs_in_group_by_clause6881_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_exprs_in_group_by_clause6881	= { FOLLOW_group_by_exprs_in_group_by_clause6881_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_group_in_group_by_clause6904  */
static	ANTLR3_BITWORD FOLLOW_r_group_in_group_by_clause6904_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_group_in_group_by_clause6904	= { FOLLOW_r_group_in_group_by_clause6904_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_group_by_clause6908  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_group_by_clause6908_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_group_by_clause6908	= { FOLLOW_r_by_in_group_by_clause6908_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_exprs_in_group_by_clause6912  */
static	ANTLR3_BITWORD FOLLOW_group_by_exprs_in_group_by_clause6912_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_exprs_in_group_by_clause6912	= { FOLLOW_group_by_exprs_in_group_by_clause6912_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_having_in_group_by_clause6917  */
static	ANTLR3_BITWORD FOLLOW_r_having_in_group_by_clause6917_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_having_in_group_by_clause6917	= { FOLLOW_r_having_in_group_by_clause6917_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_group_by_clause6921  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_group_by_clause6921_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_group_by_clause6921	= { FOLLOW_sql_condition_in_group_by_clause6921_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_expr_in_group_by_exprs6982  */
static	ANTLR3_BITWORD FOLLOW_group_by_expr_in_group_by_exprs6982_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_expr_in_group_by_exprs6982	= { FOLLOW_group_by_expr_in_group_by_exprs6982_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_group_by_exprs6986  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_group_by_exprs6986_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_group_by_exprs6986	= { FOLLOW_COMMA_in_group_by_exprs6986_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_expr_in_group_by_exprs6988  */
static	ANTLR3_BITWORD FOLLOW_group_by_expr_in_group_by_exprs6988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_expr_in_group_by_exprs6988	= { FOLLOW_group_by_expr_in_group_by_exprs6988_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_rollup_cube_clause_in_group_by_expr7001  */
static	ANTLR3_BITWORD FOLLOW_rollup_cube_clause_in_group_by_expr7001_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_rollup_cube_clause_in_group_by_expr7001	= { FOLLOW_rollup_cube_clause_in_group_by_expr7001_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_sets_clause_in_group_by_expr7006  */
static	ANTLR3_BITWORD FOLLOW_grouping_sets_clause_in_group_by_expr7006_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_sets_clause_in_group_by_expr7006	= { FOLLOW_grouping_sets_clause_in_group_by_expr7006_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_expression_list_in_group_by_expr7011  */
static	ANTLR3_BITWORD FOLLOW_grouping_expression_list_in_group_by_expr7011_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_expression_list_in_group_by_expr7011	= { FOLLOW_grouping_expression_list_in_group_by_expr7011_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_rollup_in_rollup_cube_clause7023  */
static	ANTLR3_BITWORD FOLLOW_k_rollup_in_rollup_cube_clause7023_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_rollup_in_rollup_cube_clause7023	= { FOLLOW_k_rollup_in_rollup_cube_clause7023_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_cube_in_rollup_cube_clause7027  */
static	ANTLR3_BITWORD FOLLOW_k_cube_in_rollup_cube_clause7027_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_cube_in_rollup_cube_clause7027	= { FOLLOW_k_cube_in_rollup_cube_clause7027_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_rollup_cube_clause7031  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_rollup_cube_clause7031_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_rollup_cube_clause7031	= { FOLLOW_LPAREN_in_rollup_cube_clause7031_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_expression_list_in_rollup_cube_clause7033  */
static	ANTLR3_BITWORD FOLLOW_grouping_expression_list_in_rollup_cube_clause7033_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_expression_list_in_rollup_cube_clause7033	= { FOLLOW_grouping_expression_list_in_rollup_cube_clause7033_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_rollup_cube_clause7035  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_rollup_cube_clause7035_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_rollup_cube_clause7035	= { FOLLOW_RPAREN_in_rollup_cube_clause7035_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_grouping_in_grouping_sets_clause7045  */
static	ANTLR3_BITWORD FOLLOW_k_grouping_in_grouping_sets_clause7045_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_grouping_in_grouping_sets_clause7045	= { FOLLOW_k_grouping_in_grouping_sets_clause7045_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_sets_in_grouping_sets_clause7047  */
static	ANTLR3_BITWORD FOLLOW_k_sets_in_grouping_sets_clause7047_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_sets_in_grouping_sets_clause7047	= { FOLLOW_k_sets_in_grouping_sets_clause7047_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_grouping_sets_clause7049  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_grouping_sets_clause7049_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_grouping_sets_clause7049	= { FOLLOW_LPAREN_in_grouping_sets_clause7049_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_sets_expression_list_in_grouping_sets_clause7051  */
static	ANTLR3_BITWORD FOLLOW_grouping_sets_expression_list_in_grouping_sets_clause7051_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_sets_expression_list_in_grouping_sets_clause7051	= { FOLLOW_grouping_sets_expression_list_in_grouping_sets_clause7051_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_grouping_sets_clause7053  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_grouping_sets_clause7053_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_grouping_sets_clause7053	= { FOLLOW_RPAREN_in_grouping_sets_clause7053_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_sets_expr_in_grouping_sets_exprs7063  */
static	ANTLR3_BITWORD FOLLOW_grouping_sets_expr_in_grouping_sets_exprs7063_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_sets_expr_in_grouping_sets_exprs7063	= { FOLLOW_grouping_sets_expr_in_grouping_sets_exprs7063_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_grouping_sets_exprs7067  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_grouping_sets_exprs7067_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_grouping_sets_exprs7067	= { FOLLOW_COMMA_in_grouping_sets_exprs7067_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_sets_expr_in_grouping_sets_exprs7069  */
static	ANTLR3_BITWORD FOLLOW_grouping_sets_expr_in_grouping_sets_exprs7069_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_sets_expr_in_grouping_sets_exprs7069	= { FOLLOW_grouping_sets_expr_in_grouping_sets_exprs7069_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_rollup_cube_clause_in_grouping_sets_expr7082  */
static	ANTLR3_BITWORD FOLLOW_rollup_cube_clause_in_grouping_sets_expr7082_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_rollup_cube_clause_in_grouping_sets_expr7082	= { FOLLOW_rollup_cube_clause_in_grouping_sets_expr7082_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_expression_list_in_grouping_sets_expr7086  */
static	ANTLR3_BITWORD FOLLOW_grouping_expression_list_in_grouping_sets_expr7086_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_expression_list_in_grouping_sets_expr7086	= { FOLLOW_grouping_expression_list_in_grouping_sets_expr7086_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_or_in_sql_condition7096  */
static	ANTLR3_BITWORD FOLLOW_condition_or_in_sql_condition7096_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_or_in_sql_condition7096	= { FOLLOW_condition_or_in_sql_condition7096_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_and_in_condition_or7106  */
static	ANTLR3_BITWORD FOLLOW_condition_and_in_condition_or7106_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_and_in_condition_or7106	= { FOLLOW_condition_and_in_condition_or7106_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_or_in_condition_or7110  */
static	ANTLR3_BITWORD FOLLOW_r_or_in_condition_or7110_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_or_in_condition_or7110	= { FOLLOW_r_or_in_condition_or7110_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_and_in_condition_or7112  */
static	ANTLR3_BITWORD FOLLOW_condition_and_in_condition_or7112_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_and_in_condition_or7112	= { FOLLOW_condition_and_in_condition_or7112_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_not_in_condition_and7143  */
static	ANTLR3_BITWORD FOLLOW_condition_not_in_condition_and7143_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_not_in_condition_and7143	= { FOLLOW_condition_not_in_condition_and7143_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_and_in_condition_and7147  */
static	ANTLR3_BITWORD FOLLOW_r_and_in_condition_and7147_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_and_in_condition_and7147	= { FOLLOW_r_and_in_condition_and7147_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_not_in_condition_and7149  */
static	ANTLR3_BITWORD FOLLOW_condition_not_in_condition_and7149_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_not_in_condition_and7149	= { FOLLOW_condition_not_in_condition_and7149_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_not7180  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_not7180_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_not7180	= { FOLLOW_r_not_in_condition_not7180_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_expr_in_condition_not7182  */
static	ANTLR3_BITWORD FOLLOW_condition_expr_in_condition_not7182_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_expr_in_condition_not7182	= { FOLLOW_condition_expr_in_condition_not7182_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_expr_in_condition_not7197  */
static	ANTLR3_BITWORD FOLLOW_condition_expr_in_condition_not7197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_expr_in_condition_not7197	= { FOLLOW_condition_expr_in_condition_not7197_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_exists_in_condition_expr7213  */
static	ANTLR3_BITWORD FOLLOW_condition_exists_in_condition_expr7213_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_exists_in_condition_expr7213	= { FOLLOW_condition_exists_in_condition_expr7213_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_paren_in_condition_expr7227  */
static	ANTLR3_BITWORD FOLLOW_condition_paren_in_condition_expr7227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_paren_in_condition_expr7227	= { FOLLOW_condition_paren_in_condition_expr7227_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_in_condition_expr7232  */
static	ANTLR3_BITWORD FOLLOW_condition_is_in_condition_expr7232_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_in_condition_expr7232	= { FOLLOW_condition_is_in_condition_expr7232_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_comparison_in_condition_expr7240  */
static	ANTLR3_BITWORD FOLLOW_condition_comparison_in_condition_expr7240_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_comparison_in_condition_expr7240	= { FOLLOW_condition_comparison_in_condition_expr7240_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_group_comparison_in_condition_expr7245  */
static	ANTLR3_BITWORD FOLLOW_condition_group_comparison_in_condition_expr7245_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_group_comparison_in_condition_expr7245	= { FOLLOW_condition_group_comparison_in_condition_expr7245_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_in_in_condition_expr7250  */
static	ANTLR3_BITWORD FOLLOW_condition_in_in_condition_expr7250_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_in_in_condition_expr7250	= { FOLLOW_condition_in_in_condition_expr7250_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_a_set_in_condition_expr7255  */
static	ANTLR3_BITWORD FOLLOW_condition_is_a_set_in_condition_expr7255_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_a_set_in_condition_expr7255	= { FOLLOW_condition_is_a_set_in_condition_expr7255_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_any_in_condition_expr7260  */
static	ANTLR3_BITWORD FOLLOW_condition_is_any_in_condition_expr7260_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_any_in_condition_expr7260	= { FOLLOW_condition_is_any_in_condition_expr7260_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_empty_in_condition_expr7265  */
static	ANTLR3_BITWORD FOLLOW_condition_is_empty_in_condition_expr7265_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_empty_in_condition_expr7265	= { FOLLOW_condition_is_empty_in_condition_expr7265_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_of_type_in_condition_expr7270  */
static	ANTLR3_BITWORD FOLLOW_condition_is_of_type_in_condition_expr7270_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_of_type_in_condition_expr7270	= { FOLLOW_condition_is_of_type_in_condition_expr7270_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_present_in_condition_expr7275  */
static	ANTLR3_BITWORD FOLLOW_condition_is_present_in_condition_expr7275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_present_in_condition_expr7275	= { FOLLOW_condition_is_present_in_condition_expr7275_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_like_in_condition_expr7280  */
static	ANTLR3_BITWORD FOLLOW_condition_like_in_condition_expr7280_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_like_in_condition_expr7280	= { FOLLOW_condition_like_in_condition_expr7280_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_memeber_in_condition_expr7285  */
static	ANTLR3_BITWORD FOLLOW_condition_memeber_in_condition_expr7285_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_memeber_in_condition_expr7285	= { FOLLOW_condition_memeber_in_condition_expr7285_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_between_in_condition_expr7290  */
static	ANTLR3_BITWORD FOLLOW_condition_between_in_condition_expr7290_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_between_in_condition_expr7290	= { FOLLOW_condition_between_in_condition_expr7290_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_regexp_like_in_condition_expr7295  */
static	ANTLR3_BITWORD FOLLOW_condition_regexp_like_in_condition_expr7295_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_regexp_like_in_condition_expr7295	= { FOLLOW_condition_regexp_like_in_condition_expr7295_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_submultiset_in_condition_expr7300  */
static	ANTLR3_BITWORD FOLLOW_condition_submultiset_in_condition_expr7300_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_submultiset_in_condition_expr7300	= { FOLLOW_condition_submultiset_in_condition_expr7300_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_equals_path_in_condition_expr7305  */
static	ANTLR3_BITWORD FOLLOW_condition_equals_path_in_condition_expr7305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_equals_path_in_condition_expr7305	= { FOLLOW_condition_equals_path_in_condition_expr7305_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_under_path_in_condition_expr7310  */
static	ANTLR3_BITWORD FOLLOW_condition_under_path_in_condition_expr7310_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_under_path_in_condition_expr7310	= { FOLLOW_condition_under_path_in_condition_expr7310_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_paren_in_condition_expr7315  */
static	ANTLR3_BITWORD FOLLOW_condition_paren_in_condition_expr7315_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_paren_in_condition_expr7315	= { FOLLOW_condition_paren_in_condition_expr7315_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_exists_in_condition_exists7326  */
static	ANTLR3_BITWORD FOLLOW_r_exists_in_condition_exists7326_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_exists_in_condition_exists7326	= { FOLLOW_r_exists_in_condition_exists7326_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_condition_exists7328  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_condition_exists7328_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_condition_exists7328	= { FOLLOW_subquery_in_condition_exists7328_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_condition_is7338  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_condition_is7338_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_condition_is7338	= { FOLLOW_column_spec_in_condition_is7338_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_condition_is7340  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_condition_is7340_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_condition_is7340	= { FOLLOW_outer_join_sign_in_condition_is7340_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_is_in_condition_is7343  */
static	ANTLR3_BITWORD FOLLOW_r_is_in_condition_is7343_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004800000000000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_r_is_in_condition_is7343	= { FOLLOW_r_is_in_condition_is7343_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_is7347  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_is7347_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004000000000000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_is7347	= { FOLLOW_r_not_in_condition_is7347_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nan_in_condition_is7354  */
static	ANTLR3_BITWORD FOLLOW_k_nan_in_condition_is7354_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nan_in_condition_is7354	= { FOLLOW_k_nan_in_condition_is7354_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_infinite_in_condition_is7358  */
static	ANTLR3_BITWORD FOLLOW_k_infinite_in_condition_is7358_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_infinite_in_condition_is7358	= { FOLLOW_k_infinite_in_condition_is7358_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_null_in_condition_is7362  */
static	ANTLR3_BITWORD FOLLOW_r_null_in_condition_is7362_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_null_in_condition_is7362	= { FOLLOW_r_null_in_condition_is7362_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_is7369  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_is7369_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_is7369	= { FOLLOW_sql_expression_in_condition_is7369_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_is_in_condition_is7372  */
static	ANTLR3_BITWORD FOLLOW_r_is_in_condition_is7372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004800000000000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_r_is_in_condition_is7372	= { FOLLOW_r_is_in_condition_is7372_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_is7376  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_is7376_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004000000000000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_is7376	= { FOLLOW_r_not_in_condition_is7376_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nan_in_condition_is7383  */
static	ANTLR3_BITWORD FOLLOW_k_nan_in_condition_is7383_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nan_in_condition_is7383	= { FOLLOW_k_nan_in_condition_is7383_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_infinite_in_condition_is7387  */
static	ANTLR3_BITWORD FOLLOW_k_infinite_in_condition_is7387_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_infinite_in_condition_is7387	= { FOLLOW_k_infinite_in_condition_is7387_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_null_in_condition_is7391  */
static	ANTLR3_BITWORD FOLLOW_r_null_in_condition_is7391_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_null_in_condition_is7391	= { FOLLOW_r_null_in_condition_is7391_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_comparison7421  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_comparison7421_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_comparison7421	= { FOLLOW_LPAREN_in_condition_comparison7421_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_condition_comparison7423  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_condition_comparison7423_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_condition_comparison7423	= { FOLLOW_sql_expressions_in_condition_comparison7423_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_comparison7425  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_comparison7425_bits[]	= { ANTLR3_UINT64_LIT(0xA000000000000000), ANTLR3_UINT64_LIT(0x0000020000100000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000030000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_comparison7425	= { FOLLOW_RPAREN_in_condition_comparison7425_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_condition_comparison7429  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_condition_comparison7429_bits[]	= { ANTLR3_UINT64_LIT(0xA000000000000000), ANTLR3_UINT64_LIT(0x0000020000100000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000030000000) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_condition_comparison7429	= { FOLLOW_outer_join_sign_in_condition_comparison7429_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_condition_comparison7434  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_condition_comparison7434_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_condition_comparison7434	= { FOLLOW_EQ_in_condition_comparison7434_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_not_equal_in_condition_comparison7438  */
static	ANTLR3_BITWORD FOLLOW_not_equal_in_condition_comparison7438_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_not_equal_in_condition_comparison7438	= { FOLLOW_not_equal_in_condition_comparison7438_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_condition_comparison7442  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_condition_comparison7442_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_condition_comparison7442	= { FOLLOW_subquery_in_condition_comparison7442_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_condition_comparison7446  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_condition_comparison7446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_condition_comparison7446	= { FOLLOW_outer_join_sign_in_condition_comparison7446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_prior_in_condition_comparison7501  */
static	ANTLR3_BITWORD FOLLOW_r_prior_in_condition_comparison7501_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_prior_in_condition_comparison7501	= { FOLLOW_r_prior_in_condition_comparison7501_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_comparison7506  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_comparison7506_bits[]	= { ANTLR3_UINT64_LIT(0xA000000000000000), ANTLR3_UINT64_LIT(0x00000E0000180000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000030000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_comparison7506	= { FOLLOW_sql_expression_in_condition_comparison7506_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_condition_comparison7510  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_condition_comparison7510_bits[]	= { ANTLR3_UINT64_LIT(0xA000000000000000), ANTLR3_UINT64_LIT(0x00000E0000180000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000030000000) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_condition_comparison7510	= { FOLLOW_outer_join_sign_in_condition_comparison7510_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_condition_comparison7515  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_condition_comparison7515_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_condition_comparison7515	= { FOLLOW_EQ_in_condition_comparison7515_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_not_equal_in_condition_comparison7519  */
static	ANTLR3_BITWORD FOLLOW_not_equal_in_condition_comparison7519_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_not_equal_in_condition_comparison7519	= { FOLLOW_not_equal_in_condition_comparison7519_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GTH_in_condition_comparison7523  */
static	ANTLR3_BITWORD FOLLOW_GTH_in_condition_comparison7523_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_GTH_in_condition_comparison7523	= { FOLLOW_GTH_in_condition_comparison7523_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_geq_in_condition_comparison7527  */
static	ANTLR3_BITWORD FOLLOW_geq_in_condition_comparison7527_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_geq_in_condition_comparison7527	= { FOLLOW_geq_in_condition_comparison7527_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LTH_in_condition_comparison7531  */
static	ANTLR3_BITWORD FOLLOW_LTH_in_condition_comparison7531_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LTH_in_condition_comparison7531	= { FOLLOW_LTH_in_condition_comparison7531_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_leq_in_condition_comparison7535  */
static	ANTLR3_BITWORD FOLLOW_leq_in_condition_comparison7535_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_leq_in_condition_comparison7535	= { FOLLOW_leq_in_condition_comparison7535_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_prior_in_condition_comparison7541  */
static	ANTLR3_BITWORD FOLLOW_r_prior_in_condition_comparison7541_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_prior_in_condition_comparison7541	= { FOLLOW_r_prior_in_condition_comparison7541_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_comparison7548  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_comparison7548_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_comparison7548	= { FOLLOW_sql_expression_in_condition_comparison7548_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_comparison7552  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_comparison7552_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_comparison7552	= { FOLLOW_LPAREN_in_condition_comparison7552_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_condition_comparison7554  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_condition_comparison7554_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_condition_comparison7554	= { FOLLOW_select_statement_in_condition_comparison7554_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_comparison7556  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_comparison7556_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_comparison7556	= { FOLLOW_RPAREN_in_condition_comparison7556_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_condition_comparison7562  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_condition_comparison7562_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_condition_comparison7562	= { FOLLOW_outer_join_sign_in_condition_comparison7562_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_group_comparison7634  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_group_comparison7634_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_group_comparison7634	= { FOLLOW_LPAREN_in_condition_group_comparison7634_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_condition_group_comparison7636  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_condition_group_comparison7636_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_condition_group_comparison7636	= { FOLLOW_sql_expressions_in_condition_group_comparison7636_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_group_comparison7638  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_group_comparison7638_bits[]	= { ANTLR3_UINT64_LIT(0xA000000000000000), ANTLR3_UINT64_LIT(0x0000020000100000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000030000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_group_comparison7638	= { FOLLOW_RPAREN_in_condition_group_comparison7638_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_condition_group_comparison7642  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_condition_group_comparison7642_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4090000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094D94B4) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_condition_group_comparison7642	= { FOLLOW_EQ_in_condition_group_comparison7642_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_not_equal_in_condition_group_comparison7646  */
static	ANTLR3_BITWORD FOLLOW_not_equal_in_condition_group_comparison7646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4090000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094D94B4) };
static  ANTLR3_BITSET_LIST FOLLOW_not_equal_in_condition_group_comparison7646	= { FOLLOW_not_equal_in_condition_group_comparison7646_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_any_in_condition_group_comparison7652  */
static	ANTLR3_BITWORD FOLLOW_r_any_in_condition_group_comparison7652_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_any_in_condition_group_comparison7652	= { FOLLOW_r_any_in_condition_group_comparison7652_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_some_in_condition_group_comparison7656  */
static	ANTLR3_BITWORD FOLLOW_k_some_in_condition_group_comparison7656_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_some_in_condition_group_comparison7656	= { FOLLOW_k_some_in_condition_group_comparison7656_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_condition_group_comparison7660  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_condition_group_comparison7660_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_condition_group_comparison7660	= { FOLLOW_r_all_in_condition_group_comparison7660_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_group_comparison7664  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_group_comparison7664_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FF010840550), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_group_comparison7664	= { FOLLOW_LPAREN_in_condition_group_comparison7664_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_expression_list_in_condition_group_comparison7668  */
static	ANTLR3_BITWORD FOLLOW_grouping_expression_list_in_condition_group_comparison7668_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_expression_list_in_condition_group_comparison7668	= { FOLLOW_grouping_expression_list_in_condition_group_comparison7668_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_condition_group_comparison7672  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_condition_group_comparison7672_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_condition_group_comparison7672	= { FOLLOW_select_statement_in_condition_group_comparison7672_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_group_comparison7676  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_group_comparison7676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_group_comparison7676	= { FOLLOW_RPAREN_in_condition_group_comparison7676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_group_comparison7681  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_group_comparison7681_bits[]	= { ANTLR3_UINT64_LIT(0xA000000000000000), ANTLR3_UINT64_LIT(0x00000E0000180000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000030000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_group_comparison7681	= { FOLLOW_sql_expression_in_condition_group_comparison7681_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_condition_group_comparison7685  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_condition_group_comparison7685_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4090000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094D94B4) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_condition_group_comparison7685	= { FOLLOW_EQ_in_condition_group_comparison7685_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_not_equal_in_condition_group_comparison7689  */
static	ANTLR3_BITWORD FOLLOW_not_equal_in_condition_group_comparison7689_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4090000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094D94B4) };
static  ANTLR3_BITSET_LIST FOLLOW_not_equal_in_condition_group_comparison7689	= { FOLLOW_not_equal_in_condition_group_comparison7689_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GTH_in_condition_group_comparison7693  */
static	ANTLR3_BITWORD FOLLOW_GTH_in_condition_group_comparison7693_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4090000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094D94B4) };
static  ANTLR3_BITSET_LIST FOLLOW_GTH_in_condition_group_comparison7693	= { FOLLOW_GTH_in_condition_group_comparison7693_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_geq_in_condition_group_comparison7697  */
static	ANTLR3_BITWORD FOLLOW_geq_in_condition_group_comparison7697_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4090000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094D94B4) };
static  ANTLR3_BITSET_LIST FOLLOW_geq_in_condition_group_comparison7697	= { FOLLOW_geq_in_condition_group_comparison7697_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LTH_in_condition_group_comparison7701  */
static	ANTLR3_BITWORD FOLLOW_LTH_in_condition_group_comparison7701_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4090000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094D94B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LTH_in_condition_group_comparison7701	= { FOLLOW_LTH_in_condition_group_comparison7701_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_leq_in_condition_group_comparison7705  */
static	ANTLR3_BITWORD FOLLOW_leq_in_condition_group_comparison7705_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4090000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094D94B4) };
static  ANTLR3_BITSET_LIST FOLLOW_leq_in_condition_group_comparison7705	= { FOLLOW_leq_in_condition_group_comparison7705_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_any_in_condition_group_comparison7711  */
static	ANTLR3_BITWORD FOLLOW_r_any_in_condition_group_comparison7711_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_any_in_condition_group_comparison7711	= { FOLLOW_r_any_in_condition_group_comparison7711_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_some_in_condition_group_comparison7715  */
static	ANTLR3_BITWORD FOLLOW_k_some_in_condition_group_comparison7715_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_some_in_condition_group_comparison7715	= { FOLLOW_k_some_in_condition_group_comparison7715_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_condition_group_comparison7719  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_condition_group_comparison7719_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_condition_group_comparison7719	= { FOLLOW_r_all_in_condition_group_comparison7719_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_group_comparison7723  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_group_comparison7723_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FF010840550), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_group_comparison7723	= { FOLLOW_LPAREN_in_condition_group_comparison7723_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_condition_group_comparison7727  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_condition_group_comparison7727_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_condition_group_comparison7727	= { FOLLOW_sql_expressions_in_condition_group_comparison7727_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_condition_group_comparison7731  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_condition_group_comparison7731_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_condition_group_comparison7731	= { FOLLOW_select_statement_in_condition_group_comparison7731_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_group_comparison7735  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_group_comparison7735_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_group_comparison7735	= { FOLLOW_RPAREN_in_condition_group_comparison7735_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_in7746  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_in7746_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_in7746	= { FOLLOW_LPAREN_in_condition_in7746_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_condition_in7748  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_condition_in7748_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_condition_in7748	= { FOLLOW_sql_expressions_in_condition_in7748_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_in7750  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_in7750_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800010000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_in7750	= { FOLLOW_RPAREN_in_condition_in7750_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_in7754  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_in7754_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800010000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_in7754	= { FOLLOW_r_not_in_condition_in7754_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_in_in_condition_in7759  */
static	ANTLR3_BITWORD FOLLOW_r_in_in_condition_in7759_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_in_in_condition_in7759	= { FOLLOW_r_in_in_condition_in7759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_in7761  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_in7761_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FF010840550), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_in7761	= { FOLLOW_LPAREN_in_condition_in7761_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_expression_list_in_condition_in7765  */
static	ANTLR3_BITWORD FOLLOW_grouping_expression_list_in_condition_in7765_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_expression_list_in_condition_in7765	= { FOLLOW_grouping_expression_list_in_condition_in7765_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_condition_in7769  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_condition_in7769_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_condition_in7769	= { FOLLOW_select_statement_in_condition_in7769_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_in7773  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_in7773_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_in7773	= { FOLLOW_RPAREN_in_condition_in7773_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_in7778  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_in7778_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800010000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_in7778	= { FOLLOW_sql_expression_in_condition_in7778_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_in7782  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_in7782_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800010000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_in7782	= { FOLLOW_r_not_in_condition_in7782_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_in_in_condition_in7787  */
static	ANTLR3_BITWORD FOLLOW_r_in_in_condition_in7787_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_in_in_condition_in7787	= { FOLLOW_r_in_in_condition_in7787_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_in7789  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_in7789_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FF010840550), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_in7789	= { FOLLOW_LPAREN_in_condition_in7789_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_list_in_condition_in7793  */
static	ANTLR3_BITWORD FOLLOW_expression_list_in_condition_in7793_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_list_in_condition_in7793	= { FOLLOW_expression_list_in_condition_in7793_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_condition_in7797  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_condition_in7797_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_condition_in7797	= { FOLLOW_select_statement_in_condition_in7797_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_in7801  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_in7801_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_in7801	= { FOLLOW_RPAREN_in_condition_in7801_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_in7814  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_in7814_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800010000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_in7814	= { FOLLOW_sql_expression_in_condition_in7814_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_in7818  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_in7818_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800010000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_in7818	= { FOLLOW_r_not_in_condition_in7818_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_in_in_condition_in7823  */
static	ANTLR3_BITWORD FOLLOW_r_in_in_condition_in7823_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_in_in_condition_in7823	= { FOLLOW_r_in_in_condition_in7823_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_in7825  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_in7825_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_in7825	= { FOLLOW_sql_expression_in_condition_in7825_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_table_column_name_in_condition_is_a_set7835  */
static	ANTLR3_BITWORD FOLLOW_nested_table_column_name_in_condition_is_a_set7835_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_table_column_name_in_condition_is_a_set7835	= { FOLLOW_nested_table_column_name_in_condition_is_a_set7835_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_is_in_condition_is_a_set7837  */
static	ANTLR3_BITWORD FOLLOW_r_is_in_condition_is_a_set7837_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_is_in_condition_is_a_set7837	= { FOLLOW_r_is_in_condition_is_a_set7837_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_is_a_set7841  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_is_a_set7841_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_is_a_set7841	= { FOLLOW_r_not_in_condition_is_a_set7841_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_a_in_condition_is_a_set7846  */
static	ANTLR3_BITWORD FOLLOW_k_a_in_condition_is_a_set7846_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_k_a_in_condition_is_a_set7846	= { FOLLOW_k_a_in_condition_is_a_set7846_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_condition_is_a_set7848  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_condition_is_a_set7848_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_condition_is_a_set7848	= { FOLLOW_r_set_in_condition_is_a_set7848_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_name_in_condition_is_any7860  */
static	ANTLR3_BITWORD FOLLOW_column_name_in_condition_is_any7860_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_name_in_condition_is_any7860	= { FOLLOW_column_name_in_condition_is_any7860_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_is_in_condition_is_any7862  */
static	ANTLR3_BITWORD FOLLOW_r_is_in_condition_is_any7862_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4080000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_is_in_condition_is_any7862	= { FOLLOW_r_is_in_condition_is_any7862_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_any_in_condition_is_any7867  */
static	ANTLR3_BITWORD FOLLOW_r_any_in_condition_is_any7867_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_any_in_condition_is_any7867	= { FOLLOW_r_any_in_condition_is_any7867_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_table_column_name_in_condition_is_empty7877  */
static	ANTLR3_BITWORD FOLLOW_nested_table_column_name_in_condition_is_empty7877_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_table_column_name_in_condition_is_empty7877	= { FOLLOW_nested_table_column_name_in_condition_is_empty7877_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_is_in_condition_is_empty7879  */
static	ANTLR3_BITWORD FOLLOW_r_is_in_condition_is_empty7879_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_is_in_condition_is_empty7879	= { FOLLOW_r_is_in_condition_is_empty7879_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_is_empty7883  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_is_empty7883_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_is_empty7883	= { FOLLOW_r_not_in_condition_is_empty7883_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_empty_in_condition_is_empty7888  */
static	ANTLR3_BITWORD FOLLOW_k_empty_in_condition_is_empty7888_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_empty_in_condition_is_empty7888	= { FOLLOW_k_empty_in_condition_is_empty7888_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_is_of_type7898  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_is_of_type7898_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_is_of_type7898	= { FOLLOW_sql_expression_in_condition_is_of_type7898_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_is_in_condition_is_of_type7900  */
static	ANTLR3_BITWORD FOLLOW_r_is_in_condition_is_of_type7900_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0010800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_is_in_condition_is_of_type7900	= { FOLLOW_r_is_in_condition_is_of_type7900_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_is_of_type7903  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_is_of_type7903_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_is_of_type7903	= { FOLLOW_r_not_in_condition_is_of_type7903_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_of_in_condition_is_of_type7907  */
static	ANTLR3_BITWORD FOLLOW_r_of_in_condition_is_of_type7907_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_of_in_condition_is_of_type7907	= { FOLLOW_r_of_in_condition_is_of_type7907_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_type_in_condition_is_of_type7911  */
static	ANTLR3_BITWORD FOLLOW_k_type_in_condition_is_of_type7911_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_type_in_condition_is_of_type7911	= { FOLLOW_k_type_in_condition_is_of_type7911_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_is_of_type7916  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_is_of_type7916_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_is_of_type7916	= { FOLLOW_LPAREN_in_condition_is_of_type7916_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_names_in_condition_is_of_type7918  */
static	ANTLR3_BITWORD FOLLOW_type_names_in_condition_is_of_type7918_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_names_in_condition_is_of_type7918	= { FOLLOW_type_names_in_condition_is_of_type7918_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_is_of_type7920  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_is_of_type7920_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_is_of_type7920	= { FOLLOW_RPAREN_in_condition_is_of_type7920_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cell_reference_in_condition_is_present7936  */
static	ANTLR3_BITWORD FOLLOW_cell_reference_in_condition_is_present7936_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_cell_reference_in_condition_is_present7936	= { FOLLOW_cell_reference_in_condition_is_present7936_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_is_in_condition_is_present7938  */
static	ANTLR3_BITWORD FOLLOW_r_is_in_condition_is_present7938_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_is_in_condition_is_present7938	= { FOLLOW_r_is_in_condition_is_present7938_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_present_in_condition_is_present7940  */
static	ANTLR3_BITWORD FOLLOW_k_present_in_condition_is_present7940_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_present_in_condition_is_present7940	= { FOLLOW_k_present_in_condition_is_present7940_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_like7950  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_like7950_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000804000000000), ANTLR3_UINT64_LIT(0x3800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_like7950	= { FOLLOW_sql_expression_in_condition_like7950_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_like7954  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_like7954_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000804000000000), ANTLR3_UINT64_LIT(0x3800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_like7954	= { FOLLOW_r_not_in_condition_like7954_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_like_in_condition_like7961  */
static	ANTLR3_BITWORD FOLLOW_r_like_in_condition_like7961_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_like_in_condition_like7961	= { FOLLOW_r_like_in_condition_like7961_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_likec_in_condition_like7965  */
static	ANTLR3_BITWORD FOLLOW_k_likec_in_condition_like7965_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_likec_in_condition_like7965	= { FOLLOW_k_likec_in_condition_like7965_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_like2_in_condition_like7969  */
static	ANTLR3_BITWORD FOLLOW_k_like2_in_condition_like7969_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_like2_in_condition_like7969	= { FOLLOW_k_like2_in_condition_like7969_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_like4_in_condition_like7973  */
static	ANTLR3_BITWORD FOLLOW_k_like4_in_condition_like7973_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_like4_in_condition_like7973	= { FOLLOW_k_like4_in_condition_like7973_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_like7977  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_like7977_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_like7977	= { FOLLOW_sql_expression_in_condition_like7977_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_escape_in_condition_like7981  */
static	ANTLR3_BITWORD FOLLOW_k_escape_in_condition_like7981_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_escape_in_condition_like7981	= { FOLLOW_k_escape_in_condition_like7981_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_like7983  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_like7983_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_like7983	= { FOLLOW_sql_expression_in_condition_like7983_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_memeber7996  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_memeber7996_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800000000000), ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_memeber7996	= { FOLLOW_sql_expression_in_condition_memeber7996_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_memeber8000  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_memeber8000_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800000000000), ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_memeber8000	= { FOLLOW_r_not_in_condition_memeber8000_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_member_in_condition_memeber8005  */
static	ANTLR3_BITWORD FOLLOW_k_member_in_condition_memeber8005_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0010000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_member_in_condition_memeber8005	= { FOLLOW_k_member_in_condition_memeber8005_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_of_in_condition_memeber8009  */
static	ANTLR3_BITWORD FOLLOW_r_of_in_condition_memeber8009_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_of_in_condition_memeber8009	= { FOLLOW_r_of_in_condition_memeber8009_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_expression_in_condition_memeber8015  */
static	ANTLR3_BITWORD FOLLOW_function_expression_in_condition_memeber8015_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_function_expression_in_condition_memeber8015	= { FOLLOW_function_expression_in_condition_memeber8015_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_table_column_name_in_condition_memeber8017  */
static	ANTLR3_BITWORD FOLLOW_nested_table_column_name_in_condition_memeber8017_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_table_column_name_in_condition_memeber8017	= { FOLLOW_nested_table_column_name_in_condition_memeber8017_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_between8028  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_between8028_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_between8028	= { FOLLOW_sql_expression_in_condition_between8028_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_between8032  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_between8032_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x1000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_between8032	= { FOLLOW_r_not_in_condition_between8032_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_between_in_condition_between8037  */
static	ANTLR3_BITWORD FOLLOW_r_between_in_condition_between8037_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_between_in_condition_between8037	= { FOLLOW_r_between_in_condition_between8037_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_between8039  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_between8039_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_between8039	= { FOLLOW_sql_expression_in_condition_between8039_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_and_in_condition_between8041  */
static	ANTLR3_BITWORD FOLLOW_r_and_in_condition_between8041_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_and_in_condition_between8041	= { FOLLOW_r_and_in_condition_between8041_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_condition_between8043  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_condition_between8043_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_condition_between8043	= { FOLLOW_sql_expression_in_condition_between8043_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_regexp_like_in_condition_regexp_like8054  */
static	ANTLR3_BITWORD FOLLOW_k_regexp_like_in_condition_regexp_like8054_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_regexp_like_in_condition_regexp_like8054	= { FOLLOW_k_regexp_like_in_condition_regexp_like8054_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_regexp_like8056  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_regexp_like8056_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x400000000087026C), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_regexp_like8056	= { FOLLOW_LPAREN_in_condition_regexp_like8056_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_call_parameters_in_condition_regexp_like8058  */
static	ANTLR3_BITWORD FOLLOW_call_parameters_in_condition_regexp_like8058_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_call_parameters_in_condition_regexp_like8058	= { FOLLOW_call_parameters_in_condition_regexp_like8058_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_regexp_like8060  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_regexp_like8060_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_regexp_like8060	= { FOLLOW_RPAREN_in_condition_regexp_like8060_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_table_column_name_in_condition_submultiset8071  */
static	ANTLR3_BITWORD FOLLOW_nested_table_column_name_in_condition_submultiset8071_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_table_column_name_in_condition_submultiset8071	= { FOLLOW_nested_table_column_name_in_condition_submultiset8071_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_condition_submultiset8075  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_condition_submultiset8075_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_condition_submultiset8075	= { FOLLOW_r_not_in_condition_submultiset8075_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_submultiset_in_condition_submultiset8080  */
static	ANTLR3_BITWORD FOLLOW_k_submultiset_in_condition_submultiset8080_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0010000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_submultiset_in_condition_submultiset8080	= { FOLLOW_k_submultiset_in_condition_submultiset8080_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_of_in_condition_submultiset8084  */
static	ANTLR3_BITWORD FOLLOW_r_of_in_condition_submultiset8084_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_of_in_condition_submultiset8084	= { FOLLOW_r_of_in_condition_submultiset8084_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_table_column_name_in_condition_submultiset8089  */
static	ANTLR3_BITWORD FOLLOW_nested_table_column_name_in_condition_submultiset8089_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_table_column_name_in_condition_submultiset8089	= { FOLLOW_nested_table_column_name_in_condition_submultiset8089_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_equals_path_in_condition_equals_path8099  */
static	ANTLR3_BITWORD FOLLOW_k_equals_path_in_condition_equals_path8099_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_equals_path_in_condition_equals_path8099	= { FOLLOW_k_equals_path_in_condition_equals_path8099_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_equals_path8101  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_equals_path8101_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_equals_path8101	= { FOLLOW_LPAREN_in_condition_equals_path8101_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_name_in_condition_equals_path8103  */
static	ANTLR3_BITWORD FOLLOW_column_name_in_condition_equals_path8103_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_column_name_in_condition_equals_path8103	= { FOLLOW_column_name_in_condition_equals_path8103_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_condition_equals_path8105  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_condition_equals_path8105_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800200) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_condition_equals_path8105	= { FOLLOW_COMMA_in_condition_equals_path8105_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_path_string_in_condition_equals_path8107  */
static	ANTLR3_BITWORD FOLLOW_path_string_in_condition_equals_path8107_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_path_string_in_condition_equals_path8107	= { FOLLOW_path_string_in_condition_equals_path8107_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_condition_equals_path8111  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_condition_equals_path8111_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_condition_equals_path8111	= { FOLLOW_COMMA_in_condition_equals_path8111_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_correlation_integer_in_condition_equals_path8113  */
static	ANTLR3_BITWORD FOLLOW_correlation_integer_in_condition_equals_path8113_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_correlation_integer_in_condition_equals_path8113	= { FOLLOW_correlation_integer_in_condition_equals_path8113_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_equals_path8118  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_equals_path8118_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_equals_path8118	= { FOLLOW_RPAREN_in_condition_equals_path8118_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_under_path_in_condition_under_path8128  */
static	ANTLR3_BITWORD FOLLOW_k_under_path_in_condition_under_path8128_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_under_path_in_condition_under_path8128	= { FOLLOW_k_under_path_in_condition_under_path8128_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_under_path8130  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_under_path8130_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_under_path8130	= { FOLLOW_LPAREN_in_condition_under_path8130_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_name_in_condition_under_path8132  */
static	ANTLR3_BITWORD FOLLOW_column_name_in_condition_under_path8132_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_column_name_in_condition_under_path8132	= { FOLLOW_column_name_in_condition_under_path8132_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_condition_under_path8136  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_condition_under_path8136_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_condition_under_path8136	= { FOLLOW_COMMA_in_condition_under_path8136_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_levels_in_condition_under_path8138  */
static	ANTLR3_BITWORD FOLLOW_levels_in_condition_under_path8138_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_levels_in_condition_under_path8138	= { FOLLOW_levels_in_condition_under_path8138_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_condition_under_path8143  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_condition_under_path8143_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800200) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_condition_under_path8143	= { FOLLOW_COMMA_in_condition_under_path8143_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_path_string_in_condition_under_path8145  */
static	ANTLR3_BITWORD FOLLOW_path_string_in_condition_under_path8145_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_path_string_in_condition_under_path8145	= { FOLLOW_path_string_in_condition_under_path8145_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_condition_under_path8149  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_condition_under_path8149_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_condition_under_path8149	= { FOLLOW_COMMA_in_condition_under_path8149_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_correlation_integer_in_condition_under_path8151  */
static	ANTLR3_BITWORD FOLLOW_correlation_integer_in_condition_under_path8151_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_correlation_integer_in_condition_under_path8151	= { FOLLOW_correlation_integer_in_condition_under_path8151_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_under_path8156  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_under_path8156_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_under_path8156	= { FOLLOW_RPAREN_in_condition_under_path8156_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_integer_in_levels8166  */
static	ANTLR3_BITWORD FOLLOW_integer_in_levels8166_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_integer_in_levels8166	= { FOLLOW_integer_in_levels8166_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_integer_in_correlation_integer8176  */
static	ANTLR3_BITWORD FOLLOW_integer_in_correlation_integer8176_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_integer_in_correlation_integer8176	= { FOLLOW_integer_in_correlation_integer8176_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_path_string8186  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_path_string8186_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_path_string8186	= { FOLLOW_quoted_string_in_path_string8186_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_only_in_type_names8196  */
static	ANTLR3_BITWORD FOLLOW_k_only_in_type_names8196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_only_in_type_names8196	= { FOLLOW_k_only_in_type_names8196_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_type_names8200  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_type_names8200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_type_names8200	= { FOLLOW_schema_name_in_type_names8200_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_type_names8202  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_type_names8202_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_type_names8202	= { FOLLOW_DOT_in_type_names8202_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_type_names8206  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_type_names8206_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_type_names8206	= { FOLLOW_identifier_in_type_names8206_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_only_in_type_names8213  */
static	ANTLR3_BITWORD FOLLOW_k_only_in_type_names8213_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_only_in_type_names8213	= { FOLLOW_k_only_in_type_names8213_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_type_names8217  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_type_names8217_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_type_names8217	= { FOLLOW_schema_name_in_type_names8217_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_type_names8219  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_type_names8219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_type_names8219	= { FOLLOW_DOT_in_type_names8219_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_type_names8223  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_type_names8223_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_type_names8223	= { FOLLOW_identifier_in_type_names8223_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_integer8237  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_integer8237_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_integer8237	= { FOLLOW_NUMBER_in_integer8237_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_column_name8247  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_column_name8247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_column_name8247	= { FOLLOW_sql_identifier_in_column_name8247_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_nested_table8258  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_nested_table8258_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_nested_table8258	= { FOLLOW_sql_identifier_in_nested_table8258_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_nested_table_column_name8271  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_nested_table_column_name8271_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_nested_table_column_name8271	= { FOLLOW_schema_name_in_nested_table_column_name8271_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_nested_table_column_name8273  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_nested_table_column_name8273_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_nested_table_column_name8273	= { FOLLOW_DOT_in_nested_table_column_name8273_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_name_in_nested_table_column_name8279  */
static	ANTLR3_BITWORD FOLLOW_table_name_in_nested_table_column_name8279_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_table_name_in_nested_table_column_name8279	= { FOLLOW_table_name_in_nested_table_column_name8279_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_nested_table_column_name8281  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_nested_table_column_name8281_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_nested_table_column_name8281	= { FOLLOW_DOT_in_nested_table_column_name8281_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nested_table_in_nested_table_column_name8286  */
static	ANTLR3_BITWORD FOLLOW_nested_table_in_nested_table_column_name8286_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_nested_table_in_nested_table_column_name8286	= { FOLLOW_nested_table_in_nested_table_column_name8286_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_nested_table_column_name8288  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_nested_table_column_name8288_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_nested_table_column_name8288	= { FOLLOW_DOT_in_nested_table_column_name8288_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_name_in_nested_table_column_name8292  */
static	ANTLR3_BITWORD FOLLOW_column_name_in_nested_table_column_name8292_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_column_name_in_nested_table_column_name8292	= { FOLLOW_column_name_in_nested_table_column_name8292_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_sql_expressions8302  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_sql_expressions8302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_sql_expressions8302	= { FOLLOW_sql_expression_in_sql_expressions8302_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_sql_expressions8306  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_sql_expressions8306_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_sql_expressions8306	= { FOLLOW_COMMA_in_sql_expressions8306_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_sql_expressions8308  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_sql_expressions8308_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_sql_expressions8308	= { FOLLOW_sql_expression_in_sql_expressions8308_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_grouping_sets_expression_list8335  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_grouping_sets_expression_list8335_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_grouping_sets_expression_list8335	= { FOLLOW_LPAREN_in_grouping_sets_expression_list8335_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_grouping_sets_expression_list8337  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_grouping_sets_expression_list8337_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_grouping_sets_expression_list8337	= { FOLLOW_RPAREN_in_grouping_sets_expression_list8337_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_grouping_sets_expression_list8342  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_grouping_sets_expression_list8342_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_grouping_sets_expression_list8342	= { FOLLOW_LPAREN_in_grouping_sets_expression_list8342_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_grouping_sets_expression_list8344  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_grouping_sets_expression_list8344_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_grouping_sets_expression_list8344	= { FOLLOW_sql_expressions_in_grouping_sets_expression_list8344_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_grouping_sets_expression_list8346  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_grouping_sets_expression_list8346_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_grouping_sets_expression_list8346	= { FOLLOW_RPAREN_in_grouping_sets_expression_list8346_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_grouping_sets_expression_list8351  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_grouping_sets_expression_list8351_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_grouping_sets_expression_list8351	= { FOLLOW_sql_expression_in_grouping_sets_expression_list8351_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_grouping_sets_expression_list8359  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_grouping_sets_expression_list8359_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_grouping_sets_expression_list8359	= { FOLLOW_COMMA_in_grouping_sets_expression_list8359_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_grouping_sets_expression_list8365  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_grouping_sets_expression_list8365_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_grouping_sets_expression_list8365	= { FOLLOW_LPAREN_in_grouping_sets_expression_list8365_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_grouping_sets_expression_list8367  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_grouping_sets_expression_list8367_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_grouping_sets_expression_list8367	= { FOLLOW_RPAREN_in_grouping_sets_expression_list8367_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_grouping_sets_expression_list8374  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_grouping_sets_expression_list8374_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_grouping_sets_expression_list8374	= { FOLLOW_LPAREN_in_grouping_sets_expression_list8374_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_grouping_sets_expression_list8376  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_grouping_sets_expression_list8376_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_grouping_sets_expression_list8376	= { FOLLOW_sql_expressions_in_grouping_sets_expression_list8376_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_grouping_sets_expression_list8378  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_grouping_sets_expression_list8378_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_grouping_sets_expression_list8378	= { FOLLOW_RPAREN_in_grouping_sets_expression_list8378_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_grouping_sets_expression_list8384  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_grouping_sets_expression_list8384_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_grouping_sets_expression_list8384	= { FOLLOW_sql_expression_in_grouping_sets_expression_list8384_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_list_in_grouping_expression_list8402  */
static	ANTLR3_BITWORD FOLLOW_expression_list_in_grouping_expression_list8402_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_list_in_grouping_expression_list8402	= { FOLLOW_expression_list_in_grouping_expression_list8402_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_grouping_expression_list8406  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_grouping_expression_list8406_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_grouping_expression_list8406	= { FOLLOW_COMMA_in_grouping_expression_list8406_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_list_in_grouping_expression_list8408  */
static	ANTLR3_BITWORD FOLLOW_expression_list_in_grouping_expression_list8408_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_list_in_grouping_expression_list8408	= { FOLLOW_expression_list_in_grouping_expression_list8408_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_expression_list8421  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_expression_list8421_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_expression_list8421	= { FOLLOW_LPAREN_in_expression_list8421_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_expression_list8423  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_expression_list8423_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_expression_list8423	= { FOLLOW_sql_expressions_in_expression_list8423_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_expression_list8425  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_expression_list8425_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_expression_list8425	= { FOLLOW_RPAREN_in_expression_list8425_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_expression_list8430  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_expression_list8430_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_expression_list8430	= { FOLLOW_sql_expressions_in_expression_list8430_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_cell_reference8440  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_cell_reference8440_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_cell_reference8440	= { FOLLOW_sql_identifier_in_cell_reference8440_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_condition_paren8452  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_condition_paren8452_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_condition_paren8452	= { FOLLOW_LPAREN_in_condition_paren8452_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_condition_paren8454  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_condition_paren8454_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_condition_paren8454	= { FOLLOW_sql_condition_in_condition_paren8454_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_condition_paren8456  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_condition_paren8456_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_condition_paren8456	= { FOLLOW_RPAREN_in_condition_paren8456_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_model_in_model_clause8469  */
static	ANTLR3_BITWORD FOLLOW_k_model_in_model_clause8469_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000200000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_k_model_in_model_clause8469	= { FOLLOW_k_model_in_model_clause8469_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_main_model_in_model_clause8471  */
static	ANTLR3_BITWORD FOLLOW_main_model_in_model_clause8471_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000004000000), ANTLR3_UINT64_LIT(0x0000000000001400) };
static  ANTLR3_BITSET_LIST FOLLOW_main_model_in_model_clause8471	= { FOLLOW_main_model_in_model_clause8471_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cell_reference_options_in_model_clause8483  */
static	ANTLR3_BITWORD FOLLOW_cell_reference_options_in_model_clause8483_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000001400) };
static  ANTLR3_BITSET_LIST FOLLOW_cell_reference_options_in_model_clause8483	= { FOLLOW_cell_reference_options_in_model_clause8483_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_return_rows_clause_in_model_clause8492  */
static	ANTLR3_BITWORD FOLLOW_return_rows_clause_in_model_clause8492_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_return_rows_clause_in_model_clause8492	= { FOLLOW_return_rows_clause_in_model_clause8492_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_reference_model_in_model_clause8501  */
static	ANTLR3_BITWORD FOLLOW_reference_model_in_model_clause8501_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_reference_model_in_model_clause8501	= { FOLLOW_reference_model_in_model_clause8501_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_ignore_in_cell_reference_options8541  */
static	ANTLR3_BITWORD FOLLOW_k_ignore_in_cell_reference_options8541_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_k_ignore_in_cell_reference_options8541	= { FOLLOW_k_ignore_in_cell_reference_options8541_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_keep_in_cell_reference_options8545  */
static	ANTLR3_BITWORD FOLLOW_k_keep_in_cell_reference_options8545_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_k_keep_in_cell_reference_options8545	= { FOLLOW_k_keep_in_cell_reference_options8545_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nav_in_cell_reference_options8549  */
static	ANTLR3_BITWORD FOLLOW_k_nav_in_cell_reference_options8549_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nav_in_cell_reference_options8549	= { FOLLOW_k_nav_in_cell_reference_options8549_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_unique_in_cell_reference_options8558  */
static	ANTLR3_BITWORD FOLLOW_r_unique_in_cell_reference_options8558_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000200000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_r_unique_in_cell_reference_options8558	= { FOLLOW_r_unique_in_cell_reference_options8558_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dimension_in_cell_reference_options8562  */
static	ANTLR3_BITWORD FOLLOW_k_dimension_in_cell_reference_options8562_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dimension_in_cell_reference_options8562	= { FOLLOW_k_dimension_in_cell_reference_options8562_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_single_in_cell_reference_options8566  */
static	ANTLR3_BITWORD FOLLOW_k_single_in_cell_reference_options8566_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_k_single_in_cell_reference_options8566	= { FOLLOW_k_single_in_cell_reference_options8566_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_reference_in_cell_reference_options8568  */
static	ANTLR3_BITWORD FOLLOW_k_reference_in_cell_reference_options8568_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_reference_in_cell_reference_options8568	= { FOLLOW_k_reference_in_cell_reference_options8568_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_return_in_return_rows_clause8583  */
static	ANTLR3_BITWORD FOLLOW_k_return_in_return_rows_clause8583_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0010000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_return_in_return_rows_clause8583	= { FOLLOW_k_return_in_return_rows_clause8583_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_updated_in_return_rows_clause8587  */
static	ANTLR3_BITWORD FOLLOW_k_updated_in_return_rows_clause8587_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_k_updated_in_return_rows_clause8587	= { FOLLOW_k_updated_in_return_rows_clause8587_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_return_rows_clause8591  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_return_rows_clause8591_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_return_rows_clause8591	= { FOLLOW_r_all_in_return_rows_clause8591_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_rows_in_return_rows_clause8595  */
static	ANTLR3_BITWORD FOLLOW_r_rows_in_return_rows_clause8595_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_rows_in_return_rows_clause8595	= { FOLLOW_r_rows_in_return_rows_clause8595_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_reference_in_reference_model8605  */
static	ANTLR3_BITWORD FOLLOW_k_reference_in_reference_model8605_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_reference_in_reference_model8605	= { FOLLOW_k_reference_in_reference_model8605_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_reference_model_name_in_reference_model8607  */
static	ANTLR3_BITWORD FOLLOW_reference_model_name_in_reference_model8607_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_reference_model_name_in_reference_model8607	= { FOLLOW_reference_model_name_in_reference_model8607_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_on_in_reference_model8609  */
static	ANTLR3_BITWORD FOLLOW_r_on_in_reference_model8609_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_on_in_reference_model8609	= { FOLLOW_r_on_in_reference_model8609_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_reference_model8611  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_reference_model8611_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_reference_model8611	= { FOLLOW_LPAREN_in_reference_model8611_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_reference_model8613  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_reference_model8613_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_reference_model8613	= { FOLLOW_subquery_in_reference_model8613_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_reference_model8615  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_reference_model8615_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000200000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_reference_model8615	= { FOLLOW_RPAREN_in_reference_model8615_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_column_clauses_in_reference_model8619  */
static	ANTLR3_BITWORD FOLLOW_model_column_clauses_in_reference_model8619_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_model_column_clauses_in_reference_model8619	= { FOLLOW_model_column_clauses_in_reference_model8619_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cell_reference_options_in_reference_model8623  */
static	ANTLR3_BITWORD FOLLOW_cell_reference_options_in_reference_model8623_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cell_reference_options_in_reference_model8623	= { FOLLOW_cell_reference_options_in_reference_model8623_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_reference_model_name8635  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_reference_model_name8635_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_reference_model_name8635	= { FOLLOW_identifier_in_reference_model_name8635_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_main_in_main_model8648  */
static	ANTLR3_BITWORD FOLLOW_k_main_in_main_model8648_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_main_in_main_model8648	= { FOLLOW_k_main_in_main_model8648_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_main_model_name_in_main_model8650  */
static	ANTLR3_BITWORD FOLLOW_main_model_name_in_main_model8650_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000200000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_main_model_name_in_main_model8650	= { FOLLOW_main_model_name_in_main_model8650_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_column_clauses_in_main_model8655  */
static	ANTLR3_BITWORD FOLLOW_model_column_clauses_in_main_model8655_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_model_column_clauses_in_main_model8655	= { FOLLOW_model_column_clauses_in_main_model8655_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cell_reference_options_in_main_model8661  */
static	ANTLR3_BITWORD FOLLOW_cell_reference_options_in_main_model8661_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_cell_reference_options_in_main_model8661	= { FOLLOW_cell_reference_options_in_main_model8661_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_rules_clause_in_main_model8665  */
static	ANTLR3_BITWORD FOLLOW_model_rules_clause_in_main_model8665_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_model_rules_clause_in_main_model8665	= { FOLLOW_model_rules_clause_in_main_model8665_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_main_model_name8675  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_main_model_name8675_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_main_model_name8675	= { FOLLOW_identifier_in_main_model_name8675_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_partition_clause_in_model_column_clauses8688  */
static	ANTLR3_BITWORD FOLLOW_query_partition_clause_in_model_column_clauses8688_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xFAD3B62010040050), ANTLR3_UINT64_LIT(0x00000000094994F4) };
static  ANTLR3_BITSET_LIST FOLLOW_query_partition_clause_in_model_column_clauses8688	= { FOLLOW_query_partition_clause_in_model_column_clauses8688_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_model_column_clauses8692  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_model_column_clauses8692_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000200000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_model_column_clauses8692	= { FOLLOW_column_spec_in_model_column_clauses8692_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dimension_in_model_column_clauses8702  */
static	ANTLR3_BITWORD FOLLOW_k_dimension_in_model_column_clauses8702_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dimension_in_model_column_clauses8702	= { FOLLOW_k_dimension_in_model_column_clauses8702_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_model_column_clauses8704  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_model_column_clauses8704_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_model_column_clauses8704	= { FOLLOW_r_by_in_model_column_clauses8704_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_model_column_clauses8706  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_model_column_clauses8706_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_model_column_clauses8706	= { FOLLOW_LPAREN_in_model_column_clauses8706_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_columns_in_model_column_clauses8708  */
static	ANTLR3_BITWORD FOLLOW_model_columns_in_model_column_clauses8708_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_model_columns_in_model_column_clauses8708	= { FOLLOW_model_columns_in_model_column_clauses8708_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_model_column_clauses8710  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_model_column_clauses8710_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_model_column_clauses8710	= { FOLLOW_RPAREN_in_model_column_clauses8710_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_measures_in_model_column_clauses8714  */
static	ANTLR3_BITWORD FOLLOW_k_measures_in_model_column_clauses8714_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_measures_in_model_column_clauses8714	= { FOLLOW_k_measures_in_model_column_clauses8714_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_model_column_clauses8716  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_model_column_clauses8716_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_model_column_clauses8716	= { FOLLOW_LPAREN_in_model_column_clauses8716_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_columns_in_model_column_clauses8718  */
static	ANTLR3_BITWORD FOLLOW_model_columns_in_model_column_clauses8718_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_model_columns_in_model_column_clauses8718	= { FOLLOW_model_columns_in_model_column_clauses8718_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_model_column_clauses8720  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_model_column_clauses8720_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_model_column_clauses8720	= { FOLLOW_RPAREN_in_model_column_clauses8720_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_column_in_model_columns8730  */
static	ANTLR3_BITWORD FOLLOW_model_column_in_model_columns8730_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_model_column_in_model_columns8730	= { FOLLOW_model_column_in_model_columns8730_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_model_columns8734  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_model_columns8734_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_model_columns8734	= { FOLLOW_COMMA_in_model_columns8734_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_column_in_model_columns8736  */
static	ANTLR3_BITWORD FOLLOW_model_column_in_model_columns8736_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_model_column_in_model_columns8736	= { FOLLOW_model_column_in_model_columns8736_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_model_column8749  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_model_column8749_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x4200000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_model_column8749	= { FOLLOW_sql_expression_in_model_column8749_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_as_in_model_column8755  */
static	ANTLR3_BITWORD FOLLOW_r_as_in_model_column8755_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_as_in_model_column8755	= { FOLLOW_r_as_in_model_column8755_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_model_column8760  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_model_column8760_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_model_column8760	= { FOLLOW_column_spec_in_model_column8760_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_rules_in_model_rules_clause8775  */
static	ANTLR3_BITWORD FOLLOW_k_rules_in_model_rules_clause8775_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_rules_in_model_rules_clause8775	= { FOLLOW_k_rules_in_model_rules_clause8775_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_update_in_model_rules_clause8779  */
static	ANTLR3_BITWORD FOLLOW_r_update_in_model_rules_clause8779_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_update_in_model_rules_clause8779	= { FOLLOW_r_update_in_model_rules_clause8779_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_upsert_in_model_rules_clause8783  */
static	ANTLR3_BITWORD FOLLOW_k_upsert_in_model_rules_clause8783_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0010000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_upsert_in_model_rules_clause8783	= { FOLLOW_k_upsert_in_model_rules_clause8783_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_model_rules_clause8787  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_model_rules_clause8787_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_model_rules_clause8787	= { FOLLOW_r_all_in_model_rules_clause8787_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_automatic_in_model_rules_clause8799  */
static	ANTLR3_BITWORD FOLLOW_k_automatic_in_model_rules_clause8799_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_automatic_in_model_rules_clause8799	= { FOLLOW_k_automatic_in_model_rules_clause8799_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_sequential_in_model_rules_clause8803  */
static	ANTLR3_BITWORD FOLLOW_k_sequential_in_model_rules_clause8803_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_sequential_in_model_rules_clause8803	= { FOLLOW_k_sequential_in_model_rules_clause8803_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_order_in_model_rules_clause8807  */
static	ANTLR3_BITWORD FOLLOW_r_order_in_model_rules_clause8807_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_order_in_model_rules_clause8807	= { FOLLOW_r_order_in_model_rules_clause8807_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_iterate_in_model_rules_clause8819  */
static	ANTLR3_BITWORD FOLLOW_k_iterate_in_model_rules_clause8819_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_iterate_in_model_rules_clause8819	= { FOLLOW_k_iterate_in_model_rules_clause8819_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_model_rules_clause8821  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_model_rules_clause8821_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_model_rules_clause8821	= { FOLLOW_LPAREN_in_model_rules_clause8821_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_model_rules_clause8823  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_model_rules_clause8823_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_model_rules_clause8823	= { FOLLOW_NUMBER_in_model_rules_clause8823_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_model_rules_clause8825  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_model_rules_clause8825_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_model_rules_clause8825	= { FOLLOW_RPAREN_in_model_rules_clause8825_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_until_in_model_rules_clause8829  */
static	ANTLR3_BITWORD FOLLOW_k_until_in_model_rules_clause8829_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_until_in_model_rules_clause8829	= { FOLLOW_k_until_in_model_rules_clause8829_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_model_rules_clause8831  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_model_rules_clause8831_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_model_rules_clause8831	= { FOLLOW_LPAREN_in_model_rules_clause8831_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_model_rules_clause8833  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_model_rules_clause8833_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_model_rules_clause8833	= { FOLLOW_sql_condition_in_model_rules_clause8833_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_model_rules_clause8835  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_model_rules_clause8835_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_model_rules_clause8835	= { FOLLOW_RPAREN_in_model_rules_clause8835_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_model_rules_clause8845  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_model_rules_clause8845_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962008000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_model_rules_clause8845	= { FOLLOW_LPAREN_in_model_rules_clause8845_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_rules_exprs_in_model_rules_clause8847  */
static	ANTLR3_BITWORD FOLLOW_model_rules_exprs_in_model_rules_clause8847_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_model_rules_exprs_in_model_rules_clause8847	= { FOLLOW_model_rules_exprs_in_model_rules_clause8847_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_model_rules_clause8849  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_model_rules_clause8849_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_model_rules_clause8849	= { FOLLOW_RPAREN_in_model_rules_clause8849_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_rules_expr_in_model_rules_exprs8859  */
static	ANTLR3_BITWORD FOLLOW_model_rules_expr_in_model_rules_exprs8859_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_model_rules_expr_in_model_rules_exprs8859	= { FOLLOW_model_rules_expr_in_model_rules_exprs8859_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_model_rules_exprs8863  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_model_rules_exprs8863_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962008000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_model_rules_exprs8863	= { FOLLOW_COMMA_in_model_rules_exprs8863_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_rules_expr_in_model_rules_exprs8865  */
static	ANTLR3_BITWORD FOLLOW_model_rules_expr_in_model_rules_exprs8865_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_model_rules_expr_in_model_rules_exprs8865	= { FOLLOW_model_rules_expr_in_model_rules_exprs8865_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_update_in_model_rules_expr8880  */
static	ANTLR3_BITWORD FOLLOW_r_update_in_model_rules_expr8880_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_update_in_model_rules_expr8880	= { FOLLOW_r_update_in_model_rules_expr8880_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_upsert_in_model_rules_expr8884  */
static	ANTLR3_BITWORD FOLLOW_k_upsert_in_model_rules_expr8884_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4010000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_upsert_in_model_rules_expr8884	= { FOLLOW_k_upsert_in_model_rules_expr8884_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_model_rules_expr8888  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_model_rules_expr8888_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_model_rules_expr8888	= { FOLLOW_r_all_in_model_rules_expr8888_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cell_assignment_in_model_rules_expr8896  */
static	ANTLR3_BITWORD FOLLOW_cell_assignment_in_model_rules_expr8896_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_cell_assignment_in_model_rules_expr8896	= { FOLLOW_cell_assignment_in_model_rules_expr8896_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_model_rules_expr8900  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_model_rules_expr8900_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_model_rules_expr8900	= { FOLLOW_order_by_clause_in_model_rules_expr8900_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_model_rules_expr8905  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_model_rules_expr8905_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_model_rules_expr8905	= { FOLLOW_EQ_in_model_rules_expr8905_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_model_rules_expr8907  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_model_rules_expr8907_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_model_rules_expr8907	= { FOLLOW_sql_expression_in_model_rules_expr8907_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_measure_column_in_cell_assignment8917  */
static	ANTLR3_BITWORD FOLLOW_measure_column_in_cell_assignment8917_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_measure_column_in_cell_assignment8917	= { FOLLOW_measure_column_in_cell_assignment8917_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACK_in_cell_assignment8919  */
static	ANTLR3_BITWORD FOLLOW_LBRACK_in_cell_assignment8919_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000260100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACK_in_cell_assignment8919	= { FOLLOW_LBRACK_in_cell_assignment8919_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_multi_column_for_loop_in_cell_assignment8923  */
static	ANTLR3_BITWORD FOLLOW_multi_column_for_loop_in_cell_assignment8923_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_multi_column_for_loop_in_cell_assignment8923	= { FOLLOW_multi_column_for_loop_in_cell_assignment8923_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cell_assignment_exprs_in_cell_assignment8927  */
static	ANTLR3_BITWORD FOLLOW_cell_assignment_exprs_in_cell_assignment8927_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_cell_assignment_exprs_in_cell_assignment8927	= { FOLLOW_cell_assignment_exprs_in_cell_assignment8927_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACK_in_cell_assignment8931  */
static	ANTLR3_BITWORD FOLLOW_RBRACK_in_cell_assignment8931_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACK_in_cell_assignment8931	= { FOLLOW_RBRACK_in_cell_assignment8931_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cell_assignment_expr_in_cell_assignment_exprs8941  */
static	ANTLR3_BITWORD FOLLOW_cell_assignment_expr_in_cell_assignment_exprs8941_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_cell_assignment_expr_in_cell_assignment_exprs8941	= { FOLLOW_cell_assignment_expr_in_cell_assignment_exprs8941_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_cell_assignment_exprs8945  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_cell_assignment_exprs8945_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000260100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_cell_assignment_exprs8945	= { FOLLOW_COMMA_in_cell_assignment_exprs8945_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cell_assignment_expr_in_cell_assignment_exprs8947  */
static	ANTLR3_BITWORD FOLLOW_cell_assignment_expr_in_cell_assignment_exprs8947_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_cell_assignment_expr_in_cell_assignment_exprs8947	= { FOLLOW_cell_assignment_expr_in_cell_assignment_exprs8947_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_cell_assignment_expr8960  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_cell_assignment_expr8960_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_cell_assignment_expr8960	= { FOLLOW_sql_condition_in_cell_assignment_expr8960_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_cell_assignment_expr8964  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_cell_assignment_expr8964_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_cell_assignment_expr8964	= { FOLLOW_sql_expression_in_cell_assignment_expr8964_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_single_column_for_loop_in_cell_assignment_expr8968  */
static	ANTLR3_BITWORD FOLLOW_single_column_for_loop_in_cell_assignment_expr8968_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_single_column_for_loop_in_cell_assignment_expr8968	= { FOLLOW_single_column_for_loop_in_cell_assignment_expr8968_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_name_in_measure_column8978  */
static	ANTLR3_BITWORD FOLLOW_column_name_in_measure_column8978_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_column_name_in_measure_column8978	= { FOLLOW_column_name_in_measure_column8978_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_for_in_single_column_for_loop8988  */
static	ANTLR3_BITWORD FOLLOW_r_for_in_single_column_for_loop8988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_for_in_single_column_for_loop8988	= { FOLLOW_r_for_in_single_column_for_loop8988_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_name_in_single_column_for_loop8990  */
static	ANTLR3_BITWORD FOLLOW_column_name_in_single_column_for_loop8990_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000804010400000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_name_in_single_column_for_loop8990	= { FOLLOW_column_name_in_single_column_for_loop8990_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_in_in_single_column_for_loop8996  */
static	ANTLR3_BITWORD FOLLOW_r_in_in_single_column_for_loop8996_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_in_in_single_column_for_loop8996	= { FOLLOW_r_in_in_single_column_for_loop8996_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_single_column_for_loop8998  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_single_column_for_loop8998_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000800264) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_single_column_for_loop8998	= { FOLLOW_LPAREN_in_single_column_for_loop8998_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_literals_in_single_column_for_loop9002  */
static	ANTLR3_BITWORD FOLLOW_literals_in_single_column_for_loop9002_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_literals_in_single_column_for_loop9002	= { FOLLOW_literals_in_single_column_for_loop9002_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_single_column_for_loop9006  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_single_column_for_loop9006_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_single_column_for_loop9006	= { FOLLOW_subquery_in_single_column_for_loop9006_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_single_column_for_loop9010  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_single_column_for_loop9010_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_single_column_for_loop9010	= { FOLLOW_RPAREN_in_single_column_for_loop9010_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_like_in_single_column_for_loop9018  */
static	ANTLR3_BITWORD FOLLOW_r_like_in_single_column_for_loop9018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800200) };
static  ANTLR3_BITSET_LIST FOLLOW_r_like_in_single_column_for_loop9018	= { FOLLOW_r_like_in_single_column_for_loop9018_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pattern_in_single_column_for_loop9020  */
static	ANTLR3_BITWORD FOLLOW_pattern_in_single_column_for_loop9020_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_pattern_in_single_column_for_loop9020	= { FOLLOW_pattern_in_single_column_for_loop9020_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_from_in_single_column_for_loop9025  */
static	ANTLR3_BITWORD FOLLOW_r_from_in_single_column_for_loop9025_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800264) };
static  ANTLR3_BITSET_LIST FOLLOW_r_from_in_single_column_for_loop9025	= { FOLLOW_r_from_in_single_column_for_loop9025_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_literal_in_single_column_for_loop9027  */
static	ANTLR3_BITWORD FOLLOW_literal_in_single_column_for_loop9027_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_literal_in_single_column_for_loop9027	= { FOLLOW_literal_in_single_column_for_loop9027_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_to_in_single_column_for_loop9029  */
static	ANTLR3_BITWORD FOLLOW_r_to_in_single_column_for_loop9029_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800264) };
static  ANTLR3_BITSET_LIST FOLLOW_r_to_in_single_column_for_loop9029	= { FOLLOW_r_to_in_single_column_for_loop9029_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_literal_in_single_column_for_loop9031  */
static	ANTLR3_BITWORD FOLLOW_literal_in_single_column_for_loop9031_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000020000000) };
static  ANTLR3_BITSET_LIST FOLLOW_literal_in_single_column_for_loop9031	= { FOLLOW_literal_in_single_column_for_loop9031_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_increment_in_single_column_for_loop9035  */
static	ANTLR3_BITWORD FOLLOW_r_increment_in_single_column_for_loop9035_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800264) };
static  ANTLR3_BITSET_LIST FOLLOW_r_increment_in_single_column_for_loop9035	= { FOLLOW_r_increment_in_single_column_for_loop9035_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_decrement_in_single_column_for_loop9039  */
static	ANTLR3_BITWORD FOLLOW_k_decrement_in_single_column_for_loop9039_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800264) };
static  ANTLR3_BITSET_LIST FOLLOW_k_decrement_in_single_column_for_loop9039	= { FOLLOW_k_decrement_in_single_column_for_loop9039_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_literal_in_single_column_for_loop9043  */
static	ANTLR3_BITWORD FOLLOW_literal_in_single_column_for_loop9043_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_literal_in_single_column_for_loop9043	= { FOLLOW_literal_in_single_column_for_loop9043_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_pattern9057  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_pattern9057_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_pattern9057	= { FOLLOW_quoted_string_in_pattern9057_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_literal9067  */
static	ANTLR3_BITWORD FOLLOW_set_in_literal9067_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_literal9067	= { FOLLOW_set_in_literal9067_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_literal9078  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_literal9078_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_literal9078	= { FOLLOW_NUMBER_in_literal9078_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_literal9083  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_literal9083_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_literal9083	= { FOLLOW_quoted_string_in_literal9083_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_literal_in_literals9093  */
static	ANTLR3_BITWORD FOLLOW_literal_in_literals9093_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_literal_in_literals9093	= { FOLLOW_literal_in_literals9093_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_literals9097  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_literals9097_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800264) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_literals9097	= { FOLLOW_COMMA_in_literals9097_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_literal_in_literals9099  */
static	ANTLR3_BITWORD FOLLOW_literal_in_literals9099_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_literal_in_literals9099	= { FOLLOW_literal_in_literals9099_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_for_in_multi_column_for_loop9112  */
static	ANTLR3_BITWORD FOLLOW_r_for_in_multi_column_for_loop9112_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_for_in_multi_column_for_loop9112	= { FOLLOW_r_for_in_multi_column_for_loop9112_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_multi_column_for_loop9114  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_multi_column_for_loop9114_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_multi_column_for_loop9114	= { FOLLOW_LPAREN_in_multi_column_for_loop9114_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_specs_in_multi_column_for_loop9116  */
static	ANTLR3_BITWORD FOLLOW_column_specs_in_multi_column_for_loop9116_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_specs_in_multi_column_for_loop9116	= { FOLLOW_column_specs_in_multi_column_for_loop9116_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_multi_column_for_loop9118  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_multi_column_for_loop9118_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800010000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_multi_column_for_loop9118	= { FOLLOW_RPAREN_in_multi_column_for_loop9118_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_in_in_multi_column_for_loop9120  */
static	ANTLR3_BITWORD FOLLOW_r_in_in_multi_column_for_loop9120_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_in_in_multi_column_for_loop9120	= { FOLLOW_r_in_in_multi_column_for_loop9120_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_multi_column_for_loop9122  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_multi_column_for_loop9122_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_multi_column_for_loop9122	= { FOLLOW_LPAREN_in_multi_column_for_loop9122_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bracket_literals_list_in_multi_column_for_loop9126  */
static	ANTLR3_BITWORD FOLLOW_bracket_literals_list_in_multi_column_for_loop9126_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_bracket_literals_list_in_multi_column_for_loop9126	= { FOLLOW_bracket_literals_list_in_multi_column_for_loop9126_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_multi_column_for_loop9130  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_multi_column_for_loop9130_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_multi_column_for_loop9130	= { FOLLOW_subquery_in_multi_column_for_loop9130_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_multi_column_for_loop9134  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_multi_column_for_loop9134_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_multi_column_for_loop9134	= { FOLLOW_RPAREN_in_multi_column_for_loop9134_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bracket_literals9144  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bracket_literals9144_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800264) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bracket_literals9144	= { FOLLOW_LPAREN_in_bracket_literals9144_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_literals_in_bracket_literals9146  */
static	ANTLR3_BITWORD FOLLOW_literals_in_bracket_literals9146_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_literals_in_bracket_literals9146	= { FOLLOW_literals_in_bracket_literals9146_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bracket_literals9148  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bracket_literals9148_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bracket_literals9148	= { FOLLOW_RPAREN_in_bracket_literals9148_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bracket_literals_in_bracket_literals_list9158  */
static	ANTLR3_BITWORD FOLLOW_bracket_literals_in_bracket_literals_list9158_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_bracket_literals_in_bracket_literals_list9158	= { FOLLOW_bracket_literals_in_bracket_literals_list9158_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bracket_literals_list9162  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bracket_literals_list9162_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bracket_literals_list9162	= { FOLLOW_COMMA_in_bracket_literals_list9162_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bracket_literals_in_bracket_literals_list9164  */
static	ANTLR3_BITWORD FOLLOW_bracket_literals_in_bracket_literals_list9164_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_bracket_literals_in_bracket_literals_list9164	= { FOLLOW_bracket_literals_in_bracket_literals_list9164_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_union_in_union_clause9186  */
static	ANTLR3_BITWORD FOLLOW_r_union_in_union_clause9186_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0010000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_r_union_in_union_clause9186	= { FOLLOW_r_union_in_union_clause9186_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_union_clause9190  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_union_clause9190_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_union_clause9190	= { FOLLOW_r_all_in_union_clause9190_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_intersect_in_union_clause9199  */
static	ANTLR3_BITWORD FOLLOW_r_intersect_in_union_clause9199_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_r_intersect_in_union_clause9199	= { FOLLOW_r_intersect_in_union_clause9199_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_minus_in_union_clause9205  */
static	ANTLR3_BITWORD FOLLOW_r_minus_in_union_clause9205_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_r_minus_in_union_clause9205	= { FOLLOW_r_minus_in_union_clause9205_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_union_clause9215  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_union_clause9215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_union_clause9215	= { FOLLOW_select_statement_in_union_clause9215_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_union_clause9219  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_union_clause9219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_union_clause9219	= { FOLLOW_subquery_in_union_clause9219_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_order_in_order_by_clause9261  */
static	ANTLR3_BITWORD FOLLOW_r_order_in_order_by_clause9261_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_order_in_order_by_clause9261	= { FOLLOW_r_order_in_order_by_clause9261_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_siblings_in_order_by_clause9263  */
static	ANTLR3_BITWORD FOLLOW_k_siblings_in_order_by_clause9263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_siblings_in_order_by_clause9263	= { FOLLOW_k_siblings_in_order_by_clause9263_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_order_by_clause9267  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_order_by_clause9267_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_order_by_clause9267	= { FOLLOW_r_by_in_order_by_clause9267_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_part_first_in_order_by_clause9269  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_part_first_in_order_by_clause9269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_part_first_in_order_by_clause9269	= { FOLLOW_order_by_clause_part_first_in_order_by_clause9269_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_part_next_in_order_by_clause9271  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_part_next_in_order_by_clause9271_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_part_next_in_order_by_clause9271	= { FOLLOW_order_by_clause_part_next_in_order_by_clause9271_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_order_by_clause_part_first9303  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_order_by_clause_part_first9303_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0400000000000000), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_order_by_clause_part_first9303	= { FOLLOW_sql_expression_in_order_by_clause_part_first9303_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_asc_in_order_by_clause_part_first9305  */
static	ANTLR3_BITWORD FOLLOW_r_asc_in_order_by_clause_part_first9305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_asc_in_order_by_clause_part_first9305	= { FOLLOW_r_asc_in_order_by_clause_part_first9305_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_desc_in_order_by_clause_part_first9309  */
static	ANTLR3_BITWORD FOLLOW_r_desc_in_order_by_clause_part_first9309_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_desc_in_order_by_clause_part_first9309	= { FOLLOW_r_desc_in_order_by_clause_part_first9309_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_order_by_clause_part_first9314  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_order_by_clause_part_first9314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_order_by_clause_part_first9314	= { FOLLOW_k_nulls_in_order_by_clause_part_first9314_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_order_by_clause_part_first9316  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_order_by_clause_part_first9316_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_order_by_clause_part_first9316	= { FOLLOW_k_first_in_order_by_clause_part_first9316_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_order_by_clause_part_first9321  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_order_by_clause_part_first9321_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_order_by_clause_part_first9321	= { FOLLOW_k_nulls_in_order_by_clause_part_first9321_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_last_in_order_by_clause_part_first9323  */
static	ANTLR3_BITWORD FOLLOW_k_last_in_order_by_clause_part_first9323_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_last_in_order_by_clause_part_first9323	= { FOLLOW_k_last_in_order_by_clause_part_first9323_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_order_by_clause_part_next9343  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_order_by_clause_part_next9343_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_order_by_clause_part_next9343	= { FOLLOW_COMMA_in_order_by_clause_part_next9343_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_order_by_clause_part_next9345  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_order_by_clause_part_next9345_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0400000000000000), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_order_by_clause_part_next9345	= { FOLLOW_sql_expression_in_order_by_clause_part_next9345_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_asc_in_order_by_clause_part_next9347  */
static	ANTLR3_BITWORD FOLLOW_r_asc_in_order_by_clause_part_next9347_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_asc_in_order_by_clause_part_next9347	= { FOLLOW_r_asc_in_order_by_clause_part_next9347_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_desc_in_order_by_clause_part_next9351  */
static	ANTLR3_BITWORD FOLLOW_r_desc_in_order_by_clause_part_next9351_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_desc_in_order_by_clause_part_next9351	= { FOLLOW_r_desc_in_order_by_clause_part_next9351_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_order_by_clause_part_next9356  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_order_by_clause_part_next9356_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_order_by_clause_part_next9356	= { FOLLOW_k_nulls_in_order_by_clause_part_next9356_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_order_by_clause_part_next9358  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_order_by_clause_part_next9358_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_order_by_clause_part_next9358	= { FOLLOW_k_first_in_order_by_clause_part_next9358_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_order_by_clause_part_next9363  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_order_by_clause_part_next9363_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_order_by_clause_part_next9363	= { FOLLOW_k_nulls_in_order_by_clause_part_next9363_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_last_in_order_by_clause_part_next9365  */
static	ANTLR3_BITWORD FOLLOW_k_last_in_order_by_clause_part_next9365_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_last_in_order_by_clause_part_next9365	= { FOLLOW_k_last_in_order_by_clause_part_next9365_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_name_in_analytic_function_name9401  */
static	ANTLR3_BITWORD FOLLOW_function_name_in_analytic_function_name9401_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_function_name_in_analytic_function_name9401	= { FOLLOW_function_name_in_analytic_function_name9401_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_analytic_function_name_in_analytic_function_call9423  */
static	ANTLR3_BITWORD FOLLOW_analytic_function_name_in_analytic_function_call9423_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_analytic_function_name_in_analytic_function_call9423	= { FOLLOW_analytic_function_name_in_analytic_function_call9423_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_analytic_function_call9425  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_analytic_function_call9425_bits[]	= { ANTLR3_UINT64_LIT(0x6000000000000000), ANTLR3_UINT64_LIT(0x4010000000870265), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAF39FE014840450), ANTLR3_UINT64_LIT(0x0000000009499CB4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_analytic_function_call9425	= { FOLLOW_LPAREN_in_analytic_function_call9425_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_distinct_in_analytic_function_call9429  */
static	ANTLR3_BITWORD FOLLOW_r_distinct_in_analytic_function_call9429_bits[]	= { ANTLR3_UINT64_LIT(0x6000000000000000), ANTLR3_UINT64_LIT(0x4000000000870265), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAF39FE010840450), ANTLR3_UINT64_LIT(0x0000000009499CB4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_distinct_in_analytic_function_call9429	= { FOLLOW_r_distinct_in_analytic_function_call9429_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_unique_in_analytic_function_call9433  */
static	ANTLR3_BITWORD FOLLOW_r_unique_in_analytic_function_call9433_bits[]	= { ANTLR3_UINT64_LIT(0x6000000000000000), ANTLR3_UINT64_LIT(0x4000000000870265), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAF39FE010840450), ANTLR3_UINT64_LIT(0x0000000009499CB4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_unique_in_analytic_function_call9433	= { FOLLOW_r_unique_in_analytic_function_call9433_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_analytic_function_call9437  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_analytic_function_call9437_bits[]	= { ANTLR3_UINT64_LIT(0x6000000000000000), ANTLR3_UINT64_LIT(0x4000000000870265), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAF39FE010840450), ANTLR3_UINT64_LIT(0x0000000009499CB4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_analytic_function_call9437	= { FOLLOW_r_all_in_analytic_function_call9437_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_analytic_function_call9441  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_analytic_function_call9441_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_analytic_function_call9441	= { FOLLOW_sql_expression_in_analytic_function_call9441_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_analytic_function_call9445  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_analytic_function_call9445_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_analytic_function_call9445	= { FOLLOW_COMMA_in_analytic_function_call9445_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_analytic_function_call9447  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_analytic_function_call9447_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_analytic_function_call9447	= { FOLLOW_sql_expression_in_analytic_function_call9447_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_respect_in_analytic_function_call9455  */
static	ANTLR3_BITWORD FOLLOW_k_respect_in_analytic_function_call9455_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_k_respect_in_analytic_function_call9455	= { FOLLOW_k_respect_in_analytic_function_call9455_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_ignore_in_analytic_function_call9459  */
static	ANTLR3_BITWORD FOLLOW_k_ignore_in_analytic_function_call9459_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_k_ignore_in_analytic_function_call9459	= { FOLLOW_k_ignore_in_analytic_function_call9459_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_analytic_function_call9462  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_analytic_function_call9462_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_analytic_function_call9462	= { FOLLOW_k_nulls_in_analytic_function_call9462_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_analytic_function_call9467  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_analytic_function_call9467_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_analytic_function_call9467	= { FOLLOW_RPAREN_in_analytic_function_call9467_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dense_rank_analytic_in_analytic_function9479  */
static	ANTLR3_BITWORD FOLLOW_dense_rank_analytic_in_analytic_function9479_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_dense_rank_analytic_in_analytic_function9479	= { FOLLOW_dense_rank_analytic_in_analytic_function9479_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_percent_rank_analytic_in_analytic_function9487  */
static	ANTLR3_BITWORD FOLLOW_percent_rank_analytic_in_analytic_function9487_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_percent_rank_analytic_in_analytic_function9487	= { FOLLOW_percent_rank_analytic_in_analytic_function9487_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_percent_cont_disc_analytic_in_analytic_function9495  */
static	ANTLR3_BITWORD FOLLOW_percent_cont_disc_analytic_in_analytic_function9495_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_percent_cont_disc_analytic_in_analytic_function9495	= { FOLLOW_percent_cont_disc_analytic_in_analytic_function9495_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_first_last_in_analytic_function9503  */
static	ANTLR3_BITWORD FOLLOW_first_last_in_analytic_function9503_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_first_last_in_analytic_function9503	= { FOLLOW_first_last_in_analytic_function9503_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_listagg_in_analytic_function9508  */
static	ANTLR3_BITWORD FOLLOW_listagg_in_analytic_function9508_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_listagg_in_analytic_function9508	= { FOLLOW_listagg_in_analytic_function9508_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_analytic_function_call_in_analytic_function9524  */
static	ANTLR3_BITWORD FOLLOW_analytic_function_call_in_analytic_function9524_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_analytic_function_call_in_analytic_function9524	= { FOLLOW_analytic_function_call_in_analytic_function9524_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_respect_in_analytic_function9530  */
static	ANTLR3_BITWORD FOLLOW_k_respect_in_analytic_function9530_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_k_respect_in_analytic_function9530	= { FOLLOW_k_respect_in_analytic_function9530_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_ignore_in_analytic_function9534  */
static	ANTLR3_BITWORD FOLLOW_k_ignore_in_analytic_function9534_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_k_ignore_in_analytic_function9534	= { FOLLOW_k_ignore_in_analytic_function9534_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_analytic_function9537  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_analytic_function9537_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_analytic_function9537	= { FOLLOW_k_nulls_in_analytic_function9537_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_over_in_analytic_function9543  */
static	ANTLR3_BITWORD FOLLOW_k_over_in_analytic_function9543_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_over_in_analytic_function9543	= { FOLLOW_k_over_in_analytic_function9543_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_analytic_function9545  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_analytic_function9545_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_analytic_function9545	= { FOLLOW_LPAREN_in_analytic_function9545_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_analytic_clause_in_analytic_function9547  */
static	ANTLR3_BITWORD FOLLOW_analytic_clause_in_analytic_function9547_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_analytic_clause_in_analytic_function9547	= { FOLLOW_analytic_clause_in_analytic_function9547_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_analytic_function9549  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_analytic_function9549_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_analytic_function9549	= { FOLLOW_RPAREN_in_analytic_function9549_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_count_in_count_function9560  */
static	ANTLR3_BITWORD FOLLOW_k_count_in_count_function9560_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_count_in_count_function9560	= { FOLLOW_k_count_in_count_function9560_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_count_function9562  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_count_function9562_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE014840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_count_function9562	= { FOLLOW_LPAREN_in_count_function9562_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASTERISK_in_count_function9566  */
static	ANTLR3_BITWORD FOLLOW_ASTERISK_in_count_function9566_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ASTERISK_in_count_function9566	= { FOLLOW_ASTERISK_in_count_function9566_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_distinct_in_count_function9571  */
static	ANTLR3_BITWORD FOLLOW_r_distinct_in_count_function9571_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_distinct_in_count_function9571	= { FOLLOW_r_distinct_in_count_function9571_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_unique_in_count_function9575  */
static	ANTLR3_BITWORD FOLLOW_r_unique_in_count_function9575_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_unique_in_count_function9575	= { FOLLOW_r_unique_in_count_function9575_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_count_function9579  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_count_function9579_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_count_function9579	= { FOLLOW_r_all_in_count_function9579_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_count_function9583  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_count_function9583_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_count_function9583	= { FOLLOW_sql_expression_in_count_function9583_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_count_function9586  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_count_function9586_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_count_function9586	= { FOLLOW_RPAREN_in_count_function9586_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_over_in_count_function9598  */
static	ANTLR3_BITWORD FOLLOW_k_over_in_count_function9598_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_over_in_count_function9598	= { FOLLOW_k_over_in_count_function9598_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_count_function9600  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_count_function9600_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_count_function9600	= { FOLLOW_LPAREN_in_count_function9600_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_analytic_clause_in_count_function9602  */
static	ANTLR3_BITWORD FOLLOW_analytic_clause_in_count_function9602_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_analytic_clause_in_count_function9602	= { FOLLOW_analytic_clause_in_count_function9602_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_count_function9604  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_count_function9604_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_count_function9604	= { FOLLOW_RPAREN_in_count_function9604_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_partition_clause_in_analytic_clause9619  */
static	ANTLR3_BITWORD FOLLOW_query_partition_clause_in_analytic_clause9619_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_query_partition_clause_in_analytic_clause9619	= { FOLLOW_query_partition_clause_in_analytic_clause9619_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_analytic_clause9623  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_analytic_clause9623_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000080), ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_analytic_clause9623	= { FOLLOW_order_by_clause_in_analytic_clause9623_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_windowing_clause_in_analytic_clause9625  */
static	ANTLR3_BITWORD FOLLOW_windowing_clause_in_analytic_clause9625_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_windowing_clause_in_analytic_clause9625	= { FOLLOW_windowing_clause_in_analytic_clause9625_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_unbounded_in_windowing_clause_part9641  */
static	ANTLR3_BITWORD FOLLOW_k_unbounded_in_windowing_clause_part9641_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004000000000000), ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_k_unbounded_in_windowing_clause_part9641	= { FOLLOW_k_unbounded_in_windowing_clause_part9641_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_preceding_in_windowing_clause_part9645  */
static	ANTLR3_BITWORD FOLLOW_k_preceding_in_windowing_clause_part9645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_preceding_in_windowing_clause_part9645	= { FOLLOW_k_preceding_in_windowing_clause_part9645_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_following_in_windowing_clause_part9649  */
static	ANTLR3_BITWORD FOLLOW_k_following_in_windowing_clause_part9649_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_following_in_windowing_clause_part9649	= { FOLLOW_k_following_in_windowing_clause_part9649_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_current_in_windowing_clause_part9662  */
static	ANTLR3_BITWORD FOLLOW_r_current_in_windowing_clause_part9662_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_r_current_in_windowing_clause_part9662	= { FOLLOW_r_current_in_windowing_clause_part9662_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_row_in_windowing_clause_part9664  */
static	ANTLR3_BITWORD FOLLOW_r_row_in_windowing_clause_part9664_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_row_in_windowing_clause_part9664	= { FOLLOW_r_row_in_windowing_clause_part9664_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_windowing_clause_part9676  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_windowing_clause_part9676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004000000000000), ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_windowing_clause_part9676	= { FOLLOW_sql_expression_in_windowing_clause_part9676_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_preceding_in_windowing_clause_part9680  */
static	ANTLR3_BITWORD FOLLOW_k_preceding_in_windowing_clause_part9680_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_preceding_in_windowing_clause_part9680	= { FOLLOW_k_preceding_in_windowing_clause_part9680_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_following_in_windowing_clause_part9684  */
static	ANTLR3_BITWORD FOLLOW_k_following_in_windowing_clause_part9684_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_following_in_windowing_clause_part9684	= { FOLLOW_k_following_in_windowing_clause_part9684_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_rows_in_windowing_clause9703  */
static	ANTLR3_BITWORD FOLLOW_r_rows_in_windowing_clause9703_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x5000000000870264), ANTLR3_UINT64_LIT(0x1004002000040180), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x0000000009C994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_rows_in_windowing_clause9703	= { FOLLOW_r_rows_in_windowing_clause9703_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_range_in_windowing_clause9707  */
static	ANTLR3_BITWORD FOLLOW_k_range_in_windowing_clause9707_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x5000000000870264), ANTLR3_UINT64_LIT(0x1004002000040180), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x0000000009C994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_range_in_windowing_clause9707	= { FOLLOW_k_range_in_windowing_clause9707_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_windowing_clause_part_in_windowing_clause9716  */
static	ANTLR3_BITWORD FOLLOW_windowing_clause_part_in_windowing_clause9716_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_windowing_clause_part_in_windowing_clause9716	= { FOLLOW_windowing_clause_part_in_windowing_clause9716_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_between_in_windowing_clause9722  */
static	ANTLR3_BITWORD FOLLOW_r_between_in_windowing_clause9722_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040180), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x0000000009C994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_between_in_windowing_clause9722	= { FOLLOW_r_between_in_windowing_clause9722_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_windowing_clause_part_in_windowing_clause9724  */
static	ANTLR3_BITWORD FOLLOW_windowing_clause_part_in_windowing_clause9724_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_windowing_clause_part_in_windowing_clause9724	= { FOLLOW_windowing_clause_part_in_windowing_clause9724_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_and_in_windowing_clause9726  */
static	ANTLR3_BITWORD FOLLOW_r_and_in_windowing_clause9726_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040180), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x0000000009C994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_and_in_windowing_clause9726	= { FOLLOW_r_and_in_windowing_clause9726_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_windowing_clause_part_in_windowing_clause9728  */
static	ANTLR3_BITWORD FOLLOW_windowing_clause_part_in_windowing_clause9728_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_windowing_clause_part_in_windowing_clause9728	= { FOLLOW_windowing_clause_part_in_windowing_clause9728_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_count_in_aggregate_function_name9745  */
static	ANTLR3_BITWORD FOLLOW_k_count_in_aggregate_function_name9745_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_count_in_aggregate_function_name9745	= { FOLLOW_k_count_in_aggregate_function_name9745_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_spec_in_aggregate_function_name9749  */
static	ANTLR3_BITWORD FOLLOW_function_spec_in_aggregate_function_name9749_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_function_spec_in_aggregate_function_name9749	= { FOLLOW_function_spec_in_aggregate_function_name9749_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dense_rank_aggregate_in_aggregate_function9761  */
static	ANTLR3_BITWORD FOLLOW_dense_rank_aggregate_in_aggregate_function9761_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_dense_rank_aggregate_in_aggregate_function9761	= { FOLLOW_dense_rank_aggregate_in_aggregate_function9761_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_percent_rank_aggregate_in_aggregate_function9769  */
static	ANTLR3_BITWORD FOLLOW_percent_rank_aggregate_in_aggregate_function9769_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_percent_rank_aggregate_in_aggregate_function9769	= { FOLLOW_percent_rank_aggregate_in_aggregate_function9769_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_first_last_in_aggregate_function9774  */
static	ANTLR3_BITWORD FOLLOW_first_last_in_aggregate_function9774_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_first_last_in_aggregate_function9774	= { FOLLOW_first_last_in_aggregate_function9774_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_listagg_in_aggregate_function9779  */
static	ANTLR3_BITWORD FOLLOW_listagg_in_aggregate_function9779_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_listagg_in_aggregate_function9779	= { FOLLOW_listagg_in_aggregate_function9779_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_aggregate_function_name_in_aggregate_function9784  */
static	ANTLR3_BITWORD FOLLOW_aggregate_function_name_in_aggregate_function9784_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_aggregate_function_name_in_aggregate_function9784	= { FOLLOW_aggregate_function_name_in_aggregate_function9784_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_aggregate_function9786  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_aggregate_function9786_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE014840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_aggregate_function9786	= { FOLLOW_LPAREN_in_aggregate_function9786_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASTERISK_in_aggregate_function9790  */
static	ANTLR3_BITWORD FOLLOW_ASTERISK_in_aggregate_function9790_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ASTERISK_in_aggregate_function9790	= { FOLLOW_ASTERISK_in_aggregate_function9790_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_distinct_in_aggregate_function9795  */
static	ANTLR3_BITWORD FOLLOW_r_distinct_in_aggregate_function9795_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_distinct_in_aggregate_function9795	= { FOLLOW_r_distinct_in_aggregate_function9795_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_unique_in_aggregate_function9799  */
static	ANTLR3_BITWORD FOLLOW_r_unique_in_aggregate_function9799_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_unique_in_aggregate_function9799	= { FOLLOW_r_unique_in_aggregate_function9799_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_aggregate_function9803  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_aggregate_function9803_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_aggregate_function9803	= { FOLLOW_r_all_in_aggregate_function9803_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_aggregate_function9807  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_aggregate_function9807_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_aggregate_function9807	= { FOLLOW_sql_expression_in_aggregate_function9807_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_aggregate_function9810  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_aggregate_function9810_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_aggregate_function9810	= { FOLLOW_RPAREN_in_aggregate_function9810_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_over_in_aggregate_function9814  */
static	ANTLR3_BITWORD FOLLOW_k_over_in_aggregate_function9814_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_over_in_aggregate_function9814	= { FOLLOW_k_over_in_aggregate_function9814_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_aggregate_function9816  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_aggregate_function9816_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_aggregate_function9816	= { FOLLOW_LPAREN_in_aggregate_function9816_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_analytic_clause_in_aggregate_function9818  */
static	ANTLR3_BITWORD FOLLOW_analytic_clause_in_aggregate_function9818_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_analytic_clause_in_aggregate_function9818	= { FOLLOW_analytic_clause_in_aggregate_function9818_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_aggregate_function9820  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_aggregate_function9820_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_aggregate_function9820	= { FOLLOW_RPAREN_in_aggregate_function9820_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_percent_rank_in_percent_rank_aggregate9838  */
static	ANTLR3_BITWORD FOLLOW_k_percent_rank_in_percent_rank_aggregate9838_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_percent_rank_in_percent_rank_aggregate9838	= { FOLLOW_k_percent_rank_in_percent_rank_aggregate9838_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_percent_rank_aggregate9840  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_percent_rank_aggregate9840_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_percent_rank_aggregate9840	= { FOLLOW_LPAREN_in_percent_rank_aggregate9840_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_list_in_percent_rank_aggregate9842  */
static	ANTLR3_BITWORD FOLLOW_expression_list_in_percent_rank_aggregate9842_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_list_in_percent_rank_aggregate9842	= { FOLLOW_expression_list_in_percent_rank_aggregate9842_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_percent_rank_aggregate9844  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_percent_rank_aggregate9844_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_percent_rank_aggregate9844	= { FOLLOW_RPAREN_in_percent_rank_aggregate9844_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_within_in_percent_rank_aggregate9846  */
static	ANTLR3_BITWORD FOLLOW_k_within_in_percent_rank_aggregate9846_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000003000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_within_in_percent_rank_aggregate9846	= { FOLLOW_k_within_in_percent_rank_aggregate9846_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_group_in_percent_rank_aggregate9848  */
static	ANTLR3_BITWORD FOLLOW_r_group_in_percent_rank_aggregate9848_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_group_in_percent_rank_aggregate9848	= { FOLLOW_r_group_in_percent_rank_aggregate9848_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_percent_rank_aggregate9858  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_percent_rank_aggregate9858_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_percent_rank_aggregate9858	= { FOLLOW_LPAREN_in_percent_rank_aggregate9858_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_order_in_percent_rank_aggregate9860  */
static	ANTLR3_BITWORD FOLLOW_r_order_in_percent_rank_aggregate9860_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_order_in_percent_rank_aggregate9860	= { FOLLOW_r_order_in_percent_rank_aggregate9860_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_percent_rank_aggregate9862  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_percent_rank_aggregate9862_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_percent_rank_aggregate9862	= { FOLLOW_r_by_in_percent_rank_aggregate9862_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_percent_rank_aggregate9864  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_percent_rank_aggregate9864_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0400000000000001), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_percent_rank_aggregate9864	= { FOLLOW_sql_expression_in_percent_rank_aggregate9864_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_asc_in_percent_rank_aggregate9867  */
static	ANTLR3_BITWORD FOLLOW_r_asc_in_percent_rank_aggregate9867_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_asc_in_percent_rank_aggregate9867	= { FOLLOW_r_asc_in_percent_rank_aggregate9867_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_desc_in_percent_rank_aggregate9871  */
static	ANTLR3_BITWORD FOLLOW_r_desc_in_percent_rank_aggregate9871_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_desc_in_percent_rank_aggregate9871	= { FOLLOW_r_desc_in_percent_rank_aggregate9871_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_percent_rank_aggregate9876  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_percent_rank_aggregate9876_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0202000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_percent_rank_aggregate9876	= { FOLLOW_k_nulls_in_percent_rank_aggregate9876_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_percent_rank_aggregate9879  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_percent_rank_aggregate9879_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_percent_rank_aggregate9879	= { FOLLOW_k_first_in_percent_rank_aggregate9879_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_last_in_percent_rank_aggregate9883  */
static	ANTLR3_BITWORD FOLLOW_k_last_in_percent_rank_aggregate9883_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_k_last_in_percent_rank_aggregate9883	= { FOLLOW_k_last_in_percent_rank_aggregate9883_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_percent_rank_aggregate9897  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_percent_rank_aggregate9897_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_percent_rank_aggregate9897	= { FOLLOW_COMMA_in_percent_rank_aggregate9897_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_percent_rank_aggregate9899  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_percent_rank_aggregate9899_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0400000000000001), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_percent_rank_aggregate9899	= { FOLLOW_sql_expression_in_percent_rank_aggregate9899_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_asc_in_percent_rank_aggregate9902  */
static	ANTLR3_BITWORD FOLLOW_r_asc_in_percent_rank_aggregate9902_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_asc_in_percent_rank_aggregate9902	= { FOLLOW_r_asc_in_percent_rank_aggregate9902_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_desc_in_percent_rank_aggregate9906  */
static	ANTLR3_BITWORD FOLLOW_r_desc_in_percent_rank_aggregate9906_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_desc_in_percent_rank_aggregate9906	= { FOLLOW_r_desc_in_percent_rank_aggregate9906_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_percent_rank_aggregate9911  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_percent_rank_aggregate9911_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0202000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_percent_rank_aggregate9911	= { FOLLOW_k_nulls_in_percent_rank_aggregate9911_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_percent_rank_aggregate9914  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_percent_rank_aggregate9914_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_percent_rank_aggregate9914	= { FOLLOW_k_first_in_percent_rank_aggregate9914_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_last_in_percent_rank_aggregate9918  */
static	ANTLR3_BITWORD FOLLOW_k_last_in_percent_rank_aggregate9918_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_k_last_in_percent_rank_aggregate9918	= { FOLLOW_k_last_in_percent_rank_aggregate9918_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dense_rank_in_dense_rank_aggregate9937  */
static	ANTLR3_BITWORD FOLLOW_k_dense_rank_in_dense_rank_aggregate9937_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dense_rank_in_dense_rank_aggregate9937	= { FOLLOW_k_dense_rank_in_dense_rank_aggregate9937_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_dense_rank_aggregate9939  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_dense_rank_aggregate9939_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_dense_rank_aggregate9939	= { FOLLOW_LPAREN_in_dense_rank_aggregate9939_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_list_in_dense_rank_aggregate9941  */
static	ANTLR3_BITWORD FOLLOW_expression_list_in_dense_rank_aggregate9941_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_list_in_dense_rank_aggregate9941	= { FOLLOW_expression_list_in_dense_rank_aggregate9941_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_dense_rank_aggregate9943  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_dense_rank_aggregate9943_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_dense_rank_aggregate9943	= { FOLLOW_RPAREN_in_dense_rank_aggregate9943_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_within_in_dense_rank_aggregate9945  */
static	ANTLR3_BITWORD FOLLOW_k_within_in_dense_rank_aggregate9945_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000003000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_within_in_dense_rank_aggregate9945	= { FOLLOW_k_within_in_dense_rank_aggregate9945_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_group_in_dense_rank_aggregate9947  */
static	ANTLR3_BITWORD FOLLOW_r_group_in_dense_rank_aggregate9947_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_group_in_dense_rank_aggregate9947	= { FOLLOW_r_group_in_dense_rank_aggregate9947_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_dense_rank_aggregate9957  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_dense_rank_aggregate9957_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_dense_rank_aggregate9957	= { FOLLOW_LPAREN_in_dense_rank_aggregate9957_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_order_in_dense_rank_aggregate9959  */
static	ANTLR3_BITWORD FOLLOW_r_order_in_dense_rank_aggregate9959_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_order_in_dense_rank_aggregate9959	= { FOLLOW_r_order_in_dense_rank_aggregate9959_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_dense_rank_aggregate9961  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_dense_rank_aggregate9961_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_dense_rank_aggregate9961	= { FOLLOW_r_by_in_dense_rank_aggregate9961_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_dense_rank_aggregate9963  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_dense_rank_aggregate9963_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0400000000000001), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_dense_rank_aggregate9963	= { FOLLOW_sql_expression_in_dense_rank_aggregate9963_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_asc_in_dense_rank_aggregate9966  */
static	ANTLR3_BITWORD FOLLOW_r_asc_in_dense_rank_aggregate9966_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_asc_in_dense_rank_aggregate9966	= { FOLLOW_r_asc_in_dense_rank_aggregate9966_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_desc_in_dense_rank_aggregate9970  */
static	ANTLR3_BITWORD FOLLOW_r_desc_in_dense_rank_aggregate9970_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_desc_in_dense_rank_aggregate9970	= { FOLLOW_r_desc_in_dense_rank_aggregate9970_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_dense_rank_aggregate9975  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_dense_rank_aggregate9975_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0202000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_dense_rank_aggregate9975	= { FOLLOW_k_nulls_in_dense_rank_aggregate9975_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_dense_rank_aggregate9978  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_dense_rank_aggregate9978_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_dense_rank_aggregate9978	= { FOLLOW_k_first_in_dense_rank_aggregate9978_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_last_in_dense_rank_aggregate9982  */
static	ANTLR3_BITWORD FOLLOW_k_last_in_dense_rank_aggregate9982_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_k_last_in_dense_rank_aggregate9982	= { FOLLOW_k_last_in_dense_rank_aggregate9982_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_dense_rank_aggregate9996  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_dense_rank_aggregate9996_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_dense_rank_aggregate9996	= { FOLLOW_COMMA_in_dense_rank_aggregate9996_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_dense_rank_aggregate9998  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_dense_rank_aggregate9998_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0400000000000001), ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_dense_rank_aggregate9998	= { FOLLOW_sql_expression_in_dense_rank_aggregate9998_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_asc_in_dense_rank_aggregate10001  */
static	ANTLR3_BITWORD FOLLOW_r_asc_in_dense_rank_aggregate10001_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_asc_in_dense_rank_aggregate10001	= { FOLLOW_r_asc_in_dense_rank_aggregate10001_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_desc_in_dense_rank_aggregate10005  */
static	ANTLR3_BITWORD FOLLOW_r_desc_in_dense_rank_aggregate10005_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_r_desc_in_dense_rank_aggregate10005	= { FOLLOW_r_desc_in_dense_rank_aggregate10005_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_dense_rank_aggregate10010  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_dense_rank_aggregate10010_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0202000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_dense_rank_aggregate10010	= { FOLLOW_k_nulls_in_dense_rank_aggregate10010_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_dense_rank_aggregate10013  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_dense_rank_aggregate10013_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_dense_rank_aggregate10013	= { FOLLOW_k_first_in_dense_rank_aggregate10013_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_last_in_dense_rank_aggregate10017  */
static	ANTLR3_BITWORD FOLLOW_k_last_in_dense_rank_aggregate10017_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_k_last_in_dense_rank_aggregate10017	= { FOLLOW_k_last_in_dense_rank_aggregate10017_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_percent_rank_in_percent_rank_analytic10036  */
static	ANTLR3_BITWORD FOLLOW_k_percent_rank_in_percent_rank_analytic10036_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_percent_rank_in_percent_rank_analytic10036	= { FOLLOW_k_percent_rank_in_percent_rank_analytic10036_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_percent_rank_analytic10038  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_percent_rank_analytic10038_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_percent_rank_analytic10038	= { FOLLOW_LPAREN_in_percent_rank_analytic10038_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_percent_rank_analytic10040  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_percent_rank_analytic10040_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_percent_rank_analytic10040	= { FOLLOW_RPAREN_in_percent_rank_analytic10040_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_over_in_percent_rank_analytic10042  */
static	ANTLR3_BITWORD FOLLOW_k_over_in_percent_rank_analytic10042_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_over_in_percent_rank_analytic10042	= { FOLLOW_k_over_in_percent_rank_analytic10042_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_percent_rank_analytic10044  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_percent_rank_analytic10044_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_percent_rank_analytic10044	= { FOLLOW_LPAREN_in_percent_rank_analytic10044_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_partition_clause_in_percent_rank_analytic10046  */
static	ANTLR3_BITWORD FOLLOW_query_partition_clause_in_percent_rank_analytic10046_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_query_partition_clause_in_percent_rank_analytic10046	= { FOLLOW_query_partition_clause_in_percent_rank_analytic10046_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_percent_rank_analytic10048  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_percent_rank_analytic10048_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_percent_rank_analytic10048	= { FOLLOW_RPAREN_in_percent_rank_analytic10048_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_percentile_disc_in_percent_cont_disc_analytic10063  */
static	ANTLR3_BITWORD FOLLOW_k_percentile_disc_in_percent_cont_disc_analytic10063_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_percentile_disc_in_percent_cont_disc_analytic10063	= { FOLLOW_k_percentile_disc_in_percent_cont_disc_analytic10063_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_percentile_cont_in_percent_cont_disc_analytic10067  */
static	ANTLR3_BITWORD FOLLOW_k_percentile_cont_in_percent_cont_disc_analytic10067_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_percentile_cont_in_percent_cont_disc_analytic10067	= { FOLLOW_k_percentile_cont_in_percent_cont_disc_analytic10067_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_percent_cont_disc_analytic10071  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_percent_cont_disc_analytic10071_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_percent_cont_disc_analytic10071	= { FOLLOW_LPAREN_in_percent_cont_disc_analytic10071_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_percent_cont_disc_analytic10073  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_percent_cont_disc_analytic10073_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_percent_cont_disc_analytic10073	= { FOLLOW_sql_expression_in_percent_cont_disc_analytic10073_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_percent_cont_disc_analytic10075  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_percent_cont_disc_analytic10075_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_percent_cont_disc_analytic10075	= { FOLLOW_RPAREN_in_percent_cont_disc_analytic10075_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_within_in_percent_cont_disc_analytic10077  */
static	ANTLR3_BITWORD FOLLOW_k_within_in_percent_cont_disc_analytic10077_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000003000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_within_in_percent_cont_disc_analytic10077	= { FOLLOW_k_within_in_percent_cont_disc_analytic10077_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_group_in_percent_cont_disc_analytic10079  */
static	ANTLR3_BITWORD FOLLOW_r_group_in_percent_cont_disc_analytic10079_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_group_in_percent_cont_disc_analytic10079	= { FOLLOW_r_group_in_percent_cont_disc_analytic10079_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_percent_cont_disc_analytic10081  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_percent_cont_disc_analytic10081_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_percent_cont_disc_analytic10081	= { FOLLOW_LPAREN_in_percent_cont_disc_analytic10081_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_percent_cont_disc_analytic10083  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_percent_cont_disc_analytic10083_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_percent_cont_disc_analytic10083	= { FOLLOW_order_by_clause_in_percent_cont_disc_analytic10083_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_percent_cont_disc_analytic10085  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_percent_cont_disc_analytic10085_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_percent_cont_disc_analytic10085	= { FOLLOW_RPAREN_in_percent_cont_disc_analytic10085_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_over_in_percent_cont_disc_analytic10096  */
static	ANTLR3_BITWORD FOLLOW_k_over_in_percent_cont_disc_analytic10096_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_over_in_percent_cont_disc_analytic10096	= { FOLLOW_k_over_in_percent_cont_disc_analytic10096_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_percent_cont_disc_analytic10098  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_percent_cont_disc_analytic10098_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_percent_cont_disc_analytic10098	= { FOLLOW_LPAREN_in_percent_cont_disc_analytic10098_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_partition_clause_in_percent_cont_disc_analytic10100  */
static	ANTLR3_BITWORD FOLLOW_query_partition_clause_in_percent_cont_disc_analytic10100_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_query_partition_clause_in_percent_cont_disc_analytic10100	= { FOLLOW_query_partition_clause_in_percent_cont_disc_analytic10100_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_percent_cont_disc_analytic10102  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_percent_cont_disc_analytic10102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_percent_cont_disc_analytic10102	= { FOLLOW_RPAREN_in_percent_cont_disc_analytic10102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dense_rank_in_dense_rank_analytic10115  */
static	ANTLR3_BITWORD FOLLOW_k_dense_rank_in_dense_rank_analytic10115_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dense_rank_in_dense_rank_analytic10115	= { FOLLOW_k_dense_rank_in_dense_rank_analytic10115_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_dense_rank_analytic10117  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_dense_rank_analytic10117_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_dense_rank_analytic10117	= { FOLLOW_LPAREN_in_dense_rank_analytic10117_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_dense_rank_analytic10119  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_dense_rank_analytic10119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_dense_rank_analytic10119	= { FOLLOW_RPAREN_in_dense_rank_analytic10119_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_over_in_dense_rank_analytic10121  */
static	ANTLR3_BITWORD FOLLOW_k_over_in_dense_rank_analytic10121_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_over_in_dense_rank_analytic10121	= { FOLLOW_k_over_in_dense_rank_analytic10121_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_dense_rank_analytic10123  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_dense_rank_analytic10123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_dense_rank_analytic10123	= { FOLLOW_LPAREN_in_dense_rank_analytic10123_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_partition_clause_in_dense_rank_analytic10125  */
static	ANTLR3_BITWORD FOLLOW_query_partition_clause_in_dense_rank_analytic10125_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_query_partition_clause_in_dense_rank_analytic10125	= { FOLLOW_query_partition_clause_in_dense_rank_analytic10125_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_dense_rank_analytic10127  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_dense_rank_analytic10127_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_dense_rank_analytic10127	= { FOLLOW_RPAREN_in_dense_rank_analytic10127_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_aggregate_function_name_in_first_last10141  */
static	ANTLR3_BITWORD FOLLOW_aggregate_function_name_in_first_last10141_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_aggregate_function_name_in_first_last10141	= { FOLLOW_aggregate_function_name_in_first_last10141_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_first_last10143  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_first_last10143_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x401000000087026C), ANTLR3_UINT64_LIT(0x1004002000042100), ANTLR3_UINT64_LIT(0xBAD39FE014840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_first_last10143	= { FOLLOW_LPAREN_in_first_last10143_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASTERISK_in_first_last10147  */
static	ANTLR3_BITWORD FOLLOW_ASTERISK_in_first_last10147_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ASTERISK_in_first_last10147	= { FOLLOW_ASTERISK_in_first_last10147_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_distinct_in_first_last10152  */
static	ANTLR3_BITWORD FOLLOW_r_distinct_in_first_last10152_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_distinct_in_first_last10152	= { FOLLOW_r_distinct_in_first_last10152_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_unique_in_first_last10156  */
static	ANTLR3_BITWORD FOLLOW_r_unique_in_first_last10156_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_unique_in_first_last10156	= { FOLLOW_r_unique_in_first_last10156_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_first_last10159  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_first_last10159_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_first_last10159	= { FOLLOW_r_all_in_first_last10159_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_first_last10163  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_first_last10163_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_first_last10163	= { FOLLOW_sql_expression_in_first_last10163_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_first_last10166  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_first_last10166_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_first_last10166	= { FOLLOW_RPAREN_in_first_last10166_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_keep_in_first_last10168  */
static	ANTLR3_BITWORD FOLLOW_k_keep_in_first_last10168_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_keep_in_first_last10168	= { FOLLOW_k_keep_in_first_last10168_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_first_last10178  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_first_last10178_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_first_last10178	= { FOLLOW_LPAREN_in_first_last10178_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dense_rank_in_first_last10180  */
static	ANTLR3_BITWORD FOLLOW_k_dense_rank_in_first_last10180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0202000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dense_rank_in_first_last10180	= { FOLLOW_k_dense_rank_in_first_last10180_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_first_in_first_last10183  */
static	ANTLR3_BITWORD FOLLOW_k_first_in_first_last10183_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_first_in_first_last10183	= { FOLLOW_k_first_in_first_last10183_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_last_in_first_last10185  */
static	ANTLR3_BITWORD FOLLOW_k_last_in_first_last10185_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_last_in_first_last10185	= { FOLLOW_k_last_in_first_last10185_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_first_last10188  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_first_last10188_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_first_last10188	= { FOLLOW_order_by_clause_in_first_last10188_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_first_last10190  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_first_last10190_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_first_last10190	= { FOLLOW_RPAREN_in_first_last10190_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_over_in_first_last10194  */
static	ANTLR3_BITWORD FOLLOW_k_over_in_first_last10194_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_over_in_first_last10194	= { FOLLOW_k_over_in_first_last10194_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_first_last10196  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_first_last10196_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_first_last10196	= { FOLLOW_LPAREN_in_first_last10196_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_analytic_clause_in_first_last10198  */
static	ANTLR3_BITWORD FOLLOW_analytic_clause_in_first_last10198_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_analytic_clause_in_first_last10198	= { FOLLOW_analytic_clause_in_first_last10198_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_first_last10200  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_first_last10200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_first_last10200	= { FOLLOW_RPAREN_in_first_last10200_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_listagg_in_listagg10215  */
static	ANTLR3_BITWORD FOLLOW_k_listagg_in_listagg10215_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_listagg_in_listagg10215	= { FOLLOW_k_listagg_in_listagg10215_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_listagg10217  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_listagg10217_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_listagg10217	= { FOLLOW_LPAREN_in_listagg10217_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_listagg10219  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_listagg10219_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_listagg10219	= { FOLLOW_sql_expression_in_listagg10219_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_listagg10222  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_listagg10222_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800200) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_listagg10222	= { FOLLOW_COMMA_in_listagg10222_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_listagg10224  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_listagg10224_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_listagg10224	= { FOLLOW_quoted_string_in_listagg10224_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_listagg10228  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_listagg10228_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_listagg10228	= { FOLLOW_RPAREN_in_listagg10228_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_within_in_listagg10230  */
static	ANTLR3_BITWORD FOLLOW_k_within_in_listagg10230_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000003000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_within_in_listagg10230	= { FOLLOW_k_within_in_listagg10230_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_group_in_listagg10232  */
static	ANTLR3_BITWORD FOLLOW_r_group_in_listagg10232_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_group_in_listagg10232	= { FOLLOW_r_group_in_listagg10232_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_listagg10234  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_listagg10234_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_listagg10234	= { FOLLOW_LPAREN_in_listagg10234_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_listagg10236  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_listagg10236_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_listagg10236	= { FOLLOW_order_by_clause_in_listagg10236_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_listagg10238  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_listagg10238_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_listagg10238	= { FOLLOW_RPAREN_in_listagg10238_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_over_in_listagg10249  */
static	ANTLR3_BITWORD FOLLOW_k_over_in_listagg10249_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_over_in_listagg10249	= { FOLLOW_k_over_in_listagg10249_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_listagg10251  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_listagg10251_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_listagg10251	= { FOLLOW_LPAREN_in_listagg10251_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_partition_clause_in_listagg10253  */
static	ANTLR3_BITWORD FOLLOW_query_partition_clause_in_listagg10253_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_query_partition_clause_in_listagg10253	= { FOLLOW_query_partition_clause_in_listagg10253_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_listagg10255  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_listagg10255_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_listagg10255	= { FOLLOW_RPAREN_in_listagg10255_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_for_in_for_update_clause10272  */
static	ANTLR3_BITWORD FOLLOW_r_for_in_for_update_clause10272_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_for_in_for_update_clause10272	= { FOLLOW_r_for_in_for_update_clause10272_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_update_in_for_update_clause10274  */
static	ANTLR3_BITWORD FOLLOW_r_update_in_for_update_clause10274_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0012000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_update_in_for_update_clause10274	= { FOLLOW_r_update_in_for_update_clause10274_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_of_in_for_update_clause10278  */
static	ANTLR3_BITWORD FOLLOW_r_of_in_for_update_clause10278_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_of_in_for_update_clause10278	= { FOLLOW_r_of_in_for_update_clause10278_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_part_first_in_for_update_clause10280  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_part_first_in_for_update_clause10280_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010001), ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_part_first_in_for_update_clause10280	= { FOLLOW_for_update_clause_part_first_in_for_update_clause10280_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_part_next_in_for_update_clause10282  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_part_next_in_for_update_clause10282_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010001), ANTLR3_UINT64_LIT(0x0002000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_part_next_in_for_update_clause10282	= { FOLLOW_for_update_clause_part_next_in_for_update_clause10282_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_nowait_in_for_update_clause10289  */
static	ANTLR3_BITWORD FOLLOW_r_nowait_in_for_update_clause10289_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_nowait_in_for_update_clause10289	= { FOLLOW_r_nowait_in_for_update_clause10289_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_wait_in_for_update_clause10293  */
static	ANTLR3_BITWORD FOLLOW_k_wait_in_for_update_clause10293_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_k_wait_in_for_update_clause10293	= { FOLLOW_k_wait_in_for_update_clause10293_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_for_update_clause10295  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_for_update_clause10295_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_for_update_clause10295	= { FOLLOW_NUMBER_in_for_update_clause10295_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_skip_in_for_update_clause10299  */
static	ANTLR3_BITWORD FOLLOW_k_skip_in_for_update_clause10299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_skip_in_for_update_clause10299	= { FOLLOW_k_skip_in_for_update_clause10299_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_locked_in_for_update_clause10301  */
static	ANTLR3_BITWORD FOLLOW_k_locked_in_for_update_clause10301_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_locked_in_for_update_clause10301	= { FOLLOW_k_locked_in_for_update_clause10301_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_for_update_clause_part_first10349  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_for_update_clause_part_first10349_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_for_update_clause_part_first10349	= { FOLLOW_schema_name_in_for_update_clause_part_first10349_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_for_update_clause_part_first10351  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_for_update_clause_part_first10351_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_for_update_clause_part_first10351	= { FOLLOW_DOT_in_for_update_clause_part_first10351_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_name_in_for_update_clause_part_first10356  */
static	ANTLR3_BITWORD FOLLOW_table_name_in_for_update_clause_part_first10356_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_table_name_in_for_update_clause_part_first10356	= { FOLLOW_table_name_in_for_update_clause_part_first10356_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_for_update_clause_part_first10358  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_for_update_clause_part_first10358_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_for_update_clause_part_first10358	= { FOLLOW_DOT_in_for_update_clause_part_first10358_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_name_in_for_update_clause_part_first10362  */
static	ANTLR3_BITWORD FOLLOW_column_name_in_for_update_clause_part_first10362_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_column_name_in_for_update_clause_part_first10362	= { FOLLOW_column_name_in_for_update_clause_part_first10362_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_for_update_clause_part_next10372  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_for_update_clause_part_next10372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_for_update_clause_part_next10372	= { FOLLOW_COMMA_in_for_update_clause_part_next10372_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_schema_name_in_for_update_clause_part_next10375  */
static	ANTLR3_BITWORD FOLLOW_schema_name_in_for_update_clause_part_next10375_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_schema_name_in_for_update_clause_part_next10375	= { FOLLOW_schema_name_in_for_update_clause_part_next10375_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_for_update_clause_part_next10377  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_for_update_clause_part_next10377_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_for_update_clause_part_next10377	= { FOLLOW_DOT_in_for_update_clause_part_next10377_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_name_in_for_update_clause_part_next10382  */
static	ANTLR3_BITWORD FOLLOW_table_name_in_for_update_clause_part_next10382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_table_name_in_for_update_clause_part_next10382	= { FOLLOW_table_name_in_for_update_clause_part_next10382_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_for_update_clause_part_next10384  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_for_update_clause_part_next10384_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_for_update_clause_part_next10384	= { FOLLOW_DOT_in_for_update_clause_part_next10384_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_name_in_for_update_clause_part_next10388  */
static	ANTLR3_BITWORD FOLLOW_column_name_in_for_update_clause_part_next10388_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_column_name_in_for_update_clause_part_next10388	= { FOLLOW_column_name_in_for_update_clause_part_next10388_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_pivot_in_pivot_clause10402  */
static	ANTLR3_BITWORD FOLLOW_k_pivot_in_pivot_clause10402_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_pivot_in_pivot_clause10402	= { FOLLOW_k_pivot_in_pivot_clause10402_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_xml_in_pivot_clause10404  */
static	ANTLR3_BITWORD FOLLOW_k_xml_in_pivot_clause10404_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_xml_in_pivot_clause10404	= { FOLLOW_k_xml_in_pivot_clause10404_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_pivot_clause10407  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_pivot_clause10407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_pivot_clause10407	= { FOLLOW_LPAREN_in_pivot_clause10407_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_aggregate_function_in_pivot_clause10409  */
static	ANTLR3_BITWORD FOLLOW_aggregate_function_in_pivot_clause10409_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010001), ANTLR3_UINT64_LIT(0x0000000000200000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_aggregate_function_in_pivot_clause10409	= { FOLLOW_aggregate_function_in_pivot_clause10409_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_c_alias_in_pivot_clause10411  */
static	ANTLR3_BITWORD FOLLOW_c_alias_in_pivot_clause10411_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010001), ANTLR3_UINT64_LIT(0x0000000000200000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_c_alias_in_pivot_clause10411	= { FOLLOW_c_alias_in_pivot_clause10411_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_pivot_clause10415  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_pivot_clause10415_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_pivot_clause10415	= { FOLLOW_COMMA_in_pivot_clause10415_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_aggregate_function_in_pivot_clause10417  */
static	ANTLR3_BITWORD FOLLOW_aggregate_function_in_pivot_clause10417_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010001), ANTLR3_UINT64_LIT(0x0000000000200000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_aggregate_function_in_pivot_clause10417	= { FOLLOW_aggregate_function_in_pivot_clause10417_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_c_alias_in_pivot_clause10419  */
static	ANTLR3_BITWORD FOLLOW_c_alias_in_pivot_clause10419_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010001), ANTLR3_UINT64_LIT(0x0000000000200000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_c_alias_in_pivot_clause10419	= { FOLLOW_c_alias_in_pivot_clause10419_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_for_clause_in_pivot_clause10426  */
static	ANTLR3_BITWORD FOLLOW_pivot_for_clause_in_pivot_clause10426_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800010000000) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_for_clause_in_pivot_clause10426	= { FOLLOW_pivot_for_clause_in_pivot_clause10426_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_in_clause_in_pivot_clause10428  */
static	ANTLR3_BITWORD FOLLOW_pivot_in_clause_in_pivot_clause10428_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_in_clause_in_pivot_clause10428	= { FOLLOW_pivot_in_clause_in_pivot_clause10428_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_pivot_clause10430  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_pivot_clause10430_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_pivot_clause10430	= { FOLLOW_RPAREN_in_pivot_clause10430_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_for_in_pivot_for_clause10440  */
static	ANTLR3_BITWORD FOLLOW_r_for_in_pivot_for_clause10440_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_for_in_pivot_for_clause10440	= { FOLLOW_r_for_in_pivot_for_clause10440_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_pivot_for_clause10442  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_pivot_for_clause10442_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_pivot_for_clause10442	= { FOLLOW_column_spec_in_pivot_for_clause10442_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_pivot_for_clause10448  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_pivot_for_clause10448_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_pivot_for_clause10448	= { FOLLOW_LPAREN_in_pivot_for_clause10448_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_specs_in_pivot_for_clause10450  */
static	ANTLR3_BITWORD FOLLOW_column_specs_in_pivot_for_clause10450_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_specs_in_pivot_for_clause10450	= { FOLLOW_column_specs_in_pivot_for_clause10450_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_pivot_for_clause10452  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_pivot_for_clause10452_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_pivot_for_clause10452	= { FOLLOW_RPAREN_in_pivot_for_clause10452_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_in_in_pivot_in_clause10464  */
static	ANTLR3_BITWORD FOLLOW_r_in_in_pivot_in_clause10464_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_in_in_pivot_in_clause10464	= { FOLLOW_r_in_in_pivot_in_clause10464_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_pivot_in_clause10474  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_pivot_in_clause10474_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FF010840550), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_pivot_in_clause10474	= { FOLLOW_LPAREN_in_pivot_in_clause10474_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_pivot_in_clause10498  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_pivot_in_clause10498_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_pivot_in_clause10498	= { FOLLOW_select_statement_in_pivot_in_clause10498_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_any_in_pivot_in_clause10510  */
static	ANTLR3_BITWORD FOLLOW_r_any_in_pivot_in_clause10510_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_r_any_in_pivot_in_clause10510	= { FOLLOW_r_any_in_pivot_in_clause10510_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_pivot_in_clause10513  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_pivot_in_clause10513_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4080000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_pivot_in_clause10513	= { FOLLOW_COMMA_in_pivot_in_clause10513_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_any_in_pivot_in_clause10515  */
static	ANTLR3_BITWORD FOLLOW_r_any_in_pivot_in_clause10515_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_r_any_in_pivot_in_clause10515	= { FOLLOW_r_any_in_pivot_in_clause10515_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_list_in_pivot_in_clause10529  */
static	ANTLR3_BITWORD FOLLOW_expression_list_in_pivot_in_clause10529_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010001), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_list_in_pivot_in_clause10529	= { FOLLOW_expression_list_in_pivot_in_clause10529_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_c_alias_in_pivot_in_clause10531  */
static	ANTLR3_BITWORD FOLLOW_c_alias_in_pivot_in_clause10531_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_c_alias_in_pivot_in_clause10531	= { FOLLOW_c_alias_in_pivot_in_clause10531_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_pivot_in_clause10535  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_pivot_in_clause10535_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_pivot_in_clause10535	= { FOLLOW_COMMA_in_pivot_in_clause10535_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_list_in_pivot_in_clause10537  */
static	ANTLR3_BITWORD FOLLOW_expression_list_in_pivot_in_clause10537_bits[]	= { ANTLR3_UINT64_LIT(0x6000000000000000), ANTLR3_UINT64_LIT(0x4200000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_list_in_pivot_in_clause10537	= { FOLLOW_expression_list_in_pivot_in_clause10537_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_c_alias_in_pivot_in_clause10539  */
static	ANTLR3_BITWORD FOLLOW_c_alias_in_pivot_in_clause10539_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_c_alias_in_pivot_in_clause10539	= { FOLLOW_c_alias_in_pivot_in_clause10539_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_pivot_in_clause10563  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_pivot_in_clause10563_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_pivot_in_clause10563	= { FOLLOW_RPAREN_in_pivot_in_clause10563_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_unpivot_in_unpivot_clause10573  */
static	ANTLR3_BITWORD FOLLOW_k_unpivot_in_unpivot_clause10573_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_unpivot_in_unpivot_clause10573	= { FOLLOW_k_unpivot_in_unpivot_clause10573_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_exclude_in_unpivot_clause10578  */
static	ANTLR3_BITWORD FOLLOW_k_exclude_in_unpivot_clause10578_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_k_exclude_in_unpivot_clause10578	= { FOLLOW_k_exclude_in_unpivot_clause10578_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_include_in_unpivot_clause10582  */
static	ANTLR3_BITWORD FOLLOW_k_include_in_unpivot_clause10582_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_k_include_in_unpivot_clause10582	= { FOLLOW_k_include_in_unpivot_clause10582_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nulls_in_unpivot_clause10586  */
static	ANTLR3_BITWORD FOLLOW_k_nulls_in_unpivot_clause10586_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nulls_in_unpivot_clause10586	= { FOLLOW_k_nulls_in_unpivot_clause10586_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_unpivot_clause10592  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_unpivot_clause10592_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_unpivot_clause10592	= { FOLLOW_LPAREN_in_unpivot_clause10592_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_unpivot_clause10595  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_unpivot_clause10595_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010001), ANTLR3_UINT64_LIT(0x0000000000200000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_unpivot_clause10595	= { FOLLOW_column_spec_in_unpivot_clause10595_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_unpivot_clause10600  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_unpivot_clause10600_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_unpivot_clause10600	= { FOLLOW_LPAREN_in_unpivot_clause10600_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_specs_in_unpivot_clause10602  */
static	ANTLR3_BITWORD FOLLOW_column_specs_in_unpivot_clause10602_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_specs_in_unpivot_clause10602	= { FOLLOW_column_specs_in_unpivot_clause10602_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_unpivot_clause10604  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_unpivot_clause10604_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4200000000010001), ANTLR3_UINT64_LIT(0x0000000000200000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_unpivot_clause10604	= { FOLLOW_RPAREN_in_unpivot_clause10604_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_for_clause_in_unpivot_clause10608  */
static	ANTLR3_BITWORD FOLLOW_pivot_for_clause_in_unpivot_clause10608_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800010000000) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_for_clause_in_unpivot_clause10608	= { FOLLOW_pivot_for_clause_in_unpivot_clause10608_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_in_clause_in_unpivot_clause10610  */
static	ANTLR3_BITWORD FOLLOW_unpivot_in_clause_in_unpivot_clause10610_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_in_clause_in_unpivot_clause10610	= { FOLLOW_unpivot_in_clause_in_unpivot_clause10610_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_unpivot_clause10612  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_unpivot_clause10612_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_unpivot_clause10612	= { FOLLOW_RPAREN_in_unpivot_clause10612_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_in_in_unpivot_in_clause10622  */
static	ANTLR3_BITWORD FOLLOW_r_in_in_unpivot_in_clause10622_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_in_in_unpivot_in_clause10622	= { FOLLOW_r_in_in_unpivot_in_clause10622_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_unpivot_in_clause10626  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_unpivot_in_clause10626_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_unpivot_in_clause10626	= { FOLLOW_LPAREN_in_unpivot_in_clause10626_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_unpivot_in_clause10631  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_unpivot_in_clause10631_bits[]	= { ANTLR3_UINT64_LIT(0x6000000000000000), ANTLR3_UINT64_LIT(0x0200000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_unpivot_in_clause10631	= { FOLLOW_column_spec_in_unpivot_in_clause10631_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_unpivot_in_clause10636  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_unpivot_in_clause10636_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_unpivot_in_clause10636	= { FOLLOW_LPAREN_in_unpivot_in_clause10636_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_specs_in_unpivot_in_clause10638  */
static	ANTLR3_BITWORD FOLLOW_column_specs_in_unpivot_in_clause10638_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_specs_in_unpivot_in_clause10638	= { FOLLOW_column_specs_in_unpivot_in_clause10638_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_unpivot_in_clause10640  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_unpivot_in_clause10640_bits[]	= { ANTLR3_UINT64_LIT(0x6000000000000000), ANTLR3_UINT64_LIT(0x0200000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_unpivot_in_clause10640	= { FOLLOW_RPAREN_in_unpivot_in_clause10640_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_as_in_unpivot_in_clause10645  */
static	ANTLR3_BITWORD FOLLOW_r_as_in_unpivot_in_clause10645_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000800204) };
static  ANTLR3_BITSET_LIST FOLLOW_r_as_in_unpivot_in_clause10645	= { FOLLOW_r_as_in_unpivot_in_clause10645_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constant_in_unpivot_in_clause10648  */
static	ANTLR3_BITWORD FOLLOW_constant_in_unpivot_in_clause10648_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_constant_in_unpivot_in_clause10648	= { FOLLOW_constant_in_unpivot_in_clause10648_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_unpivot_in_clause10653  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_unpivot_in_clause10653_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800204) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_unpivot_in_clause10653	= { FOLLOW_LPAREN_in_unpivot_in_clause10653_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constant_in_unpivot_in_clause10655  */
static	ANTLR3_BITWORD FOLLOW_constant_in_unpivot_in_clause10655_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_constant_in_unpivot_in_clause10655	= { FOLLOW_constant_in_unpivot_in_clause10655_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_unpivot_in_clause10657  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_unpivot_in_clause10657_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_unpivot_in_clause10657	= { FOLLOW_RPAREN_in_unpivot_in_clause10657_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_unpivot_in_clause10666  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_unpivot_in_clause10666_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_unpivot_in_clause10666	= { FOLLOW_COMMA_in_unpivot_in_clause10666_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_unpivot_in_clause10669  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_unpivot_in_clause10669_bits[]	= { ANTLR3_UINT64_LIT(0x6000000000000000), ANTLR3_UINT64_LIT(0x0200000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_unpivot_in_clause10669	= { FOLLOW_column_spec_in_unpivot_in_clause10669_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_unpivot_in_clause10674  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_unpivot_in_clause10674_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_unpivot_in_clause10674	= { FOLLOW_LPAREN_in_unpivot_in_clause10674_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_specs_in_unpivot_in_clause10676  */
static	ANTLR3_BITWORD FOLLOW_column_specs_in_unpivot_in_clause10676_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_specs_in_unpivot_in_clause10676	= { FOLLOW_column_specs_in_unpivot_in_clause10676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_unpivot_in_clause10678  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_unpivot_in_clause10678_bits[]	= { ANTLR3_UINT64_LIT(0x6000000000000000), ANTLR3_UINT64_LIT(0x0200000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_unpivot_in_clause10678	= { FOLLOW_RPAREN_in_unpivot_in_clause10678_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_as_in_unpivot_in_clause10683  */
static	ANTLR3_BITWORD FOLLOW_r_as_in_unpivot_in_clause10683_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000800204) };
static  ANTLR3_BITSET_LIST FOLLOW_r_as_in_unpivot_in_clause10683	= { FOLLOW_r_as_in_unpivot_in_clause10683_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constant_in_unpivot_in_clause10686  */
static	ANTLR3_BITWORD FOLLOW_constant_in_unpivot_in_clause10686_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_constant_in_unpivot_in_clause10686	= { FOLLOW_constant_in_unpivot_in_clause10686_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_unpivot_in_clause10691  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_unpivot_in_clause10691_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000800204) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_unpivot_in_clause10691	= { FOLLOW_LPAREN_in_unpivot_in_clause10691_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constant_in_unpivot_in_clause10693  */
static	ANTLR3_BITWORD FOLLOW_constant_in_unpivot_in_clause10693_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_constant_in_unpivot_in_clause10693	= { FOLLOW_constant_in_unpivot_in_clause10693_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_unpivot_in_clause10695  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_unpivot_in_clause10695_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_unpivot_in_clause10695	= { FOLLOW_RPAREN_in_unpivot_in_clause10695_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_unpivot_in_clause10705  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_unpivot_in_clause10705_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_unpivot_in_clause10705	= { FOLLOW_RPAREN_in_unpivot_in_clause10705_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_constant10715  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_constant10715_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_constant10715	= { FOLLOW_NUMBER_in_constant10715_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_constant10719  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_constant10719_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_constant10719	= { FOLLOW_quoted_string_in_constant10719_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_114_in_r_access10734  */
static	ANTLR3_BITWORD FOLLOW_114_in_r_access10734_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_114_in_r_access10734	= { FOLLOW_114_in_r_access10734_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_115_in_r_add10747  */
static	ANTLR3_BITWORD FOLLOW_115_in_r_add10747_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_115_in_r_add10747	= { FOLLOW_115_in_r_add10747_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_116_in_r_all10760  */
static	ANTLR3_BITWORD FOLLOW_116_in_r_all10760_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_116_in_r_all10760	= { FOLLOW_116_in_r_all10760_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_117_in_r_alter10773  */
static	ANTLR3_BITWORD FOLLOW_117_in_r_alter10773_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_117_in_r_alter10773	= { FOLLOW_117_in_r_alter10773_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_118_in_r_and10786  */
static	ANTLR3_BITWORD FOLLOW_118_in_r_and10786_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_118_in_r_and10786	= { FOLLOW_118_in_r_and10786_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_119_in_r_any10799  */
static	ANTLR3_BITWORD FOLLOW_119_in_r_any10799_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_119_in_r_any10799	= { FOLLOW_119_in_r_any10799_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_120_in_r_arraylen10812  */
static	ANTLR3_BITWORD FOLLOW_120_in_r_arraylen10812_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_120_in_r_arraylen10812	= { FOLLOW_120_in_r_arraylen10812_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_121_in_r_as10825  */
static	ANTLR3_BITWORD FOLLOW_121_in_r_as10825_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_121_in_r_as10825	= { FOLLOW_121_in_r_as10825_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_122_in_r_asc10838  */
static	ANTLR3_BITWORD FOLLOW_122_in_r_asc10838_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_122_in_r_asc10838	= { FOLLOW_122_in_r_asc10838_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_123_in_r_audit10851  */
static	ANTLR3_BITWORD FOLLOW_123_in_r_audit10851_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_123_in_r_audit10851	= { FOLLOW_123_in_r_audit10851_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_124_in_r_between10864  */
static	ANTLR3_BITWORD FOLLOW_124_in_r_between10864_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_124_in_r_between10864	= { FOLLOW_124_in_r_between10864_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_125_in_r_by10877  */
static	ANTLR3_BITWORD FOLLOW_125_in_r_by10877_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_125_in_r_by10877	= { FOLLOW_125_in_r_by10877_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_126_in_r_case10890  */
static	ANTLR3_BITWORD FOLLOW_126_in_r_case10890_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_126_in_r_case10890	= { FOLLOW_126_in_r_case10890_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_127_in_r_char10904  */
static	ANTLR3_BITWORD FOLLOW_127_in_r_char10904_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_127_in_r_char10904	= { FOLLOW_127_in_r_char10904_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_128_in_r_check10917  */
static	ANTLR3_BITWORD FOLLOW_128_in_r_check10917_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_128_in_r_check10917	= { FOLLOW_128_in_r_check10917_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_129_in_r_cluster10930  */
static	ANTLR3_BITWORD FOLLOW_129_in_r_cluster10930_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_129_in_r_cluster10930	= { FOLLOW_129_in_r_cluster10930_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_130_in_r_column10943  */
static	ANTLR3_BITWORD FOLLOW_130_in_r_column10943_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_130_in_r_column10943	= { FOLLOW_130_in_r_column10943_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_131_in_r_comment10956  */
static	ANTLR3_BITWORD FOLLOW_131_in_r_comment10956_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_131_in_r_comment10956	= { FOLLOW_131_in_r_comment10956_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_132_in_r_compress10969  */
static	ANTLR3_BITWORD FOLLOW_132_in_r_compress10969_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_132_in_r_compress10969	= { FOLLOW_132_in_r_compress10969_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_133_in_r_connect10982  */
static	ANTLR3_BITWORD FOLLOW_133_in_r_connect10982_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_133_in_r_connect10982	= { FOLLOW_133_in_r_connect10982_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_134_in_r_create10995  */
static	ANTLR3_BITWORD FOLLOW_134_in_r_create10995_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_134_in_r_create10995	= { FOLLOW_134_in_r_create10995_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_135_in_r_current11008  */
static	ANTLR3_BITWORD FOLLOW_135_in_r_current11008_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_135_in_r_current11008	= { FOLLOW_135_in_r_current11008_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_136_in_r_date11021  */
static	ANTLR3_BITWORD FOLLOW_136_in_r_date11021_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_136_in_r_date11021	= { FOLLOW_136_in_r_date11021_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_137_in_r_decimal11034  */
static	ANTLR3_BITWORD FOLLOW_137_in_r_decimal11034_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_137_in_r_decimal11034	= { FOLLOW_137_in_r_decimal11034_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_138_in_r_default11047  */
static	ANTLR3_BITWORD FOLLOW_138_in_r_default11047_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_138_in_r_default11047	= { FOLLOW_138_in_r_default11047_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_139_in_r_delete11060  */
static	ANTLR3_BITWORD FOLLOW_139_in_r_delete11060_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_139_in_r_delete11060	= { FOLLOW_139_in_r_delete11060_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_140_in_r_desc11073  */
static	ANTLR3_BITWORD FOLLOW_140_in_r_desc11073_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_140_in_r_desc11073	= { FOLLOW_140_in_r_desc11073_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_141_in_r_distinct11086  */
static	ANTLR3_BITWORD FOLLOW_141_in_r_distinct11086_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_141_in_r_distinct11086	= { FOLLOW_141_in_r_distinct11086_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_142_in_r_drop11099  */
static	ANTLR3_BITWORD FOLLOW_142_in_r_drop11099_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_142_in_r_drop11099	= { FOLLOW_142_in_r_drop11099_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_143_in_r_else11112  */
static	ANTLR3_BITWORD FOLLOW_143_in_r_else11112_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_143_in_r_else11112	= { FOLLOW_143_in_r_else11112_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_144_in_r_exclusive11125  */
static	ANTLR3_BITWORD FOLLOW_144_in_r_exclusive11125_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_144_in_r_exclusive11125	= { FOLLOW_144_in_r_exclusive11125_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_145_in_r_exists11138  */
static	ANTLR3_BITWORD FOLLOW_145_in_r_exists11138_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_145_in_r_exists11138	= { FOLLOW_145_in_r_exists11138_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_146_in_r_false11151  */
static	ANTLR3_BITWORD FOLLOW_146_in_r_false11151_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_146_in_r_false11151	= { FOLLOW_146_in_r_false11151_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_147_in_r_file11165  */
static	ANTLR3_BITWORD FOLLOW_147_in_r_file11165_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_147_in_r_file11165	= { FOLLOW_147_in_r_file11165_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_148_in_r_float11178  */
static	ANTLR3_BITWORD FOLLOW_148_in_r_float11178_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_148_in_r_float11178	= { FOLLOW_148_in_r_float11178_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_149_in_r_for11191  */
static	ANTLR3_BITWORD FOLLOW_149_in_r_for11191_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_149_in_r_for11191	= { FOLLOW_149_in_r_for11191_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_150_in_r_from11204  */
static	ANTLR3_BITWORD FOLLOW_150_in_r_from11204_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_150_in_r_from11204	= { FOLLOW_150_in_r_from11204_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_151_in_r_grant11217  */
static	ANTLR3_BITWORD FOLLOW_151_in_r_grant11217_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_151_in_r_grant11217	= { FOLLOW_151_in_r_grant11217_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_152_in_r_group11230  */
static	ANTLR3_BITWORD FOLLOW_152_in_r_group11230_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_152_in_r_group11230	= { FOLLOW_152_in_r_group11230_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_153_in_r_having11243  */
static	ANTLR3_BITWORD FOLLOW_153_in_r_having11243_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_153_in_r_having11243	= { FOLLOW_153_in_r_having11243_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_154_in_r_identified11256  */
static	ANTLR3_BITWORD FOLLOW_154_in_r_identified11256_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_154_in_r_identified11256	= { FOLLOW_154_in_r_identified11256_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_155_in_r_immediate11269  */
static	ANTLR3_BITWORD FOLLOW_155_in_r_immediate11269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_155_in_r_immediate11269	= { FOLLOW_155_in_r_immediate11269_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_156_in_r_in11282  */
static	ANTLR3_BITWORD FOLLOW_156_in_r_in11282_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_156_in_r_in11282	= { FOLLOW_156_in_r_in11282_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_157_in_r_increment11295  */
static	ANTLR3_BITWORD FOLLOW_157_in_r_increment11295_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_157_in_r_increment11295	= { FOLLOW_157_in_r_increment11295_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_158_in_r_index11308  */
static	ANTLR3_BITWORD FOLLOW_158_in_r_index11308_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_158_in_r_index11308	= { FOLLOW_158_in_r_index11308_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_159_in_r_initial11321  */
static	ANTLR3_BITWORD FOLLOW_159_in_r_initial11321_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_159_in_r_initial11321	= { FOLLOW_159_in_r_initial11321_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_160_in_r_insert11334  */
static	ANTLR3_BITWORD FOLLOW_160_in_r_insert11334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_160_in_r_insert11334	= { FOLLOW_160_in_r_insert11334_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_161_in_r_integer11347  */
static	ANTLR3_BITWORD FOLLOW_161_in_r_integer11347_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_161_in_r_integer11347	= { FOLLOW_161_in_r_integer11347_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_162_in_r_intersect11360  */
static	ANTLR3_BITWORD FOLLOW_162_in_r_intersect11360_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_162_in_r_intersect11360	= { FOLLOW_162_in_r_intersect11360_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_163_in_r_into11373  */
static	ANTLR3_BITWORD FOLLOW_163_in_r_into11373_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_163_in_r_into11373	= { FOLLOW_163_in_r_into11373_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_164_in_r_is11386  */
static	ANTLR3_BITWORD FOLLOW_164_in_r_is11386_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_164_in_r_is11386	= { FOLLOW_164_in_r_is11386_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_165_in_r_level11399  */
static	ANTLR3_BITWORD FOLLOW_165_in_r_level11399_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_165_in_r_level11399	= { FOLLOW_165_in_r_level11399_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_166_in_r_like11412  */
static	ANTLR3_BITWORD FOLLOW_166_in_r_like11412_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_166_in_r_like11412	= { FOLLOW_166_in_r_like11412_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_167_in_r_lock11425  */
static	ANTLR3_BITWORD FOLLOW_167_in_r_lock11425_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_167_in_r_lock11425	= { FOLLOW_167_in_r_lock11425_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_168_in_r_long11438  */
static	ANTLR3_BITWORD FOLLOW_168_in_r_long11438_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_168_in_r_long11438	= { FOLLOW_168_in_r_long11438_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_169_in_r_maxextents11451  */
static	ANTLR3_BITWORD FOLLOW_169_in_r_maxextents11451_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_169_in_r_maxextents11451	= { FOLLOW_169_in_r_maxextents11451_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_170_in_r_minus11464  */
static	ANTLR3_BITWORD FOLLOW_170_in_r_minus11464_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_170_in_r_minus11464	= { FOLLOW_170_in_r_minus11464_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_171_in_r_mode11477  */
static	ANTLR3_BITWORD FOLLOW_171_in_r_mode11477_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_171_in_r_mode11477	= { FOLLOW_171_in_r_mode11477_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_172_in_r_modify11490  */
static	ANTLR3_BITWORD FOLLOW_172_in_r_modify11490_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_172_in_r_modify11490	= { FOLLOW_172_in_r_modify11490_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_173_in_r_noaudit11503  */
static	ANTLR3_BITWORD FOLLOW_173_in_r_noaudit11503_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_173_in_r_noaudit11503	= { FOLLOW_173_in_r_noaudit11503_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_174_in_r_nocompress11516  */
static	ANTLR3_BITWORD FOLLOW_174_in_r_nocompress11516_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_174_in_r_nocompress11516	= { FOLLOW_174_in_r_nocompress11516_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_175_in_r_not11529  */
static	ANTLR3_BITWORD FOLLOW_175_in_r_not11529_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_175_in_r_not11529	= { FOLLOW_175_in_r_not11529_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_176_in_r_notfound11542  */
static	ANTLR3_BITWORD FOLLOW_176_in_r_notfound11542_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_176_in_r_notfound11542	= { FOLLOW_176_in_r_notfound11542_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_177_in_r_nowait11555  */
static	ANTLR3_BITWORD FOLLOW_177_in_r_nowait11555_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_177_in_r_nowait11555	= { FOLLOW_177_in_r_nowait11555_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_178_in_r_null11568  */
static	ANTLR3_BITWORD FOLLOW_178_in_r_null11568_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_178_in_r_null11568	= { FOLLOW_178_in_r_null11568_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_179_in_r_number11581  */
static	ANTLR3_BITWORD FOLLOW_179_in_r_number11581_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_179_in_r_number11581	= { FOLLOW_179_in_r_number11581_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_180_in_r_of11594  */
static	ANTLR3_BITWORD FOLLOW_180_in_r_of11594_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_180_in_r_of11594	= { FOLLOW_180_in_r_of11594_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_181_in_r_offline11607  */
static	ANTLR3_BITWORD FOLLOW_181_in_r_offline11607_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_181_in_r_offline11607	= { FOLLOW_181_in_r_offline11607_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_182_in_r_on11620  */
static	ANTLR3_BITWORD FOLLOW_182_in_r_on11620_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_182_in_r_on11620	= { FOLLOW_182_in_r_on11620_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_183_in_r_online11633  */
static	ANTLR3_BITWORD FOLLOW_183_in_r_online11633_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_183_in_r_online11633	= { FOLLOW_183_in_r_online11633_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_184_in_r_option11646  */
static	ANTLR3_BITWORD FOLLOW_184_in_r_option11646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_184_in_r_option11646	= { FOLLOW_184_in_r_option11646_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_185_in_r_or11659  */
static	ANTLR3_BITWORD FOLLOW_185_in_r_or11659_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_185_in_r_or11659	= { FOLLOW_185_in_r_or11659_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_186_in_r_order11672  */
static	ANTLR3_BITWORD FOLLOW_186_in_r_order11672_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_186_in_r_order11672	= { FOLLOW_186_in_r_order11672_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_187_in_r_pctfree11685  */
static	ANTLR3_BITWORD FOLLOW_187_in_r_pctfree11685_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_187_in_r_pctfree11685	= { FOLLOW_187_in_r_pctfree11685_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_188_in_r_prior11698  */
static	ANTLR3_BITWORD FOLLOW_188_in_r_prior11698_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_188_in_r_prior11698	= { FOLLOW_188_in_r_prior11698_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_189_in_r_privileges11711  */
static	ANTLR3_BITWORD FOLLOW_189_in_r_privileges11711_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_189_in_r_privileges11711	= { FOLLOW_189_in_r_privileges11711_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_190_in_r_public11724  */
static	ANTLR3_BITWORD FOLLOW_190_in_r_public11724_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_190_in_r_public11724	= { FOLLOW_190_in_r_public11724_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_191_in_r_raw11737  */
static	ANTLR3_BITWORD FOLLOW_191_in_r_raw11737_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_191_in_r_raw11737	= { FOLLOW_191_in_r_raw11737_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_192_in_r_rename11750  */
static	ANTLR3_BITWORD FOLLOW_192_in_r_rename11750_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_192_in_r_rename11750	= { FOLLOW_192_in_r_rename11750_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_193_in_r_resource11763  */
static	ANTLR3_BITWORD FOLLOW_193_in_r_resource11763_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_193_in_r_resource11763	= { FOLLOW_193_in_r_resource11763_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_194_in_r_revoke11776  */
static	ANTLR3_BITWORD FOLLOW_194_in_r_revoke11776_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_194_in_r_revoke11776	= { FOLLOW_194_in_r_revoke11776_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_195_in_r_row11789  */
static	ANTLR3_BITWORD FOLLOW_195_in_r_row11789_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_195_in_r_row11789	= { FOLLOW_195_in_r_row11789_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_196_in_r_rowid11802  */
static	ANTLR3_BITWORD FOLLOW_196_in_r_rowid11802_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_196_in_r_rowid11802	= { FOLLOW_196_in_r_rowid11802_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_197_in_r_rowlabel11815  */
static	ANTLR3_BITWORD FOLLOW_197_in_r_rowlabel11815_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_197_in_r_rowlabel11815	= { FOLLOW_197_in_r_rowlabel11815_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_198_in_r_rownum11828  */
static	ANTLR3_BITWORD FOLLOW_198_in_r_rownum11828_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_198_in_r_rownum11828	= { FOLLOW_198_in_r_rownum11828_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_199_in_r_rows11841  */
static	ANTLR3_BITWORD FOLLOW_199_in_r_rows11841_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_199_in_r_rows11841	= { FOLLOW_199_in_r_rows11841_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_200_in_r_select11854  */
static	ANTLR3_BITWORD FOLLOW_200_in_r_select11854_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_200_in_r_select11854	= { FOLLOW_200_in_r_select11854_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_201_in_r_session11867  */
static	ANTLR3_BITWORD FOLLOW_201_in_r_session11867_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_201_in_r_session11867	= { FOLLOW_201_in_r_session11867_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_202_in_r_set11880  */
static	ANTLR3_BITWORD FOLLOW_202_in_r_set11880_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_202_in_r_set11880	= { FOLLOW_202_in_r_set11880_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_203_in_r_share11893  */
static	ANTLR3_BITWORD FOLLOW_203_in_r_share11893_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_203_in_r_share11893	= { FOLLOW_203_in_r_share11893_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_204_in_r_size11906  */
static	ANTLR3_BITWORD FOLLOW_204_in_r_size11906_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_204_in_r_size11906	= { FOLLOW_204_in_r_size11906_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_205_in_r_smallint11919  */
static	ANTLR3_BITWORD FOLLOW_205_in_r_smallint11919_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_205_in_r_smallint11919	= { FOLLOW_205_in_r_smallint11919_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_206_in_r_sqlbuf11932  */
static	ANTLR3_BITWORD FOLLOW_206_in_r_sqlbuf11932_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_206_in_r_sqlbuf11932	= { FOLLOW_206_in_r_sqlbuf11932_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_207_in_r_start11945  */
static	ANTLR3_BITWORD FOLLOW_207_in_r_start11945_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_207_in_r_start11945	= { FOLLOW_207_in_r_start11945_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_208_in_r_successful11958  */
static	ANTLR3_BITWORD FOLLOW_208_in_r_successful11958_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_208_in_r_successful11958	= { FOLLOW_208_in_r_successful11958_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_209_in_r_synonym11971  */
static	ANTLR3_BITWORD FOLLOW_209_in_r_synonym11971_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_209_in_r_synonym11971	= { FOLLOW_209_in_r_synonym11971_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_210_in_r_sysdate11984  */
static	ANTLR3_BITWORD FOLLOW_210_in_r_sysdate11984_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_210_in_r_sysdate11984	= { FOLLOW_210_in_r_sysdate11984_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_211_in_r_table11997  */
static	ANTLR3_BITWORD FOLLOW_211_in_r_table11997_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_211_in_r_table11997	= { FOLLOW_211_in_r_table11997_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_212_in_r_then12010  */
static	ANTLR3_BITWORD FOLLOW_212_in_r_then12010_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_212_in_r_then12010	= { FOLLOW_212_in_r_then12010_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_213_in_r_to12023  */
static	ANTLR3_BITWORD FOLLOW_213_in_r_to12023_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_213_in_r_to12023	= { FOLLOW_213_in_r_to12023_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_214_in_r_trigger12037  */
static	ANTLR3_BITWORD FOLLOW_214_in_r_trigger12037_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_214_in_r_trigger12037	= { FOLLOW_214_in_r_trigger12037_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_215_in_r_true12051  */
static	ANTLR3_BITWORD FOLLOW_215_in_r_true12051_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_215_in_r_true12051	= { FOLLOW_215_in_r_true12051_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_216_in_r_uid12065  */
static	ANTLR3_BITWORD FOLLOW_216_in_r_uid12065_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_216_in_r_uid12065	= { FOLLOW_216_in_r_uid12065_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_217_in_r_union12078  */
static	ANTLR3_BITWORD FOLLOW_217_in_r_union12078_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_217_in_r_union12078	= { FOLLOW_217_in_r_union12078_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_218_in_r_unique12091  */
static	ANTLR3_BITWORD FOLLOW_218_in_r_unique12091_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_218_in_r_unique12091	= { FOLLOW_218_in_r_unique12091_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_219_in_r_update12104  */
static	ANTLR3_BITWORD FOLLOW_219_in_r_update12104_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_219_in_r_update12104	= { FOLLOW_219_in_r_update12104_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_220_in_r_user12118  */
static	ANTLR3_BITWORD FOLLOW_220_in_r_user12118_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_220_in_r_user12118	= { FOLLOW_220_in_r_user12118_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_221_in_r_validate12131  */
static	ANTLR3_BITWORD FOLLOW_221_in_r_validate12131_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_221_in_r_validate12131	= { FOLLOW_221_in_r_validate12131_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_222_in_r_values12144  */
static	ANTLR3_BITWORD FOLLOW_222_in_r_values12144_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_222_in_r_values12144	= { FOLLOW_222_in_r_values12144_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_223_in_r_varchar12157  */
static	ANTLR3_BITWORD FOLLOW_223_in_r_varchar12157_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_223_in_r_varchar12157	= { FOLLOW_223_in_r_varchar12157_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_224_in_r_varchar212170  */
static	ANTLR3_BITWORD FOLLOW_224_in_r_varchar212170_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_224_in_r_varchar212170	= { FOLLOW_224_in_r_varchar212170_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_225_in_r_view12183  */
static	ANTLR3_BITWORD FOLLOW_225_in_r_view12183_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_225_in_r_view12183	= { FOLLOW_225_in_r_view12183_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_226_in_r_whenever12196  */
static	ANTLR3_BITWORD FOLLOW_226_in_r_whenever12196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_226_in_r_whenever12196	= { FOLLOW_226_in_r_whenever12196_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_227_in_r_where12209  */
static	ANTLR3_BITWORD FOLLOW_227_in_r_where12209_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_227_in_r_where12209	= { FOLLOW_227_in_r_where12209_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_228_in_r_with12222  */
static	ANTLR3_BITWORD FOLLOW_228_in_r_with12222_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_228_in_r_with12222	= { FOLLOW_228_in_r_with12222_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_a12603  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_a12603_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_a12603	= { FOLLOW_ID_in_k_a12603_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_229_in_k_at12636  */
static	ANTLR3_BITWORD FOLLOW_229_in_k_at12636_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_229_in_k_at12636	= { FOLLOW_229_in_k_at12636_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_automatic12664  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_automatic12664_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_automatic12664	= { FOLLOW_ID_in_k_automatic12664_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_bfile12696  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_bfile12696_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_bfile12696	= { FOLLOW_ID_in_k_bfile12696_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_binary_double12719  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_binary_double12719_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_binary_double12719	= { FOLLOW_ID_in_k_binary_double12719_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_binary_float12743  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_binary_float12743_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_binary_float12743	= { FOLLOW_ID_in_k_binary_float12743_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_binary_integer12765  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_binary_integer12765_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_binary_integer12765	= { FOLLOW_ID_in_k_binary_integer12765_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_blob12797  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_blob12797_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_blob12797	= { FOLLOW_ID_in_k_blob12797_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_block12828  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_block12828_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_block12828	= { FOLLOW_ID_in_k_block12828_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_boolean12857  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_boolean12857_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_boolean12857	= { FOLLOW_ID_in_k_boolean12857_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_both12889  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_both12889_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_both12889	= { FOLLOW_ID_in_k_both12889_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_breadth12918  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_breadth12918_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_breadth12918	= { FOLLOW_ID_in_k_breadth12918_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_byte12950  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_byte12950_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_byte12950	= { FOLLOW_ID_in_k_byte12950_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_230_in_k_cast12980  */
static	ANTLR3_BITWORD FOLLOW_230_in_k_cast12980_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_230_in_k_cast12980	= { FOLLOW_230_in_k_cast12980_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_character13008  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_character13008_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_character13008	= { FOLLOW_ID_in_k_character13008_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_clob13040  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_clob13040_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_clob13040	= { FOLLOW_ID_in_k_clob13040_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_231_in_k_cluster_set13063  */
static	ANTLR3_BITWORD FOLLOW_231_in_k_cluster_set13063_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_231_in_k_cluster_set13063	= { FOLLOW_231_in_k_cluster_set13063_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_232_in_k_connect_by_root13086  */
static	ANTLR3_BITWORD FOLLOW_232_in_k_connect_by_root13086_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_232_in_k_connect_by_root13086	= { FOLLOW_232_in_k_connect_by_root13086_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_constraint13113  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_constraint13113_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_constraint13113	= { FOLLOW_ID_in_k_constraint13113_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_233_in_k_count13143  */
static	ANTLR3_BITWORD FOLLOW_233_in_k_count13143_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_233_in_k_count13143	= { FOLLOW_233_in_k_count13143_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_cross13177  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_cross13177_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_cross13177	= { FOLLOW_ID_in_k_cross13177_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_234_in_k_cube13207  */
static	ANTLR3_BITWORD FOLLOW_234_in_k_cube13207_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_234_in_k_cube13207	= { FOLLOW_234_in_k_cube13207_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_235_in_k_cursor13237  */
static	ANTLR3_BITWORD FOLLOW_235_in_k_cursor13237_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_235_in_k_cursor13237	= { FOLLOW_235_in_k_cursor13237_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_236_in_k_cycle13267  */
static	ANTLR3_BITWORD FOLLOW_236_in_k_cycle13267_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_236_in_k_cycle13267	= { FOLLOW_236_in_k_cycle13267_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_day13301  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_day13301_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_day13301	= { FOLLOW_ID_in_k_day13301_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_dbtimezone13327  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_dbtimezone13327_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_dbtimezone13327	= { FOLLOW_ID_in_k_dbtimezone13327_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_dec13360  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_dec13360_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_dec13360	= { FOLLOW_ID_in_k_dec13360_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_decrement13387  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_decrement13387_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_decrement13387	= { FOLLOW_ID_in_k_decrement13387_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_dense_rank13413  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_dense_rank13413_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_dense_rank13413	= { FOLLOW_ID_in_k_dense_rank13413_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_depth13444  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_depth13444_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_depth13444	= { FOLLOW_ID_in_k_depth13444_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_237_in_k_dimension13469  */
static	ANTLR3_BITWORD FOLLOW_237_in_k_dimension13469_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_237_in_k_dimension13469	= { FOLLOW_237_in_k_dimension13469_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_double13500  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_double13500_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_double13500	= { FOLLOW_ID_in_k_double13500_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_empty13531  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_empty13531_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_empty13531	= { FOLLOW_ID_in_k_empty13531_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_238_in_k_end13562  */
static	ANTLR3_BITWORD FOLLOW_238_in_k_end13562_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_238_in_k_end13562	= { FOLLOW_238_in_k_end13562_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_equals_path13588  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_equals_path13588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_equals_path13588	= { FOLLOW_ID_in_k_equals_path13588_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_errors13618  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_errors13618_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_errors13618	= { FOLLOW_ID_in_k_errors13618_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_239_in_k_escape13646  */
static	ANTLR3_BITWORD FOLLOW_239_in_k_escape13646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_239_in_k_escape13646	= { FOLLOW_239_in_k_escape13646_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_exclude13676  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_exclude13676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_exclude13676	= { FOLLOW_ID_in_k_exclude13676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_240_in_k_extract13703  */
static	ANTLR3_BITWORD FOLLOW_240_in_k_extract13703_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_240_in_k_extract13703	= { FOLLOW_240_in_k_extract13703_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_241_in_k_first13733  */
static	ANTLR3_BITWORD FOLLOW_241_in_k_first13733_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_241_in_k_first13733	= { FOLLOW_241_in_k_first13733_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_242_in_k_following13748  */
static	ANTLR3_BITWORD FOLLOW_242_in_k_following13748_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_242_in_k_following13748	= { FOLLOW_242_in_k_following13748_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_243_in_k_full13762  */
static	ANTLR3_BITWORD FOLLOW_243_in_k_full13762_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_243_in_k_full13762	= { FOLLOW_243_in_k_full13762_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_244_in_k_grouping13776  */
static	ANTLR3_BITWORD FOLLOW_244_in_k_grouping13776_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_244_in_k_grouping13776	= { FOLLOW_244_in_k_grouping13776_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_hour13792  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_hour13792_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_hour13792	= { FOLLOW_ID_in_k_hour13792_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_245_in_k_ignore13805  */
static	ANTLR3_BITWORD FOLLOW_245_in_k_ignore13805_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_245_in_k_ignore13805	= { FOLLOW_245_in_k_ignore13805_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_include13821  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_include13821_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_include13821	= { FOLLOW_ID_in_k_include13821_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_246_in_k_infinite13834  */
static	ANTLR3_BITWORD FOLLOW_246_in_k_infinite13834_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_246_in_k_infinite13834	= { FOLLOW_246_in_k_infinite13834_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_inner13850  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_inner13850_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_inner13850	= { FOLLOW_ID_in_k_inner13850_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_int13865  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_int13865_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_int13865	= { FOLLOW_ID_in_k_int13865_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_247_in_k_interval13878  */
static	ANTLR3_BITWORD FOLLOW_247_in_k_interval13878_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_247_in_k_interval13878	= { FOLLOW_247_in_k_interval13878_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_iterate13894  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_iterate13894_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_iterate13894	= { FOLLOW_ID_in_k_iterate13894_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_248_in_k_join13907  */
static	ANTLR3_BITWORD FOLLOW_248_in_k_join13907_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_248_in_k_join13907	= { FOLLOW_248_in_k_join13907_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_keep13923  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_keep13923_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_keep13923	= { FOLLOW_ID_in_k_keep13923_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_249_in_k_last13937  */
static	ANTLR3_BITWORD FOLLOW_249_in_k_last13937_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_249_in_k_last13937	= { FOLLOW_249_in_k_last13937_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_leading13955  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_leading13955_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_leading13955	= { FOLLOW_ID_in_k_leading13955_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_250_in_k_left13968  */
static	ANTLR3_BITWORD FOLLOW_250_in_k_left13968_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_250_in_k_left13968	= { FOLLOW_250_in_k_left13968_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_251_in_k_like213982  */
static	ANTLR3_BITWORD FOLLOW_251_in_k_like213982_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_251_in_k_like213982	= { FOLLOW_251_in_k_like213982_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_252_in_k_like413996  */
static	ANTLR3_BITWORD FOLLOW_252_in_k_like413996_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_252_in_k_like413996	= { FOLLOW_252_in_k_like413996_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_253_in_k_likec14010  */
static	ANTLR3_BITWORD FOLLOW_253_in_k_likec14010_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_253_in_k_likec14010	= { FOLLOW_253_in_k_likec14010_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_limit14042  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_limit14042_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_limit14042	= { FOLLOW_ID_in_k_limit14042_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_listagg14071  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_listagg14071_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_listagg14071	= { FOLLOW_ID_in_k_listagg14071_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_lnnvl14102  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_lnnvl14102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_lnnvl14102	= { FOLLOW_ID_in_k_lnnvl14102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_local14133  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_local14133_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_local14133	= { FOLLOW_ID_in_k_local14133_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_locked14163  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_locked14163_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_locked14163	= { FOLLOW_ID_in_k_locked14163_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_log14196  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_log14196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_log14196	= { FOLLOW_ID_in_k_log14196_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_254_in_k_main14226  */
static	ANTLR3_BITWORD FOLLOW_254_in_k_main14226_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_254_in_k_main14226	= { FOLLOW_254_in_k_main14226_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_matched14256  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_matched14256_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_matched14256	= { FOLLOW_ID_in_k_matched14256_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_maxvalue14286  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_maxvalue14286_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_maxvalue14286	= { FOLLOW_ID_in_k_maxvalue14286_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_measures14314  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_measures14314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_measures14314	= { FOLLOW_ID_in_k_measures14314_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_255_in_k_member14342  */
static	ANTLR3_BITWORD FOLLOW_255_in_k_member14342_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_255_in_k_member14342	= { FOLLOW_255_in_k_member14342_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_merge14374  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_merge14374_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_merge14374	= { FOLLOW_ID_in_k_merge14374_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_minute14405  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_minute14405_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_minute14405	= { FOLLOW_ID_in_k_minute14405_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_mivalue14434  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_mivalue14434_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_mivalue14434	= { FOLLOW_ID_in_k_mivalue14434_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_mlslabel14462  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_mlslabel14462_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_mlslabel14462	= { FOLLOW_ID_in_k_mlslabel14462_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_256_in_k_model14477  */
static	ANTLR3_BITWORD FOLLOW_256_in_k_model14477_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_256_in_k_model14477	= { FOLLOW_256_in_k_model14477_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_month14499  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_month14499_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_month14499	= { FOLLOW_ID_in_k_month14499_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_257_in_k_multiset14512  */
static	ANTLR3_BITWORD FOLLOW_257_in_k_multiset14512_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_257_in_k_multiset14512	= { FOLLOW_257_in_k_multiset14512_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_258_in_k_nan14526  */
static	ANTLR3_BITWORD FOLLOW_258_in_k_nan14526_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_258_in_k_nan14526	= { FOLLOW_258_in_k_nan14526_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_national14542  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_national14542_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_national14542	= { FOLLOW_ID_in_k_national14542_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_natural14557  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_natural14557_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_natural14557	= { FOLLOW_ID_in_k_natural14557_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_259_in_k_nav14570  */
static	ANTLR3_BITWORD FOLLOW_259_in_k_nav14570_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_259_in_k_nav14570	= { FOLLOW_259_in_k_nav14570_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_nchar14586  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_nchar14586_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_nchar14586	= { FOLLOW_ID_in_k_nchar14586_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_nclob14601  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_nclob14601_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_nclob14601	= { FOLLOW_ID_in_k_nclob14601_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_nocycle14616  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_nocycle14616_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_nocycle14616	= { FOLLOW_ID_in_k_nocycle14616_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_260_in_k_nulls14630  */
static	ANTLR3_BITWORD FOLLOW_260_in_k_nulls14630_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_260_in_k_nulls14630	= { FOLLOW_260_in_k_nulls14630_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_numeric14646  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_numeric14646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_numeric14646	= { FOLLOW_ID_in_k_numeric14646_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_nvarchar14661  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_nvarchar14661_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_nvarchar14661	= { FOLLOW_ID_in_k_nvarchar14661_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_nvarchar214676  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_nvarchar214676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_nvarchar214676	= { FOLLOW_ID_in_k_nvarchar214676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_only14693  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_only14693_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_only14693	= { FOLLOW_ID_in_k_only14693_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_261_in_k_outer14707  */
static	ANTLR3_BITWORD FOLLOW_261_in_k_outer14707_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_261_in_k_outer14707	= { FOLLOW_261_in_k_outer14707_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_over14724  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_over14724_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_over14724	= { FOLLOW_ID_in_k_over14724_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_262_in_k_partition14737  */
static	ANTLR3_BITWORD FOLLOW_262_in_k_partition14737_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_262_in_k_partition14737	= { FOLLOW_262_in_k_partition14737_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_percent_rank14753  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_percent_rank14753_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_percent_rank14753	= { FOLLOW_ID_in_k_percent_rank14753_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_percentile_cont14768  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_percentile_cont14768_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_percentile_cont14768	= { FOLLOW_ID_in_k_percentile_cont14768_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_percentile_disc14783  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_percentile_disc14783_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_percentile_disc14783	= { FOLLOW_ID_in_k_percentile_disc14783_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_263_in_k_pivot14796  */
static	ANTLR3_BITWORD FOLLOW_263_in_k_pivot14796_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_263_in_k_pivot14796	= { FOLLOW_263_in_k_pivot14796_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_pls_integer14812  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_pls_integer14812_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_pls_integer14812	= { FOLLOW_ID_in_k_pls_integer14812_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_positive14827  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_positive14827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_positive14827	= { FOLLOW_ID_in_k_positive14827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_264_in_k_preceding14840  */
static	ANTLR3_BITWORD FOLLOW_264_in_k_preceding14840_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_264_in_k_preceding14840	= { FOLLOW_264_in_k_preceding14840_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_precision14856  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_precision14856_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_precision14856	= { FOLLOW_ID_in_k_precision14856_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_present14871  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_present14871_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_present14871	= { FOLLOW_ID_in_k_present14871_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_265_in_k_range14884  */
static	ANTLR3_BITWORD FOLLOW_265_in_k_range14884_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_265_in_k_range14884	= { FOLLOW_265_in_k_range14884_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_read14902  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_read14902_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_read14902	= { FOLLOW_ID_in_k_read14902_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_real14917  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_real14917_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_real14917	= { FOLLOW_ID_in_k_real14917_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_266_in_k_reference14930  */
static	ANTLR3_BITWORD FOLLOW_266_in_k_reference14930_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_266_in_k_reference14930	= { FOLLOW_266_in_k_reference14930_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_regexp_like14946  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_regexp_like14946_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_regexp_like14946	= { FOLLOW_ID_in_k_regexp_like14946_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_reject14970  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_reject14970_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_reject14970	= { FOLLOW_ID_in_k_reject14970_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_267_in_k_respect14983  */
static	ANTLR3_BITWORD FOLLOW_267_in_k_respect14983_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_267_in_k_respect14983	= { FOLLOW_267_in_k_respect14983_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_268_in_k_return14997  */
static	ANTLR3_BITWORD FOLLOW_268_in_k_return14997_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_268_in_k_return14997	= { FOLLOW_268_in_k_return14997_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_269_in_k_returning15011  */
static	ANTLR3_BITWORD FOLLOW_269_in_k_returning15011_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_269_in_k_returning15011	= { FOLLOW_269_in_k_returning15011_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_270_in_k_right15025  */
static	ANTLR3_BITWORD FOLLOW_270_in_k_right15025_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_270_in_k_right15025	= { FOLLOW_270_in_k_right15025_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_271_in_k_rollup15039  */
static	ANTLR3_BITWORD FOLLOW_271_in_k_rollup15039_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_271_in_k_rollup15039	= { FOLLOW_271_in_k_rollup15039_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_rules15056  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_rules15056_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_rules15056	= { FOLLOW_ID_in_k_rules15056_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_sample15071  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_sample15071_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_sample15071	= { FOLLOW_ID_in_k_sample15071_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_scn15086  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_scn15086_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_scn15086	= { FOLLOW_ID_in_k_scn15086_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_272_in_k_search15099  */
static	ANTLR3_BITWORD FOLLOW_272_in_k_search15099_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_272_in_k_search15099	= { FOLLOW_272_in_k_search15099_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_second15115  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_second15115_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_second15115	= { FOLLOW_ID_in_k_second15115_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_seed15130  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_seed15130_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_seed15130	= { FOLLOW_ID_in_k_seed15130_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_sequential15145  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_sequential15145_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_sequential15145	= { FOLLOW_ID_in_k_sequential15145_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_sessiontimezone15160  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_sessiontimezone15160_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_sessiontimezone15160	= { FOLLOW_ID_in_k_sessiontimezone15160_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_273_in_k_sets15173  */
static	ANTLR3_BITWORD FOLLOW_273_in_k_sets15173_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_273_in_k_sets15173	= { FOLLOW_273_in_k_sets15173_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_siblings15189  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_siblings15189_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_siblings15189	= { FOLLOW_ID_in_k_siblings15189_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_single15204  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_single15204_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_single15204	= { FOLLOW_ID_in_k_single15204_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_skip15219  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_skip15219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_skip15219	= { FOLLOW_ID_in_k_skip15219_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_274_in_k_some15232  */
static	ANTLR3_BITWORD FOLLOW_274_in_k_some15232_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_274_in_k_some15232	= { FOLLOW_274_in_k_some15232_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_275_in_k_sql15246  */
static	ANTLR3_BITWORD FOLLOW_275_in_k_sql15246_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_275_in_k_sql15246	= { FOLLOW_275_in_k_sql15246_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_276_in_k_submultiset15263  */
static	ANTLR3_BITWORD FOLLOW_276_in_k_submultiset15263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_276_in_k_submultiset15263	= { FOLLOW_276_in_k_submultiset15263_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_subpartition15279  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_subpartition15279_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_subpartition15279	= { FOLLOW_ID_in_k_subpartition15279_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_277_in_k_the15293  */
static	ANTLR3_BITWORD FOLLOW_277_in_k_the15293_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_277_in_k_the15293	= { FOLLOW_277_in_k_the15293_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_time15309  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_time15309_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_time15309	= { FOLLOW_ID_in_k_time15309_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_278_in_k_timestamp15322  */
static	ANTLR3_BITWORD FOLLOW_278_in_k_timestamp15322_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_278_in_k_timestamp15322	= { FOLLOW_278_in_k_timestamp15322_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_timezone_hour15338  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_timezone_hour15338_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_timezone_hour15338	= { FOLLOW_ID_in_k_timezone_hour15338_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_timezone_minute15353  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_timezone_minute15353_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_timezone_minute15353	= { FOLLOW_ID_in_k_timezone_minute15353_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_timezone_region15368  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_timezone_region15368_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_timezone_region15368	= { FOLLOW_ID_in_k_timezone_region15368_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_timezone_abbr15383  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_timezone_abbr15383_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_timezone_abbr15383	= { FOLLOW_ID_in_k_timezone_abbr15383_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_213_in_k_to15415  */
static	ANTLR3_BITWORD FOLLOW_213_in_k_to15415_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_213_in_k_to15415	= { FOLLOW_213_in_k_to15415_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_trailing15444  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_trailing15444_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_trailing15444	= { FOLLOW_ID_in_k_trailing15444_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_trim15476  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_trim15476_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_trim15476	= { FOLLOW_ID_in_k_trim15476_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_type15509  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_type15509_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_type15509	= { FOLLOW_ID_in_k_type15509_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_279_in_k_unbounded15534  */
static	ANTLR3_BITWORD FOLLOW_279_in_k_unbounded15534_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_279_in_k_unbounded15534	= { FOLLOW_279_in_k_unbounded15534_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_under_path15561  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_under_path15561_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_under_path15561	= { FOLLOW_ID_in_k_under_path15561_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_unlimited15588  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_unlimited15588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_unlimited15588	= { FOLLOW_ID_in_k_unlimited15588_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_280_in_k_unpivot15615  */
static	ANTLR3_BITWORD FOLLOW_280_in_k_unpivot15615_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_280_in_k_unpivot15615	= { FOLLOW_280_in_k_unpivot15615_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_until15647  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_until15647_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_until15647	= { FOLLOW_ID_in_k_until15647_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_updated15676  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_updated15676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_updated15676	= { FOLLOW_ID_in_k_updated15676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_upsert15706  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_upsert15706_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_upsert15706	= { FOLLOW_ID_in_k_upsert15706_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_urowid15736  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_urowid15736_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_urowid15736	= { FOLLOW_ID_in_k_urowid15736_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_281_in_k_using15765  */
static	ANTLR3_BITWORD FOLLOW_281_in_k_using15765_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_281_in_k_using15765	= { FOLLOW_281_in_k_using15765_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_value15797  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_value15797_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_value15797	= { FOLLOW_ID_in_k_value15797_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_varying15829  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_varying15829_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_varying15829	= { FOLLOW_ID_in_k_varying15829_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_282_in_k_versions15855  */
static	ANTLR3_BITWORD FOLLOW_282_in_k_versions15855_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_282_in_k_versions15855	= { FOLLOW_282_in_k_versions15855_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_wait15894  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_wait15894_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_wait15894	= { FOLLOW_ID_in_k_wait15894_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_283_in_k_when15924  */
static	ANTLR3_BITWORD FOLLOW_283_in_k_when15924_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_283_in_k_when15924	= { FOLLOW_283_in_k_when15924_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_within15955  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_within15955_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_within15955	= { FOLLOW_ID_in_k_within15955_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_xml15988  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_xml15988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_xml15988	= { FOLLOW_ID_in_k_xml15988_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_year16021  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_year16021_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_year16021	= { FOLLOW_ID_in_k_year16021_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ID_in_k_zone16053  */
static	ANTLR3_BITWORD FOLLOW_ID_in_k_zone16053_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ID_in_k_zone16053	= { FOLLOW_ID_in_k_zone16053_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_keyword16068  */
static	ANTLR3_BITWORD FOLLOW_set_in_keyword16068_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_keyword16068	= { FOLLOW_set_in_keyword16068_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_quoted_string0  */
static	ANTLR3_BITWORD FOLLOW_set_in_quoted_string0_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_quoted_string0	= { FOLLOW_set_in_quoted_string0_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOUBLEVERTBAR_in_doublevertbar17314  */
static	ANTLR3_BITWORD FOLLOW_DOUBLEVERTBAR_in_doublevertbar17314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DOUBLEVERTBAR_in_doublevertbar17314	= { FOLLOW_DOUBLEVERTBAR_in_doublevertbar17314_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_VERTBAR_in_doublevertbar17322  */
static	ANTLR3_BITWORD FOLLOW_VERTBAR_in_doublevertbar17322_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_VERTBAR_in_doublevertbar17322	= { FOLLOW_VERTBAR_in_doublevertbar17322_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_VERTBAR_in_doublevertbar17324  */
static	ANTLR3_BITWORD FOLLOW_VERTBAR_in_doublevertbar17324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_VERTBAR_in_doublevertbar17324	= { FOLLOW_VERTBAR_in_doublevertbar17324_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_EQ_in_not_equal17347  */
static	ANTLR3_BITWORD FOLLOW_NOT_EQ_in_not_equal17347_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_EQ_in_not_equal17347	= { FOLLOW_NOT_EQ_in_not_equal17347_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LTH_in_not_equal17355  */
static	ANTLR3_BITWORD FOLLOW_LTH_in_not_equal17355_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_LTH_in_not_equal17355	= { FOLLOW_LTH_in_not_equal17355_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GTH_in_not_equal17357  */
static	ANTLR3_BITWORD FOLLOW_GTH_in_not_equal17357_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GTH_in_not_equal17357	= { FOLLOW_GTH_in_not_equal17357_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_284_in_not_equal17365  */
static	ANTLR3_BITWORD FOLLOW_284_in_not_equal17365_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_284_in_not_equal17365	= { FOLLOW_284_in_not_equal17365_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_not_equal17367  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_not_equal17367_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_not_equal17367	= { FOLLOW_EQ_in_not_equal17367_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_285_in_not_equal17375  */
static	ANTLR3_BITWORD FOLLOW_285_in_not_equal17375_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_285_in_not_equal17375	= { FOLLOW_285_in_not_equal17375_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_not_equal17377  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_not_equal17377_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_not_equal17377	= { FOLLOW_EQ_in_not_equal17377_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LEQ_in_leq17422  */
static	ANTLR3_BITWORD FOLLOW_LEQ_in_leq17422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LEQ_in_leq17422	= { FOLLOW_LEQ_in_leq17422_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LTH_in_leq17430  */
static	ANTLR3_BITWORD FOLLOW_LTH_in_leq17430_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LTH_in_leq17430	= { FOLLOW_LTH_in_leq17430_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_leq17432  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_leq17432_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_leq17432	= { FOLLOW_EQ_in_leq17432_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GEQ_in_geq17465  */
static	ANTLR3_BITWORD FOLLOW_GEQ_in_geq17465_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GEQ_in_geq17465	= { FOLLOW_GEQ_in_geq17465_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GTH_in_geq17473  */
static	ANTLR3_BITWORD FOLLOW_GTH_in_geq17473_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_GTH_in_geq17473	= { FOLLOW_GTH_in_geq17473_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_geq17475  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_geq17475_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_geq17475	= { FOLLOW_EQ_in_geq17475_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_synpred8_OracleSQL902  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_synpred8_OracleSQL902_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_synpred8_OracleSQL902	= { FOLLOW_t_alias_in_synpred8_OracleSQL902_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_when_in_synpred15_OracleSQL1038  */
static	ANTLR3_BITWORD FOLLOW_k_when_in_synpred15_OracleSQL1038_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_when_in_synpred15_OracleSQL1038	= { FOLLOW_k_when_in_synpred15_OracleSQL1038_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_matched_in_synpred15_OracleSQL1040  */
static	ANTLR3_BITWORD FOLLOW_k_matched_in_synpred15_OracleSQL1040_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_matched_in_synpred15_OracleSQL1040	= { FOLLOW_k_matched_in_synpred15_OracleSQL1040_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_when_in_synpred17_OracleSQL1073  */
static	ANTLR3_BITWORD FOLLOW_k_when_in_synpred17_OracleSQL1073_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_when_in_synpred17_OracleSQL1073	= { FOLLOW_k_when_in_synpred17_OracleSQL1073_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_synpred17_OracleSQL1075  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_synpred17_OracleSQL1075_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_synpred17_OracleSQL1075	= { FOLLOW_r_not_in_synpred17_OracleSQL1075_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_matched_in_synpred17_OracleSQL1077  */
static	ANTLR3_BITWORD FOLLOW_k_matched_in_synpred17_OracleSQL1077_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_matched_in_synpred17_OracleSQL1077	= { FOLLOW_k_matched_in_synpred17_OracleSQL1077_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_synpred33_OracleSQL1310  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_synpred33_OracleSQL1310_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_synpred33_OracleSQL1310	= { FOLLOW_select_statement_in_synpred33_OracleSQL1310_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_synpred35_OracleSQL1336  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_synpred35_OracleSQL1336_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_synpred35_OracleSQL1336	= { FOLLOW_t_alias_in_synpred35_OracleSQL1336_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_partition_extension_clause_in_synpred54_OracleSQL1595  */
static	ANTLR3_BITWORD FOLLOW_partition_extension_clause_in_synpred54_OracleSQL1595_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_partition_extension_clause_in_synpred54_OracleSQL1595	= { FOLLOW_partition_extension_clause_in_synpred54_OracleSQL1595_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_synpred58_OracleSQL1614  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_synpred58_OracleSQL1614_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_synpred58_OracleSQL1614	= { FOLLOW_pivot_clause_in_synpred58_OracleSQL1614_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_synpred59_OracleSQL1616  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_synpred59_OracleSQL1616_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_synpred59_OracleSQL1616	= { FOLLOW_unpivot_clause_in_synpred59_OracleSQL1616_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_synpred60_OracleSQL1608  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_synpred60_OracleSQL1608_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_synpred60_OracleSQL1608	= { FOLLOW_subquery_in_synpred60_OracleSQL1608_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_restricrion_clause_in_synpred60_OracleSQL1610  */
static	ANTLR3_BITWORD FOLLOW_subquery_restricrion_clause_in_synpred60_OracleSQL1610_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_restricrion_clause_in_synpred60_OracleSQL1610	= { FOLLOW_subquery_restricrion_clause_in_synpred60_OracleSQL1610_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_synpred60_OracleSQL1614  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_synpred60_OracleSQL1614_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_synpred60_OracleSQL1614	= { FOLLOW_pivot_clause_in_synpred60_OracleSQL1614_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_synpred60_OracleSQL1616  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_synpred60_OracleSQL1616_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_synpred60_OracleSQL1616	= { FOLLOW_unpivot_clause_in_synpred60_OracleSQL1616_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred62_OracleSQL1623  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred62_OracleSQL1623_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred62_OracleSQL1623	= { FOLLOW_LPAREN_in_synpred62_OracleSQL1623_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_synpred62_OracleSQL1625  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_synpred62_OracleSQL1625_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_synpred62_OracleSQL1625	= { FOLLOW_subquery_in_synpred62_OracleSQL1625_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_restricrion_clause_in_synpred62_OracleSQL1627  */
static	ANTLR3_BITWORD FOLLOW_subquery_restricrion_clause_in_synpred62_OracleSQL1627_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_restricrion_clause_in_synpred62_OracleSQL1627	= { FOLLOW_subquery_restricrion_clause_in_synpred62_OracleSQL1627_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred62_OracleSQL1630  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred62_OracleSQL1630_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred62_OracleSQL1630	= { FOLLOW_RPAREN_in_synpred62_OracleSQL1630_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_into_in_synpred63_OracleSQL1651  */
static	ANTLR3_BITWORD FOLLOW_r_into_in_synpred63_OracleSQL1651_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_into_in_synpred63_OracleSQL1651	= { FOLLOW_r_into_in_synpred63_OracleSQL1651_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_name_long_in_synpred63_OracleSQL1653  */
static	ANTLR3_BITWORD FOLLOW_table_name_long_in_synpred63_OracleSQL1653_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_table_name_long_in_synpred63_OracleSQL1653	= { FOLLOW_table_name_long_in_synpred63_OracleSQL1653_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_synpred73_OracleSQL1795  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_synpred73_OracleSQL1795_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_synpred73_OracleSQL1795	= { FOLLOW_sql_expression_in_synpred73_OracleSQL1795_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_synpred79_OracleSQL1931  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_synpred79_OracleSQL1931_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_synpred79_OracleSQL1931	= { FOLLOW_subquery_in_synpred79_OracleSQL1931_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_where_clause_in_synpred87_OracleSQL2024  */
static	ANTLR3_BITWORD FOLLOW_where_clause_in_synpred87_OracleSQL2024_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_where_clause_in_synpred87_OracleSQL2024	= { FOLLOW_where_clause_in_synpred87_OracleSQL2024_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_hierarchical_query_clause_in_synpred88_OracleSQL2032  */
static	ANTLR3_BITWORD FOLLOW_hierarchical_query_clause_in_synpred88_OracleSQL2032_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_hierarchical_query_clause_in_synpred88_OracleSQL2032	= { FOLLOW_hierarchical_query_clause_in_synpred88_OracleSQL2032_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_clause_in_synpred89_OracleSQL2040  */
static	ANTLR3_BITWORD FOLLOW_group_by_clause_in_synpred89_OracleSQL2040_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_clause_in_synpred89_OracleSQL2040	= { FOLLOW_group_by_clause_in_synpred89_OracleSQL2040_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_model_in_synpred92_OracleSQL2049  */
static	ANTLR3_BITWORD FOLLOW_k_model_in_synpred92_OracleSQL2049_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000200000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_k_model_in_synpred92_OracleSQL2049	= { FOLLOW_k_model_in_synpred92_OracleSQL2049_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_main_in_synpred92_OracleSQL2052  */
static	ANTLR3_BITWORD FOLLOW_k_main_in_synpred92_OracleSQL2052_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_main_in_synpred92_OracleSQL2052	= { FOLLOW_k_main_in_synpred92_OracleSQL2052_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_partition_in_synpred92_OracleSQL2054  */
static	ANTLR3_BITWORD FOLLOW_k_partition_in_synpred92_OracleSQL2054_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_partition_in_synpred92_OracleSQL2054	= { FOLLOW_k_partition_in_synpred92_OracleSQL2054_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dimension_in_synpred92_OracleSQL2056  */
static	ANTLR3_BITWORD FOLLOW_k_dimension_in_synpred92_OracleSQL2056_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dimension_in_synpred92_OracleSQL2056	= { FOLLOW_k_dimension_in_synpred92_OracleSQL2056_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_union_clause_in_synpred93_OracleSQL2071  */
static	ANTLR3_BITWORD FOLLOW_union_clause_in_synpred93_OracleSQL2071_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_union_clause_in_synpred93_OracleSQL2071	= { FOLLOW_union_clause_in_synpred93_OracleSQL2071_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_synpred94_OracleSQL2081  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_synpred94_OracleSQL2081_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_synpred94_OracleSQL2081	= { FOLLOW_for_update_clause_in_synpred94_OracleSQL2081_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_synpred95_OracleSQL2097  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_synpred95_OracleSQL2097_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_synpred95_OracleSQL2097	= { FOLLOW_order_by_clause_in_synpred95_OracleSQL2097_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_synpred96_OracleSQL2107  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_synpred96_OracleSQL2107_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_synpred96_OracleSQL2107	= { FOLLOW_for_update_clause_in_synpred96_OracleSQL2107_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_depth_in_synpred103_OracleSQL2368  */
static	ANTLR3_BITWORD FOLLOW_k_depth_in_synpred103_OracleSQL2368_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_depth_in_synpred103_OracleSQL2368	= { FOLLOW_k_depth_in_synpred103_OracleSQL2368_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PLUS_in_synpred121_OracleSQL2688  */
static	ANTLR3_BITWORD FOLLOW_PLUS_in_synpred121_OracleSQL2688_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_PLUS_in_synpred121_OracleSQL2688	= { FOLLOW_PLUS_in_synpred121_OracleSQL2688_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_in_synpred121_OracleSQL2692  */
static	ANTLR3_BITWORD FOLLOW_MINUS_in_synpred121_OracleSQL2692_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_in_synpred121_OracleSQL2692	= { FOLLOW_MINUS_in_synpred121_OracleSQL2692_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_doublevertbar_in_synpred121_OracleSQL2696  */
static	ANTLR3_BITWORD FOLLOW_doublevertbar_in_synpred121_OracleSQL2696_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_doublevertbar_in_synpred121_OracleSQL2696	= { FOLLOW_doublevertbar_in_synpred121_OracleSQL2696_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_mul_in_synpred121_OracleSQL2700  */
static	ANTLR3_BITWORD FOLLOW_expr_mul_in_synpred121_OracleSQL2700_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_mul_in_synpred121_OracleSQL2700	= { FOLLOW_expr_mul_in_synpred121_OracleSQL2700_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_synpred123_OracleSQL2717  */
static	ANTLR3_BITWORD FOLLOW_set_in_synpred123_OracleSQL2717_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_synpred123_OracleSQL2717	= { FOLLOW_set_in_synpred123_OracleSQL2717_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_sign_in_synpred123_OracleSQL2727  */
static	ANTLR3_BITWORD FOLLOW_expr_sign_in_synpred123_OracleSQL2727_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_sign_in_synpred123_OracleSQL2727	= { FOLLOW_expr_sign_in_synpred123_OracleSQL2727_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_extract_datetime_expression_in_synpred128_OracleSQL2771  */
static	ANTLR3_BITWORD FOLLOW_extract_datetime_expression_in_synpred128_OracleSQL2771_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_extract_datetime_expression_in_synpred128_OracleSQL2771	= { FOLLOW_extract_datetime_expression_in_synpred128_OracleSQL2771_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_interval_x_to_y_in_synpred129_OracleSQL2781  */
static	ANTLR3_BITWORD FOLLOW_interval_x_to_y_in_synpred129_OracleSQL2781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_interval_x_to_y_in_synpred129_OracleSQL2781	= { FOLLOW_interval_x_to_y_in_synpred129_OracleSQL2781_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datetime_expression_in_synpred130_OracleSQL2786  */
static	ANTLR3_BITWORD FOLLOW_datetime_expression_in_synpred130_OracleSQL2786_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datetime_expression_in_synpred130_OracleSQL2786	= { FOLLOW_datetime_expression_in_synpred130_OracleSQL2786_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_interval_expression_in_synpred131_OracleSQL2791  */
static	ANTLR3_BITWORD FOLLOW_interval_expression_in_synpred131_OracleSQL2791_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_interval_expression_in_synpred131_OracleSQL2791	= { FOLLOW_interval_expression_in_synpred131_OracleSQL2791_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_paren_in_synpred132_OracleSQL2798  */
static	ANTLR3_BITWORD FOLLOW_expr_paren_in_synpred132_OracleSQL2798_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_paren_in_synpred132_OracleSQL2798	= { FOLLOW_expr_paren_in_synpred132_OracleSQL2798_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_cursor_in_synpred133_OracleSQL2811  */
static	ANTLR3_BITWORD FOLLOW_k_cursor_in_synpred133_OracleSQL2811_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_cursor_in_synpred133_OracleSQL2811	= { FOLLOW_k_cursor_in_synpred133_OracleSQL2811_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred133_OracleSQL2813  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred133_OracleSQL2813_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred133_OracleSQL2813	= { FOLLOW_LPAREN_in_synpred133_OracleSQL2813_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_cast_in_synpred134_OracleSQL2827  */
static	ANTLR3_BITWORD FOLLOW_k_cast_in_synpred134_OracleSQL2827_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_cast_in_synpred134_OracleSQL2827	= { FOLLOW_k_cast_in_synpred134_OracleSQL2827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred134_OracleSQL2829  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred134_OracleSQL2829_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred134_OracleSQL2829	= { FOLLOW_LPAREN_in_synpred134_OracleSQL2829_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_cluster_set_in_synpred135_OracleSQL2841  */
static	ANTLR3_BITWORD FOLLOW_k_cluster_set_in_synpred135_OracleSQL2841_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_cluster_set_in_synpred135_OracleSQL2841	= { FOLLOW_k_cluster_set_in_synpred135_OracleSQL2841_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred135_OracleSQL2843  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred135_OracleSQL2843_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred135_OracleSQL2843	= { FOLLOW_LPAREN_in_synpred135_OracleSQL2843_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_object_access_expression_in_synpred136_OracleSQL2854  */
static	ANTLR3_BITWORD FOLLOW_object_access_expression_in_synpred136_OracleSQL2854_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_object_access_expression_in_synpred136_OracleSQL2854	= { FOLLOW_object_access_expression_in_synpred136_OracleSQL2854_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_case_expression_in_synpred137_OracleSQL2861  */
static	ANTLR3_BITWORD FOLLOW_case_expression_in_synpred137_OracleSQL2861_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_case_expression_in_synpred137_OracleSQL2861	= { FOLLOW_case_expression_in_synpred137_OracleSQL2861_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_special_function_in_synpred138_OracleSQL2874  */
static	ANTLR3_BITWORD FOLLOW_special_function_in_synpred138_OracleSQL2874_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_special_function_in_synpred138_OracleSQL2874	= { FOLLOW_special_function_in_synpred138_OracleSQL2874_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_analytic_function_in_synpred139_OracleSQL2887  */
static	ANTLR3_BITWORD FOLLOW_analytic_function_in_synpred139_OracleSQL2887_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_analytic_function_in_synpred139_OracleSQL2887	= { FOLLOW_analytic_function_in_synpred139_OracleSQL2887_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_aggregate_function_in_synpred140_OracleSQL2900  */
static	ANTLR3_BITWORD FOLLOW_aggregate_function_in_synpred140_OracleSQL2900_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_aggregate_function_in_synpred140_OracleSQL2900	= { FOLLOW_aggregate_function_in_synpred140_OracleSQL2900_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_expression_in_synpred141_OracleSQL2913  */
static	ANTLR3_BITWORD FOLLOW_function_expression_in_synpred141_OracleSQL2913_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_function_expression_in_synpred141_OracleSQL2913	= { FOLLOW_function_expression_in_synpred141_OracleSQL2913_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simple_expression_in_synpred142_OracleSQL2927  */
static	ANTLR3_BITWORD FOLLOW_simple_expression_in_synpred142_OracleSQL2927_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simple_expression_in_synpred142_OracleSQL2927	= { FOLLOW_simple_expression_in_synpred142_OracleSQL2927_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred144_OracleSQL2946  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred144_OracleSQL2946_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred144_OracleSQL2946	= { FOLLOW_LPAREN_in_synpred144_OracleSQL2946_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_select_in_synpred144_OracleSQL2949  */
static	ANTLR3_BITWORD FOLLOW_r_select_in_synpred144_OracleSQL2949_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_select_in_synpred144_OracleSQL2949	= { FOLLOW_r_select_in_synpred144_OracleSQL2949_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_with_in_synpred144_OracleSQL2953  */
static	ANTLR3_BITWORD FOLLOW_r_with_in_synpred144_OracleSQL2953_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_with_in_synpred144_OracleSQL2953	= { FOLLOW_r_with_in_synpred144_OracleSQL2953_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_function_spec_in_synpred145_OracleSQL2997  */
static	ANTLR3_BITWORD FOLLOW_function_spec_in_synpred145_OracleSQL2997_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_function_spec_in_synpred145_OracleSQL2997	= { FOLLOW_function_spec_in_synpred145_OracleSQL2997_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_leading_in_synpred150_OracleSQL3113  */
static	ANTLR3_BITWORD FOLLOW_k_leading_in_synpred150_OracleSQL3113_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_leading_in_synpred150_OracleSQL3113	= { FOLLOW_k_leading_in_synpred150_OracleSQL3113_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_trailing_in_synpred151_OracleSQL3117  */
static	ANTLR3_BITWORD FOLLOW_k_trailing_in_synpred151_OracleSQL3117_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_trailing_in_synpred151_OracleSQL3117	= { FOLLOW_k_trailing_in_synpred151_OracleSQL3117_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_both_in_synpred152_OracleSQL3121  */
static	ANTLR3_BITWORD FOLLOW_k_both_in_synpred152_OracleSQL3121_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_both_in_synpred152_OracleSQL3121	= { FOLLOW_k_both_in_synpred152_OracleSQL3121_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_trim_in_synpred155_OracleSQL3094  */
static	ANTLR3_BITWORD FOLLOW_k_trim_in_synpred155_OracleSQL3094_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_trim_in_synpred155_OracleSQL3094	= { FOLLOW_k_trim_in_synpred155_OracleSQL3094_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred155_OracleSQL3104  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred155_OracleSQL3104_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000440100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred155_OracleSQL3104	= { FOLLOW_LPAREN_in_synpred155_OracleSQL3104_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_leading_in_synpred155_OracleSQL3113  */
static	ANTLR3_BITWORD FOLLOW_k_leading_in_synpred155_OracleSQL3113_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_leading_in_synpred155_OracleSQL3113	= { FOLLOW_k_leading_in_synpred155_OracleSQL3113_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_trailing_in_synpred155_OracleSQL3117  */
static	ANTLR3_BITWORD FOLLOW_k_trailing_in_synpred155_OracleSQL3117_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_trailing_in_synpred155_OracleSQL3117	= { FOLLOW_k_trailing_in_synpred155_OracleSQL3117_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_both_in_synpred155_OracleSQL3121  */
static	ANTLR3_BITWORD FOLLOW_k_both_in_synpred155_OracleSQL3121_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000200), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_both_in_synpred155_OracleSQL3121	= { FOLLOW_k_both_in_synpred155_OracleSQL3121_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_QUOTED_STRING_in_synpred155_OracleSQL3125  */
static	ANTLR3_BITWORD FOLLOW_QUOTED_STRING_in_synpred155_OracleSQL3125_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_QUOTED_STRING_in_synpred155_OracleSQL3125	= { FOLLOW_QUOTED_STRING_in_synpred155_OracleSQL3125_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_from_in_synpred155_OracleSQL3128  */
static	ANTLR3_BITWORD FOLLOW_r_from_in_synpred155_OracleSQL3128_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_from_in_synpred155_OracleSQL3128	= { FOLLOW_r_from_in_synpred155_OracleSQL3128_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_synpred155_OracleSQL3136  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_synpred155_OracleSQL3136_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_synpred155_OracleSQL3136	= { FOLLOW_sql_expression_in_synpred155_OracleSQL3136_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred155_OracleSQL3146  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred155_OracleSQL3146_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred155_OracleSQL3146	= { FOLLOW_RPAREN_in_synpred155_OracleSQL3146_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simple_case_expression_in_synpred157_OracleSQL3194  */
static	ANTLR3_BITWORD FOLLOW_simple_case_expression_in_synpred157_OracleSQL3194_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simple_case_expression_in_synpred157_OracleSQL3194	= { FOLLOW_simple_case_expression_in_synpred157_OracleSQL3194_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_identifier_in_synpred162_OracleSQL3304  */
static	ANTLR3_BITWORD FOLLOW_sql_identifier_in_synpred162_OracleSQL3304_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_identifier_in_synpred162_OracleSQL3304	= { FOLLOW_sql_identifier_in_synpred162_OracleSQL3304_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_synpred162_OracleSQL3307  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_synpred162_OracleSQL3307_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_synpred162_OracleSQL3307	= { FOLLOW_DOT_in_synpred162_OracleSQL3307_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_synpred163_OracleSQL3321  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_synpred163_OracleSQL3321_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_synpred163_OracleSQL3321	= { FOLLOW_identifier_in_synpred163_OracleSQL3321_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_synpred163_OracleSQL3324  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_synpred163_OracleSQL3324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_synpred163_OracleSQL3324	= { FOLLOW_DOT_in_synpred163_OracleSQL3324_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cell_assignment_in_synpred170_OracleSQL3373  */
static	ANTLR3_BITWORD FOLLOW_cell_assignment_in_synpred170_OracleSQL3373_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cell_assignment_in_synpred170_OracleSQL3373	= { FOLLOW_cell_assignment_in_synpred170_OracleSQL3373_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_synpred171_OracleSQL3387  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_synpred171_OracleSQL3387_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_synpred171_OracleSQL3387	= { FOLLOW_column_spec_in_synpred171_OracleSQL3387_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_model_in_synpred182_OracleSQL3499  */
static	ANTLR3_BITWORD FOLLOW_k_model_in_synpred182_OracleSQL3499_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000200000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_k_model_in_synpred182_OracleSQL3499	= { FOLLOW_k_model_in_synpred182_OracleSQL3499_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_main_in_synpred182_OracleSQL3502  */
static	ANTLR3_BITWORD FOLLOW_k_main_in_synpred182_OracleSQL3502_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_main_in_synpred182_OracleSQL3502	= { FOLLOW_k_main_in_synpred182_OracleSQL3502_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_partition_in_synpred182_OracleSQL3504  */
static	ANTLR3_BITWORD FOLLOW_k_partition_in_synpred182_OracleSQL3504_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_partition_in_synpred182_OracleSQL3504	= { FOLLOW_k_partition_in_synpred182_OracleSQL3504_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dimension_in_synpred182_OracleSQL3506  */
static	ANTLR3_BITWORD FOLLOW_k_dimension_in_synpred182_OracleSQL3506_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dimension_in_synpred182_OracleSQL3506	= { FOLLOW_k_dimension_in_synpred182_OracleSQL3506_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_clause_in_synpred183_OracleSQL3543  */
static	ANTLR3_BITWORD FOLLOW_group_by_clause_in_synpred183_OracleSQL3543_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_clause_in_synpred183_OracleSQL3543	= { FOLLOW_group_by_clause_in_synpred183_OracleSQL3543_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_model_in_synpred186_OracleSQL3559  */
static	ANTLR3_BITWORD FOLLOW_k_model_in_synpred186_OracleSQL3559_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000200000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_k_model_in_synpred186_OracleSQL3559	= { FOLLOW_k_model_in_synpred186_OracleSQL3559_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_main_in_synpred186_OracleSQL3562  */
static	ANTLR3_BITWORD FOLLOW_k_main_in_synpred186_OracleSQL3562_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_main_in_synpred186_OracleSQL3562	= { FOLLOW_k_main_in_synpred186_OracleSQL3562_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_partition_in_synpred186_OracleSQL3564  */
static	ANTLR3_BITWORD FOLLOW_k_partition_in_synpred186_OracleSQL3564_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_partition_in_synpred186_OracleSQL3564	= { FOLLOW_k_partition_in_synpred186_OracleSQL3564_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dimension_in_synpred186_OracleSQL3566  */
static	ANTLR3_BITWORD FOLLOW_k_dimension_in_synpred186_OracleSQL3566_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dimension_in_synpred186_OracleSQL3566	= { FOLLOW_k_dimension_in_synpred186_OracleSQL3566_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_union_clause_in_synpred187_OracleSQL3588  */
static	ANTLR3_BITWORD FOLLOW_union_clause_in_synpred187_OracleSQL3588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_union_clause_in_synpred187_OracleSQL3588	= { FOLLOW_union_clause_in_synpred187_OracleSQL3588_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_synpred188_OracleSQL3605  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_synpred188_OracleSQL3605_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_synpred188_OracleSQL3605	= { FOLLOW_for_update_clause_in_synpred188_OracleSQL3605_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_synpred189_OracleSQL3628  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_synpred189_OracleSQL3628_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_synpred189_OracleSQL3628	= { FOLLOW_order_by_clause_in_synpred189_OracleSQL3628_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_synpred190_OracleSQL3645  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_synpred190_OracleSQL3645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_synpred190_OracleSQL3645	= { FOLLOW_for_update_clause_in_synpred190_OracleSQL3645_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred191_OracleSQL3527  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred191_OracleSQL3527_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred191_OracleSQL3527	= { FOLLOW_LPAREN_in_synpred191_OracleSQL3527_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_synpred191_OracleSQL3529  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_synpred191_OracleSQL3529_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_synpred191_OracleSQL3529	= { FOLLOW_select_statement_in_synpred191_OracleSQL3529_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred191_OracleSQL3531  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred191_OracleSQL3531_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040403200000), ANTLR3_UINT64_LIT(0x0000000002000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred191_OracleSQL3531	= { FOLLOW_RPAREN_in_synpred191_OracleSQL3531_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_clause_in_synpred191_OracleSQL3543  */
static	ANTLR3_BITWORD FOLLOW_group_by_clause_in_synpred191_OracleSQL3543_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_clause_in_synpred191_OracleSQL3543	= { FOLLOW_group_by_clause_in_synpred191_OracleSQL3543_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_model_clause_in_synpred191_OracleSQL3573  */
static	ANTLR3_BITWORD FOLLOW_model_clause_in_synpred191_OracleSQL3573_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_model_clause_in_synpred191_OracleSQL3573	= { FOLLOW_model_clause_in_synpred191_OracleSQL3573_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_union_clause_in_synpred191_OracleSQL3588  */
static	ANTLR3_BITWORD FOLLOW_union_clause_in_synpred191_OracleSQL3588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400040400200000), ANTLR3_UINT64_LIT(0x0000000002000000) };
static  ANTLR3_BITSET_LIST FOLLOW_union_clause_in_synpred191_OracleSQL3588	= { FOLLOW_union_clause_in_synpred191_OracleSQL3588_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_synpred191_OracleSQL3605  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_synpred191_OracleSQL3605_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0400000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_synpred191_OracleSQL3605	= { FOLLOW_for_update_clause_in_synpred191_OracleSQL3605_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_synpred191_OracleSQL3628  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_synpred191_OracleSQL3628_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_synpred191_OracleSQL3628	= { FOLLOW_order_by_clause_in_synpred191_OracleSQL3628_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_synpred191_OracleSQL3645  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_synpred191_OracleSQL3645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_synpred191_OracleSQL3645	= { FOLLOW_for_update_clause_in_synpred191_OracleSQL3645_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_clause_in_synpred192_OracleSQL3669  */
static	ANTLR3_BITWORD FOLLOW_group_by_clause_in_synpred192_OracleSQL3669_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_clause_in_synpred192_OracleSQL3669	= { FOLLOW_group_by_clause_in_synpred192_OracleSQL3669_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_model_in_synpred195_OracleSQL3685  */
static	ANTLR3_BITWORD FOLLOW_k_model_in_synpred195_OracleSQL3685_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000200000000000), ANTLR3_UINT64_LIT(0x0000000000000040) };
static  ANTLR3_BITSET_LIST FOLLOW_k_model_in_synpred195_OracleSQL3685	= { FOLLOW_k_model_in_synpred195_OracleSQL3685_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_main_in_synpred195_OracleSQL3688  */
static	ANTLR3_BITWORD FOLLOW_k_main_in_synpred195_OracleSQL3688_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_main_in_synpred195_OracleSQL3688	= { FOLLOW_k_main_in_synpred195_OracleSQL3688_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_partition_in_synpred195_OracleSQL3690  */
static	ANTLR3_BITWORD FOLLOW_k_partition_in_synpred195_OracleSQL3690_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_partition_in_synpred195_OracleSQL3690	= { FOLLOW_k_partition_in_synpred195_OracleSQL3690_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dimension_in_synpred195_OracleSQL3692  */
static	ANTLR3_BITWORD FOLLOW_k_dimension_in_synpred195_OracleSQL3692_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dimension_in_synpred195_OracleSQL3692	= { FOLLOW_k_dimension_in_synpred195_OracleSQL3692_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_union_clause_in_synpred196_OracleSQL3714  */
static	ANTLR3_BITWORD FOLLOW_union_clause_in_synpred196_OracleSQL3714_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_union_clause_in_synpred196_OracleSQL3714	= { FOLLOW_union_clause_in_synpred196_OracleSQL3714_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_synpred197_OracleSQL3731  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_synpred197_OracleSQL3731_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_synpred197_OracleSQL3731	= { FOLLOW_for_update_clause_in_synpred197_OracleSQL3731_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_order_by_clause_in_synpred198_OracleSQL3754  */
static	ANTLR3_BITWORD FOLLOW_order_by_clause_in_synpred198_OracleSQL3754_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_order_by_clause_in_synpred198_OracleSQL3754	= { FOLLOW_order_by_clause_in_synpred198_OracleSQL3754_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_for_update_clause_in_synpred199_OracleSQL3771  */
static	ANTLR3_BITWORD FOLLOW_for_update_clause_in_synpred199_OracleSQL3771_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_for_update_clause_in_synpred199_OracleSQL3771	= { FOLLOW_for_update_clause_in_synpred199_OracleSQL3771_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_synpred202_OracleSQL3883  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_synpred202_OracleSQL3883_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_synpred202_OracleSQL3883	= { FOLLOW_k_year_in_synpred202_OracleSQL3883_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred203_OracleSQL3909  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred203_OracleSQL3909_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred203_OracleSQL3909	= { FOLLOW_LPAREN_in_synpred203_OracleSQL3909_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_precision_in_synpred203_OracleSQL3911  */
static	ANTLR3_BITWORD FOLLOW_precision_in_synpred203_OracleSQL3911_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_precision_in_synpred203_OracleSQL3911	= { FOLLOW_precision_in_synpred203_OracleSQL3911_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred203_OracleSQL3913  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred203_OracleSQL3913_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred203_OracleSQL3913	= { FOLLOW_RPAREN_in_synpred203_OracleSQL3913_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_synpred204_OracleSQL3939  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_synpred204_OracleSQL3939_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_synpred204_OracleSQL3939	= { FOLLOW_k_year_in_synpred204_OracleSQL3939_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_synpred206_OracleSQL3858  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_synpred206_OracleSQL3858_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_synpred206_OracleSQL3858	= { FOLLOW_quoted_string_in_synpred206_OracleSQL3858_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bind_variable_in_synpred206_OracleSQL3862  */
static	ANTLR3_BITWORD FOLLOW_bind_variable_in_synpred206_OracleSQL3862_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_bind_variable_in_synpred206_OracleSQL3862	= { FOLLOW_bind_variable_in_synpred206_OracleSQL3862_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_synpred206_OracleSQL3883  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_synpred206_OracleSQL3883_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_synpred206_OracleSQL3883	= { FOLLOW_k_year_in_synpred206_OracleSQL3883_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_month_in_synpred206_OracleSQL3887  */
static	ANTLR3_BITWORD FOLLOW_k_month_in_synpred206_OracleSQL3887_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_month_in_synpred206_OracleSQL3887	= { FOLLOW_k_month_in_synpred206_OracleSQL3887_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred206_OracleSQL3909  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred206_OracleSQL3909_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred206_OracleSQL3909	= { FOLLOW_LPAREN_in_synpred206_OracleSQL3909_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_precision_in_synpred206_OracleSQL3911  */
static	ANTLR3_BITWORD FOLLOW_precision_in_synpred206_OracleSQL3911_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_precision_in_synpred206_OracleSQL3911	= { FOLLOW_precision_in_synpred206_OracleSQL3911_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred206_OracleSQL3913  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred206_OracleSQL3913_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred206_OracleSQL3913	= { FOLLOW_RPAREN_in_synpred206_OracleSQL3913_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_to_in_synpred206_OracleSQL3936  */
static	ANTLR3_BITWORD FOLLOW_k_to_in_synpred206_OracleSQL3936_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_to_in_synpred206_OracleSQL3936	= { FOLLOW_k_to_in_synpred206_OracleSQL3936_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_synpred206_OracleSQL3939  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_synpred206_OracleSQL3939_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_synpred206_OracleSQL3939	= { FOLLOW_k_year_in_synpred206_OracleSQL3939_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_month_in_synpred206_OracleSQL3943  */
static	ANTLR3_BITWORD FOLLOW_k_month_in_synpred206_OracleSQL3943_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_month_in_synpred206_OracleSQL3943	= { FOLLOW_k_month_in_synpred206_OracleSQL3943_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_day_in_synpred208_OracleSQL4033  */
static	ANTLR3_BITWORD FOLLOW_k_day_in_synpred208_OracleSQL4033_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_day_in_synpred208_OracleSQL4033	= { FOLLOW_k_day_in_synpred208_OracleSQL4033_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_hour_in_synpred209_OracleSQL4037  */
static	ANTLR3_BITWORD FOLLOW_k_hour_in_synpred209_OracleSQL4037_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_hour_in_synpred209_OracleSQL4037	= { FOLLOW_k_hour_in_synpred209_OracleSQL4037_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_minute_in_synpred210_OracleSQL4041  */
static	ANTLR3_BITWORD FOLLOW_k_minute_in_synpred210_OracleSQL4041_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_minute_in_synpred210_OracleSQL4041	= { FOLLOW_k_minute_in_synpred210_OracleSQL4041_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred212_OracleSQL4066  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred212_OracleSQL4066_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred212_OracleSQL4066	= { FOLLOW_LPAREN_in_synpred212_OracleSQL4066_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_precision_in_synpred212_OracleSQL4068  */
static	ANTLR3_BITWORD FOLLOW_precision_in_synpred212_OracleSQL4068_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_precision_in_synpred212_OracleSQL4068	= { FOLLOW_precision_in_synpred212_OracleSQL4068_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_synpred212_OracleSQL4071  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_synpred212_OracleSQL4071_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_synpred212_OracleSQL4071	= { FOLLOW_COMMA_in_synpred212_OracleSQL4071_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_precision_in_synpred212_OracleSQL4073  */
static	ANTLR3_BITWORD FOLLOW_precision_in_synpred212_OracleSQL4073_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_precision_in_synpred212_OracleSQL4073	= { FOLLOW_precision_in_synpred212_OracleSQL4073_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred212_OracleSQL4077  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred212_OracleSQL4077_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred212_OracleSQL4077	= { FOLLOW_RPAREN_in_synpred212_OracleSQL4077_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_day_in_synpred213_OracleSQL4102  */
static	ANTLR3_BITWORD FOLLOW_k_day_in_synpred213_OracleSQL4102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_day_in_synpred213_OracleSQL4102	= { FOLLOW_k_day_in_synpred213_OracleSQL4102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_hour_in_synpred214_OracleSQL4106  */
static	ANTLR3_BITWORD FOLLOW_k_hour_in_synpred214_OracleSQL4106_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_hour_in_synpred214_OracleSQL4106	= { FOLLOW_k_hour_in_synpred214_OracleSQL4106_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_minute_in_synpred215_OracleSQL4110  */
static	ANTLR3_BITWORD FOLLOW_k_minute_in_synpred215_OracleSQL4110_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_minute_in_synpred215_OracleSQL4110	= { FOLLOW_k_minute_in_synpred215_OracleSQL4110_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred216_OracleSQL4119  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred216_OracleSQL4119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred216_OracleSQL4119	= { FOLLOW_LPAREN_in_synpred216_OracleSQL4119_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_precision_in_synpred216_OracleSQL4121  */
static	ANTLR3_BITWORD FOLLOW_precision_in_synpred216_OracleSQL4121_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_precision_in_synpred216_OracleSQL4121	= { FOLLOW_precision_in_synpred216_OracleSQL4121_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred216_OracleSQL4123  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred216_OracleSQL4123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred216_OracleSQL4123	= { FOLLOW_RPAREN_in_synpred216_OracleSQL4123_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_synpred219_OracleSQL4203  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_synpred219_OracleSQL4203_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_synpred219_OracleSQL4203	= { FOLLOW_k_year_in_synpred219_OracleSQL4203_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_month_in_synpred220_OracleSQL4215  */
static	ANTLR3_BITWORD FOLLOW_k_month_in_synpred220_OracleSQL4215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_month_in_synpred220_OracleSQL4215	= { FOLLOW_k_month_in_synpred220_OracleSQL4215_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_day_in_synpred221_OracleSQL4227  */
static	ANTLR3_BITWORD FOLLOW_k_day_in_synpred221_OracleSQL4227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_day_in_synpred221_OracleSQL4227	= { FOLLOW_k_day_in_synpred221_OracleSQL4227_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_hour_in_synpred222_OracleSQL4239  */
static	ANTLR3_BITWORD FOLLOW_k_hour_in_synpred222_OracleSQL4239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_hour_in_synpred222_OracleSQL4239	= { FOLLOW_k_hour_in_synpred222_OracleSQL4239_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_minute_in_synpred223_OracleSQL4251  */
static	ANTLR3_BITWORD FOLLOW_k_minute_in_synpred223_OracleSQL4251_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_minute_in_synpred223_OracleSQL4251	= { FOLLOW_k_minute_in_synpred223_OracleSQL4251_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_second_in_synpred224_OracleSQL4263  */
static	ANTLR3_BITWORD FOLLOW_k_second_in_synpred224_OracleSQL4263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_second_in_synpred224_OracleSQL4263	= { FOLLOW_k_second_in_synpred224_OracleSQL4263_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timezone_hour_in_synpred225_OracleSQL4275  */
static	ANTLR3_BITWORD FOLLOW_k_timezone_hour_in_synpred225_OracleSQL4275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timezone_hour_in_synpred225_OracleSQL4275	= { FOLLOW_k_timezone_hour_in_synpred225_OracleSQL4275_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timezone_minute_in_synpred226_OracleSQL4287  */
static	ANTLR3_BITWORD FOLLOW_k_timezone_minute_in_synpred226_OracleSQL4287_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timezone_minute_in_synpred226_OracleSQL4287	= { FOLLOW_k_timezone_minute_in_synpred226_OracleSQL4287_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timezone_region_in_synpred227_OracleSQL4299  */
static	ANTLR3_BITWORD FOLLOW_k_timezone_region_in_synpred227_OracleSQL4299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timezone_region_in_synpred227_OracleSQL4299	= { FOLLOW_k_timezone_region_in_synpred227_OracleSQL4299_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_local_in_synpred230_OracleSQL4397  */
static	ANTLR3_BITWORD FOLLOW_k_local_in_synpred230_OracleSQL4397_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_local_in_synpred230_OracleSQL4397	= { FOLLOW_k_local_in_synpred230_OracleSQL4397_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quoted_string_in_synpred231_OracleSQL4407  */
static	ANTLR3_BITWORD FOLLOW_quoted_string_in_synpred231_OracleSQL4407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_quoted_string_in_synpred231_OracleSQL4407	= { FOLLOW_quoted_string_in_synpred231_OracleSQL4407_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dbtimezone_in_synpred232_OracleSQL4411  */
static	ANTLR3_BITWORD FOLLOW_k_dbtimezone_in_synpred232_OracleSQL4411_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dbtimezone_in_synpred232_OracleSQL4411	= { FOLLOW_k_dbtimezone_in_synpred232_OracleSQL4411_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_sessiontimezone_in_synpred233_OracleSQL4415  */
static	ANTLR3_BITWORD FOLLOW_k_sessiontimezone_in_synpred233_OracleSQL4415_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_sessiontimezone_in_synpred233_OracleSQL4415	= { FOLLOW_k_sessiontimezone_in_synpred233_OracleSQL4415_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_day_in_synpred240_OracleSQL4471  */
static	ANTLR3_BITWORD FOLLOW_k_day_in_synpred240_OracleSQL4471_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_day_in_synpred240_OracleSQL4471	= { FOLLOW_k_day_in_synpred240_OracleSQL4471_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred240_OracleSQL4474  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred240_OracleSQL4474_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred240_OracleSQL4474	= { FOLLOW_LPAREN_in_synpred240_OracleSQL4474_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred240_OracleSQL4476  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred240_OracleSQL4476_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred240_OracleSQL4476	= { FOLLOW_NUMBER_in_synpred240_OracleSQL4476_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred240_OracleSQL4478  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred240_OracleSQL4478_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred240_OracleSQL4478	= { FOLLOW_RPAREN_in_synpred240_OracleSQL4478_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_to_in_synpred240_OracleSQL4482  */
static	ANTLR3_BITWORD FOLLOW_r_to_in_synpred240_OracleSQL4482_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_to_in_synpred240_OracleSQL4482	= { FOLLOW_r_to_in_synpred240_OracleSQL4482_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_second_in_synpred240_OracleSQL4484  */
static	ANTLR3_BITWORD FOLLOW_k_second_in_synpred240_OracleSQL4484_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_second_in_synpred240_OracleSQL4484	= { FOLLOW_k_second_in_synpred240_OracleSQL4484_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred240_OracleSQL4487  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred240_OracleSQL4487_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred240_OracleSQL4487	= { FOLLOW_LPAREN_in_synpred240_OracleSQL4487_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred240_OracleSQL4489  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred240_OracleSQL4489_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred240_OracleSQL4489	= { FOLLOW_NUMBER_in_synpred240_OracleSQL4489_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred240_OracleSQL4491  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred240_OracleSQL4491_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred240_OracleSQL4491	= { FOLLOW_RPAREN_in_synpred240_OracleSQL4491_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatype_name_in_synpred247_OracleSQL4611  */
static	ANTLR3_BITWORD FOLLOW_datatype_name_in_synpred247_OracleSQL4611_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatype_name_in_synpred247_OracleSQL4611	= { FOLLOW_datatype_name_in_synpred247_OracleSQL4611_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_binary_integer_in_synpred248_OracleSQL4627  */
static	ANTLR3_BITWORD FOLLOW_k_binary_integer_in_synpred248_OracleSQL4627_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_binary_integer_in_synpred248_OracleSQL4627	= { FOLLOW_k_binary_integer_in_synpred248_OracleSQL4627_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_binary_float_in_synpred249_OracleSQL4633  */
static	ANTLR3_BITWORD FOLLOW_k_binary_float_in_synpred249_OracleSQL4633_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_binary_float_in_synpred249_OracleSQL4633	= { FOLLOW_k_binary_float_in_synpred249_OracleSQL4633_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_binary_double_in_synpred250_OracleSQL4638  */
static	ANTLR3_BITWORD FOLLOW_k_binary_double_in_synpred250_OracleSQL4638_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_binary_double_in_synpred250_OracleSQL4638	= { FOLLOW_k_binary_double_in_synpred250_OracleSQL4638_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_natural_in_synpred251_OracleSQL4643  */
static	ANTLR3_BITWORD FOLLOW_k_natural_in_synpred251_OracleSQL4643_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_natural_in_synpred251_OracleSQL4643	= { FOLLOW_k_natural_in_synpred251_OracleSQL4643_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_positive_in_synpred252_OracleSQL4648  */
static	ANTLR3_BITWORD FOLLOW_k_positive_in_synpred252_OracleSQL4648_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_positive_in_synpred252_OracleSQL4648	= { FOLLOW_k_positive_in_synpred252_OracleSQL4648_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_numeric_in_synpred254_OracleSQL4659  */
static	ANTLR3_BITWORD FOLLOW_k_numeric_in_synpred254_OracleSQL4659_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_numeric_in_synpred254_OracleSQL4659	= { FOLLOW_k_numeric_in_synpred254_OracleSQL4659_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_number_in_synpred258_OracleSQL4655  */
static	ANTLR3_BITWORD FOLLOW_r_number_in_synpred258_OracleSQL4655_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_number_in_synpred258_OracleSQL4655	= { FOLLOW_r_number_in_synpred258_OracleSQL4655_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_numeric_in_synpred258_OracleSQL4659  */
static	ANTLR3_BITWORD FOLLOW_k_numeric_in_synpred258_OracleSQL4659_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_numeric_in_synpred258_OracleSQL4659	= { FOLLOW_k_numeric_in_synpred258_OracleSQL4659_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_decimal_in_synpred258_OracleSQL4663  */
static	ANTLR3_BITWORD FOLLOW_r_decimal_in_synpred258_OracleSQL4663_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_decimal_in_synpred258_OracleSQL4663	= { FOLLOW_r_decimal_in_synpred258_OracleSQL4663_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_dec_in_synpred258_OracleSQL4667  */
static	ANTLR3_BITWORD FOLLOW_k_dec_in_synpred258_OracleSQL4667_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_dec_in_synpred258_OracleSQL4667	= { FOLLOW_k_dec_in_synpred258_OracleSQL4667_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred258_OracleSQL4673  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred258_OracleSQL4673_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred258_OracleSQL4673	= { FOLLOW_LPAREN_in_synpred258_OracleSQL4673_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred258_OracleSQL4675  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred258_OracleSQL4675_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000001) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred258_OracleSQL4675	= { FOLLOW_NUMBER_in_synpred258_OracleSQL4675_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_synpred258_OracleSQL4679  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_synpred258_OracleSQL4679_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_synpred258_OracleSQL4679	= { FOLLOW_COMMA_in_synpred258_OracleSQL4679_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred258_OracleSQL4681  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred258_OracleSQL4681_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred258_OracleSQL4681	= { FOLLOW_NUMBER_in_synpred258_OracleSQL4681_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred258_OracleSQL4686  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred258_OracleSQL4686_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred258_OracleSQL4686	= { FOLLOW_RPAREN_in_synpred258_OracleSQL4686_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_boolean_in_synpred264_OracleSQL4732  */
static	ANTLR3_BITWORD FOLLOW_k_boolean_in_synpred264_OracleSQL4732_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_boolean_in_synpred264_OracleSQL4732	= { FOLLOW_k_boolean_in_synpred264_OracleSQL4732_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_interval_in_synpred268_OracleSQL4742  */
static	ANTLR3_BITWORD FOLLOW_k_interval_in_synpred268_OracleSQL4742_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_interval_in_synpred268_OracleSQL4742	= { FOLLOW_k_interval_in_synpred268_OracleSQL4742_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_day_in_synpred268_OracleSQL4744  */
static	ANTLR3_BITWORD FOLLOW_k_day_in_synpred268_OracleSQL4744_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_day_in_synpred268_OracleSQL4744	= { FOLLOW_k_day_in_synpred268_OracleSQL4744_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred268_OracleSQL4748  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred268_OracleSQL4748_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred268_OracleSQL4748	= { FOLLOW_LPAREN_in_synpred268_OracleSQL4748_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred268_OracleSQL4750  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred268_OracleSQL4750_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred268_OracleSQL4750	= { FOLLOW_NUMBER_in_synpred268_OracleSQL4750_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred268_OracleSQL4752  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred268_OracleSQL4752_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred268_OracleSQL4752	= { FOLLOW_RPAREN_in_synpred268_OracleSQL4752_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_to_in_synpred268_OracleSQL4757  */
static	ANTLR3_BITWORD FOLLOW_r_to_in_synpred268_OracleSQL4757_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_to_in_synpred268_OracleSQL4757	= { FOLLOW_r_to_in_synpred268_OracleSQL4757_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_second_in_synpred268_OracleSQL4759  */
static	ANTLR3_BITWORD FOLLOW_k_second_in_synpred268_OracleSQL4759_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_second_in_synpred268_OracleSQL4759	= { FOLLOW_k_second_in_synpred268_OracleSQL4759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred268_OracleSQL4763  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred268_OracleSQL4763_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred268_OracleSQL4763	= { FOLLOW_LPAREN_in_synpred268_OracleSQL4763_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred268_OracleSQL4765  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred268_OracleSQL4765_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred268_OracleSQL4765	= { FOLLOW_NUMBER_in_synpred268_OracleSQL4765_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred268_OracleSQL4767  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred268_OracleSQL4767_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred268_OracleSQL4767	= { FOLLOW_RPAREN_in_synpred268_OracleSQL4767_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_interval_in_synpred270_OracleSQL4775  */
static	ANTLR3_BITWORD FOLLOW_k_interval_in_synpred270_OracleSQL4775_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_interval_in_synpred270_OracleSQL4775	= { FOLLOW_k_interval_in_synpred270_OracleSQL4775_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_year_in_synpred270_OracleSQL4777  */
static	ANTLR3_BITWORD FOLLOW_k_year_in_synpred270_OracleSQL4777_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_year_in_synpred270_OracleSQL4777	= { FOLLOW_k_year_in_synpred270_OracleSQL4777_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred270_OracleSQL4781  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred270_OracleSQL4781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred270_OracleSQL4781	= { FOLLOW_LPAREN_in_synpred270_OracleSQL4781_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred270_OracleSQL4783  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred270_OracleSQL4783_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred270_OracleSQL4783	= { FOLLOW_NUMBER_in_synpred270_OracleSQL4783_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred270_OracleSQL4785  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred270_OracleSQL4785_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred270_OracleSQL4785	= { FOLLOW_RPAREN_in_synpred270_OracleSQL4785_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_to_in_synpred270_OracleSQL4790  */
static	ANTLR3_BITWORD FOLLOW_r_to_in_synpred270_OracleSQL4790_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_to_in_synpred270_OracleSQL4790	= { FOLLOW_r_to_in_synpred270_OracleSQL4790_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_month_in_synpred270_OracleSQL4792  */
static	ANTLR3_BITWORD FOLLOW_k_month_in_synpred270_OracleSQL4792_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_month_in_synpred270_OracleSQL4792	= { FOLLOW_k_month_in_synpred270_OracleSQL4792_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_time_in_synpred275_OracleSQL4799  */
static	ANTLR3_BITWORD FOLLOW_k_time_in_synpred275_OracleSQL4799_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_time_in_synpred275_OracleSQL4799	= { FOLLOW_k_time_in_synpred275_OracleSQL4799_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_timestamp_in_synpred275_OracleSQL4803  */
static	ANTLR3_BITWORD FOLLOW_k_timestamp_in_synpred275_OracleSQL4803_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_timestamp_in_synpred275_OracleSQL4803	= { FOLLOW_k_timestamp_in_synpred275_OracleSQL4803_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred275_OracleSQL4809  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred275_OracleSQL4809_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred275_OracleSQL4809	= { FOLLOW_LPAREN_in_synpred275_OracleSQL4809_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred275_OracleSQL4811  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred275_OracleSQL4811_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred275_OracleSQL4811	= { FOLLOW_NUMBER_in_synpred275_OracleSQL4811_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred275_OracleSQL4813  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred275_OracleSQL4813_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred275_OracleSQL4813	= { FOLLOW_RPAREN_in_synpred275_OracleSQL4813_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_with_in_synpred275_OracleSQL4820  */
static	ANTLR3_BITWORD FOLLOW_r_with_in_synpred275_OracleSQL4820_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_with_in_synpred275_OracleSQL4820	= { FOLLOW_r_with_in_synpred275_OracleSQL4820_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_local_in_synpred275_OracleSQL4824  */
static	ANTLR3_BITWORD FOLLOW_k_local_in_synpred275_OracleSQL4824_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_local_in_synpred275_OracleSQL4824	= { FOLLOW_k_local_in_synpred275_OracleSQL4824_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_time_in_synpred275_OracleSQL4829  */
static	ANTLR3_BITWORD FOLLOW_k_time_in_synpred275_OracleSQL4829_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_time_in_synpred275_OracleSQL4829	= { FOLLOW_k_time_in_synpred275_OracleSQL4829_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_zone_in_synpred275_OracleSQL4831  */
static	ANTLR3_BITWORD FOLLOW_k_zone_in_synpred275_OracleSQL4831_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_zone_in_synpred275_OracleSQL4831	= { FOLLOW_k_zone_in_synpred275_OracleSQL4831_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_int_in_synpred277_OracleSQL4844  */
static	ANTLR3_BITWORD FOLLOW_k_int_in_synpred277_OracleSQL4844_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_int_in_synpred277_OracleSQL4844	= { FOLLOW_k_int_in_synpred277_OracleSQL4844_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_real_in_synpred281_OracleSQL4870  */
static	ANTLR3_BITWORD FOLLOW_k_real_in_synpred281_OracleSQL4870_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_real_in_synpred281_OracleSQL4870	= { FOLLOW_k_real_in_synpred281_OracleSQL4870_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_double_in_synpred282_OracleSQL4875  */
static	ANTLR3_BITWORD FOLLOW_k_double_in_synpred282_OracleSQL4875_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_double_in_synpred282_OracleSQL4875	= { FOLLOW_k_double_in_synpred282_OracleSQL4875_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_precision_in_synpred282_OracleSQL4877  */
static	ANTLR3_BITWORD FOLLOW_k_precision_in_synpred282_OracleSQL4877_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_precision_in_synpred282_OracleSQL4877	= { FOLLOW_k_precision_in_synpred282_OracleSQL4877_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_character_in_synpred304_OracleSQL5074  */
static	ANTLR3_BITWORD FOLLOW_k_character_in_synpred304_OracleSQL5074_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_character_in_synpred304_OracleSQL5074	= { FOLLOW_k_character_in_synpred304_OracleSQL5074_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_varying_in_synpred304_OracleSQL5078  */
static	ANTLR3_BITWORD FOLLOW_k_varying_in_synpred304_OracleSQL5078_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_varying_in_synpred304_OracleSQL5078	= { FOLLOW_k_varying_in_synpred304_OracleSQL5078_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred304_OracleSQL5085  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred304_OracleSQL5085_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred304_OracleSQL5085	= { FOLLOW_LPAREN_in_synpred304_OracleSQL5085_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred304_OracleSQL5087  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred304_OracleSQL5087_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred304_OracleSQL5087	= { FOLLOW_NUMBER_in_synpred304_OracleSQL5087_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred304_OracleSQL5089  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred304_OracleSQL5089_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred304_OracleSQL5089	= { FOLLOW_RPAREN_in_synpred304_OracleSQL5089_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nchar_in_synpred307_OracleSQL5097  */
static	ANTLR3_BITWORD FOLLOW_k_nchar_in_synpred307_OracleSQL5097_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nchar_in_synpred307_OracleSQL5097	= { FOLLOW_k_nchar_in_synpred307_OracleSQL5097_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_varying_in_synpred307_OracleSQL5105  */
static	ANTLR3_BITWORD FOLLOW_k_varying_in_synpred307_OracleSQL5105_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_varying_in_synpred307_OracleSQL5105	= { FOLLOW_k_varying_in_synpred307_OracleSQL5105_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred307_OracleSQL5112  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred307_OracleSQL5112_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred307_OracleSQL5112	= { FOLLOW_LPAREN_in_synpred307_OracleSQL5112_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred307_OracleSQL5114  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred307_OracleSQL5114_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred307_OracleSQL5114	= { FOLLOW_NUMBER_in_synpred307_OracleSQL5114_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred307_OracleSQL5116  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred307_OracleSQL5116_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred307_OracleSQL5116	= { FOLLOW_RPAREN_in_synpred307_OracleSQL5116_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nvarchar_in_synpred309_OracleSQL5124  */
static	ANTLR3_BITWORD FOLLOW_k_nvarchar_in_synpred309_OracleSQL5124_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nvarchar_in_synpred309_OracleSQL5124	= { FOLLOW_k_nvarchar_in_synpred309_OracleSQL5124_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred309_OracleSQL5129  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred309_OracleSQL5129_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred309_OracleSQL5129	= { FOLLOW_LPAREN_in_synpred309_OracleSQL5129_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred309_OracleSQL5131  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred309_OracleSQL5131_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred309_OracleSQL5131	= { FOLLOW_NUMBER_in_synpred309_OracleSQL5131_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred309_OracleSQL5133  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred309_OracleSQL5133_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred309_OracleSQL5133	= { FOLLOW_RPAREN_in_synpred309_OracleSQL5133_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nvarchar2_in_synpred311_OracleSQL5141  */
static	ANTLR3_BITWORD FOLLOW_k_nvarchar2_in_synpred311_OracleSQL5141_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nvarchar2_in_synpred311_OracleSQL5141	= { FOLLOW_k_nvarchar2_in_synpred311_OracleSQL5141_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred311_OracleSQL5145  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred311_OracleSQL5145_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred311_OracleSQL5145	= { FOLLOW_LPAREN_in_synpred311_OracleSQL5145_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred311_OracleSQL5147  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred311_OracleSQL5147_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred311_OracleSQL5147	= { FOLLOW_NUMBER_in_synpred311_OracleSQL5147_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred311_OracleSQL5149  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred311_OracleSQL5149_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred311_OracleSQL5149	= { FOLLOW_RPAREN_in_synpred311_OracleSQL5149_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_national_in_synpred315_OracleSQL5157  */
static	ANTLR3_BITWORD FOLLOW_k_national_in_synpred315_OracleSQL5157_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x8000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_national_in_synpred315_OracleSQL5157	= { FOLLOW_k_national_in_synpred315_OracleSQL5157_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_character_in_synpred315_OracleSQL5162  */
static	ANTLR3_BITWORD FOLLOW_k_character_in_synpred315_OracleSQL5162_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_character_in_synpred315_OracleSQL5162	= { FOLLOW_k_character_in_synpred315_OracleSQL5162_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_char_in_synpred315_OracleSQL5166  */
static	ANTLR3_BITWORD FOLLOW_r_char_in_synpred315_OracleSQL5166_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_char_in_synpred315_OracleSQL5166	= { FOLLOW_r_char_in_synpred315_OracleSQL5166_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_varying_in_synpred315_OracleSQL5172  */
static	ANTLR3_BITWORD FOLLOW_k_varying_in_synpred315_OracleSQL5172_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_varying_in_synpred315_OracleSQL5172	= { FOLLOW_k_varying_in_synpred315_OracleSQL5172_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred315_OracleSQL5179  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred315_OracleSQL5179_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred315_OracleSQL5179	= { FOLLOW_LPAREN_in_synpred315_OracleSQL5179_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_synpred315_OracleSQL5181  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_synpred315_OracleSQL5181_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_synpred315_OracleSQL5181	= { FOLLOW_NUMBER_in_synpred315_OracleSQL5181_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred315_OracleSQL5183  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred315_OracleSQL5183_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred315_OracleSQL5183	= { FOLLOW_RPAREN_in_synpred315_OracleSQL5183_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_mlslabel_in_synpred316_OracleSQL5191  */
static	ANTLR3_BITWORD FOLLOW_k_mlslabel_in_synpred316_OracleSQL5191_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_mlslabel_in_synpred316_OracleSQL5191	= { FOLLOW_k_mlslabel_in_synpred316_OracleSQL5191_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_pls_integer_in_synpred317_OracleSQL5196  */
static	ANTLR3_BITWORD FOLLOW_k_pls_integer_in_synpred317_OracleSQL5196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_pls_integer_in_synpred317_OracleSQL5196	= { FOLLOW_k_pls_integer_in_synpred317_OracleSQL5196_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_blob_in_synpred318_OracleSQL5201  */
static	ANTLR3_BITWORD FOLLOW_k_blob_in_synpred318_OracleSQL5201_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_blob_in_synpred318_OracleSQL5201	= { FOLLOW_k_blob_in_synpred318_OracleSQL5201_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_clob_in_synpred321_OracleSQL5206  */
static	ANTLR3_BITWORD FOLLOW_k_clob_in_synpred321_OracleSQL5206_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_clob_in_synpred321_OracleSQL5206	= { FOLLOW_k_clob_in_synpred321_OracleSQL5206_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_character_in_synpred321_OracleSQL5210  */
static	ANTLR3_BITWORD FOLLOW_k_character_in_synpred321_OracleSQL5210_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_k_character_in_synpred321_OracleSQL5210	= { FOLLOW_k_character_in_synpred321_OracleSQL5210_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_set_in_synpred321_OracleSQL5212  */
static	ANTLR3_BITWORD FOLLOW_r_set_in_synpred321_OracleSQL5212_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070000), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_set_in_synpred321_OracleSQL5212	= { FOLLOW_r_set_in_synpred321_OracleSQL5212_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_synpred321_OracleSQL5216  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_synpred321_OracleSQL5216_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_synpred321_OracleSQL5216	= { FOLLOW_identifier_in_synpred321_OracleSQL5216_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_synpred321_OracleSQL5221  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_synpred321_OracleSQL5221_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000008000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_synpred321_OracleSQL5221	= { FOLLOW_column_spec_in_synpred321_OracleSQL5221_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHARSET_ATTR_in_synpred321_OracleSQL5223  */
static	ANTLR3_BITWORD FOLLOW_CHARSET_ATTR_in_synpred321_OracleSQL5223_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHARSET_ATTR_in_synpred321_OracleSQL5223	= { FOLLOW_CHARSET_ATTR_in_synpred321_OracleSQL5223_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nclob_in_synpred322_OracleSQL5233  */
static	ANTLR3_BITWORD FOLLOW_k_nclob_in_synpred322_OracleSQL5233_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nclob_in_synpred322_OracleSQL5233	= { FOLLOW_k_nclob_in_synpred322_OracleSQL5233_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_bfile_in_synpred323_OracleSQL5238  */
static	ANTLR3_BITWORD FOLLOW_k_bfile_in_synpred323_OracleSQL5238_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_bfile_in_synpred323_OracleSQL5238	= { FOLLOW_k_bfile_in_synpred323_OracleSQL5238_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_synpred331_OracleSQL5340  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_synpred331_OracleSQL5340_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_synpred331_OracleSQL5340	= { FOLLOW_outer_join_sign_in_synpred331_OracleSQL5340_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_join_clause_in_synpred344_OracleSQL5714  */
static	ANTLR3_BITWORD FOLLOW_join_clause_in_synpred344_OracleSQL5714_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_join_clause_in_synpred344_OracleSQL5714	= { FOLLOW_join_clause_in_synpred344_OracleSQL5714_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_join_clause_in_synpred345_OracleSQL5723  */
static	ANTLR3_BITWORD FOLLOW_join_clause_in_synpred345_OracleSQL5723_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_join_clause_in_synpred345_OracleSQL5723	= { FOLLOW_join_clause_in_synpred345_OracleSQL5723_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_synpred346_OracleSQL5720  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_synpred346_OracleSQL5720_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_synpred346_OracleSQL5720	= { FOLLOW_COMMA_in_synpred346_OracleSQL5720_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_join_clause_in_synpred346_OracleSQL5723  */
static	ANTLR3_BITWORD FOLLOW_join_clause_in_synpred346_OracleSQL5723_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_join_clause_in_synpred346_OracleSQL5723	= { FOLLOW_join_clause_in_synpred346_OracleSQL5723_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_in_synpred346_OracleSQL5725  */
static	ANTLR3_BITWORD FOLLOW_table_reference_in_synpred346_OracleSQL5725_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_in_synpred346_OracleSQL5725	= { FOLLOW_table_reference_in_synpred346_OracleSQL5725_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_only_in_synpred347_OracleSQL5759  */
static	ANTLR3_BITWORD FOLLOW_k_only_in_synpred347_OracleSQL5759_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_only_in_synpred347_OracleSQL5759	= { FOLLOW_k_only_in_synpred347_OracleSQL5759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred347_OracleSQL5761  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred347_OracleSQL5761_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred347_OracleSQL5761	= { FOLLOW_LPAREN_in_synpred347_OracleSQL5761_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_table_expression_in_synpred347_OracleSQL5763  */
static	ANTLR3_BITWORD FOLLOW_query_table_expression_in_synpred347_OracleSQL5763_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_query_table_expression_in_synpred347_OracleSQL5763	= { FOLLOW_query_table_expression_in_synpred347_OracleSQL5763_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred347_OracleSQL5765  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred347_OracleSQL5765_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred347_OracleSQL5765	= { FOLLOW_RPAREN_in_synpred347_OracleSQL5765_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_flashback_query_clause_in_synpred348_OracleSQL5776  */
static	ANTLR3_BITWORD FOLLOW_flashback_query_clause_in_synpred348_OracleSQL5776_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_flashback_query_clause_in_synpred348_OracleSQL5776	= { FOLLOW_flashback_query_clause_in_synpred348_OracleSQL5776_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_t_alias_in_synpred349_OracleSQL5779  */
static	ANTLR3_BITWORD FOLLOW_t_alias_in_synpred349_OracleSQL5779_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_t_alias_in_synpred349_OracleSQL5779	= { FOLLOW_t_alias_in_synpred349_OracleSQL5779_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_partition_extension_clause_in_synpred350_OracleSQL5798  */
static	ANTLR3_BITWORD FOLLOW_partition_extension_clause_in_synpred350_OracleSQL5798_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_partition_extension_clause_in_synpred350_OracleSQL5798	= { FOLLOW_partition_extension_clause_in_synpred350_OracleSQL5798_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sample_clause_in_synpred352_OracleSQL5808  */
static	ANTLR3_BITWORD FOLLOW_sample_clause_in_synpred352_OracleSQL5808_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sample_clause_in_synpred352_OracleSQL5808	= { FOLLOW_sample_clause_in_synpred352_OracleSQL5808_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_synpred353_OracleSQL5812  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_synpred353_OracleSQL5812_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_synpred353_OracleSQL5812	= { FOLLOW_pivot_clause_in_synpred353_OracleSQL5812_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_synpred354_OracleSQL5814  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_synpred354_OracleSQL5814_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_synpred354_OracleSQL5814	= { FOLLOW_unpivot_clause_in_synpred354_OracleSQL5814_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_restricrion_clause_in_synpred356_OracleSQL5823  */
static	ANTLR3_BITWORD FOLLOW_subquery_restricrion_clause_in_synpred356_OracleSQL5823_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_restricrion_clause_in_synpred356_OracleSQL5823	= { FOLLOW_subquery_restricrion_clause_in_synpred356_OracleSQL5823_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_synpred357_OracleSQL5827  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_synpred357_OracleSQL5827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_synpred357_OracleSQL5827	= { FOLLOW_pivot_clause_in_synpred357_OracleSQL5827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_synpred358_OracleSQL5829  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_synpred358_OracleSQL5829_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_synpred358_OracleSQL5829	= { FOLLOW_unpivot_clause_in_synpred358_OracleSQL5829_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_synpred359_OracleSQL5821  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_synpred359_OracleSQL5821_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_synpred359_OracleSQL5821	= { FOLLOW_subquery_in_synpred359_OracleSQL5821_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_restricrion_clause_in_synpred359_OracleSQL5823  */
static	ANTLR3_BITWORD FOLLOW_subquery_restricrion_clause_in_synpred359_OracleSQL5823_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_restricrion_clause_in_synpred359_OracleSQL5823	= { FOLLOW_subquery_restricrion_clause_in_synpred359_OracleSQL5823_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_synpred359_OracleSQL5827  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_synpred359_OracleSQL5827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_synpred359_OracleSQL5827	= { FOLLOW_pivot_clause_in_synpred359_OracleSQL5827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_synpred359_OracleSQL5829  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_synpred359_OracleSQL5829_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_synpred359_OracleSQL5829	= { FOLLOW_unpivot_clause_in_synpred359_OracleSQL5829_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred363_OracleSQL5836  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred363_OracleSQL5836_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred363_OracleSQL5836	= { FOLLOW_LPAREN_in_synpred363_OracleSQL5836_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_synpred363_OracleSQL5838  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_synpred363_OracleSQL5838_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_synpred363_OracleSQL5838	= { FOLLOW_subquery_in_synpred363_OracleSQL5838_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_restricrion_clause_in_synpred363_OracleSQL5840  */
static	ANTLR3_BITWORD FOLLOW_subquery_restricrion_clause_in_synpred363_OracleSQL5840_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000080) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_restricrion_clause_in_synpred363_OracleSQL5840	= { FOLLOW_subquery_restricrion_clause_in_synpred363_OracleSQL5840_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_synpred363_OracleSQL5844  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_synpred363_OracleSQL5844_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_synpred363_OracleSQL5844	= { FOLLOW_pivot_clause_in_synpred363_OracleSQL5844_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_synpred363_OracleSQL5846  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_synpred363_OracleSQL5846_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_synpred363_OracleSQL5846	= { FOLLOW_unpivot_clause_in_synpred363_OracleSQL5846_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred363_OracleSQL5850  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred363_OracleSQL5850_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred363_OracleSQL5850	= { FOLLOW_RPAREN_in_synpred363_OracleSQL5850_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pivot_clause_in_synpred364_OracleSQL5859  */
static	ANTLR3_BITWORD FOLLOW_pivot_clause_in_synpred364_OracleSQL5859_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_pivot_clause_in_synpred364_OracleSQL5859	= { FOLLOW_pivot_clause_in_synpred364_OracleSQL5859_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unpivot_clause_in_synpred365_OracleSQL5861  */
static	ANTLR3_BITWORD FOLLOW_unpivot_clause_in_synpred365_OracleSQL5861_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_unpivot_clause_in_synpred365_OracleSQL5861	= { FOLLOW_unpivot_clause_in_synpred365_OracleSQL5861_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_synpred367_OracleSQL5888  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_synpred367_OracleSQL5888_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_synpred367_OracleSQL5888	= { FOLLOW_sql_expression_in_synpred367_OracleSQL5888_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_synpred368_OracleSQL5898  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_synpred368_OracleSQL5898_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_synpred368_OracleSQL5898	= { FOLLOW_sql_expression_in_synpred368_OracleSQL5898_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_seed_in_synpred373_OracleSQL5952  */
static	ANTLR3_BITWORD FOLLOW_k_seed_in_synpred373_OracleSQL5952_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_seed_in_synpred373_OracleSQL5952	= { FOLLOW_k_seed_in_synpred373_OracleSQL5952_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred373_OracleSQL5954  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred373_OracleSQL5954_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000070004), ANTLR3_UINT64_LIT(0x0004002000000000), ANTLR3_UINT64_LIT(0xBAD3962010040050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred373_OracleSQL5954	= { FOLLOW_LPAREN_in_synpred373_OracleSQL5954_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_seed_value_in_synpred373_OracleSQL5956  */
static	ANTLR3_BITWORD FOLLOW_seed_value_in_synpred373_OracleSQL5956_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_seed_value_in_synpred373_OracleSQL5956	= { FOLLOW_seed_value_in_synpred373_OracleSQL5956_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred373_OracleSQL5958  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred373_OracleSQL5958_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred373_OracleSQL5958	= { FOLLOW_RPAREN_in_synpred373_OracleSQL5958_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_constraint_in_synpred380_OracleSQL6070  */
static	ANTLR3_BITWORD FOLLOW_k_constraint_in_synpred380_OracleSQL6070_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_constraint_in_synpred380_OracleSQL6070	= { FOLLOW_k_constraint_in_synpred380_OracleSQL6070_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constraint_in_synpred380_OracleSQL6072  */
static	ANTLR3_BITWORD FOLLOW_constraint_in_synpred380_OracleSQL6072_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_constraint_in_synpred380_OracleSQL6072	= { FOLLOW_constraint_in_synpred380_OracleSQL6072_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_synpred382_OracleSQL6102  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_synpred382_OracleSQL6102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_synpred382_OracleSQL6102	= { FOLLOW_outer_join_sign_in_synpred382_OracleSQL6102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred383_OracleSQL6142  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred383_OracleSQL6142_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred383_OracleSQL6142	= { FOLLOW_LPAREN_in_synpred383_OracleSQL6142_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_join_clause_in_synpred383_OracleSQL6144  */
static	ANTLR3_BITWORD FOLLOW_join_clause_in_synpred383_OracleSQL6144_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_join_clause_in_synpred383_OracleSQL6144	= { FOLLOW_join_clause_in_synpred383_OracleSQL6144_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred383_OracleSQL6146  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred383_OracleSQL6146_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred383_OracleSQL6146	= { FOLLOW_RPAREN_in_synpred383_OracleSQL6146_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_inner_cross_join_clause_in_synpred384_OracleSQL6152  */
static	ANTLR3_BITWORD FOLLOW_inner_cross_join_clause_in_synpred384_OracleSQL6152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_inner_cross_join_clause_in_synpred384_OracleSQL6152	= { FOLLOW_inner_cross_join_clause_in_synpred384_OracleSQL6152_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_clause_in_synpred385_OracleSQL6154  */
static	ANTLR3_BITWORD FOLLOW_outer_join_clause_in_synpred385_OracleSQL6154_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_clause_in_synpred385_OracleSQL6154	= { FOLLOW_outer_join_clause_in_synpred385_OracleSQL6154_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred386_OracleSQL6142  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred386_OracleSQL6142_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred386_OracleSQL6142	= { FOLLOW_LPAREN_in_synpred386_OracleSQL6142_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_join_clause_in_synpred386_OracleSQL6144  */
static	ANTLR3_BITWORD FOLLOW_join_clause_in_synpred386_OracleSQL6144_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_join_clause_in_synpred386_OracleSQL6144	= { FOLLOW_join_clause_in_synpred386_OracleSQL6144_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred386_OracleSQL6146  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred386_OracleSQL6146_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0508000000000000), ANTLR3_UINT64_LIT(0x0000000000004040) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred386_OracleSQL6146	= { FOLLOW_RPAREN_in_synpred386_OracleSQL6146_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_in_synpred386_OracleSQL6148  */
static	ANTLR3_BITWORD FOLLOW_table_reference_in_synpred386_OracleSQL6148_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0508000000000000), ANTLR3_UINT64_LIT(0x0000000000004040) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_in_synpred386_OracleSQL6148	= { FOLLOW_table_reference_in_synpred386_OracleSQL6148_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_inner_cross_join_clause_in_synpred386_OracleSQL6152  */
static	ANTLR3_BITWORD FOLLOW_inner_cross_join_clause_in_synpred386_OracleSQL6152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0508000000000000), ANTLR3_UINT64_LIT(0x0000000000004040) };
static  ANTLR3_BITSET_LIST FOLLOW_inner_cross_join_clause_in_synpred386_OracleSQL6152	= { FOLLOW_inner_cross_join_clause_in_synpred386_OracleSQL6152_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_clause_in_synpred386_OracleSQL6154  */
static	ANTLR3_BITWORD FOLLOW_outer_join_clause_in_synpred386_OracleSQL6154_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0508000000000000), ANTLR3_UINT64_LIT(0x0000000000004040) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_clause_in_synpred386_OracleSQL6154	= { FOLLOW_outer_join_clause_in_synpred386_OracleSQL6154_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_joining_clause_in_synpred388_OracleSQL6187  */
static	ANTLR3_BITWORD FOLLOW_joining_clause_in_synpred388_OracleSQL6187_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_joining_clause_in_synpred388_OracleSQL6187	= { FOLLOW_joining_clause_in_synpred388_OracleSQL6187_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_inner_in_synpred389_OracleSQL6180  */
static	ANTLR3_BITWORD FOLLOW_k_inner_in_synpred389_OracleSQL6180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_inner_in_synpred389_OracleSQL6180	= { FOLLOW_k_inner_in_synpred389_OracleSQL6180_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_join_in_synpred389_OracleSQL6183  */
static	ANTLR3_BITWORD FOLLOW_k_join_in_synpred389_OracleSQL6183_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0000000000400000), ANTLR3_UINT64_LIT(0xBAD3962000080050), ANTLR3_UINT64_LIT(0x00000000096994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_k_join_in_synpred389_OracleSQL6183	= { FOLLOW_k_join_in_synpred389_OracleSQL6183_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_table_reference_in_synpred389_OracleSQL6185  */
static	ANTLR3_BITWORD FOLLOW_table_reference_in_synpred389_OracleSQL6185_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_table_reference_in_synpred389_OracleSQL6185	= { FOLLOW_table_reference_in_synpred389_OracleSQL6185_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_joining_clause_in_synpred389_OracleSQL6187  */
static	ANTLR3_BITWORD FOLLOW_joining_clause_in_synpred389_OracleSQL6187_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x4000000000010000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x000000000B4994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_joining_clause_in_synpred389_OracleSQL6187	= { FOLLOW_joining_clause_in_synpred389_OracleSQL6187_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_cross_in_synpred390_OracleSQL6197  */
static	ANTLR3_BITWORD FOLLOW_k_cross_in_synpred390_OracleSQL6197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_cross_in_synpred390_OracleSQL6197	= { FOLLOW_k_cross_in_synpred390_OracleSQL6197_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_query_partition_clause_in_synpred395_OracleSQL6269  */
static	ANTLR3_BITWORD FOLLOW_query_partition_clause_in_synpred395_OracleSQL6269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_query_partition_clause_in_synpred395_OracleSQL6269	= { FOLLOW_query_partition_clause_in_synpred395_OracleSQL6269_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_joining_clause_in_synpred396_OracleSQL6274  */
static	ANTLR3_BITWORD FOLLOW_joining_clause_in_synpred396_OracleSQL6274_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_joining_clause_in_synpred396_OracleSQL6274	= { FOLLOW_joining_clause_in_synpred396_OracleSQL6274_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nocycle_in_synpred410_OracleSQL6737  */
static	ANTLR3_BITWORD FOLLOW_k_nocycle_in_synpred410_OracleSQL6737_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nocycle_in_synpred410_OracleSQL6737	= { FOLLOW_k_nocycle_in_synpred410_OracleSQL6737_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_start_in_synpred411_OracleSQL6748  */
static	ANTLR3_BITWORD FOLLOW_r_start_in_synpred411_OracleSQL6748_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_start_in_synpred411_OracleSQL6748	= { FOLLOW_r_start_in_synpred411_OracleSQL6748_bits, 4	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_with_in_synpred411_OracleSQL6750  */
static	ANTLR3_BITWORD FOLLOW_r_with_in_synpred411_OracleSQL6750_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_with_in_synpred411_OracleSQL6750	= { FOLLOW_r_with_in_synpred411_OracleSQL6750_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_synpred411_OracleSQL6754  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_synpred411_OracleSQL6754_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_synpred411_OracleSQL6754	= { FOLLOW_sql_condition_in_synpred411_OracleSQL6754_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nocycle_in_synpred413_OracleSQL6807  */
static	ANTLR3_BITWORD FOLLOW_k_nocycle_in_synpred413_OracleSQL6807_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nocycle_in_synpred413_OracleSQL6807	= { FOLLOW_k_nocycle_in_synpred413_OracleSQL6807_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_having_in_synpred414_OracleSQL6855  */
static	ANTLR3_BITWORD FOLLOW_r_having_in_synpred414_OracleSQL6855_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_having_in_synpred414_OracleSQL6855	= { FOLLOW_r_having_in_synpred414_OracleSQL6855_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_group_in_synpred415_OracleSQL6873  */
static	ANTLR3_BITWORD FOLLOW_r_group_in_synpred415_OracleSQL6873_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_group_in_synpred415_OracleSQL6873	= { FOLLOW_r_group_in_synpred415_OracleSQL6873_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_by_in_synpred415_OracleSQL6877  */
static	ANTLR3_BITWORD FOLLOW_r_by_in_synpred415_OracleSQL6877_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_by_in_synpred415_OracleSQL6877	= { FOLLOW_r_by_in_synpred415_OracleSQL6877_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_exprs_in_synpred415_OracleSQL6881  */
static	ANTLR3_BITWORD FOLLOW_group_by_exprs_in_synpred415_OracleSQL6881_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_exprs_in_synpred415_OracleSQL6881	= { FOLLOW_group_by_exprs_in_synpred415_OracleSQL6881_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_group_in_synpred416_OracleSQL6894  */
static	ANTLR3_BITWORD FOLLOW_r_group_in_synpred416_OracleSQL6894_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_group_in_synpred416_OracleSQL6894	= { FOLLOW_r_group_in_synpred416_OracleSQL6894_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_having_in_synpred417_OracleSQL6917  */
static	ANTLR3_BITWORD FOLLOW_r_having_in_synpred417_OracleSQL6917_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_having_in_synpred417_OracleSQL6917	= { FOLLOW_r_having_in_synpred417_OracleSQL6917_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_synpred417_OracleSQL6921  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_synpred417_OracleSQL6921_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_synpred417_OracleSQL6921	= { FOLLOW_sql_condition_in_synpred417_OracleSQL6921_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_synpred418_OracleSQL6986  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_synpred418_OracleSQL6986_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_synpred418_OracleSQL6986	= { FOLLOW_COMMA_in_synpred418_OracleSQL6986_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_group_by_expr_in_synpred418_OracleSQL6988  */
static	ANTLR3_BITWORD FOLLOW_group_by_expr_in_synpred418_OracleSQL6988_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_group_by_expr_in_synpred418_OracleSQL6988	= { FOLLOW_group_by_expr_in_synpred418_OracleSQL6988_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_rollup_cube_clause_in_synpred419_OracleSQL7001  */
static	ANTLR3_BITWORD FOLLOW_rollup_cube_clause_in_synpred419_OracleSQL7001_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_rollup_cube_clause_in_synpred419_OracleSQL7001	= { FOLLOW_rollup_cube_clause_in_synpred419_OracleSQL7001_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_sets_clause_in_synpred420_OracleSQL7006  */
static	ANTLR3_BITWORD FOLLOW_grouping_sets_clause_in_synpred420_OracleSQL7006_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_sets_clause_in_synpred420_OracleSQL7006	= { FOLLOW_grouping_sets_clause_in_synpred420_OracleSQL7006_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_rollup_cube_clause_in_synpred423_OracleSQL7082  */
static	ANTLR3_BITWORD FOLLOW_rollup_cube_clause_in_synpred423_OracleSQL7082_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_rollup_cube_clause_in_synpred423_OracleSQL7082	= { FOLLOW_rollup_cube_clause_in_synpred423_OracleSQL7082_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_or_in_synpred424_OracleSQL7110  */
static	ANTLR3_BITWORD FOLLOW_r_or_in_synpred424_OracleSQL7110_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_or_in_synpred424_OracleSQL7110	= { FOLLOW_r_or_in_synpred424_OracleSQL7110_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_and_in_synpred424_OracleSQL7112  */
static	ANTLR3_BITWORD FOLLOW_condition_and_in_synpred424_OracleSQL7112_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_and_in_synpred424_OracleSQL7112	= { FOLLOW_condition_and_in_synpred424_OracleSQL7112_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_and_in_synpred425_OracleSQL7147  */
static	ANTLR3_BITWORD FOLLOW_r_and_in_synpred425_OracleSQL7147_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_r_and_in_synpred425_OracleSQL7147	= { FOLLOW_r_and_in_synpred425_OracleSQL7147_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_not_in_synpred425_OracleSQL7149  */
static	ANTLR3_BITWORD FOLLOW_condition_not_in_synpred425_OracleSQL7149_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_not_in_synpred425_OracleSQL7149	= { FOLLOW_condition_not_in_synpred425_OracleSQL7149_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_exists_in_synpred427_OracleSQL7208  */
static	ANTLR3_BITWORD FOLLOW_r_exists_in_synpred427_OracleSQL7208_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_exists_in_synpred427_OracleSQL7208	= { FOLLOW_r_exists_in_synpred427_OracleSQL7208_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred428_OracleSQL7220  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred428_OracleSQL7220_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4080000000870264), ANTLR3_UINT64_LIT(0x1004802000060100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred428_OracleSQL7220	= { FOLLOW_LPAREN_in_synpred428_OracleSQL7220_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_condition_in_synpred428_OracleSQL7222  */
static	ANTLR3_BITWORD FOLLOW_sql_condition_in_synpred428_OracleSQL7222_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_condition_in_synpred428_OracleSQL7222	= { FOLLOW_sql_condition_in_synpred428_OracleSQL7222_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_in_synpred429_OracleSQL7232  */
static	ANTLR3_BITWORD FOLLOW_condition_is_in_synpred429_OracleSQL7232_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_in_synpred429_OracleSQL7232	= { FOLLOW_condition_is_in_synpred429_OracleSQL7232_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_comparison_in_synpred430_OracleSQL7240  */
static	ANTLR3_BITWORD FOLLOW_condition_comparison_in_synpred430_OracleSQL7240_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_comparison_in_synpred430_OracleSQL7240	= { FOLLOW_condition_comparison_in_synpred430_OracleSQL7240_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_group_comparison_in_synpred431_OracleSQL7245  */
static	ANTLR3_BITWORD FOLLOW_condition_group_comparison_in_synpred431_OracleSQL7245_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_group_comparison_in_synpred431_OracleSQL7245	= { FOLLOW_condition_group_comparison_in_synpred431_OracleSQL7245_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_in_in_synpred432_OracleSQL7250  */
static	ANTLR3_BITWORD FOLLOW_condition_in_in_synpred432_OracleSQL7250_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_in_in_synpred432_OracleSQL7250	= { FOLLOW_condition_in_in_synpred432_OracleSQL7250_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_a_set_in_synpred433_OracleSQL7255  */
static	ANTLR3_BITWORD FOLLOW_condition_is_a_set_in_synpred433_OracleSQL7255_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_a_set_in_synpred433_OracleSQL7255	= { FOLLOW_condition_is_a_set_in_synpred433_OracleSQL7255_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_any_in_synpred434_OracleSQL7260  */
static	ANTLR3_BITWORD FOLLOW_condition_is_any_in_synpred434_OracleSQL7260_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_any_in_synpred434_OracleSQL7260	= { FOLLOW_condition_is_any_in_synpred434_OracleSQL7260_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_empty_in_synpred435_OracleSQL7265  */
static	ANTLR3_BITWORD FOLLOW_condition_is_empty_in_synpred435_OracleSQL7265_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_empty_in_synpred435_OracleSQL7265	= { FOLLOW_condition_is_empty_in_synpred435_OracleSQL7265_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_of_type_in_synpred436_OracleSQL7270  */
static	ANTLR3_BITWORD FOLLOW_condition_is_of_type_in_synpred436_OracleSQL7270_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_of_type_in_synpred436_OracleSQL7270	= { FOLLOW_condition_is_of_type_in_synpred436_OracleSQL7270_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_is_present_in_synpred437_OracleSQL7275  */
static	ANTLR3_BITWORD FOLLOW_condition_is_present_in_synpred437_OracleSQL7275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_is_present_in_synpred437_OracleSQL7275	= { FOLLOW_condition_is_present_in_synpred437_OracleSQL7275_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_like_in_synpred438_OracleSQL7280  */
static	ANTLR3_BITWORD FOLLOW_condition_like_in_synpred438_OracleSQL7280_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_like_in_synpred438_OracleSQL7280	= { FOLLOW_condition_like_in_synpred438_OracleSQL7280_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_memeber_in_synpred439_OracleSQL7285  */
static	ANTLR3_BITWORD FOLLOW_condition_memeber_in_synpred439_OracleSQL7285_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_memeber_in_synpred439_OracleSQL7285	= { FOLLOW_condition_memeber_in_synpred439_OracleSQL7285_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_between_in_synpred440_OracleSQL7290  */
static	ANTLR3_BITWORD FOLLOW_condition_between_in_synpred440_OracleSQL7290_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_between_in_synpred440_OracleSQL7290	= { FOLLOW_condition_between_in_synpred440_OracleSQL7290_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_regexp_like_in_synpred441_OracleSQL7295  */
static	ANTLR3_BITWORD FOLLOW_condition_regexp_like_in_synpred441_OracleSQL7295_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_regexp_like_in_synpred441_OracleSQL7295	= { FOLLOW_condition_regexp_like_in_synpred441_OracleSQL7295_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_submultiset_in_synpred442_OracleSQL7300  */
static	ANTLR3_BITWORD FOLLOW_condition_submultiset_in_synpred442_OracleSQL7300_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_submultiset_in_synpred442_OracleSQL7300	= { FOLLOW_condition_submultiset_in_synpred442_OracleSQL7300_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_equals_path_in_synpred443_OracleSQL7305  */
static	ANTLR3_BITWORD FOLLOW_condition_equals_path_in_synpred443_OracleSQL7305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_equals_path_in_synpred443_OracleSQL7305	= { FOLLOW_condition_equals_path_in_synpred443_OracleSQL7305_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_condition_under_path_in_synpred444_OracleSQL7310  */
static	ANTLR3_BITWORD FOLLOW_condition_under_path_in_synpred444_OracleSQL7310_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_condition_under_path_in_synpred444_OracleSQL7310	= { FOLLOW_condition_under_path_in_synpred444_OracleSQL7310_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_column_spec_in_synpred449_OracleSQL7338  */
static	ANTLR3_BITWORD FOLLOW_column_spec_in_synpred449_OracleSQL7338_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_column_spec_in_synpred449_OracleSQL7338	= { FOLLOW_column_spec_in_synpred449_OracleSQL7338_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_synpred449_OracleSQL7340  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_synpred449_OracleSQL7340_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_synpred449_OracleSQL7340	= { FOLLOW_outer_join_sign_in_synpred449_OracleSQL7340_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_is_in_synpred449_OracleSQL7343  */
static	ANTLR3_BITWORD FOLLOW_r_is_in_synpred449_OracleSQL7343_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004800000000000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_r_is_in_synpred449_OracleSQL7343	= { FOLLOW_r_is_in_synpred449_OracleSQL7343_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_not_in_synpred449_OracleSQL7347  */
static	ANTLR3_BITWORD FOLLOW_r_not_in_synpred449_OracleSQL7347_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004000000000000), ANTLR3_UINT64_LIT(0x0040000000000000), ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_r_not_in_synpred449_OracleSQL7347	= { FOLLOW_r_not_in_synpred449_OracleSQL7347_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_nan_in_synpred449_OracleSQL7354  */
static	ANTLR3_BITWORD FOLLOW_k_nan_in_synpred449_OracleSQL7354_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_nan_in_synpred449_OracleSQL7354	= { FOLLOW_k_nan_in_synpred449_OracleSQL7354_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_infinite_in_synpred449_OracleSQL7358  */
static	ANTLR3_BITWORD FOLLOW_k_infinite_in_synpred449_OracleSQL7358_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_k_infinite_in_synpred449_OracleSQL7358	= { FOLLOW_k_infinite_in_synpred449_OracleSQL7358_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_null_in_synpred449_OracleSQL7362  */
static	ANTLR3_BITWORD FOLLOW_r_null_in_synpred449_OracleSQL7362_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_null_in_synpred449_OracleSQL7362	= { FOLLOW_r_null_in_synpred449_OracleSQL7362_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_synpred455_OracleSQL7446  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_synpred455_OracleSQL7446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_synpred455_OracleSQL7446	= { FOLLOW_outer_join_sign_in_synpred455_OracleSQL7446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred456_OracleSQL7421  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred456_OracleSQL7421_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred456_OracleSQL7421	= { FOLLOW_LPAREN_in_synpred456_OracleSQL7421_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_synpred456_OracleSQL7423  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_synpred456_OracleSQL7423_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_synpred456_OracleSQL7423	= { FOLLOW_sql_expressions_in_synpred456_OracleSQL7423_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred456_OracleSQL7425  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred456_OracleSQL7425_bits[]	= { ANTLR3_UINT64_LIT(0xA000000000000000), ANTLR3_UINT64_LIT(0x0000020000100000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000030000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred456_OracleSQL7425	= { FOLLOW_RPAREN_in_synpred456_OracleSQL7425_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_synpred456_OracleSQL7429  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_synpred456_OracleSQL7429_bits[]	= { ANTLR3_UINT64_LIT(0xA000000000000000), ANTLR3_UINT64_LIT(0x0000020000100000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000030000000) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_synpred456_OracleSQL7429	= { FOLLOW_outer_join_sign_in_synpred456_OracleSQL7429_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_synpred456_OracleSQL7434  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_synpred456_OracleSQL7434_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_synpred456_OracleSQL7434	= { FOLLOW_EQ_in_synpred456_OracleSQL7434_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_not_equal_in_synpred456_OracleSQL7438  */
static	ANTLR3_BITWORD FOLLOW_not_equal_in_synpred456_OracleSQL7438_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_not_equal_in_synpred456_OracleSQL7438	= { FOLLOW_not_equal_in_synpred456_OracleSQL7438_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_subquery_in_synpred456_OracleSQL7442  */
static	ANTLR3_BITWORD FOLLOW_subquery_in_synpred456_OracleSQL7442_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_subquery_in_synpred456_OracleSQL7442	= { FOLLOW_subquery_in_synpred456_OracleSQL7442_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_synpred456_OracleSQL7446  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_synpred456_OracleSQL7446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_synpred456_OracleSQL7446	= { FOLLOW_outer_join_sign_in_synpred456_OracleSQL7446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_prior_in_synpred457_OracleSQL7501  */
static	ANTLR3_BITWORD FOLLOW_r_prior_in_synpred457_OracleSQL7501_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_prior_in_synpred457_OracleSQL7501	= { FOLLOW_r_prior_in_synpred457_OracleSQL7501_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_prior_in_synpred464_OracleSQL7541  */
static	ANTLR3_BITWORD FOLLOW_r_prior_in_synpred464_OracleSQL7541_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_r_prior_in_synpred464_OracleSQL7541	= { FOLLOW_r_prior_in_synpred464_OracleSQL7541_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expression_in_synpred465_OracleSQL7548  */
static	ANTLR3_BITWORD FOLLOW_sql_expression_in_synpred465_OracleSQL7548_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expression_in_synpred465_OracleSQL7548	= { FOLLOW_sql_expression_in_synpred465_OracleSQL7548_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_outer_join_sign_in_synpred466_OracleSQL7562  */
static	ANTLR3_BITWORD FOLLOW_outer_join_sign_in_synpred466_OracleSQL7562_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_outer_join_sign_in_synpred466_OracleSQL7562	= { FOLLOW_outer_join_sign_in_synpred466_OracleSQL7562_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_expression_list_in_synpred470_OracleSQL7668  */
static	ANTLR3_BITWORD FOLLOW_grouping_expression_list_in_synpred470_OracleSQL7668_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_expression_list_in_synpred470_OracleSQL7668	= { FOLLOW_grouping_expression_list_in_synpred470_OracleSQL7668_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred471_OracleSQL7634  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred471_OracleSQL7634_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FE010840450), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred471_OracleSQL7634	= { FOLLOW_LPAREN_in_synpred471_OracleSQL7634_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_synpred471_OracleSQL7636  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_synpred471_OracleSQL7636_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_synpred471_OracleSQL7636	= { FOLLOW_sql_expressions_in_synpred471_OracleSQL7636_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred471_OracleSQL7638  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred471_OracleSQL7638_bits[]	= { ANTLR3_UINT64_LIT(0xA000000000000000), ANTLR3_UINT64_LIT(0x0000020000100000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000030000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred471_OracleSQL7638	= { FOLLOW_RPAREN_in_synpred471_OracleSQL7638_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQ_in_synpred471_OracleSQL7642  */
static	ANTLR3_BITWORD FOLLOW_EQ_in_synpred471_OracleSQL7642_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4090000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094D94B4) };
static  ANTLR3_BITSET_LIST FOLLOW_EQ_in_synpred471_OracleSQL7642	= { FOLLOW_EQ_in_synpred471_OracleSQL7642_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_not_equal_in_synpred471_OracleSQL7646  */
static	ANTLR3_BITWORD FOLLOW_not_equal_in_synpred471_OracleSQL7646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x4090000000010000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0xBAD3962000000050), ANTLR3_UINT64_LIT(0x00000000094D94B4) };
static  ANTLR3_BITSET_LIST FOLLOW_not_equal_in_synpred471_OracleSQL7646	= { FOLLOW_not_equal_in_synpred471_OracleSQL7646_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_any_in_synpred471_OracleSQL7652  */
static	ANTLR3_BITWORD FOLLOW_r_any_in_synpred471_OracleSQL7652_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_any_in_synpred471_OracleSQL7652	= { FOLLOW_r_any_in_synpred471_OracleSQL7652_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_k_some_in_synpred471_OracleSQL7656  */
static	ANTLR3_BITWORD FOLLOW_k_some_in_synpred471_OracleSQL7656_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_k_some_in_synpred471_OracleSQL7656	= { FOLLOW_k_some_in_synpred471_OracleSQL7656_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_r_all_in_synpred471_OracleSQL7660  */
static	ANTLR3_BITWORD FOLLOW_r_all_in_synpred471_OracleSQL7660_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_r_all_in_synpred471_OracleSQL7660	= { FOLLOW_r_all_in_synpred471_OracleSQL7660_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_synpred471_OracleSQL7664  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_synpred471_OracleSQL7664_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000), ANTLR3_UINT64_LIT(0x4000000000870264), ANTLR3_UINT64_LIT(0x1004002000040100), ANTLR3_UINT64_LIT(0xBAD39FF010840550), ANTLR3_UINT64_LIT(0x00000000094994B4) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_synpred471_OracleSQL7664	= { FOLLOW_LPAREN_in_synpred471_OracleSQL7664_bits, 5	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_expression_list_in_synpred471_OracleSQL7668  */
static	ANTLR3_BITWORD FOLLOW_grouping_expression_list_in_synpred471_OracleSQL7668_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_grouping_expression_list_in_synpred471_OracleSQL7668	= { FOLLOW_grouping_expression_list_in_synpred471_OracleSQL7668_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_select_statement_in_synpred471_OracleSQL7672  */
static	ANTLR3_BITWORD FOLLOW_select_statement_in_synpred471_OracleSQL7672_bits[]	= { ANTLR3_UINT64_LIT(0x4000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_select_statement_in_synpred471_OracleSQL7672	= { FOLLOW_select_statement_in_synpred471_OracleSQL7672_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_synpred471_OracleSQL7676  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_synpred471_OracleSQL7676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_synpred471_OracleSQL7676	= { FOLLOW_RPAREN_in_synpred471_OracleSQL7676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sql_expressions_in_synpred479_OracleSQL7727  */
static	ANTLR3_BITWORD FOLLOW_sql_expressions_in_synpred479_OracleSQL7727_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sql_expressions_in_synpred479_OracleSQL7727	= { FOLLOW_sql_expressions_in_synpred479_OracleSQL7727_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_grouping_expression_list_in_synpred481_OracleSQL7765  */
static	ANTLR3_BITWORD FOLLOW_grouping_expression_list_in_synpred481_OracleSQL7765_bits[]	= { ANTLR3_UINT64_LIT(0x000000000000