# FindTeradata.cmake

SET(TERADATA_FOUND "NO")

MESSAGE(STATUS "Looking for Teradata...")

#IF (NOT TERADATA_PATH_LIB)
#    MESSAGE(FATAL_ERROR "Please set path to cliv2 LIBRARIES with -DTERADATA_PATH_LIB")
#ENDIF (NOT TERADATA_PATH_LIB)

#IF (NOT TERADATA_PATH_INCLUDES)
#    MESSAGE(FATAL_ERROR "Please set path to cliv2 INCLUDES with -DTERADATA_PATH_INCLUDES")
#ENDIF (NOT TERADATA_PATH_INCLUDES)

GET_FILENAME_COMPONENT(TERADATA14_ROOT_PATH  "[HKEY_LOCAL_MACHINE\\SOFTWARE\\Teradata\\Client\\14.00\\Teradata CLIv2;InstallDLLsPath]" ABSOLUTE)
GET_FILENAME_COMPONENT(TERADATA13_ROOT_PATH  "[HKEY_LOCAL_MACHINE\\SOFTWARE\\Teradata\\Client\\13.00\\Teradata CLIv2;InstallDLLsPath]" ABSOLUTE)

SET(TERADATA_LIB_PATHS
  /opt/teradata/client/14.00/lib64/
  /opt/teradata/client/14.00/lib/
  /opt/teradata/client/13.00/lib64/
  /opt/teradata/client/13.00/lib/
  ${TERADATA14_ROOT_PATH}/lib/
  ${TERADATA13_ROOT_PATH}/lib/
  $ENV{COPLIB}/
)
FIND_LIBRARY(
  TERADATA_LIBRARY_LIBCLIV2
  NAMES libcliv2.so wincli32
  PATHS ${TERADATA_LIB_PATHS}
  NO_DEFAULT_PATH NO_CMAKE_ENVIRONMENT_PATH NO_CMAKE_PATH NO_SYSTEM_ENVIRONMENT_PATH NO_CMAKE_SYSTEM_PATH
)
FIND_LIBRARY(
  TERADATA_LIBRARY_LIBTDUSR
  NAMES libtdusr.so
  PATHS ${TERADATA_LIB_PATHS}
  NO_DEFAULT_PATH NO_CMAKE_ENVIRONMENT_PATH NO_CMAKE_PATH NO_SYSTEM_ENVIRONMENT_PATH NO_CMAKE_SYSTEM_PATH
)
MESSAGE(STATUS "Teradata Library libcliv2: ${TERADATA_LIBRARY_LIBCLIV2}")
MESSAGE(STATUS "Teradata Library libtdusr: ${TERADATA_LIBRARY_LIBTDUSR}")

SET(TERADATA_INCLUDE_PATHS
  /opt/teradata/client/14.00/include/
  /opt/teradata/client/13.00/include/
  ${TERADATA14_ROOT_PATH}/inc/
  ${TERADATA13_ROOT_PATH}/inc/
  $ENV{COPLIB}/../include/
)
FIND_PATH(
  TERADATA_INCLUDES
  coptypes.h
  ${TERADATA_INCLUDE_PATHS}
  NO_DEFAULT_PATH NO_CMAKE_ENVIRONMENT_PATH NO_CMAKE_PATH NO_SYSTEM_ENVIRONMENT_PATH NO_CMAKE_SYSTEM_PATH
)
MESSAGE(STATUS "Teradata Includes: ${TERADATA_INCLUDES}")

SET (TERADATA_LIBRARIES "${TERADATA_LIBRARY_LIBCLIV2}")
# teradata doesn't distribute a .lib for this one on windows
IF (TERADATA_LIBRARY_LIBTDUSR)
  LIST (APPEND TERADATA_LIBRARIES ${TERADATA_LIBRARY_LIBTDUSR})
ENDIF (TERADATA_LIBRARY_LIBTDUSR)
MESSAGE(STATUS "Teradata Libraries: ${TERADATA_LIBRARIES}")

# TRY_RUN(TDRUNRESULT TDCOMPILERESULT
#     ${CMAKE_BINARY_DIR}
#     ${CMAKE_SOURCE_DIR}/cmake/modules/TeradataTest.c
#     CMAKE_FLAGS "-DINCLUDE_DIRECTORIES:STRING=${TERADATA_PATH_INCLUDES}"
#     OUTPUT_VARIABLE TDOUTPUTVAR)

# IF (NOT TDCOMPILERESULT)
#     MESSAGE(STATUS "Compile Result: ${TDCOMPILERESULT}")
#     MESSAGE(STATUS "Run Result: ${TDRUNRESULT}")
#     MESSAGE(STATUS "Output: ${TDOUTPUTVAR}")
#     MESSAGE(FATAL_ERROR "Failed to run a simple Teradata compile test. Please double-check TERADATA_PATH_LIB and TERADATA_PATH_INCLUDES are set correctly.")
# ENDIF (NOT TDCOMPILERESULT)

IF (TERADATA_INCLUDES AND TERADATA_LIBRARIES)
   SET(TERADATA_FOUND "YES")
ENDIF (TERADATA_INCLUDES AND TERADATA_LIBRARIES)

MESSAGE(STATUS "Teradata found: ${TERADATA_FOUND}")
