/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __RCX_Disasm_h
#define __RCX_Disasm_h

#ifndef __PTypes_h
#include "PTypes.h"
#endif

#ifndef __RCX_Result_h
#include "RCX_Result.h"
#endif

#ifndef _STDIO_H
#include <stdio.h>
#endif

class RCX_Printer;
class RCX_SourceFiles;
class RCX_SourceTag;

class RCX_Disasm
{
public:
				RCX_Disasm();

	void		Print(RCX_Printer *dst, const UByte *code, int length);

	void		Print(RCX_Printer *dst, const UByte *code, int length, RCX_SourceFiles *sf,
					const RCX_SourceTag *tags, int tagCount);

	RCX_Result	Print1(RCX_Printer *dst, const UByte *code, int length, UShort pc);
	RCX_Result	SPrint1(char *text, const UByte *code, int length, UShort pc);

private:
};


class RCX_Printer
{
public:
	virtual	void Print(const char *text);
	virtual void Print(const char *text, int length) = 0;
};

class RCX_StdioPrinter : public RCX_Printer
{
public:
			RCX_StdioPrinter(FILE *fp)	{ fFile = fp; }
	
	virtual void Print(const char *text)				{ fputs(text, fFile); }
	virtual void Print(const char *text, int length)	{ fwrite(text, length, 1, fFile); } 
	
private:
	FILE*	fFile;
};


class RCX_SourceFiles
{
public:
	virtual long Print(RCX_Printer *printer, short index, long start, long end) = 0;
};


extern RCX_Disasm gRCX_Disasm;

#endif
