#include "xchatosd_conf.h"

XOsdConf::XOsdConf()
{
    __possible.push_back("lines");
    __params["lines"] = "isnumber";
    __possible.push_back("active");
    __params["active"] = "isbool";
    __possible.push_back("align");
    __params["align"] = "setof";
    __values["align"] = ":left:right:center:";
    __possible.push_back("allchan");
    __params["allchan"] = "isbool";
    __possible.push_back("channels");
    __params["channels"] = "any";
// Now we use nl_langinfo for codepage selection
//    __possible.push_back("codepage");
//    __params["codepage"] = "any";
    __possible.push_back("color");
    __params["color"] = "any";
    __possible.push_back("delay");
    __params["delay"] = "isnumber";
    __possible.push_back("font");
    __params["font"] = "any";
    __possible.push_back("hoffset");
    __params["hoffset"] = "isnumber";
    __possible.push_back("voffset");
    __params["voffset"] = "isnumber";
    __possible.push_back("osd");
    __params["osd"] = "isbool";
    __possible.push_back("pos");
    __params["pos"] = "setof";
    __values["pos"] = ":top:bottom:middle:";
    __possible.push_back("priv");
    __params["priv"] = "isbool";
    __alias["private"] = "priv";
    __possible.push_back("shadow");
    __params["shadow"] = "isnumber";
    __alias["soffset"] = "shadow";
    __possible.push_back("timeout");
    __params["timeout"] = "isnumber";
    __possible.push_back("notice");
    __params["notice"] = "isbool";
    __possible.push_back("notify");
    __params["notice"] = "isbool";
    __possible.push_back("verbose");
    __params["verbose"] = "isbool";
    __possible.push_back("dcc");
    __params["dcc"] = "isbool";
    __possible.push_back("ctcp");
    __params["ctcp"] = "isbool";
}

XOsdConf::~XOsdConf() {
	__data.clear();
	__possible.clear();
}

void XOsdConf::erase () {
    __data.clear();
}

int XOsdConf::write (string filename)
{
	ofstream fp(filename.c_str());
	if(!fp) {
		return -1;
	}
	map<string,string>::iterator iter = __data.begin();
	while ( iter != __data.end() ) {
	    fp << (*iter).first << "=" << (*iter).second << endl;
	    iter++;
	}
	fp.close();
	return 0;
}

int XOsdConf::getiValue (string key)
{
    return atoi(__data[key].c_str());
}

int XOsdConf::setValue (string key, string value)
{
    if(__alias.count(key))
	key = __alias[key];
    if(isPossible(key)) {
	if (isValueOk(key, value)) {
	    if( __params[key] == "isbool" ) {
		__data[key] = (value=="1"
		    ||(!strcasecmp(value.c_str(),"yes"))
		    ||(!strcasecmp(value.c_str(),"on"))
		)?"1":"0";
	    } else {
		__data[key] = value;
	    }
	    return 1;
	} else {
	    __lasterr = CONF_Err2;
	}
    } else {
	__lasterr = CONF_Err1;
    }
    return 0;
}

bool XOsdConf::isValueOk (string key, string value)
{
    string keyType = __params[key];
    if(keyType.empty()) return false;
    
    if( keyType == "any" ) return true;
    if( keyType == "isbool" && 
	    (	value=="on"||
		value=="off"||
		value=="yes"||
		value=="no"||
		value=="1"||
		value=="0"))
	return true;
    if( keyType == "isnumber" ) {
	for(int k=0; k<value.size();k++)
	    if(!isdigit(value[k])) return false;
	return true;
    }
    if( keyType == "setof" ) {
    	string mySet = __values[key];
	if( __values[key].find(":"+value+":") != -1) 
	    return true;
	return false;
    }
    return false;
}

int XOsdConf::setValue (string key, int value)
{
    char tmp[10];
    sprintf(tmp, "%i", value);
    return setValue(key,string(tmp));
}

bool XOsdConf::isPossible (string key)
{
    if(__alias.count(key))
	key = __alias[key];
    bool flag = false;
    vector<string>::iterator i=__possible.begin();
    while( i!=__possible.end() ) {
	if(*i==key) flag=true;
	i++;
    }
    return flag;
}

string XOsdConf::getValue (string key)
{
    if(__alias.count(key))
	key = __alias[key];
    map<string,string>::iterator i=__data.begin();
    while( i != __data.end() ) {
	if((*i).first==key) return (*i).second;
	i++;
    }
    return "";
}

int XOsdConf::read (string filename)
{
	ifstream fp(filename.c_str());
	if(!fp) {
		return -1;
	}
	string buffer,key,value;
	while(fp>>buffer) {
		key = buffer.substr(0,buffer.find("="));
		value = buffer.substr(buffer.find("=")+1);
		setValue(key, value);
	}
}
