#include <set>
#include <string>
#include <fstream>
#include <iostream>
#include <xosd.h>
#include <stdio.h>
#include <stdlib.h>
#include <langinfo.h>
#include "xchatosd.h"
#include "xchatosd_lang.h"
#include "my_xosd.h"
#include "xchatosd_conf.h"
#ifdef ICONV_LIB
#include <iconv.h>
#endif

#include <errno.h>
#include "xchat-plugin.h"

using namespace std;

static xchat_plugin *ph;
static XOsd *osd = NULL;
static XOsdConf config;
static char *codepage;
#ifdef ICONV_LIB
static iconv_t iconv_desc = (iconv_t) (-1);
#endif

static char outbuf[BUF_SIZE];
#define hooks 5
static xchat_hook *hook[hooks];

static int inchan(string chan)
{
	return config.getValue("channels").find(chan+",");
}

static void XOSDconfRead(void)
{
	config.setValue("lines",XOSD_LINES);
	config.setValue("notice",XCHATOSD_NOTICE);
	config.setValue("notice",XCHATOSD_NOTIFY);
	config.setValue("verbose",XCHATOSD_VERBOSE);
	config.setValue("delay",XOSD_DELAY);
	config.setValue("channels",XCHATOSD_CHANNELS);
	config.setValue("pos",XOSD_POS);
	config.setValue("voffset",XOSD_V_OFFSET);
	config.setValue("hoffset",XOSD_H_OFFSET);
	config.setValue("align",XOSD_ALIGN);
	config.setValue("shadow",XOSD_SHADOW);
	config.setValue("timeout",XOSD_TIMEOUT);
	config.setValue("font",XOSD_FONT);
	config.setValue("color",XOSD_COLOR);
	config.setValue("priv",XCHATOSD_PRIVATE);
	config.setValue("osd",XCHATOSD_OSD);
	config.setValue("dcc",XCHATOSD_DCC);
	config.setValue("ctcp",XCHATOSD_CTCP);
	config.setValue("allchan",XCHATOSD_ALLCHAN);
	config.setValue("active",XCHATOSD_ACTIVE);
	string buffer = xchat_get_info(ph, "xchatdirfs");
	buffer += "/";
	buffer += XCHATOSD_CONFIG_FILE;
	config.read(buffer);
}

static int XOSDconfWrite(void)
{
	string buffer = xchat_get_info(ph, "xchatdirfs");
	buffer += "/";
	buffer += XCHATOSD_CONFIG_FILE;
	config.write(buffer);
	return 0;
}

static int XOSD_init(void)
{
	if (osd == NULL) {
		osd = new XOsd(config.getiValue("lines"));
	}
	if (osd == NULL) {
		return -1;
	}
	if(osd->setPos(config.getValue("pos")) == -1)
	    return -1;
	if(osd->setVOffset(config.getiValue("voffset"))==-1)
	    return -1;
	if(osd->setHOffset(config.getiValue("hoffset"))==-1)
	    return -1;
	if(osd->setAlign(config.getValue("align"))==-1)
	    return -1;
	if(osd->setSOffset(config.getiValue("shadow"))==-1)
	    return -1;
	if(osd->setTimeout(config.getiValue("timeout"))==-1)
	    return -1;
	if(osd->setFont(config.getValue("font"))==-1)
	    return -1;
	if(osd->setColor(config.getValue("color"))==-1)
	    return -1;
	if(osd->display(MSG_Hello)==-1)
	    return -1;
	return 0;
}

#ifdef ICONV_LIB
static int ICONV_init(void)
{
	if (iconv_desc != (iconv_t) (-1)) {
		iconv_close(iconv_desc);
	}
	iconv_desc = iconv_open(codepage, "UTF8");
	if (iconv_desc == (iconv_t) (-1)) {
		return -1;
	} else {
		return 0;
	}
}
#endif

static int XosdPrint(string msg)
{
	const char *inptr = msg.c_str();
	char *outptr = (char *) outbuf;
	size_t inleft = msg.size();
	size_t outleft = BUF_SIZE;
#ifdef ICONV_LIB
	if (iconv(iconv_desc,
		  (char **) &inptr,
		  &inleft, (char **) &outptr, &outleft) != (size_t) (-1)) {
		outbuf[BUF_SIZE - outleft] = '\0';
		osd->display(outbuf);
	} else {
	    xchat_print(ph, MSG_NotEnough);
#endif
	    osd->display(msg);
#ifdef ICONV_LIB
	}
#endif
	return 1;
}
	
static int chan_del( string chan )
{
	if (chan.empty() || chan == "") {
		xchat_print(ph, MSG_ChanErr4);
		return -1;
	} else {
		string buf = chan;
		buf += ",";
		string chans = config.getValue("channels");
		int idx = chans.find(buf);
		if( idx != -1 ) {
		    chans.erase(idx,buf.size());
		    config.setValue("channels",chans);
    		    xchat_print(ph, MSG_ChanOk2);
		} else {		
		    xchat_print(ph, MSG_ChanErr5);
		    return -1;
		}
	}
	return 0;
}

static int chan_add( string chan )
{
	string chans = config.getValue("channels");
	if (chan.empty() || chan == "" || (int)chans.find(chan) != -1) {
		xchat_print(ph, MSG_ChanErr4);
	} else {
	    chans += chan;
	    chans += ",";
	    config.setValue("channels",chans);
	    xchat_print(ph,MSG_ChanOk1);
	}
	return 0;
}

static int osd_cb(char *word[], char *word_eol[], void *userdata)
{
    string cmd1 = word[2];
    string cmd2 = word[3];
    string cmd3 = word[4];
	if (cmd1 == "help") {
		if (cmd2 == "set") {
			xchat_print(ph, "with 'set' command you can:\n");
			xchat_print(ph,
				    "\0033/osd set color colorname\003. Where colorname is the name of the color that you want OSD to use.\n");
			xchat_print(ph,
				    "\0033/osd set lines numlines\003. Where numlines is the number of lines OSD will you to display data\n");
			xchat_print(ph,
				    "\0033/osd set delay numseconds\003. Where numseconds is the number of seconds OSD data will be displayed\n");
			xchat_print(ph,
				    "\0033/osd set voffset pix\003. Where pix is the number of pixels that OSD will use as offset from the vertical edge of the screen.\n");
			xchat_print(ph,
				    "\0033/osd set hoffset pix\003. Where pix is the number of pixels that OSD will use as offset from the horizontal edge of the screen.\n");
			xchat_print(ph,
				    "\0033/osd set shadow pix\003. Where pix is the number of pixels that OSD will use as offset between shadow and data\n");
			xchat_print(ph,
				    "\0033/osd set timeout secs\003. Where secs is the number of seconds of expiration data on the screen\n");
			xchat_print(ph,
				    "\0033/osd set active <on/off>\003. Toggles between OSD'ing messages from active tab on and off.\n");
			xchat_print(ph,
				    "\0033/osd set private <on/off>\003. Have no effect at this moment\n");
			xchat_print(ph,
				    "\0033/osd set notice <on/off>\003. Turn on and off notifying of notices\n");
			xchat_print(ph,
				    "\0033/osd set notify <on/off>\003. Turn on and off notifications about online users\n");
			xchat_print(ph,
				    "\0033/osd set dcc <on/off>\003. Turn on and off notifications about dcc chat messages\n");
			xchat_print(ph,
				    "\0033/osd set align <left|center|right>\003. Set positioning of the OSD on the screen\n");
			xchat_print(ph,
				    "\0033/osd set pos <top|middle|bottom>\003. Same as previous.\n");
/*
#ifdef ICONV_LIB
			xchat_print(ph,
				    "\0033/osd set codepage <cp>\003. Where cp is the codepage that you want to use when recoding.\n");
#endif
*/
			xchat_print(ph,
				    "\0033/osd set font <font>\003. Where font is the font that you find useful with xfontsel :)\n");
		} else {
			xchat_print(ph,
				    "XChatOSD module is borrowed from XChadOSD perl script.\n");
			xchat_print(ph,
				    "Here is a list of commands that you can use:\n");
			xchat_print(ph,
				    "/osd <on/off> - turn on or off OSD at all\n");
			xchat_print(ph,
				    "/osd set <color|lines|delay|voffset|hoffset|shadow|timeout|private|align|pos|color|active|notice|dcc>\n");
			xchat_print(ph,
				    "Type '/osd help set' for descriptive information\n");
		}
	} else
	if (cmd1 == "show") {
		if(! config.isPossible(cmd2) ) {
		    xchat_print(ph, MSG_ShowErr0);
		    return XCHAT_EAT_ALL;
		}
		string value = config.getValue(cmd2);
		if( cmd2 == "osd" 
			|| cmd2 == "active" 
			|| cmd2 == "private" 
			|| cmd2 == "priv" 
			|| cmd2 == "allchan" 
			|| cmd2 == "dcc" 
			|| cmd2 == "ctcp" 
		    ) value = (value=="1")?"On":"Off";
		string msg;
		msg = MSG_Success1 + cmd2 + MSG_Success3 + value + "\n";
		xchat_print(ph, msg.c_str());
	} else
	if (cmd1 == "set") {
		int status = 0;
		status = config.setValue(cmd2,cmd3);
		delete osd;
		osd = NULL;
		XOSD_init();
/*
#ifdef ICONV_LIB
		if(status && cmd2 == "codepage") {
		    ICONV_init();
		}
#endif
*/
		if (status == 1) {
			string msg;
			msg = MSG_Success1 + cmd2 + MSG_Success2 + cmd3 + "\n";			
			xchat_print(ph, msg.c_str());
		} else {
		    string tmp = config.lastError();
			xchat_print(ph, tmp.c_str());
		}
	} else
	if (cmd1 == "chan") {
	    if(cmd2 == "all") {
		config.setValue("allchan",1);
		xchat_print(ph, MSG_ChanOk3);
	    } else if( cmd2 == "none" ) {
		config.setValue("allchan","-1");
		xchat_print(ph, MSG_ChanOk4);
	    } else if( cmd2 == "my" ) {
		config.setValue("allchan","0");
		xchat_print(ph, MSG_ChanOk5);
	    } else if( cmd2 == "toggle" ) {
		if( cmd3.empty() ) {
		    cmd3 = xchat_get_info(ph, "channel");
		}
		if( inchan( cmd3 ) != -1 ) {
			chan_del( cmd3 );
		} else {
			chan_add( cmd3 );
		}
	    } else if (cmd2 == "add") {
		if( cmd3.empty() ) {
		    cmd3 = xchat_get_info(ph, "channel");
		}
		chan_add( cmd3 );
	    } else if (cmd2 == "del") {
		if( cmd3.empty() ) {
		    cmd3 = xchat_get_info(ph, "channel");
		}
		chan_del(cmd3);
	    }
	} else 
	if (cmd1 == "on") {
		config.setValue("osd",1);
		xchat_print(ph, MSG_OsdOn);
	} else
	if (cmd1 == "off") {
		config.setValue("osd",0);
		xchat_print(ph, MSG_OsdOff);
	} else
	if (cmd1.empty()) {
	    int tmp = config.getiValue("osd");
	    config.setValue("osd",(tmp)?0:1);
		xchat_print(ph, (tmp)?MSG_OsdOff:MSG_OsdOn);
	}
	return XCHAT_EAT_ALL;
}

static int osd_priv_cb(char *word[], char *word_eol[], void *userdata)
{
	string to = word[3];
	if (config.getiValue("osd") == 0) {
		return XCHAT_EAT_NONE;
	}
	string msg = word_eol[4]+1;
	string type= "";
	if(msg[0] == 1 && msg[msg.size()-1]==1) {
	    string::size_type n = msg.find(' ');
	    type=msg.substr(1,n-1);
	    msg=msg.substr(n+1,msg.size()-n-2);
	}
	if (config.getiValue("allchan") == -1 && to[0] == '#') {
		return XCHAT_EAT_NONE;
	}
	if (config.getiValue("allchan") == 0 && to[0] == '#' && (inchan(to)==-1)) {
		return XCHAT_EAT_NONE;
	}
	if (config.getiValue("priv") == 0 && to[0] != '#') {
		return XCHAT_EAT_NONE;
	}
	if ( config.getiValue("active") && to == string(xchat_get_info(ph, "channel")) ) {
		return XCHAT_EAT_NONE;
	}
	if ( config.getiValue("ctcp") == 0 && type != "") {
		return XCHAT_EAT_NONE;
	}
	string tmp = word[1];
	int i = tmp.find(":");
	if(i==-1) {
	    return XCHAT_EAT_NONE;
	}
	string nick = tmp.substr(i+1,tmp.find("!")-i-1);
	if( type == "" ) {
	    type = MSG_Message1;
	} else {
	    type = MSG_CTCP1 + type + MSG_CTCP2;
	}
	if(config.getiValue("verbose")) {	    
	    msg = type + nick + MSG_Message2 + to + MSG_Message3 + (msg);
	} else {
	    msg = type + nick + MSG_Message2 + to;
	}
	XosdPrint(msg);
	return XCHAT_EAT_NONE;
}

static int osd_notice_cb(char *word[], char *word_eol[], void *userdata)
{
	string to = word[3];
	if (config.getiValue("osd") == 0 || config.getiValue("notice") == 0) {
		return XCHAT_EAT_NONE;
	}
	string msg;
	string tmp = word[1];
	int i = tmp.find(":");
	if(i==-1) {
	    return XCHAT_EAT_NONE;
	}
	string nick = tmp.substr(i,tmp.find("!")-i);
	if(config.getiValue("verbose")) {
	    msg = MSG_Notice1 + nick + MSG_Notice2 + to + MSG_Notice3 + (word_eol[4]+1);
	} else {
	    msg = MSG_Notice1 + nick + MSG_Notice2 + to;
	}
	XosdPrint(msg);
	return XCHAT_EAT_NONE;
}

static int osd_dcc_cb(char *word[], void *userdata)
{
	string from = word[3];
	string msg = word[4];
	if (config.getiValue("osd") == 0 || config.getiValue("dcc") == 0) {
		return XCHAT_EAT_NONE;
	}
	if(config.getiValue("verbose")) {
	    msg = MSG_DCC1 + from + MSG_DCC2 + msg;
	} else {
	    msg = MSG_DCC1 + from;
	}
	XosdPrint(msg);
	return XCHAT_EAT_NONE;
}

static int osd_notify_cb(char *word[], char *word_eol[], void *userdata)
{
	static set<string> onlineUsers;
	set<string> newUsers;
	int i = 1;
	string::size_type pos = 0, prev_pos = 0;
	string data = word_eol[4];
	string nick, nicks, diss;
	if(data[0] == ':') {
	    data.erase(0,1);
	}
	if(data.size()) {
	    while((pos = data.find_first_of(" \n\t",pos)) != string::npos) {
		nick = data.substr(prev_pos, pos-prev_pos);
		newUsers.insert(nick);
		if(!onlineUsers.count(nick)) {
		    nicks += " " + nick;
		}
		prev_pos = ++pos;
	    }
	    set<string>::iterator it=onlineUsers.begin();
	    for (; it != onlineUsers.end(); ++it) {
		if(! newUsers.count(*it)) {
		    diss += " " + *it;
		}
	    }
	    if(nicks.size()) {
    		XosdPrint(nicks + MSG_Notify1);
	    }
	    if(diss.size()) {
    		XosdPrint(diss + MSG_Notify2);
	    }
	}
	onlineUsers = newUsers;
	return XCHAT_EAT_NONE;
}


extern "C" { int
xchat_plugin_init(xchat_plugin * plugin_handle,
		  char **plugin_name,
		  char **plugin_desc, char **plugin_version, char *arg)
{
	ph = plugin_handle;
	XOSDconfRead();
	if (XOSD_init() != 0) {
		xchat_print(ph,
			    "Can't init OSD library. Plugin disabled.\n");
		return 0;
	}
	codepage = nl_langinfo(CODESET);
	if(!strlen(codepage))
	    codepage = XCHATOSD_CODEPAGE;

#ifdef ICONV_LIB
	if (ICONV_init() != 0) {
		xchat_print(ph,
			    "Can't init Iconv library. Conversion disabled.\n");
	}
#endif
	*plugin_name = "XChatOSD";
	*plugin_desc = "Shows XChat messages using OSD library";
	*plugin_version = XChatOSDver;

	hook[0] =
	    xchat_hook_command(ph, "OSD", XCHAT_PRI_NORM, osd_cb,
			       "Usage: osd, Master OSD Command", 0);
	hook[1] =
	    xchat_hook_server(ph, "PRIVMSG", XCHAT_PRI_NORM, osd_priv_cb,
			      NULL);
	hook[2] =
	    xchat_hook_server(ph, "NOTICE", XCHAT_PRI_NORM, osd_notice_cb,
			      NULL);
	hook[3] =
	    xchat_hook_server(ph, "303", XCHAT_PRI_NORM, osd_notify_cb,
			      NULL);
	hook[4] =
	    xchat_hook_print(ph, "DCC Chat Text", XCHAT_PRI_NORM, osd_dcc_cb,
			      NULL);
	xchat_print(ph, "XChatOSD plugin loaded successfully.\n");
	return 1;
}
}

extern "C" {
int xchat_plugin_deinit(void)
{
    for(int i=0; i<hooks; i++)
	xchat_unhook(ph, hook[i]);
#ifdef ICONV_LIB
	iconv_close(iconv_desc);
#endif
	delete osd;
	XOSDconfWrite();
	xchat_print(ph, "XChatOSD plugin unloaded successfully.\n");
	return 1;
}
}
