#include "my_xosd.h"

XOsd::XOsd(int lines)
{
	__osd = xosd_create(lines);
	if( __osd != NULL ) {
		__lines = lines;
		__line = 1;
	}
}

int XOsd::setPos(string pos)
{
	if( __osd ) {
		__pos = XOSD_top;
		if(pos == "top") {
			__pos = XOSD_top;
		} else if(pos == "bottom") {
			__pos = XOSD_bottom;
		} else if(pos == "middle") {
			__pos = XOSD_middle;
		}
		return xosd_set_pos(__osd, __pos);
	}
	return 0;
}

int XOsd::setVOffset(int i)
{
	if( __osd ) {
		return xosd_set_vertical_offset(__osd, i);
	}
	return 0;
}

int XOsd::setHOffset(int i)
{
	if( __osd ) {
		return xosd_set_horizontal_offset(__osd, i);
	}
	return 0;
}

int XOsd::setAlign(string align)
{
	if( __osd ) {
		__align = XOSD_left;
		if(align == "left") {
			__align = XOSD_left;
		} else if(align == "bottom") {
			__align = XOSD_center;
		} else if(align == "middle") {
			__align = XOSD_right;
		}
		return xosd_set_align(__osd, __align);
	}
	return 0;
}

int XOsd::setSOffset(int i)
{
	if( __osd ) {
		return xosd_set_shadow_offset(__osd, i);
	}
	return 0;
}

int XOsd::setTimeout(int i)
{
	if( __osd ) {
		return xosd_set_timeout(__osd, i);
	}
	return 0;
}

int XOsd::setFont(string font)
{
	if( __osd ) {
		return xosd_set_font(__osd, font.c_str());
	}
	return 0;

}

int XOsd::setColor(string color)
{
	if( __osd ) {
		return xosd_set_colour(__osd, color.c_str());
	}
	return 0;

}

int XOsd::display(string msg)
{
	if( __osd ) {
		if(xosd_is_onscreen(__osd)) {
			if( __line < __lines ) {
				__line++;
			} else {
				scroll(1);
			}
		} else {
			__line = 1;
			scroll(__lines-1);
		}
		return xosd_display(__osd, __line-1, XOSD_string, msg.c_str());
	}
	return 0;

}

int XOsd::scroll(int lines) {
	if( __osd ) {
		return xosd_scroll(__osd, lines);
	}
	return 0;
}

int XOsd::hide() {
	if( __osd ) {
		return xosd_hide(__osd);
	}
	return 0;
}

int XOsd::show() {
	if(__osd) {
		return xosd_show(__osd);
	}
	return 0;
}

istream& operator>>(istream &s, XOsd &Xosd) {
    string tmp;
    s>>tmp;
    Xosd.display(tmp);
    return s;
}

XOsd::~XOsd()
{
	if( __osd ) {
		xosd_destroy(__osd);
	}
}

