"use strict"
define("vault/adapters/application",["exports","ember-data","ember-fetch/mixins/adapter-fetch","fetch","vault/config/environment"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=s.default.APP,l=r.POLLING_URLS,i=r.NAMESPACE_ROOT_URLS
e.default=t.default.RESTAdapter.extend(n.default,{auth:Ember.inject.service(),namespaceService:Ember.inject.service("namespace"),controlGroup:Ember.inject.service(),flashMessages:Ember.inject.service(),namespace:"v1/sys",shouldReloadAll:function(){return!0},shouldReloadRecord:function(){return!0},shouldBackgroundReloadRecord:function(){return!1},addHeaders:function(e,t){var n=t.clientToken||this.get("auth.currentToken"),a={}
n&&!t.unauthenticated&&(a["X-Vault-Token"]=n),t.wrapTTL&&(a["X-Vault-Wrap-TTL"]=t.wrapTTL)
var s=void 0===t.namespace?this.get("namespaceService.path"):t.namespace
s&&!i.some(function(t){return e.includes(t)})&&(a["X-Vault-Namespace"]=s),t.headers=Ember.assign(t.headers||{},a)},_preRequest:function(e,t){return this.addHeaders(e,t),l.some(function(t){return e.includes(t)})||this.auth.setLastFetch(Date.now()),t.timeout=6e4,t},ajax:function(e,t){var n=this,a=e,s=t,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},l=this.get("controlGroup"),i=l.tokenForUrl(a)
i&&(a="/v1/sys/wrapping/unwrap",s="POST",r={clientToken:i.token,data:{token:i.token}})
var o=this._preRequest(a,r)
return this._super(a,s,o).then(function(){for(var e=arguments.length,t=Array(e),a=0;a<e;a++)t[a]=arguments[a]
i&&l.deleteControlGroupToken(i.accessor)
var s=t[0]
if(s&&s.warnings){var o=n.get("flashMessages")
s.warnings.forEach(function(e){o.info(e)})}return l.checkForControlGroup(t,s,r.wrapTTL)})},rawRequest:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},s=this._preRequest(e,n)
return(0,a.default)(e,{method:t||"GET",headers:s.headers||{}}).then(function(e){return e.status>=200&&e.status<300?Ember.RSVP.resolve(e):Ember.RSVP.reject()})},handleResponse:function(e,n,a,s){var r=this._super.apply(this,arguments)
return r instanceof t.default.AdapterError&&(Ember.set(r,"httpStatus",e),Ember.set(r,"path",s.url)),r}})}),define("vault/adapters/auth-config/_base",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"/v1/auth",pathForType:function(e){var t=e.split("/").pop()
return"identity-whitelist"===t||"roletag-blacklist"===t?"tidy/"+t:t},buildURL:function(e,t,n){var a=t||n.belongsTo("backend").id,s=this.get("namespace")+"/"+a+"/config"
return e.includes("aws")&&(s=s+"/"+this.pathForType(e)),s},createRecord:function(e,t,n){var a=n.belongsTo("backend").id
return this._super.apply(this,arguments).then(function(){return{id:a}})},updateRecord:function(e,t,n){var a=n.belongsTo("backend").id
return this._super.apply(this,arguments).then(function(){return{id:a}})}})}),define("vault/adapters/auth-config/aws/client",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/aws/identity-whitelist",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/aws/roletag-blacklist",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/azure",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/gcp",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/github",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/jwt",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/kubernetes",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/ldap",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/oidc",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/okta",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-config/radius",["exports","vault/adapters/auth-config/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/auth-method",["exports","vault/adapters/application","ember-data","vault/utils/path-encoding-helpers"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({url:function(e){var t=this.buildURL()+"/auth"
return e?t+"/"+(0,a.encodePath)(e):t},pathForType:function(){return"mounts/auth"},findAll:function(e,t,a,s){if(Ember.get(s||{},"adapterOptions.unauthenticated")){var r="/"+this.urlPrefix()+"/internal/ui/mounts"
return this.ajax(r,"GET",{unauthenticated:!0}).then(function(e){return{data:e.data.auth}}).catch(function(){return{data:{}}})}return this.ajax(this.url(),"GET").catch(function(e){throw e instanceof n.default.AdapterError&&Ember.set(e,"policyPath","sys/auth"),e})},createRecord:function(e,t,n){var a=e.serializerFor(t.modelName).serialize(n),s=n.attr("path")
return this.ajax(this.url(s),"POST",{data:a}).then(function(){return{data:Ember.assign({},a,{path:s+"/",id:s})}})},urlForDeleteRecord:function(e,t,n){return this.url(n.id)},exchangeOIDC:function(e,t,n){return this.ajax("/v1/auth/"+(0,a.encodePath)(e)+"/oidc/callback","GET",{data:{state:t,code:n}})}})}),define("vault/adapters/aws-credential",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({createRecord:function(e,t,n){var a=n.attr("ttl"),s=n.attr("roleArn"),r=n.attr("credentialType"),l="POST",i=void 0,o={}
"iam_user"===r?l="GET":(void 0!==a&&(o.ttl=a),"assumed_role"===r&&s&&(o.role_arn=s),i=o.ttl||o.role_arn?{data:o}:{})
var u=n.attr("role"),c="/v1/"+u.backend+"/creds/"+u.name
return this.ajax(c,l,i).then(function(a){a.id=n.id,a.modelName=t.modelName,e.pushPayload(t.modelName,a)})}})}),define("vault/adapters/capabilities",["exports","vault/adapters/application","ember-data"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({pathForType:function(){return"capabilities-self"},findRecord:function(e,t,a){return this.ajax(this.buildURL(t),"POST",{data:{paths:[a]}}).catch(function(e){throw e instanceof n.default.AdapterError&&Ember.set(e,"policyPath","sys/capabilities-self"),e})},queryRecord:function(e,t,n){var a=n.id
if(a)return this.findRecord(e,t,a).then(function(e){return e.path=a,e})}})}),define("vault/adapters/cluster",["exports","ember-inflector","vault/adapters/application","ember-data"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=a.default.AdapterError,r=["health","seal-status","tokens","token","seal","unseal","init","capabilities-self","license"]
e.default=n.default.extend({version:Ember.inject.service(),namespaceService:Ember.inject.service("namespace"),shouldBackgroundReloadRecord:function(){return!0},findRecord:function(e,t,n,a){var r={health:this.health(),sealStatus:this.sealStatus().catch(function(e){return e})}
return this.get("version.isEnterprise")&&this.get("namespaceService.inRootNamespace")&&(r.replicationStatus=this.replicationStatus().catch(function(e){return e})),Ember.RSVP.hash(r).then(function(e){var t=e.health,r=e.sealStatus,l=e.replicationStatus,i={id:n,name:a.attr("name")}
return i=Ember.assign(i,t),r instanceof s==!1&&(i=Ember.assign(i,{nodes:[r]})),l&&l instanceof s==!1&&(i=Ember.assign(i,l.data)),Ember.RSVP.resolve(i)})},pathForType:function(e){return"cluster"===e?"clusters":(0,t.pluralize)(e)},health:function(){return this.ajax(this.urlFor("health"),"GET",{data:{standbycode:200,sealedcode:200,uninitcode:200,drsecondarycode:200,performancestandbycode:200},unauthenticated:!0})},features:function(){return this.ajax(this.urlFor("license")+"/features","GET",{unauthenticated:!0})},sealStatus:function(){return this.ajax(this.urlFor("seal-status"),"GET",{unauthenticated:!0})},seal:function(){return this.ajax(this.urlFor("seal"),"PUT")},unseal:function(e){return this.ajax(this.urlFor("unseal"),"PUT",{data:e,unauthenticated:!0})},initCluster:function(e){return this.ajax(this.urlFor("init"),"PUT",{data:e,unauthenticated:!0})},authenticate:function(e){var t=e.backend,n=e.data,a=n.role,s=n.jwt,r=n.token,l=n.password,i=n.username,o=n.path,u=this.urlForAuth(t,i,o),c="token"===t?"GET":"POST",d={unauthenticated:!0}
return"token"===t?d.headers={"X-Vault-Token":r}:d.data="jwt"===t||"oidc"===t?{role:a,jwt:s}:r?{token:r,password:l}:{password:l},this.ajax(u,c,d)},urlFor:function(e){if(!r.includes(e))throw new Error("Calls to a "+e+" endpoint are not currently allowed in the vault cluster adapater")
return this.buildURL()+"/"+e},urlForAuth:function(e,t,n){var a=e.toLowerCase(),s={github:"login",jwt:"login",oidc:"login",userpass:"login/"+encodeURIComponent(t),ldap:"login/"+encodeURIComponent(t),okta:"login/"+encodeURIComponent(t),radius:"login/"+encodeURIComponent(t),token:"lookup-self"}[a],r=n&&"token"!==a?n:a
if(!s)throw new Error("There is no auth url for "+e+".")
return"/v1/auth/"+r+"/"+s},urlForReplication:function(e,t,n){var a=void 0
return a=t?e+"/"+t+"/"+n:""+n,this.buildURL()+"/replication/"+a},replicationStatus:function(){return this.ajax(this.buildURL()+"/replication/status","GET",{unauthenticated:!0})},replicationDrPromote:function(e,t){var n=t&&t.checkStatus?"GET":"PUT"
return this.ajax(this.buildURL()+"/replication/dr/secondary/promote",n,{data:e,unauthenticated:!0})},generateDrOperationToken:function(e,t){var n=t&&t.checkStatus?"GET":"PUT",a=this.buildURL()+"/replication/dr/secondary/generate-operation-token/"
return!e||e.pgp_key||e.attempt?a+="attempt":a+="update",this.ajax(a,n,{data:e,unauthenticated:!0})},replicationAction:function(e,t,n,a){var s="recover"===e||"reindex"===e?this.urlForReplication(t,null,e):this.urlForReplication(t,n,e)
return this.ajax(s,"POST",{data:a})}})}),define("vault/adapters/console",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",pathForType:function(e){return e}})}),define("vault/adapters/control-group-config",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({pathForType:function(){return"config/control-group"},urlForDeleteRecord:function(e,t){return this.buildURL(t)},urlForFindRecord:function(e,t){return this.buildURL(t)},urlForUpdateRecord:function(e,t){return this.buildURL(t)}})}),define("vault/adapters/control-group",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({pathForType:function(){return"control-group"},findRecord:function(e,t,n){var a=this.buildURL(t.modelName)
return this.ajax(a+"/request","POST",{data:{accessor:n}}).then(function(e){return e.id=n,e})},urlForUpdateRecord:function(e,t){return this.buildURL(t)+"/authorize"}})}),define("vault/adapters/generated-item-list",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",urlForItem:function(){},optionsForQuery:function(e){var t={}
return e||(t.list=!0),{data:t}},fetchByQuery:function(e,t){var n=t.id,a=t.method,s=t.type
return this.ajax(this.urlForItem(a,n,s),"GET",this.optionsForQuery(n)).then(function(e){var t={id:n,name:n,method:a}
return Ember.assign({},e,t)})},query:function(e,t,n){return this.fetchByQuery(e,n)},queryRecord:function(e,t,n){return this.fetchByQuery(e,n)}})}),define("vault/adapters/identity/base",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",pathForType:function(e){return e},urlForQuery:function(){return this._super.apply(this,arguments)+"?list=true"},query:function(e,t){return this.ajax(this.buildURL(t.modelName,null,null,"query"),"GET")},buildURL:function(e,t,n,a,s){return"createRecord"===a?this._super.apply(this,arguments):this._super(e+"/id",t,n,a,s)}})}),define("vault/adapters/identity/entity-alias",["exports","vault/adapters/identity/base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/identity/entity-merge",["exports","vault/adapters/identity/base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({buildURL:function(){var e=Array.prototype.slice.call(arguments).slice(1)
return this._super.apply(this,["identity/entity/merge"].concat(function(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}(e)))},createRecord:function(e,t,n){return this._super.apply(this,arguments).then(function(){return{id:n.attr("toEntityId")}})}})}),define("vault/adapters/identity/entity",["exports","vault/adapters/identity/base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({lookup:function(e,t){var n="/"+this.urlPrefix()+"/identity/lookup/entity"
return this.ajax(n,"POST",{data:t}).then(function(t){if(t){return e.push(e.serializerFor("identity/entity").normalizeResponse(e,e.modelFor("identity/entity"),t,t.data.id,"findRecord")),t}})}})}),define("vault/adapters/identity/group-alias",["exports","vault/adapters/identity/base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/identity/group",["exports","vault/adapters/identity/base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({lookup:function(e,t){var n="/"+this.urlPrefix()+"/identity/lookup/group"
return this.ajax(n,"POST",{data:t}).then(function(t){if(t){return e.push(e.serializerFor("identity/group").normalizeResponse(e,e.modelFor("identity/group"),t,t.data.id,"findRecord")),t}})}})}),define("vault/adapters/kmip/base",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t]
for(var a in n)Object.prototype.hasOwnProperty.call(n,a)&&(e[a]=n[a])}return e}
e.default=t.default.extend({namespace:"v1",pathForType:function(e){return e.replace("kmip/","")},_url:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},a=arguments[2],s=t.backend,r=t.scope,l=t.role,i=this.pathForType(e),o=void 0
switch(i){case"scope":o=(0,n.encodePath)(s)+"/scope"
break
case"role":o=(0,n.encodePath)(s)+"/scope/"+(0,n.encodePath)(r)+"/role"
break
case"credential":o=(0,n.encodePath)(s)+"/scope/"+(0,n.encodePath)(r)+"/role/"+(0,n.encodePath)(l)+"/credential"}return a&&"credential"===i?"/v1/"+o+"/lookup?serial_number="+(0,n.encodePath)(a):a?"/v1/"+o+"/"+(0,n.encodePath)(a):"/v1/"+o},urlForQuery:function(e,t){return this._url(t,e)+"?list=true"},query:function(e,t,n){return this.ajax(this.urlForQuery(n,t.modelName),"GET").then(function(e){n.size,n.page,n.responsePath,n.pageFilter
var t=function(e,t){var n={}
for(var a in e)t.indexOf(a)>=0||Object.prototype.hasOwnProperty.call(e,a)&&(n[a]=e[a])
return n}(n,["size","page","responsePath","pageFilter"])
return e._requestQuery=t,e})},queryRecord:function(e,t,n){var s=n.id
return delete n.id,this.ajax(this._url(t.modelName,n,s),"GET").then(function(e){return e.id=s,e=a({},e,n)})},buildURL:function(e,t,n,a,s){return"createRecord"===a?this._super.apply(this,arguments):this._super(""+e,t,n,a,s)}})}),define("vault/adapters/kmip/ca",["exports","vault/adapters/kmip/base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({urlForFindRecord:function(e,t,n){var a=this.pathForType(t)
return this.buildURL(e,a,n)}})})
define("vault/adapters/kmip/config",["exports","vault/adapters/kmip/base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({_url:function(e,t,n){var a=this.pathForType(t)
return this.buildURL(e,a,n)},urlForFindRecord:function(){return this._url.apply(this,arguments)},urlForCreateRecord:function(e,t){return this._url(t.id,e,t)},urlForUpdateRecord:function(){return this._url.apply(this,arguments)}})}),define("vault/adapters/kmip/credential",["exports","vault/adapters/kmip/base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({createRecord:function(e,t,n){var a=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope,role:n.record.role})
return a+="/generate",this.ajax(a,"POST",{data:n.serialize()}).then(function(e){return e.data.id=e.data.serial_number,e})},deleteRecord:function(e,t,n){var a=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope,role:n.record.role})
return a+="/revoke",this.ajax(a,"POST",{data:{serial_number:n.id}})}})}),define("vault/adapters/kmip/role",["exports","vault/adapters/kmip/base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t]
for(var a in n)Object.prototype.hasOwnProperty.call(n,a)&&(e[a]=n[a])}return e}
e.default=t.default.extend({createRecord:function(e,t,n){var a=n.id||n.attr("name"),s=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope},a)
return this.ajax(s,"POST",{data:this.serialize(n)}).then(function(){return{id:a,name:a,backend:n.record.backend,scope:n.record.scope}})},deleteRecord:function(e,t,n){var a=n.id||n.attr("name"),s=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope},a)
return this.ajax(s,"DELETE")},serialize:function(e){var t=e.serialize(),a=e.record.nonOperationFields.map(Ember.String.decamelize),s=Ember.getProperties(t,a)
for(var r in s)null==s[r]&&delete s[r]
return t.operation_all?n({operation_all:!0},s):t.operation_none?n({operation_none:!0},s):(delete t.operation_none,delete t.operation_all,t)},updateRecord:function(){return this.createRecord.apply(this,arguments)}})}),define("vault/adapters/kmip/scope",["exports","vault/adapters/kmip/base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({createRecord:function(e,t,n){var a=n.attr("name")
return this.ajax(this._url(t.modelName,{backend:n.record.backend},a),"POST").then(function(){return{id:a,name:a}})},deleteRecord:function(e,t,n){var a=this._url(t.modelName,{backend:n.record.backend},n.id)
return a+="?force=true",this.ajax(a,"DELETE")}})}),define("vault/adapters/lease",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({revokePrefix:function(e){var t=this.buildURL()+"/leases/revoke-prefix/"+(0,n.encodePath)(e)
return t=t.replace(/\/$/,""),this.ajax(t,"PUT")},forceRevokePrefix:function(e){var t=this.buildURL()+"/leases/revoke-prefix/"+(0,n.encodePath)(e)
return t=t.replace(/\/$/,""),this.ajax(t,"PUT")},renew:function(e,t){var n=this.buildURL()+"/leases/renew"
return this.ajax(n,"PUT",{data:{lease_id:e,interval:t}})},deleteRecord:function(e,t,n){var a=n.id
return this.ajax(this.buildURL()+"/leases/revoke","PUT",{data:{lease_id:a}})},queryRecord:function(e,t,n){var a=n.lease_id
return this.ajax(this.buildURL()+"/leases/lookup","PUT",{data:{lease_id:a}})},query:function(e,t,a){var s=a.prefix||""
return this.ajax(this.buildURL()+"/leases/lookup/"+(0,n.encodePath)(s),"GET",{data:{list:!0}}).then(function(e){return s&&(e.prefix=s),e})}})}),define("vault/adapters/license",["exports","vault/adapters/cluster"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({queryRecord:function(){return this._super.apply(this,arguments).then(function(e){return e.data.id=e.data.license_id,e.data})},createRecord:function(e,t,n){var a=n.attr("licenseId")
return this._super.apply(this,arguments).then(function(){return{id:a}})},updateRecord:function(e,t,n){var a=n.attr("licenseId")
return this._super.apply(this,arguments).then(function(){return{id:a}})},pathForType:function(){return"license"},urlForUpdateRecord:function(){return this.buildURL()+"/license"}})}),define("vault/adapters/mount-filter-config",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({url:function(e){return this.buildURL()+"/replication/performance/primary/mount-filter/"+e},findRecord:function(e,t,n){return this.ajax(this.url(n),"GET").then(function(e){return e.id=n,e})},createRecord:function(e,t,n){return this.ajax(this.url(n.id),"PUT",{data:this.serialize(n)})},updateRecord:function(){return this.createRecord.apply(this,arguments)},deleteRecord:function(e,t,n){return this.ajax(this.url(n.id),"DELETE")}})}),define("vault/adapters/namespace",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({pathForType:function(){return"namespaces"},urlForFindAll:function(e,t){return t.adapterOptions&&t.adapterOptions.forUser?"/"+this.urlPrefix()+"/internal/ui/namespaces":"/"+this.urlPrefix()+"/namespaces?list=true"},urlForCreateRecord:function(e,t){var n=t.attr("path")
return this.buildURL(e,n)},createRecord:function(e,t,n){var a=n.attr("path")
return this._super.apply(this,arguments).then(function(){return{id:a}})},findAll:function(e,t,n,a){return a.adapterOptions&&void 0!==a.adapterOptions.namespace?this.ajax(this.urlForFindAll("namespace",a),"GET",{namespace:a.adapterOptions.namespace}):this._super.apply(this,arguments)}})}),define("vault/adapters/node",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/permissions",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({query:function(){return this.ajax(this.urlForQuery(),"GET")},urlForQuery:function(){return this.buildURL()+"/internal/ui/resultant-acl"}})}),define("vault/adapters/pki-ca-certificate-sign",["exports","vault/adapters/pki"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({url:function(e,t){return"/v1/"+t.attr("backend")+"/root/sign-intermediate"}})}),define("vault/adapters/pki-ca-certificate",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",url:function(e,t){var n=e.attributes(),a=n.backend,s=n.caType,r=n.type
return"sign-intermediate"===t?"/v1/"+a+"/root/sign-intermediate":"set-signed-intermediate"===t?"/v1/"+a+"/intermediate/set-signed":"upload"===t?"/v1/"+a+"/config/ca":"/v1/"+a+"/"+s+"/generate/"+r},createRecordOrUpdate:function(e,t,n,a){var s=e.serializerFor("application"),r=n.attr("uploadPemBundle"),l="setSignedIntermediate"===n.adapterOptions.method,i="signIntermediate"===n.adapterOptions.method?"sign-intermediate":null,o=void 0
return r?(i="upload",o={pem_bundle:n.attr("pemBundle")}):l?(i="set-signed-intermediate",o={certificate:n.attr("certificate")}):o=s.serialize(n,a),this.ajax(this.url(n,i),"POST",{data:o}).then(function(a){a||(a={}),a.id=n.id,a.modelName=t.modelName,e.pushPayload(t.modelName,a)})},createRecord:function(){return this.createRecordOrUpdate.apply(this,arguments)},updateRecord:function(){return this.createRecordOrUpdate.apply(this,arguments)},deleteRecord:function(e,t,n){var a=n.attr("backend")
return this.ajax("/v1/"+a+"/root","DELETE")}})}),define("vault/adapters/pki-certificate-sign",["exports","vault/adapters/pki"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({url:function(e,t){return!0===t.attr("signVerbatim")?"/v1/"+e.backend+"/sign-verbatim/"+e.name:"/v1/"+e.backend+"/sign/"+e.name},pathForType:function(){return"sign"}})}),define("vault/adapters/pki-certificate",["exports","vault/adapters/pki"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({url:function(e){return"/v1/"+e.backend+"/issue/"+e.name},urlFor:function(e,t){var n=this.buildURL()+"/"+e+"/certs"
return t&&(n=this.buildURL()+"/"+e+"/cert/"+t),n},optionsForQuery:function(e){var t={}
return e||(t.list=!0),{data:t}},fetchByQuery:function(e,t){var n=t.backend,a=t.id
return this.ajax(this.urlFor(n,a),"GET",this.optionsForQuery(a)).then(function(e){var t={backend:n}
return a&&(t.serial_number=a,t.id=a,t.id_for_nav="cert/"+a),Ember.assign({},e,t)})},query:function(e,t,n){return this.fetchByQuery(e,n)},queryRecord:function(e,t,n){return this.fetchByQuery(e,n)},updateRecord:function(e,t,n){if("revoke"===n.adapterOptions.method){var a=n.id,s=n.record.get("backend"),r={serial_number:a}
return this.ajax(this.buildURL()+"/"+s+"/revoke","POST",{data:r}).then(function(e){var t={id:a,serial_number:a,backend:s}
return Ember.assign({},e,t)})}}})}),define("vault/adapters/pki-config",["exports","vault/adapters/application","ember-data"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",urlFor:function(e,t){return{tidy:"/v1/"+e+"/tidy",urls:"/v1/"+e+"/config/urls",crl:"/v1/"+e+"/config/crl"}[t]},createOrUpdate:function(e,t,n){var a=this.urlFor(n.record.get("backend"),n.adapterOptions.method),s=e.serializerFor(t.modelName)
if(a){var r=n.adapterOptions.fields.reduce(function(e,t){var a=n.attr(t)
return a?s.serializeAttribute(n,e,t,a):e[s.keyForAttribute(t)]=a,e},{})
return this.ajax(a,"POST",{data:r}).then(function(e){var t=e||{}
return t.id=n.record.get("backend")+"-"+n.adapterOptions.method,t})}},createRecord:function(){return this.createOrUpdate.apply(this,arguments)},updateRecord:function(){return this.createOrUpdate.apply(this,Array.prototype.slice.call(arguments).concat(["update"]))},fetchSection:function(e,t){if(!t||!["cert","urls","crl","tidy"].includes(t)){var a=new n.default.AdapterError
throw Ember.set(a,"httpStatus",404),a}return this["fetch"+Ember.String.capitalize(t)](e)},id:function(e){return e+"-config-ca"},fetchCert:function(e){var t="/v1/"+e+"/ca",n=t+"/pem",a=t+"_chain"
return Ember.RSVP.hash({backend:e,id:this.id(e),der:this.rawRequest(t,"GET",{unauthenticated:!0}).then(function(e){return e.blob()}),pem:this.rawRequest(n,"GET",{unauthenticated:!0}).then(function(e){return e.text()}),ca_chain:this.rawRequest(a,"GET",{unauthenticated:!0}).then(function(e){return e.text()})})},fetchUrls:function(e){var t="/v1/"+e+"/config/urls",n=this.id(e)
return this.ajax(t,"GET").then(function(t){return t.id=n,t.backend=e,t}).catch(function(e){if(404===e.httpStatus)return Ember.RSVP.resolve({id:n})
throw e})},fetchCrl:function(e){var t="/v1/"+e+"/config/crl",n=this.id(e)
return this.ajax(t,"GET").then(function(t){return t.id=n,t.backend=e,t}).catch(function(e){if(404===e.httpStatus)return{id:n}
throw e})},fetchTidy:function(e){var t=this.id(e)
return Ember.RSVP.resolve({id:t,backend:e})},queryRecord:function(e,t,n){var a=n.backend,s=n.section
return this.fetchSection(a,s).then(function(e){return e.backend=a,e})}})}),define("vault/adapters/pki",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",url:function(){},createRecord:function(e,t,n,a){var s=e.serializerFor(t.modelName).serialize(n,a),r=n.attr("role")
return this.ajax(this.url(r,n),"POST",{data:s}).then(function(a){a.id=n.id,a.modelName=t.modelName,e.pushPayload(t.modelName,a)})}})}),define("vault/adapters/policy",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1/sys",pathForType:function(e){return e.replace("policy","policies")},createOrUpdate:function(e,t,n){var a=e.serializerFor("policy").serialize(n),s=n.attr("name")
return this.ajax(this.buildURL(t.modelName,s),"PUT",{data:a}).then(function(){return{data:Ember.assign({},n.record.toJSON(),{id:s})}})},createRecord:function(){return this.createOrUpdate.apply(this,arguments)},updateRecord:function(){return this.createOrUpdate.apply(this,arguments)},query:function(e,t){return this.ajax(this.buildURL(t.modelName),"GET",{data:{list:!0}})}})}),define("vault/adapters/policy/acl",["exports","vault/adapters/policy"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/policy/egp",["exports","vault/adapters/policy"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/policy/rgp",["exports","vault/adapters/policy"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/adapters/requests",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({queryRecord:function(){return this.ajax(this.urlForQuery(),"GET").then(function(e){return e.id=e.request_id,e})},urlForQuery:function(){return this.buildURL()+"/internal/counters/requests"}})}),define("vault/adapters/role-aws",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",createOrUpdate:function(e,t,n,a){var s=e.serializerFor(t.modelName).serialize(n,a),r=n.id,l=this.urlForRole(n.record.get("backend"),r)
return this.ajax(l,"POST",{data:s})},createRecord:function(){return this.createOrUpdate.apply(this,arguments)},updateRecord:function(){return this.createOrUpdate.apply(this,Array.prototype.slice.call(arguments).concat(["update"]))},deleteRecord:function(e,t,n){var a=n.id
return this.ajax(this.urlForRole(n.record.get("backend"),a),"DELETE")},pathForType:function(){return"roles"},urlForRole:function(e,t){var a=this.buildURL()+"/"+(0,n.encodePath)(e)+"/roles"
return t&&(a=a+"/"+(0,n.encodePath)(t)),a},optionsForQuery:function(e){var t={}
return e||(t.list=!0),{data:t}},fetchByQuery:function(e,t){var n=t.id,a=t.backend
return this.ajax(this.urlForRole(a,n),"GET",this.optionsForQuery(n)).then(function(e){var t={id:n,name:n,backend:a}
return Ember.assign({},e,t)})},query:function(e,t,n){return this.fetchByQuery(e,n)},queryRecord:function(e,t,n){return this.fetchByQuery(e,n)}})}),define("vault/adapters/role-jwt",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
e.default=t.default.extend({router:Ember.inject.service(),findRecord:function(e,t,s,r){var l=JSON.parse(s),i=a(l,2),o=i[0],u=i[1]
o=(0,n.encodePath)(o)
var c=Ember.get(r,"adapterOptions.namespace"),d="/v1/auth/"+o+"/oidc/auth_url",m=""+window.location.origin+this.router.urlFor("vault.cluster.oidc-callback",{auth_path:o})
return c&&(m=""+window.location.origin+this.router.urlFor("vault.cluster.oidc-callback",{auth_path:o},{queryParams:{namespace:c}})),this.ajax(d,"POST",{data:{role:u,redirect_uri:m}})}})}),define("vault/adapters/role-pki",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",createOrUpdate:function(e,t,n,a){var s=e.serializerFor(t.modelName).serialize(n,a),r=n.id,l=this.urlForRole(n.record.get("backend"),r)
return this.ajax(l,"POST",{data:s})},createRecord:function(){return this.createOrUpdate.apply(this,arguments)},updateRecord:function(){return this.createOrUpdate.apply(this,Array.prototype.slice.call(arguments).concat(["update"]))},deleteRecord:function(e,t,n){var a=n.id
return this.ajax(this.urlForRole(n.record.get("backend"),a),"DELETE")},pathForType:function(){return"roles"},urlForRole:function(e,t){var a=this.buildURL()+"/"+(0,n.encodePath)(e)+"/roles"
return t&&(a=a+"/"+(0,n.encodePath)(t)),a},optionsForQuery:function(e){var t={}
return e||(t.list=!0),{data:t}},fetchByQuery:function(e,t){var n=t.id,a=t.backend
return this.ajax(this.urlForRole(a,n),"GET",this.optionsForQuery(n)).then(function(e){var t={id:n,name:n,backend:a}
return Ember.assign({},e,t)})},query:function(e,t,n){return this.fetchByQuery(e,n)},queryRecord:function(e,t,n){return this.fetchByQuery(e,n)}})}),define("vault/adapters/role-ssh",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",defaultSerializer:"role",createOrUpdate:function(e,t,n,a){var s=e.serializerFor(t.modelName).serialize(n,a),r=n.id,l=this.urlForRole(n.record.get("backend"),r)
return this.ajax(l,"POST",{data:s})},createRecord:function(){return this.createOrUpdate.apply(this,arguments)},updateRecord:function(){return this.createOrUpdate.apply(this,Array.prototype.slice.call(arguments).concat(["update"]))},deleteRecord:function(e,t,n){var a=n.id
return this.ajax(this.urlForRole(n.record.get("backend"),a),"DELETE")},pathForType:function(){return"roles"},urlForRole:function(e,t){var a=this.buildURL()+"/"+(0,n.encodePath)(e)+"/roles"
return t&&(a=a+"/"+(0,n.encodePath)(t)),a},optionsForQuery:function(e){var t={}
return e||(t.list=!0),{data:t}},fetchByQuery:function(e,t){var n=t.id,a=t.backend,s=Ember.RSVP.resolve(),r=this.ajax(this.urlForRole(a,n),"GET",this.optionsForQuery(n))
return n||(s=this.findAllZeroAddress(e,t)),Ember.RSVP.allSettled([r,s]).then(function(e){if(!e[0].value)throw e[0].reason
var t={id:n,name:n,backend:a,data:{}}
return e.forEach(function(e){e.value&&(e.value.data.roles?t.data=Ember.assign({},t.data,{zero_address_roles:e.value.data.roles}):t.data=Ember.assign({},t.data,e.value.data))}),t})},findAllZeroAddress:function(e,t){var a=t.backend,s="/v1/"+(0,n.encodePath)(a)+"/config/zeroaddress"
return this.ajax(s,"GET")},query:function(e,t,n){return this.fetchByQuery(e,n)},queryRecord:function(e,t,n){return this.fetchByQuery(e,n)}})}),define("vault/adapters/secret-engine",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({url:function(e){var t=this.buildURL()+"/mounts"
return e?t+"/"+(0,n.encodePath)(e):t},internalURL:function(e){var t="/"+this.urlPrefix()+"/internal/ui/mounts"
return e&&(t=t+"/"+(0,n.encodePath)(e)),t},pathForType:function(){return"mounts"},query:function(e,t,n){return this.ajax(this.internalURL(n.path),"GET")},createRecord:function(e,t,n){var a=e.serializerFor(t.modelName).serialize(n),s=n.attr("path")
return this.ajax(this.url(s),"POST",{data:a}).then(function(){return{data:Ember.assign({},a,{path:s+"/",id:s})}})},findRecord:function(e,t,a,s){if("ssh"===s.attr("type"))return this.ajax("/v1/"+(0,n.encodePath)(a)+"/config/ca","GET")},queryRecord:function(e,t,a){if("aws"===a.type)return this.ajax("/v1/"+(0,n.encodePath)(a.backend)+"/config/lease","GET").then(function(e){return e.path=a.backend+"/",e})},updateRecord:function(e,t,a){var s=a.adapterOptions,r=s.apiPath,l=s.options,i=s.adapterMethod
if(i)return this[i].apply(this,arguments)
if(r){var o=e.serializerFor(t.modelName).serialize(a),u=(0,n.encodePath)(a.id)
return this.ajax("/v1/"+u+"/"+r,l.isDelete?"DELETE":"POST",{data:o})}},saveAWSRoot:function(e,t,a){var s=a.adapterOptions.data,r=(0,n.encodePath)(a.id)
return this.ajax("/v1/"+r+"/config/root","POST",{data:s})},saveAWSLease:function(e,t,a){var s=a.adapterOptions.data,r=(0,n.encodePath)(a.id)
return this.ajax("/v1/"+r+"/config/lease","POST",{data:s})},saveZeroAddressConfig:function(e,t,a){var s=(0,n.encodePath)(a.id),r=e.peekAll("role-ssh").filterBy("zeroAddress").mapBy("id").join(","),l="/v1/"+s+"/config/zeroaddress",i={roles:r}
return""===r?this.ajax(l,"DELETE"):this.ajax(l,"POST",{data:i})}})}),define("vault/adapters/secret-v2-version",["exports","vault/adapters/application","ember-data","vault/utils/path-encoding-helpers","vault/lib/control-group-error"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
e.default=t.default.extend({namespace:"v1",_url:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"data",s=this.buildURL()+"/"+(0,a.encodePath)(e)+"/"+n+"/"
return Ember.isEmpty(t)||(s+=(0,a.encodePath)(t)),s},urlForFindRecord:function(e){var t=JSON.parse(e),n=r(t,3),a=n[0],s=n[1],l=n[2],i=this._url(a,s)
return l?i+"?version="+l:i},urlForQueryRecord:function(e){return this.urlForFindRecord(e)},findRecord:function(){return this._super.apply(this,arguments).catch(function(e){if(e instanceof n.default.AdapterError)throw e
return e})},queryRecord:function(e,t){return this.ajax(this.urlForQueryRecord(e),"GET",t).then(function(n){return t.wrapTTL?n:(n.id=e,n.backend=backend,n)})},urlForCreateRecord:function(e,t){var n=t.belongsTo("secret").belongsTo("engine").id,a=t.attr("path")
return this._url(n,a)},createRecord:function(e,t,n){var a=n.belongsTo("secret").belongsTo("engine").id,s=n.attr("path")
return this._super.apply(this,arguments).then(function(e){return e.id=JSON.stringify([a,s,e.version]),e})},urlForUpdateRecord:function(e){var t=JSON.parse(e),n=r(t,2),a=n[0],s=n[1]
return this._url(a,s)},v2DeleteOperation:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"delete",a=JSON.parse(t),s=r(a,3),l=s[0],i=s[1],o=s[2]
return this.ajax(this._url(l,i,n),"POST",{data:{versions:[o]}}).then(function(){var n=e.peekRecord("secret-v2-version",t)
return n&&n.rollbackAttributes()&&n.reload()})},handleResponse:function(e,t,n,a){return 404===e&&Ember.get(n,"data.metadata")?this._super(200,t,n,a):this._super.apply(this,arguments)}})}),define("vault/adapters/secret-v2",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",_url:function(e,t){var a=this.buildURL()+"/"+(0,n.encodePath)(e)+"/metadata/"
return Ember.isEmpty(t)||(a+=(0,n.encodePath)(t)),a},query:function(e,t,n){var a=n.backend,s=n.id
return this.ajax(this._url(a,s),"GET",{data:{list:!0}}).then(function(e){return e.id=s,e.backend=a,e})},urlForQueryRecord:function(e){var t=e.id,n=e.backend
return this._url(n,t)},queryRecord:function(e,t,n){var a=n.backend,s=n.id
return this.ajax(this._url(a,s),"GET").then(function(e){return e.id=s,e.backend=a,e})},detailURL:function(e){var t=e.belongsTo("engine",{id:!0})||e.attr("engineId"),n=e.id
return this._url(t,n)},urlForUpdateRecord:function(e,t,n){return this.detailURL(n)},urlForCreateRecord:function(e,t){return this.detailURL(t)},urlForDeleteRecord:function(e,t,n){return this.detailURL(n)}})}),define("vault/adapters/secret",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",createOrUpdate:function(e,t,n){var a=e.serializerFor(t.modelName).serialize(n),s=n.id
return this.ajax(this.urlForSecret(n.attr("backend"),s),"POST",{data:a})},createRecord:function(){return this.createOrUpdate.apply(this,arguments)},updateRecord:function(){return this.createOrUpdate.apply(this,arguments)},deleteRecord:function(e,t,n){var a=n.id
return this.ajax(this.urlForSecret(n.attr("backend"),a),"DELETE")},urlForSecret:function(e,t){var a=this.buildURL()+"/"+(0,n.encodePath)(e)+"/"
return Ember.isEmpty(t)||(a+=(0,n.encodePath)(t)),a},pathForType:function(){return"mounts"},optionsForQuery:function(e,t,n){var a={}
return"query"===t&&(a.list=!0),n?{data:a,wrapTTL:n}:{data:a}},fetchByQuery:function(e,t){var n=e.id,a=e.backend,s=e.wrapTTL
return this.ajax(this.urlForSecret(a,n),"GET",this.optionsForQuery(n,t,s)).then(function(e){return s?e:(e.id=n,e.backend=a,e)})},query:function(e,t,n){return this.fetchByQuery(n,"query")},queryRecord:function(e,t,n){return this.fetchByQuery(n,"queryRecord")}})}),define("vault/adapters/ssh-otp-credential",["exports","vault/adapters/ssh"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({url:function(e){return"/v1/"+e.backend+"/creds/"+e.name}})})
define("vault/adapters/ssh-sign",["exports","vault/adapters/ssh"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({url:function(e){return"/v1/"+e.backend+"/sign/"+e.name}})}),define("vault/adapters/ssh",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({namespace:"v1",defaultSerializer:"ssh",url:function(){},createRecord:function(e,t,n,a){var s=e.serializerFor(t.modelName).serialize(n,a),r=n.attr("role")
return this.ajax(this.url(r),"POST",{data:s}).then(function(a){a.id=n.id,a.modelName=t.modelName,e.pushPayload(t.modelName,a)})}})}),define("vault/adapters/tools",["exports","vault/adapters/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=["lookup","wrap","unwrap","rewrap"],a=["random","hash"]
e.default=t.default.extend({toolUrlFor:function(e){var t=n.includes(e),s=a.includes(e),r=t?"wrapping":"tools"
if(!t&&!s)throw new Error("Calls to a "+e+" endpoint are not currently allowed in the tool adapter")
return this.buildURL()+"/"+r+"/"+e},toolAction:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=n.wrapTTL,s=n.clientToken,r=this.toolUrlFor(e),l=a?{data:t,wrapTTL:a,clientToken:s}:{data:t,clientToken:s}
return this.ajax(r,"POST",l)}})}),define("vault/adapters/transit-key",["exports","vault/adapters/application","ember-inflector","vault/utils/path-encoding-helpers"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
e.default=t.default.extend({namespace:"v1",createOrUpdate:function(e,t,n,a){var s=e.serializerFor(t.modelName).serialize(n,a),r=n.id,l=this.urlForSecret(n.record.get("backend"),r)
return"update"===a&&(l+="/config"),this.ajax(l,"POST",{data:s})},createRecord:function(){return this.createOrUpdate.apply(this,arguments)},updateRecord:function(){return this.createOrUpdate.apply(this,Array.prototype.slice.call(arguments).concat(["update"]))},deleteRecord:function(e,t,n){var a=n.id
return this.ajax(this.urlForSecret(n.record.get("backend"),a),"DELETE")},pathForType:function(e){var t=void 0
switch(e){case"cluster":t="clusters"
break
case"secret-engine":t="secrets"
break
default:t=(0,n.pluralize)(e)}return t},urlForSecret:function(e,t){var n=this.buildURL()+"/"+(0,a.encodePath)(e)+"/keys/"
return t&&(n+=(0,a.encodePath)(t)),n},urlForAction:function(e,t,n,r){var l=this.buildURL()+"/"+(0,a.encodePath)(t)+"/"+e
if("hash"===e||"random"===e)return l
if("datakey"===e&&r)return l+"/"+r+"/"+(0,a.encodePath)(n)
if("export"===e&&r){var i=s(r,2),o=i[0],u=i[1],c=l+"/"+o+"-key/"+(0,a.encodePath)(n)
return u?c+"/"+u:c}return l+"/"+(0,a.encodePath)(n)},optionsForQuery:function(e){var t={}
return e||(t.list=!0),{data:t}},fetchByQuery:function(e){var t=e.id,n=e.backend
return this.ajax(this.urlForSecret(n,t),"GET",this.optionsForQuery(t)).then(function(e){return e.id=t,e})},query:function(e,t,n){return this.fetchByQuery(n)},queryRecord:function(e,t,n){return this.fetchByQuery(n)},keyAction:function(e,t){var n=t.backend,a=t.id,s=t.payload,r="export"===e?"GET":"POST",l=(arguments.length>2&&void 0!==arguments[2]?arguments[2]:{}).wrapTTL
if("rotate"===e)return this.ajax(this.urlForSecret(n,a)+"/rotate",r)
var i=s.param
return delete s.param,this.ajax(this.urlForAction(e,n,a,i),r,{data:s,wrapTTL:l})}})}),define("vault/app",["exports","vault/resolver","ember-load-initializers","vault/config/environment","ember-concurrency-test-waiter/define-modifier"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0}),(0,s.default)()
var r
r=Ember.Application.extend({modulePrefix:a.default.modulePrefix,podModulePrefix:a.default.podModulePrefix,Resolver:t.default,engines:{openApiExplorer:{dependencies:{services:["auth","flash-messages","namespace","router","version"]}},replication:{dependencies:{services:["auth","flash-messages","namespace","replication-mode","router","store","version","wizard"]}},kmip:{dependencies:{services:["auth","flash-messages","namespace","path-help","router","store","version","wizard","secret-mount-path"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}}}}),(0,n.default)(r,a.default.modulePrefix),e.default=r}),define("vault/breakpoints",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default={mobile:"(max-width: 768px)",tablet:"(min-width: 769px)",desktop:"(min-width: 1088px)"}}),define("vault/components/alert-banner",["exports","core/components/alert-banner"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/alert-inline",["exports","core/components/alert-inline"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/alert-popup",["exports","vault/components/outer-html"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({type:null,message:null,close:null})}),define("vault/components/auth-config-form/config",["exports","ember-concurrency","ember-data"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=Ember.Component.extend({tagName:"",model:null,flashMessages:Ember.inject.service(),router:Ember.inject.service(),wizard:Ember.inject.service(),saveModel:(0,t.task)(regeneratorRuntime.mark(function e(){return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.prev=0,e.next=3,this.model.save()
case 3:e.next=10
break
case 5:if(e.prev=5,e.t0=e.catch(0),e.t0 instanceof n.default.AdapterError!=!1){e.next=9
break}throw e.t0
case 9:return e.abrupt("return")
case 10:"authentication"===this.wizard.currentMachine&&"config"===this.wizard.featureState&&this.wizard.transitionFeatureMachine(this.wizard.featureState,"CONTINUE"),this.router.transitionTo("vault.cluster.access.methods").followRedirects(),this.flashMessages.success("The configuration was saved successfully.")
case 13:case"end":return e.stop()}},e,this,[[0,5]])})).withTestWaiter()})
a.reopenClass({positionalParams:["model"]}),e.default=a}),define("vault/components/auth-config-form/options",["exports","vault/components/auth-config-form/config","ember-concurrency","ember-data"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({router:Ember.inject.service(),wizard:Ember.inject.service(),saveModel:(0,n.task)(regeneratorRuntime.mark(function e(){var t
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return(t=this.model.config.serialize()).description=this.model.description,e.prev=2,e.next=5,this.model.tune(t)
case 5:e.next=12
break
case 7:if(e.prev=7,e.t0=e.catch(2),e.t0 instanceof a.default.AdapterError!=!1){e.next=11
break}throw e.t0
case 11:return e.abrupt("return")
case 12:"authentication"===this.wizard.currentMachine&&"config"===this.wizard.featureState&&this.wizard.transitionFeatureMachine(this.wizard.featureState,"CONTINUE"),this.router.transitionTo("vault.cluster.access.methods").followRedirects(),this.flashMessages.success("The configuration was saved successfully.")
case 15:case"end":return e.stop()}},e,this,[[2,7]])})).withTestWaiter()})}),define("vault/components/auth-form",["exports","vault/helpers/supported-auth-backends","ember-concurrency"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=(0,t.supportedAuthBackends)(),s={token:null,username:null,password:null,customPath:null}
e.default=Ember.Component.extend(s,{router:Ember.inject.service(),auth:Ember.inject.service(),flashMessages:Ember.inject.service(),store:Ember.inject.service(),csp:Ember.inject.service("csp-event"),selectedAuth:null,methods:null,cluster:null,redirectTo:null,namespace:null,wrappedToken:null,oldNamespace:null,didReceiveAttrs:function(){this._super.apply(this,arguments)
var e=this.get("wrappedToken"),t=this.get("selectedAuth"),n=this.get("oldSelectedAuth"),a=this.get("namespace"),s=this.get("oldNamespace")
null!==s&&s===a||this.get("fetchMethods").perform(),this.set("oldNamespace",a),n&&n!==t&&this.resetDefaults(),this.set("oldSelectedAuth",t),e&&this.get("unwrapToken").perform(e)},didRender:function(){this._super.apply(this,arguments)
var e=this.firstMethod(),t=this.element.querySelector("li.is-active")
t&&t.scrollIntoView(),(this.get("fetchMethods.isIdle")&&e&&!this.get("selectedAuth")||this.get("selectedAuth")&&!this.get("selectedAuthBackend"))&&this.set("selectedAuth",e)},firstMethod:function(){var e=this.get("methodsToShow.firstObject")
if(e)return Ember.get(e,"path")||Ember.get(e,"type")},resetDefaults:function(){this.setProperties(s)},selectedAuthIsPath:Ember.computed.match("selectedAuth",/\/$/),selectedAuthBackend:Ember.computed("methods","methods.[]","selectedAuth","selectedAuthIsPath",function(){var e=this.get("methods"),t=this.get("selectedAuth"),n=this.get("selectedAuthIsPath")
return e?n?e.findBy("path",t):a.findBy("type",t):{}}),providerPartialName:Ember.computed("selectedAuthBackend",function(){var e=this.get("selectedAuthBackend.type")||"token"
return e=e.toLowerCase(),"partials/auth-form/"+Ember.String.dasherize(e)}),hasCSPError:Ember.computed.alias("csp.connectionViolations.firstObject"),cspErrorText:"This is a standby Vault node but can't communicate with the active node via request forwarding. Sign in at the active node to use the Vault UI.",allSupportedMethods:Ember.computed("methodsToShow","hasMethodsWithPath",function(){var e=this.get("hasMethodsWithPath"),t=this.get("methodsToShow")
return e?t.concat(a):t}),hasMethodsWithPath:Ember.computed("methodsToShow",function(){return this.get("methodsToShow").isAny("path")}),methodsToShow:Ember.computed("methods",function(){var e=(this.get("methods")||[]).filter(function(e){return a.find(function(t){return Ember.get(t,"type").toLowerCase()===Ember.get(e,"type").toLowerCase()})})
return e.length?e:a}),unwrapToken:(0,n.task)(regeneratorRuntime.mark(function e(t){var n,a,s=this
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return this.set("selectedAuth","token"),n=this.get("store").adapterFor("tools"),e.prev=2,e.next=5,n.toolAction("unwrap",null,{clientToken:t})
case 5:a=e.sent,this.set("token",a.auth.client_token),Ember.run.next(function(){s.send("doSubmit")}),e.next=13
break
case 10:e.prev=10,e.t0=e.catch(2),this.set("error","Token unwrap failed: "+e.t0.errors[0])
case 13:case"end":return e.stop()}},e,this,[[2,10]])})).withTestWaiter(),fetchMethods:(0,n.task)(regeneratorRuntime.mark(function e(){var t,n
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return t=this.get("store"),e.prev=1,e.next=4,t.findAll("auth-method",{adapterOptions:{unauthenticated:!0}})
case 4:n=e.sent,this.set("methods",n.map(function(e){return e.serialize({includeId:!0})})),Ember.run.next(function(){t.unloadAll("auth-method")}),e.next=12
break
case 9:e.prev=9,e.t0=e.catch(1),this.set("error","There was an error fetching Auth Methods: "+e.t0.errors[0])
case 12:case"end":return e.stop()}},e,this,[[1,9]])})).withTestWaiter(),showLoading:Ember.computed.or("isLoading","authenticate.isRunning","fetchMethods.isRunning","unwrapToken.isRunning"),handleError:function(e){var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1]
this.set("loading",!1)
var n=void 0
n=e.errors?e.errors.map(function(e){return e.detail?e.detail:e}):[e]
var a=t?"Authentication failed: ":""
this.set("error",""+a+n.join("."))},authenticate:(0,n.task)(regeneratorRuntime.mark(function e(t,n){var a,s,r,l,i,o,u=this
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return a=this.cluster.id,e.prev=1,e.next=4,this.auth.authenticate({clusterId:a,backend:t,data:n})
case 4:return s=e.sent,r=s.isRoot,l=s.namespace,i=void 0,(o=this.redirectTo)?(this.set("redirectTo",""),i=this.router.transitionTo(o)):i=this.router.transitionTo("vault.cluster",{queryParams:{namespace:l}}),e.next=11,i.followRedirects().then(function(){r&&u.flashMessages.warning("You have logged in with a root token. As a security precaution, this root token will not be stored by your browser and you will need to re-authenticate after the window is closed or refreshed.")})
case 11:e.next=16
break
case 13:e.prev=13,e.t0=e.catch(1),this.handleError(e.t0)
case 16:case"end":return e.stop()}},e,this,[[1,13]])})).withTestWaiter(),actions:{doSubmit:function(){var e=void 0,t=void 0
if(arguments.length>1){var n=Array.prototype.slice.call(arguments)
e=n[0],t=n[1]}else{t=Array.prototype.slice.call(arguments)[0]}t&&t.preventDefault()
var s={}
this.setProperties({error:null})
var r=this.get("selectedAuthBackend")||{},l=a.find(function(e){return(Ember.get(e,"type")||"").toLowerCase()===(Ember.get(r,"type")||"").toLowerCase()}),i=Ember.get(l||{},"formAttributes")||{}
return s=Ember.assign(s,this.getProperties.apply(this,function(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}(i))),e&&(s=Ember.assign(s,e)),(this.get("customPath")||Ember.get(r,"id"))&&(s.path=this.get("customPath")||Ember.get(r,"id")),this.authenticate.unlinked().perform(r.type,s)},handleError:function(e){e?this.handleError(e,!1):this.set("error",null)}}})}),define("vault/components/auth-info",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({auth:Ember.inject.service(),wizard:Ember.inject.service(),router:Ember.inject.service(),version:Ember.inject.service(),transitionToRoute:function(){var e;(e=this.get("router")).transitionTo.apply(e,arguments)},classNames:"user-menu auth-info",isRenewing:Ember.computed.or("fakeRenew","auth.isRenewing"),canExpire:Ember.computed.alias("auth.allowExpiration"),isOSS:Ember.computed.alias("version.isOSS"),actions:{restartGuide:function(){this.get("wizard").restartGuide()},renewToken:function(){var e=this
this.set("fakeRenew",!0),Ember.run.later(function(){e.set("fakeRenew",!1),e.get("auth").renew()},200)},revokeToken:function(){var e=this
this.get("auth").revokeCurrentToken().then(function(){e.transitionToRoute("vault.cluster.logout")})}}})}),define("vault/components/auth-jwt",["exports","vault/components/outer-html","ember-concurrency"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.ERROR_MISSING_PARAMS=e.ERROR_WINDOW_CLOSED=void 0
var a=Ember.testing?0:500,s="The provider window was closed before authentication was complete.  Please click Sign In to try again.",r="The callback from the provider did not supply all of the required parameters.  Please click Sign In to try again. If the problem persists, you may want to contact your administrator."
e.ERROR_WINDOW_CLOSED=s,e.ERROR_MISSING_PARAMS=r,e.default=t.default.extend({store:Ember.inject.service(),selectedAuthPath:null,selectedAuthType:null,roleName:null,role:null,onRoleName:function(){},onLoading:function(){},onError:function(){},onToken:function(){},onNamespace:function(){},didReceiveAttrs:function(){var e=this.oldSelectedAuthPath,t=this.selectedAuthPath,n=!e&&!t
e!==t?(this.set("role",null),this.onRoleName(this.roleName),this.fetchRole.perform(null,{debounce:!1})):n&&this.fetchRole.perform(this.roleName),this.set("oldSelectedAuthPath",t)},isOIDC:Ember.computed("role","role.authUrl",function(){return this.role&&this.role.authUrl}),getWindow:function(){return this.window||window},fetchRole:(0,n.task)(regeneratorRuntime.mark(function e(t){var s,r,l,i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{debounce:!0}
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(!i.debounce){e.next=4
break}return this.onRoleName(t),e.next=4,(0,n.timeout)(a)
case 4:return s=this.selectedAuthPath||this.selectedAuthType,r=JSON.stringify([s,t]),l=null,e.prev=7,e.next=10,this.store.findRecord("role-jwt",r,{adapterOptions:{namespace:this.namespace}})
case 10:l=e.sent,e.next=17
break
case 13:if(e.prev=13,e.t0=e.catch(7),e.t0.httpStatus&&400===e.t0.httpStatus){e.next=17
break}throw e.t0
case 17:this.set("role",l)
case 18:case"end":return e.stop()}},e,this,[[7,13]])})).restartable().withTestWaiter(),handleOIDCError:function(e){this.onLoading(!1),this.prepareForOIDC.cancelAll(),this.onError(e)},prepareForOIDC:(0,n.task)(regeneratorRuntime.mark(function e(t){var a
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return this.onLoading(!0),this.watchPopup.perform(t),this.watchCurrent.perform(t),e.next=5,(0,n.waitForEvent)(this.getWindow(),"storage")
case 5:a=e.sent,this.exchangeOIDC.perform(a,t)
case 7:case"end":return e.stop()}},e,this)})),watchPopup:(0,n.task)(regeneratorRuntime.mark(function e(t){return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=3,(0,n.timeout)(a)
case 3:if(t&&!t.closed){e.next=5
break}return e.abrupt("return",this.handleOIDCError(s))
case 5:e.next=0
break
case 7:case"end":return e.stop()}},e,this)})),watchCurrent:(0,n.task)(regeneratorRuntime.mark(function e(t){return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,(0,n.waitForEvent)(this.getWindow(),"beforeunload")
case 2:t.close()
case 3:case"end":return e.stop()}},e,this)})),closeWindow:function(e){this.watchPopup.cancelAll(),this.watchCurrent.cancelAll(),e.close()},exchangeOIDC:(0,n.task)(regeneratorRuntime.mark(function e(t,n){var s,l,i,o,u,c,d,m,p=this
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if("oidcState"===t.key){e.next=2
break}return e.abrupt("return")
case 2:if(this.onLoading(!0),s=JSON.parse(t.newValue),l=s.namespace,i=s.path,o=s.state,u=s.code,this.getWindow().localStorage.removeItem("oidcState"),Ember.run.later(function(){p.closeWindow(n)},a),i&&o&&u){e.next=8
break}return e.abrupt("return",this.handleOIDCError(r))
case 8:return c=this.store.adapterFor("auth-method"),this.onNamespace(l),d=void 0,e.prev=11,e.next=14,c.exchangeOIDC(i,o,u)
case 14:d=e.sent,e.next=20
break
case 17:return e.prev=17,e.t0=e.catch(11),e.abrupt("return",this.handleOIDCError(e.t0))
case 20:return m=d.auth.client_token,this.onSelectedAuth("token"),this.onToken(m),e.next=25,this.onSubmit()
case 25:case"end":return e.stop()}},e,this,[[11,17]])})),actions:{startOIDCAuth:function(){var e,t=(e=regeneratorRuntime.mark(function e(t,n){var a,s,r,l
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(this.onError(null),n&&n.preventDefault&&n.preventDefault(),this.isOIDC){e.next=4
break}return e.abrupt("return")
case 4:return e.next=6,this.fetchRole.perform(this.roleName,{debounce:!1})
case 6:a=this.getWindow(),500,600,s=a.screen.width/2-250,r=a.screen.height/2-300,l=a.open(this.role.authUrl,"vaultOIDCWindow","width=500,height=600,resizable,scrollbars=yes,top="+r+",left="+s),this.prepareForOIDC.perform(l)
case 13:case"end":return e.stop()}},e,this)}),function(){var t=e.apply(this,arguments)
return new Promise(function(e,n){return function a(s,r){try{var l=t[s](r),i=l.value}catch(e){return void n(e)}if(!l.done)return Promise.resolve(i).then(function(e){a("next",e)},function(e){a("throw",e)})
e(i)}("next")})})
return function(e,n){return t.apply(this,arguments)}}()}})}),define("vault/components/b64-toggle",["exports","vault/utils/b64"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n="base64",a="utf-8"
e.default=Ember.Component.extend({tagName:"button",attributeBindings:["type"],type:"button",classNames:["button","b64-toggle"],classNameBindings:["isInput:is-input:is-textarea"],isInput:!0,value:null,initialEncoding:a,_value:"",currentEncoding:"",lastEncoding:"",isBase64:Ember.computed.equal("currentEncoding",n),valuesMatch:Ember.computed("value","_value",function(){var e=this.getProperties("value","_value"),t=e.value,n=e._value
return!(Ember.isBlank(t)||Ember.isBlank(n))&&t===n}),init:function(){this._super.apply(this,arguments)
var e=Ember.get(this,"initialEncoding")
Ember.set(this,"currentEncoding",e),e===n&&(Ember.set(this,"_value",Ember.get(this,"value")),Ember.set(this,"lastEncoding",n))},didReceiveAttrs:function(){""!==Ember.get(this,"value")?(Ember.get(this,"isBase64")&&!Ember.get(this,"valuesMatch")&&Ember.set(this,"currentEncoding",a),Ember.get(this,"lastEncoding")===n&&Ember.get(this,"valuesMatch")&&Ember.set(this,"currentEncoding",n)):Ember.set(this,"currentEncoding",a)},click:function(){var e=Ember.get(this,"value"),s=Ember.get(this,"currentEncoding")===a
if(e){var r=s?(0,t.encodeString)(e):(0,t.decodeString)(e),l=s?n:a
Ember.set(this,"value",r),Ember.set(this,"_value",r),Ember.set(this,"lastEncoding",l),Ember.set(this,"currentEncoding",l)}}})}),define("vault/components/basic-dropdown-hover",["exports","ember-basic-dropdown-hover/components/basic-dropdown-hover"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/basic-dropdown",["exports","ember-basic-dropdown/components/basic-dropdown"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/basic-dropdown/content-element",["exports","ember-basic-dropdown/components/basic-dropdown/content-element"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/basic-dropdown/content",["exports","ember-basic-dropdown/components/basic-dropdown/content"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/basic-dropdown/trigger",["exports","ember-basic-dropdown/components/basic-dropdown/trigger"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({attributeBindings:["type"]})}),define("vault/components/block-error",["exports","vault/components/outer-html"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/components/chevron",["exports","core/components/chevron"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/config-pki-ca",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({classNames:"config-pki-ca",store:Ember.inject.service("store"),flashMessages:Ember.inject.service(),replaceCA:!1,setSignedIntermediate:!1,signIntermediate:!1,needsConfig:Ember.computed.not("config.pem"),model:null,config:null,onRefresh:function(){},loading:!1,willDestroy:function(){var e=this.get("model")
e&&e.unloadRecord(),this._super.apply(this,arguments)},createOrReplaceModel:function(e){var t=this.get("model"),n=this.get("config"),a=this.get("store"),s=n.get("backend")
t&&t.unloadRecord()
var r=a.createRecord(e||"pki-ca-certificate",{id:s+"-ca-cert",backend:s})
this.set("model",r)},downloadHrefs:Ember.computed("config","config.{backend,pem,caChain,der}",function(){var e=this.get("config").getProperties("backend","pem","caChain","der"),t=e.backend,n=e.pem,a=e.caChain,s=e.der
if(!n)return[]
var r=new Blob([n],{type:"text/plain"}),l=[{display:"Download CA Certificate in PEM format",name:t+"_ca.pem",url:URL.createObjectURL(r)},{display:"Download CA Certificate in DER format",name:t+"_ca.der",url:URL.createObjectURL(s)}]
if(a){var i=new Blob([a],{type:"text/plain"})
l.push({display:"Download CA Certificate Chain",name:t+"_ca_chain.pem",url:URL.createObjectURL(i)})}return l}),actions:{saveCA:function(e){var t=this
this.set("loading",!0)
var n=this.get("model"),a=this.get("model.uploadPemBundle")
n.save({adapterOptions:{method:e}}).then(function(n){"setSignedIntermediate"===e||a?(t.send("refresh"),t.get("flashMessages").success("The certificate for this backend has been updated.")):n.get("certificate")||n.get("csr")||t.get("flashMessages").warning("You tried to generate a new root CA, but one currently exists. To replace the existing one, delete it first and then generate again.")}).catch(function(){}).finally(function(){t.set("loading",!1)})},deleteCA:function(){var e=this
this.set("loading",!0)
var t=this.get("model"),n=t.get("backend")
t.send("pushedData"),t.destroyRecord().then(function(){e.get("flashMessages").success("The CA key for "+n+" has been deleted. The old CA certificate will still be accessible for reading until a new certificate/key are generated or uploaded.")}).finally(function(){e.set("loading",!1),e.send("refresh"),e.createOrReplaceModel()})},refresh:function(){this.setProperties({setSignedIntermediate:!1,signIntermediate:!1,replaceCA:!1}),this.get("onRefresh")()},toggleReplaceCA:function(){this.get("replaceCA")||this.createOrReplaceModel(),this.toggleProperty("replaceCA")},toggleVal:function(e,t){if(e){var n="signIntermediate"===e?"pki-ca-certificate-sign":null
this.get(e)||this.createOrReplaceModel(n),void 0!==t?this.set(e,t):this.toggleProperty(e)}}}})}),define("vault/components/config-pki",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({classNames:"config-pki",flashMessages:Ember.inject.service(),section:null,config:null,onRefresh:function(){},loading:!1,actions:{save:function(e){var t=this
this.set("loading",!0)
var n=this.get("config")
n.save({adapterOptions:{method:e,fields:Ember.get(n,e+"Attrs").map(function(e){return e.name})}}).then(function(){t.get("flashMessages").success("The "+e+" config for this backend has been updated."),"tidy"===e&&n.rollbackAttributes(),t.send("refresh")}).catch(function(){}).finally(function(){t.set("loading",!1)})},refresh:function(){this.get("onRefresh")()}}})}),define("vault/components/confirm-action",["exports","core/components/confirm-action"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/console/command-input",["exports","vault/lib/keycodes"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({onExecuteCommand:function(){},onFullscreen:function(){},onValueUpdate:function(){},onShiftCommand:function(){},value:null,isFullscreen:null,actions:{handleKeyUp:function(e){var n=e.keyCode
switch(n){case t.default.ENTER:this.get("onExecuteCommand")(e.target.value)
break
case t.default.UP:case t.default.DOWN:this.get("onShiftCommand")(n)
break
default:this.get("onValueUpdate")(e.target.value)}},fullscreen:function(){this.get("onFullscreen")()}}})}),define("vault/components/console/log-command",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({})}),define("vault/components/console/log-error",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({})}),define("vault/components/console/log-help",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({})}),define("vault/components/console/log-json",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({})})
define("vault/components/console/log-list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({content:null,list:Ember.computed("content",function(){return this.get("content").keys})})}),define("vault/components/console/log-object",["exports","columnify"],function(e,t){function n(e){Object.keys(e).forEach(function(t){var n=e[t]
"string"!=typeof n&&(n=JSON.stringify(n)),e[t]=n})}Object.defineProperty(e,"__esModule",{value:!0}),e.stringifyObjectValues=n,e.default=Ember.Component.extend({content:null,columns:Ember.computed("content",function(){var e=this.get("content")
return n(e),(0,t.default)(e,{preserveNewLines:!0,headingTransform:function(e){return Ember.String.capitalize(e)}})})})}),define("vault/components/console/log-success",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({})}),define("vault/components/console/log-text",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({})}),define("vault/components/console/output-log",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({log:null})}),define("vault/components/console/ui-panel",["exports","ember-concurrency","vault/lib/control-group-error","vault/lib/console-helpers"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
e.default=Ember.Component.extend({console:Ember.inject.service(),router:Ember.inject.service(),controlGroup:Ember.inject.service(),store:Ember.inject.service(),classNames:"console-ui-panel",classNameBindings:["isFullscreen:fullscreen"],isFullscreen:!1,inputValue:null,log:Ember.computed.alias("console.log"),didRender:function(){this._super.apply(this,arguments),this.scrollToBottom()},logAndOutput:function(e,t){var n=this
this.get("console").logAndOutput(e,t),Ember.run.schedule("afterRender",function(){return n.scrollToBottom()})},isRunning:Ember.computed.or("executeCommand.isRunning","refreshRoute.isRunning"),executeCommand:(0,t.task)(regeneratorRuntime.mark(function e(t){var r,l,i,o,u,c,d,m,p,f,h,b,v=this,y=arguments.length>1&&void 0!==arguments[1]&&arguments[1]
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(this.set("inputValue",""),r=this.get("console"),l=void 0,!(0,a.executeUICommand)(t,function(e){return v.logAndOutput(e)},{api:function(){return v.routeToExplore.perform(t)},clearall:function(){return r.clearLog(!0)},clear:function(){return r.clearLog()},fullscreen:function(){return v.toggleProperty("isFullscreen")},refresh:function(){return v.refreshRoute.perform()}})){e.next=5
break}return e.abrupt("return")
case 5:e.prev=5,l=(0,a.parseCommand)(t,y),e.next=13
break
case 9:return e.prev=9,e.t0=e.catch(5),this.logAndOutput(t,{type:"help"}),e.abrupt("return")
case 13:if(!1!==l){e.next=15
break}return e.abrupt("return")
case 15:if(i=s(l,4),o=i[0],u=i[1],c=i[2],((d=i[3])||u)&&(m=(0,a.extractDataAndFlags)(d,u),p=m.data,f=m.flags),!(h=(0,a.logErrorFromInput)(c,o,f,d))){e.next=21
break}return this.logAndOutput(t,h),e.abrupt("return")
case 21:return e.prev=21,e.next=24,r[o].call(r,c,p,f.wrapTTL)
case 24:b=e.sent,this.logAndOutput(t,(0,a.logFromResponse)(b,c,o,f)),e.next=33
break
case 28:if(e.prev=28,e.t1=e.catch(21),!(e.t1 instanceof n.default)){e.next=32
break}return e.abrupt("return",this.logAndOutput(t,this.get("controlGroup").logFromError(e.t1)))
case 32:this.logAndOutput(t,(0,a.logFromError)(e.t1,c,o))
case 33:case"end":return e.stop()}},e,this,[[5,9],[21,28]])})),refreshRoute:(0,t.task)(regeneratorRuntime.mark(function e(){var t,n,a
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return t=Ember.getOwner(this),n=this.get("router.currentRouteName"),a=t.lookup("route:"+n),e.prev=3,this.get("store").clearAllDatasets(),e.next=7,a.refresh()
case 7:this.logAndOutput(null,{type:"success",content:"The current screen has been refreshed!"}),e.next=13
break
case 10:e.prev=10,e.t0=e.catch(3),this.logAndOutput(null,{type:"error",content:"The was a problem refreshing the current screen."})
case 13:case"end":return e.stop()}},e,this,[[3,10]])})),routeToExplore:(0,t.task)(regeneratorRuntime.mark(function e(t){var n,a
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return n=t.replace("api","").trim(),e.prev=1,e.next=4,this.router.transitionTo("vault.cluster.open-api-explorer.index",{queryParams:{filter:n}})
case 4:a="Welcome to the Vault API explorer! \nYou can search for endpoints, see what parameters they accept, and even execute requests with your current token.",n&&(a="Welcome to the Vault API explorer! \nWe've filtered the list of endpoints for '"+n+"'."),this.logAndOutput(null,{type:"success",content:a}),e.next=12
break
case 9:e.prev=9,e.t0=e.catch(1),this.logAndOutput(null,{type:"error",content:"There was a problem navigating to the api explorer."})
case 12:case"end":return e.stop()}},e,this,[[1,9]])})),shiftCommandIndex:function(e){var t=this
this.get("console").shiftCommandIndex(e,function(e){t.set("inputValue",e)})},scrollToBottom:function(){this.element.scrollTop=this.element.scrollHeight},actions:{closeConsole:function(){this.set("console.isOpen",!1)},toggleFullscreen:function(){this.toggleProperty("isFullscreen")},executeCommand:function(e){this.get("executeCommand").perform(e,!0)},shiftCommandIndex:function(e){this.shiftCommandIndex(e)}}})}),define("vault/components/control-group-success",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({router:Ember.inject.service(),controlGroup:Ember.inject.service(),store:Ember.inject.service(),model:null,controlGroupResponse:null,error:null,unwrapData:null,unwrap:(0,t.task)(regeneratorRuntime.mark(function e(t){var n,a
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return n=this.get("store").adapterFor("tools"),this.set("error",null),e.prev=2,e.next=5,n.toolAction("unwrap",null,{clientToken:t})
case 5:a=e.sent,this.set("unwrapData",a.auth||a.data),this.get("controlGroup").deleteControlGroupToken(this.get("model.id")),e.next=13
break
case 10:e.prev=10,e.t0=e.catch(2),this.set("error","Token unwrap failed: "+e.t0.errors[0])
case 13:case"end":return e.stop()}},e,this,[[2,10]])})).drop(),markAndNavigate:(0,t.task)(regeneratorRuntime.mark(function e(){var t,n
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return this.get("controlGroup").markTokenForUnwrap(this.get("model.id")),t=this.get("controlGroupResponse.uiParams"),n=t.url,e.next=4,this.get("router").transitionTo(n)
case 4:case"end":return e.stop()}},e,this)})).drop()})}),define("vault/components/control-group",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:"",auth:Ember.inject.service(),controlGroup:Ember.inject.service(),model:null,didReceiveAttrs:function(){this._super.apply(this,arguments)
var e=this.get("model.id"),t=this.get("controlGroup").wrapInfoForAccessor(e)
this.set("controlGroupResponse",t)},currentUserEntityId:Ember.computed.alias("auth.authData.entity_id"),currentUserIsRequesting:Ember.computed("currentUserEntityId","model.requestEntity.id",function(){return this.get("currentUserEntityId")===this.get("model.requestEntity.id")}),currentUserHasAuthorized:Ember.computed("currentUserEntityId","model.authorizations.@each.id",function(){var e=this.get("model.authorizations")||[]
return Boolean(e.findBy("id",this.get("currentUserEntityId")))}),isSuccess:Ember.computed.or("currentUserHasAuthorized","model.approved"),requestorName:Ember.computed("currentUserIsRequesting","model.requestEntity",function(){var e=this.get("model.requestEntity")
return this.get("currentUserIsRequesting")?"You":e&&Ember.get(e,"name")?Ember.get(e,"name"):"Someone"}),bannerPrefix:Ember.computed("model.approved","currentUserHasAuthorized",function(){return this.get("currentUserHasAuthorized")?"Thanks!":this.get("model.approved")?"Success!":"Locked"}),bannerText:Ember.computed("model.approved","currentUserIsRequesting","currentUserHasAuthorized",function(){var e=this.get("model.approved"),t=this.getProperties("currentUserIsRequesting","currentUserHasAuthorized"),n=t.currentUserHasAuthorized,a=t.currentUserIsRequesting
return n?"You have given authorization":a&&e?"You have been given authorization":e?"This Control Group has been authorized":a?"The path you requested is locked by a Control Group":"Someone is requesting access to a path locked by a Control Group"}),refresh:(0,t.task)(regeneratorRuntime.mark(function e(){return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.prev=0,e.next=3,this.get("model").reload()
case 3:e.next=8
break
case 5:e.prev=5,e.t0=e.catch(0),this.set("errors",e.t0)
case 8:case"end":return e.stop()}},e,this,[[0,5]])})).drop(),authorize:(0,t.task)(regeneratorRuntime.mark(function e(){return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.prev=0,e.next=3,this.get("model").save()
case 3:return e.next=5,this.get("refresh").perform()
case 5:e.next=10
break
case 7:e.prev=7,e.t0=e.catch(0),this.set("errors",e.t0)
case 10:case"end":return e.stop()}},e,this,[[0,7]])})).drop()})}),define("vault/components/copy-button",["exports","ember-cli-clipboard/components/copy-button"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/doc-link",["exports","core/components/doc-link"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/download-button",["exports","core/components/download-button"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/edit-form",["exports","core/components/edit-form"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/empty-state",["exports","core/components/empty-state"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/field-group-show",["exports","core/components/field-group-show"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/flash-message",["exports","ember-cli-flash/components/flash-message"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({alertType:Ember.computed("flash.type",{get:function(){return"is-"+Ember.getWithDefault(this,"flash.type","")}})})}),define("vault/components/form-field-groups",["exports","core/components/form-field-groups"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/form-field",["exports","core/components/form-field"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/generate-credentials",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t={"ssh-sign":{model:"ssh-sign"},"ssh-creds":{model:"ssh-otp-credential",title:"Generate SSH Credentials"},"aws-creds":{model:"aws-credential",title:"Generate AWS Credentials",backIsListLink:!0},"pki-issue":{model:"pki-certificate",title:"Issue Certificate"},"pki-sign":{model:"pki-certificate-sign",title:"Sign Certificate"}}
e.default=Ember.Component.extend({wizard:Ember.inject.service(),store:Ember.inject.service(),router:Ember.inject.service(),backendType:null,backendPath:null,roleName:null,action:null,model:null,loading:!1,emptyData:"{\n}",modelForType:function(){var e=this.get("options")
if(e)return e.model
this.get("router").transitionTo("vault.cluster.secrets.backend.list-root",this.get("backendPath"))},options:Ember.computed("action","backendType",function(){var e=this.get("action")||"creds"
return t[this.get("backendType")+"-"+e]}),init:function(){this._super.apply(this,arguments),this.createOrReplaceModel()},didReceiveAttrs:function(){"displayRole"===this.get("wizard.featureState")&&this.get("wizard").transitionFeatureMachine(this.get("wizard.featureState"),"CONTINUE",this.get("backendType"))},willDestroy:function(){this.get("model").unloadRecord(),this._super.apply(this,arguments)},createOrReplaceModel:function(){var e=this.modelForType(),t=this.get("model"),n=this.get("roleName"),a=this.get("backendPath")
if(e){t&&t.unloadRecord()
var s={role:{backend:a,name:n},id:a+"-"+n},r=this.get("store").createRecord(e,s)
this.set("model",r)}},actions:{create:function(){var e=this,t=this.get("model")
this.set("loading",!0),this.model.save().catch(function(){"credentials"===e.get("wizard.featureState")&&e.get("wizard").transitionFeatureMachine(e.get("wizard.featureState"),"ERROR",e.get("backendType"))}).finally(function(){t.set("hasGenerated",!0),e.set("loading",!1)})},codemirrorUpdated:function(e,t,n){n.performLint(),n.state.lint.marked.length>0||Ember.set(this.get("model"),e,JSON.parse(t))},newModel:function(){this.createOrReplaceModel()}}})}),define("vault/components/generated-item-list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({model:null,itemType:null,router:Ember.inject.service(),store:Ember.inject.service(),actions:{refreshItemList:function(){var e=Ember.getOwner(this).lookup("route:"+this.router.currentRouteName)
this.store.clearAllDatasets(),e.refresh()}}})}),define("vault/components/generated-item",["exports","ember-concurrency","ember-data"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({model:null,itemType:null,flashMessages:Ember.inject.service(),router:Ember.inject.service(),props:Ember.computed(function(){return this.model.serialize()}),saveModel:(0,t.task)(regeneratorRuntime.mark(function e(){return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.prev=0,e.next=3,this.model.save()
case 3:e.next=10
break
case 5:if(e.prev=5,e.t0=e.catch(0),e.t0 instanceof n.default.AdapterError!=!1){e.next=9
break}throw e.t0
case 9:return e.abrupt("return")
case 10:this.router.transitionTo("vault.cluster.access.method.item.list").followRedirects(),this.flashMessages.success("The "+this.itemType+" configuration was saved successfully.")
case 12:case"end":return e.stop()}},e,this,[[0,5]])})).withTestWaiter(),actions:{deleteItem:function(){var e=this
this.model.destroyRecord().then(function(){e.router.transitionTo("vault.cluster.access.method.item.list").followRedirects(),e.flashMessages.success(e.model.id+" "+e.itemType+" was deleted successfully.")})}}})}),define("vault/components/home-link",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:"",text:Ember.computed(function(){return"home"}),computedClasses:Ember.computed("classNames",function(){return this.get("classNames").join(" ")})})}),define("vault/components/hover-copy-button",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({classNameBindings:"alwaysShow:hover-copy-button-static:hover-copy-button",copyValue:null,alwaysShow:!1,tooltipText:"Copy"})}),define("vault/components/http-requests-bar-chart",["exports","d3-selection","d3-scale","d3-axis","d3-time-format","d3-tip","d3-transition","d3-ease","ember-concurrency"],function(e,t,n,a,s,r,l,i,o){Object.defineProperty(e,"__esModule",{value:!0})
e.default=Ember.Component.extend({classNames:["http-requests-bar-chart-container"],counters:null,margin:Object.freeze({top:24,right:16,bottom:24,left:16}),padding:.04,width:0,height:function(){var e=this.margin
return 240-e.top-e.bottom},parsedCounters:Ember.computed("counters",function(){return this.counters.map(function(e){return Ember.assign({},e,{start_time:s.default.isoParse(e.start_time)})})}),yScale:Ember.computed("parsedCounters","height",function(){var e=this.parsedCounters,t=this.height(),a=e.map(function(e){return e.total})
return n.default.scaleLinear().domain([0,Math.max.apply(Math,function(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}(a))]).range([t,0])}),xScale:Ember.computed("parsedCounters","width",function(){var e=this.parsedCounters,t=this.width,a=this.margin,s=this.padding
return n.default.scaleBand().domain(e.map(function(e){return e.start_time})).rangeRound([0,t-a.left-a.right],.05).paddingInner(s).paddingOuter(s)}),didInsertElement:function(){var e=this
this._super.apply(this,arguments)
var t=this.margin
Ember.run.schedule("afterRender",this,function(){e.set("width",e.element.clientWidth-t.left-t.right),e.renderBarChart()})},didUpdateAttrs:function(){this.renderBarChart()},renderBarChart:function(){var e=this.margin,n=this.width,o=this.xScale,u=this.yScale,c=this.parsedCounters,d=this.elementId,m=this.height(),p=t.default.select(".http-requests-bar-chart"),f=t.default.select("#bars-container-"+d),h=(0,r.default)().attr("class","d3-tooltip").offset([6,0]).html(function(e){return'\n          <p class="date">'+s.default.utcFormat("%B %Y")(e.start_time)+"</p>\n          <p>"+Intl.NumberFormat().format(e.total)+" Requests</p>\n        "})
p.call(h),t.default.select(".http-requests-bar-chart").attr("width",n+e.left+e.right).attr("height",m+e.top+e.bottom).attr("viewBox","0 0 "+n+" "+m)
var b=a.default.axisRight(u).ticks(3,"~s").tickSizeOuter(0),v=a.default.axisBottom(o).tickFormat(s.default.utcFormat("%b %Y")).tickSizeOuter(0)
p.select("g.x-axis").attr("transform","translate(0,"+m+")").call(v),p.select("g.y-axis").attr("transform","translate("+(n-e.left-e.right)+", 0)").call(b)
var y=a.default.axisRight(u).ticks(3).tickFormat("").tickSize(n-e.left-e.right)
p.select(".gridlines").call(y)
var g=f.selectAll(".bar").data(c,function(e){return+e.start_time}),x=g.enter().append("rect").attr("class","bar"),k=l.default.transition().duration(300).ease(i.default.easeQuad)
g.merge(x).attr("x",function(e){return o(e.start_time)}).attr("y",function(){return u(0)}).attr("width",o.bandwidth()).transition(k).delay(function(e,t){return 150*t}).attr("height",function(e){return m-u(e.total)}).attr("y",function(e){return u(e.total)}),g.exit().remove()
var w=t.default.select(".shadow-bars").selectAll(".bar").data(c,function(e){return+e.start_time}),E=w.enter().append("rect").attr("class","bar").on("mouseenter",h.show).on("mouseleave",h.hide)
w.merge(E).attr("width",o.bandwidth()).attr("height",function(e){return m-u(e.total)+12}).attr("x",function(e){return o(e.start_time)}).attr("y",function(e){return u(e.total)-12}).attr("fill","transparent").attr("stroke","transparent"),w.exit().remove()},updateDimensions:function(){var e=this.element.clientWidth,t=this.margin
this.set("width",e-t.left-t.right),this.renderBarChart()},waitForResize:(0,o.task)(regeneratorRuntime.mark(function e(){return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=3,(0,o.waitForEvent)(window,"resize")
case 3:Ember.run.scheduleOnce("afterRender",this,"updateDimensions"),e.next=0
break
case 6:case"end":return e.stop()}},e,this)})).on("didInsertElement").cancelOn("willDestroyElement").drop()})}),define("vault/components/http-requests-container",["exports","date-fns/is_within_range","date-fns/add_months"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({classNames:["http-requests-container"],counters:null,timeWindow:"All",filteredCounters:Ember.computed("counters","timeWindow",function(){var e=this.counters,a=this.timeWindow
if("All"===a)return e
if("Last 12 Months"===a){var s=new Date,r=(0,n.default)(s,-12)
return e.filter(function(e){return(0,t.default)(e.start_time,r,s)})}return e.filter(function(e){return new Date(e.start_time).getUTCFullYear().toString()===a})}),actions:{updateTimeWindow:function(e){this.set("timeWindow",e)}}})}),define("vault/components/http-requests-dropdown",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({classNames:["http-requests-dropdown"],counters:null,timeWindow:"All",options:Ember.computed("counters",function(){var e=this.counters||[],t=[]
if(e.length){var n=e.map(function(e){return new Date(e.start_time).getUTCFullYear().toString()}).uniq()
n.sort().reverse(),t=t.concat(n)}return t}),onChange:function(){},actions:{onSelectTimeWindow:function(e){var t=e.target.value
t!==this.timeWindow&&this.onChange(t)}}})}),define("vault/components/http-requests-table",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:"",counters:null,countersWithChange:Ember.computed("counters",function(){var e=this.counters||[],t=[],n=void 0
return e.forEach(function(e){if(n){var a=((n-e.total)/n*100).toFixed(1),s=void 0;(a=-a)>0?s="arrow-up":a<0&&(s="arrow-down")
var r=Ember.assign({percentChange:a,glyph:s},e)
t.push(r)}else t.push(e)
n=e.total}),t})})}),define("vault/components/icon",["exports","core/components/icon"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/identity/_popup-base",["exports"],function(e){function t(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:"",flashMessages:Ember.inject.service(),params:null,successMessage:function(){return"Save was successful"},errorMessage:function(){return"There was an error saving"},onError:function(e){e&&e.rollbackAttributes&&e.rollbackAttributes()},onSuccess:function(){},transaction:function(){},actions:{performTransaction:function(){var e=this,n=[].concat(Array.prototype.slice.call(arguments)),a=this.messageArgs.apply(this,t(n))
return this.transaction.apply(this,t(n)).then(function(){e.get("onSuccess")(),e.get("flashMessages").success(e.successMessage.apply(e,t(a)))}).catch(function(n){e.onError.apply(e,t(a)),e.get("flashMessages").success(e.errorMessage.apply(e,[n].concat(t(a))))})}}})}),define("vault/components/identity/edit-form",["exports","ember-concurrency","vault/helpers/humanize"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({flashMessages:Ember.inject.service(),model:null,mode:"create",onSave:function(){},cancelLink:Ember.computed("mode","model.identityType",function(){var e=this.model,t=this.mode
return{"create-entity":"vault.cluster.access.identity","edit-entity":"vault.cluster.access.identity.show","merge-entity-merge":"vault.cluster.access.identity","create-entity-alias":"vault.cluster.access.identity.aliases","edit-entity-alias":"vault.cluster.access.identity.aliases.show","create-group":"vault.cluster.access.identity","edit-group":"vault.cluster.access.identity.show","create-group-alias":"vault.cluster.access.identity.aliases","edit-group-alias":"vault.cluster.access.identity.aliases.show"}[e?t+"-"+e.identityType:"merge-entity-alias"]}),getMessage:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],a=this.mode,s=(0,n.humanize)([e.identityType]),r=t?"deleted":"saved"
return"merge"===a?"Successfully merged entities":e.id?"Successfully "+r+" "+s+" "+e.id+".":"Successfully "+r+" "+s+"."},save:(0,t.task)(regeneratorRuntime.mark(function e(){var t,n
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return t=this.model,n=this.getMessage(t),e.prev=2,e.next=5,t.save()
case 5:e.next=10
break
case 7:return e.prev=7,e.t0=e.catch(2),e.abrupt("return")
case 10:return this.get("flashMessages").success(n),e.next=13,this.get("onSave")({saveType:"save",model:t})
case 13:case"end":return e.stop()}},e,this,[[2,7]])})).drop().withTestWaiter(),willDestroy:function(){var e=this.model
e&&(e.get("isDirty")&&!e.isDestroyed||!e.isDestroying)&&e.rollbackAttributes()},actions:{deleteItem:function(e){var t=this,n=this.getMessage(e,!0),a=this.get("flashMessages")
e.destroyRecord().then(function(){return a.success(n),t.get("onSave")({saveType:"delete",model:e})})}}})}),define("vault/components/identity/item-details",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({flashMessages:Ember.inject.service(),actions:{enable:function(e){var t=this
e.set("disabled",!1),e.save().then(function(){t.get("flashMessages").success("Successfully enabled entity: "+e.id)}).catch(function(n){t.get("flashMessages").success("There was a problem enabling the entity: "+e.id+" - "+(n.errors.join(" ")||n.message))})}}})})
define("vault/components/identity/lookup-input",["exports","ember-concurrency","vault/helpers/underscore"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({store:Ember.inject.service(),flashMessages:Ember.inject.service(),router:Ember.inject.service(),type:"entity",param:"alias name",paramValue:null,aliasMountAccessor:null,authMethods:null,init:function(){var e=this
this._super.apply(this,arguments),this.get("store").findAll("auth-method").then(function(t){e.set("authMethods",t),e.set("aliasMountAccessor",t.get("firstObject.accessor"))})},adapter:function(){var e=this.get("type")
return this.get("store").adapterFor("identity/"+e)},data:function(){var e=this.getProperties("param","paramValue","aliasMountAccessor"),t=e.param,a=e.paramValue,s=e.aliasMountAccessor,r={}
return r[(0,n.underscore)([t])]=a,"alias name"===t&&(r.alias_mount_accessor=s),r},lookup:(0,t.task)(regeneratorRuntime.mark(function e(){var t,n,a,s,r,l,i
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return t=this.get("flashMessages"),n=this.get("type"),a=this.get("store"),s=this.getProperties("param","paramValue"),r=s.param,l=s.paramValue,i=void 0,e.prev=5,e.next=8,this.adapter().lookup(a,this.data())
case 8:i=e.sent,e.next=15
break
case 11:return e.prev=11,e.t0=e.catch(5),t.danger("We encountered an error attempting the "+n+" lookup: "+(e.t0.message||e.t0.errors.join(""))+"."),e.abrupt("return")
case 15:if(!i){e.next=19
break}return e.abrupt("return",this.get("router").transitionTo("vault.cluster.access.identity.show",i.id,"details"))
case 19:t.danger("We were unable to find an identity "+n+' with a "'+r+'" of "'+l+'".')
case 20:case"end":return e.stop()}},e,this,[[5,11]])}))})}),define("vault/components/identity/popup-alias",["exports","vault/components/identity/_popup-base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({messageArgs:function(e){return[e.get("identityType"),e.id]},successMessage:function(e,t){return"Successfully deleted "+e+": "+t},errorMessage:function(e,t,n){return"There was a problem deleting "+t+": "+n+" - "+(e.errors?e.errors.join(" "):e.message)},transaction:function(e){return e.destroyRecord()}})}),define("vault/components/identity/popup-members",["exports","vault/components/identity/_popup-base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({model:Ember.computed.alias("params.firstObject"),groupArray:Ember.computed("params",function(){return this.get("params").objectAt(1)}),memberId:Ember.computed("params",function(){return this.get("params").objectAt(2)}),messageArgs:function(){return[].concat(Array.prototype.slice.call(arguments))},successMessage:function(e,t,n){return"Successfully removed '"+n+"' from the group"},errorMessage:function(e,t,n,a){return"There was a problem removing '"+a+"' from the group - "+(e.errors?e.errors.join(" "):e.message)},transaction:function(e,t,n){var a=e.get(t)
return e.set(t,a.without(n)),e.save()}})}),define("vault/components/identity/popup-metadata",["exports","vault/components/identity/_popup-base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t]
for(var a in n)Object.prototype.hasOwnProperty.call(n,a)&&(e[a]=n[a])}return e}
e.default=t.default.extend({model:Ember.computed.alias("params.firstObject"),key:Ember.computed("params",function(){return this.params.objectAt(1)}),messageArgs:function(e,t){return[e,t]},successMessage:function(e,t){return"Successfully removed '"+t+"' from metadata"},errorMessage:function(e,t,n){return"There was a problem removing '"+n+"' from the metadata - "+(e.errors?e.errors.join(" "):e.message)},transaction:function(e,t){var a=e.metadata
return delete a[t],e.set("metadata",n({},a)),e.save()}})}),define("vault/components/identity/popup-policy",["exports","vault/components/identity/_popup-base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({model:Ember.computed.alias("params.firstObject"),policyName:Ember.computed("params",function(){return this.get("params").objectAt(1)}),messageArgs:function(e,t){return[e,t]},successMessage:function(e,t){return"Successfully removed '"+t+"' policy from "+e.id+" "},errorMessage:function(e,t,n){return"There was a problem removing '"+n+"' policy - "+(e.errors?e.errors.join(" "):e.message)},transaction:function(e,t){var n=e.get("policies")
return e.set("policies",n.without(t)),e.save()}})}),define("vault/components/info-table-row",["exports","core/components/info-table-row"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/info-tooltip",["exports","core/components/info-tooltip"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/ivy-codemirror",["exports","ivy-codemirror/components/ivy-codemirror"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/json-editor",["exports","vault/components/ivy-codemirror"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n={gutters:["CodeMirror-lint-markers"],tabSize:2,mode:"application/json",lineNumbers:!0,lint:{lintOnChange:!1},theme:"hashi",readOnly:!1,showCursorWhenSelecting:!0}
e.default=t.default.extend({updateCodeMirrorOptions:function(){var e=Ember.assign({},n,this.get("options"))
e.autoHeight&&(e.viewportMargin=1/0,delete e.autoHeight),e&&Object.keys(e).forEach(function(t){this.updateCodeMirrorOption(t,e[t])},this)}})}),define("vault/components/key-value-header",["exports","vault/lib/key-utils","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:"nav",classNames:"key-value-header breadcrumb",ariaLabel:"breadcrumbs",attributeBindings:["ariaLabel:aria-label","aria-hidden"],baseKey:null,path:null,showCurrent:!0,linkToPaths:!0,stripTrailingSlash:function(e){return"/"===e[e.length-1]?e.slice(0,-1):e},currentPath:Ember.computed("mode","path","showCurrent",function(){var e=this.get("mode"),t=this.get("path"),n=this.get("showCurrent")
return e&&!1!==n?"vault.cluster.secrets.backend."+e:t}),secretPath:Ember.computed("baseKey","baseKey.{display,id}","root","showCurrent",function(){var e=this,a=[],s=this.get("root"),r=this.get("baseKey.display")||this.get("baseKey.id"),l=(0,n.encodePath)(this.get("baseKey.id"))
if(s&&a.push(s),!r)return a
var i=this.get("path"),o=this.get("currentPath"),u=this.get("showCurrent"),c=t.default.ancestorKeysForKey(r),d=t.default.keyPartsForKey(r)
return 0===c.length?(a.push({label:r,text:this.stripTrailingSlash(r),path:o,model:l}),u||a.pop(),a):(c.forEach(function(t,n){a.push({label:d[n],text:e.stripTrailingSlash(d[n]),path:i,model:t})}),a.push({label:t.default.keyWithoutParentKey(r),text:this.stripTrailingSlash(t.default.keyWithoutParentKey(r)),path:o,model:l}),u||a.pop(),a)})})}),define("vault/components/key-version-select",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:""})}),define("vault/components/kv-object-editor",["exports","vault/lib/kv-object"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({classNames:["field","form-section"],value:null,label:null,helpText:null,onChange:function(){},init:function(){this._super.apply(this,arguments)
var e=t.default.create({content:[]}).fromJSON(this.get("value"))
this.set("kvData",e),this.addRow()},kvData:null,kvDataAsJSON:Ember.computed("kvData","kvData.[]",function(){return this.get("kvData").toJSON()}),kvDataIsAdvanced:Ember.computed("kvData","kvData.[]",function(){return this.get("kvData").isAdvanced()}),kvHasDuplicateKeys:Ember.computed("kvData","kvData.@each.name",function(){var e=this.get("kvData")
return e.uniqBy("name").length!==e.get("length")}),addRow:function(){var e=this.get("kvData"),t={name:"",value:""}
Ember.isNone(e.findBy("name",""))&&(Ember.guidFor(t),e.addObject(t))},actions:{addRow:function(){this.addRow()},updateRow:function(){var e=this.get("kvData")
this.get("onChange")(e.toJSON())},deleteRow:function(e,t){var n=this.get("kvData")
n.objectAt(t)
n.removeAt(t),this.get("onChange")(n.toJSON())}}})}),define("vault/components/labeled-radio-button",["exports","ember-radio-button/components/labeled-radio-button"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/layout-loading",["exports","core/components/layout-loading"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/learn-link",["exports","vault/components/doc-link"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({host:"https://learn.hashicorp.com"})}),define("vault/components/license-info",["exports","vault/helpers/all-features"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({expirationTime:"",startTime:"",licenseId:"",features:null,model:null,text:"",showForm:!1,isTemporary:Ember.computed("licenseId",function(){return"temporary"===this.licenseId}),featuresInfo:Ember.computed("model","features",function(){var e=this
return(0,t.allFeatures)().map(function(t){var n=e.features.includes(t)
if(n&&"Performance Standby"===t){var a=e.model.performanceStandbyCount
return{name:t,active:!!a&&n,count:a}}return{name:t,active:n}})}),saveModel:function(){},actions:{saveModel:function(e){this.saveModel(e)},toggleForm:function(){this.toggleProperty("showForm")}}})}),define("vault/components/link-to-external",["exports","ember-engines/components/link-to-external-component"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/link-to",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),Ember.LinkComponent.reopen({activeClass:"is-active"}),e.default=Ember.LinkComponent}),define("vault/components/linked-block",["exports","core/components/linked-block"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/list-item",["exports","core/components/list-item"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/list-item/content",["exports","core/components/list-item/content"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/list-item/popup-menu",["exports","core/components/list-item/popup-menu"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/list-pagination",["exports","core/components/list-pagination"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/list-view",["exports","core/components/list-view"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/logo-edition",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:"",version:Ember.inject.service()})}),define("vault/components/logo-splash",["exports","vault/components/outer-html"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/masked-input",["exports","core/components/masked-input"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/menu-loader",["exports","core/components/menu-loader"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/menu-sidebar",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({classNames:["column","is-sidebar"],classNameBindings:["isActive:is-active"],isActive:!1,actions:{openMenu:function(){this.set("isActive",!0)},closeMenu:function(){this.set("isActive",!1)}}})}),define("vault/components/message-error",["exports","core/components/message-error"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})
define("vault/components/model-wrap",["exports","core/components/model-wrap"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/mount-accessor-select",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({store:Ember.inject.service(),value:null,onChange:function(){},init:function(){this._super.apply(this,arguments),this.get("authMethods").perform()},authMethods:(0,t.task)(regeneratorRuntime.mark(function e(){var t
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,this.get("store").findAll("auth-method")
case 2:return t=e.sent,this.get("value")||this.set("value",t.get("firstObject.accessor")),e.abrupt("return",t)
case 5:case"end":return e.stop()}},e,this)})).drop(),actions:{change:function(e){this.get("onChange")(e)}}})}),define("vault/components/mount-backend-form",["exports","ember-concurrency","vault/helpers/mountable-auth-methods","vault/helpers/mountable-secret-engines"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=(0,n.methods)(),r=(0,a.engines)()
e.default=Ember.Component.extend({store:Ember.inject.service(),wizard:Ember.inject.service(),flashMessages:Ember.inject.service(),version:Ember.inject.service(),onMountSuccess:function(){},mountType:"auth",mountModel:null,showEnable:!1,init:function(){this._super.apply(this,arguments)
var e="secret"===this.mountType?"secret-engine":"auth-method",t=this.store.createRecord(e)
this.set("mountModel",t)},mountTypes:Ember.computed("mountType",function(){return"secret"===this.mountType?this.engines:s}),engines:Ember.computed("version.features[]",function(){return this.version.hasFeature("KMIP")?r.concat([a.KMIP]):r}),willDestroy:function(){this.get("mountModel").rollbackAttributes()},checkPathChange:function(e){var t=this.mountModel,n=t.path,a=this.mountTypes.findBy("type",n)
n&&!a||t.set("path",e)},mountBackend:(0,t.task)(regeneratorRuntime.mark(function e(){var t,n,a,s,r
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return t=this.mountModel,n=t.getProperties("type","path"),a=n.type,s=n.path,e.prev=2,e.next=5,t.save()
case 5:e.next=10
break
case 7:return e.prev=7,e.t0=e.catch(2),e.abrupt("return")
case 10:return r="secret"===(r=this.mountType)?r+"s engine":r+" method",this.flashMessages.success("Successfully mounted the "+a+" "+r+" at "+s+"."),e.next=15,this.onMountSuccess(a,s)
case 15:return e.abrupt("return")
case 16:case"end":return e.stop()}},e,this,[[2,7]])})).drop().withTestWaiter(),actions:{onTypeChange:function(e,t){"type"===e&&(this.wizard.set("componentState",t),this.checkPathChange(t))},toggleShowEnable:function(e){this.set("showEnable",e),!0===e&&"idle"===this.wizard.featureState?this.wizard.transitionFeatureMachine(this.wizard.featureState,"CONTINUE",this.mountModel.type):this.wizard.transitionFeatureMachine(this.wizard.featureState,"RESET",this.mountModel.type)}}})}),define("vault/components/namespace-link",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({namespaceService:Ember.inject.service("namespace"),currentNamespace:Ember.computed.alias("namespaceService.path"),tagName:"",targetNamespace:null,showLastSegment:!1,normalizedNamespace:Ember.computed("targetNamespace",function(){return(this.get("targetNamespace")||"").replace(/\.+/g,"/").replace("☃",".")}),namespaceDisplay:Ember.computed("normalizedNamespace","showLastSegment",function(){var e=this.get("normalizedNamespace"),t=this.get("showLastSegment"),n=e.split("/")
return""===e?"root":t?n[n.length-1]:e}),isCurrentNamespace:Ember.computed("targetNamespace","currentNamespace",function(){return this.get("currentNamespace")===this.get("targetNamespace")})})}),define("vault/components/namespace-picker",["exports","vault/lib/key-utils","vault/lib/path-to-tree","ember-concurrency"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=t.default.ancestorKeysForKey
e.default=Ember.Component.extend({tagName:"",namespaceService:Ember.inject.service("namespace"),auth:Ember.inject.service(),store:Ember.inject.service(),namespace:null,listCapability:null,canList:Ember.computed.alias("listCapability.canList"),init:function(){this._super.apply(this,arguments),this.get("namespaceService.findNamespacesForUser").perform()},didReceiveAttrs:function(){this._super.apply(this,arguments)
var e=this.get("namespace"),t=this.get("oldNamespace")
t&&e===t||(this.get("setForAnimation").perform(),this.get("fetchListCapability").perform()),this.set("oldNamespace",e)},fetchListCapability:(0,a.task)(regeneratorRuntime.mark(function e(){var t
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(e.prev=0,!this.listCapability){e.next=5
break}return e.next=4,this.listCapability.reload()
case 4:return e.abrupt("return")
case 5:return e.next=7,this.store.findRecord("capabilities","sys/namespaces/")
case 7:t=e.sent,this.set("listCapability",t),e.next=13
break
case 11:e.prev=11,e.t0=e.catch(0)
case 13:case"end":return e.stop()}},e,this,[[0,11]])})),setForAnimation:(0,a.task)(regeneratorRuntime.mark(function e(){var t,n,s,r
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(t=this.get("menuLeaves"),n=this.get("lastMenuLeaves")){e.next=7
break}return this.set("lastMenuLeaves",t),e.next=6,(0,a.timeout)(0)
case 6:return e.abrupt("return")
case 7:if(s=t.length>n.length,r=(s?t:n).get("lastObject"),this.set("isAdding",s),this.set("changedLeaf",r),!s){e.next=16
break}return this.set("lastMenuLeaves",t),e.next=15,(0,a.timeout)(0)
case 15:return e.abrupt("return")
case 16:return e.next=18,(0,a.timeout)(250)
case 18:this.set("lastMenuLeaves",t)
case 19:case"end":return e.stop()}},e,this)})).drop(),isAnimating:Ember.computed.alias("setForAnimation.isRunning"),namespacePath:Ember.computed.alias("namespaceService.path"),accessibleNamespaces:Ember.computed.alias("namespaceService.accessibleNamespaces"),inRootNamespace:Ember.computed.alias("namespaceService.inRootNamespace"),namespaceTree:Ember.computed("accessibleNamespaces",function(){var e=this.get("accessibleNamespaces")
return e?(0,n.default)(e):[]}),maybeAddRoot:function(e){return""===this.get("auth.authData.userRootNamespace")&&e.unshift(""),e.uniq()},pathToLeaf:function(e){return e.replace(/\/$/,"").replace(/\.+/g,"☃").replace(/\/+/g,".")},menuLeaves:Ember.computed("namespacePath","namespaceTree",function(){var e=this.get("namespacePath")
e=e.replace(/^\//,"")
var t=s(e)
return t.push(e),t=(t=this.maybeAddRoot(t)).map(this.pathToLeaf)}),rootLeaves:Ember.computed("namespaceTree",function(){var e=this.get("namespaceTree")
return Object.keys(e)}),currentLeaf:Ember.computed.alias("lastMenuLeaves.lastObject"),canAccessMultipleNamespaces:Ember.computed.gt("accessibleNamespaces.length",1),isUserRootNamespace:Ember.computed("auth.authData.userRootNamespace","namespacePath",function(){return this.get("auth.authData.userRootNamespace")===this.get("namespacePath")}),namespaceDisplay:Ember.computed("namespacePath","accessibleNamespaces","accessibleNamespaces.[]",function(){var e=this.get("namespacePath")
if(""===e)return""
var t=e.split("/")
return t[t.length-1]})})}),define("vault/components/namespace-reminder",["exports","core/components/namespace-reminder"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/nav-header",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({classNameBindings:"consoleFullscreen:panel-fullscreen",tagName:"header",navDrawerOpen:!1,consoleFullscreen:!1,actions:{toggleNavDrawer:function(e){if(void 0!==e)return this.set("navDrawerOpen",e)
this.toggleProperty("navDrawerOpen")}}})}),define("vault/components/nav-header/home",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:""})}),define("vault/components/nav-header/items",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:""})}),define("vault/components/nav-header/main",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:""})}),define("vault/components/navigate-input",["exports","core/components/navigate-input"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/not-found",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({model:null,tagName:"",router:Ember.inject.service(),path:Ember.computed.alias("router.currentURL")})}),define("vault/components/outer-html",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:""})}),define("vault/components/page-header-level-left",["exports","core/components/page-header-level-left"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/page-header-level-right",["exports","core/components/page-header-level-right"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/page-header-top",["exports","core/components/page-header-top"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/page-header",["exports","core/components/page-header"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/pgp-file",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/gi
e.default=Ember.Component.extend({classNames:["box","is-fullwidth","is-marginless","is-shadowless"],key:null,index:null,onChange:function(){},label:null,fileHelpText:null,textareaHelpText:null,readFile:function(e){var t=this,n=new FileReader
n.onload=function(){return t.setPGPKey.perform(n.result,e.name)},n.readAsDataURL(e)},setPGPKey:(0,t.task)(regeneratorRuntime.mark(function e(t,a){var s,r,l
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return s=t.split(",")[1].trim(),r=atob(s).trim(),l=r.match(n)?r:s,e.next=5,this.get("onChange")(this.get("index"),{value:l,fileName:a})
case 5:case"end":return e.stop()}},e,this)})).withTestWaiter(),actions:{pickedFile:function(e){var t=e.target.files
if(t.length)for(var n=0,a=t.length;n<a;n++)this.readFile(t[n])},updateData:function(e){var t=this.get("key")
Ember.set(t,"value",e.target.value),this.get("onChange")(this.get("index"),this.get("key"))},clearKey:function(){this.get("onChange")(this.get("index"),{value:""})}}})}),define("vault/components/pgp-list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({onDataUpdate:function(){},listData:Ember.computed("listLength",function(){var e=this.get("listLength")
return e&&(e=parseInt(e,10)),Array(e||0).fill(null).map(function(){return{value:""}})}),listLength:0,actions:{setKey:function(e,t){var n=this.get("listData")
n.replace(e,1,t),this.get("onDataUpdate")(n.compact().map(function(e){return e.value}))}}})}),define("vault/components/pki-cert-popup",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({item:null,actions:{delete:function(e){e.save({adapterOptions:{method:"revoke"}})}}})}),define("vault/components/pki-cert-show",["exports","vault/components/role-edit"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({actions:{delete:function(){this.get("model").save({adapterOptions:{method:"revoke"}})}}})}),define("vault/components/popup-menu",["exports","core/components/popup-menu"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select-multiple-with-create",["exports","ember-power-select-with-create/components/power-select-multiple-with-create"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select-multiple",["exports","ember-power-select/components/power-select-multiple"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select-multiple/trigger",["exports","ember-power-select/components/power-select-multiple/trigger"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select-with-create",["exports","ember-power-select-with-create/components/power-select-with-create"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select-with-create/suggested-option",["exports","ember-power-select-with-create/components/power-select-with-create/suggested-option"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select",["exports","ember-power-select/components/power-select"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select/before-options",["exports","ember-power-select/components/power-select/before-options"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select/options",["exports","ember-power-select/components/power-select/options"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})
define("vault/components/power-select/placeholder",["exports","ember-power-select/components/power-select/placeholder"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select/power-select-group",["exports","ember-power-select/components/power-select/power-select-group"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select/search-message",["exports","ember-power-select/components/power-select/search-message"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/power-select/trigger",["exports","ember-power-select/components/power-select/trigger"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/radial-progress",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:"svg",classNames:"radial-progress",attributeBindings:["size:width","size:height","viewBox"],progressDecimal:null,size:20,strokeWidth:1,viewBox:Ember.computed("size",function(){var e=this.get("size")
return"0 0 "+e+" "+e}),centerValue:Ember.computed("size",function(){return this.get("size")/2}),r:Ember.computed("size","strokeWidth",function(){return(this.get("size")-this.get("strokeWidth"))/2}),c:Ember.computed("r",function(){return 2*Math.PI*this.get("r")}),dashArrayOffset:Ember.computed("c","progressDecimal",function(){return this.get("c")*(1-this.get("progressDecimal"))})})}),define("vault/components/radio-button-input",["exports","ember-radio-button/components/radio-button-input"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/radio-button",["exports","ember-radio-button/components/radio-button"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/replication-action-demote",["exports","core/components/replication-action-demote"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/replication-action-disable",["exports","core/components/replication-action-disable"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/replication-action-promote",["exports","core/components/replication-action-promote"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/replication-action-recover",["exports","core/components/replication-action-recover"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/replication-action-reindex",["exports","core/components/replication-action-reindex"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/replication-action-update-primary",["exports","core/components/replication-action-update-primary"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/replication-actions-single",["exports","core/components/replication-actions-single"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/replication-actions",["exports","core/components/replication-actions"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/replication-mode-summary",["exports","core/components/replication-mode-summary"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/role-aws-edit",["exports","vault/components/role-edit"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
e.default=t.default.extend({actions:{createOrUpdate:function(e,t){var n=this
t.preventDefault()
var a=this.get("model.id")
if("create"!==e||!Ember.isBlank(a)){var s=Ember.get(this,"model.credential_type")
"iam_user"==s&&Ember.set(this,"model.role_arns",[]),"assumed_role"==s&&Ember.set(this,"model.policy_arns",[]),"federation_token"==s&&(Ember.set(this,"model.role_arns",[]),Ember.set(this,"model.policy_arns",[])),"{}"==Ember.get(this,"model.policy_document")&&Ember.set(this,"model.policy_document",""),this.persist("save",function(){n.hasDataChanges(),n.transitionToRoute("vault.cluster.secrets.backend.show",a)})}},codemirrorUpdated:function(e,t,n){n.performLint(),n.state.lint.marked.length>0||Ember.set(this.get("model"),e,t)}}})}),define("vault/components/role-edit",["exports","ember-concurrency","vault/mixins/focus-on-insert","vault/lib/keycodes"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
e.default=Ember.Component.extend(n.default,{router:Ember.inject.service(),wizard:Ember.inject.service(),mode:null,emptyData:"{\n}",onDataChange:function(){},onRefresh:function(){},model:null,requestInFlight:Ember.computed.or("model.isLoading","model.isReloading","model.isSaving"),didReceiveAttrs:function(){this._super.apply(this,arguments),("details"===this.get("wizard.featureState")&&"create"===this.get("mode")||"role"===this.get("wizard.featureState")&&"show"===this.get("mode"))&&this.get("wizard").transitionFeatureMachine(this.get("wizard.featureState"),"CONTINUE",this.get("backendType")),"displayRole"===this.get("wizard.featureState")&&this.get("wizard").transitionFeatureMachine(this.get("wizard.featureState"),"NOOP",this.get("backendType"))},willDestroyElement:function(){this._super.apply(this,arguments),this.model&&this.model.isError&&this.model.rollbackAttributes()},waitForKeyUp:(0,t.task)(regeneratorRuntime.mark(function e(){var n
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=3,(0,t.waitForEvent)(document.body,"keyup")
case 3:n=e.sent,this.onEscape(n),e.next=0
break
case 7:case"end":return e.stop()}},e,this)})).on("didInsertElement").cancelOn("willDestroyElement"),transitionToRoute:function(){var e;(e=this.get("router")).transitionTo.apply(e,arguments)},onEscape:function(e){e.keyCode===a.default.ESC&&"show"===this.get("mode")&&this.transitionToRoute("vault.cluster.secrets.backend.list-root")},hasDataChanges:function(){Ember.get(this,"onDataChange")(Ember.get(this,"model.hasDirtyAttributes"))},persist:function(e,t){var n=this,a=Ember.get(this,"model")
return a[e]().then(function(){Ember.get(a,"isError")||("role"===n.get("wizard.featureState")&&n.get("wizard").transitionFeatureMachine("role","CONTINUE",n.get("backendType")),t(a))})},actions:{createOrUpdate:function(e,t){var n=this
t.preventDefault()
var a=this.get("model.id")
"create"===e&&Ember.isBlank(a)||this.persist("save",function(){n.hasDataChanges(),n.transitionToRoute("vault.cluster.secrets.backend.show",a)})},setValue:function(e,t){Ember.set(Ember.get(this,"model"),e,t.target.checked)},refresh:function(){this.get("onRefresh")()},delete:function(){var e=this
this.persist("destroyRecord",function(){e.hasDataChanges(),e.transitionToRoute("vault.cluster.secrets.backend.list-root")})},codemirrorUpdated:function(e,t,n){n.performLint(),n.state.lint.marked.length>0||Ember.set(this.get("model"),e,JSON.parse(t))}}})}),define("vault/components/role-pki-edit",["exports","vault/components/role-edit"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({init:function(){this._super.apply(this,arguments),this.set("backendType","pki")}})}),define("vault/components/role-ssh-edit",["exports","vault/components/role-edit"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({init:function(){this._super.apply(this,arguments),this.set("backendType","ssh")}})}),define("vault/components/search-select",["exports","ember-concurrency","ember-inflector"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e}
e.default=Ember.Component.extend({classNames:["field","search-select"],store:Ember.inject.service(),onChange:function(){},inputValue:Ember.computed(function(){return[]}),selectedOptions:null,options:null,shouldUseFallback:!1,shouldRenderName:!1,init:function(){this._super.apply(this,arguments),this.set("selectedOptions",this.inputValue||[])},formatOptions:function(e){e=e.toArray().map(function(e){return e.searchText=e.name+" "+e.id,e})
var t=this.selectedOptions.map(function(t){var n=e.findBy("id",t)
return e.removeObject(n),{id:t,name:n?n.name:t,searchText:n?n.searchText:t}})
this.set("selectedOptions",t),this.options&&(e=this.options.concat(e)),this.set("options",e)},fetchOptions:(0,t.task)(regeneratorRuntime.mark(function e(){var t,n,a,s,r,l,i,o
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:t=!0,n=!1,a=void 0,e.prev=3,s=this.models[Symbol.iterator]()
case 5:if(t=(r=s.next()).done){e.next=30
break}return(l=r.value).includes("identity")&&this.set("shouldRenderName",!0),e.prev=8,e.next=11,this.store.query(l,{})
case 11:i=e.sent,this.formatOptions(i),e.next=27
break
case 15:if(e.prev=15,e.t0=e.catch(8),404!==e.t0.httpStatus){e.next=19
break}return e.abrupt("return")
case 19:if(403!==e.t0.httpStatus){e.next=22
break}return this.set("shouldUseFallback",!0),e.abrupt("return")
case 22:if(!this.staticOptions){e.next=26
break}return o=this.staticOptions,this.formatOptions(o),e.abrupt("return")
case 26:throw e.t0
case 27:t=!0,e.next=5
break
case 30:e.next=36
break
case 32:e.prev=32,e.t1=e.catch(3),n=!0,a=e.t1
case 36:e.prev=36,e.prev=37,!t&&s.return&&s.return()
case 39:if(e.prev=39,!n){e.next=42
break}throw a
case 42:return e.finish(39)
case 43:return e.finish(36)
case 44:case"end":return e.stop()}},e,this,[[3,32,36,44],[8,15],[37,,39,43]])})).on("didInsertElement"),handleChange:function(){this.selectedOptions.length&&"object"===a(this.selectedOptions.firstObject)?this.onChange(Array.from(this.selectedOptions,function(e){return e.id})):this.onChange(this.selectedOptions)},actions:{onChange:function(e){this.onChange(e)},createOption:function(e){var t={name:e,id:e}
this.selectedOptions.pushObject(t),this.handleChange()},selectOption:function(e){this.selectedOptions.pushObject(e),this.options.removeObject(e),this.handleChange()},discardSelection:function(e){this.selectedOptions.removeObject(e),this.options.pushObject(e),this.handleChange()},constructSuggestion:function(e){return"Add new "+(0,n.singularize)(this.label)+": "+e},hideCreateOptionOnSameID:function(e){return!(this.options&&(this.options.findBy("id",e)||this.options.findBy("name",e)))}}})}),define("vault/components/secret-edit",["exports","ember-concurrency","vault/mixins/focus-on-insert","vault/mixins/with-nav-to-nearest-ancestor","vault/lib/keycodes","vault/lib/kv-object","vault/macros/maybe-query-record"],function(e,t,n,a,s,r,l){Object.defineProperty(e,"__esModule",{value:!0})
e.default=Ember.Component.extend(n.default,a.default,{wizard:Ember.inject.service(),router:Ember.inject.service(),store:Ember.inject.service(),flashMessages:Ember.inject.service(),key:null,model:null,initialKey:null,mode:null,secretData:null,wrappedData:null,isWrapping:!1,showWrapButton:Ember.computed.not("wrappedData"),onDataChange:function(){},onRefresh:function(){},onToggleAdvancedEdit:function(){},preferAdvancedEdit:!1,toggleAdvancedEdit:"toggleAdvancedEdit",error:null,codemirrorString:null,hasLintError:!1,isV2:!1,init:function(){this._super.apply(this,arguments)
var e=this.model.secretData
!e&&this.model.selectedVersion&&(this.set("isV2",!0),e=this.model.belongsTo("selectedVersion").value().secretData)
var t=r.default.create({content:[]}).fromJSON(e)
if(this.set("secretData",t),this.set("codemirrorString",t.toJSONString()),t.isAdvanced()&&this.set("preferAdvancedEdit",!0),this.checkRows(),"details"===this.wizard.featureState&&"create"===this.mode){var n=this.model.backend.includes("kv")?"kv":this.model.backend
this.wizard.transitionFeatureMachine("details","CONTINUE",n)}"edit"===this.mode&&this.send("addRow")},waitForKeyUp:(0,t.task)(regeneratorRuntime.mark(function e(){var n
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=3,(0,t.waitForEvent)(document.body,"keyup")
case 3:n=e.sent,this.onEscape(n),e.next=0
break
case 7:case"end":return e.stop()}},e,this)})).on("didInsertElement").cancelOn("willDestroyElement"),partialName:Ember.computed("mode",function(){return"partials/secret-form-"+this.mode}),updatePath:(0,l.maybeQueryRecord)("capabilities",function(e){if(e.model&&"create"!==e.mode){var t=e.isV2?e.get("model.engine.id"):e.model.backend,n=e.model.id
return{id:e.isV2?t+"/data/"+n:t+"/"+n}}},"isV2","model","model.id","mode"),canDelete:Ember.computed.alias("model.canDelete"),canEdit:Ember.computed.alias("updatePath.canUpdate"),v2UpdatePath:(0,l.maybeQueryRecord)("capabilities",function(e){if(e.model&&"create"!==e.mode&&!1!==e.isV2)return{id:e.get("model.engine.id")+"/metadata/"+e.model.id}},"isV2","model","model.id","mode"),canEditV2Secret:Ember.computed.alias("v2UpdatePath.canUpdate"),requestInFlight:Ember.computed.or("model.isLoading","model.isReloading","model.isSaving"),buttonDisabled:Ember.computed.or("requestInFlight","model.isFolder","model.flagsIsInvalid","hasLintError","error"),modelForData:Ember.computed("isV2","model",function(){var e=this.model
return e?this.isV2?e.belongsTo("selectedVersion").value():e:null}),basicModeDisabled:Ember.computed("secretDataIsAdvanced","showAdvancedMode",function(){return this.secretDataIsAdvanced||!1===this.showAdvancedMode}),secretDataAsJSON:Ember.computed("secretData","secretData.[]",function(){return this.secretData.toJSON()}),secretDataIsAdvanced:Ember.computed("secretData","secretData.[]",function(){return this.secretData.isAdvanced()}),showAdvancedMode:Ember.computed("preferAdvancedEdit","secretDataIsAdvanced","lastChange",function(){return this.secretDataIsAdvanced||this.preferAdvancedEdit}),isWriteWithoutRead:Ember.computed("model.{failedServerRead,selectedVersion.failedServerRead}","isV2",function(){if(this.model)return!(!this.isV2||!this.model.selectedVersion.failedServerRead)||!(this.isV2||!this.model.failedServerRead)}),transitionToRoute:function(){var e
return(e=this.router).transitionTo.apply(e,arguments)},onEscape:function(e){if(e.keyCode===s.default.ESC&&"show"===this.mode){var t=this.model.parentKey
t?this.transitionToRoute("vault.cluster.secrets.backend.list",t):this.transitionToRoute("vault.cluster.secrets.backend.list-root")}},persistKey:function(e){var t=this,n=this.model,a=this.modelForData,s=this.isV2,r=a.get("path")||n.id
return r.startsWith("/")&&(r=r.replace(/^\/+/g,""),a.set(a.pathAttr,r)),a.save().then(function(){a.isError||(s&&n.set("id",r),s&&Object.keys(n.changedAttributes()).length?n.save().then(function(){t.saveComplete(e,r)}).catch(function(e){t.set(e,e.errors.join(" "))}):t.saveComplete(e,r))})},saveComplete:function(e,t){"secret"===this.wizard.featureState&&this.wizard.transitionFeatureMachine("secret","CONTINUE"),e(t)},checkRows:function(){0===this.secretData.length&&this.send("addRow")},actions:{handleKeyDown:function(e){if(e.stopPropagation(),e.keyCode===s.default.ENTER&&e.metaKey){var t=this.element.querySelector("form")
t.length&&t.submit()}},handleChange:function(){this.set("codemirrorString",this.secretData.toJSONString(!0)),Ember.set(this.modelForData,"secretData",this.secretData.toJSON())},handleWrapClick:function(){var e=this
this.set("isWrapping",!0),this.isV2?this.store.adapterFor("secret-v2-version").queryRecord(this.modelForData.id,{wrapTTL:1800}).then(function(t){e.set("wrappedData",t.wrap_info.token),e.flashMessages.success("Secret Successfully Wrapped!")}).catch(function(){e.flashMessages.error("Could Not Wrap Secret")}).finally(function(){e.set("isWrapping",!1)}):this.store.adapterFor("secret").queryRecord(null,null,{backend:this.model.backend,id:this.modelForData.id,wrapTTL:1800}).then(function(t){e.set("wrappedData",t.wrap_info.token),e.flashMessages.success("Secret Successfully Wrapped!")}).catch(function(){e.flashMessages.error("Could Not Wrap Secret")}).finally(function(){e.set("isWrapping",!1)})},clearWrappedData:function(){this.set("wrappedData",null)},handleCopySuccess:function(){this.flashMessages.success("Copied Wrapped Data!"),this.send("clearWrappedData")},handleCopyError:function(){this.flashMessages.error("Could Not Copy Wrapped Data"),this.send("clearWrappedData")},createOrUpdateKey:function(e,t){var n=this
t.preventDefault()
var a=this.modelForData
"create"===e&&Ember.isBlank(a.get("path")||a.id)||this.persistKey(function(){n.transitionToRoute("vault.cluster.secrets.backend.show",n.model.id)})},deleteKey:function(){var e=this,t=this.model.id
this.model.destroyRecord().then(function(){e.navToNearestAncestor.perform(t)})},refresh:function(){this.onRefresh()},addRow:function(){var e=this.secretData
Ember.isNone(e.findBy("name",""))&&(e.pushObject({name:"",value:""}),this.send("handleChange")),this.checkRows()},deleteRow:function(e){var t=this.secretData,n=t.findBy("name",e)
Ember.isBlank(n.name)||(t.removeObject(n),this.checkRows(),this.send("handleChange"))},toggleAdvanced:function(e){this.onToggleAdvancedEdit(e)},codemirrorUpdated:function(e,t){this.set("error",null),t.performLint()
var n=0===t.state.lint.marked.length
if(n)try{this.secretData.fromJSONString(e),Ember.set(this.modelForData,"secretData",this.secretData.toJSON())}catch(e){this.set("error",e.message)}this.set("hasLintError",!n),this.set("codemirrorString",e)},formatJSON:function(){this.set("codemirrorString",this.secretData.toJSONString(!0))}}})}),define("vault/components/secret-link",["exports","vault/utils/path-encoding-helpers"],function(e,t){function n(e){var n=e.mode,a=e.secret,s=e.queryParams,r=void 0,l="vault.cluster.secrets.backend."+n
return r=a&&" "!==a?[l,(0,t.encodePath)(a)]:[l+"-root"],s&&r.push(s),r}Object.defineProperty(e,"__esModule",{value:!0}),e.linkParams=n,e.default=Ember.Component.extend({onLinkClick:function(){},tagName:"",mode:"list",secret:null,queryParams:null,ariaLabel:null,linkParams:Ember.computed("mode","secret","queryParams",function(){return n(this.getProperties("mode","secret","queryParams"))})})}),define("vault/components/secret-list-header",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:"",isCertTab:!1,isConfigure:!1,baseKey:null,backendCrumb:null,model:null,options:null})}),define("vault/components/secret-version-menu",["exports","vault/macros/maybe-query-record"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
e.default=Ember.Component.extend({tagName:"",store:Ember.inject.service(),version:null,useDefaultTrigger:!1,onRefresh:function(){},deleteVersionPath:(0,t.maybeQueryRecord)("capabilities",function(e){var t=JSON.parse(e.version.id),a=n(t,2)
return{id:a[0]+"/delete/"+a[1]}},"version.id"),canDeleteVersion:Ember.computed.alias("deleteVersionPath.canUpdate"),destroyVersionPath:(0,t.maybeQueryRecord)("capabilities",function(e){var t=JSON.parse(e.version.id),a=n(t,2)
return{id:a[0]+"/destroy/"+a[1]}},"version.id"),canDestroyVersion:Ember.computed.alias("destroyVersionPath.canUpdate"),undeleteVersionPath:(0,t.maybeQueryRecord)("capabilities",function(e){var t=JSON.parse(e.version.id),a=n(t,2)
return{id:a[0]+"/undelete/"+a[1]}},"version.id"),canUndeleteVersion:Ember.computed.alias("undeleteVersionPath.canUpdate"),isFetchingVersionCapabilities:Ember.computed.or("deleteVersionPath.isPending","destroyVersionPath.isPending","undeleteVersionPath.isPending"),actions:{deleteVersion:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"destroy"
return this.store.adapterFor("secret-v2-version").v2DeleteOperation(this.store,this.version.id,e).then(this.onRefresh)}}})}),define("vault/components/section-tabs",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t=Ember.Component.extend({tagName:"",model:null,tabType:"authSettings"})
t.reopenClass({positionalParams:["model","tabType","paths"]}),e.default=t}),define("vault/components/shamir-flow",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t]
for(var a in n)Object.prototype.hasOwnProperty.call(n,a)&&(e[a]=n[a])}return e},n={key:null,loading:!1,errors:[],threshold:null,progress:null,pgp_key:null,haveSavedPGPKey:!1,started:!1,generateWithPGP:!1,pgpKeyFile:{value:""},nonce:""}
e.default=Ember.Component.extend(n,{tagName:"",store:Ember.inject.service(),formText:null,fetchOnInit:!1,buttonText:"Submit",thresholdPath:"required",generateAction:!1,init:function(){this._super.apply(this,arguments),this.get("fetchOnInit")&&this.attemptProgress()},didInsertElement:function(){this._super.apply(this,arguments),this.onUpdate(this.getProperties(Object.keys(n)))},onUpdate:function(){},onShamirSuccess:function(){},isComplete:function(e){return!0===e.complete},stopLoading:function(){this.setProperties({loading:!1,errors:[],key:null})},reset:function(){this.setProperties(n)},hasProgress:Ember.computed.gt("progress",0),actionSuccess:function(e){var n=this.onUpdate,a=this.isComplete,s=this.onShamirSuccess,r=this.thresholdPath,l=Ember.get(e,r),i=t({},e,{threshold:l})
this.stopLoading(),this.otp&&!i.otp&&delete i.otp,this.setProperties(i),n(i),a(i)&&(this.reset(),s(i))},actionError:function(e){if(this.stopLoading(),400!==e.httpStatus)throw e
this.set("errors",e.errors)},generateStep:Ember.computed("generateWithPGP","haveSavedPGPKey","pgp_key",function(){var e=this.generateWithPGP,t=this.pgp_key,n=this.haveSavedPGPKey
return e||t?e?t&&n?"beginGenerationWithPGP":"providePGPKey":void 0:"chooseMethod"}),extractData:function(e){var t=this.get("generateAction"),n=this.get("started"),a=this.get("generateWithPGP"),s=this.get("nonce")
return!t||n?(s&&(e.nonce=s),e):a?{pgp_key:e.pgp_key}:{attempt:e.attempt}},attemptProgress:function(e){var t=this,n=!e,a=this.get("action")
a=a&&Ember.String.camelize(a),this.set("loading",!0)
var s=this.get("store").adapterFor("cluster")
s[a].call(s,e,{checkStatus:n}).then(function(e){return t.actionSuccess(e)},function(){return t.actionError.apply(t,arguments)})},actions:{reset:function(){this.reset(),this.set("encoded_token",null),this.set("otp",null)},onSubmit:function(e){e.key&&this.attemptProgress(this.extractData(e))},startGenerate:function(e){this.generateAction&&(e.attempt=!0),this.attemptProgress(this.extractData(e))},setKey:function(e,t){this.set("pgp_key",t.value),this.set("pgpKeyFile",t)},savePGPKey:function(){this.get("pgp_key")&&this.set("haveSavedPGPKey",!0)}}})}),define("vault/components/shamir-progress",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({threshold:null,progress:null,classNames:["shamir-progress"],progressDecimal:Ember.computed("threshold","progress",function(){var e=this.getProperties("threshold","progress"),t=e.threshold,n=e.progress
return t&&n?n/t:0})})}),define("vault/components/splash-page",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({version:Ember.inject.service(),auth:Ember.inject.service(),store:Ember.inject.service(),tagName:"",activeCluster:Ember.computed("auth.activeCluster",function(){return this.get("store").peekRecord("cluster",this.get("auth.activeCluster"))})})}),define("vault/components/splash-page/splash-content",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:""})})
define("vault/components/splash-page/splash-footer",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:""})}),define("vault/components/splash-page/splash-header",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:""})}),define("vault/components/status-menu",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({currentCluster:Ember.inject.service("current-cluster"),cluster:Ember.computed.alias("currentCluster.cluster"),auth:Ember.inject.service(),store:Ember.inject.service(),media:Ember.inject.service(),version:Ember.inject.service(),type:"cluster",itemTag:null,partialName:Ember.computed("type",function(){return"partials/status/"+this.type}),glyphName:Ember.computed("type",function(){return{cluster:"status-indicator",user:"user-square-outline"}[this.type]}),activeCluster:Ember.computed("auth.activeCluster",function(){return this.get("store").peekRecord("cluster",this.get("auth.activeCluster"))}),currentToken:Ember.computed("auth.currentToken",function(){return this.get("auth.currentToken")})})}),define("vault/components/string-list",["exports","core/components/string-list"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/text-file",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({classNames:["box","is-fullwidth","is-marginless","is-shadowless"],classNameBindings:["inputOnly:is-paddingless"],file:null,index:null,onChange:function(){},inputOnly:!1,label:null,fileHelpText:"Select a file from your computer",textareaHelpText:"Enter the value as text",readFile:function(e){var t=this,n=new FileReader
n.onload=function(){return t.setFile(n.result,e.name)},n.readAsText(e)},setFile:function(e,t){this.get("onChange")(this.get("index"),{value:e,fileName:t})},actions:{pickedFile:function(e){var t=e.target.files
if(t.length)for(var n=0,a=t.length;n<a;n++)this.readFile(t[n])},updateData:function(e){var t=this.get("file")
Ember.set(t,"value",e.target.value),this.get("onChange")(this.get("index"),this.get("file"))},clearFile:function(){this.get("onChange")(this.get("index"),{value:""})}}})}),define("vault/components/toggle-button",["exports","core/components/toggle-button"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/token-expire-warning",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({tagName:""})}),define("vault/components/tool-actions-form",["exports","date-fns"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n={token:null,rewrap_token:null,errors:[],wrap_info:null,creation_time:null,creation_ttl:null,data:"{\n}",unwrap_data:null,details:null,wrapTTL:null,sum:null,random_bytes:null,input:null},a=["lookup","wrap","unwrap","rewrap"]
e.default=Ember.Component.extend(n,{store:Ember.inject.service(),wizard:Ember.inject.service(),bytes:32,format:"base64",algorithm:"sha2-256",tagName:"",unwrapActiveTab:"data",didReceiveAttrs:function(){this._super.apply(this,arguments),this.checkAction()},selectedAction:null,reset:function(){this.isDestroyed||this.isDestroying||Ember.setProperties(this,n)},checkAction:function(){var e=Ember.get(this,"selectedAction")
e!==Ember.get(this,"oldSelectedAction")&&this.reset(),Ember.set(this,"oldSelectedAction",e)},dataIsEmpty:Ember.computed.match("data",new RegExp(n.data)),expirationDate:Ember.computed("creation_time","creation_ttl",function(){var e=this.getProperties("creation_time","creation_ttl"),n=e.creation_time,a=e.creation_ttl
return n&&a?(0,t.addSeconds)(n,a):null}),handleError:function(e){Ember.set(this,"errors",e.errors)},handleSuccess:function(e,t){var n,a,s,r={},l=e&&e.data||e.auth
if(l&&"unwrap"===t){var i={"Request ID":e.request_id,"Lease ID":e.lease_id||"None",Renewable:e.renewable?"Yes":"No","Lease Duration":e.lease_duration||"None"}
r=Ember.assign({},r,{unwrap_data:l},{details:i})}if(r=Ember.assign({},r,l),e&&e.wrap_info){var o="rewrap"===t?"rewrap_token":"token"
r=Ember.assign({},r,(n={},a=o,s=e.wrap_info.token,a in n?Object.defineProperty(n,a,{value:s,enumerable:!0,configurable:!0,writable:!0}):n[a]=s,n))}(r.token||r.rewrap_token||r.unwrap_data||"lookup"===t)&&this.get("wizard").transitionFeatureMachine(this.get("wizard.featureState"),"CONTINUE"),Ember.setProperties(this,r)},getData:function(){var e=Ember.get(this,"selectedAction")
return a.includes(e)?Ember.get(this,"dataIsEmpty")?{token:(Ember.get(this,"token")||"").trim()}:JSON.parse(Ember.get(this,"data")):"random"===e?this.getProperties("bytes","format"):"hash"===e?this.getProperties("input","format","algorithm"):void 0},actions:{doSubmit:function(e){var t=this
e.preventDefault()
var n=Ember.get(this,"selectedAction"),a="wrap"===n?Ember.get(this,"wrapTTL"):null,s=this.getData()
Ember.setProperties(this,{errors:null,wrap_info:null,creation_time:null,creation_ttl:null}),Ember.get(this,"store").adapterFor("tools").toolAction(n,s,{wrapTTL:a}).then(function(e){return t.handleSuccess(e,n)},function(){return t.handleError.apply(t,arguments)})},onClear:function(){this.reset()},codemirrorUpdated:function(e,t){t.performLint()
var n=t.state.lint.marked.length>0
Ember.setProperties(this,{buttonDisabled:n,data:e})}}})}),define("vault/components/tool-tip",["exports","core/components/tool-tip"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/toolbar-actions",["exports","core/components/toolbar-actions"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/toolbar-download-button",["exports","core/components/toolbar-download-button"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/toolbar-filters",["exports","core/components/toolbar-filters"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/toolbar-link",["exports","core/components/toolbar-link"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/toolbar-secret-link",["exports","vault/components/outer-html"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({glyph:Ember.computed("type",function(){return"add"==this.type?"plus-plain":"chevron-right"}),tagName:""})}),define("vault/components/toolbar",["exports","core/components/toolbar"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/transit-edit",["exports","ember-concurrency","vault/mixins/focus-on-insert","vault/lib/keycodes"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
e.default=Ember.Component.extend(n.default,{router:Ember.inject.service(),wizard:Ember.inject.service(),mode:null,onDataChange:function(){},onRefresh:function(){},key:null,requestInFlight:Ember.computed.or("key.isLoading","key.isReloading","key.isSaving"),willDestroyElement:function(){this._super.apply(this,arguments),this.key&&this.key.isError&&this.key.rollbackAttributes()},waitForKeyUp:(0,t.task)(regeneratorRuntime.mark(function e(){var n
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=3,(0,t.waitForEvent)(document.body,"keyup")
case 3:n=e.sent,this.onEscape(n),e.next=0
break
case 7:case"end":return e.stop()}},e,this)})).on("didInsertElement").cancelOn("willDestroyElement"),transitionToRoute:function(){var e;(e=this.get("router")).transitionTo.apply(e,arguments)},onEscape:function(e){e.keyCode===a.default.ESC&&"show"===this.get("mode")&&this.transitionToRoute("vault.cluster.secrets.backend.list-root")},hasDataChanges:function(){Ember.get(this,"onDataChange")(Ember.get(this,"key.hasDirtyAttributes"))},persistKey:function(e,t){var n=this,a=Ember.get(this,"key")
return a[e]().then(function(){Ember.get(a,"isError")||("secret"===n.get("wizard.featureState")?n.get("wizard").transitionFeatureMachine("secret","CONTINUE"):"encryption"===n.get("wizard.featureState")&&n.get("wizard").transitionFeatureMachine("encryption","CONTINUE","transit"),t(a))})},actions:{createOrUpdateKey:function(e,t){var n=this
t.preventDefault()
var a=this.get("key.id")
"create"===e&&Ember.isBlank(a)||this.persistKey("save",function(){n.hasDataChanges(),n.transitionToRoute("vault.cluster.secrets.backend.show",a)},"create"===e)},setValueOnKey:function(e,t){Ember.set(Ember.get(this,"key"),e,t.target.checked)},derivedChange:function(e){Ember.get(this,"key").setDerived(e)},convergentEncryptionChange:function(e){Ember.get(this,"key").setConvergentEncryption(e)},refresh:function(){this.get("onRefresh")()},deleteKey:function(){var e=this
this.persistKey("destroyRecord",function(){e.hasDataChanges(),e.transitionToRoute("vault.cluster.secrets.backend.list-root")})}}})}),define("vault/components/transit-key-actions",["exports","ember-copy"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n={hash_algorithm:"sha2-256",algorithm:"sha2-256",signature_algorithm:"pss",bits:256,bytes:32,ciphertext:null,context:null,format:"base64",hmac:null,input:null,key_version:0,keys:null,nonce:null,param:"wrapped",prehashed:!1,plaintext:null,random_bytes:null,signature:null,sum:null,exportKeyType:null,exportKeyVersion:null,wrappedToken:null,valid:null,plaintextOriginal:null,didDecode:!1,verification:"Signature"},a={sign:["input","hash_algorithm","key_version","prehashed","signature_algorithm"],verify:["input","hmac","signature","hash_algorithm","prehashed"],hmac:["input","algorithm","key_version"],encrypt:["plaintext","context","nonce","key_version"],decrypt:["ciphertext","context","nonce"],rewrap:["ciphertext","context","nonce","key_version"]}
e.default=Ember.Component.extend(n,{store:Ember.inject.service(),selectedAction:null,key:null,onRefresh:function(){},init:function(){this._super.apply(this,arguments),Ember.get(this,"selectedAction")||Ember.set(this,"selectedAction",Ember.get(this,"key.supportedActions.firstObject"))},didReceiveAttrs:function(){this._super.apply(this,arguments),this.checkAction(),"export"===Ember.get(this,"selectedAction")&&this.setExportKeyDefaults()},setExportKeyDefaults:function(){var e=Ember.get(this,"key.exportKeyTypes.firstObject"),t=Ember.get(this,"key.validKeyVersions.lastObject")
this.setProperties({exportKeyType:e,exportKeyVersion:t})},keyIsRSA:Ember.computed("key.type",function(){var e=Ember.get(this,"key.type")
return"rsa-2048"===e||"rsa-4096"===e}),getModelInfo:function(){var e=Ember.get(this,"key")||Ember.get(this,"backend")
return e?{backend:Ember.get(e,"backend")||Ember.get(e,"id"),id:Ember.get(e,"id")}:null},checkAction:function(){var e=Ember.get(this,"selectedAction"),t=Ember.get(this,"oldSelectedAction")
this.resetParams(t,e),Ember.set(this,"oldSelectedAction",e)},resetParams:function(e,s){var r=(0,t.copy)(n),l=void 0
!(!e||"datakey"===e||"rewrap"===e&&!Ember.get(this,"key.supportsEncryption"))&&s&&(l=a[s]),l&&l.forEach(function(e){return delete r[e]}),this.setProperties(r),"export"===s&&this.setExportKeyDefaults()},handleError:function(e){this.set("errors",e.errors)},handleSuccess:function(e,t,n){var a={}
if(e&&e.data){if("export"===n&&e.data.keys){var s=e.data,r=s.keys,l=s.type,i=s.name
e.data.keys={keys:r,type:l,name:i}}a=Ember.assign({},a,e.data)}t.wrapTTL&&(a=Ember.assign({},a,{wrappedToken:e.wrap_info.token})),this.setProperties(a),"rotate"===n&&this.get("onRefresh")()},compactData:function(e){var t=Ember.get(this,"key.type"),n="rsa-2048"===t||"rsa-4096"===t
return Object.keys(e).reduce(function(t,a){return"signature_algorithm"!==a||n?(e[a]&&(t[a]=e[a]),t):t},{})},actions:{onActionChange:function(e){Ember.set(this,"selectedAction",e),this.checkAction()},onClear:function(){this.resetParams(null,Ember.get(this,"selectedAction"))},clearParams:function(e){var t=this;(Array.isArray(e)?e:[e]).forEach(function(e){return t.set(e,null)})},doSubmit:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},a=this.getModelInfo(),s=a.backend,r=a.id,l=this.get("selectedAction"),i=e?this.compactData(e):null
this.setProperties({errors:null,result:null}),this.get("store").adapterFor("transit-key").keyAction(l,{backend:s,id:r,payload:i},n).then(function(e){return t.handleSuccess(e,n,l)},function(){return t.handleError.apply(t,arguments)})}}})}),define("vault/components/ttl-picker",["exports","core/components/ttl-picker"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/ui-wizard",["exports","xstate"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({classNames:["ui-wizard-container"],wizard:Ember.inject.service(),auth:Ember.inject.service(),shouldRender:Ember.computed("wizard.showWhenUnauthenticated","auth.currentToken",function(){return this.get("auth.currentToken")||this.get("wizard.showWhenUnauthenticated")}),currentState:Ember.computed.alias("wizard.currentState"),featureState:Ember.computed.alias("wizard.featureState"),featureComponent:Ember.computed.alias("wizard.featureComponent"),tutorialComponent:Ember.computed.alias("wizard.tutorialComponent"),componentState:Ember.computed.alias("wizard.componentState"),nextFeature:Ember.computed.alias("wizard.nextFeature"),nextStep:Ember.computed.alias("wizard.nextStep"),actions:{dismissWizard:function(){this.get("wizard").transitionTutorialMachine(this.get("currentState"),"DISMISS")},advanceWizard:function(){var e=(0,t.matchesState)("init",this.get("wizard.currentState"))&&this.get("wizard.initEvent")||"CONTINUE"
this.get("wizard").transitionTutorialMachine(this.get("currentState"),e)},advanceFeature:function(){this.get("wizard").transitionFeatureMachine(this.get("featureState"),"CONTINUE")},finishFeature:function(){this.get("wizard").transitionFeatureMachine(this.get("featureState"),"DONE")},repeatStep:function(){this.get("wizard").transitionFeatureMachine(this.get("featureState"),"REPEAT",this.get("componentState"))},resetFeature:function(){this.get("wizard").transitionFeatureMachine(this.get("featureState"),"RESET",this.get("componentState"))},pauseWizard:function(){this.get("wizard").transitionTutorialMachine(this.get("currentState"),"PAUSE")}}})}),define("vault/components/upgrade-page",["exports","core/components/upgrade-page"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/vault-logo-spinner",["exports","core/components/vault-logo-spinner"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/components/wizard-content",["exports","vault/helpers/wizard-constants"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e}
e.default=Ember.Component.extend({wizard:Ember.inject.service(),classNames:["ui-wizard"],glyph:null,headerText:null,selectProgress:null,currentMachine:Ember.computed.alias("wizard.currentMachine"),tutorialState:Ember.computed.alias("wizard.currentState"),tutorialComponent:Ember.computed.alias("wizard.tutorialComponent"),showProgress:Ember.computed("wizard.featureComponent","tutorialState",function(){return this.tutorialComponent.includes("active")&&(this.tutorialState.includes("init.active")||this.wizard.featureComponent&&this.wizard.featureMachineHistory)}),featureMachineHistory:Ember.computed.alias("wizard.featureMachineHistory"),totalFeatures:Ember.computed("wizard.featureList",function(){return this.wizard.featureList.length}),completedFeatures:Ember.computed("wizard.currentMachine",function(){return this.wizard.getCompletedFeatures()}),currentFeatureProgress:Ember.computed("featureMachineHistory.[]",function(){if(this.tutorialState.includes("active.feature")){var e=t.FEATURE_MACHINE_STEPS[this.currentMachine]
return"secrets"===this.currentMachine&&(this.featureMachineHistory.includes("secret")&&(e=e.secret.secret),this.featureMachineHistory.includes("list")&&(e=e.secret.list),this.featureMachineHistory.includes("encryption")&&(e=e.encryption),(this.featureMachineHistory.includes("role")||"object"===(void 0===e?"undefined":n(e)))&&(e=e.role)),{percentage:this.featureMachineHistory.length/e*100,feature:this.currentMachine,text:"Step "+this.featureMachineHistory.length+" of "+e}}return null}),currentTutorialProgress:Ember.computed("tutorialState",function(){if(this.tutorialState.includes("init.active")){var e=this.tutorialState.split(".")[2],n=t.INIT_STEPS.indexOf(e)+1
return{percentage:n/t.INIT_STEPS.length*100,text:"Step "+n+" of "+t.INIT_STEPS.length}}return null}),progressBar:Ember.computed("currentFeatureProgress","currentFeature","currentTutorialProgress",function(){var e=this,t=[]
return this.currentTutorialProgress?t.push({style:Ember.String.htmlSafe("width:"+this.currentTutorialProgress.percentage+"%;"),completed:!1,showIcon:!0}):this.currentFeatureProgress&&(this.completedFeatures.forEach(function(e){t.push({style:Ember.String.htmlSafe("width:100%;"),completed:!0,feature:e,showIcon:!0})}),this.wizard.featureList.forEach(function(n){n===e.currentMachine?t.push({style:Ember.String.htmlSafe("width:"+e.currentFeatureProgress.percentage+"%;"),completed:100==e.currentFeatureProgress.percentage,feature:n,showIcon:!0}):t.push({style:Ember.String.htmlSafe("width:0%;"),completed:!1,feature:n,showIcon:!0})})),t}),actions:{dismissWizard:function(){this.wizard.transitionTutorialMachine(this.wizard.currentState,"DISMISS")}}})}),define("vault/components/wizard-section",["exports","vault/components/outer-html"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({headerText:null,headerIcon:null,docText:null,docPath:null,instructions:null})}),define("vault/components/wizard/features-selection",["exports","vault/helpers/wizard-constants"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({wizard:Ember.inject.service(),version:Ember.inject.service(),permissions:Ember.inject.service(),init:function(){this._super.apply(this,arguments),this.maybeHideFeatures()},maybeHideFeatures:function(){var e=this;(this.get("allFeatures").forEach(function(t){t.disabled=e.doesNotHavePermission(t.requiredPermissions)}),!1===this.get("showReplication"))&&(this.get("allFeatures").findBy("key","replication").show=!1)},doesNotHavePermission:function(e){var t=this
return!Object.keys(e).every(function(n){return t.permissions.hasPermission(n,e[n])})},estimatedTime:Ember.computed("selectedFeatures",function(){var e=0,n=!0,a=!1,s=void 0
try{for(var r,l=Object.keys(t.FEATURE_MACHINE_TIME)[Symbol.iterator]();!(n=(r=l.next()).done);n=!0){var i=r.value
this.selectedFeatures.includes(i)&&(e+=t.FEATURE_MACHINE_TIME[i])}}catch(e){a=!0,s=e}finally{try{!n&&l.return&&l.return()}finally{if(a)throw s}}return e}),selectProgress:Ember.computed("selectedFeatures",function(){var e=this.selectedFeatures.map(function(e){return{style:Ember.String.htmlSafe("width:0%;"),completed:!1,showIcon:!0,feature:e}})
return 0===e.length&&(e=[{style:Ember.String.htmlSafe("width:0%;"),showIcon:!1}]),e}),allFeatures:Ember.computed(function(){return[{key:"secrets",name:"Secrets",steps:["Enabling a Secrets Engine","Adding a secret"],selected:!1,show:!0,disabled:!1,requiredPermissions:{"sys/mounts/example":["update"]}},{key:"authentication",name:"Authentication",steps:["Enabling an Auth Method","Managing your Auth Method"],selected:!1,show:!0,disabled:!1,requiredPermissions:{"sys/auth":["read"],"sys/auth/foo":["update","sudo"]}},{key:"policies",name:"Policies",steps:["Choosing a policy type","Creating a policy","Deleting your policy","Other types of policies"],selected:!1,show:!0,disabled:!1,requiredPermissions:{"sys/policies/acl":["list"]}},{key:"replication",name:"Replication",steps:["Setting up replication","Your cluster information"],selected:!1,show:!0,disabled:!1,requiredPermissions:{"sys/replication/performance/primary/enable":["update"],"sys/replication/dr/primary/enable":["update"]}},{key:"tools",name:"Tools",steps:["Wrapping data","Lookup wrapped data","Rewrapping your data","Unwrapping your data"],selected:!1,show:!0,disabled:!1,requiredPermissions:{"sys/wrapping/wrap":["update"],"sys/wrapping/lookup":["update"],"sys/wrapping/unwrap":["update"],"sys/wrapping/rewrap":["update"]}}]}),showReplication:Ember.computed("version.{hasPerfReplication,hasDRReplication}",function(){return this.get("version.hasPerfReplication")||this.get("version.hasDRReplication")}),selectedFeatures:Ember.computed("allFeatures.@each.selected",function(){return this.get("allFeatures").filterBy("selected").mapBy("key")}),cannotStartWizard:Ember.computed("selectedFeatures",function(){return!this.get("selectedFeatures").length}),actions:{saveFeatures:function(){var e=this.get("wizard")
e.saveFeatures(this.get("selectedFeatures")),e.transitionTutorialMachine("active.select","CONTINUE")}}})}),define("vault/components/wizard/mounts-wizard",["exports","vault/helpers/mountable-secret-engines","vault/helpers/mountable-auth-methods","vault/helpers/supported-secret-backends","vault/helpers/supported-auth-backends"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=(0,a.supportedSecretBackends)(),l=(0,s.supportedAuthBackends)()
e.default=Ember.Component.extend({wizard:Ember.inject.service(),featureState:Ember.computed.alias("wizard.featureState"),currentState:Ember.computed.alias("wizard.currentState"),currentMachine:Ember.computed.alias("wizard.currentMachine"),mountSubtype:Ember.computed.alias("wizard.componentState"),fullNextStep:Ember.computed.alias("wizard.nextStep"),nextFeature:Ember.computed.alias("wizard.nextFeature"),nextStep:Ember.computed("fullNextStep",function(){return this.get("fullNextStep").split(".").lastObject}),needsEncryption:Ember.computed("mountSubtype",function(){return"transit"===this.get("mountSubtype")}),stepComponent:Ember.computed.alias("wizard.stepComponent"),detailsComponent:Ember.computed("mountSubtype",function(){var e="secrets"===this.get("currentMachine")?"engine":"method"
return this.get("mountSubtype")?"wizard/"+this.get("mountSubtype")+"-"+e:null}),isSupported:Ember.computed("mountSubtype",function(){return"secrets"===this.get("currentMachine")?r.includes(this.get("mountSubtype")):l.includes(this.get("mountSubtype"))}),mountName:Ember.computed("mountSubtype",function(){var e=this
if("secrets"===this.get("currentMachine")){var a=(0,t.engines)().find(function(t){return t.type===e.get("mountSubtype")})
if(a)return a.displayName}else{var s=(0,n.methods)().find(function(t){return t.type===e.get("mountSubtype")})
if(s)return s.displayName}return null}),actionText:Ember.computed("mountSubtype",function(){switch(this.get("mountSubtype")){case"aws":return"Generate credential"
case"ssh":return"Sign keys"
case"pki":return"Generate certificate"
default:return null}}),onAdvance:function(){},onRepeat:function(){},onReset:function(){},onDone:function(){}})}),define("vault/components/wrap-ttl",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Component.extend({onChange:null,wrapResponse:!0,ttl:null,wrapTTL:Ember.computed("wrapResponse","ttl",function(){var e=this.getProperties("wrapResponse","ttl"),t=e.wrapResponse,n=e.ttl
return t?n:null}),didRender:function(){this._super.apply(this,arguments),Ember.get(this,"onChange")(Ember.get(this,"wrapTTL"))},init:function(){this._super.apply(this,arguments)},layout:Ember.HTMLBars.template({id:"4BOzQK7t",block:'{"symbols":[],"statements":[[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"div"],[11,"class","b-checkbox"],[9],[0,"\\n        "],[7,"input"],[11,"id","wrap-response"],[11,"class","styled"],[11,"name","wrap-response"],[12,"checked",[21,"wrapResponse"]],[12,"onchange",[27,"action",[[22,0,[]],"changedValue","wrapResponse"],null]],[11,"type","checkbox"],[9],[10],[0,"\\n        "],[7,"label"],[11,"for","wrap-response"],[11,"class","is-label"],[9],[0,"\\n          Wrap response\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[23,["wrapResponse"]]],null,{"statements":[[0,"        "],[1,[27,"ttl-picker",null,[["data-test-wrap-ttl-picker","labelText","onChange"],[true,"Wrap TTL",[27,"action",[[22,0,[]],[27,"mut",[[23,["ttl"]]],null]],null]]]],false],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "]],"hasEval":false}',meta:{}}),actions:{changedValue:function(e,t){var n=t.target,a=n.type,s=n.value,r=n.checked,l="checkbox"===a?r:s
Ember.set(this,e,l),Ember.get(this,"onChange")(Ember.get(this,"wrapTTL"))}}})}),define("vault/config/asset-manifest",["exports","require","vault/config/environment"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=n.default.modulePrefix,s=a+"/config/asset-manifest",r=a+"/config/node-asset-manifest",l={}
try{if(t.default.has(r))l=(0,t.default)(r).default
else{var i=document.querySelector('meta[name="'+s+'"]').getAttribute("content")
l=JSON.parse(unescape(i))}}catch(e){throw new Error('Failed to load asset manifest. For browser environments, verify the meta tag with name "'+s+'" is present. For non-browser environments, verify that you included the node-asset-manifest module.')}e.default=l}),define("vault/controllers/application",["exports","vault/config/environment"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({env:t.default.environment,auth:Ember.inject.service(),store:Ember.inject.service(),activeCluster:Ember.computed("auth.activeCluster",function(){var e=this.get("auth.activeCluster")
return e?this.get("store").peekRecord("cluster",e):null}),activeClusterName:Ember.computed("activeCluster",function(){var e=this.get("activeCluster")
return e?e.get("name"):null})})}),define("vault/controllers/vault",["exports","vault/config/environment"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({queryParams:[{wrappedToken:"wrapped_token",redirectTo:"redirect_to"}],wrappedToken:"",redirectTo:"",env:t.default.environment,auth:Ember.inject.service(),store:Ember.inject.service(),activeCluster:Ember.computed("auth.activeCluster",function(){var e=this.get("auth.activeCluster")
return e?this.get("store").peekRecord("cluster",e):null}),activeClusterName:Ember.computed("activeCluster",function(){var e=this.get("activeCluster")
return e?e.get("name"):null})})}),define("vault/controllers/vault/cluster",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({auth:Ember.inject.service(),store:Ember.inject.service(),media:Ember.inject.service(),router:Ember.inject.service(),permissions:Ember.inject.service(),namespaceService:Ember.inject.service("namespace"),vaultVersion:Ember.inject.service("version"),console:Ember.inject.service(),queryParams:[{namespaceQueryParam:{scope:"controller",as:"namespace"}}],namespaceQueryParam:"",onQPChange:Ember.observer("namespaceQueryParam",function(){this.get("namespaceService").setNamespace(this.get("namespaceQueryParam"))}),consoleOpen:Ember.computed.alias("console.isOpen"),activeCluster:Ember.computed("auth.activeCluster",function(){return this.get("store").peekRecord("cluster",this.get("auth.activeCluster"))}),activeClusterName:Ember.computed("activeCluster",function(){var e=this.get("activeCluster")
return e?e.get("name"):null}),showNav:Ember.computed("router.currentRouteName","activeClusterName","auth.currentToken","activeCluster.{dr.isSecondary,needsInit,sealed}",function(){return!(this.get("activeCluster.dr.isSecondary")||this.get("activeCluster.needsInit")||this.get("activeCluster.sealed"))&&(!(!this.activeClusterName||!this.auth.currentToken||"vault.cluster.auth"===this.router.currentRouteName)||void 0)}),actions:{toggleConsole:function(){this.toggleProperty("consoleOpen")}}})})
define("vault/controllers/vault/cluster/access/control-groups-configure",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({actions:{onSave:function(e){"destroyRecord"===e.saveType&&this.send("reload")}}})}),define("vault/controllers/vault/cluster/access/identity/aliases/add",["exports","vault/controllers/vault/cluster/access/identity/create"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({showRoute:"vault.cluster.access.identity.aliases.show"})}),define("vault/controllers/vault/cluster/access/identity/aliases/edit",["exports","vault/controllers/vault/cluster/access/identity/aliases/add"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/controllers/vault/cluster/access/identity/aliases/index",["exports","core/mixins/list-controller"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(t.default,{actions:{onDelete:function(){this.send("reload")}}})}),define("vault/controllers/vault/cluster/access/identity/create",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({showRoute:"vault.cluster.access.identity.show",showTab:"details",navAfterSave:(0,t.task)(regeneratorRuntime.mark(function e(t){var n,a,s,r=t.saveType,l=t.model
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(n="delete"===r,a=l.get("identityType"),s={"entity-alias":"vault.cluster.access.identity.aliases.index","group-alias":"vault.cluster.access.identity.aliases.index",group:"vault.cluster.access.identity.index",entity:"vault.cluster.access.identity.index"}[a],n){e.next=8
break}return e.next=7,this.transitionToRoute(this.get("showRoute"),l.id,this.get("showTab"))
case 7:return e.abrupt("return")
case 8:return e.next=10,this.transitionToRoute(s)
case 10:case"end":return e.stop()}},e,this)}))})}),define("vault/controllers/vault/cluster/access/identity/edit",["exports","vault/controllers/vault/cluster/access/identity/create"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/controllers/vault/cluster/access/identity/index",["exports","core/mixins/list-controller"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(t.default,{flashMessages:Ember.inject.service(),actions:{delete:function(e){var t=this,n=e.get("identityType"),a=e.id
return e.destroyRecord().then(function(){t.send("reload"),t.get("flashMessages").success("Successfully deleted "+n+": "+a)}).catch(function(e){t.get("flashMessages").success("There was a problem deleting "+n+": "+a+" - "+(e.errors.join(" ")||e.message))})},toggleDisabled:function(e){var t=this,n=e.get("disabled")?["enabled","enabling"]:["disabled","disabling"],a=e.get("identityType"),s=e.id
e.toggleProperty("disabled"),e.save().then(function(){t.get("flashMessages").success("Successfully "+n[0]+" "+a+": "+s)}).catch(function(e){t.get("flashMessages").success("There was a problem "+n[1]+" "+a+": "+s+" - "+(e.errors.join(" ")||e.message))})},reloadRecord:function(e){e.reload()}}})}),define("vault/controllers/vault/cluster/access/identity/merge",["exports","vault/controllers/vault/cluster/access/identity/create"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/controllers/vault/cluster/access/leases/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({actions:{lookupLease:function(e){this.transitionToRoute("vault.cluster.access.leases.show",e)}}})}),define("vault/controllers/vault/cluster/access/leases/list-root",["exports","vault/controllers/vault/cluster/access/leases/list"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/controllers/vault/cluster/access/leases/list",["exports","vault/lib/key-utils","core/mixins/list-controller"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(n.default,{flashMessages:Ember.inject.service(),store:Ember.inject.service(),clusterController:Ember.inject.controller("vault.cluster"),backendCrumb:Ember.computed(function(){return{label:"leases",text:"leases",path:"vault.cluster.access.leases.list-root",model:this.get("clusterController.model.name")}}),isLoading:!1,filterIsFolder:Ember.computed("filter",function(){return!!t.default.keyIsFolder(this.get("filter"))}),emptyTitle:Ember.computed("baseKey.id","filter","filterIsFolder",function(){var e=this.get("baseKey.id"),t=this.filter
return""===e?"There are currently no leases.":this.filterIsFolder?t===e?"There are no leases under &quot;"+t+"&quot;.":"We couldn't find a prefix matching &quot;"+t+"&quot;.":void 0}),actions:{revokePrefix:function(e,t){var n=this,a=this.get("store").adapterFor("lease")
a[t?"forceRevokePrefix":"revokePrefix"].call(a,e).then(function(){return n.transitionToRoute("vault.cluster.access.leases.list-root").then(function(){n.get("flashMessages").success("All of the leases under "+e+" will be revoked.")})}).catch(function(t){var a=t.errors.join(".")
n.get("flashMessages").danger("There was an error attempting to revoke the prefix: "+e+". "+a+".")})}}})}),define("vault/controllers/vault/cluster/access/leases/show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({clusterController:Ember.inject.controller("vault.cluster"),backendCrumb:Ember.computed(function(){return{label:"leases",text:"leases",path:"vault.cluster.access.leases.list-root",model:this.get("clusterController.model.name")}}),flashMessages:Ember.inject.service(),actions:{revokeLease:function(e){var t=this
return e.destroyRecord().then(function(){return t.transitionToRoute("vault.cluster.access.leases.list-root")})},renewLease:function(e,t){var n=this,a=e.store.adapterFor("lease"),s=this.get("flashMessages")
a.renew(e.id,t).then(function(){n.send("refreshModel"),Ember.run.next(function(){s.success("The lease "+e.id+" was successfully renewed.")})}).catch(function(e){var t=e.errors.join(".")
s.danger("There was an error renewing the lease: "+t)})}}})}),define("vault/controllers/vault/cluster/access/method/item/list",["exports","vault/mixins/list-controller"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(t.default,{})}),define("vault/controllers/vault/cluster/access/methods",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({queryParams:{page:"page",pageFilter:"pageFilter"},page:1,pageFilter:null,filter:null,disableMethod:(0,t.task)(regeneratorRuntime.mark(function e(t){var n,a,s
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return n=t.getProperties("type","path"),a=n.type,s=n.path,e.prev=1,e.next=4,t.destroyRecord()
case 4:this.get("flashMessages").success("The "+a+" Auth Method at "+s+" has been disabled."),e.next=10
break
case 7:e.prev=7,e.t0=e.catch(1),this.get("flashMessages").danger("There was an error disabling Auth Method at "+s+": "+e.t0.errors.join(" ")+".")
case 10:case"end":return e.stop()}},e,this,[[1,7]])})).drop()})}),define("vault/controllers/vault/cluster/access/namespaces/create",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({namespaceService:Ember.inject.service("namespace"),actions:{onSave:function(e){if("save"===e.saveType)return this.get("namespaceService.findNamespacesForUser").perform(),this.transitionToRoute("vault.cluster.access.namespaces.index")}}})}),define("vault/controllers/vault/cluster/access/namespaces/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({namespaceService:Ember.inject.service("namespace"),accessibleNamespaces:Ember.computed.alias("namespaceService.accessibleNamespaces"),currentNamespace:Ember.computed.alias("namespaceService.path"),actions:{refreshNamespaceList:function(){this.get("namespaceService.findNamespacesForUser").perform()}}})}),define("vault/controllers/vault/cluster/auth",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({vaultController:Ember.inject.controller("vault"),clusterController:Ember.inject.controller("vault.cluster"),namespaceService:Ember.inject.service("namespace"),namespaceQueryParam:Ember.computed.alias("clusterController.namespaceQueryParam"),queryParams:[{authMethod:"with"}],wrappedToken:Ember.computed.alias("vaultController.wrappedToken"),authMethod:"",redirectTo:Ember.computed.alias("vaultController.redirectTo"),updateNamespace:(0,t.task)(regeneratorRuntime.mark(function e(n){return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,(0,t.timeout)(500)
case 2:this.get("namespaceService").setNamespace(n,!0),this.set("namespaceQueryParam",n)
case 4:case"end":return e.stop()}},e,this)})).restartable()})}),define("vault/controllers/vault/cluster/init",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),n={keyData:null,secret_shares:null,secret_threshold:null,pgp_keys:null,use_pgp:!1,loading:!1}
e.default=Ember.Controller.extend(n,{wizard:Ember.inject.service(),reset:function(){this.setProperties(n)},initSuccess:function(e){this.set("loading",!1),this.set("keyData",e),this.model.reload(),this.get("wizard").set("initEvent","SAVE"),this.get("wizard").transitionTutorialMachine(this.get("wizard.currentState"),"TOSAVE")},initError:function(e){if(this.set("loading",!1),400!==e.httpStatus)throw e
this.set("errors",e.errors)},keyFilename:Ember.computed("model.name",function(){return"vault-cluster-"+this.get("model.name")}),actions:{initCluster:function(e){var t=this,n=!!this.model.sealType&&"shamir"!==this.model.sealType
if(e.secret_shares){var a=parseInt(e.secret_shares,10)
e.secret_shares=a,n&&(e.stored_shares=1,e.recovery_shares=a)}if(e.secret_threshold){var s=parseInt(e.secret_threshold,10)
e.secret_threshold=s,n&&(e.recovery_threshold=s)}e.use_pgp||delete e.pgp_keys,e.use_pgp&&n&&(e.recovery_pgp_keys=e.pgp_keys),e.use_pgp_for_root||delete e.root_token_pgp_key,delete e.use_pgp,delete e.use_pgp_for_root
var r=this.model.store
this.setProperties({loading:!0,errors:null}),r.adapterFor("cluster").initCluster(e).then(function(e){return t.initSuccess(e)},function(){return t.initError.apply(t,arguments)})},setKeys:function(e){this.set("pgp_keys",e)},setRootKey:function(e){var n=t(e,1)[0]
this.set("root_token_pgp_key",n)}}})}),define("vault/controllers/vault/cluster/license",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({licenseSuccess:function(){this.send("doRefresh")},licenseError:function(){},actions:{saveModel:function(e){var t=this,n=e.text
this.model.save({text:n}).then(function(){return t.licenseSuccess()},function(){return t.licenseError()})}}})}),define("vault/controllers/vault/cluster/oidc-callback",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({queryParams:["state","code"],code:null,state:null})}),define("vault/controllers/vault/cluster/policies/create",["exports","vault/utils/trim-right","vault/mixins/policy-edit-controller"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(n.default,{showFileUpload:!1,file:null,actions:{setPolicyFromFile:function(e,n){var a=n.value,s=n.fileName,r=this.get("model")
if(r.set("policy",a),!r.get("name")){var l=(0,t.default)(s,[".json",".txt",".hcl",".policy"])
r.set("name",l)}this.set("showFileUpload",!1)}}})}),define("vault/controllers/vault/cluster/policies/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({flashMessages:Ember.inject.service(),wizard:Ember.inject.service(),queryParams:{page:"page",pageFilter:"pageFilter"},filter:null,page:1,pageFilter:null,filterFocused:!1,isLoading:!1,filterMatchesKey:Ember.computed("filter","model","model.[]",function(){var e=this.get("filter"),t=this.get("model")
return!!(t&&t.length&&t.findBy("id",e))}),firstPartialMatch:Ember.computed("filter","model","model.[]","filterMatchesKey",function(){var e=this.get("filter"),t=this.get("model")
if(t){var n=this.get("filterMatchesKey"),a=new RegExp("^"+e)
return n?null:t.find(function(e){return a.test(e.get("id"))})}}),actions:{setFilter:function(e){this.set("filter",e)},setFilterFocus:function(e){this.set("filterFocused",e)},deletePolicy:function(e){var t=this,n=e.get("policyType"),a=e.id,s=this.get("flashMessages")
e.destroyRecord().then(function(){t.send("reload"),s.success(n.toUpperCase()+' policy "'+a+'" was successfully deleted.'),"delete"===t.get("wizard.featureState")&&t.get("wizard").transitionFeatureMachine("delete","CONTINUE",n)}).catch(function(e){var t=e.errors?e.errors.join(""):e.message
s.danger("There was an error deleting the "+n.toUpperCase()+' policy "'+a+'": '+t+".")})}}})}),define("vault/controllers/vault/cluster/policy/edit",["exports","vault/mixins/policy-edit-controller"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(t.default)}),define("vault/controllers/vault/cluster/replication-dr-promote",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({queryParams:["action"],action:""})}),define("vault/controllers/vault/cluster/secrets/backend",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({preferAdvancedEdit:!1})}),define("vault/controllers/vault/cluster/secrets/backend/actions-root",["exports","vault/controllers/vault/cluster/secrets/backend/actions"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/controllers/vault/cluster/secrets/backend/actions",["exports","vault/mixins/backend-crumb"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(t.default,{queryParams:{selectedAction:"action"},actions:{refresh:function(){this.send("refreshModel")}}})}),define("vault/controllers/vault/cluster/secrets/backend/configuration",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({isConfigurable:Ember.computed("model.type",function(){return["aws","ssh","pki"].includes(this.get("model.type"))})})}),define("vault/controllers/vault/cluster/secrets/backend/create-root",["exports","vault/controllers/vault/cluster/secrets/backend/create"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/controllers/vault/cluster/secrets/backend/create",["exports","vault/mixins/backend-crumb"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(t.default,{backendController:Ember.inject.controller("vault.cluster.secrets.backend"),queryParams:["initialKey"],initialKey:"",actions:{refresh:function(){this.send("refreshModel")},toggleAdvancedEdit:function(e){this.set("preferAdvancedEdit",e),this.get("backendController").set("preferAdvancedEdit",e)}}})})
define("vault/controllers/vault/cluster/secrets/backend/credentials-root",["exports","vault/controllers/vault/cluster/secrets/backend/credentials"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/controllers/vault/cluster/secrets/backend/credentials",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({queryParams:["action"],action:"",reset:function(){this.set("action","")}})}),define("vault/controllers/vault/cluster/secrets/backend/edit-root",["exports","vault/controllers/vault/cluster/secrets/backend/edit"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/controllers/vault/cluster/secrets/backend/edit",["exports","vault/mixins/backend-crumb"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(t.default,{backendController:Ember.inject.controller("vault.cluster.secrets.backend"),queryParams:["version"],version:"",reset:function(){this.set("version","")},actions:{refresh:function(){this.send("refreshModel")},toggleAdvancedEdit:function(e){this.set("preferAdvancedEdit",e),this.get("backendController").set("preferAdvancedEdit",e)}}})}),define("vault/controllers/vault/cluster/secrets/backend/list-root",["exports","vault/controllers/vault/cluster/secrets/backend/list"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/controllers/vault/cluster/secrets/backend/list",["exports","vault/lib/key-utils","vault/mixins/backend-crumb","vault/mixins/with-nav-to-nearest-ancestor","core/mixins/list-controller"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(s.default,n.default,a.default,{flashMessages:Ember.inject.service(),queryParams:["page","pageFilter","tab"],tab:"",filterIsFolder:Ember.computed("filter",function(){return!!t.default.keyIsFolder(this.get("filter"))}),isConfigurableTab:Ember.computed("isCertTab","isConfigure",function(){return this.get("isCertTab")||this.get("isConfigure")}),actions:{chooseAction:function(e){this.set("selectedAction",e)},toggleZeroAddress:function(e,t){var n=this
e.toggleProperty("zeroAddress"),this.set("loading-"+e.id,!0),t.saveZeroAddressConfig().catch(function(t){e.set("zeroAddress",!1),n.get("flashMessages").danger(t.message)}).finally(function(){n.set("loading-"+e.id,!1)})},delete:function(e,t){var n=this,a=e.id
e.destroyRecord().then(function(){n.get("flashMessages").success(a+" was successfully deleted."),n.send("reload"),"secret"===t&&n.navToNearestAncestor.perform(a)})}}})}),define("vault/controllers/vault/cluster/secrets/backend/show-root",["exports","vault/controllers/vault/cluster/secrets/backend/show"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/controllers/vault/cluster/secrets/backend/show",["exports","vault/mixins/backend-crumb"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend(t.default,{backendController:Ember.inject.controller("vault.cluster.secrets.backend"),queryParams:["tab","version"],version:"",tab:"",reset:function(){this.set("tab",""),this.set("version","")},actions:{refresh:function(){this.send("refreshModel")},toggleAdvancedEdit:function(e){this.set("preferAdvancedEdit",e),this.get("backendController").set("preferAdvancedEdit",e)}}})}),define("vault/controllers/vault/cluster/secrets/backend/sign-root",["exports","vault/controllers/vault/cluster/secrets/backend/sign"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/controllers/vault/cluster/secrets/backend/sign",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({store:Ember.inject.service(),loading:!1,emptyData:"{\n}",actions:{sign:function(){var e=this
this.set("loading",!0),this.model.save().finally(function(){e.set("loading",!1)})},codemirrorUpdated:function(e,t,n){n.performLint(),n.state.lint.marked.length>0||Ember.set(this.get("model"),e,JSON.parse(t))},newModel:function(){var e=this.get("model"),t=e.get("role")
e.unloadRecord()
var n=this.get("store").createRecord("ssh-sign",{role:t,id:Ember.get(t,"backend")+"-"+Ember.get(t,"name")})
this.set("model",n)}}})}),define("vault/controllers/vault/cluster/secrets/backends",["exports","ember-concurrency","vault/helpers/supported-secret-backends"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=(0,n.supportedSecretBackends)()
e.default=Ember.Controller.extend({displayableBackends:Ember.computed.filterBy("model","shouldIncludeInList"),supportedBackends:Ember.computed("displayableBackends","displayableBackends.[]",function(){return(this.get("displayableBackends")||[]).filter(function(e){return a.includes(e.get("engineType"))}).sortBy("id")}),unsupportedBackends:Ember.computed("displayableBackends","displayableBackends.[]","supportedBackends","supportedBackends.[]",function(){return(this.get("displayableBackends")||[]).slice().removeObjects(this.get("supportedBackends")).sortBy("id")}),disableEngine:(0,t.task)(regeneratorRuntime.mark(function e(t){var n,a
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return n=t.engineType,a=t.path,e.prev=1,e.next=4,t.destroyRecord()
case 4:this.get("flashMessages").success("The "+n+" Secrets Engine at "+a+" has been disabled."),e.next=10
break
case 7:e.prev=7,e.t0=e.catch(1),this.get("flashMessages").danger("There was an error disabling the "+n+" Secrets Engine at "+a+": "+e.t0.errors.join(" ")+".")
case 10:case"end":return e.stop()}},e,this,[[1,7]])})).drop()})}),define("vault/controllers/vault/cluster/settings",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({namespaceService:Ember.inject.service("namespace")})}),define("vault/controllers/vault/cluster/settings/auth/enable",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({wizard:Ember.inject.service(),actions:{onMountSuccess:function(e,t){return this.wizard.transitionFeatureMachine(this.wizard.featureState,"CONTINUE",e),this.transitionToRoute("vault.cluster.settings.auth.configure",t).followRedirects()}}})}),define("vault/controllers/vault/cluster/settings/configure-secret-backend",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t={configured:!1,iamEndpoint:null,stsEndpoint:null,accessKey:null,secretKey:null,region:""}
e.default=Ember.Controller.extend(t,{queryParams:["tab"],tab:"",flashMessages:Ember.inject.service(),loading:!1,reset:function(){this.get("model").rollbackAttributes(),this.setProperties(t)},actions:{saveConfig:function(){var e=this,t=(arguments.length>0&&void 0!==arguments[0]?arguments[0]:{delete:!1}).delete
"ssh"===this.get("model.type")&&(this.set("loading",!0),this.get("model").saveCA({isDelete:t}).then(function(){e.set("loading",!1),e.send("refreshRoute"),e.set("configured",!t),t?e.get("flashMessages").success("SSH Certificate Authority Configuration deleted!"):e.get("flashMessages").success("SSH Certificate Authority Configuration saved!")}))},save:function(e,t){var n=this
this.set("loading",!0),Object.keys(t).some(function(e){return Ember.isPresent(t[e])})&&this.get("model").save({adapterOptions:{adapterMethod:e,data:t}}).then(function(){n.get("model").send("pushedData"),n.reset(),n.get("flashMessages").success("The backend configuration saved successfully!")}).finally(function(){n.set("loading",!1)})}}})}),define("vault/controllers/vault/cluster/settings/mount-secret-backend",["exports","vault/helpers/supported-secret-backends"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=(0,t.supportedSecretBackends)()
e.default=Ember.Controller.extend({wizard:Ember.inject.service(),actions:{onMountSuccess:function(e,t){var a=this
return(n.includes(e)?"kmip"===e?this.transitionToRoute("vault.cluster.secrets.backend.kmip.scopes",t):this.transitionToRoute("vault.cluster.secrets.backend.index",t):this.transitionToRoute("vault.cluster.secrets.backends")).followRedirects().then(function(){a.get("wizard").transitionFeatureMachine(a.get("wizard.featureState"),"CONTINUE",e)})},onConfigError:function(e){return this.transitionToRoute("vault.cluster.settings.configure-secret-backend",e)}}})}),define("vault/controllers/vault/cluster/settings/seal",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({auth:Ember.inject.service(),actions:{seal:function(){var e=this
return this.model.cluster.store.adapterFor("cluster").seal().then(function(){return e.model.cluster.get("leaderNode").set("sealed",!0),e.get("auth").deleteCurrentToken(),e.transitionToRoute("vault.cluster.unseal")})}}})}),define("vault/controllers/vault/cluster/unseal",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Controller.extend({wizard:Ember.inject.service(),actions:{transitionToCluster:function(e){var t=this
return this.get("model").reload().then(function(){return t.get("wizard").transitionTutorialMachine(t.get("wizard.currentState"),"CONTINUE",e),t.transitionToRoute("vault.cluster",t.get("model.name"))})},setUnsealState:function(e){this.get("wizard").set("componentState",e)},isUnsealed:function(e){return!1===e.sealed}}})}),define("vault/flash/object",["exports","ember-cli-flash/flash/object"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/-date-base",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Helper.extend({disableInterval:!1,compute:function(e,t){var n=this,a=t.interval
Ember.get(this,"disableInterval")||(this.clearTimer(),a&&(this.intervalTimer=setTimeout(function(){Ember.run(function(){return n.recompute()})},parseInt(a,10))))},clearTimer:function(){clearTimeout(this.intervalTimer)},destroy:function(){this.clearTimer(),this._super.apply(this,arguments)}})}),define("vault/helpers/add",["exports"],function(e){function t(e){return e.reduce(function(e,t){return parseInt(t,0)+e},0)}Object.defineProperty(e,"__esModule",{value:!0}),e.add=t,e.default=Ember.Helper.helper(t)}),define("vault/helpers/all-features",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.allFeatures=n
var t=["HSM","Performance Replication","DR Replication","MFA","Sentinel","Seal Wrapping","Control Groups","Performance Standby","Namespaces"]
function n(){return t}e.default=Ember.Helper.helper(n)}),define("vault/helpers/and",["exports","ember-truth-helpers/helpers/and"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"and",{enumerable:!0,get:function(){return t.and}})}),define("vault/helpers/append",["exports","ember-composable-helpers/helpers/append"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"append",{enumerable:!0,get:function(){return t.append}})}),define("vault/helpers/array",["exports","ember-composable-helpers/helpers/array"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"array",{enumerable:!0,get:function(){return t.array}})}),define("vault/helpers/assign",["exports","ember-assign-helper/helpers/assign"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"assign",{enumerable:!0,get:function(){return t.assign}})}),define("vault/helpers/aws-regions",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.regions=n
var t=["us-east-1","us-east-2","us-west-1","us-west-2","ca-central-1","ap-south-1","ap-northeast-1","ap-northeast-2","ap-southeast-1","ap-southeast-2","eu-central-1","eu-west-1","eu-west-2","sa-east-1"]
function n(){return t.slice(0)}e.default=Ember.Helper.helper(n)}),define("vault/helpers/camelize",["exports","ember-cli-string-helpers/helpers/camelize"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"camelize",{enumerable:!0,get:function(){return t.camelize}})}),define("vault/helpers/cancel-all",["exports","ember-concurrency/helpers/cancel-all"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/capitalize",["exports","ember-cli-string-helpers/helpers/capitalize"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"capitalize",{enumerable:!0,get:function(){return t.capitalize}})}),define("vault/helpers/chunk",["exports","ember-composable-helpers/helpers/chunk"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"chunk",{enumerable:!0,get:function(){return t.chunk}})})
define("vault/helpers/classify",["exports","ember-cli-string-helpers/helpers/classify"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"classify",{enumerable:!0,get:function(){return t.classify}})}),define("vault/helpers/coerce-eq",["exports"],function(e){function t(e){return e[0]==e[1]}Object.defineProperty(e,"__esModule",{value:!0}),e.coerceEq=t,e.default=Ember.Helper.helper(t)}),define("vault/helpers/compact",["exports","ember-composable-helpers/helpers/compact"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"compact",{enumerable:!0,get:function(){return t.compact}})}),define("vault/helpers/compute",["exports","ember-composable-helpers/helpers/compute"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"compute",{enumerable:!0,get:function(){return t.compute}})}),define("vault/helpers/contains",["exports","ember-composable-helpers/helpers/contains"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"contains",{enumerable:!0,get:function(){return t.contains}})}),define("vault/helpers/dasherize",["exports","ember-cli-string-helpers/helpers/dasherize"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"dasherize",{enumerable:!0,get:function(){return t.dasherize}})}),define("vault/helpers/date-format",["exports","date-fns/format"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.dateFormat=a
var n=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
function a(e){var a=n(e,2),s=a[0],r=a[1]
return(0,t.default)(s,r)}e.default=Ember.Helper.helper(a)}),define("vault/helpers/date-from-now",["exports","date-fns"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.dateFromNow=a
var n=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
function a(e){var a=n(e,1)[0],s=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{}
return(0,t.distanceInWordsToNow)(a,s)}e.default=Ember.Helper.helper(a)}),define("vault/helpers/dec",["exports","ember-composable-helpers/helpers/dec"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"dec",{enumerable:!0,get:function(){return t.dec}})}),define("vault/helpers/dot-to-dash",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.dotToDash=n
var t=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
function n(e){return t(e,1)[0].replace(/\./gi,"-")}e.default=Ember.Helper.helper(n)}),define("vault/helpers/drop",["exports","ember-composable-helpers/helpers/drop"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"drop",{enumerable:!0,get:function(){return t.drop}})}),define("vault/helpers/ember-power-select-is-group",["exports","ember-power-select/helpers/ember-power-select-is-group"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"emberPowerSelectIsGroup",{enumerable:!0,get:function(){return t.emberPowerSelectIsGroup}})}),define("vault/helpers/ember-power-select-is-selected",["exports","ember-power-select/helpers/ember-power-select-is-selected"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"emberPowerSelectIsSelected",{enumerable:!0,get:function(){return t.emberPowerSelectIsSelected}})}),define("vault/helpers/ember-power-select-true-string-if-present",["exports","ember-power-select/helpers/ember-power-select-true-string-if-present"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"emberPowerSelectTrueStringIfPresent",{enumerable:!0,get:function(){return t.emberPowerSelectTrueStringIfPresent}})}),define("vault/helpers/eq",["exports","ember-truth-helpers/helpers/equal"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"equal",{enumerable:!0,get:function(){return t.equal}})}),define("vault/helpers/filter-by",["exports","ember-composable-helpers/helpers/filter-by"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"filterBy",{enumerable:!0,get:function(){return t.filterBy}})}),define("vault/helpers/filter",["exports","ember-composable-helpers/helpers/filter"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"filter",{enumerable:!0,get:function(){return t.filter}})}),define("vault/helpers/find-by",["exports","ember-composable-helpers/helpers/find-by"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"findBy",{enumerable:!0,get:function(){return t.findBy}})}),define("vault/helpers/flatten",["exports","ember-composable-helpers/helpers/flatten"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"flatten",{enumerable:!0,get:function(){return t.flatten}})}),define("vault/helpers/format-number",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.formatNumber=n
var t=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
function n(e){var n=t(e,1)[0]
return(new Intl.NumberFormat).format(n)}e.default=Ember.Helper.helper(n)}),define("vault/helpers/format-utc",["exports","d3-time-format"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.formatUtc=a
var n=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
function a(e){var a=n(e,2),s=a[0],r=a[1]
return t.default.utcFormat(r)(t.default.utcParse("%Y-%m-%dT%H:%M:%SZ")(s)||t.default.isoParse(s))}e.default=Ember.Helper.helper(a)}),define("vault/helpers/group-by",["exports","ember-composable-helpers/helpers/group-by"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"groupBy",{enumerable:!0,get:function(){return t.groupBy}})}),define("vault/helpers/gt",["exports","ember-truth-helpers/helpers/gt"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"gt",{enumerable:!0,get:function(){return t.gt}})}),define("vault/helpers/gte",["exports","ember-truth-helpers/helpers/gte"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"gte",{enumerable:!0,get:function(){return t.gte}})}),define("vault/helpers/has-feature",["exports","core/helpers/has-feature"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/has-next",["exports","ember-composable-helpers/helpers/has-next"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"hasNext",{enumerable:!0,get:function(){return t.hasNext}})}),define("vault/helpers/has-permission",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
e.default=Ember.Helper.extend({permissions:Ember.inject.service(),onPermissionsChange:Ember.observer("permissions.exactPaths","permissions.globPaths","permissions.canViewAll",function(){this.recompute()}),compute:function(e,n){var a=t(e,1)[0],s=n.routeParams,r=n.capability
return this.permissions.hasNavPermission(a,s,r)}})}),define("vault/helpers/has-previous",["exports","ember-composable-helpers/helpers/has-previous"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"hasPrevious",{enumerable:!0,get:function(){return t.hasPrevious}})}),define("vault/helpers/html-safe",["exports","ember-cli-string-helpers/helpers/html-safe"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"htmlSafe",{enumerable:!0,get:function(){return t.htmlSafe}})}),define("vault/helpers/humanize",["exports","ember-cli-string-helpers/helpers/humanize"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"humanize",{enumerable:!0,get:function(){return t.humanize}})})
define("vault/helpers/inc",["exports","ember-composable-helpers/helpers/inc"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"inc",{enumerable:!0,get:function(){return t.inc}})}),define("vault/helpers/intersect",["exports","ember-composable-helpers/helpers/intersect"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"intersect",{enumerable:!0,get:function(){return t.intersect}})}),define("vault/helpers/invoke",["exports","ember-composable-helpers/helpers/invoke"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"invoke",{enumerable:!0,get:function(){return t.invoke}})}),define("vault/helpers/is-active-route",["exports","core/helpers/is-active-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isActiveRoute",{enumerable:!0,get:function(){return t.isActiveRoute}})}),define("vault/helpers/is-active",["exports","ember-router-helpers/helpers/is-active"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isActive",{enumerable:!0,get:function(){return t.isActive}})}),define("vault/helpers/is-after",["exports","vault/helpers/-date-base","date-fns"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
e.default=t.default.extend({compute:function(e){var t=a(e,2),s=t[0],r=t[1]
return this._super.apply(this,arguments),(0,n.isAfter)(s,r)}})}),define("vault/helpers/is-array",["exports","ember-truth-helpers/helpers/is-array"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isArray",{enumerable:!0,get:function(){return t.isArray}})}),define("vault/helpers/is-before",["exports","vault/helpers/-date-base","date-fns"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
e.default=t.default.extend({compute:function(e){var t=a(e,2),s=t[0],r=t[1]
return this._super.apply(this,arguments),(0,n.isBefore)(s,r)}})}),define("vault/helpers/is-clipboard-supported",["exports","ember-cli-clipboard/helpers/is-clipboard-supported"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isClipboardSupported",{enumerable:!0,get:function(){return t.isClipboardSupported}})}),define("vault/helpers/is-empty",["exports","ember-truth-helpers/helpers/is-empty"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/is-equal",["exports","ember-truth-helpers/helpers/is-equal"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"isEqual",{enumerable:!0,get:function(){return t.isEqual}})}),define("vault/helpers/is-version",["exports","core/helpers/is-version"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/join",["exports","ember-composable-helpers/helpers/join"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"join",{enumerable:!0,get:function(){return t.join}})}),define("vault/helpers/jsonify",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.jsonify=n
var t=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
function n(e){var n=t(e,1)[0]
return JSON.parse(n)}e.default=Ember.Helper.helper(n)}),define("vault/helpers/lowercase",["exports","ember-cli-string-helpers/helpers/lowercase"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"lowercase",{enumerable:!0,get:function(){return t.lowercase}})}),define("vault/helpers/lt",["exports","ember-truth-helpers/helpers/lt"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"lt",{enumerable:!0,get:function(){return t.lt}})}),define("vault/helpers/lte",["exports","ember-truth-helpers/helpers/lte"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"lte",{enumerable:!0,get:function(){return t.lte}})}),define("vault/helpers/map-by",["exports","ember-composable-helpers/helpers/map-by"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"mapBy",{enumerable:!0,get:function(){return t.mapBy}})}),define("vault/helpers/map",["exports","ember-composable-helpers/helpers/map"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"map",{enumerable:!0,get:function(){return t.map}})}),define("vault/helpers/media",["exports","ember-responsive/helpers/media"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"media",{enumerable:!0,get:function(){return t.media}})}),define("vault/helpers/message-types",["exports","core/helpers/message-types"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"messageTypes",{enumerable:!0,get:function(){return t.messageTypes}}),Object.defineProperty(e,"MESSAGE_TYPES",{enumerable:!0,get:function(){return t.MESSAGE_TYPES}})}),define("vault/helpers/mountable-auth-methods",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.methods=n
var t=[{displayName:"AliCloud",value:"alicloud",type:"alicloud",category:"cloud"},{displayName:"AppRole",value:"approle",type:"approle",category:"generic"},{displayName:"AWS",value:"aws",type:"aws",category:"cloud"},{displayName:"Azure",value:"azure",type:"azure",category:"cloud"},{displayName:"Google Cloud",value:"gcp",type:"gcp",category:"cloud"},{displayName:"GitHub",value:"github",type:"github",category:"cloud"},{displayName:"JWT",value:"jwt",type:"jwt",glyph:"auth",category:"generic"},{displayName:"OIDC",value:"oidc",type:"oidc",glyph:"auth",category:"generic"},{displayName:"Kubernetes",value:"kubernetes",type:"kubernetes",category:"infra"},{displayName:"LDAP",value:"ldap",type:"ldap",glyph:"auth",category:"infra"},{displayName:"Okta",value:"okta",type:"okta",category:"infra"},{displayName:"RADIUS",value:"radius",type:"radius",glyph:"auth",category:"infra"},{displayName:"TLS Certificates",value:"cert",type:"cert",category:"generic"},{displayName:"Username & Password",value:"userpass",type:"userpass",category:"generic"}]
function n(){return t.slice()}e.default=Ember.Helper.helper(n)}),define("vault/helpers/mountable-secret-engines",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.engines=n
e.KMIP={displayName:"KMIP",value:"kmip",type:"kmip",category:"generic"}
var t=[{displayName:"Active Directory",value:"ad",type:"ad",category:"cloud"},{displayName:"AliCloud",value:"alicloud",type:"alicloud",category:"cloud"},{displayName:"AWS",value:"aws",type:"aws",category:"cloud"},{displayName:"Azure",value:"azure",type:"azure",category:"cloud"},{displayName:"Consul",value:"consul",type:"consul",category:"infra"},{displayName:"Databases",value:"database",type:"database",category:"infra"},{displayName:"Google Cloud",value:"gcp",type:"gcp",category:"cloud"},{displayName:"Google Cloud KMS",value:"gcpkms",type:"gcpkms",category:"cloud"},{displayName:"KV",value:"kv",type:"kv",category:"generic"},{displayName:"Nomad",value:"nomad",type:"nomad",category:"infra"},{displayName:"PKI Certificates",value:"pki",type:"pki",category:"generic"},{displayName:"RabbitMQ",value:"rabbitmq",type:"rabbitmq",category:"infra"},{displayName:"SSH",value:"ssh",type:"ssh",category:"generic"},{displayName:"Transit",value:"transit",type:"transit",category:"generic"},{displayName:"TOTP",value:"totp",type:"totp",category:"generic"}]
function n(){return t.slice()}e.default=Ember.Helper.helper(n)}),define("vault/helpers/multi-line-join",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.multiLineJoin=n
var t=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
function n(e){return t(e,1)[0].join("\n")}e.default=Ember.Helper.helper(n)}),define("vault/helpers/nav-to-route",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Helper.extend({router:Ember.inject.service(),compute:function(e,t){var n,a=this,s=(n=e,Array.isArray(n)?n:Array.from(n)),r=s[0],l=s.slice(1),i=t.replace,o=void 0!==i&&i
return function(){var e=a.get("router"),t=o?e.replaceWith:e.transitionTo
return t.call.apply(t,[e,r].concat(function(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}(l)))}}})}),define("vault/helpers/next",["exports","ember-composable-helpers/helpers/next"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"next",{enumerable:!0,get:function(){return t.next}})}),define("vault/helpers/not-eq",["exports","ember-truth-helpers/helpers/not-equal"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"notEq",{enumerable:!0,get:function(){return t.notEq}})}),define("vault/helpers/not",["exports","ember-truth-helpers/helpers/not"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"not",{enumerable:!0,get:function(){return t.not}})}),define("vault/helpers/now",["exports","vault/helpers/-date-base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({compute:function(){return this._super.apply(this,arguments),Date.now()}})}),define("vault/helpers/object-at",["exports","ember-composable-helpers/helpers/object-at"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"objectAt",{enumerable:!0,get:function(){return t.objectAt}})})
define("vault/helpers/optional",["exports","ember-composable-helpers/helpers/optional"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"optional",{enumerable:!0,get:function(){return t.optional}})}),define("vault/helpers/options-for-backend",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.optionsForBackend=s
var t=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),n={searchPlaceholder:"Filter secrets",item:"secret",create:"Create secret",navigateTree:!0,editComponent:"secret-edit",listItemPartial:"partials/secret-list/item"},a={aws:{displayName:"AWS",searchPlaceholder:"Filter roles",item:"role",create:"Create role",navigateTree:!1,editComponent:"role-aws-edit",listItemPartial:"partials/secret-list/aws-role-item"},pki:{displayName:"PKI",navigateTree:!1,listItemPartial:"partials/secret-list/pki-role-item",tabs:[{name:"roles",label:"Roles",searchPlaceholder:"Filter roles",item:"role",create:"Create role",editComponent:"role-pki-edit"},{name:"certs",modelPrefix:"cert/",label:"Certificates",searchPlaceholder:"Filter certificates",item:"certificates",create:"Create role",tab:"certs",listItemPartial:"partials/secret-list/pki-cert-item",editComponent:"pki-cert-show"}]},ssh:{displayName:"SSH",searchPlaceholder:"Filter roles",item:"role",create:"Create role",navigateTree:!1,editComponent:"role-ssh-edit",listItemPartial:"partials/secret-list/ssh-role-item"},transit:{searchPlaceholder:"Filter keys",item:"key",create:"Create encryption key",navigateTree:!1,editComponent:"transit-edit",listItemPartial:"partials/secret-list/item"}}
function s(e){var s=t(e,2),r=s[0],l=s[1],i=a[r],o=void 0
if(i&&i.tabs){var u=i.tabs.findBy("name",l)||i.tabs.findBy("modelPrefix",l)||i.tabs[0]
o=Ember.assign({},i,u)}else o=i||Ember.assign({},n,{displayName:"kv"===r?"KV":Ember.String.capitalize(r)})
return o}e.default=Ember.Helper.helper(s)}),define("vault/helpers/or",["exports","ember-truth-helpers/helpers/or"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"or",{enumerable:!0,get:function(){return t.or}})}),define("vault/helpers/path-or-array",["exports","core/helpers/path-or-array"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/perform",["exports","ember-concurrency/helpers/perform"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/pipe-action",["exports","ember-composable-helpers/helpers/pipe-action"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/pipe",["exports","ember-composable-helpers/helpers/pipe"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"pipe",{enumerable:!0,get:function(){return t.pipe}})}),define("vault/helpers/pluralize",["exports","ember-inflector/lib/helpers/pluralize"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default}),define("vault/helpers/previous",["exports","ember-composable-helpers/helpers/previous"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"previous",{enumerable:!0,get:function(){return t.previous}})}),define("vault/helpers/queue",["exports","ember-composable-helpers/helpers/queue"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"queue",{enumerable:!0,get:function(){return t.queue}})}),define("vault/helpers/range",["exports","ember-composable-helpers/helpers/range"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"range",{enumerable:!0,get:function(){return t.range}})}),define("vault/helpers/reduce",["exports","ember-composable-helpers/helpers/reduce"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"reduce",{enumerable:!0,get:function(){return t.reduce}})}),define("vault/helpers/reject-by",["exports","ember-composable-helpers/helpers/reject-by"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"rejectBy",{enumerable:!0,get:function(){return t.rejectBy}})}),define("vault/helpers/repeat",["exports","ember-composable-helpers/helpers/repeat"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"repeat",{enumerable:!0,get:function(){return t.repeat}})}),define("vault/helpers/replication-action-for-mode",["exports","core/helpers/replication-action-for-mode"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/reverse",["exports","ember-composable-helpers/helpers/reverse"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"reverse",{enumerable:!0,get:function(){return t.reverse}})}),define("vault/helpers/route-params-for",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
e.default=Ember.Helper.extend({permissions:Ember.inject.service(),compute:function(e){var n=t(e,1)[0]
return this.permissions.navPathParams(n)}})}),define("vault/helpers/route-params",["exports","ember-router-helpers/helpers/route-params"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"routeParams",{enumerable:!0,get:function(){return t.routeParams}})}),define("vault/helpers/set-flash-message",["exports","core/helpers/set-flash-message"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"setFlashMessage",{enumerable:!0,get:function(){return t.setFlashMessage}})}),define("vault/helpers/sha2-digest-sizes",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.sha2DigestSizes=n
var t=["sha2-224","sha2-256","sha2-384","sha2-512"]
function n(){return t}e.default=Ember.Helper.helper(n)}),define("vault/helpers/shuffle",["exports","ember-composable-helpers/helpers/shuffle"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"shuffle",{enumerable:!0,get:function(){return t.shuffle}})}),define("vault/helpers/singularize",["exports","ember-inflector/lib/helpers/singularize"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default}),define("vault/helpers/slice",["exports","ember-composable-helpers/helpers/slice"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"slice",{enumerable:!0,get:function(){return t.slice}})}),define("vault/helpers/sort-by",["exports","ember-composable-helpers/helpers/sort-by"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"sortBy",{enumerable:!0,get:function(){return t.sortBy}})}),define("vault/helpers/stringify",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.stringify=n
var t=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
function n(e,n){var a=t(e,1)[0]
return n.skipFormat?JSON.stringify(a):JSON.stringify(a,null,2)}e.default=Ember.Helper.helper(n)}),define("vault/helpers/supported-auth-backends",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.supportedAuthBackends=n
var t=[{type:"token",typeDisplay:"Token",description:"Token authentication.",tokenPath:"id",displayNamePath:"display_name",formAttributes:["token"]},{type:"userpass",typeDisplay:"Username",description:"A simple username and password backend.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"ldap",typeDisplay:"LDAP",description:"LDAP authentication.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"okta",typeDisplay:"Okta",description:"Authenticate with your Okta username and password.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"jwt",typeDisplay:"JWT",description:"Authenticate using JWT or OIDC provider.",tokenPath:"client_token",displayNamePath:"display_name",formAttributes:["role","jwt"]},{type:"oidc",typeDisplay:"OIDC",description:"Authenticate using JWT or OIDC provider.",tokenPath:"client_token",displayNamePath:"display_name",formAttributes:["role","jwt"]},{type:"radius",typeDisplay:"RADIUS",description:"Authenticate with your RADIUS username and password.",tokenPath:"client_token",displayNamePath:"metadata.username",formAttributes:["username","password"]},{type:"github",typeDisplay:"GitHub",description:"GitHub authentication.",tokenPath:"client_token",displayNamePath:["metadata.org","metadata.username"],formAttributes:["token"]}]
function n(){return t}e.default=Ember.Helper.helper(n)}),define("vault/helpers/supported-secret-backends",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.supportedSecretBackends=n
var t=["aws","cubbyhole","generic","kv","pki","ssh","transit","kmip"]
function n(){return t}e.default=Ember.Helper.helper(n)}),define("vault/helpers/svg-jar",["exports","ember-svg-jar/utils/make-helper","ember-svg-jar/utils/make-svg"],function(e,t,n){function a(e){try{return require("ember-svg-jar/inlined/"+e).default}catch(e){return null}}function s(e,t){return(0,n.default)(e,t,a)}Object.defineProperty(e,"__esModule",{value:!0}),e.svgJar=s,e.default=(0,t.default)(s)}),define("vault/helpers/tabs-for-auth-section",["exports","ember-inflector"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.tabsForAuthSection=r
var n=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),a={aws:[{label:"Client",routeParams:["vault.cluster.settings.auth.configure.section","client"]},{label:"Identity Whitelist Tidy",routeParams:["vault.cluster.settings.auth.configure.section","identity-whitelist"]},{label:"Role Tag Blacklist Tidy",routeParams:["vault.cluster.settings.auth.configure.section","roletag-blacklist"]}],azure:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],github:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],gcp:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],jwt:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],oidc:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],kubernetes:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],ldap:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],okta:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}],radius:[{label:"Configuration",routeParams:["vault.cluster.settings.auth.configure.section","configuration"]}]},s={}
function r(e){var r=n(e,3),l=r[0],i=r[1],o=void 0===i?"authSettings":i,u=r[2],c=void 0
return"authSettings"===o?((c=(a[l.type]||[]).slice()).push({label:"Method Options",routeParams:["vault.cluster.settings.auth.configure.section","options"]}),c):((c=u?u.map(function(e){var n=e.slice(1)
return{label:Ember.String.capitalize((0,t.pluralize)(n)),routeParams:["vault.cluster.access.method.item.list",n]}}):(s[l.type]||[]).slice()).push({label:"Configuration",routeParams:["vault.cluster.access.method.section","configuration"]}),c)}e.default=Ember.Helper.helper(r)}),define("vault/helpers/tabs-for-identity-show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.tabsForIdentityShow=a
var t=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),n=e.TABS={entity:["details","aliases","policies","groups","metadata"],"entity-alias":["details","metadata"],group:["details","aliases","policies","members","parent-groups","metadata"],"group-internal":["details","policies","members","parent-groups","metadata"],"group-external":["details","aliases","policies","members","parent-groups","metadata"],"group-alias":["details"]}
function a(e){var a=t(e,2),s=a[0],r=a[1],l=s
return r&&(l=l+"-"+r),n[l]}e.default=Ember.Helper.helper(a)})
define("vault/helpers/take",["exports","ember-composable-helpers/helpers/take"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"take",{enumerable:!0,get:function(){return t.take}})}),define("vault/helpers/task",["exports","ember-concurrency/helpers/task"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/titleize",["exports","ember-cli-string-helpers/helpers/titleize"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"titleize",{enumerable:!0,get:function(){return t.titleize}})}),define("vault/helpers/to-label",["exports","vault/helpers/capitalize","vault/helpers/humanize","vault/helpers/dasherize"],function(e,t,n,a){function s(e){return(0,t.capitalize)([(0,n.humanize)([(0,a.dasherize)(e)])])}Object.defineProperty(e,"__esModule",{value:!0}),e.toLabel=s,e.default=Ember.Helper.helper(s)}),define("vault/helpers/toggle-action",["exports","ember-composable-helpers/helpers/toggle-action"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/helpers/toggle",["exports","ember-composable-helpers/helpers/toggle"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"toggle",{enumerable:!0,get:function(){return t.toggle}})}),define("vault/helpers/tools-actions",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.toolsActions=n
var t=["wrap","lookup","unwrap","rewrap","random","hash"]
function n(){return t}e.default=Ember.Helper.helper(n)}),define("vault/helpers/transition-to",["exports","ember-router-helpers/helpers/transition-to"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"transitionTo",{enumerable:!0,get:function(){return t.transitionTo}})}),define("vault/helpers/trim",["exports","ember-cli-string-helpers/helpers/trim"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"trim",{enumerable:!0,get:function(){return t.trim}})}),define("vault/helpers/truncate",["exports","ember-cli-string-helpers/helpers/truncate"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"truncate",{enumerable:!0,get:function(){return t.truncate}})}),define("vault/helpers/underscore",["exports","ember-cli-string-helpers/helpers/underscore"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"underscore",{enumerable:!0,get:function(){return t.underscore}})}),define("vault/helpers/union",["exports","ember-composable-helpers/helpers/union"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"union",{enumerable:!0,get:function(){return t.union}})}),define("vault/helpers/uppercase",["exports","ember-cli-string-helpers/helpers/uppercase"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"uppercase",{enumerable:!0,get:function(){return t.uppercase}})}),define("vault/helpers/url-for",["exports","ember-router-helpers/helpers/url-for"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"urlFor",{enumerable:!0,get:function(){return t.urlFor}})}),define("vault/helpers/w",["exports","ember-cli-string-helpers/helpers/w"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"w",{enumerable:!0,get:function(){return t.w}})}),define("vault/helpers/without",["exports","ember-composable-helpers/helpers/without"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"without",{enumerable:!0,get:function(){return t.without}})}),define("vault/helpers/wizard-constants",["exports","vault/machines/tutorial-machine","vault/machines/secrets-machine","vault/machines/policies-machine","vault/machines/replication-machine","vault/machines/tools-machine","vault/machines/auth-machine"],function(e,t,n,a,s,r,l){Object.defineProperty(e,"__esModule",{value:!0}),e.FEATURE_MACHINE_TIME=e.INIT_STEPS=e.FEATURE_MACHINE_STEPS=e.DEFAULTS=e.MACHINES=e.STORAGE_KEYS=void 0
e.STORAGE_KEYS={TUTORIAL_STATE:"vault:ui-tutorial-state",FEATURE_LIST:"vault:ui-feature-list",FEATURE_STATE:"vault:ui-feature-state",FEATURE_STATE_HISTORY:"vault:ui-feature-state-history",COMPLETED_FEATURES:"vault:ui-completed-list",COMPONENT_STATE:"vault:ui-component-state",RESUME_URL:"vault:ui-tutorial-resume-url",RESUME_ROUTE:"vault:ui-tutorial-resume-route"},e.MACHINES={tutorial:t.default,secrets:n.default,policies:a.default,replication:s.default,tools:r.default,authentication:l.default},e.DEFAULTS={currentState:null,featureList:null,featureState:null,currentMachine:null,tutorialComponent:null,featureComponent:null,stepComponent:null,detailsComponent:null,componentState:null,nextFeature:null,nextStep:null,featureMachineHistory:null},e.FEATURE_MACHINE_STEPS={secrets:{encryption:5,secret:{list:4,secret:5},role:7},policies:5,replication:2,tools:8,authentication:4},e.INIT_STEPS=["setup","save","unseal","login"],e.FEATURE_MACHINE_TIME={secrets:7,policies:5,replication:5,tools:8,authentication:5}}),define("vault/helpers/xor",["exports","ember-truth-helpers/helpers/xor"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"xor",{enumerable:!0,get:function(){return t.xor}})}),define("vault/initializers/allow-link-action",["exports","ember-link-action/initializers/allow-link-action"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"initialize",{enumerable:!0,get:function(){return t.initialize}})}),define("vault/initializers/container-debug-adapter",["exports","ember-resolver/resolvers/classic/container-debug-adapter"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default={name:"container-debug-adapter",initialize:function(){var e=arguments[1]||arguments[0]
e.register("container-debug-adapter:main",t.default),e.inject("container-debug-adapter:main","namespace","application:main")}}}),define("vault/initializers/disable-ember-inspector",["exports","vault/config/environment"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default={name:"ember-inspect-disable",initialize:function(){"production"===t.default.environment&&(window.NO_EMBER_DEBUG=!0)}}}),define("vault/initializers/ember-concurrency",["exports","ember-concurrency/initializers/ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/initializers/ember-data",["exports","ember-data/setup-container","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default={name:"ember-data",initialize:t.default}}),define("vault/initializers/ember-responsive-breakpoints",["exports","ember-responsive/initializers/responsive"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default}),define("vault/initializers/enable-engines",["exports","vault/config/environment"],function(e,t){function n(){t.default.addRootMounts=function(){this.mount("replication")}}Object.defineProperty(e,"__esModule",{value:!0}),e.initialize=n,e.default={initialize:n}}),define("vault/initializers/engines",["exports","ember-engines/initializers/engines"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}}),Object.defineProperty(e,"initialize",{enumerable:!0,get:function(){return t.initialize}})}),define("vault/initializers/export-application-global",["exports","vault/config/environment"],function(e,t){function n(){var e=arguments[1]||arguments[0]
if(!1!==t.default.exportApplicationGlobal){var n
if("undefined"!=typeof window)n=window
else if("undefined"!=typeof global)n=global
else{if("undefined"==typeof self)return
n=self}var a,s=t.default.exportApplicationGlobal
a="string"==typeof s?s:Ember.String.classify(t.default.modulePrefix),n[a]||(n[a]=e,e.reopen({willDestroy:function(){this._super.apply(this,arguments),delete n[a]}}))}}Object.defineProperty(e,"__esModule",{value:!0}),e.initialize=n,e.default={name:"export-application-global",initialize:n}}),define("vault/initializers/flash-messages",["exports","vault/config/environment","ember-cli-flash/utils/flash-message-options"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.initialize=r
var a=Ember.deprecate,s="[ember-cli-flash] Future versions of ember-cli-flash will no longer inject the service automatically. Instead, you should explicitly inject it into your Route, Controller or Component with `Ember.inject.service`."
function r(){var e=arguments[1]||arguments[0],r=(t.default||{}).flashMessageDefaults,l=(r||[]).injectionFactories,i=(0,n.default)(r),o=!(l&&l.length)
a(s,o,{id:"ember-cli-flash.deprecate-injection-factories",until:"2.0.0"}),i.injectionFactories.forEach(function(t){e.inject(t,"flashMessages","service:flash-messages")})}e.default={name:"flash-messages",initialize:r}}),define("vault/initializers/model-fragments",["exports","ember-data-model-fragments"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default={name:"fragmentTransform",before:"ember-data",initialize:function(e){e.inject("transform","store","service:store")}}}),define("vault/instance-initializers/ember-data",["exports","ember-data/initialize-store-service"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default={name:"ember-data",initialize:t.default}})
define("vault/instance-initializers/load-asset-manifest",["exports","vault/config/asset-manifest"],function(e,t){function n(e){e.lookup("service:asset-loader").pushManifest(t.default)}Object.defineProperty(e,"__esModule",{value:!0}),e.initialize=n,e.default={name:"load-asset-manifest",initialize:n}}),define("vault/instance-initializers/track-csp-event",["exports"],function(e){function t(e){e.lookup("service:csp-event").attach()}Object.defineProperty(e,"__esModule",{value:!0}),e.initialize=t,e.default={name:"track-csp-event",initialize:t}}),define("vault/lib/attach-capabilities",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(e,t){var s=Object.keys(t),r=s.reduce(function(e,t){return e[t]=a("capabilities"),e},{})
return Ember.debug("adding new relationships: "+s.join(", ")+" to "+e.toString()),e.reopen(r),e.reopenClass({relatedCapabilities:function(e){var a=e.data,r=e.included
if(a||(a=e),Ember.isArray(a))return{data:a.map(this.relatedCapabilities),included:r}
var l=n({id:a.id},a.attributes),i=!0,o=!1,u=void 0
try{for(var c,d=s[Symbol.iterator]();!(i=(c=d.next()).done);i=!0){var m=c.value,p=t[m]
Ember.typeOf(p),a.relationships[m]={data:{type:"capabilities",id:p(l)}}}}catch(e){o=!0,u=e}finally{try{!i&&d.return&&d.return()}finally{if(o)throw u}}return r?{data:a,included:r}:a}}),e}
var n=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t]
for(var a in n)Object.prototype.hasOwnProperty.call(n,a)&&(e[a]=n[a])}return e},a=t.default.belongsTo}),define("vault/lib/console-helpers",["exports","vault/lib/keycodes","yargs-parser/lib/tokenize-arg-string.js","shell-quote"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0}),e.extractDataAndFlags=function(e,t){return e.concat(t).reduce(function(e,t){var n=t.split(/=(.+)/),a=s(n,2),r=a[0],l=a[1]
if(r.startsWith("-")){var i=r.replace(/^-/,"")
return"wrap-ttl"===i&&(i="wrapTTL"),e.flags[i]=l||!0,e}return e.data[r]?(e.data[r]=[].concat(e.data[r],l),e):(e.data[r]=l,e)},{data:{},flags:{}})},e.executeUICommand=function(e,t,n){var a=e.startsWith("api")?"api":e,s=l.includes(a)
s&&t(e)
"function"==typeof n[a]&&n[a]()
return s},e.parseCommand=function(e,t){var s=(0,n.default)((0,a.parse)(e))
"vault"===s[0]&&s.shift()
var l=(m=s,Array.isArray(m)?m:Array.from(m)),i=l[0],o=l.slice(1),u=void 0,c=[],d=[]
var m
if(o.forEach(function(e){if(e.startsWith("-"))c.push(e)
else if(u){var t=e.split(/=(.+)/).filter(function(e){return""!==e}).join("=")
d.push(t)}else u=e}),!r.includes(i)){if(t)throw new Error("invalid command")
return!1}return[i,c,u,d]},e.logFromResponse=function(e,t,n,a){var s=a.format,r=a.field,l=e&&(e.auth||e.data||e.wrap_info)
if(!l){if("write"===n)return{type:"success",content:"Success! Data written to: "+t}
if("delete"===n)return{type:"success",content:"Success! Data deleted (if it existed) at: "+t}
l=e}if(r){var i=l[r],o=void 0
if(i){if(s&&"json"===s)return{type:"json",content:i}
o="string"==typeof i?{type:"text",content:i}:"number"==typeof i?{type:"text",content:JSON.stringify(i)}:"boolean"==typeof i?{type:"text",content:JSON.stringify(i)}:Array.isArray(i)?{type:"text",content:JSON.stringify(i)}:{type:"object",content:i}}else o={type:"error",content:'Field "'+r+'" not present in secret'}
return o}if(s&&"json"===s)return{type:"json",content:e}
if("list"===n)return{type:"list",content:l}
return{type:"object",content:l}},e.logFromError=function(e,t,n){var a=void 0,s=e.httpStatus,r=e.path
a="Error "+{read:"reading from",write:"writing to",list:"listing",delete:"deleting at"}[n]+": "+t+".\nURL: "+r+"\nCode: "+s,"string"==typeof e.errors[0]&&(a=a+"\nErrors:\n  "+e.errors.join("\n  "))
return{type:"error",content:a}},e.shiftCommandIndex=function(e,n,a){var s=void 0,r=n.length
if(!r)return[]
e===t.default.UP?(a-=1)<0&&(a=r-1):((a+=1)===r&&(s=""),a>r&&(a-=1))
""!==s&&(s=n.objectAt(a).content)
return[a,s]},e.logErrorFromInput=function(e,t,n,a){if(void 0===e)return{type:"error",content:"A path is required to make a request."}
if("write"===t&&!n.force&&0===a.length)return{type:"error",content:"Must supply data or use -force"}}
var s=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),r=["read","write","list","delete"],l=["api","clearall","clear","fullscreen","refresh"]}),define("vault/lib/control-group-error",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=function(e){function n(e){(function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")})(this,n)
var t=e.accessor,a=e.creation_path,s=e.creation_time,r=e.token,l=e.ttl,i=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called")
return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(n.__proto__||Object.getPrototypeOf(n)).call(this))
return i.message="Control Group encountered",i.token=r,i.accessor=t,i.creation_path=a,i.creation_time=s,i.ttl=l,i}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t)
e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(n,t.default.AdapterError),n}()
e.default=n}),define("vault/lib/key-utils",["exports"],function(e){function t(e){return!!e&&!!e.match(/\/$/)}function n(e){if(!e)return null
var n=t(e),a=e.split("/")
return n&&a.pop(),a.length>1?a:null}function a(e){var t=n(e)
return t?t.slice(0,-1).join("/")+"/":null}Object.defineProperty(e,"__esModule",{value:!0}),e.default={keyIsFolder:t,keyPartsForKey:n,parentKeyForKey:a,keyWithoutParentKey:function(e){return e?e.replace(a(e),""):null},ancestorKeysForKey:function(e){for(var t=[],n=a(e);n;)t.unshift(n),n=a(n)
return t}}}),define("vault/lib/keycodes",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default={ENTER:13,ESC:27,TAB:9,LEFT:37,UP:38,RIGHT:39,DOWN:40,T:116}}),define("vault/lib/kv-object",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.ArrayProxy.extend({fromJSON:function(e){if(e&&"object"!==Ember.typeOf(e))throw new Error("Vault expects data to be formatted as an JSON object.")
var t=Object.keys(e||[]).map(function(t){var n={name:t,value:e[t]}
return Ember.guidFor(n),n})
return this.setObjects(t.sort(function(e,t){return""===e.name?1:""===t.name?-1:e.name.localeCompare(t.name)})),this},fromJSONString:function(e){return this.fromJSON(JSON.parse(e))},toJSON:function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0]
return this.reduce(function(t,n){if(!e&&""===n.value&&""===n.name)return t
var a=void 0===n.value?"":n.value
return t[n.name||""]=a,t},{})},toJSONString:function(e){return JSON.stringify(this.toJSON(e),null,2)},isAdvanced:function(){return this.any(function(e){return"string"!=typeof e.value})}})}),define("vault/lib/local-storage",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default={getItem:function(e){var t=window.localStorage.getItem(e)
return t&&JSON.parse(t)},setItem:function(e,t){window.localStorage.setItem(e,JSON.stringify(t))},removeItem:function(e){return window.localStorage.removeItem(e)},keys:function(){return Object.keys(window.localStorage)}}}),define("vault/lib/memory-storage",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t={}
e.default={getItem:function(e){var n=t[e]
return n&&JSON.parse(n)},setItem:function(e,n){t[e]=JSON.stringify(n)},removeItem:function(e){delete t[e]},keys:function(){return Object.keys(t)}}}),define("vault/lib/path-to-tree",["exports","flat","deepmerge"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(e){var t=e.slice(0).sort(function(e,t){return t.length-e.length||t.localeCompare(e)}).reduce(function(e,t){var n=e.find(function(e){return e.startsWith(t)})
return n&&"/"===n.charAt(t.length)||e.push(t),e},[])
return t=t.sort(function(e,t){return e.localeCompare(t)}),n.default.all(t.map(function(e){return e=e.replace(/\.+/g,s),a(function(e,t,n){t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n
return e}({},e,null),{delimiter:"/",object:!0})}))}
var a=t.default.unflatten,s="☃"}),define("vault/lib/token-storage",["exports","vault/lib/local-storage","vault/lib/memory-storage"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(e){if("memory"===e)return n.default
var a=void 0
try{window.localStorage.getItem("test"),a=t.default}catch(e){a=n.default}return a}}),define("vault/machines/auth-machine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default={key:"auth",initial:"idle",on:{RESET:"idle",DONE:"complete"},states:{idle:{onEntry:[{type:"routeTransition",params:["vault.cluster.settings.auth.enable"]},{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/auth-idle"}],on:{CONTINUE:"enable"}},enable:{onEntry:[{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/auth-enable"}],on:{CONTINUE:"config"}},config:{onEntry:[{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/auth-config"}],on:{CONTINUE:"details"}},details:{onEntry:[{type:"render",level:"step",component:"wizard/auth-details"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"complete"}},complete:{onEntry:["completeFeature"]}}}}),define("vault/machines/policies-machine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default={key:"policies",initial:"idle",states:{idle:{onEntry:[{type:"routeTransition",params:["vault.cluster.policies.index","acl"]},{type:"render",level:"feature",component:"wizard/policies-intro"}],on:{CONTINUE:"create"}},create:{on:{CONTINUE:"details"},onEntry:[{type:"render",level:"feature",component:"wizard/policies-create"}]},details:{on:{CONTINUE:"delete"},onEntry:[{type:"render",level:"feature",component:"wizard/policies-details"}]},delete:{on:{CONTINUE:"others"},onEntry:[{type:"render",level:"feature",component:"wizard/policies-delete"}]},others:{on:{CONTINUE:"complete"},onEntry:[{type:"render",level:"feature",component:"wizard/policies-others"}]},complete:{onEntry:["completeFeature"]}}}}),define("vault/machines/replication-machine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default={key:"replication",initial:"setup",states:{setup:{on:{ENABLEREPLICATION:"details"},onEntry:[{type:"routeTransition",params:["vault.cluster.replication"]},{type:"render",level:"feature",component:"wizard/replication-setup"}]},details:{on:{CONTINUE:"complete"},onEntry:[{type:"render",level:"feature",component:"wizard/replication-details"}]},complete:{onEntry:["completeFeature"]}}}}),define("vault/machines/secrets-machine",["exports","vault/helpers/supported-secret-backends"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=(0,t.supportedSecretBackends)()
e.default={key:"secrets",initial:"idle",on:{RESET:"idle",DONE:"complete",ERROR:"error"},states:{idle:{onEntry:[{type:"routeTransition",params:["vault.cluster.settings.mount-secret-backend"]},{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/secrets-idle"}],on:{CONTINUE:"enable"}},enable:{onEntry:[{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/secrets-enable"}],on:{CONTINUE:{details:{cond:function(e){return n.includes(e)}},list:{cond:function(e){return!n.includes(e)}}}}},details:{onEntry:[{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/secrets-details"}],on:{CONTINUE:{role:{cond:function(e){return["pki","aws","ssh"].includes(e)}},secret:{cond:function(e){return["kv"].includes(e)}},encryption:{cond:function(e){return"transit"===e}}}}},encryption:{onEntry:[{type:"render",level:"feature",component:"wizard/mounts-wizard"},{type:"render",level:"step",component:"wizard/secrets-encryption"}],on:{CONTINUE:"display"}},credentials:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-credentials"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"display"}},role:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-role"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"displayRole"}},displayRole:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-display-role"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"credentials"}},secret:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-secret"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"display"}},display:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-display"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{REPEAT:{role:{cond:function(e){return["pki","aws","ssh"].includes(e)},actions:[{type:"routeTransition",params:["vault.cluster.secrets.backend.create-root"]}]},secret:{cond:function(e){return["kv"].includes(e)},actions:[{type:"routeTransition",params:["vault.cluster.secrets.backend.create-root"]}]},encryption:{cond:function(e){return"transit"===e},actions:[{type:"routeTransition",params:["vault.cluster.secrets.backend.create-root"]}]}}}},list:{onEntry:[{type:"render",level:"step",component:"wizard/secrets-list"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"display"}},error:{onEntry:[{type:"render",level:"step",component:"wizard/tutorial-error"},{type:"render",level:"feature",component:"wizard/mounts-wizard"}],on:{CONTINUE:"complete"}},complete:{onEntry:["completeFeature"]}}}}),define("vault/machines/tools-machine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default={key:"tools",initial:"wrap",states:{wrap:{onEntry:[{type:"routeTransition",params:["vault.cluster.tools"]},{type:"render",level:"feature",component:"wizard/tools-wrap"}],on:{CONTINUE:"wrapped"}},wrapped:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-wrapped"}],on:{LOOKUP:"lookup"}},lookup:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-lookup"}],on:{CONTINUE:"info"}},info:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-info"}],on:{REWRAP:"rewrap"}},rewrap:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-rewrap"}],on:{CONTINUE:"rewrapped"}},rewrapped:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-rewrapped"}],on:{UNWRAP:"unwrap"}},unwrap:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-unwrap"}],on:{CONTINUE:"unwrapped"}},unwrapped:{onEntry:[{type:"render",level:"feature",component:"wizard/tools-unwrapped"}],on:{CONTINUE:"complete"}},complete:{onEntry:["completeFeature"]}}}}),define("vault/machines/tutorial-machine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default={key:"tutorial",initial:"idle",on:{DISMISS:"dismissed",DONE:"complete",PAUSE:"paused"},states:{init:{key:"init",initial:"idle",on:{INITDONE:"active.select"},onEntry:["showTutorialAlways",{type:"render",level:"tutorial",component:"wizard/tutorial-idle"},{type:"render",level:"feature",component:null}],onExit:["showTutorialWhenAuthenticated","clearFeatureData"],states:{idle:{on:{START:"active.setup",SAVE:"active.save",UNSEAL:"active.unseal",LOGIN:"active.login"}},active:{onEntry:{type:"render",level:"tutorial",component:"wizard/tutorial-active"},states:{setup:{on:{TOSAVE:"save"},onEntry:{type:"render",level:"feature",component:"wizard/init-setup"}},save:{on:{TOUNSEAL:"unseal",TOLOGIN:"login"},onEntry:{type:"render",level:"feature",component:"wizard/init-save-keys"}},unseal:{on:{TOLOGIN:"login"},onEntry:{type:"render",level:"feature",component:"wizard/init-unseal"}},login:{onEntry:{type:"render",level:"feature",component:"wizard/init-login"}}}}}},active:{key:"feature",initial:"select",onEntry:{type:"render",level:"tutorial",component:"wizard/tutorial-active"},states:{select:{on:{CONTINUE:"feature"},onEntry:{type:"render",level:"feature",component:"wizard/features-selection"}},feature:{}}},idle:{on:{INIT:"init.idle",AUTH:"active.select",CONTINUE:"active"},onEntry:[{type:"render",level:"feature",component:null},{type:"render",level:"step",component:null},{type:"render",level:"detail",component:null},{type:"render",level:"tutorial",component:"wizard/tutorial-idle"}]},dismissed:{onEntry:[{type:"render",level:"tutorial",component:null},{type:"render",level:"feature",component:null},{type:"render",level:"step",component:null},{type:"render",level:"detail",component:null},"handleDismissed"]},paused:{on:{CONTINUE:"active.feature"},onEntry:[{type:"render",level:"feature",component:null},{type:"render",level:"step",component:null},{type:"render",level:"detail",component:null},{type:"render",level:"tutorial",component:"wizard/tutorial-paused"},"handlePaused"],onExit:["handleResume"]},complete:{onEntry:[{type:"render",level:"feature",component:null},{type:"render",level:"step",component:null},{type:"render",level:"detail",component:null},{type:"render",level:"tutorial",component:"wizard/tutorial-complete"}]}}}}),define("vault/macros/identity-capabilities",["exports","vault/macros/lazy-capabilities"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(){return(0,t.default)((0,t.apiPath)(s,"identityType","id"),"id","identityType")}
var n,a,s=(n=["identity/","/id/",""],a=["identity/","/id/",""],Object.freeze(Object.defineProperties(n,{raw:{value:Object.freeze(a)}})))}),define("vault/macros/lazy-capabilities",["exports","vault/macros/maybe-query-record"],function(e,t){function n(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}Object.defineProperty(e,"__esModule",{value:!0}),e.apiPath=function(e){for(var t=arguments.length,n=Array(t>1?t-1:0),a=1;a<t;a++)n[a-1]=arguments[a]
return function(t){var a=t||{},s=[e[0]]
return n.forEach(function(t,n){s.push(a[t],e[n+1])}),s.join("")}},e.default=function(){var e=Array.prototype.slice.call(arguments),a=e[0],s=e.slice(1)
return t.maybeQueryRecord.apply(void 0,["capabilities",function(e){var t=e.getProperties.apply(e,n(s)),r=Object.keys(t).reduce(function(e,n){return null!=t[n]&&(e[n]=t[n]),e},{})
if(Object.keys(r).length===s.length)return{id:a(r)}}].concat(n(s)))}}),define("vault/macros/maybe-query-record",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.maybeQueryRecord=function(e){for(var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=arguments.length,a=Array(n>2?n-2:0),s=2;s<n;s++)a[s-2]=arguments[s]
return Ember.computed.apply(void 0,a.concat([{get:function(){var n="function"==typeof t?t(this):t,a=Ember.ObjectProxy.extend(Ember.PromiseProxyMixin)
return a.create({promise:n?this.get("store").queryRecord(e,n):Ember.RSVP.resolve({})})}}]))}}),define("vault/mixins/backend-crumb",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Mixin.create({backendCrumb:Ember.computed("backend",function(){var e=this.get("backend")
if(void 0===e)throw new Error("backend-crumb mixin requires backend to be set")
return{label:e,text:e,path:"vault.cluster.secrets.backend.list-root",model:e}})})}),define("vault/mixins/cluster-route",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t="vault.cluster.init",n="vault.cluster.unseal",a="vault.cluster.auth",s="vault.cluster.oidc-callback"
e.INIT=t,e.UNSEAL=n,e.AUTH=a,e.CLUSTER="vault.cluster",e.CLUSTER_INDEX="vault.cluster.index",e.DR_REPLICATION_SECONDARY="vault.cluster.replication-dr-promote",e.default=Ember.Mixin.create({auth:Ember.inject.service(),store:Ember.inject.service(),router:Ember.inject.service(),transitionToTargetRoute:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},t=this.targetRouteName(e)
return t&&t!==this.routeName&&t!==e.targetName&&t!==this.router.currentRouteName?t===a&&"vault.cluster.index"!==e.targetName?this.transitionTo(t,{queryParams:{redirect_to:this.router.currentURL}}):this.transitionTo(t):Ember.RSVP.resolve()},beforeModel:function(e){return this.transitionToTargetRoute(e)},clusterModel:function(){return this.modelFor("vault.cluster")||this.store.peekRecord("cluster","vault")},authToken:function(){return Ember.get(this,"auth.currentToken")},hasKeyData:function(){return!!Ember.get(this.controllerFor(t),"keyData")},targetRouteName:function(e){var r=this.clusterModel(),l=this.authToken()
return Ember.get(r,"needsInit")?t:this.hasKeyData()&&this.routeName!==n&&this.routeName!==a?t:Ember.get(r,"sealed")?n:Ember.get(r,"dr.isSecondary")?"vault.cluster.replication-dr-promote":l?!Ember.get(r,"needsInit")&&this.routeName===t||!Ember.get(r,"sealed")&&this.routeName===n||!Ember.get(r,"dr.isSecondary")&&"vault.cluster.replication-dr-promote"===this.routeName||l&&this.routeName===a?"vault.cluster":null:e&&e.targetName===s||this.routeName===s?s:a}})}),define("vault/mixins/focus-on-insert",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Mixin.create({focusOnInsertSelector:null,shouldFocus:!0,focusOnInsert:Ember.on("didInsertElement",function(){Ember.run.schedule("afterRender",this,"focusOnInsertFocus")}),focusOnInsertFocus:function(){!1!==this.get("shouldFocus")&&this.forceFocus()},forceFocus:function(){var e=this.element.querySelectorAll(this.get("focusOnInsertSelector")||'input[type="text"]')[0]
e&&e!==document.activeElement&&e.focus()}})}),define("vault/mixins/key-mixin",["exports","vault/lib/key-utils"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Mixin.create({pathAttr:"id",flags:null,initialParentKey:null,isCreating:Ember.computed("initialParentKey",function(){return null!=this.get("initialParentKey")}),pathVal:function(){return this.get(this.pathAttr)},isFolder:Ember.computed("id","path",function(){return t.default.keyIsFolder(this.pathVal())}),keyParts:Ember.computed("id","path",function(){return t.default.keyPartsForKey(this.pathVal())}),parentKey:Ember.computed("id","path","isCreating",{get:function(){return this.isCreating?this.initialParentKey:t.default.parentKeyForKey(this.pathVal())},set:function(e,t){return t}}),keyWithoutParent:Ember.computed("id","path","parentKey",{get:function(){var e=this.pathVal()
return e?e.replace(this.parentKey,""):null},set:function(e,t){return t&&t.trim()?this.set(this.pathAttr,this.parentKey+t):this.set(this.pathAttr,null),t}})})}),define("vault/mixins/link-action",["exports","ember-link-action/mixins/link-action"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/mixins/list-controller",["exports","core/mixins/list-controller"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/mixins/list-route",["exports","core/mixins/list-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/mixins/model-boundary-route",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Mixin.create({modelType:null,modelTypes:null,verifyProps:Ember.on("init",function(){this.get("modelType"),this.get("modelTypes")}),clearModelCache:Ember.on("deactivate",function(){var e=this,t=this.get("modelType"),n=this.get("modelTypes");(t||n)&&(t&&this.store.unloadAll(t),n&&n.forEach(function(t){e.store.unloadAll(t)}))})})}),define("vault/mixins/policy-edit-controller",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Mixin.create({flashMessages:Ember.inject.service(),wizard:Ember.inject.service(),actions:{deletePolicy:function(e){var t=this,n=e.get("policyType"),a=e.get("name"),s=this.get("flashMessages")
e.destroyRecord().then(function(){return s.success(n.toUpperCase()+' policy "'+a+'" was successfully deleted.'),t.transitionToRoute("vault.cluster.policies",n)}).catch(function(e){var t=e.errors?e.errors.join(""):e.message
s.danger("There was an error deleting the "+n.toUpperCase()+' policy "'+a+'": '+t+".")})},savePolicy:function(e){var t=this,n=this.get("flashMessages"),a=e.get("policyType"),s=e.get("name")
e.save().then(function(e){return n.success(a.toUpperCase()+' policy "'+s+'" was successfully saved.'),"create"===t.get("wizard.featureState")&&t.get("wizard").transitionFeatureMachine("create","CONTINUE",a),t.transitionToRoute("vault.cluster.policy.show",e.get("policyType"),e.get("name"))}).catch(function(){})},setModelName:function(e,t){e.set("name",t.target.value.toLowerCase())}}})})
define("vault/mixins/replication-actions",["exports","core/mixins/replication-actions"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/mixins/unload-model-route",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Mixin.create({modelPath:"model",unloadModel:function(){var e=this.modelPath,t=this.controller.get(e)
t&&t.unloadRecord&&(this.store.unloadRecord(t),t.destroy(),this.controller.set(e,null))},actions:{willTransition:function(){return this.unloadModel(),!0}}})}),define("vault/mixins/unsaved-model-route",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Mixin.create({actions:{willTransition:function(e){var t=this.controller.get("model")
return!t||(!Ember.get(t,"hasDirtyAttributes")||(window.confirm("You have unsaved changes. Navigating away will discard these changes. Are you sure you want to discard your changes?")?(this.unloadModel(),!0):(e.abort(),!1)))}}})}),define("vault/mixins/with-nav-to-nearest-ancestor",["exports","vault/lib/key-utils","ember-concurrency"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Mixin.create({navToNearestAncestor:(0,n.task)(regeneratorRuntime.mark(function e(n){var a,s,r,l
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:a=t.default.ancestorKeysForKey(n),s=!1,r=a.pop()
case 3:if(!r){e.next=23
break}return e.prev=4,(l=this.transitionToRoute("vault.cluster.secrets.backend.list",r)).data.isDeletion=!0,e.next=9,l.promise
case 9:e.next=15
break
case 11:e.prev=11,e.t0=e.catch(4),s=!0,r=a.pop()
case 15:if(e.prev=15,s){e.next=19
break}return r=null,e.abrupt("return")
case 19:return s=!1,e.finish(15)
case 21:e.next=3
break
case 23:return e.next=25,this.transitionToRoute("vault.cluster.secrets.backend.list-root")
case 25:case"end":return e.stop()}},e,this,[[4,11,15,21]])}))})}),define("vault/models/auth-config",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=t.default.belongsTo
e.default=t.default.Model.extend({backend:n("auth-method",{inverse:"authConfigs",readOnly:!0,async:!1}),getHelpUrl:function(e){return"/v1/auth/"+e+"/config?help=1"}})}),define("vault/models/auth-config/approle",["exports","vault/models/auth-config"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({})}),define("vault/models/auth-config/aws/client",["exports","ember-data","vault/models/auth-config","vault/utils/field-to-attrs"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=t.default.attr
e.default=n.default.extend({secretKey:s("string"),accessKey:s("string"),endpoint:s("string",{label:"EC2 Endpoint"}),iamEndpoint:s("string",{label:"IAM Endpoint"}),stsEndpoint:s("string",{label:"STS Endpoint"}),iamServerIdHeaderValue:s("string",{label:"IAM Server ID Header Value"}),fieldGroups:Ember.computed(function(){return(0,a.default)(this,[{default:["accessKey","secretKey"]},{"AWS Options":["endpoint","iamEndpoint","stsEndpoint","iamServerIdHeaderValue"]}])})})}),define("vault/models/auth-config/aws/identity-whitelist",["exports","vault/models/auth-config/aws/tidy"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/models/auth-config/aws/roletag-blacklist",["exports","vault/models/auth-config/aws/tidy"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/models/auth-config/aws/tidy",["exports","ember-data","vault/utils/field-to-attrs","vault/models/auth-config"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=t.default.attr
e.default=a.default.extend({safetyBuffer:s({defaultValue:"72h",editType:"ttl"}),disablePeriodicTidy:s("boolean",{defaultValue:!1}),attrs:Ember.computed(function(){return(0,n.expandAttributeMeta)(this,["safetyBuffer","disablePeriodicTidy"])})})}),define("vault/models/auth-config/azure",["exports","ember-data","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=t.default.attr
e.default=n.default.extend({useOpenAPI:!0,tenantId:r("string",{label:"Tenant ID",helpText:"The tenant ID for the Azure Active Directory organization"}),resource:r("string",{helpText:"The configured URL for the application registered in Azure Active Directory"}),clientId:r("string",{label:"Client ID",helpText:"The client ID for credentials to query the Azure APIs. Currently read permissions to query compute resources are required."}),clientSecret:r("string",{helpText:"The client secret for credentials to query the Azure APIs"}),googleCertsEndpoint:r("string"),fieldGroups:Ember.computed(function(){var e=[{default:["tenantId","resource"]},{"Azure Options":["clientId","clientSecret"]}]
return this.newFields&&(e=(0,a.combineFieldGroups)(e,this.newFields,[])),(0,s.default)(this,e)})})}),define("vault/models/auth-config/cert",["exports","vault/models/auth-config"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({})}),define("vault/models/auth-config/gcp",["exports","ember-data","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=t.default.attr
e.default=n.default.extend({useOpenAPI:!0,credentials:r("string",{editType:"file"}),googleCertsEndpoint:r("string"),fieldGroups:Ember.computed(function(){var e=[{default:["credentials"]},{"Google Cloud Options":["googleCertsEndpoint"]}]
return this.newFields&&(e=(0,a.combineFieldGroups)(e,this.newFields,[])),(0,s.default)(this,e)})})}),define("vault/models/auth-config/github",["exports","ember-data","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=t.default.attr
e.default=n.default.extend({useOpenAPI:!0,organization:r("string"),baseUrl:r("string",{label:"Base URL"}),fieldGroups:Ember.computed(function(){var e=[{default:["organization"]},{"GitHub Options":["baseUrl"]},{TTLs:["ttl","maxTtl"]}]
return this.newFields&&(e=(0,s.combineFieldGroups)(e,this.newFields,[])),(0,a.default)(this,e)})})}),define("vault/models/auth-config/jwt",["exports","ember-data","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=t.default.attr
e.default=n.default.extend({useOpenAPI:!0,oidcDiscoveryUrl:r("string",{label:"OIDC discovery URL",helpText:"The OIDC discovery URL, without any .well-known component (base path). Cannot be used with jwt_validation_pubkeys"}),oidcClientId:r("string",{label:"OIDC client ID"}),oidcClientSecret:r("string",{label:"OIDC client secret"}),oidcDiscoveryCaPem:r("string",{label:"OIDC discovery CA PEM",editType:"file",helpText:"The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used"}),jwtValidationPubkeys:r({label:"JWT validation public keys",editType:"stringArray"}),jwtSupportedAlgs:r({label:"JWT supported algorithms"}),boundIssuer:r("string",{helpText:"The value against which to match the iss claim in a JWT"}),fieldGroups:Ember.computed(function(){var e,t,n,r=this.constructor.modelName.split("/")[1].toUpperCase(),l=[{default:["oidcDiscoveryUrl","defaultRole"]},(e={},t=r+" Options",n=["oidcClientId","oidcClientSecret","oidcDiscoveryCaPem","jwtValidationPubkeys","jwtSupportedAlgs","boundIssuer"],t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e)]
return this.newFields&&(l=(0,s.combineFieldGroups)(l,this.newFields,[])),(0,a.default)(this,l)})})}),define("vault/models/auth-config/kubernetes",["exports","ember-data","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=t.default.attr
e.default=n.default.extend({useOpenAPI:!0,kubernetesHost:r("string",{helpText:"Host must be a host string, a host:port pair, or a URL to the base of the Kubernetes API server"}),kubernetesCaCert:r("string",{editType:"file",helpText:"PEM encoded CA cert for use by the TLS client used to talk with the Kubernetes API"}),tokenReviewerJwt:r("string",{helpText:"A service account JWT used to access the TokenReview API to validate other JWTs during login. If not set the JWT used for login will be used to access the API"}),pemKeys:r({editType:"stringArray"}),fieldGroups:Ember.computed(function(){var e=[{default:["kubernetesHost","kubernetesCaCert"]},{"Kubernetes Options":["tokenReviewerJwt","pemKeys"]}]
return this.newFields&&(e=(0,a.combineFieldGroups)(e,this.newFields,[])),(0,s.default)(this,e)})})}),define("vault/models/auth-config/ldap",["exports","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({useOpenAPI:!0,fieldGroups:Ember.computed(function(){var e=[{default:["url"]},{"LDAP Options":["starttls","insecureTls","discoverdn","denyNullBind","tlsMinVersion","tlsMaxVersion","certificate","userattr","upndomain"]},{"Customize User Search":["binddn","userdn","bindpass"]},{"Customize Group Membership Search":["groupfilter","groupattr","groupdn","useTokenGroups"]}]
return this.newFields&&(e=(0,a.combineFieldGroups)(e,this.newFields,[])),(0,n.default)(this,e)})})}),define("vault/models/auth-config/oidc",["exports","vault/models/auth-config/jwt"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/models/auth-config/okta",["exports","ember-data","vault/models/auth-config","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=t.default.attr
e.default=n.default.extend({useOpenAPI:!0,orgName:r("string",{helpText:"Name of the organization to be used in the Okta API"}),apiToken:r("string",{helpText:"Okta API token. This is required to query Okta for user group membership. If this is not supplied only locally configured groups will be enabled."}),baseUrl:r("string",{helpText:"If set, will be used as the base domain for API requests. Examples are okta.com, oktapreview.com, and okta-emea.com"}),bypassOktaMfa:r("boolean",{defaultValue:!1,helpText:"Useful if Vault's built-in MFA mechanisms. Will also cause certain other statuses to be ignored, such as PASSWORD_EXPIRED"}),fieldGroups:Ember.computed(function(){var e=[{default:["orgName"]},{Options:["apiToken","baseUrl","bypassOktaMfa"]}]
return this.newFields&&(e=(0,s.combineFieldGroups)(e,this.newFields,[])),(0,a.default)(this,e)})})}),define("vault/models/auth-config/radius",["exports","ember-data","vault/models/auth-config","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=t.default.attr
e.default=n.default.extend({useOpenAPI:!0,host:r("string"),secret:r("string"),fieldGroups:Ember.computed(function(){var e=[{default:["host","secret"]},{"RADIUS Options":["port","nasPort","nasIdentifier","dialTimeout","unregisteredUserPolicies"]}]
return this.newFields&&(e=(0,a.combineFieldGroups)(e,this.newFields,[])),(0,s.default)(this,e)})})}),define("vault/models/auth-config/userpass",["exports","vault/models/auth-config"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({})}),define("vault/models/auth-method",["exports","ember-data","ember-data-model-fragments/attributes","vault/utils/field-to-attrs","ember-api-actions","vault/utils/api-path","vault/lib/attach-capabilities"],function(e,t,n,a,s,r,l){Object.defineProperty(e,"__esModule",{value:!0})
var i=c(["sys/auth/",""],["sys/auth/",""]),o=c(["auth/","/config/client"],["auth/","/config/client"]),u=c(["auth/","/config"],["auth/","/config"])
function c(e,t){return Object.freeze(Object.defineProperties(e,{raw:{value:Object.freeze(t)}}))}var d=t.default.attr,m=t.default.hasMany,p=t.default.Model.extend({authConfigs:m("auth-config",{polymorphic:!0,inverse:"backend",async:!1}),path:d("string"),accessor:d("string"),name:d("string"),type:d("string"),methodType:Ember.computed("type",function(){return this.get("type").replace(/^ns_/,"")}),description:d("string",{editType:"textarea"}),config:(0,n.fragment)("mount-config",{defaultValue:{}}),local:d("boolean",{helpText:"When Replication is enabled, a local mount will not be replicated across clusters. This can only be specified at mount time."}),sealWrap:d("boolean",{helpText:"When enabled - if a seal supporting seal wrapping is specified in the configuration, all critical security parameters (CSPs) in this backend will be seal wrapped. (For K/V mounts, all values will be seal wrapped.) This can only be specified at mount time."}),apiPath:Ember.computed("path",function(){return"auth/"+this.get("path")}),localDisplay:Ember.computed("local",function(){return this.get("local")?"local":"replicated"}),tuneAttrs:Ember.computed(function(){return(0,a.expandAttributeMeta)(this,["description","config.{listingVisibility,defaultLeaseTtl,maxLeaseTtl,tokenType,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders}"])}),tune:(0,s.memberAction)({path:"tune",type:"post",urlType:"updateRecord"}),formFields:Ember.computed(function(){return["type","path","description","accessor","local","sealWrap","config.{listingVisibility,defaultLeaseTtl,maxLeaseTtl,tokenType,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders}"]}),formFieldGroups:Ember.computed(function(){return[{default:["path"]},{"Method Options":["description","config.listingVisibility","local","sealWrap","config.{defaultLeaseTtl,maxLeaseTtl,tokenType,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders}"]}]}),attrs:Ember.computed("formFields",function(){return(0,a.expandAttributeMeta)(this,this.get("formFields"))}),fieldGroups:Ember.computed("formFieldGroups",function(){return(0,a.default)(this,this.get("formFieldGroups"))}),canDisable:Ember.computed.alias("deletePath.canDelete"),canEdit:Ember.computed.alias("configPath.canUpdate")})
e.default=(0,l.default)(p,{deltePath:(0,r.default)(i,"id"),configPath:function(e){return"aws"===e.type?(0,r.default)(o,"id"):(0,r.default)(u,"id")}})}),define("vault/models/aws-credential",["exports","ember-data","vault/utils/field-to-attrs"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=t.default.attr,s=["accessKey","secretKey","securityToken","leaseId","renewable","leaseDuration"]
e.default=t.default.Model.extend({helpText:"For Vault roles of credential type iam_user, there are no inputs, just submit the form. Choose a type to change the input options.",role:a("object",{readOnly:!0}),credentialType:a("string",{defaultValue:"iam_user",possibleValues:[{value:"iam_user",displayName:"IAM User"},{value:"assumed_role",displayName:"Assumed Role"},{value:"federation_token",displayName:"Federation Token"}],readOnly:!0}),roleArn:a("string",{label:"Role ARN",helpText:"The ARN of the role to assume if credential_type on the Vault role is assumed_role. Optional if the role has a single role ARN; required otherwise."}),ttl:a({editType:"ttl",defaultValue:"3600s",setDefault:!0,label:"TTL",helpText:"Specifies the TTL for the use of the STS token. Valid only when credential_type is assumed_role or federation_token."}),leaseId:a("string"),renewable:a("boolean"),leaseDuration:a("number"),accessKey:a("string"),secretKey:a("string"),securityToken:a("string"),attrs:Ember.computed("credentialType","accessKey","securityToken",function(){var e=this.get("credentialType")
return this.get("accessKey")||this.get("securityToken")?(0,n.expandAttributeMeta)(this,s.slice(0)):(0,n.expandAttributeMeta)(this,{iam_user:["credentialType"],assumed_role:["credentialType","ttl","roleArn"],federation_token:["credentialType","ttl"]}[e].slice(0))}),toCreds:Ember.computed("accessKey","secretKey","securityToken","leaseId",function(){var e=this.getProperties("accessKey","secretKey","securityToken","leaseId"),t=Object.keys(e).reduce(function(t,n){return e[n]?(t[n]=e[n],t):t},{})
return JSON.stringify(t,null,2)})})}),define("vault/models/capabilities",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.SUDO_PATH_PREFIXES=e.SUDO_PATHS=void 0
var n=t.default.attr,a=["sys/seal","sys/replication/performance/primary/secondary-token","sys/replication/dr/primary/secondary-token","sys/replication/reindex","sys/leases/lookup/"],s=["sys/leases/revoke-prefix","sys/leases/revoke-force"]
e.SUDO_PATHS=a,e.SUDO_PATH_PREFIXES=s
var r=function(e){return Ember.computed("path","capabilities","capabilities.[]",function(){var t=this.get("capabilities"),n=this.get("path")
return!!t&&(!!t.includes("root")||!t.includes("deny")&&(a.includes(n)||s.find(function(e){return n.startsWith(e)})?t.includes("sudo")&&t.includes(e):t.includes(e)))})}
e.default=t.default.Model.extend({path:n("string"),capabilities:n("array"),canSudo:r("sudo"),canRead:r("read"),canCreate:r("create"),canUpdate:r("update"),canDelete:r("delete"),canList:r("list"),allowedParameters:n(),deniedParameters:n()})}),define("vault/models/cluster",["exports","ember-data","ember-data-model-fragments/attributes"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=t.default.hasMany,s=t.default.attr
e.default=t.default.Model.extend({version:Ember.inject.service(),nodes:a("nodes",{async:!1}),name:s("string"),status:s("string"),standby:s("boolean"),type:s("string"),needsInit:Ember.computed("nodes","nodes.@each.initialized",function(){return this.get("nodes").isEvery("initialized",!1)}),unsealed:Ember.computed("nodes","nodes.{[],@each.sealed}",function(){return!!this.get("nodes").findBy("sealed",!1)}),sealed:Ember.computed.not("unsealed"),leaderNode:Ember.computed("nodes","nodes.[]",function(){var e=this.get("nodes")
return 1===e.get("length")?e.get("firstObject"):e.findBy("isLeader")}),sealThreshold:Ember.computed.alias("leaderNode.sealThreshold"),sealProgress:Ember.computed.alias("leaderNode.progress"),sealType:Ember.computed.alias("leaderNode.type"),hasProgress:Ember.computed.gte("sealProgress",1),mode:s("string"),allReplicationDisabled:Ember.computed.and("{dr,performance}.replicationDisabled"),anyReplicationEnabled:Ember.computed.or("{dr,performance}.replicationEnabled"),stateDisplay:function(e){if(!e)return null
return{"stream-wals":"Streaming","merkle-diff":"Determining sync status","merkle-sync":"Syncing"}[e]||"Synced"},drStateDisplay:Ember.computed("dr.state",function(){return this.stateDisplay(this.get("dr.state"))}),performanceStateDisplay:Ember.computed("performance.state",function(){return this.stateDisplay(this.get("performance.state"))}),stateGlyph:function(e){return{"stream-wals":"android-sync","merkle-diff":"android-sync","merkle-sync":null}[e]||"check-circled-outline"},drStateGlyph:Ember.computed("dr.state",function(){return this.stateGlyph(this.get("dr.state"))}),performanceStateGlyph:Ember.computed("performance.state",function(){return this.stateGlyph(this.get("performance.state"))}),dr:(0,n.fragment)("replication-attributes"),performance:(0,n.fragment)("replication-attributes"),rm:Ember.inject.service("replication-mode"),replicationMode:Ember.computed.alias("rm.mode"),replicationAttrs:Ember.computed("dr.mode","performance.mode","replicationMode",function(){var e=this.get("replicationMode")
return e?Ember.get(this,e):null})})}),define("vault/models/control-group-config",["exports","ember-data","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s,r,l=(s=["sys/config/control-group"],r=["sys/config/control-group"],Object.freeze(Object.defineProperties(s,{raw:{value:Object.freeze(r)}})))
var i=t.default.attr
e.default=t.default.Model.extend({fields:Ember.computed(function(){return(0,a.expandAttributeMeta)(this,["maxTtl"])}),configurePath:(0,n.default)((0,n.apiPath)(l)),canDelete:Ember.computed.alias("configurePath.canDelete"),maxTtl:i({defaultValue:0,editType:"ttl",label:"Maximum TTL"})})}),define("vault/models/control-group",["exports","ember-data","vault/macros/lazy-capabilities"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=r(["sys/control-group/authorize"],["sys/control-group/authorize"]),s=r(["sys/config/control-group"],["sys/config/control-group"])
function r(e,t){return Object.freeze(Object.defineProperties(e,{raw:{value:Object.freeze(t)}}))}var l=t.default.attr,i=t.default.belongsTo,o=t.default.hasMany
e.default=t.default.Model.extend({approved:l("boolean"),requestPath:l("string"),requestEntity:i("identity/entity",{async:!1}),authorizations:o("identity/entity",{async:!1}),authorizePath:(0,n.default)((0,n.apiPath)(a)),canAuthorize:Ember.computed.alias("authorizePath.canUpdate"),configurePath:(0,n.default)((0,n.apiPath)(s)),canConfigure:Ember.computed.alias("configurePath.canUpdate")})}),define("vault/models/identity/_base",["exports","ember-data","vault/utils/field-to-attrs"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.Model.extend({formFields:Ember.computed(function(){return assert("formFields should be overridden",!1)}),fields:Ember.computed("formFields","formFields.[]",function(){return(0,n.expandAttributeMeta)(this,this.get("formFields"))}),identityType:Ember.computed(function(){return this.constructor.modelName.split("/")[1]})})}),define("vault/models/identity/entity-alias",["exports","vault/models/identity/_base","ember-data","vault/macros/identity-capabilities"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=n.default.attr,r=n.default.belongsTo
e.default=t.default.extend({parentType:"entity",formFields:Ember.computed(function(){return["name","mountAccessor"]}),entity:r("identity/entity",{readOnly:!0,async:!1}),name:s("string"),canonicalId:s("string"),mountAccessor:s("string",{label:"Auth Backend",editType:"mountAccessor"}),metadata:s({editType:"kv"}),mountPath:s("string",{readOnly:!0}),mountType:s("string",{readOnly:!0}),creationTime:s("string",{readOnly:!0}),lastUpdateTime:s("string",{readOnly:!0}),mergedFromCanonicalIds:s(),updatePath:(0,a.default)(),canDelete:Ember.computed.alias("updatePath.canDelete"),canEdit:Ember.computed.alias("updatePath.canUpdate")})}),define("vault/models/identity/entity-merge",["exports","ember-data","vault/models/identity/_base"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=t.default.attr
e.default=n.default.extend({formFields:Ember.computed(function(){return["toEntityId","fromEntityIds","force"]}),toEntityId:a("string",{label:"Entity to merge to"}),fromEntityIds:a({label:"Entities to merge from",editType:"stringArray"}),force:a("boolean",{label:'Keep MFA secrets from the "to" entity if there are merge conflicts',defaultValue:!1})})})
define("vault/models/identity/entity",["exports","vault/models/identity/_base","ember-data","vault/utils/api-path","vault/lib/attach-capabilities"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=i(["identity/","/id/",""],["identity/","/id/",""]),l=i(["identity/entity-alias"],["identity/entity-alias"])
function i(e,t){return Object.freeze(Object.defineProperties(e,{raw:{value:Object.freeze(t)}}))}var o=n.default.attr,u=n.default.hasMany,c=t.default.extend({formFields:Ember.computed(function(){return["name","disabled","policies","metadata"]}),name:o("string"),disabled:o("boolean",{defaultValue:!1,label:"Disable entity",helpText:"All associated tokens cannot be used, but are not revoked."}),mergedEntityIds:o(),metadata:o({editType:"kv"}),policies:o({label:"Policies",editType:"searchSelect",fallbackComponent:"string-list",models:["policy/acl","policy/rgp"]}),creationTime:o("string",{readOnly:!0}),lastUpdateTime:o("string",{readOnly:!0}),aliases:u("identity/entity-alias",{async:!1,readOnly:!0}),groupIds:o({readOnly:!0}),directGroupIds:o({readOnly:!0}),inheritedGroupIds:o({readOnly:!0}),canDelete:Ember.computed.alias("updatePath.canDelete"),canEdit:Ember.computed.alias("updatePath.canUpdate"),canRead:Ember.computed.alias("updatePath.canRead"),canAddAlias:Ember.computed.alias("aliasPath.canCreate")})
e.default=(0,s.default)(c,{updatePath:(0,a.default)(r,"identityType","id"),aliasPath:(0,a.default)(l)})}),define("vault/models/identity/group-alias",["exports","vault/models/identity/_base","ember-data","vault/macros/identity-capabilities"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=n.default.attr,r=n.default.belongsTo
e.default=t.default.extend({parentType:"group",formFields:Ember.computed(function(){return["name","mountAccessor"]}),group:r("identity/group",{readOnly:!0,async:!1}),name:s("string"),canonicalId:s("string"),mountPath:s("string",{readOnly:!0}),mountType:s("string",{readOnly:!0}),mountAccessor:s("string",{label:"Auth Backend",editType:"mountAccessor"}),creationTime:s("string",{readOnly:!0}),lastUpdateTime:s("string",{readOnly:!0}),updatePath:(0,a.default)(),canDelete:Ember.computed.alias("updatePath.canDelete"),canEdit:Ember.computed.alias("updatePath.canUpdate")})}),define("vault/models/identity/group",["exports","vault/models/identity/_base","ember-data","vault/macros/lazy-capabilities","vault/macros/identity-capabilities"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r,l,i=(r=["identity/group-alias"],l=["identity/group-alias"],Object.freeze(Object.defineProperties(r,{raw:{value:Object.freeze(l)}})))
var o=n.default.attr,u=n.default.belongsTo
e.default=t.default.extend({formFields:Ember.computed("type",function(){var e=["name","type","policies","metadata"]
return"internal"===this.get("type")?e.concat(["memberGroupIds","memberEntityIds"]):e}),name:o("string"),type:o("string",{defaultValue:"internal",possibleValues:["internal","external"]}),creationTime:o("string",{readOnly:!0}),lastUpdateTime:o("string",{readOnly:!0}),numMemberEntities:o("number",{readOnly:!0}),numParentGroups:o("number",{readOnly:!0}),metadata:o("object",{editType:"kv"}),policies:o({label:"Policies",editType:"searchSelect",fallbackComponent:"string-list",models:["policy/acl","policy/rgp"]}),memberGroupIds:o({label:"Member Group IDs",editType:"searchSelect",fallbackComponent:"string-list",models:["identity/group"]}),parentGroupIds:o({label:"Parent Group IDs",editType:"searchSelect",fallbackComponent:"string-list",models:["identity/group"]}),memberEntityIds:o({label:"Member Entity IDs",editType:"searchSelect",fallbackComponent:"string-list",models:["identity/entity"]}),hasMembers:Ember.computed("memberEntityIds","memberEntityIds.[]","memberGroupIds","memberGroupIds.[]",function(){var e=this.getProperties("memberEntityIds","memberGroupIds"),t=e.memberEntityIds,n=e.memberGroupIds
return(t&&t.get("length")||0)+(n&&n.get("length")||0)>0}),alias:u("identity/group-alias",{async:!1,readOnly:!0}),updatePath:(0,s.default)(),canDelete:Ember.computed.alias("updatePath.canDelete"),canEdit:Ember.computed.alias("updatePath.canUpdate"),aliasPath:(0,a.default)((0,a.apiPath)(i)),canAddAlias:Ember.computed("aliasPath.canCreate","type","alias",function(){var e=this.get("type"),t=this.get("alias")
return"internal"!==e&&!t&&this.get("aliasPath.canCreate")})})}),define("vault/models/kmip/ca",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=t.default.attr,a=t.default.belongsTo
e.default=t.default.Model.extend({config:a("kmip/config",{async:!1}),caPem:n("string",{label:"CA PEM"})})}),define("vault/models/kmip/config",["exports","ember-data","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=t.default.belongsTo
e.default=t.default.Model.extend({useOpenAPI:!0,ca:s("kmip/ca",{async:!1}),getHelpUrl:function(e){return"/v1/"+e+"/config?help=1"},fieldGroups:Ember.computed(function(){var e=[{default:["listenAddrs","connectionTimeout"]}]
return e=(0,n.combineFieldGroups)(e,this.newFields,[]),(0,a.default)(this,e)})})}),define("vault/models/kmip/credential",["exports","ember-data","vault/utils/field-to-attrs","vault/utils/api-path","vault/lib/attach-capabilities"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r,l,i=(r=["","/scope/","/role/","/credentials/revoke"],l=["","/scope/","/role/","/credentials/revoke"],Object.freeze(Object.defineProperties(r,{raw:{value:Object.freeze(l)}})))
var o=t.default.attr,u=t.default.Model.extend({backend:o({readOnly:!0}),scope:o({readOnly:!0}),role:o({readOnly:!0}),certificate:o("string",{readOnly:!0}),caChain:o({readOnly:!0}),privateKey:o("string",{readOnly:!0,sensitive:!0}),format:o("string",{possibleValues:["pem","der","pem_bundle"],defaultValue:"pem",label:"Certificate format"}),fieldGroups:Ember.computed(function(){return(0,n.default)(this,[{default:["format"]}])})})
e.default=(0,s.default)(u,{deletePath:(0,a.default)(i,"backend","scope","role")})}),define("vault/models/kmip/role",["exports","ember-data","vault/utils/field-to-attrs","vault/utils/api-path","vault/lib/attach-capabilities"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0}),e.COMPUTEDS=void 0
var r,l,i=(r=["","/scope/","/role/",""],l=["","/scope/","/role/",""],Object.freeze(Object.defineProperties(r,{raw:{value:Object.freeze(l)}})))
var o=t.default.attr,u=e.COMPUTEDS={operationFields:Ember.computed("newFields",function(){return this.newFields.filter(function(e){return e.startsWith("operation")})}),operationFieldsWithoutSpecial:Ember.computed("operationFields",function(){return this.operationFields.slice().removeObjects(["operationAll","operationNone"])}),tlsFields:Ember.computed(function(){return["tlsClientKeyBits","tlsClientKeyType","tlsClientTtl"]}),nonOperationFields:Ember.computed("tlsFields","operationFields",function(){var e=["role"].concat(this.operationFields,this.tlsFields)
return this.newFields.slice().removeObjects(e)})},c=t.default.Model.extend(u,{useOpenAPI:!0,backend:o({readOnly:!0}),scope:o({readOnly:!0}),name:o({readOnly:!0}),getHelpUrl:function(e){return"/v1/"+e+"/scope/example/role/example?help=1"},fieldGroups:Ember.computed("fields","tlsFields","nonOperationFields",function(){var e=[{TLS:this.tlsFields}]
return this.nonOperationFields.length&&e.unshift({default:this.nonOperationFields}),(0,n.default)(this,e)}),operationFormFields:Ember.computed("operationFieldsWithoutSpecial",function(){var e=["operationCreate","operationActivate","operationGet","operationLocate","operationRekey","operationRevoke","operationDestroy"],t=["operationAddAttribute","operationGetAttributes"],a=["operationDiscoverVersion"],s=this.operationFieldsWithoutSpecial.slice().removeObjects(e.concat(t,a)),r=[{"Managed Cryptographic Objects":e},{"Object Attributes":t},{Server:a}]
return s.length&&r.push({"":s}),(0,n.default)(this,r)}),tlsFormFields:Ember.computed("tlsFields",function(){return(0,n.expandAttributeMeta)(this,this.tlsFields)}),fields:Ember.computed("nonOperationFields",function(){return(0,n.expandAttributeMeta)(this,this.nonOperationFields)})})
e.default=(0,s.default)(c,{updatePath:(0,a.default)(i,"backend","scope","id")})}),define("vault/models/kmip/scope",["exports","ember-data","vault/utils/api-path","vault/lib/attach-capabilities","vault/utils/field-to-attrs"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r,l,i=(r=["","/scope/",""],l=["","/scope/",""],Object.freeze(Object.defineProperties(r,{raw:{value:Object.freeze(l)}})))
var o=t.default.attr,u=t.default.Model.extend({name:o("string"),backend:o({readOnly:!0}),attrs:Ember.computed(function(){return(0,s.expandAttributeMeta)(this,["name"])})})
e.default=(0,a.default)(u,{updatePath:(0,n.default)(i,"backend","id")})}),define("vault/models/lease",["exports","ember-data","vault/mixins/key-mixin"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=t.default.attr
e.default=t.default.Model.extend(n.default,{issueTime:a("string"),expireTime:a("string"),lastRenewal:a("string"),renewable:a("boolean"),ttl:a("number"),isAuthLease:Ember.computed.match("id",/^auth/)})}),define("vault/models/license",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=t.default.attr
e.default=t.default.Model.extend({expirationTime:n("string"),features:n("array"),licenseId:n("string"),startTime:n("string"),text:n("string"),performanceStandbyCount:n("number")})}),define("vault/models/mount-config",["exports","ember-data/attr","ember-data-model-fragments/fragment"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=n.default.extend({defaultLeaseTtl:(0,t.default)({label:"Default Lease TTL",editType:"ttl"}),maxLeaseTtl:(0,t.default)({label:"Max Lease TTL",editType:"ttl"}),auditNonHmacRequestKeys:(0,t.default)({label:"Request keys excluded from HMACing in audit",editType:"stringArray",helpText:"Keys that will not be HMAC'd by audit devices in the request data object."}),auditNonHmacResponseKeys:(0,t.default)({label:"Response keys excluded from HMACing in audit",editType:"stringArray",helpText:"Keys that will not be HMAC'd by audit devices in the response data object."}),listingVisibility:(0,t.default)("string",{editType:"boolean",label:"List method when unauthenticated",trueValue:"unauth",falseValue:"hidden"}),passthroughRequestHeaders:(0,t.default)({label:"Allowed passthrough request headers",helpText:"Headers to whitelist and pass from the request to the backend",editType:"stringArray"}),tokenType:(0,t.default)("string",{label:"Token Type",helpText:"The type of token that should be generated via this role. Can be `service`, `batch`, or `default` to use the mount's default (which unless changed will be `service` tokens).",possibleValues:["default","batch","service"],defaultFormValue:"default"})})}),define("vault/models/mount-filter-config",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=t.default.attr
e.default=t.default.Model.extend({mode:n("string",{defaultValue:"whitelist"}),paths:n("array",{defaultValue:function(){return[]}})})}),define("vault/models/mount-options",["exports","ember-data/attr","ember-data-model-fragments/fragment"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=n.default.extend({version:(0,t.default)("number",{label:"Version",helpText:"The KV Secrets Engine can operate in different modes. Version 1 is the original generic Secrets Engine the allows for storing of static key/value pairs. Version 2 added more features including data versioning, TTLs, and check and set.",possibleValues:[2,1],defaultFormValue:2})})}),define("vault/models/namespace",["exports","ember-data","vault/utils/field-to-attrs"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=t.default.attr
e.default=t.default.Model.extend({path:a("string",{validationAttr:"pathIsValid",invalidMessage:"You have entered and invalid path please only include letters, numbers, -, ., and _."}),pathIsValid:Ember.computed("path",function(){return this.get("path")&&this.get("path").match(/^[\w\d-.]+$/g)}),description:a("string",{editType:"textarea"}),fields:Ember.computed(function(){return(0,n.expandAttributeMeta)(this,["path"])})})}),define("vault/models/node",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=t.default.attr
e.default=t.default.Model.extend({name:n("string"),initialized:n("boolean"),sealed:n("boolean"),isSealed:Ember.computed.alias("sealed"),standby:n("boolean"),isActive:Ember.computed.equal("standby",!1),clusterName:n("string"),clusterId:n("string"),isLeader:Ember.computed.and("initialized","isActive"),t:n("number"),n:n("number"),progress:n("number"),sealThreshold:Ember.computed.alias("t"),sealNumShares:Ember.computed.alias("n"),version:n("string"),type:n("string"),haEnabled:n("boolean"),isSelf:n("boolean"),leaderAddress:n("string")})}),define("vault/models/pki-ca-certificate-sign",["exports","ember-copy","ember-data","vault/models/pki-certificate-sign"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=n.default.attr
e.default=a.default.extend({backend:s("string",{readOnly:!0}),useCsrValues:s("boolean",{defaultValue:!1,label:"Use CSR values"}),maxPathLength:s("number",{defaultValue:-1}),permittedDnsNames:s("string",{label:"Permitted DNS domains"}),ou:s({label:"OU (OrganizationalUnit)",editType:"stringArray"}),organization:s({editType:"stringArray"}),country:s({editType:"stringArray"}),locality:s({editType:"stringArray",label:"Locality/City"}),province:s({editType:"stringArray",label:"Province/State"}),streetAddress:s({editType:"stringArray"}),postalCode:s({editType:"stringArray"}),fieldGroups:Ember.computed("useCsrValues",function(){var e=[{default:["csr","commonName","format","useCsrValues"]}]
return!1===this.get("useCsrValues")&&(e=e.concat([{Options:["altNames","ipSans","ttl","excludeCnFromSans","maxPathLength","permittedDnsNames","ou","organization","otherSans"]},{"Address Options":["country","locality","province","streetAddress","postalCode"]}])),this.fieldsToAttrs((0,t.copy)(e,!0))})})}),define("vault/models/pki-ca-certificate",["exports","vault/models/pki-certificate","ember-data","vault/macros/lazy-capabilities"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s,r,l=(s=["","/root"],r=["","/root"],Object.freeze(Object.defineProperties(s,{raw:{value:Object.freeze(r)}})))
var i=n.default.attr
e.default=t.default.extend({DISPLAY_FIELDS:Ember.computed(function(){return["csr","certificate","expiration","issuingCa","caChain","privateKey","privateKeyType","serialNumber"]}),backend:i("string",{readOnly:!0}),caType:i("string",{possibleValues:["root","intermediate"],defaultValue:"root",label:"CA Type",readOnly:!0}),uploadPemBundle:i("boolean",{label:"Upload PEM bundle",readOnly:!0}),pemBundle:i("string",{label:"PEM bundle",editType:"file"}),addBasicConstraints:i("boolean",{label:"Add a Basic Constraints extension with CA: true",helpText:"Only needed as a workaround in some compatibility scenarios with Active Directory Certificate Services"}),fieldDefinition:Ember.computed("caType","uploadPemBundle",function(){var e=this.get("caType"),t=[{default:["caType","uploadPemBundle"]}]
return this.get("uploadPemBundle")?t[0].default.push("pemBundle"):(t[0].default.push("type","commonName"),"root"===e&&t.push({Options:["altNames","ipSans","ttl","format","privateKeyFormat","keyType","keyBits","maxPathLength","permittedDnsNames","excludeCnFromSans","ou","organization","otherSans"]}),"intermediate"===e&&t.push({Options:["altNames","ipSans","format","privateKeyFormat","keyType","keyBits","excludeCnFromSans","addBasicConstraints","ou","organization","otherSans"]})),t.push({"Address Options":["country","locality","province","streetAddress","postalCode"]}),t}),type:i("string",{possibleValues:["internal","exported"],defaultValue:"internal"}),ou:i({label:"OU (OrganizationalUnit)",editType:"stringArray"}),organization:i({editType:"stringArray"}),country:i({editType:"stringArray"}),locality:i({editType:"stringArray",label:"Locality/City"}),province:i({editType:"stringArray",label:"Province/State"}),streetAddress:i({editType:"stringArray"}),postalCode:i({editType:"stringArray"}),keyType:i("string",{possibleValues:["rsa","ec"],defaultValue:"rsa"}),keyBits:i("number",{defaultValue:2048}),privateKeyFormat:i("string",{possibleValues:["","der","pem","pkcs8"],defaultValue:""}),maxPathLength:i("number",{defaultValue:-1}),permittedDnsNames:i("string",{label:"Permitted DNS domains"}),csr:i("string",{editType:"textarea",label:"CSR"}),expiration:i(),deletePath:(0,a.default)((0,a.apiPath)(l,"backend"),"backend"),canDeleteRoot:Ember.computed.and("deletePath.canDelete","deletePath.canSudo")})}),define("vault/models/pki-certificate-sign",["exports","ember-copy","ember-data","vault/models/pki-certificate","vault/utils/openapi-to-attrs"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=n.default.attr
e.default=a.default.extend({signVerbatim:r("boolean",{readOnly:!0,defaultValue:!1}),useOpenAPI:!0,csr:r("string",{label:"Certificate Signing Request (CSR)",editType:"textarea"}),fieldGroups:Ember.computed("signVerbatim",function(){var e=[{default:["csr","commonName","format","signVerbatim"]}]
return this.newFields&&(e=(0,s.combineFieldGroups)(e,this.newFields,[])),!1===this.get("signVerbatim")&&e.push({Options:["altNames","ipSans","ttl","excludeCnFromSans","otherSans"]}),this.fieldsToAttrs((0,t.copy)(e,!0))})})}),define("vault/models/pki-certificate",["exports","ember-data","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s,r,l=(s=["","/revoke"],r=["","/revoke"],Object.freeze(Object.defineProperties(s,{raw:{value:Object.freeze(r)}})))
var i=t.default.attr
e.default=t.default.Model.extend({idPrefix:"cert/",backend:i("string",{readOnly:!0}),idForNav:i("string",{readOnly:!0}),DISPLAY_FIELDS:Ember.computed(function(){return["certificate","issuingCa","caChain","privateKey","privateKeyType","serialNumber","revocationTime"]}),role:i("object",{readOnly:!0}),revocationTime:i("number"),commonName:i("string",{label:"Common Name"}),altNames:i("string",{label:"DNS/Email Subject Alternative Names (SANs)"}),ipSans:i("string",{label:"IP Subject Alternative Names (SANs)"}),otherSans:i({editType:"stringArray",label:"Other SANs",helpText:"The format is the same as OpenSSL: <oid>;<type>:<value> where the only current valid type is UTF8"}),ttl:i({label:"TTL",editType:"ttl"}),format:i("string",{defaultValue:"pem",possibleValues:["pem","der","pem_bundle"]}),excludeCnFromSans:i("boolean",{label:"Exclude Common Name from Subject Alternative Names (SANs)",defaultValue:!1}),certificate:i("string"),issuingCa:i("string",{label:"Issuing CA"}),caChain:i("string",{label:"CA chain"}),privateKey:i("string"),privateKeyType:i("string"),serialNumber:i("string"),fieldsToAttrs:function(e){return(0,a.default)(this,e)},fieldDefinition:Ember.computed(function(){return[{default:["commonName","format"]},{Options:["altNames","ipSans","ttl","excludeCnFromSans","otherSans"]}]}),fieldGroups:Ember.computed("fieldDefinition",function(){return this.fieldsToAttrs(this.get("fieldDefinition"))}),attrs:Ember.computed("certificate","csr",function(){var e=this.get("certificate")||this.get("csr")?this.get("DISPLAY_FIELDS").slice(0):[]
return(0,a.expandAttributeMeta)(this,e)}),toCreds:Ember.computed("certificate","issuingCa","caChain","privateKey","privateKeyType","revocationTime","serialNumber",function(){var e=this.getProperties("certificate","issuingCa","caChain","privateKey","privateKeyType","revocationTime","serialNumber"),t=Object.keys(e).reduce(function(t,n){return e[n]?(t[n]=e[n],t):t},{})
return JSON.stringify(t,null,2)}),revokePath:(0,n.default)((0,n.apiPath)(l,"backend"),"backend"),canRevoke:Ember.computed.alias("revokePath.canUpdate")})}),define("vault/models/pki-config",["exports","ember-data","vault/utils/field-to-attrs"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=t.default.attr
e.default=t.default.Model.extend({backend:a("string"),der:a(),pem:a("string"),caChain:a("string"),attrList:function(e){return(0,n.expandAttributeMeta)(this,e)},urlsAttrs:Ember.computed(function(){return this.attrList(["issuingCertificates","crlDistributionPoints","ocspServers"])}),issuingCertificates:a({editType:"stringArray"}),crlDistributionPoints:a({label:"CRL Distribution Points",editType:"stringArray"}),ocspServers:a({label:"OCSP Servers",editType:"stringArray"}),tidyAttrs:Ember.computed(function(){return this.attrList(["tidyCertStore","tidyRevocationList","safetyBuffer"])}),tidyCertStore:a("boolean",{defaultValue:!1,label:"Tidy the Certificate Store"}),tidyRevocationList:a("boolean",{defaultValue:!1,label:"Tidy the Revocation List (CRL)"}),safetyBuffer:a({defaultValue:"72h",editType:"ttl"}),crlAttrs:Ember.computed(function(){return this.attrList(["expiry"])}),expiry:a({defaultValue:"72h",editType:"ttl"})})}),define("vault/models/policy",["exports","ember-data","vault/macros/lazy-capabilities"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a,s,r=(a=["sys/policies/","/",""],s=["sys/policies/","/",""],Object.freeze(Object.defineProperties(a,{raw:{value:Object.freeze(s)}})))
var l=t.default.attr
e.default=t.default.Model.extend({name:l("string"),policy:l("string"),policyType:Ember.computed(function(){return this.constructor.modelName.split("/")[1]}),updatePath:(0,n.default)((0,n.apiPath)(r,"policyType","id"),"id","policyType"),canDelete:Ember.computed.alias("updatePath.canDelete"),canEdit:Ember.computed.alias("updatePath.canUpdate"),canRead:Ember.computed.alias("updatePath.canRead"),format:Ember.computed("policy",function(){var e=this.get("policy"),t=void 0
try{JSON.parse(e)&&(t=!0)}catch(e){t=!1}return t?"json":"hcl"})})}),define("vault/models/policy/acl",["exports","vault/models/policy"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/models/policy/egp",["exports","ember-data","vault/models/policy/rgp","vault/utils/field-to-attrs"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=t.default.attr
e.default=n.default.extend({paths:s({editType:"stringArray"}),additionalAttrs:Ember.computed(function(){return(0,a.expandAttributeMeta)(this,["enforcementLevel","paths"])})})}),define("vault/models/policy/rgp",["exports","ember-data","vault/models/policy","vault/utils/field-to-attrs"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=t.default.attr
e.default=n.default.extend({enforcementLevel:s("string",{possibleValues:["advisory","soft-mandatory","hard-mandatory"],defaultValue:"hard-mandatory"}),additionalAttrs:Ember.computed(function(){return(0,a.expandAttributeMeta)(this,["enforcementLevel"])})})}),define("vault/models/replication-attributes",["exports","ember-data/attr","ember-data-model-fragments/fragment"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=n.default.extend({clusterId:(0,t.default)("string"),clusterIdDisplay:Ember.computed("mode",function(){var e=this.get("clusterId")
return e?e.split("-")[0]:null}),mode:(0,t.default)("string"),replicationDisabled:Ember.computed.match("mode",/disabled|unsupported/),replicationUnsupported:Ember.computed.match("mode",/unsupported/),replicationEnabled:Ember.computed.not("replicationDisabled"),isPrimary:Ember.computed.match("mode",/primary/),knownSecondaries:(0,t.default)("array"),isSecondary:Ember.computed.match("mode",/secondary/),modeForUrl:Ember.computed("mode",function(){return"bootstrapping"===this.get("mode")?"bootstrapping":this.get("isSecondary")?"secondary":this.get("isPrimary")&&"primary"}),secondaryId:(0,t.default)("string"),primaryClusterAddr:(0,t.default)("string"),knownPrimaryClusterAddrs:(0,t.default)("array"),state:(0,t.default)("string"),lastRemoteWAL:(0,t.default)("number"),lastWAL:(0,t.default)("number"),merkleRoot:(0,t.default)("string"),merkleSyncProgress:(0,t.default)("object"),syncProgress:Ember.computed("state","merkleSyncProgress",function(){var e=this.getProperties("state","merkleSyncProgress"),t=e.state,n=e.merkleSyncProgress
if("merkle-sync"!==t||!n)return null
var a=n.sync_total_keys
return{progress:n.sync_progress,total:a}}).volatile(),syncProgressPercent:Ember.computed("syncProgress",function(){var e=this.get("syncProgress")
if(!e)return null
var t=e.progress,n=e.total
return Math.floor(t/n*100)}),modeDisplay:Ember.computed("mode",function(){return{disabled:"Disabled",unknown:"Unknown",bootstrapping:"Bootstrapping",primary:"Primary",secondary:"Secondary",unsupported:"Not supported"}[this.get("mode")]||"Disabled"})})}),define("vault/models/requests",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=t.default.attr
e.default=t.default.Model.extend({counters:n("array")})}),define("vault/models/role-aws",["exports","ember-data","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=l(["","/roles/",""],["","/roles/",""]),r=l(["","/creds/",""],["","/creds/",""])
function l(e,t){return Object.freeze(Object.defineProperties(e,{raw:{value:Object.freeze(t)}}))}var i=t.default.attr
e.default=t.default.Model.extend({backend:i("string",{readOnly:!0}),name:i("string",{label:"Role name",fieldValue:"id",readOnly:!0}),useOpenAPI:!1,credentialTypes:i("array",{readOnly:!0}),credentialType:i("string",{defaultValue:"iam_user",possibleValues:[{value:"iam_user",displayName:"IAM User"},{value:"assumed_role",displayName:"Assumed Role"},{value:"federation_token",displayName:"Federation Token"}]}),roleArns:i({editType:"stringArray",label:"Role ARNs"}),policyArns:i({editType:"stringArray",label:"Policy ARNs"}),policyDocument:i("string",{editType:"json"}),fields:Ember.computed("credentialType",function(){var e=this.credentialType
return(0,a.expandAttributeMeta)(this,{iam_user:["name","credentialType","policyArns","policyDocument"],assumed_role:["name","credentialType","roleArns","policyDocument"],federation_token:["name","credentialType","policyDocument"]}[e])}),updatePath:(0,n.default)((0,n.apiPath)(s,"backend","id"),"backend","id"),canDelete:Ember.computed.alias("updatePath.canDelete"),canEdit:Ember.computed.alias("updatePath.canUpdate"),canRead:Ember.computed.alias("updatePath.canRead"),generatePath:(0,n.default)((0,n.apiPath)(r,"backend","id"),"backend","id"),canGenerate:Ember.computed.alias("generatePath.canUpdate")})}),define("vault/models/role-jwt",["exports","ember-data","core/utils/parse-url"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.PROVIDER_WITH_LOGO=e.DOMAIN_STRINGS=void 0
var a=t.default.attr,s={github:"GitHub",gitlab:"GitLab",google:"Google",ping:"Ping",okta:"Okta",auth0:"Auth0"},r=["GitLab","Google","Auth0"]
e.DOMAIN_STRINGS=s,e.PROVIDER_WITH_LOGO=r,e.default=t.default.Model.extend({authUrl:a("string"),providerName:Ember.computed("authUrl",function(){var e=(0,n.default)(this.authUrl).hostname,t=Object.keys(s).find(function(t){return e.includes(t)})
return s[t]||null}),providerButtonComponent:Ember.computed("providerName",function(){var e=this.providerName
return r.includes(e)?"auth-button-"+e.toLowerCase():null})})}),define("vault/models/role-pki",["exports","ember-data","vault/macros/lazy-capabilities","vault/utils/field-to-attrs","vault/utils/openapi-to-attrs"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=u(["","/roles/",""],["","/roles/",""]),l=u(["","/issue/",""],["","/issue/",""]),i=u(["","/sign/",""],["","/sign/",""]),o=u(["","/sign-verbatim/",""],["","/sign-verbatim/",""])
function u(e,t){return Object.freeze(Object.defineProperties(e,{raw:{value:Object.freeze(t)}}))}var c=t.default.attr
e.default=t.default.Model.extend({backend:c("string",{readOnly:!0}),name:c("string",{label:"Role name",fieldValue:"id",readOnly:!0}),useOpenAPI:!0,getHelpUrl:function(e){return"/v1/"+e+"/roles/example?help=1"},updatePath:(0,n.default)((0,n.apiPath)(r,"backend","id"),"backend","id"),canDelete:Ember.computed.alias("updatePath.canDelete"),canEdit:Ember.computed.alias("updatePath.canUpdate"),canRead:Ember.computed.alias("updatePath.canRead"),generatePath:(0,n.default)((0,n.apiPath)(l,"backend","id"),"backend","id"),canGenerate:Ember.computed.alias("generatePath.canUpdate"),signPath:(0,n.default)((0,n.apiPath)(i,"backend","id"),"backend","id"),canSign:Ember.computed.alias("signPath.canUpdate"),signVerbatimPath:(0,n.default)((0,n.apiPath)(o,"backend","id"),"backend","id"),canSignVerbatim:Ember.computed.alias("signVerbatimPath.canUpdate"),fieldGroups:Ember.computed(function(){var e=[{default:["name","keyType"]},{Options:["keyBits","ttl","maxTtl","allowAnyName","enforceHostnames","allowIpSans","requireCn","useCsrCommonName","useCsrSans","ou","organization","keyUsage","allowedOtherSans","notBeforeDuration"]},{"Address Options":["country","locality","province","streetAddress","postalCode"]},{"Domain Handling":["allowLocalhost","allowBareDomains","allowSubdomains","allowGlobDomains","allowedDomains"]},{"Extended Key Usage":["serverFlag","clientFlag","codeSigningFlag","emailProtectionFlag","extKeyUsageOids"]},{Advanced:["generateLease","noStore","basicConstraintsValidForNonCa","policyIdentifiers"]}]
return this.newFields&&(e=(0,s.combineFieldGroups)(e,this.newFields,["extKeyUsage"])),(0,a.default)(this,e)})})}),define("vault/models/role-ssh",["exports","ember-data","vault/macros/lazy-capabilities","vault/utils/field-to-attrs"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=o(["","/roles/",""],["","/roles/",""]),r=o(["","/creds/",""],["","/creds/",""]),l=o(["","/sign/",""],["","/sign/",""]),i=o(["","/config/zeroaddress"],["","/config/zeroaddress"])
function o(e,t){return Object.freeze(Object.defineProperties(e,{raw:{value:Object.freeze(t)}}))}var u=t.default.attr,c=["name","keyType","defaultUser","adminUser","port","allowedUsers","cidrList","excludeCidrList"],d=["name","keyType","allowUserCertificates","allowHostCertificates","defaultUser","allowedUsers","allowedDomains","ttl","maxTtl","allowedCriticalOptions","defaultCriticalOptions","allowedExtensions","defaultExtensions","allowBareDomains","allowSubdomains","allowUserKeyIds","keyIdFormat"]
e.default=t.default.Model.extend({useOpenAPI:!0,getHelpUrl:function(e){return"/v1/"+e+"/roles/example?help=1"},zeroAddress:u("boolean",{readOnly:!0}),backend:u("string",{readOnly:!0}),name:u("string",{label:"Role Name",fieldValue:"id",readOnly:!0}),keyType:u("string",{possibleValues:["ca","otp"]}),adminUser:u("string",{helpText:"Username of the admin user at the remote host"}),defaultUser:u("string",{helpText:"Username to use when one isn't specified"}),allowedUsers:u("string",{helpText:"Create a whitelist of users that can use this key (e.g. `admin, dev`, or use `*` to allow all)"}),allowedDomains:u("string",{helpText:"List of domains for which a client can request a certificate (e.g. `example.com`, or `*` to allow all)"}),cidrList:u("string",{helpText:"List of CIDR blocks for which this role is applicable"}),excludeCidrList:u("string",{helpText:"List of CIDR blocks that are not accepted by this role"}),port:u("number",{helpText:"Port number for the SSH connection (default is `22`)"}),allowedCriticalOptions:u("string",{helpText:"List of critical options that certificates have when signed"}),defaultCriticalOptions:u("object",{helpText:"Map of critical options certificates should have if none are provided when signing"}),allowedExtensions:u("string",{helpText:"List of extensions that certificates can have when signed"}),defaultExtensions:u("object",{helpText:"Map of extensions certificates should have if none are provided when signing"}),allowUserCertificates:u("boolean",{helpText:"Specifies if certificates are allowed to be signed for us as a user"}),allowHostCertificates:u("boolean",{helpText:"Specifies if certificates are allowed to be signed for us as a host"}),allowBareDomains:u("boolean",{helpText:"Specifies if host certificates that are requested are allowed to use the base domains listed in Allowed Domains"}),allowSubdomains:u("boolean",{helpText:"Specifies if host certificates that are requested are allowed to be subdomains of those listed in Allowed Domains"}),allowUserKeyIds:u("boolean",{helpText:'Specifies if users can override the key ID for a signed certificate with the "key_id" field'}),keyIdFormat:u("string",{helpText:"When supplied, this value specifies a custom format for the key id of a signed certificate"}),attrsForKeyType:Ember.computed("keyType",function(){var e="ca"===this.get("keyType")?d.slice(0):c.slice(0)
return(0,a.expandAttributeMeta)(this,e)}),updatePath:(0,n.default)((0,n.apiPath)(s,"backend","id"),"backend","id"),canDelete:Ember.computed.alias("updatePath.canDelete"),canEdit:Ember.computed.alias("updatePath.canUpdate"),canRead:Ember.computed.alias("updatePath.canRead"),generatePath:(0,n.default)((0,n.apiPath)(r,"backend","id"),"backend","id"),canGenerate:Ember.computed.alias("generatePath.canUpdate"),signPath:(0,n.default)((0,n.apiPath)(l,"backend","id"),"backend","id"),canSign:Ember.computed.alias("signPath.canUpdate"),zeroAddressPath:(0,n.default)((0,n.apiPath)(i,"backend"),"backend"),canEditZeroAddress:Ember.computed.alias("zeroAddressPath.canUpdate")})})
define("vault/models/secret-engine",["exports","ember-data","ember-data-model-fragments/attributes","vault/utils/field-to-attrs"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s=t.default.attr,r=["system","identity"]
e.default=t.default.Model.extend({path:s("string"),accessor:s("string"),name:s("string"),type:s("string",{label:"Secret engine type"}),description:s("string",{editType:"textarea"}),config:(0,n.fragment)("mount-config",{defaultValue:{}}),options:(0,n.fragment)("mount-options",{defaultValue:{}}),local:s("boolean",{helpText:"When Replication is enabled, a local mount will not be replicated across clusters. This can only be specified at mount time."}),sealWrap:s("boolean",{helpText:"When enabled - if a seal supporting seal wrapping is specified in the configuration, all critical security parameters (CSPs) in this backend will be seal wrapped. (For K/V mounts, all values will be seal wrapped.) This can only be specified at mount time."}),modelTypeForKV:Ember.computed("engineType","options.version",function(){var e=this.get("engineType"),t=this.get("options.version"),n="secret"
return"kv"!==e&&"generic"!==e||2!==t||(n="secret-v2"),n}),isV2KV:Ember.computed("modelTypeForKV",function(){return"secret-v2"===this.modelTypeForKV}),formFields:Ember.computed("engineType",function(){var e=this.get("engineType"),t=["type","path","description","accessor","local","sealWrap","config.{defaultLeaseTtl,maxLeaseTtl,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders}"]
return"kv"!==e&&"generic"!==e||t.push("options.{version}"),t}),formFieldGroups:Ember.computed("engineType",function(){var e=this.get("engineType"),t={default:["path"]}
return"kv"!==e&&"generic"!==e||t.default.push("options.{version}"),[t,{"Method Options":["description","config.listingVisibility","local","sealWrap","config.{defaultLeaseTtl,maxLeaseTtl,auditNonHmacRequestKeys,auditNonHmacResponseKeys,passthroughRequestHeaders}"]}]}),attrs:Ember.computed("formFields",function(){return(0,a.expandAttributeMeta)(this,this.get("formFields"))}),fieldGroups:Ember.computed("formFieldGroups",function(){return(0,a.default)(this,this.get("formFieldGroups"))}),engineType:Ember.computed("type",function(){return(this.get("type")||"").replace(/^ns_/,"")}),shouldIncludeInList:Ember.computed("engineType",function(){return!r.includes(this.get("engineType"))}),localDisplay:Ember.computed("local",function(){return this.get("local")?"local":"replicated"}),privateKey:s("string"),publicKey:s("string"),generateSigningKey:s("boolean",{defaultValue:!0}),saveCA:function(e){if("ssh"===this.get("type"))return e.isDelete&&this.setProperties({privateKey:null,publicKey:null,generateSigningKey:!1}),this.save({adapterOptions:{options:e,apiPath:"config/ca",attrsToSend:["privateKey","publicKey","generateSigningKey"]}})},saveZeroAddressConfig:function(){return this.save({adapterOptions:{adapterMethod:"saveZeroAddressConfig"}})},lease:s("string"),leaseMax:s("string")})}),define("vault/models/secret-v2-version",["exports","vault/models/secret","ember-data"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=n.default.attr,s=n.default.belongsTo
e.default=t.default.extend({pathAttr:"path",version:a("number"),secret:s("secret-v2"),path:a("string"),deletionTime:a("string"),createdTime:a("string"),deleted:Ember.computed.bool("deletionTime"),destroyed:a("boolean"),currentVersion:a("number")})}),define("vault/models/secret-v2",["exports","ember-data","vault/utils/field-to-attrs","vault/mixins/key-mixin","vault/macros/lazy-capabilities"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0})
var r=i(["","/data/",""],["","/data/",""]),l=i(["","/metadata/",""],["","/metadata/",""])
function i(e,t){return Object.freeze(Object.defineProperties(e,{raw:{value:Object.freeze(t)}}))}var o=t.default.attr,u=t.default.hasMany,c=t.default.belongsTo,d=t.default.Model
e.default=d.extend(a.default,{engine:c("secret-engine",{async:!1}),engineId:o("string"),versions:u("secret-v2-version",{async:!1,inverse:null}),selectedVersion:c("secret-v2-version",{async:!1,inverse:"secret"}),createdTime:o(),updatedTime:o(),currentVersion:o("number"),oldestVersion:o("number"),maxVersions:o("number",{defaultValue:10,label:"Maximum Number of Versions"}),casRequired:o("boolean",{defaultValue:!1,label:"Require Check and Set",helpText:"Writes will only be allowed if the key’s current version matches the version specified in the cas parameter"}),fields:Ember.computed(function(){return(0,n.expandAttributeMeta)(this,["maxVersions","casRequired"])}),versionPath:(0,s.default)((0,s.apiPath)(r,"engineId","id"),"engineId","id"),secretPath:(0,s.default)((0,s.apiPath)(l,"engineId","id"),"engineId","id"),canEdit:Ember.computed.alias("versionPath.canUpdate"),canDelete:Ember.computed.alias("secretPath.canDelete"),canRead:Ember.computed.alias("secretPath.canRead")})}),define("vault/models/secret",["exports","ember-data","vault/mixins/key-mixin","vault/macros/lazy-capabilities"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s,r,l=(s=["","/",""],r=["","/",""],Object.freeze(Object.defineProperties(s,{raw:{value:Object.freeze(r)}})))
var i=t.default.attr
e.default=t.default.Model.extend(n.default,{auth:i("string"),lease_duration:i("number"),lease_id:i("string"),renewable:i("boolean"),secretData:i("object"),dataAsJSONString:Ember.computed("secretData",function(){return JSON.stringify(this.get("secretData"),null,2)}),isAdvancedFormat:Ember.computed("secretData",function(){var e=this.get("secretData")
return e&&Object.keys(e).some(function(t){return"string"!=typeof e[t]})}),helpText:i("string"),backend:i("string"),secretPath:(0,a.default)((0,a.apiPath)(l,"backend","id"),"backend","id"),canEdit:Ember.computed.alias("secretPath.canUpdate"),canDelete:Ember.computed.alias("secretPath.canDelete"),canRead:Ember.computed.alias("secretPath.canRead")})}),define("vault/models/ssh-otp-credential",["exports","ember-data","vault/utils/field-to-attrs"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=t.default.attr,s=["username","ip"],r=["username","ip","key","keyType","port"]
e.default=t.default.Model.extend({role:a("object",{readOnly:!0}),ip:a("string",{label:"IP Address"}),username:a("string"),key:a("string"),keyType:a("string"),port:a("number"),attrs:Ember.computed("key",function(){var e=this.get("key")?r.slice(0):s.slice(0)
return(0,n.expandAttributeMeta)(this,e)}),toCreds:Ember.computed("key",function(){return this.get("key")})})}),define("vault/models/ssh-sign",["exports","ember-data","vault/utils/field-to-attrs"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=t.default.attr,s=["publicKey","keyId","validPrincipals","certType","criticalOptions","extension","ttl"],r=["signedKey","leaseId","renewable","leaseDuration","serialNumber"]
e.default=t.default.Model.extend({role:a("object",{readOnly:!0}),publicKey:a("string",{label:"Public Key",editType:"textarea"}),ttl:a({label:"TTL",editType:"ttl"}),validPrincipals:a("string"),certType:a("string",{defaultValue:"user",label:"Certificate Type",possibleValues:["user","host"]}),keyId:a("string",{label:"Key ID"}),criticalOptions:a("object"),extension:a("object"),leaseId:a("string",{label:"Lease ID"}),renewable:a("boolean"),leaseDuration:a("number"),serialNumber:a("string"),signedKey:a("string"),attrs:Ember.computed("signedKey",function(){var e=this.get("signedKey")?r.slice(0):s.slice(0)
return(0,n.expandAttributeMeta)(this,e)})})}),define("vault/models/test-form-model",["exports","vault/models/auth-method","ember-data-model-fragments/attributes"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({otherConfig:(0,n.fragment)("mount-config",{defaultValue:{}})})}),define("vault/models/transit-key",["exports","ember-data","vault/utils/clamp","vault/macros/lazy-capabilities"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s,r,l=(s=["","/keys/","/rotate"],r=["","/keys/","/rotate"],Object.freeze(Object.defineProperties(s,{raw:{value:Object.freeze(r)}})))
var i=t.default.attr,o={encrypt:"supportsEncryption",decrypt:"supportsDecryption",datakey:"supportsEncryption",rewrap:"supportsEncryption",sign:"supportsSigning",hmac:!0,verify:!0,export:"exportable"}
e.default=t.default.Model.extend({type:i("string",{defaultValue:"aes256-gcm96"}),name:i("string"),deletionAllowed:i("boolean"),derived:i("boolean"),exportable:i("boolean"),minDecryptionVersion:i("number",{defaultValue:1}),minEncryptionVersion:i("number",{defaultValue:0}),latestVersion:i("number"),keys:i("object"),convergentEncryption:i("boolean"),convergentEncryptionVersion:i("number"),supportsSigning:i("boolean"),supportsEncryption:i("boolean"),supportsDecryption:i("boolean"),supportsDerivation:i("boolean"),setConvergentEncryption:function(e){!0===e&&Ember.set(this,"derived",e),Ember.set(this,"convergentEncryption",e)},setDerived:function(e){!1===e&&Ember.set(this,"convergentEncryption",e),Ember.set(this,"derived",e)},supportedActions:Ember.computed("type",function(){var e=this
return Object.keys(o).filter(function(t){var n=o[t]
return"boolean"==typeof n?n:Ember.get(e,n)})}),canDelete:Ember.computed("deletionAllowed","lastLoadTS",function(){var e=Boolean(this.changedAttributes().deletionAllowed)
return Ember.get(this,"deletionAllowed")&&!1===e}),keyVersions:Ember.computed("validKeyVersions",function(){for(var e=Math.max.apply(Math,function(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}(Ember.get(this,"validKeyVersions"))),t=[];e>0;)t.unshift(e),e--
return t}),encryptionKeyVersions:Ember.computed("keyVerisons","minDecryptionVersion","latestVersion",function(){var e=this.getProperties("keyVersions","minDecryptionVersion"),t=e.keyVersions,n=e.minDecryptionVersion
return t.filter(function(e){return e>=n}).reverse()}),keysForEncryption:Ember.computed("minEncryptionVersion","latestVersion",function(){for(var e=this.getProperties("minEncryptionVersion","latestVersion"),t=e.minEncryptionVersion,a=e.latestVersion,s=(0,n.default)(t-1,0,a),r=[];a>s;)r.push(a),a--
return r}),validKeyVersions:Ember.computed("keys",function(){return Object.keys(Ember.get(this,"keys"))}),exportKeyTypes:Ember.computed("exportable","type",function(){var e=["hmac"]
return this.get("supportsSigning")&&e.unshift("signing"),this.get("supportsEncryption")&&e.unshift("encryption"),e}),backend:i("string",{readOnly:!0}),rotatePath:(0,a.default)((0,a.apiPath)(l,"backend","id"),"backend","id"),canRotate:Ember.computed.alias("rotatePath.canUpdate")})}),define("vault/resolver",["exports","ember-resolver"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default}),define("vault/router",["exports","vault/config/environment"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=Ember.Router.extend({location:t.default.locationType,rootURL:t.default.rootURL})
n.map(function(){this.route("vault",{path:"/"},function(){this.route("cluster",{path:"/:cluster_name"},function(){this.route("oidc-callback",{path:"/auth/*auth_path/oidc/callback"}),this.route("auth"),this.route("init"),this.route("logout"),this.mount("open-api-explorer",{path:"/api-explorer"}),this.route("license"),this.route("requests",{path:"/metrics/requests"}),this.route("settings",function(){this.route("index",{path:"/"}),this.route("seal"),this.route("auth",function(){this.route("index",{path:"/"}),this.route("enable"),this.route("configure",{path:"/configure/:method"},function(){this.route("index",{path:"/"}),this.route("section",{path:"/:section_name"})})}),this.route("mount-secret-backend"),this.route("configure-secret-backend",{path:"/secrets/configure/:backend"},function(){this.route("index",{path:"/"}),this.route("section",{path:"/:section_name"})})}),this.route("unseal"),this.route("tools",function(){this.route("tool",{path:"/:selected_action"})}),this.route("access",function(){this.route("methods",{path:"/"}),this.route("method",{path:"/:path"},function(){this.route("index",{path:"/"}),this.route("item",{path:"/item/:item_type"},function(){this.route("list",{path:"/"}),this.route("create"),this.route("edit",{path:"/edit/:item_id"}),this.route("show",{path:"/show/:item_id"})}),this.route("section",{path:"/:section_name"})}),this.route("leases",function(){this.route("index",{path:"/"}),this.route("list-root",{path:"/list/"}),this.route("list",{path:"/list/*prefix"}),this.route("show",{path:"/show/*lease_id"})}),this.route("identity",{path:"/identity/:item_type"},function(){this.route("index",{path:"/"}),this.route("create"),this.route("merge"),this.route("edit",{path:"/edit/:item_id"}),this.route("show",{path:"/:item_id/:section"}),this.route("aliases",function(){this.route("index",{path:"/"}),this.route("add",{path:"/add/:item_id"}),this.route("edit",{path:"/edit/:item_alias_id"}),this.route("show",{path:"/:item_alias_id/:section"})})}),this.route("control-groups"),this.route("control-groups-configure",{path:"/control-groups/configure"}),this.route("control-group-accessor",{path:"/control-groups/:accessor"}),this.route("namespaces",function(){this.route("index",{path:"/"}),this.route("create")})}),this.route("secrets",function(){this.route("backends",{path:"/"}),this.route("backend",{path:"/:backend"},function(){this.mount("kmip"),this.route("index",{path:"/"}),this.route("configuration"),this.route("list-root",{path:"/list/"}),this.route("create-root",{path:"/create/"}),this.route("show-root",{path:"/show/"}),this.route("edit-root",{path:"/edit/"}),this.route("list",{path:"/list/*secret"}),this.route("show",{path:"/show/*secret"}),this.route("create",{path:"/create/*secret"}),this.route("edit",{path:"/edit/*secret"}),this.route("credentials-root",{path:"/credentials/"}),this.route("credentials",{path:"/credentials/*secret"}),this.route("versions-root",{path:"/versions/"}),this.route("versions",{path:"/versions/*secret"}),this.route("sign-root",{path:"/sign/"}),this.route("sign",{path:"/sign/*secret"}),this.route("actions-root",{path:"/actions/"}),this.route("actions",{path:"/actions/*secret"})})}),this.route("policies",{path:"/policies/:type"},function(){this.route("index",{path:"/"}),this.route("create",{path:"/create"})}),this.route("policy",{path:"/policy/:type"},function(){this.route("show",{path:"/:policy_name"}),this.route("edit",{path:"/:policy_name/edit"})}),this.route("replication-dr-promote"),t.default.addRootMounts&&t.default.addRootMounts.call(this),this.route("not-found",{path:"/*path"})}),this.route("not-found",{path:"/*path"})})}),e.default=n}),define("vault/routes/application",["exports","vault/lib/control-group-error"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({controlGroup:Ember.inject.service(),routing:Ember.inject.service("router"),wizard:Ember.inject.service(),namespaceService:Ember.inject.service("namespace"),actions:{willTransition:function(){window.scrollTo(0,0)},error:function(e,n){var a=this.get("controlGroup")
if(e instanceof t.default)return a.handleError(e,n)
"/v1/sys/wrapping/unwrap"===e.path&&a.unmarkTokenForUnwrap()
var s=this.get("routing"),r=n.intent.url,l=n.intent,i=l.name,o=l.contexts,u=l.queryParams
if(!r)try{r=s.urlFor.apply(s,[i].concat(function(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}(o||[]),[{queryParams:u}]))}catch(e){r=null}return r&&(r=r.replace("/ui","")),e.errorURL=r,u&&this.controllerFor("vault.cluster").set("namespaceQueryParam",u.namespace||""),r&&s.get("location").setURL(r),!0},didTransition:function(){var e=this,t=this.get("wizard")
return"active.feature"!==t.get("currentState")||(Ember.run.next(function(){var n=e.get("routing.currentURL"),a=e.get("routing.currentRouteName")
e.get("wizard.setURLAfterTransition")&&(e.set("wizard.setURLAfterTransition",!1),e.set("wizard.expectedURL",n),e.set("wizard.expectedRouteName",a))
var s=e.get("wizard.expectedRouteName")
!1===e.get("routing").isActive(s)&&t.transitionTutorialMachine(t.get("currentState"),"PAUSE")}),!0)}}})}),define("vault/routes/loading",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({renderTemplate:function(){var e=this._router.currentState.routerJs.activeTransition.targetName
"vault.cluster.oidc-callback"===e||"vault.cluster.oidc-callback-namespace"===e?this.render("vault/cluster/oidc-callback",{into:"application",outlet:"main"}):this._super.apply(this,arguments)}})}),define("vault/routes/vault",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t=Ember.testing?0:300
e.default=Ember.Route.extend({version:Ember.inject.service(),beforeModel:function(){return this.get("version").fetchVersion()},model:function(){var e=this
return this.store.push({data:{id:"1",type:"cluster",attributes:{name:"vault"}}}),new Ember.RSVP.Promise(function(n){Ember.run.later(function(){n(e.store.peekAll("cluster"))},t)})},redirect:function(e,t){if(1===e.get("length")&&"vault.index"===t.targetName)return this.transitionTo("vault.cluster",e.get("firstObject.name"))}})}),define("vault/routes/vault/cluster",["exports","ember-concurrency","vault/mixins/cluster-route","vault/mixins/model-boundary-route"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
e.default=Ember.Route.extend(a.default,n.default,{namespaceService:Ember.inject.service("namespace"),version:Ember.inject.service(),permissions:Ember.inject.service(),store:Ember.inject.service(),auth:Ember.inject.service(),currentCluster:Ember.inject.service(),modelTypes:Ember.computed(function(){return["node","secret","secret-engine"]}),globalNamespaceModels:Ember.computed(function(){return["node","cluster"]}),queryParams:{namespaceQueryParam:{refreshModel:!0}},getClusterId:function(e){var t=e.cluster_name,n=this.modelFor("vault").findBy("name",t)
return n?n.get("id"):null},clearNonGlobalModels:function(){var e=this.store,t=this.get("globalNamespaceModels"),n=!0,a=!1,s=void 0
try{for(var r,l=Ember.getOwner(this).lookup("data-adapter:main").getModelTypes()[Symbol.iterator]();!(n=(r=l.next()).done);n=!0){var i=r.value.name
if(t.includes(i))return
e.unloadAll(i)}}catch(e){a=!0,s=e}finally{try{!n&&l.return&&l.return()}finally{if(a)throw s}}},beforeModel:function(){var e,t=(e=regeneratorRuntime.mark(function e(){var t,n
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(t=this.paramsFor(this.routeName),this.clearNonGlobalModels(),this.get("namespaceService").setNamespace(t.namespaceQueryParam),!(n=this.getClusterId(t))){e.next=11
break}return this.get("auth").setCluster(n),e.next=8,this.get("permissions").getPaths.perform()
case 8:return e.abrupt("return",this.get("version").fetchFeatures())
case 11:return e.abrupt("return",Ember.RSVP.reject({httpStatus:404,message:"not found",path:t.cluster_name}))
case 12:case"end":return e.stop()}},e,this)}),function(){var t=e.apply(this,arguments)
return new Promise(function(e,n){return function a(s,r){try{var l=t[s](r),i=l.value}catch(e){return void n(e)}if(!l.done)return Promise.resolve(i).then(function(e){a("next",e)},function(e){a("throw",e)})
e(i)}("next")})})
return function(){return t.apply(this,arguments)}}(),model:function(e){var t=this.getClusterId(e)
return this.get("store").findRecord("cluster",t)},poll:(0,t.task)(regeneratorRuntime.mark(function e(){return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(!Ember.testing){e.next=3
break}return e.abrupt("return")
case 3:return e.next=5,(0,t.timeout)(1e4)
case 5:return e.prev=5,e.next=8,this.controller.model.reload()
case 8:return e.next=10,this.transitionToTargetRoute()
case 10:e.next=14
break
case 12:e.prev=12,e.t0=e.catch(5)
case 14:e.next=0
break
case 16:case"end":return e.stop()}},e,this,[[5,12]])})).cancelOn("deactivate").keepLatest(),afterModel:function(e,t){return this._super.apply(this,arguments),this.get("currentCluster").setCluster(e),this.get("namespaceService.path")&&!this.get("version.hasNamespaces")?this.transitionTo(this.routeName,{queryParams:{namespace:""}}):this.transitionToTargetRoute(t)},setupController:function(){this._super.apply(this,arguments),this.poll.perform()},actions:{error:function(e){return 503===e.httpStatus&&"Vault is sealed"===e.errors[0]&&this.refresh(),!0}}})}),define("vault/routes/vault/cluster/access",["exports","vault/mixins/cluster-route","vault/mixins/model-boundary-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(n.default,t.default,{modelTypes:Ember.computed(function(){return["capabilities","control-group","identity/group","identity/group-alias","identity/alias"]}),model:function(){return{}}})}),define("vault/routes/vault/cluster/access/control-group-accessor",["exports","vault/mixins/unload-model-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{version:Ember.inject.service(),beforeModel:function(){var e=this,t=arguments
return this.get("version").fetchFeatures().then(function(){return e._super.apply(e,t)})},model:function(e){return this.get("version").hasFeature("Control Groups")?this.store.findRecord("control-group",e.accessor):null},actions:{willTransition:function(){return!0},deactivate:function(){return this.unloadModel(),!0}}})}),define("vault/routes/vault/cluster/access/control-groups-configure",["exports","vault/mixins/unload-model-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{version:Ember.inject.service(),beforeModel:function(){var e=this,t=arguments
return this.get("version").fetchFeatures().then(function(){return e._super.apply(e,t)})},model:function(){var e=this,t="control-group-config"
return this.get("version").hasFeature("Control Groups")?this.store.findRecord(t,"config").catch(function(n){if(404===n.httpStatus)return e.store.createRecord(t,{id:"config"})
throw n}):null},actions:{reload:function(){this.refresh()}}})}),define("vault/routes/vault/cluster/access/control-groups",["exports","vault/mixins/unload-model-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{version:Ember.inject.service(),beforeModel:function(){var e=this,t=arguments
return this.get("version").fetchFeatures().then(function(){return e._super.apply(e,t)})},model:function(){return this.get("version").hasFeature("Control Groups")?this.store.createRecord("control-group"):null}})}),define("vault/routes/vault/cluster/access/identity",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n={entities:"entity",groups:"group"}
e.default=Ember.Route.extend({model:function(e){var a=n[e.item_type]
if(!a){var s=new t.default.AdapterError
throw Ember.set(s,"httpStatus",404),s}return a}})}),define("vault/routes/vault/cluster/access/identity/aliases/add",["exports","vault/mixins/unload-model-route","vault/mixins/unsaved-model-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,n.default,{model:function(e){var t="identity/"+this.modelFor("vault.cluster.access.identity")+"-alias"
return this.store.createRecord(t,{canonicalId:e.item_id})}})}),define("vault/routes/vault/cluster/access/identity/aliases/edit",["exports","vault/mixins/unload-model-route","vault/mixins/unsaved-model-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,n.default,{model:function(e){var t="identity/"+this.modelFor("vault.cluster.access.identity")+"-alias"
return this.store.findRecord(t,e.item_alias_id)}})}),define("vault/routes/vault/cluster/access/identity/aliases/index",["exports","core/mixins/list-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{model:function(e){var t="identity/"+this.modelFor("vault.cluster.access.identity")+"-alias"
return this.store.lazyPaginatedQuery(t,{responsePath:"data.keys",page:e.page,pageFilter:e.pageFilter}).catch(function(e){if(404===e.httpStatus)return[]
throw e})},setupController:function(e){this._super.apply(this,arguments),e.set("identityType",this.modelFor("vault.cluster.access.identity"))},actions:{willTransition:function(e){return window.scrollTo(0,0),e&&e.targetName===this.routeName||this.store.clearAllDatasets(),!0},reload:function(){this.store.clearAllDatasets(),this.refresh()}}})}),define("vault/routes/vault/cluster/access/identity/aliases/show",["exports","ember-data","vault/helpers/tabs-for-identity-show"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({model:function(e){var a=e.section,s=this.modelFor("vault.cluster.access.identity")+"-alias",r="identity/"+s
if(!n.TABS[s].includes(a)){var l=new t.default.AdapterError
throw Ember.set(l,"httpStatus",404),l}return Ember.RSVP.hash({model:this.store.findRecord(r,e.item_alias_id),section:a})},setupController:function(e,t){var n=t.model,a=t.section
e.setProperties({model:n,section:a})}})}),define("vault/routes/vault/cluster/access/identity/create",["exports","vault/mixins/unload-model-route","vault/mixins/unsaved-model-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,n.default,{model:function(){var e="identity/"+this.modelFor("vault.cluster.access.identity")
return this.store.createRecord(e)}})}),define("vault/routes/vault/cluster/access/identity/edit",["exports","vault/mixins/unload-model-route","vault/mixins/unsaved-model-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,n.default,{model:function(e){var t="identity/"+this.modelFor("vault.cluster.access.identity")
return this.store.findRecord(t,e.item_id)}})}),define("vault/routes/vault/cluster/access/identity/index",["exports","core/mixins/list-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{model:function(e){var t="identity/"+this.modelFor("vault.cluster.access.identity")
return this.store.lazyPaginatedQuery(t,{responsePath:"data.keys",page:e.page,pageFilter:e.pageFilter}).catch(function(e){if(404===e.httpStatus)return[]
throw e})},setupController:function(e){this._super.apply(this,arguments),e.set("identityType",this.modelFor("vault.cluster.access.identity"))},actions:{willTransition:function(e){return window.scrollTo(0,0),e.targetName!==this.routeName&&this.store.clearAllDatasets(),!0},reload:function(){this.store.clearAllDatasets(),this.refresh()}}})}),define("vault/routes/vault/cluster/access/identity/merge",["exports","vault/mixins/unload-model-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{beforeModel:function(){if("entity"!==this.modelFor("vault.cluster.access.identity"))return this.transitionTo("vault.cluster.access.identity")},model:function(){return this.store.createRecord("identity/entity-merge")}})}),define("vault/routes/vault/cluster/access/identity/show",["exports","ember-data","vault/helpers/tabs-for-identity-show"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({model:function(e){var a=e.section,s=this.modelFor("vault.cluster.access.identity"),r="identity/"+s
if(!n.TABS[s].includes(a)){var l=new t.default.AdapterError
throw Ember.set(l,"httpStatus",404),l}var i=this.store.peekRecord(r,e.item_id)
return i&&!i.get("creationTime")&&(i=i.reload()),i||(i=this.store.findRecord(r,e.item_id)),Ember.RSVP.hash({model:i,section:a})},activate:function(){var e=this
this.currentModel&&Ember.run.next(function(){e.controller.get("model").reload()})},afterModel:function(e){var t=e.section,n=e.model
if("group"===n.get("identityType")&&"internal"===n.get("type")&&"aliases"===t)return this.transitionTo("vault.cluster.access.identity.show",n.id,"details")},setupController:function(e,t){var n=t.model,a=t.section
e.setProperties({model:n,section:a})}})}),define("vault/routes/vault/cluster/access/leases",["exports","vault/mixins/cluster-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{model:function(){return this.store.findRecord("capabilities","sys/leases/lookup/")}})}),define("vault/routes/vault/cluster/access/leases/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({beforeModel:function(e){return this.modelFor("vault.cluster.access.leases").get("canList")&&e.targetName===this.routeName?this.replaceWith("vault.cluster.access.leases.list-root"):void 0}})})
define("vault/routes/vault/cluster/access/leases/list-root",["exports","vault/routes/vault/cluster/access/leases/list"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/routes/vault/cluster/access/leases/list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({queryParams:{page:{refreshModel:!0},pageFilter:{refreshModel:!0}},templateName:"vault/cluster/access/leases/list",model:function(e){var t=this,n=e.prefix||""
if(this.modelFor("vault.cluster.access.leases").get("canList"))return Ember.RSVP.hash({leases:this.store.lazyPaginatedQuery("lease",{prefix:n,responsePath:"data.keys",page:e.page,pageFilter:e.pageFilter}).then(function(e){return t.set("has404",!1),e}).catch(function(e){if(404===e.httpStatus&&""===n)return[]
throw e}),capabilities:Ember.RSVP.hash({revokePrefix:this.store.findRecord("capabilities","sys/leases/revoke-prefix/"+n),forceRevokePrefix:this.store.findRecord("capabilities","sys/leases/revoke-force/"+n)})})},setupController:function(e,t){var n=this.paramsFor(this.routeName),a=n.prefix?n.prefix:"",s=this.get("has404")
if(e.set("hasModel",!0),e.setProperties({model:t.leases,capabilities:t.capabilities,baseKey:{id:a},has404:s}),!s){var r=n.pageFilter,l=void 0
a?l=a+(r||""):r&&(l=r),e.setProperties({filter:l||"",page:t.leases.get("meta.currentPage")})}},resetController:function(e,t){this._super.apply(this,arguments),t&&e.set("filter","")},actions:{error:function(e,t){var n=this.paramsFor(this.routeName).prefix
if(Ember.set(e,"keyId",n),!this.controllerFor(this.routeName).get("hasModel")||404!==e.httpStatus)return!0
this.set("has404",!0),t.abort()},willTransition:function(e){return window.scrollTo(0,0),e.targetName!==this.routeName&&this.store.clearAllDatasets(),!0}}})}),define("vault/routes/vault/cluster/access/leases/show",["exports","vault/mixins/unload-model-route","vault/lib/key-utils"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{beforeModel:function(){var e=this.paramsFor(this.routeName).lease_id,t=n.default.parentKeyForKey(e)
if(n.default.keyIsFolder(e))return t?this.transitionTo("vault.cluster.access.leases.list",t):this.transitionTo("vault.cluster.access.leases.list-root")},model:function(e){var t=e.lease_id
return Ember.RSVP.hash({lease:this.store.queryRecord("lease",{lease_id:t}),capabilities:Ember.RSVP.hash({renew:this.store.findRecord("capabilities","sys/leases/renew"),revoke:this.store.findRecord("capabilities","sys/leases/revoke"),leases:this.modelFor("vault.cluster.access.leases")})})},setupController:function(e,t){this._super.apply(this,arguments)
var n=this.paramsFor(this.routeName).lease_id
e.setProperties({model:t.lease,capabilities:t.capabilities,baseKey:{id:n}})},actions:{error:function(e){var t=this.paramsFor(this.routeName).lease_id
return Ember.set(e,"keyId",t),!0},refreshModel:function(){this.refresh()}}})}),define("vault/routes/vault/cluster/access/method",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({pathHelp:Ember.inject.service("path-help"),model:function(e){var n=this,a=e.path
return this.store.findAll("auth-method").then(function(e){var s=e.findBy("id",a)
if(!s){var r=new t.default.AdapterError
throw Ember.set(r,"httpStatus",404),r}return n.pathHelp.getPaths(s.apiPath,a).then(function(e){return s.set("paths",e),s})})}})}),define("vault/routes/vault/cluster/access/method/index",["exports","vault/helpers/tabs-for-auth-section"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({beforeModel:function(){var e=this.modelFor("vault.cluster.access.method"),n=e.methodType,a=e.paths
a=a?a.navPaths.reduce(function(e,t){return e.concat(t.path)},[]):null
var s=(0,t.tabsForAuthSection)([n,"authConfig",a])[0].routeParams
return this.transitionTo.apply(this,function(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}(s))}})}),define("vault/routes/vault/cluster/access/method/item",["exports","ember-inflector"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({wizard:Ember.inject.service(),pathHelp:Ember.inject.service("path-help"),beforeModel:function(){var e=this.getMethodAndModelInfo(),n=e.apiPath,a=e.type,s=e.method,r=e.itemType,l="generated-"+(0,t.singularize)(r)+"-"+a
return this.pathHelp.getNewModel(l,s,n,r)},getMethodAndModelInfo:function(){var e=this.paramsFor(this.routeName).item_type,t=this.paramsFor("vault.cluster.access.method").path,n=this.modelFor("vault.cluster.access.method")
return{apiPath:n.apiPath,type:n.type,method:t,itemType:e}},setupController:function(e){this._super.apply(this,arguments)
var t=this.getMethodAndModelInfo(),n=t.apiPath,a=t.method,s=t.itemType
e.set("itemType",s),e.set("method",a),this.pathHelp.getPaths(n,a,s).then(function(t){e.set("paths",Array.from(t.list,function(e){return e.path}))})}})}),define("vault/routes/vault/cluster/access/method/item/create",["exports","vault/mixins/unload-model-route","vault/mixins/unsaved-model-route","ember-inflector"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,n.default,{model:function(){var e=this.paramsFor("vault.cluster.access.method.item").item_type,t=this.modelFor("vault.cluster.access.method").type,n=this.paramsFor("vault.cluster.access.method").path,s="generated-"+(0,a.singularize)(e)+"-"+t
return this.store.createRecord(s,{itemType:e,method:n,adapterOptions:{path:n+"/"+e}})},setupController:function(e){this._super.apply(this,arguments)
var t=this.paramsFor("vault.cluster.access.method.item").item_type,n=this.paramsFor("vault.cluster.access.method").path
e.set("itemType",(0,a.singularize)(t)),e.set("mode","create"),e.set("method",n)}})}),define("vault/routes/vault/cluster/access/method/item/edit",["exports","vault/mixins/unload-model-route","vault/mixins/unsaved-model-route","ember-inflector"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,n.default,{model:function(e){var t=this.modelFor("vault.cluster.access.method").type,n=this.paramsFor("vault.cluster.access.method.item").item_type,s="generated-"+(0,a.singularize)(n)+"-"+t
return this.store.findRecord(s,e.item_id)},setupController:function(e){this._super.apply(this,arguments)
var t=this.paramsFor("vault.cluster.access.method.item").item_type,n=this.paramsFor("vault.cluster.access.method").path,s=this.paramsFor(this.routeName).item_id
e.set("itemType",(0,a.singularize)(t)),e.set("mode","edit"),e.set("method",n),e.set("itemName",s)}})}),define("vault/routes/vault/cluster/access/method/item/list",["exports","ember-inflector","vault/mixins/list-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(n.default,{wizard:Ember.inject.service(),pathHelp:Ember.inject.service("path-help"),getMethodAndModelInfo:function(){var e=this.paramsFor("vault.cluster.access.method.item").item_type,t=this.paramsFor("vault.cluster.access.method").path,n=this.modelFor("vault.cluster.access.method")
return{apiPath:n.apiPath,type:n.type,method:t,itemType:e}},model:function(){var e=this.getMethodAndModelInfo(),n=e.type,a=e.method,s=e.itemType,r=this.paramsFor(this.routeName),l=r.page,i=r.pageFilter,o="generated-"+(0,t.singularize)(s)+"-"+n
return this.store.lazyPaginatedQuery(o,{responsePath:"data.keys",page:l,pageFilter:i,type:s,method:a}).catch(function(e){if(404===e.httpStatus)return[]
throw e})},actions:{willTransition:function(e){return window.scrollTo(0,0),e.targetName!==this.routeName&&this.store.clearAllDatasets(),!0},reload:function(){this.store.clearAllDatasets(),this.refresh()}},setupController:function(e){this._super.apply(this,arguments)
var t=this.getMethodAndModelInfo(),n=t.apiPath,a=t.method,s=t.itemType
e.set("itemType",s),e.set("method",a),this.pathHelp.getPaths(n,a,s).then(function(t){e.set("paths",t.navPaths.reduce(function(e,t){return e.concat(t.path)},[]))})}})}),define("vault/routes/vault/cluster/access/method/item/show",["exports","ember-inflector"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({pathHelp:Ember.inject.service("path-help"),model:function(){var e=this.paramsFor(this.routeName).item_id,n=this.paramsFor("vault.cluster.access.method.item").item_type,a=this.paramsFor("vault.cluster.access.method").path,s=this.modelFor("vault.cluster.access.method").type,r="generated-"+(0,t.singularize)(n)+"-"+s
return this.store.findRecord(r,e,{adapterOptions:{path:a+"/"+n}})},setupController:function(e){this._super.apply(this,arguments)
var n=this.paramsFor("vault.cluster.access.method.item").item_type
e.set("itemType",(0,t.singularize)(n))}})}),define("vault/routes/vault/cluster/access/method/section",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({wizard:Ember.inject.service(),model:function(e){if("configuration"!==e.section_name){var n=new t.default.AdapterError
throw Ember.set(n,"httpStatus",404),n}var a=this.modelFor("vault.cluster.access.method")
return this.wizard.transitionFeatureMachine(this.wizard.featureState,"DETAILS",a.type),a},setupController:function(e){var t=this.paramsFor(this.routeName).section_name
this._super.apply(this,arguments),e.set("section",t)
var n=this.modelFor("vault.cluster.access.method").paths.navPaths.map(function(e){return e.path})
e.set("paths",n)}})}),define("vault/routes/vault/cluster/access/methods",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({queryParams:{page:{refreshModel:!0},pageFilter:{refreshModel:!0}},model:function(){return this.store.findAll("auth-method")}})}),define("vault/routes/vault/cluster/access/namespaces/create",["exports","vault/mixins/unload-model-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{version:Ember.inject.service(),beforeModel:function(){var e=this,t=arguments
return this.get("version").fetchFeatures().then(function(){return e._super.apply(e,t)})},model:function(){return this.get("version.hasNamespaces")?this.store.createRecord("namespace"):null}})}),define("vault/routes/vault/cluster/access/namespaces/index",["exports","vault/mixins/unload-model-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{version:Ember.inject.service(),beforeModel:function(){var e=this,t=arguments
return this.store.unloadAll("namespace"),this.get("version").fetchFeatures().then(function(){return e._super.apply(e,t)})},model:function(){return this.get("version.hasNamespaces")?this.store.findAll("namespace").catch(function(e){if(404===e.httpStatus)return[]
throw e}):null}})}),define("vault/routes/vault/cluster/auth",["exports","vault/routes/vault/cluster/cluster-route-base","vault/config/environment"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({queryParams:{authMethod:{replace:!0}},flashMessages:Ember.inject.service(),version:Ember.inject.service(),wizard:Ember.inject.service(),beforeModel:function(){var e=this
return this._super().then(function(){return e.get("version").fetchFeatures()})},model:function(){return this._super.apply(this,arguments)},resetController:function(e){e.set("wrappedToken",""),e.set("authMethod","")},afterModel:function(){n.default.welcomeMessage&&this.get("flashMessages").stickyInfo(n.default.welcomeMessage)},activate:function(){this.get("wizard").set("initEvent","LOGIN"),this.get("wizard").transitionTutorialMachine(this.get("wizard.currentState"),"TOLOGIN")},actions:{willTransition:function(e){e.targetName!==this.routeName&&this.get("wizard").transitionTutorialMachine(this.get("wizard.currentState"),"INITDONE")}}})}),define("vault/routes/vault/cluster/cluster-route-base",["exports","vault/mixins/cluster-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{model:function(){return this.modelFor("vault.cluster")},resetController:function(e){e.reset&&e.reset()}})}),define("vault/routes/vault/cluster/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({beforeModel:function(){return this.transitionTo("vault.cluster.secrets")}})}),define("vault/routes/vault/cluster/init",["exports","vault/routes/vault/cluster/cluster-route-base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({wizard:Ember.inject.service(),activate:function(){this.get("wizard").transitionTutorialMachine("idle","INIT"),this.get("wizard").set("initEvent","START")}})}),define("vault/routes/vault/cluster/license",["exports","vault/mixins/cluster-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{version:Ember.inject.service(),beforeModel:function(){this.version.isOSS&&this.transitionTo("vault.cluster")},model:function(){return this.store.queryRecord("license",{})},actions:{doRefresh:function(){this.refresh()}}})}),define("vault/routes/vault/cluster/logout",["exports","vault/mixins/model-boundary-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{auth:Ember.inject.service(),controlGroup:Ember.inject.service(),flashMessages:Ember.inject.service(),console:Ember.inject.service(),permissions:Ember.inject.service(),namespaceService:Ember.inject.service("namespace"),modelTypes:Ember.computed(function(){return["secret","secret-engine"]}),beforeModel:function(){this.auth.deleteCurrentToken(),this.controlGroup.deleteTokens(),this.namespaceService.reset(),this.console.set("isOpen",!1),this.console.clearLog(!0),this.flashMessages.clearMessages(),this.permissions.reset(),this.replaceWith("vault.cluster.auth",{queryParams:{redirect_to:""}})}})}),define("vault/routes/vault/cluster/oidc-callback",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({templateName:"vault/cluster/oidc-callback",model:function(){},afterModel:function(){var e=this.paramsFor(this.routeName),t=e.auth_path,n=e.code,a=e.state,s={namespace:this.paramsFor("vault.cluster").namespaceQueryParam,path:t=window.decodeURIComponent(t),code:n,state:a}
window.localStorage.setItem("oidcState",JSON.stringify(s))},renderTemplate:function(){this.render(this.templateName,{into:"application",outlet:"main"})}})}),define("vault/routes/vault/cluster/policies",["exports","vault/mixins/cluster-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=["acl","egp","rgp"]
e.default=Ember.Route.extend(t.default,{version:Ember.inject.service(),beforeModel:function(){var e=this,t=arguments
return this.get("version").fetchFeatures().then(function(){return e._super.apply(e,t)})},model:function(e){var t=e.type
return n.includes(t)?{}:this.transitionTo(this.routeName,n[0])}})}),define("vault/routes/vault/cluster/policies/create",["exports","vault/mixins/unload-model-route","vault/mixins/unsaved-model-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,n.default,{version:Ember.inject.service(),wizard:Ember.inject.service(),model:function(){var e=this.policyType()
return"acl"===e&&"policies"===this.get("wizard.currentMachine")&&"idle"===this.get("wizard.featureState")&&this.get("wizard").transitionFeatureMachine(this.get("wizard.featureState"),"CONTINUE"),this.get("version.hasSentinel")||"acl"===e?this.store.createRecord("policy/"+e,{}):this.transitionTo("vault.cluster.policies",e)},setupController:function(e){this._super.apply(this,arguments),e.set("policyType",this.policyType())},policyType:function(){return this.paramsFor("vault.cluster.policies").type}})}),define("vault/routes/vault/cluster/policies/index",["exports","vault/mixins/cluster-route","core/mixins/list-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,n.default,{version:Ember.inject.service(),wizard:Ember.inject.service(),activate:function(){"details"===this.get("wizard.featureState")&&this.get("wizard").transitionFeatureMachine("details","CONTINUE",this.policyType())},shouldReturnEmptyModel:function(e,t){return"acl"!==e&&(t.get("isOSS")||!t.get("hasSentinel"))},model:function(e){var t=this,n=this.policyType()
if(!this.shouldReturnEmptyModel(n,this.get("version")))return this.store.lazyPaginatedQuery("policy/"+n,{page:e.page,pageFilter:e.pageFilter,responsePath:"data.keys"}).catch(function(e){if(404===e.httpStatus&&"acl"!==t.policyType())return[]
throw e})},setupController:function(e,t){var n=this.paramsFor(this.routeName)
t?e.setProperties({model:t,filter:n.pageFilter||"",page:t.get("meta.currentPage")||1,policyType:this.policyType()}):e.setProperties({model:null,policyType:this.policyType()})},resetController:function(e,t){this._super.apply(this,arguments),t&&e.set("filter","")},actions:{willTransition:function(e){return window.scrollTo(0,0),e&&e.targetName===this.routeName||this.store.clearAllDatasets(),!0},reload:function(){this.store.clearAllDatasets(),this.refresh()}},policyType:function(){return this.paramsFor("vault.cluster.policies").type}})}),define("vault/routes/vault/cluster/policy",["exports","vault/mixins/cluster-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=["acl","egp","rgp"]
e.default=Ember.Route.extend(t.default,{version:Ember.inject.service(),beforeModel:function(){var e=this,t=arguments
return this.get("version").fetchFeatures().then(function(){return e._super.apply(e,t)})},model:function(e){var t=e.type
return n.includes(t)?this.get("version.hasSentinel")||"acl"===t?{}:this.transitionTo("vault.cluster.policies",t):this.transitionTo("vault.cluster.policies",n[0])}})}),define("vault/routes/vault/cluster/policy/edit",["exports","vault/mixins/unsaved-model-route","vault/routes/vault/cluster/policy/show"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=n.default.extend(t.default)}),define("vault/routes/vault/cluster/policy/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({beforeModel:function(){return this.transitionTo("vault.cluster.policies","acl")}})}),define("vault/routes/vault/cluster/policy/show",["exports","vault/mixins/unload-model-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{beforeModel:function(){var e=this.paramsFor(this.routeName)
if("acl"===this.policyType()&&"root"===e.policy_name)return this.transitionTo("vault.cluster.policies","acl")},model:function(e){var t=this.policyType()
return Ember.RSVP.hash({policy:this.store.findRecord("policy/"+t,e.policy_name),capabilities:this.store.findRecord("capabilities","sys/policies/"+t+"/"+e.policy_name)})},setupController:function(e,t){e.setProperties({model:t.policy,capabilities:t.capabilities,policyType:this.policyType()})},policyType:function(){return this.paramsFor("vault.cluster.policy").type}})}),define("vault/routes/vault/cluster/replication-dr-promote",["exports","vault/routes/vault/cluster/cluster-route-base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({replicationMode:Ember.inject.service(),beforeModel:function(){this._super.apply(this,arguments),this.get("replicationMode").setMode("dr")}})}),define("vault/routes/vault/cluster/requests",["exports","vault/routes/vault/cluster/cluster-route-base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({model:function(){return this.store.queryRecord("requests",{})}})})
define("vault/routes/vault/cluster/secrets",["exports","vault/mixins/cluster-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default)}),define("vault/routes/vault/cluster/secrets/backend",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({flashMessages:Ember.inject.service(),secretMountPath:Ember.inject.service(),oldModel:null,model:function(e){var t=e.backend
return this.secretMountPath.update(t),this.store.query("secret-engine",{path:t}).then(function(e){if(e)return e.get("firstObject")})},afterModel:function(e,t){var n=e&&e.get("path")
if(t.targetName===this.routeName)return this.replaceWith("vault.cluster.secrets.backend.list-root",n)}})}),define("vault/routes/vault/cluster/secrets/backend/actions",["exports","vault/routes/vault/cluster/secrets/backend/secret-edit","vault/lib/key-utils"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({queryParams:{selectedAction:{replace:!0}},templateName:"vault/cluster/secrets/backend/transitActionsLayout",beforeModel:function(){var e=this.paramsFor(this.routeName).secret,t=n.default.parentKeyForKey(e),a=this.paramsFor("vault.cluster.secrets.backend").backend
if("transit"!==this.backendType(a))return t?this.transitionTo("vault.cluster.secrets.backend.show",t):this.transitionTo("vault.cluster.secrets.backend.show-root")},setupController:function(e,t){this._super.apply(this,arguments)
var n=this.paramsFor(this.routeName).selectedAction
e.set("selectedAction",n||t.secret.get("supportedActions.firstObject"))}})}),define("vault/routes/vault/cluster/secrets/backend/configuration",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({wizard:Ember.inject.service(),model:function(){var e=this.modelFor("vault.cluster.secrets.backend")
return"list"===this.get("wizard.featureState")&&this.get("wizard").transitionFeatureMachine(this.get("wizard.featureState"),"CONTINUE",e.get("type")),e}})}),define("vault/routes/vault/cluster/secrets/backend/create-root",["exports","vault/routes/vault/cluster/secrets/backend/secret-edit"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
e.default=t.default.extend({wizard:Ember.inject.service(),createModel:function(e){var t=this.paramsFor("vault.cluster.secrets.backend").backend,n=this.modelType(t)
return"role-ssh"===n?this.store.createRecord(n,{keyType:"ca"}):"secret"!==n&&"secret-v2"!==n?("details"===this.get("wizard.featureState")&&"transit"===this.get("wizard.componentState")&&this.get("wizard").transitionFeatureMachine("details","CONTINUE","transit"),this.store.createRecord(n)):function(e,t,n){var a=e.peekRecord("secret-engine",t),s=a.get("modelTypeForKV")
if("secret-v2"!==s){var r=e.createRecord(s)
return r.set("id",n),r}var l=e.createRecord(s)
l.set("engine",a)
var i=e.createRecord("secret-v2-version",{path:n})
return l.set("selectedVersion",i),l}(this.store,t,e.queryParams.initialKey)},model:function(e,t){return Ember.RSVP.hash({secret:this.createModel(t),capabilities:{}})}})}),define("vault/routes/vault/cluster/secrets/backend/create",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({beforeModel:function(){var e=this.paramsFor(this.routeName),t=e.secret,n=e.initialKey||t
return this.transitionTo("vault.cluster.secrets.backend.create-root",{queryParams:{initialKey:n}})}})}),define("vault/routes/vault/cluster/secrets/backend/credentials-root",["exports","vault/routes/vault/cluster/secrets/backend/credentials"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/routes/vault/cluster/secrets/backend/credentials",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0})
var t=["ssh","aws","pki"]
e.default=Ember.Route.extend({templateName:"vault/cluster/secrets/backend/credentials",pathHelp:Ember.inject.service("path-help"),backendModel:function(){return this.modelFor("vault.cluster.secrets.backend")},beforeModel:function(){var e=this.paramsFor("vault.cluster.secrets.backend").backend
if("ssh"==e){return this.pathHelp.getNewModel("ssh-otp-credential",e)}},model:function(e){var n=e.secret,a=this.backendModel(),s=a.get("id"),r=a.get("type")
return t.includes(a.get("type"))?Ember.RSVP.resolve({backendPath:s,backendType:r,roleName:n}):this.transitionTo("vault.cluster.secrets.backend.list-root",s)},resetController:function(e){e.reset()}})}),define("vault/routes/vault/cluster/secrets/backend/edit-root",["exports","vault/routes/vault/cluster/secrets/backend/edit"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/routes/vault/cluster/secrets/backend/edit",["exports","vault/routes/vault/cluster/secrets/backend/secret-edit"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({queryParams:{version:{refreshModel:!0}}})}),define("vault/routes/vault/cluster/secrets/backend/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({beforeModel:function(){return this.replaceWith("vault.cluster.secrets.backend.list-root")}})}),define("vault/routes/vault/cluster/secrets/backend/list-root",["exports","vault/routes/vault/cluster/secrets/backend/list"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/routes/vault/cluster/secrets/backend/list",["exports","vault/helpers/supported-secret-backends","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0})
var a=(0,t.supportedSecretBackends)()
e.default=Ember.Route.extend({templateName:"vault/cluster/secrets/backend/list",pathHelp:Ember.inject.service("path-help"),queryParams:{page:{refreshModel:!0},pageFilter:{refreshModel:!0},tab:{refreshModel:!0}},secretParam:function(){var e=this.paramsFor(this.routeName).secret
return e?(0,n.normalizePath)(e):""},enginePathParam:function(){return this.paramsFor("vault.cluster.secrets.backend").backend},beforeModel:function(){var e=this,t=this.secretParam(),n=this.enginePathParam(),s=this.paramsFor("vault.cluster.secrets.backend").tab,r=this.store.peekRecord("secret-engine",n),l=r&&r.get("engineType")
if(!l||!a.includes(l))return this.transitionTo("vault.cluster.secrets")
if("vault.cluster.secrets.backend.list"===this.routeName&&!t.endsWith("/"))return this.replaceWith("vault.cluster.secrets.backend.list",t+"/")
var i=this.getModelType(n,s)
return this.pathHelp.getNewModel(i,n).then(function(){e.store.unloadAll("capabilities")})},getModelType:function(e,t){var n=this.store.peekRecord("secret-engine",e),a=n.get("engineType")
return{transit:"transit-key",ssh:"role-ssh",aws:"role-aws",pki:"certs"===t?"pki-certificate":"role-pki",cubbyhole:"secret",kv:n.get("modelTypeForKV"),generic:n.get("modelTypeForKV")}[a]},model:function(e){var t=this,n=this.secretParam()||"",a=this.enginePathParam(),s=this.modelFor("vault.cluster.secrets.backend")
return Ember.RSVP.hash({secret:n,secrets:this.store.lazyPaginatedQuery(this.getModelType(a,e.tab),{id:n,backend:a,responsePath:"data.keys",page:e.page,pageFilter:e.pageFilter}).then(function(e){return t.set("has404",!1),e}).catch(function(e){if(s&&404===e.httpStatus&&""===n)return[]
throw e})})},afterModel:function(e){var t=this,n=this.paramsFor(this.routeName).tab,a=this.enginePathParam()
if(n&&"certs"===n)return Ember.RSVP.all(["ca","crl","ca_chain"].map(function(e){return t.store.queryRecord("pki-certificate",{id:e,backend:a})})).then(function(t){return t.rejectBy("certificate").forEach(function(e){return e.unloadRecord()}),e},function(){return e})},setupController:function(e,t){var n=this.paramsFor(this.routeName),a=t.secret,s=t.secrets,r=this.enginePathParam(),l=this.store.peekRecord("secret-engine",r),i=this.get("has404")
if(a!==e.get("baseKey.id")&&this.store.clearAllDatasets(),e.set("hasModel",!0),e.setProperties({model:s,has404:i,backend:r,backendModel:l,baseKey:{id:a},backendType:l.get("engineType")}),!i){var o=n.pageFilter,u=void 0
a?u=a+(o||""):o&&(u=o),e.setProperties({filter:u||"",page:s.get("meta.currentPage")||1})}},resetController:function(e,t){this._super.apply(this,arguments),t&&(e.set("pageFilter",null),e.set("filter",null))},actions:{error:function(e,t){var n=this.secretParam(),a=this.enginePathParam(),s=404===e.httpStatus,r=this.controllerFor(this.routeName).get("hasModel")
if(t.data.isDeletion&&s)throw e
return Ember.set(e,"secret",n),Ember.set(e,"isRoot",!0),Ember.set(e,"backend",a),!r||!s||(this.set("has404",!0),t.abort(),!1)},willTransition:function(e){return window.scrollTo(0,0),e.targetName!==this.routeName&&this.store.clearAllDatasets(),!0},reload:function(){this.store.clearAllDatasets(),this.refresh()}}})}),define("vault/routes/vault/cluster/secrets/backend/secret-edit",["exports","ember-data","vault/lib/key-utils","vault/mixins/unload-model-route","vault/utils/path-encoding-helpers"],function(e,t,n,a,s){function r(e){return function(){var t=e.apply(this,arguments)
return new Promise(function(e,n){return function a(s,r){try{var l=t[s](r),i=l.value}catch(e){return void n(e)}if(!l.done)return Promise.resolve(i).then(function(e){a("next",e)},function(e){a("throw",e)})
e(i)}("next")})}}Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(a.default,{pathHelp:Ember.inject.service("path-help"),secretParam:function(){var e=this.paramsFor(this.routeName).secret
return e?(0,s.normalizePath)(e):""},enginePathParam:function(){return this.paramsFor("vault.cluster.secrets.backend").backend},capabilities:function(e){var t=this.enginePathParam(),n=this.modelFor("vault.cluster.secrets.backend"),a=n.engineType,s=void 0
return s=n.isV2KV?t+"/data/"+e:"transit"===a?t+"/keys/"+e:"ssh"===a||"aws"===a?t+"/roles/"+e:t+"/"+e,this.store.findRecord("capabilities",s)},backendType:function(){return this.modelFor("vault.cluster.secrets.backend").get("engineType")},templateName:"vault/cluster/secrets/backend/secretEditLayout",beforeModel:function(){var e=this,t=this.secretParam()
return this.buildModel(t).then(function(){var a=n.default.parentKeyForKey(t)
if("edit"===e.routeName.split(".").pop()&&n.default.keyIsFolder(t))return a?e.transitionTo("vault.cluster.secrets.backend.list",(0,s.encodePath)(a)):e.transitionTo("vault.cluster.secrets.backend.list-root")})},buildModel:function(e){var t=this.enginePathParam(),n=this.modelType(t,e)
return["secret","secret-v2"].includes(n)?Ember.RSVP.resolve():this.pathHelp.getNewModel(n,t)},modelType:function(e,t){var n=this.modelFor("vault.cluster.secrets.backend",e),a=n.get("engineType")
return{transit:"transit-key",ssh:"role-ssh",aws:"role-aws",pki:t&&t.startsWith("cert/")?"pki-certificate":"role-pki",cubbyhole:"secret",kv:n.get("modelTypeForKV"),generic:n.get("modelTypeForKV")}[a]},getTargetVersion:function(e,t){return e?parseInt(t||e,10):t?parseInt(t,10):null},fetchV2Models:function(){var e=r(regeneratorRuntime.mark(function e(n,a,s){var r,l,i,o,u
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(r=this.enginePathParam(),l=this.modelFor("vault.cluster.secrets.backend",r),i=this.getTargetVersion(a.currentVersion,s.version),(o=a.versions&&a.versions.findBy("version",i))||!0===a.failedServerRead){e.next=8
break}throw u=new t.default.AdapterError,Ember.set(u,"httpStatus",404),u
case 8:return a.set("engine",l),e.t0=a,e.next=12,this.fetchV2VersionModel(n,a,o,i)
case 12:return e.t1=e.sent,e.t0.set.call(e.t0,"selectedVersion",e.t1),e.abrupt("return",a)
case 15:case"end":return e.stop()}},e,this)}))
return function(t,n,a){return e.apply(this,arguments)}}(),fetchV2VersionModel:function(){var e=r(regeneratorRuntime.mark(function e(t,n,a,s){var r,l,i,o
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(r=this.secretParam(),l=this.enginePathParam(),i=s?[l,r,s]:[l,r],o=void 0,e.prev=4,!n.failedServerRead){e.next=11
break}return e.next=8,this.store.findRecord("secret-v2-version",JSON.stringify(i),{reload:!0})
case 8:o=e.sent,e.next=15
break
case 11:return a.rollbackAttributes(),e.next=14,a.reload()
case 14:o=e.sent
case 15:e.next=26
break
case 17:if(e.prev=17,e.t0=e.catch(4),403!==e.t0.httpStatus||!t.get("canUpdate")){e.next=25
break}(o=a||this.store.createRecord("secret-v2-version")).setProperties({failedServerRead:!0}),o.isNew&&(o.set("id",JSON.stringify(i)),o.send("pushedData")),e.next=26
break
case 25:throw e.t0
case 26:return e.abrupt("return",o)
case 27:case"end":return e.stop()}},e,this,[[4,17]])}))
return function(t,n,a,s){return e.apply(this,arguments)}}(),handleSecretModelError:function(e,t,n,a){if(!e.get("canUpdate")&&"secret"===n)throw a
var s=this.store.createRecord(n)
return s.setProperties({id:t,failedServerRead:!0}),s},model:function(){var e=r(regeneratorRuntime.mark(function e(t){var n,a,s,r,l
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return n=this.secretParam(),a=this.enginePathParam(),s=this.modelType(a,n),n||(n=" "),"pki-certificate"===s&&(n=n.replace("cert/","")),r=void 0,l=this.capabilities(n),e.prev=7,e.next=10,this.store.queryRecord(s,{id:n,backend:a})
case 10:r=e.sent,e.next=22
break
case 13:if(e.prev=13,e.t0=e.catch(7),403!==e.t0.httpStatus||"secret-v2"!==s&&"secret"!==s){e.next=21
break}return e.next=18,l
case 18:r=this.handleSecretModelError(l,n,s,e.t0),e.next=22
break
case 21:throw e.t0
case 22:return e.next=24,l
case 24:if("secret-v2"!==s){e.next=28
break}return e.next=27,this.fetchV2Models(l,r,t)
case 27:r=e.sent
case 28:return e.abrupt("return",{secret:r,capabilities:l})
case 29:case"end":return e.stop()}},e,this,[[7,13]])}))
return function(t){return e.apply(this,arguments)}}(),setupController:function(e,t){this._super.apply(this,arguments)
var n=this.secretParam(),a=this.enginePathParam(),s=this.controllerFor("vault.cluster.secrets.backend").get("preferAdvancedEdit")||!1,r=this.backendType()
t.secret.setProperties({backend:a}),e.setProperties({model:t.secret,capabilities:t.capabilities,baseKey:{id:n},mode:this.routeName.split(".").pop().replace("-root",""),backend:a,preferAdvancedEdit:s,backendType:r})},resetController:function(e){e.reset&&"function"==typeof e.reset&&e.reset()},actions:{error:function(e){var t=this.secretParam(),n=this.enginePathParam()
return Ember.set(e,"keyId",n+"/"+t),Ember.set(e,"backend",n),!0},refreshModel:function(){this.refresh()},willTransition:function(e){var t=this.controller,n=t.mode,a=t.model,s=a.get("selectedVersion"),r=a.changedAttributes(),l=Object.keys(r)
return"show"!==n&&l.length&&"backend"!==l[0]||"show"!==n&&s&&Object.keys(s.changedAttributes()).length?window.confirm("You have unsaved changes. Navigating away will discard these changes. Are you sure you want to discard your changes?")?(s&&s.rollbackAttributes(),this.unloadModel(),!0):(e.abort(),!1):this._super.apply(this,arguments)}}})}),define("vault/routes/vault/cluster/secrets/backend/show-root",["exports","vault/routes/vault/cluster/secrets/backend/show"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/routes/vault/cluster/secrets/backend/show",["exports","vault/routes/vault/cluster/secrets/backend/secret-edit"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({queryParams:{version:{refreshModel:!0}}})}),define("vault/routes/vault/cluster/secrets/backend/sign-root",["exports","vault/routes/vault/cluster/secrets/backend/sign"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/routes/vault/cluster/secrets/backend/sign",["exports","vault/mixins/unload-model-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{templateName:"vault/cluster/secrets/backend/sign",backendModel:function(){return this.modelFor("vault.cluster.secrets.backend")},pathQuery:function(e,t){return{id:t+"/sign/"+e}},pathForType:function(){return"sign"},model:function(e){var t=this,n=e.secret,a=this.backendModel(),s=a.get("id")
return"ssh"!==a.get("type")?this.transitionTo("vault.cluster.secrets.backend.list-root",s):this.store.queryRecord("capabilities",this.pathQuery(n,s)).then(function(e){return e.get("canUpdate")?t.store.createRecord("ssh-sign",{role:{backend:s,id:n,name:n},id:s+"-"+n}):t.transitionTo("vault.cluster.secrets.backend.list-root",s)})},setupController:function(e){this._super.apply(this,arguments),e.set("backend",this.backendModel())}})}),define("vault/routes/vault/cluster/secrets/backend/versions-root",["exports","vault/routes/vault/cluster/secrets/backend/version"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/routes/vault/cluster/secrets/backend/versions",["exports","vault/lib/key-utils","vault/mixins/unload-model-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(n.default,{templateName:"vault/cluster/secrets/backend/versions",beforeModel:function(){var e=this.modelFor("vault.cluster.secrets.backend"),n=this.paramsFor(this.routeName).secret,a=t.default.parentKeyForKey(n)
if(!e.get("isV2KV"))return a?this.transitionTo("vault.cluster.secrets.backend.list",a):this.transitionTo("vault.cluster.secrets.backend.list-root")},model:function(e){var t=e.secret,n=this.paramsFor("vault.cluster.secrets.backend").backend
return this.store.queryRecord("secret-v2",{id:t,backend:n})}})}),define("vault/routes/vault/cluster/secrets/backends",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({model:function(){return this.store.query("secret-engine",{})}})}),define("vault/routes/vault/cluster/settings",["exports","vault/mixins/cluster-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{model:function(){return{}}})}),define("vault/routes/vault/cluster/settings/auth/configure",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({model:function(){var e=this,t=this.paramsFor(this.routeName).method
return this.store.findAll("auth-method").then(function(){return e.store.peekRecord("auth-method",t)})}})}),define("vault/routes/vault/cluster/settings/auth/configure/index",["exports","vault/helpers/tabs-for-auth-section"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({beforeModel:function(){var e=this.modelFor("vault.cluster.settings.auth.configure"),n=Ember.get((0,t.tabsForAuthSection)([e]),"firstObject.routeParams.lastObject")
return this.transitionTo("vault.cluster.settings.auth.configure.section",n)}})}),define("vault/routes/vault/cluster/settings/auth/configure/section",["exports","ember-data","vault/mixins/unload-model-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(n.default,{modelPath:"model.model",pathHelp:Ember.inject.service("path-help"),modelType:function(e,t){return{"aws-client":"auth-config/aws/client","aws-identity-whitelist":"auth-config/aws/identity-whitelist","aws-roletag-blacklist":"auth-config/aws/roletag-blacklist","azure-configuration":"auth-config/azure","github-configuration":"auth-config/github","gcp-configuration":"auth-config/gcp","jwt-configuration":"auth-config/jwt","oidc-configuration":"auth-config/oidc","kubernetes-configuration":"auth-config/kubernetes","ldap-configuration":"auth-config/ldap","okta-configuration":"auth-config/okta","radius-configuration":"auth-config/radius"}[e+"-"+t]},beforeModel:function(){var e=this.paramsFor(this.routeName).section_name
if("options"!==e){var t=this.paramsFor("vault.cluster.settings.auth.configure").method,n=this.modelFor("vault.cluster.settings.auth.configure"),a=this.modelType(n.type,e)
return this.pathHelp.getNewModel(a,t,n.apiPath)}},model:function(e){var n=this,a=this.modelFor("vault.cluster.settings.auth.configure"),s=e.section_name
if("options"===s)return Ember.RSVP.hash({model:a,section:s})
var r=this.modelType(a.get("type"),s)
if(!r){var l=new t.default.AdapterError
throw Ember.set(l,"httpStatus",404),l}var i=this.store.peekRecord(r,a.id)
return i?Ember.RSVP.hash({model:i,section:s}):this.store.findRecord(r,a.id).then(function(e){return e.set("backend",a),Ember.RSVP.hash({model:e,section:s})}).catch(function(e){var t=void 0
if(404===e.httpStatus)return(t=n.store.createRecord(r,{id:a.id})).set("backend",a),Ember.RSVP.hash({model:t,section:s})
throw e})},actions:{willTransition:function(){if("auth-method"!==this.currentModel.model.constructor.modelName)return this.unloadModel(),!0}}})}),define("vault/routes/vault/cluster/settings/auth/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({beforeModel:function(){return this.replaceWith("vault.cluster.settings.auth.enable")}})}),define("vault/routes/vault/cluster/settings/configure-secret-backend",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=["aws","ssh","pki"]
e.default=Ember.Route.extend({model:function(){var e=this,a=this.paramsFor(this.routeName).backend
return this.store.query("secret-engine",{path:a}).then(function(s){var r=s&&s.get("firstObject")
if(!r||!n.includes(r.get("type"))){var l=new t.default.AdapterError
throw Ember.set(l,"httpStatus",404),l}return e.store.findRecord("secret-engine",a).then(function(){return r},function(){return r})})},afterModel:function(e,t){var n=e.get("type")
return"pki"===n?t.targetName===this.routeName?this.transitionTo(this.routeName+".section","cert"):void 0:"aws"===n?this.store.queryRecord("secret-engine",{backend:e.id,type:n}).then(function(){return e},function(){return e}):e},setupController:function(e,t){return t.get("publicKey")&&e.set("configured",!0),this._super.apply(this,arguments)},resetController:function(e,t){t&&e.reset()},actions:{refreshRoute:function(){this.refresh()}}})}),define("vault/routes/vault/cluster/settings/configure-secret-backend/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({beforeModel:function(e){if("pki"===this.modelFor("vault.cluster.settings.configure-secret-backend").get("type")&&e.targetName===this.routeName)return this.transitionTo("vault.cluster.settings.configure-secret-backend.section","cert")}})}),define("vault/routes/vault/cluster/settings/configure-secret-backend/section",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n={pki:["cert","urls","crl","tidy"]}
e.default=Ember.Route.extend({fetchModel:function(){var e=this.paramsFor(this.routeName).section_name,t=this.modelFor("vault.cluster.settings.configure-secret-backend"),n=t.get("type")+"-config"
return this.store.queryRecord(n,{backend:t.id,section:e}).then(function(n){return n.set("backendType",t.get("type")),n.set("section",e),n})},model:function(e){var a=e.section_name,s=this.modelFor("vault.cluster.settings.configure-secret-backend"),r=n[s.get("type")].includes(a)
if(!s||!r){var l=new t.default.AdapterError
throw Ember.set(l,"httpStatus",404),l}return this.fetchModel()},setupController:function(e){var t=this
this._super.apply(this,arguments),e.set("onRefresh",function(){return t.fetchModel()})}})}),define("vault/routes/vault/cluster/settings/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({beforeModel:function(e){if(e.targetName===this.routeName)return e.abort(),this.replaceWith("vault.cluster.settings.mount-secret-backend")}})})
define("vault/routes/vault/cluster/settings/mount-secret-backend",["exports","vault/mixins/unload-model-route","vault/mixins/unsaved-model-route"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,n.default,{model:function(){return{}},activate:function(){this.store.unloadAll("secret-engine")}})}),define("vault/routes/vault/cluster/settings/seal",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({model:function(){return Ember.RSVP.hash({cluster:this.modelFor("vault.cluster"),seal:this.store.findRecord("capabilities","sys/seal")})}})}),define("vault/routes/vault/cluster/tools",["exports","vault/mixins/cluster-route"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend(t.default,{model:function(){return this.modelFor("vault.cluster")}})}),define("vault/routes/vault/cluster/tools/index",["exports","vault/helpers/tools-actions"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({currentCluster:Ember.inject.service(),beforeModel:function(e){var n=this.get("currentCluster.cluster.name"),a=(0,t.toolsActions)()
if(e.targetName===this.routeName)return e.abort(),this.replaceWith("vault.cluster.tools.tool",n,a[0])}})}),define("vault/routes/vault/cluster/tools/tool",["exports","vault/helpers/tools-actions"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Route.extend({wizard:Ember.inject.service(),beforeModel:function(e){var n=(0,t.toolsActions)(),a=this.paramsFor(this.routeName).selected_action
if(!a||!n.includes(a))return e.abort(),this.transitionTo(this.routeName,n[0])},model:function(e){return e.selected_action},setupController:function(e,t){this._super.apply(this,arguments),e.set("selectedAction",t)},actions:{didTransition:function(){var e=this.paramsFor(this.routeName)
return"tools"===this.wizard.currentMachine&&this.wizard.transitionFeatureMachine(this.wizard.featureState,e.selected_action.toUpperCase()),this.controller.setProperties(e),!0}}})}),define("vault/routes/vault/cluster/unseal",["exports","vault/routes/vault/cluster/cluster-route-base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({wizard:Ember.inject.service(),activate:function(){this.get("wizard").set("initEvent","UNSEAL"),this.get("wizard").transitionTutorialMachine(this.get("wizard.currentState"),"TOUNSEAL")}})}),define("vault/serializers/application",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t]
for(var a in n)Object.prototype.hasOwnProperty.call(n,a)&&(e[a]=n[a])}return e}
e.default=t.default.JSONSerializer.extend({keyForAttribute:function(e){return Ember.String.decamelize(e)},normalizeItems:function(e){var t=this
return e.data&&e.data.keys&&Array.isArray(e.data.keys)?e.data.keys.map(function(a){if("string"!=typeof a)return a
var s=function(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}({},t.get("primaryKey")||"id",a)
return e._requestQuery&&(s=n({},s,e._requestQuery)),s}):(Ember.assign(e,e.data),delete e.data,e)},pushPayload:function(e,t){var n=this.normalizeResponse(e,e.modelFor(t.modelName),t,t.id,"findRecord")
return e.push(n)},normalizeResponse:function(e,t,n,a,s){var r=this.normalizeItems(n,s)
delete n._requestQuery,a&&!r.id&&(r.id=a)
var l=this._super(e,t,r,a,s)
return t.relatedCapabilities&&(l=t.relatedCapabilities(l)),l},serializeAttribute:function(e,t,n,a){var s=e.attr(n),r=Ember.isNone(e.changedAttributes()[n]),l=Ember.isBlank(s)
a.options.readOnly||"object"===a.type&&s&&Object.keys(s).length>0&&r||l&&r||this._super(e,t,n,a)},serializeBelongsTo:function(e,t){return t}})}),define("vault/serializers/auth-method",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t]
for(var a in n)Object.prototype.hasOwnProperty.call(n,a)&&(e[a]=n[a])}return e}
e.default=t.default.extend({normalizeBackend:function(e,t){var a=n({},t)
return a.id=e.slice(0,-1),a.path=e,a},normalizeResponse:function(e,t,n,a,s){var r=this,l="createRecord"===s?n.data:Object.keys(n.data).map(function(e){return r.normalizeBackend(e,n.data[e])})
return this._super(e,t,l,a,s)}})}),define("vault/serializers/capabilities",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t]
for(var a in n)Object.prototype.hasOwnProperty.call(n,a)&&(e[a]=n[a])}return e}
e.default=t.default.extend({primaryKey:"path",normalizeResponse:function(e,t,a,s,r){s&&(a.path=s)
var l=n({},a.data,{path:a.path})
return this._super(e,t,l,s,r)},modelNameFromPayloadKey:function(){return"capabilities"}})}),define("vault/serializers/cluster",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.RESTSerializer.extend(t.default.EmbeddedRecordsMixin,{keyForAttribute:function(e){return Ember.String.decamelize(e)},attrs:{nodes:{embedded:"always"}},pushPayload:function(e,t){var n=this.normalizeResponse(e,e.modelFor("cluster"),t,null,"findAll")
return e.push(n)},normalizeResponse:function(e,t,n,a,s){var r={clusters:Ember.assign({id:"1"},n.data||n)}
return this._super(e,t,r,a,s)}})}),define("vault/serializers/config",["exports","ember-data"],function(e,t){function n(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.RESTSerializer.extend({keyForAttribute:function(e){return Ember.String.decamelize(e)},normalizeAll:function(e){return e.data?[Ember.assign({},e,e.data)]:[e]},normalizeResponse:function(e,t,a,s,r){var l=this.normalizeAll(a),i=t.modelName,o=n({},i,l)
return"queryRecord"===r&&(o=n({},i,l[0])),this._super(e,t,o,s,r)}})}),define("vault/serializers/control-group",["exports","ember-data","vault/serializers/application"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=n.default.extend(t.default.EmbeddedRecordsMixin,{attrs:{requestEntity:{embedded:"always"},authorizations:{embedded:"always"}},normalizeResponse:function(e,t,n){var a=Ember.get(n,"data.request_entity")
if(Array.isArray(n.data.authorizations)){var s=!0,r=!1,l=void 0
try{for(var i,o=n.data.authorizations[Symbol.iterator]();!(s=(i=o.next()).done);s=!0){var u=i.value
u.id=u.entity_id,u.name=u.entity_name}}catch(e){r=!0,l=e}finally{try{!s&&o.return&&o.return()}finally{if(r)throw l}}}return a&&0===Object.keys(a).length&&(n.data.request_entity=null),this._super.apply(this,arguments)},serialize:function(e){return{accessor:e.id}}})}),define("vault/serializers/identity/_base",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({normalizeItems:function(e){return e.data.keys&&Array.isArray(e.data.keys)?e.data.keys.map(function(t){var n=e.data.key_info[t]
return n.id=t,n}):(Ember.assign(e,e.data),delete e.data,e)}})}),define("vault/serializers/identity/entity-alias",["exports","vault/serializers/identity/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/serializers/identity/entity",["exports","ember-data","vault/serializers/identity/_base"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=n.default.extend(t.default.EmbeddedRecordsMixin,{serializeHasMany:function(){},attrs:{aliases:{embedded:"always"}}})}),define("vault/serializers/identity/group-alias",["exports","vault/serializers/identity/_base"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/serializers/identity/group",["exports","ember-data","vault/serializers/identity/_base"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=n.default.extend(t.default.EmbeddedRecordsMixin,{attrs:{alias:{embedded:"always"}},normalizeFindRecordResponse:function(e,t,n){return n.alias&&0===Object.keys(n.alias).length&&delete n.alias,this._super.apply(this,arguments)},serialize:function(){var e=this._super.apply(this,arguments)
return delete e.alias,"external"===e.type&&(delete e.member_entity_ids,delete e.member_group_ids),e}})}),define("vault/serializers/lease",["exports","ember-data"],function(e,t){function n(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.RESTSerializer.extend({keyForAttribute:function(e){return Ember.String.decamelize(e)},normalizeAll:function(e){return e.data.keys&&Array.isArray(e.data.keys)?e.data.keys.map(function(t){return{id:e.prefix?e.prefix+t:t}}):[e.data]},normalizeResponse:function(e,t,a,s,r){var l=this.normalizeAll(a),i=t.modelName,o=n({},i,l)
return"queryRecord"===r&&(o=n({},i,l[0])),this._super(e,t,o,s,r)}})}),define("vault/serializers/mount-config",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/serializers/mount-filter-config",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.RESTSerializer.extend({keyForAttribute:function(e){return Ember.String.decamelize(e)},normalizeResponse:function(e,t,n,a,s){var r=t.modelName
n.data.id=a
var l,i,o,u=(l={},i=r,o=n.data,i in l?Object.defineProperty(l,i,{value:o,enumerable:!0,configurable:!0,writable:!0}):l[i]=o,l)
return this._super(e,t,u,a,s)}})}),define("vault/serializers/namespace",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({normalizeList:function(e){return e.data.keys?e.data.keys.map(function(e){return{path:e,id:e.replace(/\/$/,"")}}):e.data},normalizeResponse:function(e,t,n,a,s){var r=(a||n.id||"").replace(/\/$/,""),l=["deleteRecord","createRecord"].includes(s)?{id:r,path:r}:this.normalizeList(n)
return this._super(e,t,l,a,s)}})}),define("vault/serializers/node",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.RESTSerializer.extend(t.default.EmbeddedRecordsMixin,{keyForAttribute:function(e){return Ember.String.decamelize(e)},pushPayload:function(e,t){var n=this.normalizeResponse(e,e.modelFor("node"),t,null,"findAll")
return e.push(n)},nodeFromObject:function(e,t){var n=t.nodes[e]
return Ember.assign(n,{name:e,id:e})},normalizeResponse:function(e,t,n,a,s){var r=this,l={nodes:n.nodes?Object.keys(n.nodes).map(function(e){return r.nodeFromObject(e,n)}):[Ember.assign(n,{id:"1"})]}
return this._super(e,t,l,a,s)},normalize:function(e,t,n){return t.id="1",this._super(e,t,n)}})}),define("vault/serializers/pki-certificate",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.RESTSerializer.extend({keyForAttribute:function(e){return Ember.String.decamelize(e)},pushPayload:function(e,t){var n=this.normalizeResponse(e,e.modelFor(t.modelName),t,t.id,"findRecord")
return e.push(n)},normalizeItems:function(e){return e.data&&e.data.keys&&Array.isArray(e.data.keys)?e.data.keys.map(function(t){var n={id_for_nav:"cert/"+t,id:t}
return e.backend&&(n.backend=e.backend),n}):(Ember.assign(e,e.data),delete e.data,e)},normalizeResponse:function(e,t,n,a,s){var r,l,i,o=this.normalizeItems(n),u=t.modelName,c=(i=o,(l=u)in(r={})?Object.defineProperty(r,l,{value:i,enumerable:!0,configurable:!0,writable:!0}):r[l]=i,r)
return this._super(e,t,c,a,s)},serializeAttribute:function(e,t,n,a){var s=e.attr(n),r=Ember.isNone(e.changedAttributes()[n]),l=Ember.isBlank(s)
a.options.readOnly||"object"===a.type&&s&&Object.keys(s).length>0&&r||l&&r||this._super(e,t,n,a)}})}),define("vault/serializers/pki-config",["exports","ember-data"],function(e,t){function n(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.RESTSerializer.extend({keyForAttribute:function(e){return Ember.String.decamelize(e)},normalizeAll:function(e){return e.data?[Ember.assign({},e,e.data)]:[e]},normalizeResponse:function(e,t,a,s,r){var l=this.normalizeAll(a),i=t.modelName,o=n({},i,l)
return"queryRecord"===r&&(o=n({},i,l[0])),this._super(e,t,o,s,r)}})}),define("vault/serializers/policy",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({primaryKey:"name",normalizePolicies:function(e){return e.data.keys?e.data.keys.map(function(e){return{name:e}}):e.data},normalizeResponse:function(e,t,n,a,s){var r=["deleteRecord"].includes(s)?{name:a}:this.normalizePolicies(n)
return this._super(e,t,r,a,s)}})}),define("vault/serializers/policy/acl",["exports","vault/serializers/policy"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/serializers/policy/egp",["exports","vault/serializers/policy"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/serializers/policy/rgp",["exports","vault/serializers/policy"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/serializers/replication-attributes",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.RESTSerializer.extend({keyForAttribute:function(e){return Ember.String.decamelize(e)}})}),define("vault/serializers/role-aws",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({extractLazyPaginatedData:function(e){return e.data.keys.map(function(t){var n={id:t}
return e.backend&&(n.backend=e.backend),n})},normalizeItems:function(){var e=this._super.apply(this,arguments)
return e.credential_types&&(e.credential_type=e.credential_types[0]),e}})})
define("vault/serializers/role-pki",["exports","vault/serializers/role"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/serializers/role-ssh",["exports","vault/serializers/role"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend()}),define("vault/serializers/role",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({extractLazyPaginatedData:function(e){var t
return e.zero_address_roles&&e.zero_address_roles.forEach(function(t){e.data.key_info[t].zero_address=!0}),e.data.key_info?(t=e.data.keys.map(function(t){var n={id:t,key_type:e.data.key_info[t].key_type,zero_address:e.data.key_info[t].zero_address}
return e.backend&&(n.backend=e.backend),n}),delete e.data.key_info,t):e.data.keys.map(function(t){var n={id:t}
return e.backend&&(n.backend=e.backend),n})}})}),define("vault/serializers/secret-engine",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({normalizeBackend:function(e,t){var n={}
for(var a in t)n[a]=t[a]
return null===e||n.path||(n.path=e),n.data&&delete(n=Ember.assign({},n,n.data)).data,n.id=n.path.slice(0,-1),n},normalizeResponse:function(e,t,n,a,s){var r=this,l="findRecord"===s,i="queryRecord"===s,o=void 0
return o="createRecord"===s?n.data:l?this.normalizeBackend(a+"/",n.data):i?this.normalizeBackend(null,n):n.data.secret?Object.keys(n.data.secret).map(function(e){return r.normalizeBackend(e,n.data.secret[e])}):n.data.path?[this.normalizeBackend(n.data.path,n.data)]:Object.keys(n.data).map(function(e){return r.normalizeBackend(e,n[e])}),this._super(e,t,o,a,s)},serialize:function(e){var t=e.record.get("engineType"),n=this._super.apply(this,arguments)
return"kv"!==t&&"generic"!==t?delete n.options:n.options.version||(n.options.version=2),n}})}),define("vault/serializers/secret-v2-version",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({secretDataPath:"data.data",normalizeItems:function(e){var t=this.secretDataPath
return e.secret_data=Ember.get(e,t),delete(e=Ember.assign({},e,e.data.metadata)).data,e.path=e.id,e},serialize:function(e){var t=e.belongsTo("secret")
if(t.record.failedServerRead&&e.record.failedServerRead)return{data:e.attr("secretData")}
var n=t.record.failedServerRead?e.attr("version"):t.attr("currentVersion")
return n=n||0,{data:e.attr("secretData"),options:{cas:n}}}})}),define("vault/serializers/secret-v2",["exports","vault/serializers/application","ember-data"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend(n.default.EmbeddedRecordsMixin,{attrs:{versions:{embedded:"always"}},secretDataPath:"data",normalizeItems:function(e,t){return e.data.keys&&Array.isArray(e.data.keys)?e.data.keys.map(function(t){var n=e.id?e.id+t:t
return n||(n=" "),{id:n,engine_id:e.backend}}):(e.data.versions&&(e.data.versions=Object.keys(e.data.versions).map(function(t){var n=e.data.versions[t]
return n.version=t,n.path=e.id,n.id=JSON.stringify([e.backend,e.id,t]),n})),e.data.engine_id=e.backend,e.data.id=e.id,"queryRecord"===t?e.data:[e.data])},serializeHasMany:function(){}})}),define("vault/serializers/secret",["exports","vault/serializers/application"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({secretDataPath:"data",normalizeItems:function(e,t){if("queryRecord"!==t&&e.data.keys&&Array.isArray(e.data.keys))return e.data.keys.map(function(t){var n=e.id?e.id+t:t
return n||(n=" "),{id:n,backend:e.backend}})
var n=this.get("secretDataPath")
return e.secret_data=Ember.get(e,n),delete e[n],"queryRecord"===t?e:[e]},serialize:function(e){return e.attr("secretData")}})}),define("vault/serializers/ssh",["exports","ember-data"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.RESTSerializer.extend({keyForAttribute:function(e){return Ember.String.decamelize(e)},pushPayload:function(e,t){var n=this.normalizeResponse(e,e.modelFor(t.modelName),t,t.id,"findRecord")
return e.push(n)},normalizeItems:function(e){return Ember.assign(e,e.data),delete e.data,e},normalizeResponse:function(e,t,n,a,s){var r,l,i,o=this.normalizeItems(n),u=t.modelName,c=(i=o,(l=u)in(r={})?Object.defineProperty(r,l,{value:i,enumerable:!0,configurable:!0,writable:!0}):r[l]=i,r)
return this._super(e,t,c,a,s)},serializeAttribute:function(e,t,n,a){var s=e.attr(n)
a.options.readOnly||"object"===a.type&&s&&Object.keys(s).length>0&&Ember.isNone(e.changedAttributes()[n])||Ember.isBlank(s)&&Ember.isNone(e.changedAttributes()[n])||this._super(e,t,n,a)}})}),define("vault/serializers/transit-key",["exports","ember-data"],function(e,t){function n(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.RESTSerializer.extend({primaryKey:"name",keyForAttribute:function(e){return Ember.String.decamelize(e)},normalizeSecrets:function(e){if(e.data.keys&&Array.isArray(e.data.keys))return e.data.keys.map(function(e){return{name:e}})
if(Ember.assign(e,e.data),delete e.data,"aes256-gcm96"===e.type||"chacha20-poly1305"===e.type)for(var t in e.keys)e.keys[t]=1e3*e.keys[t]
return[e]},normalizeResponse:function(e,t,a,s,r){var l=["updateRecord","createRecord","deleteRecord"].includes(r)?{name:s}:this.normalizeSecrets(a),i=t.modelName,o=n({},i,l)
return"queryRecord"===r&&(o=n({},i,l[0])),this._super(e,t,o,s,r)},serialize:function(e,t){return"update"===t?{min_decryption_version:e.attr("minDecryptionVersion"),min_encryption_version:e.attr("minEncryptionVersion"),deletion_allowed:e.attr("deletionAllowed")}:this._super.apply(this,arguments)}})}),define("vault/services/asset-loader",["exports","ember-asset-loader/services/asset-loader"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/services/auth",["exports","fetch","vault/lib/token-storage","vault/config/environment","vault/helpers/supported-auth-backends","ember-concurrency"],function(e,t,n,a,s,r){Object.defineProperty(e,"__esModule",{value:!0}),e.ROOT_PREFIX=e.TOKEN_PREFIX=e.TOKEN_SEPARATOR=void 0
var l=(0,s.supportedAuthBackends)()
e.TOKEN_SEPARATOR="☃",e.TOKEN_PREFIX="vault-",e.ROOT_PREFIX="_root_",e.default=Ember.Service.extend({permissions:Ember.inject.service(),namespace:Ember.inject.service(),IDLE_TIMEOUT:18e4,expirationCalcTS:null,init:function(){this._super.apply(this,arguments),this.checkForRootToken()},clusterAdapter:function(){return Ember.getOwner(this).lookup("adapter:cluster")},tokens:Ember.computed(function(){return this.getTokensFromStorage()||[]}),generateTokenName:function(e,t){var n=e.backend,a=e.clusterId
return(t||[]).includes("root")?"vault-_root_☃"+a:"vault-"+n+"☃"+a},backendFromTokenName:function(e){return e.includes("vault-_root_")?"token":e.slice("vault-".length).split("☃")[0]},storage:function(e){return e&&0===e.indexOf("vault-_root_")&&"development"!==this.environment()?(0,n.default)("memory"):(0,n.default)()},environment:function(){return a.default.environment},now:function(){return Date.now()},setCluster:function(e){this.set("activeCluster",e)},ajax:function(e,n,a){var s={url:e,method:n,dataType:"json",headers:{"X-Vault-Token":this.get("currentToken")}},r=void 0===a.namespace?this.get("namespaceService.path"):a.namespace
r&&(s.headers["X-Vault-Namespace"]=r)
var l=Ember.assign(s,a)
return(0,t.default)(e,{method:l.method||"GET",headers:l.headers||{}}).then(function(e){return 204===e.status?Ember.RSVP.resolve():e.status>=200&&e.status<300?Ember.RSVP.resolve(e.json()):Ember.RSVP.reject()})},renewCurrentToken:function(){var e=this.get("authData.userRootNamespace")
return this.ajax("/v1/auth/token/renew-self","POST",{namespace:e})},revokeCurrentToken:function(){var e=this.get("authData.userRootNamespace")
return this.ajax("/v1/auth/token/revoke-self","POST",{namespace:e})},calculateExpiration:function(e){var t=this.now(),n=e.ttl||e.lease_duration,a=t+1e3*n
return this.set("expirationCalcTS",t),{ttl:n,tokenExpirationEpoch:a}},persistAuthData:function(){var e=Array.prototype.slice.call(arguments),t=e[0],n=e[1],a=this.get("tokens"),s=this.get("namespace.path")||"",r=void 0,i=void 0,o=void 0
"string"==typeof t?(r=t,o=this.backendFromTokenName(r)):o=(i=t).backend
var u=l.findBy("type",o),c=void 0
c=Ember.isArray(u.displayNamePath)?u.displayNamePath.map(function(e){return Ember.get(n,e)}).join("/"):Ember.get(n,u.displayNamePath)
var d=n.entity_id,m=n.policies,p=n.renewable,f=n.namespace_path,h=f&&f.replace(/\/$/,"")
"token"!==o||h||(h=""),void 0===h&&(h=this.get("authData.userRootNamespace")),void 0===h&&(h=s)
var b={userRootNamespace:h,displayName:c,backend:u,token:n.client_token||Ember.get(n,u.tokenPath),policies:m,renewable:p,entity_id:d}
return r=this.generateTokenName({backend:o,clusterId:i&&i.clusterId||this.get("activeCluster")},n.policies),n.renewable&&Ember.assign(b,this.calculateExpiration(n)),b.displayName||(b.displayName=Ember.get(this.getTokenData(r)||{},"displayName")),a.addObject(r),this.set("tokens",a),this.set("allowExpiration",!1),this.setTokenData(r,b),Ember.RSVP.resolve({namespace:s||b.userRootNamespace,token:r,isRoot:m.includes("root")})},setTokenData:function(e,t){this.storage(e).setItem(e,t)},getTokenData:function(e){return this.storage(e).getItem(e)},removeTokenData:function(e){return this.storage(e).removeItem(e)},tokenExpirationDate:Ember.computed("currentTokenName","expirationCalcTS",function(){var e=this.get("currentTokenName")
if(e){var t=this.getTokenData(e).tokenExpirationEpoch,n=new Date(0)
return t?n.setUTCMilliseconds(t):null}}),tokenExpired:Ember.computed(function(){var e=this.get("tokenExpirationDate")
return e?this.now()>=e:null}).volatile(),renewAfterEpoch:Ember.computed("currentTokenName","expirationCalcTS",function(){var e=this.get("currentTokenName"),t=this.expirationCalcTS,n=this.getTokenData(e)
if(!e||!n||!t)return null
var a=n.ttl
return n.renewable?Math.floor(1e3*a/2)+t:null}),renew:function(){var e=this,t=this.get("currentTokenName")
if(!this.get("isRenewing"))return this.set("isRenewing",!0),this.renewCurrentToken().then(function(n){return e.set("isRenewing",!1),e.persistAuthData(t,n.data||n.auth)},function(t){throw e.set("isRenewing",!1),t})},checkShouldRenew:(0,r.task)(regeneratorRuntime.mark(function e(){return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(!Ember.testing){e.next=3
break}return e.abrupt("return")
case 3:return e.next=5,(0,r.timeout)(5e3)
case 5:if(!this.shouldRenew()){e.next=8
break}return e.next=8,this.renew()
case 8:e.next=0
break
case 10:case"end":return e.stop()}},e,this)})).on("init"),shouldRenew:function(){var e=this.now(),t=this.get("lastFetch"),n=this.get("renewAfterEpoch")
return!(!this.currentTokenName||this.get("tokenExpired")||this.get("allowExpiration")||!n)&&(t&&e-t>=this.IDLE_TIMEOUT?(this.set("allowExpiration",!0),!1):e>=n)},setLastFetch:function(e){this.set("lastFetch",e),this.allowExpiration&&this.renew(),this.set("allowExpiration",!1)},getTokensFromStorage:function(e){return this.storage().keys().reject(function(t){return 0!==t.indexOf("vault-")||e&&e(t)})},checkForRootToken:function(){var e=this
"development"!==this.environment()&&this.getTokensFromStorage().forEach(function(t){var n=e.getTokenData(t)
n&&n.policies.includes("root")&&e.removeTokenData(t)})},authenticate:function(){var e,t=(e=regeneratorRuntime.mark(function e(){var t,n,a,s,r,l=arguments
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return t=Array.prototype.slice.call(l),n=t[0],a=this.clusterAdapter(),e.next=4,a.authenticate(n)
case 4:return s=e.sent,e.next=7,this.persistAuthData(n,s.auth||s.data,this.get("namespace.path"))
case 7:return r=e.sent,e.next=10,this.get("permissions").getPaths.perform()
case 10:return e.abrupt("return",r)
case 11:case"end":return e.stop()}},e,this)}),function(){var t=e.apply(this,arguments)
return new Promise(function(e,n){return function a(s,r){try{var l=t[s](r),i=l.value}catch(e){return void n(e)}if(!l.done)return Promise.resolve(i).then(function(e){a("next",e)},function(e){a("throw",e)})
e(i)}("next")})})
return function(){return t.apply(this,arguments)}}(),deleteCurrentToken:function(){var e=this.get("currentTokenName")
this.deleteToken(e),this.removeTokenData(e)},deleteToken:function(e){var t=this.get("tokens").without(e)
this.removeTokenData(e),this.set("tokens",t)},currentTokenName:Ember.computed("activeCluster","tokens","tokens.[]",function(){var e=new RegExp(this.get("activeCluster"))
return this.get("tokens").find(function(t){return e.test(t)})}),currentToken:Ember.computed("currentTokenName",function(){var e=this.get("currentTokenName"),t=e&&this.getTokenData(e)
return e&&t?t.token:null}),authData:Ember.computed("currentTokenName",function(){var e=this.get("currentTokenName")
if(e){var t=this.backendFromTokenName(e),n=this.getTokenData(e)
return Ember.assign(n,{backend:l.findBy("type",t)})}})})}),define("vault/services/code-mirror",["exports","ivy-codemirror/services/code-mirror"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/services/console",["exports","vault/lib/console-helpers","vault/utils/path-encoding-helpers"],function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.sanitizePath=s,e.ensureTrailingSlash=r
var a=function(){return function(e,t){if(Array.isArray(e))return e
if(Symbol.iterator in Object(e))return function(e,t){var n=[],a=!0,s=!1,r=void 0
try{for(var l,i=e[Symbol.iterator]();!(a=(l=i.next()).done)&&(n.push(l.value),!t||n.length!==t);a=!0);}catch(e){s=!0,r=e}finally{try{!a&&i.return&&i.return()}finally{if(s)throw r}}return n}(e,t)
throw new TypeError("Invalid attempt to destructure non-iterable instance")}}()
function s(e){return e.trim().replace(/^\/+|\/+$/g,"")}function r(e){return e.replace(/(\w+[^\/]$)/g,"$1/")}var l={read:"GET",list:"GET",write:"POST",delete:"DELETE"}
e.default=Ember.Service.extend({isOpen:!1,adapter:function(){return Ember.getOwner(this).lookup("adapter:console")},commandHistory:Ember.computed("log.[]",function(){return this.get("log").filterBy("type","command")}),log:Ember.computed(function(){return[]}),commandIndex:null,shiftCommandIndex:function(e){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:function(){},s=(0,t.shiftCommandIndex)(e,this.get("commandHistory"),this.get("commandIndex")),r=a(s,2),l=r[0],i=r[1]
void 0!==i&&void 0!==l&&(this.set("commandIndex",l),n(i))},clearLog:function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=this.get("log"),n=void 0
e||(n=this.get("commandHistory").slice()).setEach("hidden",!0),t.clear(),n&&t.addObjects(n)},logAndOutput:function(e,t){var n=this.get("log")
e&&(n.pushObject({type:"command",content:e}),this.set("commandIndex",null)),t&&n.pushObject(t)},ajax:function(e,t){var a=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},s=l[e],r=this.adapter(),i=r.buildURL((0,n.encodePath)(t)),o=a.data,u=a.wrapTTL
return r.ajax(i,s,{data:o,wrapTTL:u})},read:function(e,t,n){return this.ajax("read",s(e),{wrapTTL:n})},write:function(e,t,n){return this.ajax("write",s(e),{data:t,wrapTTL:n})},delete:function(e){return this.ajax("delete",s(e))},list:function(e,t,n){var a=r(s(e))
return this.ajax("list",a,{data:{list:!0},wrapTTL:n})}})}),define("vault/services/control-group",["exports","vault/lib/control-group-error","vault/lib/token-storage","core/utils/parse-url"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0}),e.TOKEN_SEPARATOR=e.CONTROL_GROUP_PREFIX=e.storageKey=void 0
var s=["sys/wrapping/rewrap","sys/wrapping/wrap","sys/replication/performance/primary/secondary-token","sys/replication/dr/primary/secondary-token"],r=function(e,t){return"vault:cg-"+e+"☃"+t}
e.storageKey=r,e.CONTROL_GROUP_PREFIX="vault:cg-",e.TOKEN_SEPARATOR="☃",e.default=Ember.Service.extend({version:Ember.inject.service(),router:Ember.inject.service(),storage:function(){return(0,n.default)()},keyFromAccessor:function(e){var t=(this.storage().keys()||[]).filter(function(e){return e.startsWith("vault:cg-")}).find(function(t){return t.replace("vault:cg-","").startsWith(e)})
return t||null},storeControlGroupToken:function(e){var t=r(e.accessor,e.creation_path)
this.storage().setItem(t,e)},deleteControlGroupToken:function(e){this.unmarkTokenForUnwrap()
var t=this.keyFromAccessor(e)
this.storage().removeItem(t)},deleteTokens:function(){var e=this;(this.storage().keys()||[]).filter(function(e){return e.startsWith("vault:cg-")}).forEach(function(t){return e.storage().removeItem(t)})},wrapInfoForAccessor:function(e){var t=this.keyFromAccessor(e)
return t?this.storage().getItem(t):null},tokenToUnwrap:null,markTokenForUnwrap:function(e){this.set("tokenToUnwrap",this.wrapInfoForAccessor(e))},unmarkTokenForUnwrap:function(){this.set("tokenToUnwrap",null)},tokenForUrl:function(e){if(this.get("version.isOSS"))return null
var t=(0,a.default)(e).pathname
t=t.replace("/v1/","")
var n=this.get("tokenToUnwrap")
return n&&n.creation_path===t?{token:n.token,accessor:n.accessor,creationTime:n.creation_time}:null},checkForControlGroup:function(e,n,a){var r=n&&Ember.get(n,"wrap_info.creation_path")
if(this.get("version.isOSS")||a||!n||r&&s.includes(r)||!n.wrap_info)return Ember.RSVP.resolve.apply(Ember.RSVP,function(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}(e))
var l=new t.default(n.wrap_info)
return Ember.RSVP.reject(l)},urlFromTransition:function(e){var t,n=Object.keys(e.params),a=[],s=!0,r=!1,l=void 0
try{for(var i,o=n[Symbol.iterator]();!(s=(i=o.next()).done);s=!0){var u=i.value,c=e.params[u]
Object.keys(c).length&&a.push(c)}}catch(e){r=!0,l=e}finally{try{!s&&o.return&&o.return()}finally{if(r)throw l}}return(t=this.get("router")).urlFor.apply(t,[e.targetName].concat(a,[{queryParams:e.queryParams}])).replace("/ui","")},handleError:function(e,t){var n=e.accessor,a=e.token,s=e.creation_path,r=e.creation_time,l=e.ttl,i=this.urlFromTransition(t),o={accessor:n,token:a,creation_path:s,creation_time:r,ttl:l}
return o.uiParams={url:i},this.storeControlGroupToken(o),this.get("router").transitionTo("vault.cluster.access.control-group-accessor",n)},logFromError:function(e){var t=e.accessor,n={accessor:t,token:e.token,creation_path:e.creation_path,creation_time:e.creation_time,ttl:e.ttl}
this.storeControlGroupToken(n)
var a=this.get("router").urlFor("vault.cluster.access.control-group-accessor",t)
return{type:"error-with-html",content:["A Control Group was encountered at "+e.creation_path+".","The Control Group Token is "+e.token+".","The Accessor is "+e.accessor+".","Visit <a href='"+a+"'>"+a+"</a> for more details."].join("\n")}}})}),define("vault/services/csp-event",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Service.extend({events:Ember.computed(function(){return[]}),connectionViolations:Ember.computed("events.[].violatedDirective",function(){return this.get("events").filter(function(e){return e.violatedDirective.startsWith("connect-src")})}),attach:function(){this.monitor.perform()},remove:function(){this.monitor.cancelAll()},monitor:(0,t.task)(regeneratorRuntime.mark(function e(){var n
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:this.events.clear()
case 1:return e.next=4,(0,t.waitForEvent)(window.document,"securitypolicyviolation")
case 4:n=e.sent,this.events.addObject(n),e.next=1
break
case 8:case"end":return e.stop()}},e,this)}))})}),define("vault/services/current-cluster",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Service.extend({cluster:null,setCluster:function(e){this.set("cluster",e)}})}),define("vault/services/flash-messages",["exports","ember-cli-flash/services/flash-messages"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default.extend({stickyInfo:function(e){return this.info(e,{sticky:!0,priority:300})}})}),define("vault/services/media",["exports","ember-responsive/services/media"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=t.default}),define("vault/services/namespace",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
e.default=Ember.Service.extend({store:Ember.inject.service(),auth:Ember.inject.service(),userRootNamespace:Ember.computed.alias("auth.authData.userRootNamespace"),path:null,accessibleNamespaces:null,inRootNamespace:Ember.computed.equal("path",""),setNamespace:function(e){this.set("path",e)},findNamespacesForUser:(0,t.task)(regeneratorRuntime.mark(function e(){var t,n,a,s,r
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:return t=this.get("store"),n=t.adapterFor("namespace"),a=this.get("auth.authData.userRootNamespace"),e.prev=3,e.next=6,n.findAll(t,"namespace",null,{adapterOptions:{forUser:!0,namespace:a}})
case 6:s=e.sent,r=s.data.keys||[],this.set("accessibleNamespaces",r.map(function(e){var t=e
return a&&(t=a+"/"+e),t.replace(/\/$/,"")})),e.next=13
break
case 11:e.prev=11,e.t0=e.catch(3)
case 13:case"end":return e.stop()}},e,this,[[3,11]])})).drop(),reset:function(){this.set("accessibleNamespaces",null)}})}),define("vault/services/path-help",["exports","ember-data","vault/utils/path-encoding-helpers","vault/utils/openapi-to-attrs","vault/utils/field-to-attrs","vault/adapters/generated-item-list"],function(e,t,n,a,s,r){Object.defineProperty(e,"__esModule",{value:!0}),e.sanitizePath=function(e){return e.trim().replace(/^\/+|\/+$/g,"")},e.default=Ember.Service.extend({attrs:null,ajax:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=Ember.getOwner(this).lookup("adapter:application"),a=t.data
return n.ajax(e,"GET",{data:a})},getNewModel:function(e,n,a,s){var r=this,l=Ember.getOwner(this),i="model:"+e,o=l.factoryFor(i),u=void 0,c=void 0
if(o){Ember.debug("Model factory found for "+e)
var d=(u=o.class).proto()
return u.merged||!0!==d.useOpenAPI?Ember.RSVP.resolve():(c=d.getHelpUrl(n),this.registerNewModelWithProps(c,n,u,i))}return Ember.debug("Creating new Model for "+e),u=t.default.Model.extend({}),this.getPaths(a,n,s).then(function(t){if(!l.factoryFor("adapter:"+e)){Ember.debug("Creating new adapter for "+e)
var o=r.getNewAdapter(t,s)
l.register("adapter:"+e,o)}var d=void 0
if(s){var m=t.create.find(function(e){return e.path.includes(s)})
d=(d=m.path).slice(0,d.indexOf("{")-1)+"/example"}else d=t.configPath[0].path
return c="/v1/"+a+d.slice(1)+"?help=true",r.registerNewModelWithProps(c,n,u,i)})},reducePaths:function(e,t){var n=t[0],a=t[1]
return a.post&&a.get&&a["x-vault-displayAttrs"]&&"Configure"===a["x-vault-displayAttrs"].action?(e.configPath.push({path:n}),e):(a.get&&a.get.parameters&&"list"===a.get.parameters[0].name&&e.list.push({path:n}),a.delete&&e.delete.push({path:n}),a.post&&a["x-vault-displayAttrs"]&&a["x-vault-displayAttrs"].action&&e.create.push({path:n,action:a["x-vault-displayAttrs"].action}),a["x-vault-displayAttrs"]&&a["x-vault-displayAttrs"].navigation&&e.navPaths.push({path:n}),e)},getPaths:function(e,t){var n=this
return Ember.debug("Fetching relevant paths for "+t+" from "+e),this.ajax("/v1/"+e+"?help=1",t).then(function(t){var a=t.openapi.paths
return Object.entries(a).reduce(n.reducePaths,{apiPath:e,configPath:[],list:[],create:[],delete:[],navPaths:[]})})},getProps:function(e,t){return Ember.debug("Fetching schema properties for "+t+" from "+e),this.ajax(e,t).then(function(e){var t=Object.keys(e.openapi.paths)[0],n=e.openapi.paths[t],s=n.parameters,r={}
if(s){var l=s[0],i=l.name,o=l.schema,u=l.description,c=i.split("_").join(" ")
r[i]={"x-vault-displayAttrs":{name:c,group:"default"},type:o.type,description:u,isId:!0}}var d=n.post.requestBody.content["application/json"].schema.properties,m=Ember.assign({},r,d)
return(0,a.expandOpenApiProps)(m)})},getNewAdapter:function(e,t){var a=e.list,s=e.create,l=e.apiPath,i=s.find(function(e){return e.path.includes(t)}),o=a.find(function(e){return e.path.includes(t)}),u=e.delete.find(function(e){return e.path.includes(t)})
return r.default.extend({urlForItem:function(e,t){var a=o.path,s=this.buildURL()+"/"+l+a.slice(1)+"/"
return t&&(s+=(0,n.encodePath)(t)),s},urlForFindRecord:function(e,t,n){return this.urlForItem(t,e,n)},urlForUpdateRecord:function(e){var t=i.path
return t=t.slice(1,t.indexOf("{")-1),this.buildURL()+"/"+l+t+"/"+e},urlForCreateRecord:function(e,t){var n=t.id,a=i.path
return a=a.slice(1,a.indexOf("{")-1),this.buildURL()+"/"+l+a+"/"+n},urlForDeleteRecord:function(e){var t=u.path
return t=t.slice(1,t.indexOf("{")-1),this.buildURL()+"/"+l+t+"/"+e}})},registerNewModelWithProps:function(e,t,n,s){var r=this
return this.getProps(e,t).then(function(e){var l=(0,a.combineAttributes)(n.attributes,e),i=l.attrs,o=l.newFields,u=Ember.getOwner(r)
n=n.extend(i,{newFields:o})
try{var c=n.proto().fieldGroups
c||(Ember.debug("Constructing fieldGroups for "+t),c=r.getFieldGroups(n),n=n.extend({fieldGroups:c}))}catch(e){}n.reopenClass({merged:!0}),u.unregister(s),u.register(s,n)})},getFieldGroups:function(e){var t,n,a,r={default:[]},l=[]
for(var i in e.attributes.forEach(function(e){e.options.fieldGroup?r[e.options.fieldGroup]?r[e.options.fieldGroup].push(e.name):r[e.options.fieldGroup]=[e.name]:r.default.push(e.name)}),r)l.push((t={},n=i,a=r[i],n in t?Object.defineProperty(t,n,{value:a,enumerable:!0,configurable:!0,writable:!0}):t[n]=a,t))
return(0,s.default)(e,l)}})}),define("vault/services/permissions",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n={access:{methods:"sys/auth",entities:"identity/entity/id",groups:"identity/group/id",leases:"sys/leases/lookup",namespaces:"sys/namespaces","control-groups":"sys/control-group/"},policies:{acl:"sys/policies/acl",rgp:"sys/policies/rgp",egp:"sys/policies/egp"},tools:{wrap:"sys/wrapping/wrap",lookup:"sys/wrapping/lookup",unwrap:"sys/wrapping/unwrap",rewrap:"sys/wrapping/rewrap",random:"sys/tools/random",hash:"sys/tools/hash"},status:{replication:"sys/replication",license:"sys/license",seal:"sys/seal"},metrics:{requests:"sys/internal/counters/requests"}},a={"sys/auth":["vault.cluster.access.methods"],"identity/entity/id":["vault.cluster.access.identity","entities"],"identity/group/id":["vault.cluster.access.identity","groups"],"sys/leases/lookup":["vault.cluster.access.leases"],"sys/namespaces":["vault.cluster.access.namespaces"],"sys/control-group/":["vault.cluster.access.control-groups"]}
e.default=Ember.Service.extend({exactPaths:null,globPaths:null,canViewAll:null,store:Ember.inject.service(),auth:Ember.inject.service(),namespace:Ember.inject.service(),getPaths:(0,t.task)(regeneratorRuntime.mark(function e(){var t
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(!this.paths){e.next=2
break}return e.abrupt("return")
case 2:return e.prev=2,e.next=5,this.get("store").adapterFor("permissions").query()
case 5:return t=e.sent,this.setPaths(t),e.abrupt("return")
case 10:e.prev=10,e.t0=e.catch(2),this.set("canViewAll",!0)
case 13:case"end":return e.stop()}},e,this,[[2,10]])})),setPaths:function(e){this.set("exactPaths",e.data.exact_paths),this.set("globPaths",e.data.glob_paths),this.set("canViewAll",e.data.root)},reset:function(){this.set("exactPaths",null),this.set("globPaths",null),this.set("canViewAll",null)},hasNavPermission:function(e,t){var a=this
return t?this.hasPermission(n[e][t]):Object.values(n[e]).some(function(e){return a.hasPermission(e)})},navPathParams:function(e){var t=this,s=Object.values(n[e]).find(function(e){return t.hasPermission(e)})
return["policies","tools"].includes(e)?s.split("/").lastObject:a[s]},pathNameWithNamespace:function(e){var t=this.get("namespace").path
return t?t+"/"+e:e},hasPermission:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[null],a=this.pathNameWithNamespace(e)
return!!this.canViewAll||n.every(function(e){return t.hasMatchingExactPath(a,e)||t.hasMatchingGlobPath(a,e)})},hasMatchingExactPath:function(e,t){var n=this.get("exactPaths")
if(n){var a=Object.keys(n).find(function(t){return t.startsWith(e)}),s=a&&!this.isDenied(n[a])
return a&&t?this.hasCapability(n[a],t)&&s:s}return!1},hasMatchingGlobPath:function(e,t){var n=this.get("globPaths")
if(n){var a=Object.keys(n).find(function(t){return e.includes(t)||e.includes(t.replace(/\/$/,""))}),s=a&&!this.isDenied(n[a])||n.hasOwnProperty("")
return a&&t?this.hasCapability(n[a],t)&&s:s}return!1},hasCapability:function(e,t){return e.capabilities.includes(t)},isDenied:function(e){return e.capabilities.includes("deny")}})}),define("vault/services/replication-mode",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Service.extend({mode:null,getMode:function(){this.get("mode")},setMode:function(e){this.set("mode",e)}})}),define("vault/services/router",["exports"],function(e){function t(e){var t=(e=e.slice())[e.length-1],n=void 0
return n=t&&t.hasOwnProperty("queryParams")?e.pop().queryParams:{},{routeName:e.shift(),models:e,queryParams:n}}function n(e,t){var n=void 0,a=0,s=0
for(n in e)if(e.hasOwnProperty(n)){if(e[n]!==t[n])return!1
a++}for(n in t)t.hasOwnProperty(n)&&s++
return a===s}Object.defineProperty(e,"__esModule",{value:!0}),e.extractRouteArgs=t,e.shallowEqual=n,e.default=Ember.Service.extend({routing:Ember.inject.service("-routing"),router:Ember.computed.alias("routing.router"),transitionTo:function(){var e,t=this.router
return(e=t.transitionTo).call.apply(e,[t].concat(Array.prototype.slice.call(arguments)))},replaceWith:function(){var e,t=this.router
return(e=t.replaceWith).call.apply(e,[t].concat(Array.prototype.slice.call(arguments)))},urlFor:function(){var e,t=this.router
return(e=t.generate).call.apply(e,[t].concat(Array.prototype.slice.call(arguments)))},currentURL:Ember.computed.alias("router.currentURL"),currentRouteName:Ember.computed.alias("router.currentRouteName"),rootURL:Ember.computed.alias("router.rootURL"),location:Ember.computed.alias("router.location"),isActive:function(){for(var e=arguments.length,a=Array(e),s=0;s<e;s++)a[s]=arguments[s]
var r=t(a),l=r.routeName,i=r.models,o=r.queryParams,u=this.router._routerMicrolib
return!!u.isActiveIntent(l,i,null)&&(!(Object.keys(o).length>0)||(this.router._prepareQueryParams(l,i,o,!0),n(o,u.state.queryParams)))}})}),define("vault/services/secret-mount-path",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.Service.extend({currentPath:null,update:function(e){this.set("currentPath",e)},get:function(){return this.currentPath}})}),define("vault/services/store",["exports","ember-copy","ember-data","vault/utils/clamp","vault/config/environment"],function(e,t,n,a,s){Object.defineProperty(e,"__esModule",{value:!0}),e.normalizeModelName=l,e.keyForCache=i
var r=s.default.APP.DEFAULT_PAGE_SIZE
function l(e){return Ember.String.dasherize(e)}function i(e){e.size,e.page,e.responsePath,e.pageFilter
var t=function(e,t){var n={}
for(var a in e)t.indexOf(a)>=0||Object.prototype.hasOwnProperty.call(e,a)&&(n[a]=e[a])
return n}(e,["size","page","responsePath","pageFilter"]),n=Object.keys(t).sort().reduce(function(e,n){return e[n]=t[n],e},{})
return JSON.stringify(n)}e.default=n.default.Store.extend({lazyCaches:Ember.computed(function(){return new Map}),setLazyCacheForModel:function(e,t,n){var a=i(t),s=this.lazyCacheForModel(e)||new Map
s.set(a,n)
var r=this.get("lazyCaches"),o=l(e)
r.set(o,s)},getLazyCacheForModel:function(e,t){var n=i(t),a=this.lazyCacheForModel(e)
if(a)return a.get(n)},lazyCacheForModel:function(e){return this.get("lazyCaches").get(l(e))},lazyPaginatedQuery:function(e,t){var n=this,a=this.adapterFor(e),s=l(e),i=this.getDataset(s,t),o=t.responsePath
return t.size||(t.size=r),i?Ember.RSVP.resolve(this.fetchPage(s,t)):a.query(this,{modelName:s},t).then(function(e){var a=n.serializerFor(s),r=a.extractLazyPaginatedData,l=r?r.call(a,e):Ember.get(e,o)
return Ember.set(e,o,null),n.storeDataset(s,t,e,l),n.fetchPage(s,t)}).catch(function(e){throw e})},filterData:function(e,t){var n=t||[]
return e&&(n=t.filter(function(t){return(t.id||t).toLowerCase().includes(e.toLowerCase())})),n},constructResponse:function(e,n){var s=n.pageFilter,r=n.responsePath,l=n.size,i=n.page,o=this.getDataset(e,n),u=o.response,c=o.dataset
u=(0,t.copy)(u,!0)
var d=this.filterData(s,c),m=Math.ceil(d.length/l),p=(0,a.default)(i,1,m),f=p*l,h=f-l,b=d.slice(h,f)
return Ember.set(u,r||"",b),u.meta={currentPage:p,lastPage:m,nextPage:(0,a.default)(p+1,1,m),prevPage:(0,a.default)(p-1,1,m),total:Ember.get(c,"length")||0,filteredTotal:Ember.get(d,"length")||0},u},fetchPage:function(e,t){var n=this,a=this.constructResponse(e,t)
return this.peekAll(e).forEach(function(e){e.unloadRecord()}),new Ember.RSVP.Promise(function(t){Ember.run.schedule("destroy",function(){n.push(n.serializerFor(e).normalizeResponse(n,n.modelFor(e),a,null,"query"))
var s=n.peekAll(e).toArray()
s.set("meta",a.meta),t(s)})})},getDataset:function(e,t){return this.getLazyCacheForModel(e,t)},storeDataset:function(e,t,n,a){var s={response:n,dataset:a}
this.setLazyCacheForModel(e,t,s)},clearDataset:function(e){var t=this.get("lazyCaches")
t.size&&(e&&t.has(e)?t.delete(e):(t.clear(),this.set("lazyCaches",t)))},clearAllDatasets:function(){this.clearDataset()}})}),define("vault/services/text-measurer",["exports","ember-text-measurer/services/text-measurer"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}),define("vault/services/version",["exports","ember-concurrency"],function(e,t){Object.defineProperty(e,"__esModule",{value:!0})
var n=function(e,t){var n=e.get("features")
return!!n&&n.includes(t)},a=function(e){return Ember.computed("features","features.[]",function(){return n(this,e)})}
e.default=Ember.Service.extend({_features:null,features:Ember.computed.readOnly("_features"),version:null,store:Ember.inject.service(),hasPerfReplication:a("Performance Replication"),hasDRReplication:a("DR Replication"),hasSentinel:a("Sentinel"),hasNamespaces:a("Namespaces"),isEnterprise:Ember.computed.match("version",/\+.+$/),isOSS:Ember.computed.not("isEnterprise"),setVersion:function(e){this.set("version",e.version)},hasFeature:function(e){return n(this,e)},setFeatures:function(e){e.features&&this.set("_features",e.features)},getVersion:(0,t.task)(regeneratorRuntime.mark(function e(){var t
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(!this.get("version")){e.next=2
break}return e.abrupt("return")
case 2:return e.next=4,this.get("store").adapterFor("cluster").health()
case 4:return t=e.sent,this.setVersion(t),e.abrupt("return")
case 7:case"end":return e.stop()}},e,this)})),getFeatures:(0,t.task)(regeneratorRuntime.mark(function e(){var t
return regeneratorRuntime.wrap(function(e){for(;;)switch(e.prev=e.next){case 0:if(!this.get("features.length")&&!this.get("isOSS")){e.next=2
break}return e.abrupt("return")
case 2:return e.prev=2,e.next=5,this.get("store").adapterFor("cluster").features()
case 5:return t=e.sent,this.setFeatures(t),e.abrupt("return")
case 10:e.prev=10,e.t0=e.catch(2)
case 12:case"end":return e.stop()}},e,this,[[2,10]])})).keepLatest(),fetchVersion:function(){return this.get("getVersion").perform()},fetchFeatures:function(){return this.get("getFeatures").perform()}})}),define("vault/services/wizard",["exports","xstate","vault/lib/token-storage","vault/helpers/wizard-constants"],function(e,t,n,a){Object.defineProperty(e,"__esModule",{value:!0})
var s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e}
function r(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t]
return n}return Array.from(e)}var l=a.STORAGE_KEYS.TUTORIAL_STATE,i=a.STORAGE_KEYS.COMPONENT_STATE,o=a.STORAGE_KEYS.FEATURE_STATE,u=a.STORAGE_KEYS.FEATURE_LIST,c=a.STORAGE_KEYS.FEATURE_STATE_HISTORY,d=a.STORAGE_KEYS.COMPLETED_FEATURES,m=a.STORAGE_KEYS.RESUME_URL,p=a.STORAGE_KEYS.RESUME_ROUTE,f=(0,t.Machine)(a.MACHINES.tutorial),h=null
e.default=Ember.Service.extend(a.DEFAULTS,{router:Ember.inject.service(),showWhenUnauthenticated:!1,featureMachineHistory:null,init:function(){this._super.apply(this,arguments),this.initializeMachines()},initializeMachines:function(){if(!this.storageHasKey(l)){var e=f.initialState
this.saveState("currentState",e.value),this.saveExtState(l,e.value)}this.saveState("currentState",this.getExtState(l)),this.storageHasKey(i)&&this.set("componentState",this.getExtState(i))
var t=f.getStateNodes(this.currentState)
this.executeActions(t.reduce(function(e,t){return e.concat(t.onEntry)},[]),null,"tutorial"),this.storageHasKey(u)&&(this.set("featureList",this.getExtState(u)),this.storageHasKey(c)&&this.set("featureMachineHistory",this.getExtState(c)),this.saveState("featureState",this.getExtState(o)||(h?h.initialState:null)),this.saveExtState(o,this.featureState),this.buildFeatureMachine())},clearFeatureData:function(){var e=this.storage();[u,o,c,d].forEach(function(t){return e.removeItem(t)}),this.set("currentMachine",null),this.set("featureMachineHistory",null),this.set("featureState",null),this.set("featureList",null)},restartGuide:function(){this.clearFeatureData()
var e=this.storage();[l,i,m,p].forEach(function(t){return e.removeItem(t)}),this.setProperties(a.DEFAULTS),this.initializeMachines(),this.transitionTutorialMachine("idle","AUTH")},saveFeatureHistory:function(e){if(0!==this.getCompletedFeatures().length||null!==this.featureMachineHistory||"idle"!==e&&"wrap"!==e){if(this.featureMachineHistory)if(this.featureMachineHistory.includes(e)){var t=this.featureMachineHistory.indexOf(e),n=this.featureMachineHistory.splice(0,t+1)
this.set("featureMachineHistory",n)}else{var a=this.featureMachineHistory.addObject(e)
this.set("featureMachineHistory",a)}}else{var s=[e]
this.set("featureMachineHistory",s)}this.featureMachineHistory&&this.saveExtState(c,this.featureMachineHistory)},saveState:function(e,t){t.value&&(t=t.value)
for(var n="";"object"===Ember.typeOf(t);){var a=Object.keys(t)
n+=a+".",t=t[a]}n+=t,this.set(e,n),"featureState"===e&&this.saveFeatureHistory(t)},transitionTutorialMachine:function(e,t,n){n&&(this.set("componentState",n),this.saveExtState(i,n))
var a=f.transition(e,t),s=a.actions,r=a.value
this.saveState("currentState",r),this.saveExtState(l,this.currentState),this.executeActions(s,t,"tutorial")},transitionFeatureMachine:function(e,t,n){if(h&&this.currentState.includes("active")){n&&(this.set("componentState",n),this.saveExtState(i,n))
var a=h.transition(e,t,this.get("componentState")),s=a.actions,r=a.value
if(this.saveState("featureState",r),this.saveExtState(o,r),this.executeActions(s,t,"feature"),h){var l=void 0
l="secrets"===this.currentMachine&&"display"===r?h.transition(r,"REPEAT",this.componentState):h.transition(r,"CONTINUE",this.componentState),this.saveState("nextStep",l.value)}}},saveExtState:function(e,t){this.storage().setItem(e,t)},getExtState:function(e){return this.storage().getItem(e)},storageHasKey:function(e){return Boolean(this.getExtState(e))},executeActions:function(e,t,n){var a=this,l=void 0,i=void 0,o=this.router,u=function(e){var n=e
switch(e.type&&(n=e.type),n){case"render":a.set(e.level+"Component",e.component)
break
case"routeTransition":i=e.params[0],l=o.urlFor.apply(o,r(e.params)).replace(/^\/ui/,""),Ember.run.next(function(){o.transitionTo.apply(o,r(e.params))})
break
case"saveFeatures":a.saveFeatures(t.features)
break
case"completeFeature":a.completeFeature()
break
case"handleDismissed":a.handleDismissed()
break
case"handlePaused":return a.handlePaused(),{v:void 0}
case"handleResume":a.handleResume()
break
case"showTutorialWhenAuthenticated":a.set("showWhenUnauthenticated",!1)
break
case"showTutorialAlways":a.set("showWhenUnauthenticated",!0)
break
case"clearFeatureData":a.clearFeatureData()
break
case"continueFeature":a.transitionFeatureMachine(a.featureState,"CONTINUE",a.componentState)}},c=!0,d=!1,m=void 0
try{for(var p,f=e[Symbol.iterator]();!(c=(p=f.next()).done);c=!0){var h=u(p.value)
if("object"===(void 0===h?"undefined":s(h)))return h.v}}catch(e){d=!0,m=e}finally{try{!c&&f.return&&f.return()}finally{if(d)throw m}}"tutorial"!==n&&(l?(this.set("expectedURL",l),this.set("expectedRouteName",i),this.set("setURLAfterTransition",!1)):this.set("setURLAfterTransition",!0))},handlePaused:function(){this.expectedURL&&(this.saveExtState(m,this.expectedURL),this.saveExtState(p,this.expectedRouteName))},handleResume:function(){var e=this,t=this.storage().getItem(m)
t&&this.get("router").transitionTo(t).followRedirects().then(function(){e.set("expectedRouteName",e.storage().getItem(p)),e.set("expectedURL",t),e.initializeMachines(),e.storage().removeItem(m)})},handleDismissed:function(){this.storage().removeItem(o),this.storage().removeItem(u),this.storage().removeItem(c),this.storage().removeItem(i)},saveFeatures:function(e){this.set("featureList",e),this.saveExtState(u,this.featureList),this.buildFeatureMachine()},buildFeatureMachine:function(){if(null!==this.featureList){this.startFeature()
var e=this.featureList.length>1?this.featureList.objectAt(1).capitalize():"Finish"
this.set("nextFeature",e)
var t=void 0
t="secrets"===this.currentMachine&&"display"===this.featureState?h.transition(this.featureState,"REPEAT",this.componentState):h.transition(this.featureState,"CONTINUE",this.componentState),this.saveState("nextStep",t.value)
var n=h.getStateNodes(this.featureState)
this.executeActions(n.reduce(function(e,t){return e.concat(t.onEntry)},[]),null,"feature")}},startFeature:function(){var e=a.MACHINES[this.featureList.objectAt(0)]
h=(0,t.Machine)(e),this.set("currentMachine",this.featureList.objectAt(0)),this.storageHasKey(o)?this.saveState("featureState",this.getExtState(o)):this.saveState("featureState",h.initialState),this.saveExtState(o,this.featureState)},getCompletedFeatures:function(){return this.storageHasKey(d)?this.getExtState(d).toArray():[]},completeFeature:function(){var e=this.featureList,t=e.shift()
if(this.getExtState(d))this.saveExtState(d,this.getExtState(d).toArray().addObject(t))
else{var n=[]
n.push(t),this.saveExtState(d,n)}this.saveExtState(u,e.length?e:null),this.storage().removeItem(o),this.featureMachineHistory&&(this.set("featureMachineHistory",[]),this.saveExtState(c,[])),e.length>0?this.buildFeatureMachine():(this.storage().removeItem(u),h=null,this.transitionTutorialMachine(this.currentState,"DONE"))},storage:function(){return(0,n.default)()}})}),define("vault/templates/application",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"8u50WRAS",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","page-container"],[9],[0,"\\n  "],[1,[21,"outlet"],false],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/application.hbs"}})}),define("vault/templates/components/alert-popup",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"NVLPpwF8",block:'{"symbols":["@isPreformatted"],"statements":[[7,"div"],[12,"class",[28,["message ",[23,["type","class"]]]]],[9],[0,"\\n  "],[7,"div"],[11,"class","columns is-mobile is-variable is-1"],[9],[0,"\\n    "],[7,"div"],[11,"class","column is-narrow message-icon"],[9],[0,"\\n      "],[5,"icon",[[11,"aria-hidden","true"]],[["@size","@glyph"],["l",[28,[[23,["type","glyph"]]]]]]],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","column"],[9],[0,"\\n      "],[7,"button"],[11,"class","close-button"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["close"]]]],[9],[0,"\\n        "],[5,"icon",[],[["@glyph","@aria-label"],["cancel-plain","Close"]]],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","message-title"],[9],[0,"\\n        "],[1,[23,["type","text"]],false],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[23,["message"]]],null,{"statements":[[0,"        "],[7,"p"],[12,"class",[28,["message-body ",[27,"if",[[22,1,[]],"pre"],null]]]],[9],[1,[21,"message"],false],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/alert-popup.hbs"}})})
define("vault/templates/components/auth-button-auth0",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"oTyxoj+l",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","is-flex-v-centered auth-button-type-auth0"],[9],[0,"\\n  "],[7,"div"],[11,"class","auth-button-tile is-flex-column is-flex-v-centered"],[9],[0,"\\n    "],[7,"svg"],[11,"height","20"],[11,"xmlns","http://www.w3.org/2000/svg","http://www.w3.org/2000/xmlns/"],[11,"viewBox","0 0 193.71 216.56"],[9],[7,"defs"],[9],[7,"style"],[9],[0,".cls-1{fill:#eb5424;}"],[10],[10],[7,"path"],[11,"class","cls-1"],[11,"d","M189,66.92,167.22,0H96.85L118.6,66.92ZM96.85,0H26.49L4.75,66.92H75.11ZM4.75,66.92Zm0,0h0A96.85,96.85,0,0,0,39.93,175.2l21.74-66.92Zm184.21,0h0L132,108.28l21.74,66.92h0A96.85,96.85,0,0,0,189,66.92ZM39.93,175.2h0l56.93,41.36,56.92-41.36L96.85,133.84Z"],[9],[10],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","text"],[9],[0,"\\n    Sign in with Auth0\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/auth-button-auth0.hbs"}})}),define("vault/templates/components/auth-button-gitlab",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"EAMTwUy/",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","is-flex-v-centered auth-button-type-gitlab"],[9],[0,"\\n  "],[7,"svg"],[11,"class","auth-button-tile"],[11,"xmlns","http://www.w3.org/2000/svg","http://www.w3.org/2000/xmlns/"],[11,"viewBox","0 0 586 559"],[9],[7,"defs"],[9],[7,"style"],[9],[0,".cls-1{fill:#fc6d26;}.cls-2{fill:#e24329;}.cls-3{fill:#fca326;}"],[10],[10],[7,"g"],[11,"id","g44"],[9],[7,"path"],[11,"id","path46"],[11,"class","cls-1"],[11,"d","M461.17,301.83l-18.91-58.12L404.84,128.43a6.47,6.47,0,0,0-12.27,0L355.15,243.64H230.82L193.4,128.43a6.46,6.46,0,0,0-12.26,0L143.78,243.64l-18.91,58.19a12.88,12.88,0,0,0,4.66,14.39L293,435,456.44,316.22a12.9,12.9,0,0,0,4.73-14.39"],[9],[10],[10],[7,"g"],[11,"id","g48"],[9],[7,"path"],[11,"id","path50"],[11,"class","cls-2"],[11,"d","M293,434.91h0l62.16-191.28H230.87L293,434.91Z"],[9],[10],[10],[7,"g"],[11,"id","g56"],[9],[7,"path"],[11,"id","path58"],[11,"class","cls-1"],[11,"d","M293,434.91,230.82,243.63h-87L293,434.91Z"],[9],[10],[10],[7,"g"],[11,"id","g64"],[9],[7,"path"],[11,"id","path66"],[11,"class","cls-3"],[11,"d","M143.75,243.69h0l-18.91,58.12a12.88,12.88,0,0,0,4.66,14.39L293,435,143.75,243.69Z"],[9],[10],[10],[7,"g"],[11,"id","g72"],[9],[7,"path"],[11,"id","path74"],[11,"class","cls-2"],[11,"d","M143.78,243.69h87.11L193.4,128.49a6.47,6.47,0,0,0-12.27,0l-37.35,115.2Z"],[9],[10],[10],[7,"g"],[11,"id","g76"],[9],[7,"path"],[11,"id","path78"],[11,"class","cls-1"],[11,"d","M293,434.91l62.16-191.28H442.3L293,434.91Z"],[9],[10],[10],[7,"g"],[11,"id","g80"],[9],[7,"path"],[11,"id","path82"],[11,"class","cls-3"],[11,"d","M442.24,243.69h0l18.91,58.12a12.85,12.85,0,0,1-4.66,14.39L293,434.91l149.2-191.22Z"],[9],[10],[10],[7,"g"],[11,"id","g84"],[9],[7,"path"],[11,"id","path86"],[11,"class","cls-2"],[11,"d","M442.28,243.69h-87.1l37.42-115.2a6.46,6.46,0,0,1,12.26,0l37.42,115.2Z"],[9],[10],[10],[10],[0,"\\n  "],[7,"div"],[11,"class","text"],[9],[0,"\\n    Sign in with GitLab\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/auth-button-gitlab.hbs"}})}),define("vault/templates/components/auth-button-google",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"k2vVIxDY",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","is-flex-v-centered auth-button-type-google"],[9],[0,"\\n"],[7,"svg"],[11,"width","39"],[11,"height","39"],[11,"xmlns","http://www.w3.org/2000/svg","http://www.w3.org/2000/xmlns/"],[11,"xmlns:xlink","http://www.w3.org/1999/xlink","http://www.w3.org/2000/xmlns/"],[11,"viewBox","0 0 46 46"],[9],[0,"\\n  "],[7,"defs"],[9],[0,"\\n    "],[7,"filter"],[11,"x","-50%"],[11,"y","-50%"],[11,"width","200%"],[11,"height","200%"],[11,"filterUnits","objectBoundingBox"],[11,"id","a"],[9],[0,"\\n      "],[7,"feOffset"],[11,"dy","1"],[11,"in","SourceAlpha"],[11,"result","shadowOffsetOuter1"],[9],[10],[0,"\\n      "],[7,"feGaussianBlur"],[11,"stdDeviation",".5"],[11,"in","shadowOffsetOuter1"],[11,"result","shadowBlurOuter1"],[9],[10],[0,"\\n      "],[7,"feColorMatrix"],[11,"values","0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.168 0"],[11,"in","shadowBlurOuter1"],[11,"result","shadowMatrixOuter1"],[9],[10],[0,"\\n      "],[7,"feOffset"],[11,"in","SourceAlpha"],[11,"result","shadowOffsetOuter2"],[9],[10],[0,"\\n      "],[7,"feGaussianBlur"],[11,"stdDeviation",".5"],[11,"in","shadowOffsetOuter2"],[11,"result","shadowBlurOuter2"],[9],[10],[0,"\\n      "],[7,"feColorMatrix"],[11,"values","0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.084 0"],[11,"in","shadowBlurOuter2"],[11,"result","shadowMatrixOuter2"],[9],[10],[0,"\\n      "],[7,"feMerge"],[9],[0,"\\n        "],[7,"feMergeNode"],[11,"in","shadowMatrixOuter1"],[9],[10],[0,"\\n        "],[7,"feMergeNode"],[11,"in","shadowMatrixOuter2"],[9],[10],[0,"\\n        "],[7,"feMergeNode"],[11,"in","SourceGraphic"],[9],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"rect"],[11,"id","b"],[11,"width","40"],[11,"height","40"],[11,"rx","2"],[9],[10],[0,"\\n    "],[7,"rect"],[11,"id","c"],[11,"x","5"],[11,"y","5"],[11,"width","38"],[11,"height","38"],[11,"rx","1"],[9],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"g"],[11,"fill","none"],[11,"fill-rule","evenodd"],[9],[0,"\\n    "],[7,"g"],[11,"transform","translate(3 3)"],[11,"filter","url(#a)"],[9],[0,"\\n      "],[7,"use"],[11,"fill","#4285F4"],[11,"xlink:href","#b","http://www.w3.org/1999/xlink"],[9],[10],[0,"\\n      "],[7,"use"],[11,"xlink:href","#b","http://www.w3.org/1999/xlink"],[9],[10],[0,"\\n      "],[7,"use"],[11,"xlink:href","#b","http://www.w3.org/1999/xlink"],[9],[10],[0,"\\n      "],[7,"use"],[11,"xlink:href","#b","http://www.w3.org/1999/xlink"],[9],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"g"],[11,"transform","translate(-1 -1)"],[9],[0,"\\n      "],[7,"use"],[11,"fill","#FFF"],[11,"xlink:href","#c","http://www.w3.org/1999/xlink"],[9],[10],[0,"\\n      "],[7,"use"],[11,"xlink:href","#c","http://www.w3.org/1999/xlink"],[9],[10],[0,"\\n      "],[7,"use"],[11,"xlink:href","#c","http://www.w3.org/1999/xlink"],[9],[10],[0,"\\n      "],[7,"use"],[11,"xlink:href","#c","http://www.w3.org/1999/xlink"],[9],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"path"],[11,"d","M31.64 23.20454545c0-.63818181-.0572727-1.25181818-.1636364-1.84090909H23V24.845h4.8436364c-.2086364 1.125-.8427273 2.0781818-1.7959091 2.7163636v2.2581819h2.9086363C30.6581818 28.2527273 31.64 25.9454545 31.64 23.20454545z"],[11,"fill","#4285F4"],[9],[10],[0,"\\n    "],[7,"path"],[11,"d","M23 32c2.43 0 4.4672727-.8059091 5.9563636-2.1804545l-2.9086363-2.2581819c-.8059091.54-1.8368182.8590909-3.0477273.8590909-2.34409091 0-4.32818182-1.5831818-5.03590909-3.7104545h-3.00681818v2.3318182C16.43818182 29.9831818 19.48181818 32 23 32z"],[11,"fill","#34A853"],[9],[10],[0,"\\n    "],[7,"path"],[11,"d","M17.96409091 24.71c-.18-.54-.28227273-1.11681818-.28227273-1.71 0-.59318182.10227273-1.17.28227273-1.71v-2.33181818h-3.00681818C14.34772727 20.17318182 14 21.54772727 14 23c0 1.4522727.34772727 2.8268182.95727273 4.0418182L17.9640909 24.71z"],[11,"fill","#FBBC05"],[9],[10],[0,"\\n    "],[7,"path"],[11,"d","M23 17.57954545c1.3213636 0 2.5077273.45409091 3.4404545 1.3459091l2.5813637-2.58136364C27.4631818 14.89181818 25.4259091 14 23 14c-3.51818182 0-6.56181818 2.01681818-8.04272727 4.95818182L17.9640909 21.29C18.67181818 19.16272727 20.65590909 17.57954545 23 17.57954545z"],[11,"fill","#EA4335"],[9],[10],[0,"\\n    "],[7,"path"],[11,"d","M14 14h18v18H14V14z"],[9],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n\\n"],[7,"div"],[11,"class","is-flex-1 text"],[9],[0,"\\nSign in with Google\\n"],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/auth-button-google.hbs"}})}),define("vault/templates/components/auth-config-form/config",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"FDSH1GJM",block:'{"symbols":["attr"],"statements":[[7,"form"],[3,"action",[[22,0,[]],[27,"perform",[[23,["saveModel"]]],null]],[["on"],["submit"]]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["save","Auth Method"]]],[0,"\\n    "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n"],[4,"if",[[23,["model","attrs"]]],null,{"statements":[[4,"each",[[23,["model","attrs"]]],null,{"statements":[[0,"        "],[1,[27,"form-field",null,[["attr","model"],[[22,1,[]],[23,["model"]]]]],false],[0,"\\n"]],"parameters":[1]},null]],"parameters":[]},{"statements":[[4,"if",[[23,["model","fieldGroups"]]],null,{"statements":[[0,"      "],[1,[27,"form-field-groups",null,[["model","mode"],[[23,["model"]],[23,["mode"]]]]],false],[0,"\\n    "]],"parameters":[]},null]],"parameters":[]}],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["saveModel","isRunning"]],"loading"],null]]]],[12,"disabled",[23,["saveModel","isRunning"]]],[11,"type","submit"],[9],[0,"\\n      Save\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10]],"hasEval":false}',meta:{moduleName:"vault/templates/components/auth-config-form/config.hbs"}})}),define("vault/templates/components/auth-config-form/options",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"M30TLlNh",block:'{"symbols":["attr"],"statements":[[7,"form"],[3,"action",[[22,0,[]],[27,"perform",[[23,["saveModel"]]],null]],[["on"],["submit"]]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["save","Auth Method"]]],[0,"\\n    "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n"],[4,"each",[[23,["model","tuneAttrs"]]],null,{"statements":[[0,"      "],[1,[27,"form-field",null,[["attr","model"],[[22,1,[]],[23,["model"]]]]],false],[0,"\\n"]],"parameters":[1]},null],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["saveModel","isRunning"]],"loading"],null]]]],[12,"disabled",[23,["saveModel","isRunning"]]],[11,"type","submit"],[9],[0,"\\n      Update Options\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10]],"hasEval":false}',meta:{moduleName:"vault/templates/components/auth-config-form/options.hbs"}})}),define("vault/templates/components/auth-form-options",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"YRf+cFic",block:'{"symbols":["@customPath","@onPathChange"],"statements":[[4,"if",[[27,"not",[[22,0,["selectedAuthIsPath"]]],null]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box has-slim-padding is-shadowless"],[9],[0,"\\n    "],[5,"toggle-button",[],[["@toggleTarget","@toggleAttr"],[[22,0,[]],"isOpen"]]],[0,"\\n"],[4,"if",[[22,0,["isOpen"]]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","custom-path"],[11,"class","is-label"],[9],[0,"\\n          Mount path\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"input"],[11,"name","custom-path"],[11,"id","custom-path"],[11,"class","input"],[12,"value",[22,1,[]]],[12,"oninput",[27,"action",[[22,0,[]],[22,2,[]]],[["value"],["target.value"]]]],[11,"type","text"],[9],[10],[0,"\\n        "],[10],[0,"\\n        "],[5,"alert-inline",[],[["@type","@message"],["info","If this backend was mounted using a non-default path, enter it here."]]],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/auth-form-options.hbs"}})}),define("vault/templates/components/auth-form",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"1MbYilHl",block:'{"symbols":["method","method","methodKey"],"statements":[[7,"div"],[11,"class","auth-form"],[9],[0,"\\n"],[4,"if",[[23,["showLoading"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","vault-loader"],[9],[0,"\\n      "],[5,"vault-logo-spinner",[],[[],[]]],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["hasMethodsWithPath"]]],null,{"statements":[[0,"    "],[7,"nav"],[11,"class","tabs is-marginless"],[9],[0,"\\n      "],[7,"ul"],[9],[0,"\\n"],[4,"each",[[23,["methodsToShow"]]],null,{"statements":[[4,"with",[[27,"or",[[22,2,["path"]],[22,2,["type"]]],null]],null,{"statements":[[0,"              "],[7,"li"],[12,"class",[28,[[27,"if",[[27,"and",[[23,["selectedAuthIsPath"]],[27,"eq",[[27,"or",[[23,["selectedAuthBackend","path"]],[23,["selectedAuthBackend","type"]]],null],[22,3,[]]],null]],null],"is-active",""],null]]]],[9],[0,"\\n"],[4,"link-to",["vault.cluster.auth",[23,["cluster","name"]],[27,"query-params",null,[["with"],[[22,3,[]]]]]],null,{"statements":[[0,"                  "],[1,[27,"or",[[22,2,["id"]],[27,"capitalize",[[22,2,["type"]]],null]],null],false],[0,"\\n"]],"parameters":[]},null],[0,"              "],[10],[0,"\\n"]],"parameters":[3]},null]],"parameters":[2]},null],[4,"if",[[23,["hasMethodsWithPath"]]],null,{"statements":[[0,"          "],[7,"li"],[12,"class",[28,[[27,"if",[[27,"not",[[23,["selectedAuthIsPath"]]],null],"is-active",""],null]]]],[9],[0,"\\n"],[4,"link-to",["vault.cluster.auth",[23,["cluster","name"]],[27,"query-params",null,[["with"],["token"]]]],null,{"statements":[[0,"              Other\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[7,"div"],[11,"class","box is-marginless is-shadowless"],[9],[0,"\\n    "],[5,"message-error",[],[["@errorMessage"],[[27,"if",[[27,"and",[[23,["cluster","standby"]],[23,["hasCSPError"]]],null],[23,["cspErrorText"]],[23,["error"]]],null]]]],[0,"\\n"],[4,"if",[[27,"or",[[27,"not",[[23,["hasMethodsWithPath"]]],null],[27,"not",[[23,["selectedAuthIsPath"]]],null]],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","selectedMethod"],[11,"class","is-label"],[9],[0,"\\n          Method\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n          "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n            "],[7,"select"],[11,"name","selectedMethod"],[11,"id","selectedMethod"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["selectedAuth"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"supported-auth-backends",null,null]],null,{"statements":[[0,"                "],[7,"option"],[12,"selected",[27,"eq",[[23,["selectedAuthBackend","type"]],[22,1,["type"]]],null]],[12,"value",[22,1,["type"]]],[9],[0,"\\n                  "],[1,[22,1,["typeDisplay"]],false],[0,"\\n                "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"or",[[27,"eq",[[22,0,["selectedAuthBackend","type"]],"jwt"],null],[27,"eq",[[22,0,["selectedAuthBackend","type"]],"oidc"],null]],null]],null,{"statements":[[0,"    "],[5,"auth-jwt",[],[["@onError","@onLoading","@onToken","@namespace","@onNamespace","@onSelectedAuth","@onSubmit","@onRoleName","@roleName","@selectedAuthType","@selectedAuthPath","@disabled"],[[27,"action",[[22,0,[]],"handleError"],null],[27,"action",[[22,0,[]],[27,"mut",[[22,0,["isLoading"]]],null]],null],[27,"action",[[22,0,[]],[27,"mut",[[22,0,["token"]]],null]],null],[22,0,["namespace"]],[27,"action",[[22,0,[]],[27,"mut",[[22,0,["namespace"]]],null]],null],[27,"action",[[22,0,[]],[27,"mut",[[22,0,["selectedAuth"]]],null]],null],[27,"action",[[22,0,[]],"doSubmit"],null],[27,"action",[[22,0,[]],[27,"mut",[[22,0,["roleName"]]],null]],null],[22,0,["roleName"]],[22,0,["selectedAuthBackend","type"]],[27,"or",[[22,0,["customPath"]],[22,0,["selectedAuthBackend","id"]]],null],[23,["authenticate","isRunning"]]]],{"statements":[[0,"\\n      "],[5,"auth-form-options",[],[["@customPath","@onPathChange","@selectedAuthIsPath"],[[22,0,["customPath"]],[27,"action",[[22,0,[]],[27,"mut",[[22,0,["customPath"]]],null]],null],[22,0,["selectedAuthIsPath"]]]]],[0,"\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"form"],[11,"id","auth-form"],[12,"onsubmit",[27,"action",[[22,0,[]],"doSubmit"],null]],[9],[0,"\\n        "],[15,[23,["providerPartialName"]],[]],[0,"\\n"],[4,"if",[[27,"not-eq",[[23,["selectedAuthBackend","type"]],"token"],null]],null,{"statements":[[0,"          "],[5,"auth-form-options",[],[["@customPath","@onPathChange","@selectedAuthIsPath"],[[22,0,["customPath"]],[27,"action",[[22,0,[]],[27,"mut",[[22,0,["customPath"]]],null]],null],[22,0,["selectedAuthIsPath"]]]]],[0,"\\n"]],"parameters":[]},null],[0,"        "],[7,"button"],[12,"disabled",[23,["authenticate","isRunning"]]],[12,"class",[28,["button is-primary ",[27,"if",[[23,["authenticate","isRunning"]],"is-loading"],null]]]],[11,"id","auth-submit"],[11,"type","submit"],[9],[0,"\\n          Sign In\\n        "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":true}',meta:{moduleName:"vault/templates/components/auth-form.hbs"}})}),define("vault/templates/components/auth-info",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"U9Mq3WT1",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","popup-menu-content"],[9],[0,"\\n  "],[7,"div"],[11,"class","box"],[9],[0,"\\n    "],[7,"div"],[11,"class","menu-label"],[9],[0,"\\n      "],[1,[23,["auth","authData","displayName"]],false],[0,"\\n    "],[10],[0,"\\n    "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n      "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n"],[4,"if",[[23,["canExpire"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[5,"alert-banner",[],[["@type","@message"],["warning",[28,["We\'ve stopped auto-renewing your token due to inactivity.\\n                It will expire in ",[27,"date-from-now",[[23,["auth","tokenExpirationDate"]]],[["interval","hideSuffix"],[1000,true]]],".\\n                on ",[27,"date-format",[[23,["auth","tokenExpirationDate"]],"MMMM Do YYYY, h:mm:ss a"],null]]]]]],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},null],[0,"        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[7,"button"],[11,"class","link"],[12,"onclick",[27,"action",[[22,0,[]],"restartGuide"],null]],[11,"type","button"],[9],[0,"\\n            Restart guide\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[5,"copy-button",[[11,"class","link"]],[["@clipboardText","@buttonType","@success"],[[23,["auth","currentToken"]],"button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Token copied!"],null]],null]]],{"statements":[[0,"\\n            Copy token\\n          "]],"parameters":[]}],[0,"\\n        "],[10],[0,"\\n"],[4,"if",[[27,"is-before",[[27,"now",null,[["interval"],[1000]]],[23,["auth","tokenExpirationDate"]]],null]],null,{"statements":[[4,"if",[[23,["auth","authData","renewable"]]],null,{"statements":[[0,"            "],[7,"li"],[11,"class","action"],[9],[0,"\\n              "],[7,"button"],[12,"class",[28,["link button ",[27,"if",[[23,["isRenewing"]],"is-loading"],null]]]],[11,"type","button"],[3,"action",[[22,0,[]],"renewToken"]],[9],[0,"\\n                Renew token\\n              "],[10],[0,"\\n            "],[10],[0,"\\n            "],[7,"li"],[11,"class","action"],[9],[0,"\\n              "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@onConfirmAction"],["button link is-destroy",[27,"concat",["Revoke ",[27,"get",[[23,["auth"]],"authData.displayName"],null],"?"],null],[27,"concat",["You will not be able to log in again with this token."],null],"Revoke",[27,"action",[[22,0,[]],"revokeToken"],null]]],{"statements":[[0,"\\n                Revoke token\\n              "]],"parameters":[]}],[0,"\\n            "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"            "],[7,"li"],[11,"class","action text-right"],[9],[0,"\\n              "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@onConfirmAction"],["button link is-destroy",[27,"concat",["Revoke ",[27,"get",[[23,["auth"]],"authData.displayName"],null],"?"],null],[27,"concat",["You will not be able to log in again with this token."],null],"Revoke",[27,"action",[[22,0,[]],"revokeToken"],null]]],{"statements":[[0,"\\n                Revoke token\\n              "]],"parameters":[]}],[0,"\\n            "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]},null],[0,"        "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.logout",[23,["activeClusterName"]]],[["id","class","invokeAction"],["logout","is-destroy",[23,["onLinkClick"]]]],{"statements":[[0,"            Sign out\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/auth-info.hbs"}})}),define("vault/templates/components/auth-jwt",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"OpcAI2ME",block:'{"symbols":["@onSubmit","@roleName","&default","@disabled"],"statements":[[7,"form"],[11,"id","auth-form"],[12,"onsubmit",[27,"action",[[22,0,[]],[27,"if",[[22,0,["isOIDC"]],"startOIDCAuth",[22,1,[]]],null],[27,"hash",null,[["role","jwt"],[[23,["roleName"]],[23,["jwt"]]]]]],null]],[9],[0,"\\n  "],[7,"div"],[11,"class","field"],[9],[0,"\\n    "],[7,"label"],[11,"for","role"],[11,"class","is-label"],[9],[0,"Role"],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"input"],[12,"value",[22,2,[]]],[11,"placeholder","Default"],[12,"oninput",[27,"perform",[[22,0,["fetchRole"]]],[["value"],["target.value"]]]],[11,"autocomplete","off"],[11,"spellcheck","false"],[11,"name","role"],[11,"id","role"],[11,"class","input"],[11,"type","text"],[9],[10],[0,"\\n    "],[10],[0,"\\n    "],[5,"alert-inline",[],[["@type","@message"],["info","Leave blank to sign in with the default role if one is configured"]]],[0,"\\n  "],[10],[0,"\\n"],[4,"unless",[[22,0,["isOIDC"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","token"],[11,"class","is-label"],[9],[0,"JWT Token"],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"input",null,[["type","value","name","class","autocomplete","spellcheck"],["password",[23,["jwt"]],"jwt","input","off","false"]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[7,"div"],[9],[0,"\\n    "],[14,3],[0,"\\n  "],[10],[0,"\\n  "],[7,"button"],[12,"disabled",[22,4,[]]],[12,"class",[28,["button is-primary ",[27,"if",[[22,4,[]],"is-loading"],null]]]],[11,"id","auth-submit"],[11,"type","submit"],[9],[0,"\\n"],[4,"if",[[22,0,["isOIDC"]]],null,{"statements":[[4,"if",[[22,0,["role","providerButtonComponent"]]],null,{"statements":[[0,"        "],[1,[27,"component",[[22,0,["role","providerButtonComponent"]]],null],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      Sign in with "],[1,[27,"or",[[22,0,["role","providerName"]],"OIDC Provider"],null],false],[0,"\\n"]],"parameters":[]}]],"parameters":[]},{"statements":[[0,"      Sign In\\n"]],"parameters":[]}],[0,"  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/auth-jwt.hbs"}})}),define("vault/templates/components/auth-method/configuration",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"4iyUNNx+",block:'{"symbols":["attr"],"statements":[[7,"div"],[11,"class","box is-fullwidth is-sideless is-paddingless is-marginless"],[9],[0,"\\n"],[4,"each",[[23,["model","attrs"]]],null,{"statements":[[4,"if",[[27,"eq",[[22,1,["type"]],"object"],null]],null,{"statements":[[0,"      "],[1,[27,"info-table-row",null,[["alwaysRender","label","value"],[true,[27,"or",[[22,1,["options","label"]],[27,"to-label",[[22,1,["name"]]],null]],null],[27,"stringify",[[27,"get",[[23,["model"]],[22,1,["name"]]],null]],null]]]],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[1,[27,"info-table-row",null,[["alwaysRender","label","value"],[true,[27,"or",[[22,1,["options","label"]],[27,"to-label",[[22,1,["name"]]],null]],null],[27,"get",[[23,["model"]],[22,1,["name"]]],null]]]],false],[0,"\\n"]],"parameters":[]}]],"parameters":[1]},null],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/auth-method/configuration.hbs"}})}),define("vault/templates/components/b64-toggle",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"PTxjE4W8",block:'{"symbols":[],"statements":[[4,"if",[[23,["isBase64"]]],null,{"statements":[[0,"  Decode from base64\\n"]],"parameters":[]},{"statements":[[0,"  Encode to base64\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/b64-toggle.hbs"}})}),define("vault/templates/components/backend-configure",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"NAtimjD1",block:'{"symbols":[],"statements":[],"hasEval":false}',meta:{moduleName:"vault/templates/components/backend-configure.hbs"}})}),define("vault/templates/components/block-error",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"2dLKvjAZ",block:'{"symbols":["&default"],"statements":[[7,"div"],[11,"class","box is-sideless has-background-white-bis has-text-grey has-text-centered"],[9],[0,"\\n"],[14,1],[0,"\\n"],[10]],"hasEval":false}',meta:{moduleName:"vault/templates/components/block-error.hbs"}})}),define("vault/templates/components/config-pki-ca",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"12xk2O+l",block:'{"symbols":["dl","attr","attr"],"statements":[[4,"if",[[23,["replaceCA"]]],null,{"statements":[[0,"  "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n  "],[7,"h2"],[11,"class","title is-3"],[9],[0,"\\n"],[4,"if",[[23,["needsConfig"]]],null,{"statements":[[0,"      Configure CA Certificate\\n"]],"parameters":[]},{"statements":[[0,"      Replace CA Certificate\\n"]],"parameters":[]}],[0,"  "],[10],[0,"\\n"],[4,"if",[[27,"or",[[23,["model","certificate"]],[23,["model","csr"]]],null]],null,{"statements":[[4,"each",[[23,["model","attrs"]]],null,{"statements":[[0,"      "],[1,[27,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,3,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,3,["name"]]],null]],null]],null]],null],[27,"get",[[23,["model"]],[22,3,["name"]]],null]]]],false],[0,"\\n"]],"parameters":[3]},null],[0,"    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[27,"or",[[23,["model","certificate"]],[23,["model","csr"]]],null],"button","button",[27,"action",[[22,0,[]],[27,"set-flash-message",[[27,"concat",[[27,"if",[[23,["model","certificate"]],"Certificate","CSR"],null]," copied!"],null]],null]],null]]],{"statements":[[0,"          Copy "],[1,[27,"if",[[23,["model","certificate"]],"Certificate","CSR"],null],false],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"refresh"]],[9],[0,"\\n          Back\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"form"],[3,"action",[[22,0,[]],"saveCA"],[["on"],["submit"]]],[9],[0,"\\n      "],[5,"namespace-reminder",[],[["@mode","@noun"],["save","PKI change"]]],[0,"\\n"],[4,"if",[[23,["model","uploadPemBundle"]]],null,{"statements":[[0,"        "],[5,"alert-banner",[],[["@type","@message"],["warning","If you have already set a certificate and key, they will be overridden with the successful saving of a new PEM bundle."]]],[0,"\\n"]],"parameters":[]},null],[0,"      "],[15,"partials/form-field-groups-loop",[]],[0,"\\n      "],[7,"div"],[11,"class","field is-grouped is-grouped-split box is-fullwidth is-bottomless"],[9],[0,"\\n        "],[7,"div"],[11,"class","field is-grouped"],[9],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["loading"]],"is-loading"],null]]]],[12,"disabled",[21,"loading"]],[11,"type","submit"],[9],[0,"\\n              Save\\n            "],[10],[0,"\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"toggleReplaceCA"]],[9],[0,"\\n              Cancel\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"if",[[23,["model","canDeleteRoot"]]],null,{"statements":[[0,"            "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@onConfirmAction"],["button","Delete this CA key?","This CA certificate will still be available for reading until a new certificate/key are generated or uploaded.",[27,"action",[[22,0,[]],"deleteCA"],null]]],{"statements":[[0,"\\n              Delete\\n            "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]},{"statements":[[4,"if",[[23,["signIntermediate"]]],null,{"statements":[[4,"if",[[27,"or",[[23,["model","certificate"]]],null]],null,{"statements":[[0,"    "],[5,"alert-banner",[],[["@type","@message"],["warning","If using this for an Intermediate CA in Vault, copy the certificate below and write it to the PKI mount being used as an intermediate using the `Set signed Intermediate` endpoint."]]],[0,"\\n"],[4,"each",[[23,["model","attrs"]]],null,{"statements":[[0,"      "],[1,[27,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,2,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,2,["name"]]],null]],null]],null]],null],[27,"get",[[23,["model"]],[22,2,["name"]]],null]]]],false],[0,"\\n"]],"parameters":[2]},null],[0,"    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[23,["model","certificate"]],"button","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Certificate copied!"],null]],null]]],{"statements":[[0,"          Copy Certificate\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"refresh"]],[9],[0,"\\n          Back\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"h2"],[11,"class","title is-3"],[9],[0,"Sign intermediate"],[10],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["save","PKI change"]]],[0,"\\n    "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n    "],[7,"form"],[3,"action",[[22,0,[]],"saveCA"],[["on"],["submit"]]],[9],[0,"\\n      "],[15,"partials/form-field-groups-loop",[]],[0,"\\n      "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["loading"]],"is-loading"],null]]]],[12,"disabled",[21,"loading"]],[11,"type","submit"],[9],[0,"\\n            Save\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"toggleVal","signIntermediate",false]],[9],[0,"\\n            Cancel\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]},{"statements":[[4,"if",[[23,["setSignedIntermediate"]]],null,{"statements":[[0,"  "],[7,"h2"],[11,"class","title is-3"],[9],[0,"Set signed intermediate"],[10],[0,"\\n  "],[5,"namespace-reminder",[],[["@mode","@noun"],["save","PKI change"]]],[0,"\\n  "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n    "],[7,"p"],[11,"class","has-text-grey-dark"],[9],[0,"\\n      Submit a signed CA certificate corresponding to a generated private key.\\n    "],[10],[0,"\\n  "],[7,"form"],[3,"action",[[22,0,[]],"saveCA","setSignedIntermediate"],[["on"],["submit"]]],[9],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","certificate"],[11,"class","is-label"],[9],[0,"\\n        Signed Intermediate Certificate\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"textarea",null,[["class","id","name","value"],["textarea","certificate","certificate",[23,["model","certificate"]]]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["loading"]],"is-loading"],null]]]],[12,"disabled",[21,"loading"]],[11,"type","submit"],[9],[0,"\\n          Save\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"toggleVal","setSignedIntermediate",false]],[9],[0,"\\n          Cancel\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"p"],[11,"class","has-text-grey-dark"],[9],[0,"\\n    This is the default CA certificate used in Vault. It is not used for self-signed certificates or if you have a signed intermediate CA certificate with a generated key.\\n  "],[10],[0,"\\n"],[4,"each",[[23,["downloadHrefs"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","box is-shadowless is-marginless is-fullwidth has-slim-padding"],[9],[0,"\\n      "],[7,"a"],[12,"href",[22,1,["url"]]],[12,"download",[22,1,["name"]]],[9],[0,"\\n        "],[1,[22,1,["display"]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-shadowless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"toggleReplaceCA"]],[9],[0,"\\n"],[4,"if",[[23,["needsConfig"]]],null,{"statements":[[0,"          Configure CA\\n"]],"parameters":[]},{"statements":[[0,"          Replace CA\\n"]],"parameters":[]}],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n"],[4,"if",[[23,["config","pem"]]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"toggleVal","signIntermediate"]],[9],[0,"\\n          Sign intermediate\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"toggleVal","setSignedIntermediate"]],[9],[0,"\\n        Set signed intermediate\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]}]],"parameters":[]}]],"hasEval":true}',meta:{moduleName:"vault/templates/components/config-pki-ca.hbs"}})}),define("vault/templates/components/config-pki",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"wOeVkKXz",block:'{"symbols":["attr"],"statements":[[5,"namespace-reminder",[],[["@mode","@noun"],["save","PKI change"]]],[0,"\\n\\n"],[4,"if",[[27,"eq",[[23,["section"]],"tidy"],null]],null,{"statements":[[0,"  "],[7,"p"],[11,"class","has-text-grey-dark"],[9],[0,"\\n    You can tidy up the backend storage and/or CRL by removing certificates that have expired and are past a certain buffer period beyond their expiration time.\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["section"]],"crl"],null]],null,{"statements":[[0,"  "],[7,"h2"],[11,"class","title is-5"],[9],[0,"\\n    Certificate Revocation List (CRL) config\\n  "],[10],[0,"\\n  "],[7,"p"],[11,"class","has-text-grey-dark"],[9],[0,"\\n    Set the duration for which the generated CRL should be marked valid.\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}],[0,"\\n"],[1,[27,"message-error",null,[["model"],[[23,["config"]]]]],false],[0,"\\n"],[7,"form"],[11,"class","box is-shadowless is-marginless is-fullwidth has-slim-padding"],[3,"action",[[22,0,[]],"save",[23,["section"]]],[["on"],["submit"]]],[9],[0,"\\n"],[4,"each",[[27,"get",[[23,["config"]],[27,"concat",[[23,["section"]],"Attrs"],null]],null]],null,{"statements":[[0,"    "],[1,[27,"form-field",null,[["attr","model"],[[22,1,[]],[23,["config"]]]]],false],[0,"\\n"]],"parameters":[1]},null],[0,"  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["loading"]],"is-loading"],null]]]],[12,"disabled",[21,"loading"]],[11,"type","submit"],[9],[0,"\\n        Save\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/config-pki.hbs"}})}),define("vault/templates/components/console/command-input",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"uxkw99A9",block:'{"symbols":["d"],"statements":[[7,"div"],[11,"class","console-ui-input"],[9],[0,"\\n"],[4,"if",[[23,["isRunning"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","control console-spinner is-loading"],[9],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[5,"chevron",[],[[],[]]],[0,"\\n"]],"parameters":[]}],[0,"  "],[7,"input"],[12,"onkeyup",[27,"action",[[22,0,[]],"handleKeyUp"],null]],[12,"value",[21,"value"]],[11,"autocomplete","off"],[11,"spellcheck","false"],[9],[10],[0,"\\n"],[4,"tool-tip",null,[["horizontalPosition","verticalPosition"],["auto-right",[27,"if",[[23,["isFullscreen"]],"above","below"],null]]],{"statements":[[4,"component",[[22,1,["trigger"]]],[["tagName","type","class","click"],["button","button",[27,"concat",["button is-compact",[27,"if",[[23,["isFullscreen"]]," active"],null]],null],[27,"action",[[22,0,[]],"fullscreen"],null]]],{"statements":[[0,"    "],[5,"icon",[[12,"aria-label",[27,"if",[[23,["isFullscreen"]],"Minimize","Maximize"],null]]],[["@size","@glyph"],["l",[27,"if",[[23,["isFullscreen"]],"expand-less","expand-more"],null]]]],[0,"\\n"]],"parameters":[]},null],[4,"component",[[22,1,["content"]]],[["class"],["tool-tip"]],{"statements":[[0,"      "],[7,"div"],[11,"class","box"],[9],[0,"\\n"],[4,"if",[[23,["isFullscreen"]]],null,{"statements":[[0,"        Minimize\\n"]],"parameters":[]},{"statements":[[0,"        Maximize\\n"]],"parameters":[]}],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null],[10],[0,"\\n"],[5,"namespace-reminder",[],[["@class","@mode","@noun"],["console-reminder","execute","command"]]],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/command-input.hbs"}})}),define("vault/templates/components/console/log-command",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"dkVXH2Pw",block:'{"symbols":[],"statements":[[7,"pre"],[11,"class","console-ui-command"],[9],[5,"icon",[[11,"aria-hidden","true"]],[["@glyph"],["chevron-right"]]],[1,[21,"content"],false],[10],[0,""]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/log-command.hbs"}})}),define("vault/templates/components/console/log-error-with-html",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Jg9wpvlf",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","console-ui-alert has-text-danger"],[9],[0,"\\n  "],[5,"icon",[[11,"aria-hidden","true"]],[["@glyph"],["cancel-circle-fill"]]],[0,"\\n  "],[7,"pre"],[9],[1,[21,"content"],true],[10],[0,""],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/log-error-with-html.hbs"}})}),define("vault/templates/components/console/log-error",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"TSnZWPv8",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","console-ui-alert has-text-danger"],[9],[0,"\\n  "],[5,"icon",[[11,"aria-hidden","true"]],[["@glyph"],["cancel-circle-fill"]]],[0,"\\n  "],[7,"pre"],[9],[1,[21,"content"],false],[10],[0,""],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/log-error.hbs"}})}),define("vault/templates/components/console/log-help",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"EqjNumdA",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","console-ui-alert has-text-grey"],[9],[0,"\\n"],[5,"icon",[[11,"aria-hidden","true"]],[["@glyph"],["info-circle-fill"]]],[0,"\\n"],[7,"pre"],[9],[0,"Usage: vault <command> [args]\\n\\nCommands:\\n  read        Read data and retrieves secrets\\n  write       Write data, configuration, and secrets\\n  delete      Delete secrets and configuration\\n  list        List data or secrets\\n\\nWeb CLI Commands:\\n  api         Navigate to the Vault API explorer. Use \'api [filter]\' to prefilter the list.\\n  clear       Clear output from the log\\n  clearall    Clear output and command history\\n  fullscreen  Toggle fullscreen display\\n  refresh     Refresh the data on the current screen under the CLI window\\n"],[10],[0,""],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/log-help.hbs"}})}),define("vault/templates/components/console/log-json",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"gfjQlchJ",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","console-ui-output has-copy-button"],[9],[0,"\\n  "],[1,[27,"json-editor",null,[["value","options"],[[27,"stringify",[[23,["content"]]],null],[27,"hash",null,[["readOnly","lineNumbers","autoHeight","gutters","theme"],[true,false,true,false,"hashi auto-height"]]]]]],false],[0,"\\n  "],[5,"hover-copy-button",[],[["@copyValue"],[[27,"stringify",[[23,["content"]]],null]]]],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/log-json.hbs"}})}),define("vault/templates/components/console/log-list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"RMOg0sLK",block:'{"symbols":["item"],"statements":[[7,"div"],[11,"class","console-ui-output has-copy-button"],[9],[0,"\\n"],[7,"pre"],[9],[0,"Keys\\n"],[4,"each",[[23,["list"]]],null,{"statements":[[1,[22,1,[]],false],[0,"\\n"]],"parameters":[1]},null],[10],[0,""],[5,"hover-copy-button",[],[["@copyValue"],[[27,"multi-line-join",[[23,["list"]]],null]]]],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/log-list.hbs"}})}),define("vault/templates/components/console/log-object",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"kzY1ghtC",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","console-ui-output has-copy-button"],[9],[0,"\\n"],[7,"pre"],[9],[1,[21,"columns"],false],[10],[0,""],[5,"hover-copy-button",[],[["@copyValue"],[[21,"columns"]]]],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/log-object.hbs"}})}),define("vault/templates/components/console/log-success",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"ns2cKu6n",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","console-ui-alert has-text-success"],[9],[0,"\\n  "],[5,"icon",[[11,"aria-hidden","true"]],[["@glyph"],["check-circle-fill"]]],[0,"\\n  "],[7,"pre"],[9],[1,[21,"content"],false],[10],[0,""],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/log-success.hbs"}})}),define("vault/templates/components/console/log-text",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"HlGREayQ",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","console-ui-output has-copy-button"],[9],[0,"\\n"],[7,"pre"],[9],[1,[21,"content"],false],[10],[0,""],[5,"hover-copy-button",[],[["@copyValue","@alwaysShow"],[[21,"content"],"true"]]],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/log-text.hbs"}})}),define("vault/templates/components/console/output-log",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"CbBzl3Np",block:'{"symbols":["message"],"statements":[[4,"each",[[23,["log"]]],null,{"statements":[[4,"unless",[[22,1,["hidden"]]],null,{"statements":[[0,"    "],[1,[27,"component",[[27,"concat",["console/log-",[22,1,["type"]]],null]],[["content"],[[22,1,["content"]]]]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/output-log.hbs"}})}),define("vault/templates/components/console/ui-panel",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"b08E9TIj",block:'{"symbols":[],"statements":[[7,"button"],[11,"class","button is-ghost console-close-button"],[11,"type","button"],[3,"action",[[22,0,[]],"closeConsole"]],[9],[0,"\\n  "],[5,"icon",[[11,"aria-label","Close console"]],[["@glyph"],["cancel-plain"]]],[0,"\\n"],[10],[0,"\\n"],[7,"div"],[11,"class","console-ui-panel-content"],[9],[0,"\\n  "],[7,"div"],[11,"class","content"],[9],[0,"\\n    "],[7,"p"],[11,"class","has-text-grey is-font-mono"],[9],[0,"\\n      The Vault Browser CLI provides an easy way to execute the most common CLI commands, such as write, read, delete, and list.\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[1,[27,"console/output-log",null,[["log"],[[23,["log"]]]]],false],[0,"\\n  "],[1,[27,"console/command-input",null,[["isFullscreen","isRunning","value","onValueUpdate","onFullscreen","onExecuteCommand","onShiftCommand"],[[23,["isFullscreen"]],[23,["isRunning"]],[23,["inputValue"]],[27,"action",[[22,0,[]],[27,"mut",[[23,["inputValue"]]],null]],null],[27,"action",[[22,0,[]],"toggleFullscreen"],null],[27,"action",[[22,0,[]],"executeCommand"],null],[27,"action",[[22,0,[]],"shiftCommandIndex"],null]]]],false],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/console/ui-panel.hbs"}})}),define("vault/templates/components/control-group-success",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"uv1Xseqf",block:'{"symbols":[],"statements":[[4,"if",[[27,"and",[[23,["controlGroupResponse","token"]],[23,["controlGroupResponse","uiParams","url"]]],null]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","control-group-success"],[9],[0,"\\n    You have been granted access to "],[7,"code"],[9],[1,[23,["model","requestPath"]],false],[10],[0,". Be careful, you can only access this data once.\\n    If you need access again in the future you will need to get authorized again.\\n    "],[7,"div"],[11,"class","box is-shadowless is-fullwidth is-marginless has-slim-padding"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[11,"type","button"],[3,"action",[[22,0,[]],[27,"perform",[[23,["markAndNavigate"]]],null]]],[9],[0,"Visit"],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["unwrapData"]]],null,{"statements":[[0,"    "],[7,"div"],[12,"class",[28,["control-group-success ",[27,"if",[[23,["unwrapData"]],"is-editor"],null]]]],[9],[0,"\\n      "],[7,"div"],[11,"class","has-copy-button"],[9],[0,"\\n        "],[5,"json-editor",[],[["@value","@options"],[[27,"stringify",[[23,["unwrapData"]]],null],[27,"hash",null,[["readOnly","lineNumbers","autoHeight","gutters","theme"],[true,false,true,false,"hashi-read-only auto-height"]]]]]],[0,"\\n        "],[5,"hover-copy-button",[],[["@copyValue"],[[27,"stringify",[[23,["unwrapData"]]],null]]]],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.control-groups"],[["class"],["button"]],{"statements":[[0,"        "],[5,"chevron",[],[["@direction"],["left"]]],[0," Back\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","control-group-success"],[9],[0,"\\n      "],[7,"form"],[3,"action",[[22,0,[]],[27,"perform",[[23,["unwrap"]],[23,["token"]]],null]],[["on"],["submit"]]],[9],[0,"\\n        "],[1,[27,"message-error",null,[["errorMessage"],[[23,["error"]]]]],false],[0,"\\n          "],[7,"p"],[9],[0,"\\n          If you have the token, you can now can access "],[7,"code"],[9],[1,[23,["model","requestPath"]],false],[10],[0,"\\n          "],[10],[0,"\\n          "],[7,"label"],[11,"for","token"],[11,"class","is-label"],[9],[0,"\\n            Token to access data\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"input",null,[["class","autocomplete","spellcheck","name","value"],["input","off","false","token",[23,["token"]]]]],false],[0,"\\n          "],[10],[0,"\\n        "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n          "],[7,"button"],[11,"class","button is-primary"],[12,"disabled",[27,"not",[[23,["token"]]],null]],[11,"type","submit"],[9],[0,"\\n            Access\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/control-group-success.hbs"}})}),define("vault/templates/components/control-group",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"+vrb6n1z",block:'{"symbols":["authorization","index"],"statements":[[7,"div"],[11,"class","box is-fullwidth is-bottomless is-sideless"],[9],[0,"\\n  "],[5,"message-error",[],[["@model"],[[21,"model"]]]],[0,"\\n  "],[7,"div"],[12,"class",[28,["control-group-header ",[27,"if",[[23,["isSuccess"]],"is-success"],null]]]],[9],[0,"\\n    "],[7,"p"],[9],[0,"\\n      "],[5,"icon",[],[["@glyph"],[[27,"if",[[23,["isSuccess"]],"check-circle-fill","lock-closed"],null]]]],[0,"\\n      "],[7,"strong"],[9],[1,[21,"bannerPrefix"],false],[10],[0,"\\n      "],[7,"span"],[9],[1,[21,"bannerText"],false],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[4,"if",[[27,"and",[[23,["model","approved"]],[27,"not",[[23,["currentUserHasAuthorized"]]],null],[27,"or",[[27,"not",[[23,["model","requestEntity"]]],null],[23,["currentUserIsRequesting"]]],null]],null]],null,{"statements":[[0,"    "],[5,"control-group-success",[],[["@model","@controlGroupResponse"],[[21,"model"],[21,"controlGroupResponse"]]]],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","control-group"],[9],[0,"\\n      "],[7,"div"],[9],[0,"\\n"],[4,"if",[[23,["model","requestEntity","canRead"]]],null,{"statements":[[4,"link-to",["vault.cluster.access.identity.show","entities",[23,["model","requestEntity","id"]],"details"],null,{"statements":[[0,"            "],[1,[21,"requestorName"],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"          "],[1,[21,"requestorName"],false],[0,"\\n"]],"parameters":[]}],[0,"        "],[4,"if",[[23,["currentUserIsRequesting"]]],null,{"statements":[[0,"are"]],"parameters":[]},{"statements":[[0,"is"]],"parameters":[]}],[0,"\\n"],[4,"if",[[23,["model","approved"]]],null,{"statements":[[0,"          authorized to access "],[7,"code"],[9],[1,[23,["model","requestPath"]],false],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"          requesting access to "],[7,"code"],[9],[1,[23,["model","requestPath"]],false],[10],[0,"\\n"]],"parameters":[]}],[0,"      "],[10],[0,"\\n\\n"],[4,"if",[[27,"or",[[27,"not",[[23,["model","requestEntity"]]],null],[23,["currentUserIsRequesting"]]],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","message is-list is-highlight has-copy-button"],[11,"tabindex","-1"],[9],[0,"\\n          "],[5,"hover-copy-button",[],[["@alwaysShow","@copyValue"],["true",[23,["model","id"]]]]],[0,"\\n          "],[7,"div"],[11,"class","message-body"],[9],[0,"\\n            "],[7,"h4"],[11,"class","title is-7 is-marginless"],[9],[0,"\\n              Accessor\\n            "],[10],[0,"\\n            "],[7,"code"],[11,"class","is-word-break"],[9],[1,[23,["model","id"]],false],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"\\n      "],[7,"div"],[11,"class","authorizations"],[9],[0,"\\n"],[4,"if",[[27,"gt",[[23,["model","authorizations","length"]],0],null]],null,{"statements":[[0,"        "],[7,"span"],[11,"class","has-text-success"],[9],[0,"\\n          "],[5,"icon",[],[["@glyph"],["check-circle-outline"]]],[0,"\\n        "],[10],[0,"\\n          Already approved by\\n"],[4,"each",[[23,["model","authorizations"]]],null,{"statements":[[4,"if",[[22,1,["canRead"]]],null,{"statements":[[4,"link-to",["vault.cluster.access.identity.show","entities",[22,1,["id"]],"details"],null,{"statements":[[1,[22,1,["name"]],false]],"parameters":[]},null]],"parameters":[]},{"statements":[[1,[22,1,["name"]],false]],"parameters":[]}],[4,"if",[[27,"lt",[[27,"inc",[[22,2,[]]],null],[23,["model","authorizations","length"]]],null]],null,{"statements":[[0,","]],"parameters":[]},null],[0,"\\n"]],"parameters":[1,2]},null]],"parameters":[]},{"statements":[[0,"          "],[7,"span"],[11,"class","has-text-grey"],[9],[0,"\\n            "],[5,"icon",[],[["@glyph"],["check-circle-outline"]]],[0,"\\n          "],[10],[0,"\\n          Awaiting authorization.\\n"]],"parameters":[]}],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}],[4,"if",[[23,["controlGroupResponse","token"]]],null,{"statements":[[0,"      "],[7,"p"],[11,"class","control-group-token-text"],[9],[0,"\\n        We’ve saved your request token, but you may want to copy it just in case:\\n        "],[7,"span"],[11,"class","tag has-font-monospaced"],[9],[1,[23,["controlGroupResponse","token"]],false],[10],[0,"\\n        "],[5,"hover-copy-button",[],[["@alwaysShow","@copyValue"],["true",[23,["controlGroupResponse","token"]]]]],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"unless",[[27,"and",[[23,["model","approved"]],[27,"or",[[27,"not",[[23,["model","requestEntity"]]],null],[23,["currentUserIsRequesting"]]],null]],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n"],[4,"if",[[23,["model","canAuthorize"]]],null,{"statements":[[4,"if",[[27,"or",[[23,["model","approved"]],[23,["currentUserHasAuthorized"]]],null]],null,{"statements":[[4,"link-to",["vault.cluster.access.control-groups"],[["class"],["button"]],{"statements":[[0,"            "],[5,"chevron",[],[["@direction"],["left"]]],[0," Back\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"          "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["authorize","isRunning"]],"is-loading"],null]]]],[11,"type","button"],[3,"action",[[22,0,[]],[27,"perform",[[23,["authorize"]]],null]]],[9],[0,"\\n            Authorize\\n          "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]},{"statements":[[0,"        "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["refresh","isRunning"]],"is-loading"],null]]]],[11,"type","button"],[3,"action",[[22,0,[]],[27,"perform",[[23,["refresh"]]],null]]],[9],[0,"\\n          Refresh\\n        "],[10],[0,"\\n"]],"parameters":[]}],[0,"    "],[10],[0,"\\n"]],"parameters":[]},null],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/control-group.hbs"}})}),define("vault/templates/components/generate-credentials",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"rlXYde5q",block:'{"symbols":["attr","attr","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,3,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"nav"],[11,"class","breadcrumb"],[9],[0,"\\n      "],[7,"ul"],[9],[0,"\\n        "],[7,"li"],[9],[0,"\\n          "],[7,"span"],[11,"class","sep"],[9],[0,"/"],[10],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend",[23,["backendPath"]]],null,{"statements":[[0,"            "],[1,[21,"backendPath"],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n        "],[7,"li"],[11,"class","is-active"],[9],[0,"\\n          "],[7,"span"],[11,"class","sep"],[9],[0,"/"],[10],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend",[23,["backendPath"]]],null,{"statements":[[0,"            creds\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n        "],[7,"li"],[9],[0,"\\n          "],[7,"span"],[11,"class","sep"],[9],[0,"/"],[10],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.show",[23,["roleName"]]],null,{"statements":[[0,"            "],[1,[21,"roleName"],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,3,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      "],[1,[23,["options","title"]],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[3]}],[0,"\\n\\n"],[4,"if",[[23,["model","hasGenerated"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-fullwidth is-sideless is-paddingless is-marginless"],[9],[0,"\\n    "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n"],[4,"unless",[[23,["model","isError"]]],null,{"statements":[[0,"      "],[5,"alert-banner",[],[["@type","@message"],["warning","You will not be able to access this information later, so please copy the information below."]]],[0,"\\n"]],"parameters":[]},null],[4,"each",[[23,["model","attrs"]]],null,{"statements":[[4,"if",[[27,"eq",[[22,2,["type"]],"object"],null]],null,{"statements":[[0,"        "],[1,[27,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,2,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,2,["name"]]],null]],null]],null]],null],[27,"stringify",[[27,"get",[[23,["model"]],[22,2,["name"]]],null]],null]]]],false],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"or",[[27,"eq",[[22,2,["name"]],"key"],null],[27,"eq",[[22,2,["name"]],"secretKey"],null],[27,"eq",[[22,2,["name"]],"securityToken"],null],[27,"eq",[[22,2,["name"]],"privateKey"],null]],null]],null,{"statements":[[4,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,2,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,2,["name"]]],null]],null]],null]],null],[27,"get",[[23,["model"]],[22,2,["name"]]],null]]],{"statements":[[0,"            "],[5,"masked-input",[],[["@value","@name","@displayOnly"],[[27,"get",[[23,["model"]],[22,2,["name"]]],null],[22,2,["name"]],true]]],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"          "],[1,[27,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,2,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,2,["name"]]],null]],null]],null]],null],[27,"get",[[23,["model"]],[22,2,["name"]]],null]]]],false],[0,"\\n"]],"parameters":[]}]],"parameters":[]}]],"parameters":[2]},null],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[23,["model","toCreds"]],"button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Credentials copied!"],null]],null]]],{"statements":[[0,"        Copy credentials\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n"],[4,"if",[[23,["model","leaseId"]]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[23,["model","leaseId"]],"button","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Lease ID copied!"],null]],null]]],{"statements":[[0,"          Copy Lease ID\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"if",[[23,["options","backIsListLink"]]],null,{"statements":[[4,"link-to",["vault.cluster.secrets.backend.list-root",[23,["backendPath"]]],[["class"],["button"]],{"statements":[[0,"          Back\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"        "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"newModel"]],[9],[0,"\\n          Back\\n        "],[10],[0,"\\n"]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"form"],[3,"action",[[22,0,[]],"create"],[["on"],["submit"]]],[9],[0,"\\n    "],[7,"div"],[11,"class","box is-sideless no-padding-top is-fullwidth is-marginless"],[9],[0,"\\n      "],[5,"namespace-reminder",[],[["@mode","@noun"],["generate","credential"]]],[0,"\\n      "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n"],[4,"if",[[23,["model","helpText"]]],null,{"statements":[[0,"        "],[7,"p"],[11,"class","is-hint"],[9],[1,[23,["model","helpText"]],false],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["model","fieldGroups"]]],null,{"statements":[[0,"        "],[15,"partials/form-field-groups-loop",[]],[0,"\\n"]],"parameters":[]},{"statements":[[4,"each",[[23,["model","attrs"]]],null,{"statements":[[0,"          "],[1,[27,"form-field",null,[["attr","model"],[[22,1,[]],[23,["model"]]]]],false],[0,"\\n"]],"parameters":[1]},null]],"parameters":[]}],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[12,"disabled",[21,"loading"]],[12,"class",[28,["button is-primary ",[27,"if",[[23,["loading"]],"is-loading"],null]]]],[11,"type","submit"],[9],[0,"\\n          Generate\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.list-root",[23,["backendPath"]]],[["class"],["button"]],{"statements":[[0,"          Cancel\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":true}',meta:{moduleName:"vault/templates/components/generate-credentials.hbs"}})})
define("vault/templates/components/generated-item-list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"zAHwqcfr",block:'{"symbols":["list","Item","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,3,["top"]],[],[[],[]],{"statements":[[0,"\\n"],[4,"key-value-header",null,[["path"],["vault.cluster.access.methods"]],{"statements":[[0,"      "],[7,"li"],[9],[0,"\\n        "],[7,"span"],[11,"class","sep"],[9],[0,"\\n          /\\n        "],[10],[0,"\\n"],[4,"link-to",["vault.cluster.access.methods"],null,{"statements":[[0,"          methods\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "]],"parameters":[]}],[0,"\\n  "],[6,[22,3,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      "],[1,[21,"method"],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[3]}],[0,"\\n"],[1,[27,"section-tabs",[[23,["model"]],"authShow",[23,["paths"]]],null],false],[0,"\\n"],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n  "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-link",[],[["@params"],[[27,"array",["vault.cluster.access.method.item.create",[23,["itemType"]]],null]]],{"statements":[[0,"\\n      Create\\n      "],[1,[27,"singularize",[[23,["itemType"]]],null],false],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"],[5,"list-view",[],[["@items","@itemNoun"],[[21,"model"],[21,"itemType"]]],{"statements":[[0,"\\n"],[4,"if",[[22,1,["empty"]]],null,{"statements":[[0,"    "],[6,[22,1,["empty"]],[],[["@title","@message"],[[28,["No ",[27,"pluralize",[[23,["itemType"]]],null]," yet"]],[28,["A list of ",[27,"pluralize",[[23,["itemType"]]],null]," will be listed here. Create your first ",[21,"itemType"]," to get started."]]]],{"statements":[[0,"\\n"],[4,"link-to",["vault.cluster.access.method.item.create",[23,["itemType"]]],[["class"],["link"]],{"statements":[[0,"        Create "],[1,[27,"singularize",[[23,["itemType"]]],null],false],[0,"\\n"]],"parameters":[]},null],[0,"    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[22,1,["item"]]],null,{"statements":[[0,"    "],[5,"list-item",[],[["@linkParams"],[[27,"array",["vault.cluster.access.method.item.show",[23,["itemType"]],[22,1,["item","id"]]],null]]],{"statements":[[0,"\\n      "],[6,[22,2,["content"]],[],[[],[]],{"statements":[[0,"\\n        "],[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph","@size"],["folder-outline","l"]]],[1,[22,1,["item","id"]],false],[0,"\\n      "]],"parameters":[]}],[0,"\\n      "],[6,[22,2,["menu"]],[],[[],[]],{"statements":[[0,"\\n        "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.method.item.show",[22,1,["item","id"]]],[["class"],["is-block"]],{"statements":[[0,"            View "],[1,[27,"singularize",[[23,["itemType"]]],null],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n        "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.method.item.edit",[22,1,["item","id"]]],[["class"],["is-block"]],{"statements":[[0,"            Edit "],[1,[27,"singularize",[[23,["itemType"]]],null],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n        "],[7,"li"],[9],[0,"\\n          "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction","@confirmMessage","@cancelButtonText"],["link is-destroy",[27,"action",[[22,0,[]],[27,"perform",[[22,2,["callMethod"]],"destroyRecord",[22,1,["item"]],[27,"concat",["Successfully deleted ",[27,"singularize",[[23,["itemType"]]],null]," ",[22,1,["item","id"]]],null],[27,"concat",["There was an error deleting this ",[27,"singularize",[[23,["itemType"]]],null]],null],[27,"action",[[22,0,[]],"refreshItemList"],null]],null]],null],[27,"concat",["Are you sure you want to delete ",[22,1,["item","id"]],"?"],null],"Cancel"]],{"statements":[[0,"\\n            Delete\\n            "],[1,[27,"singularize",[[23,["itemType"]]],null],false],[0,"\\n          "]],"parameters":[]}],[0,"\\n        "],[10],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[2]}],[0,"\\n  "]],"parameters":[]},null]],"parameters":[]}]],"parameters":[1]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/generated-item-list.hbs"}})}),define("vault/templates/components/generated-item",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Y1vmZi6C",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"nav"],[11,"class","breadcrumb"],[9],[0,"\\n      "],[7,"ul"],[9],[0,"\\n        "],[7,"li"],[9],[0,"\\n          "],[7,"span"],[11,"class","sep"],[9],[0,"\\n            /\\n          "],[10],[0,"\\n"],[4,"link-to",["vault.cluster.access.method.item.list",[23,["itemType"]]],null,{"statements":[[0,"            "],[1,[27,"pluralize",[[23,["itemType"]]],null],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"show"],null]],null,{"statements":[[0,"      "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n        "],[1,[23,["model","id"]],false],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n        "],[1,[27,"capitalize",[[23,["mode"]]],null],false],[0,"\\n        "],[1,[27,"singularize",[[23,["itemType"]]],null],false],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"edit"],null]],null,{"statements":[[0,"          "],[1,[23,["model","id"]],false],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]}],[0,"  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"show"],null]],null,{"statements":[[0,"  "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n      "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction","@confirmMessage","@cancelButtonText"],["toolbar-link",[27,"action",[[22,0,[]],"deleteItem"],null],[27,"concat",["Are you sure you want to delete ",[23,["model","id"]],"?"],null],"Cancel"]],{"statements":[[0,"\\n        Delete\\n        "],[1,[21,"itemType"],false],[0,"\\n      "]],"parameters":[]}],[0,"\\n      "],[5,"toolbar-link",[],[["@params"],[[27,"array",["vault.cluster.access.method.item.edit",[23,["itemType"]],[23,["model","id"]]],null]]],{"statements":[[0,"\\n        Edit "],[1,[27,"singularize",[[23,["itemType"]]],null],false],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"eq",[[23,["mode"]],"show"],null]],null,{"statements":[[0,"  "],[5,"field-group-show",[],[["@model","@showAllFields"],[[21,"model"],"true"]]],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"form"],[3,"action",[[22,0,[]],[27,"perform",[[23,["saveModel"]]],null]],[["on"],["submit"]]],[9],[0,"\\n    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[5,"namespace-reminder",[],[["@mode","@noun"],["save",[21,"itemType"]]]],[0,"\\n      "],[5,"message-error",[],[["@model"],[[21,"model"]]]],[0,"\\n      "],[5,"form-field-groups",[],[["@model","@mode"],[[21,"model"],[21,"mode"]]]],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped-split box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["saveModel","isRunning"]],"loading"],null]]]],[12,"disabled",[23,["saveModel","isRunning"]]],[11,"type","submit"],[9],[0,"\\n          Save\\n        "],[10],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"create"],null]],null,{"statements":[[4,"link-to",["vault.cluster.access.method.item.list"],[["class"],["button"]],{"statements":[[0,"            Cancel\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[4,"link-to",["vault.cluster.access.method.item.show",[23,["model","id"]]],[["class"],["button"]],{"statements":[[0,"            Cancel\\n"]],"parameters":[]},null]],"parameters":[]}],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/generated-item.hbs"}})}),define("vault/templates/components/home-link",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"1pweR0IC",block:'{"symbols":["&default"],"statements":[[7,"span"],[12,"class",[21,"class"]],[9],[0,"\\n"],[4,"if",[[24,1]],null,{"statements":[[0,"    "],[14,1],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[1,[21,"text"],false],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/home-link.hbs"}})}),define("vault/templates/components/hover-copy-button",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"mXMJAU/n",block:'{"symbols":["T"],"statements":[[5,"tool-tip",[],[["@onClose"],[[27,"action",[[22,0,[]],[27,"mut",[[23,["tooltipText"]]],null],"Copy"],null]]],{"statements":[[0,"\\n  "],[6,[22,1,["trigger"]],[[11,"tabindex","false"]],[[],[]],{"statements":[[0,"\\n    "],[5,"copy-button",[[11,"class","copy-button button is-compact is-transparent"]],[["@clipboardText","@success"],[[21,"copyValue"],[27,"action",[[22,0,[]],[27,"mut",[[23,["tooltipText"]]],null],"Copied!"],null]]],{"statements":[[0,"\\n      "],[5,"icon",[[11,"aria-label","Copy"]],[["@glyph"],["copy-action"]]],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["content"]],[],[["@class"],["tool-tip"]],{"statements":[[0,"\\n    "],[7,"div"],[11,"class","box"],[9],[0,"\\n      "],[1,[21,"tooltipText"],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/hover-copy-button.hbs"}})}),define("vault/templates/components/http-requests-bar-chart",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"25wvXWbc",block:'{"symbols":[],"statements":[[0,"\\n"],[7,"svg"],[11,"class","http-requests-bar-chart"],[9],[0,"\\n  "],[7,"defs"],[9],[0,"\\n    "],[7,"linearGradient"],[11,"id","bg-gradient"],[11,"gradientTransform","rotate(90)"],[9],[0,"\\n      "],[7,"stop"],[11,"stop-color","#5b92ff"],[11,"stop-opacity","1"],[11,"offset","0%"],[9],[10],[0,"\\n      "],[7,"stop"],[11,"stop-color","#5b92ff"],[11,"stop-opacity","0.5"],[11,"offset","100%"],[9],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"g"],[11,"class","gridlines"],[9],[10],[0,"\\n  "],[7,"g"],[11,"class","x-axis"],[9],[10],[0,"\\n  "],[7,"g"],[11,"class","y-axis"],[9],[10],[0,"\\n  "],[7,"g"],[12,"clip-path",[28,["url(#bars-container-",[22,0,["elementId"]],")"]]],[9],[0,"\\n    "],[7,"rect"],[11,"x","0"],[11,"y","0"],[11,"width","100%"],[11,"height","100%"],[11,"style","fill: url(#bg-gradient)"],[9],[10],[0,"\\n    "],[7,"clipPath"],[12,"id",[28,["bars-container-",[22,0,["elementId"]]]]],[9],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n    "],[7,"g"],[11,"class","shadow-bars"],[9],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/http-requests-bar-chart.hbs"}})}),define("vault/templates/components/http-requests-container",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"OpOjLcOL",block:'{"symbols":[],"statements":[[4,"if",[[27,"gt",[[23,["counters","length"]],1],null]],null,{"statements":[[0,"  "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n    "],[5,"http-requests-dropdown",[],[["@counters","@onChange","@timeWindow"],[[21,"counters"],[27,"action",[[22,0,[]],"updateTimeWindow"],null],[21,"timeWindow"]]]],[0,"\\n  "]],"parameters":[]}],[0,"\\n\\n  "],[5,"http-requests-bar-chart",[],[["@counters"],[[21,"filteredCounters"]]]],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[5,"alert-inline",[],[["@type","@message"],["info","Metrics are recorded only for interactions that produce or use a Vault token."]]],[0,"\\n"],[5,"http-requests-table",[],[["@counters"],[[21,"filteredCounters"]]]],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/http-requests-container.hbs"}})}),define("vault/templates/components/http-requests-dropdown",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"ENvVKGQU",block:'{"symbols":["op"],"statements":[[7,"label"],[11,"for","date-range"],[11,"class","is-label toolbar-label"],[9],[0,"\\n  Date Range\\n"],[10],[0,"\\n"],[7,"div"],[11,"class","select"],[9],[0,"\\n  "],[7,"select"],[11,"class","select"],[11,"id","date-range"],[11,"name","selectedTimeWindow"],[12,"onchange",[27,"action",[[22,0,[]],"onSelectTimeWindow"],null]],[9],[0,"\\n      "],[7,"option"],[11,"value","All"],[12,"selected",[27,"eq",[[23,["timeWindow"]],"All"],null]],[9],[0,"All"],[10],[0,"/>\\n      "],[7,"option"],[11,"value","Last 12 Months"],[12,"selected",[27,"eq",[[23,["timeWindow"]],"Last 12 Months"],null]],[9],[0,"Last 12 Months"],[10],[0,"\\n"],[4,"each",[[23,["options"]]],null,{"statements":[[0,"      "],[7,"option"],[12,"value",[22,1,[]]],[12,"selected",[27,"eq",[[23,["timeWindow"]],[22,1,[]]],null]],[9],[1,[22,1,[]],false],[10],[0,"\\n"]],"parameters":[1]},null],[0,"  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/http-requests-dropdown.hbs"}})}),define("vault/templates/components/http-requests-table",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"8YO1C/mV",block:'{"symbols":["c"],"statements":[[7,"div"],[11,"class","http-requests-table"],[9],[0,"\\n  "],[7,"table"],[11,"class","is-fullwidth"],[9],[0,"\\n    "],[7,"caption"],[11,"class","is-collapsed"],[9],[0,"HTTP Request Volume"],[10],[0,"\\n    "],[7,"thead"],[11,"class","has-text-weight-semibold"],[9],[0,"\\n      "],[7,"tr"],[9],[0,"\\n        "],[7,"th"],[11,"scope","col"],[9],[0,"Month"],[10],[0,"\\n        "],[7,"th"],[11,"scope","col"],[9],[0,"Requests"],[10],[0,"\\n"],[4,"if",[[27,"gt",[[23,["counters","length"]],1],null]],null,{"statements":[[0,"          "],[7,"th"],[11,"scope","col"],[9],[0,"Change"],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"tbody"],[9],[0,"\\n"],[4,"each",[[27,"reverse",[[23,["countersWithChange"]]],null]],null,{"statements":[[0,"        "],[7,"tr"],[9],[0,"\\n          "],[7,"th"],[11,"scope","row"],[11,"class","start-time has-text-black"],[9],[1,[27,"format-utc",[[22,1,["start_time"]],"%B %Y"],null],false],[10],[0,"\\n          "],[7,"td"],[9],[1,[27,"format-number",[[22,1,["total"]]],null],false],[10],[0,"\\n"],[4,"if",[[27,"gt",[[23,["counters","length"]],1],null]],null,{"statements":[[0,"            "],[7,"td"],[11,"class","has-text-grey-dark percent-change"],[9],[0,"\\n"],[4,"if",[[22,1,["percentChange"]]],null,{"statements":[[0,"                "],[5,"icon",[[12,"class",[22,1,["glyph"]]]],[["@glyph"],[[22,1,["glyph"]]]]],[0,"\\n                "],[1,[22,1,["percentChange"]],false],[0,"%\\n"]],"parameters":[]},{"statements":[[0,"                "],[5,"icon",[],[["@glyph"],["minus-plain"]]],[0,"\\n"]],"parameters":[]}],[0,"            "],[10],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/http-requests-table.hbs"}})}),define("vault/templates/components/identity/edit-form",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"bbomOzni",block:'{"symbols":["attr"],"statements":[[4,"if",[[27,"and",[[27,"eq",[[23,["mode"]],"edit"],null],[23,["model","canDelete"]]],null]],null,{"statements":[[0,"  "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n      "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction"],["toolbar-link",[27,"action",[[22,0,[]],"deleteItem",[23,["model"]]],null]]],{"statements":[[0,"\\n        Delete "],[1,[23,["model","identityType"]],false],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[7,"form"],[3,"action",[[22,0,[]],[27,"perform",[[23,["save"]]],null]],[["on"],["submit"]]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],[[21,"mode"],[27,"lowercase",[[27,"humanize",[[23,["model","identityType"]]],null]],null]]]],[0,"\\n    "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"merge"],null]],null,{"statements":[[0,"      "],[5,"alert-banner",[],[["@type","@message"],["warning","Metadata on merged entities is not preserved, you will need to recreate it on the entity you merge to."]]],[0,"\\n"]],"parameters":[]},null],[4,"each",[[23,["model","fields"]]],null,{"statements":[[0,"      "],[1,[27,"form-field",null,[["attr","model"],[[22,1,[]],[23,["model"]]]]],false],[0,"\\n"]],"parameters":[1]},null],[0,"  "],[10],[0,"\\n\\n  "],[7,"div"],[11,"class","field is-grouped is-grouped-split is-fullwidth box is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["save","isRunning"]],"loading"],null]]]],[12,"disabled",[23,["save","isRunning"]]],[11,"type","submit"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"create"],null]],null,{"statements":[[0,"            Create\\n"]],"parameters":[]},{"statements":[[0,"            Save\\n"]],"parameters":[]}],[0,"        "],[10],[0,"\\n"],[4,"if",[[27,"or",[[27,"eq",[[23,["mode"]],"merge"],null],[27,"eq",[[23,["mode"]],"create"],null]],null]],null,{"statements":[[4,"link-to",[[23,["cancelLink"]]],[["class"],["button"]],{"statements":[[0,"            Cancel\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[4,"link-to",[[23,["cancelLink"]],[23,["model","id"]],"details"],[["class"],["button"]],{"statements":[[0,"            Cancel\\n"]],"parameters":[]},null]],"parameters":[]}],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/edit-form.hbs"}})}),define("vault/templates/components/identity/entity-nav",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"LN3ioQi9",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      "],[1,[27,"capitalize",[[27,"pluralize",[[23,["identityType"]]],null]],null],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n"],[7,"div"],[11,"class","tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[9],[0,"\\n  "],[7,"nav"],[11,"class","tabs"],[9],[0,"\\n    "],[7,"ul"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.index",[27,"pluralize",[[23,["identityType"]]],null]],[["tagName"],["li"]],{"statements":[[4,"link-to",["vault.cluster.access.identity.index",[27,"pluralize",[[23,["identityType"]]],null]],null,{"statements":[[0,"          "],[1,[27,"capitalize",[[27,"pluralize",[[23,["identityType"]]],null]],null],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[4,"link-to",["vault.cluster.access.identity.aliases.index",[27,"pluralize",[[23,["identityType"]]],null]],[["tagName"],["li"]],{"statements":[[4,"link-to",["vault.cluster.access.identity.aliases.index",[27,"pluralize",[[23,["identityType"]]],null]],null,{"statements":[[0,"          Aliases\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n"],[4,"if",[[23,["model","meta","total"]]],null,{"statements":[[0,"    "],[5,"toolbar-filters",[],[[],[]],{"statements":[[0,"\\n      "],[1,[27,"identity/lookup-input",null,[["type"],[[23,["identityType"]]]]],false],[0,"\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"  "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n"],[4,"if",[[27,"eq",[[23,["identityType"]],"entity"],null]],null,{"statements":[[0,"      "],[5,"toolbar-link",[],[["@params"],[[27,"array",["vault.cluster.access.identity.merge",[27,"pluralize",[[23,["identityType"]]],null]],null]]],{"statements":[[0,"\\n        Merge "],[1,[27,"pluralize",[[23,["identityType"]]],null],false],[0,"\\n      "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"    "],[5,"toolbar-link",[],[["@type","@params"],["add",[27,"array",["vault.cluster.access.identity.create",[27,"pluralize",[[23,["identityType"]]],null]],null]]],{"statements":[[0,"\\n      Create "],[1,[21,"identityType"],false],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/entity-nav.hbs"}})}),define("vault/templates/components/identity/item-alias/alias-details",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"t1/FWVA1",block:'{"symbols":[],"statements":[[1,[27,"info-table-row",null,[["label","value"],["Name",[23,["model","name"]]]]],false],[0,"\\n"],[1,[27,"info-table-row",null,[["label","value"],["ID",[23,["model","id"]]]]],false],[0,"\\n"],[4,"info-table-row",null,[["label","value"],[[27,"if",[[27,"eq",[[23,["model","identityType"]],"entity-alias"],null],"Entity ID","Group ID"],null],[23,["model","canonicalId"]]]],{"statements":[[4,"link-to",["vault.cluster.access.identity.show",[27,"if",[[27,"eq",[[23,["model","identityType"]],"entity-alias"],null],"entities","groups"],null],[23,["model","canonicalId"]],"details"],[["class"],["has-text-black is-font-mono"]],{"statements":[[0,"    "],[1,[23,["model","canonicalId"]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[1,[27,"info-table-row",null,[["label","value"],["Merged from Entity ID",[23,["model","mergedFromCanonicalIds"]]]]],false],[0,"\\n"],[4,"info-table-row",null,[["label","value"],["Mount",[23,["model","mountAccessor"]]]],{"statements":[[0,"  "],[7,"div"],[9],[0,"\\n    "],[1,[23,["model","mountPath"]],false],[0,"\\n    "],[7,"div"],[9],[0,"\\n      "],[7,"span"],[11,"class","tag"],[9],[1,[23,["model","mountType"]],false],[10],[0,"\\n      "],[7,"code"],[11,"class","has-text-grey is-size-8"],[9],[1,[23,["model","mountAccessor"]],false],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null],[4,"info-table-row",null,[["label","value"],["Created",[23,["model","creationTime"]]]],{"statements":[[0,"  "],[7,"time"],[12,"datetime",[23,["model","creationTime"]]],[12,"title",[23,["model","creationTime"]]],[9],[0,"\\n    "],[1,[27,"date-format",[[23,["model","creationTime"]],"MMM DD, YYYY [at] h:mm a"],null],false],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null],[4,"info-table-row",null,[["label","value"],["Last Updated",[23,["model","lastUpdateTime"]]]],{"statements":[[0,"  "],[7,"time"],[12,"datetime",[23,["model","lastUpdateTime"]]],[12,"title",[23,["model","lastUpdateTime"]]],[9],[0,"\\n    "],[1,[27,"date-format",[[23,["model","lastUpdateTime"]],"MMM DD, YYYY [at] h:mm a"],null],false],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/item-alias/alias-details.hbs"}})}),define("vault/templates/components/identity/item-alias/alias-metadata",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"CxNvYDGe",block:'{"symbols":["value","key"],"statements":[[4,"each",[[27,"-each-in",[[23,["model","metadata"]]],null]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","info-table-row is-mobile"],[9],[0,"\\n    "],[7,"div"],[11,"class","is-flex is-fullwidth"],[9],[0,"\\n      "],[7,"div"],[11,"class","column is-one-quarter"],[9],[0,"\\n        "],[7,"span"],[11,"class","is-label has-text-grey-dark"],[9],[0,"\\n          "],[1,[22,2,[]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","column is-flex"],[9],[0,"\\n        "],[1,[22,1,[]],false],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[1,2]},{"statements":[[0,"  "],[5,"empty-state",[],[["@title"],[[28,["No metadata associated with ",[23,["model","name"]]," yet"]]]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/item-alias/alias-metadata.hbs"}})}),define("vault/templates/components/identity/item-aliases",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"DllgZllV",block:'{"symbols":["item"],"statements":[[4,"each",[[27,"if",[[23,["model","alias","id"]],[27,"array",[[23,["model","alias"]]],null],[23,["model","aliases"]]],null]],null,{"statements":[[4,"linked-block",["vault.cluster.access.identity.aliases.show",[22,1,["id"]],"details"],[["class"],["list-item-row"]],{"statements":[[0,"    "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n      "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n        "],[4,"link-to",["vault.cluster.access.identity.aliases.show",[22,1,["id"]],"details"],[["class"],["has-text-black has-text-weight-semibold"]],{"statements":[[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph"],["user-square-outline"]]],[7,"span"],[11,"class","has-text-weight-semibold"],[9],[1,[22,1,["name"]],false],[10]],"parameters":[]},null],[0,"\\n        "],[7,"div"],[11,"class","has-text-grey"],[9],[0,"\\n          "],[1,[22,1,["id"]],false],[0,"\\n        "],[10],[0,"\\n        "],[7,"span"],[11,"class","tag"],[9],[1,[22,1,["mountType"]],false],[10],[0,"\\n        "],[7,"span"],[11,"class","has-text-grey is-size-8"],[9],[0,"\\n          "],[1,[22,1,["mountAccessor"]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n        "],[1,[27,"identity/popup-alias",null,[["params"],[[27,"array",[[22,1,[]]],null]]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},{"statements":[[0,"  "],[5,"empty-state",[],[["@title"],[[28,["No ",[23,["model","identityType"]]," aliases for ",[23,["model","name"]]," yet"]]]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/item-aliases.hbs"}})}),define("vault/templates/components/identity/item-details",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"s5HEBh4e",block:'{"symbols":["id"],"statements":[[7,"div"],[11,"class","box is-shadowless is-marginless is-fullwidth"],[9],[0,"\\n"],[4,"if",[[23,["model","disabled"]]],null,{"statements":[[0,"    "],[5,"alert-banner",[],[["@type","@title","@message"],["warning","Attention",[28,["This ",[23,["model","identityType"]]," is disabled. All associated tokens cannot be used, but are not revoked."]]]],{"statements":[[0,"\\n"],[4,"if",[[23,["model","canEdit"]]],null,{"statements":[[0,"        "],[7,"button"],[12,"onclick",[27,"action",[[22,0,[]],"enable",[23,["model"]]],null]],[11,"class","link"],[11,"type","button"],[9],[0,"\\n          Enable\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"  "],[1,[27,"info-table-row",null,[["label","value"],["Name",[23,["model","name"]]]]],false],[0,"\\n  "],[1,[27,"info-table-row",null,[["label","value"],["Type",[23,["model","type"]]]]],false],[0,"\\n  "],[1,[27,"info-table-row",null,[["label","value"],["ID",[23,["model","id"]]]]],false],[0,"\\n"],[4,"info-table-row",null,[["label","value"],["Merged Ids",[23,["model","mergedEntityIds"]]]],{"statements":[[0,"    "],[7,"div"],[9],[0,"\\n"],[4,"each",[[23,["model","mergedEntityIds"]]],null,{"statements":[[0,"        "],[7,"div"],[9],[0,"\\n          "],[7,"code"],[11,"class","has-text-black"],[9],[1,[22,1,[]],false],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"    "],[10],[0,"\\n"]],"parameters":[]},null],[4,"info-table-row",null,[["label","value"],["Created",[23,["model","creationTime"]]]],{"statements":[[0,"    "],[7,"time"],[12,"datetime",[23,["model","creationTime"]]],[12,"title",[23,["model","creationTime"]]],[9],[0,"\\n      "],[1,[27,"date-format",[[23,["model","creationTime"]],"MMM DD, YYYY [at] h:mm a"],null],false],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[4,"info-table-row",null,[["label","value"],["Last Updated",[23,["model","lastUpdateTime"]]]],{"statements":[[0,"    "],[7,"time"],[12,"datetime",[23,["model","lastUpdateTime"]]],[12,"title",[23,["model","lastUpdateTime"]]],[9],[0,"\\n      "],[1,[27,"date-format",[[23,["model","lastUpdateTime"]],"MMM DD, YYYY [at] h:mm a"],null],false],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[10]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/item-details.hbs"}})}),define("vault/templates/components/identity/item-groups",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Iy4sCGaC",block:'{"symbols":["gid","gid"],"statements":[[4,"if",[[23,["model","groupIds"]]],null,{"statements":[[4,"each",[[23,["model","directGroupIds"]]],null,{"statements":[[0,"    "],[4,"link-to",["vault.cluster.access.identity.show","groups",[22,2,[]],"details"],[["class"],["list-item-row"]],{"statements":[[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph"],["folder-outline"]]],[1,[22,2,[]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[2]},null],[4,"each",[[23,["model","inheritedGroupIds"]]],null,{"statements":[[4,"linked-block",["vault.cluster.access.identity.show","groups",[22,1,[]],"details"],[["class"],["list-item-row"]],{"statements":[[0,"      "],[4,"link-to",["vault.cluster.access.identity.show","groups",[22,1,[]],"details"],[["class"],["has-text-black"]],{"statements":[[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph"],["folder-outline"]]],[1,[22,1,[]],false],[0,"\\n"]],"parameters":[]},null],[0,"      "],[7,"span"],[11,"class","tag has-text-grey is-size-8"],[9],[0,"inherited"],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null]],"parameters":[]},{"statements":[[0,"  "],[5,"empty-state",[],[["@title"],[[28,[[23,["model","name"]]," is not a member of any groups."]]]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/item-groups.hbs"}})}),define("vault/templates/components/identity/item-members",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"U33HCViM",block:'{"symbols":["gid","gid"],"statements":[[4,"if",[[23,["model","hasMembers"]]],null,{"statements":[[4,"each",[[23,["model","memberGroupIds"]]],null,{"statements":[[4,"linked-block",["vault.cluster.access.identity.show","groups",[22,2,[]],[23,["details"]]],[["class"],["list-item-row"]],{"statements":[[0,"      "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n        "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n          "],[4,"link-to",["vault.cluster.access.identity.show","groups",[22,2,[]],"details"],[["class"],["is-block has-text-black has-text-weight-semibold"]],{"statements":[[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph"],["folder-outline"]]],[1,[22,2,[]],false]],"parameters":[]},null],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n"],[4,"if",[[23,["model","canEdit"]]],null,{"statements":[[0,"            "],[1,[27,"identity/popup-members",null,[["params"],[[27,"array",[[23,["model"]],"memberGroupIds",[22,2,[]]],null]]]],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[2]},null],[4,"each",[[23,["model","memberEntityIds"]]],null,{"statements":[[4,"linked-block",["vault.cluster.access.identity.show","groups",[22,1,[]],[23,["details"]]],[["class"],["list-item-row"]],{"statements":[[0,"      "],[7,"div"],[11,"class","columns"],[9],[0,"\\n        "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n          "],[4,"link-to",["vault.cluster.access.identity.show","entities",[22,1,[]],"details"],[["class"],["is-block has-text-black has-text-weight-semibold"]],{"statements":[[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph"],["user-square-outline"]]],[1,[22,1,[]],false]],"parameters":[]},null],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n"],[4,"if",[[23,["model","canEdit"]]],null,{"statements":[[0,"            "],[1,[27,"identity/popup-members",null,[["params"],[[27,"array",[[23,["model"]],"memberEntityIds",[22,1,[]]],null]]]],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null]],"parameters":[]},{"statements":[[0,"  "],[5,"empty-state",[],[["@title"],["No members in this group yet"]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/item-members.hbs"}})}),define("vault/templates/components/identity/item-metadata",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"U5TLkJBT",block:'{"symbols":["value","key"],"statements":[[4,"each",[[27,"-each-in",[[23,["model","metadata"]]],null]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","info-table-row is-mobile"],[9],[0,"\\n    "],[7,"div"],[11,"class","is-flex is-fullwidth"],[9],[0,"\\n      "],[7,"div"],[11,"class","column is-one-quarter"],[9],[0,"\\n        "],[7,"span"],[11,"class","is-label has-text-grey-dark"],[9],[0,"\\n          "],[1,[22,2,[]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","column is-5"],[9],[0,"\\n        "],[1,[22,1,[]],false],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n"],[4,"if",[[23,["model","canEdit"]]],null,{"statements":[[0,"          "],[1,[27,"identity/popup-metadata",null,[["params"],[[27,"array",[[23,["model"]],[22,2,[]]],null]]]],false],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[1,2]},{"statements":[[0,"  "],[5,"empty-state",[],[["@title","@message"],[[28,["No metadata for ",[23,["model","name"]]]],[28,["You can store custom data that you want to associate with a ",[27,"lowercase",[[27,"humanize",[[23,["model","identityType"]]],null]],null],". Edit this ",[27,"lowercase",[[27,"humanize",[[23,["model","identityType"]]],null]],null]," to get started."]]]],{"statements":[[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.edit",[23,["model","id"]]],[["tagName","class"],["button","link"]],{"statements":[[0,"      Edit "],[1,[27,"lowercase",[[27,"humanize",[[23,["model","identityType"]]],null]],null],false],[0,"\\n"]],"parameters":[]},null],[0,"    "],[5,"learn-link",[],[["@path"],["/vault/identity-access-management/iam-identity"]],{"statements":[[0,"\\n      Learn more\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/item-metadata.hbs"}})}),define("vault/templates/components/identity/item-parent-groups",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"c9EV6onB",block:'{"symbols":["gid"],"statements":[[4,"if",[[23,["model","parentGroupIds","length"]]],null,{"statements":[[4,"each",[[23,["model","parentGroupIds"]]],null,{"statements":[[4,"linked-block",["vault.cluster.access.identity.show","groups",[22,1,[]],[23,["details"]]],[["class"],["list-item-row"]],{"statements":[[0,"      "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n        "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n          "],[4,"link-to",["vault.cluster.access.identity.show","groups",[22,1,[]],"details"],[["class"],["is-block has-text-black has-text-weight-semibold"]],{"statements":[[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph"],["folder-outline"]]],[1,[22,1,[]],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n        "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null]],"parameters":[]},{"statements":[[0,"  "],[5,"empty-state",[],[["@title"],["This group has no parent groups yet"]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/item-parent-groups.hbs"}})}),define("vault/templates/components/identity/item-policies",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"O8SQY6TU",block:'{"symbols":["policyName"],"statements":[[4,"each",[[23,["model","policies"]]],null,{"statements":[[4,"linked-block",["vault.cluster.policy.show","acl",[23,["item"]]],[["class"],["list-item-row"]],{"statements":[[0,"    "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n      "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n        "],[4,"link-to",["vault.cluster.policy.show","acl",[22,1,[]]],[["class"],["is-block has-text-black has-text-weight-semibold"]],{"statements":[[7,"span"],[11,"class","is-underline"],[9],[1,[22,1,[]],false],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n"],[4,"if",[[23,["model","canEdit"]]],null,{"statements":[[0,"          "],[1,[27,"identity/popup-policy",null,[["params"],[[27,"array",[[23,["model"]],[22,1,[]]],null]]]],false],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},{"statements":[[0,"  "],[5,"empty-state",[],[["@title"],[[28,["No policies associated with ",[23,["model","name"]]," yet"]]]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/item-policies.hbs"}})}),define("vault/templates/components/identity/lookup-input",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"dYAYgVem",block:'{"symbols":["paramOption"],"statements":[[7,"form"],[3,"action",[[22,0,[]],[27,"perform",[[23,["lookup"]]],null]],[["on"],["submit"]]],[9],[0,"\\n  "],[7,"div"],[11,"class","field is-flex"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n        "],[7,"select"],[11,"name","param"],[11,"id","param"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["param"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"array",["alias name","name","id","alias id"],null]],null,{"statements":[[0,"            "],[7,"option"],[12,"selected",[27,"eq",[[23,["param"]],[22,1,[]]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n             Lookup by "],[1,[22,1,[]],false],[0,"\\n            "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["param"]],"alias name"],null]],null,{"statements":[[0,"        "],[1,[27,"mount-accessor-select",null,[["value","onChange"],[[23,["aliasMountAccessor"]],[27,"action",[[22,0,[]],[27,"mut",[[23,["aliasMountAccessor"]]],null]],null]]]],false],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n      "],[1,[27,"input",null,[["class","value","placeholder"],["input",[23,["paramValue"]],[27,"capitalize",[[23,["param"]]],null]]]],false],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-hidden"],[11,"type","submit"],[9],[0,"Lookup"],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/lookup-input.hbs"}})}),define("vault/templates/components/identity/popup-alias",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"yKDJpdUR",block:'{"symbols":["item"],"statements":[[4,"popup-menu",null,[["name"],["alias-menu"]],{"statements":[[4,"with",[[23,["params","firstObject"]]],null,{"statements":[[0,"  "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n    "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n      "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.aliases.show",[27,"pluralize",[[22,1,["parentType"]]],null],[22,1,["id"]],"details"],null,{"statements":[[0,"          Details\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"],[4,"if",[[22,1,["updatePath","isPending"]]],null,{"statements":[[0,"        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n            loading\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[22,1,["canEdit"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.aliases.edit",[27,"pluralize",[[22,1,["parentType"]]],null],[22,1,["id"]]],null,{"statements":[[0,"              Edit\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[22,1,["canDelete"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction"],["link is-destroy",[27,"action",[[22,0,[]],"performTransaction",[22,1,[]]],null]]],{"statements":[[0,"\\n              Delete\\n            "]],"parameters":[]}],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[1]},null]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/popup-alias.hbs"}})}),define("vault/templates/components/identity/popup-members",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"zSxDqJ5z",block:'{"symbols":[],"statements":[[4,"popup-menu",null,[["name"],["member-edit-menu"]],{"statements":[[0,"  "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n    "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n      "],[7,"li"],[11,"class","action"],[9],[0,"\\n        "],[5,"confirm-action",[],[["@buttonClasses","@confirmButtonText","@confirmMessage","@onConfirmAction"],["link is-destroy","Remove this group?","This may affect permissions for this group.",[27,"action",[[22,0,[]],"performTransaction",[23,["model"]],[23,["groupArray"]],[23,["memberId"]]],null]]],{"statements":[[0,"\\n          Remove\\n        "]],"parameters":[]}],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/popup-members.hbs"}})}),define("vault/templates/components/identity/popup-metadata",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"/AeA6Vzf",block:'{"symbols":[],"statements":[[5,"popup-menu",[],[["@name"],["metadata-edit-menu"]],{"statements":[[0,"\\n  "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n    "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n      "],[7,"li"],[11,"class","action"],[9],[0,"\\n        "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@onConfirmAction"],["link is-destroy","Remove metadata?","This data may be used outside of Vault.","Remove",[27,"action",[[22,0,[]],"performTransaction",[23,["model"]],[23,["key"]]],null]]],{"statements":[[0,"\\n          Remove\\n        "]],"parameters":[]}],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/popup-metadata.hbs"}})}),define("vault/templates/components/identity/popup-policy",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"fK6+oVg6",block:'{"symbols":[],"statements":[[4,"popup-menu",null,[["name"],["policy-menu"]],{"statements":[[0,"  "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n    "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n      "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.policy.show","acl",[23,["policyName"]]],null,{"statements":[[0,"          View Policy\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.policy.edit","acl",[23,["policyName"]]],null,{"statements":[[0,"          Edit Policy\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"li"],[11,"class","action"],[9],[0,"\\n        "],[5,"confirm-action",[],[["@buttonClasses","@confirmButtonText","@confirmMessage","@onConfirmAction"],["link is-destroy","Remove","This policy may affect permissions to access Vault data.",[27,"action",[[22,0,[]],"performTransaction",[23,["model"]],[23,["policyName"]]],null]]],{"statements":[[0,"\\n          Remove from "],[1,[23,["model","identityType"]],false],[0,"\\n        "]],"parameters":[]}],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/identity/popup-policy.hbs"}})}),define("vault/templates/components/key-value-header",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"VP5QTufe",block:'{"symbols":["path","index","&default"],"statements":[[7,"ul"],[9],[0,"\\n  "],[14,3],[0,"\\n"],[4,"each",[[23,["secretPath"]]],null,{"statements":[[0,"    "],[7,"li"],[12,"class",[28,[[27,"if",[[27,"is-active-route",[[22,1,["path"]],[22,1,["model"]]],[["isExact"],[true]]],"is-active"],null]]]],[9],[0,"\\n      "],[7,"span"],[11,"class","sep"],[9],[0,"/"],[10],[0,"\\n"],[4,"if",[[23,["linkToPaths"]]],null,{"statements":[[4,"link-to",null,[["params"],[[27,"array",[[22,1,["path"]],[22,1,["model"]]],null]]],{"statements":[[0,"\\n          "],[1,[22,1,["text"]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"        "],[7,"span"],[9],[1,[22,1,["text"]],false],[10],[0,"\\n"]],"parameters":[]}],[0,"    "],[10],[0,"\\n"]],"parameters":[1,2]},null],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/key-value-header.hbs"}})}),define("vault/templates/components/key-version-select",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"aDBifUpQ",block:'{"symbols":["version"],"statements":[[4,"if",[[27,"gt",[[23,["key","keysForEncryption","length"]],1],null]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","field"],[9],[0,"\\n    "],[7,"label"],[11,"for","key_version"],[11,"class","is-label"],[9],[0,"Key version"],[10],[0,"\\n    "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n      "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n        "],[7,"select"],[11,"name","key_version"],[11,"id","key_version"],[12,"onchange",[27,"action",[[22,0,[]],[23,["onVersionChange"]]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[23,["key","keysForEncryption"]]],null,{"statements":[[4,"if",[[27,"eq",[[22,1,[]],[23,["key","latestVersion"]]],null]],null,{"statements":[[0,"            "],[7,"option"],[12,"selected",[27,"if",[[23,["key_version"]],[27,"eq",[[22,1,[]],[23,["key_version"]]],null],[27,"eq",[[22,1,[]],[23,["key","latestVersion"]]],null]],null]],[11,"value","0"],[9],[0,"\\n              "],[1,[22,1,[]],false],[0," (latest)\\n            "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"            "],[7,"option"],[12,"selected",[27,"if",[[23,["key_version"]],[27,"eq",[[22,1,[]],[23,["key_version"]]],null],[27,"eq",[[22,1,[]],[23,["key","latestVersion"]]],null]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n              "],[1,[22,1,[]],false],[0,"\\n            "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[1]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/key-version-select.hbs"}})}),define("vault/templates/components/kv-object-editor",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"xSLL64be",block:'{"symbols":["row","index"],"statements":[[4,"if",[[23,["label"]]],null,{"statements":[[0,"  "],[7,"label"],[11,"class","title is-4"],[9],[0,"\\n    "],[1,[21,"label"],false],[0,"\\n"],[4,"if",[[23,["helpText"]]],null,{"statements":[[4,"info-tooltip",null,null,{"statements":[[0,"        "],[1,[21,"helpText"],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"  "],[10],[0,"\\n"]],"parameters":[]},null],[4,"each",[[23,["kvData"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","columns is-variable is-1"],[9],[0,"\\n    "],[7,"div"],[11,"class","column is-one-quarter"],[9],[0,"\\n      "],[1,[27,"input",null,[["value","placeholder","change","class"],[[22,1,["name"]],"key",[27,"action",[[22,0,[]],"updateRow",[22,1,[]],[22,2,[]]],null],"input"]]],false],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","column"],[9],[0,"\\n      "],[1,[27,"textarea",null,[["name","change","value","wrap","class","placeholder","rows"],[[22,1,["name"]],[27,"action",[[22,0,[]],"updateRow",[22,1,[]],[22,2,[]]],null],[22,1,["value"]],"off","input","value",1]]],false],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","column is-narrow"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["kvData","length"]],[27,"inc",[[22,2,[]]],null]],null]],null,{"statements":[[0,"        "],[7,"button"],[11,"class","button is-outlined is-primary"],[11,"type","button"],[3,"action",[[22,0,[]],"addRow"]],[9],[0,"\\n          Add\\n        "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"        "],[7,"button"],[11,"class","button has-text-grey is-expanded is-icon"],[11,"aria-label","Delete row"],[11,"type","button"],[3,"action",[[22,0,[]],"deleteRow",[22,1,[]],[22,2,[]]]],[9],[0,"\\n        "],[5,"icon",[],[["@glyph","@size"],["trash","l"]]],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[1,2]},null],[4,"if",[[23,["kvHasDuplicateKeys"]]],null,{"statements":[[0,"  "],[5,"alert-banner",[],[["@type","@message","@class"],["warning","More than one key shares the same name. Please be sure to have unique key names or some data may be lost when saving.","is-marginless"]]],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/kv-object-editor.hbs"}})}),define("vault/templates/components/license-info",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"f4N6PMDm",block:'{"symbols":["info","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,2,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"License"],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[2]}],[0,"\\n"],[5,"message-error",[],[["@model"],[[21,"model"]]]],[0,"\\n"],[4,"if",[[23,["isTemporary"]]],null,{"statements":[[0,"  "],[7,"section"],[11,"class","box is-sideless is-fullwidth"],[9],[0,"\\n    "],[5,"alert-banner",[],[["@type","@message","@class"],["warning",[28,["Your temporary license expires in ",[27,"date-from-now",[[23,["expirationTime"]]],null]," and your vault will seal. Please enter a valid license below."]],"license-warning"]]],[0,"\\n    "],[7,"span"],[11,"class","title is-5"],[9],[0,"Temporary license"],[10],[0,"\\n    "],[7,"form"],[3,"action",[[22,0,[]],"saveModel",[23,["text"]]],[["on"],["submit"]]],[9],[0,"\\n      "],[7,"div"],[11,"class","box is-shadowless is-fullwidth is-marginless"],[9],[0,"\\n        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","license-id"],[11,"class","is-label"],[9],[0,"License"],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"input",null,[["id","value","autocomplete","class"],["license-id",[23,["text"]],"off","input"]]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"Save"],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"section"],[11,"class","box is-sideless is-fullwidth"],[9],[0,"\\n    "],[7,"span"],[11,"class","title is-5"],[9],[0,"Details"],[10],[0,"\\n"],[4,"if",[[23,["showForm"]]],null,{"statements":[[0,"      "],[7,"form"],[3,"action",[[22,0,[]],"saveModel",[23,["text"]]],[["on"],["submit"]]],[9],[0,"\\n        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","license-id"],[11,"class","is-label"],[9],[0,"License"],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"input",null,[["id","value","autocomplete","class"],["license-id",[23,["text"]],"off","input"]]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","field is-grouped"],[9],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"Save"],[10],[0,"\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"toggleForm"]],[9],[0,"Cancel"],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[7,"div"],[11,"class","field box is-fullwidth is-shadowless is-paddingless is-marginless"],[9],[0,"\\n        "],[1,[27,"info-table-row",null,[["label","value"],["License ID",[23,["licenseId"]]]]],false],[0,"\\n"],[4,"info-table-row",null,[["label","value"],["Valid from",[23,["startTime"]]]],{"statements":[[0,"          "],[1,[27,"date-format",[[23,["model","startTime"]],"MMM DD, YYYY hh:mm:ss A"],null],false],[0," to "],[1,[27,"date-format",[[23,["expirationTime"]],"MMM DD, YYYY hh:mm:ss A"],null],false],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","field box is-fullwidth is-shadowless is-paddingless is-marginless"],[9],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"toggleForm"]],[9],[0,"Enter new license"],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]}],[0,"    "],[10],[0,"\\n"]],"parameters":[]}],[7,"section"],[11,"class","box is-sideless is-marginless is-shadowless is-fullwidth"],[9],[0,"\\n  "],[7,"span"],[11,"class","title is-5"],[9],[0,"Features"],[10],[0,"\\n  "],[7,"div"],[11,"class","field box is-fullwidth is-shadowless is-paddingless is-marginless"],[9],[0,"\\n"],[4,"each",[[23,["featuresInfo"]]],null,{"statements":[[4,"info-table-row",null,[["label","value"],[[22,1,["name"]],[27,"if",[[22,1,["active"]],"Active","Not Active"],null]]],{"statements":[[4,"if",[[22,1,["active"]]],null,{"statements":[[0,"        "],[5,"icon",[[11,"class","icon-true"],[11,"aria-hidden","true"]],[["@glyph","@size"],["check-circle-outline","l"]]],[7,"span"],[9],[0,"Active "],[4,"if",[[22,1,["count"]]],null,{"statements":[[0,"—\\n         "],[1,[22,1,["count"]],false],[0," standby nodes allotted"]],"parameters":[]},null],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"          "],[5,"icon",[[11,"class","icon-false"],[11,"aria-hidden","true"]],[["@glyph","@size"],["cancel-circle-outline","l"]]],[7,"span"],[9],[0,"Not Active"],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]},null]],"parameters":[1]},null],[0,"  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/license-info.hbs"}})}),define("vault/templates/components/logo-edition",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"c3sIr/lT",block:'{"symbols":[],"statements":[[7,"svg"],[11,"width","146"],[11,"height","51"],[11,"viewBox","0 0 146 51"],[11,"xmlns","http://www.w3.org/2000/svg","http://www.w3.org/2000/xmlns/"],[9],[0,"\\n  "],[7,"g"],[11,"id","vault-logo-v"],[11,"fill-rule","nonzero"],[9],[0,"\\n    "],[7,"path"],[11,"d","M0,0 L25.4070312,51 L51,0 L0,0 Z M28.5,10.5 L31.5,10.5 L31.5,13.5 L28.5,13.5 L28.5,10.5 Z M22.5,22.5 L19.5,22.5 L19.5,19.5 L22.5,19.5 L22.5,22.5 Z M22.5,18 L19.5,18 L19.5,15 L22.5,15 L22.5,18 Z M22.5,13.5 L19.5,13.5 L19.5,10.5 L22.5,10.5 L22.5,13.5 Z M26.991018,27 L24,27 L24,24 L27,24 L26.991018,27 Z M26.991018,22.5 L24,22.5 L24,19.5 L27,19.5 L26.991018,22.5 Z M26.991018,18 L24,18 L24,15 L27,15 L26.991018,18 Z M26.991018,13.5 L24,13.5 L24,10.5 L27,10.5 L26.991018,13.5 Z M28.5,15 L31.5,15 L31.5,18 L28.5089552,18 L28.5,15 Z M28.5,22.5 L28.5,19.5 L31.5,19.5 L31.5,22.4601182 L28.5,22.5 Z"],[9],[10],[0,"\\n  "],[10],[0,"\\n\\n  "],[7,"path"],[11,"id","vault-logo-name"],[11,"d","M69.7218638,30.2482468 L63.2587814,8.45301543 L58,8.45301543 L65.9885305,34.6072931 L73.4551971,34.6072931 L81.4437276,8.45301543 L76.1849462,8.45301543 L69.7218638,30.2482468 Z M97.6329749,22.0014025 C97.6329749,17.2103787 95.8265233,15.0897616 89.6845878,15.0897616 C87.5168459,15.0897616 84.8272401,15.4431978 82.9806452,15.9929874 L83.5827957,19.6451613 C85.3089606,19.2917251 87.2358423,19.056101 89.0021505,19.056101 C92.1333333,19.056101 92.7354839,19.802244 92.7354839,21.9228612 L92.7354839,23.9256662 L88.0387097,23.9256662 C84.0645161,23.9256662 82.3383513,25.4179523 82.3383513,29.3057504 C82.3383513,32.6044881 83.8637993,35 87.4365591,35 C89.4035842,35 91.4910394,34.4502104 93.2573477,33.3113604 L93.618638,34.6072931 L97.6329749,34.6072931 L97.6329749,22.0014025 Z M92.7354839,30.2089762 C91.8121864,30.7194951 90.4874552,31.1907433 89.0422939,31.1907433 C87.5168459,31.1907433 87.0752688,30.601683 87.0752688,29.2664797 C87.0752688,27.8134642 87.5168459,27.3814867 89.1225806,27.3814867 L92.7354839,27.3814867 L92.7354839,30.2089762 Z M102.421505,15.4824684 L102.421505,29.345021 C102.421505,32.7615708 103.585663,35 106.837276,35 C109.125448,35 112.216487,34.1753156 114.665233,32.997195 L115.146953,34.6072931 L118.880287,34.6072931 L118.880287,15.4824684 L113.982796,15.4824684 L113.982796,28.7559607 C112.216487,29.6591865 110.088889,30.3660589 108.884588,30.3660589 C107.760573,30.3660589 107.318996,29.85554 107.318996,28.8345021 L107.318996,15.4824684 L102.421505,15.4824684 Z M129.168459,34.6072931 L129.168459,7 L124.270968,7.66760168 L124.270968,34.6072931 L129.168459,34.6072931 Z M144.394265,30.601683 C143.551254,30.8373072 142.6681,30.9943899 141.94552,30.9943899 C140.660932,30.9943899 140.179211,30.3267882 140.179211,29.3057504 L140.179211,19.2917251 L144.875986,19.2917251 L145.197133,15.4824684 L140.179211,15.4824684 L140.179211,10.0631136 L135.28172,10.7307153 L135.28172,15.4824684 L132.351254,15.4824684 L132.351254,19.2917251 L135.28172,19.2917251 L135.28172,29.9340813 C135.28172,33.3506311 137.088172,35 140.660932,35 C141.905376,35 143.912545,34.6858345 144.956272,34.2538569 L144.394265,30.601683 Z"],[9],[10],[0,"\\n\\n"],[4,"if",[[27,"is-version",["Enterprise"],null]],null,{"statements":[[0,"    "],[7,"g"],[11,"id","vault-logo-edition-enterprise"],[11,"transform","translate(65.000000, 40.000000)"],[11,"fill-rule","nonzero"],[9],[0,"\\n      "],[7,"polygon"],[11,"points","0.435816733 0.579322709 4.39438247 0.579322709 4.39438247 1.35454183 1.30175299 1.35454183 1.30175299 3.46577689 4.17171315 3.46577689 4.17171315 4.24099602 1.30175299 4.24099602 1.30175299 6.52541833 4.40262948 6.52541833 4.40262948 7.30063745 0.435816733 7.30063745"],[9],[10],[0,"\\n      "],[7,"polygon"],[11,"points","7.3138247 1.58545817 7.3138247 7.31713147 6.48912351 7.31713147 6.48912351 0.579322709 7.68494024 0.579322709 10.6126295 6.35223108 10.6126295 0.579322709 11.4373307 0.579322709 11.4373307 7.31713147 10.249761 7.31713147"],[9],[10],[0,"\\n      "],[7,"polygon"],[11,"points","15.107251 1.36278884 13.1032271 1.36278884 13.1032271 0.587569721 17.9937052 0.587569721 17.9937052 1.36278884 15.9814343 1.36278884 15.9814343 7.31713147 15.107251 7.31713147"],[9],[10],[0,"\\n      "],[7,"polygon"],[11,"points","19.6513546 0.579322709 23.6099203 0.579322709 23.6099203 1.35454183 20.5172908 1.35454183 20.5172908 3.46577689 23.387251 3.46577689 23.387251 4.24099602 20.5172908 4.24099602 20.5172908 6.52541833 23.6181673 6.52541833 23.6181673 7.30063745 19.6431076 7.30063745"],[9],[10],[0,"\\n      "],[7,"path"],[11,"d","M28.22,4.87601594 L26.5705976,4.87601594 L26.5705976,7.35011952 L25.7046614,7.35011952 L25.7046614,0.579322709 L28.2694821,0.579322709 C29.7127092,0.579322709 30.2240239,1.20609562 30.2240239,2.2287251 L30.2240239,3.20187251 C30.3204128,3.92160892 29.8576792,4.59791178 29.1519124,4.76880478 L30.9002789,7.30888446 L29.9023904,7.30888446 L28.22,4.87601594 Z M28.22,1.35454183 L26.5705976,1.35454183 L26.5705976,4.10079681 L28.22,4.10079681 C29.0447012,4.10079681 29.3333466,3.86988048 29.3333466,3.21011952 L29.3333466,2.25346614 C29.3580876,1.58545817 29.0694422,1.36278884 28.244741,1.36278884 L28.22,1.35454183 Z"],[9],[10],[0,"\\n      "],[7,"path"],[11,"d","M32.6898805,0.579322709 L35.1639841,0.579322709 C36.6072112,0.579322709 37.1185259,1.20609562 37.1185259,2.2287251 L37.1185259,3.22661355 C37.1185259,4.26573705 36.6154582,4.87601594 35.1639841,4.87601594 L33.5970518,4.87601594 L33.5970518,7.31713147 L32.7311155,7.31713147 L32.6898805,0.579322709 Z M35.098008,1.35454183 L33.5640637,1.35454183 L33.5640637,4.12553785 L35.098008,4.12553785 C35.9227092,4.12553785 36.2113546,3.89462151 36.2113546,3.23486056 L36.2113546,2.24521912 C36.2113546,1.58545817 35.9309562,1.36278884 35.098008,1.36278884 L35.098008,1.35454183 Z"],[9],[10],[0,"\\n      "],[7,"path"],[11,"d","M41.4399602,4.87601594 L39.7905578,4.87601594 L39.7905578,7.35011952 L38.9246215,7.35011952 L38.9246215,0.579322709 L41.4894422,0.579322709 C42.9326693,0.579322709 43.4439841,1.20609562 43.4439841,2.2287251 L43.4439841,3.20187251 C43.5403729,3.92160892 43.0776394,4.59791178 42.3718725,4.76880478 L44.120239,7.30888446 L43.1223506,7.30888446 L41.4399602,4.87601594 Z M41.4399602,1.35454183 L39.7905578,1.35454183 L39.7905578,4.10079681 L41.4399602,4.10079681 C42.2646614,4.10079681 42.5533068,3.86988048 42.5533068,3.21011952 L42.5533068,2.25346614 C42.5698008,1.58545817 42.2894024,1.36278884 41.4564542,1.36278884 L41.4399602,1.35454183 Z"],[9],[10],[0,"\\n      "],[7,"polygon"],[11,"points","46.8087649 7.31713147 45.9840637 7.31713147 45.9840637 0.579322709 46.8087649 0.579322709"],[9],[10],[0,"\\n      "],[7,"path"],[11,"d","M50.9322709,7.41609562 C50.2485334,7.41749872 49.5699834,7.29742608 48.928247,7.0614741 L49.0684462,6.35223108 C49.6711823,6.54568134 50.2993133,6.64851694 50.9322709,6.65737052 C52.0126295,6.65737052 52.2352988,6.37697211 52.2352988,5.61 C52.2352988,4.70282869 52.2352988,4.62035857 50.8415538,4.30697211 C49.1921514,3.94410359 49.0189641,3.63071713 49.0189641,2.23697211 C49.0189641,1.06589641 49.5055378,0.49685259 51.1714343,0.49685259 C51.7856888,0.497823804 52.3976026,0.572582499 52.9940239,0.719521912 L52.9198008,1.45350598 C52.3508265,1.32930718 51.7702971,1.26572539 51.1879283,1.2638247 C50.0828287,1.2638247 49.8849004,1.48649402 49.8849004,2.26171315 C49.8849004,3.1936255 49.8849004,3.23486056 51.2209163,3.56474104 C53.0105179,4.01007968 53.1012351,4.27398406 53.1012351,5.58525896 C53.1342231,6.74808765 52.7878486,7.41609562 50.9322709,7.41609562 Z"],[9],[10],[0,"\\n      "],[7,"polygon"],[11,"points","55.2454582 0.579322709 59.1792829 0.579322709 59.1792829 1.35454183 56.0866534 1.35454183 56.0866534 3.46577689 58.9566135 3.46577689 58.9566135 4.24099602 56.0866534 4.24099602 56.0866534 6.52541833 59.1875299 6.52541833 59.1875299 7.30063745 55.2124701 7.30063745"],[9],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/logo-edition.hbs"}})}),define("vault/templates/components/logo-splash",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"pns5PTSV",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","is-flex-v-centered is-flex-1"],[9],[0,"\\n  "],[7,"div"],[11,"class","columns is-centered"],[9],[0,"\\n    "],[7,"div"],[11,"class","column is-narrow has-text-centered has-text-grey-dark has-current-color-fill"],[9],[0,"\\n      "],[5,"logo-edition",[],[[],[]]],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/logo-splash.hbs"}})})
define("vault/templates/components/menu-sidebar",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"wuAWpsfl",block:'{"symbols":["&default"],"statements":[[7,"aside"],[11,"class","menu"],[9],[0,"\\n"],[4,"if",[[23,["title"]]],null,{"statements":[[0,"    "],[7,"p"],[11,"class","menu-label"],[9],[0,"\\n      "],[1,[21,"title"],false],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n    "],[14,1],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","menu-toggle"],[9],[0,"\\n"],[4,"if",[[23,["isActive"]]],null,{"statements":[[0,"      "],[7,"button"],[11,"class","button is-ghost"],[11,"type","button"],[3,"action",[[22,0,[]],"closeMenu"]],[9],[0,"\\n        "],[5,"icon",[[11,"aria-label","Close menu"]],[["@glyph"],["cancel-plain"]]],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[7,"button"],[11,"class","button is-ghost has-text-grey-light"],[11,"type","button"],[3,"action",[[22,0,[]],"openMenu"]],[9],[0,"\\n        "],[5,"icon",[[11,"aria-label","Open menu"]],[["@glyph"],["more-vertical"]]],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]}],[0,"  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/menu-sidebar.hbs"}})}),define("vault/templates/components/mount-accessor-select",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"/nzvY0LV",block:'{"symbols":["method"],"statements":[[4,"if",[[23,["label"]]],null,{"statements":[[0,"  "],[7,"label"],[12,"for",[28,[[21,"name"]]]],[11,"class","is-label"],[9],[0,"\\n    "],[1,[21,"label"],false],[0,"\\n"],[4,"if",[[23,["helpText"]]],null,{"statements":[[4,"info-tooltip",null,null,{"statements":[[0,"        "],[7,"span"],[9],[1,[21,"helpText"],false],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"  "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["authMethods","isRunning"]]],null,{"statements":[[0,"  "],[7,"div"],[9],[0,"\\n    "],[7,"span"],[11,"class","loader is-inline-block"],[9],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["authMethods","last","value"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n    "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n      "],[7,"select"],[12,"name",[21,"name"]],[12,"id",[21,"name"]],[12,"onchange",[27,"action",[[22,0,[]],"change"],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[23,["authMethods","last","value"]]],null,{"statements":[[0,"          "],[7,"option"],[12,"selected",[27,"eq",[[23,["value"]],[22,1,["accessor"]]],null]],[12,"value",[22,1,["accessor"]]],[9],[0,"\\n          "],[1,[22,1,["path"]],false],[0," ("],[1,[22,1,["type"]],false],[0,")\\n          "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"input"],[12,"name",[21,"name"]],[12,"id",[21,"name"]],[11,"class","input"],[12,"value",[21,"value"]],[11,"placeholder","Mount accessor"],[12,"onchange",[27,"action",[[22,0,[]],"change"],[["value"],["target.value"]]]],[9],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/mount-accessor-select.hbs"}})}),define("vault/templates/components/mount-backend-form",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"wXZG2sR6",block:'{"symbols":["category","type","p","typeInfo"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,3,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n"],[4,"if",[[23,["showEnable"]]],null,{"statements":[[4,"with",[[27,"find-by",["type",[23,["mountModel","type"]],[23,["mountTypes"]]],null]],null,{"statements":[[0,"          "],[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph","@size"],[[27,"or",[[22,4,["glyph"]],[22,4,["type"]]],null],"l"]]],[0,"\\n\\n"],[4,"if",[[27,"eq",[[23,["mountType"]],"auth"],null]],null,{"statements":[[0,"            "],[1,[27,"concat",["Enable ",[22,4,["displayName"]]," Authentication Method"],null],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"            "],[1,[27,"concat",["Enable ",[22,4,["displayName"]]," Secrets Engine"],null],false],[0,"\\n"]],"parameters":[]}]],"parameters":[4]},null]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["mountType"]],"auth"],null]],null,{"statements":[[0,"        Enable an Authentication Method\\n"]],"parameters":[]},{"statements":[[0,"        Enable a Secrets Engine\\n      "]],"parameters":[]}]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[3]}],[0,"\\n"],[7,"form"],[3,"action",[[22,0,[]],[27,"perform",[[23,["mountBackend"]]],null]],[["on"],["submit"]]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["enable",[27,"if",[[27,"eq",[[23,["mountType"]],"auth"],null],"Auth Method","Secret Engine"],null]]]],[0,"\\n\\n    "],[1,[27,"message-error",null,[["model"],[[23,["mountModel"]]]]],false],[0,"\\n"],[4,"if",[[23,["showEnable"]]],null,{"statements":[[0,"      "],[1,[27,"form-field-groups",null,[["model","onChange","renderGroup"],[[23,["mountModel"]],[27,"action",[[22,0,[]],"onTypeChange"],null],"default"]]],false],[0,"\\n      "],[1,[27,"form-field-groups",null,[["model","onChange","renderGroup"],[[23,["mountModel"]],[27,"action",[[22,0,[]],"onTypeChange"],null],"Method Options"]]],false],[0,"\\n"]],"parameters":[]},{"statements":[[4,"each",[[27,"array",["generic","cloud","infra"],null]],null,{"statements":[[0,"        "],[7,"h3"],[11,"class","title box-radio-header"],[9],[0,"\\n          "],[1,[27,"capitalize",[[22,1,[]]],null],false],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","box-radio-container"],[9],[0,"\\n"],[4,"each",[[27,"filter-by",["category",[22,1,[]],[23,["mountTypes"]]],null]],null,{"statements":[[0,"            "],[7,"label"],[12,"for",[22,2,["type"]]],[12,"class",[28,["box-radio\\n                ",[27,"if",[[27,"eq",[[23,["mountModel","type"]],[22,2,["type"]]],null]," is-selected"],null]]]],[9],[0,"\\n              "],[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph","@size"],[[27,"or",[[22,2,["glyph"]],[22,2,["type"]]],null],"xl"]]],[0,"\\n\\n              "],[1,[22,2,["displayName"]],false],[0,"\\n              "],[5,"radio-button",[],[["@value","@radioClass","@groupValue","@changed","@name","@radioId"],[[22,2,["type"]],"radio",[23,["mountModel","type"]],[27,"queue",[[27,"action",[[22,0,[]],[27,"mut",[[23,["mountModel","type"]]],null]],null],[27,"action",[[22,0,[]],"onTypeChange","type"],null]],null],"mount-type",[22,2,["type"]]]]],[0,"\\n\\n              "],[7,"label"],[12,"for",[22,2,["type"]]],[9],[10],[0,"\\n            "],[10],[0,"\\n"]],"parameters":[2]},null],[0,"        "],[10],[0,"\\n"]],"parameters":[1]},null]],"parameters":[]}],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n"],[4,"if",[[23,["showEnable"]]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["mountBackend","isRunning"]],"loading"],null]]]],[12,"disabled",[23,["mountBackend","isRunning"]]],[11,"type","submit"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mountType"]],"auth"],null]],null,{"statements":[[0,"            Enable Method\\n"]],"parameters":[]},{"statements":[[0,"            Enable Engine\\n"]],"parameters":[]}],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button"],[12,"onclick",[27,"action",[[22,0,[]],"toggleShowEnable",false],null]],[11,"type","button"],[9],[0,"\\n          Back\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[7,"button"],[11,"class","button is-primary"],[12,"onclick",[27,"action",[[22,0,[]],"toggleShowEnable",true],null]],[12,"disabled",[27,"not",[[23,["mountModel","type"]]],null]],[11,"type","button"],[9],[0,"\\n        Next\\n      "],[10],[0,"\\n"]],"parameters":[]}],[0,"  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/mount-backend-form.hbs"}})}),define("vault/templates/components/mount-info",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"oEmgoMId",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[1,[27,"key-value-header",null,[["baseKey","path","root","showCurrent"],[[23,["model"]],"vault.cluster.access.method",[23,["root"]],true]]],false],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      "],[1,[27,"capitalize",[[23,["model","methodType"]]],null],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["levelRight"]],[],[[],[]],{"statements":[[0,"\\n"],[4,"if",[[27,"eq",[[23,["section"]],"configuration"],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","field is-grouped"],[9],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.settings.auth.configure",[23,["model","id"]]],[["class"],["button is-ghost has-icon-right is-compact"]],{"statements":[[0,"            Configure\\n            "],[5,"chevron",[],[[],[]]],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n"],[1,[27,"section-tabs",[[23,["model"]],"authShow"],null],false],[0,"\\n"],[1,[27,"component",[[27,"concat",["auth-method/",[23,["section"]]],null]],[["model"],[[23,["model"]]]]],false]],"hasEval":false}',meta:{moduleName:"vault/templates/components/mount-info.hbs"}})}),define("vault/templates/components/namespace-link",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"7/9lBUUe",block:'{"symbols":["&default"],"statements":[[5,"link-to",[[12,"class",[27,"concat",["is-block ",[23,["class"]]],null]]],[["@params"],[[27,"array",["vault.cluster.secrets",[27,"query-params",null,[["namespace"],[[22,0,["normalizedNamespace"]]]]]],null]]],{"statements":[[0,"\\n"],[4,"if",[[24,1]],null,{"statements":[[0,"    "],[14,1],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n      "],[7,"span"],[11,"class","level-left"],[9],[1,[22,0,["namespaceDisplay"]],false],[10],[0,"\\n      "],[7,"span"],[11,"class","level-right"],[9],[0,"\\n        "],[7,"button"],[11,"class","button is-ghost icon"],[11,"type","button"],[9],[0,"\\n          "],[5,"chevron",[[11,"class","has-text-grey"]],[["@isButton"],[true]]],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/namespace-link.hbs"}})}),define("vault/templates/components/namespace-picker",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Hq5M2hk8",block:'{"symbols":["D","leaf","( unused value )","leafName","rootLeaf","&default"],"statements":[[4,"if",[[27,"and",[[27,"not",[[23,["accessibleNamespaces","length"]]],null],[23,["inRootNamespace"]]],null]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","namespace-picker no-namespaces"],[9],[0,"\\n"],[0,"    "],[14,6],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"div"],[11,"class","namespace-picker"],[9],[0,"\\n    "],[5,"basic-dropdown",[],[["@horizontalPosition","@verticalPosition"],["auto-left","below"]],{"statements":[[0,"\\n      "],[6,[22,1,["trigger"]],[],[["@tagName","@class"],["button","button is-transparent namespace-picker-trigger has-current-color"]],{"statements":[[0,"\\n        "],[14,6],[0,"\\n"],[4,"if",[[23,["namespaceDisplay"]]],null,{"statements":[[0,"          "],[7,"span"],[11,"class","namespace-name"],[9],[1,[21,"namespaceDisplay"],false],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"          "],[7,"span"],[11,"class","namespace-name is-hidden-tablet"],[9],[0,"/ (Root)"],[10],[0,"\\n"]],"parameters":[]}],[0,"        "],[5,"chevron",[],[["@direction","@class"],["down","has-text-white auto-width is-status-chevron"]]],[0,"\\n      "]],"parameters":[]}],[0,"\\n      "],[6,[22,1,["content"]],[],[["@class"],["namespace-picker-content"]],{"statements":[[0,"\\n        "],[7,"div"],[11,"class","namespace-header-bar level is-mobile"],[9],[0,"\\n          "],[7,"div"],[11,"class","level-left"],[9],[0,"\\n"],[4,"if",[[27,"not",[[23,["isUserRootNamespace"]]],null]],null,{"statements":[[0,"              "],[5,"namespace-link",[],[["@targetNamespace","@class"],[[27,"or",[[27,"object-at",[[27,"dec",[2,[23,["menuLeaves","length"]]],null],[23,["lastMenuLeaves"]]],null],[23,["auth","authData","userRootNamespace"]]],null],"namespace-link button is-ghost icon"]],{"statements":[[0,"\\n                "],[5,"chevron",[],[["@direction","@class"],["left","has-text-info"]]],[0,"\\n              "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n          "],[7,"div"],[11,"class","level-right"],[9],[0,"\\n"],[4,"if",[[23,["canList"]]],null,{"statements":[[4,"link-to",["vault.cluster.access.namespaces"],[["class"],["namespace-manage-link"]],{"statements":[[0,"                Manage\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"header"],[11,"class","current-namespace"],[9],[0,"\\n          "],[7,"h5"],[11,"class","list-header"],[9],[0,"Current namespace"],[10],[0,"\\n          "],[7,"div"],[11,"class","level is-mobile namespace-link"],[9],[0,"\\n            "],[7,"span"],[11,"class","level-left"],[9],[1,[27,"if",[[23,["namespacePath"]],[27,"concat",[[23,["namespacePath"]],"/"],null],"root"],null],false],[10],[0,"\\n            "],[7,"span"],[11,"class","level-right"],[9],[0,"\\n              "],[5,"icon",[[11,"class","has-text-success"]],[["@glyph"],["check-circle-outline"]]],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[12,"class",[28,["namespace-list ",[27,"if",[[23,["isAnimating"]],"animated-list"],null]]]],[9],[0,"\\n"],[4,"if",[[27,"contains",["",[23,["lastMenuLeaves"]]],null]],null,{"statements":[[0,"            "],[7,"div"],[12,"class",[28,["leaf-panel\\n              ",[27,"if",[[27,"eq",["",[23,["currentLeaf"]]],null],"leaf-panel-current","leaf-panel-left"],null],"\\n            "]]],[9],[4,"each",[[23,["rootLeaves"]]],null,{"statements":[[0,"\\n                "],[5,"namespace-link",[],[["@targetNamespace","@class","@showLastSegment"],[[22,5,[]],"namespace-link",true]]],[0,"\\n              "]],"parameters":[5]},null],[10],[0,"\\n"]],"parameters":[]},null],[4,"each",[[23,["lastMenuLeaves"]]],null,{"statements":[[0,"              "],[7,"div"],[12,"class",[28,["leaf-panel\\n                ",[27,"if",[[27,"eq",[[22,2,[]],[23,["currentLeaf"]]],null],"leaf-panel-current","leaf-panel-left"],null],"\\n                ",[27,"if",[[27,"and",[[23,["isAdding"]],[27,"eq",[[22,2,[]],[23,["changedLeaf"]]],null]],null],"leaf-panel-adding"],null],"\\n                ",[27,"if",[[27,"and",[[27,"not",[[23,["isAdding"]]],null],[27,"eq",[[22,2,[]],[23,["changedLeaf"]]],null]],null],"leaf-panel-exiting"],null],"\\n              "]]],[9],[4,"each",[[27,"-each-in",[[27,"get",[[23,["namespaceTree"]],[22,2,[]]],null]],null]],null,{"statements":[[0,"\\n              "],[5,"namespace-link",[],[["@targetNamespace","@class","@showLastSegment"],[[27,"concat",[[22,2,[]],"/",[22,4,[]]],null],"namespace-link",true]]],[0,"\\n                "]],"parameters":[3,4]},null],[10],[0,"\\n"]],"parameters":[2]},null],[0,"        "],[10],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[1]}],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","navbar-separator"],[9],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/namespace-picker.hbs"}})}),define("vault/templates/components/nav-header",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"bU4YLI5l",block:'{"symbols":["&default"],"statements":[[7,"nav"],[11,"class","navbar"],[9],[0,"\\n  "],[7,"div"],[11,"class","navbar-brand"],[9],[0,"\\n    "],[14,1,[[27,"hash",null,[["home"],[[27,"component",["nav-header/home"],null]]]]]],[0,"\\n  "],[10],[0,"\\n\\n"],[4,"unless",[[23,["navDrawerOpen"]]],null,{"statements":[[0,"  "],[7,"button"],[11,"class","navbar-drawer-toggle is-hidden-tablet"],[3,"action",[[22,0,[]],"toggleNavDrawer"]],[9],[0,"\\n      "],[5,"icon",[],[["@glyph"],["more-vertical"]]],[0," Menu\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"\\n  "],[7,"div"],[12,"class",[28,["navbar-drawer",[27,"if",[[23,["navDrawerOpen"]]," is-active"],null]]]],[9],[0,"\\n    "],[7,"div"],[11,"class","navbar-drawer-scroll"],[9],[0,"\\n      "],[7,"div"],[9],[0,"\\n        "],[14,1,[[27,"hash",null,[["main","closeDrawer"],[[27,"component",["nav-header/main"],null],[27,"action",[[22,0,[]],"toggleNavDrawer",false],null]]]]]],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","navbar-end"],[9],[0,"\\n        "],[14,1,[[27,"hash",null,[["items","closeDrawer"],[[27,"component",["nav-header/items"],null],[27,"action",[[22,0,[]],"toggleNavDrawer",false],null]]]]]],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n\\n"],[4,"if",[[23,["navDrawerOpen"]]],null,{"statements":[[0,"      "],[7,"button"],[11,"class"," navbar-drawer-toggle is-hidden-tablet"],[11,"type","button"],[3,"action",[[22,0,[]],"toggleNavDrawer",false]],[9],[0,"\\n        "],[5,"icon",[],[["@glyph"],["cancel-plain"]]],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[10],[0,"\\n\\n  "],[7,"div"],[12,"class",[28,["navbar-drawer-overlay",[27,"if",[[23,["navDrawerOpen"]]," is-active"],null]]]],[12,"onclick",[27,"action",[[22,0,[]],"toggleNavDrawer",[27,"not",[[23,["navDrawerOpen"]]],null]],null]],[9],[10],[0,"\\n"],[10],[0,"\\n"],[1,[27,"console/ui-panel",null,[["isFullscreen"],[[23,["consoleFullscreen"]]]]],false],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/nav-header.hbs"}})}),define("vault/templates/components/nav-header/home",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"pKYBGB7H",block:'{"symbols":["&default"],"statements":[[14,1],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/nav-header/home.hbs"}})}),define("vault/templates/components/nav-header/items",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"/vXCZ5IT",block:'{"symbols":["&default"],"statements":[[14,1],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/nav-header/items.hbs"}})}),define("vault/templates/components/nav-header/main",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"XkXB802k",block:'{"symbols":["&default"],"statements":[[14,1],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/nav-header/main.hbs"}})}),define("vault/templates/components/not-found",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"nC71micr",block:'{"symbols":["p"],"statements":[[7,"div"],[11,"class","box is-shadowless"],[9],[0,"\\n  "],[5,"page-header",[],[[],[]],{"statements":[[0,"\\n    "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n      "],[7,"h1"],[11,"class","title is-3 has-text-grey"],[9],[0,"\\n        404 Not Found\\n      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[1]}],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless has-background-white-bis has-text-grey has-text-centered"],[9],[0,"\\n    "],[7,"p"],[9],[0,"Sorry, we were unable to find any content at "],[7,"code"],[9],[1,[27,"or",[[23,["model","path"]],[23,["path"]]],null],false],[10],[0,"."],[10],[0,"\\n    "],[7,"p"],[9],[0,"Double check the url or go back "],[1,[27,"home-link",null,[["text"],["home"]]],false],[0,"."],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/not-found.hbs"}})}),define("vault/templates/components/pgp-file",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"e+xpa3aJ",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n  "],[7,"div"],[11,"class","level-left"],[9],[0,"\\n    "],[7,"label"],[11,"class","is-label"],[9],[0,"\\n"],[4,"if",[[23,["label"]]],null,{"statements":[[0,"        "],[1,[21,"label"],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"        PGP KEY "],[1,[27,"if",[[27,"not-eq",[[23,["index"]],""],null],[27,"inc",[[23,["index"]]],null]],null],false],[0,"\\n"]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","level-right"],[9],[0,"\\n    "],[7,"div"],[11,"class","control is-flex"],[9],[0,"\\n      "],[7,"input"],[12,"id",[27,"concat",["useText-",[23,["elementId"]]],null]],[12,"name",[27,"concat",["useText-",[23,["elementId"]]],null]],[11,"class","switch is-rounded is-success is-small"],[12,"checked",[23,["key","enterAsText"]]],[12,"onchange",[27,"action",[[22,0,[]],[27,"toggle",["enterAsText",[23,["key"]]],null]],null]],[11,"type","checkbox"],[9],[10],[0,"\\n      "],[7,"label"],[12,"for",[27,"concat",["useText-",[23,["elementId"]]],null]],[9],[0,"\\n        Enter as text\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"],[7,"div"],[11,"class","field"],[9],[0,"\\n"],[4,"if",[[23,["key","enterAsText"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"textarea"],[11,"class","textarea"],[12,"oninput",[27,"action",[[22,0,[]],"updateData"],null]],[9],[1,[23,["key","value"]],false],[10],[0,"    "],[10],[0,"\\n    "],[7,"p"],[11,"class","help has-text-grey"],[9],[0,"\\n"],[4,"if",[[23,["textareaHelpText"]]],null,{"statements":[[0,"        "],[1,[21,"textareaHelpText"],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"        Enter a base64-encoded key\\n"]],"parameters":[]}],[0,"    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n      "],[7,"div"],[11,"class","file"],[9],[0,"\\n        "],[7,"label"],[11,"class","file-label is-fullwidth"],[9],[0,"\\n          "],[7,"input"],[11,"class","file-input"],[12,"onchange",[27,"action",[[22,0,[]],"pickedFile"],null]],[11,"type","file"],[9],[10],[0,"\\n          "],[7,"span"],[11,"class","file-cta is-fullwidth"],[9],[0,"\\n            "],[7,"span"],[11,"class","file-icon has-text-grey-dark"],[9],[0,"\\n              "],[5,"icon",[],[["@glyph"],["file-outline"]]],[0,"\\n            "],[10],[0,"\\n            "],[7,"span"],[11,"class","file-label has-text-grey-dark"],[9],[0,"\\n"],[4,"if",[[23,["key","fileName"]]],null,{"statements":[[0,"                "],[1,[23,["key","fileName"]],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"                Choose a file…\\n"]],"parameters":[]}],[0,"            "],[10],[0,"\\n"],[4,"if",[[23,["key","fileName"]]],null,{"statements":[[0,"              "],[7,"button"],[11,"class","file-delete-button"],[11,"type","button"],[3,"action",[[22,0,[]],"clearKey"]],[9],[0,"\\n                "],[5,"icon",[],[["@glyph","@aria-label"],["cancel-plain","Close"]]],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"p"],[11,"class","help has-text-grey"],[9],[0,"\\n"],[4,"if",[[23,["fileHelpText"]]],null,{"statements":[[0,"        "],[1,[21,"fileHelpText"],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"        Select a PGP key from your computer\\n"]],"parameters":[]}],[0,"    "],[10],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/pgp-file.hbs"}})}),define("vault/templates/components/pgp-list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"XKkGP0mJ",block:'{"symbols":["key","index"],"statements":[[4,"each",[[23,["listData"]]],null,{"statements":[[0,"  "],[1,[27,"pgp-file",null,[["key","index","onChange"],[[22,1,[]],[22,2,[]],[27,"action",[[22,0,[]],"setKey"],null]]]],false],[0,"\\n"]],"parameters":[1,2]},{"statements":[[0,"  "],[7,"p"],[11,"class","has-text-grey"],[9],[0,"\\n    Enter a number of Key Shares to enter PGP keys.\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/pgp-list.hbs"}})}),define("vault/templates/components/pki-cert-popup",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"uqiXp3tU",block:'{"symbols":[],"statements":[[4,"popup-menu",null,[["name","contentClass"],["role-aws-nav","is-wide"]],{"statements":[[0,"  "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n    "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n      "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.show",[23,["item","idForNav"]]],null,{"statements":[[0,"          Details\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"],[4,"if",[[23,["item","canRevoke"]]],null,{"statements":[[0,"        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction","@confirmTitle","@confirmMessage","@confirmButtonText"],["link is-destroy",[27,"action",[[22,0,[]],"delete",[23,["item"]]],null],"Revoke this cert?","Any services using this cert may be affected.","Revoke"]],{"statements":[[0,"\\n            Revoke\\n          "]],"parameters":[]}],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/pki-cert-popup.hbs"}})}),define("vault/templates/components/pki-cert-show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"4ZeXrNaW",block:'{"symbols":["attr","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,2,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[1,[27,"key-value-header",null,[["baseKey","path","mode","root","showCurrent"],[[27,"hash",null,[["display","id"],[[23,["model","id"]],[23,["model","idForNav"]]]]],"vault.cluster.secrets.backend.list",[23,["mode"]],[23,["root"]],true]]],false],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,2,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      PKI Certificate\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[2]}],[0,"\\n\\n"],[7,"div"],[11,"class","box is-fullwidth is-sideless is-paddingless is-marginless"],[9],[0,"\\n  "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n"],[4,"each",[[23,["model","attrs"]]],null,{"statements":[[4,"if",[[27,"eq",[[22,1,["type"]],"object"],null]],null,{"statements":[[0,"      "],[1,[27,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,1,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,1,["name"]]],null]],null]],null]],null],[27,"stringify",[[27,"get",[[23,["model"]],[22,1,["name"]]],null]],null]]]],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[1,[27,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,1,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,1,["name"]]],null]],null]],null]],null],[27,"get",[[23,["model"]],[22,1,["name"]]],null]]]],false],[0,"\\n"]],"parameters":[]}]],"parameters":[1]},null],[10],[0,"\\n"],[7,"div"],[11,"class","field is-grouped is-grouped-split box is-fullwidth is-bottomless"],[9],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[23,["model","toCreds"]],"button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Credentials copied!"],null]],null]]],{"statements":[[0,"        Copy credentials\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.list-root",[27,"query-params",null,[["tab"],["certs"]]]],[["class"],["button"]],{"statements":[[0,"        Back\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[4,"if",[[27,"and",[[27,"not",[[23,["model","revocationTime"]]],null],[23,["model","canRevoke"]]],null]],null,{"statements":[[0,"    "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction","@confirmTitle","@confirmMessage","@confirmButtonText"],["button",[27,"action",[[22,0,[]],"delete"],null],"Revoke this cert?","Any services using this cert may be affected.","Revoke"]],{"statements":[[0,"\\n      Revoke\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/pki-cert-show.hbs"}})}),define("vault/templates/components/radial-progress",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"63ugez9l",block:'{"symbols":[],"statements":[[7,"circle"],[11,"class","path"],[12,"cx",[28,[[21,"centerValue"]]]],[12,"cy",[28,[[21,"centerValue"]]]],[12,"r",[28,[[21,"r"]]]],[11,"fill","none"],[12,"stroke-width",[28,[[21,"strokeWidth"]]]],[9],[10],[0,"\\n"],[7,"circle"],[11,"class","progress-fill"],[12,"cx",[28,[[21,"centerValue"]]]],[12,"cy",[28,[[21,"centerValue"]]]],[12,"r",[28,[[21,"r"]]]],[11,"fill","none"],[12,"stroke-width",[28,[[21,"strokeWidth"]]]],[12,"stroke-dasharray",[28,[[21,"c"]]]],[12,"stroke-dashoffset",[28,[[21,"dashArrayOffset"]]]],[9],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/radial-progress.hbs"}})}),define("vault/templates/components/role-aws-edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"FtrC+6aX",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[1,[27,"key-value-header",null,[["baseKey","path","mode","root","showCurrent"],[[23,["model"]],"vault.cluster.secrets.backend.list",[23,["mode"]],[23,["root"]],true]]],false],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"create"],null]],null,{"statements":[[0,"        Create an AWS Role\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["mode"]],"edit"],null]],null,{"statements":[[0,"        Edit AWS Role "],[7,"code"],[9],[1,[23,["model","id"]],false],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"        AWS Role "],[7,"code"],[9],[1,[23,["model","id"]],false],[10],[0,"\\n      "]],"parameters":[]}]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"show"],null]],null,{"statements":[[0,"  "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n"],[4,"if",[[23,["model","canGenerate"]]],null,{"statements":[[0,"        "],[5,"toolbar-secret-link",[],[["@secret","@mode"],[[23,["model","id"]],"credentials"]],{"statements":[[0,"\\n          Generate credentials\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"and",[[23,["model","canGenerate"]],[27,"or",[[23,["model","canDelete"]],[23,["model","canEdit"]]],null]],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","toolbar-separator"],[9],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["model","canDelete"]]],null,{"statements":[[0,"        "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction"],["toolbar-link",[27,"action",[[22,0,[]],"delete"],null]]],{"statements":[[0,"\\n          Delete role\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["model","canEdit"]]],null,{"statements":[[0,"        "],[5,"toolbar-secret-link",[],[["@secret","@mode","@replace"],[[23,["model","id"]],"edit","true"]],{"statements":[[0,"\\n          Edit role\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"if",[[27,"or",[[27,"eq",[[23,["mode"]],"edit"],null],[27,"eq",[[23,["mode"]],"create"],null]],null]],null,{"statements":[[0,"  "],[15,"partials/role-aws/form",[]],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[15,"partials/role-aws/show",[]],[0,"\\n"]],"parameters":[]}]],"hasEval":true}',meta:{moduleName:"vault/templates/components/role-aws-edit.hbs"}})}),define("vault/templates/components/role-pki-edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"x8ZWLTU+",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[1,[27,"key-value-header",null,[["baseKey","path","mode","root","showCurrent"],[[23,["model"]],"vault.cluster.secrets.backend.list",[23,["mode"]],[23,["root"]],true]]],false],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"create"],null]],null,{"statements":[[0,"        Create a PKI Role\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["mode"]],"edit"],null]],null,{"statements":[[0,"        Edit PKI Role\\n"]],"parameters":[]},{"statements":[[0,"        PKI Role "],[7,"code"],[9],[1,[23,["model","id"]],false],[10],[0,"\\n      "]],"parameters":[]}]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"show"],null]],null,{"statements":[[0,"  "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n"],[4,"if",[[23,["model","canGenerate"]]],null,{"statements":[[0,"        "],[5,"toolbar-secret-link",[],[["@secret","@mode","@queryParams"],[[23,["model","id"]],"credentials",[27,"query-params",null,[["action"],["issue"]]]]],{"statements":[[0,"\\n          Generate Certificate\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["model","canSign"]]],null,{"statements":[[0,"        "],[5,"toolbar-secret-link",[],[["@secret","@mode","@queryParams"],[[23,["model","id"]],"credentials",[27,"query-params",null,[["action"],["sign"]]]]],{"statements":[[0,"\\n          Sign Certificate\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"and",[[27,"or",[[23,["model","canGenerate"]],[23,["model","canSign"]]],null],[27,"or",[[23,["model","canDelete"]],[23,["model","canEdit"]]],null]],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","toolbar-separator"],[9],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["model","canDelete"]]],null,{"statements":[[0,"        "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction"],["toolbar-link",[27,"action",[[22,0,[]],"delete"],null]]],{"statements":[[0,"\\n          Delete role\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["model","canEdit"]]],null,{"statements":[[0,"        "],[5,"toolbar-secret-link",[],[["@secret","@mode","@replace"],[[23,["model","id"]],"edit","true"]],{"statements":[[0,"\\n          Edit role\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"if",[[27,"or",[[27,"eq",[[23,["mode"]],"edit"],null],[27,"eq",[[23,["mode"]],"create"],null]],null]],null,{"statements":[[0,"  "],[15,"partials/role-pki/form",[]],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[15,"partials/role-pki/show",[]],[0,"\\n"]],"parameters":[]}]],"hasEval":true}',meta:{moduleName:"vault/templates/components/role-pki-edit.hbs"}})}),define("vault/templates/components/role-ssh-edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"26wlW1XK",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[1,[27,"key-value-header",null,[["baseKey","path","mode","root","showCurrent"],[[23,["model"]],"vault.cluster.secrets.backend.list",[23,["mode"]],[23,["root"]],true]]],false],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"create"],null]],null,{"statements":[[0,"        Create an SSH role\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["mode"]],"edit"],null]],null,{"statements":[[0,"        Edit SSH role\\n"]],"parameters":[]},{"statements":[[0,"        SSH role "],[7,"code"],[9],[1,[23,["model","id"]],false],[10],[0,"\\n      "]],"parameters":[]}]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"show"],null]],null,{"statements":[[0,"  "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n"],[4,"if",[[27,"eq",[[23,["model","keyType"]],"otp"],null]],null,{"statements":[[0,"        "],[5,"toolbar-secret-link",[],[["@secret","@mode","@replace"],[[23,["model","id"]],"credentials","true"]],{"statements":[[0,"\\n         Generate Credential\\n       "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[0,"        "],[5,"toolbar-secret-link",[],[["@secret","@mode","@replace"],[[23,["model","id"]],"sign","true"]],{"statements":[[0,"\\n          Sign Keys\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[4,"if",[[27,"or",[[23,["model","canUpdate"]],[23,["model","canDelete"]]],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","toolbar-separator"],[9],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["model","canDelete"]]],null,{"statements":[[0,"        "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction"],["toolbar-link",[27,"action",[[22,0,[]],"delete"],null]]],{"statements":[[0,"\\n          Delete role\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"or",[[23,["model","canUpdate"]],[23,["model","canDelete"]]],null]],null,{"statements":[[0,"        "],[5,"toolbar-secret-link",[],[["@secret","@mode","@replace"],[[23,["model","id"]],"edit","true"]],{"statements":[[0,"\\n          Edit role\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"if",[[27,"or",[[27,"eq",[[23,["mode"]],"edit"],null],[27,"eq",[[23,["mode"]],"create"],null]],null]],null,{"statements":[[0,"  "],[15,"partials/role-ssh/form",[]],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[15,"partials/role-ssh/show",[]],[0,"\\n"]],"parameters":[]}]],"hasEval":true}',meta:{moduleName:"vault/templates/components/role-ssh-edit.hbs"}})}),define("vault/templates/components/search-select-placeholder",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"I73KEbI0",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","field"],[9],[0,"\\n  "],[7,"p"],[11,"class","control has-icons-left has-icons-right"],[9],[0,"\\n    "],[7,"span"],[11,"class","input has-text-grey-light"],[9],[0,"Search"],[10],[0,"\\n    "],[5,"icon",[[11,"class","search-icon has-text-grey-light"],[11,"aria-hidden","true"]],[["@glyph"],["search"]]],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/search-select-placeholder.hbs"}})}),define("vault/templates/components/search-select",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"P7ccwig+",block:'{"symbols":["selected","option"],"statements":[[4,"if",[[23,["shouldUseFallback"]]],null,{"statements":[[0,"  "],[1,[27,"component",[[23,["fallbackComponent"]]],[["label","onChange","inputValue","helpText"],[[23,["label"]],[27,"action",[[22,0,[]],"onChange"],null],[23,["inputValue"]],[23,["helpText"]]]]],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"label"],[11,"class","title is-4"],[9],[0,"\\n    "],[1,[21,"label"],false],[0,"\\n"],[4,"if",[[23,["helpText"]]],null,{"statements":[[0,"      "],[4,"info-tooltip",null,null,{"statements":[[1,[21,"helpText"],false]],"parameters":[]},null],[0,"\\n"]],"parameters":[]},null],[0,"  "],[10],[0,"\\n"],[4,"power-select-with-create",null,[["options","onchange","oncreate","placeholderComponent","renderInPlace","searchField","verticalPosition","showCreateWhen","buildSuggestion"],[[23,["options"]],[27,"action",[[22,0,[]],"selectOption"],null],[27,"action",[[22,0,[]],"createOption"],null],[27,"component",["search-select-placeholder"],null],true,"searchText","below",[27,"action",[[22,0,[]],"hideCreateOptionOnSameID"],null],[27,"action",[[22,0,[]],"constructSuggestion"],null]]],{"statements":[[4,"if",[[23,["shouldRenderName"]]],null,{"statements":[[0,"      "],[1,[22,2,["name"]],false],[0,"\\n      "],[7,"small"],[11,"class","search-select-list-key"],[9],[0,"\\n        "],[1,[22,2,["id"]],false],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[1,[22,2,["id"]],false],[0,"\\n"]],"parameters":[]}]],"parameters":[2]},null],[0,"  "],[7,"ul"],[11,"class","search-select-list"],[9],[0,"\\n"],[4,"each",[[23,["selectedOptions"]]],null,{"statements":[[0,"      "],[7,"li"],[11,"class","search-select-list-item"],[9],[0,"\\n"],[4,"if",[[23,["shouldRenderName"]]],null,{"statements":[[0,"          "],[1,[22,1,["name"]],false],[0,"\\n          "],[7,"small"],[11,"class","search-select-list-key"],[9],[0,"\\n            "],[1,[22,1,["id"]],false],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"          "],[1,[22,1,["id"]],false],[0,"\\n"]],"parameters":[]}],[0,"        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[11,"class","button is-ghost"],[11,"type","button"],[3,"action",[[22,0,[]],"discardSelection",[22,1,[]]]],[9],[0,"\\n            "],[5,"icon",[],[["@glyph"],["trash"]]],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/search-select.hbs"}})}),define("vault/templates/components/secret-edit-display",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"7LWqz8NC",block:'{"symbols":["secret","index","attr","@editActions","@secretData","@codemirrorString","@isV2","@model","@canEditV2Secret","@showWriteWithoutReadWarning","@showAdvancedMode"],"statements":[[4,"if",[[27,"and",[[27,"or",[[22,8,["isNew"]],[22,9,[]]],null],[22,7,[]],[27,"not",[[22,8,["failedServerRead"]]],null]],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","form-section box is-shadowless is-fullwidth"],[9],[0,"\\n      "],[7,"label"],[11,"class","title is-5"],[9],[0,"\\n        Secret metadata\\n      "],[10],[0,"\\n"],[4,"each",[[22,8,["fields"]]],null,{"statements":[[0,"        "],[5,"form-field",[],[["@attr","@model"],[[22,3,[]],[22,0,["model"]]]]],[0,"\\n"]],"parameters":[3]},null],[0,"    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"if",[[22,10,[]]],null,{"statements":[[4,"if",[[27,"and",[[22,7,[]],[22,8,["failedServerRead"]]],null]],null,{"statements":[[0,"      "],[5,"alert-banner",[],[["@type","@message","@class"],["warning","Your policies prevent you from reading metadata for this secret and the current version\'s data. Creating a new version of the secret with this form will not be able to use the check-and-set mechanism. If this is required on the secret, then you will need access to read the secret\'s metadata.","is-marginless"]]],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[22,7,[]]],null,{"statements":[[0,"      "],[5,"alert-banner",[],[["@type","@message","@class"],["warning","Your policies prevent you from reading the current secret version. Saving this form will create a new version of the secret and will utilize the available check-and-set mechanism.","is-marginless"]]],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[5,"alert-banner",[],[["@type","@message","@class"],["warning","Your policies prevent you from reading the current secret data. Saving using this form will overwrite the existing values.","is-marginless"]]],[0,"\\n    "]],"parameters":[]}]],"parameters":[]}]],"parameters":[]},null],[0,"\\n"],[4,"if",[[22,11,[]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","form-section"],[9],[0,"\\n      "],[7,"label"],[11,"class","title is-5"],[9],[0,"\\n"],[4,"if",[[23,["isV2"]]],null,{"statements":[[0,"        Version data\\n"]],"parameters":[]},{"statements":[[0,"        Secret data\\n"]],"parameters":[]}],[0,"      "],[10],[0,"\\n      "],[5,"json-editor",[],[["@value","@valueUpdated","@onFocusOut"],[[22,6,[]],[22,4,["codemirrorUpdated"]],[22,4,["formatJSON"]]]]],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","form-section"],[9],[0,"\\n      "],[7,"label"],[11,"class","title is-5"],[9],[0,"\\n"],[4,"if",[[23,["isV2"]]],null,{"statements":[[0,"        Version data\\n"]],"parameters":[]},{"statements":[[0,"        Secret data\\n"]],"parameters":[]}],[0,"      "],[10],[0,"\\n"],[4,"each",[[22,5,[]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","info-table-row"],[9],[0,"\\n        "],[7,"div"],[11,"class","column is-one-quarter info-table-row-edit"],[9],[0,"\\n          "],[1,[27,"input",null,[["value","placeholder","change","class","autocomplete","spellcheck"],[[22,1,["name"]],"key",[27,"action",[[22,0,[]],[22,4,["handleChange"]]],null],"input","off","false"]]],false],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","column info-table-row-edit"],[9],[0,"\\n          "],[5,"masked-input",[],[["@name","@onKeyDown","@onChange","@value"],[[22,1,["name"]],[22,4,["handleKeyDown"]],[22,4,["handleChange"]],[22,1,["value"]]]]],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","column is-narrow info-table-row-edit"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[22,5,["length"]],[27,"inc",[[22,2,[]]],null]],null]],null,{"statements":[[0,"            "],[7,"button"],[11,"class","button is-outlined is-primary"],[11,"type","button"],[3,"action",[[22,0,[]],[22,4,["addRow"]]]],[9],[0,"\\n              Add\\n            "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"            "],[7,"button"],[11,"class","button has-text-grey is-expanded is-icon"],[11,"aria-label","Delete row"],[11,"type","button"],[3,"action",[[22,0,[]],[22,4,["deleteRow"]],[22,1,["name"]]]],[9],[0,"\\n              "],[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph","@size"],["trash","l"]]],[0,"\\n            "],[10],[0,"\\n"]],"parameters":[]}],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[1,2]},null],[0,"    "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/secret-edit-display.hbs"}})}),define("vault/templates/components/secret-edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"xGZXUQcz",block:'{"symbols":["targetRoute","D","D","secretVersion","p","@model","@mode"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,5,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[1,[27,"key-value-header",null,[["baseKey","path","mode","root","showCurrent"],[[23,["baseKey"]],"vault.cluster.secrets.backend.list",[23,["mode"]],[23,["root"]],true]]],false],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,5,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"create"],null]],null,{"statements":[[0,"        Create secret\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"and",[[23,["isV2"]],[27,"eq",[[23,["mode"]],"edit"],null]],null]],null,{"statements":[[0,"        Create new version\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["mode"]],"edit"],null]],null,{"statements":[[0,"        Edit secret\\n"]],"parameters":[]},{"statements":[[0,"        "],[1,[23,["key","id"]],false],[0,"\\n      "]],"parameters":[]}]],"parameters":[]}]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[5]}],[0,"\\n\\n"],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n"],[4,"unless",[[27,"and",[[27,"eq",[[23,["mode"]],"show"],null],[23,["isWriteWithoutRead"]]],null]],null,{"statements":[[0,"    "],[5,"toolbar-filters",[],[[],[]],{"statements":[[0,"\\n      "],[7,"input"],[11,"id","json"],[11,"name","json"],[11,"class","switch is-rounded is-success is-small"],[12,"checked",[21,"showAdvancedMode"]],[12,"onchange",[27,"action",[[22,0,[]],"toggleAdvanced"],[["value"],["target.checked"]]]],[12,"disabled",[27,"and",[[27,"eq",[[23,["mode"]],"show"],null],[23,["secretDataIsAdvanced"]]],null]],[11,"type","checkbox"],[9],[10],[0,"\\n      "],[7,"label"],[11,"for","json"],[11,"class","has-text-grey"],[9],[0,"JSON"],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"  "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n"],[4,"if",[[27,"and",[[27,"eq",[[22,7,[]],"show"],null],[22,0,["isV2"]],[27,"not",[[22,6,["failedServerRead"]]],null]],null]],null,{"statements":[[0,"      "],[5,"secret-version-menu",[],[["@version","@onRefresh"],[[22,0,["modelForData"]],[27,"action",[[22,0,[]],"refresh"],null]]]],[0,"\\n      "],[5,"basic-dropdown",[],[["@class","@horizontalPosition","@verticalPosition"],["popup-menu","auto-right","below"]],{"statements":[[0,"\\n        "],[6,[22,3,["trigger"]],[],[["@class","@tagName"],[[27,"concat",["popup-menu-trigger toolbar-link",[27,"if",[[22,3,["isOpen"]]," is-active"],null]],null],"button"]],{"statements":[[0,"\\n          History "],[5,"chevron",[],[["@direction","@isButton"],["down",true]]],[0,"\\n        "]],"parameters":[]}],[0,"\\n        "],[6,[22,3,["content"]],[],[["@class"],["popup-menu-content "]],{"statements":[[0,"\\n          "],[7,"nav"],[11,"class","box menu"],[9],[0,"\\n            "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n              "],[7,"li"],[11,"class","action"],[9],[0,"\\n                "],[5,"secret-link",[],[["@mode","@secret","@class","@onLinkClick"],["versions",[22,0,["model","id"]],"has-text-black has-text-weight-semibold has-bottom-shadow",[27,"action",[[22,0,[]],[22,3,["actions","close"]]],null]]],{"statements":[[0,"\\n                 View version history\\n                "]],"parameters":[]}],[0,"\\n              "],[10],[0,"\\n            "],[10],[0,"\\n            "],[7,"h5"],[11,"class","list-header"],[9],[0,"Versions"],[10],[0,"\\n            "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n"],[4,"each",[[27,"reverse",[[22,0,["model","versions"]]],null]],null,{"statements":[[0,"              "],[7,"li"],[11,"class","action"],[9],[0,"\\n                "],[5,"link-to",[[11,"class","link"]],[["@params","@invokeAction"],[[27,"array",[[27,"query-params",null,[["version"],[[22,4,["version"]]]]]],null],[27,"action",[[22,0,[]],[22,3,["actions","close"]]],null]]],{"statements":[[0,"\\n                  Version "],[1,[22,4,["version"]],false],[0,"\\n"],[4,"if",[[27,"eq",[[22,4,["version"]],[22,0,["model","currentVersion"]]],null]],null,{"statements":[[0,"                    "],[5,"icon",[[11,"class","has-text-success is-pulled-right"]],[["@glyph"],["check-circle-outline"]]],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[22,4,["deleted"]]],null,{"statements":[[0,"                    "],[5,"icon",[[11,"class","has-text-grey is-pulled-right"]],[["@glyph"],["cancel-square-outline"]]],[0,"\\n                  "]],"parameters":[]},null]],"parameters":[]}],[0,"                "]],"parameters":[]}],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[4]},null],[0,"            "],[10],[0,"\\n          "],[10],[0,"\\n        "]],"parameters":[]}],[0,"\\n      "]],"parameters":[3]}],[0,"\\n      "],[7,"div"],[11,"class","toolbar-separator"],[9],[10],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"if",[[27,"and",[[27,"eq",[[23,["mode"]],"show"],null],[23,["canDelete"]]],null]],null,{"statements":[[0,"      "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction","@confirmMessage"],["toolbar-link",[27,"action",[[22,0,[]],"deleteKey"],null],[27,"if",[[23,["isV2"]],[27,"concat",["This will permanently delete all versions of this secret."],null],[27,"concat",["You will not be able to recover this secret data later."],null]],null]]],{"statements":[[0,"\\n        Delete secret\\n      "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"if",[[27,"and",[[27,"eq",[[23,["mode"]],"show"],null],[27,"or",[[23,["canEditV2Secret"]],[23,["canEdit"]]],null]],null]],null,{"statements":[[4,"let",[[27,"concat",["vault.cluster.secrets.backend.",[27,"if",[[27,"eq",[[23,["mode"]],"show"],null],"edit","show"],null]],null]],null,{"statements":[[4,"unless",[[27,"and",[[23,["isV2"]],[27,"or",[[23,["isWriteWithoutRead"]],[23,["modelForData","destroyed"]],[23,["modelForData","deleted"]]],null]],null]],null,{"statements":[[0,"          "],[5,"basic-dropdown",[],[["@class","@horizontalPosition","@verticalPosition","@onClose"],["popup-menu","auto-right","below",[27,"action",[[22,0,[]],"clearWrappedData"],null]]],{"statements":[[0,"\\n            "],[6,[22,2,["trigger"]],[],[["@class","@tagName"],[[27,"concat",["toolbar-link",[27,"if",[[22,2,["isOpen"]]," is-active"],null]],null],"button"]],{"statements":[[0,"\\n              Copy secret\\n              "],[5,"chevron",[],[["@direction","@isButton"],["down",true]]],[0,"\\n            "]],"parameters":[]}],[0,"\\n            "],[6,[22,2,["content"]],[],[["@class"],["popup-menu-content is-wide"]],{"statements":[[0,"\\n              "],[7,"nav"],[11,"class","box menu"],[9],[0,"\\n                "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n                  "],[7,"li"],[11,"class","action"],[9],[0,"\\n                    "],[5,"copy-button",[],[["@class","@clipboardText","@success"],["link link-plain has-text-weight-semibold is-ghost",[21,"codemirrorString"],[27,"action",[[22,0,[]],[27,"set-flash-message",["JSON Copied!"],null]],null]]],{"statements":[[0,"\\n                      Copy JSON\\n                    "]],"parameters":[]}],[0,"\\n                  "],[10],[0,"\\n                  "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"if",[[23,["showWrapButton"]]],null,{"statements":[[0,"                      "],[7,"button"],[12,"class",[28,["link link-plain has-text-weight-semibold is-ghost ",[27,"if",[[23,["isWrapping"]],"is-loading"],null]]]],[12,"disabled",[21,"isWrapping"]],[11,"type","button"],[3,"action",[[22,0,[]],"handleWrapClick"]],[9],[0,"\\n                        Wrap secret\\n                      "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"                      "],[5,"masked-input",[],[["@class","@displayOnly","@allowCopy","@value","@success","@error"],["has-padding",true,true,[21,"wrappedData"],[27,"action",[[22,0,[]],"handleCopySuccess"],null],[27,"action",[[22,0,[]],"handleCopyError"],null]]]],[0,"\\n"]],"parameters":[]}],[0,"                  "],[10],[0,"\\n                "],[10],[0,"\\n              "],[10],[0,"\\n            "]],"parameters":[]}],[0,"\\n          "]],"parameters":[2]}],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"if",[[23,["isV2"]]],null,{"statements":[[0,"          "],[5,"toolbar-link",[],[["@params","@replace","@type"],[[27,"array",[[22,1,[]],[23,["model","id"]],[27,"query-params",null,[["version"],[[22,0,["modelForData","version"]]]]]],null],true,"add"]],{"statements":[[0,"\\n            Create new version\\n          "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[0,"          "],[5,"toolbar-link",[],[["@params","@replace"],[[27,"array",[[22,1,[]],[23,["model","id"]]],null],true]],{"statements":[[0,"\\n            Edit secret\\n          "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}]],"parameters":[1]},null]],"parameters":[]},null],[0,"  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n\\n"],[15,[23,["partialName"]],[]],[0,"\\n"]],"hasEval":true}',meta:{moduleName:"vault/templates/components/secret-edit.hbs"}})}),define("vault/templates/components/secret-link",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"HTZG25bJ",block:'{"symbols":["&default"],"statements":[[4,"link-to",null,[["params","class","invokeAction"],[[23,["linkParams"]],[23,["class"]],[27,"action",[[22,0,[]],[23,["onLinkClick"]]],null]]],{"statements":[[0,"  "],[14,1],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/secret-link.hbs"}})}),define("vault/templates/components/secret-list-header",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"NbEc/psH",block:'{"symbols":["options","oTab","p"],"statements":[[4,"with",[[27,"options-for-backend",[[23,["model","engineType"]]],null]],null,{"statements":[[0,"  "],[5,"page-header",[],[[],[]],{"statements":[[0,"\\n    "],[6,[22,3,["top"]],[],[[],[]],{"statements":[[0,"\\n"],[4,"key-value-header",null,[["baseKey","path","root"],[[23,["baseKey"]],"vault.cluster.secrets.backend.list",[23,["backendCrumb"]]]],{"statements":[[0,"        "],[7,"li"],[9],[0,"\\n          "],[7,"span"],[11,"class","sep"],[9],[0,"\\n            /\\n          "],[10],[0,"\\n"],[4,"link-to",["vault.cluster.secrets"],null,{"statements":[[0,"            secrets\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "]],"parameters":[]}],[0,"\\n    "],[6,[22,3,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n      "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n        "],[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph","@size"],[[27,"or",[[23,["model","engineType"]],"secrets"],null],"xl"]]],[0,"\\n        "],[1,[23,["model","id"]],false],[0,"\\n"],[4,"if",[[27,"eq",[[23,["model","options","version"]],2],null]],null,{"statements":[[0,"          "],[7,"span"],[11,"class","tag"],[9],[0,"\\n            Version 2\\n          "],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[3]}],[0,"\\n"],[4,"if",[[22,1,["tabs"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","tabs-container box is-bottomless is-marginless is-fullwidth is-paddingless"],[9],[0,"\\n      "],[7,"nav"],[11,"class","tabs"],[9],[0,"\\n        "],[7,"ul"],[9],[0,"\\n"],[4,"each",[[22,1,["tabs"]]],null,{"statements":[[4,"if",[[22,2,["tab"]]],null,{"statements":[[4,"link-to",["vault.cluster.secrets.backend.list-root",[27,"query-params",null,[["tab"],[[22,2,["tab"]]]]]],[["tagName","activeClass"],["li","is-active"]],{"statements":[[4,"link-to",["vault.cluster.secrets.backend.list-root",[27,"query-params",null,[["tab"],[[22,2,["tab"]]]]]],null,{"statements":[[0,"                  "],[1,[22,2,["label"]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null]],"parameters":[]},{"statements":[[4,"link-to",["vault.cluster.secrets.backend.list-root",[27,"query-params",null,[["tab"],[""]]]],[["tagName","activeClass"],["li","is-active"]],{"statements":[[4,"link-to",["vault.cluster.secrets.backend.list-root",[27,"query-params",null,[["tab"],[""]]]],null,{"statements":[[0,"                  "],[1,[22,2,["label"]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null]],"parameters":[]}]],"parameters":[2]},null],[4,"link-to",["vault.cluster.secrets.backend.configuration"],[["tagName","activeClass"],["li","is-active"]],{"statements":[[4,"link-to",["vault.cluster.secrets.backend.configuration"],null,{"statements":[[0,"              Configuration\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","tabs-container box is-bottomless is-marginless is-fullwidth is-paddingless"],[9],[0,"\\n      "],[7,"nav"],[11,"class","tabs"],[9],[0,"\\n        "],[7,"ul"],[9],[0,"\\n"],[4,"if",[[27,"contains",[[23,["model","engineType"]],[27,"supported-secret-backends",null,null]],null]],null,{"statements":[[4,"link-to",["vault.cluster.secrets.backend.list-root"],[["tagName","activeClass","current-when"],["li","is-active","vault.cluster.secrets.backend.list-root vault.cluster.secrets.backend.list"]],{"statements":[[4,"link-to",["vault.cluster.secrets.backend.list-root"],null,{"statements":[[0,"                "],[1,[27,"capitalize",[[27,"pluralize",[[22,1,["item"]]],null]],null],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null]],"parameters":[]},null],[4,"link-to",["vault.cluster.secrets.backend.configuration"],[["tagName","activeClass"],["li","is-active"]],{"statements":[[4,"link-to",["vault.cluster.secrets.backend.configuration"],null,{"statements":[[0,"              Configuration\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[1]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/secret-list-header.hbs"}})}),define("vault/templates/components/secret-version-menu",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"pc8094oi",block:'{"symbols":["D","&default"],"statements":[[0,"    "],[5,"basic-dropdown",[],[["@class","@horizontalPosition","@verticalPosition"],["popup-menu","auto-right","below"]],{"statements":[[0,"\\n      "],[6,[22,1,["trigger"]],[],[["@class","@tagName"],[[27,"concat",["toolbar-link",[27,"if",[[22,1,["isOpen"]]," is-active"],null]],null],"button"]],{"statements":[[0,"\\n"],[4,"if",[[23,["useDefaultTrigger"]]],null,{"statements":[[0,"          "],[5,"icon",[[11,"aria-label","More options"],[11,"class","has-text-black auto-width"]],[["@glyph"],["more-horizontal"]]],[0,"\\n"]],"parameters":[]},{"statements":[[0,"          Version "],[1,[22,0,["version","version"]],false],[0,"\\n          "],[5,"chevron",[],[["@direction","@isButton"],["down",true]]],[0,"\\n"]],"parameters":[]}],[0,"      "]],"parameters":[]}],[0,"\\n      "],[6,[22,1,["content"]],[],[["@class"],["popup-menu-content "]],{"statements":[[0,"\\n        "],[7,"nav"],[11,"class","box menu"],[9],[0,"\\n          "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n"],[4,"if",[[24,2]],null,{"statements":[[0,"              "],[14,2],[0,"\\n"]],"parameters":[]},null],[4,"if",[[22,0,["version","destroyed"]]],null,{"statements":[[0,"              "],[7,"li"],[11,"class","action has-text-grey"],[9],[0,"\\n                "],[7,"button"],[11,"class","link"],[11,"disabled",""],[11,"type","button"],[9],[0,"\\n                  The data for "],[1,[22,0,["version","path"]],false],[0," version "],[1,[22,0,["version","version"]],false],[0," has been destroyed.\\n                "],[10],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["isFetchingVersionCapabilities"]]],null,{"statements":[[0,"                "],[7,"li"],[11,"class","action"],[9],[0,"\\n                  "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n                    loading\\n                  "],[10],[0,"\\n                "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"                "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"if",[[22,0,["version","deleted"]]],null,{"statements":[[4,"if",[[23,["canUndeleteVersion"]]],null,{"statements":[[0,"                      "],[7,"button"],[11,"class","link"],[11,"type","button"],[3,"action",[[22,0,[]],[27,"queue",[[27,"action",[[22,0,[]],[22,1,["actions","close"]]],null],[27,"action",[[22,0,[]],"deleteVersion","undelete"],null]],null]]],[9],[0,"\\n                        Undelete version\\n                      "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"                      "],[7,"button"],[11,"class","link"],[11,"disabled",""],[11,"type","button"],[9],[0,"\\n                        The data for "],[1,[22,0,["version","path"]],false],[0," version "],[1,[22,0,["version","version"]],false],[0," has been deleted. You do not have the permisssion to undelete it.\\n                      "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]},{"statements":[[4,"if",[[23,["canDeleteVersion"]]],null,{"statements":[[0,"                    "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@onConfirmAction"],["link is-destroy","Delete version?","This version will no longer be able to be read, but the underlying data will not be removed and can still be undeleted.",[27,"action",[[22,0,[]],[27,"queue",[[27,"action",[[22,0,[]],[22,1,["actions","close"]]],null],[27,"action",[[22,0,[]],"deleteVersion","delete"],null]],null]],null]]],{"statements":[[0,"\\n                      Delete version\\n                    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[0,"                    "],[7,"button"],[11,"class","link"],[11,"disabled",""],[11,"type","button"],[9],[0,"\\n                      You do not have the permissions to delete the data for this secret.\\n                    "],[10],[0,"\\n                  "]],"parameters":[]}]],"parameters":[]}],[0,"                "],[10],[0,"\\n"],[4,"if",[[23,["canDestroyVersion"]]],null,{"statements":[[0,"                  "],[7,"li"],[11,"class","action"],[9],[0,"\\n                    "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@onConfirmAction"],["link is-destroy","Permanently delete?","This version will no longer be able to be read, and cannot be undeleted.",[27,"action",[[22,0,[]],[27,"queue",[[27,"action",[[22,0,[]],[22,1,["actions","close"]]],null],[27,"action",[[22,0,[]],"deleteVersion","destroy"],null]],null]],null]]],{"statements":[[0,"\\n                      Permanently destroy version\\n                    "]],"parameters":[]}],[0,"\\n                  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"                  "],[7,"button"],[11,"class","link"],[11,"disabled",""],[11,"type","button"],[9],[0,"\\n                    You do not have the permissions to destroy the data for this secret.\\n                  "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]}]],"parameters":[]}],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[1]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/secret-version-menu.hbs"}})}),define("vault/templates/components/section-tabs",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"YJusMZN6",block:'{"symbols":["tabs","tab"],"statements":[[4,"with",[[27,"tabs-for-auth-section",[[23,["model"]],[23,["tabType"]],[23,["paths"]]],null]],null,{"statements":[[4,"if",[[22,1,["length"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[9],[0,"\\n      "],[7,"nav"],[11,"class","tabs"],[9],[0,"\\n        "],[7,"ul"],[9],[0,"\\n"],[4,"each",[[22,1,[]]],null,{"statements":[[4,"link-to",null,[["params","tagName"],[[22,2,["routeParams"]],"li"]],{"statements":[[4,"link-to",null,[["params"],[[22,2,["routeParams"]]]],{"statements":[[0,"                "],[1,[22,2,["label"]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null]],"parameters":[2]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/section-tabs.hbs"}})}),define("vault/templates/components/shamir-flow",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Yn4+yqC2",block:'{"symbols":["cmd","&default"],"statements":[[4,"if",[[23,["encoded_token"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-marginless is-shadowless"],[9],[0,"\\n    "],[7,"div"],[11,"class","message is-list has-copy-button"],[11,"tabindex","-1"],[9],[0,"\\n      "],[5,"hover-copy-button",[],[["@copyValue"],[[21,"encoded_token"]]]],[0,"\\n      "],[7,"div"],[11,"class","message-body"],[9],[0,"\\n        "],[7,"h4"],[11,"class","title is-7 is-marginless"],[9],[0,"\\n"],[4,"if",[[23,["otp"]]],null,{"statements":[[0,"            Encoded Operation Token\\n"]],"parameters":[]},{"statements":[[0,"            Encrypted Operation Token\\n"]],"parameters":[]}],[0,"        "],[10],[0,"\\n        "],[7,"code"],[11,"class","is-word-break"],[9],[1,[21,"encoded_token"],false],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"],[4,"if",[[23,["otp"]]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","message is-list has-copy-button"],[11,"tabindex","-1"],[9],[0,"\\n        "],[5,"hover-copy-button",[],[["@copyValue"],[[21,"otp"]]]],[0,"\\n        "],[7,"div"],[11,"class","message-body"],[9],[0,"\\n          "],[7,"h4"],[11,"class","title is-7 is-marginless"],[9],[0,"\\n            One Time Password (otp)\\n          "],[10],[0,"\\n          "],[7,"code"],[11,"class","is-word-break"],[9],[1,[21,"otp"],false],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","message is-list has-copy-button"],[11,"tabindex","-1"],[9],[0,"\\n"],[4,"let",[[27,"concat",["vault operator generate-root -dr-token -otp=\\"",[23,["otp"]],"\\" -decode=\\"",[23,["encoded_token"]],"\\""],null]],null,{"statements":[[0,"          "],[5,"hover-copy-button",[],[["@copyValue"],[[22,1,[]]]]],[0,"\\n          "],[7,"div"],[11,"class","message-body"],[9],[0,"\\n            "],[7,"h4"],[11,"class","title is-7 is-marginless"],[9],[0,"\\n              DR Operation Token Command\\n            "],[10],[0,"\\n            "],[7,"code"],[11,"class","is-word-break"],[9],[1,[22,1,[]],false],[10],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","box is-marginless is-shadowless"],[9],[0,"\\n    "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"reset"]],[9],[0,"\\n      Clear Token\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"and",[[23,["generateAction"]],[27,"not",[[23,["started"]]],null]],null]],null,{"statements":[[0,"  "],[7,"form"],[11,"id","shamir"],[3,"action",[[22,0,[]],"startGenerate",[27,"hash",null,[["pgp_key"],[[23,["pgp_key"]]]]]],[["on"],["submit"]]],[9],[0,"\\n    "],[1,[27,"message-error",null,[["errors"],[[23,["errors"]]]]],false],[0,"\\n"],[4,"if",[[27,"eq",[[23,["generateStep"]],"chooseMethod"],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","box is-marginless is-shadowless"],[9],[0,"\\n        "],[7,"p"],[9],[0,"\\n        Updating or promoting this cluster requires an operation token. Let\'s generate one by\\n        inputting the master key shares. If you\'d like to encrypt the token with a PGP Key, please click \\"Provide PGP Key\\" below, otherwise we can begin generation of the Operation Token.\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","box is-shadowless field is-grouped is-grouped-centered"],[9],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[11,"class","button is-primary"],[11,"type","button"],[3,"action",[[22,0,[]],[27,"mut",[[23,["generateWithPGP"]]],null],true]],[9],[0,"\\n            Provide PGP Key\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"span"],[11,"class","button auto-width is-white is-static"],[9],[0,"\\n            or\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n            Generate Operation Token\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"eq",[[23,["generateStep"]],"providePGPKey"],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","box is-marginless is-shadowless"],[9],[0,"\\n        "],[7,"p"],[9],[0,"\\n          Choose a PGP Key from your computer or paste the contents of one in the form below.\\n          This key will be used to Encrypt the generated Operation Token.\\n        "],[10],[0,"\\n        "],[1,[27,"pgp-file",null,[["index","key","onChange"],["",[23,["pgpKeyFile"]],[27,"action",[[22,0,[]],"setKey"],null]]]],false],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","field is-grouped box is-marginless is-shadowless"],[9],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"reset"]],[9],[0,"\\n            Back\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[12,"disabled",[27,"not",[[23,["pgp_key"]]],null]],[11,"class","button is-primary"],[11,"type","button"],[3,"action",[[22,0,[]],"savePGPKey"]],[9],[0,"\\n            Use PGP Key\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"eq",[[23,["generateStep"]],"beginGenerationWithPGP"],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","box is-marginless is-shadowless"],[9],[0,"\\n        "],[7,"p"],[9],[0,"\\n          Below is the base-64 encoded PGP Key that will be used to encrypt the generated Operation Token.\\n          Next we\'ll enter portions of the master key to generate an Operation Token. Click the \\"Generate Operation Token\\" button to proceed.\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","message is-list has-copy-button"],[11,"tabindex","-1"],[9],[0,"\\n          "],[5,"hover-copy-button",[],[["@copyValue"],[[21,"pgp_key"]]]],[0,"\\n          "],[7,"div"],[11,"class","message-body"],[9],[0,"\\n            "],[7,"h4"],[11,"class","title is-7 is-marginless"],[9],[0,"\\n              PGP Key "],[1,[23,["pgpKeyFile","fileName"]],false],[0,"\\n            "],[10],[0,"\\n            "],[7,"code"],[11,"class","is-word-break"],[9],[1,[21,"pgp_key"],false],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","field is-grouped box is-marginless is-shadowless"],[9],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"reset"]],[9],[0,"\\n            Back\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[12,"disabled",[27,"and",[[27,"not",[[23,["pgp_key"]]],null]],null]],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n            Generate Operation Token\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"form"],[11,"id","shamir"],[3,"action",[[22,0,[]],"onSubmit",[27,"hash",null,[["key"],[[23,["key"]]]]]],[["on"],["submit"]]],[9],[0,"\\n    "],[7,"div"],[11,"class","box is-marginless is-shadowless"],[9],[0,"\\n"],[4,"if",[[23,["errors"]]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","box is-shadowless is-marginless no-padding-top is-fullwidth"],[9],[0,"\\n          "],[1,[27,"message-error",null,[["errors"],[[23,["errors"]]]]],false],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[7,"div"],[11,"class","box is-shadowless is-marginless no-padding-top is-fullwidth"],[9],[0,"\\n"],[4,"if",[[24,2]],null,{"statements":[[0,"          "],[14,2],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["formText"]]],null,{"statements":[[0,"          "],[1,[21,"formText"],false],[0,"\\n        "]],"parameters":[]},null]],"parameters":[]}],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","key"],[11,"class","is-label"],[9],[0,"\\n          Master Key Portion\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[1,[27,"input",null,[["class","type","name","value"],["input","password","key",[23,["key"]]]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","box is-marginless is-shadowless"],[9],[0,"\\n      "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n        "],[7,"div"],[11,"class","column is-narrow"],[9],[0,"\\n          "],[7,"button"],[11,"class","button is-primary"],[12,"disabled",[21,"loading"]],[11,"type","submit"],[9],[0,"\\n            "],[1,[27,"if",[[23,["generateAction"]],"Generate Token",[23,["buttonText"]]],null],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","column is-flex-v-centered is-flex-end"],[9],[0,"\\n"],[4,"if",[[27,"or",[[23,["started"]],[23,["hasProgress"]]],null]],null,{"statements":[[0,"            "],[5,"shamir-progress",[],[["@threshold","@progress"],[[21,"threshold"],[21,"progress"]]]],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/shamir-flow.hbs"}})}),define("vault/templates/components/shamir-progress",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"eoAyOcef",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","level"],[9],[0,"\\n  "],[7,"div"],[11,"class","level-left"],[9],[0,"\\n    "],[7,"span"],[11,"class","has-text-grey is-size-8 shamir-progress-progress"],[9],[0,"\\n      "],[1,[21,"progress"],false],[0,"/"],[1,[21,"threshold"],false],[0," keys provided\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","level-right is-marginless"],[9],[0,"\\n    "],[5,"radial-progress",[],[["@progressDecimal"],[[21,"progressDecimal"]]]],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/shamir-progress.hbs"}})}),define("vault/templates/components/splash-page",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"b1Ack5ef",block:'{"symbols":["Nav","&default"],"statements":[[5,"nav-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["home"]],[],[[],[]],{"statements":[[0,"\\n    "],[5,"home-link",[],[["@class"],["navbar-item splash-page-logo has-text-white"]],{"statements":[[0,"\\n      "],[5,"logo-edition",[],[[],[]]],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["items"]],[],[[],[]],{"statements":[[0,"\\n   "],[7,"div"],[11,"class","navbar-item status-indicator-button"],[12,"data-status",[28,[[27,"if",[[23,["activeCluster","unsealed"]],"good","bad"],null]]]],[9],[0,"\\n     "],[5,"status-menu",[],[["@label","@onLinkClick"],["Status",[27,"action",[[22,0,[]],[22,1,["closeDrawer"]]],null]]]],[0,"\\n   "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n"],[5,"ui-wizard",[],[[],[]],{"statements":[[0,"\\n  "],[7,"div"],[11,"class","splash-page-container section is-flex-v-centered-tablet is-flex-1 is-fullwidth"],[9],[0,"\\n    "],[7,"div"],[11,"class","columns is-centered is-gapless is-fullwidth"],[9],[0,"\\n      "],[7,"div"],[11,"class","column is-4-desktop is-6-tablet"],[9],[0,"\\n        "],[7,"div"],[11,"class","splash-page-header"],[9],[0,"\\n          "],[14,2,[[27,"hash",null,[["header"],[[27,"component",["splash-page/splash-header"],null]]]]]],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","splash-page-sub-header"],[9],[0,"\\n          "],[14,2,[[27,"hash",null,[["sub-header"],[[27,"component",["splash-page/splash-header"],null]]]]]],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","login-form box is-paddingless is-relative"],[9],[0,"\\n          "],[14,2,[[27,"hash",null,[["content"],[[27,"component",["splash-page/splash-content"],null]]]]]],[0,"\\n        "],[10],[0,"\\n        "],[14,2,[[27,"hash",null,[["footer"],[[27,"component",["splash-page/splash-content"],null]]]]]],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/splash-page.hbs"}})})
define("vault/templates/components/splash-page/splash-content",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Hk4BEOHL",block:'{"symbols":["&default"],"statements":[[14,1],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/splash-page/splash-content.hbs"}})}),define("vault/templates/components/splash-page/splash-footer",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"ZBPrPPTe",block:'{"symbols":["&default"],"statements":[[14,1],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/splash-page/splash-footer.hbs"}})}),define("vault/templates/components/splash-page/splash-header",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"22PZN7oN",block:'{"symbols":["&default"],"statements":[[14,1],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/splash-page/splash-header.hbs"}})}),define("vault/templates/components/status-menu",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"S3f97mTA",block:'{"symbols":["d"],"statements":[[4,"basic-dropdown",null,[["horizontalPosition","verticalPosition","renderInPlace"],["auto-left","below",[23,["media","isMobile"]]]],{"statements":[[4,"component",[[22,1,["trigger"]]],[["tagName","class"],[[27,"if",[[27,"eq",[[23,["type"]],"replication"],null],"span","button"],null],[27,"if",[[27,"eq",[[23,["type"]],"replication"],null],"","button is-transparent"],null]]],{"statements":[[0,"    "],[5,"icon",[[12,"aria-label",[21,"ariaLabel"]]],[["@glyph","@size"],[[21,"glyphName"],"l"]]],[0,"\\n    "],[7,"div"],[11,"class","status-menu-label"],[9],[0,"\\n      "],[1,[21,"label"],false],[0,"\\n    "],[10],[0,"\\n    "],[5,"chevron",[[11,"class","has-text-white is-status-chevron"]],[["@direction"],["down"]]],[0,"\\n"]],"parameters":[]},null],[4,"component",[[22,1,["content"]]],[["class"],[[27,"concat",["status-menu-content status-menu-content-",[23,["type"]]],null]]],{"statements":[[0,"    "],[15,[23,["partialName"]],[1]],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null]],"hasEval":true}',meta:{moduleName:"vault/templates/components/status-menu.hbs"}})}),define("vault/templates/components/text-file",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"teMQHeb7",block:'{"symbols":[],"statements":[[4,"unless",[[23,["inputOnly"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n    "],[7,"div"],[11,"class","level-left"],[9],[0,"\\n      "],[7,"label"],[11,"class","is-label"],[9],[0,"\\n"],[4,"if",[[23,["label"]]],null,{"statements":[[0,"          "],[1,[21,"label"],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"          File\\n"]],"parameters":[]}],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","level-right"],[9],[0,"\\n      "],[7,"div"],[11,"class","control is-flex"],[9],[0,"\\n        "],[7,"input"],[12,"id",[27,"concat",["useText-",[23,["elementId"]]],null]],[12,"name",[27,"concat",["useText-",[23,["elementId"]]],null]],[11,"class","switch is-rounded is-success is-small"],[12,"checked",[23,["file","enterAsText"]]],[12,"onchange",[27,"action",[[22,0,[]],[27,"toggle",["enterAsText",[23,["file"]]],null]],null]],[11,"type","checkbox"],[9],[10],[0,"\\n        "],[7,"label"],[12,"for",[27,"concat",["useText-",[23,["elementId"]]],null]],[9],[0,"\\n          Enter as text\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null],[7,"div"],[11,"class","field"],[9],[0,"\\n"],[4,"if",[[23,["file","enterAsText"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"textarea"],[11,"class","textarea"],[12,"oninput",[27,"action",[[22,0,[]],"updateData"],null]],[9],[1,[23,["file","value"]],false],[10],[0,"    "],[10],[0,"\\n    "],[7,"p"],[11,"class","help has-text-grey"],[9],[0,"\\n      "],[1,[21,"textareaHelpText"],false],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n        "],[7,"div"],[11,"class","file has-name is-fullwidth"],[9],[0,"\\n        "],[7,"label"],[11,"class","file-label"],[9],[0,"\\n          "],[7,"input"],[11,"class","file-input"],[12,"onchange",[27,"action",[[22,0,[]],"pickedFile"],null]],[11,"type","file"],[9],[10],[0,"\\n          "],[7,"span"],[11,"class","file-cta button"],[9],[0,"\\n            "],[5,"icon",[[11,"class","has-light-grey-text"]],[["@glyph"],["upload"]]],[0,"\\n            Choose a file…\\n          "],[10],[0,"\\n          "],[7,"span"],[11,"class","file-name has-text-grey-dark"],[9],[0,"\\n"],[4,"if",[[23,["file","fileName"]]],null,{"statements":[[0,"              "],[1,[23,["file","fileName"]],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"              No file chosen\\n"]],"parameters":[]}],[0,"          "],[10],[0,"\\n"],[4,"if",[[23,["file","fileName"]]],null,{"statements":[[0,"            "],[7,"button"],[11,"class","file-delete-button"],[11,"type","button"],[3,"action",[[22,0,[]],"clearFile"]],[9],[0,"\\n              "],[5,"icon",[],[["@glyph"],["cancel-circle-outline"]]],[0,"\\n            "],[10],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"p"],[11,"class","help has-text-grey"],[9],[0,"\\n      "],[1,[21,"fileHelpText"],false],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/text-file.hbs"}})}),define("vault/templates/components/token-expire-warning",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"zV9b5MF/",block:'{"symbols":["&default"],"statements":[[4,"if",[[27,"and",[[23,["expirationDate"]],[27,"is-after",[[27,"now",null,[["interval"],[1000]]],[23,["expirationDate"]]],null]],null]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","token-expire-warning"],[9],[0,"\\n    "],[5,"alert-banner",[],[["@type","@message"],["danger",[28,["Your auth token expired on\\n        ",[27,"date-format",[[23,["expirationDate"]],"MMMM Do YYYY, h:mm:ss a"],null],"\\n         . You will need to re-authenticate."]]]],{"statements":[[0,"\\n"],[4,"link-to",["vault.cluster.logout"],[["class"],["button link"]],{"statements":[[0,"        Reauthenticate\\n"]],"parameters":[]},null],[0,"    "]],"parameters":[]}],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[14,1],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/token-expire-warning.hbs"}})}),define("vault/templates/components/tool-actions-form",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"XdHtS8kM",block:'{"symbols":[],"statements":[[7,"form"],[12,"onsubmit",[27,"action",[[22,0,[]],"doSubmit"],null]],[9],[0,"\\n  "],[15,[27,"concat",["partials/tools/",[23,["selectedAction"]]],null],[]],[0,"\\n"],[10],[0,"\\n"]],"hasEval":true}',meta:{moduleName:"vault/templates/components/tool-actions-form.hbs"}})}),define("vault/templates/components/toolbar-download-button",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"/0pLZ26r",block:'{"symbols":["@actionText"],"statements":[[1,[22,1,[]],false],[0,"\\n"],[5,"chevron",[],[["@isButton"],[true]]],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/toolbar-download-button.hbs"}})}),define("vault/templates/components/toolbar-secret-link",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"U3xdCS4j",block:'{"symbols":["&default"],"statements":[[5,"secret-link",[],[["@class","@mode","@secret","@replace","@queryParams"],["toolbar-link",[21,"mode"],[21,"secret"],[21,"replace"],[21,"queryParams"]]],{"statements":[[0,"\\n  "],[14,1],[0,"\\n  "],[5,"icon",[],[["@glyph"],[[21,"glyph"]]]],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/toolbar-secret-link.hbs"}})}),define("vault/templates/components/transit-edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"CxKmeMLm",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[1,[27,"key-value-header",null,[["baseKey","path","mode","root","showCurrent"],[[23,["key"]],"vault.cluster.secrets.backend.list",[23,["mode"]],[23,["root"]],true]]],false],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"create"],null]],null,{"statements":[[0,"        Create encryption key\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["mode"]],"edit"],null]],null,{"statements":[[0,"        Edit encryption key\\n"]],"parameters":[]},{"statements":[[0,"        Encryption key "],[7,"code"],[9],[1,[23,["key","id"]],false],[10],[0,"\\n      "]],"parameters":[]}]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[15,[27,"concat",["partials/transit-form-",[23,["mode"]]],null],[]],[0,"\\n"]],"hasEval":true}',meta:{moduleName:"vault/templates/components/transit-edit.hbs"}})}),define("vault/templates/components/transit-key-action/datakey",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"dWFG6Pyr",block:'{"symbols":["bitOption","paramOption"],"statements":[[7,"form"],[3,"action",[[22,0,[]],"doSubmit",[27,"hash",null,[["param","context","nonce","bits"],[[23,["param"]],[23,["context"]],[23,["nonce"]],[23,["bits"]]]]]],[["on"],["submit"]]],[9],[0,"\\n"],[4,"if",[[23,["ciphertext"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["param"]],"plaintext"],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","plaintext"],[11,"class","is-label"],[9],[0,"Plaintext"],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"textarea"],[11,"readonly",""],[11,"class","textarea"],[11,"id","plaintext"],[9],[1,[21,"plaintext"],false],[10],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","ciphertext"],[11,"class","is-label"],[9],[0,"Ciphertext"],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"textarea"],[11,"readonly",""],[11,"class","textarea"],[11,"id","ciphertext"],[9],[1,[21,"ciphertext"],false],[10],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["param"]],"plaintext"],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardTarget","class","buttonType","success"],["#plaintext","button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Plaintext copied!"],null]],null]]],{"statements":[[0,"        Copy plaintext\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardTarget","class","buttonType","success"],["#ciphertext",[27,"concat",["button is-primary ",[27,"if",[[27,"eq",[[23,["param"]],"plaintext"],null],"is-outlined",""],null]],null],"button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Ciphertext copied!"],null]],null]]],{"statements":[[0,"      Copy ciphertext\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n        Back\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[5,"namespace-reminder",[],[["@mode","@noun"],["perform","datakey creation"]]],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","param"],[11,"class","is-label"],[9],[0,"Output format"],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n          "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n            "],[7,"select"],[11,"name","param"],[11,"id","param"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["param"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"array",["plaintext","wrapped"],null]],null,{"statements":[[0,"                "],[7,"option"],[12,"selected",[27,"eq",[[23,["param"]],[22,2,[]]],null]],[12,"value",[22,2,[]]],[9],[0,"\\n                  "],[1,[22,2,[]],false],[0,"\\n                "],[10],[0,"\\n"]],"parameters":[2]},null],[0,"            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[23,["key","derived"]]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","context"],[11,"class","is-label"],[9],[0,"\\n            Context\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","field has-addons"],[9],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"input",null,[["type","id","value","class"],["text","context",[23,["context"]],"input"]]],false],[0,"\\n            "],[10],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"b64-toggle",null,[["value"],[[23,["context"]]]]],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"eq",[[23,["key","convergentEncryptionVersion"]],1],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","nonce"],[11,"class","is-label"],[9],[0,"Nonce"],[10],[0,"\\n          "],[7,"div"],[11,"class","field has-addons"],[9],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"input",null,[["type","id","value","class"],["text","nonce",[23,["nonce"]],"input"]]],false],[0,"\\n            "],[10],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"b64-toggle",null,[["value"],[[23,["nonce"]]]]],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","bits"],[11,"class","is-label"],[9],[0,"Bits"],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n          "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n          "],[7,"select"],[11,"name","bits"],[11,"id","bits"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["bits"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"array",[128,256,512],null]],null,{"statements":[[0,"              "],[7,"option"],[12,"selected",[27,"eq",[[23,["bits"]],[22,1,[]]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n                "],[7,"code"],[9],[1,[22,1,[]],false],[10],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"          "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n          Create datakey\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/transit-key-action/datakey.hbs"}})}),define("vault/templates/components/transit-key-action/decrypt",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"x8sqdgk3",block:'{"symbols":[],"statements":[[7,"form"],[3,"action",[[22,0,[]],"doSubmit",[27,"hash",null,[["ciphertext","context","nonce"],[[23,["ciphertext"]],[23,["context"]],[23,["nonce"]]]]]],[["on"],["submit"]]],[9],[0,"\\n"],[4,"if",[[27,"and",[[23,["plaintext"]],[23,["ciphertext"]]],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","plaintext"],[11,"class","is-label"],[9],[0,"\\n          Plaintext\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-relative"],[9],[0,"\\n          "],[1,[27,"textarea",null,[["id","value","readonly","class"],["plaintext",[23,["plaintext"]],true,"textarea"]]],false],[0,"\\n          "],[1,[27,"b64-toggle",null,[["value","isInput","initialEncoding"],[[23,["plaintext"]],false,"base64"]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardTarget","class","buttonType","success"],["#plaintext","button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Plaintext copied!"],null]],null]]],{"statements":[[0,"          Copy\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n          Back\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","ciphertext"],[11,"class","is-label"],[9],[0,"Ciphertext"],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[1,[27,"textarea",null,[["id","name","value","class"],["ciphertext","ciphertext",[23,["ciphertext"]],"textarea"]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[23,["key","derived"]]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","context"],[11,"class","is-label"],[9],[0,"\\n            Context\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","field has-addons"],[9],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"input",null,[["type","id","value","class"],["text","context",[23,["context"]],"input"]]],false],[0,"\\n            "],[10],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"b64-toggle",null,[["value"],[[23,["context"]]]]],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"eq",[[23,["key","convergentEncryptionVersion"]],1],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","nonce"],[11,"class","is-label"],[9],[0,"Nonce"],[10],[0,"\\n          "],[7,"div"],[11,"class","field has-addons"],[9],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"input",null,[["type","id","value","class"],["text","nonce",[23,["nonce"]],"input"]]],false],[0,"\\n            "],[10],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"b64-toggle",null,[["value"],[[23,["nonce"]]]]],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button is-primary"],[11,"id","decrypt"],[11,"type","submit"],[9],[0,"\\n           Decrypt\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/transit-key-action/decrypt.hbs"}})}),define("vault/templates/components/transit-key-action/encrypt",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"mzxjFktm",block:'{"symbols":[],"statements":[[7,"form"],[3,"action",[[22,0,[]],"doSubmit",[27,"hash",null,[["plaintext","context","nonce","key_version"],[[23,["plaintext"]],[23,["context"]],[23,["nonce"]],[23,["key_version"]]]]]],[["on"],["submit"]]],[9],[0,"\\n"],[4,"if",[[27,"and",[[23,["plaintext"]],[23,["ciphertext"]]],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","ciphertext"],[11,"class","is-label"],[9],[0,"Ciphertext"],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n          "],[7,"textarea"],[11,"readonly",""],[11,"class","textarea"],[11,"id","ciphertext"],[9],[1,[21,"ciphertext"],false],[10],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardTarget","class","buttonType","success"],["#ciphertext","button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Ciphertext copied!"],null]],null]]],{"statements":[[0,"          Copy\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n          Back\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[5,"namespace-reminder",[],[["@mode","@noun"],["perform","encryption"]]],[0,"\\n      "],[1,[27,"key-version-select",null,[["key","onVersionChange","key_version"],[[23,["key"]],[27,"action",[[22,0,[]],[27,"mut",[[23,["key_version"]]],null]],null],[23,["key_version"]]]]],false],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","plaintext"],[11,"class","is-label"],[9],[0,"\\n          Plaintext\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-relative"],[9],[0,"\\n          "],[1,[27,"textarea",null,[["id","value","class"],["plaintext",[23,["plaintext"]],"textarea"]]],false],[0,"\\n          "],[1,[27,"b64-toggle",null,[["value","isInput"],[[23,["plaintext"]],false]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[23,["key","derived"]]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","context"],[11,"class","is-label"],[9],[0,"\\n            Context\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","field has-addons"],[9],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"input",null,[["type","id","value","class"],["text","context",[23,["context"]],"input"]]],false],[0,"\\n            "],[10],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"b64-toggle",null,[["value"],[[23,["context"]]]]],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"eq",[[23,["key","convergentEncryptionVersion"]],1],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"div"],[11,"class","level"],[9],[0,"\\n            "],[7,"div"],[11,"class","level-left"],[9],[0,"\\n              "],[7,"label"],[11,"for","nonce"],[11,"class","is-label"],[9],[0,"Nonce"],[10],[0,"\\n            "],[10],[0,"\\n            "],[7,"div"],[11,"class","level-right"],[9],[0,"\\n              "],[1,[27,"b64-toggle",null,[["value"],[[23,["nonce"]]]]],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"input",null,[["type","id","value","class"],["text","nonce",[23,["nonce"]],"input"]]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n          Encrypt\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/transit-key-action/encrypt.hbs"}})}),define("vault/templates/components/transit-key-action/export",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"7Ea7RMdu",block:'{"symbols":["versionOption","currOption"],"statements":[[7,"form"],[3,"action",[[22,0,[]],"doSubmit",[27,"hash",null,[["param"],[[27,"compact",[[27,"array",[[23,["exportKeyType"]],[27,"if",[[23,["exportVersion"]],[23,["exportKeyVersion"]]],null]],null]],null]]]],[27,"hash",null,[["wrapTTL"],[[23,["wrapTTL"]]]]]],[["on"],["submit"]]],[9],[0,"\\n"],[4,"if",[[27,"or",[[23,["keys"]],[23,["wrappedToken"]]],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n"],[4,"if",[[23,["wrapTTL"]]],null,{"statements":[[0,"          "],[7,"label"],[11,"for","export"],[11,"class","is-label"],[9],[0,"Wrapped Key"],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[7,"textarea"],[11,"readonly",""],[11,"nowrap",""],[11,"wrap","off"],[11,"class","textarea"],[11,"id","export"],[9],[1,[21,"wrappedToken"],false],[10],[0,"          "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"          "],[7,"label"],[11,"class","is-label"],[9],[0,"Exported Key"],[10],[0,"\\n          "],[1,[27,"json-editor",null,[["value","options"],[[27,"stringify",[[23,["keys"]]],null],[27,"hash",null,[["readOnly"],[true]]]]]],false],[0,"\\n"]],"parameters":[]}],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[27,"if",[[23,["wrapTTL"]],[23,["wrappedToken"]],[27,"stringify",[[23,["keys"]]],null]],null],"button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",[[27,"if",[[23,["wrapTTL"]],"Wrapped key copied!","Exported key copied!"],null]],null]],null]]],{"statements":[[0,"          Copy\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n          Back\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","type"],[11,"class","is-label"],[9],[0,"Key type"],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n          "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n            "],[7,"select"],[11,"name","type"],[11,"id","type"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["exportKeyType"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[23,["key","exportKeyTypes"]]],null,{"statements":[[0,"                "],[7,"option"],[12,"selected",[27,"eq",[[23,["exportKeyType"]],[22,2,[]]],null]],[12,"value",[22,2,[]]],[9],[0,"\\n                  "],[7,"code"],[9],[1,[22,2,[]],false],[10],[0,"\\n                "],[10],[0,"\\n"]],"parameters":[2]},null],[0,"            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"div"],[11,"class","b-checkbox"],[9],[0,"\\n          "],[1,[27,"input",null,[["type","name","id","class","checked"],["checkbox","exportVersion","exportVersion","styled",[23,["exportVersion"]]]]],false],[0,"\\n          "],[7,"label"],[11,"for","exportVersion"],[11,"class","is-label"],[9],[0,"\\n            Export a single version\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"],[4,"if",[[23,["exportVersion"]]],null,{"statements":[[0,"          "],[7,"div"],[11,"class","field"],[9],[0,"\\n            "],[7,"label"],[11,"for","version"],[11,"class","is-label"],[9],[0,"Version"],[10],[0,"\\n            "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n              "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n                "],[7,"select"],[11,"name","version"],[11,"id","version"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["exportKeyVersion"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[23,["key","validKeyVersions"]]],null,{"statements":[[0,"                    "],[7,"option"],[12,"selected",[27,"eq",[[23,["exportKeyVersion"]],[22,1,[]]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n                      "],[7,"code"],[9],[1,[22,1,[]],false],[10],[0,"\\n"],[4,"if",[[27,"eq",[[23,["key","validKeyVersions","lastObject"]],[22,1,[]]],null]],null,{"statements":[[0,"                        "],[7,"span"],[9],[0," (latest) "],[10],[0,"\\n"]],"parameters":[]},null],[0,"                    "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"                "],[10],[0,"\\n              "],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[1,[27,"wrap-ttl",null,[["onChange"],[[27,"action",[[22,0,[]],[27,"mut",[[23,["wrapTTL"]]],null]],null]]]],false],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n          Export key\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/transit-key-action/export.hbs"}})}),define("vault/templates/components/transit-key-action/hmac",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Wed7uDCq",block:'{"symbols":["algo"],"statements":[[7,"form"],[3,"action",[[22,0,[]],"doSubmit",[27,"hash",null,[["input","algorithm","key_version"],[[23,["input"]],[23,["algorithm"]],[23,["key_version"]]]]]],[["on"],["submit"]]],[9],[0,"\\n"],[4,"if",[[23,["hmac"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","hmac"],[11,"class","is-label"],[9],[0,"HMAC"],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"textarea"],[11,"readonly",""],[11,"class","textarea"],[11,"id","hmac"],[9],[1,[21,"hmac"],false],[10],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardTarget","class","buttonType","success"],["#hmac","button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["HMAC copied!"],null]],null]]],{"statements":[[0,"          Copy\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n          Back\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[5,"namespace-reminder",[],[["@mode","@noun"],["perform","HMAC creation"]]],[0,"\\n      "],[1,[27,"key-version-select",null,[["key","onVersionChange","key_version"],[[23,["key"]],[27,"action",[[22,0,[]],[27,"mut",[[23,["key_version"]]],null]],null],[23,["key_version"]]]]],false],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","input"],[11,"class","is-label"],[9],[0,"\\n          Input\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-relative"],[9],[0,"\\n          "],[1,[27,"textarea",null,[["id","name","value","class"],["input","input",[23,["input"]],"textarea"]]],false],[0,"\\n          "],[1,[27,"b64-toggle",null,[["value","isInput"],[[23,["input"]],false]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","algorithm"],[11,"class","is-label"],[9],[0,"Hash Algorithm"],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n          "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n            "],[7,"select"],[11,"name","algorithm"],[11,"id","algorithm"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["algorithm"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"sha2-digest-sizes",null,null]],null,{"statements":[[0,"                 "],[7,"option"],[12,"selected",[27,"if",[[23,["algorithm"]],[27,"eq",[[23,["algorithm"]],[22,1,[]]],null]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n                   "],[7,"code"],[9],[1,[22,1,[]],false],[10],[0,"\\n                 "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n          HMAC\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/transit-key-action/hmac.hbs"}})}),define("vault/templates/components/transit-key-action/rewrap",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"2o7BOq/7",block:'{"symbols":[],"statements":[[7,"form"],[3,"action",[[22,0,[]],"doSubmit",[27,"hash",null,[["ciphertext","context","nonce","key_version"],[[23,["ciphertext"]],[23,["context"]],[23,["nonce"]],[23,["key_version"]]]]]],[["on"],["submit"]]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["perform","rewrap"]]],[0,"\\n    "],[1,[27,"key-version-select",null,[["key","onVersionChange","key_version"],[[23,["key"]],[27,"action",[[22,0,[]],[27,"mut",[[23,["key_version"]]],null]],null],[23,["key_version"]]]]],false],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","ciphertext"],[11,"class","is-label"],[9],[0,"Ciphertext"],[10],[0,"\\n      "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n        "],[1,[27,"textarea",null,[["name","class","id","value"],["ciphertext","textarea","ciphertext",[23,["ciphertext"]]]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"],[4,"if",[[23,["key","derived"]]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","context"],[11,"class","is-label"],[9],[0,"\\n          Context\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","field has-addons"],[9],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"input",null,[["type","id","value","class"],["text","context",[23,["context"]],"input"]]],false],[0,"\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"b64-toggle",null,[["value"],[[23,["context"]]]]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"eq",[[23,["key","convergentEncryptionVersion"]],1],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","nonce"],[11,"class","is-label"],[9],[0,"Nonce"],[10],[0,"\\n        "],[7,"div"],[11,"class","field has-addons"],[9],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"input",null,[["type","id","value","class"],["text","nonce",[23,["nonce"]],"input"]]],false],[0,"\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"b64-toggle",null,[["value"],[[23,["nonce"]]]]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","content"],[9],[0,"\\n      "],[7,"p"],[11,"class","help"],[9],[0,"\\n        Submitting this form will update the "],[7,"code"],[9],[0,"ciphertext"],[10],[0," in-place.\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n        Rewrap\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/transit-key-action/rewrap.hbs"}})}),define("vault/templates/components/transit-key-action/sign",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"EyPIi1C1",block:'{"symbols":["sigAlgo","algo"],"statements":[[7,"form"],[3,"action",[[22,0,[]],"doSubmit",[27,"hash",null,[["input","hash_algorithm","signature_algorithm","key_version","context","prehashed"],[[23,["input"]],[23,["hash_algorithm"]],[23,["signature_algorithm"]],[23,["key_version"]],[23,["context"]],[23,["prehashed"]]]]]],[["on"],["submit"]]],[9],[0,"\\n"],[4,"if",[[23,["signature"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","signature"],[11,"class","is-label"],[9],[0,"Signature"],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"textarea"],[11,"readonly",""],[11,"class","textarea"],[11,"id","signature"],[9],[1,[21,"signature"],false],[10],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardTarget","class","buttonType","success"],["#signature","button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Signature copied!"],null]],null]]],{"statements":[[0,"          Copy\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n          Back\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[5,"namespace-reminder",[],[["@mode","@noun"],["perform","signing"]]],[0,"\\n      "],[1,[27,"key-version-select",null,[["key","onVersionChange","key_version"],[[23,["key"]],[27,"action",[[22,0,[]],[27,"mut",[[23,["key_version"]]],null]],null],[23,["key_version"]]]]],false],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","input"],[11,"class","is-label"],[9],[0,"\\n          Input\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-relative"],[9],[0,"\\n          "],[1,[27,"textarea",null,[["id","name","value","class"],["input","input",[23,["input"]],"textarea"]]],false],[0,"\\n          "],[1,[27,"b64-toggle",null,[["value","isInput"],[[23,["input"]],false]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[23,["key","derived"]]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","context"],[11,"class","is-label"],[9],[0,"\\n            Context\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","field has-addons"],[9],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"input",null,[["type","id","value","class"],["text","context",[23,["context"]],"input"]]],false],[0,"\\n            "],[10],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"b64-toggle",null,[["value"],[[23,["context"]]]]],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n          "],[7,"div"],[11,"class","level-left"],[9],[0,"\\n            "],[7,"label"],[11,"for","hash_algorithm"],[11,"class","is-label"],[9],[0,"Hash Algorithm"],[10],[0,"\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","level-right"],[9],[0,"\\n            "],[7,"div"],[11,"class","control is-flex"],[9],[0,"\\n              "],[1,[27,"input",null,[["id","type","name","class","checked"],["prehashed","checkbox","prehashed","switch is-rounded is-success is-small",[23,["prehashed"]]]]],false],[0,"\\n              "],[7,"label"],[11,"for","prehashed"],[9],[0,"Prehashed"],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n          "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n            "],[7,"select"],[11,"name","hash_algorithm"],[11,"id","hash_algorithm"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["hash_algorithm"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"sha2-digest-sizes",null,null]],null,{"statements":[[0,"               "],[7,"option"],[12,"selected",[27,"if",[[23,["hash_algorithm"]],[27,"eq",[[23,["hash_algorithm"]],[22,2,[]]],null],[27,"eq",[[22,2,[]],"sha2-256"],null]],null]],[12,"value",[22,2,[]]],[9],[0,"\\n                 "],[1,[22,2,[]],false],[0,"\\n               "],[10],[0,"\\n"]],"parameters":[2]},null],[0,"            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[27,"or",[[27,"eq",[[23,["key","type"]],"rsa-2048"],null],[27,"eq",[[23,["key","type"]],"rsa-4096"],null]],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","signature_algorithm"],[11,"class","is-label"],[9],[0,"Signature Algorithm"],[10],[0,"\\n          "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n            "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n              "],[7,"select"],[11,"name","signature_algorithm"],[11,"id","signature_algorithm"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["signature_algorithm"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"array",["pss","pkcs1v15"],null]],null,{"statements":[[0,"                 "],[7,"option"],[12,"selected",[27,"if",[[23,["signature_algorithm"]],[27,"eq",[[23,["signature_algorithm"]],[22,1,[]]],null],[27,"eq",[[22,1,[]],"pss"],null]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n                   "],[1,[22,1,[]],false],[0,"\\n                 "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"              "],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[12,"disabled",[21,"loading"]],[12,"class",[28,["button is-primary ",[27,"if",[[23,["loading"]],"is-loading"],null]]]],[11,"type","submit"],[9],[0,"\\n          Sign\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/transit-key-action/sign.hbs"}})}),define("vault/templates/components/transit-key-action/verify",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"eElsIvWy",block:'{"symbols":["algo","sigAlgo","algo","type"],"statements":[[7,"form"],[3,"action",[[22,0,[]],"doSubmit",[27,"hash",null,[["input","signature","signature_algorithm","hmac","hash_algorithm","context","prehashed"],[[23,["input"]],[23,["signature"]],[23,["signature_algorithm"]],[23,["hmac"]],[23,["hash_algorithm"]],[23,["context"]],[23,["prehashed"]]]]]],[["on"],["submit"]]],[9],[0,"\\n"],[4,"if",[[27,"not-eq",[[23,["valid"]],null],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[7,"h4"],[11,"class","is-label"],[9],[0,"Verified"],[10],[0,"\\n      "],[7,"div"],[11,"class","box"],[9],[0,"\\n        "],[7,"div"],[11,"class","columns is-centered"],[9],[0,"\\n          "],[7,"div"],[11,"class","column is-half has-text-centered"],[9],[0,"\\n            "],[7,"p"],[12,"class",[28,["box is-shadowless ",[27,"if",[[23,["valid"]],"has-text-success","has-text-danger"],null]]]],[9],[0,"\\n            "],[5,"icon",[],[["@glyph"],[[27,"if",[[23,["valid"]],"check-plain","cancel-plain"],null]]]],[0,"\\n            The input is "],[7,"b"],[9],[1,[27,"if",[[23,["valid"]],"valid","not valid"],null],false],[10],[0," for the given "],[1,[27,"if",[[23,["signature"]],"signature","hmac"],null],false],[0,".\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n        Back\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","input"],[11,"class","is-label"],[9],[0,"\\n          Input\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control is-relative"],[9],[0,"\\n          "],[1,[27,"textarea",null,[["id","name","value","class"],["input","input",[23,["input"]],"textarea"]]],false],[0,"\\n          "],[1,[27,"b64-toggle",null,[["value","isInput"],[[23,["input"]],false]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[27,"and",[[23,["key","supportsSigning"]],[23,["key","derived"]],[27,"not",[[23,["hmac"]]],null]],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","context"],[11,"class","is-label"],[9],[0,"\\n            Context\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","field has-addons"],[9],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"input",null,[["type","id","value","class"],["text","context",[23,["context"]],"input"]]],false],[0,"\\n            "],[10],[0,"\\n            "],[7,"div"],[11,"class","control"],[9],[0,"\\n              "],[1,[27,"b64-toggle",null,[["value"],[[23,["context"]]]]],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["key","supportsSigning"]]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","columns is-5"],[9],[0,"\\n          "],[7,"div"],[11,"class","column is-one-third"],[9],[0,"\\n            "],[7,"div"],[11,"class","field"],[9],[0,"\\n              "],[7,"label"],[11,"for","verification"],[11,"class","is-label"],[9],[0,"Verification Type"],[10],[0,"\\n              "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n                "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n                  "],[7,"select"],[11,"name","verification"],[11,"id","verification"],[12,"onchange",[27,"queue",[[27,"action",[[22,0,[]],[27,"mut",[[23,["verification"]]],null]],[["value"],["target.value"]]],[27,"action",[[22,0,[]],"clearParams",[27,"array",["hmac","signature"],null]],null]],null]],[9],[0,"\\n"],[4,"each",[[27,"array",["Signature","HMAC"],null]],null,{"statements":[[0,"                      "],[7,"option"],[12,"selected",[27,"if",[[23,["verification"]],[27,"eq",[[23,["verification"]],[22,4,[]]],null],[27,"if",[[23,["hmac"]],[27,"eq",[[22,4,[]],"HMAC"],null],[27,"eq",[[22,4,[]],"Signature"],null]],null]],null]],[12,"value",[22,4,[]]],[9],[0,"\\n                        "],[1,[22,4,[]],false],[0,"\\n                      "],[10],[0,"\\n"]],"parameters":[4]},null],[0,"                  "],[10],[0,"\\n                "],[10],[0,"\\n              "],[10],[0,"\\n            "],[10],[0,"\\n            "],[7,"div"],[11,"class","field"],[9],[0,"\\n              "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n                "],[7,"div"],[11,"class","level-left"],[9],[0,"\\n                  "],[7,"label"],[11,"for","hash_algorithm"],[11,"class","is-label"],[9],[0,"Hash Algorithm"],[10],[0,"\\n                "],[10],[0,"\\n                "],[7,"div"],[11,"class","level-right"],[9],[0,"\\n"],[4,"unless",[[27,"eq",[[23,["verification"]],"HMAC"],null]],null,{"statements":[[0,"                    "],[7,"div"],[11,"class","control is-flex"],[9],[0,"\\n                      "],[1,[27,"input",null,[["id","type","name","class","checked"],["prehashed","checkbox","prehashed","switch is-rounded is-success is-small",[23,["prehashed"]]]]],false],[0,"\\n                      "],[7,"label"],[11,"for","prehashed"],[9],[0,"Prehashed"],[10],[0,"\\n                    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"                "],[10],[0,"\\n              "],[10],[0,"\\n              "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n                "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n                  "],[7,"select"],[11,"name","hash_algorithm"],[11,"id","hash_algorithm"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["hash_algorithm"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"sha2-digest-sizes",null,null]],null,{"statements":[[0,"                      "],[7,"option"],[12,"selected",[27,"if",[[23,["hash_algorithm"]],[27,"eq",[[23,["hash_algorithm"]],[22,3,[]]],null],[27,"eq",[[22,3,[]],"sha2-256"],null]],null]],[12,"value",[22,3,[]]],[9],[0,"\\n                        "],[7,"code"],[9],[1,[22,3,[]],false],[10],[0,"\\n                      "],[10],[0,"\\n"]],"parameters":[3]},null],[0,"                  "],[10],[0,"\\n                "],[10],[0,"\\n              "],[10],[0,"\\n            "],[10],[0,"\\n"],[4,"if",[[27,"and",[[23,["keyIsRSA"]],[27,"or",[[27,"and",[[23,["verification"]],[27,"eq",[[23,["verification"]],"Signature"],null]],null],[23,["signature"]]],null]],null]],null,{"statements":[[0,"              "],[7,"div"],[11,"class","field"],[9],[0,"\\n                "],[7,"label"],[11,"for","signature_algorithm"],[11,"class","is-label"],[9],[0,"Signature Algorithm"],[10],[0,"\\n                "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n                  "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n                    "],[7,"select"],[11,"name","signature_algorithm"],[11,"id","signature_algorithm"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["signature_algorithm"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"array",["pss","pkcs1v15"],null]],null,{"statements":[[0,"                       "],[7,"option"],[12,"selected",[27,"if",[[23,["signature_algorithm"]],[27,"eq",[[23,["signature_algorithm"]],[22,2,[]]],null],[27,"eq",[[22,2,[]],"pss"],null]],null]],[12,"value",[22,2,[]]],[9],[0,"\\n                         "],[1,[22,2,[]],false],[0,"\\n                       "],[10],[0,"\\n"]],"parameters":[2]},null],[0,"                    "],[10],[0,"\\n                  "],[10],[0,"\\n                "],[10],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[]},null],[0,"\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","column is-two-thirds is-flex-column"],[9],[0,"\\n"],[4,"if",[[27,"or",[[27,"and",[[23,["verification"]],[27,"eq",[[23,["verification"]],"HMAC"],null]],null],[23,["hmac"]]],null]],null,{"statements":[[0,"              "],[7,"div"],[11,"class","field is-flex-column is-flex-1"],[9],[0,"\\n                "],[7,"label"],[11,"for","hmac"],[11,"class","is-label"],[9],[0,"HMAC"],[10],[0,"\\n                "],[7,"div"],[11,"class","control is-flex-column is-flex-1"],[9],[0,"\\n                  "],[1,[27,"textarea",null,[["class","id","value"],["textarea is-flex-1","hmac",[23,["hmac"]]]]],false],[0,"\\n                "],[10],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"              "],[7,"div"],[11,"class","field is-flex-column is-flex-1"],[9],[0,"\\n                "],[7,"label"],[11,"for","signature"],[11,"class","is-label"],[9],[0,"Signature"],[10],[0,"\\n                "],[7,"div"],[11,"class","control is-flex-column is-flex-1"],[9],[0,"\\n                  "],[1,[27,"textarea",null,[["id","class","value"],["signature","textarea is-flex-1",[23,["signature"]]]]],false],[0,"\\n                "],[10],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[]}],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","hmac"],[11,"class","is-label"],[9],[0,"HMAC"],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"textarea",null,[["class","id","value"],["textarea","hmac",[23,["hmac"]]]]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","hash_algorithm"],[11,"class","is-label"],[9],[0,"Algorithm"],[10],[0,"\\n          "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n            "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n              "],[7,"select"],[11,"name","hash_algorithm"],[11,"id","hash_algorithm"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["hash_algorithm"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"array",["sha2-224","sha2-256","sha2-384","sha2-512"],null]],null,{"statements":[[0,"                  "],[7,"option"],[12,"selected",[27,"if",[[23,["hash_algorithm"]],[27,"eq",[[23,["hash_algorithm"]],[22,1,[]]],null],[27,"eq",[[22,1,[]],"sha2-256"],null]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n                    "],[7,"code"],[9],[1,[22,1,[]],false],[10],[0,"\\n                  "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"              "],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]}],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[12,"disabled",[21,"loading"]],[12,"class",[28,["button is-primary ",[27,"if",[[23,["loading"]],"is-loading"],null]]]],[11,"type","submit"],[9],[0,"\\n          Verify\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/transit-key-action/verify.hbs"}})}),define("vault/templates/components/transit-key-actions",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"6sFa0BnJ",block:'{"symbols":[],"statements":[[4,"if",[[27,"eq",[[23,["selectedAction"]],"rotate"],null]],null,{"statements":[[4,"if",[[23,["key","canRotate"]]],null,{"statements":[[0,"    "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@onConfirmAction"],["toolbar-link","Rotate this key?","After rotation, all key actions will default to using the newest version of the key.","Rotate",[27,"action",[[22,0,[]],"doSubmit"],null]]],{"statements":[[0,"\\n      Rotate encryption key\\n      "],[5,"chevron",[],[["@isButton"],[true]]],[0,"\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"  "],[1,[27,"message-error",null,[["errors"],[[23,["errors"]]]]],false],[0,"\\n"],[4,"if",[[23,["selectedAction"]]],null,{"statements":[[0,"    "],[7,"div"],[9],[0,"\\n    "],[15,[27,"concat",["components/transit-key-action/",[23,["selectedAction"]]],null],[]],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}]],"hasEval":true}',meta:{moduleName:"vault/templates/components/transit-key-actions.hbs"}})}),define("vault/templates/components/ui-wizard",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"kJO9gS03",block:'{"symbols":["&default"],"statements":[[7,"div"],[12,"class",[28,["app-content ",[27,"if",[[27,"and",[[23,["shouldRender"]],[23,["featureComponent"]]],null],"wizard-open"],null]]]],[9],[0,"\\n  "],[14,1],[0,"\\n"],[10],[0,"\\n"],[4,"component",[[27,"if",[[23,["shouldRender"]],[23,["tutorialComponent"]]],null]],[["onAdvance","onDismiss"],[[27,"action",[[22,0,[]],"advanceWizard"],null],[27,"action",[[22,0,[]],"dismissWizard"],null]]],{"statements":[[0,"  "],[1,[27,"component",[[23,["featureComponent"]]],[["componentState","nextFeature","nextStep","onDone","onRepeat","onReset","onAdvance"],[[23,["componentState"]],[23,["nextFeature"]],[23,["nextStep"]],[27,"action",[[22,0,[]],"finishFeature"],null],[27,"action",[[22,0,[]],"repeatStep"],null],[27,"action",[[22,0,[]],"resetFeature"],null],[27,"action",[[22,0,[]],"advanceFeature"],null]]]],false],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/components/ui-wizard.hbs"}})}),define("vault/templates/components/wizard-content",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"ynokD5+R",block:'{"symbols":["T","&default"],"statements":[[7,"div"],[11,"class","wizard-header"],[9],[0,"\\n"],[4,"unless",[[23,["hidePopup"]]],null,{"statements":[[0,"    "],[5,"popup-menu",[],[["@class"],["wizard-dismiss-menu"]],{"statements":[[0,"\\n      "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n        "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[7,"button"],[11,"class","button link "],[12,"onclick",[27,"action",[[22,0,[]],"dismissWizard"],null]],[11,"type","button"],[9],[0,"\\n              Dismiss\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"  "],[7,"h1"],[11,"class","title is-5"],[9],[0,"\\n    "],[5,"icon",[],[["@glyph","@size"],[[21,"glyph"],"l"]]],[0," "],[1,[21,"headerText"],false],[0,"\\n  "],[10],[0,"\\n"],[4,"if",[[23,["showProgress"]]],null,{"statements":[[0,"    "],[5,"tool-tip",[],[["@verticalPosition"],["below"]],{"statements":[[0,"\\n      "],[6,[22,1,["trigger"]],[],[["@tabindex"],["false"]],{"statements":[[0,"\\n        "],[5,"wizard-progress",[],[["@currentFeatureProgress","@progressBar"],[[21,"currentFeatureProgress"],[21,"progressBar"]]]],[0,"\\n      "]],"parameters":[]}],[0,"\\n      "],[6,[22,1,["content"]],[],[["@class"],["tool-tip"]],{"statements":[[0,"\\n        "],[7,"div"],[11,"class","box"],[9],[0,"\\n"],[4,"if",[[23,["currentTutorialProgress"]]],null,{"statements":[[0,"            "],[1,[23,["currentTutorialProgress","text"]],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"            "],[7,"p"],[9],[1,[27,"capitalize",[[23,["currentFeatureProgress","feature"]]],null],false],[10],[0,"\\n            "],[1,[23,["currentFeatureProgress","text"]],false],[0,"\\n"]],"parameters":[]}],[0,"        "],[10],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[1]}],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["selectProgress"]]],null,{"statements":[[0,"      "],[5,"wizard-progress",[],[["@noProgress","@progressBar"],[true,[21,"selectProgress"]]]],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}],[10],[0,"\\n"],[14,2],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard-content.hbs"}})}),define("vault/templates/components/wizard-progress",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"MlepN17L",block:'{"symbols":["bar"],"statements":[[7,"div"],[11,"class","progress-container"],[9],[0,"\\n"],[4,"each",[[23,["progressBar"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","feature-progress-container"],[9],[0,"\\n      "],[7,"span"],[11,"class","progress-bar"],[9],[0,"\\n        "],[7,"span"],[11,"class","feature-progress"],[12,"style",[22,1,["style"]]],[9],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[22,1,["showIcon"]]],null,{"statements":[[0,"        "],[5,"icon",[[12,"class",[28,["feature-check ",[27,"if",[[22,1,["completed"]],"completed-check","incomplete-check"],null]]]]],[["@glyph"],["check-circle-fill"]]],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n"]],"parameters":[1]},null],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard-progress.hbs"}})}),define("vault/templates/components/wizard-section",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"clOk3sCT",block:'{"symbols":["&default"],"statements":[[7,"div"],[12,"class",[28,["wizard-section ",[21,"class"]]]],[9],[0,"\\n  "],[7,"h2"],[11,"class","title is-6"],[9],[0,"\\n"],[4,"if",[[23,["headerIcon"]]],null,{"statements":[[0,"      "],[5,"icon",[[11,"aria-hidden","true"]],[["@glyph","@size"],[[21,"headerIcon"],"l"]]],[0,"\\n"]],"parameters":[]},null],[0,"    "],[1,[21,"headerText"],false],[0,"\\n  "],[10],[0,"\\n  "],[14,1],[0,"\\n"],[4,"if",[[23,["instructions"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","wizard-instructions"],[9],[0,"\\n      "],[7,"h2"],[11,"class","title is-6"],[9],[0,"What to do"],[10],[0,"\\n      "],[7,"p"],[9],[1,[21,"instructions"],false],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["docText"]]],null,{"statements":[[0,"    "],[5,"doc-link",[],[["@path"],[[21,"docPath"]]],{"statements":[[0,"\\n      "],[5,"icon",[[11,"aria-hidden","true"]],[["@glyph"],["learn"]]],[0," "],[1,[21,"docText"],false],[0,"\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard-section.hbs"}})}),define("vault/templates/components/wizard/ad-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"B4fwqTnq",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Active Directory","azure","Docs: Active Directory Secrets","/docs/secrets/ad/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The AD Secrets Engine rotates AD passwords dynamically, and is designed for\\n    a high-load environment where many instances may be accessing a shared password simultaneously.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/ad-engine.hbs"}})}),define("vault/templates/components/wizard/alicloud-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"ZBP5TuWF",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["AliCloud","alicloud","Docs: Google Cloud Secrets","/docs/secrets/alicloud/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The AliCloud Secrets Engine dynamically generates AliCloud access tokens based on RAM policies, or AliCloud STS credentials based on RAM roles. This generally makes working with AliCloud easier, since it does not involve clicking in the web UI. The AliCloud access tokens are time-based and are automatically revoked when the Vault lease expires. STS credentials are short-lived, non-renewable, and expire on their own.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/alicloud-engine.hbs"}})}),define("vault/templates/components/wizard/alicloud-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"yIKN7pmB",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["AliCloud","alicloud","Docs: AliCloud Authentication","/docs/auth/alicloud.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The AliCloud Auth Method provides an automated mechanism to retrieve a Vault token for AliCloud entities.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/alicloud-method.hbs"}})}),define("vault/templates/components/wizard/approle-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Uz8US5xL",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["AppRole","approle","Docs: AppRole Authentication","/docs/auth/approle.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Approle Auth Method allows machines or apps to authenticate with Vault-defined roles. The open design of AppRole enables a varied set of workflows and configurations to handle large numbers of apps. This Auth Method is oriented to automated workflows (machines and services), and is less useful for human operators.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/approle-method.hbs"}})}),define("vault/templates/components/wizard/auth-config",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"AjyftFF0",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Configuring your Auth Method","Docs: Authentication Methods","/docs/auth/index.html","Click the \'Save\' link to save any extra configuration. Saving without filling anything in will use the defaults."]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    You can update your new Auth Method configuration here.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/auth-config.hbs"}})}),define("vault/templates/components/wizard/auth-details",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"KZRZt2G0",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@docText","@docPath"],["Auth Method Details","Docs: Authentication Methods","/docs/auth/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    Fantastic! Now you\'re ready to use your new "],[1,[21,"mountName"],false],[0," Auth Method!\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"],[5,"wizard-section",[],[["@headerText","@class"],["Want to start again or move on?","wizard-details"]],{"statements":[[0,"\\n  "],[7,"button"],[11,"class","button next-feature-step"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onReset"]]]],[9],[0,"\\n    Enable another Auth Method "],[5,"icon",[[11,"class","hs-icon-button-right"]],[["@glyph"],["loop"]]],[0,"\\n  "],[10],[0,"\\n  "],[7,"button"],[11,"class","button next-feature-step"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onAdvance"]]]],[9],[0,"\\n    "],[1,[21,"nextFeature"],false],[0," "],[5,"chevron",[],[["@isButton"],[true]]],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/auth-details.hbs"}})}),define("vault/templates/components/wizard/auth-edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"HStSD2QD",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Editing your Auth Method","Docs: Authentication Methods","/docs/auth/index.html","Click the \\"View method\\" link to see its details."]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    You can update your new Auth Method configuration here.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/auth-edit.hbs"}})})
define("vault/templates/components/wizard/auth-enable",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"zj4DQKzZ",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Entering Auth Method details","Docs: Authentication Methods","/docs/auth/index.html","Name your method and click \'Enable Method\'."]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    Great! Now you can customize this method with a name and fill out general configuration under \\"Method Options\\".\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/auth-enable.hbs"}})}),define("vault/templates/components/wizard/auth-idle",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"EhbYDouB",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Enabling an Auth Method","Docs: Authentication Methods","/docs/auth/index.html","Choose an Authentication Method and click \\"Next\\" to get started."]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    Controlling who can see your secrets is important. Let\'s set up a an Authentication Method for you and your team to use. Don\'t worry, you can add more methods later.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/auth-idle.hbs"}})}),define("vault/templates/components/wizard/auth-list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Jjm+kwLO",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Auth Method list","Docs: Authentication Methods","/docs/auth/index.html","Click the ellipsis menu for your method and then click \\"View configuration\\" to see its details."]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    Awesome! Now you can see your new Auth Method in the list.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/auth-list.hbs"}})}),define("vault/templates/components/wizard/aws-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"HoOSPmck",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["AWS","aws","Docs: AWS Secrets","/docs/secrets/aws/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The AWS Secrets Engine generates AWS access credentials dynamically based on IAM policies. This generally makes working with AWS IAM easier, since it does not involve clicking in the web UI. Additionally, the process is codified and mapped to internal Auth Methods (such as LDAP). The AWS IAM credentials are time-based and are automatically revoked when the Vault lease expires.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/aws-engine.hbs"}})}),define("vault/templates/components/wizard/aws-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"PozCAZrK",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["AWS","aws","Docs: AWS Authentication","/docs/auth/aws.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The AWS Auth Method provides an automated mechanism to retrieve a Vault token for AWS EC2 instances and IAM principals. Unlike most Vault Auth Methods, this method does not require manual first-deploying, or provisioning security-sensitive credentials (tokens, username/password, client certificates, etc), by operators under many circumstances.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/aws-method.hbs"}})}),define("vault/templates/components/wizard/azure-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"7aV9lKGk",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Azure","azure","Docs: Azure Secrets","/docs/secrets/azure/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n  The Azure Secrets Engine dynamically generates Azure service principals and role assignments. Vault roles can be mapped to one or more Azure roles, providing a simple, flexible way to manage the permissions granted to generated service principals.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/azure-engine.hbs"}})}),define("vault/templates/components/wizard/azure-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"AWz6j8CC",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Azure","azure","Docs: Azure Authentication","/docs/auth/azure.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Azure Auth Method allows authentication against Vault using Azure Active Directory credentials.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/azure-method.hbs"}})}),define("vault/templates/components/wizard/cert-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"9KpJNAxj",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["TLS Certificates","cert","Docs: TLS Certificates Authentication","/docs/auth/cert.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The TLS Certificates Auth Method allows authentication using SSL/TLS client certificates which are either signed by a CA or self-signed. CA certificates are associated with a role.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/cert-method.hbs"}})}),define("vault/templates/components/wizard/ch-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"TQGf+ZJs",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@docText","@docPath"],["Cubbyhole","Docs: Cubbyhole Secrets","/docs/secrets/cubbyhole/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The cubbyhole Secrets Engine is used to store arbitrary secrets within the configured physical storage for Vault namespaced to a token. In cubbyhole, paths are scoped per token. No token can access another token\'s cubbyhole. When the token expires, its cubbyhole is destroyed.\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/ch-engine.hbs"}})}),define("vault/templates/components/wizard/consul-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"zOnI9dDA",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Consul","consul","Docs: Consul Secrets","/docs/secrets/consul/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Consul Secrets Engine generates Consul API tokens dynamically based on Consul ACL policies.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/consul-engine.hbs"}})}),define("vault/templates/components/wizard/database-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"XzJ1sWCu",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Databases","database","Docs: Database Secrets","/docs/secrets/databases/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The database Secrets Engine generates database credentials dynamically based on configured roles.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/database-engine.hbs"}})}),define("vault/templates/components/wizard/features-selection",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"3Nc1YhT9",block:'{"symbols":["feature","step"],"statements":[[5,"wizard-content",[],[["@headerText","@glyph","@selectProgress"],["Vault Web UI","tour",[21,"selectProgress"]]],{"statements":[[0,"\\n  "],[7,"h2"],[11,"class","title is-6"],[9],[0,"\\n    Choosing where to go\\n  "],[10],[0,"\\n  "],[7,"p"],[9],[0,"You did it! You now have access to your Vault and can start entering your data. We can help you get started with any of the options below."],[10],[0,"\\n  "],[7,"div"],[11,"class","access-information"],[9],[0,"\\n    "],[5,"icon",[[11,"class","has-text-info"]],[["@glyph"],["info-circle-fill"]]],[0,"\\n    "],[7,"p"],[9],[0,"Vault only shows links to pages that you have access to based on your policies. Contact your administrator if you need access changes."],[10],[0,"\\n  "],[10],[0,"\\n"],[4,"if",[[27,"or",[[27,"has-feature",["Performance Replication"],null],[27,"has-feature",["DR Replication"],null]],null]],null,{"statements":[],"parameters":[]},null],[0,"  "],[7,"h3"],[11,"class","feature-header"],[9],[0,"Walk me through setting up:"],[10],[0,"\\n  "],[7,"form"],[11,"id","features-form"],[11,"class","feature-selection"],[3,"action",[[22,0,[]],"saveFeatures"],[["on"],["submit"]]],[9],[0,"\\n"],[4,"each",[[23,["allFeatures"]]],null,{"statements":[[4,"if",[[22,1,["show"]]],null,{"statements":[[0,"    "],[7,"div"],[12,"class",[28,["feature-box ",[27,"if",[[22,1,["selected"]],"is-active"],null]," ",[27,"if",[[22,1,["disabled"]],"is-disabled"],null]]]],[9],[0,"\\n      "],[7,"div"],[11,"class","b-checkbox"],[9],[0,"\\n        "],[7,"input"],[12,"id",[28,["feature-",[22,1,["key"]]]]],[11,"class","styled"],[12,"checked",[22,1,["selected"]]],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[22,1,["selected"]]],null]],[["value"],["target.checked"]]]],[12,"disabled",[22,1,["disabled"]]],[11,"type","checkbox"],[9],[10],[0,"\\n        "],[7,"label"],[12,"for",[28,["feature-",[22,1,["key"]]]]],[9],[1,[22,1,["name"]],false],[10],[0,"\\n        "],[7,"button"],[11,"class","button is-ghost icon is-pulled-right"],[12,"onclick",[27,"action",[[22,0,[]],[27,"toggle",[[27,"concat",[[22,1,["key"]],"-isOpen"],null],[22,0,[]]],null]],null]],[11,"type","button"],[9],[0,"\\n          "],[5,"chevron",[],[["@direction","@class"],[[27,"if",[[27,"get",[[22,0,[]],[27,"concat",[[22,1,["key"]],"-isOpen"],null]],null],"up","down"],null],"has-text-grey auto-width is-paddingless is-flex-column"]]],[0,"\\n        "],[10],[0,"\\n"],[4,"if",[[22,1,["disabled"]]],null,{"statements":[[0,"          "],[5,"info-tooltip",[],[[],[]],{"statements":[[0,"\\n              You do not have permissions to tour some parts of this feature\\n          "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"],[4,"if",[[27,"get",[[22,0,[]],[27,"concat",[[22,1,["key"]],"-isOpen"],null]],null]],null,{"statements":[[0,"        "],[7,"ul"],[11,"class","feature-steps"],[9],[0,"\\n"],[4,"each",[[22,1,["steps"]]],null,{"statements":[[0,"            "],[7,"li"],[9],[1,[22,2,[]],false],[10],[0,"\\n"]],"parameters":[2]},null],[0,"        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null],[0,"    "],[7,"span"],[11,"class","selection-summary"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[12,"disabled",[21,"cannotStartWizard"]],[11,"type","submit"],[9],[0,"\\n        Start\\n      "],[10],[0,"\\n"],[4,"if",[[23,["selectedFeatures"]]],null,{"statements":[[0,"        "],[7,"span"],[11,"class","time-estimate"],[9],[5,"icon",[[11,"class","has-text-grey"],[11,"aria-hidden","true"]],[["@glyph"],["stopwatch"]]],[0,"About "],[1,[21,"estimatedTime"],false],[0," minutes"],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/features-selection.hbs"}})}),define("vault/templates/components/wizard/gcp-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"bQv7On6d",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Google Cloud","gcp","Docs: Google Cloud Secrets","/docs/secrets/gcp/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Google Cloud Vault Secrets Engine dynamically generates Google Cloud service account keys and OAuth tokens based on IAM policies. This enables users to gain access to Google Cloud resources without needing to create or manage a dedicated service account.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/gcp-engine.hbs"}})}),define("vault/templates/components/wizard/gcp-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"E4h5B7Ud",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Google Cloud","gcp","Docs: Google Cloud Authentication","/docs/auth/gcp.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The GCP Auth Method allows authentication against Vault using Google credentials.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/gcp-method.hbs"}})}),define("vault/templates/components/wizard/gcpkms-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"duUHLBDT",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Google Cloud KMS","gcpkms","Docs: Google Cloud Secrets","/docs/secrets/gcpkms/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Google Cloud KMS Vault Secrets Engine provides encryption and key management via Google Cloud KMS. It supports management of keys, including creation, rotation, and revocation, as well as encrypting and decrypting data with managed keys. This enables management of KMS keys through Vault\'s policies and IAM system.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/gcpkms-engine.hbs"}})}),define("vault/templates/components/wizard/github-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"hLmg+plf",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["GitHub","github","Docs: GitHub Authentication","/docs/auth/github.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Github Auth Method can be used to authenticate with Vault using a GitHub personal access token.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/github-method.hbs"}})}),define("vault/templates/components/wizard/init-login",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"NTCHupVW",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Authentication","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath"],["Authenticate to Vault","Learn: Initialization","/docs/concepts/tokens.html"]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Vault is unsealed, but we still need to authenticate using the Initial\\n      Root Token that was generated. We recommend setting up an Authentication\\n      Method such as Username & Password for regular use, and only using a root\\n      token for initial setup or for emergencies.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/init-login.hbs"}})}),define("vault/templates/components/wizard/init-save-keys",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"HmAPXsc9",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Initialization","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath"],["Saving your keys","Learn: Initialization","/intro/getting-started/deploy.html#initializing-the-vault"]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"Now that Vault is initialized, you\'ll want to save your root token and\\n    master key portions in a safe place. Distribute your keys to responsible\\n    people on your team. If these keys are lost, you may not be able to access\\n    your data again. Keep them safe!"],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/init-save-keys.hbs"}})}),define("vault/templates/components/wizard/init-setup",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"P7j8j5MH",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Initialization","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath"],["Setting up your master keys","Learn: Initialization","/intro/getting-started/deploy.html#initializing-the-vault"]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      This is the very first step of setting up\\n      a Vault server. Vault comes with an important\\n      security feature called a \\"seal\\", which lets you\\n      shut down and secure your Vault installation if\\n      there is a security breach. This is the default\\n      state of Vault, so it is currently sealed since\\n      it was just installed. To unseal the vault, you will\\n      need to provide the key(s) that you generate here.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/init-setup.hbs"}})}),define("vault/templates/components/wizard/init-unseal",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"0GKDtGHW",block:'{"symbols":["word"],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Initialization","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath"],["Unsealing your vault","Learn: Initialization","/intro/getting-started/deploy.html#initializing-the-vault"]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Now we will provide the "],[1,[27,"pluralize",[[23,["componentState","threshold"]],"key"],null],false],[0," that\\n      you copied or downloaded to unseal the vault so that we can get started\\n      using it. You\'ll need "],[1,[27,"pluralize",[[23,["componentState","threshold"]],"key"],null],false],[0," total,\\n      and "],[4,"with",[[27,"pluralize",[[23,["componentState","progress"]],"key"],[["without-count"],[true]]]],null,{"statements":[[0,"\\n      "],[1,[27,"if",[[27,"eq",[[22,1,[]],"key"],null],[27,"concat",[[23,["componentState","progress"]]," ",[22,1,[]]," has "],null],[27,"concat",[[23,["componentState","progress"]]," ",[22,1,[]]," have "],null]],null],false],[0,"\\n      "]],"parameters":[1]},null],[0," already been provided.\\n      Please provide\\n      "],[1,[27,"pluralize",[[27,"dec",[[23,["componentState","progress"]],[23,["componentState","threshold"]]],null],"more key"],null],false],[0," to unseal.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/init-unseal.hbs"}})}),define("vault/templates/components/wizard/kubernetes-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"36AMLGww",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Kubernetes","kubernetes","Docs: Kubernetes Authentication","/docs/auth/kubernetes.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Kubernetes Auth Method can be used to authenticate with Vault using a Kubernetes Service Account Token. This method of authentication makes it easy to introduce a Vault token into a Kubernetes Pod.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/kubernetes-method.hbs"}})}),define("vault/templates/components/wizard/kv-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"+duNo4Wl",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Key/Value","kv","Docs: Key/Value Secrets","/docs/secrets/kv/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The KV Secrets Engine is used to store arbitrary secrets within the configured physical storage for Vault. This backend can be run in one of two modes. It can be a generic key-value store that stores one value for a key. Versioning can be enabled and a configurable number of versions for each key will be stored.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/kv-engine.hbs"}})}),define("vault/templates/components/wizard/ldap-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"NEXtgktU",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["LDAP","ldap","Docs: LDAP Authentication","/docs/auth/ldap.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The LDAP Auth Method allows authentication using an existing LDAP server and user/password credentials. This allows Vault to be integrated into environments using LDAP without duplicating the user/pass configuration in multiple places.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/ldap-method.hbs"}})}),define("vault/templates/components/wizard/mounts-wizard",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"uJEWXCVr",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],[[27,"capitalize",[[23,["currentMachine"]]],null],"tour"]],{"statements":[[0,"\\n"],[1,[27,"component",[[23,["stepComponent"]]],[["mountSubtype","mountName","actionText","nextFeature","nextStep","needsEncryption","isSupported","onDone","onAdvance","onRepeat","onReset","class"],[[23,["mountSubtype"]],[23,["mountName"]],[23,["actionText"]],[23,["nextFeature"]],[23,["nextStep"]],[23,["needsEncryption"]],[23,["isSupported"]],[23,["onDone"]],[23,["onAdvance"]],[23,["onRepeat"]],[23,["onReset"]],"wizard-step"]]],false],[0,"\\n"],[1,[27,"component",[[23,["detailsComponent"]]],[["onAdvance","onRepeat","class"],[[23,["onAdvance"]],[23,["onRepeat"]],"wizard-details"]]],false],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/mounts-wizard.hbs"}})}),define("vault/templates/components/wizard/nomad-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"hj9Bfjus",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Nomad","nomad","Docs: Nomad Secrets","/docs/secrets/nomad/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Nomad secret backend for Vault generates Nomad API tokens dynamically based on pre-existing Nomad ACL policies.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/nomad-engine.hbs"}})}),define("vault/templates/components/wizard/okta-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"CpRjyCGq",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Okta","okta","Docs: Okta Authentication","/docs/auth/okta.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Okta Auth Method allows authentication using Okta and user/password credentials. This allows Vault to be integrated into environments using Okta.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/okta-method.hbs"}})}),define("vault/templates/components/wizard/pki-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"gbdrAFox",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["PKI","pki","Docs: PKI Secrets","/docs/secrets/pki/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The PKI Secrets Engine generates dynamic X.509 certificates. With this Secrets Engine, services can get certificates without going through the usual manual process of generating a private key and CSR, submitting to a CA, and waiting for a verification and signing process to complete.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/pki-engine.hbs"}})}),define("vault/templates/components/wizard/policies-create",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"YZdYPSmR",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Policies","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Creating a policy","Docs: Policies","/docs/concepts/policies.html","Fill in your policy details and click \\"Create Policy\\"."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Let\'s use \\""],[7,"code"],[9],[0,"my-new-policy"],[10],[0,"\\" for your policy name. Copy the policy below to try it out:\\n    "],[10],[0,"\\n"],[7,"pre"],[9],[7,"code"],[9],[0,"path \\"secret/foo\\" {\\n  capabilities = [\\"read\\"]\\n}"],[10],[10],[0,"  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/policies-create.hbs"}})}),define("vault/templates/components/wizard/policies-delete",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"OrEb9cf8",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Policies","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Deleting your policy","Docs: Policies","/docs/concepts/policies.html","Click on \\"Delete\\" to remove the policy that you created."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      You can delete your test policy by clicking the \\"...\\" icon to the right of the policy name.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/policies-delete.hbs"}})}),define("vault/templates/components/wizard/policies-details",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"A27XRolM",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Policies","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Your new policy","Docs: Policies","/docs/concepts/policies.html","Click on \\"ACL Policies\\" in the sidebar to go back to the list of policies."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Good job! Here you can see your new policy. If you\'d like to edit it, you\'d just click the \\"Edit\\" toggle.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/policies-details.hbs"}})})
define("vault/templates/components/wizard/policies-intro",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"9sSdYlyo",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Policies","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Choosing a policy type","Docs: Policies","/docs/concepts/policies.html","To get started with something simple, click on \\"Create ACL policy\\"."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Policies in Vault are a way for you to control what data can be accessed, including things like creating new secrets, listing users, or even entire Vault features.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/policies-intro.hbs"}})}),define("vault/templates/components/wizard/policies-others",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"MZr1uQn7",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Policies","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath"],["Other kinds of policies","Docs: Policies","/docs/concepts/policies.html"]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Good! Now you\'re ready to go writing your own policies. We only explored ACL policies, but there are two other types of policies available to Enterprise customers that might be what you need. RGP (Role Governing Policies) are policies tied to particular tokens, entities, or groups. EGP (Endpoint Governing Policies) are tied to specific paths instead of tokens.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@class"],["Ready to move on?","wizard-details"]],{"statements":[[0,"\\n    "],[7,"button"],[11,"class","button next-feature-step"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onAdvance"]]]],[9],[0,"\\n      "],[1,[21,"nextFeature"],false],[0," "],[5,"chevron",[],[["@isButton"],[true]]],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/policies-others.hbs"}})}),define("vault/templates/components/wizard/rabbitmq-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"OyCbfYcO",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["RabbitMQ","rabbitmq","Docs: RabbitMQ Secrets","/docs/secrets/rabbitmq/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The RabbitMQ Secrets Engine generates user credentials dynamically based on configured permissions and virtual hosts. This means that services that need to access a virtual host no longer need to hardcode credentials.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/rabbitmq-engine.hbs"}})}),define("vault/templates/components/wizard/radius-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"a47i5/Ys",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["RADIUS","radius","Docs: RADIUS Authentication","/docs/auth/radius.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The RADIUS Auth Method allows users to authenticate with Vault using an existing RADIUS server that accepts the PAP authentication scheme.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/radius-method.hbs"}})}),define("vault/templates/components/wizard/replication-details",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"nHo4o/DC",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Replication","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath"],["Your cluster information","Docs: Replication","/docs/internals/replication.html"]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Here you can see the details about your new replication cluster, manage or disable replication, and handle secondary clusters. You can also get a quick status by hovering over the \\"Replication\\" link at the top.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[7,"div"],[11,"class","wizard-details"],[9],[0,"\\n    "],[7,"h3"],[11,"class","title is-6"],[9],[0,"\\n      Ready to move on?\\n    "],[10],[0,"\\n    "],[7,"button"],[11,"class","button next-feature-step"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onAdvance"]]]],[9],[0,"\\n      "],[1,[21,"nextFeature"],false],[0," "],[5,"chevron",[],[["@isButton"],[true]]],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/replication-details.hbs"}})}),define("vault/templates/components/wizard/replication-setup",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"/ZtTSTcy",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Replication","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Setting up Replication","Docs: Replication","/docs/internals/replication.html","Choose the one that is right for your needs and click \\"Enable Replication\\""]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Vault has two kinds of replication, each for a different purpose. Do you want to keep a backup of your data, or are you more interested in speed of access?\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@class"],["Cluster mode","wizard-details"]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      A cluster is set as either a primary or secondary. The primary cluster is authoritative, and is the only cluster allowed to perform actions that write to the underlying data storage, such as modifying policies or secrets. Secondary clusters can service all other operations and forward any writes to the primary cluster.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/replication-setup.hbs"}})}),define("vault/templates/components/wizard/secrets-credentials",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"IsquLBoW",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText"],["Generate Credential"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    Enter details and generate your credential.\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/secrets-credentials.hbs"}})}),define("vault/templates/components/wizard/secrets-details",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"2vBPpQul",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@instructions"],["Your Secrets Engine",[28,["Click on the link to add a ",[21,"nextStep"]," in the page header"]]]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n"],[4,"if",[[23,["needsEncryption"]]],null,{"statements":[[0,"      The Transit Secrets Engine uses encryption keys to provide \\"encryption as a service\\". Click on \\"Create Encryption Key\\" at the top to create one.\\n"]],"parameters":[]},{"statements":[[0,"      Now that we\'ve mounted the "],[1,[21,"secretType"],false],[0," Secrets Engine, let\'s add a "],[1,[21,"nextStep"],false],[0,".\\n"]],"parameters":[]}],[0,"  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/secrets-details.hbs"}})}),define("vault/templates/components/wizard/secrets-display-role",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"jHM6y5Qa",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText"],["Your new role"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    With our new role, we can generate a credential that has the same permissions as that role. Click on \\"Generate credentials\\" links at the top of the page.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/secrets-display-role.hbs"}})}),define("vault/templates/components/wizard/secrets-display",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"R/Xj5p0/",block:'{"symbols":[],"statements":[[4,"if",[[23,["isSupported"]]],null,{"statements":[[0,"  "],[5,"wizard-section",[],[["@headerText"],[[27,"unless",[[23,["actionText"]],"All set!","Generate Credential"],null]]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n"],[4,"if",[[23,["actionText"]]],null,{"statements":[[0,"        Here is your generated credential. As you can see, we can only show the credential once, so you\'ll want to be sure to save it. If you need another credential in the future, just come back and generate a new one.\\n"]],"parameters":[]},{"statements":[[0,"        Well done!\\n"]],"parameters":[]}],[0,"      You\'re now ready to start using your new "],[1,[21,"mountName"],false],[0," Secrets Engine.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[5,"wizard-section",[],[["@headerText"],["Viewing engine configuration"]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Here you can see all the details of your new engine. This can be useful to get information for things like TTL or Seal Wrap settings.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[5,"wizard-section",[],[["@headerText","@class"],["Want to start again or move on?","wizard-details"]],{"statements":[[0,"\\n"],[4,"if",[[23,["isSupported"]]],null,{"statements":[[0,"    "],[7,"button"],[11,"class","button next-feature-step"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onRepeat"]]]],[9],[0,"\\n      Create another "],[1,[27,"unless",[[23,["needsEncryption"]],[23,["mountName"]]],null],false],[0," "],[1,[21,"nextStep"],false],[0," "],[1,[27,"if",[[23,["needsEncryption"]],"key"],null],false],[0," "],[5,"icon",[[11,"class","hs-icon-button-right"],[11,"aria-hidden","true"]],[["@glyph"],["loop"]]],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[7,"button"],[11,"class","button next-feature-step"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onReset"]]]],[9],[0,"\\n    Enable another Secrets Engine "],[5,"icon",[[11,"class","hs-icon-button-right"],[11,"aria-hidden","true"]],[["@glyph"],["loop"]]],[0,"\\n  "],[10],[0,"\\n  "],[7,"button"],[11,"class","button next-feature-step"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onDone"]]]],[9],[0,"\\n    "],[1,[21,"nextFeature"],false],[0," "],[5,"chevron",[],[["@isButton"],[true]]],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/secrets-display.hbs"}})}),define("vault/templates/components/wizard/secrets-enable",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"7rWiSp1i",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Entering Secrets Engine details","Docs: Secrets Engines","/docs/secrets/index.html","Fill in the details for your engine and click \\"Enable Engine\\""]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    Good choice! Now you can customize your engine with a name and description that makes sense for your team, as well as options for replication and caching.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/secrets-enable.hbs"}})}),define("vault/templates/components/wizard/secrets-encryption",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"KBKwOtoG",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText"],["Adding an encryption key"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    Enter the details about your encryption key and save it.\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/secrets-encryption.hbs"}})}),define("vault/templates/components/wizard/secrets-idle",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"aJ+uTamA",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Enabling a Secrets Engine","Docs: Secrets Engines","/docs/secrets/index.html","Select an engine and click \\"Next\\""]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    Vault is all about managing secrets, so let\'s set up your first Secrets Engine. You can use a static engine to store your secrets locally in Vault, or connect to a cloud backend with one of the dynamic engines.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/secrets-idle.hbs"}})}),define("vault/templates/components/wizard/secrets-list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Slu/q3TB",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@instructions"],["Viewing engine configuration","Find the engine in the list and click on \\"View configuration\\" in the menu on the right."]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    This engine isn\'t fully supported in the Vault UI yet, but you can view and edit the configuration and use the Vault Browser CLI to interact with the engine just like you would on the command-line.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/secrets-list.hbs"}})}),define("vault/templates/components/wizard/secrets-role",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"VXDP9dFP",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@instructions"],["Adding a role","Enter your role details and click \\"Save\\""]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    A role grants permissions that specify what an identity can and cannot do. A role is typically shared among many users who are then granted credentials with that are granted the policy permissions.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/secrets-role.hbs"}})}),define("vault/templates/components/wizard/secrets-secret",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"72wQMAKU",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@instructions"],["Adding a secret","Enter the details of your secret and click \\"Save\\""]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    Here you can specify the path of your secret and include the key/value pairs to include.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/secrets-secret.hbs"}})}),define("vault/templates/components/wizard/ssh-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"8ZN/3JHq",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["SSH","ssh","Docs: SSH Secrets","/docs/secrets/ssh/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Vault SSH Secrets Engine provides secure authentication and authorization for access to machines via the SSH protocol. The Vault SSH Secrets Engine helps manage access to machine infrastructure, providing several ways to issue SSH credentials.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/ssh-engine.hbs"}})}),define("vault/templates/components/wizard/tools-info",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"9FP9Nleh",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Tools","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Information about your data","API: Lookup Data","/api/system/wrapping-lookup.html","Click on \\"Rewrap\\" in the sidebar."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Good job! You can see some basic information about your wrapped data, including the expiration time. Next up, we\'ll take the token you still have in your clipboard and rewrap it to keep it active and extend that expiration time.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tools-info.hbs"}})}),define("vault/templates/components/wizard/tools-lookup",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"JFjQReyG",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Tools","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Lookup wrapped data","API: Lookup Data","/api/system/wrapping-lookup.html","Paste the token that you copied and click \\"Lookup Token\\"."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Lookup lets you see information about your token without unwrapping it or changing it. Paste your token here and click \\"Lookup\\". If you find that your data didn\'t copy for some reason, you can always go back and do it again.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tools-lookup.hbs"}})}),define("vault/templates/components/wizard/tools-rewrap",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"av34047H",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Tools","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Rewrapping your data","API: Rewrap Data","/api/system/wrapping-rewrap.html","Paste your token into the input and click \\"Rewrap Token\\" to transform your token into a new one."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      You can rewrap your data to rotate the token, but it will still have the same creation time and TTL. Don\'t worry, the new token will still have the same data.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tools-rewrap.hbs"}})}),define("vault/templates/components/wizard/tools-rewrapped",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"dn4ZAvOt",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Tools","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Your rewrapped data","API: Rewrap Data","/api/system/wrapping-rewrap.html","Copy this token and then click on \\"Unwrap\\" in the sidebar to verify the data is still in there."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      It\'s a subtle transformation, but your old token has been revoked and this new one has taken its place.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tools-rewrapped.hbs"}})}),define("vault/templates/components/wizard/tools-unwrap",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"aSERrSCo",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Tools","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Unwrapping your data","API: Unwrap Data","/api/system/wrapping-unwrap.html","Paste your token into the input and click \\"Unwrap Data\\"."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      We saved this step for the end because unwrapping the token will revoke it, so we can only do this once.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tools-unwrap.hbs"}})}),define("vault/templates/components/wizard/tools-unwrapped",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"GWOQUQuu",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Tools","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath"],["Your unwrapped data","API: Unwrap Data","/api/system/wrapping-unwrap.html"]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Here you can see that your data survived intact. These tools are mostly handy for applications to use, but if you ever do need to wrap data or handle the wrapping token, now you know how.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[7,"button"],[11,"class","button next-feature-step"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onAdvance"]]]],[9],[0,"\\n   "],[1,[21,"nextFeature"],false],[0," "],[5,"chevron",[],[["@isButton"],[true]]],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tools-unwrapped.hbs"}})}),define("vault/templates/components/wizard/tools-wrap",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"w7R0J/Zz",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Tools","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Wrapping data","API: Wrap Data","/api/system/wrapping-wrap.html","Enter some data in JSON format and click \\"Wrap Data\\"."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Vault provides several ways to create or wrap data, and manage it from there. Here you can wrap a token (or anything you like) in JSON format. Give it a try.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tools-wrap.hbs"}})}),define("vault/templates/components/wizard/tools-wrapped",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"OF2V1kkm",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph"],["Tools","tour"]],{"statements":[[0,"\\n  "],[5,"wizard-section",[],[["@headerText","@docText","@docPath","@instructions"],["Copying your wrapped token","API: Wrap Data","/api/system/wrapping-wrap.html","Copy the token and then click on \\"Lookup\\" in the sidebar."]],{"statements":[[0,"\\n    "],[7,"p"],[9],[0,"\\n      Your data is now encrypted. You can recover the data using the token on this page, but be careful because if you lose the token you won\'t be able to retrieve your data! We will use this token for the next few steps.\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tools-wrapped.hbs"}})}),define("vault/templates/components/wizard/totp-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"gZyVReM0",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["TOTP","totp","Docs: TOTP Secrets","/docs/secrets/totp/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The TOTP Secrets Engine generates time-based credentials according to the TOTP standard.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/totp-engine.hbs"}})}),define("vault/templates/components/wizard/transit-engine",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"KxkkjADP",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Transit","transit","Docs: Transit Secrets","/docs/secrets/transit/index.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Transit Secrets Engine handles cryptographic functions on data in-transit. Vault doesn\'t store the data sent to the Secrets Engine. It can also be viewed as \\"cryptography as a service\\" or \\"encryption as a service\\".\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/transit-engine.hbs"}})}),define("vault/templates/components/wizard/tutorial-active",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"t6BZZg8u",block:'{"symbols":["&default"],"statements":[[0,"  "],[14,1],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tutorial-active.hbs"}})}),define("vault/templates/components/wizard/tutorial-complete",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"dyzUZCW+",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph","@class"],["Thanks for taking the tour!","tour","collapsed"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    We hope you enjoyed using Vault. You can get back to the guide in the user menu in the upper right.\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","box wizard-divider-box"],[9],[0,"\\n    "],[7,"button"],[11,"class","button is-transparent has-icon-left has-text-white"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onDismiss"]]]],[9],[0,"\\n      "],[5,"icon",[[11,"aria-hidden","true"]],[["@glyph"],["cancel-plain"]]],[0,"\\n      Close\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tutorial-complete.hbs"}})}),define("vault/templates/components/wizard/tutorial-error",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"1pd4GsuP",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText"],["Oops!"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    Something went wrong and you can\'t complete this step.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"],[5,"wizard-section",[],[[],[]],{"statements":[[0,"\\n  "],[7,"button"],[11,"class","button next-feature-step"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onReset"]]]],[9],[0,"\\n    Go Back "],[5,"icon",[],[["@glyph"],["reply"]]],[0,"\\n  "],[10],[0,"\\n  "],[7,"button"],[11,"class","button next-feature-step"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onAdvance"]]]],[9],[0,"\\n    "],[1,[21,"nextFeature"],false],[0," "],[5,"chevron",[],[["@isButton"],[true]]],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tutorial-error.hbs"}})})
define("vault/templates/components/wizard/tutorial-idle",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"dGkqBltG",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph","@class","@hidePopup"],["Welcome to Vault","tour","collapsed",true]],{"statements":[[0,"\\n  "],[7,"button"],[11,"class","button is-transparent icon dismiss-collapsed"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onDismiss"]]]],[9],[0,"\\n    "],[5,"icon",[[11,"aria-label","Close"]],[["@glyph"],["cancel-plain"]]],[0,"\\n  "],[10],[0,"\\n  "],[7,"p"],[9],[0,"Want a tour? Our helpful guide will introduce you to the Vault Web UI."],[10],[0,"\\n  "],[7,"div"],[11,"class","box wizard-divider-box"],[9],[0,"\\n    "],[7,"button"],[11,"class","button is-transparent has-icon-left has-text-white"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onAdvance"]]]],[9],[0,"\\n      "],[5,"chevron",[],[["@direction"],["up"]]],[0,"\\n      Let\'s get started\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tutorial-idle.hbs"}})}),define("vault/templates/components/wizard/tutorial-paused",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"jX4RqxcP",block:'{"symbols":[],"statements":[[5,"wizard-content",[],[["@headerText","@glyph","@class","@hidePopup"],["Vault Web UI Guide","tour","collapsed",true]],{"statements":[[0,"\\n  "],[7,"button"],[11,"class","button is-transparent dismiss-collapsed"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onDismiss"]]]],[9],[0,"\\n    "],[5,"icon",[[11,"aria-label","Close"]],[["@glyph"],["cancel-plain"]]],[0,"\\n  "],[10],[0,"\\n  "],[7,"p"],[9],[0,"Feel free to explore Vault. Click below to get back to the guide or close this window."],[10],[0,"\\n  "],[7,"div"],[11,"class","box wizard-divider-box"],[9],[0,"\\n    "],[7,"button"],[11,"class","button is-transparent has-icon-left has-text-white"],[11,"type","button"],[3,"action",[[22,0,[]],[23,["onAdvance"]]]],[9],[0,"\\n      "],[5,"chevron",[],[["@direction"],["up"]]],[0,"\\n      Back to guide\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/tutorial-paused.hbs"}})}),define("vault/templates/components/wizard/userpass-method",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Ox3/HHvM",block:'{"symbols":[],"statements":[[5,"wizard-section",[],[["@headerText","@headerIcon","@docText","@docPath"],["Username & Password","userpass","Docs: Userpass Authentication","/docs/auth/userpass.html"]],{"statements":[[0,"\\n  "],[7,"p"],[9],[0,"\\n    The Username & Password Auth Method allows users to authenticate with Vault using a username and password combination.\\n  "],[10],[0,"\\n"]],"parameters":[]}],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/components/wizard/userpass-method.hbs"}})}),define("vault/templates/loading",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"h+D4vZzz",block:'{"symbols":[],"statements":[[5,"logo-splash",[],[[],[]]],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/loading.hbs"}})}),define("vault/templates/partials/auth-form/github",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"kLl55R8d",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","field"],[9],[0,"\\n  "],[7,"label"],[11,"for","token"],[11,"class","is-label"],[9],[0,"GitHub token"],[10],[0,"\\n  "],[7,"div"],[11,"class","control"],[9],[0,"\\n    "],[1,[27,"input",null,[["type","value","name","id","class","autocomplete","spellcheck"],["password",[23,["token"]],"token","token","input","off","false"]]],false],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/auth-form/github.hbs"}})}),define("vault/templates/partials/auth-form/ldap",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"ZFgUb08N",block:'{"symbols":[],"statements":[[15,"partials/userpass-form",[]],[0,"\\n"]],"hasEval":true}',meta:{moduleName:"vault/templates/partials/auth-form/ldap.hbs"}})}),define("vault/templates/partials/auth-form/okta",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"qkV0RDbT",block:'{"symbols":[],"statements":[[15,"partials/userpass-form",[]],[0,"\\n"]],"hasEval":true}',meta:{moduleName:"vault/templates/partials/auth-form/okta.hbs"}})}),define("vault/templates/partials/auth-form/radius",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"qZj/bt1d",block:'{"symbols":[],"statements":[[15,"partials/userpass-form",[]],[0,"\\n"]],"hasEval":true}',meta:{moduleName:"vault/templates/partials/auth-form/radius.hbs"}})}),define("vault/templates/partials/auth-form/token",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"GirsBmX1",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","field"],[9],[0,"\\n  "],[7,"label"],[11,"for","token"],[11,"class","is-label"],[9],[0,"Token"],[10],[0,"\\n  "],[7,"div"],[11,"class","control"],[9],[0,"\\n    "],[1,[27,"input",null,[["type","value","name","class","autocomplete","spellcheck"],["password",[23,["token"]],"token","input","off","false"]]],false],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/auth-form/token.hbs"}})}),define("vault/templates/partials/auth-form/userpass",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"bzwWG9Ej",block:'{"symbols":[],"statements":[[15,"partials/userpass-form",[]],[0,"\\n"]],"hasEval":true}',meta:{moduleName:"vault/templates/partials/auth-form/userpass.hbs"}})}),define("vault/templates/partials/backend-details",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"4xlgs2PH",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","level has-padded-items box no-padding-bottom is-shadowless is-size-7 has-background-transparent is-fullwidth"],[9],[0,"\\n"],[4,"if",[[23,["backend","description"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","level-item level-left is-fixed-25"],[9],[0,"\\n      "],[7,"div"],[9],[0,"\\n        "],[7,"h4"],[11,"class","label is-marginless"],[9],[0,"Description"],[10],[0,"\\n        "],[7,"p"],[11,"class","has-text-grey-dark is-size-8"],[9],[0,"\\n        "],[1,[27,"capitalize",[[23,["backend","description"]]],null],false],[0,".\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[7,"div"],[11,"class","level-item level-left"],[9],[0,"\\n    "],[7,"div"],[9],[0,"\\n      "],[7,"h4"],[11,"class","label"],[9],[0,"Default TTL"],[10],[0,"\\n      "],[7,"span"],[9],[0,"\\n        "],[1,[23,["backend","config","default_lease_ttl"]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","level-item level-left"],[9],[0,"\\n    "],[7,"div"],[9],[0,"\\n      "],[7,"h4"],[11,"class","label"],[9],[0,"Maximum TTL"],[10],[0,"\\n      "],[7,"span"],[9],[0,"\\n        "],[1,[23,["backend","config","max_lease_ttl"]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","level-item level-left"],[9],[0,"\\n    "],[7,"div"],[9],[0,"\\n      "],[7,"h4"],[11,"class","label"],[9],[0,"Replicated behavior"],[10],[0,"\\n      "],[1,[23,["backend","localDisplay"]],false],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/backend-details.hbs"}})}),define("vault/templates/partials/form-field-from-model",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"7EXay6Tn",block:'{"symbols":["val"],"statements":[[7,"div"],[11,"class","field"],[9],[0,"\\n"],[4,"unless",[[27,"or",[[27,"contains",[[23,["attr","options","editType"]],[27,"array",["boolean","searchSelect","mountAccessor","kv","file","ttl","stringArray","json"],null]],null],[27,"eq",[[23,["attr","type"]],"boolean"],null]],null]],null,{"statements":[[0,"    "],[7,"label"],[12,"for",[28,[[23,["attr","name"]]]]],[11,"class","is-label"],[9],[0,"\\n      "],[1,[27,"capitalize",[[27,"or",[[23,["attr","options","label"]],[27,"humanize",[[27,"dasherize",[[23,["attr","name"]]],null]],null]],null]],null],false],[0,"\\n"],[4,"if",[[23,["attr","options","helpText"]]],null,{"statements":[[0,"        "],[4,"info-tooltip",null,null,{"statements":[[1,[23,["attr","options","helpText"]],false]],"parameters":[]},null],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["attr","options","possibleValues"]]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n      "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n        "],[7,"select"],[12,"name",[28,[[23,["attr","name"]]]]],[12,"id",[28,[[23,["attr","name"]]]]],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[27,"get",[[23,["model"]],[23,["attr","name"]]],null]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[23,["attr","options","possibleValues"]]],null,{"statements":[[0,"            "],[7,"option"],[12,"selected",[27,"eq",[[27,"get",[[23,["model"]],[23,["attr","name"]]],null],[22,1,[]]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n              "],[1,[22,1,[]],false],[0,"\\n            "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["attr","options","editType"]],"ttl"],null]],null,{"statements":[[0,"    "],[1,[27,"ttl-picker",null,[["initialValue","labelText","setDefaultValue","onChange"],[[27,"or",[[27,"get",[[23,["model"]],[23,["attr","name"]]],null],[23,["attr","options","defaultValue"]]],null],[27,"if",[[23,["attr","options","label"]],[23,["attr","options","label"]],[27,"humanize",[[27,"dasherize",[[23,["attr","name"]]],null]],null]],null],false,[27,"action",[[22,0,[]],[27,"mut",[[27,"get",[[23,["model"]],[23,["attr","name"]]],null]],null]],null]]]],false],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"or",[[27,"eq",[[23,["attr","type"]],"number"],null],[27,"eq",[[23,["attr","type"]],"string"],null]],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[1,[27,"input",null,[["id","value","class"],[[23,["attr","name"]],[27,"get",[[23,["model"]],[27,"or",[[23,["attr","options","fieldValue"]],[23,["attr","name"]]],null]],null],"input"]]],false],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["attr","type"]],"boolean"],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","b-checkbox"],[9],[0,"\\n      "],[7,"input"],[12,"id",[28,[[23,["attr","name"]]]]],[11,"class","styled"],[12,"checked",[27,"get",[[23,["model"]],[23,["attr","name"]]],null]],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[27,"get",[[23,["model"]],[23,["attr","name"]]],null]],null]],[["value"],["target.checked"]]]],[11,"type","checkbox"],[9],[10],[0,"\\n\\n      "],[7,"label"],[12,"for",[28,[[23,["attr","name"]]]]],[11,"class","is-label"],[9],[0,"\\n        "],[1,[27,"capitalize",[[27,"or",[[23,["attr","options","label"]],[27,"humanize",[[27,"dasherize",[[23,["attr","name"]]],null]],null]],null]],null],false],[0,"\\n"],[4,"if",[[23,["attr","options","helpText"]]],null,{"statements":[[0,"          "],[4,"info-tooltip",null,null,{"statements":[[1,[23,["attr","options","helpText"]],false]],"parameters":[]},null],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["attr","type"]],"object"],null]],null,{"statements":[[0,"    "],[1,[27,"json-editor",null,[["value","valueUpdated"],[[27,"if",[[27,"get",[[23,["model"]],[23,["attr","name"]]],null],[27,"stringify",[[27,"get",[[23,["model"]],[23,["attr","name"]]],null]],null],[23,["emptyData"]]],null],[27,"action",[[22,0,[]],"codemirrorUpdated",[23,["attr","name"]]],null]]]],false],[0,"\\n  "]],"parameters":[]},null]],"parameters":[]}]],"parameters":[]}]],"parameters":[]}]],"parameters":[]}],[10]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/form-field-from-model.hbs"}})}),define("vault/templates/partials/form-field-groups-loop",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"wGLFcFsM",block:'{"symbols":["fieldGroup","fields","group","attr","attr"],"statements":[[4,"each",[[23,["model","fieldGroups"]]],null,{"statements":[[4,"each",[[27,"-each-in",[[22,1,[]]],null]],null,{"statements":[[4,"if",[[27,"eq",[[22,3,[]],"default"],null]],null,{"statements":[[4,"each",[[22,2,[]]],null,{"statements":[[4,"unless",[[27,"and",[[27,"not-eq",[[23,["mode"]],"create"],null],[27,"eq",[[22,5,["name"]],"name"],null]],null]],null,{"statements":[[0,"          "],[1,[27,"form-field",null,[["attr","model"],[[22,5,[]],[23,["model"]]]]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[5]},null]],"parameters":[]},{"statements":[[0,"      "],[1,[27,"toggle-button",null,[["class","toggleAttr","toggleTarget","openLabel","closedLabel"],["is-block",[27,"concat",["show",[27,"camelize",[[22,3,[]]],null]],null],[22,0,[]],[27,"concat",["Hide ",[22,3,[]]],null],[22,3,[]]]]],false],[0,"\\n"],[4,"if",[[27,"get",[[22,0,[]],[27,"concat",["show",[27,"camelize",[[22,3,[]]],null]],null]],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","box is-marginless"],[9],[0,"\\n"],[4,"each",[[22,2,[]]],null,{"statements":[[0,"            "],[1,[27,"form-field",null,[["attr","model"],[[22,4,[]],[23,["model"]]]]],false],[0,"\\n"]],"parameters":[4]},null],[0,"        "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}]],"parameters":[2,3]},null]],"parameters":[1]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/form-field-groups-loop.hbs"}})}),define("vault/templates/partials/role-aws/form",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"VfLJuaZJ",block:'{"symbols":["attr"],"statements":[[7,"form"],[12,"onsubmit",[27,"action",[[22,0,[]],"createOrUpdate","create"],null]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],[[21,"mode"],"AWS role"]]],[0,"\\n"],[4,"if",[[27,"gt",[[23,["model","credentialTypes","length"]],1],null]],null,{"statements":[[0,"      "],[5,"alert-banner",[],[["@type","@message"],["warning",[28,["This role has more than one credential_type, currently: ",[27,"join",[", ",[23,["model","credentialTypes"]]],null],".\\n          Multiple credential types is deprecated and you must choose one in order to save this role."]]]]],[0,"\\n"]],"parameters":[]},null],[4,"each",[[27,"if",[[27,"eq",[[23,["mode"]],"edit"],null],[27,"drop",[1,[23,["model","fields"]]],null],[23,["model","fields"]]],null]],null,{"statements":[[0,"      "],[1,[27,"form-field",null,[["attr","model"],[[22,1,[]],[23,["model"]]]]],false],[0,"\\n"]],"parameters":[1]},null],[0,"  "],[10],[0,"\\n\\n  "],[7,"div"],[11,"class","field is-grouped-split box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[12,"disabled",[21,"buttonDisabled"]],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"create"],null]],null,{"statements":[[0,"          Create role\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["mode"]],"edit"],null]],null,{"statements":[[0,"          Save\\n        "]],"parameters":[]},null]],"parameters":[]}],[0,"      "],[10],[0,"\\n"],[4,"secret-link",null,[["mode","class","secret"],[[27,"if",[[27,"eq",[[23,["mode"]],"create"],null],"list","show"],null],"button",[23,["model","id"]]]],{"statements":[[0,"        Cancel\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/role-aws/form.hbs"}})}),define("vault/templates/partials/role-aws/popup-menu",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"SEu+8ePI",block:'{"symbols":[],"statements":[[4,"popup-menu",null,[["name","contentClass"],["role-aws-nav","is-wide"]],{"statements":[[0,"  "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n    "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n"],[4,"if",[[23,["item","generatePath","isPending"]]],null,{"statements":[[0,"        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n            loading\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["item","canGenerate"]]],null,{"statements":[[0,"        "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.credentials",[23,["item","id"]]],null,{"statements":[[0,"            Generate credentials\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "]],"parameters":[]},null]],"parameters":[]}],[4,"if",[[23,["item","updatePath","isPending"]]],null,{"statements":[[0,"        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n            loading\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n            loading\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["item","canRead"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.show",[23,["item","id"]]],null,{"statements":[[0,"              Details\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["item","canEdit"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.edit",[23,["item","id"]]],null,{"statements":[[0,"              Edit\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["item","canDelete"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction"],["link is-destroy",[27,"action",[[22,0,[]],"delete",[23,["item"]]],null]]],{"statements":[[0,"\\n              Delete\\n            "]],"parameters":[]}],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/role-aws/popup-menu.hbs"}})}),define("vault/templates/partials/role-aws/show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"ETsmkAF7",block:'{"symbols":["attr"],"statements":[[7,"div"],[11,"class","box is-fullwidth is-sideless is-paddingless is-marginless"],[9],[0,"\\n"],[4,"if",[[27,"gt",[[23,["model","credentialTypes","length"]],1],null]],null,{"statements":[[0,"    "],[5,"alert-banner",[],[["@type","@message"],["warning",[28,["This role has more than one credential_type, currently: ",[27,"join",[", ",[23,["model","credentialTypes"]]],null],".\\n        When you next edit this role, you will have to choose a single credential type."]]]]],[0,"\\n"]],"parameters":[]},null],[4,"each",[[23,["model","fields"]]],null,{"statements":[[4,"if",[[27,"eq",[[22,1,["name"]],"policyDocument"],null]],null,{"statements":[[4,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,1,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,1,["name"]]],null]],null]],null]],null],[23,["model","policyDocument"]]]],{"statements":[[0,"        "],[7,"pre"],[9],[7,"code"],[11,"class","is-paddingless"],[9],[1,[27,"stringify",[[27,"jsonify",[[23,["model","policyDocument"]]],null]],null],false],[10],[10],[0,""]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"      "],[1,[27,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,1,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,1,["name"]]],null]],null]],null]],null],[27,"get",[[23,["model"]],[22,1,["name"]]],null]]]],false],[0,""]],"parameters":[]}]],"parameters":[1]},null],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/role-aws/show.hbs"}})}),define("vault/templates/partials/role-pki/form",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"sCAu7LOa",block:'{"symbols":[],"statements":[[7,"form"],[12,"onsubmit",[27,"action",[[22,0,[]],"createOrUpdate","create"],null]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],[[21,"mode"],"PKI role"]]],[0,"\\n    "],[15,"partials/form-field-groups-loop",[]],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped-split box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[12,"disabled",[21,"buttonDisabled"]],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"create"],null]],null,{"statements":[[0,"          Create role\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["mode"]],"edit"],null]],null,{"statements":[[0,"          Save\\n        "]],"parameters":[]},null]],"parameters":[]}],[0,"      "],[10],[0,"\\n"],[4,"secret-link",null,[["mode","class","secret"],[[27,"if",[[27,"eq",[[23,["mode"]],"create"],null],"list","show"],null],"button",[23,["model","id"]]]],{"statements":[[0,"        Cancel\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":true}',meta:{moduleName:"vault/templates/partials/role-pki/form.hbs"}})}),define("vault/templates/partials/role-pki/popup-menu",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"3MJVA/PI",block:'{"symbols":[],"statements":[[4,"popup-menu",null,[["name"],["role-aws-nav"]],{"statements":[[0,"  "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n"],[4,"if",[[27,"or",[[23,["item","generatePath","isPending"]],[23,["item","signPath","isPending"]]],null]],null,{"statements":[[0,"      "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n            loading\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"or",[[23,["item","canGenerate"]],[23,["item","canSign"]]],null]],null,{"statements":[[0,"      "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n"],[4,"if",[[23,["item","canGenerate"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.credentials",[23,["item","id"]],[27,"query-params",null,[["action"],["issue"]]]],null,{"statements":[[0,"              Generate certificate\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["item","canSign"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.credentials",[23,["item","id"]],[27,"query-params",null,[["action"],["sign"]]]],null,{"statements":[[0,"              Sign certificate\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "]],"parameters":[]},null]],"parameters":[]}],[0,"    "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n"],[4,"if",[[23,["item","updatePath","isPending"]]],null,{"statements":[[0,"        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n            loading\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n            loading\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["item","canRead"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.show",[23,["item","id"]]],null,{"statements":[[0,"              Details\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["item","canEdit"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.edit",[23,["item","id"]]],null,{"statements":[[0,"              Edit\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["item","canDelete"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction"],["link is-destroy",[27,"action",[[22,0,[]],"delete",[23,["item"]]],null]]],{"statements":[[0,"\\n              Delete\\n            "]],"parameters":[]}],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/role-pki/popup-menu.hbs"}})}),define("vault/templates/partials/role-pki/show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"EefA8S2N",block:'{"symbols":["fieldGroup","fields","group","attr","attr"],"statements":[[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n"],[4,"each",[[23,["model","fieldGroups"]]],null,{"statements":[[4,"each",[[27,"-each-in",[[22,1,[]]],null]],null,{"statements":[[4,"if",[[27,"or",[[27,"eq",[[22,3,[]],"default"],null],[27,"eq",[[22,3,[]],"Options"],null]],null]],null,{"statements":[[4,"each",[[22,2,[]]],null,{"statements":[[0,"          "],[1,[27,"info-table-row",null,[["alwaysRender","label","value"],[true,[27,"capitalize",[[27,"or",[[22,5,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,5,["name"]]],null]],null]],null]],null],[27,"get",[[23,["model"]],[22,5,["name"]]],null]]]],false],[0,"\\n"]],"parameters":[5]},null]],"parameters":[]},{"statements":[[0,"        "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n          "],[7,"h2"],[11,"class","title is-5"],[9],[0,"\\n            "],[1,[22,3,[]],false],[0,"\\n          "],[10],[0,"\\n"],[4,"each",[[22,2,[]]],null,{"statements":[[0,"            "],[1,[27,"info-table-row",null,[["alwaysRender","label","value"],[true,[27,"capitalize",[[27,"or",[[22,4,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,4,["name"]]],null]],null]],null]],null],[27,"get",[[23,["model"]],[22,4,["name"]]],null]]]],false],[0,"\\n"]],"parameters":[4]},null],[0,"        "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[2,3]},null]],"parameters":[1]},null],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/role-pki/show.hbs"}})}),define("vault/templates/partials/role-ssh/form",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"O569O8ma",block:'{"symbols":["numRequired","attr","attr"],"statements":[[7,"form"],[12,"onsubmit",[27,"action",[[22,0,[]],"createOrUpdate","create"],null]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],[[21,"mode"],"SSH role"]]],[0,"\\n"],[4,"if",[[23,["model","attrsForKeyType"]]],null,{"statements":[[4,"with",[[27,"if",[[27,"eq",[[23,["model","keyType"]],"otp"],null],3,4],null]],null,{"statements":[[4,"each",[[27,"take",[[22,1,[]],[23,["model","attrsForKeyType"]]],null]],null,{"statements":[[4,"unless",[[27,"and",[[27,"eq",[[23,["mode"]],"edit"],null],[27,"eq",[[22,3,["name"]],"name"],null]],null]],null,{"statements":[[0,"            "],[15,"partials/form-field-from-model",[1,3]],[0,"\\n"]],"parameters":[]},null]],"parameters":[3]},null],[0,"        "],[1,[27,"toggle-button",null,[["toggleAttr","toggleTarget","openLabel","closedLabel"],["showOptions",[22,0,[]],"Hide options","More options"]]],false],[0,"\\n"],[4,"if",[[23,["showOptions"]]],null,{"statements":[[0,"          "],[7,"div"],[11,"class","box is-marginless"],[9],[0,"\\n"],[4,"each",[[27,"drop",[[22,1,[]],[23,["model","attrsForKeyType"]]],null]],null,{"statements":[[0,"              "],[15,"partials/form-field-from-model",[1,2]],[0,"\\n"]],"parameters":[2]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null]],"parameters":[]},null],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped-split box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[12,"disabled",[21,"buttonDisabled"]],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["mode"]],"create"],null]],null,{"statements":[[0,"          Create role\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["mode"]],"edit"],null]],null,{"statements":[[0,"          Save\\n        "]],"parameters":[]},null]],"parameters":[]}],[0,"      "],[10],[0,"\\n"],[4,"secret-link",null,[["mode","class","secret"],[[27,"if",[[27,"eq",[[23,["mode"]],"create"],null],"list","show"],null],"button",[23,["model","id"]]]],{"statements":[[0,"        Cancel\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":true}',meta:{moduleName:"vault/templates/partials/role-ssh/form.hbs"}})}),define("vault/templates/partials/role-ssh/popup-menu",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"blqFcjVL",block:'{"symbols":[],"statements":[[4,"popup-menu",null,[["name"],["role-ssh-nav"]],{"statements":[[0,"  "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n    "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["item","keyType"]],"otp"],null]],null,{"statements":[[4,"if",[[23,["item","generatePath","isPending"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n              loading\\n            "],[10],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["item","canGenerate"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.credentials",[23,["item","id"]]],null,{"statements":[[0,"              Generate Credentials\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n        "]],"parameters":[]},null]],"parameters":[]}]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["item","keyType"]],"ca"],null]],null,{"statements":[[4,"if",[[23,["item","signPath","isPending"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n              loading\\n            "],[10],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["item","canGenerate"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.sign",[23,["item","id"]]],null,{"statements":[[0,"              Sign Keys\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n        "]],"parameters":[]},null]],"parameters":[]}],[0,"      "]],"parameters":[]},null]],"parameters":[]}],[4,"if",[[23,["item","canEditZeroAddress"]]],null,{"statements":[[4,"if",[[23,["item","zeroAddress"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[7,"button"],[12,"disabled",[27,"get",[[22,0,[]],[27,"concat",["loading-",[23,["item","id"]]],null]],null]],[12,"class",[28,["link button is-transparent\\n              ",[27,"if",[[27,"get",[[22,0,[]],[27,"concat",["loading-",[23,["item","id"]]],null]],null],"is-loading"],null]," "]]],[11,"type","button"],[3,"action",[[22,0,[]],"toggleZeroAddress",[23,["item"]],[23,["backendModel"]]]],[9],[0,"\\n              Disable Zero Address\\n            "],[10],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[7,"button"],[12,"disabled",[27,"get",[[22,0,[]],[27,"concat",["loading-",[23,["item","id"]]],null]],null]],[12,"class",[28,["link button is-transparent ",[27,"if",[[27,"get",[[22,0,[]],[27,"concat",["loading-",[23,["item","id"]]],null]],null],"is-loading"],null]]]],[11,"type","button"],[3,"action",[[22,0,[]],"toggleZeroAddress",[23,["item"]],[23,["backendModel"]]]],[9],[0,"\\n              Enable Zero Address\\n            "],[10],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]},null],[4,"if",[[23,["item","updatePath","isPending"]]],null,{"statements":[[0,"        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n            loading\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"li"],[11,"class","action"],[9],[0,"\\n          "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n            loading\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["item","canRead"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.show",[23,["item","id"]]],null,{"statements":[[0,"              Details\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["item","canEdit"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets.backend.edit",[23,["item","id"]]],null,{"statements":[[0,"              Edit\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["item","canDelete"]]],null,{"statements":[[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction"],["link is-destroy",[27,"action",[[22,0,[]],"delete",[23,["item"]]],null]]],{"statements":[[0,"\\n              Delete\\n            "]],"parameters":[]}],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/role-ssh/popup-menu.hbs"}})}),define("vault/templates/partials/role-ssh/show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"zERfZzmK",block:'{"symbols":["attr"],"statements":[[7,"div"],[11,"class","box is-fullwidth is-sideless is-paddingless is-marginless"],[9],[0,"\\n"],[4,"each",[[23,["model","attrsForKeyType"]]],null,{"statements":[[4,"if",[[27,"eq",[[22,1,["type"]],"object"],null]],null,{"statements":[[0,"      "],[1,[27,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,1,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,1,["name"]]],null]],null]],null]],null],[27,"stringify",[[27,"get",[[23,["model"]],[22,1,["name"]]],null]],null]]]],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[1,[27,"info-table-row",null,[["label","value"],[[27,"capitalize",[[27,"or",[[22,1,["options","label"]],[27,"humanize",[[27,"dasherize",[[22,1,["name"]]],null]],null]],null]],null],[27,"get",[[23,["model"]],[22,1,["name"]]],null]]]],false],[0,"\\n"]],"parameters":[]}]],"parameters":[1]},null],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/role-ssh/show.hbs"}})}),define("vault/templates/partials/secret-backend-settings/aws",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"kVQNXLfy",block:'{"symbols":["val"],"statements":[[7,"div"],[11,"class","tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[9],[0,"\\n  "],[7,"nav"],[11,"class","tabs"],[9],[0,"\\n    "],[7,"ul"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.settings.configure-secret-backend",[23,["model","id"]],[27,"query-params",null,[["tab"],[""]]]],[["tagName"],["li"]],{"statements":[[4,"link-to",["vault.cluster.settings.configure-secret-backend",[23,["model","id"]],[27,"query-params",null,[["tab"],[""]]]],null,{"statements":[[0,"          Dynamic IAM root credentials\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"\\n"],[4,"link-to",["vault.cluster.settings.configure-secret-backend",[23,["model","id"]],[27,"query-params",null,[["tab"],["leases"]]]],[["tagName"],["li"]],{"statements":[[4,"link-to",["vault.cluster.settings.configure-secret-backend",[23,["model","id"]],[27,"query-params",null,[["tab"],["leases"]]]],null,{"statements":[[0,"          Leases\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n\\n"],[4,"if",[[27,"eq",[[23,["tab"]],"leases"],null]],null,{"statements":[[0,"  "],[7,"form"],[3,"action",[[22,0,[]],"save","saveAWSLease",[27,"hash",null,[["lease","lease_max"],[[23,["model","lease"]],[23,["model","leaseMax"]]]]]],[["on"],["submit"]]],[9],[0,"\\n    "],[7,"div"],[11,"class","box is-fullwidth is-shadowless is-marginless"],[9],[0,"\\n      "],[5,"namespace-reminder",[],[["@mode","@noun"],["saved","configuration"]]],[0,"\\n      "],[1,[27,"message-error",null,[["model"],[[23,["model"]]]]],false],[0,"\\n      "],[7,"p"],[11,"class","has-text-grey-dark"],[9],[0,"\\n        If you do not supply lease settings, we will use the default values in AWS.\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[1,[27,"ttl-picker",null,[["labelText","initialValue","onChange"],["Lease",[23,["model","lease"]],[27,"action",[[22,0,[]],[27,"mut",[[23,["model","lease"]]],null]],null]]]],false],[0,"\\n    "],[1,[27,"ttl-picker",null,[["labelText","initialValue","onChange"],["Maximum Lease",[23,["model","leaseMax"]],[27,"action",[[22,0,[]],[27,"mut",[[23,["model","leaseMax"]]],null]],null]]]],false],[0,"\\n    "],[7,"div"],[11,"class","box is-bottomless is-fullwidth"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n        Save\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"form"],[3,"action",[[22,0,[]],"save","saveAWSRoot",[27,"hash",null,[["access_key","iam_endpoint","sts_endpoint","secret_key","region"],[[23,["accessKey"]],[23,["iamEndpoint"]],[23,["stsEndpoint"]],[23,["secretKey"]],[23,["region"]]]]]],[["on"],["submit"]]],[9],[0,"\\n    "],[7,"div"],[11,"class","box is-fullwidth is-shadowless is-marginless"],[9],[0,"\\n      "],[5,"namespace-reminder",[],[["@mode","@noun"],["save","configuration"]]],[0,"\\n      "],[7,"p"],[11,"class","has-text-grey-dark"],[9],[0,"\\n      Note: the client uses the official AWS SDK and will use the specified credentials, environment credentials, shared file credentials, or IAM role/ECS task credentials in that order.\\n      "],[10],[0,"\\n    "],[10],[0,"\\n\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","access"],[11,"class","is-label"],[9],[0,"\\n        Access key\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"input",null,[["type","id","name","class","autocomplete","spellcheck","value"],["text","access","access","input","off","false",[23,["accessKey"]]]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","secret"],[11,"class","is-label"],[9],[0,"\\n        Secret key\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"input",null,[["type","id","name","class","value"],["password","secret","secret","input",[23,["secretKey"]]]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n\\n    "],[1,[27,"toggle-button",null,[["toggleAttr","toggleTarget","openLabel","closedLabel"],["showOptions",[22,0,[]],"Hide options","More options"]]],false],[0,"\\n"],[4,"if",[[23,["showOptions"]]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","box is-marginless"],[9],[0,"\\n        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","region"],[11,"class","is-label"],[9],[0,"\\n            Region\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n            "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n              "],[7,"select"],[11,"name","region"],[11,"id","region"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["region"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n                "],[7,"option"],[11,"value",""],[9],[10],[0,"\\n"],[4,"each",[[27,"aws-regions",null,null]],null,{"statements":[[0,"                  "],[7,"option"],[9],[1,[22,1,[]],false],[10],[0,"\\n"]],"parameters":[1]},null],[0,"              "],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","iam"],[11,"class","is-label"],[9],[0,"\\n            IAM endpoint\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"input",null,[["type","id","name","class","value"],["text","iam","iam","input",[23,["iamEndpoint"]]]]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","sts"],[11,"class","is-label"],[9],[0,"\\n            STS endpoint\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"input",null,[["type","id","name","class","value"],["text","sts","sts","input",[23,["stsEndpoint"]]]]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"\\n    "],[7,"div"],[11,"class","box  is-bottomless is-fullwidth"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n        Save\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/secret-backend-settings/aws.hbs"}})}),define("vault/templates/partials/secret-backend-settings/pki",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"LKouSz78",block:'{"symbols":["section"],"statements":[[7,"div"],[11,"class","tabs-container box is-bottomless is-fullwidth is-paddingless"],[9],[0,"\\n  "],[7,"nav"],[11,"class","tabs"],[9],[0,"\\n    "],[7,"ul"],[9],[0,"\\n"],[4,"each",[[27,"array",["cert","urls","crl","tidy"],null]],null,{"statements":[[4,"link-to",["vault.cluster.settings.configure-secret-backend.section",[22,1,[]]],[["tagName","activeClass"],["li","is-active"]],{"statements":[[4,"link-to",["vault.cluster.settings.configure-secret-backend.section",[22,1,[]]],null,{"statements":[[4,"if",[[27,"eq",[[22,1,[]],"cert"],null]],null,{"statements":[[0,"              CA certificate\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[22,1,[]],"urls"],null]],null,{"statements":[[0,"              URLs\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[22,1,[]],"crl"],null]],null,{"statements":[[0,"              CRL\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[22,1,[]],"tidy"],null]],null,{"statements":[[0,"              Tidy\\n            "]],"parameters":[]},null]],"parameters":[]}]],"parameters":[]}]],"parameters":[]}]],"parameters":[]},null]],"parameters":[]},null]],"parameters":[1]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/secret-backend-settings/pki.hbs"}})}),define("vault/templates/partials/secret-backend-settings/ssh",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"hSRUqfTV",block:'{"symbols":[],"statements":[[4,"if",[[23,["configured"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-fullwidth is-sideless is-marginless"],[9],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","publicKey"],[11,"class","is-label"],[9],[0,"\\n        Public key\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"textarea",null,[["name","id","class","value","readonly"],["publicKey","publicKey","textarea",[23,["model","publicKey"]],true]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped-split box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardTarget","class","buttonType","success"],["#publicKey","button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Public Key copied!"],null]],null]]],{"statements":[[0,"        Copy\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[5,"confirm-action",[],[["@buttonClasses","@confirmMessage","@onConfirmAction"],["button","This will remove the CA certificate information.",[27,"action",[[22,0,[]],"saveConfig",[27,"hash",null,[["delete"],[true]]]],null]]],{"statements":[[0,"\\n        Delete\\n      "]],"parameters":[]}],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"form"],[3,"action",[[22,0,[]],"saveConfig"],[["on"],["submit"]]],[9],[0,"\\n    "],[7,"div"],[11,"class","box is-fullwidth is-sideless is-marginless"],[9],[0,"\\n      "],[5,"namespace-reminder",[],[["@mode","@noun"],["save","configuration"]]],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","privateKey"],[11,"class","is-label"],[9],[0,"\\n          Private key\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[1,[27,"textarea",null,[["name","id","class","value"],["privateKey","privateKey","input",[23,["model","privateKey"]]]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"label"],[11,"for","publicKey"],[11,"class","is-label"],[9],[0,"\\n          Public key\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[1,[27,"textarea",null,[["name","id","class","value"],["publicKey","publicKey","input",[23,["model","publicKey"]]]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","b-checkbox"],[9],[0,"\\n        "],[7,"input"],[11,"id","generateSigningKey"],[11,"class","styled"],[12,"checked",[23,["model","generateSigningKey"]]],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["model","generateSigningKey"]]],null]],[["value"],["target.checked"]]]],[11,"type","checkbox"],[9],[10],[0,"\\n        "],[7,"label"],[11,"for","generateSigningKey"],[11,"class","is-label"],[9],[0,"\\n          Generate signing key\\n"],[4,"info-tooltip",null,null,{"statements":[[0,"            Specifies if Vault should generate the signing key pair internally\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field box is-fullwidth is-bottomless is-marginless"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[12,"class",[28,["button is-primary ",[27,"if",[[23,["loading"]],"is-loading"],null]]]],[12,"disabled",[21,"loading"]],[11,"type","submit"],[9],[0,"\\n          Save\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/secret-backend-settings/ssh.hbs"}})}),define("vault/templates/partials/secret-form-create",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"OrYirxPp",block:'{"symbols":[],"statements":[[7,"form"],[12,"class",[28,[[27,"if",[[23,["showAdvancedMode"]],"advanced-edit","simple-edit"],null]]]],[12,"onsubmit",[27,"action",[[22,0,[]],"createOrUpdateKey","create"],null]],[9],[0,"\\n  "],[7,"div"],[11,"class","field box is-fullwidth is-sideless is-marginless"],[9],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["create","secret"]]],[0,"\\n    "],[5,"message-error",[],[["@model","@errorMessage"],[[21,"model"],[21,"error"]]]],[0,"\\n    "],[7,"label"],[11,"class","is-label"],[11,"for","kv-key"],[9],[0,"Path for this secret"],[10],[0,"\\n    "],[7,"p"],[11,"class","control is-expanded"],[9],[0,"\\n      "],[1,[27,"input",null,[["autocomplete","spellcheck","id","class","value"],["off","false","kv-key","input",[27,"get",[[23,["modelForData"]],[23,["modelForData","pathAttr"]]],null]]]],false],[0,"\\n    "],[10],[0,"\\n"],[4,"if",[[23,["modelForData","isFolder"]]],null,{"statements":[[0,"      "],[7,"p"],[11,"class","help is-danger"],[9],[0,"\\n      The secret path may not end in "],[7,"code"],[9],[0,"/"],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[10],[0,"\\n  "],[5,"secret-edit-display",[],[["@showAdvancedMode","@codemirrorString","@secretData","@isV2","@model","@canEditV2Secret","@editActions"],[[21,"showAdvancedMode"],[21,"codemirrorString"],[21,"secretData"],[21,"isV2"],[21,"model"],[21,"canEditV2Secret"],[27,"hash",null,[["codemirrorUpdated","formatJSON","handleKeyDown","handleChange","deleteRow","addRow"],[[27,"action",[[22,0,[]],"codemirrorUpdated"],null],[27,"action",[[22,0,[]],"formatJSON"],null],[27,"action",[[22,0,[]],"handleKeyDown"],null],[27,"action",[[22,0,[]],"handleChange"],null],[27,"action",[[22,0,[]],"deleteRow"],null],[27,"action",[[22,0,[]],"addRow"],null]]]]]]],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[12,"disabled",[21,"buttonDisabled"]],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n         Save\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"secret-link",null,[["mode","secret","class"],["list",[23,["model","parentKey"]],"button"]],{"statements":[[0,"        Cancel\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/secret-form-create.hbs"}})}),define("vault/templates/partials/secret-form-edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"/khLUouW",block:'{"symbols":[],"statements":[[7,"form"],[12,"onsubmit",[27,"action",[[22,0,[]],"createOrUpdateKey","update"],null]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless is-paddingless"],[9],[0,"\\n    "],[5,"message-error",[],[["@model","@errorMessage"],[[21,"model"],[21,"error"]]]],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["edit","secret"]]],[0,"\\n"],[4,"if",[[27,"and",[[27,"not",[[23,["model","failedServerRead"]]],null],[27,"not",[[23,["model","selectedVersion","failedServerRead"]]],null],[27,"not-eq",[[23,["model","selectedVersion","version"]],[23,["model","currentVersion"]]],null]],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","form-section"],[9],[0,"\\n        "],[5,"alert-banner",[],[["@type","@class","@message"],["warning","is-marginless",[28,["You are creating a new version based on data from Version ",[23,["model","selectedVersion","version"]],". The current version for ",[23,["model","id"]]," is Version ",[23,["model","currentVersion"]],"."]]]]],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[5,"secret-edit-display",[],[["@showAdvancedMode","@codemirrorString","@secretData","@isV2","@canEditV2Secret","@showWriteWithoutReadWarning","@model","@editActions"],[[21,"showAdvancedMode"],[21,"codemirrorString"],[21,"secretData"],[21,"isV2"],[21,"canEditV2Secret"],[21,"isWriteWithoutRead"],[21,"model"],[27,"hash",null,[["codemirrorUpdated","formatJSON","handleKeyDown","handleChange","deleteRow","addRow"],[[27,"action",[[22,0,[]],"codemirrorUpdated"],null],[27,"action",[[22,0,[]],"formatJSON"],null],[27,"action",[[22,0,[]],"handleKeyDown"],null],[27,"action",[[22,0,[]],"handleChange"],null],[27,"action",[[22,0,[]],"deleteRow"],null],[27,"action",[[22,0,[]],"addRow"],null]]]]]]],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped is-grouped-split is-fullwidth box is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped"],[9],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"button"],[12,"disabled",[21,"buttonDisabled"]],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n          Save\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"secret-link",null,[["mode","secret","class","queryParams"],["show",[23,["model","id"]],"button",[27,"query-params",null,[["version"],[[22,0,["modelForData","version"]]]]]]],{"statements":[[0,"          Cancel\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/secret-form-edit.hbs"}})}),define("vault/templates/partials/secret-form-show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"/qIDKopl",block:'{"symbols":["value","key"],"statements":[[4,"if",[[27,"and",[[23,["isV2"]],[23,["modelForData","destroyed"]]],null]],null,{"statements":[[0,"  "],[5,"empty-state",[],[["@title","@message"],[[28,["Version ",[23,["modelForData","version"]]," of this secret has been permanently destroyed"]],"A version that has been permanently deleted cannot be restored. You can see other versions of this secret in the History menu."]],{"statements":[[0,"\\n    "],[5,"doc-link",[],[["@path"],["/docs/secrets/kv/kv-v2.html"]],{"statements":[[0,"\\n      Learn more\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"and",[[23,["isV2"]],[23,["modelForData","deleted"]]],null]],null,{"statements":[[0,"  "],[5,"empty-state",[],[["@title","@message"],[[28,["Version ",[23,["modelForData","version"]]," of this secret has been deleted"]],[28,["A version that has been deleted but can be undeleted using the Version ",[23,["modelForData","version"]]," menu above.\\n      You can also see other versions of this secret in the History menu."]]]],{"statements":[[0,"\\n    "],[5,"doc-link",[],[["@path"],["/docs/secrets/kv/kv-v2.html"]],{"statements":[[0,"\\n      Learn more\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["isWriteWithoutRead"]]],null,{"statements":[[0,"  "],[5,"empty-state",[],[["@title","@message"],["You do not have permission to read this secret.",[27,"if",[[23,["isV2"]],"Your policies permit you to write a new version of this secret, but do not allow you to read its current contents.","Your policies permit you to overwrite this secret, but do not allow you to read it."],null]]],{"statements":[[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["showAdvancedMode"]]],null,{"statements":[[0,"    "],[1,[27,"json-editor",null,[["value","options"],[[23,["modelForData","dataAsJSONString"]],[27,"hash",null,[["readOnly"],[true]]]]]],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","table info-table-row-header"],[9],[0,"\\n      "],[7,"div"],[11,"class","info-table-row thead"],[9],[0,"\\n        "],[7,"div"],[11,"class","th column is-one-quarter"],[9],[0,"\\n          Key\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","th column"],[9],[0,"\\n          Value\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"],[4,"each",[[27,"-each-in",[[23,["modelForData","secretData"]]],null]],null,{"statements":[[4,"info-table-row",null,[["label","value","alwaysRender"],[[22,2,[]],[22,1,[]],true]],{"statements":[[0,"        "],[1,[27,"masked-input",null,[["value","displayOnly","allowCopy"],[[22,1,[]],true,true]]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[1,2]},null]],"parameters":[]}]],"parameters":[]}]],"parameters":[]}]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/secret-form-show.hbs"}})}),define("vault/templates/partials/secret-list/aws-role-item",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"RnulDuWE",block:'{"symbols":[],"statements":[[4,"linked-block",[[27,"concat",["vault.cluster.secrets.backend.","credentials",[27,"if",[[27,"not",[[23,["item","id"]]],null],"-root"],null]],null],[23,["item","id"]]],[["class","encode"],["list-item-row",true]],{"statements":[[0,"  "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n    "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n"],[4,"link-to",[[27,"concat",["vault.cluster.secrets.backend.","credentials",[27,"if",[[27,"not",[[23,["item","id"]]],null],"-root"],null]],null],[23,["item","id"]]],[["class"],["has-text-black has-text-weight-semibold"]],{"statements":[[0,"        "],[5,"icon",[[11,"class","has-text-grey-light is-pulled-left"]],[["@glyph"],["user-square-outline"]]],[0,"\\n        "],[7,"div"],[11,"class","role-item-details"],[9],[0,"\\n          "],[7,"span"],[11,"class","is-underline"],[9],[1,[27,"if",[[27,"eq",[[23,["item","id"]]," "],null],"(self)",[27,"or",[[23,["item","keyWithoutParent"]],[23,["item","id"]]],null]],null],false],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n      "],[15,"partials/role-aws/popup-menu",[]],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":true}',meta:{moduleName:"vault/templates/partials/secret-list/aws-role-item.hbs"}})}),define("vault/templates/partials/secret-list/item",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"TnTl06KU",block:'{"symbols":[],"statements":[[4,"linked-block",[[27,"concat",["vault.cluster.secrets.backend.",[27,"if",[[23,["item","isFolder"]],"list","show"],null],[27,"if",[[27,"not",[[23,["item","id"]]],null],"-root"],null]],null],[23,["item","id"]]],[["class","encode"],["list-item-row",true]],{"statements":[[0,"  "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n    "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n      "],[5,"secret-link",[],[["@mode","@secret","@class"],[[27,"if",[[23,["item","isFolder"]],"list","show"],null],[23,["item","id"]],"has-text-black has-text-weight-semibold"]],{"statements":[[5,"icon",[],[["@glyph","@class"],[[27,"if",[[23,["item","isFolder"]],"folder-outline","file-outline"],null],"has-text-grey-light"]]],[1,[27,"if",[[27,"eq",[[23,["item","id"]]," "],null],"(self)",[27,"or",[[23,["item","keyWithoutParent"]],[23,["item","id"]]],null]],null],false],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n      "],[5,"popup-menu",[[11,"name","secret-menu"]],[[],[]],{"statements":[[0,"\\n        "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n          "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n"],[4,"if",[[23,["item","isFolder"]]],null,{"statements":[[0,"              "],[5,"secret-link",[],[["@mode","@secret","@class"],["list",[23,["item","id"]],"has-text-black has-text-weight-semibold"]],{"statements":[[0,"\\n                Contents\\n              "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"or",[[23,["item","versionPath","isLoading"]],[23,["item","secretPath","isLoading"]]],null]],null,{"statements":[[0,"                "],[7,"li"],[11,"class","action"],[9],[0,"\\n                  "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n                    loading\\n                  "],[10],[0,"\\n                "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[23,["item","canRead"]]],null,{"statements":[[0,"                  "],[7,"li"],[11,"class","action"],[9],[0,"\\n                    "],[5,"secret-link",[],[["@mode","@secret","@class"],["show",[23,["item","id"]],"has-text-black has-text-weight-semibold"]],{"statements":[[0,"\\n                      Details\\n                    "]],"parameters":[]}],[0,"\\n                  "],[10],[0,"\\n"],[4,"if",[[23,["backendModel","isV2KV"]]],null,{"statements":[[0,"                    "],[7,"li"],[11,"class","action"],[9],[0,"\\n                      "],[5,"secret-link",[],[["@mode","@secret","@class"],["versions",[23,["item","id"]],"has-text-black has-text-weight-semibold"]],{"statements":[[0,"\\n                        View version history\\n                      "]],"parameters":[]}],[0,"\\n                    "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[4,"if",[[23,["item","canEdit"]]],null,{"statements":[[0,"                  "],[7,"li"],[11,"class","action"],[9],[0,"\\n                    "],[5,"secret-link",[],[["@mode","@secret","@class"],["edit",[23,["item","id"]],"has-text-black has-text-weight-semibold"]],{"statements":[[0,"\\n                      "],[1,[27,"if",[[23,["backendModel","isV2KV"]],"Create new version","Edit"],null],false],[0,"\\n                    "]],"parameters":[]}],[0,"\\n                  "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["item","canDelete"]]],null,{"statements":[[0,"                  "],[7,"li"],[11,"class","action"],[9],[0,"\\n                    "],[5,"confirm-action",[],[["@buttonClasses","@confirmMessage","@onConfirmAction"],["link is-destroy","This will permanently delete this secret and all its versions.",[27,"action",[[22,0,[]],"delete",[23,["item"]],"secret"],null]]],{"statements":[[0,"\\n                      "],[1,[27,"if",[[23,["backendModel","isV2KV"]],"Permanently delete","Delete"],null],false],[0,"\\n                    "]],"parameters":[]}],[0,"\\n                  "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}]],"parameters":[]}],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/secret-list/item.hbs"}})})
define("vault/templates/partials/secret-list/pki-cert-item",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"ckVz0oaD",block:'{"symbols":[],"statements":[[4,"linked-block",[[27,"concat",["vault.cluster.secrets.backend.","show",[27,"if",[[27,"not",[[23,["item","id"]]],null],"-root"],null]],null],[23,["item","idForNav"]]],[["class","tagName","encode"],["list-item-row","div",true]],{"statements":[[0,"  "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n    "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n"],[4,"link-to",[[27,"concat",["vault.cluster.secrets.backend.","show",[27,"if",[[27,"not",[[23,["item","id"]]],null],"-root"],null]],null],[23,["item","idForNav"]]],[["class"],["has-text-black has-text-weight-semibold"]],{"statements":[[0,"      "],[5,"icon",[[11,"class","has-text-grey-light is-pulled-left"]],[["@glyph"],["file-outline"]]],[0,"\\n      "],[7,"div"],[11,"class","role-item-details"],[9],[0,"\\n        "],[7,"span"],[11,"class","is-underline"],[9],[1,[27,"if",[[27,"eq",[[23,["item","id"]]," "],null],"(self)",[27,"or",[[23,["item","keyWithoutParent"]],[23,["item","id"]]],null]],null],false],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n      "],[1,[27,"pki-cert-popup",null,[["item"],[[23,["item"]]]]],false],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/secret-list/pki-cert-item.hbs"}})}),define("vault/templates/partials/secret-list/pki-role-item",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"IKx7mapr",block:'{"symbols":[],"statements":[[4,"linked-block",[[27,"concat",["vault.cluster.secrets.backend.","credentials",[27,"if",[[27,"not",[[23,["item","id"]]],null],"-root"],null]],null],[23,["item","backend"]],[23,["item","id"]]],[["queryParams","class","tagName","encode"],[[27,"hash",null,[["action"],["issue"]]],"list-item-row","div",true]],{"statements":[[0,"  "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n    "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n"],[4,"link-to",[[27,"concat",["vault.cluster.secrets.backend.","credentials",[27,"if",[[27,"not",[[23,["item","id"]]],null],"-root"],null]],null],[23,["item","id"]],[27,"query-params",null,[["action"],["issue"]]]],[["class"],["has-text-black has-text-weight-semibold"]],{"statements":[[0,"      "],[5,"icon",[[11,"class","has-text-grey-light is-pulled-left"]],[["@glyph"],["user-square-outline"]]],[0,"\\n      "],[7,"div"],[11,"class","role-item-details"],[9],[0,"\\n        "],[7,"span"],[11,"class","is-underline"],[9],[1,[27,"if",[[27,"eq",[[23,["item","id"]]," "],null],"(self)",[27,"or",[[23,["item","keyWithoutParent"]],[23,["item","id"]]],null]],null],false],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n      "],[15,"partials/role-pki/popup-menu",[]],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":true}',meta:{moduleName:"vault/templates/partials/secret-list/pki-role-item.hbs"}})}),define("vault/templates/partials/secret-list/ssh-role-item",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Yyhim/vE",block:'{"symbols":[],"statements":[[4,"linked-block",[[27,"concat",["vault.cluster.secrets.backend.",[27,"if",[[27,"eq",[[23,["item","keyType"]],"ca"],null],"sign","credentials"],null],[27,"if",[[27,"not",[[23,["item","id"]]],null],"-root"],null]],null],[23,["item","id"]]],[["class","encode"],["list-item-row",true]],{"statements":[[0,"  "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n    "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n"],[4,"link-to",[[27,"concat",["vault.cluster.secrets.backend.",[27,"if",[[27,"eq",[[23,["item","keyType"]],"ca"],null],"sign","credentials"],null],[27,"if",[[27,"not",[[23,["item","id"]]],null],"-root"],null]],null],[23,["item","id"]]],[["class"],["has-text-black has-text-weight-semibold"]],{"statements":[[0,"        "],[5,"icon",[[11,"class","has-text-grey-light is-pulled-left"]],[["@glyph"],["user-square-outline"]]],[0,"\\n        "],[7,"div"],[11,"class","role-item-details"],[9],[0,"\\n          "],[7,"span"],[11,"class","is-underline"],[9],[1,[27,"if",[[27,"eq",[[23,["item","id"]]," "],null],"(self)",[27,"or",[[23,["item","keyWithoutParent"]],[23,["item","id"]]],null]],null],false],[10],[0,"\\n          "],[7,"br"],[9],[10],[0,"\\n          "],[7,"span"],[11,"class","tag has-text-grey-dark"],[9],[1,[23,["item","keyType"]],false],[10],[0,"\\n"],[4,"if",[[23,["item","zeroAddress"]]],null,{"statements":[[0,"            "],[7,"span"],[11,"class","has-text-grey is-size-7"],[9],[0,"Zero-Address"],[10],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["backendType"]],"ssh"],null]],null,{"statements":[[0,"        "],[15,"partials/role-ssh/popup-menu",[]],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":true}',meta:{moduleName:"vault/templates/partials/secret-list/ssh-role-item.hbs"}})}),define("vault/templates/partials/status/cluster",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"8CuZi7ME",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","popup-menu-content"],[9],[0,"\\n  "],[7,"div"],[11,"class","box"],[9],[0,"\\n"],[4,"unless",[[23,["version","isOSS"]]],null,{"statements":[[4,"if",[[27,"and",[[23,["activeCluster","unsealed"]],[23,["auth","currentToken"]]],null]],null,{"statements":[[4,"if",[[27,"has-permission",["status"],[["routeParams"],["replication"]]]],null,{"statements":[[0,"          "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n            "],[7,"p"],[11,"class","menu-label"],[9],[0,"Replication"],[10],[0,"\\n            "],[7,"ul"],[9],[0,"\\n"],[4,"if",[[23,["cluster","anyReplicationEnabled"]]],null,{"statements":[[0,"                "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.replication.mode.index","dr"],[["disabled","invokeAction"],[[27,"not",[[23,["currentToken"]]],null],[27,"action",[[22,0,[]],[23,["onLinkClick"]]],null]]],{"statements":[[0,"                    "],[1,[27,"replication-mode-summary",null,[["mode","display","cluster"],["dr","menu",[23,["cluster"]]]]],false],[0,"\\n"]],"parameters":[]},null],[0,"                "],[10],[0,"\\n                "],[7,"li"],[9],[0,"\\n"],[4,"if",[[27,"has-feature",["Performance Replication"],null]],null,{"statements":[[4,"link-to",["vault.cluster.replication.mode.index","performance"],[["disabled","invokeAction"],[[27,"not",[[23,["currentToken"]]],null],[27,"action",[[22,0,[]],[23,["onLinkClick"]]],null]]],{"statements":[[0,"                      "],[1,[27,"replication-mode-summary",null,[["mode","display","cluster","tagName"],["performance","menu",[23,["cluster"]],"span"]]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"                    "],[1,[27,"replication-mode-summary",null,[["mode","display","cluster","class"],["performance","menu",[23,["cluster"]],"menu-item"]]],false],[0,"\\n"]],"parameters":[]}],[0,"                "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"                "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.replication"],[["invokeAction"],[[27,"action",[[22,0,[]],[23,["onLinkClick"]]],null]]],{"statements":[[0,"                    "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n                      "],[7,"span"],[11,"class","level-left"],[9],[0,"Enable"],[10],[0,"\\n                      "],[5,"icon",[],[["@glyph","@class"],["plus-circle-outline","has-text-grey-light level-right"]]],[0,"\\n                    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"                "],[10],[0,"\\n"]],"parameters":[]}],[0,"            "],[10],[0,"\\n          "],[10],[0,"\\n          "],[7,"hr"],[9],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[4,"if",[[27,"has-permission",["status"],[["routeParams"],["license"]]]],null,{"statements":[[0,"        "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n          "],[7,"div"],[11,"class","menu-label"],[9],[0,"\\n            License\\n          "],[10],[0,"\\n          "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n            "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.license",[23,["activeCluster","name"]]],[["invokeAction"],[[23,["onLinkClick"]]]],{"statements":[[0,"                "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n                  "],[7,"span"],[11,"class","level-left"],[9],[0,"See details"],[10],[0,"\\n                  "],[5,"chevron",[[11,"class","has-text-grey-light level-right"]],[[],[]]],[0,"\\n                "],[10],[0,"\\n"]],"parameters":[]},null],[0,"            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"hr"],[9],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"      "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n        "],[7,"div"],[11,"class","menu-label"],[9],[0,"\\n          Seal status\\n        "],[10],[0,"\\n        "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n          "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"if",[[23,["activeCluster","unsealed"]]],null,{"statements":[[4,"if",[[27,"has-permission",["status"],[["routeParams"],["seal"]]]],null,{"statements":[[4,"link-to",["vault.cluster.settings.seal",[23,["cluster","name"]]],[["invokeAction"],[[27,"action",[[22,0,[]],[27,"queue",[[27,"action",[[22,0,[]],[23,["onLinkClick"]]],null],[27,"action",[[22,0,[]],[23,["d","actions","close"]]],null]],null]],null]]],{"statements":[[0,"                  "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n                    "],[7,"span"],[11,"class","level-left"],[9],[0,"Unsealed"],[10],[0,"\\n                    "],[5,"icon",[[11,"class","has-text-success level-right"]],[["@glyph"],["check-circle-outline"]]],[0,"\\n                  "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"                "],[7,"span"],[11,"class","menu-item"],[9],[0,"\\n                  "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n                    "],[7,"span"],[11,"class","level-left"],[9],[0,"Unsealed"],[10],[0,"\\n                    "],[5,"icon",[[11,"class","has-text-success level-right"]],[["@glyph"],["check-circle-outline"]]],[0,"\\n                  "],[10],[0,"\\n                "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[]},{"statements":[[0,"              "],[7,"span"],[11,"class","menu-item"],[9],[0,"\\n                "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n                  "],[7,"span"],[11,"class","level-left has-text-danger"],[9],[0,"Sealed"],[10],[0,"\\n                  "],[5,"icon",[[11,"class","has-text-danger level-right"]],[["@glyph"],["cancel-circle-outline"]]],[0,"\\n                "],[10],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[]}],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[27,"has-permission",["metrics"],[["routeParams"],["requests"]]]],null,{"statements":[[0,"        "],[7,"hr"],[9],[10],[0,"\\n        "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n          "],[7,"div"],[11,"class","menu-label"],[9],[0,"\\n            Metrics\\n          "],[10],[0,"\\n          "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n            "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"if",[[23,["activeCluster","unsealed"]]],null,{"statements":[[4,"link-to",["vault.cluster.requests"],null,{"statements":[[0,"                "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n                  "],[7,"span"],[11,"class","level-left"],[9],[0,"HTTP Requests"],[10],[0,"\\n                  "],[5,"chevron",[[11,"class","has-text-grey-light level-right"]],[[],[]]],[0,"\\n                "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/status/cluster.hbs"}})}),define("vault/templates/partials/status/user",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"bnd97vXr",block:'{"symbols":[],"statements":[[4,"if",[[27,"and",[[23,["cluster","name"]],[23,["auth","currentToken"]]],null]],null,{"statements":[[0,"  "],[1,[27,"auth-info",null,[["activeClusterName","onLinkClick"],[[23,["cluster","name"]],[27,"action",[[22,0,[]],[23,["onLinkClick"]]],null]]]],false],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/status/user.hbs"}})}),define("vault/templates/partials/tools/hash",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"7IIg/X0l",block:'{"symbols":["formatOption","algo","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,3,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Hash data\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[3]}],[0,"\\n\\n"],[4,"if",[[23,["sum"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","sum"],[11,"class","is-input"],[9],[0,"Sum"],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[7,"textarea"],[11,"readonly",""],[11,"class","textarea"],[11,"id","sum"],[9],[1,[21,"sum"],false],[10],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[23,["sum"]],"button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Hashed data copied!"],null]],null]]],{"statements":[[0,"      Copy\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n        Back\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[1,[27,"message-error",null,[["errors"],[[23,["errors"]]]]],false],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","input"],[11,"class","is-label"],[9],[0,"\\n        Input\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"textarea",null,[["id","name","value","class"],["input","input",[23,["input"]],"textarea"]]],false],[0,"\\n        "],[1,[27,"b64-toggle",null,[["value","isInput"],[[23,["input"]],false]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-horizontal"],[9],[0,"\\n      "],[7,"div"],[11,"class","field-body"],[9],[0,"\\n        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","algorithm"],[11,"class","is-label"],[9],[0,"Algorithm"],[10],[0,"\\n          "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n            "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n              "],[7,"select"],[11,"name","algorithm"],[11,"id","algorithm"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["algorithm"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"sha2-digest-sizes",null,null]],null,{"statements":[[0,"                  "],[7,"option"],[12,"selected",[27,"if",[[23,["algorithm"]],[27,"eq",[[23,["algorithm"]],[22,2,[]]],null]],null]],[12,"value",[22,2,[]]],[9],[0,"\\n                    "],[1,[22,2,[]],false],[0,"\\n                  "],[10],[0,"\\n"]],"parameters":[2]},null],[0,"              "],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","format"],[11,"class","is-label"],[9],[0," Output format "],[10],[0,"\\n          "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n            "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n              "],[7,"select"],[11,"name","format"],[11,"id","format"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["format"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"array",["base64","hex"],null]],null,{"statements":[[0,"                  "],[7,"option"],[12,"selected",[27,"if",[[23,["format"]],[27,"eq",[[23,["format"]],[22,1,[]]],null]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n                    "],[1,[22,1,[]],false],[0,"\\n                  "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"              "],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n         Hash\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/tools/hash.hbs"}})}),define("vault/templates/partials/tools/lookup",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Udd5yqIp",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Lookup token\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[4,"if",[[27,"or",[[23,["creation_time"]],[23,["creation_ttl"]]],null]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-fullwidth is-sideless is-paddingless is-marginless"],[9],[0,"\\n    "],[1,[27,"info-table-row",null,[["label","value"],["Creation path",[23,["creation_path"]]]]],false],[0,"\\n    "],[1,[27,"info-table-row",null,[["label","value"],["Creation time",[23,["creation_time"]]]]],false],[0,"\\n    "],[1,[27,"info-table-row",null,[["label","value"],["Creation TTL",[23,["creation_ttl"]]]]],false],[0,"\\n"],[4,"if",[[23,["expirationDate"]]],null,{"statements":[[0,"      "],[1,[27,"info-table-row",null,[["label","value"],["Expiration date",[23,["expirationDate"]]]]],false],[0,"\\n      "],[1,[27,"info-table-row",null,[["label","value"],["Expires in",[27,"date-from-now",[[23,["expirationDate"]]],null]]]],false],[0,"\\n"]],"parameters":[]},null],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n        Back\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["perform",[21,"selectedAction"]]]],[0,"\\n    "],[1,[27,"message-error",null,[["errors"],[[23,["errors"]]]]],false],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","token"],[11,"class","is-label"],[9],[0,"Wrapping token"],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"input",null,[["value","class","id","name"],[[23,["token"]],"input","token","token"]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n        Lookup token\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/tools/lookup.hbs"}})}),define("vault/templates/partials/tools/random",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"YSiUuvT7",block:'{"symbols":["formatOption","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,2,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Random bytes\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[2]}],[0,"\\n\\n"],[4,"if",[[23,["random_bytes"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[7,"label"],[11,"for","rand"],[11,"class","is-label"],[9],[0,"Random bytes"],[10],[0,"\\n    "],[7,"textarea"],[11,"readonly",""],[11,"class","textarea"],[11,"id","rand"],[9],[1,[21,"random_bytes"],false],[10],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[23,["random_bytes"]],"button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Random bytes copied!"],null]],null]]],{"statements":[[0,"        Copy\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n        Back\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[1,[27,"message-error",null,[["errors"],[[23,["errors"]]]]],false],[0,"\\n    "],[7,"div"],[11,"class","field is-horizontal"],[9],[0,"\\n      "],[7,"div"],[11,"class","field-body"],[9],[0,"\\n        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","bytes"],[11,"class","is-label"],[9],[0,"\\n            Number of bytes\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[1,[27,"input",null,[["id","class","value"],["bytes","input",[23,["bytes"]]]]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","field"],[9],[0,"\\n          "],[7,"label"],[11,"for","format"],[11,"class","is-label"],[9],[0,"\\n            Output format\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n            "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n              "],[7,"select"],[11,"name","format"],[11,"id","format"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["format"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[27,"array",["base64","hex"],null]],null,{"statements":[[0,"                  "],[7,"option"],[12,"selected",[27,"if",[[23,["format"]],[27,"eq",[[23,["format"]],[22,1,[]]],null]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n                    "],[1,[22,1,[]],false],[0,"\\n                  "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"              "],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n         Generate\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/tools/random.hbs"}})}),define("vault/templates/partials/tools/rewrap",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"cvIZbHSi",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Rewrap token\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[4,"if",[[23,["rewrap_token"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","wrap-info"],[11,"class","is-label"],[9],[0,"Rewrapped token"],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"textarea",null,[["value","readonly","class","id","name"],[[23,["rewrap_token"]],true,"textarea","wrap-info","wrap-info"]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[23,["rewrap_token"]],"button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Token copied!"],null]],null]]],{"statements":[[0,"        Copy\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n        Back\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["perform",[21,"selectedAction"]]]],[0,"\\n    "],[1,[27,"message-error",null,[["errors"],[[23,["errors"]]]]],false],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","token"],[11,"class","is-label"],[9],[0,"Wrapping token"],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"input",null,[["value","class","id","name"],[[23,["token"]],"input","token","token"]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n        Rewrap token\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/tools/rewrap.hbs"}})}),define("vault/templates/partials/tools/unwrap",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"i6E036fP",block:'{"symbols":["detail","key","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,3,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Unwrap data\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[3]}],[0,"\\n\\n"],[4,"if",[[23,["unwrap_data"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[7,"nav"],[11,"class","tabs"],[9],[0,"\\n      "],[7,"ul"],[9],[0,"\\n        "],[7,"li"],[11,"role","tab"],[12,"aria-selected",[27,"if",[[27,"eq",[[23,["unwrapActiveTab"]],"data"],null],"true","false"],null]],[12,"class",[28,[[27,"if",[[27,"eq",[[23,["unwrapActiveTab"]],"data"],null],"is-active"],null]]]],[9],[0,"\\n          "],[7,"button"],[11,"class","link link-plain tab has-text-weight-semibold"],[3,"action",[[22,0,[]],[27,"mut",[[23,["unwrapActiveTab"]]],null],"data"]],[9],[0,"Data"],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"li"],[11,"role","tab"],[12,"aria-selected",[27,"if",[[27,"eq",[[23,["unwrapActiveTab"]],"data"],null],"true","false"],null]],[12,"class",[28,[[27,"if",[[27,"eq",[[23,["unwrapActiveTab"]],"details"],null],"is-active"],null]]]],[9],[0,"\\n          "],[7,"button"],[11,"class","link link-plain tab has-text-weight-semibold"],[3,"action",[[22,0,[]],[27,"mut",[[23,["unwrapActiveTab"]]],null],"details"]],[9],[0,"Wrap Details"],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"],[4,"if",[[27,"eq",[[23,["unwrapActiveTab"]],"data"],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[1,[27,"json-editor",null,[["value","options"],[[27,"stringify",[[23,["unwrap_data"]]],null],[27,"hash",null,[["readOnly"],[true]]]]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[7,"div"],[11,"class","field box is-fullwidth is-shadowless is-paddingless is-marginless"],[9],[0,"\\n"],[4,"each",[[27,"-each-in",[[23,["details"]]],null]],null,{"statements":[[4,"info-table-row",null,[["label","value"],[[22,2,[]],[22,2,[]]]],{"statements":[[4,"if",[[27,"or",[[27,"eq",[[22,1,[]],"No"],null],[27,"eq",[[22,1,[]],"None"],null]],null]],null,{"statements":[[0,"              "],[5,"icon",[[11,"class","has-text-grey"]],[["@glyph"],["cancel-square-outline"]]],[0," "],[1,[22,1,[]],false],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[22,1,[]],"Yes"],null]],null,{"statements":[[0,"                "],[5,"icon",[[11,"class","has-text-success"]],[["@glyph"],["check-circle-outline"]]],[0,"\\n"]],"parameters":[]},null],[0,"              "],[1,[22,1,[]],false],[0,"\\n"]],"parameters":[]}]],"parameters":[]},null]],"parameters":[1,2]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]}],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[27,"stringify",[[23,["unwrap_data"]]],null],"button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Data copied!"],null]],null]]],{"statements":[[0,"        Copy\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n        Back\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["perform",[21,"selectedAction"]]]],[0,"\\n    "],[1,[27,"message-error",null,[["errors"],[[23,["errors"]]]]],false],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","token"],[11,"class","is-label"],[9],[0,"Wrapping token"],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"input",null,[["value","class","id","name","autocomplete","spellcheck"],[[23,["token"]],"input","token","token","off","false"]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n        Unwrap data\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/tools/unwrap.hbs"}})}),define("vault/templates/partials/tools/wrap",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"0AP+Mqpf",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Wrap data\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[4,"if",[[23,["token"]]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","wrap-info"],[11,"class","is-label"],[9],[0,"Wrapping token"],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"textarea",null,[["value","readonly","class","id","name"],[[23,["token"]],true,"textarea","wrap-info","wrap-info"]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n     "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[23,["token"]],"button is-primary","button",[27,"action",[[22,0,[]],[27,"set-flash-message",["Token copied!"],null]],null]]],{"statements":[[0,"        Copy\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button"],[11,"type","button"],[3,"action",[[22,0,[]],"onClear"]],[9],[0,"\\n        Back\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["perform",[21,"selectedAction"]]]],[0,"\\n    "],[1,[27,"message-error",null,[["errors"],[[23,["errors"]]]]],false],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","data"],[11,"class","is-label"],[9],[0,"Data to wrap "],[7,"span"],[11,"class","is-size-9 is-lowercase has-text-grey"],[9],[0,"(json-formatted)"],[10],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"json-editor",null,[["value","valueUpdated"],[[23,["data"]],[27,"action",[[22,0,[]],"codemirrorUpdated"],null]]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[1,[27,"ttl-picker",null,[["labelText","onChange"],["Wrap TTL",[27,"action",[[22,0,[]],[27,"mut",[[23,["wrapTTL"]]],null]],null]]]],false],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[12,"disabled",[21,"buttonDisabled"]],[11,"type","submit"],[9],[0,"\\n        Wrap data\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/tools/wrap.hbs"}})}),define("vault/templates/partials/transit-form-create",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"YJaYi3hi",block:'{"symbols":[],"statements":[[7,"form"],[12,"onsubmit",[27,"action",[[22,0,[]],"createOrUpdateKey","create"],null]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[1,[27,"message-error",null,[["model"],[[23,["key"]]]]],false],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["create","transit key"]]],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","key-name"],[11,"class","is-label"],[9],[0,"Name"],[10],[0,"\\n      "],[1,[27,"input",null,[["id","value","class"],["key-name",[23,["key","id"]],"input"]]],false],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","key-type"],[11,"class","is-label"],[9],[0,"Type"],[10],[0,"\\n      "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n        "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n          "],[7,"select"],[11,"name","key-type"],[11,"id","key-type"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["key","type"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n            "],[7,"option"],[12,"selected",[27,"eq",[[23,["key","type"]],"aes256-gcm96"],null]],[11,"value","aes256-gcm96"],[9],[0,"\\n              aes256-gcm96\\n            "],[10],[0,"\\n            "],[7,"option"],[12,"selected",[27,"eq",[[23,["key","type"]],"chacha20-poly1305"],null]],[11,"value","chacha20-poly1305"],[9],[0,"\\n              chacha20-poly1305\\n            "],[10],[0,"\\n            "],[7,"option"],[12,"selected",[27,"eq",[[23,["key","type"]],"ecdsa-p256"],null]],[11,"value","ecdsa-p256"],[9],[0,"\\n              ecdsa-p256\\n            "],[10],[0,"\\n            "],[7,"option"],[12,"selected",[27,"eq",[[23,["key","type"]],"ed25519"],null]],[11,"value","ed25519"],[9],[0,"\\n              ed25519\\n            "],[10],[0,"\\n            "],[7,"option"],[12,"selected",[27,"eq",[[23,["key","type"]],"rsa-2048"],null]],[11,"value","rsa-2048"],[9],[0,"\\n              rsa-2048\\n            "],[10],[0,"\\n            "],[7,"option"],[12,"selected",[27,"eq",[[23,["key","type"]],"rsa-4096"],null]],[11,"value","rsa-4096"],[9],[0,"\\n              rsa-4096\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"div"],[11,"class","b-checkbox"],[9],[0,"\\n        "],[7,"input"],[11,"id","key-exportable"],[11,"class","styled"],[12,"checked",[23,["key","exportable"]]],[12,"onchange",[27,"action",[[22,0,[]],"setValueOnKey","exportable"],null]],[11,"type","checkbox"],[9],[10],[0,"\\n        "],[7,"label"],[11,"for","key-exportable"],[11,"class","is-label"],[9],[0,"\\n          Exportable\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"],[4,"if",[[27,"or",[[27,"eq",[[23,["key","type"]],"aes256-gcm96"],null],[27,"eq",[[23,["key","type"]],"chacha20-poly1305"],null],[27,"eq",[[23,["key","type"]],"ed25519"],null]],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"div"],[11,"class","b-checkbox"],[9],[0,"\\n          "],[7,"input"],[11,"id","key-derived"],[11,"class","styled"],[12,"checked",[23,["key","derived"]]],[12,"onchange",[27,"action",[[22,0,[]],"derivedChange"],[["value"],["target.checked"]]]],[11,"type","checkbox"],[9],[10],[0,"\\n          "],[7,"label"],[11,"for","key-derived"],[11,"class","is-label"],[9],[0,"\\n            Derived\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"or",[[27,"eq",[[23,["key","type"]],"aes256-gcm96"],null],[27,"eq",[[23,["key","type"]],"chacha20-poly1305"],null]],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"div"],[11,"class","b-checkbox"],[9],[0,"\\n          "],[7,"input"],[11,"id","key-convergent"],[11,"class","styled"],[12,"checked",[23,["key","convergentEncryption"]]],[12,"onchange",[27,"action",[[22,0,[]],"convergentEncryptionChange"],[["value"],["target.checked"]]]],[11,"type","checkbox"],[9],[10],[0,"\\n          "],[7,"label"],[11,"for","key-convergent"],[11,"class","is-label"],[9],[0,"\\n            Enable convergent encryption\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[12,"disabled",[21,"requestInFlight"]],[12,"class",[28,["button is-primary ",[27,"if",[[23,["requestInFlight"]],"is-loading"],null]]]],[11,"type","submit"],[9],[0,"\\n        Create encryption key\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"secret-link",null,[["mode","class"],["list","button"]],{"statements":[[0,"        Cancel\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/transit-form-create.hbs"}})}),define("vault/templates/partials/transit-form-edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"4jNIP2Kx",block:'{"symbols":["version","version"],"statements":[[7,"form"],[12,"onsubmit",[27,"action",[[22,0,[]],"createOrUpdateKey","create"],null]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[1,[27,"message-error",null,[["model"],[[23,["key"]]]]],false],[0,"\\n    "],[5,"namespace-reminder",[],[["@mode","@noun"],["edit","transit key"]]],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"div"],[11,"class","b-checkbox"],[9],[0,"\\n        "],[7,"input"],[11,"id","key-allows-delete"],[12,"checked",[23,["key","deletionAllowed"]]],[11,"class","styled"],[12,"onchange",[27,"action",[[22,0,[]],"setValueOnKey","deletionAllowed"],null]],[11,"type","checkbox"],[9],[10],[0,"\\n        "],[7,"label"],[11,"for","key-allows-delete"],[11,"class","is-label"],[9],[0,"\\n          Allow deletion\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","key-min-version"],[11,"class","is-label"],[9],[0,"Minimum decryption version"],[10],[0,"\\n      "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n        "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n          "],[7,"select"],[11,"name","key-min-version"],[11,"id","key-min-version"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["key","minDecryptionVersion"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n"],[4,"each",[[23,["key","keyVersions"]]],null,{"statements":[[0,"              "],[7,"option"],[12,"selected",[27,"eq",[[23,["key","minDecryptionVersion"]],[22,2,[]]],null]],[12,"value",[22,2,[]]],[9],[0,"\\n                "],[7,"code"],[9],[1,[22,2,[]],false],[10],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[2]},null],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"p"],[11,"class","help"],[9],[0,"\\n      The minimum decryption version required to reverse transformations performed with the encryption key. Results from lower key versions\\n      may be rewrapped with the new key version using the "],[7,"code"],[9],[0,"rewrap"],[10],[0," action.\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","key-min-version"],[11,"class","is-label"],[9],[0,"Minimum encryption version"],[10],[0,"\\n      "],[7,"div"],[11,"class","control is-expanded"],[9],[0,"\\n        "],[7,"div"],[11,"class","select is-fullwidth"],[9],[0,"\\n          "],[7,"select"],[11,"name","key-min-version"],[11,"id","key-min-version"],[12,"onchange",[27,"action",[[22,0,[]],[27,"mut",[[23,["key","minEncryptionVersion"]]],null]],[["value"],["target.value"]]]],[9],[0,"\\n             "],[7,"option"],[12,"selected",[27,"eq",[[23,["key","minEncryptionVersion"]],0],null]],[11,"value","0"],[9],[0,"\\n               "],[7,"code"],[9],[0,"Latest"],[10],[0," (currently "],[1,[23,["key","latestVersion"]],false],[0,")\\n            "],[10],[0,"\\n"],[4,"each",[[23,["key","encryptionKeyVersions"]]],null,{"statements":[[0,"              "],[7,"option"],[12,"selected",[27,"eq",[[23,["key","minEncryptionVersion"]],[22,1,[]]],null]],[12,"value",[22,1,[]]],[9],[0,"\\n                "],[7,"code"],[9],[1,[22,1,[]],false],[10],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[1]},null],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"p"],[11,"class","help"],[9],[0,"\\n      The minimum version of the key that can be used to encrypt plaintext, sign payloads, or generate HMACs.\\n      You will be able to specify which version of the key to use for each of these actions. The value specified here must be greater than or equal to that specified in the "],[7,"b"],[9],[0,"Minimum Decryption Version"],[10],[0," selection above.\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped is-grouped-split box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"div"],[11,"class","field is-grouped"],[9],[0,"\\n"],[4,"if",[[23,["capabilities","canUpdate"]]],null,{"statements":[[0,"          "],[7,"div"],[11,"class","control"],[9],[0,"\\n            "],[7,"button"],[12,"disabled",[21,"requestInFlight"]],[12,"class",[28,["button is-primary ",[27,"if",[[23,["requestInFlight"]],"is-loading"],null]]]],[11,"type","submit"],[9],[0,"\\n              Update transit key\\n            "],[10],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},null],[0,"        "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"secret-link",null,[["mode","secret","class"],["show",[23,["key","id"]],"button"]],{"statements":[[0,"            Cancel\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[27,"and",[[23,["key","canDelete"]],[23,["capabilities","canDelete"]]],null]],null,{"statements":[[0,"        "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction"],["button",[27,"action",[[22,0,[]],"deleteKey"],null]]],{"statements":[[0,"\\n          Delete transit key\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/transit-form-edit.hbs"}})}),define("vault/templates/partials/transit-form-show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"AzExUX4H",block:'{"symbols":["meta","version","creationTimestamp","version"],"statements":[[7,"div"],[11,"class","tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[9],[0,"\\n  "],[7,"nav"],[11,"class","tabs"],[9],[0,"\\n    "],[7,"ul"],[9],[0,"\\n      "],[7,"li"],[12,"class",[28,[[27,"if",[[27,"eq",[[23,["tab"]],""],null],"is-active"],null]]]],[9],[0,"\\n"],[4,"secret-link",null,[["secret","mode","replace","queryParams"],[[23,["key","id"]],"show",true,[27,"query-params",null,[["tab"],[""]]]]],{"statements":[[0,"          Details\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n\\n      "],[7,"li"],[12,"class",[28,[[27,"if",[[27,"eq",[[23,["tab"]],"versions"],null],"is-active"],null]]]],[9],[0,"\\n"],[4,"secret-link",null,[["secret","mode","replace","queryParams"],[[23,["key","id"]],"show",true,[27,"query-params",null,[["tab"],["versions"]]]]],{"statements":[[0,"          Versions\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n\\n"],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n  "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n"],[4,"if",[[27,"eq",[[23,["tab"]],"versions"],null]],null,{"statements":[[0,"      "],[5,"transit-key-actions",[],[["@key","@selectedAction","@capabilities","@onRefresh"],[[21,"key"],"rotate",[21,"capabilities"],[27,"action",[[22,0,[]],"refresh"],null]]]],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"eq",[[23,["mode"]],"show"],null]],null,{"statements":[[4,"if",[[27,"or",[[23,["capabilities","canUpdate"]],[23,["capabilities","canDelete"]]],null]],null,{"statements":[[0,"        "],[5,"toolbar-secret-link",[[11,"replace","true"]],[["@secret","@mode"],[[23,["key","id"]],"edit"]],{"statements":[[0,"\\n          Edit encryption key\\n        "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"      "],[5,"toolbar-secret-link",[],[["@secret","@mode"],[[23,["key","id"]],"actions"]],{"statements":[[0,"\\n        Key actions\\n      "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n\\n"],[4,"if",[[27,"eq",[[23,["tab"]],"versions"],null]],null,{"statements":[[4,"if",[[27,"or",[[27,"eq",[[23,["key","type"]],"aes256-gcm96"],null],[27,"eq",[[23,["key","type"]],"chacha20-poly1305"],null]],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","columns is-mobile is-gapless is-marginless table"],[9],[0,"\\n      "],[7,"div"],[11,"class","column is-half thead"],[9],[0,"\\n        "],[7,"div"],[11,"class","th"],[9],[0,"\\n          Version\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","column is-half thead"],[9],[0,"\\n        "],[7,"div"],[11,"class","th"],[9],[0,"\\n          Created at\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"],[4,"each",[[27,"-each-in",[[23,["key","keys"]]],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","columns is-mobile is-gapless is-marginless table"],[9],[0,"\\n        "],[7,"div"],[11,"class","column is-half td"],[9],[0,"\\n          "],[7,"div"],[11,"class","td is-borderless"],[9],[0,"\\n            "],[1,[22,4,[]],false],[0,"\\n"],[4,"if",[[27,"coerce-eq",[[23,["key","minDecryptionVersion"]],[22,4,[]]],null]],null,{"statements":[[0,"              "],[7,"p"],[11,"class","help has-text-grey"],[9],[0,"(current minimum decryption version)"],[10],[0,"\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","column is-half td"],[9],[0,"\\n          "],[7,"div"],[11,"class","td is-borderless"],[9],[0,"\\n            "],[1,[27,"date-format",[[22,3,[]],"MMM DD, YYYY hh:mm:ss A"],null],false],[0,"\\n            "],[7,"br"],[9],[10],[0,"\\n            "],[7,"small"],[11,"class","is-font-mono has-text-grey"],[9],[0,"\\n              "],[1,[27,"date-format",[[22,3,[]]],null],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[3,4]},null]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","columns is-gapless is-marginless table"],[9],[0,"\\n      "],[7,"div"],[11,"class","column is-11 thead"],[9],[0,"\\n        "],[7,"div"],[11,"class","columns is-marginless is-gapless"],[9],[0,"\\n          "],[7,"div"],[11,"class","column is-one-third"],[9],[0,"\\n            "],[7,"div"],[11,"class","th"],[9],[0,"\\n              Version\\n            "],[10],[0,"\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","column  is-one-third"],[9],[0,"\\n            "],[7,"div"],[11,"class","th"],[9],[0,"\\n              Name\\n            "],[10],[0,"\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","column  is-one-third"],[9],[0,"\\n            "],[7,"div"],[11,"class","th"],[9],[0,"\\n              Created at\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","column is-1 thead is-hidden-mobile"],[9],[0,"\\n        "],[7,"div"],[11,"class","column thead is-narrow"],[9],[0,"\\n          "],[7,"div"],[11,"class","th"],[9],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"],[4,"each",[[27,"-each-in",[[23,["key","keys"]]],null]],null,{"statements":[[0,"      "],[7,"div"],[12,"class",[28,["columns is-gapless is-marginless table ",[27,"if",[[27,"get",[[22,0,[]],[27,"concat",[[22,2,[]],"-open"],null]],null],"has-background-grey-lighter"],null]]]],[9],[0,"\\n        "],[7,"div"],[12,"class",[28,["column ",[27,"if",[[27,"get",[[22,0,[]],[27,"concat",[[22,2,[]],"-open"],null]],null],"","td"],null]]]],[9],[0,"\\n          "],[7,"div"],[11,"class","columns is-marginless is-gapless"],[9],[0,"\\n            "],[7,"div"],[11,"class","column is-11"],[9],[0,"\\n              "],[7,"div"],[11,"class","columns is-marginless is-gapless"],[9],[0,"\\n                "],[7,"div"],[11,"class","column is-one-third"],[9],[0,"\\n                  "],[7,"div"],[11,"class","td is-borderless"],[9],[0,"\\n                    "],[1,[22,2,[]],false],[0,"\\n"],[4,"if",[[27,"coerce-eq",[[23,["key","minDecryptionVersion"]],[22,2,[]]],null]],null,{"statements":[[0,"                      "],[7,"p"],[11,"class","help has-text-grey"],[9],[0,"(current minimum decryption version)"],[10],[0,"\\n"]],"parameters":[]},null],[0,"                  "],[10],[0,"\\n                "],[10],[0,"\\n                "],[7,"div"],[11,"class","column is-one-third"],[9],[0,"\\n                  "],[7,"div"],[11,"class","td is-borderless"],[9],[0,"\\n                    "],[1,[22,1,["name"]],false],[0,"\\n                  "],[10],[0,"\\n                "],[10],[0,"\\n                "],[7,"div"],[11,"class","column is-one-third"],[9],[0,"\\n                  "],[7,"div"],[11,"class","td is-borderless"],[9],[0,"\\n                    "],[7,"div"],[9],[0,"\\n                      "],[1,[27,"date-format",[[22,1,["creation_time"]],"MMM DD, YYYY hh:mm:ss A"],null],false],[0,"\\n                      "],[7,"br"],[9],[10],[0,"\\n                      "],[7,"small"],[11,"class","is-font-mono has-text-grey"],[9],[0,"\\n                        "],[1,[27,"date-format",[[22,1,["creation_time"]]],null],false],[0,"\\n                      "],[10],[0,"\\n                    "],[10],[0,"\\n                  "],[10],[0,"\\n                "],[10],[0,"\\n              "],[10],[0,"\\n            "],[10],[0,"\\n            "],[7,"div"],[11,"class","column is-1 has-text-centered is-flex-v-centered"],[9],[0,"\\n              "],[7,"button"],[11,"class","button is-transparent"],[11,"type","button"],[3,"action",[[22,0,[]],[27,"toggle",[[27,"concat",[[22,2,[]],"-open"],null],[22,0,[]]],null]]],[9],[0,"\\n                "],[5,"icon",[[11,"class","has-text-black auto-width"],[12,"aria-label",[27,"concat",[[23,["backend","path"]]," options"],null]]],[["@glyph"],["more-horizontal"]]],[0,"\\n              "],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"],[4,"if",[[27,"get",[[22,0,[]],[27,"concat",[[22,2,[]],"-open"],null]],null]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","table has-background-grey-lighter is-paddingless is-marginless"],[9],[0,"\\n          "],[7,"div"],[11,"class","td"],[9],[0,"\\n            "],[7,"div"],[9],[0,"\\n              "],[7,"span"],[11,"class","is-label"],[9],[0,"\\n                Public Key\\n              "],[10],[0,"\\n              "],[7,"pre"],[11,"class","has-background-transparent"],[9],[7,"code"],[11,"class","is-paddingless"],[9],[1,[22,1,["public_key"]],false],[10],[10],[0,"              "],[7,"div"],[11,"class","box is-fullwidth has-background-transparent is-shadowless"],[9],[0,"\\n                "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"copy-button",null,[["clipboardText","class","buttonType","success"],[[22,1,["public_key"]],"button","button",[27,"action",[[22,0,[]],[27,"set-flash-message",[[27,"concat",["Public key for version ",[22,2,[]]," copied!"],null]],null]],null]]],{"statements":[[0,"                    Copy\\n"]],"parameters":[]},null],[0,"                "],[10],[0,"\\n              "],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1,2]},null]],"parameters":[]}]],"parameters":[]},{"statements":[[0,"  "],[1,[27,"info-table-row",null,[["label","value"],["Type",[23,["key","type"]]]]],false],[0,"\\n  "],[1,[27,"info-table-row",null,[["label","value"],["Deletion allowed",[27,"stringify",[[23,["key","deletionAllowed"]]],null]]]],false],[0,"\\n\\n"],[4,"if",[[23,["key","derived"]]],null,{"statements":[[0,"    "],[1,[27,"info-table-row",null,[["label","value"],["Derived",[23,["key","derived"]]]]],false],[0,"\\n    "],[1,[27,"info-table-row",null,[["label","value"],["Convergent encryption",[23,["key","convergentEncryption"]]]]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/transit-form-show.hbs"}})}),define("vault/templates/partials/userpass-form",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"rQO0qDZe",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","field"],[9],[0,"\\n  "],[7,"label"],[11,"for","username"],[11,"class","is-label"],[9],[0,"Username"],[10],[0,"\\n  "],[7,"div"],[11,"class","control"],[9],[0,"\\n    "],[1,[27,"input",null,[["value","name","id","class","autocomplete","spellcheck"],[[23,["username"]],"username","username","input","off","false"]]],false],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"],[7,"div"],[11,"class","field"],[9],[0,"\\n  "],[7,"label"],[11,"for","password"],[11,"class","is-label"],[9],[0,"Password"],[10],[0,"\\n  "],[7,"div"],[11,"class","control"],[9],[0,"\\n    "],[1,[27,"input",null,[["value","name","id","type","class","autocomplete","spellcheck"],[[23,["password"]],"password","password","password","input","off","false"]]],false],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/partials/userpass-form.hbs"}})}),define("vault/templates/vault",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Ub9O02QH",block:'{"symbols":[],"statements":[[0,"\\n"],[1,[21,"outlet"],false],[0,"\\n  "],[7,"footer"],[11,"class","footer has-text-grey has-text-centered"],[9],[0,"\\n    "],[7,"span"],[11,"class","is-inline-block"],[9],[0,"\\n      "],[5,"icon",[[11,"aria-hidden","true"],[11,"class","has-text-grey-light"]],[["@glyph","@size"],["hashicorp","l"]]],[0,"\\n      © "],[1,[27,"date-format",[[27,"now",null,null],"YYYY"],null],false],[0," HashiCorp\\n    "],[10],[0,"\\n    "],[7,"span"],[9],[0,"\\n      Vault "],[1,[23,["activeCluster","leaderNode","version"]],false],[0,"\\n    "],[10],[0,"\\n"],[4,"if",[[27,"is-version",["OSS"],null]],null,{"statements":[[0,"      "],[7,"span"],[9],[0,"\\n        "],[7,"a"],[11,"href","https://hashicorp.com/products/vault/trial?source=vaultui"],[11,"class","link has-text-grey"],[9],[0,"\\n          Upgrade to Vault Enterprise\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[7,"span"],[9],[0,"\\n      "],[7,"a"],[11,"class","has-text-grey"],[11,"target","_blank"],[11,"rel","noreferrer noopener"],[11,"href","https://www.vaultproject.io/docs/index.html"],[9],[0,"Documentation"],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[4,"if",[[27,"eq",[[23,["env"]],"development"],null]],null,{"statements":[[0,"    "],[7,"div"],[11,"class","env-banner level development"],[9],[0,"\\n      "],[7,"div"],[11,"class","level-item notification"],[9],[0,"\\n        "],[5,"icon",[],[["@glyph"],["git-branch"]]],[5,"icon",[],[["@glyph"],["edit"]]],[0," Local development "],[5,"icon",[],[["@glyph"],["edit"]]],[5,"icon",[],[["@glyph"],["git-branch"]]],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[7,"div"],[11,"id","modal-wormhole"],[9],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault.hbs"}})}),define("vault/templates/vault/cluster",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"33Y8y2G2",block:'{"symbols":["flash","component","flash","close","Nav"],"statements":[[4,"if",[[23,["showNav"]]],null,{"statements":[[0,"  "],[5,"nav-header",[],[["@class"],[[28,[[27,"if",[[23,["consoleOpen"]],"panel-open"],null]]]]],{"statements":[[0,"\\n    "],[6,[22,5,["home"]],[],[[],[]],{"statements":[[0,"\\n      "],[5,"home-link",[],[["@class"],["navbar-item has-text-white has-current-color-fill"]],{"statements":[[0,"\\n        "],[5,"icon",[],[["@glyph","@size"],["vault-logo","l"]]],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[]}],[0,"\\n    "],[6,[22,5,["main"]],[],[[],[]],{"statements":[[0,"\\n      "],[7,"ul"],[12,"class",[28,["navbar-sections ",[27,"if",[[27,"has-feature",["Namespaces"],null],"with-ns-picker"],null]]]],[9],[0,"\\n"],[4,"if",[[27,"has-feature",["Namespaces"],null]],null,{"statements":[[0,"          "],[7,"li"],[9],[0,"\\n            "],[5,"namespace-picker",[],[["@class","@namespace"],["navbar-item",[21,"namespaceQueryParam"]]],{"statements":[[0,"\\n            "]],"parameters":[]}],[0,"\\n          "],[10],[0,"\\n"]],"parameters":[]},null],[0,"        "],[7,"li"],[12,"class",[28,[[27,"if",[[27,"is-active-route",["vault.cluster.secrets"],null],"is-active"],null]]]],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets"],[["current-when","invokeAction"],["vault.cluster.secrets vault.cluster.settings.mount-secret-backend vault.cluster.settings.configure-secret-backend",[27,"action",[[22,0,[]],[22,5,["closeDrawer"]]],null]]],{"statements":[[0,"            Secrets\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n"],[4,"if",[[27,"has-permission",["access"],null]],null,{"statements":[[0,"          "],[7,"li"],[12,"class",[28,[[27,"if",[[27,"is-active-route",["vault.cluster.access"],null],"is-active"],null]]]],[9],[0,"\\n"],[4,"link-to",null,[["params","current-when","invokeAction"],[[27,"route-params-for",["access"],null],"vault.cluster.access vault.cluster.settings.auth",[27,"action",[[22,0,[]],[22,5,["closeDrawer"]]],null]]],{"statements":[[0,"              Access\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"has-permission",["policies"],null]],null,{"statements":[[0,"          "],[7,"li"],[12,"class",[28,[[27,"if",[[27,"is-active-route",[[27,"array",["vault.cluster.policies","vault.cluster.policy"],null]],null],"is-active"],null]]]],[9],[0,"\\n"],[4,"link-to",["vault.cluster.policies",[27,"route-params-for",["policies"],null]],[["current-when","invokeAction"],["vault.cluster.policies vault.cluster.policy",[27,"action",[[22,0,[]],[22,5,["closeDrawer"]]],null]]],{"statements":[[0,"              Policies\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"has-permission",["tools"],null]],null,{"statements":[[0,"          "],[7,"li"],[12,"class",[28,[[27,"if",[[27,"is-active-route",["vault.cluster.tools"],null],"is-active"],null]]]],[9],[0,"\\n"],[4,"link-to",["vault.cluster.tools.tool",[27,"route-params-for",["tools"],null]],[["invokeAction"],[[27,"action",[[22,0,[]],[22,5,["closeDrawer"]]],null]]],{"statements":[[0,"              Tools\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n    "],[6,[22,5,["items"]],[],[[],[]],{"statements":[[0,"\\n      "],[7,"div"],[11,"class","navbar-separator is-hidden-tablet"],[9],[10],[0,"\\n"],[4,"if",[[23,["namespaceService","inRootNamespace"]]],null,{"statements":[[0,"        "],[7,"div"],[11,"class","navbar-item status-indicator-button"],[12,"data-status",[28,[[27,"if",[[23,["activeCluster","unsealed"]],"good","bad"],null]]]],[9],[0,"\\n          "],[5,"status-menu",[],[["@label","@onLinkClick"],["Status",[27,"action",[[22,0,[]],[22,5,["closeDrawer"]]],null]]]],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","navbar-separator is-hidden-mobile"],[9],[10],[0,"\\n"]],"parameters":[]},null],[0,"      "],[7,"div"],[11,"class","navbar-item"],[9],[0,"\\n        "],[7,"button"],[12,"class",[28,["button is-transparent nav-console-button",[27,"if",[[23,["consoleOpen"]]," popup-open"],null]]]],[11,"type","button"],[3,"action",[[22,0,[]],[27,"queue",[[27,"action",[[22,0,[]],"toggleConsole"],null],[27,"action",[[22,0,[]],[22,5,["closeDrawer"]]],null]],null]]],[9],[0,"\\n          "],[5,"icon",[],[["@glyph","@size"],["console","l"]]],[0,"\\n          "],[7,"div"],[11,"class","status-menu-label"],[9],[0,"\\n            Console\\n          "],[10],[0,"\\n          "],[5,"chevron",[[11,"class","has-text-white is-status-chevron"]],[["@direction"],["down"]]],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n      "],[7,"div"],[12,"class",[28,["navbar-item nav-user-button ",[27,"if",[[23,["auth","allowExpiration"]],"may-expire"],null]]]],[9],[0,"\\n        "],[5,"status-menu",[],[["@type","@label","@onLinkClick"],["user","User",[27,"action",[[22,0,[]],[22,5,["closeDrawer"]]],null]]]],[0,"\\n      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[5]}],[0,"\\n"]],"parameters":[]},null],[7,"div"],[11,"class","global-flash"],[9],[0,"\\n"],[4,"each",[[23,["flashMessages","queue"]]],null,{"statements":[[4,"flash-message",null,[["flash"],[[22,1,[]]]],{"statements":[[4,"if",[[22,3,["componentName"]]],null,{"statements":[[0,"        "],[1,[27,"component",[[22,3,["componentName"]]],[["content"],[[22,3,["content"]]]]],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"        "],[5,"alert-popup",[],[["@type","@message","@close","@isPreformatted"],[[27,"message-types",[[22,3,["type"]]],null],[22,3,["message"]],[22,4,[]],[22,3,["preformatted"]]]]],[0,"\\n"]],"parameters":[]}]],"parameters":[2,3,4]},null]],"parameters":[1]},null],[10],[0,"\\n"],[4,"if",[[23,["showNav"]]],null,{"statements":[[0,"  "],[5,"ui-wizard",[],[[],[]],{"statements":[[0,"\\n    "],[7,"section"],[11,"class","section"],[9],[0,"\\n      "],[7,"div"],[11,"class","container is-widescreen"],[9],[0,"\\n        "],[5,"token-expire-warning",[],[["@expirationDate"],[[23,["auth","tokenExpirationDate"]]]],{"statements":[[0,"\\n          "],[1,[21,"outlet"],false],[0,"\\n        "]],"parameters":[]}],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[1,[21,"outlet"],false],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster.hbs"}})}),define("vault/templates/vault/cluster/access",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"euHdQLs+",block:'{"symbols":[],"statements":[[7,"div"],[11,"class","columns"],[9],[0,"\\n"],[4,"menu-sidebar",null,[["title","class"],["Access","is-3"]],{"statements":[[4,"if",[[27,"has-permission",["access"],[["routeParams"],["methods"]]]],null,{"statements":[[0,"      "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.methods"],[["current-when"],["vault.cluster.access.methods vault.cluster.access.method"]],{"statements":[[0,"          Auth Methods\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"has-permission",["access"],[["routeParams"],["entities"]]]],null,{"statements":[[0,"      "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.identity","entities"],null,{"statements":[[0,"          Entities\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"has-permission",["access"],[["routeParams"],["groups"]]]],null,{"statements":[[0,"      "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.identity","groups"],null,{"statements":[[0,"          Groups\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"has-permission",["access"],[["routeParams"],["leases"]]]],null,{"statements":[[0,"      "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.leases"],null,{"statements":[[0,"          Leases\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"and",[[27,"has-feature",["Namespaces"],null],[27,"has-permission",["access"],[["routeParams"],["namespaces"]]]],null]],null,{"statements":[[0,"      "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.namespaces"],null,{"statements":[[0,"          Namespaces\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[27,"and",[[27,"has-feature",["Control Groups"],null],[27,"has-permission",["access"],[["routeParams"],["control-groups"]]]],null]],null,{"statements":[[0,"      "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.control-groups"],[["current-when"],["vault.cluster.access.control-groups vault.cluster.access.control-group-accessor vault.cluster.access.control-groups-configure"]],{"statements":[[0,"          Control Groups\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"  "],[7,"div"],[11,"class","column is-9"],[9],[0,"\\n    "],[1,[21,"outlet"],false],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access.hbs"}})}),define("vault/templates/vault/cluster/access/control-group-accessor",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"0fEuX9WW",block:'{"symbols":["p"],"statements":[[4,"if",[[27,"has-feature",["Control Groups"],null]],null,{"statements":[[0,"  "],[5,"page-header",[],[[],[]],{"statements":[[0,"\\n    "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n      "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n        Control Groups\\n      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[1]}],[0,"\\n"],[4,"if",[[23,["model","canConfigure"]]],null,{"statements":[[0,"    "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n      "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n        "],[5,"toolbar-link",[],[["@params"],[[27,"array",["vault.cluster.access.control-groups-configure"],null]]],{"statements":[[0,"\\n          Configure\\n        "]],"parameters":[]}],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"  "],[5,"control-group",[],[["@model"],[[21,"model"]]]],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[5,"upgrade-page",[],[["@title","@minimumEdition"],["Control Groups","Vault Enterprise Premium"]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/control-group-accessor.hbs"}})}),define("vault/templates/vault/cluster/access/control-groups-configure",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"pCR4r8iF",block:'{"symbols":["p"],"statements":[[4,"if",[[27,"has-feature",["Control Groups"],null]],null,{"statements":[[0,"  "],[5,"page-header",[],[[],[]],{"statements":[[0,"\\n    "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n      "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n        Control Groups\\n      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[1]}],[0,"\\n  "],[5,"edit-form",[],[["@model","@onSave"],[[21,"model"],[27,"action",[[22,0,[]],"onSave"],null]]]],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[5,"upgrade-page",[],[["@title","@minimumEdition"],["Control Groups","Vault Enterprise Premium"]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/control-groups-configure.hbs"}})}),define("vault/templates/vault/cluster/access/control-groups",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"naMIGidB",block:'{"symbols":["p"],"statements":[[4,"if",[[27,"has-feature",["Control Groups"],null]],null,{"statements":[[0,"  "],[5,"page-header",[],[[],[]],{"statements":[[0,"\\n    "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n      "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n        Control Groups\\n      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[1]}],[0,"\\n"],[4,"if",[[23,["model","canConfigure"]]],null,{"statements":[[0,"    "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n      "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n        "],[5,"toolbar-link",[],[["@params"],[[27,"array",["vault.cluster.access.control-groups-configure"],null]]],{"statements":[[0,"\\n          Configure\\n        "]],"parameters":[]}],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"  "],[7,"form"],[3,"action",[[22,0,[]],[27,"nav-to-route",["vault.cluster.access.control-group-accessor",[23,["model","id"]]],null]],[["on"],["submit"]]],[9],[0,"\\n    "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n      "],[7,"p"],[11,"class","has-text-grey is-size-8"],[9],[0,"\\n       Control Groups add additional authorization factors to be required before satisfying a request. If you have a Control Group accessor, provide it here to view the lookup the authorization progress.\\n      "],[10],[0,"\\n      "],[7,"label"],[11,"for","accessor"],[11,"class","is-label"],[9],[0,"\\n        Accessor\\n      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"input",null,[["class","autocomplete","spellcheck","name","value"],["input","off","false","accessor",[23,["model","id"]]]]],false],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n    "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[12,"disabled",[27,"not",[[23,["model","id"]]],null]],[11,"type","submit"],[9],[0,"\\n        Lookup\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[5,"upgrade-page",[],[["@title","@minimumEdition"],["Control Groups","Vault Enterprise Premium"]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/control-groups.hbs"}})}),define("vault/templates/vault/cluster/access/error",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"dq7Ozcmt",block:'{"symbols":["error","p"],"statements":[[4,"if",[[27,"eq",[[23,["model","httpStatus"]],404],null]],null,{"statements":[[0,"      "],[1,[27,"not-found",null,[["model"],[[23,["model"]]]]],false],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[5,"page-header",[],[[],[]],{"statements":[[0,"\\n        "],[6,[22,2,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n          "],[7,"h1"],[11,"class","title is-3 has-text-grey"],[9],[0,"\\n"],[4,"if",[[27,"eq",[[23,["model","httpStatus"]],403],null]],null,{"statements":[[0,"              Not authorized\\n"]],"parameters":[]},{"statements":[[0,"              Error\\n"]],"parameters":[]}],[0,"          "],[10],[0,"\\n        "]],"parameters":[]}],[0,"\\n      "]],"parameters":[2]}],[0,"\\n      "],[7,"div"],[11,"class","box is-sideless has-background-white-bis has-text-grey has-text-centered"],[9],[0,"\\n"],[4,"if",[[23,["model","message"]]],null,{"statements":[[0,"          "],[7,"p"],[9],[1,[23,["model","message"]],false],[10],[0,"\\n"]],"parameters":[]},null],[4,"each",[[23,["model","errors"]]],null,{"statements":[[0,"          "],[7,"p"],[9],[1,[22,1,[]],false],[10],[0,"\\n"]],"parameters":[1]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/error.hbs"}})}),define("vault/templates/vault/cluster/access/identity/aliases/add",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"A1QBNOs/",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Create "],[1,[27,"lowercase",[[27,"humanize",[[23,["model","identityType"]]],null]],null],false],[0," for "],[1,[23,["model","canonicalId"]],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[1,[27,"identity/edit-form",null,[["model","onSave"],[[23,["model"]],[27,"perform",[[23,["navAfterSave"]]],null]]]],false],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/identity/aliases/add.hbs"}})}),define("vault/templates/vault/cluster/access/identity/aliases/edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"aHRl2dQB",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Edit "],[1,[23,["model","name"]],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[1,[27,"identity/edit-form",null,[["mode","model","onSave"],["edit",[23,["model"]],[27,"perform",[[23,["navAfterSave"]]],null]]]],false],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/identity/aliases/edit.hbs"}})}),define("vault/templates/vault/cluster/access/identity/aliases/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"0c+5YkDF",block:'{"symbols":["item"],"statements":[[1,[27,"identity/entity-nav",null,[["identityType","model"],[[23,["identityType"]],[23,["model"]]]]],false],[0,"\\n"],[4,"if",[[23,["model","meta","total"]]],null,{"statements":[[4,"each",[[23,["model"]]],null,{"statements":[[4,"linked-block",["vault.cluster.access.identity.aliases.show",[22,1,["id"]],"details"],[["class"],["list-item-row"]],{"statements":[[0,"      "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n        "],[7,"div"],[11,"class","column is-10"],[9],[0,"\\n          "],[4,"link-to",["vault.cluster.access.identity.aliases.show",[22,1,["id"]],"details"],[["class"],["is-block has-text-black has-text-weight-semibold"]],{"statements":[[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph"],["user-square-outline"]]],[7,"span"],[11,"class","has-text-weight-semibold"],[9],[1,[22,1,["name"]],false],[10]],"parameters":[]},null],[0,"\\n          "],[7,"div"],[11,"class","has-text-grey"],[9],[0,"\\n            "],[1,[22,1,["id"]],false],[0,"\\n          "],[10],[0,"\\n          "],[7,"span"],[11,"class","tag"],[9],[1,[22,1,["mountType"]],false],[10],[0,"\\n          "],[7,"span"],[11,"class","has-text-grey is-size-8"],[9],[0,"\\n            "],[1,[22,1,["mountAccessor"]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n          "],[1,[27,"identity/popup-alias",null,[["params","onSuccess"],[[27,"array",[[22,1,[]]],null],[27,"action",[[22,0,[]],"onDelete"],null]]]],false],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null],[4,"if",[[27,"gt",[[23,["model","meta","lastPage"]],1],null]],null,{"statements":[[0,"    "],[1,[27,"list-pagination",null,[["page","lastPage","link"],[[23,["model","meta","currentPage"]],[23,["model","meta","lastPage"]],"vault.cluster.access.identity.aliases.index"]]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"  "],[5,"empty-state",[],[["@title","@message"],[[28,["No ",[21,"identityType"]," aliases yet"]],[28,["A list of ",[21,"identityType"]," aliases in this namespace will be listed here. Choose one of the ",[27,"pluralize",[[23,["identityType"]]],null]," and click \\"Create Alias\\" to get started."]]]],{"statements":[[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.create",[27,"pluralize",[[23,["identityType"]]],null]],[["tagName","class"],["button","link"]],{"statements":[[0,"      Create "],[1,[21,"identityType"],false],[0,"\\n"]],"parameters":[]},null],[0,"    "],[5,"learn-link",[],[["@path"],["/vault/identity-access-management/iam-identity"]],{"statements":[[0,"\\n      Learn more\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/identity/aliases/index.hbs"}})}),define("vault/templates/vault/cluster/access/identity/aliases/show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"CzEDv3Sx",block:'{"symbols":["tab","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,2,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"nav"],[11,"class","breadcrumb"],[9],[0,"\\n      "],[7,"ul"],[9],[0,"\\n        "],[7,"li"],[9],[0,"\\n          "],[7,"span"],[11,"class","sep"],[9],[0,"/"],[10],[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.aliases"],null,{"statements":[[0,"            "],[1,[27,"pluralize",[[27,"humanize",[[23,["model","identityType"]]],null]],null],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,2,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      "],[1,[23,["model","name"]],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[2]}],[0,"\\n"],[7,"div"],[11,"class","tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[9],[0,"\\n  "],[7,"nav"],[11,"class","tabs sub-nav"],[9],[0,"\\n    "],[7,"ul"],[9],[0,"\\n"],[4,"each",[[27,"tabs-for-identity-show",[[23,["model","identityType"]]],null]],null,{"statements":[[4,"link-to",["vault.cluster.access.identity.aliases.show",[23,["model","id"]],[22,1,[]]],[["tagName"],["li"]],{"statements":[[4,"link-to",["vault.cluster.access.identity.aliases.show",[23,["model","id"]],[22,1,[]]],null,{"statements":[[0,"            "],[1,[27,"capitalize",[[22,1,[]]],null],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null]],"parameters":[1]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n  "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-link",[],[["@params"],[[27,"array",["vault.cluster.access.identity.aliases.edit",[23,["model","id"]]],null]]],{"statements":[[0,"\\n      Edit "],[1,[27,"lowercase",[[27,"humanize",[[23,["model","identityType"]]],null]],null],false],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"],[1,[27,"component",[[27,"concat",["identity/item-alias/alias-",[23,["section"]]],null]],[["model"],[[23,["model"]]]]],false],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/identity/aliases/show.hbs"}})}),define("vault/templates/vault/cluster/access/identity/create",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"zF6NBTvQ",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Create\\n      "],[1,[23,["model","identityType"]],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n"],[1,[27,"identity/edit-form",null,[["model","onSave"],[[23,["model"]],[27,"perform",[[23,["navAfterSave"]]],null]]]],false]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/identity/create.hbs"}})}),define("vault/templates/vault/cluster/access/identity/edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"D/tO7VEy",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Edit "],[1,[23,["model","name"]],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[1,[27,"identity/edit-form",null,[["mode","model","onSave"],["edit",[23,["model"]],[27,"perform",[[23,["navAfterSave"]]],null]]]],false],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/identity/edit.hbs"}})}),define("vault/templates/vault/cluster/access/identity/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"v4V7OQPg",block:'{"symbols":["item"],"statements":[[1,[27,"identity/entity-nav",null,[["identityType","model"],[[23,["identityType"]],[23,["model"]]]]],false],[0,"\\n"],[4,"if",[[23,["model","meta","total"]]],null,{"statements":[[4,"each",[[23,["model"]]],null,{"statements":[[4,"linked-block",["vault.cluster.access.identity.show",[22,1,["id"]],"details"],[["class"],["list-item-row"]],{"statements":[[0,"      "],[7,"div"],[11,"class","columns is-mobile"],[9],[0,"\\n        "],[7,"div"],[11,"class","column is-7-tablet is-10-mobile"],[9],[0,"\\n          "],[4,"link-to",["vault.cluster.access.identity.show",[22,1,["id"]],"details"],[["class"],["is-block has-text-black has-text-weight-semibold"]],{"statements":[[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph"],["user-square-outline"]]],[7,"span"],[11,"class","has-text-weight-semibold"],[9],[1,[22,1,["name"]],false],[10]],"parameters":[]},null],[0,"\\n          "],[7,"div"],[11,"class","has-text-grey is-size-8"],[9],[0,"\\n            "],[1,[22,1,["id"]],false],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","column is-3 is-hidden-mobile"],[9],[0,"\\n"],[4,"if",[[22,1,["aliases","length"]]],null,{"statements":[[0,"            "],[1,[27,"pluralize",[[22,1,["aliases","length"]],"alias"],null],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n        "],[7,"div"],[11,"class","column has-text-right"],[9],[0,"\\n"],[4,"popup-menu",null,[["name","onOpen"],["identity-item",[27,"action",[[22,0,[]],"reloadRecord",[22,1,[]]],null]]],{"statements":[[0,"            "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n              "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n                "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.show",[22,1,["id"]],"details"],null,{"statements":[[0,"                    Details\\n"]],"parameters":[]},null],[0,"                "],[10],[0,"\\n"],[4,"if",[[27,"or",[[22,1,["isReloading"]],[22,1,["updatePath","isPending"]],[22,1,["aliasPath","isPending"]]],null]],null,{"statements":[[0,"                  "],[7,"li"],[11,"class","action"],[9],[0,"\\n                    "],[7,"button"],[11,"disabled",""],[11,"class","link button is-loading is-transparent"],[11,"type","button"],[9],[0,"\\n                      loading\\n                    "],[10],[0,"\\n                  "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[22,1,["canAddAlias"]]],null,{"statements":[[0,"                    "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.aliases.add",[27,"pluralize",[[23,["identityType"]]],null],[22,1,["id"]]],null,{"statements":[[0,"                        Create alias\\n"]],"parameters":[]},null],[0,"                    "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[22,1,["canEdit"]]],null,{"statements":[[0,"                    "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.edit",[22,1,["id"]]],null,{"statements":[[0,"                        Edit\\n"]],"parameters":[]},null],[0,"                    "],[10],[0,"\\n                    "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"if",[[22,1,["disabled"]]],null,{"statements":[[0,"                        "],[7,"button"],[11,"class","link"],[11,"type","button"],[3,"action",[[22,0,[]],"toggleDisabled",[22,1,[]]]],[9],[0,"\\n                          Enable\\n                        "],[10],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["identityType"]],"entity"],null]],null,{"statements":[[0,"                        "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@onConfirmAction"],["link is-destroy","Disable this?","Associated tokens will not be revoked, but cannot be used","Disable",[27,"action",[[22,0,[]],"toggleDisabled",[22,1,[]]],null]]],{"statements":[[0,"\\n                          Disable\\n                        "]],"parameters":[]}],[0,"\\n                      "]],"parameters":[]},null]],"parameters":[]}],[0,"                    "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[22,1,["canDelete"]]],null,{"statements":[[0,"                    "],[7,"li"],[11,"class","action"],[9],[0,"\\n                      "],[5,"confirm-action",[],[["@buttonClasses","@onConfirmAction"],["link is-destroy",[27,"action",[[22,0,[]],"delete",[22,1,[]]],null]]],{"statements":[[0,"\\n                        Delete\\n                      "]],"parameters":[]}],[0,"\\n                    "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]}],[0,"              "],[10],[0,"\\n            "],[10],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[1]},null],[4,"if",[[27,"gt",[[23,["model","meta","lastPage"]],1],null]],null,{"statements":[[0,"    "],[1,[27,"list-pagination",null,[["page","lastPage","link"],[[23,["model","meta","currentPage"]],[23,["model","meta","lastPage"]],"vault.cluster.access.identity.index"]]],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},{"statements":[[0,"  "],[5,"empty-state",[],[["@title","@message"],[[28,["No ",[27,"pluralize",[[23,["identityType"]]],null]," yet"]],[28,["A list of ",[27,"pluralize",[[23,["identityType"]]],null]," in this namespace will be listed here. Create your first ",[21,"identityType"]," to get started."]]]],{"statements":[[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.create",[27,"pluralize",[[23,["identityType"]]],null]],[["tagName","class"],["button","link"]],{"statements":[[0,"      Create "],[1,[21,"identityType"],false],[0,"\\n"]],"parameters":[]},null],[0,"    "],[5,"learn-link",[],[["@path"],["/vault/identity-access-management/iam-identity"]],{"statements":[[0,"\\n      Learn more\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/identity/index.hbs"}})}),define("vault/templates/vault/cluster/access/identity/merge",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"K82foHp2",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Merge entities\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[1,[27,"identity/edit-form",null,[["mode","model","onSave"],["merge",[23,["model"]],[27,"perform",[[23,["navAfterSave"]]],null]]]],false],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/identity/merge.hbs"}})})
define("vault/templates/vault/cluster/access/identity/show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"px8Ku58/",block:'{"symbols":["tab","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,2,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"nav"],[11,"class","breadcrumb"],[9],[0,"\\n      "],[7,"ul"],[9],[0,"\\n        "],[7,"li"],[9],[0,"\\n          "],[7,"span"],[11,"class","sep"],[9],[0,"/"],[10],[0,"\\n"],[4,"link-to",["vault.cluster.access.identity.index"],null,{"statements":[[0,"            "],[1,[27,"capitalize",[[27,"pluralize",[[23,["model","identityType"]]],null]],null],false],[0,"\\n"]],"parameters":[]},null],[0,"        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,2,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      "],[1,[23,["model","name"]],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[2]}],[0,"\\n"],[7,"div"],[11,"class","tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[9],[0,"\\n  "],[7,"nav"],[11,"class","tabs sub-nav"],[9],[0,"\\n    "],[7,"ul"],[9],[0,"\\n"],[4,"each",[[27,"tabs-for-identity-show",[[23,["model","identityType"]],[23,["model","type"]]],null]],null,{"statements":[[4,"link-to",["vault.cluster.access.identity.show",[27,"pluralize",[[23,["model","identityType"]]],null],[23,["model","id"]],[22,1,[]]],[["tagName"],["li"]],{"statements":[[4,"link-to",["vault.cluster.access.identity.show",[27,"pluralize",[[23,["model","identityType"]]],null],[23,["model","id"]],[22,1,[]]],null,{"statements":[[0,"            "],[1,[27,"capitalize",[[27,"humanize",[[22,1,[]]],null]],null],false],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null]],"parameters":[1]},null],[0,"    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n  "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n"],[4,"unless",[[27,"or",[[27,"and",[[27,"eq",[[23,["model","identityType"]],"group"],null],[27,"eq",[[23,["model","type"]],"internal"],null]],null],[23,["model","alias"]]],null]],null,{"statements":[[0,"      "],[5,"toolbar-link",[],[["@type","@params"],["add",[27,"array",["vault.cluster.access.identity.aliases.add",[27,"pluralize",[[23,["model","identityType"]]],null],[23,["model","id"]]],null]]],{"statements":[[0,"\\n        Add alias\\n      "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"    "],[5,"toolbar-link",[],[["@params"],[[27,"array",["vault.cluster.access.identity.edit",[27,"pluralize",[[23,["model","identityType"]]],null],[23,["model","id"]]],null]]],{"statements":[[0,"\\n      Edit "],[1,[23,["model","identityType"]],false],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n"],[1,[27,"component",[[27,"concat",["identity/item-",[23,["section"]]],null]],[["model"],[[23,["model"]]]]],false],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/identity/show.hbs"}})}),define("vault/templates/vault/cluster/access/leases/error",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"r5dbK/Yr",block:'{"symbols":["error","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,2,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      "],[4,"link-to",["vault.cluster.access.leases"],null,{"statements":[[0,"Leases"]],"parameters":[]},null],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[2]}],[0,"\\n\\n"],[4,"unless",[[27,"or",[[27,"eq",[[23,["model","httpStatus"]],400],null],[27,"eq",[[23,["model","httpStatus"]],404],null]],null]],null,{"statements":[[0,"  "],[1,[23,["model","message"]],false],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"if",[[27,"eq",[[23,["model","httpStatus"]],400],null]],null,{"statements":[[0,"  "],[5,"alert-banner",[],[["@type","@message"],["danger",[28,[[23,["model","keyId"]]," is not a valid lease ID"]]]]],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["model","httpStatus"]],404],null]],null,{"statements":[[0,"  "],[5,"empty-state",[],[["@title","@message"],["No leases with that ID",[28,["Unable to find lease for the ID \\"",[23,["model","keyId"]],"\\". Try going back to the lookup and re-entering the ID."]]]],{"statements":[[0,"\\n"],[4,"link-to",["vault.cluster.access.leases"],[["class"],["link"]],{"statements":[[0,"      Back to lookup\\n"]],"parameters":[]},null],[0,"  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[4,"if",[[27,"eq",[[23,["model","httpStatus"]],403],null]],null,{"statements":[[0,"  "],[5,"empty-state",[],[["@title","@message"],["You don\'t have access to a lease with that ID","If you think you\'ve reached this page in error, please contact your administrator."]],{"statements":[[0,"\\n"],[4,"link-to",["vault.cluster.access.leases"],[["class"],["link"]],{"statements":[[0,"      Back to lookup\\n"]],"parameters":[]},null],[0,"  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[4,"each",[[23,["model","errors"]]],null,{"statements":[[0,"    "],[5,"alert-banner",[],[["@type","@message"],["danger",[22,1,[]]]]],[0,"\\n"]],"parameters":[1]},null]],"parameters":[]}]],"parameters":[]}]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/leases/error.hbs"}})}),define("vault/templates/vault/cluster/access/leases/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"WZ5d6SK/",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Lookup a lease\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[7,"form"],[3,"action",[[22,0,[]],"lookupLease",[23,["leaseId"]]],[["on"],["submit"]]],[9],[0,"\\n  "],[7,"div"],[11,"class","box is-sideless is-fullwidth is-marginless"],[9],[0,"\\n    "],[7,"div"],[11,"class","field"],[9],[0,"\\n      "],[7,"label"],[11,"for","lease-id"],[11,"class","is-label"],[9],[0,"Lease ID"],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n        "],[1,[27,"input",null,[["value","id","class"],[[23,["leaseId"]],"lease-id","input"]]],false],[0,"\\n      "],[10],[0,"\\n      "],[7,"p"],[11,"class","help has-text-grey"],[9],[0,"\\n        If you know the "],[7,"code"],[9],[0,"id"],[10],[0," of a lease, enter it above to lookup details of the lease.\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n  "],[7,"div"],[11,"class","field is-grouped box is-fullwidth is-bottomless"],[9],[0,"\\n    "],[7,"div"],[11,"class","control"],[9],[0,"\\n      "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"Lookup"],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"],[10],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/leases/index.hbs"}})}),define("vault/templates/vault/cluster/access/leases/list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"ImqG7szK",block:'{"symbols":["item","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,2,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[1,[27,"key-value-header",null,[["baseKey","path","model","root","showCurrent"],[[23,["baseKey"]],"vault.cluster.access.leases.list",[23,["clusterController","model","name"]],[23,["backendCrumb"]],true]]],false],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,2,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.leases.list-root"],null,{"statements":[[0,"        Leases\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[2]}],[0,"\\n\\n"],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n  "],[5,"toolbar-filters",[],[[],[]],{"statements":[[0,"\\n    "],[1,[27,"navigate-input",null,[["filterFocusDidChange","filterDidChange","filter","filterMatchesKey","firstPartialMatch","baseKey","shouldNavigateTree","mode","placeholder"],[[27,"action",[[22,0,[]],"setFilterFocus"],null],[27,"action",[[22,0,[]],"setFilter"],null],[23,["filter"]],[23,["filterMatchesKey"]],[23,["firstPartialMatch"]],[27,"get",[[23,["baseKey"]],"id"],null],true,"leases","Filter leases"]]],false],[0,"\\n"],[4,"if",[[23,["filterFocused"]]],null,{"statements":[[0,"        \\n        \\n"],[4,"if",[[23,["filterMatchesKey"]]],null,{"statements":[[4,"unless",[[23,["filterIsFolder"]]],null,{"statements":[[0,"           "],[7,"p"],[11,"class","help has-text-grey is-size-8"],[9],[0,"\\n             "],[7,"kbd"],[9],[0,"ENTER"],[10],[0," to go to see details\\n           "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[4,"if",[[23,["firstPartialMatch"]]],null,{"statements":[[0,"         "],[7,"p"],[11,"class","help has-text-grey is-size-8"],[9],[0,"\\n           "],[7,"kbd"],[9],[0,"TAB"],[10],[0," to complete\\n         "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[]},null],[0,"  "]],"parameters":[]}],[0,"\\n  "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n"],[4,"if",[[27,"not-eq",[[23,["baseKey","id"]],""],null]],null,{"statements":[[0,"      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"if",[[27,"and",[[23,["capabilities","forceRevokePrefix","canUpdate"]],[27,"not",[[23,["confirmingRevoke"]]],null]],null]],null,{"statements":[[0,"          "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@onConfirmAction"],["toolbar-link","Disable this?",[27,"concat",["All leases under this one will also be removed and disregard any errors encountered."],null],"Revoke",[27,"action",[[22,0,[]],"revokePrefix",[23,["baseKey","id"]],true],null]]],{"statements":[[0,"\\n            Force revoke prefix\\n          "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n      "],[7,"div"],[11,"class","control"],[9],[0,"\\n"],[4,"if",[[27,"and",[[23,["capabilities","revokePrefix","canUpdate"]],[27,"not",[[23,["confirmingForceRevoke"]]],null]],null]],null,{"statements":[[0,"          "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@onConfirmAction"],["toolbar-link","Revoke this?",[27,"concat",["All leases under this one will also be removed"],null],"Revoke",[27,"action",[[22,0,[]],"revokePrefix",[23,["baseKey","id"]]],null]]],{"statements":[[0,"\\n            Revoke prefix\\n          "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n\\n"],[4,"if",[[23,["model","meta","total"]]],null,{"statements":[[4,"each",[[23,["model"]]],null,{"statements":[[0,"    "],[4,"link-to",[[27,"if",[[22,1,["isFolder"]],"vault.cluster.access.leases.list","vault.cluster.access.leases.show"],null],[22,1,["id"]]],[["class"],["list-item-row"]],{"statements":[[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph"],[[27,"if",[[22,1,["isFolder"]],"folder-outline","file-outline"],null]]]],[7,"span"],[11,"class","has-text-weight-semibold"],[9],[1,[27,"or",[[22,1,["keyWithoutParent"]],[22,1,["id"]]],null],false],[10]],"parameters":[]},null],[0,"\\n"]],"parameters":[1]},{"statements":[[0,"    "],[5,"empty-state",[],[["@title"],[[28,["There are no leases matching \\"",[22,0,["filter"]],"\\""]]]]],[0,"\\n"]],"parameters":[]}]],"parameters":[]},{"statements":[[0,"  "],[5,"empty-state",[],[["@title"],[[22,0,["emptyTitle"]]]]],[0,"\\n"]],"parameters":[]}],[4,"if",[[27,"gt",[[23,["model","meta","lastPage"]],1],null]],null,{"statements":[[0,"  "],[1,[27,"list-pagination",null,[["page","lastPage","link","model"],[[23,["model","meta","currentPage"]],[23,["model","meta","lastPage"]],[27,"concat",["vault.cluster.access.leases.list",[27,"if",[[27,"not",[[23,["baseKey","id"]]],null],"-root"],null]],null],[27,"compact",[[27,"array",[[27,"if",[[23,["baseKey","id"]],[23,["baseKey","id"]]],null]],null]],null]]]],false],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/leases/list.hbs"}})}),define("vault/templates/vault/cluster/access/leases/show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"8kpIGZIy",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["top"]],[],[[],[]],{"statements":[[0,"\\n    "],[1,[27,"key-value-header",null,[["baseKey","path","root","showCurrent","linkToPaths"],[[23,["baseKey"]],"vault.cluster.access.leases.list",[23,["backendCrumb"]],true,[23,["capabilities","leases","canList"]]]]],false],[0,"\\n  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.leases"],null,{"statements":[[0,"        Leases\\n"]],"parameters":[]},null],[0,"    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n\\n"],[4,"if",[[23,["capabilities","revoke","canUpdate"]]],null,{"statements":[[0,"  "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n      "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@onConfirmAction"],["toolbar-link","Revoke this?",[27,"concat",["All leases under this one will also be removed"],null],"Confirm",[27,"action",[[22,0,[]],"revokeLease",[23,["model"]]],null]]],{"statements":[[0,"\\n        Revoke lease\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[7,"div"],[11,"class","field box is-fullwidth is-sideless is-paddingless is-marginless"],[9],[0,"\\n"],[4,"info-table-row",null,[["label","value"],["Issue time",[23,["model","issueTime"]]]],{"statements":[[0,"    "],[1,[27,"date-format",[[23,["model","issueTime"]],"MMM DD, YYYY hh:mm:ss A"],null],false],[0,"\\n    "],[7,"br"],[9],[10],[0,"\\n    "],[7,"code"],[9],[0,"\\n      "],[1,[23,["model","issueTime"]],false],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "],[1,[27,"info-table-row",null,[["label","value"],["Renewable",[23,["model","renewable"]]]]],false],[0,"\\n"],[4,"info-table-row",null,[["label","value"],["Last renewal",[23,["model","lastRenewal"]]]],{"statements":[[0,"    "],[1,[27,"date-format",[[23,["model","lastRenewal"]],"MMM DD, YYYY hh:mm:ss A"],null],false],[0,"\\n    "],[7,"br"],[9],[10],[0,"\\n    "],[7,"code"],[9],[0,"\\n      "],[1,[23,["model","lastRenewal"]],false],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]},null],[4,"if",[[23,["model","expireTime"]]],null,{"statements":[[4,"info-table-row",null,[["label","value"],["Expiration time",[23,["model","expireTime"]]]],{"statements":[[0,"      "],[1,[27,"date-format",[[23,["model","expireTime"]],"MMM DD, YYYY hh:mm:ss A"],null],false],[0,"\\n      "],[7,"br"],[9],[10],[0,"\\n      "],[7,"code"],[9],[0,"\\n        "],[1,[23,["model","expireTime"]],false],[0,"\\n      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"    "],[1,[27,"info-table-row",null,[["label","value"],["Expires in",[27,"date-from-now",[[23,["model","expireTime"]]],[["interval","hideSuffix"],[1000,true]]]]]],false],[0,"\\n"]],"parameters":[]},null],[0,"  "],[1,[27,"info-table-row",null,[["label","value"],["TTL",[23,["model","ttl"]]]]],false],[0,"\\n"],[10],[0,"\\n"],[4,"if",[[27,"and",[[27,"not",[[23,["model","isAuthLease"]]],null],[23,["model","renewable"]],[23,["capabilities","renew","canUpdate"]]],null]],null,{"statements":[[0,"  "],[7,"div"],[11,"class","box is-shadowless"],[9],[0,"\\n    "],[7,"h2"],[11,"class","title is-6"],[9],[0,"Renew Lease"],[10],[0,"\\n    "],[7,"form"],[3,"action",[[22,0,[]],"renewLease",[23,["model"]],[23,["interval"]]],[["on"],["submit"]]],[9],[0,"\\n      "],[1,[27,"ttl-picker",null,[["labelText","labelClass","onChange","outputSeconds"],["Interval","is-label",[27,"action",[[22,0,[]],[27,"mut",[[23,["interval"]]],null]],null],true]]],false],[0,"\\n      "],[7,"div"],[11,"class","field"],[9],[0,"\\n        "],[7,"div"],[11,"class","control"],[9],[0,"\\n          "],[7,"button"],[11,"class","button is-primary"],[11,"type","submit"],[9],[0,"\\n            Renew lease\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n  "],[10],[0,"\\n"]],"parameters":[]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/leases/show.hbs"}})}),define("vault/templates/vault/cluster/access/method/item/create",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"q4hVK6zR",block:'{"symbols":[],"statements":[[5,"generated-item",[],[["@model","@mode","@itemType"],[[21,"model"],"create",[23,["model","itemType"]]]]],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/method/item/create.hbs"}})}),define("vault/templates/vault/cluster/access/method/item/edit",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"2wZglZRG",block:'{"symbols":[],"statements":[[5,"generated-item",[],[["@model","@mode","@itemType"],[[21,"model"],"edit",[21,"itemType"]]]]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/method/item/edit.hbs"}})}),define("vault/templates/vault/cluster/access/method/item/list",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"OojSr7wy",block:'{"symbols":[],"statements":[[5,"generated-item-list",[],[["@model","@method","@itemType","@paths"],[[21,"model"],[21,"method"],[21,"itemType"],[21,"paths"]]]]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/method/item/list.hbs"}})}),define("vault/templates/vault/cluster/access/method/item/show",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"g6FljceQ",block:'{"symbols":[],"statements":[[5,"generated-item",[],[["@model","@itemType","@mode"],[[21,"model"],[21,"itemType"],"show"]]]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/method/item/show.hbs"}})}),define("vault/templates/vault/cluster/access/method/section",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"4oHipNQL",block:'{"symbols":["p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["top"]],[],[[],[]],{"statements":[[0,"\\n"],[4,"key-value-header",null,[["path"],["vault.cluster.access.methods"]],{"statements":[[0,"      "],[7,"li"],[9],[0,"\\n        "],[7,"span"],[11,"class","sep"],[9],[0,"\\n          /\\n        "],[10],[0,"\\n"],[4,"link-to",["vault.cluster.access.methods"],null,{"statements":[[0,"          methods\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n"]],"parameters":[]},null],[0,"  "]],"parameters":[]}],[0,"\\n  "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      "],[1,[23,["model","id"]],false],[0,"\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[1]}],[0,"\\n"],[1,[27,"section-tabs",[[23,["model"]],"authShow",[23,["paths"]]],null],false],[0,"\\n"],[4,"if",[[27,"eq",[[23,["section"]],"configuration"],null]],null,{"statements":[[0,"  "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n      "],[5,"toolbar-link",[],[["@params"],[[27,"array",["vault.cluster.settings.auth.configure",[23,["model","id"]]],null]]],{"statements":[[0,"\\n        Configure\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[1,[27,"component",[[27,"concat",["auth-method/",[23,["section"]]],null]],[["model"],[[23,["model"]]]]],false]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/method/section.hbs"}})}),define("vault/templates/vault/cluster/access/methods",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"hCnZeSs3",block:'{"symbols":["method","T","T","p"],"statements":[[5,"page-header",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,4,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Authentication Methods\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[4]}],[0,"\\n\\n"],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n  "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-link",[],[["@type","@params"],["add",[27,"array",["vault.cluster.settings.auth.enable"],null]]],{"statements":[[0,"\\n      Enable new method\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n"]],"parameters":[]}],[0,"\\n\\n"],[4,"each",[[27,"sort-by",["path",[23,["model"]]],null]],null,{"statements":[[4,"if",[[27,"eq",[[22,1,["methodType"]],"ldap"],null]],null,{"statements":[[0,"    "],[5,"linked-block",[[11,"class","list-item-row"]],[["@params"],[[27,"array",["vault.cluster.access.method",[22,1,["id"]]],null]]],{"statements":[[0,"\\n      "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n        "],[7,"div"],[11,"class","level-left"],[9],[0,"\\n          "],[7,"div"],[9],[0,"\\n            "],[5,"tool-tip",[],[["@horizontalPosition"],["left"]],{"statements":[[0,"\\n              "],[6,[22,3,["trigger"]],[],[[],[]],{"statements":[[0,"\\n                "],[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph","@size"],[[27,"if",[[27,"or",[[27,"find-by",["type",[22,1,["methodType"]],[27,"mountable-auth-methods",null,null]],null],[27,"eq",[[22,1,["methodType"]],"token"],null]],null],[22,1,["methodType"]],"auth"],null],"l"]]],[0,"\\n              "]],"parameters":[]}],[0,"\\n              "],[6,[22,3,["content"]],[],[["@class"],["tool-tip"]],{"statements":[[0,"\\n                "],[7,"div"],[11,"class","box"],[9],[0,"\\n                  "],[1,[22,1,["methodType"]],false],[0,"\\n                "],[10],[0,"\\n              "]],"parameters":[]}],[0,"\\n            "]],"parameters":[3]}],[0,"\\n            "],[7,"span"],[11,"class","has-text-weight-semibold has-text-black"],[9],[0,"\\n              "],[1,[22,1,["path"]],false],[0,"\\n            "],[10],[0,"\\n            "],[7,"br"],[9],[10],[0,"\\n            "],[7,"code"],[11,"class","has-text-grey is-size-8"],[9],[0,"\\n            "],[1,[22,1,["accessor"]],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","level-right is-flex is-paddingless is-marginless"],[9],[0,"\\n          "],[7,"div"],[11,"class","level-item"],[9],[0,"\\n"],[4,"popup-menu",null,[["name"],["auth-backend-nav"]],{"statements":[[0,"              "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n                "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n                  "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.method.section",[22,1,["id"]],"configuration"],null,{"statements":[[0,"                      View configuration\\n"]],"parameters":[]},null],[0,"                  "],[10],[0,"\\n"],[4,"if",[[22,1,["canEdit"]]],null,{"statements":[[0,"                    "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.settings.auth.configure",[22,1,["id"]]],null,{"statements":[[0,"                        Edit configuration\\n"]],"parameters":[]},null],[0,"                    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"if",[[27,"and",[[27,"not-eq",[[22,1,["methodType"]],"token"],null],[22,1,["canDisable"]]],null]],null,{"statements":[[0,"                    "],[7,"li"],[11,"class","action"],[9],[0,"\\n                      "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@onConfirmAction"],["link is-destroy","Disable method?","This may affect access to Vault data.","Disable",[27,"perform",[[23,["disableMethod"]],[22,1,[]]],null]]],{"statements":[[0,"\\n                        Disable\\n                      "]],"parameters":[]}],[0,"\\n                    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"                "],[10],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[0,"    "],[7,"div"],[11,"class","list-item-row"],[9],[0,"\\n      "],[7,"div"],[11,"class","level is-mobile"],[9],[0,"\\n        "],[7,"div"],[11,"class","level-left"],[9],[0,"\\n          "],[7,"div"],[9],[0,"\\n            "],[5,"tool-tip",[],[["@horizontalPosition"],["left"]],{"statements":[[0,"\\n              "],[6,[22,2,["trigger"]],[],[[],[]],{"statements":[[0,"\\n                "],[5,"icon",[[11,"class","has-text-grey-light"]],[["@glyph","@size"],[[27,"if",[[27,"or",[[27,"find-by",["type",[22,1,["methodType"]],[27,"mountable-auth-methods",null,null]],null],[27,"eq",[[22,1,["methodType"]],"token"],null]],null],[22,1,["methodType"]],"auth"],null],"l"]]],[0,"\\n              "]],"parameters":[]}],[0,"\\n              "],[6,[22,2,["content"]],[],[["@class"],["tool-tip"]],{"statements":[[0,"\\n                "],[7,"div"],[11,"class","box"],[9],[0,"\\n                  "],[1,[22,1,["methodType"]],false],[0,"\\n                "],[10],[0,"\\n              "]],"parameters":[]}],[0,"\\n            "]],"parameters":[2]}],[0,"\\n            "],[7,"span"],[11,"class","has-text-weight-semibold has-text-grey"],[9],[0,"\\n              "],[1,[22,1,["path"]],false],[0,"\\n            "],[10],[0,"\\n            "],[7,"br"],[9],[10],[0,"\\n            "],[7,"code"],[11,"class","has-text-grey is-size-8"],[9],[0,"\\n            "],[1,[22,1,["accessor"]],false],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n        "],[7,"div"],[11,"class","level-right is-flex is-paddingless is-marginless"],[9],[0,"\\n          "],[7,"div"],[11,"class","level-item"],[9],[0,"\\n"],[4,"popup-menu",null,[["name"],["auth-backend-nav"]],{"statements":[[0,"              "],[7,"nav"],[11,"class","menu"],[9],[0,"\\n                "],[7,"ul"],[11,"class","menu-list"],[9],[0,"\\n                  "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.method.section",[22,1,["id"]],"configuration"],null,{"statements":[[0,"                      View configuration\\n"]],"parameters":[]},null],[0,"                  "],[10],[0,"\\n"],[4,"if",[[22,1,["canEdit"]]],null,{"statements":[[0,"                    "],[7,"li"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.settings.auth.configure",[22,1,["id"]]],null,{"statements":[[0,"                        Edit configuration\\n"]],"parameters":[]},null],[0,"                    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"\\n"],[4,"if",[[27,"and",[[27,"not-eq",[[22,1,["methodType"]],"token"],null],[22,1,["canDisable"]]],null]],null,{"statements":[[0,"                    "],[7,"li"],[11,"class","action"],[9],[0,"\\n                      "],[5,"confirm-action",[],[["@buttonClasses","@confirmTitle","@confirmMessage","@confirmButtonText","@onConfirmAction"],["link is-destroy","Disable method?","This may affect access to Vault data.","Disable",[27,"perform",[[23,["disableMethod"]],[22,1,[]]],null]]],{"statements":[[0,"\\n                        Disable\\n                      "]],"parameters":[]}],[0,"\\n                    "],[10],[0,"\\n"]],"parameters":[]},null],[0,"                "],[10],[0,"\\n              "],[10],[0,"\\n"]],"parameters":[]},null],[0,"          "],[10],[0,"\\n        "],[10],[0,"\\n      "],[10],[0,"\\n    "],[10],[0,"\\n"]],"parameters":[]}]],"parameters":[1]},null]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/methods.hbs"}})}),define("vault/templates/vault/cluster/access/namespaces",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"Uz3QIUa3",block:'{"symbols":[],"statements":[[1,[21,"outlet"],false],[0,"\\n"]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/namespaces.hbs"}})}),define("vault/templates/vault/cluster/access/namespaces/create",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"I8bl+X0/",block:'{"symbols":["p"],"statements":[[4,"if",[[27,"has-feature",["Namespaces"],null]],null,{"statements":[[0,"  "],[5,"page-header",[],[[],[]],{"statements":[[0,"\\n    "],[6,[22,1,["top"]],[],[[],[]],{"statements":[[0,"\\n      "],[7,"div"],[11,"class","breadcrumb"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.access.namespaces.index"],null,{"statements":[[0,"          "],[7,"span"],[11,"class","sep"],[9],[0,"/"],[10],[0,"\\n          Namespaces\\n"]],"parameters":[]},null],[0,"      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n    "],[6,[22,1,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n      "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n        Create a Namespace\\n      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[1]}],[0,"\\n  "],[5,"edit-form",[],[["@model","@onSave","@cancelLinkParams"],[[21,"model"],[27,"action",[[22,0,[]],"onSave"],null],[27,"array",["vault.cluster.access.namespaces.index"],null]]]],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[5,"upgrade-page",[],[["@title","@minimumEdition"],["Namespaces","Vault Enterprise Pro"]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/namespaces/create.hbs"}})}),define("vault/templates/vault/cluster/access/namespaces/index",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"3QH4lW3S",block:'{"symbols":["list","Item","targetNamespace","p"],"statements":[[4,"if",[[27,"has-feature",["Namespaces"],null]],null,{"statements":[[0,"  "],[5,"page-header",[],[[],[]],{"statements":[[0,"\\n    "],[6,[22,4,["levelLeft"]],[],[[],[]],{"statements":[[0,"\\n      "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n        Namespaces\\n      "],[10],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[4]}],[0,"\\n\\n  "],[5,"toolbar",[],[[],[]],{"statements":[[0,"\\n    "],[5,"toolbar-actions",[],[[],[]],{"statements":[[0,"\\n      "],[5,"toolbar-link",[],[["@type","@params"],["add",[27,"array",["vault.cluster.access.namespaces.create"],null]]],{"statements":[[0,"\\n        Create namespace\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[]}],[0,"\\n  "]],"parameters":[]}],[0,"\\n\\n  "],[5,"list-view",[],[["@items","@itemNoun"],[[21,"model"],"namespace"]],{"statements":[[0,"\\n"],[4,"if",[[22,1,["empty"]]],null,{"statements":[[0,"      "],[6,[22,1,["empty"]],[],[[],[]],{"statements":[[0,"\\n"],[4,"link-to",["vault.cluster.access.namespaces.create"],null,{"statements":[[0,"          Create Namespace\\n"]],"parameters":[]},null],[0,"\\n        "],[5,"learn-link",[],[["@path"],["/vault/security/namespaces"]],{"statements":[[0,"\\n          Learn more\\n        "]],"parameters":[]}],[0,"\\n      "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},{"statements":[[0,"      "],[5,"list-item",[],[[],[]],{"statements":[[0,"\\n        "],[6,[22,2,["content"]],[],[[],[]],{"statements":[[0,"\\n          "],[1,[22,1,["item","id"]],false],[0,"\\n        "]],"parameters":[]}],[0,"\\n        "],[6,[22,2,["menu"]],[],[[],[]],{"statements":[[0,"\\n"],[4,"with",[[27,"concat",[[23,["currentNamespace"]],[27,"if",[[23,["currentNamespace"]],"/"],null],[22,1,["item","id"]]],null]],null,{"statements":[[4,"if",[[27,"contains",[[22,3,[]],[23,["accessibleNamespaces"]]],null]],null,{"statements":[[0,"              "],[7,"li"],[11,"class","action"],[9],[0,"\\n"],[4,"link-to",["vault.cluster.secrets",[27,"query-params",null,[["namespace"],[[22,3,[]]]]]],[["class"],["is-block"]],{"statements":[[0,"                  Switch to Namespace\\n"]],"parameters":[]},null],[0,"              "],[10],[0,"\\n"]],"parameters":[]},null]],"parameters":[3]},null],[0,"          "],[7,"li"],[11,"class","action"],[9],[0,"\\n            "],[5,"confirm-action",[],[["@buttonClasses","@confirmButtonText","@confirmMessage","@onConfirmAction"],["link is-destroy","Remove","Any engines or mounts in this namespace will also be removed.",[27,"action",[[22,0,[]],[27,"perform",[[22,2,["callMethod"]],"destroyRecord",[22,1,["item"]],[27,"concat",["Successfully deleted namespace: ",[22,1,["item","id"]]],null],"There was an error deleting this namespace: ",[27,"action",[[22,0,[]],"refreshNamespaceList"],null]],null]],null]]],{"statements":[[0,"\\n              Delete\\n            "]],"parameters":[]}],[0,"\\n          "],[10],[0,"\\n        "]],"parameters":[]}],[0,"\\n      "]],"parameters":[2]}],[0,"\\n"]],"parameters":[]}],[0,"  "]],"parameters":[1]}],[0,"\\n"]],"parameters":[]},{"statements":[[0,"  "],[5,"upgrade-page",[],[["@title","@minimumEdition"],["Namespaces","Vault Enterprise Pro"]]],[0,"\\n"]],"parameters":[]}]],"hasEval":false}',meta:{moduleName:"vault/templates/vault/cluster/access/namespaces/index.hbs"}})}),define("vault/templates/vault/cluster/auth",["exports"],function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=Ember.HTMLBars.template({id:"l5nl1p7p",block:'{"symbols":["Page"],"statements":[[5,"splash-page",[],[[],[]],{"statements":[[0,"\\n  "],[6,[22,1,["header"]],[],[[],[]],{"statements":[[0,"\\n    "],[7,"h1"],[11,"class","title is-3"],[9],[0,"\\n      Sign in to Vault\\n    "],[10],[0,"\\n  "]],"parameters":[]}],[0,"\\n"],[4,"if",[[27,"has-feature",["Namespaces"],null]],null,{"statements":[[0,"    "],[6,[22,1,["sub-header"]],[],[[],[]],{"statements":[[0,"\\n      "],[5,"toolbar",[[11,"class","toolbar-namespace-picker"]],[[],[]],{"statements":[[0,"\\n        "],[7,"div"],[11,"class","field is-horizontal"],[9],[0,"\\n          "],[7,"div"],[11,"class","field-label is-normal"],[9],[0,"\\n            "],[7,"label"],[11,"class","is-label"],[11,"for","namespace"],[9],[0,"Namespace"],[10],[0,"\\n          "],[10],[0,"\\n          "],[7,"div"],[11,"class","field-body"],[9],[0,"\\n            "],[7,"div"],[11,"class","field"],[9],[0,"\\n              "],[7,"div"],[11,"class","control"],[9],[0,"\\n                "],[7,"input"],[12,"value",[21,"namespaceQueryParam"]],[11,"placeholder","/ (Root)"],[12,"oninput",[27,"perform",[[23,["updateNamespace"]]],[["value"],["target.value"]]]],[11,"autocomplete","off"],[11,"spellcheck","false"],[11,"name","namespace"],[11,"id","namespace"],[11,"class","input"],[11,"type","text"],[9],[10],[0,"\\n              "],[10],[0,"\\n            "],[10],[0,"\\n          "],[10],[0,"\\n        "],[10],[0,"\\n      "]],"parameters":[]}],[0,"\\n    "]],"parameters":[]}],[0,"\\n"]],"parameters":[]},null],[0,"  "],[6,[22,1,["content"]],[],[[],[]],{"state