#ifndef SPY_SLOTS_H
#define SPY_SLOTS_H

#include <qobject.h>
#include <qlistbox.h>
#include <qstringlist.h>
#include <qstring.h>

class Spy;
	
class SpySlots : public QObject
{
	Q_OBJECT
	private:
		QStringList disabledControls;
		Spy *spy;
	
	public slots:
		void onCreateConfigDialog();
		void onApplyConfigDialog();

		void _Left();
		void _Right();
		void _Left2(QListBoxItem *item);
		void _Right2(QListBoxItem *item);
		void ifScanAll(bool toggled);
	public:
		SpySlots(QObject *parent=0, const char *name=0);
		~SpySlots();
		void registerDisabledControl(const QString &name);
		void unregisterDisabledControl(const QString &name);
};

#endif
