/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qgrid.h>

#include "spy_slots.h"
#include "debug.h"
#include "spy.h"
#include "config_dialog.h"
#include "userlist.h"

void SpySlots::onCreateConfigDialog()
{
	kdebugf();

	QListBox *e_availusers= ConfigDialog::getListBox("Spy", "available");
	QListBox *e_notifies= ConfigDialog::getListBox("Spy", "track");
	for (UserList::ConstIterator i = userlist.begin(); i != userlist.end(); ++i)
	{
		if ((*i).uin())
		{
			std::vector<UinType>::iterator it = find(spy->tracked.begin(), spy->tracked.end(), (*i).uin());
			if (it == spy->tracked.end())
				e_availusers->insertItem((*i).altNick());
			else
				e_notifies->insertItem((*i).altNick());
		}
	}

	e_availusers->sort();
	e_notifies->sort();
	e_availusers->setSelectionMode(QListBox::Extended);
	e_notifies->setSelectionMode(QListBox::Extended);

	QCheckBox *b_notifyall= ConfigDialog::getCheckBox("Spy", "Scan all contacts");
	QGrid *panebox = ConfigDialog::getGrid("Spy","listboxy");

	if (config_file.readBoolEntry("Spy", "ScanAll"))
		panebox->setEnabled(false);

	connect(b_notifyall, SIGNAL(toggled(bool)), this, SLOT(ifScanAll(bool)));
	
	for (QStringList::iterator it=disabledControls.begin(); it!=disabledControls.end(); ++it)
	{
		ConfigDialog::getCheckBox("Spy", " ", *it)->setDisabled(true);
		ConfigDialog::getCheckBox("Spy", " ", *it)->setDown(true);
	}

	kdebugf2();
}

void SpySlots::onApplyConfigDialog()
{
	kdebugf();
	QListBox *e_notifies= ConfigDialog::getListBox("Spy", "track");

	std::vector<UinType> oldTracked(spy->tracked);
	spy->tracked.clear();
		
	for (size_t i = 0; i < e_notifies->count(); ++i)
	{
		UinType uin = userlist.byAltNick(e_notifies->text(i)).uin();
		spy->trackedAdd(uin);
		
		std::vector<UinType>::iterator it = find(oldTracked.begin(), oldTracked.end(), uin);
		if (it == oldTracked.end())
		{
			// Dodany do listy śledzonych, a więc skanujemy od razu
			spy->checkInvisibleStatus(uin);
		}
	}
	
	// Teraz sprawdzamy kto został usunięty z listy śledzonych i zmieniamy
	// jego stan na niedostępny.
	for (size_t i = 0; i < oldTracked.size(); ++i)
	{
		if (!spy->isTracked(oldTracked[i]))
		{
			if (userlist.containsUin(oldTracked[i]))
			{
				UserListElement ule = userlist.byUin(oldTracked[i]);
				if (ule.status().isInvisible())
				{
					ule.status().setOffline(ule.status().description());
					userlist.changeUserInfo(ule.altNick(), ule);
				}			
			}
		}
	}
	spy->saveTrackedList();
	
	// Ustawiamy nowy czas zegara
	spy->timerCheck->stop();
	spy->timerCheck->start(1000 * 60 *
		config_file.readNumEntry("Spy", "ScanTime", 5));
	kdebugf2();
}

SpySlots::SpySlots(QObject *parent, const char *name) : QObject(parent, name)
{
	kdebugf();
	spy = dynamic_cast<Spy *>(parent);
	kdebugf2();
}

SpySlots::~SpySlots()
{
	kdebugf();
	kdebugf2();
}

void SpySlots::registerDisabledControl(const QString &name)
{
	kdebugf();
	disabledControls.append(name);
	kdebugf2();
}

void SpySlots::unregisterDisabledControl(const QString &name)
{
	kdebugf();
	disabledControls.remove(name);
	kdebugf2();
}

void SpySlots::ifScanAll(bool toggled)
{
	kdebugf();
	ConfigDialog::getGrid("Spy","listboxy")->setEnabled(!toggled);
	kdebugf2();
}

void SpySlots::_Left2(QListBoxItem *)
{
	_Left();
}

void SpySlots::_Right2(QListBoxItem *)
{
	_Right();
}

void SpySlots::_Left(void)
{
	kdebugf();
	QListBox *e_availusers= ConfigDialog::getListBox("Spy", "available");
	QListBox *e_notifies= ConfigDialog::getListBox("Spy", "track");
	QStringList tomove;
	unsigned int i;

	for(i=0; i<e_notifies->count(); ++i)
		if (e_notifies->isSelected(i))
			tomove+=e_notifies->text(i);

	for(i=0; i<tomove.size(); ++i)
	{
		e_availusers->insertItem(tomove[i]);
		e_notifies->removeItem(e_notifies->index(e_notifies->findItem(tomove[i])));
	}

	e_availusers->sort();
	kdebugf2();
}

void SpySlots::_Right(void)
{
	kdebugf();
	QListBox *e_availusers= ConfigDialog::getListBox("Spy", "available");
	QListBox *e_notifies= ConfigDialog::getListBox("Spy", "track");
	QStringList tomove;
	unsigned int i;

	for(i=0; i<e_availusers->count(); ++i)
		if (e_availusers->isSelected(i))
			tomove+=e_availusers->text(i);

	for(i=0; i<tomove.size(); ++i)
	{
		e_notifies->insertItem(tomove[i]);
		e_availusers->removeItem(e_availusers->index(e_availusers->findItem(tomove[i])));
	}

	e_notifies->sort();
	kdebugf2();
}
