/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
Copyright (C) 2005 by 
Pan Wojtas (Wojtek Sulewski)
wojteksulewski <_at_> op.pl
gg: 2087202
*/

#include "spy_list.h"
#include "userinfo.h"
#include "chat.h"
#include "modules/notify/notify.h"

SpyList::SpyList(void): QDialog (0, "", FALSE)
{
	kdebugf();

	SearchUnknown = new SearchRecord;
	SearchUnknown->clearData();

// informacja
	qgrp1 = new QGroupBox(3, Qt::Vertical, tr("Info"), this);
	l_1 = new QLabel(tr("The list of users, which have you on their lists and you don't have them on your list."), qgrp1);
	l_2 = new QLabel(tr("If the list is empty, you can try again later - the module needs some time to find users!"), qgrp1);
	l_3 = new QLabel(tr("If the list is still empty, probably there are no such persons ;)") + "\n", qgrp1);

// lista
	results = new QListView(this);
	results->addColumn(tr("Last seen"));
	results->addColumn(tr("Status"));
	results->addColumn(tr("Uin"));
	results->addColumn(tr("Name"));
	results->addColumn(tr("City"));
	results->addColumn(tr("Nickname"));
	results->addColumn(tr("Birth year"));
	results->setAllColumnsShowFocus(true);
	// resize w whoHasMeOnList() !
	// dzięki temu nie pojawia się czasami niepotrzebny poziomy scroll


	connect(results, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(chatButtonClicked()));

// rozmowa
	b_chat = new QPushButton("&" + tr("Chat"),this);
	connect(b_chat, SIGNAL(clicked()), this, SLOT(chatButtonClicked()));
// dodaj osobę
	b_addbtn = new QPushButton("&" + tr("Add User"),this);
	connect(b_addbtn, SIGNAL(clicked()), this, SLOT(addButtonClicked()));
// usuń z listy
	b_remove = new QPushButton("&" + tr("Remove from list"),this);
	connect(b_remove, SIGNAL(clicked()), this, SLOT(removeButtonClicked()));

	
	grid = new QGridLayout (this, 7, 12, 3, 3);
	grid->addMultiCellWidget(qgrp1, 1, 1, 0, 11);
	grid->addMultiCellWidget(results, 2, 2, 0, 11);
	grid->addMultiCellWidget(b_chat, 3, 3, 0, 2);
	grid->addMultiCellWidget(b_addbtn, 3, 3, 4, 7);
	grid->addMultiCellWidget(b_remove, 3, 3, 8, 11);

	grid->addColSpacing(2, 10);
	grid->addColSpacing(5, 10);
	grid->addColSpacing(9, 10);
	
	resize(650,330);
	setCaption(tr("Unknown users"));

	kdebugf2();
}

SpyList::~SpyList(void)
{
	kdebugf();

// FIXME: nie jestem pewien, czy te wszystkie delete są na pewno potrzebne
// ale chyba tak, bo okienko nie ma flagi Qt::WDestructiveClose
	delete SearchUnknown;
	delete l_1;
	delete l_2;
	delete l_3;
	delete results;
	delete b_chat;
	delete b_addbtn;
	delete b_remove;
	delete grid;

	kdebugf2();
}

void SpyList::chatButtonClicked()
{
	kdebugf();
	QListViewItem *selected = results->selectedItem();
	if (!selected && results->childCount() == 1)
		selected = results->firstChild();
	if (!selected)
	{
		kdebugf2();
		return;
	}

	QString uin = selected->text(2);
	UinsList uins((UinType)uin.toInt());

	chat_manager->openChat(uins);
	kdebugf2();
}

void SpyList::removeButtonClicked(void)
{
	QListViewItem *selected = results->selectedItem();
	if (!selected && results->childCount() == 1)
		selected = results->firstChild();
	if (!selected)
	{
		QMessageBox::information(this,tr("Add User"),
			tr("Select user first"));
		return;
	}
	
	bool ok;
	unsigned int uin_int = selected->text(2).toInt(&ok, 10);
	if (ok)
	{
		FOREACH(it, Unknowns)
		{
			if ((*it).uin == uin_int)
			{
				Unknowns.remove(it);
				break;
			}
		}
	}

	delete selected;
	saveUnknownsList2File();
}

void SpyList::addButtonClicked(void)
{
/**

	kopiuj-wklej z search.cpp:

**/
	kdebugf();
	QListViewItem *selected = results->selectedItem();
	if (!selected && results->childCount() == 1)
		selected = results->firstChild();
	if (!selected)
	{
		QMessageBox::information(this,tr("Add User"),
			tr("Select user first"));
		return;
	}

	QString uin = selected->text(2);
	QString firstname = selected->text(3);
	QString nickname = selected->text(5);

	// Build altnick. Try user nick first.
	QString altnick = nickname;
	// If nick is empty, try firstname+lastname.
	if (!altnick.length())
	{
		altnick = firstname;
	}
	// If nick is empty, use uin.
	if (!altnick.length())
		altnick = uin;

	UserInfo *ui = new UserInfo(QString::null, true, 0, "user info");
	UserListElement e;
	bool ok;
	e.setFirstName(firstname);
	e.setLastName("");
	e.setNickName(nickname);
	e.setAltNick(altnick);
	e.setUin(uin.toUInt(&ok));
	if (!ok)
		e.setUin(0);
	e.setGroup("");
	e.setEmail("");
	ui->setUserInfo(e);
	ui->show();

	kdebugf2();
}


void SpyList::loadUnknownsFromFile(void)
{
	results->clear();
	QFile list_file;
	list_file.setName(QString(ggPath("spy-unknownslist").ascii()));
	if (list_file.open(IO_ReadOnly))
	{
		QTextStream stream(&list_file);

		bool ok;
		while (!stream.atEnd())
		{
			List user;
			
			QString line = stream.readLine();	// line of text excluding '\n'
			QStringList l_line = QStringList::split(",", line);	// linia wygląda w ten sposób: "uin [uinType],data [QString]"

			QStringList::ConstIterator i = l_line.begin();
			int uin_int = (*i).toInt(&ok, 10);	// zamienia QStringa na inta, 10 to system dziesiętny ;)
			if (!ok)
				kdebugm(KDEBUG_PANIC, "nie udao się zamienić QString na int");
			++i;
			
			
			user.uin = uin_int;
			user.date = (*i);
			user.new_one = false;
			Unknowns.append(user);
		}
		list_file.close();
	}
}

void SpyList::saveUnknownsList2File(void)
{
	QFile list_file;
	list_file.setName(QString(ggPath("spy-unknownslist").ascii()));

	list_file.remove();
	if (list_file.open(IO_WriteOnly))
	{
		QTextStream stream(&list_file);
		FOREACH(it, Unknowns)
		{
			stream << (*it).uin << "," << (*it).date << endl;
		}
		list_file.close();
	
	}
}

void SpyList::searchUser(UinType uin)
{
	QString str_uin;
	str_uin.sprintf("%d", uin);
	SearchUnknown->reqUin(str_uin);

	gadu->searchNextInPubdir(*SearchUnknown);
}

void SpyList::userStatusChangeIgnored(UinType uin)
{
	bool IsOnList = false;
	FOREACH(it, Unknowns)
	{
		if ((*it).uin == uin)
		{
			(*it).date = QDate::currentDate().toString(Qt::ISODate).ascii();	// jeśli jest na liście, to aktualizuje datę
			IsOnList = true;
			(*it).new_one = false;			// na wszelki wypadek
			break;
		}
	}
	if (!IsOnList)			// jeśli nie ma na liście, to dodaje
	{
		List user;
		user.uin = uin;
		user.date = QDate::currentDate().toString(Qt::ISODate).ascii();
		user.new_one = true;
		Unknowns.append(user);
	}
	
	searchUser(uin);
}


void SpyList::newSearchResults(SearchResults& searchResults, int seq, int fromUin)
{
	kdebugf();

	QListViewItem *qlv = NULL;
	QPixmap pix;

	if (seq != SearchUnknown->Seq)
		return;

	SearchUnknown->FromUin = fromUin;

	CONST_FOREACH(searchIterator, searchResults)
	{
		qlv = results->findItem((*searchIterator).Uin, 2);

		pix = ((*searchIterator).Stat).pixmap((*searchIterator).Stat.status(), false, false);
		
		bool ok;
		unsigned int uin_int = (*searchIterator).Uin.toInt(&ok, 10);
		if (!ok)
			kdebugm(KDEBUG_PANIC, "nie udało się zamienić QString na int");

		if (qlv)
		{
			FOREACH(it, Unknowns)
			{
				if ((*it).uin == uin_int)
				{
					qlv->setText(0, (*it).date);	// data - kiedy ostatnio był widziany
					break;
				}
			}
			qlv->setText(2, (*searchIterator).Uin);
			qlv->setText(3, (*searchIterator).First);
			qlv->setText(4, (*searchIterator).City);
			qlv->setText(5, (*searchIterator).Nick);
			qlv->setText(6, (*searchIterator).Born);
		} else
		{
			QString date;
			bool new_one;
			FOREACH(it, Unknowns)
			{
				if ((*it).uin == uin_int)
				{
					date = (*it).date;		// data - kiedy ostatnio był widziany
					new_one = (*it).new_one;
					(*it).new_one = false;
					break;
				}
			}
			qlv = new QListViewItem(results, date, QString::null, (*searchIterator).Uin,
				(*searchIterator).First, (*searchIterator).City,
				(*searchIterator).Nick, (*searchIterator).Born);
			qlv->setPixmap(1, pix);
			qlv = NULL;
			
			if (new_one)					// jeśli jest to nowa osoba, wyświetla hintek z informacją, że znalazł kogoś nowego
			{
				QMap<QString,QVariant> parms;
				parms["Pixmap"] = icons_manager.loadIcon(dataPath("kadu/modules/data/spy/spy32.png"));
				parms["ShowSource"] = bool(FALSE);
				UserListElement user;
				user.setUin(uin_int);
				notify->emitMessage(QString::null, QString::null, " " + (*searchIterator).Uin + tr(" - <b>%1</b> has you on his list!")
					.arg(QStyleSheet::escape((*searchIterator).First)), &parms, &user);
			}
		}
	}
	kdebugf2();
}

void SpyList::whoHasMeOnList()
{
	results->setResizeMode(QListView::LastColumn);
	show();		// działa, tylko nie rozumiem dlaczego ;)
	
}
