#ifndef SPY_H
#define SPY_H

#include <vector>
#include <map>
#include <fstream>
#include <qobject.h>
#include "kadu.h"
#include "spy_slots.h"
#include "spy_list.h"


class Spy : public QObject
{
    Q_OBJECT
		QTimer *timerConnected, *timerCheck, *timerInvisible;
	
		// Lista osób obecnie ukrytych, sprawdzanych czy nie stali się niedostępni.
		std::vector<UinType> invisible;
		
		// Lista osób, które wtyczka ma sprawdzać.
		std::vector<UinType> tracked;

		// Lista osób, którym wysłano pakiet i czekamy na odpowiedź.
		std::vector<UinType> sent;
	
		SpySlots *spy_slots;
	
		/* Zmienia określa czy minęło < 10 sek. od połączenia z serwerem.
		 * Jeżeli jest prawdziwa, to ignorujemy zmiany statusu na niedostępny
		 * oraz żadania wysłania obrazka, bo są to wiadomości zakolejkowane z serwera.
		 */
		bool rightAfterConnection;
	
		int checkInvisibleStatus (UinType uin, bool forceCheck = false);
		void unsetInvisible ();
		void createGUI ();	
		void destroyGUI ();
		void loadTrackedList ();
		void saveTrackedList ();
		bool isTracked (UinType uin);
		bool isOnTrackedList (UinType uin);
		bool isChattingWith (const UinsList& uins);
		bool isChattingWith (UinType uin);
		void notifyAboutScanning(UinType uin);
		bool isOnSentList(UinType uin);
		
		SpyList *spy_list;
	private slots:
		void scanUser();
		void checkNow();
	
	public:
		Spy();
		~Spy();

		void trackedRemove (UinType uin);
		void trackedAdd (UinType uin);
	public slots:
		void imageRequestReceived (UinType sender, uint32_t size, uint32_t crc32);
		void userStatusChanged (const UserListElement &, const UserStatus &oldStatus, bool onConnection = false);
		void connected ();
		void check ();
		void clearInvisible ();
		void messageFiltering (const UinsList& senders,QCString& msg, QByteArray& formats,bool& stop);
		void popupMenu ();

	
	friend class SpySlots;
};

#endif
