/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
    Author:
    Przemysław Sowa
    przemyslaw_sowa@o2.pl

    ChangeLog:

        [v0.0.1]
            * First version.
		
		Changes moved to ChangeLog file.
*/
#include <cassert>
#include <iostream>
#include <limits>
#include <qmessagebox.h>
#include <qdatetime.h>
#include "config_file.h"
#include "config_dialog.h"
#include "debug.h"
#include "misc.h"
#include "chat.h"
#include "history.h"
#include "message_box.h"
#include "pending_msgs.h"
#include <modules/notify/notify.h>


#include "spy.h"

#define MODULE_SPY_VERSION 0.0.7
#define TRACKED_LIST_FILE "spy-trackedlist"
#define FAKE_SIZE 20
#define FAKE_CRC32 4567

Spy *spy_module;

extern "C" int spy_init()
{
	kdebugf();

	spy_module = new Spy();
	return 0;

	kdebugf2();
}

extern "C" void spy_close()
{
	kdebugf();

	delete spy_module;

	kdebugf2();
}

Spy::Spy()
 : timerConnected(0), timerCheck(0), timerInvisible(0),
 rightAfterConnection(false)
{
	kdebugf();

	connect(gadu, SIGNAL(imageRequestReceived(UinType, uint32_t, uint32_t)), this, SLOT(imageRequestReceived(UinType, uint32_t, uint32_t)));
	connect(gadu, SIGNAL(userStatusChanged(const UserListElement&, const UserStatus&, bool)), this, SLOT(userStatusChanged(const UserListElement&, const UserStatus&, bool)));
	connect(gadu, SIGNAL(connected()), this, SLOT(connected()));
	connect(gadu, SIGNAL(messageFiltering (const UinsList&, QCString&, QByteArray&, bool&)), this, SLOT(messageFiltering (const UinsList&, QCString&, QByteArray&, bool&)));

// Zegar, który co ScanTime min sprawdza ukrytych i niedostępnych czy nie
// zmienili stanu.
	timerCheck = new QTimer();
	connect(timerCheck, SIGNAL(timeout()), this, SLOT(check()));
	timerCheck->start(1000 * 60 * config_file.readNumEntry("Spy", "ScanTime", 5));

	loadTrackedList();
	createGUI();

// Jżeli jesteśmy online, to od razu sprawdzamy czy ktoś jest ukryty.
// FIXME: zmieniłem z if (gadu->status().isOnline() || gadu->status().isBusy() || gadu->status().isInvisible())
	if (!gadu->status().isOffline())
		check();


// lista osób, które mają nas na swoich listach, a my ich nie
	spy_list = new SpyList();
	connect(gadu, SIGNAL(newSearchResults(SearchResults &, int, int)), spy_list, SLOT(newSearchResults(SearchResults &, int, int)));
	// osoba, której nie mamy na liście zmieniła status	
	connect(gadu, SIGNAL(userStatusChangeIgnored(UinType)), spy_list, SLOT(userStatusChangeIgnored(UinType)));
	spy_list->loadUnknownsFromFile();

	if (!gadu->status().isOffline())		// jeśli jesteśmy już połączeni w czasie ładowania modułu
	{
		FOREACH(it, spy_list->Unknowns)
		{
			spy_list->searchUser((*it).uin);		// szuka uinu
		}
	}

	// nowa pozycja w menu głównym
	QPopupMenu *MainMenu = kadu->mainMenu();
	int index = MainMenu->indexOf(kadu->personalInfoMenuId) + 5;
	MainMenu->insertItem(tr("Who has me on list?"), spy_list, SLOT(whoHasMeOnList()), 0, -1, index);
	
	
	spy_list->userStatusChangeIgnored(666);
	spy_list->userStatusChangeIgnored(23456);

	kdebugf2();
}

Spy::~Spy()
{
	kdebugf();
	spy_list->saveUnknownsList2File();

	disconnect(gadu, SIGNAL(newSearchResults(SearchResults &, int, int)), spy_list, SLOT(newSearchResults(SearchResults &, int, int)));
	disconnect(gadu, SIGNAL(userStatusChangeIgnored(UinType)), spy_list, SLOT(userStatusChangeIgnored(UinType)));

	disconnect(gadu, SIGNAL(messageFiltering (const UinsList&, QCString&, QByteArray&, bool&)), this, SLOT(messageFiltering (const UinsList&, QCString&, QByteArray&, bool&)));
	disconnect(gadu,  SIGNAL(imageRequestReceived(UinType, uint32_t, uint32_t)), this, SLOT(imageRequestReceived(UinType, uint32_t, uint32_t)));
	disconnect(gadu, SIGNAL(userStatusChanged(const UserListElement&, const UserStatus&, bool)), this, SLOT(userStatusChanged(const UserListElement&, const UserStatus&, bool)));
	disconnect(gadu, SIGNAL(connected()), this, SLOT(connected()));

	if (timerConnected)
	{
		disconnect(timerConnected, SIGNAL(timeout()), this, SLOT(connected()));
		delete timerConnected;
	}
	if (timerInvisible)
	{
		disconnect(timerInvisible, SIGNAL(timeout()), this, SLOT(clearInvisible()));
		delete timerInvisible;
	}

	disconnect(timerCheck, SIGNAL(timeout()), this, SLOT(check()));
	delete timerCheck;
	delete spy_list;

	unsetInvisible();
	destroyGUI();
	saveTrackedList();

// usuwa "Who has me on list?" z głównego menu kadu
	QPopupMenu *MainMenu = kadu->mainMenu();
	int index = MainMenu->indexOf(kadu->personalInfoMenuId) + 5;
	MainMenu->removeItemAt(index);

	kdebugf2();
}

// Ta funkcja wysyła specjalny pakiet, na który jeżeli otrzymamy odpowiedź,
// tzn że dana osoba jest ukryta.
int Spy::checkInvisibleStatus(UinType uin, bool forceCheck)
{
	kdebugf();

	if (!userlist.containsUin(uin) || gadu->status().isOffline()
		|| (config_file.readNumEntry("General", "UIN") == uin))
	{
		kdebugf2();
		return 1;
	}
	
	UserListElement ule = userlist.byUin(uin);
	if ((!isTracked(uin) || isOnSentList(uin)) && !forceCheck)
	{
		kdebugm(KDEBUG_INFO, "Nie sprawdzam: %s\n", userlist.byUin(uin).altNick().ascii());
		kdebugf2();
		return 1;
	}
	
	sent.push_back(uin);

	kdebugm(KDEBUG_INFO, "Sprawdzam: %s\n", userlist.byUin(uin).altNick().ascii());

    struct gg_msg_richtext_format_img
	{
		struct gg_msg_richtext rt;
		struct gg_msg_richtext_format f;
		struct gg_msg_richtext_image image;
	} msg;

	msg.rt.flag = 2;
	msg.rt.length = 13;
	msg.f.position = 0;
	msg.f.font = 0x80;
	msg.image.unknown1 = 0x0109;
	msg.image.size = FAKE_SIZE;
	msg.image.crc32 = FAKE_CRC32;
	
	UinsList ulist;
	ulist.push_back(uin); 
	int ret = gadu->sendMessageRichText(ulist, "", (unsigned char *)&msg, sizeof(msg));

	kdebugf2();
	return ret;
}

// Obsługa odbioru pakietu od osób ukrytych.
void Spy::imageRequestReceived(UinType sender, uint32_t size, uint32_t crc32)
{
	kdebugf();

	if (size == FAKE_SIZE && crc32 == FAKE_CRC32 && !rightAfterConnection)
	{
		// Usuwamy element reprezentujący ten numer GG z listy osób ukrytych do sprawdzenia.
		std::vector<UinType>::iterator iter = std::find(invisible.begin(), invisible.end(), sender);
		if (iter != invisible.end())
			invisible.erase(iter);

		iter = std::find(sent.begin(), sent.end(), sender);
		if (iter != sent.end())
			sent.erase(iter);

		if (!userlist.containsUin(sender))
		{
			kdebugf2();
			return;
		}
		
		UserListElement ule = userlist.byUin(sender);
		if (!ule.status().isOffline())
		{
			kdebugf2();
			return;
		}
		
		kdebugm(KDEBUG_INFO, "%s jest ukryty!\n", userlist.byUin(sender).altNick().ascii());
		
		UserStatus oldStatus = ule.status();
		ule.status().setInvisible(ule.status().description());
// FIXME: zamieniłem kolejność changeUserInfo -> notify
		notify->userStatusChanged(ule, oldStatus, false);
		userlist.changeUserInfo(ule.altNick(), ule);
		
		if (isChattingWith (sender))
			chat_manager->refreshTitlesForUin (sender);

		history.appendStatus(sender, ule.status());
	}
	
	kdebugf2();
}

// Jeżeli ktoś zmienił stan na "niedostępny" to sprawdzamy czy się  nie ukrył.
void Spy::userStatusChanged(const UserListElement &user, const UserStatus &oldStatus, bool onConnection)
{
	kdebugf();
	kdebugm(KDEBUG_INFO, "userStatusChanged\n");
// FIXME: zmieniłem z if (user.status().isOffline() && !oldStatus.isOffline() && !rightAfterConnection)
// wg mnie nie powoduje to żadnych nieprzyjemności - a sprawdza osoby, które zmieniły status np. z niedostępny na niedostępny z opisem
// checkInvisibleStatus sprawdza, czy to nie jestemy my, więc chyba nie ma problemu...
	if (user.status().isOffline() && !rightAfterConnection)
	{
		checkInvisibleStatus(user.uin());
	}
	kdebugf2();
}

// Po uzyskaniu połączenia odczekujemy X sek i skanujemy ludzi.
void Spy::connected ()
{
	kdebugf();

	// to samo jest w konstruktorze i tutaj, bo w momencie ładowania modułu możemy być już połączeni lub nie.
	FOREACH(it, spy_list->Unknowns)
	{
		spy_list->searchUser((*it).uin);		// szuka uinu i dodaje go do listy
	}

	if (!timerConnected)
	{
		rightAfterConnection = true;
		timerConnected = new QTimer();
		timerConnected->start(1000 *config_file.readNumEntry("Spy", "ConnectionTime", 15));
		connect(timerConnected, SIGNAL(timeout()), this, SLOT(connected()));
	}
	else
	{
		rightAfterConnection = false;
		disconnect(timerConnected, SIGNAL(timeout()), this, SLOT(connected()));
		delete timerConnected;
		timerConnected = NULL;
		check();
	}
	kdebugf2();
}

// Funkcja wywoływana przez zegar co 5 min lub z konstruktora klasy.
// Sprawdza wszystkie osoby ukryte i niedostępne. Na początku tworzy wektora
// osób ukrytych, których status jest w funkcji clearInvisible() zmieniany na
// niedostępny jeżeli nie odpowiedzą w ciagu 15 sek.
void Spy::check ()
{
	kdebugf();
	invisible.clear();

	for (UserList::ConstIterator i = userlist.begin(); i != userlist.end(); ++i)
	{
		if ((*i).status().isInvisible())
		{
			invisible.push_back((*i).uin());
			checkInvisibleStatus((*i).uin());
		}
		else if ((*i).status().isOffline())
			checkInvisibleStatus((*i).uin());
	}
	
	// Tworzymy zegar, który po ReplyTime sek. sprawdzi czy obecnie ukryci nadal
	// odpowiadają.
	if (!timerInvisible)
	{
		timerInvisible = new QTimer();
		timerInvisible->start(1000 * config_file.readNumEntry("Spy", "ReplyTime", 15));
		connect(timerInvisible, SIGNAL(timeout()), this, SLOT(clearInvisible()));
	}
	kdebugf2();
}

// Funkcja wywoływana przez QTimer timerInvisible po ReplyTime sek. od czasu
// rozpoczęcia skanowania osób ukrytych i niedostępnych. Zmienia status
// wszystkich osób z wektora invisible na niedostępny, bo jeżeli ktoś jest
// na tej liście to znaczy, że nie odpowiedział.
void Spy::clearInvisible()
{
	kdebugf();

	disconnect(timerInvisible, SIGNAL(timeout()), this, SLOT(clearInvisible()));
	delete timerInvisible;
	timerInvisible = NULL;
	
	for (size_t i = 0; i < invisible.size(); i++)
	{
		if (!userlist.containsUin(invisible[i]) ||
			(config_file.readNumEntry("General", "UIN") == invisible[i]))
			continue;
		
		UserListElement ule = userlist.byUin(invisible[i]);
		if (ule.status().isInvisible())
		{
			UserStatus oldStatus = ule.status();
			ule.status().setOffline(ule.status().description());
// FIXME: zamieniłem kolejność changeUserInfo -> notify
			notify->userStatusChanged(ule, oldStatus, false);
			userlist.changeUserInfo(ule.altNick(), ule);
				
			if (isChattingWith (invisible[i]))
				chat_manager->refreshTitlesForUin (invisible[i]);
			
			history.appendStatus(invisible[i], ule.status());
		}
	}
	invisible.clear();
	
	kdebugf2();
}

// Funkcja wywoływana w destruktorze. Zmienia status ukrytych na "niedostępny"
// przy wyłączaniu wtyczki.


void Spy::unsetInvisible()
{
	kdebugf();
	UserList::Iterator i = userlist.begin();
	while (i != userlist.end())
	{
		if ((*i).status().isInvisible())
		{
			UserList::Iterator j = i; j++;
			UserStatus oldStatus = (*i).status();
			(*i).status().setOffline((*i).status().description());
			notify->userStatusChanged(*i, oldStatus, false);
			userlist.changeUserInfo((*i).altNick(), (*i));
			i = j;
		}
		else
			i++;
	}
	kdebugf2();
}

// Ta funkcja przechwytuje wszystkie wiadomości, zanim zaczną być przetwarzane.
// Jej zadaniem jest wychwycenie ew. skanowania przez inny moduł spy i
// udzielenie lub nie udzielenie odpowiedzi w zależności od ustawień, oraz
// zapobieżenie wyświetleniu okienka z klepsydrą.

void Spy::messageFiltering (const UinsList& senders ,QCString& msg, QByteArray& formats, bool& stop)
{
	kdebugf();

	// Interesują nas jedynie wiadomości z samymi obrazkami.
	if (formats.size() != 13)
	{
		kdebugm(KDEBUG_INFO, "formats.size() != 13\n");
		kdebugf2();
		return;
	}
	
	char *cformats = static_cast<char *>(formats.data());
	
	struct gg_msg_richtext_format *actformat = 
		reinterpret_cast<struct gg_msg_richtext_format *>(cformats);	
			
	if (!(actformat->font & (~GG_FONT_IMAGE)))
	{
		kdebugm(KDEBUG_INFO, "(!(actformat->font & (~GG_FONT_IMAGE))) = true\n");
		cformats += sizeof(gg_msg_richtext_format);
	}
	if (actformat->font & GG_FONT_IMAGE)
	{
		kdebugm(KDEBUG_INFO, "(actformat->font & GG_FONT_IMAGE) = true\n");
		
		struct gg_msg_richtext_image *actimage = (struct gg_msg_richtext_image*)(cformats);

		kdebugm(KDEBUG_INFO, "Obrazek: rozmiar = %u, crc32 = %u\n", actimage->size, actimage->crc32);
		
		if (actimage->size == FAKE_SIZE && actimage->crc32 == FAKE_CRC32)
		{
			// Niezależnie od konfiguracji nie pokazujemy klepsydr przy skanowaniu
			stop = true;
			
			// Jeżeli nie jesteśmy ukryci, to znaczy, że jest to stare skanowanie
			// zakolejkowane na serwerze.
			if (gadu->status().isInvisible() && !rightAfterConnection)
			{
				if (!userlist.containsUin(senders[0]))
					userlist.addAnonymous(senders[0]);
				
				UserListElement ule = userlist.byUin(senders[0]);
				UinsList ulist; ulist.append(ule.uin());
				
				notifyAboutScanning(senders[0]);
				
				if (!config_file.readBoolEntry("Spy", "DontAllowScanningMe"))
					gadu->sendImageRequest(senders[0], actimage->size, actimage->crc32);
			}
		}
	}

	kdebugf2();
}

void Spy::trackedRemove(UinType uin)
{
	kdebugf();

	std::vector<UinType>::iterator it = find(tracked.begin(), tracked.end(), uin);
	if (it != tracked.end())
		tracked.erase(it);
	
	kdebugf2();
}

void Spy::trackedAdd(UinType uin)
{
	kdebugf();

	std::vector<UinType>::iterator it = find(tracked.begin(), tracked.end(), uin);
	if (it == tracked.end())
		tracked.push_back(uin);
	
	kdebugf2();
}

void Spy::popupMenu ()
{
	kdebugf();

	UserList users;
	UserBox *activeUserBox = UserBox::getActiveUserBox();
	if (activeUserBox == NULL)
	{
		return;
	}

	users = activeUserBox->getSelectedUsers();
	int scanuser = UserBox::userboxmenu->getItem(tr("Scan user"));
	int checknow = UserBox::userboxmenu->getItem(tr("Check now"));
	unsigned int OurUin = config_file.readNumEntry("General", "UIN");

	// Jeżeli to jesteśmy my lub kontakt SMS (bez numerka GG) - szary
	if (users.containsUin(OurUin) || users.containsUin(0))	// uin 0 ma osoba bez numeru
	{
		UserBox::userboxmenu->setItemEnabled(scanuser, false);
		UserBox::userboxmenu->setItemEnabled(checknow, false);
	}

	FOREACH(i, users)
	{
		if (isOnTrackedList((*i).uin()))
		{
			UserBox::userboxmenu->setItemChecked(scanuser, true);
			break;
		}
	}

	kdebugf2();
}

////////////////////////////////////////////////////////////////////////////////
// Funkcje prywatne
////////////////////////////////////////////////////////////////////////////////

void Spy::createGUI()
{
	kdebugf();
	
	ConfigDialog::addTab(QT_TRANSLATE_NOOP("@default", "Spy"), dataPath("kadu/modules/data/spy/spy32.png"));

	ConfigDialog::addCheckBox("Spy", "Spy",
		QT_TRANSLATE_NOOP("@default", "Scan all contacts"), "ScanAll", false);

	ConfigDialog::addGrid("Spy", "Spy" ,"listboxy",3);

		ConfigDialog::addGrid("Spy", "listboxy", "listbox1", 1);
			ConfigDialog::addLabel("Spy", "listbox1", QT_TRANSLATE_NOOP("@default", "Available"));
			ConfigDialog::addListBox("Spy", "listbox1","available");

		ConfigDialog::addGrid("Spy", "listboxy", "listbox2", 1);
			ConfigDialog::addPushButton("Spy", "listbox2", "", "AddToNotifyList","","forward");
			ConfigDialog::addPushButton("Spy", "listbox2", "", "RemoveFromNotifyList","","back");

		ConfigDialog::addGrid("Spy", "listboxy", "listbox3", 1);
			ConfigDialog::addLabel("Spy", "listbox3", QT_TRANSLATE_NOOP("@default", "Tracked"));
			ConfigDialog::addListBox("Spy", "listbox3", "track");

	ConfigDialog::addVGroupBox("Spy", "Spy", QT_TRANSLATE_NOOP("@default", "Anti-spy"));			
	
	ConfigDialog::addCheckBox("Spy", "Anti-spy",
		QT_TRANSLATE_NOOP("@default", "Don't allow others see when I am hidden"), "DontAllowScanningMe", false);

	ConfigDialog::addCheckBox("Spy", "Anti-spy",
		QT_TRANSLATE_NOOP("@default", "Notify when someone scans me"), "NotifyAboutScanningMe", false);

	// Zaawansowane
	ConfigDialog::addVGroupBox("Spy", "Spy", QT_TRANSLATE_NOOP("@default", "Advanced"));
	ConfigDialog::addLabel("Spy", "Advanced", 
		QT_TRANSLATE_NOOP("@default", "Don't change this values unless you know what they mean."));	
	ConfigDialog::addSpinBox("Spy", "Advanced", 
		QT_TRANSLATE_NOOP("@default", "Scan every (min) "), "ScanTime", 1, 60, 1, 5);
	ConfigDialog::addSpinBox("Spy", "Advanced", 
		QT_TRANSLATE_NOOP("@default", "Wait for reply for (sec) "), "ReplyTime", 10, 120, 1, 15);
	ConfigDialog::addSpinBox("Spy", "Advanced", 
		QT_TRANSLATE_NOOP("@default", "After connection wait for (sec) "), "ConnectionTime", 10, 120, 1, 15);
		
	spy_slots = new SpySlots(this, "spy_slots");
	
	ConfigDialog::connectSlot("Spy", "", SIGNAL(clicked()), spy_slots, SLOT(_Right()), "forward");
	ConfigDialog::connectSlot("Spy", "", SIGNAL(clicked()), spy_slots, SLOT(_Left()), "back");
	ConfigDialog::connectSlot("Spy", "available", SIGNAL(doubleClicked(QListBoxItem *)),
		spy_slots, SLOT(_Right2(QListBoxItem *)));
	ConfigDialog::connectSlot("Spy", "track", SIGNAL(doubleClicked(QListBoxItem *)),
		spy_slots, SLOT(_Left2(QListBoxItem *)));

	ConfigDialog::registerSlotOnCreate(spy_slots, SLOT(onCreateConfigDialog()));
	ConfigDialog::registerSlotOnApply(spy_slots, SLOT(onApplyConfigDialog()));

	// Dodaj element do menu na liście kontaktów
	int pos = UserBox::userboxmenu->indexOf(
		UserBox::userboxmenu->getItem(tr("Offline to user")));
		
	if (pos == -1)
	{
		// Nie udało się pobrać pozycji menu, pewnie zawiodło tłumaczenie.
		// JAK TO ZROBIĆ?
		pos = 8; // przypisz stałą i dodaj menu.
	}
	
	UserBox::userboxmenu->addItemAtPos(pos + 1, "ScanContact", tr("Scan user"), this, SLOT(scanUser()));
	UserBox::userboxmenu->addItemAtPos(pos + 2, "CheckNow", tr("Check now"), this, SLOT(checkNow()));

	connect(UserBox::userboxmenu, SIGNAL(popup()), this, SLOT(popupMenu()));
	
	kdebugf2();
}

void Spy::destroyGUI()
{
	kdebugf();
	
	disconnect(UserBox::userboxmenu, SIGNAL(popup()), this, SLOT(popupMenu()));
	
	// Usuń element z menu
	int pos = UserBox::userboxmenu->getItem(tr("Scan user"));
	UserBox::userboxmenu->removeItem(pos);
	pos = UserBox::userboxmenu->getItem(tr("Check now"));
	UserBox::userboxmenu->removeItem(pos);
	
	ConfigDialog::disconnectSlot("Spy", "", SIGNAL(clicked()), spy_slots, SLOT(_Right()), "forward");
	ConfigDialog::disconnectSlot("Spy", "", SIGNAL(clicked()), spy_slots, SLOT(_Left()), "back");
	ConfigDialog::disconnectSlot("Spy", "available", SIGNAL(doubleClicked(QListBoxItem *)),
		spy_slots, SLOT(_Right2(QListBoxItem *)));
	ConfigDialog::disconnectSlot("Spy", "track", SIGNAL(doubleClicked(QListBoxItem *)),
		spy_slots, SLOT(_Left2(QListBoxItem *)));

	ConfigDialog::unregisterSlotOnCreate(spy_slots, SLOT(onCreateConfigDialog()));
	ConfigDialog::unregisterSlotOnApply(spy_slots, SLOT(onApplyConfigDialog()));

	delete spy_slots;
	spy_slots = NULL;

	ConfigDialog::removeControl("Spy", QT_TRANSLATE_NOOP("@default", "Don't change this values unless you know what they mean."));
	ConfigDialog::removeControl("Spy", "Scan every (min) ");
	ConfigDialog::removeControl("Spy", "Wait for reply for (sec) ");
	ConfigDialog::removeControl("Spy", "After connection wait for (sec) ");
	ConfigDialog::removeControl("Spy", "Advanced");
	
	ConfigDialog::removeControl("Spy", "Notify when someone scans me");
	ConfigDialog::removeControl("Spy", "Don't allow others see when I am hidden");
	ConfigDialog::removeControl("Spy", "Anti-spy");
	
	ConfigDialog::removeControl("Spy", "track");
	ConfigDialog::removeControl("Spy", "Tracked");
	ConfigDialog::removeControl("Spy", "listbox3");
	ConfigDialog::removeControl("Spy", "", "back");
	ConfigDialog::removeControl("Spy", "", "forward");
	ConfigDialog::removeControl("Spy", "listbox2");
	ConfigDialog::removeControl("Spy", "available");
	ConfigDialog::removeControl("Spy", "Available");
	ConfigDialog::removeControl("Spy", "listbox1");
	ConfigDialog::removeControl("Spy", "listboxy");

	ConfigDialog::removeControl("Spy", "Scan all contacts");
	ConfigDialog::removeTab("Spy");
	
	kdebugf2();
}

void Spy::loadTrackedList()
{
	kdebugf();
	
	std::ifstream ifs(ggPath(TRACKED_LIST_FILE).ascii());
	if (!ifs.is_open())
	{
		kdebugf2();
		return;
	}
	
	while (!ifs.eof())
	{
		UinType uin;
		ifs >> uin;
		if (ifs)
			tracked.push_back(uin);
	}
	ifs.close();
	
	kdebugf2();
}


void Spy::saveTrackedList()
{
	kdebugf();
	
	std::ofstream ofs(ggPath(TRACKED_LIST_FILE).ascii());
	if (!ofs.is_open())
	{
		kdebugm(KDEBUG_ERROR, "Nie można otworzyć pliku ~/%s\n", TRACKED_LIST_FILE);
		kdebugf2();
		return;
	}
	
	for (size_t i = 0; i < tracked.size(); i++)
		ofs << tracked[i] << '\n';
	ofs.close();
	
	kdebugf2();
}

bool Spy::isTracked (UinType uin)
{
	kdebugf();

	if (config_file.readBoolEntry("Spy", "ScanAll"))
	{
		kdebugf2();
		return true;
	}

	kdebugf2();	
	return isOnTrackedList (uin);
}

bool Spy::isOnTrackedList (UinType uin)
{
	kdebugf();

	std::vector<UinType>::iterator it = find(tracked.begin(), tracked.end(), uin);
	if (it != tracked.end())
	{
		kdebugf2();
		return true;
	}
	
	kdebugf2();
	return false;
}


void Spy::scanUser()
{
	kdebugf();
	
	UserList users;
	UserBox *activeUserBox = UserBox::getActiveUserBox();
	if (activeUserBox == NULL)
	{
		return;
	}
	users = activeUserBox->getSelectedUsers();
	
	bool remove_all_from_tracked = false;

	FOREACH(i, users)
	{
		if (isOnTrackedList((*i).uin()))
		{
			remove_all_from_tracked = true;
			break;			// wystarczy, że znajdzie jednego
		}
	}

	if (remove_all_from_tracked)
	{
		UserList::Iterator i = users.begin();
		while (i != users.end())
		{
			UserListElement puser = userlist.byAltNick((*i).altNick());
			trackedRemove(puser.uin());
			if (puser.status().isInvisible())
			{
				UserList::Iterator j = i; j++;
				
				UserStatus oldStatus = puser.status();
				puser.status().setOffline(puser.status().description());
				notify->userStatusChanged(puser, oldStatus, false);
				userlist.changeUserInfo(puser.altNick(), puser);
				
				i = j;
			}
			else
				i++;
		}
	} else
	{
		FOREACH(i, users)
		{
			trackedAdd((*i).uin());
			if ((*i).status().isOffline())
				checkInvisibleStatus((*i).uin());
		}
	}

	kdebugf2();
}

void Spy::checkNow()
{
	kdebugf();

	UserBox *activeUserBox = UserBox::getActiveUserBox();
	if (activeUserBox == NULL)
	{
		kdebugf2();
		return;
	}
	UserListElement puser = userlist.byAltNick((*activeUserBox->getSelectedUsers().begin()).altNick());
	checkInvisibleStatus(puser.uin(), true);

	kdebugf2();
}


bool Spy::isChattingWith (const UinsList& uins)
{
	kdebugf();
	kdebugf2();
	return chat_manager->findChatByUins (uins);
}

bool Spy::isChattingWith (UinType uin)
{
	kdebugf();
	UinsList ulist;
	ulist.push_back (uin); 
	kdebugf2();
	return isChattingWith (ulist);
}

void Spy::notifyAboutScanning(UinType uin)
{
	kdebugf();
	if (!config_file.readBoolEntry("Spy", "NotifyAboutScanningMe") || rightAfterConnection)
	{
		kdebugf2();
		return;
	}
	
//	UinsList ulist;
//	ulist.push_back(uin);
	
	if (userlist.containsUin(uin))
	{
		UserListElement ule = userlist.byUin(uin);
/*		notify->emitMessage(tr("<b>%1</b> is checking if you are hidden")
			.arg(QStyleSheet::escape(ule.altNick())),
			ule.status().pixmap(),
			config_file.readFontEntry("Hints", "HintMessage_font"),
			config_file.readColorEntry("Hints", "HintMessage_fgcolor"),
			config_file.readColorEntry("Hints", "HintMessage_bgcolor"),
			config_file.readUnsignedNumEntry("Hints", "HintMessage_timeout"), ulist);
*/	
/*
		hint_manager->addHint(tr("<b>%1</b> is checking if you are hidden")
			.arg(QStyleSheet::escape(ule.altNick())),
			ule.status().pixmap(),
			config_file.readFontEntry("Hints", "HintMessage_font"),
			config_file.readColorEntry("Hints", "HintMessage_fgcolor"),
			config_file.readColorEntry("Hints", "HintMessage_bgcolor"),
			config_file.readUnsignedNumEntry("Hints", "HintMessage_timeout"), ulist);
*/
// FIXME: zmieniłem jako notify + ikonka spy + otwieranie okna rozmowy po kliknięciu (UserListElement user) - zależnie od opcji w dymkach...
		QMap<QString,QVariant> parms;
		parms["Pixmap"] = icons_manager.loadIcon(dataPath("kadu/modules/data/spy/spy32.png"));
		parms["ShowSource"] = bool(FALSE);
		UserListElement user;
		user.setUin(uin);
		notify->emitMessage(QString::null, QString::null, " " + tr("<b>%1</b> is checking if you are hidden").arg(QStyleSheet::escape(ule.altNick())), &parms, &user);

	}
	
	kdebugf2();
}

bool Spy::isOnSentList(UinType uin)
{
	kdebugf();

	std::vector<UinType>::iterator it = find(sent.begin(), sent.end(), uin);
	if (it != sent.end())
	{
		kdebugf2();
		return true;
	}
	
	kdebugf2();
	return false;
}
