// Code generated by protoc-gen-go. DO NOT EDIT.
// source: commands/board.proto

package commands

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type BoardDetailsReq struct {
	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The fully qualified board name of the board you want information about
	// (e.g., `arduino:avr:uno`).
	Fqbn                 string   `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoardDetailsReq) Reset()         { *m = BoardDetailsReq{} }
func (m *BoardDetailsReq) String() string { return proto.CompactTextString(m) }
func (*BoardDetailsReq) ProtoMessage()    {}
func (*BoardDetailsReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{0}
}

func (m *BoardDetailsReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoardDetailsReq.Unmarshal(m, b)
}
func (m *BoardDetailsReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoardDetailsReq.Marshal(b, m, deterministic)
}
func (m *BoardDetailsReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoardDetailsReq.Merge(m, src)
}
func (m *BoardDetailsReq) XXX_Size() int {
	return xxx_messageInfo_BoardDetailsReq.Size(m)
}
func (m *BoardDetailsReq) XXX_DiscardUnknown() {
	xxx_messageInfo_BoardDetailsReq.DiscardUnknown(m)
}

var xxx_messageInfo_BoardDetailsReq proto.InternalMessageInfo

func (m *BoardDetailsReq) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *BoardDetailsReq) GetFqbn() string {
	if m != nil {
		return m.Fqbn
	}
	return ""
}

type BoardDetailsResp struct {
	// The fully qualified board name of the board.
	Fqbn string `protobuf:"bytes,1,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// Name used to identify the board to humans (e.g., Arduino/Genuino Uno).
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Installed version of the board's platform.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// The board ID component of the FQBN (e.g., `uno`).
	PropertiesId string `protobuf:"bytes,4,opt,name=propertiesId,proto3" json:"propertiesId,omitempty"`
	// Board alias that can be used as a more user friendly alternative to the
	// FQBN.
	Alias string `protobuf:"bytes,5,opt,name=alias,proto3" json:"alias,omitempty"`
	// Whether this is an official or 3rd party board.
	Official bool `protobuf:"varint,6,opt,name=official,proto3" json:"official,omitempty"`
	// URL of the board's pinout documentation.
	Pinout string `protobuf:"bytes,7,opt,name=pinout,proto3" json:"pinout,omitempty"`
	// Data about the package that contains the board's platform.
	Package *Package `protobuf:"bytes,8,opt,name=package,proto3" json:"package,omitempty"`
	// Data about the board's platform.
	Platform *BoardPlatform `protobuf:"bytes,9,opt,name=platform,proto3" json:"platform,omitempty"`
	// Tool dependencies of the board.
	ToolsDependencies []*ToolsDependencies `protobuf:"bytes,10,rep,name=toolsDependencies,proto3" json:"toolsDependencies,omitempty"`
	// The board's custom configuration options.
	ConfigOptions []*ConfigOption `protobuf:"bytes,11,rep,name=config_options,json=configOptions,proto3" json:"config_options,omitempty"`
	// Identifying information for the board (e.g., USB VID/PID).
	IdentificationPref   []*IdentificationPref `protobuf:"bytes,12,rep,name=identification_pref,json=identificationPref,proto3" json:"identification_pref,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BoardDetailsResp) Reset()         { *m = BoardDetailsResp{} }
func (m *BoardDetailsResp) String() string { return proto.CompactTextString(m) }
func (*BoardDetailsResp) ProtoMessage()    {}
func (*BoardDetailsResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{1}
}

func (m *BoardDetailsResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoardDetailsResp.Unmarshal(m, b)
}
func (m *BoardDetailsResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoardDetailsResp.Marshal(b, m, deterministic)
}
func (m *BoardDetailsResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoardDetailsResp.Merge(m, src)
}
func (m *BoardDetailsResp) XXX_Size() int {
	return xxx_messageInfo_BoardDetailsResp.Size(m)
}
func (m *BoardDetailsResp) XXX_DiscardUnknown() {
	xxx_messageInfo_BoardDetailsResp.DiscardUnknown(m)
}

var xxx_messageInfo_BoardDetailsResp proto.InternalMessageInfo

func (m *BoardDetailsResp) GetFqbn() string {
	if m != nil {
		return m.Fqbn
	}
	return ""
}

func (m *BoardDetailsResp) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BoardDetailsResp) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *BoardDetailsResp) GetPropertiesId() string {
	if m != nil {
		return m.PropertiesId
	}
	return ""
}

func (m *BoardDetailsResp) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *BoardDetailsResp) GetOfficial() bool {
	if m != nil {
		return m.Official
	}
	return false
}

func (m *BoardDetailsResp) GetPinout() string {
	if m != nil {
		return m.Pinout
	}
	return ""
}

func (m *BoardDetailsResp) GetPackage() *Package {
	if m != nil {
		return m.Package
	}
	return nil
}

func (m *BoardDetailsResp) GetPlatform() *BoardPlatform {
	if m != nil {
		return m.Platform
	}
	return nil
}

func (m *BoardDetailsResp) GetToolsDependencies() []*ToolsDependencies {
	if m != nil {
		return m.ToolsDependencies
	}
	return nil
}

func (m *BoardDetailsResp) GetConfigOptions() []*ConfigOption {
	if m != nil {
		return m.ConfigOptions
	}
	return nil
}

func (m *BoardDetailsResp) GetIdentificationPref() []*IdentificationPref {
	if m != nil {
		return m.IdentificationPref
	}
	return nil
}

type IdentificationPref struct {
	// Identifying information for USB-connected boards.
	UsbID                *USBID   `protobuf:"bytes,1,opt,name=usbID,proto3" json:"usbID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IdentificationPref) Reset()         { *m = IdentificationPref{} }
func (m *IdentificationPref) String() string { return proto.CompactTextString(m) }
func (*IdentificationPref) ProtoMessage()    {}
func (*IdentificationPref) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{2}
}

func (m *IdentificationPref) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IdentificationPref.Unmarshal(m, b)
}
func (m *IdentificationPref) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IdentificationPref.Marshal(b, m, deterministic)
}
func (m *IdentificationPref) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IdentificationPref.Merge(m, src)
}
func (m *IdentificationPref) XXX_Size() int {
	return xxx_messageInfo_IdentificationPref.Size(m)
}
func (m *IdentificationPref) XXX_DiscardUnknown() {
	xxx_messageInfo_IdentificationPref.DiscardUnknown(m)
}

var xxx_messageInfo_IdentificationPref proto.InternalMessageInfo

func (m *IdentificationPref) GetUsbID() *USBID {
	if m != nil {
		return m.UsbID
	}
	return nil
}

type USBID struct {
	// USB vendor ID.
	VID string `protobuf:"bytes,1,opt,name=VID,proto3" json:"VID,omitempty"`
	// USB product ID.
	PID                  string   `protobuf:"bytes,2,opt,name=PID,proto3" json:"PID,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *USBID) Reset()         { *m = USBID{} }
func (m *USBID) String() string { return proto.CompactTextString(m) }
func (*USBID) ProtoMessage()    {}
func (*USBID) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{3}
}

func (m *USBID) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_USBID.Unmarshal(m, b)
}
func (m *USBID) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_USBID.Marshal(b, m, deterministic)
}
func (m *USBID) XXX_Merge(src proto.Message) {
	xxx_messageInfo_USBID.Merge(m, src)
}
func (m *USBID) XXX_Size() int {
	return xxx_messageInfo_USBID.Size(m)
}
func (m *USBID) XXX_DiscardUnknown() {
	xxx_messageInfo_USBID.DiscardUnknown(m)
}

var xxx_messageInfo_USBID proto.InternalMessageInfo

func (m *USBID) GetVID() string {
	if m != nil {
		return m.VID
	}
	return ""
}

func (m *USBID) GetPID() string {
	if m != nil {
		return m.PID
	}
	return ""
}

type Package struct {
	// Maintainer of the package.
	Maintainer string `protobuf:"bytes,1,opt,name=maintainer,proto3" json:"maintainer,omitempty"`
	// The URL of the platforms index file
	// (e.g., https://downloads.arduino.cc/packages/package_index.json).
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// A URL provided by the package author, intended to point to their website.
	WebsiteURL string `protobuf:"bytes,3,opt,name=websiteURL,proto3" json:"websiteURL,omitempty"`
	// Email address of the package maintainer.
	Email string `protobuf:"bytes,4,opt,name=email,proto3" json:"email,omitempty"`
	// Package vendor name.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Resources for getting help about using the package.
	Help                 *Help    `protobuf:"bytes,6,opt,name=help,proto3" json:"help,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Package) Reset()         { *m = Package{} }
func (m *Package) String() string { return proto.CompactTextString(m) }
func (*Package) ProtoMessage()    {}
func (*Package) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{4}
}

func (m *Package) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Package.Unmarshal(m, b)
}
func (m *Package) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Package.Marshal(b, m, deterministic)
}
func (m *Package) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Package.Merge(m, src)
}
func (m *Package) XXX_Size() int {
	return xxx_messageInfo_Package.Size(m)
}
func (m *Package) XXX_DiscardUnknown() {
	xxx_messageInfo_Package.DiscardUnknown(m)
}

var xxx_messageInfo_Package proto.InternalMessageInfo

func (m *Package) GetMaintainer() string {
	if m != nil {
		return m.Maintainer
	}
	return ""
}

func (m *Package) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Package) GetWebsiteURL() string {
	if m != nil {
		return m.WebsiteURL
	}
	return ""
}

func (m *Package) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *Package) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Package) GetHelp() *Help {
	if m != nil {
		return m.Help
	}
	return nil
}

type Help struct {
	// URL for getting online help.
	Online               string   `protobuf:"bytes,1,opt,name=online,proto3" json:"online,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Help) Reset()         { *m = Help{} }
func (m *Help) String() string { return proto.CompactTextString(m) }
func (*Help) ProtoMessage()    {}
func (*Help) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{5}
}

func (m *Help) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Help.Unmarshal(m, b)
}
func (m *Help) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Help.Marshal(b, m, deterministic)
}
func (m *Help) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Help.Merge(m, src)
}
func (m *Help) XXX_Size() int {
	return xxx_messageInfo_Help.Size(m)
}
func (m *Help) XXX_DiscardUnknown() {
	xxx_messageInfo_Help.DiscardUnknown(m)
}

var xxx_messageInfo_Help proto.InternalMessageInfo

func (m *Help) GetOnline() string {
	if m != nil {
		return m.Online
	}
	return ""
}

type BoardPlatform struct {
	// Architecture of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,1,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Category of the platform. Set to `Contributed` for 3rd party platforms.
	Category string `protobuf:"bytes,2,opt,name=category,proto3" json:"category,omitempty"`
	// Download URL of the platform archive file.
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// File name of the platform archive.
	ArchiveFileName string `protobuf:"bytes,4,opt,name=archiveFileName,proto3" json:"archiveFileName,omitempty"`
	// Checksum of the platform archive.
	Checksum string `protobuf:"bytes,5,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// File size of the platform archive.
	Size int64 `protobuf:"varint,6,opt,name=size,proto3" json:"size,omitempty"`
	// Name used to identify the platform to humans.
	Name                 string   `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoardPlatform) Reset()         { *m = BoardPlatform{} }
func (m *BoardPlatform) String() string { return proto.CompactTextString(m) }
func (*BoardPlatform) ProtoMessage()    {}
func (*BoardPlatform) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{6}
}

func (m *BoardPlatform) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoardPlatform.Unmarshal(m, b)
}
func (m *BoardPlatform) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoardPlatform.Marshal(b, m, deterministic)
}
func (m *BoardPlatform) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoardPlatform.Merge(m, src)
}
func (m *BoardPlatform) XXX_Size() int {
	return xxx_messageInfo_BoardPlatform.Size(m)
}
func (m *BoardPlatform) XXX_DiscardUnknown() {
	xxx_messageInfo_BoardPlatform.DiscardUnknown(m)
}

var xxx_messageInfo_BoardPlatform proto.InternalMessageInfo

func (m *BoardPlatform) GetArchitecture() string {
	if m != nil {
		return m.Architecture
	}
	return ""
}

func (m *BoardPlatform) GetCategory() string {
	if m != nil {
		return m.Category
	}
	return ""
}

func (m *BoardPlatform) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *BoardPlatform) GetArchiveFileName() string {
	if m != nil {
		return m.ArchiveFileName
	}
	return ""
}

func (m *BoardPlatform) GetChecksum() string {
	if m != nil {
		return m.Checksum
	}
	return ""
}

func (m *BoardPlatform) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *BoardPlatform) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type ToolsDependencies struct {
	// Vendor name of the package containing the tool definition.
	Packager string `protobuf:"bytes,1,opt,name=packager,proto3" json:"packager,omitempty"`
	// Tool name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Tool version.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Data for the operating system-specific builds of the tool.
	Systems              []*Systems `protobuf:"bytes,4,rep,name=systems,proto3" json:"systems,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ToolsDependencies) Reset()         { *m = ToolsDependencies{} }
func (m *ToolsDependencies) String() string { return proto.CompactTextString(m) }
func (*ToolsDependencies) ProtoMessage()    {}
func (*ToolsDependencies) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{7}
}

func (m *ToolsDependencies) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ToolsDependencies.Unmarshal(m, b)
}
func (m *ToolsDependencies) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ToolsDependencies.Marshal(b, m, deterministic)
}
func (m *ToolsDependencies) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ToolsDependencies.Merge(m, src)
}
func (m *ToolsDependencies) XXX_Size() int {
	return xxx_messageInfo_ToolsDependencies.Size(m)
}
func (m *ToolsDependencies) XXX_DiscardUnknown() {
	xxx_messageInfo_ToolsDependencies.DiscardUnknown(m)
}

var xxx_messageInfo_ToolsDependencies proto.InternalMessageInfo

func (m *ToolsDependencies) GetPackager() string {
	if m != nil {
		return m.Packager
	}
	return ""
}

func (m *ToolsDependencies) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ToolsDependencies) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ToolsDependencies) GetSystems() []*Systems {
	if m != nil {
		return m.Systems
	}
	return nil
}

type Systems struct {
	// Checksum of the tool archive.
	Checksum string `protobuf:"bytes,1,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// Operating system identifier.
	Host string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	// File name of the tool archive.
	ArchiveFileName string `protobuf:"bytes,3,opt,name=archiveFileName,proto3" json:"archiveFileName,omitempty"`
	// Download URL of the tool archive.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
	// File size of the tool archive.
	Size                 int64    `protobuf:"varint,5,opt,name=size,proto3" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Systems) Reset()         { *m = Systems{} }
func (m *Systems) String() string { return proto.CompactTextString(m) }
func (*Systems) ProtoMessage()    {}
func (*Systems) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{8}
}

func (m *Systems) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Systems.Unmarshal(m, b)
}
func (m *Systems) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Systems.Marshal(b, m, deterministic)
}
func (m *Systems) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Systems.Merge(m, src)
}
func (m *Systems) XXX_Size() int {
	return xxx_messageInfo_Systems.Size(m)
}
func (m *Systems) XXX_DiscardUnknown() {
	xxx_messageInfo_Systems.DiscardUnknown(m)
}

var xxx_messageInfo_Systems proto.InternalMessageInfo

func (m *Systems) GetChecksum() string {
	if m != nil {
		return m.Checksum
	}
	return ""
}

func (m *Systems) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Systems) GetArchiveFileName() string {
	if m != nil {
		return m.ArchiveFileName
	}
	return ""
}

func (m *Systems) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Systems) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type ConfigOption struct {
	// ID of the configuration option. For identifying the option to machines.
	Option string `protobuf:"bytes,1,opt,name=option,proto3" json:"option,omitempty"`
	// Name of the configuration option for identifying the option to humans.
	OptionLabel string `protobuf:"bytes,2,opt,name=option_label,json=optionLabel,proto3" json:"option_label,omitempty"`
	// Possible values of the configuration option.
	Values               []*ConfigValue `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ConfigOption) Reset()         { *m = ConfigOption{} }
func (m *ConfigOption) String() string { return proto.CompactTextString(m) }
func (*ConfigOption) ProtoMessage()    {}
func (*ConfigOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{9}
}

func (m *ConfigOption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigOption.Unmarshal(m, b)
}
func (m *ConfigOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigOption.Marshal(b, m, deterministic)
}
func (m *ConfigOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigOption.Merge(m, src)
}
func (m *ConfigOption) XXX_Size() int {
	return xxx_messageInfo_ConfigOption.Size(m)
}
func (m *ConfigOption) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigOption.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigOption proto.InternalMessageInfo

func (m *ConfigOption) GetOption() string {
	if m != nil {
		return m.Option
	}
	return ""
}

func (m *ConfigOption) GetOptionLabel() string {
	if m != nil {
		return m.OptionLabel
	}
	return ""
}

func (m *ConfigOption) GetValues() []*ConfigValue {
	if m != nil {
		return m.Values
	}
	return nil
}

type ConfigValue struct {
	// The configuration option value.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Label to identify the configuration option to humans.
	ValueLabel string `protobuf:"bytes,2,opt,name=value_label,json=valueLabel,proto3" json:"value_label,omitempty"`
	// Whether the configuration option is selected.
	Selected             bool     `protobuf:"varint,3,opt,name=selected,proto3" json:"selected,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigValue) Reset()         { *m = ConfigValue{} }
func (m *ConfigValue) String() string { return proto.CompactTextString(m) }
func (*ConfigValue) ProtoMessage()    {}
func (*ConfigValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{10}
}

func (m *ConfigValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigValue.Unmarshal(m, b)
}
func (m *ConfigValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigValue.Marshal(b, m, deterministic)
}
func (m *ConfigValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigValue.Merge(m, src)
}
func (m *ConfigValue) XXX_Size() int {
	return xxx_messageInfo_ConfigValue.Size(m)
}
func (m *ConfigValue) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigValue.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigValue proto.InternalMessageInfo

func (m *ConfigValue) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *ConfigValue) GetValueLabel() string {
	if m != nil {
		return m.ValueLabel
	}
	return ""
}

func (m *ConfigValue) GetSelected() bool {
	if m != nil {
		return m.Selected
	}
	return false
}

type BoardAttachReq struct {
	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The board's URI (e.g., /dev/ttyACM0).
	BoardUri string `protobuf:"bytes,2,opt,name=board_uri,json=boardUri,proto3" json:"board_uri,omitempty"`
	// Path of the sketch to attach the board to. The board attachment
	// metadata will be saved to `{sketch_path}/sketch.json`.
	SketchPath string `protobuf:"bytes,3,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
	// Duration in seconds to search the given URI for a connected board before
	// timing out. The default value is 5 seconds.
	SearchTimeout        string   `protobuf:"bytes,4,opt,name=search_timeout,json=searchTimeout,proto3" json:"search_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoardAttachReq) Reset()         { *m = BoardAttachReq{} }
func (m *BoardAttachReq) String() string { return proto.CompactTextString(m) }
func (*BoardAttachReq) ProtoMessage()    {}
func (*BoardAttachReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{11}
}

func (m *BoardAttachReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoardAttachReq.Unmarshal(m, b)
}
func (m *BoardAttachReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoardAttachReq.Marshal(b, m, deterministic)
}
func (m *BoardAttachReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoardAttachReq.Merge(m, src)
}
func (m *BoardAttachReq) XXX_Size() int {
	return xxx_messageInfo_BoardAttachReq.Size(m)
}
func (m *BoardAttachReq) XXX_DiscardUnknown() {
	xxx_messageInfo_BoardAttachReq.DiscardUnknown(m)
}

var xxx_messageInfo_BoardAttachReq proto.InternalMessageInfo

func (m *BoardAttachReq) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *BoardAttachReq) GetBoardUri() string {
	if m != nil {
		return m.BoardUri
	}
	return ""
}

func (m *BoardAttachReq) GetSketchPath() string {
	if m != nil {
		return m.SketchPath
	}
	return ""
}

func (m *BoardAttachReq) GetSearchTimeout() string {
	if m != nil {
		return m.SearchTimeout
	}
	return ""
}

type BoardAttachResp struct {
	// Description of the current stage of the board attachment.
	TaskProgress         *TaskProgress `protobuf:"bytes,1,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *BoardAttachResp) Reset()         { *m = BoardAttachResp{} }
func (m *BoardAttachResp) String() string { return proto.CompactTextString(m) }
func (*BoardAttachResp) ProtoMessage()    {}
func (*BoardAttachResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{12}
}

func (m *BoardAttachResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoardAttachResp.Unmarshal(m, b)
}
func (m *BoardAttachResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoardAttachResp.Marshal(b, m, deterministic)
}
func (m *BoardAttachResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoardAttachResp.Merge(m, src)
}
func (m *BoardAttachResp) XXX_Size() int {
	return xxx_messageInfo_BoardAttachResp.Size(m)
}
func (m *BoardAttachResp) XXX_DiscardUnknown() {
	xxx_messageInfo_BoardAttachResp.DiscardUnknown(m)
}

var xxx_messageInfo_BoardAttachResp proto.InternalMessageInfo

func (m *BoardAttachResp) GetTaskProgress() *TaskProgress {
	if m != nil {
		return m.TaskProgress
	}
	return nil
}

type BoardListReq struct {
	// Arduino Core Service instance from the `Init` response.
	Instance             *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BoardListReq) Reset()         { *m = BoardListReq{} }
func (m *BoardListReq) String() string { return proto.CompactTextString(m) }
func (*BoardListReq) ProtoMessage()    {}
func (*BoardListReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{13}
}

func (m *BoardListReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoardListReq.Unmarshal(m, b)
}
func (m *BoardListReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoardListReq.Marshal(b, m, deterministic)
}
func (m *BoardListReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoardListReq.Merge(m, src)
}
func (m *BoardListReq) XXX_Size() int {
	return xxx_messageInfo_BoardListReq.Size(m)
}
func (m *BoardListReq) XXX_DiscardUnknown() {
	xxx_messageInfo_BoardListReq.DiscardUnknown(m)
}

var xxx_messageInfo_BoardListReq proto.InternalMessageInfo

func (m *BoardListReq) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

type BoardListResp struct {
	// List of ports and the boards detected on those ports.
	Ports                []*DetectedPort `protobuf:"bytes,1,rep,name=ports,proto3" json:"ports,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *BoardListResp) Reset()         { *m = BoardListResp{} }
func (m *BoardListResp) String() string { return proto.CompactTextString(m) }
func (*BoardListResp) ProtoMessage()    {}
func (*BoardListResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{14}
}

func (m *BoardListResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoardListResp.Unmarshal(m, b)
}
func (m *BoardListResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoardListResp.Marshal(b, m, deterministic)
}
func (m *BoardListResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoardListResp.Merge(m, src)
}
func (m *BoardListResp) XXX_Size() int {
	return xxx_messageInfo_BoardListResp.Size(m)
}
func (m *BoardListResp) XXX_DiscardUnknown() {
	xxx_messageInfo_BoardListResp.DiscardUnknown(m)
}

var xxx_messageInfo_BoardListResp proto.InternalMessageInfo

func (m *BoardListResp) GetPorts() []*DetectedPort {
	if m != nil {
		return m.Ports
	}
	return nil
}

type DetectedPort struct {
	// Address of the port (e.g., `serial:///dev/ttyACM0`).
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Protocol of the port (e.g., `serial`).
	Protocol string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// A human friendly description of the protocol (e.g., "Serial Port (USB)").
	ProtocolLabel string `protobuf:"bytes,3,opt,name=protocol_label,json=protocolLabel,proto3" json:"protocol_label,omitempty"`
	// The boards attached to the port.
	Boards               []*BoardListItem `protobuf:"bytes,4,rep,name=boards,proto3" json:"boards,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *DetectedPort) Reset()         { *m = DetectedPort{} }
func (m *DetectedPort) String() string { return proto.CompactTextString(m) }
func (*DetectedPort) ProtoMessage()    {}
func (*DetectedPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{15}
}

func (m *DetectedPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectedPort.Unmarshal(m, b)
}
func (m *DetectedPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectedPort.Marshal(b, m, deterministic)
}
func (m *DetectedPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectedPort.Merge(m, src)
}
func (m *DetectedPort) XXX_Size() int {
	return xxx_messageInfo_DetectedPort.Size(m)
}
func (m *DetectedPort) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectedPort.DiscardUnknown(m)
}

var xxx_messageInfo_DetectedPort proto.InternalMessageInfo

func (m *DetectedPort) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *DetectedPort) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *DetectedPort) GetProtocolLabel() string {
	if m != nil {
		return m.ProtocolLabel
	}
	return ""
}

func (m *DetectedPort) GetBoards() []*BoardListItem {
	if m != nil {
		return m.Boards
	}
	return nil
}

type BoardListAllReq struct {
	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The search query to filter the board list by.
	SearchArgs           []string `protobuf:"bytes,2,rep,name=search_args,json=searchArgs,proto3" json:"search_args,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoardListAllReq) Reset()         { *m = BoardListAllReq{} }
func (m *BoardListAllReq) String() string { return proto.CompactTextString(m) }
func (*BoardListAllReq) ProtoMessage()    {}
func (*BoardListAllReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{16}
}

func (m *BoardListAllReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoardListAllReq.Unmarshal(m, b)
}
func (m *BoardListAllReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoardListAllReq.Marshal(b, m, deterministic)
}
func (m *BoardListAllReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoardListAllReq.Merge(m, src)
}
func (m *BoardListAllReq) XXX_Size() int {
	return xxx_messageInfo_BoardListAllReq.Size(m)
}
func (m *BoardListAllReq) XXX_DiscardUnknown() {
	xxx_messageInfo_BoardListAllReq.DiscardUnknown(m)
}

var xxx_messageInfo_BoardListAllReq proto.InternalMessageInfo

func (m *BoardListAllReq) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *BoardListAllReq) GetSearchArgs() []string {
	if m != nil {
		return m.SearchArgs
	}
	return nil
}

type BoardListAllResp struct {
	// List of installed boards.
	Boards               []*BoardListItem `protobuf:"bytes,1,rep,name=boards,proto3" json:"boards,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *BoardListAllResp) Reset()         { *m = BoardListAllResp{} }
func (m *BoardListAllResp) String() string { return proto.CompactTextString(m) }
func (*BoardListAllResp) ProtoMessage()    {}
func (*BoardListAllResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{17}
}

func (m *BoardListAllResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoardListAllResp.Unmarshal(m, b)
}
func (m *BoardListAllResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoardListAllResp.Marshal(b, m, deterministic)
}
func (m *BoardListAllResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoardListAllResp.Merge(m, src)
}
func (m *BoardListAllResp) XXX_Size() int {
	return xxx_messageInfo_BoardListAllResp.Size(m)
}
func (m *BoardListAllResp) XXX_DiscardUnknown() {
	xxx_messageInfo_BoardListAllResp.DiscardUnknown(m)
}

var xxx_messageInfo_BoardListAllResp proto.InternalMessageInfo

func (m *BoardListAllResp) GetBoards() []*BoardListItem {
	if m != nil {
		return m.Boards
	}
	return nil
}

type BoardListItem struct {
	// The name for use when identifying the board to a human.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The fully qualified board name. Used to identify the board to a machine.
	FQBN                 string   `protobuf:"bytes,2,opt,name=FQBN,proto3" json:"FQBN,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoardListItem) Reset()         { *m = BoardListItem{} }
func (m *BoardListItem) String() string { return proto.CompactTextString(m) }
func (*BoardListItem) ProtoMessage()    {}
func (*BoardListItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_0882eeddaa6507ab, []int{18}
}

func (m *BoardListItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoardListItem.Unmarshal(m, b)
}
func (m *BoardListItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoardListItem.Marshal(b, m, deterministic)
}
func (m *BoardListItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoardListItem.Merge(m, src)
}
func (m *BoardListItem) XXX_Size() int {
	return xxx_messageInfo_BoardListItem.Size(m)
}
func (m *BoardListItem) XXX_DiscardUnknown() {
	xxx_messageInfo_BoardListItem.DiscardUnknown(m)
}

var xxx_messageInfo_BoardListItem proto.InternalMessageInfo

func (m *BoardListItem) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BoardListItem) GetFQBN() string {
	if m != nil {
		return m.FQBN
	}
	return ""
}

func init() {
	proto.RegisterType((*BoardDetailsReq)(nil), "cc.arduino.cli.commands.BoardDetailsReq")
	proto.RegisterType((*BoardDetailsResp)(nil), "cc.arduino.cli.commands.BoardDetailsResp")
	proto.RegisterType((*IdentificationPref)(nil), "cc.arduino.cli.commands.IdentificationPref")
	proto.RegisterType((*USBID)(nil), "cc.arduino.cli.commands.USBID")
	proto.RegisterType((*Package)(nil), "cc.arduino.cli.commands.Package")
	proto.RegisterType((*Help)(nil), "cc.arduino.cli.commands.Help")
	proto.RegisterType((*BoardPlatform)(nil), "cc.arduino.cli.commands.BoardPlatform")
	proto.RegisterType((*ToolsDependencies)(nil), "cc.arduino.cli.commands.ToolsDependencies")
	proto.RegisterType((*Systems)(nil), "cc.arduino.cli.commands.Systems")
	proto.RegisterType((*ConfigOption)(nil), "cc.arduino.cli.commands.ConfigOption")
	proto.RegisterType((*ConfigValue)(nil), "cc.arduino.cli.commands.ConfigValue")
	proto.RegisterType((*BoardAttachReq)(nil), "cc.arduino.cli.commands.BoardAttachReq")
	proto.RegisterType((*BoardAttachResp)(nil), "cc.arduino.cli.commands.BoardAttachResp")
	proto.RegisterType((*BoardListReq)(nil), "cc.arduino.cli.commands.BoardListReq")
	proto.RegisterType((*BoardListResp)(nil), "cc.arduino.cli.commands.BoardListResp")
	proto.RegisterType((*DetectedPort)(nil), "cc.arduino.cli.commands.DetectedPort")
	proto.RegisterType((*BoardListAllReq)(nil), "cc.arduino.cli.commands.BoardListAllReq")
	proto.RegisterType((*BoardListAllResp)(nil), "cc.arduino.cli.commands.BoardListAllResp")
	proto.RegisterType((*BoardListItem)(nil), "cc.arduino.cli.commands.BoardListItem")
}

func init() { proto.RegisterFile("commands/board.proto", fileDescriptor_0882eeddaa6507ab) }

var fileDescriptor_0882eeddaa6507ab = []byte{
	// 1066 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xdf, 0x6e, 0x1b, 0xc5,
	0x17, 0xd6, 0xd6, 0x76, 0xec, 0x1c, 0x3b, 0x69, 0x3b, 0xbf, 0xfe, 0x60, 0x15, 0x44, 0x70, 0x57,
	0x14, 0x45, 0x44, 0x75, 0x44, 0x40, 0x42, 0x2a, 0x7f, 0xa4, 0x04, 0xab, 0xc2, 0x55, 0x28, 0x66,
	0x9a, 0x54, 0x08, 0x81, 0xcc, 0x78, 0x3c, 0xb6, 0x47, 0x59, 0xef, 0x6c, 0x66, 0x66, 0x83, 0xca,
	0x0b, 0x20, 0x1e, 0x81, 0x67, 0xe0, 0x96, 0x0b, 0x1e, 0x81, 0x3b, 0x5e, 0x09, 0xcd, 0xbf, 0xcd,
	0xba, 0xe9, 0x52, 0x01, 0xbd, 0xf2, 0x39, 0xdf, 0x9e, 0x6f, 0x66, 0xce, 0x39, 0xdf, 0x99, 0x31,
	0xdc, 0xa1, 0x62, 0xb5, 0x22, 0xd9, 0x4c, 0x1d, 0x4c, 0x05, 0x91, 0xb3, 0x41, 0x2e, 0x85, 0x16,
	0xe8, 0x75, 0x4a, 0x07, 0x44, 0xce, 0x0a, 0x9e, 0x89, 0x01, 0x4d, 0xf9, 0x20, 0x04, 0xed, 0xfc,
	0xbf, 0x0c, 0x37, 0x86, 0xc8, 0x5c, 0x7c, 0x32, 0x83, 0x9b, 0xc7, 0x86, 0x3e, 0x64, 0x9a, 0xf0,
	0x54, 0x61, 0x76, 0x81, 0x3e, 0x81, 0x0e, 0xcf, 0x94, 0x26, 0x19, 0x65, 0x71, 0xd4, 0x8f, 0xf6,
	0xba, 0x87, 0x77, 0x07, 0x35, 0xab, 0x0e, 0x46, 0x3e, 0x10, 0x97, 0x14, 0x84, 0xa0, 0x39, 0xbf,
	0x98, 0x66, 0xf1, 0x8d, 0x7e, 0xb4, 0xb7, 0x89, 0xad, 0x9d, 0xfc, 0xd1, 0x84, 0x5b, 0xeb, 0xdb,
	0xa8, 0xbc, 0x0c, 0x8c, 0xae, 0x02, 0x0d, 0x96, 0x91, 0x15, 0x0b, 0x64, 0x63, 0xa3, 0x18, 0xda,
	0x97, 0x4c, 0x2a, 0x2e, 0xb2, 0xb8, 0x61, 0xe1, 0xe0, 0xa2, 0x04, 0x7a, 0xb9, 0x14, 0x39, 0x93,
	0x9a, 0x33, 0x35, 0x9a, 0xc5, 0x4d, 0xfb, 0x79, 0x0d, 0x43, 0x77, 0xa0, 0x45, 0x52, 0x4e, 0x54,
	0xdc, 0xb2, 0x1f, 0x9d, 0x83, 0x76, 0xa0, 0x23, 0xe6, 0x73, 0x4e, 0x39, 0x49, 0xe3, 0x8d, 0x7e,
	0xb4, 0xd7, 0xc1, 0xa5, 0x8f, 0x5e, 0x83, 0x8d, 0x9c, 0x67, 0xa2, 0xd0, 0x71, 0xdb, 0x52, 0xbc,
	0x87, 0x1e, 0x40, 0x3b, 0x27, 0xf4, 0x9c, 0x2c, 0x58, 0xdc, 0xb1, 0x65, 0xe9, 0xd7, 0x96, 0x65,
	0xec, 0xe2, 0x70, 0x20, 0xa0, 0x63, 0xe8, 0xe4, 0x29, 0xd1, 0x73, 0x21, 0x57, 0xf1, 0xa6, 0x25,
	0xbf, 0x53, 0x4b, 0xb6, 0x85, 0x1a, 0xfb, 0x68, 0x5c, 0xf2, 0xd0, 0xd7, 0x70, 0x5b, 0x0b, 0x91,
	0xaa, 0x21, 0xcb, 0x59, 0x36, 0x63, 0x19, 0xe5, 0x4c, 0xc5, 0xd0, 0x6f, 0xec, 0x75, 0x0f, 0xdf,
	0xad, 0x5d, 0xec, 0xf4, 0x79, 0x06, 0xbe, 0xbe, 0x08, 0x3a, 0x81, 0x6d, 0x2a, 0xb2, 0x39, 0x5f,
	0x4c, 0x44, 0xae, 0xb9, 0xc8, 0x54, 0xdc, 0xb5, 0xcb, 0xde, 0xab, 0x5d, 0xf6, 0x33, 0x1b, 0xfe,
	0xa5, 0x8d, 0xc6, 0x5b, 0xb4, 0xe2, 0x29, 0xf4, 0x2d, 0xfc, 0x8f, 0xcf, 0x58, 0xa6, 0xf9, 0x9c,
	0x53, 0x62, 0xa0, 0x49, 0x2e, 0xd9, 0x3c, 0xee, 0xd9, 0x25, 0xf7, 0xeb, 0xa5, 0xb4, 0xc6, 0x19,
	0x4b, 0x36, 0xc7, 0x88, 0x5f, 0xc3, 0x92, 0x47, 0x80, 0xae, 0x47, 0xa2, 0x0f, 0xa0, 0x55, 0xa8,
	0xe9, 0x68, 0xe8, 0x05, 0xbb, 0x5b, 0xbb, 0xcb, 0xd9, 0x93, 0xe3, 0xd1, 0x10, 0xbb, 0xe0, 0x64,
	0x1f, 0x5a, 0xd6, 0x47, 0xb7, 0xa0, 0xf1, 0xd4, 0x93, 0x37, 0xb1, 0x31, 0x0d, 0x32, 0x1e, 0x0d,
	0xbd, 0x0e, 0x8d, 0x99, 0xfc, 0x1e, 0x41, 0xdb, 0xf7, 0x15, 0xed, 0x02, 0xac, 0x08, 0xcf, 0x34,
	0xe1, 0x19, 0x93, 0x9e, 0x56, 0x41, 0x0c, 0xbb, 0x90, 0x69, 0x60, 0x17, 0x32, 0x35, 0x8c, 0x1f,
	0xd8, 0x54, 0x71, 0xcd, 0xce, 0xf0, 0x89, 0xd7, 0x71, 0x05, 0x31, 0x32, 0x65, 0x2b, 0xc2, 0x53,
	0xaf, 0x61, 0xe7, 0x94, 0xe3, 0xd0, 0xaa, 0x8c, 0xc3, 0x7b, 0xd0, 0x5c, 0xb2, 0x34, 0xb7, 0xb2,
	0xed, 0x1e, 0xbe, 0x59, 0x9b, 0xe9, 0xe7, 0x2c, 0xcd, 0xb1, 0x0d, 0x4d, 0x76, 0xa1, 0x69, 0x3c,
	0xa3, 0x6c, 0x91, 0xa5, 0x3c, 0x63, 0xfe, 0xc8, 0xde, 0x4b, 0xfe, 0x8c, 0x60, 0x6b, 0x4d, 0x75,
	0x66, 0xb2, 0x88, 0xa4, 0x4b, 0xae, 0x19, 0xd5, 0x85, 0x0c, 0xf1, 0x6b, 0x98, 0x99, 0x21, 0x4a,
	0x34, 0x5b, 0x08, 0xf9, 0xcc, 0x67, 0x5a, 0xfa, 0xa1, 0x00, 0x8d, 0xab, 0x02, 0xec, 0xc1, 0x4d,
	0xcb, 0xbe, 0x64, 0x0f, 0x79, 0xca, 0x1e, 0x9b, 0xac, 0x5c, 0xaa, 0xcf, 0xc3, 0x76, 0xdd, 0x25,
	0xa3, 0xe7, 0xaa, 0x58, 0xf9, 0xc4, 0x4b, 0xdf, 0x14, 0x44, 0xf1, 0x1f, 0x99, 0x4d, 0xbe, 0x81,
	0xad, 0x5d, 0x16, 0xa9, 0x7d, 0x55, 0xa4, 0xe4, 0x97, 0x08, 0x6e, 0x5f, 0x93, 0xbe, 0x59, 0xd9,
	0x0f, 0x64, 0x68, 0x5a, 0xe9, 0xff, 0xc3, 0x9b, 0xe7, 0x01, 0xb4, 0xd5, 0x33, 0xa5, 0xd9, 0x4a,
	0xc5, 0x4d, 0xab, 0xeb, 0xfa, 0xbb, 0xe0, 0x89, 0x8b, 0xc3, 0x81, 0x90, 0xfc, 0x1c, 0x41, 0xdb,
	0x83, 0x6b, 0xb9, 0x46, 0xd7, 0x73, 0x5d, 0x0a, 0xa5, 0xc3, 0x89, 0x8c, 0xfd, 0xa2, 0x2a, 0x36,
	0x5e, 0x5c, 0x45, 0xdf, 0x81, 0xe6, 0x55, 0x07, 0x42, 0xed, 0x5a, 0x57, 0xb5, 0x4b, 0x7e, 0x8a,
	0xa0, 0x57, 0x9d, 0x65, 0x2b, 0x11, 0x6b, 0x95, 0x12, 0x71, 0xf8, 0x5d, 0xe8, 0x39, 0x6b, 0x92,
	0x92, 0x29, 0x0b, 0xd2, 0xee, 0x3a, 0xec, 0xc4, 0x40, 0xe8, 0x63, 0xd8, 0xb8, 0x24, 0x69, 0xc1,
	0x54, 0xdc, 0xb0, 0x25, 0x79, 0xfb, 0x25, 0xb7, 0xc7, 0x53, 0x13, 0x8c, 0x3d, 0x27, 0xf9, 0x1e,
	0xba, 0x15, 0xd8, 0xcc, 0x83, 0xfd, 0xe0, 0x8f, 0xe1, 0x1c, 0xf4, 0x16, 0x74, 0xad, 0xb1, 0x76,
	0x08, 0xb0, 0x90, 0x3b, 0xc3, 0x0e, 0x74, 0x14, 0x4b, 0x19, 0xd5, 0x6c, 0x66, 0x0b, 0xd3, 0xc1,
	0xa5, 0x9f, 0xfc, 0x16, 0xc1, 0xb6, 0x55, 0xf9, 0x91, 0xd6, 0x84, 0x2e, 0x5f, 0xc1, 0x53, 0xf7,
	0x06, 0x6c, 0xda, 0xb7, 0x77, 0x52, 0x48, 0x1e, 0x46, 0xc0, 0x02, 0x67, 0x92, 0x9b, 0xb3, 0xaa,
	0x73, 0xa6, 0xe9, 0x72, 0x92, 0x13, 0xbd, 0x0c, 0x23, 0xef, 0xa0, 0x31, 0xd1, 0x4b, 0x74, 0x0f,
	0xb6, 0x15, 0x33, 0x6d, 0x9b, 0x68, 0xbe, 0x62, 0xe6, 0xbd, 0x71, 0xcd, 0xda, 0x72, 0xe8, 0xa9,
	0x03, 0x93, 0xef, 0xfc, 0x0b, 0x1d, 0x4e, 0xad, 0x72, 0xf4, 0x08, 0xb6, 0x34, 0x51, 0xe7, 0x93,
	0x5c, 0x8a, 0x85, 0x64, 0x4a, 0xf9, 0xb3, 0xd7, 0x5f, 0xd7, 0xa7, 0x44, 0x9d, 0x8f, 0x7d, 0x30,
	0xee, 0xe9, 0x8a, 0x97, 0x7c, 0x01, 0x3d, 0xbb, 0xfc, 0x09, 0x57, 0xfa, 0xbf, 0x97, 0x24, 0x39,
	0xf1, 0x37, 0x89, 0x5b, 0x4e, 0xe5, 0xe8, 0x23, 0x68, 0xe5, 0x42, 0x6a, 0x73, 0xc6, 0xbf, 0x7f,
	0x52, 0x86, 0x4c, 0xdb, 0x3e, 0x8d, 0x85, 0xd4, 0xd8, 0x71, 0x92, 0x5f, 0x23, 0xe8, 0x55, 0x71,
	0x33, 0x91, 0x64, 0x36, 0x2b, 0x73, 0xde, 0xc4, 0xc1, 0xb5, 0xb3, 0x6d, 0xfe, 0xd1, 0x50, 0x11,
	0x74, 0x51, 0xfa, 0xa6, 0xd2, 0xc1, 0xf6, 0xca, 0x71, 0xdd, 0xd8, 0x0a, 0xa8, 0x13, 0xcf, 0xa7,
	0xb0, 0x61, 0xbb, 0x17, 0x66, 0xfa, 0x25, 0x4f, 0xb4, 0x49, 0x71, 0xa4, 0xd9, 0x0a, 0x7b, 0x56,
	0x72, 0xe1, 0x3b, 0x65, 0x3e, 0x1c, 0xa5, 0xe9, 0x2b, 0x10, 0x98, 0xd1, 0x90, 0x93, 0x08, 0x91,
	0x0b, 0x15, 0xdf, 0xe8, 0x37, 0xac, 0x86, 0x2c, 0x74, 0x24, 0x17, 0x2a, 0xc1, 0xfe, 0x7f, 0x55,
	0xb9, 0xa5, 0xca, 0x2b, 0x69, 0x44, 0xff, 0x2a, 0x8d, 0x0f, 0x2b, 0x2d, 0x34, 0x1f, 0xca, 0xab,
	0x31, 0xaa, 0x5c, 0x8d, 0x08, 0x9a, 0x0f, 0xbf, 0x3a, 0x7e, 0x1c, 0x2e, 0x27, 0x63, 0x1f, 0xdf,
	0xff, 0x66, 0x7f, 0xc1, 0xf5, 0xb2, 0x98, 0x9a, 0x1d, 0x0e, 0xfc, 0x8e, 0xe1, 0xf7, 0x3e, 0x4d,
	0xf9, 0x81, 0xcc, 0xe9, 0x41, 0xd8, 0x7d, 0xba, 0x61, 0xab, 0xff, 0xfe, 0x5f, 0x01, 0x00, 0x00,
	0xff, 0xff, 0x09, 0x63, 0xfa, 0x64, 0xc9, 0x0a, 0x00, 0x00,
}
