/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * xs_init.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: xs_init.c,v 2.16 2003/11/02 21:34:12 blusseau Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#ifdef WITH_PERL

#include <EXTERN.h>

#ifdef sun
  #ifdef PACKAGE
    #define DCHUB_PACKAGE PACKAGE
    #undef PACKAGE
    #include <perl.h>
    #ifdef PACKAGE
      #undef PACKAGE
    #endif
    #define PACKAGE DCHUB_PACKAGE
  #else
    #include <perl.h>
  #endif
#else
  #include <perl.h>
#endif
#include <XSUB.h>
#include <sys/socket.h>
#include <glib.h>
#include "gvar.h"
#include "xs_init.h"
#include "users_xml.h"
#include "global_user_if.h"
#include "user_cnx_lst.h"
#include "hub_cmd.h"
#include "db_xml.h"

#ifdef sun
  EXTERN_C void boot_DynaLoader (CV* cv);
#else
  EXTERN_C void boot_DynaLoader (pTHXo_ CV* cv);
#endif
XS(test_call)
{
	int i;
	dXSARGS;
	if(items < 2)		/* number of items in the stack */
	{
		XSRETURN_IV(1);
	}

	for(i=0;i<items;i++)
	{
		/* SvIV => param to int (or value converted into integer) */
		/* SvIVX = param to int (SvIOK must be TRUE) */
		/* SvNV => param to float (or value converted into integer) */
		/* SvNVX = param to float (SvNOK must be TRUE) */
		/* SvPV => param to string (or stringified version of param) */
		/* SvPVX => param to string (SvPOK must be TRUE) */
		
		printf("item %d: ",i);

		if(SvIOK(ST(i)))
			printf("integer: %d\n",(int)SvIVX(ST(i)));
		else if(SvNOK(ST(i)))
			printf("float: %f\n",SvNVX(ST(i)));
		else if(SvPOK(ST(i)))
			printf("string: '%s'\n",SvPVX(ST(i)));
		else
			printf("unknown type\n");
	}
	XSRETURN_IV(1);
}

/**************************************************************/
/* dchub::send_to_named_user( string nickname, string dcline) */
/**************************************************************/
XS(perl_send_to_named_user)
{
	dXSARGS;
	if(items != 2)		/* number of items in the stack */
	{
		printf("dchub::send_to_named_user : wrong number of parameters (2).\n");
		XSRETURN_IV(1);
	}

	if( (!SvPOK(ST(0))) || (!SvPOK(ST(1))) )
	{
		printf("dchub::send_to_named_user : invalid parameters (string,string required).\n");
		XSRETURN_IV(1);
	}

	GLUS_SEND_TO_A_NICK_char_ptr(SvPVX(ST(0)),SvPVX(ST(1)));

	XSRETURN_IV(1);
}

/********************************************/
/* dchub::send_to_all_users( string dcline) */
/********************************************/
XS(perl_send_to_all_users)
{
	dXSARGS;
	if(items != 1)		/* number of items in the stack */
	{
		printf("dchub::send_to_all_users : wrong number of parameters (1).\n");
		XSRETURN_IV(1);
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::send_to_all_users : invalid parameters (string required).\n");
		XSRETURN_IV(1);
	}

	GLUS_SEND_TO_EVERYONE_char_ptr(SvPVX(ST(0)));

	XSRETURN_IV(1);
}

/******************************************************************/
/* dchub::send_gchat_msg( string sender_nickname, string message) */
/******************************************************************/
XS(perl_send_gchat_msg)
{
	gchar *str;

	dXSARGS;
	if(items != 2)		/* number of items in the stack */
	{
		printf("dchub::send_gchat_msg : wrong number of parameters (2).\n");
		XSRETURN_IV(1);
	}

	if( (!SvPOK(ST(0))) || (!SvPOK(ST(1))) )
	{
		printf("dchub::send_gchat_msg : invalid parameters (string,string required).\n");
		XSRETURN_IV(1);
	}

	/* build and send the global chat message */
	str=g_strconcat("<",SvPVX(ST(0)),"> ",SvPVX(ST(1)),"|",NULL);
	GLUS_SEND_TO_EVERYONE_char_ptr(str);
	g_free(str);

	XSRETURN_IV(1);
}

/****************************************************************************************/
/* dchub::send_pchat_msg( string sender_nickname, string dest_nickname, string message) */
/****************************************************************************************/
XS(perl_send_pchat_msg)
{
	gchar *str;

	dXSARGS;
	if(items != 3)		/* number of items in the stack */
	{
		printf("dchub::send_pchat_msg : wrong number of parameters (3).\n");
		XSRETURN_IV(1);
	}

	if( (!SvPOK(ST(0))) || (!SvPOK(ST(1))) || (!SvPOK(ST(2))) )
	{
		printf("dchub::send_pchat_msg : invalid parameters (string,string,string required).\n");
		XSRETURN_IV(1);
	}

	/* build and send the private chat message */
	str=g_strconcat("$To: ",SvPVX(ST(1))," From: ",SvPVX(ST(0))," $<",SvPVX(ST(0)),"> ",SvPVX(ST(2)),"|",NULL);
	
	GLUS_SEND_TO_A_NICK_char_ptr(SvPVX(ST(1)),str);
	g_free(str);

	XSRETURN_IV(1);
}

/*********************************************************************************************/
/* dchub::send_pchat_fake_msg( string sender_nickname, string dest_nickname, string message) */
/*********************************************************************************************/
XS(perl_send_pchat_fake_msg)
{
        gchar *str;

        dXSARGS;
        if(items != 4)          /* number of items in the stack */
        {
                printf("dchub::send_pchat_msg : wrong number of parameters (4).\n");
                XSRETURN_IV(1);
        }

        if( (!SvPOK(ST(0))) || (!SvPOK(ST(1))) || (!SvPOK(ST(2))) || (!SvPOK(ST(3))) )
        {
                printf("dchub::send_pchat_msg : invalid parameters (string,string,string required).\n");
                XSRETURN_IV(1);
        }

        /* build and send the private chat message */
        str=g_strconcat("$To: ",SvPVX(ST(1))," From: ",SvPVX(ST(0))," $",SvPVX(ST(3)),"|",NULL);

        GLUS_SEND_TO_A_NICK_char_ptr(SvPVX(ST(1)),str);
        g_free(str);

        XSRETURN_IV(1);
}

/***************************************/
/* dchub::disconnect( string nickname) */
/***************************************/
XS(perl_disconnect)
{
	dXSARGS;
	if(items != 1)		/* number of items in the stack */
	{
		printf("dchub::disconnect : wrong number of parameters (1).\n");
		XSRETURN_IV(1);
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::disconnect : invalid parameters (string required).\n");
		XSRETURN_IV(1);
	}

	glus_disconnect_named_user(SvPVX(ST(0)));

	XSRETURN_IV(1);
}

/***************************************/
/* dchub::kick( string nickname)       */
/***************************************/
/* Added by Hans F*/
/******************/
XS(perl_kick)
{
	dXSARGS;
	if(items != 1)		/* number of items in the stack */
	{
		printf("dchub::kick : wrong number of parameters (1).\n");
		XSRETURN_IV(1);
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::kick : invalid parameters (string required).\n");
		XSRETURN_IV(1);
	}

	glus_kick_named_user(NULL,SvPVX(ST(0)));

	XSRETURN_IV(1);
}

/**************************************/
/* dchub::redirect( string nickname)  */
/**************************************/
/* Added by Hans F*/
/******************/
XS(perl_redirect)
{
	GString *rd_msg;
	char *rd;
	dXSARGS;
	if(items != 1)		/* number of items in the stack */
	{
		printf("dchub::redirect : wrong number of parameters (1).\n");
		XSRETURN_IV(1);
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::redirect : invalid parameters (string required).\n");
		XSRETURN_IV(1);
	}
	
	rd=db_str_get("REDIR_ADDR");

	if ((rd != NULL) && (strlen(rd) != 0)) {
		rd_msg=g_string_new("");
		/* first the message to display */
		g_string_sprintf(rd_msg,"<Hub-Security> You are being redirected to %s.|",rd);
		/* and then the redirection command */
		g_string_sprintfa(rd_msg,"$ForceMove %s|",rd);
		GLUS_SEND_TO_A_NICK(SvPVX(ST(0)),rd_msg);		/* don't free rd_msg */
	}

	/* and disconnect the user */
	glus_disconnect_named_user(SvPVX(ST(0)));

	if(rd!=NULL)
		free(rd);

	XSRETURN_IV(1);
}

/************************************************/
/* dchub::redirectto(string nickname, string ip)*/
/************************************************/
/* Added by Hans F*/
/******************/
XS(perl_redirectto)
{
	GString *rd_msg;
	dXSARGS;
	if(items != 2)		/* number of items in the stack */
	{
		printf("dchub::redirectto : wrong number of parameters (1).\n");
		XSRETURN_IV(1);
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::redirectto : invalid parameters (string required).\n");
		XSRETURN_IV(1);
	}
	
	if(!SvPOK(ST(1)))
	{
		printf("dchub::redirectto : invalid parameters (string required).\n");
		XSRETURN_IV(1);
	}

	rd_msg=g_string_new("");
	/* first the message to display */
	g_string_sprintf(rd_msg,"<Hub-Security> You are being redirected to %s.|",SvPVX(ST(1)));
	/* and then the redirection command */
	g_string_sprintfa(rd_msg,"$ForceMove %s|",SvPVX(ST(1)));
	GLUS_SEND_TO_A_NICK(SvPVX(ST(0)),rd_msg);	/* don't free rd_msg */

	/* and disconnect the user */
	glus_disconnect_named_user(SvPVX(ST(0)));

	XSRETURN_IV(1);
}


/*************************************/
/* dchub::nickinfo( string nickname) */
/*************************************/
XS(perl_nickinfo)
{
	GString *str;
	dXSARGS;
	if(items != 1)		/* number of items in the stack */
	{
		printf("dchub::nickinfo : wrong number of parameters (1).\n");
		XSRETURN_UNDEF;
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::nickinfo : invalid parameters (string required).\n");
		XSRETURN_UNDEF;
	}

	str=txt_glus_get_user_info(SvPVX(ST(0)));
	if(str==NULL)
	{
		XSRETURN_UNDEF;
	}

	/* same as XSRETURN_PV(str->str) but with g_string_free inside */
	XST_mPV(0,str->str);
	g_string_free(str,TRUE);
	XSRETURN(1);
}

/******************************************/
/* dchub::nick_duration( string nickname) */
/******************************************/
XS(perl_nick_duration)
{
	time_t duration;
	dXSARGS;
	GLUS_USER_INFO *gui;

	if(items != 1)		/* number of items in the stack */
	{
		printf("dchub::nick_duration : wrong number of parameters (1).\n");
		XSRETURN_UNDEF;
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::nick_duration : invalid parameters (string required).\n");
		XSRETURN_UNDEF;
	}

	gui=glus_get_user_info(SvPVX(ST(0)));
	if(gui==NULL)
	{
		XSRETURN_UNDEF;
	}

	duration=gl_cur_time-gui->cnx_start_time;
	glus_free_user_info(gui);

	XSRETURN_IV((int)duration);
}

/***************************************/
/* dchub::nick_level( string nickname) */
/***************************************/
XS(perl_nick_level)
{
	gint16 result;
	dXSARGS;
	if(items != 1)		/* number of items in the stack */
	{
		printf("dchub::nick_level : wrong number of parameters (1).\n");
		XSRETURN_UNDEF;
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::nick_level : invalid parameters (string required).\n");
		XSRETURN_UNDEF;
	}

	if (!xml_get_user(SvPVX(ST(0)), &result, NULL, NULL, NULL))
		result=0; /* if user is not found return level 0 */
	
	XSRETURN_IV(result);
}

/*************************************/
/* dchub::right_level( string right) */
/*************************************/
XS(perl_right_level) {
	dXSARGS;
	if(items != 1) {		/* number of items in the stack */
		printf("dchub::right_level : wrong number of parameters (1).\n");
		XSRETURN_UNDEF;
	}
	if(!SvPOK(ST(0)))
	{
		printf("dchub::right_level : invalid parameters (string required).\n");
		XSRETURN_UNDEF;
	}
	XSRETURN_IV(get_right_level(SvPVX(ST(0))));
}

/**************************/
/* Get IP address of user */ /* Morra: */
/**************************/
XS(perl_nick_ip)
{
	char *ip_addr = NULL;
	GLUS_USER_INFO *gui;
	dXSARGS;

	if (items != 1)
	{
		printf("dchub::nick_ip : wrong number of parameters (1).\n");
		XSRETURN_UNDEF;
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::nick_ip : invalid parameters (string required).\n");
		XSRETURN_UNDEF;
	}

	gui=glus_get_user_info(SvPVX(ST(0)));
	if(gui==NULL)
	{
#if 0
		printf("dchub::nick_ip : no such nickname (%s).\n", SvPVX(ST(0)));
#endif
		XSRETURN_UNDEF;
	}

	ip_addr=inet_ntoa(gui->user_ip);
	glus_free_user_info(gui);

	XSRETURN_PV(ip_addr);
}

/*************************/
/* dchub::userlist(void) */
/*************************/
XS(perl_userlist)
{
	GString *str;
	dXSARGS;
	if(items != 0)		/* number of items in the stack */
	{
		printf("dchub::userlist : wrong number of parameters (0).\n");
		XSRETURN_UNDEF;
	}

	str=txt_glus_get_userlist();
	if(str==NULL)
	{
		XSRETURN_UNDEF;
	}

	/* same as XSRETURN_PV(str->str) but with g_string_free inside */
	XST_mPV(0,str->str);
	g_string_free(str,TRUE);
	XSRETURN(1);
}

/***********************/
/* dchub::oplist(void) */
/***********************/
XS(perl_oplist)
{
	GString *str;
	dXSARGS;
	if(items != 0)		/* number of items in the stack */
	{
		printf("dchub::oplist : wrong number of parameters (0).\n");
		XSRETURN_UNDEF;
	}

	str=txt_glus_get_oplist();
	if(str==NULL)
	{
		XSRETURN_UNDEF;
	}

	/* same as XSRETURN_PV(str->str) but with g_string_free inside */
	XST_mPV(0,str->str);
	g_string_free(str,TRUE);
	XSRETURN(1);
}

/**********************************/
/* dchub::get_hub_user_stat(void) */
/**********************************/
XS(perl_get_hub_user_stat)
{
        guint64 shared_size;
        unsigned int nb_users;
        GString *str;
        dXSARGS;
        str=g_string_new("");

        if(items != 0)          /* number of items in the stack */
        {
                printf("dchub::get_hub_user_stat : wrong number of parameters (0).\n");
                XSRETURN_UNDEF;
        }
        else
        {
                glus_hub_users_stat(&shared_size,&nb_users);
                g_string_sprintfa(str,"%Lu,%u",shared_size,nb_users);
        }

        if(str==NULL)
        {
                XSRETURN_UNDEF;
        }

        /* same as XSRETURN_PV(str->str) but with g_string_free inside */
        XST_mPV(0,str->str);
        g_string_free(str,TRUE);
        XSRETURN(1);
}

/**********************************/
/* int dchub::get_max_users(void) */
/**********************************/
XS(perl_get_max_users)
{
	int max_nb=-1;

	dXSARGS;
	if(items != 0)		/* number of items in the stack */
	{
		printf("dchub::get_max_users : wrong number of parameters (0).\n");
	}
	else
	{
		if(!db_int_get("MAXUSER", &max_nb))
			max_nb=100;
	}

	XSRETURN_IV(max_nb);
}

/******************************************/
/* string dchub::get_txtdescription(void) */
/******************************************/
XS(perl_get_txtdescription)
{
	char *hubdesc;

	dXSARGS;
	if(items != 0)		/* number of items in the stack */
	{
		printf("dchub::get_txt_description : wrong number of parameters (0).\n");
		XSRETURN_UNDEF;
	}

	hubdesc=db_str_get("HUBDESC");
	
	/* same as XSRETURN_PV(hubdesc) but with g_free inside */
	XST_mPV(0,hubdesc);
	free(hubdesc);
	XSRETURN(1);
}

/*********************************/
/* string dchub::get_hubip(void) */
/*********************************/
XS(perl_get_hubip)
{
	char *hubdesc;

	dXSARGS;
	if(items != 0)		/* number of items in the stack */
	{
		printf("dchub::get_txt_hubip : wrong number of parameters (0).\n");
		XSRETURN_UNDEF;
	}

	hubdesc=db_str_get("HUBADDR");
	
	/* same as XSRETURN_PV(hubdesc) but with g_free inside */
	XST_mPV(0,hubdesc);
	free(hubdesc);
	XSRETURN(1);		/* 1 value in stack */
}

/**********************************/
/* dchub::db_get( string keyname) */
/**********************************/
XS(perl_db_get)
{
	char *str_value;
	int int_value;
	float float_value;
	int type;
	gboolean result;
	
	dXSARGS;
	if(items != 1)		/* number of items in the stack */
	{
		printf("dchub::db_get : wrong number of parameters (1).\n");
		XSRETURN_UNDEF;
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::db_get : invalid parameters (string required).\n");
		XSRETURN_UNDEF;
	}

	type=db_type_get(SvPVX(ST(0)));
	switch (type) {
		case TYPE_STR:
			str_value=db_str_get(SvPVX(ST(0)));
			if (str_value != NULL) {
				/* same as XSRETURN_PV(str) but with free inside */
				XST_mPV(0,str_value);
				free(str_value);
				XSRETURN(1);
			}
			break;
			
		case TYPE_INT:
			result=db_int_get(SvPVX(ST(0)),&int_value);
			if (result == TRUE)
				XSRETURN_IV(int_value);	
			break;
			
		case TYPE_FLOAT:
			result=db_float_get(SvPVX(ST(0)),&float_value);
			if (result == TRUE)
				XSRETURN_NV(float_value);	
			break;
	}			
	XSRETURN_UNDEF;	
}

/*************************************************/
/* dchub::db_set( string keyname, string keyval) */
/*************************************************/
XS(perl_db_set)
{
	dXSARGS;
	if(items != 2)		/* number of items in the stack */
	{
		printf("dchub::db_set : wrong number of parameters (2).\n");
		XSRETURN_UNDEF;
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::db_set : invalid parameters (string required).\n");
		XSRETURN_UNDEF;
	}

	db_str_set(SvPVX(ST(0)),SvPV_nolen(ST(1)));

	XSRETURN_IV(1);
}

/***************************************************/
/* dchub::hubcmd( string nickname, string command) */
/***************************************************/
XS(perl_hubcmd)
{
	LOCAL_USER_CNX_ENTRY *luce;

	dXSARGS;
	if(items != 2)		/* number of items in the stack */
	{
		printf("dchub::db_set : wrong number of parameters (2).\n");
		XSRETURN_UNDEF;
	}

	if(!SvPOK(ST(0)))
	{
		printf("dchub::db_set : invalid parameters (string required).\n");
		XSRETURN_UNDEF;
	}

	if(!SvPOK(ST(1)))
	{
		printf("dchub::db_set : invalid parameters (string required).\n");
		XSRETURN_UNDEF;
	}

	luce=user_cnx_entry_get_by_nickname(SvPVX(ST(0)));
	if(luce!=NULL)
	{
		GString *msg;
		msg=g_string_new("");
		g_string_sprintf(msg,"<%s> %s",SvPVX(ST(0)),SvPVX(ST(1)));
		if (SvPVX(ST(1))[strlen(SvPVX(ST(1)))-1] != '|') 
			g_string_append_c(msg,'|'); /* Append a | at the end if none exist */
		process_hub_command(luce,msg->str);
		g_string_free(msg,TRUE);
	}
	XSRETURN_IV(1);
}

/*******************************************************/
/* define all functions provided by the hub to scripts */
/*******************************************************/
void xs_init(pTHXo)
{
	char *file = __FILE__;
	dXSUB_SYS;

	/* DynaLoader is a special case */
	newXS("DynaLoader::boot_DynaLoader", boot_DynaLoader, file);

	/* list of all functions provided to perl scripts by dchub */
	newXS("dchub::send_to_named_user",perl_send_to_named_user,"xs_init.c");
	newXS("dchub::send_to_all_users",perl_send_to_all_users,"xs_init.c");

	newXS("dchub::send_gchat_msg",perl_send_gchat_msg,"xs_init.c");
	newXS("dchub::send_pchat_msg",perl_send_pchat_msg,"xs_init.c");
	newXS("dchub::send_pchat_fake_msg",perl_send_pchat_fake_msg,"xs_init.c");

	newXS("dchub::disconnect",perl_disconnect,"xs_init.c");
	/*Added by Hans F*/
	newXS("dchub::kick",perl_kick,"xs_init.c");
	newXS("dchub::redirect",perl_redirect,"xs_init.c");
	newXS("dchub::redirectto",perl_redirectto,"xs_init.c");
	/* Done */
	newXS("dchub::userlist",perl_userlist,"xs_init.c");
	newXS("dchub::oplist",perl_oplist,"xs_init.c");
	newXS("dchub::nickinfo",perl_nickinfo,"xs_init.c");
	newXS("dchub::nick_duration",perl_nick_duration,"xs_init.c");
	newXS("dchub::nick_level",perl_nick_level,"xs_init.c");
	newXS("dchub::right_level",perl_right_level,"xs_init.c");

	/* Obsolete since 0.5.0 will be remove (same function as dchub::nick_level) */
	newXS("dchub::nick_type",perl_nick_level,"xs_init.c");

	newXS("dchub::nick_ip", perl_nick_ip, "xs_init.c");	/* Morra: get users ip */
	newXS("dchub::get_max_users",perl_get_max_users,"xs_init.c");
	newXS("dchub::get_txtdescription",perl_get_txtdescription,"xs_init.c");
	newXS("dchub::get_hubip",perl_get_hubip,"xs_init.c");
	newXS("dchub::get_hub_user_stat",perl_get_hub_user_stat,"xs_init.c");
	
	newXS("dchub::db_get",perl_db_get,"xs_init.c");
	newXS("dchub::db_set",perl_db_set,"xs_init.c");

	newXS("dchub::test_call",test_call,"xs_init.c");

	newXS("dchub::hubcmd",perl_hubcmd,"xs_init.c");
}
#endif /* WITH_PERL */

