/* DChub - a Direct Connect Hub for Linux
 *
 * Copyright (C) 2001 Eric Prevoteau
 *
 * xmltools.h: Copyright (C) Yves BLUSSEAU
 *
 * $Id: xmltools.h,v 2.4 2003/10/17 16:25:47 blusseau Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XML_TOOLS_H__
#define __XML_TOOLS_H__

#include <libxml/xpath.h>

#define MAX_BUF_CONV_LEN		256	/* MAX LEN FOR STRING IN UTF8 FOR ALL XML DATAS */
#define DEFINE_BUF_CONV(var)	char var[MAX_BUF_CONV_LEN]

#define STR_LAT1ToUTF8(in,out) 						\
   {												\
	   if (in) {									\
	       int outlen=MAX_BUF_CONV_LEN;				\
		   int inlen=strlen(in);					\
           isolat1ToUTF8(out, &outlen, in, &inlen);	\
		   out[outlen]='\0';						\
       } else										\
		   *out='\0';								\
	}												\

#define STR_UTF8ToLAT1(in,out) 						\
   {												\
	   if (in) {									\
	       int outlen=MAX_BUF_CONV_LEN;				\
	       int inlen=strlen(in);					\
	       UTF8Toisolat1(out, &outlen, in, &inlen);	\
	       out[outlen]='\0';						\
       } else										\
	       *out='\0';								\
   }												\

#define MALLOC_STR_UTF8ToLAT1(in,out) 				\
   {												\
	   if (in) {									\
           int inlen=strlen(in);					\
           int outlen=inlen;						\
           out=malloc(outlen);						\
	       UTF8Toisolat1(out, &outlen, in, &inlen);	\
	       *((out)+outlen)='\0';					\
       } else										\
           out=NULL;								\
   }

gboolean initXMLTools(const char* template_dir);
void freeXMLTools();
xmlXPathObjectPtr getNodeSet (xmlDocPtr doc, xmlChar *xpath);
xmlDocPtr loadXMLFile(char *filename);

#endif
