/* DChub - a Direct Connect Hub for Linux
 *
 * Copyright (C) 2001 Eric Prevoteau
 *
 * xmltools.c: Copyright (C) Yves BLUSSEAU
 *
 * $Id: xmltools.c,v 2.8 2003/10/19 15:32:19 blusseau Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <glib.h>
#include <sys/stat.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>

#ifdef HAVE_LIBDMALLOC
#include <dmalloc.h>    /* Gray Watson's library */
#define show_alloc() dmalloc_log_unfreed()
#define show_stats() dmalloc_log_stats()
#else
#define show_alloc()    /* nothing */
#define show_stats()    /* nothing */
#endif

char *template_dir=NULL;

xmlExternalEntityLoader defaultLoader = NULL;

xmlParserInputPtr fwbExternalEntityLoader(const char *URL, 
                                          const char *ID,
                                          xmlParserCtxtPtr ctxt) {
    xmlParserInputPtr ret;
	GString *fname;
	char *t;

    // Try to load it as file from template directory
    fname=g_string_new(template_dir ? template_dir : DCHUB_TEMPLATEDIR);
	g_string_append_c(fname,'/');

	t=strrchr(URL,'/');
	if (t == NULL)
		g_string_append(fname,URL);
	else 
		g_string_append(fname,++t);
	
	ret = xmlNewInputFromFile(ctxt, fname->str);
	g_string_free(fname,TRUE);
	
    if(ret)
        return(ret);
    else if(defaultLoader)
        return defaultLoader(URL, ID, ctxt);
    else
        return NULL;
}

gboolean initXMLTools(const char* force_template_dir) {
	if (force_template_dir) {
		struct stat st;
		if(stat(force_template_dir, &st) != 0 || !S_ISDIR(st.st_mode)) {
			fprintf(stderr,"Bad template directory:%s\n", force_template_dir);
			return FALSE;
		}
		if (template_dir)
			free(template_dir);
		template_dir=strdup(force_template_dir);
	}
	xmlInitParser();
	defaultLoader = xmlGetExternalEntityLoader();
    xmlSetExternalEntityLoader(fwbExternalEntityLoader);
	return TRUE;
}

void freeXMLTools(void) {
	if (template_dir)
		free(template_dir);
	xmlCleanupParser();
}

xmlXPathObjectPtr getNodeSet (xmlDocPtr doc, xmlChar *xpath) {
	xmlXPathContextPtr context;
	xmlXPathObjectPtr result=NULL;

	context = xmlXPathNewContext(doc);
	if (context) {
		result = xmlXPathEvalExpression(xpath, context);
		if (result) {
			if(xmlXPathNodeSetIsEmpty(result->nodesetval)){
				xmlXPathFreeObject(result);
				result=NULL;
			}
		}
		xmlXPathFreeContext(context);
	}
	return result;
}

xmlDocPtr loadXMLFile(char *filename) {
	xmlDocPtr doc;
	xmlNodePtr cur;
	
	xmlValidCtxt cvp;
	cvp.userData = (void *) stderr;
	cvp.error    = (xmlValidityErrorFunc) fprintf;
	cvp.warning  = (xmlValidityWarningFunc) fprintf;
	xmlKeepBlanksDefault(0);

	doc = xmlParseFile(filename);
	if (doc == NULL ) {
		fprintf(stderr,"XML document:%s not parsed successfully.\n",filename);
		return NULL;
	}
	if (!xmlValidateDocument(&cvp, doc)) {
		fprintf(stderr,"XML file:%s is not valid\n",filename);
		return NULL;
	}
	cur = xmlDocGetRootElement(doc);
	if (cur == NULL) {
		fprintf(stderr,"empty document\n");
		xmlFreeDoc(doc);
		doc=NULL;
		
	} else {
		if (xmlStrcmp(cur->name, (const xmlChar *) "dchub")) {
			fprintf(stderr,"document of the wrong type, root node != dchub\n");
			xmlFreeDoc(doc);
			doc=NULL;
		}
	}
	return doc;
}
