#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <string.h>
#include <unistd.h>
#include <glib.h>
#include <stdarg.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include "xmltools.h"
#include "users_xml.h"
#include "db_xml.h"
#include "hl_locks.h"

#ifdef WITH_GCRYPT
#include <gcrypt.h>
#define MD5_DIGEST_LENGTH 16
#define MD5_ALGO(source,len,dest)   gcry_md_hash_buffer(GCRY_MD_MD5,dest,source,len)
#else
#include <openssl/md5.h>
#define MD5_ALGO MD5
#endif

#ifdef HAVE_LIBDMALLOC
#include <dmalloc.h>    /* Gray Watson's library */
#define show_alloc() dmalloc_log_unfreed()
#define show_stats() dmalloc_log_stats()
#else
#define show_alloc()    /* nothing */
#define show_stats()    /* nothing */
#endif

void display_nick_privilege(xmlNodePtr user) {
	xmlChar *privilege;
	privilege = xmlGetProp(user, "privilege");
	printf("nick: %s\tprivilege:%s\n", user->children->content,privilege);
	xmlFree(privilege);
}

void display_all_nick_matching(xmlXPathObjectPtr result) {
	xmlNodeSetPtr nodeset;
	int i;
	
	nodeset = result->nodesetval;
	for (i=0; i < nodeset->nodeNr; i++) {
		display_nick_privilege(nodeset->nodeTab[i]);
	}
}

gint compare_db_key (gconstpointer a, gconstpointer b, gpointer user_data) {
	return strcasecmp((char*)g_ptr_array_index((GPtrArray *)user_data,(int)a),
					  (char*)g_ptr_array_index((GPtrArray *)user_data,(int)b));
}

int main()  {
	
	//if (!loadUsersFile("users.xml")) {
	//	fprintf(stderr,"Error can't load file.\n");
	//	exit(0);
	//}

	if (!loadDBFile("db.xml")) {
		fprintf(stderr,"Error can't load file.\n");
		exit(0);
	}

	//xml_dump_db("-");
	//printf("---------------------------------------------------------\n");
	//db_int_set("mon entier",44);
	//xml_dump_db("-");
	//printf("---------------------------------------------------------\n");
	//db_int_set("mon entier",34);
	//db_str_set("ok","Ok modifi");
	//db_float_set("mon float",256.567812345);
	//{
	//	float toto;
	//	db_float_get("mon float",&toto);
	//	printf("Mon Float vaut:%f\n",toto);
	//}
	//	
	//db_str_set("AZRTy",NULL);
	//{
	//	char* val =db_str_get("AZERTy");
	//	printf("Mon Str vaut:%s\n",val);
	//	if (val == NULL) {
	//		printf("NULL\n");
	//	}
	//	free(val);
	//}
	//xml_dump_db("-");
	//printf("---------------------------------------------------------\n");
	//db_del("HUBNAME");
	//xml_dump_db("-");
	printf("---------------------------------------------------------\n");

	{
		int i;
		GSList *sortIndex=NULL;
		
		GStringChunk *gsc=NULL;
		GPtrArray *gpa_name=NULL;
		GPtrArray *gpa_type=NULL;
		GPtrArray *gpa_val=NULL;
		
		db_get_all_keys(&gpa_name, &gpa_type, &gpa_val, &gsc);

		// g_array_set_size(sortIndex, gpa_name->len - 1);
		
		for( i=0; i<gpa_name->len; i++) {
			sortIndex=g_slist_append(sortIndex,(gpointer)i);
		}
		
		/* sort the array */
		sortIndex=g_slist_sort_with_data(sortIndex, compare_db_key, gpa_name);
		
		for( i=0; i<gpa_name->len; i++) {
			printf ("%s\t%s %s\n",
					(char*)g_ptr_array_index(gpa_type,(int)g_slist_nth_data(sortIndex, i)),
					(char*)g_ptr_array_index(gpa_name,(int)g_slist_nth_data(sortIndex, i)),
					(char*)g_ptr_array_index(gpa_val, (int)g_slist_nth_data(sortIndex, i)));
		}
		
		if(gsc!=NULL)
			g_string_chunk_free(gsc);
		if(gpa_name!=NULL)
			g_ptr_array_free(gpa_name,TRUE);
		if(gpa_type!=NULL)
			g_ptr_array_free(gpa_type,TRUE);
		if(gpa_val!=NULL)
			g_ptr_array_free(gpa_val,TRUE);

		g_slist_free(sortIndex);
	}
	printf("Fin\n");
	//db_str_set("Tata","Ma Chaine");
/* 	{ */
/* 		int i; */
/* 		char *passwd=NULL; */
/* 		int level; */
/* 		gboolean protected; */
/* 		char *comment=NULL; */
		
/* 		for(i=0;i<1;i++) { */
/* 			printf("I=%d\n",i); */
/* 			if (xml_get_user("JrCs", &level, &passwd, &protected, &comment)) { */
/* 				printf("User JrCs Found Level:[%d] Password:[%s] Protected:[%d] Comment:[%s]\n",level,passwd,protected,comment); */
/* 				free(passwd); */
/* 				free(comment); */
/* 			} */
/* 			sleep(2); */
/* 		} */
/* 	} */

/* 	printf("Level for KICK:[%d]\n",get_right_level("KICK")); */
/* 	sleep(1); */
/* 	printf("Level for TOTO:[%d]\n",get_right_level("TOTO")); */
/* 	sleep(1); */
	
/* 	{ */
/* 		GString *full_users; */
/* 		full_users=full_users_list_with_level(8); */
/* 		if (full_users) { */
/* 			printf("%s\n",full_users->str); */
/* 			g_string_free(full_users,TRUE); */
/* 		} */
/* 		sleep(10); */
/* 	} */
	
/* 	if (xml_add_user("Toto", 3, "test~", TRUE, "Salut avec des > et des \"")) */
/* 		printf("Add user OK\n"); */
		
/* 	xml_dump_users("-"); */

/* 	sleep(2); */

/* 	if (xml_del_user("JrCs")) */
/* 		printf("Del user OK\n"); */
		
/* 	xml_dump_users("-"); */
	
	
    //HL_LOCK_WRITE(users_xml_file);
	//user_doc = loadXMLFile(xml_file);
	//HL_UNLOCK_WRITE(users_xml_file);
	
	/* Manual access */
	// {
	// 	xmlDocPtr doc;
	// 	xmlNodePtr cur;
	// 	char *filename="users.xml";
	// 
	// 	xmlValidCtxt cvp;
	// 	cvp.userData = (void *) stderr;
	// 	cvp.error    = (xmlValidityErrorFunc) fprintf;
	// 	cvp.warning  = (xmlValidityWarningFunc) fprintf;
	// 	xmlKeepBlanksDefault(0);
	// 
	// 	doc = xmlParseFile(filename);
	// 	if (doc == NULL ) {
	// 		fprintf(stderr,"XML document:%s not parsed successfully.\n",filename);
	// 		exit(1);
	// 	}
	// 	if (!xmlValidateDocument(&cvp, doc)) {
	// 		fprintf(stderr,"XML file:%s is not valid\n",filename);
	// 		exit(1);
	// 	}
	// 	printf("----------------------------------\nWalking the tree:\n");
	// 	cur = xmlDocGetRootElement(doc);
	// 	cur=cur->children;
	// 	while (cur != NULL && (xmlStrcmp(cur->name, (const xmlChar *) "users"))) {
	// 		cur=cur->next;
	// 	}	
	// 	if (cur == NULL) {
	// 		fprintf(stderr,"Can't find users in the document\n");
	// 		xmlFreeDoc(doc);
	// 		exit(1);
	// 	}
	// 	cur=cur->children;
	// 	if (xmlStrcmp(cur->name, (const xmlChar *) "nick")) {
	// 		fprintf(stderr,"Wrong document\n");
	// 		xmlFreeDoc(doc);
	// 		exit(1);
	// 	}
	// 
	// 	{
	// 		char out[16];
	// 		int outlen=16;
	// 		char *name="12dh";
	// 		int inlen=strlen(name);
	// 		xmlNodePtr new_user_node;
	// 
	// 		strcpy(out,"salut mec");
	// 		isolat1ToUTF8(out, &outlen, name, &inlen);
	// 		out[outlen]='\0';
	// 		
	// 		new_user_node=xmlNewChild(cur, NULL, "nick", NULL);
	// 		xmlNewProp(new_user_node,"name",out);
	// 	}
	// 	
	// 	{
	// 		xmlChar *name;
	// 		xmlChar *level;
	// 		while (cur != NULL) {
	// 			if (!xmlStrcmp(cur->name, (const xmlChar *) "nick")) {	
	// 				name = xmlGetProp(cur, "name");
	// 				level = xmlGetProp(cur, "level");
	// 				printf ("Name:%s\tLevel:%s\n",name,level);
	// 				xmlFree(level);
	// 				xmlFree(name);
	// 			}
	// 			cur=cur->next;
	// 		}
	// 	}
	// 	xmlSaveFormatFile("-", doc,1); 
	// }
	//
	//printf("----------------------------------\nUsing XPATH:\n");
	//{
	//	xmlChar *xpath = "//users/nick"; /* retrieve all the nick */
	//	xmlXPathObjectPtr result;
	//	
	//	result = getnodeset (user_doc, xpath);
	//	if (result) {
	//		display_all_nick_matching(result);
	//		xmlXPathFreeObject(result);
	//	}
	//}
	//
	//
	//printf("----------------------------------\nAll master using XPATH:\n");
	//{
	//	xmlChar *xpath = "///users/nick[@privilege=\"master\"]"; /* retrieve all master */
	//	xmlXPathObjectPtr result;
	//	
	//	result = getnodeset (user_doc, xpath);
	//	if (result) {
	//		display_all_nick_matching(result);
	//		xmlXPathFreeObject(result);
	//	}
	//}
	//
	//printf("----------------------------------\nFind a particular user using XPATH:\n");
	//{
	//	xmlNodePtr user=find_user(user_doc,"flex>bison"); /* nick with reserved caractere */
	//	if (user) {
	//		display_nick_privilege(user);
	//	}
	//}
	//
	//printf("----------------------------------\n");
    //cur = xmlDocGetRootElement(user_doc)->children;
	//xmlNewChild(cur, NULL, "nick", "new>user");
	//
	//xmlSaveFormatFile("-", user_doc,1); 
	//
	//xmlFreeDoc(user_doc);
	//xmlCleanupParser();

	//xml_free_users_resource();

	xml_free_db_resource();
	
	xmlCleanupParser();
	return 0;
}
