/* DChub - a Direct Connect Hub for Linux
 *
 * Copyright (C) 2001 Eric Prevoteau
 *
 * passwd.h: Copyright (C) Yves BLUSSEAU
 *
 * $Id: passwd.h,v 2.5 2003/10/31 00:55:32 blusseau Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DCHUB_PASSWD_H__
#define __DCHUB_PASSWD_H__

#include "md5.h"

#define ENC_MD5_PASSWD_LEN (MD5_DIGEST_LENGTH*8/6)+2

/*********************************/
/* Encrypt and encode a password */
/***************************************************************************/
/* input:  msg: the password to encrypt                                    */
/*         output: a buffer to receive the encrypt password                */
/*                 The buffer must have space for ENC_MD5_PASSWD_LEN bytes */
/***************************************************************************/
void encrypt_password(const unsigned char *msg, unsigned char *output);

#endif /* __USERS_XML_H__ */
