/* DChub - a Direct Connect Hub for Linux
 *
 * Copyright (C) 2001 Eric Prevoteau
 *
 * passwd.c: Copyright (C) Yves BLUSSEAU
 *
 * $Id: passwd.c,v 2.9 2003/10/31 00:55:32 blusseau Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include "passwd.h"

#ifdef HAVE_LIBDMALLOC
#include <dmalloc.h>    /* Gray Watson's library */
#define show_alloc() dmalloc_log_unfreed()
#define show_stats() dmalloc_log_stats()
#else
#define show_alloc()    /* nothing */
#define show_stats()    /* nothing */
#endif

static void to64(char *s, unsigned long v, int n) {
    static unsigned char itoa64[] =         /* 0 ... 63 => ASCII - 64 */
        "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    while (--n >= 0) {
        *s++ = itoa64[v&0x3f];
        v >>= 6;
    }
}

void encrypt_password(const unsigned char *msg, unsigned char *output) {	
	unsigned char MD5bin[16];
	unsigned char *final=output;
	
	unsigned long l;

	MD5_ALGO(msg,strlen(msg), MD5bin);
	l = (MD5bin[0]<<16)  | (MD5bin[1]<<8)   | (MD5bin[2]);  to64(final, l, 4); final += 4;
	l = (MD5bin[3]<<16)  | (MD5bin[4]<<8)   | (MD5bin[5]);  to64(final, l, 4); final += 4;
	l = (MD5bin[6]<<16)  | (MD5bin[7]<<8)   | (MD5bin[8]);  to64(final, l, 4); final += 4;
	l = (MD5bin[9]<<16)  | (MD5bin[10]<<10) | (MD5bin[11]); to64(final, l, 4); final += 4;
	l = (MD5bin[12]<<16) | (MD5bin[13]<<10) | (MD5bin[14]); to64(final, l, 4); final += 4;
	l =                    (MD5bin[15]);                    to64(final, l, 2); final += 2;
	*final='\0';
}
