/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * md5.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: md5.h,v 2.3 2003/10/30 15:41:00 blusseau Exp $
*/

#ifndef __MD5_H__
#define __MD5_H__

#include <glib.h>

#ifdef WITH_GCRYPT
#include <gcrypt.h>
#define MD5_DIGEST_LENGTH 16
#define MD5_ALGO(source,len,dest)   gcry_md_hash_buffer(GCRY_MD_MD5,dest,source,len)
#else
#include <openssl/md5.h>
#define MD5_ALGO MD5
#endif

#include "common_defines.h"

/****************************************/
/* compute the MD5sum of the given bloc */
/**************************************************************************************************/
/* md_array is an array of MD_BLOC_SIZE bytes which will contain the MD5sum of the content of tbl */
/**************************************************************************************************/
void do_md5(guint8 *tbl, int tbl_len, guint8 *md_array);

/**************************************************************************/
/* convert a MD_BLOC_SIZE ID from its ascii version to its binary version */
/**************************************************************************/
void id_ascii_to_bin(unsigned char *asc_id, guint8 *bin_id);

/********************************************************************/
/* append the ASCII version of a binary array to the given g_string */
/********************************************************************/
void append_MD_to_str(GString *dest_base, const guint8 *id, const int len);


/* ed2k splits file in bloc of this size to compute its CRC */
#define PARTSIZE 9728000

#endif
