/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * main_cnx.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: main_cnx.c,v 2.6 2003/09/21 09:41:02 blusseau Exp $
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#ifdef HAVE_SYS_POLL_H
#include <sys/poll.h>
#else
#include "my_poll.h"
#endif

#ifdef WIN32
	#include <windows.h>
	#include <winsock2.h>
#else
	#include <sys/types.h>
	#include <sys/socket.h>
#endif

#include <glib.h>

#include "config.h"
#include "main.h"

#include "ged_if.h"
#include "network.h"
#include "timed_out_string.h"
#include "tos_key.h"
#include "gvar.h"
#include "main_cnx_handshake.h"

/* ************************************************************************** */
/* ************************************************************************** */
/* ************************************************************************** */
/* ******************* connection acceptation handler *********************** */
/* ************************************************************************** */
/* ************************************************************************** */
/* ************************************************************************** */

/*****************************************************************/
/* this socket fd is the one used to accept incoming connections */
/*****************************************************************/
static int main_sck;

static void	new_incoming_connection(void)
{
	int sock_fd;
	struct sockaddr_in remote;
	int x=sizeof(remote);
	char *dummy1;
	int dummy_len;

	sock_fd=accept(main_sck,(struct sockaddr *)&remote,&x);
	if(sock_fd==-1)
		return;

	/* we first check if someone doesn't try to flood the hub with dummy connection */
	if(get_tos_entry(CNX_TOSKEY,(char *)&(remote.sin_addr),sizeof(remote.sin_addr),0,&dummy1,&dummy_len)==1)
	{
		/*printf(stderr,"Connection attempt from the same ip in less than 10 seconds.\n"); */
		shutdown(sock_fd,SHUT_RDWR);
		close(sock_fd);
		return;
	}

	if(get_tos_entry(BAN_TOSKEY,(char *)&(remote.sin_addr),sizeof(remote.sin_addr),0,&dummy1,&dummy_len)==1)
	{
		/* fprintf(stderr,"Connection attempt from a banned ip.\n"); */
		send(sock_fd,"<Hub-Security> your ip is banned !!!|",37,0);
		shutdown(sock_fd,SHUT_RDWR);
		close(sock_fd);
		return;
	}

	/* put the address of the remote host in the CNX tos list */
	add_tos_entry(CNX_TOSKEY,10,(char *)&(remote.sin_addr),sizeof(remote.sin_addr),NULL,0);

	cnx_handshake_register_new_fd(sock_fd,&(remote.sin_addr));
}

/**************************/
/* function called at end */
/**************************/
static int main_sck_exit(const GED_CALLBACKS *ged)
{
	return 0;
}

/****************************/
/* add FD event to wait for */
/****************************/
static void main_sck_add_fd(const GED_CALLBACKS *ged, GArray *struct_pollfd_array)
{
	struct pollfd nw;

	nw.fd=main_sck;
	nw.events=POLLIN;
	nw.revents=0;

	g_array_append_val(struct_pollfd_array,nw);
}

/*******************************/
/* check for the arrived event */
/*******************************/
static void main_sck_scan_fd(const GED_CALLBACKS *ged, GArray *struct_pollfd_array, int low_range, int high_range)
{
	/* because we have only 1 entry, its location is at the "low_range" of the struct_pollfd_array */
	struct pollfd *nw;

	nw=&(g_array_index(struct_pollfd_array,struct pollfd,low_range));

	if(nw->revents&POLLIN)
	{
		new_incoming_connection();
	}
}

/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/* ---------------------- initialization of the handler --------------------- */
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
static GED_CALLBACKS main_sck_ged=
				{
					"main_sck GED", /* ged_name For debug */
					main_sck_exit, /* destructor */
					main_sck_add_fd, 
					main_sck_scan_fd,
               NULL,
               NULL,
               NULL,
					NULL
				};

/**************************************/
/* function initializing the main_sck */
/**************************************/
GED_CALLBACKS *main_sck_init(void)
{
	main_sck=_x_tcp(hub_port);
	if(main_sck==-1)
	{
		fprintf(stderr,"Unable to create hub port.\n");
		/* unlike other GED, this function must not fail */
		exit(1);
	}
	listen(main_sck,64);
	return &main_sck_ged;
}

