/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * hub_passwd.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: hub_passwd.h,v 2.6 2003/02/25 14:43:16 ericprev Exp $
*/

#ifndef __HUB_PASSWD_H__
#define __HUB_PASSWD_H__

#include "lmp.h"
#include "chunk_codes.h"

/*********************/
/* hub password file */
/*********************/
extern char *hub_passwd_file;

/**************************/
/* hub password LMP entry */
/**************************/
LMP_ENTRY *hp_lmp;

/****************************/
/* HUB_PASS_ROW entry_flags */
/****************************/
#define HPR_EF_EMPTY 0
#define HPR_EF_BUSY 1

/******************************/
/* HUB_PASS_ROW special_flags */
/******************************/
#define HPR_SF_AUTO_START (1<<0)
#define HPR_SF_REJECTED (1<<1)

/****************************************/
/* list of all flags disabling password */
/****************************************/
#define INVALID_HPR_SF (HPR_SF_REJECTED)

/******************/
/* a row uses 1KB */
/******************/
typedef struct
{
	guint16 entry_flags;		/* free or busy ? */
	guint16 special_flags;
	guint8 hub_id[HUB_ID_LEN];
	guint8 cluster_id[MD_BLOC_SIZE];
	char hub_address[128];	/* null terminated string */
	time_t last_connection_attempt;
	char reserved[1024-128-HUB_ID_LEN-MD_BLOC_SIZE-2*sizeof(guint16)-sizeof(time_t)];
} HUB_PASS_ROW;

/***********************************************************************/
/* search in the passwd for a hub_id matching the given one and return */
/* its cluster_id in the appropriate array.                            */
/***********************************************************************/
/* output: FALSE = hub_id not found               */
/*         TRUE = hub_id found, cluster_id loaded */
/**************************************************/
gboolean hub_passwd_get_clus_id_from_hub_id(guint8 *hub_id, guint8 *cluster_id);

/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/* ----------------------------- misc functions ----------------------------- */
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/*******************************************************************************/
/* update the last_connect_attempt field of the row with the given hub_address */
/*******************************************************************************/
void hub_passwd_touch_last_attempt_from_hub_address(const char *hub_address);

/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/* ------------------------------ hub commands ------------------------------ */
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/**********************/
/* set a password row */
/**********************/
void ucmd_hp_set(HUB_PASS_ROW *hpr);

/**********************/
/* get a password row */
/**********************/
HUB_PASS_ROW *ucmd_hp_get(guint8 *hub_id);

/*************************/
/* get all password rows */
/**********************************************************************************/
/* NOTE: some rows can have entry_flags set to HPR_EF_EMPTY and should be ignored */
/**********************************************************************************/
HUB_PASS_ROW *ucmd_hp_get_rows(int *nb_rows);

/*************************/
/* delete a password row */
/*******************************/
/* output: TRUE: delete ok     */
/*         FALSE: delete error */
/*******************************/
gboolean ucmd_hp_del(guint8 *hub_id);

/**************************************/
/* clear connection attempt timestamp */
/**************************************/
/* output: TRUE: delete ok     */ 
/*         FALSE: delete error */
/*******************************/
gboolean ucmd_hp_reset_last_cnx_attempt(guint8 *hub_id);

#endif

