/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * gvar.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: gvar.h,v 2.10 2003/11/05 18:03:49 ericprev Exp $
*/

#ifndef __GVAR_H__
#define __GVAR_H__

#include <regex.h>
#include <time.h>

extern time_t gl_cur_time;

extern unsigned short reg_hub_port;
extern unsigned short cluster_port;

/****************************************************/
/* to manage simultaneous incoming user connections */
/****************************************************/
extern int remaining_allowed_incoming_cnx;
G_LOCK_EXTERN(remaining_allowed_incoming_cnx);

extern int user_wants_to_quit;		/* set to a non-null value to force the main loop to quit */

/****************/
/* LOCK_PATTERN */
/****************/
extern GPtrArray *gl_lock_patern;
G_LOCK_EXTERN(gl_lock_patern);

/***************************************/
/* some vars used for Perl interpreter */
/* these vars are READ-ONLY.           */
/***************************************/
extern char *perl_script_dir;
extern char *perl_script_main;

/*****************************************/
/* somes vars used for external programs */
/*****************************************/
extern char *ext_prog_dir;

/********************************/
/* directory containing plugins */
/********************************/
extern char *plugin_directory;


extern int	gl_sr_interval;		/* min time beween 2 search */
extern int	gl_moderate_mode;	/* limit the chat to op only */
extern int	gl_silent_limit;	/* antiflood protection */
extern int	gl_kick_limit;		/* antiflood protection */
extern int	gl_buf_size;
#if 0
extern int	gl_reg_sock;		/* reg sock */
extern int	gl_resolver_fd;		/* fd of the dns resolver */
#endif

extern int	gl_peek_user;		/* peek user count */

#endif
