/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * ged.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: ged.h,v 2.1 2003/01/31 05:49:40 eric Exp $
*/

#ifndef __GED_H__
#define __GED_H__

#include "ged_if.h"

/******************************/
/* register a new GED handler */
/**********************************************************************/
/* smallest priority value means the function has an highest priority */
/**********************************************************************/
void ged_register(GED_INIT fnc, int priority);

/****************************/
/* unregister a GED handler */
/*********************************************************************/
/* NOTE: an unregister handler still receives calls as long as its   */
/* exit function has not been called. it is just tagged for deletion */
/* until then.                                                       */
/*********************************************************************/
void ged_unregister(GED_CALLBACKS *nw);

/***************************************************************************/
/* function called before the poll call to add the FD to poll to the array */
/***************************************************************************/
void ged_pre_poll(GArray *pollfd_struct);

/************************************************************************************************************/
/* function called after the poll call to scan the array and perform tasks according to the occuring events */
/************************************************************************************************************/
void ged_post_poll(GArray *pollfd_struct);

/***********************************************/
/* function called to start GED periodic tasks */
/***********************************************/
void ged_periodic(void);

/***********************************************/
/* function called to start GED end loop tasks */
/***********************************************/
void ged_always(void);

/**********************************************/
/* function called to call GED exit functions */
/**********************************************/
void ged_exit(void);

#endif
