/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * g_string_ref.c: Copyright (C) Uriel Chemouni <uriel@adess.dyndns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: g_string_ref.c,v 2.1 2003/02/04 17:33:11 eric Exp $
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "g_string_ref.h"

void *g_string_ref_free(GString_ref *str)
{
	if (str)
	{
		if (--(str->count) <= 0)
		{
			g_string_free(str->data, TRUE);
			free(str);
		}
	}
	return(NULL);
}

GString_ref	*conv_gstring_to_gstring_ref(GString *str)
{
	GString_ref	*out;

	if (!str)
		return (NULL);
	out = malloc(sizeof(GString_ref));
	out->count = 1;
	out->data = str;
	return(out);
}

GString_ref	*g_string_ref_new(const char *str)
{
	GString_ref	*out;

	if (!str)
		return (NULL);
	out = malloc(sizeof(GString_ref));
	out->count = 1;
	out->data = g_string_new(str);
	return(out);
}

GString_ref *g_string_ref_sized_new(int size)
{
	GString_ref	*out;

	if (size == 0)
		return (NULL);
	out = malloc(sizeof(GString_ref));
	out->count = 1;
	out->data = g_string_sized_new(size);
	return(out);
}

GString_ref *g_string_ref_append(GString_ref *string, const char *val)
{
	if (string == NULL)
		g_warning ("g_string_ref_append(): NULL value receved.");
	else
		g_string_append(string->data, val);
	return string;
}

GString_ref *g_string_ref_append_c(GString_ref *string, char c)
{
	if (string == NULL)
		g_warning ("g_string_ref_append_c(): NULL value receved.");
	else
		g_string_append_c(string->data, c);
	return string;
}

GString_ref *g_string_ref_prepend(GString_ref *string, const char *val)
{
	if (string == NULL)
		g_warning ("g_string_ref_prepend(): NULL value receved.");
	else
		g_string_prepend(string->data, val);
	return string;
}

GString_ref *g_string_ref_prepend_c(GString_ref *string, char c)
{
	if (string == NULL)
		g_warning ("g_string_ref_prepend_c(): NULL value receved.");
	else
		g_string_prepend_c(string->data, c);
	return string;
}

GString_ref *g_string_ref_insert(GString_ref *string, int pos, const char *val)
{
	if (string == NULL)
		g_warning ("g_string_ref_insert(): NULL value receved.");
	else
		g_string_insert(string->data, pos, val);
	return string;
}

GString_ref *g_string_ref_insert_c(GString_ref *string, int pos, char c)
{
	if (string == NULL)
		g_warning ("g_string_ref_insert_c(): NULL value receved.");
	else
		g_string_insert_c(string->data, pos, c);
	return string;
}

GString_ref *g_string_ref_truncate(GString_ref *string, int len)
{
	if (string == NULL)
		g_warning ("g_string_ref_truncate(): NULL value receved.");
	else
		g_string_truncate(string->data, len);
	return string;
}
