#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <glib.h>
#include <stdarg.h>
#include "passwd.h"

#ifdef HAVE_GETOPT_LONG
	#include <getopt.h>
#endif

#ifdef HAVE_LIBDMALLOC
#include <dmalloc.h>    /* Gray Watson's library */
#define show_alloc() dmalloc_log_unfreed()
#define show_stats() dmalloc_log_stats()
#else
#define show_alloc()    /* nothing */
#define show_stats()    /* nothing */
#endif

const char* clear_passwd;

static void	display_usage(char *prog) {
	fprintf(stderr,"Usage: %s clear_text_password\n"
			"Options:\n"
			"\t-h, --help                   Display this help\n"
#ifndef HAVE_GETOPT_LONG
			"\n  WARNING this build do not support long arguments\n"
#endif	
			"\n", prog);
}

static void parse_command_line_options(int argc,char **argv) {
#ifdef HAVE_GETOPT_LONG
	static struct option optab[]= {
		{"help",no_argument,NULL,'h'},           /* get help */
		{NULL,0,NULL,'\0'}               /* last option */
	};
#endif
	static const char *short_opt="h";
	int ch;
	opterr = 0;
	
#ifdef HAVE_GETOPT_LONG
	while((ch=getopt_long(argc,argv,short_opt,optab,NULL))!=EOF) {
#else
	while((ch=getopt(argc,argv,short_opt))!=EOF) {		
#endif
		switch(ch) {
			case 'h':
				display_usage(argv[0]);
				exit(0);
				break;
			default:
				fprintf(stderr,"Unknown option: %c\n",ch);
				exit(1);
		}
	}

	if ((argc-optind) != 1) {
		display_usage(argv[0]);
		exit(0);
	}

	clear_passwd=argv[optind];
}
	
int main(int argc, char **argv)  {
	char enc_passwd[ENC_MD5_PASSWD_LEN];

	parse_command_line_options(argc,argv);

	encrypt_password(clear_passwd, enc_passwd);

	printf("%s\n",enc_passwd);
	
	return 0;
}
