/* DChub - a Direct Connect Hub for Linux
 *
 * Copyright (C) 2001 Eric Prevoteau
 *
 * db_xml.h: Copyright (C) Yves BLUSSEAU
 *
 * $Id: db_xml.h,v 1.3 2003/10/19 12:48:09 blusseau Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DB_XML_H__
#define __DB_XML_H__

extern const char* DB_TYPE[];
enum {TYPE_STR, TYPE_INT, TYPE_FLOAT, NO_MORE_TYPE};

/****************************************/
/* load the XML database file in memory */
/****************************************/
/* return: TRUE=ok, FALSE=error         */
/****************************************/
gboolean loadDBFile(const char* filename);

gboolean db_str_set(const char* name, const char* value);
char* db_str_get(const char* name);
gboolean db_int_set(const char* name, int value);
gboolean db_int_get(const char* name, int* value);
gboolean db_float_set(const char* name, double value);
gboolean db_float_get(const char* name, float* value);
gboolean db_del(const char* name);
int db_type_get(const char *name);

/****************************************************************/
/* dump the db content into name, type, value string array      */
/* if any input value==NULL, the value is created               */
/****************************************************************/
/* return: TRUE=ok, FALSE=error */
/********************************/
gboolean db_get_all_keys(GPtrArray **name, GPtrArray **type, GPtrArray **value, GStringChunk **gsc);

void xml_dump_db(const char *filename);
void xml_free_db_resource();
#endif /* __DB_XML_H__ */
