#! /usr/bin/perl

# $Id: dchub_perl_functions.pl,v 2.1 2003/07/13 13:46:11 blusseau Exp $

use strict;

# Some usefull functions that can be used in all scripts.

#******************************************************************************
# Escape a string
#	parametre 1: string to escape
#	return an escaped string
sub escape($) {
	my $msg=shift;
	$msg=~s/\|/&#124;/g; # Convert the | char
	$msg=~s/\$/&#36;/g;  # Convert the $ char
	return $msg;
}

#******************************************************************************
# Unscape a string
#	parametre 1: string to unescape
#	return an unescaped string
sub unescape($) {
	my $msg=shift;
	$msg=~s/&#124;/|/g; # Convert the &#124; to | char
	$msg=~s/&#36;/\$/g;	# Convert the /&#36; to $ char
	return $msg;
}

#******************************************************************************
# Remove quote or double quote
#	parametre 1: string to unquote
#	return a string without quote or double quote around.
sub unquote($) {
	my $str=shift;
	$str=~s|(^["'])(.*)\1$|$2|; # " Fix Xemacs fontification
	return $str;
}

#******************************************************************************
# Round function (like in math.h :) )
sub round {
    my($number) = shift;
    return int($number + .5);
}

1;
