/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * plg_passwd.c: Copyright (C) Dirk Rieger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: plugin_passwd.c,v 2.1 2003/11/22 18:20:28 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib.h>

#include "dchub_plugin_api.h"
#include "../src/users_xml.h"

static void plg_do_passwd(const char *source_nick, const char *dest_nick, const char *passwd)
{
	GString *reply;
	reply=g_string_new("");
   if(dest_nick!=NULL)
	{
		g_string_sprintf(reply,"$To: %s From: %s $",source_nick,dest_nick);
	}
   g_string_append(reply,"<INFO> ");

	if((source_nick==NULL)||
		(strlen(source_nick)==0)||
		(!xml_get_user(source_nick, NULL, NULL, NULL, NULL))		/* function returns false for not register users */
	  )
	{
		g_string_append(reply,"This command is for registered users only !!!\r\n");
	}
	else
	{
		if(passwd==NULL)
		{
			g_string_append(reply,"Please use this command the following way:\r\n"
						"+passwd OldPassword NeWPassword\r\n");
		}
		else
		{
			char **info;

			info=g_strsplit(passwd," ",0);
			if((info!=NULL)&&
				((info[0]==NULL)||(info[1]==NULL)||(info[2]!=NULL))		/* 2 first pointers must NOT be NULL, the 3rd must be NULL */
			  )
			{
				/* 0= oldpw */
				/* 1= newpw */
				/* 2= NULL (end of array) */
				if(strlen(info[1])<=3)
					g_string_append(reply,"The new password should contain more than 3 characters !!!\r\n");
				else
				{
					char *opassword;
					unsigned char passMD5ascii[ENC_MD5_PASSWD_LEN];
					if(!xml_get_user(source_nick,NULL,&opassword,NULL,NULL))
						g_string_append(reply,"Error - User not found !!!\r\n");
					else
					{
						encrypt_password(info[0],passMD5ascii);
						if(strcmp(passMD5ascii,info[0]))
						{
							g_string_append(reply,"The old password doesn't match !!!\r\n");
						}
						else
						{
							/* don't encode the new password, the function will do it */
							if (!xml_chg_user_properties(source_nick, NULL, &(info[1]), NULL, NULL))
								g_string_append(reply,"Error while changing password !!!\r\n");
							else
								g_string_sprintfa(reply,"Password changed from '%s' to '%s'\r\n",info[0],info[1]);
						}
					}
					free(opassword);
				}
			}
			else
			{
				g_string_append(reply,"Please use this command the following way:\r\n"
									"+passwd OldPassword NewPassword\r\n");
			}
			if(info!=NULL)
				g_strfreev(info);
		}	
	}
	g_string_append_c(reply,'|');
	plugin_send_to_named_user(source_nick,reply->str);
	g_string_free(reply,TRUE);
	return;
}


/* ########################################################################## */
/* ########################################################################## */
/* ########################################################################## */
/* ############################## hub interface ############################# */
/* ########################################################################## */
/* ########################################################################## */
/* ########################################################################## */
static void process_command(const char *source_nick, const char *dest_nick, const char *chat)
{
	if(chat[0]=='+')		/* it is a command */
	{
		GString *cmd;
		char *a;
		gchar *param=NULL;

		cmd=g_string_new(chat);
		g_string_truncate(cmd,cmd->len-1);	/* remove the trailing '|' */

		a=strchr(cmd->str,' ');
		if(a!=NULL)
		{
			if(strlen(a+1)!=0)
			{
				param=g_strdup(a+1);
			}
			g_string_truncate(cmd,a-cmd->str);	/* truncate where the space is */
		}

		if(!strcmp(cmd->str,"+passwd"))
			plg_do_passwd(source_nick,dest_nick,param);

		if(param)
			g_free(param);
		g_string_free(cmd,TRUE);
	}
}

static void globalchat_fnc(const GArray *param)
{
	if(param!=NULL)
	{
		const char *source_nick;
		const char *fullmsg;

		source_nick=g_array_index(param,PLUGIN_PARAM,1).varvalue;
		fullmsg=g_array_index(param,PLUGIN_PARAM,3).varvalue;

		if(strlen(fullmsg)>0)
		{
			char *ptr;

			ptr=strchr(fullmsg,' ');

			if(ptr!=NULL)
			{
				ptr++;
				process_command(source_nick,NULL,ptr);
			}
      }
	}
	return;
}

static void privchat_fnc(const GArray *param)
{
	if(param!=NULL)
	{
		const char *source_nick;
		const char *dest_nick;
		const char *fullmsg;

		source_nick=g_array_index(param,PLUGIN_PARAM,1).varvalue;
		dest_nick=g_array_index(param,PLUGIN_PARAM,3).varvalue;
		fullmsg=g_array_index(param,PLUGIN_PARAM,4).varvalue;
		if(fullmsg!=NULL)
		{
			char *ptr;

			ptr=strchr(fullmsg,' ');

			if(ptr!=NULL)
			{
				*ptr++;
				process_command(source_nick,dest_nick,ptr);
			}
		}
	}
	return;
}

/*****************************************************/
/* this function is called when the plugin is loaded */
/*****************************************************/
int plugin_beginning(PLUGIN *plug)
{
	printf("beginning of the PASSWD plugin\n");

	register_dchub_plugin_event(plug,"globalchat", globalchat_fnc);
	register_dchub_plugin_event(plug,"privchat", privchat_fnc);

	return 0;		/* success */
}

/************************************************************/
/* this function is called just before unloading the plugin */
/************************************************************/
int plugin_end(PLUGIN *plug)
{
	printf("end of the PASSWD plugin\n");
	return 0;		/* success */
}

