/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * plg_help.c: Copyright (C) Dirk Rieger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: plugin_help.c,v 2.3 2003/11/23 06:53:25 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib.h>

#include "dchub_plugin_api.h"
#include "generic_help.h"
#include "../src/global_user_if.h"
#include "../src/users_xml.h"

static char *filepath="no_path";

static void open_file(const char *source_nick, const char *dest_nick, const char *filename)
{
	GString *freply;

	freply=g_string_new("");
	if(dest_nick!=NULL)
	{
		g_string_sprintf(freply,"$To: %s From: %s $",source_nick,dest_nick);
	}
	g_string_append(freply,"<INFO> ");

	if(!strcmp(filepath,"no_path"))
	{
		g_string_append(freply,"Please set the path to your textfiles at top of plugin_help.c !!!");
	}
	else
	{
		GString *ofile;
		gsize h_length;
		GError *err=NULL;
		gchar *content;

		ofile=g_string_new("");
		g_string_sprintf(ofile,"%s%s",filepath,filename);

		if(g_file_get_contents(ofile->str,&content,&h_length,&err)==TRUE)
		{
			g_string_append(freply,content);
			g_free(content);
		}
		else
		{
			g_string_append(freply,"Sorry - file not available");
			g_error_free(err);
		}
		
		g_string_free(ofile,TRUE);
	}
	g_string_append_c(freply,'|');
	plugin_send_to_named_user(source_nick,freply->str);
	g_string_free(freply,TRUE);
	
	return;
}

static void plg_do_help(const char *source_nick,const char *dest_nick,const char *postcmd)
{
	GString *reply;
	gboolean send_reply=TRUE;

	reply=g_string_new("");
	if(dest_nick!=NULL)
	{
		g_string_sprintf(reply,"$To: %s From: %s $",source_nick,dest_nick);
	}
	g_string_append(reply,"<INFO> ");

	if(postcmd==NULL)
	{
		gint16 level;

		standard:
		g_string_append(reply,befehle);	/* general help */

		/* add help message according to user level */
		if(xml_get_user(source_nick, &level, NULL, NULL, NULL))  /* is a registered user ? */
		{
			g_string_append_printf(reply,"%s",regbefehle);	  /* help for all registered users */

			if(level>=get_right_level(OPERATOR))
				g_string_append_printf(reply,"%s",opbefehle);	/* and for OP and above */
		}
	}
	else if(!strncmp(postcmd,"me",2))
	{
		char *filename="helpme.txt";
		open_file(source_nick,dest_nick,filename);
		send_reply=FALSE;
	}
	else if(!strncmp(postcmd,"op",2))
	{
		GString *lists[2];
		gchar **opnames;
		int i;

		glus_get_nick_lists(&lists[0],&lists[1]);
		/* we don't need the userlist so use the lists[0] for the message to send to each op */
		opnames=g_strsplit(lists[1]->str,"$$",0);
		i=0;
		while(opnames[i]!=NULL)
		{
			/* exclude bots here */
			if(strcmp(opnames[i],"+++++++++++++"))
			{
				g_string_sprintf(lists[0],"$To: %s From: Hub-Security $<Hub-Security> The user %s needs help...|",opnames[i],source_nick);
				plugin_send_to_named_user(opnames[i],lists[0]->str);
			}
			i++;
		}
		g_strfreev(opnames);
		g_string_free(lists[0],TRUE);
		g_string_free(lists[1],TRUE);
		g_string_append(reply,"An OP will reply to your call...");
	}
	else
		goto standard;

	if(send_reply)
	{
		g_string_append_c(reply,'|');
		plugin_send_to_named_user(source_nick,reply->str);
	}
	g_string_free(reply,TRUE);
	return;
}

void plg_do_subhelp(const char *source_nick,const char *dest_nick,const char *helpfile)
{
	if(helpfile==NULL)
	{
		char *filename="helpme.txt";
		open_file(source_nick,dest_nick,filename);
	}
	else
	{
		int i=atoi(helpfile);
		/* change to the number of helpfiles you have here */
		if(i<=0 || i>=14)
		{
			GString *reply;
			reply=g_string_new("");
			if(dest_nick!=NULL)
			{
				g_string_sprintf(reply,"$To: %s From: %s $",source_nick,dest_nick);
			}
			g_string_append(reply,"<INFO> invalid Number for this helpfile !!!|");
			plugin_send_to_named_user(source_nick,reply->str);
			g_string_free(reply,TRUE);
		}
		else
		{
			GString *fname;
			fname=g_string_new("help");
			g_string_append_printf(fname,"%i.txt",i);
			open_file(source_nick,dest_nick,fname->str);
			g_string_free(fname,TRUE);
		}
	}
	return;
}

static void plg_do_hubregeln(const char *source_nick,const char *dest_nick)
{
	char *filename="hubregeln.txt";
	open_file(source_nick,dest_nick,filename);
	return;
}

static void plg_do_hubrules(const char *source_nick,const char *dest_nick)
{
	char *filename="hubrules.txt";
	open_file(source_nick,dest_nick,filename);
	return;
}

void plg_do_commands(const char *source_nick,const char *dest_nick)
{
   GString *reply;
   gint16 level;

   reply=g_string_new("");
   if(dest_nick!=NULL)
      g_string_sprintf(reply,"$To: %s From: %s $",source_nick,dest_nick);
	g_string_sprintfa(reply,"<INFO> %s",befehle);

	if(xml_get_user(source_nick, &level, NULL, NULL, NULL))
	{
      g_string_append(reply,regbefehle);
		if(level>=get_right_level(OPERATOR))
      	g_string_append(reply,opbefehle);
	}

   g_string_append_c(reply,'|');
   plugin_send_to_named_user(source_nick,reply->str);
   g_string_free(reply,TRUE);

   return;
}

/* ########################################################################## */
/* ########################################################################## */
/* ########################################################################## */
/* ############################## hub interface ############################# */
/* ########################################################################## */
/* ########################################################################## */
/* ########################################################################## */
static void process_command(const char *source_nick, const char *dest_nick, const char *chat)
{
	if(chat[0]=='+')		/* it is a command */
	{
		GString *cmd;
		char *a;
		gchar *param=NULL;

		cmd=g_string_new(chat);
		g_string_truncate(cmd,cmd->len-1);	/* remove the trailing '|' */

		a=strchr(cmd->str,' ');
		if(a!=NULL)
		{
			if(strlen(a+1)!=0)
			{
				param=g_strdup(a+1);
			}
			g_string_truncate(cmd,a-cmd->str);	/* truncate where the space is */
		}

		if(!strcmp(cmd->str,"+hubregeln") || !strcmp(cmd->str,"+regeln"))
			plg_do_hubregeln(source_nick,dest_nick);
		else if(!strcmp(cmd->str,"+hubrules") || !strcmp(cmd->str,"+rules"))
			plg_do_hubrules(source_nick,dest_nick);
		else if(!strcmp(cmd->str,"+commands"))
			plg_do_commands(source_nick,dest_nick);
		else if(!strcmp(cmd->str,"++help"))
			plg_do_help(source_nick,dest_nick,param);
		else if(!strcmp(cmd->str,"+++help"))
			plg_do_subhelp(source_nick,dest_nick,param);


		if(param)
			g_free(param);
		g_string_free(cmd,TRUE);
	}
}

static void globalchat_fnc(const GArray *param)
{
	if(param!=NULL)
	{
		const char *source_nick;
		const char *fullmsg;

		source_nick=g_array_index(param,PLUGIN_PARAM,1).varvalue;
		fullmsg=g_array_index(param,PLUGIN_PARAM,3).varvalue;

		if(strlen(fullmsg)>0)
		{
			char *ptr;

			ptr=strchr(fullmsg,' ');

			if(ptr!=NULL)
			{
				ptr++;
				process_command(source_nick,NULL,ptr);
			}
      }
	}
	return;
}

static void privchat_fnc(const GArray *param)
{
	if(param!=NULL)
	{
		const char *source_nick;
		const char *dest_nick;
		const char *fullmsg;

		source_nick=g_array_index(param,PLUGIN_PARAM,1).varvalue;
		dest_nick=g_array_index(param,PLUGIN_PARAM,3).varvalue;
		fullmsg=g_array_index(param,PLUGIN_PARAM,4).varvalue;
		if(fullmsg!=NULL)
		{
			char *ptr;

			ptr=strchr(fullmsg,' ');

			if(ptr!=NULL)
			{
				*ptr++;
				process_command(source_nick,dest_nick,ptr);
			}
		}
	}
	return;
}

/*****************************************************/
/* this function is called when the plugin is loaded */
/*****************************************************/
int plugin_beginning(PLUGIN *plug)
{
	printf("beginning of the HELP plugin\n");

	register_dchub_plugin_event(plug,"globalchat", globalchat_fnc);
	register_dchub_plugin_event(plug,"privchat", privchat_fnc);

	return 0;		/* success */
}

/************************************************************/
/* this function is called just before unloading the plugin */
/************************************************************/
int plugin_end(PLUGIN *plug)
{
	printf("end of the HELP plugin\n");
	return 0;		/* success */
}

