/* DCHub - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * ulist.c: Copyright (C) Dirk Rieger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: ulist.c,v 2.3 2003/05/06 16:57:16 ericprev Exp $
*/

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <glib.h>

#include "ulist.h"

/********************************/
/* free 1 user xtra information */
/********************************/
void free_xtra_info(XTRA_INFO *xi)
{
#if 0
   printf("free xtra info start\n");
#endif
   if(xi==NULL)
      return;
   if(xi->addr->str!=NULL)
		g_string_free(xi->addr,TRUE);
   if(xi->client->str!=NULL)
      g_string_free(xi->client,TRUE);
   if(xi->versionadd->str!=NULL)
      g_string_free(xi->versionadd,TRUE);
   if(xi->d_client->str!=NULL)
      g_string_free(xi->d_client,TRUE);
   if(xi->d_versionadd->str!=NULL)
      g_string_free(xi->d_versionadd,TRUE);
   if(xi->locka->str!=NULL)
      g_string_free(xi->locka,TRUE);
   if(xi->lockb->str!=NULL)
      g_string_free(xi->lockb,TRUE);
   if(xi->lockc->str!=NULL)
      g_string_free(xi->lockc,TRUE);
   if(xi->pka->str!=NULL)
      g_string_free(xi->pka,TRUE);
   if(xi->pkb->str!=NULL)
      g_string_free(xi->pkb,TRUE);
   if(xi->pkc->str!=NULL)
      g_string_free(xi->pkc,TRUE);
	if(xi->utype!=NULL)
		free(xi->utype);
	free(xi);
#if 0
   printf("free xtra info finished\n");
#endif
}

/*********************************/
/* empty the hub_user_list array */
/*********************************/
void reset_hub_user_list(void)
{
   int i;
   char *p;

   G_LOCK(hub_user_list);
   /* reset hub user list */
   if(hub_user_list!=NULL)
   {
#if 0
      printf("resetting hub_user_list\n");
#endif
      for(i=0;i<hub_user_list->len;i++)
      {
         p=g_ptr_array_index(hub_user_list,i);
         if(p)
            free(p);
      }
      g_ptr_array_free(hub_user_list,TRUE);
   }
   hub_user_list=g_ptr_array_new();

   /* reset hub user uinfo */
   if(hub_user_uinfo!=NULL)
   {
#if 0
      printf("resetting hub_user_uinfo\n");
#endif
      for(i=0;i<hub_user_uinfo->len;i++)
      {
         p=g_ptr_array_index(hub_user_uinfo,i);
         if(p)
            free(p);
      }
      g_ptr_array_free(hub_user_uinfo,TRUE);
   }
   hub_user_uinfo=g_ptr_array_new();

   /* reset hub op list */
   if(hub_op_list!=NULL)
   {
#if 0
      printf("resetting hub_op_list\n");
#endif
      for(i=0;i<hub_op_list->len;i++)
      {
         p=g_ptr_array_index(hub_op_list,i);
         if(p)
            free(p);
      }
      g_ptr_array_free(hub_op_list,TRUE);
   }
   hub_op_list=g_ptr_array_new();

   /* reset hub user xtra info */
   if(hub_user_xtra_info!=NULL)
   {
#if 0
      printf("resetting hub_user_xtra_info\n");
#endif
      for(i=0;i<hub_user_xtra_info->len;i++)
      {
#if 0
         printf("reset hub user list calling free_xtra_info\n");
#endif
         free_xtra_info(g_ptr_array_index(hub_user_xtra_info,i));
      }
      g_ptr_array_free(hub_user_xtra_info,TRUE);
   }
   hub_user_xtra_info=g_ptr_array_new();
#if 0
   printf("resetting hub user list finished\n");
#endif
   G_UNLOCK(hub_user_list);
}

/*******************************************/
/* add the given nick to the hub user list */
/*******************************************/
void add_user_to_user_list(const char *nick)
{
   int i;
   int gotcha=FALSE;
   char *p;
#if 0
   printf("start add user to user list: %s\n",nick);
#endif
   if(hub_user_list==NULL)
   {
      reset_hub_user_list();          /* if the list is not yet available, reset it */
#if 0
      printf("hub_user_list resetted\n");
#endif
   }
   /* don't lock before because reset_* also locks */
#if 0
	printf("add user to userlist trying to lock hub user list\n");
#endif
	if(strcmp(nick,"Hub-Security"))
	{
   	G_LOCK(hub_user_list);
#if 0
		printf("add user to userlist locked hub user list\n");
#endif

   	/* search the given nick in the user list */
   	for(i=0;i<hub_user_list->len;i++)
   	{
	      p=g_ptr_array_index(hub_user_list,i);
#if 0
   	   printf("add user comparing: %s %s %s\n",(char *)nick,p,(char *)g_ptr_array_index(hub_user_list,i));
#endif
      	if(strcmp(nick,p)==0)
	      {
   	      gotcha=TRUE;
#if 0
      	   printf("%s already in user list...\n",nick);
#endif
         	break;
	      }
   	}

	   if(gotcha==FALSE)
   	{
      	/* not found, add it */
	      p=strdup(nick);
   	   if(p!=NULL)
      	{
#if 0
         	printf("adding to user list: %s %s\n",(char *)nick,p);
#endif
	         g_ptr_array_add(hub_user_list,p);
   	      g_ptr_array_add(hub_user_uinfo,NULL);                  /* add the UINFO pointer at the same time */
      	   g_ptr_array_add(hub_user_xtra_info,NULL);               /* add the xtra_info pointer at the same time */
	      }
   	}
#if 0
		printf("add user to userlist trying to unlock hub user list\n");
#endif
   	G_UNLOCK(hub_user_list);
#if 0
	printf("add user to userlist unlocked hub user list\n");
#endif
	}
}

/*****************************************/
/* add the given nick to the hub op list */
/*****************************************/
int add_user_to_op_list(const char *nick)
{
   int i;
	int ret=FALSE;
   int gotcha=FALSE;
   char *p;

   if(hub_op_list==NULL)
      reset_hub_user_list();           /* if the list is not yet available, reset it */

#if 0
	printf("add user to oplist trying to lock hub user list\n");
#endif
	if(strcmp(nick,"Hub-Security"))
	{
	   G_LOCK(hub_user_list);
#if 0
		printf("add user to oplist locked hub user list\n");
#endif
	   /* search the given nick in the user list */
   	for(i=0;i<hub_op_list->len;i++)
	   {
   	   p=g_ptr_array_index(hub_op_list,i);
#if 0
      	printf("add op comparing: %s %s %s\n",(char *)nick,p,(char *)g_ptr_array_index(hub_user_list,i));
#endif

	      if(strcmp(nick,p)==0)
   	   {
      	   gotcha=TRUE;
         	break;                     /* we have found it */
      	}
   	}

	   /* not found, add it */
   	p=strdup(nick);
	   if(gotcha==FALSE)
   	{
      	if(p!=NULL)
	      {
#if 0
	         printf("adding op to list: %s %s\n",(char *)nick,p);
#endif
   	      g_ptr_array_add(hub_op_list,p);
				ret=TRUE;
	      }
   	}
#if 0
		printf("add user to oplist trying to unlock hub user list\n");
#endif
   	G_UNLOCK(hub_user_list);
#if 0
	printf("add user to oplist unlocked hub user list\n");
#endif
	}
	return ret;
}

/**********************************************/
/* remove the given nick to the hub user list */
/**********************************************/
int remove_user_to_user_list(const char *nick)
{
	int ret=FALSE;
#if 0
   printf("start remove user to ulist: %s - trying to lock hub user list\n",nick);
#endif
   G_LOCK(hub_user_list);
#if 0
	printf("remove user to ulist locked hub user list\n");
#endif

   if(hub_user_list!=NULL)
   {
      int i;

      /* search the given nick in the user list */
      for(i=0;i<hub_user_list->len;i++)
      {
         char *p;

         p=g_ptr_array_index(hub_user_list,i);
#if 0
         printf("remove user comparing: %s %s %s\n",(char *)nick,p,(char *)g_ptr_array_index(hub_user_list,i));
#endif
         if(strcmp(nick,p)==0)
         {
            /* free(p); */
            g_ptr_array_remove_index_fast(hub_user_list,i);
            g_ptr_array_remove_index_fast(hub_user_uinfo,i);
            /* if(p) */
               /* free(p); */
#if 0
            printf("remove user to user list calling free_xtra_info\n");
#endif
            free_xtra_info(g_ptr_array_remove_index_fast(hub_user_xtra_info,i));            /* free xtra information at the same time */
				ret=TRUE;
            break;
         }
      }

      /* the user is perhaps also an op */
      for(i=0;i<hub_op_list->len;i++)
      {
         char *p;

         p=g_ptr_array_index(hub_op_list,i);
#if 0
         printf("remove op comparing: %s %s %s\n",(char *)nick,p,(char *)g_ptr_array_index(hub_op_list,i));
#endif

         if(strcmp(nick,g_ptr_array_index(hub_op_list,i))==0)
         {
            /* free(p); */
            g_ptr_array_remove_index_fast(hub_op_list,i);
            break;
         }
      }
   }
#if 0
	printf("remove user to ulist trying to unlock hub user list\n");
#endif
   G_UNLOCK(hub_user_list);
#if 0
	printf("remove user to ulist unlocked hub user list - finished\n");
#endif
	return ret;
}

/*******************************/
/* creating the users cnx data */
/*******************************/
XTRA_INFO *create_user_cnx_info(int type, const char *addr, const char *client, double version, const char *versionadd, const char *lock, const char *pk, int has_bzlist, int got_lock, int got_myinfo, const char *d_client,double  d_version, const char *d_versionadd, time_t lock_time, char *utype, int exceed_limit, unsigned long long amount)
{
	XTRA_INFO *xi;
	xi=malloc(sizeof(XTRA_INFO));
	if(xi!=NULL)
	{
		xi->type=0;
		xi->addr=g_string_new("");
		if(addr!=NULL)
			g_string_sprintf(xi->addr,addr);
		xi->client=g_string_new("");
		if(client!=NULL)
			g_string_sprintf(xi->client,client);
		xi->version=version;
		xi->versionadd=g_string_new("");
		if(versionadd!=NULL)
			g_string_sprintf(xi->versionadd,versionadd);
		xi->locka=g_string_new("");
		if(lock!=NULL)
			g_string_sprintf(xi->locka,lock);
		xi->lockb=g_string_new("");
		xi->lockc=g_string_new("");
		xi->pka=g_string_new("");
		if(pk!=NULL)
			g_string_sprintf(xi->pka,pk);
		xi->pkb=g_string_new("");
		xi->pkc=g_string_new("");
		xi->has_bzlist=has_bzlist;
		xi->got_lock=got_lock;
		xi->got_myinfo=got_myinfo;
		if(got_myinfo==1)
		{
			xi->exceed_limit=exceed_limit;
			xi->amount=amount;
		}
		else
			xi->exceed_limit=FALSE;
		if(got_lock==1)
			xi->need_scan=2;
		else
		xi->need_scan=3;
		xi->d_client=g_string_new("");
		if(d_client!=NULL)
			g_string_sprintf(xi->d_client,d_client);
		xi->d_version=d_version;
		xi->d_versionadd=g_string_new("");
		if(d_versionadd!=NULL)
			g_string_sprintf(xi->d_versionadd,d_versionadd);
		xi->lock_time=lock_time;
		xi->last_call=time(NULL);
		xi->warnmsg_send=FALSE;
		if(utype!=NULL)
			xi->utype=strdup(utype);
		else
			xi->utype=NULL;
	}
	return xi;
}

int update_user_cnx_info(int i, int type, const char *addr, const char *client, double version, const char *versionadd, const char *lock, const char *pk, int has_bzlist, int got_lock, int got_myinfo, const char *d_client,double  d_version, const char *d_versionadd, time_t lock_time, char *utype, XTRA_INFO *xi, int exceed_limit, unsigned long long amount)
{
	xi->type=type;
#if 0
	printf("updating addr\n");
#endif
	if(addr!=NULL)
	{
		if(xi->addr->str!=NULL)
		{
			if(strcmp(addr,xi->addr->str))
			{
				g_string_free(xi->addr,TRUE);
				xi->addr=g_string_new(addr);
			}
		}
		else
			xi->addr=g_string_assign(xi->addr,addr);
	}
#if 0
	printf("updating client\n");
#endif
	if(client!=NULL)
	{
		if(xi->client->str!=NULL)
		{
			if(strcmp(client,xi->client->str))
			{
				g_string_free(xi->client,TRUE);
				xi->client=g_string_new(client);
			}
		}
		else
			xi->client=g_string_assign(xi->client,client);
	}
	if(version!=0)
	{
		xi->version=version;
	}
	printf("updating versionadd\n");
	if(versionadd!=NULL)
	{
		if(xi->versionadd->str!=NULL)
		{
			if(strcmp(versionadd,xi->versionadd->str))
			{
				g_string_free(xi->versionadd,TRUE);
				xi->versionadd=g_string_new(versionadd);
			}
		}
		else
			xi->versionadd=g_string_assign(xi->versionadd,versionadd);
	}
	printf("updating lock\n");
	if((xi->got_lock==0) && (got_lock==1))
	{
		if(lock!=NULL)
		{
			if(xi->locka->str!=NULL)
			{
				if(strcmp(lock,xi->locka->str))
				{
					g_string_free(xi->locka,TRUE);
					xi->locka=g_string_new(lock);
				}
			}
			else
				xi->locka=g_string_assign(xi->locka,lock);
		}
		if(pk!=NULL)
		{
			if(xi->pka->str!=NULL)
			{
				if(strcmp(pk,xi->pka->str))
				{
					g_string_free(xi->pka,TRUE);
					xi->pka=g_string_new(pk);
				}
			}
			else
				xi->pka=g_string_assign(xi->pka,pk);
		}
		xi->got_lock=1;
	}
	else if((xi->got_lock==1) && (got_lock==1))
	{
		if(lock!=NULL)
		{
			if(xi->lockb->str!=NULL)
			{
				if(strcmp(lock,xi->lockb->str))
				{
					g_string_free(xi->lockb,TRUE);
					xi->lockb=g_string_new(lock);
				}
			}
			else
				xi->lockb=g_string_assign(xi->lockb,lock);
		}
		if(pk!=NULL)
		{
			if(xi->pkb->str!=NULL)
			{
				if(strcmp(pk,xi->pkb->str))
				{
					g_string_free(xi->pkb,TRUE);
					xi->pkb=g_string_new(pk);
				}
			}
			else
				xi->pkb=g_string_assign(xi->pkb,pk);
		}
		xi->got_lock++;
	}
	else if((xi->got_lock>1) && (got_lock==1))
	{
		if(lock!=NULL)
		{
			if(xi->lockc->str!=NULL)
			{
				if(strcmp(lock,xi->lockc->str))
				{
					g_string_free(xi->lockc,TRUE);
					xi->lockc=g_string_new(lock);
				}
			}
			else
				xi->lockc=g_string_assign(xi->lockc,lock);
		}
		if(pk!=NULL)
		{
			if(xi->pkc->str!=NULL)
			{
				if(strcmp(pk,xi->pkc->str))
				{
					g_string_free(xi->pkc,TRUE);
					xi->pkc=g_string_new(pk);
				}
			}
			else
				xi->pkc=g_string_assign(xi->pkc,pk);
		}
		xi->got_lock++;
	}
	if(has_bzlist==1)
	{
		xi->has_bzlist++;
	}
	if(got_myinfo==1)
	{
		xi->exceed_limit=exceed_limit;
		xi->got_myinfo++;
		xi->amount=amount;
	}
	printf("updating d_client\n");
	if(d_client!=NULL)
	{
		if(xi->d_client->str!=NULL)
		{
			if(strcmp(d_client,xi->d_client->str))
			{
				g_string_free(xi->d_client,TRUE);
				xi->d_client=g_string_new(d_client);
			}
		}
		else
			xi->d_client=g_string_assign(xi->d_client,d_client);
	}
	if(d_version!=0)
	{
		xi->d_version=d_version;
	}
	if(d_versionadd!=NULL)
	{
		if(xi->d_versionadd->str!=NULL)
		{
			if(strcmp(d_versionadd,xi->d_versionadd->str))
			{
				g_string_free(xi->d_versionadd,TRUE);
				xi->d_versionadd=g_string_new(d_versionadd);
			}
		}
		else
			xi->d_versionadd=g_string_assign(xi->d_versionadd,d_versionadd);
	}
	if(got_lock==1)
		xi->lock_time=lock_time;
	if(got_lock==1 && xi->need_scan>0)
		xi->need_scan--;
	if(utype!=NULL)
   {
		printf("updating usertype %s\n",utype);
      if(xi->utype==NULL)
			xi->utype=strdup(utype);
   }
	g_ptr_array_index(hub_user_xtra_info,i)=xi;

	return 0;
}
