/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * slist.c: Copyright (C) Dirk Rieger <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: slist.c,v 2.1 2003/08/24 05:45:41 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <errno.h>
#include <glib.h>

#include "slist.h"

typedef struct
{
	GString* seen_nick;
	int seen_event;
	time_t seen_time;
} SEEN_ENTRY;

/* typedef struct { */
/*   int tm_hour; */  /* hour (0 - 23) */
/*   int tm_isdst; */  /* daylight saving time enabled/disabled */
/*   int tm_mday; */  /* day of month (1 - 31) */
/*   int tm_min; */   /* minutes (0 - 59) */
/*   int tm_mon; */   /* month (0 - 11 : 0 = January) */
/*   int tm_sec; */   /* seconds (0 - 59) */
/*   int tm_wday; */  /* Day of week (0 - 6 : 0 = Sunday) */
/*   int tm_yday; */  /* Day of year (0 - 365) */
/*   int tm_year; */  /* Year less 1900 */
/* } */

/**********************/
/* arry of SEEN_ENTRY */
/**********************/
static GArray *seen_array=NULL;

G_LOCK_DEFINE_STATIC(seen_array);

void add_seen_entry(int event, const char *nickname)
{
	SEEN_ENTRY nw;
	G_LOCK(seen_array);

	if(seen_array!=NULL)
		find_seen_by_nickname_uniq(nickname);

	nw.seen_nick=g_string_new(nickname);
	nw.seen_event=event;
	time(&nw.seen_time);

#if 0
	printf("add seen is adding %i %s\n",event,nickname);
#endif

	if(seen_array==NULL)
		seen_array=g_array_new(FALSE,FALSE,sizeof(SEEN_ENTRY));

	seen_array=g_array_append_val(seen_array,nw);
	G_UNLOCK(seen_array);
#if 0
	printf("add seen added %i %s\n",event,nickname);
#endif
}

char *find_seen_by_nickname(const char *nickname)
{
	struct tm *stime;
	char tmp_date_buf[512];
	int i;
	int f=FALSE;
#if 0
	const char *wday[7]={"Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"};
#endif
	GString *reply;

	reply=g_string_new("");
	g_string_sprintfa(reply,"Hmmm - let times think...\r\n\r\n");
	G_LOCK(seen_array);
	for(i=0;i<seen_array->len;i++)
	{
		SEEN_ENTRY *nw;
		nw=&(g_array_index(seen_array,SEEN_ENTRY,i));
#if 0
		printf("seen: %s found: %s\n",nickname,nw->seen_nick->str);
#endif
		if(strcmp(nw->seen_nick->str,nickname) == 0)
		{
			stime=localtime(&nw->seen_time);

			g_string_sprintfa(reply,"%s ",nw->seen_nick->str);

			if(nw->seen_event == 1)
				strftime(tmp_date_buf,sizeof(tmp_date_buf)-1,"is in the hub since %A, %dth day of %B in %Y, %X",stime);
			else
				strftime(tmp_date_buf,sizeof(tmp_date_buf)-1,"has left the hub since an old %A, %dth day of %B in %Y, %X",stime);

			g_string_sprintfa(reply,"%s\r\n",tmp_date_buf);

#if 0
			printf("Found: %s %s\n",nw->seen_nick->str,asctime(stime));
#endif
			f = TRUE;
			break;
		}
	}
	if (!f)
	{
		int first_hit = TRUE;
		for(i=0;i<seen_array->len;i++)
		{
			SEEN_ENTRY *nw;
			nw=&(g_array_index(seen_array,SEEN_ENTRY,i));
			if(strstr(nw->seen_nick->str,nickname))
			{
				if (first_hit)
				{
					g_string_sprintfa(reply,"I did not see %s but perhaps you mean...\r\n\r\n",nickname);
					first_hit = FALSE;
					f = TRUE;
				}
				stime=localtime(&nw->seen_time);
				g_string_sprintfa(reply,"%s ",nw->seen_nick->str);
				if (nw->seen_event==1)
					strftime(tmp_date_buf,sizeof(tmp_date_buf)-1,"Online  since %A the %x, %X.",stime);
				else
					strftime(tmp_date_buf,sizeof(tmp_date_buf)-1,"Offline since %A the %x, %X.",stime);
				g_string_sprintfa(reply,"%s\r\n",tmp_date_buf);
#if 0
				printf("Found: %s %s\n",nw->seen_nick->str,asctime(stime));
#endif
			}
		}
	}
	if (!f)
		g_string_sprintfa(reply,"\r\n Sorry but I did not see %s...",nickname);

	G_UNLOCK(seen_array);

	return reply->str;
}

static inline void delete_seen_entry(int num)
{
	SEEN_ENTRY *sd;

	sd=&(g_array_index(seen_array,SEEN_ENTRY,num));
	if(sd->seen_nick)
		g_string_free(sd->seen_nick,TRUE);
	seen_array=g_array_remove_index_fast(seen_array,num);
}

void find_seen_by_nickname_uniq(const char *nickname)
{
	time_t t;
	struct tm *stime;
	int i;
	if(seen_array!=NULL)
	{
		for(i=0;i<seen_array->len;i++)
		{
			SEEN_ENTRY *nw;
			nw=&(g_array_index(seen_array,SEEN_ENTRY,i));
			if(!strcmp(nw->seen_nick->str,nickname))
			{
				t=nw->seen_time;
				stime=localtime(&t);
#if 0
				printf("Found: %s %s -> deleting entry\n",nw->seen_nick->str,asctime(stime));
#endif
				delete_seen_entry(i);
				break;
			}
		}
	}
}

int do_users()
{
	int i;
	G_LOCK(seen_array);
	i=seen_array->len;
	G_UNLOCK(seen_array);
	return i;
}

